goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__13296){
var vec__13297 = p__13296;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__13300 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__13303 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(4),null);
var vec__13306 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__13309 = segmap;
var map__13309__$1 = (((((!((map__13309 == null))))?(((((map__13309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13309):map__13309);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__13316 = arguments.length;
switch (G__13316) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13326 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14217 = cljs.core.next(segs__$1);
var G__14218 = nrelseg;
var G__14219 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14217;
relseg__$1 = G__14218;
result__$1 = G__14219;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13326,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13326,(1),null);
var G__14221 = (gline + (1));
var G__14222 = cljs.core.next(lines__$1);
var G__14223 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14224 = result__$1;
gline = G__14221;
lines__$1 = G__14222;
relseg = G__14223;
result = G__14224;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__13330 = segmap;
var map__13330__$1 = (((((!((map__13330 == null))))?(((((map__13330.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13330.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13330):map__13330);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13330__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13330__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13330__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13330__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13330__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__13329_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13329_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__13336 = arguments.length;
switch (G__13336) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13340 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14246 = cljs.core.next(segs__$1);
var G__14247 = nrelseg;
var G__14248 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14246;
relseg__$1 = G__14247;
result__$1 = G__14248;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13340,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13340,(1),null);
var G__14250 = (gline + (1));
var G__14252 = cljs.core.next(lines__$1);
var G__14253 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14254 = result__$1;
gline = G__14250;
lines__$1 = G__14252;
relseg = G__14253;
result = G__14254;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13343){
var vec__13344 = p__13343;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13344,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13344,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13344,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13344,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13344,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__13349){
var vec__13351 = p__13349;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13351,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13351,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13351,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13351,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13351,(4),null);
var seg = vec__13351;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13354){
var vec__13356 = p__13354;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__13371 = cljs.core.seq(infos);
var chunk__13372 = null;
var count__13373 = (0);
var i__13374 = (0);
while(true){
if((i__13374 < count__13373)){
var info = chunk__13372.cljs$core$IIndexed$_nth$arity$2(null,i__13374);
var segv_14267 = info__GT_segv(info,source_idx,line,col);
var gline_14268 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14269 = cljs.core.count(cljs.core.deref(lines));
if((gline_14268 > (lc_14269 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13371,chunk__13372,count__13373,i__13374,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14268 - (lc_14269 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14267], null));
});})(seq__13371,chunk__13372,count__13373,i__13374,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13371,chunk__13372,count__13373,i__13374,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14268], null),cljs.core.conj,segv_14267);
});})(seq__13371,chunk__13372,count__13373,i__13374,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14270 = seq__13371;
var G__14271 = chunk__13372;
var G__14272 = count__13373;
var G__14273 = (i__13374 + (1));
seq__13371 = G__14270;
chunk__13372 = G__14271;
count__13373 = G__14272;
i__13374 = G__14273;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__13371);
if(temp__5735__auto__){
var seq__13371__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__13371__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__13371__$1);
var G__14274 = cljs.core.chunk_rest(seq__13371__$1);
var G__14275 = c__4609__auto__;
var G__14276 = cljs.core.count(c__4609__auto__);
var G__14277 = (0);
seq__13371 = G__14274;
chunk__13372 = G__14275;
count__13373 = G__14276;
i__13374 = G__14277;
continue;
} else {
var info = cljs.core.first(seq__13371__$1);
var segv_14278 = info__GT_segv(info,source_idx,line,col);
var gline_14279 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14280 = cljs.core.count(cljs.core.deref(lines));
if((gline_14279 > (lc_14280 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13371,chunk__13372,count__13373,i__13374,segv_14278,gline_14279,lc_14280,info,seq__13371__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14279 - (lc_14280 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14278], null));
});})(seq__13371,chunk__13372,count__13373,i__13374,segv_14278,gline_14279,lc_14280,info,seq__13371__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13371,chunk__13372,count__13373,i__13374,segv_14278,gline_14279,lc_14280,info,seq__13371__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14279], null),cljs.core.conj,segv_14278);
});})(seq__13371,chunk__13372,count__13373,i__13374,segv_14278,gline_14279,lc_14280,info,seq__13371__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14281 = cljs.core.next(seq__13371__$1);
var G__14282 = null;
var G__14283 = (0);
var G__14284 = (0);
seq__13371 = G__14281;
chunk__13372 = G__14282;
count__13373 = G__14283;
i__13374 = G__14284;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__13379_14287 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__13380_14288 = null;
var count__13381_14289 = (0);
var i__13382_14290 = (0);
while(true){
if((i__13382_14290 < count__13381_14289)){
var vec__13568_14293 = chunk__13380_14288.cljs$core$IIndexed$_nth$arity$2(null,i__13382_14290);
var source_idx_14294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13568_14293,(0),null);
var vec__13571_14295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13568_14293,(1),null);
var __14296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13571_14295,(0),null);
var lines_14297__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13571_14295,(1),null);
var seq__13574_14298 = cljs.core.seq(lines_14297__$1);
var chunk__13575_14299 = null;
var count__13576_14300 = (0);
var i__13577_14301 = (0);
while(true){
if((i__13577_14301 < count__13576_14300)){
var vec__13622_14305 = chunk__13575_14299.cljs$core$IIndexed$_nth$arity$2(null,i__13577_14301);
var line_14306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13622_14305,(0),null);
var cols_14307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13622_14305,(1),null);
var seq__13625_14313 = cljs.core.seq(cols_14307);
var chunk__13626_14314 = null;
var count__13627_14315 = (0);
var i__13628_14316 = (0);
while(true){
if((i__13628_14316 < count__13627_14315)){
var vec__13639_14319 = chunk__13626_14314.cljs$core$IIndexed$_nth$arity$2(null,i__13628_14316);
var col_14320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13639_14319,(0),null);
var infos_14321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13639_14319,(1),null);
encode_cols(infos_14321,source_idx_14294,line_14306,col_14320);


var G__14322 = seq__13625_14313;
var G__14323 = chunk__13626_14314;
var G__14324 = count__13627_14315;
var G__14325 = (i__13628_14316 + (1));
seq__13625_14313 = G__14322;
chunk__13626_14314 = G__14323;
count__13627_14315 = G__14324;
i__13628_14316 = G__14325;
continue;
} else {
var temp__5735__auto___14328 = cljs.core.seq(seq__13625_14313);
if(temp__5735__auto___14328){
var seq__13625_14329__$1 = temp__5735__auto___14328;
if(cljs.core.chunked_seq_QMARK_(seq__13625_14329__$1)){
var c__4609__auto___14330 = cljs.core.chunk_first(seq__13625_14329__$1);
var G__14331 = cljs.core.chunk_rest(seq__13625_14329__$1);
var G__14332 = c__4609__auto___14330;
var G__14333 = cljs.core.count(c__4609__auto___14330);
var G__14334 = (0);
seq__13625_14313 = G__14331;
chunk__13626_14314 = G__14332;
count__13627_14315 = G__14333;
i__13628_14316 = G__14334;
continue;
} else {
var vec__13642_14335 = cljs.core.first(seq__13625_14329__$1);
var col_14336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13642_14335,(0),null);
var infos_14337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13642_14335,(1),null);
encode_cols(infos_14337,source_idx_14294,line_14306,col_14336);


var G__14338 = cljs.core.next(seq__13625_14329__$1);
var G__14339 = null;
var G__14340 = (0);
var G__14341 = (0);
seq__13625_14313 = G__14338;
chunk__13626_14314 = G__14339;
count__13627_14315 = G__14340;
i__13628_14316 = G__14341;
continue;
}
} else {
}
}
break;
}


var G__14342 = seq__13574_14298;
var G__14343 = chunk__13575_14299;
var G__14344 = count__13576_14300;
var G__14345 = (i__13577_14301 + (1));
seq__13574_14298 = G__14342;
chunk__13575_14299 = G__14343;
count__13576_14300 = G__14344;
i__13577_14301 = G__14345;
continue;
} else {
var temp__5735__auto___14346 = cljs.core.seq(seq__13574_14298);
if(temp__5735__auto___14346){
var seq__13574_14347__$1 = temp__5735__auto___14346;
if(cljs.core.chunked_seq_QMARK_(seq__13574_14347__$1)){
var c__4609__auto___14348 = cljs.core.chunk_first(seq__13574_14347__$1);
var G__14349 = cljs.core.chunk_rest(seq__13574_14347__$1);
var G__14350 = c__4609__auto___14348;
var G__14351 = cljs.core.count(c__4609__auto___14348);
var G__14352 = (0);
seq__13574_14298 = G__14349;
chunk__13575_14299 = G__14350;
count__13576_14300 = G__14351;
i__13577_14301 = G__14352;
continue;
} else {
var vec__13645_14353 = cljs.core.first(seq__13574_14347__$1);
var line_14354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13645_14353,(0),null);
var cols_14355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13645_14353,(1),null);
var seq__13648_14356 = cljs.core.seq(cols_14355);
var chunk__13649_14357 = null;
var count__13650_14358 = (0);
var i__13651_14359 = (0);
while(true){
if((i__13651_14359 < count__13650_14358)){
var vec__13658_14360 = chunk__13649_14357.cljs$core$IIndexed$_nth$arity$2(null,i__13651_14359);
var col_14361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658_14360,(0),null);
var infos_14362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658_14360,(1),null);
encode_cols(infos_14362,source_idx_14294,line_14354,col_14361);


var G__14363 = seq__13648_14356;
var G__14364 = chunk__13649_14357;
var G__14365 = count__13650_14358;
var G__14366 = (i__13651_14359 + (1));
seq__13648_14356 = G__14363;
chunk__13649_14357 = G__14364;
count__13650_14358 = G__14365;
i__13651_14359 = G__14366;
continue;
} else {
var temp__5735__auto___14367__$1 = cljs.core.seq(seq__13648_14356);
if(temp__5735__auto___14367__$1){
var seq__13648_14368__$1 = temp__5735__auto___14367__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13648_14368__$1)){
var c__4609__auto___14369 = cljs.core.chunk_first(seq__13648_14368__$1);
var G__14370 = cljs.core.chunk_rest(seq__13648_14368__$1);
var G__14371 = c__4609__auto___14369;
var G__14372 = cljs.core.count(c__4609__auto___14369);
var G__14373 = (0);
seq__13648_14356 = G__14370;
chunk__13649_14357 = G__14371;
count__13650_14358 = G__14372;
i__13651_14359 = G__14373;
continue;
} else {
var vec__13661_14374 = cljs.core.first(seq__13648_14368__$1);
var col_14375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13661_14374,(0),null);
var infos_14376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13661_14374,(1),null);
encode_cols(infos_14376,source_idx_14294,line_14354,col_14375);


var G__14377 = cljs.core.next(seq__13648_14368__$1);
var G__14378 = null;
var G__14379 = (0);
var G__14380 = (0);
seq__13648_14356 = G__14377;
chunk__13649_14357 = G__14378;
count__13650_14358 = G__14379;
i__13651_14359 = G__14380;
continue;
}
} else {
}
}
break;
}


var G__14381 = cljs.core.next(seq__13574_14347__$1);
var G__14382 = null;
var G__14383 = (0);
var G__14384 = (0);
seq__13574_14298 = G__14381;
chunk__13575_14299 = G__14382;
count__13576_14300 = G__14383;
i__13577_14301 = G__14384;
continue;
}
} else {
}
}
break;
}


var G__14385 = seq__13379_14287;
var G__14386 = chunk__13380_14288;
var G__14387 = count__13381_14289;
var G__14388 = (i__13382_14290 + (1));
seq__13379_14287 = G__14385;
chunk__13380_14288 = G__14386;
count__13381_14289 = G__14387;
i__13382_14290 = G__14388;
continue;
} else {
var temp__5735__auto___14391 = cljs.core.seq(seq__13379_14287);
if(temp__5735__auto___14391){
var seq__13379_14392__$1 = temp__5735__auto___14391;
if(cljs.core.chunked_seq_QMARK_(seq__13379_14392__$1)){
var c__4609__auto___14396 = cljs.core.chunk_first(seq__13379_14392__$1);
var G__14400 = cljs.core.chunk_rest(seq__13379_14392__$1);
var G__14401 = c__4609__auto___14396;
var G__14402 = cljs.core.count(c__4609__auto___14396);
var G__14403 = (0);
seq__13379_14287 = G__14400;
chunk__13380_14288 = G__14401;
count__13381_14289 = G__14402;
i__13382_14290 = G__14403;
continue;
} else {
var vec__13664_14404 = cljs.core.first(seq__13379_14392__$1);
var source_idx_14405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13664_14404,(0),null);
var vec__13667_14406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13664_14404,(1),null);
var __14407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13667_14406,(0),null);
var lines_14408__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13667_14406,(1),null);
var seq__13670_14409 = cljs.core.seq(lines_14408__$1);
var chunk__13671_14410 = null;
var count__13672_14411 = (0);
var i__13673_14412 = (0);
while(true){
if((i__13673_14412 < count__13672_14411)){
var vec__13718_14413 = chunk__13671_14410.cljs$core$IIndexed$_nth$arity$2(null,i__13673_14412);
var line_14414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13718_14413,(0),null);
var cols_14415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13718_14413,(1),null);
var seq__13722_14416 = cljs.core.seq(cols_14415);
var chunk__13723_14417 = null;
var count__13724_14418 = (0);
var i__13725_14419 = (0);
while(true){
if((i__13725_14419 < count__13724_14418)){
var vec__13732_14420 = chunk__13723_14417.cljs$core$IIndexed$_nth$arity$2(null,i__13725_14419);
var col_14421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13732_14420,(0),null);
var infos_14422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13732_14420,(1),null);
encode_cols(infos_14422,source_idx_14405,line_14414,col_14421);


var G__14423 = seq__13722_14416;
var G__14424 = chunk__13723_14417;
var G__14425 = count__13724_14418;
var G__14426 = (i__13725_14419 + (1));
seq__13722_14416 = G__14423;
chunk__13723_14417 = G__14424;
count__13724_14418 = G__14425;
i__13725_14419 = G__14426;
continue;
} else {
var temp__5735__auto___14429__$1 = cljs.core.seq(seq__13722_14416);
if(temp__5735__auto___14429__$1){
var seq__13722_14430__$1 = temp__5735__auto___14429__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13722_14430__$1)){
var c__4609__auto___14431 = cljs.core.chunk_first(seq__13722_14430__$1);
var G__14432 = cljs.core.chunk_rest(seq__13722_14430__$1);
var G__14433 = c__4609__auto___14431;
var G__14434 = cljs.core.count(c__4609__auto___14431);
var G__14435 = (0);
seq__13722_14416 = G__14432;
chunk__13723_14417 = G__14433;
count__13724_14418 = G__14434;
i__13725_14419 = G__14435;
continue;
} else {
var vec__13739_14436 = cljs.core.first(seq__13722_14430__$1);
var col_14437 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13739_14436,(0),null);
var infos_14438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13739_14436,(1),null);
encode_cols(infos_14438,source_idx_14405,line_14414,col_14437);


var G__14439 = cljs.core.next(seq__13722_14430__$1);
var G__14440 = null;
var G__14441 = (0);
var G__14442 = (0);
seq__13722_14416 = G__14439;
chunk__13723_14417 = G__14440;
count__13724_14418 = G__14441;
i__13725_14419 = G__14442;
continue;
}
} else {
}
}
break;
}


var G__14443 = seq__13670_14409;
var G__14444 = chunk__13671_14410;
var G__14445 = count__13672_14411;
var G__14446 = (i__13673_14412 + (1));
seq__13670_14409 = G__14443;
chunk__13671_14410 = G__14444;
count__13672_14411 = G__14445;
i__13673_14412 = G__14446;
continue;
} else {
var temp__5735__auto___14450__$1 = cljs.core.seq(seq__13670_14409);
if(temp__5735__auto___14450__$1){
var seq__13670_14451__$1 = temp__5735__auto___14450__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13670_14451__$1)){
var c__4609__auto___14452 = cljs.core.chunk_first(seq__13670_14451__$1);
var G__14453 = cljs.core.chunk_rest(seq__13670_14451__$1);
var G__14454 = c__4609__auto___14452;
var G__14455 = cljs.core.count(c__4609__auto___14452);
var G__14456 = (0);
seq__13670_14409 = G__14453;
chunk__13671_14410 = G__14454;
count__13672_14411 = G__14455;
i__13673_14412 = G__14456;
continue;
} else {
var vec__13742_14457 = cljs.core.first(seq__13670_14451__$1);
var line_14458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13742_14457,(0),null);
var cols_14459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13742_14457,(1),null);
var seq__13745_14460 = cljs.core.seq(cols_14459);
var chunk__13746_14461 = null;
var count__13747_14462 = (0);
var i__13748_14463 = (0);
while(true){
if((i__13748_14463 < count__13747_14462)){
var vec__13755_14465 = chunk__13746_14461.cljs$core$IIndexed$_nth$arity$2(null,i__13748_14463);
var col_14466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755_14465,(0),null);
var infos_14467 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755_14465,(1),null);
encode_cols(infos_14467,source_idx_14405,line_14458,col_14466);


var G__14468 = seq__13745_14460;
var G__14469 = chunk__13746_14461;
var G__14470 = count__13747_14462;
var G__14471 = (i__13748_14463 + (1));
seq__13745_14460 = G__14468;
chunk__13746_14461 = G__14469;
count__13747_14462 = G__14470;
i__13748_14463 = G__14471;
continue;
} else {
var temp__5735__auto___14472__$2 = cljs.core.seq(seq__13745_14460);
if(temp__5735__auto___14472__$2){
var seq__13745_14473__$1 = temp__5735__auto___14472__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13745_14473__$1)){
var c__4609__auto___14474 = cljs.core.chunk_first(seq__13745_14473__$1);
var G__14475 = cljs.core.chunk_rest(seq__13745_14473__$1);
var G__14476 = c__4609__auto___14474;
var G__14477 = cljs.core.count(c__4609__auto___14474);
var G__14478 = (0);
seq__13745_14460 = G__14475;
chunk__13746_14461 = G__14476;
count__13747_14462 = G__14477;
i__13748_14463 = G__14478;
continue;
} else {
var vec__13759_14480 = cljs.core.first(seq__13745_14473__$1);
var col_14481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13759_14480,(0),null);
var infos_14482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13759_14480,(1),null);
encode_cols(infos_14482,source_idx_14405,line_14458,col_14481);


var G__14483 = cljs.core.next(seq__13745_14473__$1);
var G__14484 = null;
var G__14485 = (0);
var G__14486 = (0);
seq__13745_14460 = G__14483;
chunk__13746_14461 = G__14484;
count__13747_14462 = G__14485;
i__13748_14463 = G__14486;
continue;
}
} else {
}
}
break;
}


var G__14491 = cljs.core.next(seq__13670_14451__$1);
var G__14492 = null;
var G__14493 = (0);
var G__14494 = (0);
seq__13670_14409 = G__14491;
chunk__13671_14410 = G__14492;
count__13672_14411 = G__14493;
i__13673_14412 = G__14494;
continue;
}
} else {
}
}
break;
}


var G__14495 = cljs.core.next(seq__13379_14392__$1);
var G__14496 = null;
var G__14497 = (0);
var G__14498 = (0);
seq__13379_14287 = G__14495;
chunk__13380_14288 = G__14496;
count__13381_14289 = G__14497;
i__13382_14290 = G__14498;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13762 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__13361_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13361_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__13363_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__13363_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13364_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__13364_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13763 = G__13762;
var G__13764_14505 = G__13763;
var G__13765_14506 = "sourcesContent";
var G__13766_14507 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13764_14505,G__13765_14506,G__13766_14507);

return G__13763;
} else {
return G__13762;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13767 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13767,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13767,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13770 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13770,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13770,(1),null);
var G__14510 = cljs.core.next(col_map_seq);
var G__14511 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13770,col,infos,vec__13767,line,col_map){
return (function (v,p__13773){
var map__13774 = p__13773;
var map__13774__$1 = (((((!((map__13774 == null))))?(((((map__13774.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13774.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13774):map__13774);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13774__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13774__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13770,col,infos,vec__13767,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14510;
new_cols = G__14511;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14516 = cljs.core.next(line_map_seq);
var G__14517 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14516;
new_lines = G__14517;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13776_14518 = cljs.core.seq(reverse_map);
var chunk__13777_14519 = null;
var count__13778_14520 = (0);
var i__13779_14521 = (0);
while(true){
if((i__13779_14521 < count__13778_14520)){
var vec__13952_14522 = chunk__13777_14519.cljs$core$IIndexed$_nth$arity$2(null,i__13779_14521);
var line_14523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13952_14522,(0),null);
var columns_14524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13952_14522,(1),null);
var seq__13955_14525 = cljs.core.seq(columns_14524);
var chunk__13956_14526 = null;
var count__13957_14527 = (0);
var i__13958_14528 = (0);
while(true){
if((i__13958_14528 < count__13957_14527)){
var vec__13994_14529 = chunk__13956_14526.cljs$core$IIndexed$_nth$arity$2(null,i__13958_14528);
var column_14530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13994_14529,(0),null);
var column_info_14531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13994_14529,(1),null);
var seq__13997_14538 = cljs.core.seq(column_info_14531);
var chunk__13998_14539 = null;
var count__13999_14540 = (0);
var i__14000_14541 = (0);
while(true){
if((i__14000_14541 < count__13999_14540)){
var map__14005_14542 = chunk__13998_14539.cljs$core$IIndexed$_nth$arity$2(null,i__14000_14541);
var map__14005_14543__$1 = (((((!((map__14005_14542 == null))))?(((((map__14005_14542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14005_14542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14005_14542):map__14005_14542);
var gline_14544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005_14543__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005_14543__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005_14543__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14544], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13997_14538,chunk__13998_14539,count__13999_14540,i__14000_14541,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14005_14542,map__14005_14543__$1,gline_14544,gcol_14545,name_14546,vec__13994_14529,column_14530,column_info_14531,vec__13952_14522,line_14523,columns_14524,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14545], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14523,new cljs.core.Keyword(null,"col","col",-1959363084),column_14530,new cljs.core.Keyword(null,"name","name",1843675177),name_14546], null));
});})(seq__13997_14538,chunk__13998_14539,count__13999_14540,i__14000_14541,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14005_14542,map__14005_14543__$1,gline_14544,gcol_14545,name_14546,vec__13994_14529,column_14530,column_info_14531,vec__13952_14522,line_14523,columns_14524,inverted))
,cljs.core.sorted_map()));


var G__14555 = seq__13997_14538;
var G__14556 = chunk__13998_14539;
var G__14557 = count__13999_14540;
var G__14558 = (i__14000_14541 + (1));
seq__13997_14538 = G__14555;
chunk__13998_14539 = G__14556;
count__13999_14540 = G__14557;
i__14000_14541 = G__14558;
continue;
} else {
var temp__5735__auto___14561 = cljs.core.seq(seq__13997_14538);
if(temp__5735__auto___14561){
var seq__13997_14562__$1 = temp__5735__auto___14561;
if(cljs.core.chunked_seq_QMARK_(seq__13997_14562__$1)){
var c__4609__auto___14563 = cljs.core.chunk_first(seq__13997_14562__$1);
var G__14565 = cljs.core.chunk_rest(seq__13997_14562__$1);
var G__14566 = c__4609__auto___14563;
var G__14567 = cljs.core.count(c__4609__auto___14563);
var G__14568 = (0);
seq__13997_14538 = G__14565;
chunk__13998_14539 = G__14566;
count__13999_14540 = G__14567;
i__14000_14541 = G__14568;
continue;
} else {
var map__14007_14569 = cljs.core.first(seq__13997_14562__$1);
var map__14007_14570__$1 = (((((!((map__14007_14569 == null))))?(((((map__14007_14569.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14007_14569.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14007_14569):map__14007_14569);
var gline_14571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14007_14570__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14007_14570__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14007_14570__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14571], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13997_14538,chunk__13998_14539,count__13999_14540,i__14000_14541,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14007_14569,map__14007_14570__$1,gline_14571,gcol_14572,name_14573,seq__13997_14562__$1,temp__5735__auto___14561,vec__13994_14529,column_14530,column_info_14531,vec__13952_14522,line_14523,columns_14524,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14572], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14523,new cljs.core.Keyword(null,"col","col",-1959363084),column_14530,new cljs.core.Keyword(null,"name","name",1843675177),name_14573], null));
});})(seq__13997_14538,chunk__13998_14539,count__13999_14540,i__14000_14541,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14007_14569,map__14007_14570__$1,gline_14571,gcol_14572,name_14573,seq__13997_14562__$1,temp__5735__auto___14561,vec__13994_14529,column_14530,column_info_14531,vec__13952_14522,line_14523,columns_14524,inverted))
,cljs.core.sorted_map()));


var G__14574 = cljs.core.next(seq__13997_14562__$1);
var G__14575 = null;
var G__14576 = (0);
var G__14577 = (0);
seq__13997_14538 = G__14574;
chunk__13998_14539 = G__14575;
count__13999_14540 = G__14576;
i__14000_14541 = G__14577;
continue;
}
} else {
}
}
break;
}


var G__14578 = seq__13955_14525;
var G__14579 = chunk__13956_14526;
var G__14580 = count__13957_14527;
var G__14581 = (i__13958_14528 + (1));
seq__13955_14525 = G__14578;
chunk__13956_14526 = G__14579;
count__13957_14527 = G__14580;
i__13958_14528 = G__14581;
continue;
} else {
var temp__5735__auto___14582 = cljs.core.seq(seq__13955_14525);
if(temp__5735__auto___14582){
var seq__13955_14583__$1 = temp__5735__auto___14582;
if(cljs.core.chunked_seq_QMARK_(seq__13955_14583__$1)){
var c__4609__auto___14584 = cljs.core.chunk_first(seq__13955_14583__$1);
var G__14585 = cljs.core.chunk_rest(seq__13955_14583__$1);
var G__14586 = c__4609__auto___14584;
var G__14587 = cljs.core.count(c__4609__auto___14584);
var G__14588 = (0);
seq__13955_14525 = G__14585;
chunk__13956_14526 = G__14586;
count__13957_14527 = G__14587;
i__13958_14528 = G__14588;
continue;
} else {
var vec__14009_14589 = cljs.core.first(seq__13955_14583__$1);
var column_14590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14009_14589,(0),null);
var column_info_14591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14009_14589,(1),null);
var seq__14012_14592 = cljs.core.seq(column_info_14591);
var chunk__14013_14593 = null;
var count__14014_14594 = (0);
var i__14015_14595 = (0);
while(true){
if((i__14015_14595 < count__14014_14594)){
var map__14020_14596 = chunk__14013_14593.cljs$core$IIndexed$_nth$arity$2(null,i__14015_14595);
var map__14020_14597__$1 = (((((!((map__14020_14596 == null))))?(((((map__14020_14596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14020_14596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14020_14596):map__14020_14596);
var gline_14598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14020_14597__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14020_14597__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14020_14597__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14598], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14012_14592,chunk__14013_14593,count__14014_14594,i__14015_14595,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14020_14596,map__14020_14597__$1,gline_14598,gcol_14599,name_14600,vec__14009_14589,column_14590,column_info_14591,seq__13955_14583__$1,temp__5735__auto___14582,vec__13952_14522,line_14523,columns_14524,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14599], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14523,new cljs.core.Keyword(null,"col","col",-1959363084),column_14590,new cljs.core.Keyword(null,"name","name",1843675177),name_14600], null));
});})(seq__14012_14592,chunk__14013_14593,count__14014_14594,i__14015_14595,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14020_14596,map__14020_14597__$1,gline_14598,gcol_14599,name_14600,vec__14009_14589,column_14590,column_info_14591,seq__13955_14583__$1,temp__5735__auto___14582,vec__13952_14522,line_14523,columns_14524,inverted))
,cljs.core.sorted_map()));


var G__14601 = seq__14012_14592;
var G__14602 = chunk__14013_14593;
var G__14603 = count__14014_14594;
var G__14604 = (i__14015_14595 + (1));
seq__14012_14592 = G__14601;
chunk__14013_14593 = G__14602;
count__14014_14594 = G__14603;
i__14015_14595 = G__14604;
continue;
} else {
var temp__5735__auto___14605__$1 = cljs.core.seq(seq__14012_14592);
if(temp__5735__auto___14605__$1){
var seq__14012_14606__$1 = temp__5735__auto___14605__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14012_14606__$1)){
var c__4609__auto___14607 = cljs.core.chunk_first(seq__14012_14606__$1);
var G__14608 = cljs.core.chunk_rest(seq__14012_14606__$1);
var G__14609 = c__4609__auto___14607;
var G__14610 = cljs.core.count(c__4609__auto___14607);
var G__14611 = (0);
seq__14012_14592 = G__14608;
chunk__14013_14593 = G__14609;
count__14014_14594 = G__14610;
i__14015_14595 = G__14611;
continue;
} else {
var map__14023_14612 = cljs.core.first(seq__14012_14606__$1);
var map__14023_14613__$1 = (((((!((map__14023_14612 == null))))?(((((map__14023_14612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14023_14612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14023_14612):map__14023_14612);
var gline_14614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14023_14613__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14615 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14023_14613__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14616 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14023_14613__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14614], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14012_14592,chunk__14013_14593,count__14014_14594,i__14015_14595,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14023_14612,map__14023_14613__$1,gline_14614,gcol_14615,name_14616,seq__14012_14606__$1,temp__5735__auto___14605__$1,vec__14009_14589,column_14590,column_info_14591,seq__13955_14583__$1,temp__5735__auto___14582,vec__13952_14522,line_14523,columns_14524,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14615], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14523,new cljs.core.Keyword(null,"col","col",-1959363084),column_14590,new cljs.core.Keyword(null,"name","name",1843675177),name_14616], null));
});})(seq__14012_14592,chunk__14013_14593,count__14014_14594,i__14015_14595,seq__13955_14525,chunk__13956_14526,count__13957_14527,i__13958_14528,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14023_14612,map__14023_14613__$1,gline_14614,gcol_14615,name_14616,seq__14012_14606__$1,temp__5735__auto___14605__$1,vec__14009_14589,column_14590,column_info_14591,seq__13955_14583__$1,temp__5735__auto___14582,vec__13952_14522,line_14523,columns_14524,inverted))
,cljs.core.sorted_map()));


var G__14617 = cljs.core.next(seq__14012_14606__$1);
var G__14618 = null;
var G__14619 = (0);
var G__14620 = (0);
seq__14012_14592 = G__14617;
chunk__14013_14593 = G__14618;
count__14014_14594 = G__14619;
i__14015_14595 = G__14620;
continue;
}
} else {
}
}
break;
}


var G__14621 = cljs.core.next(seq__13955_14583__$1);
var G__14622 = null;
var G__14623 = (0);
var G__14624 = (0);
seq__13955_14525 = G__14621;
chunk__13956_14526 = G__14622;
count__13957_14527 = G__14623;
i__13958_14528 = G__14624;
continue;
}
} else {
}
}
break;
}


var G__14625 = seq__13776_14518;
var G__14626 = chunk__13777_14519;
var G__14627 = count__13778_14520;
var G__14628 = (i__13779_14521 + (1));
seq__13776_14518 = G__14625;
chunk__13777_14519 = G__14626;
count__13778_14520 = G__14627;
i__13779_14521 = G__14628;
continue;
} else {
var temp__5735__auto___14629 = cljs.core.seq(seq__13776_14518);
if(temp__5735__auto___14629){
var seq__13776_14630__$1 = temp__5735__auto___14629;
if(cljs.core.chunked_seq_QMARK_(seq__13776_14630__$1)){
var c__4609__auto___14631 = cljs.core.chunk_first(seq__13776_14630__$1);
var G__14632 = cljs.core.chunk_rest(seq__13776_14630__$1);
var G__14633 = c__4609__auto___14631;
var G__14634 = cljs.core.count(c__4609__auto___14631);
var G__14635 = (0);
seq__13776_14518 = G__14632;
chunk__13777_14519 = G__14633;
count__13778_14520 = G__14634;
i__13779_14521 = G__14635;
continue;
} else {
var vec__14025_14636 = cljs.core.first(seq__13776_14630__$1);
var line_14637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14025_14636,(0),null);
var columns_14638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14025_14636,(1),null);
var seq__14028_14639 = cljs.core.seq(columns_14638);
var chunk__14029_14640 = null;
var count__14030_14641 = (0);
var i__14031_14642 = (0);
while(true){
if((i__14031_14642 < count__14030_14641)){
var vec__14074_14643 = chunk__14029_14640.cljs$core$IIndexed$_nth$arity$2(null,i__14031_14642);
var column_14644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14074_14643,(0),null);
var column_info_14645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14074_14643,(1),null);
var seq__14077_14646 = cljs.core.seq(column_info_14645);
var chunk__14078_14647 = null;
var count__14079_14648 = (0);
var i__14080_14649 = (0);
while(true){
if((i__14080_14649 < count__14079_14648)){
var map__14099_14650 = chunk__14078_14647.cljs$core$IIndexed$_nth$arity$2(null,i__14080_14649);
var map__14099_14651__$1 = (((((!((map__14099_14650 == null))))?(((((map__14099_14650.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14099_14650.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14099_14650):map__14099_14650);
var gline_14652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14099_14651__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14099_14651__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14099_14651__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14652], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14077_14646,chunk__14078_14647,count__14079_14648,i__14080_14649,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14099_14650,map__14099_14651__$1,gline_14652,gcol_14653,name_14654,vec__14074_14643,column_14644,column_info_14645,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14653], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14637,new cljs.core.Keyword(null,"col","col",-1959363084),column_14644,new cljs.core.Keyword(null,"name","name",1843675177),name_14654], null));
});})(seq__14077_14646,chunk__14078_14647,count__14079_14648,i__14080_14649,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14099_14650,map__14099_14651__$1,gline_14652,gcol_14653,name_14654,vec__14074_14643,column_14644,column_info_14645,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted))
,cljs.core.sorted_map()));


var G__14655 = seq__14077_14646;
var G__14656 = chunk__14078_14647;
var G__14657 = count__14079_14648;
var G__14658 = (i__14080_14649 + (1));
seq__14077_14646 = G__14655;
chunk__14078_14647 = G__14656;
count__14079_14648 = G__14657;
i__14080_14649 = G__14658;
continue;
} else {
var temp__5735__auto___14659__$1 = cljs.core.seq(seq__14077_14646);
if(temp__5735__auto___14659__$1){
var seq__14077_14660__$1 = temp__5735__auto___14659__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14077_14660__$1)){
var c__4609__auto___14661 = cljs.core.chunk_first(seq__14077_14660__$1);
var G__14662 = cljs.core.chunk_rest(seq__14077_14660__$1);
var G__14663 = c__4609__auto___14661;
var G__14664 = cljs.core.count(c__4609__auto___14661);
var G__14665 = (0);
seq__14077_14646 = G__14662;
chunk__14078_14647 = G__14663;
count__14079_14648 = G__14664;
i__14080_14649 = G__14665;
continue;
} else {
var map__14108_14666 = cljs.core.first(seq__14077_14660__$1);
var map__14108_14667__$1 = (((((!((map__14108_14666 == null))))?(((((map__14108_14666.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14108_14666.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14108_14666):map__14108_14666);
var gline_14668 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14108_14667__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14108_14667__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14108_14667__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14668], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14077_14646,chunk__14078_14647,count__14079_14648,i__14080_14649,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14108_14666,map__14108_14667__$1,gline_14668,gcol_14669,name_14670,seq__14077_14660__$1,temp__5735__auto___14659__$1,vec__14074_14643,column_14644,column_info_14645,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14669], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14637,new cljs.core.Keyword(null,"col","col",-1959363084),column_14644,new cljs.core.Keyword(null,"name","name",1843675177),name_14670], null));
});})(seq__14077_14646,chunk__14078_14647,count__14079_14648,i__14080_14649,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14108_14666,map__14108_14667__$1,gline_14668,gcol_14669,name_14670,seq__14077_14660__$1,temp__5735__auto___14659__$1,vec__14074_14643,column_14644,column_info_14645,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted))
,cljs.core.sorted_map()));


var G__14678 = cljs.core.next(seq__14077_14660__$1);
var G__14679 = null;
var G__14680 = (0);
var G__14681 = (0);
seq__14077_14646 = G__14678;
chunk__14078_14647 = G__14679;
count__14079_14648 = G__14680;
i__14080_14649 = G__14681;
continue;
}
} else {
}
}
break;
}


var G__14682 = seq__14028_14639;
var G__14683 = chunk__14029_14640;
var G__14684 = count__14030_14641;
var G__14685 = (i__14031_14642 + (1));
seq__14028_14639 = G__14682;
chunk__14029_14640 = G__14683;
count__14030_14641 = G__14684;
i__14031_14642 = G__14685;
continue;
} else {
var temp__5735__auto___14688__$1 = cljs.core.seq(seq__14028_14639);
if(temp__5735__auto___14688__$1){
var seq__14028_14689__$1 = temp__5735__auto___14688__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14028_14689__$1)){
var c__4609__auto___14690 = cljs.core.chunk_first(seq__14028_14689__$1);
var G__14691 = cljs.core.chunk_rest(seq__14028_14689__$1);
var G__14693 = c__4609__auto___14690;
var G__14694 = cljs.core.count(c__4609__auto___14690);
var G__14695 = (0);
seq__14028_14639 = G__14691;
chunk__14029_14640 = G__14693;
count__14030_14641 = G__14694;
i__14031_14642 = G__14695;
continue;
} else {
var vec__14119_14697 = cljs.core.first(seq__14028_14689__$1);
var column_14698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14119_14697,(0),null);
var column_info_14699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14119_14697,(1),null);
var seq__14122_14700 = cljs.core.seq(column_info_14699);
var chunk__14123_14701 = null;
var count__14124_14702 = (0);
var i__14125_14703 = (0);
while(true){
if((i__14125_14703 < count__14124_14702)){
var map__14143_14705 = chunk__14123_14701.cljs$core$IIndexed$_nth$arity$2(null,i__14125_14703);
var map__14143_14706__$1 = (((((!((map__14143_14705 == null))))?(((((map__14143_14705.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14143_14705.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14143_14705):map__14143_14705);
var gline_14707 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14143_14706__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14143_14706__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14143_14706__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14707], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14122_14700,chunk__14123_14701,count__14124_14702,i__14125_14703,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14143_14705,map__14143_14706__$1,gline_14707,gcol_14708,name_14709,vec__14119_14697,column_14698,column_info_14699,seq__14028_14689__$1,temp__5735__auto___14688__$1,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14708], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14637,new cljs.core.Keyword(null,"col","col",-1959363084),column_14698,new cljs.core.Keyword(null,"name","name",1843675177),name_14709], null));
});})(seq__14122_14700,chunk__14123_14701,count__14124_14702,i__14125_14703,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14143_14705,map__14143_14706__$1,gline_14707,gcol_14708,name_14709,vec__14119_14697,column_14698,column_info_14699,seq__14028_14689__$1,temp__5735__auto___14688__$1,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted))
,cljs.core.sorted_map()));


var G__14714 = seq__14122_14700;
var G__14715 = chunk__14123_14701;
var G__14716 = count__14124_14702;
var G__14717 = (i__14125_14703 + (1));
seq__14122_14700 = G__14714;
chunk__14123_14701 = G__14715;
count__14124_14702 = G__14716;
i__14125_14703 = G__14717;
continue;
} else {
var temp__5735__auto___14718__$2 = cljs.core.seq(seq__14122_14700);
if(temp__5735__auto___14718__$2){
var seq__14122_14719__$1 = temp__5735__auto___14718__$2;
if(cljs.core.chunked_seq_QMARK_(seq__14122_14719__$1)){
var c__4609__auto___14721 = cljs.core.chunk_first(seq__14122_14719__$1);
var G__14722 = cljs.core.chunk_rest(seq__14122_14719__$1);
var G__14723 = c__4609__auto___14721;
var G__14724 = cljs.core.count(c__4609__auto___14721);
var G__14725 = (0);
seq__14122_14700 = G__14722;
chunk__14123_14701 = G__14723;
count__14124_14702 = G__14724;
i__14125_14703 = G__14725;
continue;
} else {
var map__14150_14729 = cljs.core.first(seq__14122_14719__$1);
var map__14150_14730__$1 = (((((!((map__14150_14729 == null))))?(((((map__14150_14729.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14150_14729.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14150_14729):map__14150_14729);
var gline_14731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14150_14730__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14150_14730__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14150_14730__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14731], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14122_14700,chunk__14123_14701,count__14124_14702,i__14125_14703,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14150_14729,map__14150_14730__$1,gline_14731,gcol_14732,name_14733,seq__14122_14719__$1,temp__5735__auto___14718__$2,vec__14119_14697,column_14698,column_info_14699,seq__14028_14689__$1,temp__5735__auto___14688__$1,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14732], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14637,new cljs.core.Keyword(null,"col","col",-1959363084),column_14698,new cljs.core.Keyword(null,"name","name",1843675177),name_14733], null));
});})(seq__14122_14700,chunk__14123_14701,count__14124_14702,i__14125_14703,seq__14028_14639,chunk__14029_14640,count__14030_14641,i__14031_14642,seq__13776_14518,chunk__13777_14519,count__13778_14520,i__13779_14521,map__14150_14729,map__14150_14730__$1,gline_14731,gcol_14732,name_14733,seq__14122_14719__$1,temp__5735__auto___14718__$2,vec__14119_14697,column_14698,column_info_14699,seq__14028_14689__$1,temp__5735__auto___14688__$1,vec__14025_14636,line_14637,columns_14638,seq__13776_14630__$1,temp__5735__auto___14629,inverted))
,cljs.core.sorted_map()));


var G__14738 = cljs.core.next(seq__14122_14719__$1);
var G__14739 = null;
var G__14740 = (0);
var G__14741 = (0);
seq__14122_14700 = G__14738;
chunk__14123_14701 = G__14739;
count__14124_14702 = G__14740;
i__14125_14703 = G__14741;
continue;
}
} else {
}
}
break;
}


var G__14742 = cljs.core.next(seq__14028_14689__$1);
var G__14743 = null;
var G__14744 = (0);
var G__14745 = (0);
seq__14028_14639 = G__14742;
chunk__14029_14640 = G__14743;
count__14030_14641 = G__14744;
i__14031_14642 = G__14745;
continue;
}
} else {
}
}
break;
}


var G__14746 = cljs.core.next(seq__13776_14630__$1);
var G__14747 = null;
var G__14748 = (0);
var G__14749 = (0);
seq__13776_14518 = G__14746;
chunk__13777_14519 = G__14747;
count__13778_14520 = G__14748;
i__13779_14521 = G__14749;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
