goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__15813 = s;
var map__15813__$1 = (((((!((map__15813 == null))))?(((((map__15813.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15813.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15813):map__15813);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15813__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15813__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__15820 = info;
var map__15821 = G__15820;
var map__15821__$1 = (((((!((map__15821 == null))))?(((((map__15821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15821):map__15821);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15821__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__15820__$1 = G__15820;
while(true){
var d__$2 = d__$1;
var map__15828 = G__15820__$1;
var map__15828__$1 = (((((!((map__15828 == null))))?(((((map__15828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15828.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15828):map__15828);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15828__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__16697 = (d__$2 + (1));
var G__16698 = shadow__$2;
d__$1 = G__16697;
G__15820__$1 = G__16698;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__15835){
var map__15836 = p__15835;
var map__15836__$1 = (((((!((map__15836 == null))))?(((((map__15836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15836):map__15836);
var name_var = map__15836__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15836__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15836__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__15838 = info;
var map__15838__$1 = (((((!((map__15838 == null))))?(((((map__15838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15838):map__15838);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15838__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15838__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__15843 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__15843) : cljs.compiler.munge.call(null,G__15843));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__15845 = arguments.length;
switch (G__15845) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__15853 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__15853.cljs$core$IFn$_invoke$arity$1 ? fexpr__15853.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__15853.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__15861 = cp;
switch (G__15861) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__15866_16712 = cljs.core.seq(s);
var chunk__15867_16713 = null;
var count__15868_16714 = (0);
var i__15869_16715 = (0);
while(true){
if((i__15869_16715 < count__15868_16714)){
var c_16716 = chunk__15867_16713.cljs$core$IIndexed$_nth$arity$2(null,i__15869_16715);
sb.append(cljs.compiler.escape_char(c_16716));


var G__16717 = seq__15866_16712;
var G__16718 = chunk__15867_16713;
var G__16719 = count__15868_16714;
var G__16720 = (i__15869_16715 + (1));
seq__15866_16712 = G__16717;
chunk__15867_16713 = G__16718;
count__15868_16714 = G__16719;
i__15869_16715 = G__16720;
continue;
} else {
var temp__5735__auto___16721 = cljs.core.seq(seq__15866_16712);
if(temp__5735__auto___16721){
var seq__15866_16722__$1 = temp__5735__auto___16721;
if(cljs.core.chunked_seq_QMARK_(seq__15866_16722__$1)){
var c__4609__auto___16723 = cljs.core.chunk_first(seq__15866_16722__$1);
var G__16724 = cljs.core.chunk_rest(seq__15866_16722__$1);
var G__16725 = c__4609__auto___16723;
var G__16726 = cljs.core.count(c__4609__auto___16723);
var G__16727 = (0);
seq__15866_16712 = G__16724;
chunk__15867_16713 = G__16725;
count__15868_16714 = G__16726;
i__15869_16715 = G__16727;
continue;
} else {
var c_16728 = cljs.core.first(seq__15866_16722__$1);
sb.append(cljs.compiler.escape_char(c_16728));


var G__16729 = cljs.core.next(seq__15866_16722__$1);
var G__16730 = null;
var G__16731 = (0);
var G__16732 = (0);
seq__15866_16712 = G__16729;
chunk__15867_16713 = G__16730;
count__15868_16714 = G__16731;
i__15869_16715 = G__16732;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15874 = cljs.core.get_global_hierarchy;
return (fexpr__15874.cljs$core$IFn$_invoke$arity$0 ? fexpr__15874.cljs$core$IFn$_invoke$arity$0() : fexpr__15874.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__15878_16740 = ast;
var map__15878_16741__$1 = (((((!((map__15878_16740 == null))))?(((((map__15878_16740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15878_16740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15878_16740):map__15878_16740);
var env_16742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878_16741__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_16742))){
var map__15880_16743 = env_16742;
var map__15880_16744__$1 = (((((!((map__15880_16743 == null))))?(((((map__15880_16743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15880_16743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15880_16743):map__15880_16743);
var line_16745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15880_16744__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_16746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15880_16744__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__15882 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__15884 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__15883 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15883.cljs$core$IFn$_invoke$arity$1 ? fexpr__15883.cljs$core$IFn$_invoke$arity$1(G__15884) : fexpr__15883.call(null,G__15884));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15882,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__15882;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_16745 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_16746)?(column_16746 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__15902 = arguments.length;
switch (G__15902) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16751 = arguments.length;
var i__4790__auto___16752 = (0);
while(true){
if((i__4790__auto___16752 < len__4789__auto___16751)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16752]));

var G__16753 = (i__4790__auto___16752 + (1));
i__4790__auto___16752 = G__16753;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_16754 = (function (){var G__15910 = a;
if((!(typeof a === 'string'))){
return G__15910.toString();
} else {
return G__15910;
}
})();
var temp__5739__auto___16755 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___16755 == null)){
} else {
var sm_data_16756 = temp__5739__auto___16755;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_16756,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__15893_SHARP_){
return (p1__15893_SHARP_ + s_16754.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_16754], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15911 = cljs.core.seq(xs);
var chunk__15912 = null;
var count__15913 = (0);
var i__15914 = (0);
while(true){
if((i__15914 < count__15913)){
var x = chunk__15912.cljs$core$IIndexed$_nth$arity$2(null,i__15914);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16760 = seq__15911;
var G__16761 = chunk__15912;
var G__16762 = count__15913;
var G__16763 = (i__15914 + (1));
seq__15911 = G__16760;
chunk__15912 = G__16761;
count__15913 = G__16762;
i__15914 = G__16763;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15911);
if(temp__5735__auto__){
var seq__15911__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15911__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15911__$1);
var G__16764 = cljs.core.chunk_rest(seq__15911__$1);
var G__16765 = c__4609__auto__;
var G__16766 = cljs.core.count(c__4609__auto__);
var G__16767 = (0);
seq__15911 = G__16764;
chunk__15912 = G__16765;
count__15913 = G__16766;
i__15914 = G__16767;
continue;
} else {
var x = cljs.core.first(seq__15911__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16768 = cljs.core.next(seq__15911__$1);
var G__16769 = null;
var G__16770 = (0);
var G__16771 = (0);
seq__15911 = G__16768;
chunk__15912 = G__16769;
count__15913 = G__16770;
i__15914 = G__16771;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq15896){
var G__15897 = cljs.core.first(seq15896);
var seq15896__$1 = cljs.core.next(seq15896);
var G__15898 = cljs.core.first(seq15896__$1);
var seq15896__$2 = cljs.core.next(seq15896__$1);
var G__15899 = cljs.core.first(seq15896__$2);
var seq15896__$3 = cljs.core.next(seq15896__$2);
var G__15900 = cljs.core.first(seq15896__$3);
var seq15896__$4 = cljs.core.next(seq15896__$3);
var G__15901 = cljs.core.first(seq15896__$4);
var seq15896__$5 = cljs.core.next(seq15896__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15897,G__15898,G__15899,G__15900,G__15901,seq15896__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__15921){
var map__15922 = p__15921;
var map__15922__$1 = (((((!((map__15922 == null))))?(((((map__15922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15922):map__15922);
var m = map__15922__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15922__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__15935 = arguments.length;
switch (G__15935) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16777 = arguments.length;
var i__4790__auto___16778 = (0);
while(true){
if((i__4790__auto___16778 < len__4789__auto___16777)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16778]));

var G__16779 = (i__4790__auto___16778 + (1));
i__4790__auto___16778 = G__16779;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15943_16789 = cljs.core.seq(xs);
var chunk__15944_16790 = null;
var count__15946_16791 = (0);
var i__15947_16792 = (0);
while(true){
if((i__15947_16792 < count__15946_16791)){
var x_16793 = chunk__15944_16790.cljs$core$IIndexed$_nth$arity$2(null,i__15947_16792);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16793);


var G__16794 = seq__15943_16789;
var G__16795 = chunk__15944_16790;
var G__16796 = count__15946_16791;
var G__16797 = (i__15947_16792 + (1));
seq__15943_16789 = G__16794;
chunk__15944_16790 = G__16795;
count__15946_16791 = G__16796;
i__15947_16792 = G__16797;
continue;
} else {
var temp__5735__auto___16798 = cljs.core.seq(seq__15943_16789);
if(temp__5735__auto___16798){
var seq__15943_16799__$1 = temp__5735__auto___16798;
if(cljs.core.chunked_seq_QMARK_(seq__15943_16799__$1)){
var c__4609__auto___16800 = cljs.core.chunk_first(seq__15943_16799__$1);
var G__16801 = cljs.core.chunk_rest(seq__15943_16799__$1);
var G__16802 = c__4609__auto___16800;
var G__16803 = cljs.core.count(c__4609__auto___16800);
var G__16804 = (0);
seq__15943_16789 = G__16801;
chunk__15944_16790 = G__16802;
count__15946_16791 = G__16803;
i__15947_16792 = G__16804;
continue;
} else {
var x_16805 = cljs.core.first(seq__15943_16799__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16805);


var G__16806 = cljs.core.next(seq__15943_16799__$1);
var G__16807 = null;
var G__16808 = (0);
var G__16809 = (0);
seq__15943_16789 = G__16806;
chunk__15944_16790 = G__16807;
count__15946_16791 = G__16808;
i__15947_16792 = G__16809;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq15929){
var G__15930 = cljs.core.first(seq15929);
var seq15929__$1 = cljs.core.next(seq15929);
var G__15931 = cljs.core.first(seq15929__$1);
var seq15929__$2 = cljs.core.next(seq15929__$1);
var G__15932 = cljs.core.first(seq15929__$2);
var seq15929__$3 = cljs.core.next(seq15929__$2);
var G__15933 = cljs.core.first(seq15929__$3);
var seq15929__$4 = cljs.core.next(seq15929__$3);
var G__15934 = cljs.core.first(seq15929__$4);
var seq15929__$5 = cljs.core.next(seq15929__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15930,G__15931,G__15932,G__15933,G__15934,seq15929__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__15961_16810 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__15962_16811 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__15963_16812 = true;
var _STAR_print_fn_STAR__temp_val__15964_16813 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__15963_16812);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__15964_16813);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__15962_16811);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__15961_16810);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15965 = cljs.core.get_global_hierarchy;
return (fexpr__15965.cljs$core$IFn$_invoke$arity$0 ? fexpr__15965.cljs$core$IFn$_invoke$arity$0() : fexpr__15965.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__15972 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15972,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15972,(1),null);
var G__15975 = ns;
var G__15976 = name;
var G__15977 = (function (){
var G__15978 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__15978) : cljs.compiler.emit_constant.call(null,G__15978));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__15975,G__15976,G__15977) : cljs.compiler.emit_record_value.call(null,G__15975,G__15976,G__15977));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__15979 = cljs.core.keys(x);
var G__15980 = cljs.core.vals(x);
var G__15981 = cljs.compiler.emit_constants_comma_sep;
var G__15982 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__15979,G__15980,G__15981,G__15982) : cljs.compiler.emit_map.call(null,G__15979,G__15980,G__15981,G__15982));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__15984 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__15985 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__15984,G__15985) : cljs.compiler.emit_with_meta.call(null,G__15984,G__15985));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__15990 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15990,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15990,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15990,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15997 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15997) : x.call(null,G__15997));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15998 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15998) : x.call(null,G__15998));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__16008 = items;
var G__16009 = (function (p1__16007_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__16007_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__16008,G__16009) : cljs.compiler.emit_js_object.call(null,G__16008,G__16009));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__16013){
var map__16014 = p__16013;
var map__16014__$1 = (((((!((map__16014 == null))))?(((((map__16014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16014.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16014):map__16014);
var ast = map__16014__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16014__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16014__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16014__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__16019 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__16019__$1 = (((((!((map__16019 == null))))?(((((map__16019.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16019.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16019):map__16019);
var cenv = map__16019__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16019__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__16022 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__16026 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__16026) : cljs.compiler.es5_GT__EQ_.call(null,G__16026));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__16022,cljs.analyzer.es5_allowed);
} else {
return G__16022;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__16028 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__16028,reserved);
} else {
return G__16028;
}
})();
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__16029_16838 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__16029_16839__$1 = (((G__16029_16838 instanceof cljs.core.Keyword))?G__16029_16838.fqn:null);
switch (G__16029_16839__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__16034){
var map__16035 = p__16034;
var map__16035__$1 = (((((!((map__16035 == null))))?(((((map__16035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16035.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16035):map__16035);
var arg = map__16035__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__16037 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__16037__$1 = (((((!((map__16037 == null))))?(((((map__16037.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16037.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16037):map__16037);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16037__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__16040){
var map__16041 = p__16040;
var map__16041__$1 = (((((!((map__16041 == null))))?(((((map__16041.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16041.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16041):map__16041);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16041__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16041__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16041__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__16043_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__16043_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__16044 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__16044) : comma_sep.call(null,G__16044));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__16045 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__16045) : comma_sep.call(null,G__16045));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__16046){
var map__16047 = p__16046;
var map__16047__$1 = (((((!((map__16047 == null))))?(((((map__16047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16047.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16047):map__16047);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16047__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16047__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16047__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__16051){
var map__16052 = p__16051;
var map__16052__$1 = (((((!((map__16052 == null))))?(((((map__16052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16052.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16052):map__16052);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16052__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16052__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__16054_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__16054_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__16055 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__16055) : comma_sep.call(null,G__16055));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__16056){
var map__16057 = p__16056;
var map__16057__$1 = (((((!((map__16057 == null))))?(((((map__16057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16057):map__16057);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16057__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16057__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___16862 = cljs.core.seq(items);
if(temp__5735__auto___16862){
var items_16863__$1 = temp__5735__auto___16862;
var vec__16062_16864 = items_16863__$1;
var seq__16063_16865 = cljs.core.seq(vec__16062_16864);
var first__16064_16866 = cljs.core.first(seq__16063_16865);
var seq__16063_16867__$1 = cljs.core.next(seq__16063_16865);
var vec__16065_16868 = first__16064_16866;
var k_16869 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16065_16868,(0),null);
var v_16870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16065_16868,(1),null);
var r_16871 = seq__16063_16867__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_16869),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16870) : emit_js_object_val.call(null,v_16870)));

var seq__16068_16872 = cljs.core.seq(r_16871);
var chunk__16069_16873 = null;
var count__16070_16874 = (0);
var i__16071_16875 = (0);
while(true){
if((i__16071_16875 < count__16070_16874)){
var vec__16078_16876 = chunk__16069_16873.cljs$core$IIndexed$_nth$arity$2(null,i__16071_16875);
var k_16877__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16078_16876,(0),null);
var v_16878__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16078_16876,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16877__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16878__$1) : emit_js_object_val.call(null,v_16878__$1)));


var G__16879 = seq__16068_16872;
var G__16880 = chunk__16069_16873;
var G__16881 = count__16070_16874;
var G__16882 = (i__16071_16875 + (1));
seq__16068_16872 = G__16879;
chunk__16069_16873 = G__16880;
count__16070_16874 = G__16881;
i__16071_16875 = G__16882;
continue;
} else {
var temp__5735__auto___16884__$1 = cljs.core.seq(seq__16068_16872);
if(temp__5735__auto___16884__$1){
var seq__16068_16885__$1 = temp__5735__auto___16884__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16068_16885__$1)){
var c__4609__auto___16886 = cljs.core.chunk_first(seq__16068_16885__$1);
var G__16887 = cljs.core.chunk_rest(seq__16068_16885__$1);
var G__16888 = c__4609__auto___16886;
var G__16889 = cljs.core.count(c__4609__auto___16886);
var G__16890 = (0);
seq__16068_16872 = G__16887;
chunk__16069_16873 = G__16888;
count__16070_16874 = G__16889;
i__16071_16875 = G__16890;
continue;
} else {
var vec__16081_16891 = cljs.core.first(seq__16068_16885__$1);
var k_16892__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16081_16891,(0),null);
var v_16893__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16081_16891,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16892__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16893__$1) : emit_js_object_val.call(null,v_16893__$1)));


var G__16894 = cljs.core.next(seq__16068_16885__$1);
var G__16895 = null;
var G__16896 = (0);
var G__16897 = (0);
seq__16068_16872 = G__16894;
chunk__16069_16873 = G__16895;
count__16070_16874 = G__16896;
i__16071_16875 = G__16897;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__16090){
var map__16091 = p__16090;
var map__16091__$1 = (((((!((map__16091 == null))))?(((((map__16091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16091.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16091):map__16091);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__16093){
var map__16094 = p__16093;
var map__16094__$1 = (((((!((map__16094 == null))))?(((((map__16094.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16094.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16094):map__16094);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16094__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16094__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__16106){
var map__16107 = p__16106;
var map__16107__$1 = (((((!((map__16107 == null))))?(((((map__16107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16107.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16107):map__16107);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16107__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__16115){
var map__16116 = p__16115;
var map__16116__$1 = (((((!((map__16116 == null))))?(((((map__16116.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16116.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16116):map__16116);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16116__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16116__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__16118 = cljs.analyzer.unwrap_quote(expr);
var map__16118__$1 = (((((!((map__16118 == null))))?(((((map__16118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16118.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16118):map__16118);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16118__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16118__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16118__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__16120 = cljs.analyzer.unwrap_quote(expr);
var map__16120__$1 = (((((!((map__16120 == null))))?(((((map__16120.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16120.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16120):map__16120);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16120__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16120__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16120__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__16123 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__16123.cljs$core$IFn$_invoke$arity$1 ? fexpr__16123.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__16123.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__16124){
var map__16125 = p__16124;
var map__16125__$1 = (((((!((map__16125 == null))))?(((((map__16125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16125.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16125):map__16125);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16125__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16125__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16125__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16125__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16125__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__16127){
var map__16128 = p__16127;
var map__16128__$1 = (((((!((map__16128 == null))))?(((((map__16128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16128.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16128):map__16128);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16128__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16128__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16128__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16128__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__16130_16916 = cljs.core.seq(nodes);
var chunk__16131_16917 = null;
var count__16132_16918 = (0);
var i__16133_16919 = (0);
while(true){
if((i__16133_16919 < count__16132_16918)){
var map__16155_16924 = chunk__16131_16917.cljs$core$IIndexed$_nth$arity$2(null,i__16133_16919);
var map__16155_16925__$1 = (((((!((map__16155_16924 == null))))?(((((map__16155_16924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16155_16924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16155_16924):map__16155_16924);
var ts_16926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16155_16925__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__16156_16927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16155_16925__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__16156_16928__$1 = (((((!((map__16156_16927 == null))))?(((((map__16156_16927.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16156_16927.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16156_16927):map__16156_16927);
var then_16929 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16156_16928__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__16159_16930 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16926));
var chunk__16160_16931 = null;
var count__16161_16932 = (0);
var i__16162_16933 = (0);
while(true){
if((i__16162_16933 < count__16161_16932)){
var test_16934 = chunk__16160_16931.cljs$core$IIndexed$_nth$arity$2(null,i__16162_16933);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16934,":");


var G__16935 = seq__16159_16930;
var G__16936 = chunk__16160_16931;
var G__16937 = count__16161_16932;
var G__16938 = (i__16162_16933 + (1));
seq__16159_16930 = G__16935;
chunk__16160_16931 = G__16936;
count__16161_16932 = G__16937;
i__16162_16933 = G__16938;
continue;
} else {
var temp__5735__auto___16939 = cljs.core.seq(seq__16159_16930);
if(temp__5735__auto___16939){
var seq__16159_16940__$1 = temp__5735__auto___16939;
if(cljs.core.chunked_seq_QMARK_(seq__16159_16940__$1)){
var c__4609__auto___16941 = cljs.core.chunk_first(seq__16159_16940__$1);
var G__16942 = cljs.core.chunk_rest(seq__16159_16940__$1);
var G__16943 = c__4609__auto___16941;
var G__16944 = cljs.core.count(c__4609__auto___16941);
var G__16945 = (0);
seq__16159_16930 = G__16942;
chunk__16160_16931 = G__16943;
count__16161_16932 = G__16944;
i__16162_16933 = G__16945;
continue;
} else {
var test_16946 = cljs.core.first(seq__16159_16940__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16946,":");


var G__16947 = cljs.core.next(seq__16159_16940__$1);
var G__16948 = null;
var G__16949 = (0);
var G__16950 = (0);
seq__16159_16930 = G__16947;
chunk__16160_16931 = G__16948;
count__16161_16932 = G__16949;
i__16162_16933 = G__16950;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16929);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16929);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16951 = seq__16130_16916;
var G__16952 = chunk__16131_16917;
var G__16953 = count__16132_16918;
var G__16954 = (i__16133_16919 + (1));
seq__16130_16916 = G__16951;
chunk__16131_16917 = G__16952;
count__16132_16918 = G__16953;
i__16133_16919 = G__16954;
continue;
} else {
var temp__5735__auto___16955 = cljs.core.seq(seq__16130_16916);
if(temp__5735__auto___16955){
var seq__16130_16956__$1 = temp__5735__auto___16955;
if(cljs.core.chunked_seq_QMARK_(seq__16130_16956__$1)){
var c__4609__auto___16957 = cljs.core.chunk_first(seq__16130_16956__$1);
var G__16958 = cljs.core.chunk_rest(seq__16130_16956__$1);
var G__16959 = c__4609__auto___16957;
var G__16960 = cljs.core.count(c__4609__auto___16957);
var G__16961 = (0);
seq__16130_16916 = G__16958;
chunk__16131_16917 = G__16959;
count__16132_16918 = G__16960;
i__16133_16919 = G__16961;
continue;
} else {
var map__16163_16962 = cljs.core.first(seq__16130_16956__$1);
var map__16163_16963__$1 = (((((!((map__16163_16962 == null))))?(((((map__16163_16962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16163_16962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16163_16962):map__16163_16962);
var ts_16964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16163_16963__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__16164_16965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16163_16963__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__16164_16966__$1 = (((((!((map__16164_16965 == null))))?(((((map__16164_16965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16164_16965.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16164_16965):map__16164_16965);
var then_16967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16164_16966__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__16167_16972 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16964));
var chunk__16168_16973 = null;
var count__16169_16974 = (0);
var i__16170_16975 = (0);
while(true){
if((i__16170_16975 < count__16169_16974)){
var test_16976 = chunk__16168_16973.cljs$core$IIndexed$_nth$arity$2(null,i__16170_16975);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16976,":");


var G__16977 = seq__16167_16972;
var G__16978 = chunk__16168_16973;
var G__16979 = count__16169_16974;
var G__16980 = (i__16170_16975 + (1));
seq__16167_16972 = G__16977;
chunk__16168_16973 = G__16978;
count__16169_16974 = G__16979;
i__16170_16975 = G__16980;
continue;
} else {
var temp__5735__auto___16981__$1 = cljs.core.seq(seq__16167_16972);
if(temp__5735__auto___16981__$1){
var seq__16167_16982__$1 = temp__5735__auto___16981__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16167_16982__$1)){
var c__4609__auto___16983 = cljs.core.chunk_first(seq__16167_16982__$1);
var G__16984 = cljs.core.chunk_rest(seq__16167_16982__$1);
var G__16985 = c__4609__auto___16983;
var G__16986 = cljs.core.count(c__4609__auto___16983);
var G__16987 = (0);
seq__16167_16972 = G__16984;
chunk__16168_16973 = G__16985;
count__16169_16974 = G__16986;
i__16170_16975 = G__16987;
continue;
} else {
var test_16988 = cljs.core.first(seq__16167_16982__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16988,":");


var G__16989 = cljs.core.next(seq__16167_16982__$1);
var G__16990 = null;
var G__16991 = (0);
var G__16992 = (0);
seq__16167_16972 = G__16989;
chunk__16168_16973 = G__16990;
count__16169_16974 = G__16991;
i__16170_16975 = G__16992;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16967);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16967);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16993 = cljs.core.next(seq__16130_16956__$1);
var G__16994 = null;
var G__16995 = (0);
var G__16996 = (0);
seq__16130_16916 = G__16993;
chunk__16131_16917 = G__16994;
count__16132_16918 = G__16995;
i__16133_16919 = G__16996;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__16171){
var map__16172 = p__16171;
var map__16172__$1 = (((((!((map__16172 == null))))?(((((map__16172.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16172.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16172):map__16172);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16172__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16172__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__16177 = env;
var G__16178 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__16177,G__16178) : cljs.compiler.resolve_type.call(null,G__16177,G__16178));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__16179 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16179,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16179,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__16174_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__16174_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__16174_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__16182 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__16182,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__16182;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__16185 = env;
var G__16186 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__16185,G__16186) : cljs.compiler.resolve_type.call(null,G__16185,G__16186));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16187_SHARP_){
return cljs.compiler.resolve_type(env,p1__16187_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__16188 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__16189 = cljs.core.seq(vec__16188);
var first__16190 = cljs.core.first(seq__16189);
var seq__16189__$1 = cljs.core.next(seq__16189);
var p = first__16190;
var first__16190__$1 = cljs.core.first(seq__16189__$1);
var seq__16189__$2 = cljs.core.next(seq__16189__$1);
var ts = first__16190__$1;
var first__16190__$2 = cljs.core.first(seq__16189__$2);
var seq__16189__$3 = cljs.core.next(seq__16189__$2);
var n = first__16190__$2;
var xs = seq__16189__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__16191 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__16192 = cljs.core.seq(vec__16191);
var first__16193 = cljs.core.first(seq__16192);
var seq__16192__$1 = cljs.core.next(seq__16192);
var p = first__16193;
var first__16193__$1 = cljs.core.first(seq__16192__$1);
var seq__16192__$2 = cljs.core.next(seq__16192__$1);
var ts = first__16193__$1;
var xs = seq__16192__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__16195 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__16194 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__16194.cljs$core$IFn$_invoke$arity$1 ? fexpr__16194.cljs$core$IFn$_invoke$arity$1(G__16195) : fexpr__16194.call(null,G__16195));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__16198 = arguments.length;
switch (G__16198) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__16206 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16196_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__16196_SHARP_);
} else {
return p1__16196_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__16207 = cljs.core.seq(vec__16206);
var first__16208 = cljs.core.first(seq__16207);
var seq__16207__$1 = cljs.core.next(seq__16207);
var x = first__16208;
var ys = seq__16207__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__16209 = cljs.core.seq(ys);
var chunk__16210 = null;
var count__16211 = (0);
var i__16212 = (0);
while(true){
if((i__16212 < count__16211)){
var next_line = chunk__16210.cljs$core$IIndexed$_nth$arity$2(null,i__16212);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__17019 = seq__16209;
var G__17020 = chunk__16210;
var G__17021 = count__16211;
var G__17022 = (i__16212 + (1));
seq__16209 = G__17019;
chunk__16210 = G__17020;
count__16211 = G__17021;
i__16212 = G__17022;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16209);
if(temp__5735__auto__){
var seq__16209__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16209__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16209__$1);
var G__17029 = cljs.core.chunk_rest(seq__16209__$1);
var G__17030 = c__4609__auto__;
var G__17031 = cljs.core.count(c__4609__auto__);
var G__17032 = (0);
seq__16209 = G__17029;
chunk__16210 = G__17030;
count__16211 = G__17031;
i__16212 = G__17032;
continue;
} else {
var next_line = cljs.core.first(seq__16209__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__17033 = cljs.core.next(seq__16209__$1);
var G__17034 = null;
var G__17035 = (0);
var G__17036 = (0);
seq__16209 = G__17033;
chunk__16210 = G__17034;
count__16211 = G__17035;
i__16212 = G__17036;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__16221_17038 = cljs.core.seq(docs__$2);
var chunk__16222_17039 = null;
var count__16223_17040 = (0);
var i__16224_17041 = (0);
while(true){
if((i__16224_17041 < count__16223_17040)){
var e_17042 = chunk__16222_17039.cljs$core$IIndexed$_nth$arity$2(null,i__16224_17041);
if(cljs.core.truth_(e_17042)){
print_comment_lines(e_17042);
} else {
}


var G__17043 = seq__16221_17038;
var G__17044 = chunk__16222_17039;
var G__17045 = count__16223_17040;
var G__17046 = (i__16224_17041 + (1));
seq__16221_17038 = G__17043;
chunk__16222_17039 = G__17044;
count__16223_17040 = G__17045;
i__16224_17041 = G__17046;
continue;
} else {
var temp__5735__auto___17047 = cljs.core.seq(seq__16221_17038);
if(temp__5735__auto___17047){
var seq__16221_17048__$1 = temp__5735__auto___17047;
if(cljs.core.chunked_seq_QMARK_(seq__16221_17048__$1)){
var c__4609__auto___17049 = cljs.core.chunk_first(seq__16221_17048__$1);
var G__17050 = cljs.core.chunk_rest(seq__16221_17048__$1);
var G__17051 = c__4609__auto___17049;
var G__17052 = cljs.core.count(c__4609__auto___17049);
var G__17053 = (0);
seq__16221_17038 = G__17050;
chunk__16222_17039 = G__17051;
count__16223_17040 = G__17052;
i__16224_17041 = G__17053;
continue;
} else {
var e_17054 = cljs.core.first(seq__16221_17048__$1);
if(cljs.core.truth_(e_17054)){
print_comment_lines(e_17054);
} else {
}


var G__17055 = cljs.core.next(seq__16221_17048__$1);
var G__17056 = null;
var G__17057 = (0);
var G__17058 = (0);
seq__16221_17038 = G__17055;
chunk__16222_17039 = G__17056;
count__16223_17040 = G__17057;
i__16224_17041 = G__17058;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__16226_SHARP_){
return goog.string.startsWith(p1__16226_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__16227){
var map__16228 = p__16227;
var map__16228__$1 = (((((!((map__16228 == null))))?(((((map__16228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16228.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16228):map__16228);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16228__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__16230){
var map__16231 = p__16230;
var map__16231__$1 = (((((!((map__16231 == null))))?(((((map__16231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16231.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16231):map__16231);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16231__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16231__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16231__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__16233_17069 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__16234_17070 = null;
var count__16235_17071 = (0);
var i__16236_17072 = (0);
while(true){
if((i__16236_17072 < count__16235_17071)){
var vec__16243_17077 = chunk__16234_17070.cljs$core$IIndexed$_nth$arity$2(null,i__16236_17072);
var i_17078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16243_17077,(0),null);
var param_17079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16243_17077,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_17079);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__17082 = seq__16233_17069;
var G__17083 = chunk__16234_17070;
var G__17084 = count__16235_17071;
var G__17085 = (i__16236_17072 + (1));
seq__16233_17069 = G__17082;
chunk__16234_17070 = G__17083;
count__16235_17071 = G__17084;
i__16236_17072 = G__17085;
continue;
} else {
var temp__5735__auto___17086 = cljs.core.seq(seq__16233_17069);
if(temp__5735__auto___17086){
var seq__16233_17087__$1 = temp__5735__auto___17086;
if(cljs.core.chunked_seq_QMARK_(seq__16233_17087__$1)){
var c__4609__auto___17088 = cljs.core.chunk_first(seq__16233_17087__$1);
var G__17089 = cljs.core.chunk_rest(seq__16233_17087__$1);
var G__17090 = c__4609__auto___17088;
var G__17091 = cljs.core.count(c__4609__auto___17088);
var G__17092 = (0);
seq__16233_17069 = G__17089;
chunk__16234_17070 = G__17090;
count__16235_17071 = G__17091;
i__16236_17072 = G__17092;
continue;
} else {
var vec__16247_17093 = cljs.core.first(seq__16233_17087__$1);
var i_17094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16247_17093,(0),null);
var param_17095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16247_17093,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_17095);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__17096 = cljs.core.next(seq__16233_17087__$1);
var G__17097 = null;
var G__17098 = (0);
var G__17099 = (0);
seq__16233_17069 = G__17096;
chunk__16234_17070 = G__17097;
count__16235_17071 = G__17098;
i__16236_17072 = G__17099;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__16250_17101 = cljs.core.seq(params);
var chunk__16251_17102 = null;
var count__16252_17103 = (0);
var i__16253_17104 = (0);
while(true){
if((i__16253_17104 < count__16252_17103)){
var param_17105 = chunk__16251_17102.cljs$core$IIndexed$_nth$arity$2(null,i__16253_17104);
cljs.compiler.emit(param_17105);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17105,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17113 = seq__16250_17101;
var G__17114 = chunk__16251_17102;
var G__17115 = count__16252_17103;
var G__17116 = (i__16253_17104 + (1));
seq__16250_17101 = G__17113;
chunk__16251_17102 = G__17114;
count__16252_17103 = G__17115;
i__16253_17104 = G__17116;
continue;
} else {
var temp__5735__auto___17118 = cljs.core.seq(seq__16250_17101);
if(temp__5735__auto___17118){
var seq__16250_17119__$1 = temp__5735__auto___17118;
if(cljs.core.chunked_seq_QMARK_(seq__16250_17119__$1)){
var c__4609__auto___17120 = cljs.core.chunk_first(seq__16250_17119__$1);
var G__17121 = cljs.core.chunk_rest(seq__16250_17119__$1);
var G__17122 = c__4609__auto___17120;
var G__17123 = cljs.core.count(c__4609__auto___17120);
var G__17124 = (0);
seq__16250_17101 = G__17121;
chunk__16251_17102 = G__17122;
count__16252_17103 = G__17123;
i__16253_17104 = G__17124;
continue;
} else {
var param_17125 = cljs.core.first(seq__16250_17119__$1);
cljs.compiler.emit(param_17125);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17125,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17127 = cljs.core.next(seq__16250_17119__$1);
var G__17128 = null;
var G__17129 = (0);
var G__17130 = (0);
seq__16250_17101 = G__17127;
chunk__16251_17102 = G__17128;
count__16252_17103 = G__17129;
i__16253_17104 = G__17130;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__16255_17132 = cljs.core.seq(params);
var chunk__16256_17133 = null;
var count__16257_17134 = (0);
var i__16258_17135 = (0);
while(true){
if((i__16258_17135 < count__16257_17134)){
var param_17136 = chunk__16256_17133.cljs$core$IIndexed$_nth$arity$2(null,i__16258_17135);
cljs.compiler.emit(param_17136);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17136,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17138 = seq__16255_17132;
var G__17139 = chunk__16256_17133;
var G__17140 = count__16257_17134;
var G__17141 = (i__16258_17135 + (1));
seq__16255_17132 = G__17138;
chunk__16256_17133 = G__17139;
count__16257_17134 = G__17140;
i__16258_17135 = G__17141;
continue;
} else {
var temp__5735__auto___17142 = cljs.core.seq(seq__16255_17132);
if(temp__5735__auto___17142){
var seq__16255_17143__$1 = temp__5735__auto___17142;
if(cljs.core.chunked_seq_QMARK_(seq__16255_17143__$1)){
var c__4609__auto___17144 = cljs.core.chunk_first(seq__16255_17143__$1);
var G__17145 = cljs.core.chunk_rest(seq__16255_17143__$1);
var G__17146 = c__4609__auto___17144;
var G__17147 = cljs.core.count(c__4609__auto___17144);
var G__17148 = (0);
seq__16255_17132 = G__17145;
chunk__16256_17133 = G__17146;
count__16257_17134 = G__17147;
i__16258_17135 = G__17148;
continue;
} else {
var param_17149 = cljs.core.first(seq__16255_17143__$1);
cljs.compiler.emit(param_17149);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17149,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17150 = cljs.core.next(seq__16255_17143__$1);
var G__17151 = null;
var G__17152 = (0);
var G__17153 = (0);
seq__16255_17132 = G__17150;
chunk__16256_17133 = G__17151;
count__16257_17134 = G__17152;
i__16258_17135 = G__17153;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__16263 = cljs.core.seq(params);
var chunk__16264 = null;
var count__16265 = (0);
var i__16266 = (0);
while(true){
if((i__16266 < count__16265)){
var param = chunk__16264.cljs$core$IIndexed$_nth$arity$2(null,i__16266);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17157 = seq__16263;
var G__17158 = chunk__16264;
var G__17159 = count__16265;
var G__17160 = (i__16266 + (1));
seq__16263 = G__17157;
chunk__16264 = G__17158;
count__16265 = G__17159;
i__16266 = G__17160;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16263);
if(temp__5735__auto__){
var seq__16263__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16263__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16263__$1);
var G__17164 = cljs.core.chunk_rest(seq__16263__$1);
var G__17165 = c__4609__auto__;
var G__17166 = cljs.core.count(c__4609__auto__);
var G__17167 = (0);
seq__16263 = G__17164;
chunk__16264 = G__17165;
count__16265 = G__17166;
i__16266 = G__17167;
continue;
} else {
var param = cljs.core.first(seq__16263__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17168 = cljs.core.next(seq__16263__$1);
var G__17169 = null;
var G__17170 = (0);
var G__17171 = (0);
seq__16263 = G__17168;
chunk__16264 = G__17169;
count__16265 = G__17170;
i__16266 = G__17171;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__16267){
var map__16268 = p__16267;
var map__16268__$1 = (((((!((map__16268 == null))))?(((((map__16268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16268):map__16268);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16268__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16268__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16268__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16268__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16268__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16268__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__16272){
var map__16273 = p__16272;
var map__16273__$1 = (((((!((map__16273 == null))))?(((((map__16273.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16273.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16273):map__16273);
var f = map__16273__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16273__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_17179__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_17180 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_17179__$1);
var delegate_name_17181 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_17180),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_17181," = function (");

var seq__16275_17182 = cljs.core.seq(params);
var chunk__16276_17183 = null;
var count__16277_17184 = (0);
var i__16278_17185 = (0);
while(true){
if((i__16278_17185 < count__16277_17184)){
var param_17186 = chunk__16276_17183.cljs$core$IIndexed$_nth$arity$2(null,i__16278_17185);
cljs.compiler.emit(param_17186);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17186,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17187 = seq__16275_17182;
var G__17188 = chunk__16276_17183;
var G__17189 = count__16277_17184;
var G__17190 = (i__16278_17185 + (1));
seq__16275_17182 = G__17187;
chunk__16276_17183 = G__17188;
count__16277_17184 = G__17189;
i__16278_17185 = G__17190;
continue;
} else {
var temp__5735__auto___17191 = cljs.core.seq(seq__16275_17182);
if(temp__5735__auto___17191){
var seq__16275_17192__$1 = temp__5735__auto___17191;
if(cljs.core.chunked_seq_QMARK_(seq__16275_17192__$1)){
var c__4609__auto___17193 = cljs.core.chunk_first(seq__16275_17192__$1);
var G__17194 = cljs.core.chunk_rest(seq__16275_17192__$1);
var G__17195 = c__4609__auto___17193;
var G__17196 = cljs.core.count(c__4609__auto___17193);
var G__17197 = (0);
seq__16275_17182 = G__17194;
chunk__16276_17183 = G__17195;
count__16277_17184 = G__17196;
i__16278_17185 = G__17197;
continue;
} else {
var param_17198 = cljs.core.first(seq__16275_17192__$1);
cljs.compiler.emit(param_17198);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17198,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17199 = cljs.core.next(seq__16275_17192__$1);
var G__17200 = null;
var G__17201 = (0);
var G__17202 = (0);
seq__16275_17182 = G__17199;
chunk__16276_17183 = G__17200;
count__16277_17184 = G__17201;
i__16278_17185 = G__17202;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_17180," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_17203 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_17203,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_17181,".call(this,");

var seq__16279_17208 = cljs.core.seq(params);
var chunk__16280_17209 = null;
var count__16281_17210 = (0);
var i__16282_17211 = (0);
while(true){
if((i__16282_17211 < count__16281_17210)){
var param_17212 = chunk__16280_17209.cljs$core$IIndexed$_nth$arity$2(null,i__16282_17211);
cljs.compiler.emit(param_17212);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17212,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17214 = seq__16279_17208;
var G__17215 = chunk__16280_17209;
var G__17216 = count__16281_17210;
var G__17217 = (i__16282_17211 + (1));
seq__16279_17208 = G__17214;
chunk__16280_17209 = G__17215;
count__16281_17210 = G__17216;
i__16282_17211 = G__17217;
continue;
} else {
var temp__5735__auto___17218 = cljs.core.seq(seq__16279_17208);
if(temp__5735__auto___17218){
var seq__16279_17219__$1 = temp__5735__auto___17218;
if(cljs.core.chunked_seq_QMARK_(seq__16279_17219__$1)){
var c__4609__auto___17220 = cljs.core.chunk_first(seq__16279_17219__$1);
var G__17221 = cljs.core.chunk_rest(seq__16279_17219__$1);
var G__17222 = c__4609__auto___17220;
var G__17223 = cljs.core.count(c__4609__auto___17220);
var G__17224 = (0);
seq__16279_17208 = G__17221;
chunk__16280_17209 = G__17222;
count__16281_17210 = G__17223;
i__16282_17211 = G__17224;
continue;
} else {
var param_17225 = cljs.core.first(seq__16279_17219__$1);
cljs.compiler.emit(param_17225);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17225,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17226 = cljs.core.next(seq__16279_17219__$1);
var G__17227 = null;
var G__17228 = (0);
var G__17229 = (0);
seq__16279_17208 = G__17226;
chunk__16280_17209 = G__17227;
count__16281_17210 = G__17228;
i__16282_17211 = G__17229;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17180,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_17180,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_17179__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17180,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_17181,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_17180,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__16286){
var map__16287 = p__16286;
var map__16287__$1 = (((((!((map__16287 == null))))?(((((map__16287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16287.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16287):map__16287);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16287__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__16283_SHARP_){
var and__4174__auto__ = p1__16283_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__16283_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_17232__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_17233 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_17232__$1);
var maxparams_17234 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_17235 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_17233),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_17236 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__16284_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__16284_SHARP_)));
}),cljs.core.seq(mmap_17235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_17233," = null;");

var seq__16289_17239 = cljs.core.seq(ms_17236);
var chunk__16290_17240 = null;
var count__16291_17241 = (0);
var i__16292_17242 = (0);
while(true){
if((i__16292_17242 < count__16291_17241)){
var vec__16299_17243 = chunk__16290_17240.cljs$core$IIndexed$_nth$arity$2(null,i__16292_17242);
var n_17244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16299_17243,(0),null);
var meth_17245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16299_17243,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_17244," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17245))){
cljs.compiler.emit_variadic_fn_method(meth_17245);
} else {
cljs.compiler.emit_fn_method(meth_17245);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__17247 = seq__16289_17239;
var G__17248 = chunk__16290_17240;
var G__17249 = count__16291_17241;
var G__17250 = (i__16292_17242 + (1));
seq__16289_17239 = G__17247;
chunk__16290_17240 = G__17248;
count__16291_17241 = G__17249;
i__16292_17242 = G__17250;
continue;
} else {
var temp__5735__auto___17251 = cljs.core.seq(seq__16289_17239);
if(temp__5735__auto___17251){
var seq__16289_17252__$1 = temp__5735__auto___17251;
if(cljs.core.chunked_seq_QMARK_(seq__16289_17252__$1)){
var c__4609__auto___17253 = cljs.core.chunk_first(seq__16289_17252__$1);
var G__17254 = cljs.core.chunk_rest(seq__16289_17252__$1);
var G__17255 = c__4609__auto___17253;
var G__17256 = cljs.core.count(c__4609__auto___17253);
var G__17257 = (0);
seq__16289_17239 = G__17254;
chunk__16290_17240 = G__17255;
count__16291_17241 = G__17256;
i__16292_17242 = G__17257;
continue;
} else {
var vec__16302_17258 = cljs.core.first(seq__16289_17252__$1);
var n_17259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16302_17258,(0),null);
var meth_17260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16302_17258,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_17259," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17260))){
cljs.compiler.emit_variadic_fn_method(meth_17260);
} else {
cljs.compiler.emit_fn_method(meth_17260);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__17261 = cljs.core.next(seq__16289_17252__$1);
var G__17262 = null;
var G__17263 = (0);
var G__17264 = (0);
seq__16289_17239 = G__17261;
chunk__16290_17240 = G__17262;
count__16291_17241 = G__17263;
i__16292_17242 = G__17264;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17233," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_17234),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_17234)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_17234));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__16305_17267 = cljs.core.seq(ms_17236);
var chunk__16306_17268 = null;
var count__16307_17269 = (0);
var i__16308_17270 = (0);
while(true){
if((i__16308_17270 < count__16307_17269)){
var vec__16315_17271 = chunk__16306_17268.cljs$core$IIndexed$_nth$arity$2(null,i__16308_17270);
var n_17272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16315_17271,(0),null);
var meth_17273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16315_17271,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17273))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_17274 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_17274," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_17275 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_17274," = new cljs.core.IndexedSeq(",a_17275,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_17272,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_17234)),(((cljs.core.count(maxparams_17234) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_17274,");"], 0));
} else {
var pcnt_17276 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17273));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_17276,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_17272,".call(this",(((pcnt_17276 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_17276,maxparams_17234)),null,(1),null)),(2),null))),");");
}


var G__17277 = seq__16305_17267;
var G__17278 = chunk__16306_17268;
var G__17279 = count__16307_17269;
var G__17280 = (i__16308_17270 + (1));
seq__16305_17267 = G__17277;
chunk__16306_17268 = G__17278;
count__16307_17269 = G__17279;
i__16308_17270 = G__17280;
continue;
} else {
var temp__5735__auto___17281 = cljs.core.seq(seq__16305_17267);
if(temp__5735__auto___17281){
var seq__16305_17282__$1 = temp__5735__auto___17281;
if(cljs.core.chunked_seq_QMARK_(seq__16305_17282__$1)){
var c__4609__auto___17283 = cljs.core.chunk_first(seq__16305_17282__$1);
var G__17284 = cljs.core.chunk_rest(seq__16305_17282__$1);
var G__17285 = c__4609__auto___17283;
var G__17286 = cljs.core.count(c__4609__auto___17283);
var G__17287 = (0);
seq__16305_17267 = G__17284;
chunk__16306_17268 = G__17285;
count__16307_17269 = G__17286;
i__16308_17270 = G__17287;
continue;
} else {
var vec__16318_17288 = cljs.core.first(seq__16305_17282__$1);
var n_17289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16318_17288,(0),null);
var meth_17290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16318_17288,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17290))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_17292 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_17292," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_17294 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_17292," = new cljs.core.IndexedSeq(",a_17294,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_17289,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_17234)),(((cljs.core.count(maxparams_17234) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_17292,");"], 0));
} else {
var pcnt_17296 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17290));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_17296,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_17289,".call(this",(((pcnt_17296 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_17296,maxparams_17234)),null,(1),null)),(2),null))),");");
}


var G__17297 = cljs.core.next(seq__16305_17282__$1);
var G__17298 = null;
var G__17299 = (0);
var G__17300 = (0);
seq__16305_17267 = G__17297;
chunk__16306_17268 = G__17298;
count__16307_17269 = G__17299;
i__16308_17270 = G__17300;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_17301 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_17236)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_17301,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17233,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17233,".cljs$lang$applyTo = ",cljs.core.some((function (p1__16285_SHARP_){
var vec__16324 = p1__16285_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16324,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16324,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_17236),".cljs$lang$applyTo;");
} else {
}

var seq__16327_17302 = cljs.core.seq(ms_17236);
var chunk__16328_17303 = null;
var count__16329_17304 = (0);
var i__16330_17305 = (0);
while(true){
if((i__16330_17305 < count__16329_17304)){
var vec__16337_17306 = chunk__16328_17303.cljs$core$IIndexed$_nth$arity$2(null,i__16330_17305);
var n_17307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16337_17306,(0),null);
var meth_17308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16337_17306,(1),null);
var c_17309 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17308));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17308))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17233,".cljs$core$IFn$_invoke$arity$variadic = ",n_17307,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_17233,".cljs$core$IFn$_invoke$arity$",c_17309," = ",n_17307,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__17310 = seq__16327_17302;
var G__17311 = chunk__16328_17303;
var G__17312 = count__16329_17304;
var G__17313 = (i__16330_17305 + (1));
seq__16327_17302 = G__17310;
chunk__16328_17303 = G__17311;
count__16329_17304 = G__17312;
i__16330_17305 = G__17313;
continue;
} else {
var temp__5735__auto___17314 = cljs.core.seq(seq__16327_17302);
if(temp__5735__auto___17314){
var seq__16327_17315__$1 = temp__5735__auto___17314;
if(cljs.core.chunked_seq_QMARK_(seq__16327_17315__$1)){
var c__4609__auto___17316 = cljs.core.chunk_first(seq__16327_17315__$1);
var G__17317 = cljs.core.chunk_rest(seq__16327_17315__$1);
var G__17318 = c__4609__auto___17316;
var G__17319 = cljs.core.count(c__4609__auto___17316);
var G__17320 = (0);
seq__16327_17302 = G__17317;
chunk__16328_17303 = G__17318;
count__16329_17304 = G__17319;
i__16330_17305 = G__17320;
continue;
} else {
var vec__16340_17321 = cljs.core.first(seq__16327_17315__$1);
var n_17322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16340_17321,(0),null);
var meth_17323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16340_17321,(1),null);
var c_17325 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17323));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17323))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17233,".cljs$core$IFn$_invoke$arity$variadic = ",n_17322,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_17233,".cljs$core$IFn$_invoke$arity$",c_17325," = ",n_17322,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__17329 = cljs.core.next(seq__16327_17315__$1);
var G__17330 = null;
var G__17331 = (0);
var G__17332 = (0);
seq__16327_17302 = G__17329;
chunk__16328_17303 = G__17330;
count__16329_17304 = G__17331;
i__16330_17305 = G__17332;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_17233,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__16343){
var map__16344 = p__16343;
var map__16344__$1 = (((((!((map__16344 == null))))?(((((map__16344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16344):map__16344);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16344__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16344__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16344__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__16346_17333 = cljs.core.seq(statements);
var chunk__16347_17334 = null;
var count__16348_17335 = (0);
var i__16349_17336 = (0);
while(true){
if((i__16349_17336 < count__16348_17335)){
var s_17337 = chunk__16347_17334.cljs$core$IIndexed$_nth$arity$2(null,i__16349_17336);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_17337);


var G__17338 = seq__16346_17333;
var G__17339 = chunk__16347_17334;
var G__17340 = count__16348_17335;
var G__17341 = (i__16349_17336 + (1));
seq__16346_17333 = G__17338;
chunk__16347_17334 = G__17339;
count__16348_17335 = G__17340;
i__16349_17336 = G__17341;
continue;
} else {
var temp__5735__auto___17342 = cljs.core.seq(seq__16346_17333);
if(temp__5735__auto___17342){
var seq__16346_17343__$1 = temp__5735__auto___17342;
if(cljs.core.chunked_seq_QMARK_(seq__16346_17343__$1)){
var c__4609__auto___17344 = cljs.core.chunk_first(seq__16346_17343__$1);
var G__17345 = cljs.core.chunk_rest(seq__16346_17343__$1);
var G__17346 = c__4609__auto___17344;
var G__17347 = cljs.core.count(c__4609__auto___17344);
var G__17348 = (0);
seq__16346_17333 = G__17345;
chunk__16347_17334 = G__17346;
count__16348_17335 = G__17347;
i__16349_17336 = G__17348;
continue;
} else {
var s_17349 = cljs.core.first(seq__16346_17343__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_17349);


var G__17350 = cljs.core.next(seq__16346_17343__$1);
var G__17351 = null;
var G__17352 = (0);
var G__17353 = (0);
seq__16346_17333 = G__17350;
chunk__16347_17334 = G__17351;
count__16348_17335 = G__17352;
i__16349_17336 = G__17353;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__16350){
var map__16351 = p__16350;
var map__16351__$1 = (((((!((map__16351 == null))))?(((((map__16351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16351.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16351):map__16351);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16351__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16351__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16351__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16351__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16351__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__16353,is_loop){
var map__16354 = p__16353;
var map__16354__$1 = (((((!((map__16354 == null))))?(((((map__16354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16354.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16354):map__16354);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16354__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16354__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16354__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__16356_17355 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__16357_17356 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__16357_17356);

try{var seq__16358_17357 = cljs.core.seq(bindings);
var chunk__16359_17358 = null;
var count__16360_17359 = (0);
var i__16361_17360 = (0);
while(true){
if((i__16361_17360 < count__16360_17359)){
var map__16366_17361 = chunk__16359_17358.cljs$core$IIndexed$_nth$arity$2(null,i__16361_17360);
var map__16366_17362__$1 = (((((!((map__16366_17361 == null))))?(((((map__16366_17361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16366_17361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16366_17361):map__16366_17361);
var binding_17363 = map__16366_17362__$1;
var init_17364 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16366_17362__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_17363);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_17364,";");


var G__17369 = seq__16358_17357;
var G__17370 = chunk__16359_17358;
var G__17371 = count__16360_17359;
var G__17372 = (i__16361_17360 + (1));
seq__16358_17357 = G__17369;
chunk__16359_17358 = G__17370;
count__16360_17359 = G__17371;
i__16361_17360 = G__17372;
continue;
} else {
var temp__5735__auto___17373 = cljs.core.seq(seq__16358_17357);
if(temp__5735__auto___17373){
var seq__16358_17374__$1 = temp__5735__auto___17373;
if(cljs.core.chunked_seq_QMARK_(seq__16358_17374__$1)){
var c__4609__auto___17375 = cljs.core.chunk_first(seq__16358_17374__$1);
var G__17376 = cljs.core.chunk_rest(seq__16358_17374__$1);
var G__17377 = c__4609__auto___17375;
var G__17378 = cljs.core.count(c__4609__auto___17375);
var G__17379 = (0);
seq__16358_17357 = G__17376;
chunk__16359_17358 = G__17377;
count__16360_17359 = G__17378;
i__16361_17360 = G__17379;
continue;
} else {
var map__16368_17380 = cljs.core.first(seq__16358_17374__$1);
var map__16368_17381__$1 = (((((!((map__16368_17380 == null))))?(((((map__16368_17380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16368_17380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16368_17380):map__16368_17380);
var binding_17382 = map__16368_17381__$1;
var init_17383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16368_17381__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_17382);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_17383,";");


var G__17384 = cljs.core.next(seq__16358_17374__$1);
var G__17385 = null;
var G__17386 = (0);
var G__17387 = (0);
seq__16358_17357 = G__17384;
chunk__16359_17358 = G__17385;
count__16360_17359 = G__17386;
i__16361_17360 = G__17387;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__16356_17355);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__16373){
var map__16374 = p__16373;
var map__16374__$1 = (((((!((map__16374 == null))))?(((((map__16374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16374.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16374):map__16374);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16374__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16374__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16374__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___17392 = cljs.core.count(exprs);
var i_17393 = (0);
while(true){
if((i_17393 < n__4666__auto___17392)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_17393) : temps.call(null,i_17393))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_17393) : exprs.call(null,i_17393)),";");

var G__17394 = (i_17393 + (1));
i_17393 = G__17394;
continue;
} else {
}
break;
}

var n__4666__auto___17395 = cljs.core.count(exprs);
var i_17396 = (0);
while(true){
if((i_17396 < n__4666__auto___17395)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_17396) : params.call(null,i_17396)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_17396) : temps.call(null,i_17396)),";");

var G__17397 = (i_17396 + (1));
i_17396 = G__17397;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__16376){
var map__16377 = p__16376;
var map__16377__$1 = (((((!((map__16377 == null))))?(((((map__16377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16377.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16377):map__16377);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16377__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16377__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16377__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__16379_17398 = cljs.core.seq(bindings);
var chunk__16380_17399 = null;
var count__16381_17400 = (0);
var i__16382_17401 = (0);
while(true){
if((i__16382_17401 < count__16381_17400)){
var map__16391_17403 = chunk__16380_17399.cljs$core$IIndexed$_nth$arity$2(null,i__16382_17401);
var map__16391_17404__$1 = (((((!((map__16391_17403 == null))))?(((((map__16391_17403.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16391_17403.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16391_17403):map__16391_17403);
var binding_17405 = map__16391_17404__$1;
var init_17406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16391_17404__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_17405)," = ",init_17406,";");


var G__17410 = seq__16379_17398;
var G__17411 = chunk__16380_17399;
var G__17412 = count__16381_17400;
var G__17413 = (i__16382_17401 + (1));
seq__16379_17398 = G__17410;
chunk__16380_17399 = G__17411;
count__16381_17400 = G__17412;
i__16382_17401 = G__17413;
continue;
} else {
var temp__5735__auto___17414 = cljs.core.seq(seq__16379_17398);
if(temp__5735__auto___17414){
var seq__16379_17415__$1 = temp__5735__auto___17414;
if(cljs.core.chunked_seq_QMARK_(seq__16379_17415__$1)){
var c__4609__auto___17416 = cljs.core.chunk_first(seq__16379_17415__$1);
var G__17417 = cljs.core.chunk_rest(seq__16379_17415__$1);
var G__17418 = c__4609__auto___17416;
var G__17419 = cljs.core.count(c__4609__auto___17416);
var G__17420 = (0);
seq__16379_17398 = G__17417;
chunk__16380_17399 = G__17418;
count__16381_17400 = G__17419;
i__16382_17401 = G__17420;
continue;
} else {
var map__16393_17421 = cljs.core.first(seq__16379_17415__$1);
var map__16393_17422__$1 = (((((!((map__16393_17421 == null))))?(((((map__16393_17421.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16393_17421.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16393_17421):map__16393_17421);
var binding_17423 = map__16393_17422__$1;
var init_17424 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16393_17422__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_17423)," = ",init_17424,";");


var G__17425 = cljs.core.next(seq__16379_17415__$1);
var G__17426 = null;
var G__17427 = (0);
var G__17428 = (0);
seq__16379_17398 = G__17425;
chunk__16380_17399 = G__17426;
count__16381_17400 = G__17427;
i__16382_17401 = G__17428;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__16397){
var map__16398 = p__16397;
var map__16398__$1 = (((((!((map__16398 == null))))?(((((map__16398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16398.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16398):map__16398);
var expr = map__16398__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16398__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16398__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16398__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__16413 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__16413.cljs$core$IFn$_invoke$arity$1 ? fexpr__16413.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__16413.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__16417 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__16417.cljs$core$IFn$_invoke$arity$1 ? fexpr__16417.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__16417.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__16400 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16395_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16395_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16396_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16396_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16400,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16400,(1),null);
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_17442 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_17442,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_17443 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_17443,args)),(((mfa_17443 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_17443,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__16434 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__16433 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__16433.cljs$core$IFn$_invoke$arity$1 ? fexpr__16433.cljs$core$IFn$_invoke$arity$1(G__16434) : fexpr__16433.call(null,G__16434));
} else {
return and__4174__auto__;
}
})())){
var fprop_17446 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_17446," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_17446,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_17446," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_17446,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__16435){
var map__16436 = p__16435;
var map__16436__$1 = (((((!((map__16436 == null))))?(((((map__16436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16436):map__16436);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16436__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16436__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16436__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__16438){
var map__16439 = p__16438;
var map__16439__$1 = (((((!((map__16439 == null))))?(((((map__16439.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16439.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16439):map__16439);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16439__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16439__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16439__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__16475 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__16475__$1 = (((((!((map__16475 == null))))?(((((map__16475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16475):map__16475);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16475__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16475__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__16476 = options;
var map__16476__$1 = (((((!((map__16476 == null))))?(((((map__16476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16476):map__16476);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__16477 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__16486 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__16486__$1 = (((((!((map__16486 == null))))?(((((map__16486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16486):map__16486);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16486__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16486__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16477,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16477,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__16488_17467 = cljs.core.seq(libs_to_load);
var chunk__16489_17468 = null;
var count__16490_17469 = (0);
var i__16491_17470 = (0);
while(true){
if((i__16491_17470 < count__16490_17469)){
var lib_17471 = chunk__16489_17468.cljs$core$IIndexed$_nth$arity$2(null,i__16491_17470);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_17471)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17471),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17471),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17471),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17471),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_17471,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17471),"');");
}

}
}
}


var G__17476 = seq__16488_17467;
var G__17477 = chunk__16489_17468;
var G__17478 = count__16490_17469;
var G__17479 = (i__16491_17470 + (1));
seq__16488_17467 = G__17476;
chunk__16489_17468 = G__17477;
count__16490_17469 = G__17478;
i__16491_17470 = G__17479;
continue;
} else {
var temp__5735__auto___17480 = cljs.core.seq(seq__16488_17467);
if(temp__5735__auto___17480){
var seq__16488_17481__$1 = temp__5735__auto___17480;
if(cljs.core.chunked_seq_QMARK_(seq__16488_17481__$1)){
var c__4609__auto___17482 = cljs.core.chunk_first(seq__16488_17481__$1);
var G__17483 = cljs.core.chunk_rest(seq__16488_17481__$1);
var G__17484 = c__4609__auto___17482;
var G__17485 = cljs.core.count(c__4609__auto___17482);
var G__17486 = (0);
seq__16488_17467 = G__17483;
chunk__16489_17468 = G__17484;
count__16490_17469 = G__17485;
i__16491_17470 = G__17486;
continue;
} else {
var lib_17487 = cljs.core.first(seq__16488_17481__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_17487)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17487),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17487),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17487),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17487),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_17487,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17487),"');");
}

}
}
}


var G__17494 = cljs.core.next(seq__16488_17481__$1);
var G__17495 = null;
var G__17496 = (0);
var G__17497 = (0);
seq__16488_17467 = G__17494;
chunk__16489_17468 = G__17495;
count__16490_17469 = G__17496;
i__16491_17470 = G__17497;
continue;
}
} else {
}
}
break;
}

var seq__16492_17498 = cljs.core.seq(node_libs);
var chunk__16493_17499 = null;
var count__16494_17500 = (0);
var i__16495_17501 = (0);
while(true){
if((i__16495_17501 < count__16494_17500)){
var lib_17502 = chunk__16493_17499.cljs$core$IIndexed$_nth$arity$2(null,i__16495_17501);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_17502)," = require('",lib_17502,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__17503 = seq__16492_17498;
var G__17504 = chunk__16493_17499;
var G__17505 = count__16494_17500;
var G__17506 = (i__16495_17501 + (1));
seq__16492_17498 = G__17503;
chunk__16493_17499 = G__17504;
count__16494_17500 = G__17505;
i__16495_17501 = G__17506;
continue;
} else {
var temp__5735__auto___17507 = cljs.core.seq(seq__16492_17498);
if(temp__5735__auto___17507){
var seq__16492_17508__$1 = temp__5735__auto___17507;
if(cljs.core.chunked_seq_QMARK_(seq__16492_17508__$1)){
var c__4609__auto___17509 = cljs.core.chunk_first(seq__16492_17508__$1);
var G__17510 = cljs.core.chunk_rest(seq__16492_17508__$1);
var G__17511 = c__4609__auto___17509;
var G__17512 = cljs.core.count(c__4609__auto___17509);
var G__17513 = (0);
seq__16492_17498 = G__17510;
chunk__16493_17499 = G__17511;
count__16494_17500 = G__17512;
i__16495_17501 = G__17513;
continue;
} else {
var lib_17514 = cljs.core.first(seq__16492_17508__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_17514)," = require('",lib_17514,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__17517 = cljs.core.next(seq__16492_17508__$1);
var G__17518 = null;
var G__17519 = (0);
var G__17520 = (0);
seq__16492_17498 = G__17517;
chunk__16493_17499 = G__17518;
count__16494_17500 = G__17519;
i__16495_17501 = G__17520;
continue;
}
} else {
}
}
break;
}

var seq__16496_17521 = cljs.core.seq(global_exports_libs);
var chunk__16497_17522 = null;
var count__16498_17523 = (0);
var i__16499_17524 = (0);
while(true){
if((i__16499_17524 < count__16498_17523)){
var lib_17525 = chunk__16497_17522.cljs$core$IIndexed$_nth$arity$2(null,i__16499_17524);
var map__16516_17526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_17525));
var map__16516_17527__$1 = (((((!((map__16516_17526 == null))))?(((((map__16516_17526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16516_17526.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16516_17526):map__16516_17526);
var global_exports_17528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16516_17527__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_17528,lib_17525);


var G__17531 = seq__16496_17521;
var G__17532 = chunk__16497_17522;
var G__17533 = count__16498_17523;
var G__17534 = (i__16499_17524 + (1));
seq__16496_17521 = G__17531;
chunk__16497_17522 = G__17532;
count__16498_17523 = G__17533;
i__16499_17524 = G__17534;
continue;
} else {
var temp__5735__auto___17535 = cljs.core.seq(seq__16496_17521);
if(temp__5735__auto___17535){
var seq__16496_17536__$1 = temp__5735__auto___17535;
if(cljs.core.chunked_seq_QMARK_(seq__16496_17536__$1)){
var c__4609__auto___17537 = cljs.core.chunk_first(seq__16496_17536__$1);
var G__17538 = cljs.core.chunk_rest(seq__16496_17536__$1);
var G__17539 = c__4609__auto___17537;
var G__17540 = cljs.core.count(c__4609__auto___17537);
var G__17541 = (0);
seq__16496_17521 = G__17538;
chunk__16497_17522 = G__17539;
count__16498_17523 = G__17540;
i__16499_17524 = G__17541;
continue;
} else {
var lib_17542 = cljs.core.first(seq__16496_17536__$1);
var map__16527_17543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_17542));
var map__16527_17544__$1 = (((((!((map__16527_17543 == null))))?(((((map__16527_17543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16527_17543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16527_17543):map__16527_17543);
var global_exports_17545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16527_17544__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_17545,lib_17542);


var G__17546 = cljs.core.next(seq__16496_17536__$1);
var G__17547 = null;
var G__17548 = (0);
var G__17549 = (0);
seq__16496_17521 = G__17546;
chunk__16497_17522 = G__17547;
count__16498_17523 = G__17548;
i__16499_17524 = G__17549;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__16537){
var map__16538 = p__16537;
var map__16538__$1 = (((((!((map__16538 == null))))?(((((map__16538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16538):map__16538);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16538__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__16542){
var map__16543 = p__16542;
var map__16543__$1 = (((((!((map__16543 == null))))?(((((map__16543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16543):map__16543);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16543__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__16545){
var map__16546 = p__16545;
var map__16546__$1 = (((((!((map__16546 == null))))?(((((map__16546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16546.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16546):map__16546);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16546__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16546__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16546__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16546__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16546__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16548_17550 = cljs.core.seq(protocols);
var chunk__16549_17551 = null;
var count__16550_17552 = (0);
var i__16551_17553 = (0);
while(true){
if((i__16551_17553 < count__16550_17552)){
var protocol_17554 = chunk__16549_17551.cljs$core$IIndexed$_nth$arity$2(null,i__16551_17553);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17554)),"}");


var G__17555 = seq__16548_17550;
var G__17556 = chunk__16549_17551;
var G__17557 = count__16550_17552;
var G__17558 = (i__16551_17553 + (1));
seq__16548_17550 = G__17555;
chunk__16549_17551 = G__17556;
count__16550_17552 = G__17557;
i__16551_17553 = G__17558;
continue;
} else {
var temp__5735__auto___17559 = cljs.core.seq(seq__16548_17550);
if(temp__5735__auto___17559){
var seq__16548_17560__$1 = temp__5735__auto___17559;
if(cljs.core.chunked_seq_QMARK_(seq__16548_17560__$1)){
var c__4609__auto___17561 = cljs.core.chunk_first(seq__16548_17560__$1);
var G__17562 = cljs.core.chunk_rest(seq__16548_17560__$1);
var G__17563 = c__4609__auto___17561;
var G__17564 = cljs.core.count(c__4609__auto___17561);
var G__17565 = (0);
seq__16548_17550 = G__17562;
chunk__16549_17551 = G__17563;
count__16550_17552 = G__17564;
i__16551_17553 = G__17565;
continue;
} else {
var protocol_17566 = cljs.core.first(seq__16548_17560__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17566)),"}");


var G__17567 = cljs.core.next(seq__16548_17560__$1);
var G__17568 = null;
var G__17569 = (0);
var G__17570 = (0);
seq__16548_17550 = G__17567;
chunk__16549_17551 = G__17568;
count__16550_17552 = G__17569;
i__16551_17553 = G__17570;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16577_17571 = cljs.core.seq(fields__$1);
var chunk__16578_17572 = null;
var count__16579_17573 = (0);
var i__16580_17574 = (0);
while(true){
if((i__16580_17574 < count__16579_17573)){
var fld_17575 = chunk__16578_17572.cljs$core$IIndexed$_nth$arity$2(null,i__16580_17574);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17575," = ",fld_17575,";");


var G__17576 = seq__16577_17571;
var G__17577 = chunk__16578_17572;
var G__17578 = count__16579_17573;
var G__17579 = (i__16580_17574 + (1));
seq__16577_17571 = G__17576;
chunk__16578_17572 = G__17577;
count__16579_17573 = G__17578;
i__16580_17574 = G__17579;
continue;
} else {
var temp__5735__auto___17580 = cljs.core.seq(seq__16577_17571);
if(temp__5735__auto___17580){
var seq__16577_17581__$1 = temp__5735__auto___17580;
if(cljs.core.chunked_seq_QMARK_(seq__16577_17581__$1)){
var c__4609__auto___17582 = cljs.core.chunk_first(seq__16577_17581__$1);
var G__17583 = cljs.core.chunk_rest(seq__16577_17581__$1);
var G__17584 = c__4609__auto___17582;
var G__17585 = cljs.core.count(c__4609__auto___17582);
var G__17586 = (0);
seq__16577_17571 = G__17583;
chunk__16578_17572 = G__17584;
count__16579_17573 = G__17585;
i__16580_17574 = G__17586;
continue;
} else {
var fld_17587 = cljs.core.first(seq__16577_17581__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17587," = ",fld_17587,";");


var G__17588 = cljs.core.next(seq__16577_17581__$1);
var G__17589 = null;
var G__17590 = (0);
var G__17591 = (0);
seq__16577_17571 = G__17588;
chunk__16578_17572 = G__17589;
count__16579_17573 = G__17590;
i__16580_17574 = G__17591;
continue;
}
} else {
}
}
break;
}

var seq__16581_17592 = cljs.core.seq(pmasks);
var chunk__16582_17593 = null;
var count__16583_17594 = (0);
var i__16584_17595 = (0);
while(true){
if((i__16584_17595 < count__16583_17594)){
var vec__16591_17596 = chunk__16582_17593.cljs$core$IIndexed$_nth$arity$2(null,i__16584_17595);
var pno_17597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16591_17596,(0),null);
var pmask_17598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16591_17596,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17597,"$ = ",pmask_17598,";");


var G__17599 = seq__16581_17592;
var G__17600 = chunk__16582_17593;
var G__17601 = count__16583_17594;
var G__17602 = (i__16584_17595 + (1));
seq__16581_17592 = G__17599;
chunk__16582_17593 = G__17600;
count__16583_17594 = G__17601;
i__16584_17595 = G__17602;
continue;
} else {
var temp__5735__auto___17603 = cljs.core.seq(seq__16581_17592);
if(temp__5735__auto___17603){
var seq__16581_17604__$1 = temp__5735__auto___17603;
if(cljs.core.chunked_seq_QMARK_(seq__16581_17604__$1)){
var c__4609__auto___17605 = cljs.core.chunk_first(seq__16581_17604__$1);
var G__17606 = cljs.core.chunk_rest(seq__16581_17604__$1);
var G__17607 = c__4609__auto___17605;
var G__17608 = cljs.core.count(c__4609__auto___17605);
var G__17609 = (0);
seq__16581_17592 = G__17606;
chunk__16582_17593 = G__17607;
count__16583_17594 = G__17608;
i__16584_17595 = G__17609;
continue;
} else {
var vec__16596_17610 = cljs.core.first(seq__16581_17604__$1);
var pno_17611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16596_17610,(0),null);
var pmask_17612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16596_17610,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17611,"$ = ",pmask_17612,";");


var G__17613 = cljs.core.next(seq__16581_17604__$1);
var G__17614 = null;
var G__17615 = (0);
var G__17616 = (0);
seq__16581_17592 = G__17613;
chunk__16582_17593 = G__17614;
count__16583_17594 = G__17615;
i__16584_17595 = G__17616;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__16599){
var map__16600 = p__16599;
var map__16600__$1 = (((((!((map__16600 == null))))?(((((map__16600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16600.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16600):map__16600);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16600__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16600__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16600__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16600__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16600__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16602_17617 = cljs.core.seq(protocols);
var chunk__16603_17618 = null;
var count__16604_17619 = (0);
var i__16605_17620 = (0);
while(true){
if((i__16605_17620 < count__16604_17619)){
var protocol_17621 = chunk__16603_17618.cljs$core$IIndexed$_nth$arity$2(null,i__16605_17620);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17621)),"}");


var G__17622 = seq__16602_17617;
var G__17623 = chunk__16603_17618;
var G__17624 = count__16604_17619;
var G__17625 = (i__16605_17620 + (1));
seq__16602_17617 = G__17622;
chunk__16603_17618 = G__17623;
count__16604_17619 = G__17624;
i__16605_17620 = G__17625;
continue;
} else {
var temp__5735__auto___17626 = cljs.core.seq(seq__16602_17617);
if(temp__5735__auto___17626){
var seq__16602_17627__$1 = temp__5735__auto___17626;
if(cljs.core.chunked_seq_QMARK_(seq__16602_17627__$1)){
var c__4609__auto___17628 = cljs.core.chunk_first(seq__16602_17627__$1);
var G__17629 = cljs.core.chunk_rest(seq__16602_17627__$1);
var G__17630 = c__4609__auto___17628;
var G__17631 = cljs.core.count(c__4609__auto___17628);
var G__17632 = (0);
seq__16602_17617 = G__17629;
chunk__16603_17618 = G__17630;
count__16604_17619 = G__17631;
i__16605_17620 = G__17632;
continue;
} else {
var protocol_17633 = cljs.core.first(seq__16602_17627__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17633)),"}");


var G__17634 = cljs.core.next(seq__16602_17627__$1);
var G__17635 = null;
var G__17636 = (0);
var G__17637 = (0);
seq__16602_17617 = G__17634;
chunk__16603_17618 = G__17635;
count__16604_17619 = G__17636;
i__16605_17620 = G__17637;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16618_17639 = cljs.core.seq(fields__$1);
var chunk__16619_17640 = null;
var count__16620_17641 = (0);
var i__16621_17642 = (0);
while(true){
if((i__16621_17642 < count__16620_17641)){
var fld_17643 = chunk__16619_17640.cljs$core$IIndexed$_nth$arity$2(null,i__16621_17642);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17643," = ",fld_17643,";");


var G__17644 = seq__16618_17639;
var G__17645 = chunk__16619_17640;
var G__17646 = count__16620_17641;
var G__17647 = (i__16621_17642 + (1));
seq__16618_17639 = G__17644;
chunk__16619_17640 = G__17645;
count__16620_17641 = G__17646;
i__16621_17642 = G__17647;
continue;
} else {
var temp__5735__auto___17648 = cljs.core.seq(seq__16618_17639);
if(temp__5735__auto___17648){
var seq__16618_17649__$1 = temp__5735__auto___17648;
if(cljs.core.chunked_seq_QMARK_(seq__16618_17649__$1)){
var c__4609__auto___17650 = cljs.core.chunk_first(seq__16618_17649__$1);
var G__17654 = cljs.core.chunk_rest(seq__16618_17649__$1);
var G__17655 = c__4609__auto___17650;
var G__17656 = cljs.core.count(c__4609__auto___17650);
var G__17657 = (0);
seq__16618_17639 = G__17654;
chunk__16619_17640 = G__17655;
count__16620_17641 = G__17656;
i__16621_17642 = G__17657;
continue;
} else {
var fld_17658 = cljs.core.first(seq__16618_17649__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17658," = ",fld_17658,";");


var G__17659 = cljs.core.next(seq__16618_17649__$1);
var G__17660 = null;
var G__17661 = (0);
var G__17662 = (0);
seq__16618_17639 = G__17659;
chunk__16619_17640 = G__17660;
count__16620_17641 = G__17661;
i__16621_17642 = G__17662;
continue;
}
} else {
}
}
break;
}

var seq__16624_17663 = cljs.core.seq(pmasks);
var chunk__16625_17664 = null;
var count__16626_17665 = (0);
var i__16627_17666 = (0);
while(true){
if((i__16627_17666 < count__16626_17665)){
var vec__16634_17667 = chunk__16625_17664.cljs$core$IIndexed$_nth$arity$2(null,i__16627_17666);
var pno_17668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16634_17667,(0),null);
var pmask_17669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16634_17667,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17668,"$ = ",pmask_17669,";");


var G__17670 = seq__16624_17663;
var G__17671 = chunk__16625_17664;
var G__17672 = count__16626_17665;
var G__17673 = (i__16627_17666 + (1));
seq__16624_17663 = G__17670;
chunk__16625_17664 = G__17671;
count__16626_17665 = G__17672;
i__16627_17666 = G__17673;
continue;
} else {
var temp__5735__auto___17674 = cljs.core.seq(seq__16624_17663);
if(temp__5735__auto___17674){
var seq__16624_17675__$1 = temp__5735__auto___17674;
if(cljs.core.chunked_seq_QMARK_(seq__16624_17675__$1)){
var c__4609__auto___17676 = cljs.core.chunk_first(seq__16624_17675__$1);
var G__17677 = cljs.core.chunk_rest(seq__16624_17675__$1);
var G__17678 = c__4609__auto___17676;
var G__17679 = cljs.core.count(c__4609__auto___17676);
var G__17680 = (0);
seq__16624_17663 = G__17677;
chunk__16625_17664 = G__17678;
count__16626_17665 = G__17679;
i__16627_17666 = G__17680;
continue;
} else {
var vec__16637_17681 = cljs.core.first(seq__16624_17675__$1);
var pno_17682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16637_17681,(0),null);
var pmask_17683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16637_17681,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17682,"$ = ",pmask_17683,";");


var G__17684 = cljs.core.next(seq__16624_17675__$1);
var G__17685 = null;
var G__17686 = (0);
var G__17687 = (0);
seq__16624_17663 = G__17684;
chunk__16625_17664 = G__17685;
count__16626_17665 = G__17686;
i__16627_17666 = G__17687;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__16640){
var map__16641 = p__16640;
var map__16641__$1 = (((((!((map__16641 == null))))?(((((map__16641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16641):map__16641);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16641__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16641__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16641__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16641__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16641__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__16643){
var map__16644 = p__16643;
var map__16644__$1 = (((((!((map__16644 == null))))?(((((map__16644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16644):map__16644);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16644__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16644__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16644__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16644__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16644__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__16648 = clojure.string.trim(code);
var G__16649 = "/*";
return goog.string.startsWith(G__16648,G__16649);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__15758__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15758__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__16654 = cljs.core.seq(table);
var chunk__16655 = null;
var count__16656 = (0);
var i__16657 = (0);
while(true){
if((i__16657 < count__16656)){
var vec__16667 = chunk__16655.cljs$core$IIndexed$_nth$arity$2(null,i__16657);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16667,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16667,(1),null);
var ns_17689 = cljs.core.namespace(sym);
var name_17690 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__17692 = seq__16654;
var G__17693 = chunk__16655;
var G__17694 = count__16656;
var G__17695 = (i__16657 + (1));
seq__16654 = G__17692;
chunk__16655 = G__17693;
count__16656 = G__17694;
i__16657 = G__17695;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16654);
if(temp__5735__auto__){
var seq__16654__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16654__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16654__$1);
var G__17696 = cljs.core.chunk_rest(seq__16654__$1);
var G__17697 = c__4609__auto__;
var G__17698 = cljs.core.count(c__4609__auto__);
var G__17699 = (0);
seq__16654 = G__17696;
chunk__16655 = G__17697;
count__16656 = G__17698;
i__16657 = G__17699;
continue;
} else {
var vec__16675 = cljs.core.first(seq__16654__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16675,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16675,(1),null);
var ns_17700 = cljs.core.namespace(sym);
var name_17701 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__17702 = cljs.core.next(seq__16654__$1);
var G__17703 = null;
var G__17704 = (0);
var G__17705 = (0);
seq__16654 = G__17702;
chunk__16655 = G__17703;
count__16656 = G__17704;
i__16657 = G__17705;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__16686 = arguments.length;
switch (G__16686) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_17707 = cljs.core.first(ks);
var vec__16692_17708 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_17707);
var top_17709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16692_17708,(0),null);
var prefix_SINGLEQUOTE__17710 = vec__16692_17708;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_17707)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__17710) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_17709)) || (cljs.core.contains_QMARK_(known_externs,top_17709)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__17710)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_17709);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__17710)),";");
}
} else {
}

var m_17713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_17707);
if(cljs.core.empty_QMARK_(m_17713)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__17710,m_17713,top_level,known_externs);
}

var G__17714 = cljs.core.next(ks);
ks = G__17714;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

