goog.provide('quil.sketch');
quil.sketch._STAR_applet_STAR_ = null;
quil.sketch.current_applet = (function quil$sketch$current_applet(){
return quil.sketch._STAR_applet_STAR_;
});
quil.sketch.rendering_modes = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"java2d","java2d",166099237),(p5.prototype["JAVA2D"]),new cljs.core.Keyword(null,"p2d","p2d",-2106175755),(p5.prototype["P2D"]),new cljs.core.Keyword(null,"p3d","p3d",-850380194),(p5.prototype["P3D"]),new cljs.core.Keyword(null,"opengl","opengl",-614998103),(p5.prototype["OPENGL"])], null);
quil.sketch.resolve_renderer = (function quil$sketch$resolve_renderer(mode){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p3d","p3d",-850380194),mode)){
return (p5.prototype["WEBGL"]);
} else {
return quil.util.resolve_constant_key(mode,quil.sketch.rendering_modes);
}
});
quil.sketch.set_size = (function quil$sketch$set_size(applet,width,height){
var temp__5735__auto__ = applet.quil_canvas;
if(cljs.core.truth_(temp__5735__auto__)){
var el = temp__5735__auto__;
var inner_canvas = el.querySelector("canvas");
applet.resizeCanvas(width,height);

inner_canvas.setAttribute("width",width);

inner_canvas.setAttribute("height",height);

(inner_canvas.style["width"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(width),"px"].join(''));

(inner_canvas.style["height"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(height),"px"].join(''));

(applet.width = window.parseInt(goog.style.getComputedStyle(inner_canvas,"width")));

return (applet.height = window.parseInt(goog.style.getComputedStyle(inner_canvas,"height")));
} else {
return null;
}
});
quil.sketch.size = (function quil$sketch$size(var_args){
var G__10602 = arguments.length;
switch (G__10602) {
case 2:
return quil.sketch.size.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return quil.sketch.size.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(quil.sketch.size.cljs$core$IFn$_invoke$arity$2 = (function (width,height){
return quil.sketch.current_applet().createCanvas((width | (0)),(height | (0)));
}));

(quil.sketch.size.cljs$core$IFn$_invoke$arity$3 = (function (width,height,mode){
return quil.sketch.current_applet().createCanvas((width | (0)),(height | (0)),quil.sketch.resolve_renderer(mode));
}));

(quil.sketch.size.cljs$lang$maxFixedArity = 3);

quil.sketch.bind_handlers = (function quil$sketch$bind_handlers(prc,opts){
var seq__10606 = cljs.core.seq(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"keyPressed","keyPressed",1791025256),new cljs.core.Keyword(null,"mouseOut","mouseOut",-386669045),new cljs.core.Keyword(null,"mouseDragged","mouseDragged",129975181),new cljs.core.Keyword(null,"setup","setup",1987730512),new cljs.core.Keyword(null,"mouseWheel","mouseWheel",-1057803856),new cljs.core.Keyword(null,"keyReleased","keyReleased",541714964),new cljs.core.Keyword(null,"mouseClicked","mouseClicked",1764302965),new cljs.core.Keyword(null,"mouseReleased","mouseReleased",1116234838),new cljs.core.Keyword(null,"mousePressed","mousePressed",1776186454),new cljs.core.Keyword(null,"mouseMoved","mouseMoved",-1936954058),new cljs.core.Keyword(null,"mouseOver","mouseOver",-1334461930),new cljs.core.Keyword(null,"keyTyped","keyTyped",1437329399),new cljs.core.Keyword(null,"draw","draw",1358331674)],[new cljs.core.Keyword(null,"key-pressed","key-pressed",-757100364),new cljs.core.Keyword(null,"mouse-exited","mouse-exited",-483205244),new cljs.core.Keyword(null,"mouse-dragged","mouse-dragged",-1220073441),new cljs.core.Keyword(null,"setup","setup",1987730512),new cljs.core.Keyword(null,"mouse-wheel","mouse-wheel",1811662439),new cljs.core.Keyword(null,"key-released","key-released",215919828),new cljs.core.Keyword(null,"mouse-clicked","mouse-clicked",-199339421),new cljs.core.Keyword(null,"mouse-released","mouse-released",-664480061),new cljs.core.Keyword(null,"mouse-pressed","mouse-pressed",736955536),new cljs.core.Keyword(null,"mouse-moved","mouse-moved",-1918152310),new cljs.core.Keyword(null,"mouse-entered","mouse-entered",811350322),new cljs.core.Keyword(null,"key-typed","key-typed",-876037597),new cljs.core.Keyword(null,"draw","draw",1358331674)]));
var chunk__10607 = null;
var count__10608 = (0);
var i__10609 = (0);
while(true){
if((i__10609 < count__10608)){
var vec__10621 = chunk__10607.cljs$core$IIndexed$_nth$arity$2(null,i__10609);
var processing_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10621,(0),null);
var quil_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10621,(1),null);
var temp__5735__auto___10718 = (opts.cljs$core$IFn$_invoke$arity$1 ? opts.cljs$core$IFn$_invoke$arity$1(quil_name) : opts.call(null,quil_name));
if(cljs.core.truth_(temp__5735__auto___10718)){
var handler_10719 = temp__5735__auto___10718;
(prc[cljs.core.name(processing_name)] = ((function (seq__10606,chunk__10607,count__10608,i__10609,handler_10719,temp__5735__auto___10718,vec__10621,processing_name,quil_name){
return (function() { 
var G__10720__delegate = function (args){
var _STAR_applet_STAR__orig_val__10624 = quil.sketch._STAR_applet_STAR_;
var _STAR_applet_STAR__temp_val__10625 = prc;
(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__temp_val__10625);

try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(handler_10719,args);
}finally {(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__orig_val__10624);
}};
var G__10720 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10721__i = 0, G__10721__a = new Array(arguments.length -  0);
while (G__10721__i < G__10721__a.length) {G__10721__a[G__10721__i] = arguments[G__10721__i + 0]; ++G__10721__i;}
  args = new cljs.core.IndexedSeq(G__10721__a,0,null);
} 
return G__10720__delegate.call(this,args);};
G__10720.cljs$lang$maxFixedArity = 0;
G__10720.cljs$lang$applyTo = (function (arglist__10724){
var args = cljs.core.seq(arglist__10724);
return G__10720__delegate(args);
});
G__10720.cljs$core$IFn$_invoke$arity$variadic = G__10720__delegate;
return G__10720;
})()
;})(seq__10606,chunk__10607,count__10608,i__10609,handler_10719,temp__5735__auto___10718,vec__10621,processing_name,quil_name))
);
} else {
}


var G__10725 = seq__10606;
var G__10726 = chunk__10607;
var G__10727 = count__10608;
var G__10728 = (i__10609 + (1));
seq__10606 = G__10725;
chunk__10607 = G__10726;
count__10608 = G__10727;
i__10609 = G__10728;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10606);
if(temp__5735__auto__){
var seq__10606__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10606__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__10606__$1);
var G__10732 = cljs.core.chunk_rest(seq__10606__$1);
var G__10733 = c__4609__auto__;
var G__10734 = cljs.core.count(c__4609__auto__);
var G__10735 = (0);
seq__10606 = G__10732;
chunk__10607 = G__10733;
count__10608 = G__10734;
i__10609 = G__10735;
continue;
} else {
var vec__10627 = cljs.core.first(seq__10606__$1);
var processing_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10627,(0),null);
var quil_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10627,(1),null);
var temp__5735__auto___10736__$1 = (opts.cljs$core$IFn$_invoke$arity$1 ? opts.cljs$core$IFn$_invoke$arity$1(quil_name) : opts.call(null,quil_name));
if(cljs.core.truth_(temp__5735__auto___10736__$1)){
var handler_10737 = temp__5735__auto___10736__$1;
(prc[cljs.core.name(processing_name)] = ((function (seq__10606,chunk__10607,count__10608,i__10609,handler_10737,temp__5735__auto___10736__$1,vec__10627,processing_name,quil_name,seq__10606__$1,temp__5735__auto__){
return (function() { 
var G__10738__delegate = function (args){
var _STAR_applet_STAR__orig_val__10630 = quil.sketch._STAR_applet_STAR_;
var _STAR_applet_STAR__temp_val__10631 = prc;
(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__temp_val__10631);

try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(handler_10737,args);
}finally {(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__orig_val__10630);
}};
var G__10738 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10739__i = 0, G__10739__a = new Array(arguments.length -  0);
while (G__10739__i < G__10739__a.length) {G__10739__a[G__10739__i] = arguments[G__10739__i + 0]; ++G__10739__i;}
  args = new cljs.core.IndexedSeq(G__10739__a,0,null);
} 
return G__10738__delegate.call(this,args);};
G__10738.cljs$lang$maxFixedArity = 0;
G__10738.cljs$lang$applyTo = (function (arglist__10743){
var args = cljs.core.seq(arglist__10743);
return G__10738__delegate(args);
});
G__10738.cljs$core$IFn$_invoke$arity$variadic = G__10738__delegate;
return G__10738;
})()
;})(seq__10606,chunk__10607,count__10608,i__10609,handler_10737,temp__5735__auto___10736__$1,vec__10627,processing_name,quil_name,seq__10606__$1,temp__5735__auto__))
);
} else {
}


var G__10744 = cljs.core.next(seq__10606__$1);
var G__10745 = null;
var G__10746 = (0);
var G__10747 = (0);
seq__10606 = G__10744;
chunk__10607 = G__10745;
count__10608 = G__10746;
i__10609 = G__10747;
continue;
}
} else {
return null;
}
}
break;
}
});
quil.sketch.in_fullscreen_QMARK_ = (function quil$sketch$in_fullscreen_QMARK_(){
var or__4185__auto__ = document.fullscreenElement;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return document.mozFullScreenElement;
}
});
/**
 * Adds fullscreen support for the provided `p5` object.
 *   Fullscreen is enabled when the user presses `F11`. We turn
 *   the sketch `<canvas>` element to fullscreen storing the old size
 *   in an `atom`. When the user cancels fullscreen (`F11` or `Esc`)
 *   we resize the sketch back to the old size.
 */
quil.sketch.add_fullscreen_support = (function quil$sketch$add_fullscreen_support(applet){
var old_size = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var adjust_canvas_size = (function (){
if(cljs.core.truth_(quil.sketch.in_fullscreen_QMARK_())){
cljs.core.reset_BANG_(old_size,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [applet.width,applet.height], null));

return quil.sketch.set_size(applet,window.screen.width,window.screen.height);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(quil.sketch.set_size,applet,cljs.core.deref(old_size));
}
});
var G__10645_10752 = window;
var G__10646_10753 = goog.events.EventType.KEYDOWN;
var G__10647_10754 = (function (event){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(event.key,"F11")) && (cljs.core.not(quil.sketch.in_fullscreen_QMARK_())))){
event.preventDefault();

var canvas = applet.quil_canvas;
if(cljs.core.truth_(canvas.requestFullscreen)){
return canvas.requestFullscreen();
} else {
if(cljs.core.truth_(canvas.mozRequestFullScreen)){
return canvas.mozRequestFullScreen();
} else {
return console.warn("Fullscreen mode is not supported in current browser.");

}
}
} else {
return null;
}
});
goog.events.listen(G__10645_10752,G__10646_10753,G__10647_10754);

goog.events.listen(document,"fullscreenchange",adjust_canvas_size);

goog.events.listen(document,"mozfullscreenchange",adjust_canvas_size);

var G__10651 = document;
var G__10652 = "fullscreenerror";
var G__10653 = (function (p1__10641_SHARP_){
return console.error("Error while switching to/from fullscreen: ",p1__10641_SHARP_);
});
return goog.events.listen(G__10651,G__10652,G__10653);
});
quil.sketch.make_sketch = (function quil$sketch$make_sketch(options){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(300)], null)], null),(function (){var G__10657 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,cljs.core.cons(quil.middlewares.deprecated_options.deprecated_options,new cljs.core.Keyword(null,"middleware","middleware",1462115504).cljs$core$IFn$_invoke$arity$2(options,cljs.core.PersistentVector.EMPTY)));
var fexpr__10656 = (function (p1__10654_SHARP_){
return (p1__10654_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10654_SHARP_.cljs$core$IFn$_invoke$arity$1(options) : p1__10654_SHARP_.call(null,options));
});
return fexpr__10656(G__10657);
})()], 0));
var sketch_size = new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(opts);
var renderer = new cljs.core.Keyword(null,"renderer","renderer",336841071).cljs$core$IFn$_invoke$arity$1(opts);
var features = cljs.core.set(new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(opts));
var setup = (function (){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(quil.sketch.size,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(sketch_size,(cljs.core.truth_(renderer)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer], null):cljs.core.PersistentVector.EMPTY)));

if(cljs.core.truth_(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(opts))){
var fexpr__10659_10763 = new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(opts);
(fexpr__10659_10763.cljs$core$IFn$_invoke$arity$0 ? fexpr__10659_10763.cljs$core$IFn$_invoke$arity$0() : fexpr__10659_10763.call(null));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"setup","setup",1987730512).cljs$core$IFn$_invoke$arity$1(opts))){
var fexpr__10660 = new cljs.core.Keyword(null,"setup","setup",1987730512).cljs$core$IFn$_invoke$arity$1(opts);
return (fexpr__10660.cljs$core$IFn$_invoke$arity$0 ? fexpr__10660.cljs$core$IFn$_invoke$arity$0() : fexpr__10660.call(null));
} else {
return null;
}
});
var mouse_wheel = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"mouse-wheel","mouse-wheel",1811662439).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var wheel_handler = temp__5735__auto__;
return (function (evt){
var G__10661 = goog.object.get(evt,"delta");
return (wheel_handler.cljs$core$IFn$_invoke$arity$1 ? wheel_handler.cljs$core$IFn$_invoke$arity$1(G__10661) : wheel_handler.call(null,G__10661));
});
} else {
return null;
}
})();
var opts__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"setup","setup",1987730512),setup,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"mouse-wheel","mouse-wheel",1811662439),mouse_wheel], 0));
var sketch = (function (prc){
quil.sketch.bind_handlers(prc,opts__$1);

(prc.quil = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null));

return (prc.quil_internal_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(quil.util.initial_internal_state));
});
return sketch;
});
quil.sketch.destroy_previous_sketch = (function quil$sketch$destroy_previous_sketch(host_elem){
var temp__5735__auto__ = host_elem.processing_obj;
if(cljs.core.truth_(temp__5735__auto__)){
var proc_obj = temp__5735__auto__;
return proc_obj.remove();
} else {
return null;
}
});
quil.sketch.sketch = (function quil$sketch$sketch(var_args){
var args__4795__auto__ = [];
var len__4789__auto___10768 = arguments.length;
var i__4790__auto___10769 = (0);
while(true){
if((i__4790__auto___10769 < len__4789__auto___10768)){
args__4795__auto__.push((arguments[i__4790__auto___10769]));

var G__10770 = (i__4790__auto___10769 + (1));
i__4790__auto___10769 = G__10770;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return quil.sketch.sketch.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(quil.sketch.sketch.cljs$core$IFn$_invoke$arity$variadic = (function (opts){
var opts_map = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var host_elem = new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(opts_map);
var renderer = (function (){var or__4185__auto__ = new cljs.core.Keyword(null,"renderer","renderer",336841071).cljs$core$IFn$_invoke$arity$1(opts_map);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"p2d","p2d",-2106175755);
}
})();
var host_elem__$1 = ((typeof host_elem === 'string')?document.getElementById(host_elem):host_elem);
if(cljs.core.truth_(host_elem__$1)){
if(cljs.core.truth_(host_elem__$1.processing_context)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(renderer,host_elem__$1.processing_context)){
} else {
console.warn("WARNING: Using different context on one canvas!");
}
} else {
(host_elem__$1.processing_context = renderer);
}

quil.sketch.destroy_previous_sketch(host_elem__$1);

var proc_obj = (new p5(quil.sketch.make_sketch(opts_map),host_elem__$1));
(host_elem__$1.processing_obj = proc_obj);

(proc_obj.quil_canvas = host_elem__$1);

quil.sketch.add_fullscreen_support(proc_obj);

return proc_obj;
} else {
return console.error((cljs.core.truth_(new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(opts_map))?["ERROR: Cannot find host element: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(opts_map))].join(''):"ERROR: Cannot create sketch. :host is not specified or element not found."));
}
}));

(quil.sketch.sketch.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(quil.sketch.sketch.cljs$lang$applyTo = (function (seq10667){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10667));
}));

quil.sketch.sketch_init_list = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.List.EMPTY);
quil.sketch.empty_body_QMARK_ = (function quil$sketch$empty_body_QMARK_(){
var child = document.body.childNodes;
return (child.length <= (1));
});
quil.sketch.add_canvas = (function quil$sketch$add_canvas(canvas_id){
var canvas = document.createElement("canvas");
canvas.setAttribute("id",canvas_id);

return document.body.appendChild(canvas);
});
quil.sketch.init_sketches = (function quil$sketch$init_sketches(){
var add_elem_QMARK__10774 = quil.sketch.empty_body_QMARK_();
var seq__10680_10775 = cljs.core.seq(cljs.core.deref(quil.sketch.sketch_init_list));
var chunk__10681_10776 = null;
var count__10682_10777 = (0);
var i__10683_10778 = (0);
while(true){
if((i__10683_10778 < count__10682_10777)){
var sk_10779 = chunk__10681_10776.cljs$core$IIndexed$_nth$arity$2(null,i__10683_10778);
if(add_elem_QMARK__10774){
quil.sketch.add_canvas(new cljs.core.Keyword(null,"host-id","host-id",742376279).cljs$core$IFn$_invoke$arity$1(sk_10779));
} else {
}

var fexpr__10687_10780 = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(sk_10779);
(fexpr__10687_10780.cljs$core$IFn$_invoke$arity$0 ? fexpr__10687_10780.cljs$core$IFn$_invoke$arity$0() : fexpr__10687_10780.call(null));


var G__10781 = seq__10680_10775;
var G__10782 = chunk__10681_10776;
var G__10783 = count__10682_10777;
var G__10784 = (i__10683_10778 + (1));
seq__10680_10775 = G__10781;
chunk__10681_10776 = G__10782;
count__10682_10777 = G__10783;
i__10683_10778 = G__10784;
continue;
} else {
var temp__5735__auto___10787 = cljs.core.seq(seq__10680_10775);
if(temp__5735__auto___10787){
var seq__10680_10788__$1 = temp__5735__auto___10787;
if(cljs.core.chunked_seq_QMARK_(seq__10680_10788__$1)){
var c__4609__auto___10789 = cljs.core.chunk_first(seq__10680_10788__$1);
var G__10790 = cljs.core.chunk_rest(seq__10680_10788__$1);
var G__10791 = c__4609__auto___10789;
var G__10792 = cljs.core.count(c__4609__auto___10789);
var G__10793 = (0);
seq__10680_10775 = G__10790;
chunk__10681_10776 = G__10791;
count__10682_10777 = G__10792;
i__10683_10778 = G__10793;
continue;
} else {
var sk_10794 = cljs.core.first(seq__10680_10788__$1);
if(add_elem_QMARK__10774){
quil.sketch.add_canvas(new cljs.core.Keyword(null,"host-id","host-id",742376279).cljs$core$IFn$_invoke$arity$1(sk_10794));
} else {
}

var fexpr__10694_10797 = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(sk_10794);
(fexpr__10694_10797.cljs$core$IFn$_invoke$arity$0 ? fexpr__10694_10797.cljs$core$IFn$_invoke$arity$0() : fexpr__10694_10797.call(null));


var G__10801 = cljs.core.next(seq__10680_10788__$1);
var G__10802 = null;
var G__10803 = (0);
var G__10804 = (0);
seq__10680_10775 = G__10801;
chunk__10681_10776 = G__10802;
count__10682_10777 = G__10803;
i__10683_10778 = G__10804;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(quil.sketch.sketch_init_list,cljs.core.PersistentVector.EMPTY);
});
quil.sketch.add_sketch_to_init_list = (function quil$sketch$add_sketch_to_init_list(sk){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(quil.sketch.sketch_init_list,cljs.core.conj,sk);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(document.readyState,"complete")){
return quil.sketch.init_sketches();
} else {
return null;
}
});
goog.events.listenOnce(window,goog.events.EventType.LOAD,quil.sketch.init_sketches);
