goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__12772){
var vec__12773 = p__12772;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12773,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12773,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__12776 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__12779 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12779,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12779,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12779,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12779,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12779,(4),null);
var vec__12782 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12782,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12782,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12782,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12782,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12782,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__12789 = segmap;
var map__12789__$1 = (((((!((map__12789 == null))))?(((((map__12789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12789):map__12789);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12789__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12789__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12789__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12789__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12789__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__12799 = arguments.length;
switch (G__12799) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12824 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13739 = cljs.core.next(segs__$1);
var G__13740 = nrelseg;
var G__13741 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13739;
relseg__$1 = G__13740;
result__$1 = G__13741;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(1),null);
var G__13742 = (gline + (1));
var G__13743 = cljs.core.next(lines__$1);
var G__13744 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13745 = result__$1;
gline = G__13742;
lines__$1 = G__13743;
relseg = G__13744;
result = G__13745;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__12830 = segmap;
var map__12830__$1 = (((((!((map__12830 == null))))?(((((map__12830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12830):map__12830);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__12829_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12829_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__12844 = arguments.length;
switch (G__12844) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12850 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13751 = cljs.core.next(segs__$1);
var G__13752 = nrelseg;
var G__13753 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13751;
relseg__$1 = G__13752;
result__$1 = G__13753;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12850,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12850,(1),null);
var G__13754 = (gline + (1));
var G__13755 = cljs.core.next(lines__$1);
var G__13756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13757 = result__$1;
gline = G__13754;
lines__$1 = G__13755;
relseg = G__13756;
result = G__13757;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12870){
var vec__12871 = p__12870;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__12878){
var vec__12879 = p__12878;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12879,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12879,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12879,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12879,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12879,(4),null);
var seg = vec__12879;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12887){
var vec__12888 = p__12887;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12888,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12888,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12888,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12888,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12888,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__12897 = cljs.core.seq(infos);
var chunk__12898 = null;
var count__12899 = (0);
var i__12900 = (0);
while(true){
if((i__12900 < count__12899)){
var info = chunk__12898.cljs$core$IIndexed$_nth$arity$2(null,i__12900);
var segv_13766 = info__GT_segv(info,source_idx,line,col);
var gline_13767 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13768 = cljs.core.count(cljs.core.deref(lines));
if((gline_13767 > (lc_13768 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13766,gline_13767,lc_13768,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13767 - (lc_13768 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13766], null));
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13766,gline_13767,lc_13768,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13766,gline_13767,lc_13768,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13767], null),cljs.core.conj,segv_13766);
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13766,gline_13767,lc_13768,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13771 = seq__12897;
var G__13772 = chunk__12898;
var G__13773 = count__12899;
var G__13774 = (i__12900 + (1));
seq__12897 = G__13771;
chunk__12898 = G__13772;
count__12899 = G__13773;
i__12900 = G__13774;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12897);
if(temp__5735__auto__){
var seq__12897__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12897__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__12897__$1);
var G__13775 = cljs.core.chunk_rest(seq__12897__$1);
var G__13776 = c__4609__auto__;
var G__13777 = cljs.core.count(c__4609__auto__);
var G__13778 = (0);
seq__12897 = G__13775;
chunk__12898 = G__13776;
count__12899 = G__13777;
i__12900 = G__13778;
continue;
} else {
var info = cljs.core.first(seq__12897__$1);
var segv_13779 = info__GT_segv(info,source_idx,line,col);
var gline_13780 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13781 = cljs.core.count(cljs.core.deref(lines));
if((gline_13780 > (lc_13781 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13779,gline_13780,lc_13781,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13780 - (lc_13781 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13779], null));
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13779,gline_13780,lc_13781,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13779,gline_13780,lc_13781,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13780], null),cljs.core.conj,segv_13779);
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13779,gline_13780,lc_13781,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13785 = cljs.core.next(seq__12897__$1);
var G__13786 = null;
var G__13787 = (0);
var G__13788 = (0);
seq__12897 = G__13785;
chunk__12898 = G__13786;
count__12899 = G__13787;
i__12900 = G__13788;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__12912_13789 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__12913_13790 = null;
var count__12914_13791 = (0);
var i__12915_13792 = (0);
while(true){
if((i__12915_13792 < count__12914_13791)){
var vec__13100_13793 = chunk__12913_13790.cljs$core$IIndexed$_nth$arity$2(null,i__12915_13792);
var source_idx_13794 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13100_13793,(0),null);
var vec__13103_13795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13100_13793,(1),null);
var __13796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13103_13795,(0),null);
var lines_13797__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13103_13795,(1),null);
var seq__13106_13798 = cljs.core.seq(lines_13797__$1);
var chunk__13107_13799 = null;
var count__13108_13800 = (0);
var i__13109_13801 = (0);
while(true){
if((i__13109_13801 < count__13108_13800)){
var vec__13154_13802 = chunk__13107_13799.cljs$core$IIndexed$_nth$arity$2(null,i__13109_13801);
var line_13803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13154_13802,(0),null);
var cols_13804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13154_13802,(1),null);
var seq__13157_13805 = cljs.core.seq(cols_13804);
var chunk__13158_13806 = null;
var count__13159_13807 = (0);
var i__13160_13808 = (0);
while(true){
if((i__13160_13808 < count__13159_13807)){
var vec__13167_13819 = chunk__13158_13806.cljs$core$IIndexed$_nth$arity$2(null,i__13160_13808);
var col_13820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13167_13819,(0),null);
var infos_13821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13167_13819,(1),null);
encode_cols(infos_13821,source_idx_13794,line_13803,col_13820);


var G__13822 = seq__13157_13805;
var G__13823 = chunk__13158_13806;
var G__13824 = count__13159_13807;
var G__13825 = (i__13160_13808 + (1));
seq__13157_13805 = G__13822;
chunk__13158_13806 = G__13823;
count__13159_13807 = G__13824;
i__13160_13808 = G__13825;
continue;
} else {
var temp__5735__auto___13828 = cljs.core.seq(seq__13157_13805);
if(temp__5735__auto___13828){
var seq__13157_13829__$1 = temp__5735__auto___13828;
if(cljs.core.chunked_seq_QMARK_(seq__13157_13829__$1)){
var c__4609__auto___13830 = cljs.core.chunk_first(seq__13157_13829__$1);
var G__13831 = cljs.core.chunk_rest(seq__13157_13829__$1);
var G__13832 = c__4609__auto___13830;
var G__13833 = cljs.core.count(c__4609__auto___13830);
var G__13834 = (0);
seq__13157_13805 = G__13831;
chunk__13158_13806 = G__13832;
count__13159_13807 = G__13833;
i__13160_13808 = G__13834;
continue;
} else {
var vec__13170_13835 = cljs.core.first(seq__13157_13829__$1);
var col_13836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13170_13835,(0),null);
var infos_13837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13170_13835,(1),null);
encode_cols(infos_13837,source_idx_13794,line_13803,col_13836);


var G__13838 = cljs.core.next(seq__13157_13829__$1);
var G__13839 = null;
var G__13840 = (0);
var G__13841 = (0);
seq__13157_13805 = G__13838;
chunk__13158_13806 = G__13839;
count__13159_13807 = G__13840;
i__13160_13808 = G__13841;
continue;
}
} else {
}
}
break;
}


var G__13842 = seq__13106_13798;
var G__13843 = chunk__13107_13799;
var G__13844 = count__13108_13800;
var G__13845 = (i__13109_13801 + (1));
seq__13106_13798 = G__13842;
chunk__13107_13799 = G__13843;
count__13108_13800 = G__13844;
i__13109_13801 = G__13845;
continue;
} else {
var temp__5735__auto___13848 = cljs.core.seq(seq__13106_13798);
if(temp__5735__auto___13848){
var seq__13106_13849__$1 = temp__5735__auto___13848;
if(cljs.core.chunked_seq_QMARK_(seq__13106_13849__$1)){
var c__4609__auto___13850 = cljs.core.chunk_first(seq__13106_13849__$1);
var G__13851 = cljs.core.chunk_rest(seq__13106_13849__$1);
var G__13852 = c__4609__auto___13850;
var G__13853 = cljs.core.count(c__4609__auto___13850);
var G__13854 = (0);
seq__13106_13798 = G__13851;
chunk__13107_13799 = G__13852;
count__13108_13800 = G__13853;
i__13109_13801 = G__13854;
continue;
} else {
var vec__13173_13855 = cljs.core.first(seq__13106_13849__$1);
var line_13856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13173_13855,(0),null);
var cols_13857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13173_13855,(1),null);
var seq__13176_13858 = cljs.core.seq(cols_13857);
var chunk__13177_13859 = null;
var count__13178_13860 = (0);
var i__13179_13861 = (0);
while(true){
if((i__13179_13861 < count__13178_13860)){
var vec__13189_13862 = chunk__13177_13859.cljs$core$IIndexed$_nth$arity$2(null,i__13179_13861);
var col_13863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13189_13862,(0),null);
var infos_13864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13189_13862,(1),null);
encode_cols(infos_13864,source_idx_13794,line_13856,col_13863);


var G__13865 = seq__13176_13858;
var G__13866 = chunk__13177_13859;
var G__13867 = count__13178_13860;
var G__13868 = (i__13179_13861 + (1));
seq__13176_13858 = G__13865;
chunk__13177_13859 = G__13866;
count__13178_13860 = G__13867;
i__13179_13861 = G__13868;
continue;
} else {
var temp__5735__auto___13869__$1 = cljs.core.seq(seq__13176_13858);
if(temp__5735__auto___13869__$1){
var seq__13176_13870__$1 = temp__5735__auto___13869__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13176_13870__$1)){
var c__4609__auto___13871 = cljs.core.chunk_first(seq__13176_13870__$1);
var G__13872 = cljs.core.chunk_rest(seq__13176_13870__$1);
var G__13873 = c__4609__auto___13871;
var G__13874 = cljs.core.count(c__4609__auto___13871);
var G__13875 = (0);
seq__13176_13858 = G__13872;
chunk__13177_13859 = G__13873;
count__13178_13860 = G__13874;
i__13179_13861 = G__13875;
continue;
} else {
var vec__13193_13876 = cljs.core.first(seq__13176_13870__$1);
var col_13877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13193_13876,(0),null);
var infos_13878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13193_13876,(1),null);
encode_cols(infos_13878,source_idx_13794,line_13856,col_13877);


var G__13879 = cljs.core.next(seq__13176_13870__$1);
var G__13880 = null;
var G__13881 = (0);
var G__13882 = (0);
seq__13176_13858 = G__13879;
chunk__13177_13859 = G__13880;
count__13178_13860 = G__13881;
i__13179_13861 = G__13882;
continue;
}
} else {
}
}
break;
}


var G__13883 = cljs.core.next(seq__13106_13849__$1);
var G__13884 = null;
var G__13885 = (0);
var G__13886 = (0);
seq__13106_13798 = G__13883;
chunk__13107_13799 = G__13884;
count__13108_13800 = G__13885;
i__13109_13801 = G__13886;
continue;
}
} else {
}
}
break;
}


var G__13887 = seq__12912_13789;
var G__13888 = chunk__12913_13790;
var G__13889 = count__12914_13791;
var G__13890 = (i__12915_13792 + (1));
seq__12912_13789 = G__13887;
chunk__12913_13790 = G__13888;
count__12914_13791 = G__13889;
i__12915_13792 = G__13890;
continue;
} else {
var temp__5735__auto___13891 = cljs.core.seq(seq__12912_13789);
if(temp__5735__auto___13891){
var seq__12912_13892__$1 = temp__5735__auto___13891;
if(cljs.core.chunked_seq_QMARK_(seq__12912_13892__$1)){
var c__4609__auto___13893 = cljs.core.chunk_first(seq__12912_13892__$1);
var G__13894 = cljs.core.chunk_rest(seq__12912_13892__$1);
var G__13895 = c__4609__auto___13893;
var G__13896 = cljs.core.count(c__4609__auto___13893);
var G__13897 = (0);
seq__12912_13789 = G__13894;
chunk__12913_13790 = G__13895;
count__12914_13791 = G__13896;
i__12915_13792 = G__13897;
continue;
} else {
var vec__13196_13898 = cljs.core.first(seq__12912_13892__$1);
var source_idx_13899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13196_13898,(0),null);
var vec__13199_13900 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13196_13898,(1),null);
var __13901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13199_13900,(0),null);
var lines_13902__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13199_13900,(1),null);
var seq__13202_13903 = cljs.core.seq(lines_13902__$1);
var chunk__13203_13904 = null;
var count__13204_13905 = (0);
var i__13205_13906 = (0);
while(true){
if((i__13205_13906 < count__13204_13905)){
var vec__13245_13907 = chunk__13203_13904.cljs$core$IIndexed$_nth$arity$2(null,i__13205_13906);
var line_13908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13245_13907,(0),null);
var cols_13909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13245_13907,(1),null);
var seq__13248_13910 = cljs.core.seq(cols_13909);
var chunk__13249_13911 = null;
var count__13250_13912 = (0);
var i__13251_13913 = (0);
while(true){
if((i__13251_13913 < count__13250_13912)){
var vec__13258_13914 = chunk__13249_13911.cljs$core$IIndexed$_nth$arity$2(null,i__13251_13913);
var col_13915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258_13914,(0),null);
var infos_13916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258_13914,(1),null);
encode_cols(infos_13916,source_idx_13899,line_13908,col_13915);


var G__13918 = seq__13248_13910;
var G__13919 = chunk__13249_13911;
var G__13920 = count__13250_13912;
var G__13921 = (i__13251_13913 + (1));
seq__13248_13910 = G__13918;
chunk__13249_13911 = G__13919;
count__13250_13912 = G__13920;
i__13251_13913 = G__13921;
continue;
} else {
var temp__5735__auto___13923__$1 = cljs.core.seq(seq__13248_13910);
if(temp__5735__auto___13923__$1){
var seq__13248_13926__$1 = temp__5735__auto___13923__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13248_13926__$1)){
var c__4609__auto___13927 = cljs.core.chunk_first(seq__13248_13926__$1);
var G__13928 = cljs.core.chunk_rest(seq__13248_13926__$1);
var G__13929 = c__4609__auto___13927;
var G__13930 = cljs.core.count(c__4609__auto___13927);
var G__13931 = (0);
seq__13248_13910 = G__13928;
chunk__13249_13911 = G__13929;
count__13250_13912 = G__13930;
i__13251_13913 = G__13931;
continue;
} else {
var vec__13261_13946 = cljs.core.first(seq__13248_13926__$1);
var col_13947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13261_13946,(0),null);
var infos_13948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13261_13946,(1),null);
encode_cols(infos_13948,source_idx_13899,line_13908,col_13947);


var G__13952 = cljs.core.next(seq__13248_13926__$1);
var G__13953 = null;
var G__13954 = (0);
var G__13955 = (0);
seq__13248_13910 = G__13952;
chunk__13249_13911 = G__13953;
count__13250_13912 = G__13954;
i__13251_13913 = G__13955;
continue;
}
} else {
}
}
break;
}


var G__13956 = seq__13202_13903;
var G__13957 = chunk__13203_13904;
var G__13958 = count__13204_13905;
var G__13959 = (i__13205_13906 + (1));
seq__13202_13903 = G__13956;
chunk__13203_13904 = G__13957;
count__13204_13905 = G__13958;
i__13205_13906 = G__13959;
continue;
} else {
var temp__5735__auto___13960__$1 = cljs.core.seq(seq__13202_13903);
if(temp__5735__auto___13960__$1){
var seq__13202_13961__$1 = temp__5735__auto___13960__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13202_13961__$1)){
var c__4609__auto___13962 = cljs.core.chunk_first(seq__13202_13961__$1);
var G__13963 = cljs.core.chunk_rest(seq__13202_13961__$1);
var G__13964 = c__4609__auto___13962;
var G__13965 = cljs.core.count(c__4609__auto___13962);
var G__13966 = (0);
seq__13202_13903 = G__13963;
chunk__13203_13904 = G__13964;
count__13204_13905 = G__13965;
i__13205_13906 = G__13966;
continue;
} else {
var vec__13265_13967 = cljs.core.first(seq__13202_13961__$1);
var line_13968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13265_13967,(0),null);
var cols_13969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13265_13967,(1),null);
var seq__13268_13970 = cljs.core.seq(cols_13969);
var chunk__13269_13971 = null;
var count__13270_13972 = (0);
var i__13271_13973 = (0);
while(true){
if((i__13271_13973 < count__13270_13972)){
var vec__13278_13974 = chunk__13269_13971.cljs$core$IIndexed$_nth$arity$2(null,i__13271_13973);
var col_13975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13278_13974,(0),null);
var infos_13976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13278_13974,(1),null);
encode_cols(infos_13976,source_idx_13899,line_13968,col_13975);


var G__13977 = seq__13268_13970;
var G__13978 = chunk__13269_13971;
var G__13979 = count__13270_13972;
var G__13980 = (i__13271_13973 + (1));
seq__13268_13970 = G__13977;
chunk__13269_13971 = G__13978;
count__13270_13972 = G__13979;
i__13271_13973 = G__13980;
continue;
} else {
var temp__5735__auto___13983__$2 = cljs.core.seq(seq__13268_13970);
if(temp__5735__auto___13983__$2){
var seq__13268_13984__$1 = temp__5735__auto___13983__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13268_13984__$1)){
var c__4609__auto___13985 = cljs.core.chunk_first(seq__13268_13984__$1);
var G__13986 = cljs.core.chunk_rest(seq__13268_13984__$1);
var G__13987 = c__4609__auto___13985;
var G__13988 = cljs.core.count(c__4609__auto___13985);
var G__13989 = (0);
seq__13268_13970 = G__13986;
chunk__13269_13971 = G__13987;
count__13270_13972 = G__13988;
i__13271_13973 = G__13989;
continue;
} else {
var vec__13281_13990 = cljs.core.first(seq__13268_13984__$1);
var col_13991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13281_13990,(0),null);
var infos_13992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13281_13990,(1),null);
encode_cols(infos_13992,source_idx_13899,line_13968,col_13991);


var G__13993 = cljs.core.next(seq__13268_13984__$1);
var G__13994 = null;
var G__13995 = (0);
var G__13996 = (0);
seq__13268_13970 = G__13993;
chunk__13269_13971 = G__13994;
count__13270_13972 = G__13995;
i__13271_13973 = G__13996;
continue;
}
} else {
}
}
break;
}


var G__13997 = cljs.core.next(seq__13202_13961__$1);
var G__13998 = null;
var G__13999 = (0);
var G__14000 = (0);
seq__13202_13903 = G__13997;
chunk__13203_13904 = G__13998;
count__13204_13905 = G__13999;
i__13205_13906 = G__14000;
continue;
}
} else {
}
}
break;
}


var G__14001 = cljs.core.next(seq__12912_13892__$1);
var G__14002 = null;
var G__14003 = (0);
var G__14004 = (0);
seq__12912_13789 = G__14001;
chunk__12913_13790 = G__14002;
count__12914_13791 = G__14003;
i__12915_13792 = G__14004;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13285 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__12892_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12892_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__12893_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__12893_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12894_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__12894_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13290 = G__13285;
goog.object.set(G__13290,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__13290;
} else {
return G__13285;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13294 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13294,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13294,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13297 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(1),null);
var G__14015 = cljs.core.next(col_map_seq);
var G__14016 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13297,col,infos,vec__13294,line,col_map){
return (function (v,p__13300){
var map__13301 = p__13300;
var map__13301__$1 = (((((!((map__13301 == null))))?(((((map__13301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13301.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13301):map__13301);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13301__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13301__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13297,col,infos,vec__13294,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14015;
new_cols = G__14016;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14021 = cljs.core.next(line_map_seq);
var G__14022 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14021;
new_lines = G__14022;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13307_14023 = cljs.core.seq(reverse_map);
var chunk__13308_14024 = null;
var count__13309_14025 = (0);
var i__13310_14026 = (0);
while(true){
if((i__13310_14026 < count__13309_14025)){
var vec__13503_14027 = chunk__13308_14024.cljs$core$IIndexed$_nth$arity$2(null,i__13310_14026);
var line_14028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13503_14027,(0),null);
var columns_14029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13503_14027,(1),null);
var seq__13506_14030 = cljs.core.seq(columns_14029);
var chunk__13507_14031 = null;
var count__13508_14032 = (0);
var i__13509_14033 = (0);
while(true){
if((i__13509_14033 < count__13508_14032)){
var vec__13595_14035 = chunk__13507_14031.cljs$core$IIndexed$_nth$arity$2(null,i__13509_14033);
var column_14036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13595_14035,(0),null);
var column_info_14037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13595_14035,(1),null);
var seq__13598_14041 = cljs.core.seq(column_info_14037);
var chunk__13599_14042 = null;
var count__13600_14043 = (0);
var i__13601_14044 = (0);
while(true){
if((i__13601_14044 < count__13600_14043)){
var map__13614_14045 = chunk__13599_14042.cljs$core$IIndexed$_nth$arity$2(null,i__13601_14044);
var map__13614_14046__$1 = (((((!((map__13614_14045 == null))))?(((((map__13614_14045.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13614_14045.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13614_14045):map__13614_14045);
var gline_14047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13614_14046__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13614_14046__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13614_14046__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14047], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13598_14041,chunk__13599_14042,count__13600_14043,i__13601_14044,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13614_14045,map__13614_14046__$1,gline_14047,gcol_14048,name_14049,vec__13595_14035,column_14036,column_info_14037,vec__13503_14027,line_14028,columns_14029,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14048], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14028,new cljs.core.Keyword(null,"col","col",-1959363084),column_14036,new cljs.core.Keyword(null,"name","name",1843675177),name_14049], null));
});})(seq__13598_14041,chunk__13599_14042,count__13600_14043,i__13601_14044,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13614_14045,map__13614_14046__$1,gline_14047,gcol_14048,name_14049,vec__13595_14035,column_14036,column_info_14037,vec__13503_14027,line_14028,columns_14029,inverted))
,cljs.core.sorted_map()));


var G__14056 = seq__13598_14041;
var G__14057 = chunk__13599_14042;
var G__14058 = count__13600_14043;
var G__14059 = (i__13601_14044 + (1));
seq__13598_14041 = G__14056;
chunk__13599_14042 = G__14057;
count__13600_14043 = G__14058;
i__13601_14044 = G__14059;
continue;
} else {
var temp__5735__auto___14060 = cljs.core.seq(seq__13598_14041);
if(temp__5735__auto___14060){
var seq__13598_14061__$1 = temp__5735__auto___14060;
if(cljs.core.chunked_seq_QMARK_(seq__13598_14061__$1)){
var c__4609__auto___14062 = cljs.core.chunk_first(seq__13598_14061__$1);
var G__14063 = cljs.core.chunk_rest(seq__13598_14061__$1);
var G__14064 = c__4609__auto___14062;
var G__14065 = cljs.core.count(c__4609__auto___14062);
var G__14066 = (0);
seq__13598_14041 = G__14063;
chunk__13599_14042 = G__14064;
count__13600_14043 = G__14065;
i__13601_14044 = G__14066;
continue;
} else {
var map__13616_14067 = cljs.core.first(seq__13598_14061__$1);
var map__13616_14068__$1 = (((((!((map__13616_14067 == null))))?(((((map__13616_14067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13616_14067.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13616_14067):map__13616_14067);
var gline_14069 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13616_14068__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14070 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13616_14068__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13616_14068__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14069], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13598_14041,chunk__13599_14042,count__13600_14043,i__13601_14044,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13616_14067,map__13616_14068__$1,gline_14069,gcol_14070,name_14071,seq__13598_14061__$1,temp__5735__auto___14060,vec__13595_14035,column_14036,column_info_14037,vec__13503_14027,line_14028,columns_14029,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14070], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14028,new cljs.core.Keyword(null,"col","col",-1959363084),column_14036,new cljs.core.Keyword(null,"name","name",1843675177),name_14071], null));
});})(seq__13598_14041,chunk__13599_14042,count__13600_14043,i__13601_14044,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13616_14067,map__13616_14068__$1,gline_14069,gcol_14070,name_14071,seq__13598_14061__$1,temp__5735__auto___14060,vec__13595_14035,column_14036,column_info_14037,vec__13503_14027,line_14028,columns_14029,inverted))
,cljs.core.sorted_map()));


var G__14073 = cljs.core.next(seq__13598_14061__$1);
var G__14074 = null;
var G__14075 = (0);
var G__14076 = (0);
seq__13598_14041 = G__14073;
chunk__13599_14042 = G__14074;
count__13600_14043 = G__14075;
i__13601_14044 = G__14076;
continue;
}
} else {
}
}
break;
}


var G__14077 = seq__13506_14030;
var G__14078 = chunk__13507_14031;
var G__14079 = count__13508_14032;
var G__14080 = (i__13509_14033 + (1));
seq__13506_14030 = G__14077;
chunk__13507_14031 = G__14078;
count__13508_14032 = G__14079;
i__13509_14033 = G__14080;
continue;
} else {
var temp__5735__auto___14084 = cljs.core.seq(seq__13506_14030);
if(temp__5735__auto___14084){
var seq__13506_14085__$1 = temp__5735__auto___14084;
if(cljs.core.chunked_seq_QMARK_(seq__13506_14085__$1)){
var c__4609__auto___14086 = cljs.core.chunk_first(seq__13506_14085__$1);
var G__14087 = cljs.core.chunk_rest(seq__13506_14085__$1);
var G__14088 = c__4609__auto___14086;
var G__14089 = cljs.core.count(c__4609__auto___14086);
var G__14090 = (0);
seq__13506_14030 = G__14087;
chunk__13507_14031 = G__14088;
count__13508_14032 = G__14089;
i__13509_14033 = G__14090;
continue;
} else {
var vec__13618_14091 = cljs.core.first(seq__13506_14085__$1);
var column_14092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13618_14091,(0),null);
var column_info_14093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13618_14091,(1),null);
var seq__13621_14094 = cljs.core.seq(column_info_14093);
var chunk__13622_14095 = null;
var count__13623_14096 = (0);
var i__13624_14097 = (0);
while(true){
if((i__13624_14097 < count__13623_14096)){
var map__13633_14098 = chunk__13622_14095.cljs$core$IIndexed$_nth$arity$2(null,i__13624_14097);
var map__13633_14099__$1 = (((((!((map__13633_14098 == null))))?(((((map__13633_14098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13633_14098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13633_14098):map__13633_14098);
var gline_14100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13633_14099__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13633_14099__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13633_14099__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14100], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13621_14094,chunk__13622_14095,count__13623_14096,i__13624_14097,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13633_14098,map__13633_14099__$1,gline_14100,gcol_14101,name_14102,vec__13618_14091,column_14092,column_info_14093,seq__13506_14085__$1,temp__5735__auto___14084,vec__13503_14027,line_14028,columns_14029,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14101], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14028,new cljs.core.Keyword(null,"col","col",-1959363084),column_14092,new cljs.core.Keyword(null,"name","name",1843675177),name_14102], null));
});})(seq__13621_14094,chunk__13622_14095,count__13623_14096,i__13624_14097,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13633_14098,map__13633_14099__$1,gline_14100,gcol_14101,name_14102,vec__13618_14091,column_14092,column_info_14093,seq__13506_14085__$1,temp__5735__auto___14084,vec__13503_14027,line_14028,columns_14029,inverted))
,cljs.core.sorted_map()));


var G__14106 = seq__13621_14094;
var G__14107 = chunk__13622_14095;
var G__14108 = count__13623_14096;
var G__14109 = (i__13624_14097 + (1));
seq__13621_14094 = G__14106;
chunk__13622_14095 = G__14107;
count__13623_14096 = G__14108;
i__13624_14097 = G__14109;
continue;
} else {
var temp__5735__auto___14110__$1 = cljs.core.seq(seq__13621_14094);
if(temp__5735__auto___14110__$1){
var seq__13621_14111__$1 = temp__5735__auto___14110__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13621_14111__$1)){
var c__4609__auto___14112 = cljs.core.chunk_first(seq__13621_14111__$1);
var G__14113 = cljs.core.chunk_rest(seq__13621_14111__$1);
var G__14114 = c__4609__auto___14112;
var G__14115 = cljs.core.count(c__4609__auto___14112);
var G__14116 = (0);
seq__13621_14094 = G__14113;
chunk__13622_14095 = G__14114;
count__13623_14096 = G__14115;
i__13624_14097 = G__14116;
continue;
} else {
var map__13635_14117 = cljs.core.first(seq__13621_14111__$1);
var map__13635_14118__$1 = (((((!((map__13635_14117 == null))))?(((((map__13635_14117.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13635_14117.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13635_14117):map__13635_14117);
var gline_14119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13635_14118__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13635_14118__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13635_14118__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14119], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13621_14094,chunk__13622_14095,count__13623_14096,i__13624_14097,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13635_14117,map__13635_14118__$1,gline_14119,gcol_14120,name_14121,seq__13621_14111__$1,temp__5735__auto___14110__$1,vec__13618_14091,column_14092,column_info_14093,seq__13506_14085__$1,temp__5735__auto___14084,vec__13503_14027,line_14028,columns_14029,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14120], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14028,new cljs.core.Keyword(null,"col","col",-1959363084),column_14092,new cljs.core.Keyword(null,"name","name",1843675177),name_14121], null));
});})(seq__13621_14094,chunk__13622_14095,count__13623_14096,i__13624_14097,seq__13506_14030,chunk__13507_14031,count__13508_14032,i__13509_14033,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13635_14117,map__13635_14118__$1,gline_14119,gcol_14120,name_14121,seq__13621_14111__$1,temp__5735__auto___14110__$1,vec__13618_14091,column_14092,column_info_14093,seq__13506_14085__$1,temp__5735__auto___14084,vec__13503_14027,line_14028,columns_14029,inverted))
,cljs.core.sorted_map()));


var G__14124 = cljs.core.next(seq__13621_14111__$1);
var G__14125 = null;
var G__14126 = (0);
var G__14127 = (0);
seq__13621_14094 = G__14124;
chunk__13622_14095 = G__14125;
count__13623_14096 = G__14126;
i__13624_14097 = G__14127;
continue;
}
} else {
}
}
break;
}


var G__14128 = cljs.core.next(seq__13506_14085__$1);
var G__14129 = null;
var G__14130 = (0);
var G__14131 = (0);
seq__13506_14030 = G__14128;
chunk__13507_14031 = G__14129;
count__13508_14032 = G__14130;
i__13509_14033 = G__14131;
continue;
}
} else {
}
}
break;
}


var G__14132 = seq__13307_14023;
var G__14133 = chunk__13308_14024;
var G__14134 = count__13309_14025;
var G__14135 = (i__13310_14026 + (1));
seq__13307_14023 = G__14132;
chunk__13308_14024 = G__14133;
count__13309_14025 = G__14134;
i__13310_14026 = G__14135;
continue;
} else {
var temp__5735__auto___14136 = cljs.core.seq(seq__13307_14023);
if(temp__5735__auto___14136){
var seq__13307_14139__$1 = temp__5735__auto___14136;
if(cljs.core.chunked_seq_QMARK_(seq__13307_14139__$1)){
var c__4609__auto___14140 = cljs.core.chunk_first(seq__13307_14139__$1);
var G__14141 = cljs.core.chunk_rest(seq__13307_14139__$1);
var G__14142 = c__4609__auto___14140;
var G__14143 = cljs.core.count(c__4609__auto___14140);
var G__14144 = (0);
seq__13307_14023 = G__14141;
chunk__13308_14024 = G__14142;
count__13309_14025 = G__14143;
i__13310_14026 = G__14144;
continue;
} else {
var vec__13641_14145 = cljs.core.first(seq__13307_14139__$1);
var line_14146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13641_14145,(0),null);
var columns_14147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13641_14145,(1),null);
var seq__13646_14148 = cljs.core.seq(columns_14147);
var chunk__13647_14149 = null;
var count__13648_14150 = (0);
var i__13649_14151 = (0);
while(true){
if((i__13649_14151 < count__13648_14150)){
var vec__13696_14152 = chunk__13647_14149.cljs$core$IIndexed$_nth$arity$2(null,i__13649_14151);
var column_14153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13696_14152,(0),null);
var column_info_14154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13696_14152,(1),null);
var seq__13699_14155 = cljs.core.seq(column_info_14154);
var chunk__13700_14156 = null;
var count__13701_14157 = (0);
var i__13702_14158 = (0);
while(true){
if((i__13702_14158 < count__13701_14157)){
var map__13707_14163 = chunk__13700_14156.cljs$core$IIndexed$_nth$arity$2(null,i__13702_14158);
var map__13707_14164__$1 = (((((!((map__13707_14163 == null))))?(((((map__13707_14163.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13707_14163.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13707_14163):map__13707_14163);
var gline_14165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13707_14164__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13707_14164__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13707_14164__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14165], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13699_14155,chunk__13700_14156,count__13701_14157,i__13702_14158,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13707_14163,map__13707_14164__$1,gline_14165,gcol_14166,name_14167,vec__13696_14152,column_14153,column_info_14154,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14166], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14146,new cljs.core.Keyword(null,"col","col",-1959363084),column_14153,new cljs.core.Keyword(null,"name","name",1843675177),name_14167], null));
});})(seq__13699_14155,chunk__13700_14156,count__13701_14157,i__13702_14158,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13707_14163,map__13707_14164__$1,gline_14165,gcol_14166,name_14167,vec__13696_14152,column_14153,column_info_14154,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted))
,cljs.core.sorted_map()));


var G__14172 = seq__13699_14155;
var G__14173 = chunk__13700_14156;
var G__14174 = count__13701_14157;
var G__14175 = (i__13702_14158 + (1));
seq__13699_14155 = G__14172;
chunk__13700_14156 = G__14173;
count__13701_14157 = G__14174;
i__13702_14158 = G__14175;
continue;
} else {
var temp__5735__auto___14176__$1 = cljs.core.seq(seq__13699_14155);
if(temp__5735__auto___14176__$1){
var seq__13699_14177__$1 = temp__5735__auto___14176__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13699_14177__$1)){
var c__4609__auto___14178 = cljs.core.chunk_first(seq__13699_14177__$1);
var G__14179 = cljs.core.chunk_rest(seq__13699_14177__$1);
var G__14180 = c__4609__auto___14178;
var G__14181 = cljs.core.count(c__4609__auto___14178);
var G__14182 = (0);
seq__13699_14155 = G__14179;
chunk__13700_14156 = G__14180;
count__13701_14157 = G__14181;
i__13702_14158 = G__14182;
continue;
} else {
var map__13709_14183 = cljs.core.first(seq__13699_14177__$1);
var map__13709_14184__$1 = (((((!((map__13709_14183 == null))))?(((((map__13709_14183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13709_14183.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13709_14183):map__13709_14183);
var gline_14185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13709_14184__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13709_14184__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14187 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13709_14184__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14185], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13699_14155,chunk__13700_14156,count__13701_14157,i__13702_14158,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13709_14183,map__13709_14184__$1,gline_14185,gcol_14186,name_14187,seq__13699_14177__$1,temp__5735__auto___14176__$1,vec__13696_14152,column_14153,column_info_14154,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14186], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14146,new cljs.core.Keyword(null,"col","col",-1959363084),column_14153,new cljs.core.Keyword(null,"name","name",1843675177),name_14187], null));
});})(seq__13699_14155,chunk__13700_14156,count__13701_14157,i__13702_14158,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13709_14183,map__13709_14184__$1,gline_14185,gcol_14186,name_14187,seq__13699_14177__$1,temp__5735__auto___14176__$1,vec__13696_14152,column_14153,column_info_14154,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted))
,cljs.core.sorted_map()));


var G__14198 = cljs.core.next(seq__13699_14177__$1);
var G__14199 = null;
var G__14200 = (0);
var G__14201 = (0);
seq__13699_14155 = G__14198;
chunk__13700_14156 = G__14199;
count__13701_14157 = G__14200;
i__13702_14158 = G__14201;
continue;
}
} else {
}
}
break;
}


var G__14202 = seq__13646_14148;
var G__14203 = chunk__13647_14149;
var G__14204 = count__13648_14150;
var G__14205 = (i__13649_14151 + (1));
seq__13646_14148 = G__14202;
chunk__13647_14149 = G__14203;
count__13648_14150 = G__14204;
i__13649_14151 = G__14205;
continue;
} else {
var temp__5735__auto___14206__$1 = cljs.core.seq(seq__13646_14148);
if(temp__5735__auto___14206__$1){
var seq__13646_14207__$1 = temp__5735__auto___14206__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13646_14207__$1)){
var c__4609__auto___14208 = cljs.core.chunk_first(seq__13646_14207__$1);
var G__14209 = cljs.core.chunk_rest(seq__13646_14207__$1);
var G__14210 = c__4609__auto___14208;
var G__14211 = cljs.core.count(c__4609__auto___14208);
var G__14212 = (0);
seq__13646_14148 = G__14209;
chunk__13647_14149 = G__14210;
count__13648_14150 = G__14211;
i__13649_14151 = G__14212;
continue;
} else {
var vec__13711_14213 = cljs.core.first(seq__13646_14207__$1);
var column_14214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13711_14213,(0),null);
var column_info_14215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13711_14213,(1),null);
var seq__13714_14216 = cljs.core.seq(column_info_14215);
var chunk__13715_14217 = null;
var count__13716_14218 = (0);
var i__13717_14219 = (0);
while(true){
if((i__13717_14219 < count__13716_14218)){
var map__13722_14220 = chunk__13715_14217.cljs$core$IIndexed$_nth$arity$2(null,i__13717_14219);
var map__13722_14221__$1 = (((((!((map__13722_14220 == null))))?(((((map__13722_14220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13722_14220.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13722_14220):map__13722_14220);
var gline_14222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13722_14221__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13722_14221__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14224 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13722_14221__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14222], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13714_14216,chunk__13715_14217,count__13716_14218,i__13717_14219,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13722_14220,map__13722_14221__$1,gline_14222,gcol_14223,name_14224,vec__13711_14213,column_14214,column_info_14215,seq__13646_14207__$1,temp__5735__auto___14206__$1,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14223], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14146,new cljs.core.Keyword(null,"col","col",-1959363084),column_14214,new cljs.core.Keyword(null,"name","name",1843675177),name_14224], null));
});})(seq__13714_14216,chunk__13715_14217,count__13716_14218,i__13717_14219,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13722_14220,map__13722_14221__$1,gline_14222,gcol_14223,name_14224,vec__13711_14213,column_14214,column_info_14215,seq__13646_14207__$1,temp__5735__auto___14206__$1,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted))
,cljs.core.sorted_map()));


var G__14230 = seq__13714_14216;
var G__14231 = chunk__13715_14217;
var G__14232 = count__13716_14218;
var G__14233 = (i__13717_14219 + (1));
seq__13714_14216 = G__14230;
chunk__13715_14217 = G__14231;
count__13716_14218 = G__14232;
i__13717_14219 = G__14233;
continue;
} else {
var temp__5735__auto___14239__$2 = cljs.core.seq(seq__13714_14216);
if(temp__5735__auto___14239__$2){
var seq__13714_14240__$1 = temp__5735__auto___14239__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13714_14240__$1)){
var c__4609__auto___14241 = cljs.core.chunk_first(seq__13714_14240__$1);
var G__14242 = cljs.core.chunk_rest(seq__13714_14240__$1);
var G__14243 = c__4609__auto___14241;
var G__14244 = cljs.core.count(c__4609__auto___14241);
var G__14245 = (0);
seq__13714_14216 = G__14242;
chunk__13715_14217 = G__14243;
count__13716_14218 = G__14244;
i__13717_14219 = G__14245;
continue;
} else {
var map__13726_14246 = cljs.core.first(seq__13714_14240__$1);
var map__13726_14247__$1 = (((((!((map__13726_14246 == null))))?(((((map__13726_14246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13726_14246.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13726_14246):map__13726_14246);
var gline_14248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13726_14247__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13726_14247__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13726_14247__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14248], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13714_14216,chunk__13715_14217,count__13716_14218,i__13717_14219,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13726_14246,map__13726_14247__$1,gline_14248,gcol_14249,name_14250,seq__13714_14240__$1,temp__5735__auto___14239__$2,vec__13711_14213,column_14214,column_info_14215,seq__13646_14207__$1,temp__5735__auto___14206__$1,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14249], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14146,new cljs.core.Keyword(null,"col","col",-1959363084),column_14214,new cljs.core.Keyword(null,"name","name",1843675177),name_14250], null));
});})(seq__13714_14216,chunk__13715_14217,count__13716_14218,i__13717_14219,seq__13646_14148,chunk__13647_14149,count__13648_14150,i__13649_14151,seq__13307_14023,chunk__13308_14024,count__13309_14025,i__13310_14026,map__13726_14246,map__13726_14247__$1,gline_14248,gcol_14249,name_14250,seq__13714_14240__$1,temp__5735__auto___14239__$2,vec__13711_14213,column_14214,column_info_14215,seq__13646_14207__$1,temp__5735__auto___14206__$1,vec__13641_14145,line_14146,columns_14147,seq__13307_14139__$1,temp__5735__auto___14136,inverted))
,cljs.core.sorted_map()));


var G__14254 = cljs.core.next(seq__13714_14240__$1);
var G__14255 = null;
var G__14256 = (0);
var G__14257 = (0);
seq__13714_14216 = G__14254;
chunk__13715_14217 = G__14255;
count__13716_14218 = G__14256;
i__13717_14219 = G__14257;
continue;
}
} else {
}
}
break;
}


var G__14258 = cljs.core.next(seq__13646_14207__$1);
var G__14259 = null;
var G__14260 = (0);
var G__14261 = (0);
seq__13646_14148 = G__14258;
chunk__13647_14149 = G__14259;
count__13648_14150 = G__14260;
i__13649_14151 = G__14261;
continue;
}
} else {
}
}
break;
}


var G__14263 = cljs.core.next(seq__13307_14139__$1);
var G__14264 = null;
var G__14265 = (0);
var G__14266 = (0);
seq__13307_14023 = G__14263;
chunk__13308_14024 = G__14264;
count__13309_14025 = G__14265;
i__13310_14026 = G__14266;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
