goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__14735 = s;
var map__14735__$1 = (((((!((map__14735 == null))))?(((((map__14735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14735):map__14735);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14735__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14735__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__14738 = info;
var map__14739 = G__14738;
var map__14739__$1 = (((((!((map__14739 == null))))?(((((map__14739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14739):map__14739);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14739__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__14738__$1 = G__14738;
while(true){
var d__$2 = d__$1;
var map__14743 = G__14738__$1;
var map__14743__$1 = (((((!((map__14743 == null))))?(((((map__14743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14743):map__14743);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14743__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__15580 = (d__$2 + (1));
var G__15581 = shadow__$2;
d__$1 = G__15580;
G__14738__$1 = G__15581;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__14745){
var map__14746 = p__14745;
var map__14746__$1 = (((((!((map__14746 == null))))?(((((map__14746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14746.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14746):map__14746);
var name_var = map__14746__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14746__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14746__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__14748 = info;
var map__14748__$1 = (((((!((map__14748 == null))))?(((((map__14748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14748):map__14748);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14748__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14748__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__14750 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__14750) : cljs.compiler.munge.call(null,G__14750));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__14802 = arguments.length;
switch (G__14802) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__14803 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__14803.cljs$core$IFn$_invoke$arity$1 ? fexpr__14803.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__14803.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__14804 = cp;
switch (G__14804) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__14805_15584 = cljs.core.seq(s);
var chunk__14806_15585 = null;
var count__14807_15586 = (0);
var i__14808_15587 = (0);
while(true){
if((i__14808_15587 < count__14807_15586)){
var c_15588 = chunk__14806_15585.cljs$core$IIndexed$_nth$arity$2(null,i__14808_15587);
sb.append(cljs.compiler.escape_char(c_15588));


var G__15589 = seq__14805_15584;
var G__15590 = chunk__14806_15585;
var G__15591 = count__14807_15586;
var G__15592 = (i__14808_15587 + (1));
seq__14805_15584 = G__15589;
chunk__14806_15585 = G__15590;
count__14807_15586 = G__15591;
i__14808_15587 = G__15592;
continue;
} else {
var temp__5735__auto___15593 = cljs.core.seq(seq__14805_15584);
if(temp__5735__auto___15593){
var seq__14805_15594__$1 = temp__5735__auto___15593;
if(cljs.core.chunked_seq_QMARK_(seq__14805_15594__$1)){
var c__4609__auto___15595 = cljs.core.chunk_first(seq__14805_15594__$1);
var G__15596 = cljs.core.chunk_rest(seq__14805_15594__$1);
var G__15597 = c__4609__auto___15595;
var G__15598 = cljs.core.count(c__4609__auto___15595);
var G__15599 = (0);
seq__14805_15584 = G__15596;
chunk__14806_15585 = G__15597;
count__14807_15586 = G__15598;
i__14808_15587 = G__15599;
continue;
} else {
var c_15600 = cljs.core.first(seq__14805_15594__$1);
sb.append(cljs.compiler.escape_char(c_15600));


var G__15601 = cljs.core.next(seq__14805_15594__$1);
var G__15602 = null;
var G__15603 = (0);
var G__15604 = (0);
seq__14805_15584 = G__15601;
chunk__14806_15585 = G__15602;
count__14807_15586 = G__15603;
i__14808_15587 = G__15604;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14809 = cljs.core.get_global_hierarchy;
return (fexpr__14809.cljs$core$IFn$_invoke$arity$0 ? fexpr__14809.cljs$core$IFn$_invoke$arity$0() : fexpr__14809.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__14810_15605 = ast;
var map__14810_15606__$1 = (((((!((map__14810_15605 == null))))?(((((map__14810_15605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14810_15605.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14810_15605):map__14810_15605);
var env_15607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14810_15606__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_15607))){
var map__14812_15608 = env_15607;
var map__14812_15609__$1 = (((((!((map__14812_15608 == null))))?(((((map__14812_15608.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14812_15608.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14812_15608):map__14812_15608);
var line_15610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14812_15609__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_15611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14812_15609__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__14814 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__14816 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__14815 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__14815.cljs$core$IFn$_invoke$arity$1 ? fexpr__14815.cljs$core$IFn$_invoke$arity$1(G__14816) : fexpr__14815.call(null,G__14816));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14814,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__14814;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_15610 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_15611)?(column_15611 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__14826 = arguments.length;
switch (G__14826) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___15613 = arguments.length;
var i__4790__auto___15614 = (0);
while(true){
if((i__4790__auto___15614 < len__4789__auto___15613)){
args_arr__4810__auto__.push((arguments[i__4790__auto___15614]));

var G__15615 = (i__4790__auto___15614 + (1));
i__4790__auto___15614 = G__15615;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_15616 = (function (){var G__14827 = a;
if((!(typeof a === 'string'))){
return G__14827.toString();
} else {
return G__14827;
}
})();
var temp__5739__auto___15617 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___15617 == null)){
} else {
var sm_data_15618 = temp__5739__auto___15617;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_15618,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__14817_SHARP_){
return (p1__14817_SHARP_ + s_15616.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_15616], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__14831 = cljs.core.seq(xs);
var chunk__14832 = null;
var count__14833 = (0);
var i__14834 = (0);
while(true){
if((i__14834 < count__14833)){
var x = chunk__14832.cljs$core$IIndexed$_nth$arity$2(null,i__14834);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__15619 = seq__14831;
var G__15620 = chunk__14832;
var G__15621 = count__14833;
var G__15622 = (i__14834 + (1));
seq__14831 = G__15619;
chunk__14832 = G__15620;
count__14833 = G__15621;
i__14834 = G__15622;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__14831);
if(temp__5735__auto__){
var seq__14831__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14831__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__14831__$1);
var G__15623 = cljs.core.chunk_rest(seq__14831__$1);
var G__15624 = c__4609__auto__;
var G__15625 = cljs.core.count(c__4609__auto__);
var G__15626 = (0);
seq__14831 = G__15623;
chunk__14832 = G__15624;
count__14833 = G__15625;
i__14834 = G__15626;
continue;
} else {
var x = cljs.core.first(seq__14831__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__15627 = cljs.core.next(seq__14831__$1);
var G__15628 = null;
var G__15629 = (0);
var G__15630 = (0);
seq__14831 = G__15627;
chunk__14832 = G__15628;
count__14833 = G__15629;
i__14834 = G__15630;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq14820){
var G__14821 = cljs.core.first(seq14820);
var seq14820__$1 = cljs.core.next(seq14820);
var G__14822 = cljs.core.first(seq14820__$1);
var seq14820__$2 = cljs.core.next(seq14820__$1);
var G__14823 = cljs.core.first(seq14820__$2);
var seq14820__$3 = cljs.core.next(seq14820__$2);
var G__14824 = cljs.core.first(seq14820__$3);
var seq14820__$4 = cljs.core.next(seq14820__$3);
var G__14825 = cljs.core.first(seq14820__$4);
var seq14820__$5 = cljs.core.next(seq14820__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14821,G__14822,G__14823,G__14824,G__14825,seq14820__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__14837){
var map__14838 = p__14837;
var map__14838__$1 = (((((!((map__14838 == null))))?(((((map__14838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14838):map__14838);
var m = map__14838__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14838__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__14847 = arguments.length;
switch (G__14847) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___15632 = arguments.length;
var i__4790__auto___15633 = (0);
while(true){
if((i__4790__auto___15633 < len__4789__auto___15632)){
args_arr__4810__auto__.push((arguments[i__4790__auto___15633]));

var G__15634 = (i__4790__auto___15633 + (1));
i__4790__auto___15633 = G__15634;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__14863_15635 = cljs.core.seq(xs);
var chunk__14864_15636 = null;
var count__14865_15637 = (0);
var i__14866_15638 = (0);
while(true){
if((i__14866_15638 < count__14865_15637)){
var x_15639 = chunk__14864_15636.cljs$core$IIndexed$_nth$arity$2(null,i__14866_15638);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_15639);


var G__15640 = seq__14863_15635;
var G__15641 = chunk__14864_15636;
var G__15642 = count__14865_15637;
var G__15643 = (i__14866_15638 + (1));
seq__14863_15635 = G__15640;
chunk__14864_15636 = G__15641;
count__14865_15637 = G__15642;
i__14866_15638 = G__15643;
continue;
} else {
var temp__5735__auto___15644 = cljs.core.seq(seq__14863_15635);
if(temp__5735__auto___15644){
var seq__14863_15645__$1 = temp__5735__auto___15644;
if(cljs.core.chunked_seq_QMARK_(seq__14863_15645__$1)){
var c__4609__auto___15646 = cljs.core.chunk_first(seq__14863_15645__$1);
var G__15647 = cljs.core.chunk_rest(seq__14863_15645__$1);
var G__15648 = c__4609__auto___15646;
var G__15649 = cljs.core.count(c__4609__auto___15646);
var G__15650 = (0);
seq__14863_15635 = G__15647;
chunk__14864_15636 = G__15648;
count__14865_15637 = G__15649;
i__14866_15638 = G__15650;
continue;
} else {
var x_15651 = cljs.core.first(seq__14863_15645__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_15651);


var G__15652 = cljs.core.next(seq__14863_15645__$1);
var G__15653 = null;
var G__15654 = (0);
var G__15655 = (0);
seq__14863_15635 = G__15652;
chunk__14864_15636 = G__15653;
count__14865_15637 = G__15654;
i__14866_15638 = G__15655;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq14841){
var G__14842 = cljs.core.first(seq14841);
var seq14841__$1 = cljs.core.next(seq14841);
var G__14843 = cljs.core.first(seq14841__$1);
var seq14841__$2 = cljs.core.next(seq14841__$1);
var G__14844 = cljs.core.first(seq14841__$2);
var seq14841__$3 = cljs.core.next(seq14841__$2);
var G__14845 = cljs.core.first(seq14841__$3);
var seq14841__$4 = cljs.core.next(seq14841__$3);
var G__14846 = cljs.core.first(seq14841__$4);
var seq14841__$5 = cljs.core.next(seq14841__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14842,G__14843,G__14844,G__14845,G__14846,seq14841__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__14867_15659 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__14868_15660 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__14869_15661 = true;
var _STAR_print_fn_STAR__temp_val__14870_15662 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__14869_15661);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__14870_15662);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__14868_15660);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__14867_15659);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14871 = cljs.core.get_global_hierarchy;
return (fexpr__14871.cljs$core$IFn$_invoke$arity$0 ? fexpr__14871.cljs$core$IFn$_invoke$arity$0() : fexpr__14871.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__14872 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14872,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14872,(1),null);
var G__14875 = ns;
var G__14876 = name;
var G__14877 = (function (){
var G__14878 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__14878) : cljs.compiler.emit_constant.call(null,G__14878));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__14875,G__14876,G__14877) : cljs.compiler.emit_record_value.call(null,G__14875,G__14876,G__14877));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__14879 = cljs.core.keys(x);
var G__14880 = cljs.core.vals(x);
var G__14881 = cljs.compiler.emit_constants_comma_sep;
var G__14882 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__14879,G__14880,G__14881,G__14882) : cljs.compiler.emit_map.call(null,G__14879,G__14880,G__14881,G__14882));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__14883 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__14884 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__14883,G__14884) : cljs.compiler.emit_with_meta.call(null,G__14883,G__14884));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__14888 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14888,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14888,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14888,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__14895 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__14895) : x.call(null,G__14895));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__14896 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__14896) : x.call(null,G__14896));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__14898 = items;
var G__14899 = (function (p1__14897_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__14897_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__14898,G__14899) : cljs.compiler.emit_js_object.call(null,G__14898,G__14899));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__14907){
var map__14908 = p__14907;
var map__14908__$1 = (((((!((map__14908 == null))))?(((((map__14908.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14908.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14908):map__14908);
var ast = map__14908__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14908__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14908__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14908__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__14910 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__14910__$1 = (((((!((map__14910 == null))))?(((((map__14910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14910.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14910):map__14910);
var cenv = map__14910__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14910__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__14912 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__14915 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__14915) : cljs.compiler.es5_GT__EQ_.call(null,G__14915));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__14912,cljs.analyzer.es5_allowed);
} else {
return G__14912;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__14916 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__14916,reserved);
} else {
return G__14916;
}
})();
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__14917_15665 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__14917_15666__$1 = (((G__14917_15665 instanceof cljs.core.Keyword))?G__14917_15665.fqn:null);
switch (G__14917_15666__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__14918){
var map__14919 = p__14918;
var map__14919__$1 = (((((!((map__14919 == null))))?(((((map__14919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14919.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14919):map__14919);
var arg = map__14919__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14919__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14919__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14919__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14919__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__14921 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__14921__$1 = (((((!((map__14921 == null))))?(((((map__14921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14921):map__14921);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14921__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__14923){
var map__14924 = p__14923;
var map__14924__$1 = (((((!((map__14924 == null))))?(((((map__14924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14924):map__14924);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14924__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14924__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14924__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__14926_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__14926_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__14927 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14927) : comma_sep.call(null,G__14927));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__14928 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14928) : comma_sep.call(null,G__14928));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__14929){
var map__14930 = p__14929;
var map__14930__$1 = (((((!((map__14930 == null))))?(((((map__14930.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14930.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14930):map__14930);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14930__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14930__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14930__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__14932){
var map__14933 = p__14932;
var map__14933__$1 = (((((!((map__14933 == null))))?(((((map__14933.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14933.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14933):map__14933);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14933__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14933__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__14936_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__14936_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__14938 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14938) : comma_sep.call(null,G__14938));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__14939){
var map__14940 = p__14939;
var map__14940__$1 = (((((!((map__14940 == null))))?(((((map__14940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14940.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14940):map__14940);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14940__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14940__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___15668 = cljs.core.seq(items);
if(temp__5735__auto___15668){
var items_15669__$1 = temp__5735__auto___15668;
var vec__14951_15670 = items_15669__$1;
var seq__14952_15671 = cljs.core.seq(vec__14951_15670);
var first__14953_15672 = cljs.core.first(seq__14952_15671);
var seq__14952_15673__$1 = cljs.core.next(seq__14952_15671);
var vec__14954_15674 = first__14953_15672;
var k_15675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14954_15674,(0),null);
var v_15676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14954_15674,(1),null);
var r_15677 = seq__14952_15673__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_15675),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_15676) : emit_js_object_val.call(null,v_15676)));

var seq__14957_15678 = cljs.core.seq(r_15677);
var chunk__14958_15679 = null;
var count__14959_15680 = (0);
var i__14960_15681 = (0);
while(true){
if((i__14960_15681 < count__14959_15680)){
var vec__14983_15682 = chunk__14958_15679.cljs$core$IIndexed$_nth$arity$2(null,i__14960_15681);
var k_15683__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14983_15682,(0),null);
var v_15684__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14983_15682,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_15683__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_15684__$1) : emit_js_object_val.call(null,v_15684__$1)));


var G__15685 = seq__14957_15678;
var G__15686 = chunk__14958_15679;
var G__15687 = count__14959_15680;
var G__15688 = (i__14960_15681 + (1));
seq__14957_15678 = G__15685;
chunk__14958_15679 = G__15686;
count__14959_15680 = G__15687;
i__14960_15681 = G__15688;
continue;
} else {
var temp__5735__auto___15689__$1 = cljs.core.seq(seq__14957_15678);
if(temp__5735__auto___15689__$1){
var seq__14957_15690__$1 = temp__5735__auto___15689__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14957_15690__$1)){
var c__4609__auto___15691 = cljs.core.chunk_first(seq__14957_15690__$1);
var G__15692 = cljs.core.chunk_rest(seq__14957_15690__$1);
var G__15693 = c__4609__auto___15691;
var G__15694 = cljs.core.count(c__4609__auto___15691);
var G__15695 = (0);
seq__14957_15678 = G__15692;
chunk__14958_15679 = G__15693;
count__14959_15680 = G__15694;
i__14960_15681 = G__15695;
continue;
} else {
var vec__14986_15696 = cljs.core.first(seq__14957_15690__$1);
var k_15697__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14986_15696,(0),null);
var v_15698__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14986_15696,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_15697__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_15698__$1) : emit_js_object_val.call(null,v_15698__$1)));


var G__15699 = cljs.core.next(seq__14957_15690__$1);
var G__15700 = null;
var G__15701 = (0);
var G__15702 = (0);
seq__14957_15678 = G__15699;
chunk__14958_15679 = G__15700;
count__14959_15680 = G__15701;
i__14960_15681 = G__15702;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__14989){
var map__14990 = p__14989;
var map__14990__$1 = (((((!((map__14990 == null))))?(((((map__14990.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14990.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14990):map__14990);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14990__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14990__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14990__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__14992){
var map__14993 = p__14992;
var map__14993__$1 = (((((!((map__14993 == null))))?(((((map__14993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14993.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14993):map__14993);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14993__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14993__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__14995){
var map__14996 = p__14995;
var map__14996__$1 = (((((!((map__14996 == null))))?(((((map__14996.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14996.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14996):map__14996);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14996__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__14998){
var map__14999 = p__14998;
var map__14999__$1 = (((((!((map__14999 == null))))?(((((map__14999.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14999.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14999):map__14999);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14999__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14999__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__15001 = cljs.analyzer.unwrap_quote(expr);
var map__15001__$1 = (((((!((map__15001 == null))))?(((((map__15001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15001.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15001):map__15001);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15001__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15001__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15001__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__15003 = cljs.analyzer.unwrap_quote(expr);
var map__15003__$1 = (((((!((map__15003 == null))))?(((((map__15003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15003):map__15003);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15003__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15003__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15003__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__15006 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__15006.cljs$core$IFn$_invoke$arity$1 ? fexpr__15006.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15006.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__15007){
var map__15008 = p__15007;
var map__15008__$1 = (((((!((map__15008 == null))))?(((((map__15008.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15008.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15008):map__15008);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15008__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15008__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15008__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15008__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15008__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__15010){
var map__15011 = p__15010;
var map__15011__$1 = (((((!((map__15011 == null))))?(((((map__15011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15011.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15011):map__15011);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__15013_15713 = cljs.core.seq(nodes);
var chunk__15014_15714 = null;
var count__15015_15715 = (0);
var i__15016_15716 = (0);
while(true){
if((i__15016_15716 < count__15015_15715)){
var map__15034_15717 = chunk__15014_15714.cljs$core$IIndexed$_nth$arity$2(null,i__15016_15716);
var map__15034_15718__$1 = (((((!((map__15034_15717 == null))))?(((((map__15034_15717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15034_15717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15034_15717):map__15034_15717);
var ts_15719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15034_15718__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15035_15720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15034_15718__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15035_15721__$1 = (((((!((map__15035_15720 == null))))?(((((map__15035_15720.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15035_15720.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15035_15720):map__15035_15720);
var then_15722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15035_15721__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15042_15723 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_15719));
var chunk__15043_15724 = null;
var count__15044_15725 = (0);
var i__15045_15726 = (0);
while(true){
if((i__15045_15726 < count__15044_15725)){
var test_15728 = chunk__15043_15724.cljs$core$IIndexed$_nth$arity$2(null,i__15045_15726);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15728,":");


var G__15729 = seq__15042_15723;
var G__15730 = chunk__15043_15724;
var G__15731 = count__15044_15725;
var G__15732 = (i__15045_15726 + (1));
seq__15042_15723 = G__15729;
chunk__15043_15724 = G__15730;
count__15044_15725 = G__15731;
i__15045_15726 = G__15732;
continue;
} else {
var temp__5735__auto___15733 = cljs.core.seq(seq__15042_15723);
if(temp__5735__auto___15733){
var seq__15042_15734__$1 = temp__5735__auto___15733;
if(cljs.core.chunked_seq_QMARK_(seq__15042_15734__$1)){
var c__4609__auto___15735 = cljs.core.chunk_first(seq__15042_15734__$1);
var G__15736 = cljs.core.chunk_rest(seq__15042_15734__$1);
var G__15737 = c__4609__auto___15735;
var G__15738 = cljs.core.count(c__4609__auto___15735);
var G__15739 = (0);
seq__15042_15723 = G__15736;
chunk__15043_15724 = G__15737;
count__15044_15725 = G__15738;
i__15045_15726 = G__15739;
continue;
} else {
var test_15740 = cljs.core.first(seq__15042_15734__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15740,":");


var G__15741 = cljs.core.next(seq__15042_15734__$1);
var G__15742 = null;
var G__15743 = (0);
var G__15744 = (0);
seq__15042_15723 = G__15741;
chunk__15043_15724 = G__15742;
count__15044_15725 = G__15743;
i__15045_15726 = G__15744;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_15722);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_15722);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__15745 = seq__15013_15713;
var G__15746 = chunk__15014_15714;
var G__15747 = count__15015_15715;
var G__15748 = (i__15016_15716 + (1));
seq__15013_15713 = G__15745;
chunk__15014_15714 = G__15746;
count__15015_15715 = G__15747;
i__15016_15716 = G__15748;
continue;
} else {
var temp__5735__auto___15749 = cljs.core.seq(seq__15013_15713);
if(temp__5735__auto___15749){
var seq__15013_15750__$1 = temp__5735__auto___15749;
if(cljs.core.chunked_seq_QMARK_(seq__15013_15750__$1)){
var c__4609__auto___15751 = cljs.core.chunk_first(seq__15013_15750__$1);
var G__15752 = cljs.core.chunk_rest(seq__15013_15750__$1);
var G__15753 = c__4609__auto___15751;
var G__15754 = cljs.core.count(c__4609__auto___15751);
var G__15755 = (0);
seq__15013_15713 = G__15752;
chunk__15014_15714 = G__15753;
count__15015_15715 = G__15754;
i__15016_15716 = G__15755;
continue;
} else {
var map__15046_15756 = cljs.core.first(seq__15013_15750__$1);
var map__15046_15757__$1 = (((((!((map__15046_15756 == null))))?(((((map__15046_15756.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15046_15756.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15046_15756):map__15046_15756);
var ts_15758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15046_15757__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15047_15759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15046_15757__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15047_15760__$1 = (((((!((map__15047_15759 == null))))?(((((map__15047_15759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15047_15759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15047_15759):map__15047_15759);
var then_15761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15047_15760__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15050_15762 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_15758));
var chunk__15051_15763 = null;
var count__15052_15764 = (0);
var i__15053_15765 = (0);
while(true){
if((i__15053_15765 < count__15052_15764)){
var test_15766 = chunk__15051_15763.cljs$core$IIndexed$_nth$arity$2(null,i__15053_15765);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15766,":");


var G__15767 = seq__15050_15762;
var G__15768 = chunk__15051_15763;
var G__15769 = count__15052_15764;
var G__15770 = (i__15053_15765 + (1));
seq__15050_15762 = G__15767;
chunk__15051_15763 = G__15768;
count__15052_15764 = G__15769;
i__15053_15765 = G__15770;
continue;
} else {
var temp__5735__auto___15771__$1 = cljs.core.seq(seq__15050_15762);
if(temp__5735__auto___15771__$1){
var seq__15050_15772__$1 = temp__5735__auto___15771__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15050_15772__$1)){
var c__4609__auto___15773 = cljs.core.chunk_first(seq__15050_15772__$1);
var G__15774 = cljs.core.chunk_rest(seq__15050_15772__$1);
var G__15775 = c__4609__auto___15773;
var G__15776 = cljs.core.count(c__4609__auto___15773);
var G__15777 = (0);
seq__15050_15762 = G__15774;
chunk__15051_15763 = G__15775;
count__15052_15764 = G__15776;
i__15053_15765 = G__15777;
continue;
} else {
var test_15778 = cljs.core.first(seq__15050_15772__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15778,":");


var G__15779 = cljs.core.next(seq__15050_15772__$1);
var G__15780 = null;
var G__15781 = (0);
var G__15782 = (0);
seq__15050_15762 = G__15779;
chunk__15051_15763 = G__15780;
count__15052_15764 = G__15781;
i__15053_15765 = G__15782;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_15761);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_15761);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__15783 = cljs.core.next(seq__15013_15750__$1);
var G__15784 = null;
var G__15785 = (0);
var G__15786 = (0);
seq__15013_15713 = G__15783;
chunk__15014_15714 = G__15784;
count__15015_15715 = G__15785;
i__15016_15716 = G__15786;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__15054){
var map__15055 = p__15054;
var map__15055__$1 = (((((!((map__15055 == null))))?(((((map__15055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15055.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15055):map__15055);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15055__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15055__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15060 = env;
var G__15061 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15060,G__15061) : cljs.compiler.resolve_type.call(null,G__15060,G__15061));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__15062 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15062,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15062,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__15057_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__15057_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__15057_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__15065 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__15065,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__15065;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15068 = env;
var G__15069 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15068,G__15069) : cljs.compiler.resolve_type.call(null,G__15068,G__15069));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15070_SHARP_){
return cljs.compiler.resolve_type(env,p1__15070_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__15071 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15072 = cljs.core.seq(vec__15071);
var first__15073 = cljs.core.first(seq__15072);
var seq__15072__$1 = cljs.core.next(seq__15072);
var p = first__15073;
var first__15073__$1 = cljs.core.first(seq__15072__$1);
var seq__15072__$2 = cljs.core.next(seq__15072__$1);
var ts = first__15073__$1;
var first__15073__$2 = cljs.core.first(seq__15072__$2);
var seq__15072__$3 = cljs.core.next(seq__15072__$2);
var n = first__15073__$2;
var xs = seq__15072__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__15074 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15075 = cljs.core.seq(vec__15074);
var first__15076 = cljs.core.first(seq__15075);
var seq__15075__$1 = cljs.core.next(seq__15075);
var p = first__15076;
var first__15076__$1 = cljs.core.first(seq__15075__$1);
var seq__15075__$2 = cljs.core.next(seq__15075__$1);
var ts = first__15076__$1;
var xs = seq__15075__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__15078 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__15077 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__15077.cljs$core$IFn$_invoke$arity$1 ? fexpr__15077.cljs$core$IFn$_invoke$arity$1(G__15078) : fexpr__15077.call(null,G__15078));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__15081 = arguments.length;
switch (G__15081) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__15089 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15079_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__15079_SHARP_);
} else {
return p1__15079_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__15090 = cljs.core.seq(vec__15089);
var first__15091 = cljs.core.first(seq__15090);
var seq__15090__$1 = cljs.core.next(seq__15090);
var x = first__15091;
var ys = seq__15090__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__15092 = cljs.core.seq(ys);
var chunk__15093 = null;
var count__15094 = (0);
var i__15095 = (0);
while(true){
if((i__15095 < count__15094)){
var next_line = chunk__15093.cljs$core$IIndexed$_nth$arity$2(null,i__15095);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__15789 = seq__15092;
var G__15790 = chunk__15093;
var G__15791 = count__15094;
var G__15792 = (i__15095 + (1));
seq__15092 = G__15789;
chunk__15093 = G__15790;
count__15094 = G__15791;
i__15095 = G__15792;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15092);
if(temp__5735__auto__){
var seq__15092__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15092__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15092__$1);
var G__15793 = cljs.core.chunk_rest(seq__15092__$1);
var G__15794 = c__4609__auto__;
var G__15795 = cljs.core.count(c__4609__auto__);
var G__15796 = (0);
seq__15092 = G__15793;
chunk__15093 = G__15794;
count__15094 = G__15795;
i__15095 = G__15796;
continue;
} else {
var next_line = cljs.core.first(seq__15092__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__15797 = cljs.core.next(seq__15092__$1);
var G__15798 = null;
var G__15799 = (0);
var G__15800 = (0);
seq__15092 = G__15797;
chunk__15093 = G__15798;
count__15094 = G__15799;
i__15095 = G__15800;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__15096_15801 = cljs.core.seq(docs__$2);
var chunk__15097_15802 = null;
var count__15098_15803 = (0);
var i__15099_15804 = (0);
while(true){
if((i__15099_15804 < count__15098_15803)){
var e_15805 = chunk__15097_15802.cljs$core$IIndexed$_nth$arity$2(null,i__15099_15804);
if(cljs.core.truth_(e_15805)){
print_comment_lines(e_15805);
} else {
}


var G__15806 = seq__15096_15801;
var G__15807 = chunk__15097_15802;
var G__15808 = count__15098_15803;
var G__15809 = (i__15099_15804 + (1));
seq__15096_15801 = G__15806;
chunk__15097_15802 = G__15807;
count__15098_15803 = G__15808;
i__15099_15804 = G__15809;
continue;
} else {
var temp__5735__auto___15810 = cljs.core.seq(seq__15096_15801);
if(temp__5735__auto___15810){
var seq__15096_15811__$1 = temp__5735__auto___15810;
if(cljs.core.chunked_seq_QMARK_(seq__15096_15811__$1)){
var c__4609__auto___15812 = cljs.core.chunk_first(seq__15096_15811__$1);
var G__15813 = cljs.core.chunk_rest(seq__15096_15811__$1);
var G__15814 = c__4609__auto___15812;
var G__15815 = cljs.core.count(c__4609__auto___15812);
var G__15816 = (0);
seq__15096_15801 = G__15813;
chunk__15097_15802 = G__15814;
count__15098_15803 = G__15815;
i__15099_15804 = G__15816;
continue;
} else {
var e_15817 = cljs.core.first(seq__15096_15811__$1);
if(cljs.core.truth_(e_15817)){
print_comment_lines(e_15817);
} else {
}


var G__15818 = cljs.core.next(seq__15096_15811__$1);
var G__15819 = null;
var G__15820 = (0);
var G__15821 = (0);
seq__15096_15801 = G__15818;
chunk__15097_15802 = G__15819;
count__15098_15803 = G__15820;
i__15099_15804 = G__15821;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__15101_SHARP_){
return goog.string.startsWith(p1__15101_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__15102){
var map__15103 = p__15102;
var map__15103__$1 = (((((!((map__15103 == null))))?(((((map__15103.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15103.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15103):map__15103);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15103__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__15113){
var map__15114 = p__15113;
var map__15114__$1 = (((((!((map__15114 == null))))?(((((map__15114.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15114.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15114):map__15114);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15114__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15114__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15114__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__15116_15822 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__15117_15823 = null;
var count__15118_15824 = (0);
var i__15119_15825 = (0);
while(true){
if((i__15119_15825 < count__15118_15824)){
var vec__15126_15826 = chunk__15117_15823.cljs$core$IIndexed$_nth$arity$2(null,i__15119_15825);
var i_15827 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15126_15826,(0),null);
var param_15828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15126_15826,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_15828);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__15829 = seq__15116_15822;
var G__15830 = chunk__15117_15823;
var G__15831 = count__15118_15824;
var G__15832 = (i__15119_15825 + (1));
seq__15116_15822 = G__15829;
chunk__15117_15823 = G__15830;
count__15118_15824 = G__15831;
i__15119_15825 = G__15832;
continue;
} else {
var temp__5735__auto___15833 = cljs.core.seq(seq__15116_15822);
if(temp__5735__auto___15833){
var seq__15116_15834__$1 = temp__5735__auto___15833;
if(cljs.core.chunked_seq_QMARK_(seq__15116_15834__$1)){
var c__4609__auto___15835 = cljs.core.chunk_first(seq__15116_15834__$1);
var G__15836 = cljs.core.chunk_rest(seq__15116_15834__$1);
var G__15837 = c__4609__auto___15835;
var G__15838 = cljs.core.count(c__4609__auto___15835);
var G__15839 = (0);
seq__15116_15822 = G__15836;
chunk__15117_15823 = G__15837;
count__15118_15824 = G__15838;
i__15119_15825 = G__15839;
continue;
} else {
var vec__15129_15840 = cljs.core.first(seq__15116_15834__$1);
var i_15841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15129_15840,(0),null);
var param_15842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15129_15840,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_15842);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__15843 = cljs.core.next(seq__15116_15834__$1);
var G__15844 = null;
var G__15845 = (0);
var G__15846 = (0);
seq__15116_15822 = G__15843;
chunk__15117_15823 = G__15844;
count__15118_15824 = G__15845;
i__15119_15825 = G__15846;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15132_15847 = cljs.core.seq(params);
var chunk__15133_15848 = null;
var count__15134_15849 = (0);
var i__15135_15850 = (0);
while(true){
if((i__15135_15850 < count__15134_15849)){
var param_15852 = chunk__15133_15848.cljs$core$IIndexed$_nth$arity$2(null,i__15135_15850);
cljs.compiler.emit(param_15852);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15852,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15853 = seq__15132_15847;
var G__15854 = chunk__15133_15848;
var G__15855 = count__15134_15849;
var G__15856 = (i__15135_15850 + (1));
seq__15132_15847 = G__15853;
chunk__15133_15848 = G__15854;
count__15134_15849 = G__15855;
i__15135_15850 = G__15856;
continue;
} else {
var temp__5735__auto___15857 = cljs.core.seq(seq__15132_15847);
if(temp__5735__auto___15857){
var seq__15132_15858__$1 = temp__5735__auto___15857;
if(cljs.core.chunked_seq_QMARK_(seq__15132_15858__$1)){
var c__4609__auto___15859 = cljs.core.chunk_first(seq__15132_15858__$1);
var G__15860 = cljs.core.chunk_rest(seq__15132_15858__$1);
var G__15861 = c__4609__auto___15859;
var G__15862 = cljs.core.count(c__4609__auto___15859);
var G__15863 = (0);
seq__15132_15847 = G__15860;
chunk__15133_15848 = G__15861;
count__15134_15849 = G__15862;
i__15135_15850 = G__15863;
continue;
} else {
var param_15864 = cljs.core.first(seq__15132_15858__$1);
cljs.compiler.emit(param_15864);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15864,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15865 = cljs.core.next(seq__15132_15858__$1);
var G__15866 = null;
var G__15867 = (0);
var G__15868 = (0);
seq__15132_15847 = G__15865;
chunk__15133_15848 = G__15866;
count__15134_15849 = G__15867;
i__15135_15850 = G__15868;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15136_15869 = cljs.core.seq(params);
var chunk__15137_15870 = null;
var count__15138_15871 = (0);
var i__15139_15872 = (0);
while(true){
if((i__15139_15872 < count__15138_15871)){
var param_15873 = chunk__15137_15870.cljs$core$IIndexed$_nth$arity$2(null,i__15139_15872);
cljs.compiler.emit(param_15873);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15873,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15874 = seq__15136_15869;
var G__15875 = chunk__15137_15870;
var G__15876 = count__15138_15871;
var G__15877 = (i__15139_15872 + (1));
seq__15136_15869 = G__15874;
chunk__15137_15870 = G__15875;
count__15138_15871 = G__15876;
i__15139_15872 = G__15877;
continue;
} else {
var temp__5735__auto___15878 = cljs.core.seq(seq__15136_15869);
if(temp__5735__auto___15878){
var seq__15136_15879__$1 = temp__5735__auto___15878;
if(cljs.core.chunked_seq_QMARK_(seq__15136_15879__$1)){
var c__4609__auto___15880 = cljs.core.chunk_first(seq__15136_15879__$1);
var G__15881 = cljs.core.chunk_rest(seq__15136_15879__$1);
var G__15882 = c__4609__auto___15880;
var G__15883 = cljs.core.count(c__4609__auto___15880);
var G__15884 = (0);
seq__15136_15869 = G__15881;
chunk__15137_15870 = G__15882;
count__15138_15871 = G__15883;
i__15139_15872 = G__15884;
continue;
} else {
var param_15885 = cljs.core.first(seq__15136_15879__$1);
cljs.compiler.emit(param_15885);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15885,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15886 = cljs.core.next(seq__15136_15879__$1);
var G__15887 = null;
var G__15888 = (0);
var G__15889 = (0);
seq__15136_15869 = G__15886;
chunk__15137_15870 = G__15887;
count__15138_15871 = G__15888;
i__15139_15872 = G__15889;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__15142 = cljs.core.seq(params);
var chunk__15143 = null;
var count__15144 = (0);
var i__15145 = (0);
while(true){
if((i__15145 < count__15144)){
var param = chunk__15143.cljs$core$IIndexed$_nth$arity$2(null,i__15145);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15890 = seq__15142;
var G__15891 = chunk__15143;
var G__15892 = count__15144;
var G__15893 = (i__15145 + (1));
seq__15142 = G__15890;
chunk__15143 = G__15891;
count__15144 = G__15892;
i__15145 = G__15893;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15142);
if(temp__5735__auto__){
var seq__15142__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15142__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15142__$1);
var G__15894 = cljs.core.chunk_rest(seq__15142__$1);
var G__15895 = c__4609__auto__;
var G__15896 = cljs.core.count(c__4609__auto__);
var G__15897 = (0);
seq__15142 = G__15894;
chunk__15143 = G__15895;
count__15144 = G__15896;
i__15145 = G__15897;
continue;
} else {
var param = cljs.core.first(seq__15142__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15898 = cljs.core.next(seq__15142__$1);
var G__15899 = null;
var G__15900 = (0);
var G__15901 = (0);
seq__15142 = G__15898;
chunk__15143 = G__15899;
count__15144 = G__15900;
i__15145 = G__15901;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__15146){
var map__15147 = p__15146;
var map__15147__$1 = (((((!((map__15147 == null))))?(((((map__15147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15147.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15147):map__15147);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15147__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15147__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15147__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15147__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15147__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15147__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__15153){
var map__15154 = p__15153;
var map__15154__$1 = (((((!((map__15154 == null))))?(((((map__15154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15154.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15154):map__15154);
var f = map__15154__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15154__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_15902__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_15903 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_15902__$1);
var delegate_name_15904 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_15903),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_15904," = function (");

var seq__15158_15905 = cljs.core.seq(params);
var chunk__15159_15906 = null;
var count__15160_15907 = (0);
var i__15161_15908 = (0);
while(true){
if((i__15161_15908 < count__15160_15907)){
var param_15909 = chunk__15159_15906.cljs$core$IIndexed$_nth$arity$2(null,i__15161_15908);
cljs.compiler.emit(param_15909);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15909,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15910 = seq__15158_15905;
var G__15911 = chunk__15159_15906;
var G__15912 = count__15160_15907;
var G__15913 = (i__15161_15908 + (1));
seq__15158_15905 = G__15910;
chunk__15159_15906 = G__15911;
count__15160_15907 = G__15912;
i__15161_15908 = G__15913;
continue;
} else {
var temp__5735__auto___15914 = cljs.core.seq(seq__15158_15905);
if(temp__5735__auto___15914){
var seq__15158_15915__$1 = temp__5735__auto___15914;
if(cljs.core.chunked_seq_QMARK_(seq__15158_15915__$1)){
var c__4609__auto___15916 = cljs.core.chunk_first(seq__15158_15915__$1);
var G__15917 = cljs.core.chunk_rest(seq__15158_15915__$1);
var G__15918 = c__4609__auto___15916;
var G__15919 = cljs.core.count(c__4609__auto___15916);
var G__15920 = (0);
seq__15158_15905 = G__15917;
chunk__15159_15906 = G__15918;
count__15160_15907 = G__15919;
i__15161_15908 = G__15920;
continue;
} else {
var param_15921 = cljs.core.first(seq__15158_15915__$1);
cljs.compiler.emit(param_15921);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15921,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15922 = cljs.core.next(seq__15158_15915__$1);
var G__15923 = null;
var G__15924 = (0);
var G__15925 = (0);
seq__15158_15905 = G__15922;
chunk__15159_15906 = G__15923;
count__15160_15907 = G__15924;
i__15161_15908 = G__15925;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_15903," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_15926 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_15926,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_15904,".call(this,");

var seq__15162_15927 = cljs.core.seq(params);
var chunk__15163_15928 = null;
var count__15164_15929 = (0);
var i__15165_15930 = (0);
while(true){
if((i__15165_15930 < count__15164_15929)){
var param_15931 = chunk__15163_15928.cljs$core$IIndexed$_nth$arity$2(null,i__15165_15930);
cljs.compiler.emit(param_15931);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15931,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15932 = seq__15162_15927;
var G__15933 = chunk__15163_15928;
var G__15934 = count__15164_15929;
var G__15935 = (i__15165_15930 + (1));
seq__15162_15927 = G__15932;
chunk__15163_15928 = G__15933;
count__15164_15929 = G__15934;
i__15165_15930 = G__15935;
continue;
} else {
var temp__5735__auto___15936 = cljs.core.seq(seq__15162_15927);
if(temp__5735__auto___15936){
var seq__15162_15937__$1 = temp__5735__auto___15936;
if(cljs.core.chunked_seq_QMARK_(seq__15162_15937__$1)){
var c__4609__auto___15938 = cljs.core.chunk_first(seq__15162_15937__$1);
var G__15939 = cljs.core.chunk_rest(seq__15162_15937__$1);
var G__15940 = c__4609__auto___15938;
var G__15941 = cljs.core.count(c__4609__auto___15938);
var G__15942 = (0);
seq__15162_15927 = G__15939;
chunk__15163_15928 = G__15940;
count__15164_15929 = G__15941;
i__15165_15930 = G__15942;
continue;
} else {
var param_15943 = cljs.core.first(seq__15162_15937__$1);
cljs.compiler.emit(param_15943);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15943,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15944 = cljs.core.next(seq__15162_15937__$1);
var G__15945 = null;
var G__15946 = (0);
var G__15947 = (0);
seq__15162_15927 = G__15944;
chunk__15163_15928 = G__15945;
count__15164_15929 = G__15946;
i__15165_15930 = G__15947;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15903,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_15903,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_15902__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15903,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_15904,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_15903,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__15169){
var map__15170 = p__15169;
var map__15170__$1 = (((((!((map__15170 == null))))?(((((map__15170.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15170.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15170):map__15170);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15170__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15166_SHARP_){
var and__4174__auto__ = p1__15166_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__15166_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_15948__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_15949 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_15948__$1);
var maxparams_15950 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_15951 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_15949),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_15952 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__15167_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__15167_SHARP_)));
}),cljs.core.seq(mmap_15951));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_15949," = null;");

var seq__15172_15953 = cljs.core.seq(ms_15952);
var chunk__15173_15954 = null;
var count__15174_15955 = (0);
var i__15175_15956 = (0);
while(true){
if((i__15175_15956 < count__15174_15955)){
var vec__15182_15957 = chunk__15173_15954.cljs$core$IIndexed$_nth$arity$2(null,i__15175_15956);
var n_15958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15182_15957,(0),null);
var meth_15959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15182_15957,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_15958," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_15959))){
cljs.compiler.emit_variadic_fn_method(meth_15959);
} else {
cljs.compiler.emit_fn_method(meth_15959);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__15960 = seq__15172_15953;
var G__15961 = chunk__15173_15954;
var G__15962 = count__15174_15955;
var G__15963 = (i__15175_15956 + (1));
seq__15172_15953 = G__15960;
chunk__15173_15954 = G__15961;
count__15174_15955 = G__15962;
i__15175_15956 = G__15963;
continue;
} else {
var temp__5735__auto___15964 = cljs.core.seq(seq__15172_15953);
if(temp__5735__auto___15964){
var seq__15172_15965__$1 = temp__5735__auto___15964;
if(cljs.core.chunked_seq_QMARK_(seq__15172_15965__$1)){
var c__4609__auto___15966 = cljs.core.chunk_first(seq__15172_15965__$1);
var G__15967 = cljs.core.chunk_rest(seq__15172_15965__$1);
var G__15968 = c__4609__auto___15966;
var G__15969 = cljs.core.count(c__4609__auto___15966);
var G__15970 = (0);
seq__15172_15953 = G__15967;
chunk__15173_15954 = G__15968;
count__15174_15955 = G__15969;
i__15175_15956 = G__15970;
continue;
} else {
var vec__15188_15971 = cljs.core.first(seq__15172_15965__$1);
var n_15972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15188_15971,(0),null);
var meth_15973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15188_15971,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_15972," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_15973))){
cljs.compiler.emit_variadic_fn_method(meth_15973);
} else {
cljs.compiler.emit_fn_method(meth_15973);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__15974 = cljs.core.next(seq__15172_15965__$1);
var G__15975 = null;
var G__15976 = (0);
var G__15977 = (0);
seq__15172_15953 = G__15974;
chunk__15173_15954 = G__15975;
count__15174_15955 = G__15976;
i__15175_15956 = G__15977;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15949," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_15950),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_15950)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_15950));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__15191_15978 = cljs.core.seq(ms_15952);
var chunk__15192_15979 = null;
var count__15193_15980 = (0);
var i__15194_15981 = (0);
while(true){
if((i__15194_15981 < count__15193_15980)){
var vec__15204_15982 = chunk__15192_15979.cljs$core$IIndexed$_nth$arity$2(null,i__15194_15981);
var n_15983 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15204_15982,(0),null);
var meth_15984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15204_15982,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_15984))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_15985 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_15985," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_15986 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_15985," = new cljs.core.IndexedSeq(",a_15986,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_15983,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_15950)),(((cljs.core.count(maxparams_15950) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_15985,");"], 0));
} else {
var pcnt_15987 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_15984));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_15987,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_15983,".call(this",(((pcnt_15987 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_15987,maxparams_15950)),null,(1),null)),(2),null))),");");
}


var G__15988 = seq__15191_15978;
var G__15989 = chunk__15192_15979;
var G__15990 = count__15193_15980;
var G__15991 = (i__15194_15981 + (1));
seq__15191_15978 = G__15988;
chunk__15192_15979 = G__15989;
count__15193_15980 = G__15990;
i__15194_15981 = G__15991;
continue;
} else {
var temp__5735__auto___15992 = cljs.core.seq(seq__15191_15978);
if(temp__5735__auto___15992){
var seq__15191_15993__$1 = temp__5735__auto___15992;
if(cljs.core.chunked_seq_QMARK_(seq__15191_15993__$1)){
var c__4609__auto___15994 = cljs.core.chunk_first(seq__15191_15993__$1);
var G__15995 = cljs.core.chunk_rest(seq__15191_15993__$1);
var G__15996 = c__4609__auto___15994;
var G__15997 = cljs.core.count(c__4609__auto___15994);
var G__15998 = (0);
seq__15191_15978 = G__15995;
chunk__15192_15979 = G__15996;
count__15193_15980 = G__15997;
i__15194_15981 = G__15998;
continue;
} else {
var vec__15207_15999 = cljs.core.first(seq__15191_15993__$1);
var n_16000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15207_15999,(0),null);
var meth_16001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15207_15999,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16001))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16002 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16002," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16003 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16002," = new cljs.core.IndexedSeq(",a_16003,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16000,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_15950)),(((cljs.core.count(maxparams_15950) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16002,");"], 0));
} else {
var pcnt_16004 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16001));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16004,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16000,".call(this",(((pcnt_16004 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16004,maxparams_15950)),null,(1),null)),(2),null))),");");
}


var G__16005 = cljs.core.next(seq__15191_15993__$1);
var G__16006 = null;
var G__16007 = (0);
var G__16008 = (0);
seq__15191_15978 = G__16005;
chunk__15192_15979 = G__16006;
count__15193_15980 = G__16007;
i__15194_15981 = G__16008;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_16009 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_15952)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_16009,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15949,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15949,".cljs$lang$applyTo = ",cljs.core.some((function (p1__15168_SHARP_){
var vec__15210 = p1__15168_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15210,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15210,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_15952),".cljs$lang$applyTo;");
} else {
}

var seq__15213_16010 = cljs.core.seq(ms_15952);
var chunk__15214_16011 = null;
var count__15215_16012 = (0);
var i__15216_16013 = (0);
while(true){
if((i__15216_16013 < count__15215_16012)){
var vec__15223_16014 = chunk__15214_16011.cljs$core$IIndexed$_nth$arity$2(null,i__15216_16013);
var n_16015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15223_16014,(0),null);
var meth_16016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15223_16014,(1),null);
var c_16017 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16016));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16016))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15949,".cljs$core$IFn$_invoke$arity$variadic = ",n_16015,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_15949,".cljs$core$IFn$_invoke$arity$",c_16017," = ",n_16015,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16018 = seq__15213_16010;
var G__16019 = chunk__15214_16011;
var G__16020 = count__15215_16012;
var G__16021 = (i__15216_16013 + (1));
seq__15213_16010 = G__16018;
chunk__15214_16011 = G__16019;
count__15215_16012 = G__16020;
i__15216_16013 = G__16021;
continue;
} else {
var temp__5735__auto___16022 = cljs.core.seq(seq__15213_16010);
if(temp__5735__auto___16022){
var seq__15213_16023__$1 = temp__5735__auto___16022;
if(cljs.core.chunked_seq_QMARK_(seq__15213_16023__$1)){
var c__4609__auto___16024 = cljs.core.chunk_first(seq__15213_16023__$1);
var G__16025 = cljs.core.chunk_rest(seq__15213_16023__$1);
var G__16026 = c__4609__auto___16024;
var G__16027 = cljs.core.count(c__4609__auto___16024);
var G__16028 = (0);
seq__15213_16010 = G__16025;
chunk__15214_16011 = G__16026;
count__15215_16012 = G__16027;
i__15216_16013 = G__16028;
continue;
} else {
var vec__15226_16029 = cljs.core.first(seq__15213_16023__$1);
var n_16030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15226_16029,(0),null);
var meth_16031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15226_16029,(1),null);
var c_16032 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16031));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16031))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_15949,".cljs$core$IFn$_invoke$arity$variadic = ",n_16030,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_15949,".cljs$core$IFn$_invoke$arity$",c_16032," = ",n_16030,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16033 = cljs.core.next(seq__15213_16023__$1);
var G__16034 = null;
var G__16035 = (0);
var G__16036 = (0);
seq__15213_16010 = G__16033;
chunk__15214_16011 = G__16034;
count__15215_16012 = G__16035;
i__15216_16013 = G__16036;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_15949,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__15229){
var map__15230 = p__15229;
var map__15230__$1 = (((((!((map__15230 == null))))?(((((map__15230.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15230.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15230):map__15230);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15230__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15230__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15230__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15236_16037 = cljs.core.seq(statements);
var chunk__15237_16038 = null;
var count__15238_16039 = (0);
var i__15239_16040 = (0);
while(true){
if((i__15239_16040 < count__15238_16039)){
var s_16041 = chunk__15237_16038.cljs$core$IIndexed$_nth$arity$2(null,i__15239_16040);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16041);


var G__16042 = seq__15236_16037;
var G__16043 = chunk__15237_16038;
var G__16044 = count__15238_16039;
var G__16045 = (i__15239_16040 + (1));
seq__15236_16037 = G__16042;
chunk__15237_16038 = G__16043;
count__15238_16039 = G__16044;
i__15239_16040 = G__16045;
continue;
} else {
var temp__5735__auto___16046 = cljs.core.seq(seq__15236_16037);
if(temp__5735__auto___16046){
var seq__15236_16047__$1 = temp__5735__auto___16046;
if(cljs.core.chunked_seq_QMARK_(seq__15236_16047__$1)){
var c__4609__auto___16048 = cljs.core.chunk_first(seq__15236_16047__$1);
var G__16049 = cljs.core.chunk_rest(seq__15236_16047__$1);
var G__16050 = c__4609__auto___16048;
var G__16051 = cljs.core.count(c__4609__auto___16048);
var G__16052 = (0);
seq__15236_16037 = G__16049;
chunk__15237_16038 = G__16050;
count__15238_16039 = G__16051;
i__15239_16040 = G__16052;
continue;
} else {
var s_16053 = cljs.core.first(seq__15236_16047__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16053);


var G__16054 = cljs.core.next(seq__15236_16047__$1);
var G__16055 = null;
var G__16056 = (0);
var G__16057 = (0);
seq__15236_16037 = G__16054;
chunk__15237_16038 = G__16055;
count__15238_16039 = G__16056;
i__15239_16040 = G__16057;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__15240){
var map__15241 = p__15240;
var map__15241__$1 = (((((!((map__15241 == null))))?(((((map__15241.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15241.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15241):map__15241);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15241__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15241__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15241__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15241__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15241__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__15243,is_loop){
var map__15244 = p__15243;
var map__15244__$1 = (((((!((map__15244 == null))))?(((((map__15244.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15244.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15244):map__15244);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15244__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15244__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15244__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__15246_16058 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__15247_16059 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__15247_16059);

try{var seq__15248_16060 = cljs.core.seq(bindings);
var chunk__15249_16061 = null;
var count__15250_16062 = (0);
var i__15251_16063 = (0);
while(true){
if((i__15251_16063 < count__15250_16062)){
var map__15256_16064 = chunk__15249_16061.cljs$core$IIndexed$_nth$arity$2(null,i__15251_16063);
var map__15256_16065__$1 = (((((!((map__15256_16064 == null))))?(((((map__15256_16064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15256_16064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15256_16064):map__15256_16064);
var binding_16066 = map__15256_16065__$1;
var init_16067 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15256_16065__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16066);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16067,";");


var G__16068 = seq__15248_16060;
var G__16069 = chunk__15249_16061;
var G__16070 = count__15250_16062;
var G__16071 = (i__15251_16063 + (1));
seq__15248_16060 = G__16068;
chunk__15249_16061 = G__16069;
count__15250_16062 = G__16070;
i__15251_16063 = G__16071;
continue;
} else {
var temp__5735__auto___16072 = cljs.core.seq(seq__15248_16060);
if(temp__5735__auto___16072){
var seq__15248_16073__$1 = temp__5735__auto___16072;
if(cljs.core.chunked_seq_QMARK_(seq__15248_16073__$1)){
var c__4609__auto___16074 = cljs.core.chunk_first(seq__15248_16073__$1);
var G__16075 = cljs.core.chunk_rest(seq__15248_16073__$1);
var G__16076 = c__4609__auto___16074;
var G__16077 = cljs.core.count(c__4609__auto___16074);
var G__16078 = (0);
seq__15248_16060 = G__16075;
chunk__15249_16061 = G__16076;
count__15250_16062 = G__16077;
i__15251_16063 = G__16078;
continue;
} else {
var map__15258_16079 = cljs.core.first(seq__15248_16073__$1);
var map__15258_16080__$1 = (((((!((map__15258_16079 == null))))?(((((map__15258_16079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15258_16079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15258_16079):map__15258_16079);
var binding_16081 = map__15258_16080__$1;
var init_16082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15258_16080__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16081);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16082,";");


var G__16083 = cljs.core.next(seq__15248_16073__$1);
var G__16084 = null;
var G__16085 = (0);
var G__16086 = (0);
seq__15248_16060 = G__16083;
chunk__15249_16061 = G__16084;
count__15250_16062 = G__16085;
i__15251_16063 = G__16086;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__15246_16058);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__15260){
var map__15261 = p__15260;
var map__15261__$1 = (((((!((map__15261 == null))))?(((((map__15261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15261):map__15261);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15261__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15261__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15261__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___16087 = cljs.core.count(exprs);
var i_16088 = (0);
while(true){
if((i_16088 < n__4666__auto___16087)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16088) : temps.call(null,i_16088))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_16088) : exprs.call(null,i_16088)),";");

var G__16089 = (i_16088 + (1));
i_16088 = G__16089;
continue;
} else {
}
break;
}

var n__4666__auto___16090 = cljs.core.count(exprs);
var i_16091 = (0);
while(true){
if((i_16091 < n__4666__auto___16090)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_16091) : params.call(null,i_16091)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16091) : temps.call(null,i_16091)),";");

var G__16092 = (i_16091 + (1));
i_16091 = G__16092;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__15263){
var map__15264 = p__15263;
var map__15264__$1 = (((((!((map__15264 == null))))?(((((map__15264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15264):map__15264);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15264__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15264__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15264__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15266_16093 = cljs.core.seq(bindings);
var chunk__15267_16094 = null;
var count__15268_16095 = (0);
var i__15269_16096 = (0);
while(true){
if((i__15269_16096 < count__15268_16095)){
var map__15274_16097 = chunk__15267_16094.cljs$core$IIndexed$_nth$arity$2(null,i__15269_16096);
var map__15274_16098__$1 = (((((!((map__15274_16097 == null))))?(((((map__15274_16097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15274_16097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15274_16097):map__15274_16097);
var binding_16099 = map__15274_16098__$1;
var init_16100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15274_16098__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16099)," = ",init_16100,";");


var G__16102 = seq__15266_16093;
var G__16103 = chunk__15267_16094;
var G__16104 = count__15268_16095;
var G__16105 = (i__15269_16096 + (1));
seq__15266_16093 = G__16102;
chunk__15267_16094 = G__16103;
count__15268_16095 = G__16104;
i__15269_16096 = G__16105;
continue;
} else {
var temp__5735__auto___16106 = cljs.core.seq(seq__15266_16093);
if(temp__5735__auto___16106){
var seq__15266_16107__$1 = temp__5735__auto___16106;
if(cljs.core.chunked_seq_QMARK_(seq__15266_16107__$1)){
var c__4609__auto___16114 = cljs.core.chunk_first(seq__15266_16107__$1);
var G__16115 = cljs.core.chunk_rest(seq__15266_16107__$1);
var G__16116 = c__4609__auto___16114;
var G__16117 = cljs.core.count(c__4609__auto___16114);
var G__16118 = (0);
seq__15266_16093 = G__16115;
chunk__15267_16094 = G__16116;
count__15268_16095 = G__16117;
i__15269_16096 = G__16118;
continue;
} else {
var map__15276_16119 = cljs.core.first(seq__15266_16107__$1);
var map__15276_16120__$1 = (((((!((map__15276_16119 == null))))?(((((map__15276_16119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15276_16119.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15276_16119):map__15276_16119);
var binding_16121 = map__15276_16120__$1;
var init_16122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15276_16120__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16121)," = ",init_16122,";");


var G__16124 = cljs.core.next(seq__15266_16107__$1);
var G__16125 = null;
var G__16126 = (0);
var G__16127 = (0);
seq__15266_16093 = G__16124;
chunk__15267_16094 = G__16125;
count__15268_16095 = G__16126;
i__15269_16096 = G__16127;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__15281){
var map__15282 = p__15281;
var map__15282__$1 = (((((!((map__15282 == null))))?(((((map__15282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15282.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15282):map__15282);
var expr = map__15282__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15282__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15282__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15282__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__15298 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__15298.cljs$core$IFn$_invoke$arity$1 ? fexpr__15298.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15298.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__15300 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__15300.cljs$core$IFn$_invoke$arity$1 ? fexpr__15300.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__15300.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__15284 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15279_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15279_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15280_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15280_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15284,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15284,(1),null);
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_16128 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_16128,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_16130 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_16130,args)),(((mfa_16130 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_16130,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__15304 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__15303 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15303.cljs$core$IFn$_invoke$arity$1 ? fexpr__15303.cljs$core$IFn$_invoke$arity$1(G__15304) : fexpr__15303.call(null,G__15304));
} else {
return and__4174__auto__;
}
})())){
var fprop_16131 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16131," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16131,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16131," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16131,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__15313){
var map__15314 = p__15313;
var map__15314__$1 = (((((!((map__15314 == null))))?(((((map__15314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15314.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15314):map__15314);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15314__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15314__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15314__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__15321){
var map__15322 = p__15321;
var map__15322__$1 = (((((!((map__15322 == null))))?(((((map__15322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15322.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15322):map__15322);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__15324 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15324__$1 = (((((!((map__15324 == null))))?(((((map__15324.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15324.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15324):map__15324);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15324__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15324__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__15325 = options;
var map__15325__$1 = (((((!((map__15325 == null))))?(((((map__15325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15325.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15325):map__15325);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15325__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15325__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__15326 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__15332 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__15332__$1 = (((((!((map__15332 == null))))?(((((map__15332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15332):map__15332);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15332__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15332__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15326,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15326,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__15334_16134 = cljs.core.seq(libs_to_load);
var chunk__15335_16135 = null;
var count__15336_16136 = (0);
var i__15337_16137 = (0);
while(true){
if((i__15337_16137 < count__15336_16136)){
var lib_16138 = chunk__15335_16135.cljs$core$IIndexed$_nth$arity$2(null,i__15337_16137);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16138)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16138),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16138),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16138),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16138),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16138,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16138),"');");
}

}
}
}


var G__16139 = seq__15334_16134;
var G__16140 = chunk__15335_16135;
var G__16141 = count__15336_16136;
var G__16142 = (i__15337_16137 + (1));
seq__15334_16134 = G__16139;
chunk__15335_16135 = G__16140;
count__15336_16136 = G__16141;
i__15337_16137 = G__16142;
continue;
} else {
var temp__5735__auto___16143 = cljs.core.seq(seq__15334_16134);
if(temp__5735__auto___16143){
var seq__15334_16144__$1 = temp__5735__auto___16143;
if(cljs.core.chunked_seq_QMARK_(seq__15334_16144__$1)){
var c__4609__auto___16145 = cljs.core.chunk_first(seq__15334_16144__$1);
var G__16146 = cljs.core.chunk_rest(seq__15334_16144__$1);
var G__16147 = c__4609__auto___16145;
var G__16148 = cljs.core.count(c__4609__auto___16145);
var G__16149 = (0);
seq__15334_16134 = G__16146;
chunk__15335_16135 = G__16147;
count__15336_16136 = G__16148;
i__15337_16137 = G__16149;
continue;
} else {
var lib_16150 = cljs.core.first(seq__15334_16144__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16150)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16150),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16150),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16150),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16150),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16150,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16150),"');");
}

}
}
}


var G__16151 = cljs.core.next(seq__15334_16144__$1);
var G__16152 = null;
var G__16153 = (0);
var G__16154 = (0);
seq__15334_16134 = G__16151;
chunk__15335_16135 = G__16152;
count__15336_16136 = G__16153;
i__15337_16137 = G__16154;
continue;
}
} else {
}
}
break;
}

var seq__15371_16155 = cljs.core.seq(node_libs);
var chunk__15372_16156 = null;
var count__15373_16157 = (0);
var i__15374_16158 = (0);
while(true){
if((i__15374_16158 < count__15373_16157)){
var lib_16159 = chunk__15372_16156.cljs$core$IIndexed$_nth$arity$2(null,i__15374_16158);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16159)," = require('",lib_16159,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16160 = seq__15371_16155;
var G__16161 = chunk__15372_16156;
var G__16162 = count__15373_16157;
var G__16163 = (i__15374_16158 + (1));
seq__15371_16155 = G__16160;
chunk__15372_16156 = G__16161;
count__15373_16157 = G__16162;
i__15374_16158 = G__16163;
continue;
} else {
var temp__5735__auto___16164 = cljs.core.seq(seq__15371_16155);
if(temp__5735__auto___16164){
var seq__15371_16165__$1 = temp__5735__auto___16164;
if(cljs.core.chunked_seq_QMARK_(seq__15371_16165__$1)){
var c__4609__auto___16166 = cljs.core.chunk_first(seq__15371_16165__$1);
var G__16167 = cljs.core.chunk_rest(seq__15371_16165__$1);
var G__16168 = c__4609__auto___16166;
var G__16169 = cljs.core.count(c__4609__auto___16166);
var G__16170 = (0);
seq__15371_16155 = G__16167;
chunk__15372_16156 = G__16168;
count__15373_16157 = G__16169;
i__15374_16158 = G__16170;
continue;
} else {
var lib_16171 = cljs.core.first(seq__15371_16165__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16171)," = require('",lib_16171,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16172 = cljs.core.next(seq__15371_16165__$1);
var G__16173 = null;
var G__16174 = (0);
var G__16175 = (0);
seq__15371_16155 = G__16172;
chunk__15372_16156 = G__16173;
count__15373_16157 = G__16174;
i__15374_16158 = G__16175;
continue;
}
} else {
}
}
break;
}

var seq__15375_16176 = cljs.core.seq(global_exports_libs);
var chunk__15376_16177 = null;
var count__15377_16178 = (0);
var i__15378_16179 = (0);
while(true){
if((i__15378_16179 < count__15377_16178)){
var lib_16180 = chunk__15376_16177.cljs$core$IIndexed$_nth$arity$2(null,i__15378_16179);
var map__15387_16181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16180));
var map__15387_16182__$1 = (((((!((map__15387_16181 == null))))?(((((map__15387_16181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15387_16181.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15387_16181):map__15387_16181);
var global_exports_16183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15387_16182__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16183,lib_16180);


var G__16184 = seq__15375_16176;
var G__16185 = chunk__15376_16177;
var G__16186 = count__15377_16178;
var G__16187 = (i__15378_16179 + (1));
seq__15375_16176 = G__16184;
chunk__15376_16177 = G__16185;
count__15377_16178 = G__16186;
i__15378_16179 = G__16187;
continue;
} else {
var temp__5735__auto___16188 = cljs.core.seq(seq__15375_16176);
if(temp__5735__auto___16188){
var seq__15375_16189__$1 = temp__5735__auto___16188;
if(cljs.core.chunked_seq_QMARK_(seq__15375_16189__$1)){
var c__4609__auto___16190 = cljs.core.chunk_first(seq__15375_16189__$1);
var G__16191 = cljs.core.chunk_rest(seq__15375_16189__$1);
var G__16192 = c__4609__auto___16190;
var G__16193 = cljs.core.count(c__4609__auto___16190);
var G__16194 = (0);
seq__15375_16176 = G__16191;
chunk__15376_16177 = G__16192;
count__15377_16178 = G__16193;
i__15378_16179 = G__16194;
continue;
} else {
var lib_16195 = cljs.core.first(seq__15375_16189__$1);
var map__15389_16196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16195));
var map__15389_16197__$1 = (((((!((map__15389_16196 == null))))?(((((map__15389_16196.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15389_16196.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15389_16196):map__15389_16196);
var global_exports_16198 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15389_16197__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16198,lib_16195);


var G__16199 = cljs.core.next(seq__15375_16189__$1);
var G__16200 = null;
var G__16201 = (0);
var G__16202 = (0);
seq__15375_16176 = G__16199;
chunk__15376_16177 = G__16200;
count__15377_16178 = G__16201;
i__15378_16179 = G__16202;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__15391){
var map__15392 = p__15391;
var map__15392__$1 = (((((!((map__15392 == null))))?(((((map__15392.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15392.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15392):map__15392);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15392__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__15425){
var map__15426 = p__15425;
var map__15426__$1 = (((((!((map__15426 == null))))?(((((map__15426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15426.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15426):map__15426);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15426__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__15428){
var map__15429 = p__15428;
var map__15429__$1 = (((((!((map__15429 == null))))?(((((map__15429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15429):map__15429);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15431_16212 = cljs.core.seq(protocols);
var chunk__15432_16213 = null;
var count__15433_16214 = (0);
var i__15434_16215 = (0);
while(true){
if((i__15434_16215 < count__15433_16214)){
var protocol_16216 = chunk__15432_16213.cljs$core$IIndexed$_nth$arity$2(null,i__15434_16215);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16216)),"}");


var G__16217 = seq__15431_16212;
var G__16218 = chunk__15432_16213;
var G__16219 = count__15433_16214;
var G__16220 = (i__15434_16215 + (1));
seq__15431_16212 = G__16217;
chunk__15432_16213 = G__16218;
count__15433_16214 = G__16219;
i__15434_16215 = G__16220;
continue;
} else {
var temp__5735__auto___16221 = cljs.core.seq(seq__15431_16212);
if(temp__5735__auto___16221){
var seq__15431_16222__$1 = temp__5735__auto___16221;
if(cljs.core.chunked_seq_QMARK_(seq__15431_16222__$1)){
var c__4609__auto___16223 = cljs.core.chunk_first(seq__15431_16222__$1);
var G__16224 = cljs.core.chunk_rest(seq__15431_16222__$1);
var G__16225 = c__4609__auto___16223;
var G__16226 = cljs.core.count(c__4609__auto___16223);
var G__16227 = (0);
seq__15431_16212 = G__16224;
chunk__15432_16213 = G__16225;
count__15433_16214 = G__16226;
i__15434_16215 = G__16227;
continue;
} else {
var protocol_16228 = cljs.core.first(seq__15431_16222__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16228)),"}");


var G__16229 = cljs.core.next(seq__15431_16222__$1);
var G__16230 = null;
var G__16231 = (0);
var G__16232 = (0);
seq__15431_16212 = G__16229;
chunk__15432_16213 = G__16230;
count__15433_16214 = G__16231;
i__15434_16215 = G__16232;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15435_16233 = cljs.core.seq(fields__$1);
var chunk__15436_16234 = null;
var count__15437_16235 = (0);
var i__15438_16236 = (0);
while(true){
if((i__15438_16236 < count__15437_16235)){
var fld_16237 = chunk__15436_16234.cljs$core$IIndexed$_nth$arity$2(null,i__15438_16236);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16237," = ",fld_16237,";");


var G__16238 = seq__15435_16233;
var G__16239 = chunk__15436_16234;
var G__16240 = count__15437_16235;
var G__16241 = (i__15438_16236 + (1));
seq__15435_16233 = G__16238;
chunk__15436_16234 = G__16239;
count__15437_16235 = G__16240;
i__15438_16236 = G__16241;
continue;
} else {
var temp__5735__auto___16242 = cljs.core.seq(seq__15435_16233);
if(temp__5735__auto___16242){
var seq__15435_16243__$1 = temp__5735__auto___16242;
if(cljs.core.chunked_seq_QMARK_(seq__15435_16243__$1)){
var c__4609__auto___16244 = cljs.core.chunk_first(seq__15435_16243__$1);
var G__16245 = cljs.core.chunk_rest(seq__15435_16243__$1);
var G__16246 = c__4609__auto___16244;
var G__16247 = cljs.core.count(c__4609__auto___16244);
var G__16248 = (0);
seq__15435_16233 = G__16245;
chunk__15436_16234 = G__16246;
count__15437_16235 = G__16247;
i__15438_16236 = G__16248;
continue;
} else {
var fld_16249 = cljs.core.first(seq__15435_16243__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16249," = ",fld_16249,";");


var G__16250 = cljs.core.next(seq__15435_16243__$1);
var G__16251 = null;
var G__16252 = (0);
var G__16253 = (0);
seq__15435_16233 = G__16250;
chunk__15436_16234 = G__16251;
count__15437_16235 = G__16252;
i__15438_16236 = G__16253;
continue;
}
} else {
}
}
break;
}

var seq__15460_16254 = cljs.core.seq(pmasks);
var chunk__15461_16255 = null;
var count__15462_16256 = (0);
var i__15463_16257 = (0);
while(true){
if((i__15463_16257 < count__15462_16256)){
var vec__15470_16258 = chunk__15461_16255.cljs$core$IIndexed$_nth$arity$2(null,i__15463_16257);
var pno_16259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15470_16258,(0),null);
var pmask_16260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15470_16258,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16259,"$ = ",pmask_16260,";");


var G__16261 = seq__15460_16254;
var G__16262 = chunk__15461_16255;
var G__16263 = count__15462_16256;
var G__16264 = (i__15463_16257 + (1));
seq__15460_16254 = G__16261;
chunk__15461_16255 = G__16262;
count__15462_16256 = G__16263;
i__15463_16257 = G__16264;
continue;
} else {
var temp__5735__auto___16265 = cljs.core.seq(seq__15460_16254);
if(temp__5735__auto___16265){
var seq__15460_16266__$1 = temp__5735__auto___16265;
if(cljs.core.chunked_seq_QMARK_(seq__15460_16266__$1)){
var c__4609__auto___16267 = cljs.core.chunk_first(seq__15460_16266__$1);
var G__16268 = cljs.core.chunk_rest(seq__15460_16266__$1);
var G__16269 = c__4609__auto___16267;
var G__16270 = cljs.core.count(c__4609__auto___16267);
var G__16271 = (0);
seq__15460_16254 = G__16268;
chunk__15461_16255 = G__16269;
count__15462_16256 = G__16270;
i__15463_16257 = G__16271;
continue;
} else {
var vec__15477_16272 = cljs.core.first(seq__15460_16266__$1);
var pno_16273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15477_16272,(0),null);
var pmask_16274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15477_16272,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16273,"$ = ",pmask_16274,";");


var G__16275 = cljs.core.next(seq__15460_16266__$1);
var G__16276 = null;
var G__16277 = (0);
var G__16278 = (0);
seq__15460_16254 = G__16275;
chunk__15461_16255 = G__16276;
count__15462_16256 = G__16277;
i__15463_16257 = G__16278;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__15480){
var map__15481 = p__15480;
var map__15481__$1 = (((((!((map__15481 == null))))?(((((map__15481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15481.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15481):map__15481);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15481__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15481__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15481__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15481__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15481__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15483_16279 = cljs.core.seq(protocols);
var chunk__15484_16280 = null;
var count__15485_16281 = (0);
var i__15486_16282 = (0);
while(true){
if((i__15486_16282 < count__15485_16281)){
var protocol_16283 = chunk__15484_16280.cljs$core$IIndexed$_nth$arity$2(null,i__15486_16282);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16283)),"}");


var G__16284 = seq__15483_16279;
var G__16285 = chunk__15484_16280;
var G__16286 = count__15485_16281;
var G__16287 = (i__15486_16282 + (1));
seq__15483_16279 = G__16284;
chunk__15484_16280 = G__16285;
count__15485_16281 = G__16286;
i__15486_16282 = G__16287;
continue;
} else {
var temp__5735__auto___16288 = cljs.core.seq(seq__15483_16279);
if(temp__5735__auto___16288){
var seq__15483_16289__$1 = temp__5735__auto___16288;
if(cljs.core.chunked_seq_QMARK_(seq__15483_16289__$1)){
var c__4609__auto___16290 = cljs.core.chunk_first(seq__15483_16289__$1);
var G__16291 = cljs.core.chunk_rest(seq__15483_16289__$1);
var G__16292 = c__4609__auto___16290;
var G__16293 = cljs.core.count(c__4609__auto___16290);
var G__16294 = (0);
seq__15483_16279 = G__16291;
chunk__15484_16280 = G__16292;
count__15485_16281 = G__16293;
i__15486_16282 = G__16294;
continue;
} else {
var protocol_16295 = cljs.core.first(seq__15483_16289__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16295)),"}");


var G__16296 = cljs.core.next(seq__15483_16289__$1);
var G__16297 = null;
var G__16298 = (0);
var G__16299 = (0);
seq__15483_16279 = G__16296;
chunk__15484_16280 = G__16297;
count__15485_16281 = G__16298;
i__15486_16282 = G__16299;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15489_16300 = cljs.core.seq(fields__$1);
var chunk__15490_16301 = null;
var count__15491_16302 = (0);
var i__15492_16303 = (0);
while(true){
if((i__15492_16303 < count__15491_16302)){
var fld_16304 = chunk__15490_16301.cljs$core$IIndexed$_nth$arity$2(null,i__15492_16303);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16304," = ",fld_16304,";");


var G__16305 = seq__15489_16300;
var G__16306 = chunk__15490_16301;
var G__16307 = count__15491_16302;
var G__16308 = (i__15492_16303 + (1));
seq__15489_16300 = G__16305;
chunk__15490_16301 = G__16306;
count__15491_16302 = G__16307;
i__15492_16303 = G__16308;
continue;
} else {
var temp__5735__auto___16309 = cljs.core.seq(seq__15489_16300);
if(temp__5735__auto___16309){
var seq__15489_16310__$1 = temp__5735__auto___16309;
if(cljs.core.chunked_seq_QMARK_(seq__15489_16310__$1)){
var c__4609__auto___16311 = cljs.core.chunk_first(seq__15489_16310__$1);
var G__16312 = cljs.core.chunk_rest(seq__15489_16310__$1);
var G__16313 = c__4609__auto___16311;
var G__16314 = cljs.core.count(c__4609__auto___16311);
var G__16315 = (0);
seq__15489_16300 = G__16312;
chunk__15490_16301 = G__16313;
count__15491_16302 = G__16314;
i__15492_16303 = G__16315;
continue;
} else {
var fld_16316 = cljs.core.first(seq__15489_16310__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16316," = ",fld_16316,";");


var G__16317 = cljs.core.next(seq__15489_16310__$1);
var G__16318 = null;
var G__16319 = (0);
var G__16320 = (0);
seq__15489_16300 = G__16317;
chunk__15490_16301 = G__16318;
count__15491_16302 = G__16319;
i__15492_16303 = G__16320;
continue;
}
} else {
}
}
break;
}

var seq__15493_16321 = cljs.core.seq(pmasks);
var chunk__15494_16322 = null;
var count__15495_16323 = (0);
var i__15496_16324 = (0);
while(true){
if((i__15496_16324 < count__15495_16323)){
var vec__15517_16325 = chunk__15494_16322.cljs$core$IIndexed$_nth$arity$2(null,i__15496_16324);
var pno_16326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15517_16325,(0),null);
var pmask_16327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15517_16325,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16326,"$ = ",pmask_16327,";");


var G__16328 = seq__15493_16321;
var G__16329 = chunk__15494_16322;
var G__16330 = count__15495_16323;
var G__16331 = (i__15496_16324 + (1));
seq__15493_16321 = G__16328;
chunk__15494_16322 = G__16329;
count__15495_16323 = G__16330;
i__15496_16324 = G__16331;
continue;
} else {
var temp__5735__auto___16332 = cljs.core.seq(seq__15493_16321);
if(temp__5735__auto___16332){
var seq__15493_16333__$1 = temp__5735__auto___16332;
if(cljs.core.chunked_seq_QMARK_(seq__15493_16333__$1)){
var c__4609__auto___16334 = cljs.core.chunk_first(seq__15493_16333__$1);
var G__16335 = cljs.core.chunk_rest(seq__15493_16333__$1);
var G__16336 = c__4609__auto___16334;
var G__16337 = cljs.core.count(c__4609__auto___16334);
var G__16338 = (0);
seq__15493_16321 = G__16335;
chunk__15494_16322 = G__16336;
count__15495_16323 = G__16337;
i__15496_16324 = G__16338;
continue;
} else {
var vec__15520_16339 = cljs.core.first(seq__15493_16333__$1);
var pno_16340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15520_16339,(0),null);
var pmask_16341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15520_16339,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16340,"$ = ",pmask_16341,";");


var G__16342 = cljs.core.next(seq__15493_16333__$1);
var G__16343 = null;
var G__16344 = (0);
var G__16345 = (0);
seq__15493_16321 = G__16342;
chunk__15494_16322 = G__16343;
count__15495_16323 = G__16344;
i__15496_16324 = G__16345;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__15523){
var map__15524 = p__15523;
var map__15524__$1 = (((((!((map__15524 == null))))?(((((map__15524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15524):map__15524);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__15528){
var map__15529 = p__15528;
var map__15529__$1 = (((((!((map__15529 == null))))?(((((map__15529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15529):map__15529);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__14727__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14727__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__15543 = cljs.core.seq(table);
var chunk__15544 = null;
var count__15545 = (0);
var i__15546 = (0);
while(true){
if((i__15546 < count__15545)){
var vec__15567 = chunk__15544.cljs$core$IIndexed$_nth$arity$2(null,i__15546);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15567,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15567,(1),null);
var ns_16346 = cljs.core.namespace(sym);
var name_16347 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16348 = seq__15543;
var G__16349 = chunk__15544;
var G__16350 = count__15545;
var G__16351 = (i__15546 + (1));
seq__15543 = G__16348;
chunk__15544 = G__16349;
count__15545 = G__16350;
i__15546 = G__16351;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15543);
if(temp__5735__auto__){
var seq__15543__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15543__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15543__$1);
var G__16352 = cljs.core.chunk_rest(seq__15543__$1);
var G__16353 = c__4609__auto__;
var G__16354 = cljs.core.count(c__4609__auto__);
var G__16355 = (0);
seq__15543 = G__16352;
chunk__15544 = G__16353;
count__15545 = G__16354;
i__15546 = G__16355;
continue;
} else {
var vec__15570 = cljs.core.first(seq__15543__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15570,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15570,(1),null);
var ns_16356 = cljs.core.namespace(sym);
var name_16357 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16358 = cljs.core.next(seq__15543__$1);
var G__16359 = null;
var G__16360 = (0);
var G__16361 = (0);
seq__15543 = G__16358;
chunk__15544 = G__16359;
count__15545 = G__16360;
i__15546 = G__16361;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__15574 = arguments.length;
switch (G__15574) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_16363 = cljs.core.first(ks);
var vec__15575_16364 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_16363);
var top_16365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15575_16364,(0),null);
var prefix_SINGLEQUOTE__16366 = vec__15575_16364;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_16363)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__16366) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_16365)) || (cljs.core.contains_QMARK_(known_externs,top_16365)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16366)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_16365);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16366)),";");
}
} else {
}

var m_16367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_16363);
if(cljs.core.empty_QMARK_(m_16367)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__16366,m_16367,top_level,known_externs);
}

var G__16368 = cljs.core.next(ks);
ks = G__16368;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

