goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__14785 = s;
var map__14785__$1 = (((((!((map__14785 == null))))?(((((map__14785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14785.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14785):map__14785);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14785__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14785__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__14788 = info;
var map__14789 = G__14788;
var map__14789__$1 = (((((!((map__14789 == null))))?(((((map__14789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14789):map__14789);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14789__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__14788__$1 = G__14788;
while(true){
var d__$2 = d__$1;
var map__14793 = G__14788__$1;
var map__14793__$1 = (((((!((map__14793 == null))))?(((((map__14793.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14793.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14793):map__14793);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14793__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__15619 = (d__$2 + (1));
var G__15620 = shadow__$2;
d__$1 = G__15619;
G__14788__$1 = G__15620;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__14801){
var map__14802 = p__14801;
var map__14802__$1 = (((((!((map__14802 == null))))?(((((map__14802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14802):map__14802);
var name_var = map__14802__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14802__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14802__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__14804 = info;
var map__14804__$1 = (((((!((map__14804 == null))))?(((((map__14804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14804):map__14804);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14804__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14804__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__14806 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__14806) : cljs.compiler.munge.call(null,G__14806));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__14823 = arguments.length;
switch (G__14823) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__14825 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__14825.cljs$core$IFn$_invoke$arity$1 ? fexpr__14825.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__14825.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__14826 = cp;
switch (G__14826) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__14827_15627 = cljs.core.seq(s);
var chunk__14828_15628 = null;
var count__14829_15629 = (0);
var i__14830_15630 = (0);
while(true){
if((i__14830_15630 < count__14829_15629)){
var c_15631 = chunk__14828_15628.cljs$core$IIndexed$_nth$arity$2(null,i__14830_15630);
sb.append(cljs.compiler.escape_char(c_15631));


var G__15632 = seq__14827_15627;
var G__15633 = chunk__14828_15628;
var G__15634 = count__14829_15629;
var G__15635 = (i__14830_15630 + (1));
seq__14827_15627 = G__15632;
chunk__14828_15628 = G__15633;
count__14829_15629 = G__15634;
i__14830_15630 = G__15635;
continue;
} else {
var temp__5735__auto___15636 = cljs.core.seq(seq__14827_15627);
if(temp__5735__auto___15636){
var seq__14827_15637__$1 = temp__5735__auto___15636;
if(cljs.core.chunked_seq_QMARK_(seq__14827_15637__$1)){
var c__4609__auto___15638 = cljs.core.chunk_first(seq__14827_15637__$1);
var G__15639 = cljs.core.chunk_rest(seq__14827_15637__$1);
var G__15640 = c__4609__auto___15638;
var G__15641 = cljs.core.count(c__4609__auto___15638);
var G__15642 = (0);
seq__14827_15627 = G__15639;
chunk__14828_15628 = G__15640;
count__14829_15629 = G__15641;
i__14830_15630 = G__15642;
continue;
} else {
var c_15647 = cljs.core.first(seq__14827_15637__$1);
sb.append(cljs.compiler.escape_char(c_15647));


var G__15648 = cljs.core.next(seq__14827_15637__$1);
var G__15649 = null;
var G__15650 = (0);
var G__15651 = (0);
seq__14827_15627 = G__15648;
chunk__14828_15628 = G__15649;
count__14829_15629 = G__15650;
i__14830_15630 = G__15651;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14831 = cljs.core.get_global_hierarchy;
return (fexpr__14831.cljs$core$IFn$_invoke$arity$0 ? fexpr__14831.cljs$core$IFn$_invoke$arity$0() : fexpr__14831.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__14832_15652 = ast;
var map__14832_15653__$1 = (((((!((map__14832_15652 == null))))?(((((map__14832_15652.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14832_15652.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14832_15652):map__14832_15652);
var env_15654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14832_15653__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_15654))){
var map__14834_15655 = env_15654;
var map__14834_15656__$1 = (((((!((map__14834_15655 == null))))?(((((map__14834_15655.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14834_15655.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14834_15655):map__14834_15655);
var line_15657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14834_15656__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_15658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14834_15656__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__14837 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__14839 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__14838 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__14838.cljs$core$IFn$_invoke$arity$1 ? fexpr__14838.cljs$core$IFn$_invoke$arity$1(G__14839) : fexpr__14838.call(null,G__14839));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14837,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__14837;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_15657 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_15658)?(column_15658 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__14849 = arguments.length;
switch (G__14849) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___15667 = arguments.length;
var i__4790__auto___15668 = (0);
while(true){
if((i__4790__auto___15668 < len__4789__auto___15667)){
args_arr__4810__auto__.push((arguments[i__4790__auto___15668]));

var G__15669 = (i__4790__auto___15668 + (1));
i__4790__auto___15668 = G__15669;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_15670 = (function (){var G__14850 = a;
if((!(typeof a === 'string'))){
return G__14850.toString();
} else {
return G__14850;
}
})();
var temp__5739__auto___15671 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___15671 == null)){
} else {
var sm_data_15672 = temp__5739__auto___15671;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_15672,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__14841_SHARP_){
return (p1__14841_SHARP_ + s_15670.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_15670], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__14856 = cljs.core.seq(xs);
var chunk__14857 = null;
var count__14858 = (0);
var i__14859 = (0);
while(true){
if((i__14859 < count__14858)){
var x = chunk__14857.cljs$core$IIndexed$_nth$arity$2(null,i__14859);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__15676 = seq__14856;
var G__15677 = chunk__14857;
var G__15678 = count__14858;
var G__15679 = (i__14859 + (1));
seq__14856 = G__15676;
chunk__14857 = G__15677;
count__14858 = G__15678;
i__14859 = G__15679;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__14856);
if(temp__5735__auto__){
var seq__14856__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14856__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__14856__$1);
var G__15680 = cljs.core.chunk_rest(seq__14856__$1);
var G__15681 = c__4609__auto__;
var G__15682 = cljs.core.count(c__4609__auto__);
var G__15683 = (0);
seq__14856 = G__15680;
chunk__14857 = G__15681;
count__14858 = G__15682;
i__14859 = G__15683;
continue;
} else {
var x = cljs.core.first(seq__14856__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__15684 = cljs.core.next(seq__14856__$1);
var G__15685 = null;
var G__15686 = (0);
var G__15687 = (0);
seq__14856 = G__15684;
chunk__14857 = G__15685;
count__14858 = G__15686;
i__14859 = G__15687;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq14843){
var G__14844 = cljs.core.first(seq14843);
var seq14843__$1 = cljs.core.next(seq14843);
var G__14845 = cljs.core.first(seq14843__$1);
var seq14843__$2 = cljs.core.next(seq14843__$1);
var G__14846 = cljs.core.first(seq14843__$2);
var seq14843__$3 = cljs.core.next(seq14843__$2);
var G__14847 = cljs.core.first(seq14843__$3);
var seq14843__$4 = cljs.core.next(seq14843__$3);
var G__14848 = cljs.core.first(seq14843__$4);
var seq14843__$5 = cljs.core.next(seq14843__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14844,G__14845,G__14846,G__14847,G__14848,seq14843__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__14860){
var map__14861 = p__14860;
var map__14861__$1 = (((((!((map__14861 == null))))?(((((map__14861.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14861.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14861):map__14861);
var m = map__14861__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14861__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__14870 = arguments.length;
switch (G__14870) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___15692 = arguments.length;
var i__4790__auto___15693 = (0);
while(true){
if((i__4790__auto___15693 < len__4789__auto___15692)){
args_arr__4810__auto__.push((arguments[i__4790__auto___15693]));

var G__15694 = (i__4790__auto___15693 + (1));
i__4790__auto___15693 = G__15694;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__14871_15695 = cljs.core.seq(xs);
var chunk__14872_15696 = null;
var count__14873_15697 = (0);
var i__14874_15698 = (0);
while(true){
if((i__14874_15698 < count__14873_15697)){
var x_15699 = chunk__14872_15696.cljs$core$IIndexed$_nth$arity$2(null,i__14874_15698);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_15699);


var G__15700 = seq__14871_15695;
var G__15701 = chunk__14872_15696;
var G__15702 = count__14873_15697;
var G__15703 = (i__14874_15698 + (1));
seq__14871_15695 = G__15700;
chunk__14872_15696 = G__15701;
count__14873_15697 = G__15702;
i__14874_15698 = G__15703;
continue;
} else {
var temp__5735__auto___15704 = cljs.core.seq(seq__14871_15695);
if(temp__5735__auto___15704){
var seq__14871_15705__$1 = temp__5735__auto___15704;
if(cljs.core.chunked_seq_QMARK_(seq__14871_15705__$1)){
var c__4609__auto___15706 = cljs.core.chunk_first(seq__14871_15705__$1);
var G__15707 = cljs.core.chunk_rest(seq__14871_15705__$1);
var G__15708 = c__4609__auto___15706;
var G__15709 = cljs.core.count(c__4609__auto___15706);
var G__15710 = (0);
seq__14871_15695 = G__15707;
chunk__14872_15696 = G__15708;
count__14873_15697 = G__15709;
i__14874_15698 = G__15710;
continue;
} else {
var x_15711 = cljs.core.first(seq__14871_15705__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_15711);


var G__15712 = cljs.core.next(seq__14871_15705__$1);
var G__15713 = null;
var G__15714 = (0);
var G__15715 = (0);
seq__14871_15695 = G__15712;
chunk__14872_15696 = G__15713;
count__14873_15697 = G__15714;
i__14874_15698 = G__15715;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq14864){
var G__14865 = cljs.core.first(seq14864);
var seq14864__$1 = cljs.core.next(seq14864);
var G__14866 = cljs.core.first(seq14864__$1);
var seq14864__$2 = cljs.core.next(seq14864__$1);
var G__14867 = cljs.core.first(seq14864__$2);
var seq14864__$3 = cljs.core.next(seq14864__$2);
var G__14868 = cljs.core.first(seq14864__$3);
var seq14864__$4 = cljs.core.next(seq14864__$3);
var G__14869 = cljs.core.first(seq14864__$4);
var seq14864__$5 = cljs.core.next(seq14864__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14865,G__14866,G__14867,G__14868,G__14869,seq14864__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__14879_15720 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__14880_15721 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__14881_15722 = true;
var _STAR_print_fn_STAR__temp_val__14882_15723 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__14881_15722);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__14882_15723);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__14880_15721);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__14879_15720);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14884 = cljs.core.get_global_hierarchy;
return (fexpr__14884.cljs$core$IFn$_invoke$arity$0 ? fexpr__14884.cljs$core$IFn$_invoke$arity$0() : fexpr__14884.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__14886 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14886,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14886,(1),null);
var G__14889 = ns;
var G__14890 = name;
var G__14891 = (function (){
var G__14892 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__14892) : cljs.compiler.emit_constant.call(null,G__14892));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__14889,G__14890,G__14891) : cljs.compiler.emit_record_value.call(null,G__14889,G__14890,G__14891));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__14894 = cljs.core.keys(x);
var G__14895 = cljs.core.vals(x);
var G__14896 = cljs.compiler.emit_constants_comma_sep;
var G__14897 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__14894,G__14895,G__14896,G__14897) : cljs.compiler.emit_map.call(null,G__14894,G__14895,G__14896,G__14897));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__14898 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__14899 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__14898,G__14899) : cljs.compiler.emit_with_meta.call(null,G__14898,G__14899));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__14903 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14903,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14903,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14903,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__14928 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__14928) : x.call(null,G__14928));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__14929 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__14929) : x.call(null,G__14929));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__14936 = items;
var G__14937 = (function (p1__14935_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__14935_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__14936,G__14937) : cljs.compiler.emit_js_object.call(null,G__14936,G__14937));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__14939){
var map__14940 = p__14939;
var map__14940__$1 = (((((!((map__14940 == null))))?(((((map__14940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14940.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14940):map__14940);
var ast = map__14940__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14940__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14940__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14940__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__14942 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__14942__$1 = (((((!((map__14942 == null))))?(((((map__14942.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14942.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14942):map__14942);
var cenv = map__14942__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14942__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__14944 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__14949 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__14949) : cljs.compiler.es5_GT__EQ_.call(null,G__14949));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__14944,cljs.analyzer.es5_allowed);
} else {
return G__14944;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__14955 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__14955,reserved);
} else {
return G__14955;
}
})();
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__14957_15732 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__14957_15733__$1 = (((G__14957_15732 instanceof cljs.core.Keyword))?G__14957_15732.fqn:null);
switch (G__14957_15733__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__14958){
var map__14959 = p__14958;
var map__14959__$1 = (((((!((map__14959 == null))))?(((((map__14959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14959.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14959):map__14959);
var arg = map__14959__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14959__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14959__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14959__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14959__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__14961 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__14961__$1 = (((((!((map__14961 == null))))?(((((map__14961.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14961.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14961):map__14961);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14961__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__14963){
var map__14964 = p__14963;
var map__14964__$1 = (((((!((map__14964 == null))))?(((((map__14964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14964.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14964):map__14964);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14964__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14964__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14964__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__14967_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__14967_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__14975 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14975) : comma_sep.call(null,G__14975));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__14976 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14976) : comma_sep.call(null,G__14976));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__14977){
var map__14978 = p__14977;
var map__14978__$1 = (((((!((map__14978 == null))))?(((((map__14978.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14978.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14978):map__14978);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14978__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14978__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14978__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__14980){
var map__14981 = p__14980;
var map__14981__$1 = (((((!((map__14981 == null))))?(((((map__14981.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14981.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14981):map__14981);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14981__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14981__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__14983_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__14983_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__14984 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14984) : comma_sep.call(null,G__14984));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__14985){
var map__14986 = p__14985;
var map__14986__$1 = (((((!((map__14986 == null))))?(((((map__14986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14986.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14986):map__14986);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14986__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14986__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___15745 = cljs.core.seq(items);
if(temp__5735__auto___15745){
var items_15746__$1 = temp__5735__auto___15745;
var vec__14991_15747 = items_15746__$1;
var seq__14992_15748 = cljs.core.seq(vec__14991_15747);
var first__14993_15749 = cljs.core.first(seq__14992_15748);
var seq__14992_15750__$1 = cljs.core.next(seq__14992_15748);
var vec__14994_15751 = first__14993_15749;
var k_15752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14994_15751,(0),null);
var v_15753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14994_15751,(1),null);
var r_15754 = seq__14992_15750__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_15752),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_15753) : emit_js_object_val.call(null,v_15753)));

var seq__14997_15755 = cljs.core.seq(r_15754);
var chunk__14998_15756 = null;
var count__14999_15757 = (0);
var i__15000_15758 = (0);
while(true){
if((i__15000_15758 < count__14999_15757)){
var vec__15007_15759 = chunk__14998_15756.cljs$core$IIndexed$_nth$arity$2(null,i__15000_15758);
var k_15760__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007_15759,(0),null);
var v_15761__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007_15759,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_15760__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_15761__$1) : emit_js_object_val.call(null,v_15761__$1)));


var G__15762 = seq__14997_15755;
var G__15763 = chunk__14998_15756;
var G__15764 = count__14999_15757;
var G__15765 = (i__15000_15758 + (1));
seq__14997_15755 = G__15762;
chunk__14998_15756 = G__15763;
count__14999_15757 = G__15764;
i__15000_15758 = G__15765;
continue;
} else {
var temp__5735__auto___15766__$1 = cljs.core.seq(seq__14997_15755);
if(temp__5735__auto___15766__$1){
var seq__14997_15767__$1 = temp__5735__auto___15766__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14997_15767__$1)){
var c__4609__auto___15768 = cljs.core.chunk_first(seq__14997_15767__$1);
var G__15769 = cljs.core.chunk_rest(seq__14997_15767__$1);
var G__15770 = c__4609__auto___15768;
var G__15771 = cljs.core.count(c__4609__auto___15768);
var G__15772 = (0);
seq__14997_15755 = G__15769;
chunk__14998_15756 = G__15770;
count__14999_15757 = G__15771;
i__15000_15758 = G__15772;
continue;
} else {
var vec__15013_15773 = cljs.core.first(seq__14997_15767__$1);
var k_15774__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15013_15773,(0),null);
var v_15775__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15013_15773,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_15774__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_15775__$1) : emit_js_object_val.call(null,v_15775__$1)));


var G__15776 = cljs.core.next(seq__14997_15767__$1);
var G__15777 = null;
var G__15778 = (0);
var G__15779 = (0);
seq__14997_15755 = G__15776;
chunk__14998_15756 = G__15777;
count__14999_15757 = G__15778;
i__15000_15758 = G__15779;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__15016){
var map__15017 = p__15016;
var map__15017__$1 = (((((!((map__15017 == null))))?(((((map__15017.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15017.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15017):map__15017);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15017__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15017__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15017__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__15019){
var map__15020 = p__15019;
var map__15020__$1 = (((((!((map__15020 == null))))?(((((map__15020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15020.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15020):map__15020);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15020__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15020__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__15022){
var map__15027 = p__15022;
var map__15027__$1 = (((((!((map__15027 == null))))?(((((map__15027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15027.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15027):map__15027);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15027__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__15029){
var map__15030 = p__15029;
var map__15030__$1 = (((((!((map__15030 == null))))?(((((map__15030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15030.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15030):map__15030);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15030__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15030__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__15032 = cljs.analyzer.unwrap_quote(expr);
var map__15032__$1 = (((((!((map__15032 == null))))?(((((map__15032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15032):map__15032);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15032__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15032__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15032__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__15034 = cljs.analyzer.unwrap_quote(expr);
var map__15034__$1 = (((((!((map__15034 == null))))?(((((map__15034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15034.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15034):map__15034);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15034__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15034__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15034__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__15041 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__15041.cljs$core$IFn$_invoke$arity$1 ? fexpr__15041.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15041.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__15042){
var map__15043 = p__15042;
var map__15043__$1 = (((((!((map__15043 == null))))?(((((map__15043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15043.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15043):map__15043);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15043__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15043__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15043__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15043__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15043__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__15045){
var map__15046 = p__15045;
var map__15046__$1 = (((((!((map__15046 == null))))?(((((map__15046.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15046.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15046):map__15046);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15046__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15046__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15046__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15046__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__15048_15804 = cljs.core.seq(nodes);
var chunk__15049_15805 = null;
var count__15050_15806 = (0);
var i__15051_15807 = (0);
while(true){
if((i__15051_15807 < count__15050_15806)){
var map__15088_15808 = chunk__15049_15805.cljs$core$IIndexed$_nth$arity$2(null,i__15051_15807);
var map__15088_15809__$1 = (((((!((map__15088_15808 == null))))?(((((map__15088_15808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15088_15808.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15088_15808):map__15088_15808);
var ts_15810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15088_15809__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15089_15811 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15088_15809__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15089_15812__$1 = (((((!((map__15089_15811 == null))))?(((((map__15089_15811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15089_15811.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15089_15811):map__15089_15811);
var then_15813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15089_15812__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15092_15814 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_15810));
var chunk__15093_15815 = null;
var count__15094_15816 = (0);
var i__15095_15817 = (0);
while(true){
if((i__15095_15817 < count__15094_15816)){
var test_15818 = chunk__15093_15815.cljs$core$IIndexed$_nth$arity$2(null,i__15095_15817);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15818,":");


var G__15819 = seq__15092_15814;
var G__15820 = chunk__15093_15815;
var G__15821 = count__15094_15816;
var G__15822 = (i__15095_15817 + (1));
seq__15092_15814 = G__15819;
chunk__15093_15815 = G__15820;
count__15094_15816 = G__15821;
i__15095_15817 = G__15822;
continue;
} else {
var temp__5735__auto___15823 = cljs.core.seq(seq__15092_15814);
if(temp__5735__auto___15823){
var seq__15092_15824__$1 = temp__5735__auto___15823;
if(cljs.core.chunked_seq_QMARK_(seq__15092_15824__$1)){
var c__4609__auto___15825 = cljs.core.chunk_first(seq__15092_15824__$1);
var G__15826 = cljs.core.chunk_rest(seq__15092_15824__$1);
var G__15827 = c__4609__auto___15825;
var G__15828 = cljs.core.count(c__4609__auto___15825);
var G__15829 = (0);
seq__15092_15814 = G__15826;
chunk__15093_15815 = G__15827;
count__15094_15816 = G__15828;
i__15095_15817 = G__15829;
continue;
} else {
var test_15830 = cljs.core.first(seq__15092_15824__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15830,":");


var G__15831 = cljs.core.next(seq__15092_15824__$1);
var G__15832 = null;
var G__15833 = (0);
var G__15834 = (0);
seq__15092_15814 = G__15831;
chunk__15093_15815 = G__15832;
count__15094_15816 = G__15833;
i__15095_15817 = G__15834;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_15813);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_15813);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__15835 = seq__15048_15804;
var G__15836 = chunk__15049_15805;
var G__15837 = count__15050_15806;
var G__15838 = (i__15051_15807 + (1));
seq__15048_15804 = G__15835;
chunk__15049_15805 = G__15836;
count__15050_15806 = G__15837;
i__15051_15807 = G__15838;
continue;
} else {
var temp__5735__auto___15839 = cljs.core.seq(seq__15048_15804);
if(temp__5735__auto___15839){
var seq__15048_15843__$1 = temp__5735__auto___15839;
if(cljs.core.chunked_seq_QMARK_(seq__15048_15843__$1)){
var c__4609__auto___15845 = cljs.core.chunk_first(seq__15048_15843__$1);
var G__15846 = cljs.core.chunk_rest(seq__15048_15843__$1);
var G__15847 = c__4609__auto___15845;
var G__15848 = cljs.core.count(c__4609__auto___15845);
var G__15849 = (0);
seq__15048_15804 = G__15846;
chunk__15049_15805 = G__15847;
count__15050_15806 = G__15848;
i__15051_15807 = G__15849;
continue;
} else {
var map__15096_15850 = cljs.core.first(seq__15048_15843__$1);
var map__15096_15851__$1 = (((((!((map__15096_15850 == null))))?(((((map__15096_15850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15096_15850.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15096_15850):map__15096_15850);
var ts_15852 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15096_15851__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15097_15853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15096_15851__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15097_15854__$1 = (((((!((map__15097_15853 == null))))?(((((map__15097_15853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15097_15853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15097_15853):map__15097_15853);
var then_15855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15097_15854__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15134_15856 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_15852));
var chunk__15135_15857 = null;
var count__15136_15858 = (0);
var i__15137_15859 = (0);
while(true){
if((i__15137_15859 < count__15136_15858)){
var test_15860 = chunk__15135_15857.cljs$core$IIndexed$_nth$arity$2(null,i__15137_15859);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15860,":");


var G__15861 = seq__15134_15856;
var G__15862 = chunk__15135_15857;
var G__15863 = count__15136_15858;
var G__15864 = (i__15137_15859 + (1));
seq__15134_15856 = G__15861;
chunk__15135_15857 = G__15862;
count__15136_15858 = G__15863;
i__15137_15859 = G__15864;
continue;
} else {
var temp__5735__auto___15865__$1 = cljs.core.seq(seq__15134_15856);
if(temp__5735__auto___15865__$1){
var seq__15134_15866__$1 = temp__5735__auto___15865__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15134_15866__$1)){
var c__4609__auto___15867 = cljs.core.chunk_first(seq__15134_15866__$1);
var G__15868 = cljs.core.chunk_rest(seq__15134_15866__$1);
var G__15869 = c__4609__auto___15867;
var G__15870 = cljs.core.count(c__4609__auto___15867);
var G__15871 = (0);
seq__15134_15856 = G__15868;
chunk__15135_15857 = G__15869;
count__15136_15858 = G__15870;
i__15137_15859 = G__15871;
continue;
} else {
var test_15872 = cljs.core.first(seq__15134_15866__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_15872,":");


var G__15873 = cljs.core.next(seq__15134_15866__$1);
var G__15874 = null;
var G__15875 = (0);
var G__15876 = (0);
seq__15134_15856 = G__15873;
chunk__15135_15857 = G__15874;
count__15136_15858 = G__15875;
i__15137_15859 = G__15876;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_15855);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_15855);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__15890 = cljs.core.next(seq__15048_15843__$1);
var G__15891 = null;
var G__15892 = (0);
var G__15893 = (0);
seq__15048_15804 = G__15890;
chunk__15049_15805 = G__15891;
count__15050_15806 = G__15892;
i__15051_15807 = G__15893;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__15138){
var map__15139 = p__15138;
var map__15139__$1 = (((((!((map__15139 == null))))?(((((map__15139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15139):map__15139);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15139__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15139__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15144 = env;
var G__15145 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15144,G__15145) : cljs.compiler.resolve_type.call(null,G__15144,G__15145));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__15155 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15155,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15155,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__15141_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__15141_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__15141_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__15158 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__15158,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__15158;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15161 = env;
var G__15162 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15161,G__15162) : cljs.compiler.resolve_type.call(null,G__15161,G__15162));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15163_SHARP_){
return cljs.compiler.resolve_type(env,p1__15163_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__15164 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15165 = cljs.core.seq(vec__15164);
var first__15166 = cljs.core.first(seq__15165);
var seq__15165__$1 = cljs.core.next(seq__15165);
var p = first__15166;
var first__15166__$1 = cljs.core.first(seq__15165__$1);
var seq__15165__$2 = cljs.core.next(seq__15165__$1);
var ts = first__15166__$1;
var first__15166__$2 = cljs.core.first(seq__15165__$2);
var seq__15165__$3 = cljs.core.next(seq__15165__$2);
var n = first__15166__$2;
var xs = seq__15165__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__15189 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15190 = cljs.core.seq(vec__15189);
var first__15191 = cljs.core.first(seq__15190);
var seq__15190__$1 = cljs.core.next(seq__15190);
var p = first__15191;
var first__15191__$1 = cljs.core.first(seq__15190__$1);
var seq__15190__$2 = cljs.core.next(seq__15190__$1);
var ts = first__15191__$1;
var xs = seq__15190__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__15193 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__15192 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__15192.cljs$core$IFn$_invoke$arity$1 ? fexpr__15192.cljs$core$IFn$_invoke$arity$1(G__15193) : fexpr__15192.call(null,G__15193));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__15196 = arguments.length;
switch (G__15196) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__15211 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15194_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__15194_SHARP_);
} else {
return p1__15194_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__15212 = cljs.core.seq(vec__15211);
var first__15213 = cljs.core.first(seq__15212);
var seq__15212__$1 = cljs.core.next(seq__15212);
var x = first__15213;
var ys = seq__15212__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__15214 = cljs.core.seq(ys);
var chunk__15215 = null;
var count__15216 = (0);
var i__15217 = (0);
while(true){
if((i__15217 < count__15216)){
var next_line = chunk__15215.cljs$core$IIndexed$_nth$arity$2(null,i__15217);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__15911 = seq__15214;
var G__15912 = chunk__15215;
var G__15913 = count__15216;
var G__15914 = (i__15217 + (1));
seq__15214 = G__15911;
chunk__15215 = G__15912;
count__15216 = G__15913;
i__15217 = G__15914;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15214);
if(temp__5735__auto__){
var seq__15214__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15214__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15214__$1);
var G__15915 = cljs.core.chunk_rest(seq__15214__$1);
var G__15916 = c__4609__auto__;
var G__15917 = cljs.core.count(c__4609__auto__);
var G__15918 = (0);
seq__15214 = G__15915;
chunk__15215 = G__15916;
count__15216 = G__15917;
i__15217 = G__15918;
continue;
} else {
var next_line = cljs.core.first(seq__15214__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__15919 = cljs.core.next(seq__15214__$1);
var G__15920 = null;
var G__15921 = (0);
var G__15922 = (0);
seq__15214 = G__15919;
chunk__15215 = G__15920;
count__15216 = G__15921;
i__15217 = G__15922;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__15218_15923 = cljs.core.seq(docs__$2);
var chunk__15219_15924 = null;
var count__15220_15925 = (0);
var i__15221_15926 = (0);
while(true){
if((i__15221_15926 < count__15220_15925)){
var e_15927 = chunk__15219_15924.cljs$core$IIndexed$_nth$arity$2(null,i__15221_15926);
if(cljs.core.truth_(e_15927)){
print_comment_lines(e_15927);
} else {
}


var G__15928 = seq__15218_15923;
var G__15929 = chunk__15219_15924;
var G__15930 = count__15220_15925;
var G__15931 = (i__15221_15926 + (1));
seq__15218_15923 = G__15928;
chunk__15219_15924 = G__15929;
count__15220_15925 = G__15930;
i__15221_15926 = G__15931;
continue;
} else {
var temp__5735__auto___15932 = cljs.core.seq(seq__15218_15923);
if(temp__5735__auto___15932){
var seq__15218_15933__$1 = temp__5735__auto___15932;
if(cljs.core.chunked_seq_QMARK_(seq__15218_15933__$1)){
var c__4609__auto___15934 = cljs.core.chunk_first(seq__15218_15933__$1);
var G__15935 = cljs.core.chunk_rest(seq__15218_15933__$1);
var G__15936 = c__4609__auto___15934;
var G__15937 = cljs.core.count(c__4609__auto___15934);
var G__15938 = (0);
seq__15218_15923 = G__15935;
chunk__15219_15924 = G__15936;
count__15220_15925 = G__15937;
i__15221_15926 = G__15938;
continue;
} else {
var e_15939 = cljs.core.first(seq__15218_15933__$1);
if(cljs.core.truth_(e_15939)){
print_comment_lines(e_15939);
} else {
}


var G__15940 = cljs.core.next(seq__15218_15933__$1);
var G__15941 = null;
var G__15942 = (0);
var G__15943 = (0);
seq__15218_15923 = G__15940;
chunk__15219_15924 = G__15941;
count__15220_15925 = G__15942;
i__15221_15926 = G__15943;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__15243_SHARP_){
return goog.string.startsWith(p1__15243_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__15244){
var map__15245 = p__15244;
var map__15245__$1 = (((((!((map__15245 == null))))?(((((map__15245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15245.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15245):map__15245);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15245__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__15261){
var map__15262 = p__15261;
var map__15262__$1 = (((((!((map__15262 == null))))?(((((map__15262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15262):map__15262);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15262__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15262__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15262__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__15264_15965 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__15265_15966 = null;
var count__15266_15967 = (0);
var i__15267_15968 = (0);
while(true){
if((i__15267_15968 < count__15266_15967)){
var vec__15274_15969 = chunk__15265_15966.cljs$core$IIndexed$_nth$arity$2(null,i__15267_15968);
var i_15970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15274_15969,(0),null);
var param_15971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15274_15969,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_15971);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__15972 = seq__15264_15965;
var G__15973 = chunk__15265_15966;
var G__15974 = count__15266_15967;
var G__15975 = (i__15267_15968 + (1));
seq__15264_15965 = G__15972;
chunk__15265_15966 = G__15973;
count__15266_15967 = G__15974;
i__15267_15968 = G__15975;
continue;
} else {
var temp__5735__auto___15976 = cljs.core.seq(seq__15264_15965);
if(temp__5735__auto___15976){
var seq__15264_15977__$1 = temp__5735__auto___15976;
if(cljs.core.chunked_seq_QMARK_(seq__15264_15977__$1)){
var c__4609__auto___15978 = cljs.core.chunk_first(seq__15264_15977__$1);
var G__15979 = cljs.core.chunk_rest(seq__15264_15977__$1);
var G__15980 = c__4609__auto___15978;
var G__15981 = cljs.core.count(c__4609__auto___15978);
var G__15982 = (0);
seq__15264_15965 = G__15979;
chunk__15265_15966 = G__15980;
count__15266_15967 = G__15981;
i__15267_15968 = G__15982;
continue;
} else {
var vec__15277_15983 = cljs.core.first(seq__15264_15977__$1);
var i_15984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15277_15983,(0),null);
var param_15985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15277_15983,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_15985);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__15986 = cljs.core.next(seq__15264_15977__$1);
var G__15987 = null;
var G__15988 = (0);
var G__15989 = (0);
seq__15264_15965 = G__15986;
chunk__15265_15966 = G__15987;
count__15266_15967 = G__15988;
i__15267_15968 = G__15989;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15280_15990 = cljs.core.seq(params);
var chunk__15281_15991 = null;
var count__15282_15992 = (0);
var i__15283_15993 = (0);
while(true){
if((i__15283_15993 < count__15282_15992)){
var param_15994 = chunk__15281_15991.cljs$core$IIndexed$_nth$arity$2(null,i__15283_15993);
cljs.compiler.emit(param_15994);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_15994,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__15995 = seq__15280_15990;
var G__15996 = chunk__15281_15991;
var G__15997 = count__15282_15992;
var G__15998 = (i__15283_15993 + (1));
seq__15280_15990 = G__15995;
chunk__15281_15991 = G__15996;
count__15282_15992 = G__15997;
i__15283_15993 = G__15998;
continue;
} else {
var temp__5735__auto___15999 = cljs.core.seq(seq__15280_15990);
if(temp__5735__auto___15999){
var seq__15280_16000__$1 = temp__5735__auto___15999;
if(cljs.core.chunked_seq_QMARK_(seq__15280_16000__$1)){
var c__4609__auto___16002 = cljs.core.chunk_first(seq__15280_16000__$1);
var G__16003 = cljs.core.chunk_rest(seq__15280_16000__$1);
var G__16004 = c__4609__auto___16002;
var G__16005 = cljs.core.count(c__4609__auto___16002);
var G__16006 = (0);
seq__15280_15990 = G__16003;
chunk__15281_15991 = G__16004;
count__15282_15992 = G__16005;
i__15283_15993 = G__16006;
continue;
} else {
var param_16007 = cljs.core.first(seq__15280_16000__$1);
cljs.compiler.emit(param_16007);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16007,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16009 = cljs.core.next(seq__15280_16000__$1);
var G__16010 = null;
var G__16011 = (0);
var G__16012 = (0);
seq__15280_15990 = G__16009;
chunk__15281_15991 = G__16010;
count__15282_15992 = G__16011;
i__15283_15993 = G__16012;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15285_16020 = cljs.core.seq(params);
var chunk__15286_16021 = null;
var count__15287_16022 = (0);
var i__15288_16023 = (0);
while(true){
if((i__15288_16023 < count__15287_16022)){
var param_16024 = chunk__15286_16021.cljs$core$IIndexed$_nth$arity$2(null,i__15288_16023);
cljs.compiler.emit(param_16024);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16024,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16025 = seq__15285_16020;
var G__16026 = chunk__15286_16021;
var G__16027 = count__15287_16022;
var G__16028 = (i__15288_16023 + (1));
seq__15285_16020 = G__16025;
chunk__15286_16021 = G__16026;
count__15287_16022 = G__16027;
i__15288_16023 = G__16028;
continue;
} else {
var temp__5735__auto___16029 = cljs.core.seq(seq__15285_16020);
if(temp__5735__auto___16029){
var seq__15285_16030__$1 = temp__5735__auto___16029;
if(cljs.core.chunked_seq_QMARK_(seq__15285_16030__$1)){
var c__4609__auto___16031 = cljs.core.chunk_first(seq__15285_16030__$1);
var G__16032 = cljs.core.chunk_rest(seq__15285_16030__$1);
var G__16033 = c__4609__auto___16031;
var G__16034 = cljs.core.count(c__4609__auto___16031);
var G__16035 = (0);
seq__15285_16020 = G__16032;
chunk__15286_16021 = G__16033;
count__15287_16022 = G__16034;
i__15288_16023 = G__16035;
continue;
} else {
var param_16036 = cljs.core.first(seq__15285_16030__$1);
cljs.compiler.emit(param_16036);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16036,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16042 = cljs.core.next(seq__15285_16030__$1);
var G__16043 = null;
var G__16044 = (0);
var G__16045 = (0);
seq__15285_16020 = G__16042;
chunk__15286_16021 = G__16043;
count__15287_16022 = G__16044;
i__15288_16023 = G__16045;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__15305 = cljs.core.seq(params);
var chunk__15306 = null;
var count__15307 = (0);
var i__15308 = (0);
while(true){
if((i__15308 < count__15307)){
var param = chunk__15306.cljs$core$IIndexed$_nth$arity$2(null,i__15308);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16052 = seq__15305;
var G__16053 = chunk__15306;
var G__16054 = count__15307;
var G__16055 = (i__15308 + (1));
seq__15305 = G__16052;
chunk__15306 = G__16053;
count__15307 = G__16054;
i__15308 = G__16055;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15305);
if(temp__5735__auto__){
var seq__15305__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15305__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15305__$1);
var G__16057 = cljs.core.chunk_rest(seq__15305__$1);
var G__16058 = c__4609__auto__;
var G__16059 = cljs.core.count(c__4609__auto__);
var G__16060 = (0);
seq__15305 = G__16057;
chunk__15306 = G__16058;
count__15307 = G__16059;
i__15308 = G__16060;
continue;
} else {
var param = cljs.core.first(seq__15305__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16061 = cljs.core.next(seq__15305__$1);
var G__16062 = null;
var G__16063 = (0);
var G__16064 = (0);
seq__15305 = G__16061;
chunk__15306 = G__16062;
count__15307 = G__16063;
i__15308 = G__16064;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__15318){
var map__15319 = p__15318;
var map__15319__$1 = (((((!((map__15319 == null))))?(((((map__15319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15319.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15319):map__15319);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15319__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15319__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15319__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15319__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15319__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15319__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__15321){
var map__15322 = p__15321;
var map__15322__$1 = (((((!((map__15322 == null))))?(((((map__15322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15322.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15322):map__15322);
var f = map__15322__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15322__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_16065__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16066 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16065__$1);
var delegate_name_16067 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16066),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_16067," = function (");

var seq__15328_16068 = cljs.core.seq(params);
var chunk__15329_16069 = null;
var count__15330_16070 = (0);
var i__15331_16071 = (0);
while(true){
if((i__15331_16071 < count__15330_16070)){
var param_16072 = chunk__15329_16069.cljs$core$IIndexed$_nth$arity$2(null,i__15331_16071);
cljs.compiler.emit(param_16072);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16072,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16073 = seq__15328_16068;
var G__16074 = chunk__15329_16069;
var G__16075 = count__15330_16070;
var G__16076 = (i__15331_16071 + (1));
seq__15328_16068 = G__16073;
chunk__15329_16069 = G__16074;
count__15330_16070 = G__16075;
i__15331_16071 = G__16076;
continue;
} else {
var temp__5735__auto___16077 = cljs.core.seq(seq__15328_16068);
if(temp__5735__auto___16077){
var seq__15328_16078__$1 = temp__5735__auto___16077;
if(cljs.core.chunked_seq_QMARK_(seq__15328_16078__$1)){
var c__4609__auto___16079 = cljs.core.chunk_first(seq__15328_16078__$1);
var G__16080 = cljs.core.chunk_rest(seq__15328_16078__$1);
var G__16081 = c__4609__auto___16079;
var G__16082 = cljs.core.count(c__4609__auto___16079);
var G__16083 = (0);
seq__15328_16068 = G__16080;
chunk__15329_16069 = G__16081;
count__15330_16070 = G__16082;
i__15331_16071 = G__16083;
continue;
} else {
var param_16084 = cljs.core.first(seq__15328_16078__$1);
cljs.compiler.emit(param_16084);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16084,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16085 = cljs.core.next(seq__15328_16078__$1);
var G__16086 = null;
var G__16087 = (0);
var G__16088 = (0);
seq__15328_16068 = G__16085;
chunk__15329_16069 = G__16086;
count__15330_16070 = G__16087;
i__15331_16071 = G__16088;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_16066," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_16092 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_16092,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_16067,".call(this,");

var seq__15333_16093 = cljs.core.seq(params);
var chunk__15334_16094 = null;
var count__15335_16095 = (0);
var i__15336_16096 = (0);
while(true){
if((i__15336_16096 < count__15335_16095)){
var param_16097 = chunk__15334_16094.cljs$core$IIndexed$_nth$arity$2(null,i__15336_16096);
cljs.compiler.emit(param_16097);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16097,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16098 = seq__15333_16093;
var G__16099 = chunk__15334_16094;
var G__16100 = count__15335_16095;
var G__16101 = (i__15336_16096 + (1));
seq__15333_16093 = G__16098;
chunk__15334_16094 = G__16099;
count__15335_16095 = G__16100;
i__15336_16096 = G__16101;
continue;
} else {
var temp__5735__auto___16102 = cljs.core.seq(seq__15333_16093);
if(temp__5735__auto___16102){
var seq__15333_16103__$1 = temp__5735__auto___16102;
if(cljs.core.chunked_seq_QMARK_(seq__15333_16103__$1)){
var c__4609__auto___16104 = cljs.core.chunk_first(seq__15333_16103__$1);
var G__16105 = cljs.core.chunk_rest(seq__15333_16103__$1);
var G__16106 = c__4609__auto___16104;
var G__16107 = cljs.core.count(c__4609__auto___16104);
var G__16108 = (0);
seq__15333_16093 = G__16105;
chunk__15334_16094 = G__16106;
count__15335_16095 = G__16107;
i__15336_16096 = G__16108;
continue;
} else {
var param_16109 = cljs.core.first(seq__15333_16103__$1);
cljs.compiler.emit(param_16109);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16109,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16110 = cljs.core.next(seq__15333_16103__$1);
var G__16111 = null;
var G__16112 = (0);
var G__16113 = (0);
seq__15333_16093 = G__16110;
chunk__15334_16094 = G__16111;
count__15335_16095 = G__16112;
i__15336_16096 = G__16113;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16066,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_16066,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_16065__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16066,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_16067,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16066,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__15340){
var map__15341 = p__15340;
var map__15341__$1 = (((((!((map__15341 == null))))?(((((map__15341.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15341.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15341):map__15341);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15341__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15337_SHARP_){
var and__4174__auto__ = p1__15337_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__15337_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_16114__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16115 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16114__$1);
var maxparams_16116 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_16117 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16115),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_16118 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__15338_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__15338_SHARP_)));
}),cljs.core.seq(mmap_16117));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_16115," = null;");

var seq__15354_16119 = cljs.core.seq(ms_16118);
var chunk__15355_16120 = null;
var count__15356_16121 = (0);
var i__15357_16122 = (0);
while(true){
if((i__15357_16122 < count__15356_16121)){
var vec__15364_16123 = chunk__15355_16120.cljs$core$IIndexed$_nth$arity$2(null,i__15357_16122);
var n_16124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15364_16123,(0),null);
var meth_16125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15364_16123,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16124," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16125))){
cljs.compiler.emit_variadic_fn_method(meth_16125);
} else {
cljs.compiler.emit_fn_method(meth_16125);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16128 = seq__15354_16119;
var G__16129 = chunk__15355_16120;
var G__16130 = count__15356_16121;
var G__16131 = (i__15357_16122 + (1));
seq__15354_16119 = G__16128;
chunk__15355_16120 = G__16129;
count__15356_16121 = G__16130;
i__15357_16122 = G__16131;
continue;
} else {
var temp__5735__auto___16132 = cljs.core.seq(seq__15354_16119);
if(temp__5735__auto___16132){
var seq__15354_16133__$1 = temp__5735__auto___16132;
if(cljs.core.chunked_seq_QMARK_(seq__15354_16133__$1)){
var c__4609__auto___16134 = cljs.core.chunk_first(seq__15354_16133__$1);
var G__16135 = cljs.core.chunk_rest(seq__15354_16133__$1);
var G__16136 = c__4609__auto___16134;
var G__16137 = cljs.core.count(c__4609__auto___16134);
var G__16138 = (0);
seq__15354_16119 = G__16135;
chunk__15355_16120 = G__16136;
count__15356_16121 = G__16137;
i__15357_16122 = G__16138;
continue;
} else {
var vec__15368_16140 = cljs.core.first(seq__15354_16133__$1);
var n_16141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15368_16140,(0),null);
var meth_16142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15368_16140,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16141," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16142))){
cljs.compiler.emit_variadic_fn_method(meth_16142);
} else {
cljs.compiler.emit_fn_method(meth_16142);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16143 = cljs.core.next(seq__15354_16133__$1);
var G__16144 = null;
var G__16145 = (0);
var G__16146 = (0);
seq__15354_16119 = G__16143;
chunk__15355_16120 = G__16144;
count__15356_16121 = G__16145;
i__15357_16122 = G__16146;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16115," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_16116),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_16116)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_16116));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__15371_16147 = cljs.core.seq(ms_16118);
var chunk__15372_16148 = null;
var count__15373_16149 = (0);
var i__15374_16150 = (0);
while(true){
if((i__15374_16150 < count__15373_16149)){
var vec__15382_16151 = chunk__15372_16148.cljs$core$IIndexed$_nth$arity$2(null,i__15374_16150);
var n_16152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15382_16151,(0),null);
var meth_16153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15382_16151,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16153))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16158 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16158," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16159 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16158," = new cljs.core.IndexedSeq(",a_16159,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16152,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16116)),(((cljs.core.count(maxparams_16116) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16158,");"], 0));
} else {
var pcnt_16160 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16153));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16160,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16152,".call(this",(((pcnt_16160 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16160,maxparams_16116)),null,(1),null)),(2),null))),");");
}


var G__16161 = seq__15371_16147;
var G__16162 = chunk__15372_16148;
var G__16163 = count__15373_16149;
var G__16164 = (i__15374_16150 + (1));
seq__15371_16147 = G__16161;
chunk__15372_16148 = G__16162;
count__15373_16149 = G__16163;
i__15374_16150 = G__16164;
continue;
} else {
var temp__5735__auto___16165 = cljs.core.seq(seq__15371_16147);
if(temp__5735__auto___16165){
var seq__15371_16166__$1 = temp__5735__auto___16165;
if(cljs.core.chunked_seq_QMARK_(seq__15371_16166__$1)){
var c__4609__auto___16167 = cljs.core.chunk_first(seq__15371_16166__$1);
var G__16168 = cljs.core.chunk_rest(seq__15371_16166__$1);
var G__16169 = c__4609__auto___16167;
var G__16170 = cljs.core.count(c__4609__auto___16167);
var G__16171 = (0);
seq__15371_16147 = G__16168;
chunk__15372_16148 = G__16169;
count__15373_16149 = G__16170;
i__15374_16150 = G__16171;
continue;
} else {
var vec__15385_16172 = cljs.core.first(seq__15371_16166__$1);
var n_16173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15385_16172,(0),null);
var meth_16174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15385_16172,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16174))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16175 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16175," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16176 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16175," = new cljs.core.IndexedSeq(",a_16176,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16173,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16116)),(((cljs.core.count(maxparams_16116) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16175,");"], 0));
} else {
var pcnt_16177 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16174));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16177,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16173,".call(this",(((pcnt_16177 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16177,maxparams_16116)),null,(1),null)),(2),null))),");");
}


var G__16178 = cljs.core.next(seq__15371_16166__$1);
var G__16179 = null;
var G__16180 = (0);
var G__16181 = (0);
seq__15371_16147 = G__16178;
chunk__15372_16148 = G__16179;
count__15373_16149 = G__16180;
i__15374_16150 = G__16181;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_16187 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_16118)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_16187,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16115,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16115,".cljs$lang$applyTo = ",cljs.core.some((function (p1__15339_SHARP_){
var vec__15388 = p1__15339_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15388,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15388,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_16118),".cljs$lang$applyTo;");
} else {
}

var seq__15391_16188 = cljs.core.seq(ms_16118);
var chunk__15392_16189 = null;
var count__15393_16190 = (0);
var i__15394_16191 = (0);
while(true){
if((i__15394_16191 < count__15393_16190)){
var vec__15401_16192 = chunk__15392_16189.cljs$core$IIndexed$_nth$arity$2(null,i__15394_16191);
var n_16193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15401_16192,(0),null);
var meth_16194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15401_16192,(1),null);
var c_16195 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16194));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16194))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16115,".cljs$core$IFn$_invoke$arity$variadic = ",n_16193,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16115,".cljs$core$IFn$_invoke$arity$",c_16195," = ",n_16193,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16196 = seq__15391_16188;
var G__16197 = chunk__15392_16189;
var G__16198 = count__15393_16190;
var G__16199 = (i__15394_16191 + (1));
seq__15391_16188 = G__16196;
chunk__15392_16189 = G__16197;
count__15393_16190 = G__16198;
i__15394_16191 = G__16199;
continue;
} else {
var temp__5735__auto___16200 = cljs.core.seq(seq__15391_16188);
if(temp__5735__auto___16200){
var seq__15391_16201__$1 = temp__5735__auto___16200;
if(cljs.core.chunked_seq_QMARK_(seq__15391_16201__$1)){
var c__4609__auto___16202 = cljs.core.chunk_first(seq__15391_16201__$1);
var G__16203 = cljs.core.chunk_rest(seq__15391_16201__$1);
var G__16204 = c__4609__auto___16202;
var G__16205 = cljs.core.count(c__4609__auto___16202);
var G__16206 = (0);
seq__15391_16188 = G__16203;
chunk__15392_16189 = G__16204;
count__15393_16190 = G__16205;
i__15394_16191 = G__16206;
continue;
} else {
var vec__15411_16207 = cljs.core.first(seq__15391_16201__$1);
var n_16208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15411_16207,(0),null);
var meth_16209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15411_16207,(1),null);
var c_16210 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16209));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16209))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16115,".cljs$core$IFn$_invoke$arity$variadic = ",n_16208,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16115,".cljs$core$IFn$_invoke$arity$",c_16210," = ",n_16208,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16211 = cljs.core.next(seq__15391_16201__$1);
var G__16212 = null;
var G__16213 = (0);
var G__16214 = (0);
seq__15391_16188 = G__16211;
chunk__15392_16189 = G__16212;
count__15393_16190 = G__16213;
i__15394_16191 = G__16214;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16115,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__15418){
var map__15419 = p__15418;
var map__15419__$1 = (((((!((map__15419 == null))))?(((((map__15419.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15419.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15419):map__15419);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15419__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15419__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15419__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15421_16219 = cljs.core.seq(statements);
var chunk__15422_16220 = null;
var count__15423_16221 = (0);
var i__15424_16222 = (0);
while(true){
if((i__15424_16222 < count__15423_16221)){
var s_16223 = chunk__15422_16220.cljs$core$IIndexed$_nth$arity$2(null,i__15424_16222);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16223);


var G__16224 = seq__15421_16219;
var G__16225 = chunk__15422_16220;
var G__16226 = count__15423_16221;
var G__16227 = (i__15424_16222 + (1));
seq__15421_16219 = G__16224;
chunk__15422_16220 = G__16225;
count__15423_16221 = G__16226;
i__15424_16222 = G__16227;
continue;
} else {
var temp__5735__auto___16228 = cljs.core.seq(seq__15421_16219);
if(temp__5735__auto___16228){
var seq__15421_16229__$1 = temp__5735__auto___16228;
if(cljs.core.chunked_seq_QMARK_(seq__15421_16229__$1)){
var c__4609__auto___16230 = cljs.core.chunk_first(seq__15421_16229__$1);
var G__16231 = cljs.core.chunk_rest(seq__15421_16229__$1);
var G__16232 = c__4609__auto___16230;
var G__16233 = cljs.core.count(c__4609__auto___16230);
var G__16234 = (0);
seq__15421_16219 = G__16231;
chunk__15422_16220 = G__16232;
count__15423_16221 = G__16233;
i__15424_16222 = G__16234;
continue;
} else {
var s_16235 = cljs.core.first(seq__15421_16229__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16235);


var G__16236 = cljs.core.next(seq__15421_16229__$1);
var G__16237 = null;
var G__16238 = (0);
var G__16239 = (0);
seq__15421_16219 = G__16236;
chunk__15422_16220 = G__16237;
count__15423_16221 = G__16238;
i__15424_16222 = G__16239;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__15428){
var map__15429 = p__15428;
var map__15429__$1 = (((((!((map__15429 == null))))?(((((map__15429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15429):map__15429);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__15437,is_loop){
var map__15438 = p__15437;
var map__15438__$1 = (((((!((map__15438 == null))))?(((((map__15438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15438.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15438):map__15438);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15438__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15438__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15438__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__15440_16244 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__15441_16245 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__15441_16245);

try{var seq__15442_16246 = cljs.core.seq(bindings);
var chunk__15443_16247 = null;
var count__15444_16248 = (0);
var i__15445_16249 = (0);
while(true){
if((i__15445_16249 < count__15444_16248)){
var map__15450_16250 = chunk__15443_16247.cljs$core$IIndexed$_nth$arity$2(null,i__15445_16249);
var map__15450_16251__$1 = (((((!((map__15450_16250 == null))))?(((((map__15450_16250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15450_16250.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15450_16250):map__15450_16250);
var binding_16252 = map__15450_16251__$1;
var init_16253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15450_16251__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16252);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16253,";");


var G__16255 = seq__15442_16246;
var G__16256 = chunk__15443_16247;
var G__16257 = count__15444_16248;
var G__16258 = (i__15445_16249 + (1));
seq__15442_16246 = G__16255;
chunk__15443_16247 = G__16256;
count__15444_16248 = G__16257;
i__15445_16249 = G__16258;
continue;
} else {
var temp__5735__auto___16259 = cljs.core.seq(seq__15442_16246);
if(temp__5735__auto___16259){
var seq__15442_16260__$1 = temp__5735__auto___16259;
if(cljs.core.chunked_seq_QMARK_(seq__15442_16260__$1)){
var c__4609__auto___16261 = cljs.core.chunk_first(seq__15442_16260__$1);
var G__16262 = cljs.core.chunk_rest(seq__15442_16260__$1);
var G__16263 = c__4609__auto___16261;
var G__16264 = cljs.core.count(c__4609__auto___16261);
var G__16265 = (0);
seq__15442_16246 = G__16262;
chunk__15443_16247 = G__16263;
count__15444_16248 = G__16264;
i__15445_16249 = G__16265;
continue;
} else {
var map__15452_16266 = cljs.core.first(seq__15442_16260__$1);
var map__15452_16267__$1 = (((((!((map__15452_16266 == null))))?(((((map__15452_16266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15452_16266.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15452_16266):map__15452_16266);
var binding_16268 = map__15452_16267__$1;
var init_16269 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15452_16267__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16268);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16269,";");


var G__16282 = cljs.core.next(seq__15442_16260__$1);
var G__16283 = null;
var G__16284 = (0);
var G__16285 = (0);
seq__15442_16246 = G__16282;
chunk__15443_16247 = G__16283;
count__15444_16248 = G__16284;
i__15445_16249 = G__16285;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__15440_16244);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__15454){
var map__15455 = p__15454;
var map__15455__$1 = (((((!((map__15455 == null))))?(((((map__15455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15455):map__15455);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15455__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15455__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15455__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___16286 = cljs.core.count(exprs);
var i_16287 = (0);
while(true){
if((i_16287 < n__4666__auto___16286)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16287) : temps.call(null,i_16287))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_16287) : exprs.call(null,i_16287)),";");

var G__16288 = (i_16287 + (1));
i_16287 = G__16288;
continue;
} else {
}
break;
}

var n__4666__auto___16289 = cljs.core.count(exprs);
var i_16290 = (0);
while(true){
if((i_16290 < n__4666__auto___16289)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_16290) : params.call(null,i_16290)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16290) : temps.call(null,i_16290)),";");

var G__16291 = (i_16290 + (1));
i_16290 = G__16291;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__15457){
var map__15458 = p__15457;
var map__15458__$1 = (((((!((map__15458 == null))))?(((((map__15458.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15458.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15458):map__15458);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15458__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15458__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15458__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15460_16292 = cljs.core.seq(bindings);
var chunk__15461_16293 = null;
var count__15462_16294 = (0);
var i__15463_16295 = (0);
while(true){
if((i__15463_16295 < count__15462_16294)){
var map__15468_16296 = chunk__15461_16293.cljs$core$IIndexed$_nth$arity$2(null,i__15463_16295);
var map__15468_16297__$1 = (((((!((map__15468_16296 == null))))?(((((map__15468_16296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15468_16296.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15468_16296):map__15468_16296);
var binding_16298 = map__15468_16297__$1;
var init_16299 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15468_16297__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16298)," = ",init_16299,";");


var G__16300 = seq__15460_16292;
var G__16301 = chunk__15461_16293;
var G__16302 = count__15462_16294;
var G__16303 = (i__15463_16295 + (1));
seq__15460_16292 = G__16300;
chunk__15461_16293 = G__16301;
count__15462_16294 = G__16302;
i__15463_16295 = G__16303;
continue;
} else {
var temp__5735__auto___16304 = cljs.core.seq(seq__15460_16292);
if(temp__5735__auto___16304){
var seq__15460_16305__$1 = temp__5735__auto___16304;
if(cljs.core.chunked_seq_QMARK_(seq__15460_16305__$1)){
var c__4609__auto___16306 = cljs.core.chunk_first(seq__15460_16305__$1);
var G__16307 = cljs.core.chunk_rest(seq__15460_16305__$1);
var G__16308 = c__4609__auto___16306;
var G__16309 = cljs.core.count(c__4609__auto___16306);
var G__16310 = (0);
seq__15460_16292 = G__16307;
chunk__15461_16293 = G__16308;
count__15462_16294 = G__16309;
i__15463_16295 = G__16310;
continue;
} else {
var map__15470_16311 = cljs.core.first(seq__15460_16305__$1);
var map__15470_16312__$1 = (((((!((map__15470_16311 == null))))?(((((map__15470_16311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15470_16311.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15470_16311):map__15470_16311);
var binding_16313 = map__15470_16312__$1;
var init_16314 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15470_16312__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16313)," = ",init_16314,";");


var G__16317 = cljs.core.next(seq__15460_16305__$1);
var G__16318 = null;
var G__16319 = (0);
var G__16320 = (0);
seq__15460_16292 = G__16317;
chunk__15461_16293 = G__16318;
count__15462_16294 = G__16319;
i__15463_16295 = G__16320;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__15474){
var map__15475 = p__15474;
var map__15475__$1 = (((((!((map__15475 == null))))?(((((map__15475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15475):map__15475);
var expr = map__15475__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15475__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15475__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15475__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__15487 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__15487.cljs$core$IFn$_invoke$arity$1 ? fexpr__15487.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15487.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__15489 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__15489.cljs$core$IFn$_invoke$arity$1 ? fexpr__15489.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__15489.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__15477 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15472_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15472_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15473_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15473_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15477,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15477,(1),null);
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_16355 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_16355,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_16356 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_16356,args)),(((mfa_16356 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_16356,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__15491 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__15490 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15490.cljs$core$IFn$_invoke$arity$1 ? fexpr__15490.cljs$core$IFn$_invoke$arity$1(G__15491) : fexpr__15490.call(null,G__15491));
} else {
return and__4174__auto__;
}
})())){
var fprop_16359 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16359," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16359,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16359," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16359,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__15492){
var map__15493 = p__15492;
var map__15493__$1 = (((((!((map__15493 == null))))?(((((map__15493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15493.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15493):map__15493);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15493__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15493__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15493__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__15495){
var map__15496 = p__15495;
var map__15496__$1 = (((((!((map__15496 == null))))?(((((map__15496.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15496.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15496):map__15496);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15496__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15496__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15496__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__15498 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15498__$1 = (((((!((map__15498 == null))))?(((((map__15498.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15498.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15498):map__15498);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15498__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15498__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__15499 = options;
var map__15499__$1 = (((((!((map__15499 == null))))?(((((map__15499.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15499.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15499):map__15499);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15499__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15499__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__15500 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__15505 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__15505__$1 = (((((!((map__15505 == null))))?(((((map__15505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15505):map__15505);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15505__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15505__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15500,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15500,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__15507_16371 = cljs.core.seq(libs_to_load);
var chunk__15508_16372 = null;
var count__15509_16373 = (0);
var i__15510_16374 = (0);
while(true){
if((i__15510_16374 < count__15509_16373)){
var lib_16375 = chunk__15508_16372.cljs$core$IIndexed$_nth$arity$2(null,i__15510_16374);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16375)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16375),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16375),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16375),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16375),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16375,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16375),"');");
}

}
}
}


var G__16384 = seq__15507_16371;
var G__16385 = chunk__15508_16372;
var G__16386 = count__15509_16373;
var G__16387 = (i__15510_16374 + (1));
seq__15507_16371 = G__16384;
chunk__15508_16372 = G__16385;
count__15509_16373 = G__16386;
i__15510_16374 = G__16387;
continue;
} else {
var temp__5735__auto___16388 = cljs.core.seq(seq__15507_16371);
if(temp__5735__auto___16388){
var seq__15507_16389__$1 = temp__5735__auto___16388;
if(cljs.core.chunked_seq_QMARK_(seq__15507_16389__$1)){
var c__4609__auto___16390 = cljs.core.chunk_first(seq__15507_16389__$1);
var G__16391 = cljs.core.chunk_rest(seq__15507_16389__$1);
var G__16392 = c__4609__auto___16390;
var G__16393 = cljs.core.count(c__4609__auto___16390);
var G__16394 = (0);
seq__15507_16371 = G__16391;
chunk__15508_16372 = G__16392;
count__15509_16373 = G__16393;
i__15510_16374 = G__16394;
continue;
} else {
var lib_16395 = cljs.core.first(seq__15507_16389__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16395)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16395),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16395),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16395),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16395),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16395,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16395),"');");
}

}
}
}


var G__16397 = cljs.core.next(seq__15507_16389__$1);
var G__16398 = null;
var G__16399 = (0);
var G__16400 = (0);
seq__15507_16371 = G__16397;
chunk__15508_16372 = G__16398;
count__15509_16373 = G__16399;
i__15510_16374 = G__16400;
continue;
}
} else {
}
}
break;
}

var seq__15511_16401 = cljs.core.seq(node_libs);
var chunk__15512_16402 = null;
var count__15513_16403 = (0);
var i__15514_16404 = (0);
while(true){
if((i__15514_16404 < count__15513_16403)){
var lib_16405 = chunk__15512_16402.cljs$core$IIndexed$_nth$arity$2(null,i__15514_16404);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16405)," = require('",lib_16405,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16406 = seq__15511_16401;
var G__16407 = chunk__15512_16402;
var G__16408 = count__15513_16403;
var G__16409 = (i__15514_16404 + (1));
seq__15511_16401 = G__16406;
chunk__15512_16402 = G__16407;
count__15513_16403 = G__16408;
i__15514_16404 = G__16409;
continue;
} else {
var temp__5735__auto___16411 = cljs.core.seq(seq__15511_16401);
if(temp__5735__auto___16411){
var seq__15511_16412__$1 = temp__5735__auto___16411;
if(cljs.core.chunked_seq_QMARK_(seq__15511_16412__$1)){
var c__4609__auto___16413 = cljs.core.chunk_first(seq__15511_16412__$1);
var G__16414 = cljs.core.chunk_rest(seq__15511_16412__$1);
var G__16415 = c__4609__auto___16413;
var G__16416 = cljs.core.count(c__4609__auto___16413);
var G__16417 = (0);
seq__15511_16401 = G__16414;
chunk__15512_16402 = G__16415;
count__15513_16403 = G__16416;
i__15514_16404 = G__16417;
continue;
} else {
var lib_16418 = cljs.core.first(seq__15511_16412__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16418)," = require('",lib_16418,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16419 = cljs.core.next(seq__15511_16412__$1);
var G__16420 = null;
var G__16421 = (0);
var G__16422 = (0);
seq__15511_16401 = G__16419;
chunk__15512_16402 = G__16420;
count__15513_16403 = G__16421;
i__15514_16404 = G__16422;
continue;
}
} else {
}
}
break;
}

var seq__15515_16423 = cljs.core.seq(global_exports_libs);
var chunk__15516_16424 = null;
var count__15517_16425 = (0);
var i__15518_16426 = (0);
while(true){
if((i__15518_16426 < count__15517_16425)){
var lib_16427 = chunk__15516_16424.cljs$core$IIndexed$_nth$arity$2(null,i__15518_16426);
var map__15523_16428 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16427));
var map__15523_16429__$1 = (((((!((map__15523_16428 == null))))?(((((map__15523_16428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15523_16428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15523_16428):map__15523_16428);
var global_exports_16430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15523_16429__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16430,lib_16427);


var G__16431 = seq__15515_16423;
var G__16432 = chunk__15516_16424;
var G__16433 = count__15517_16425;
var G__16434 = (i__15518_16426 + (1));
seq__15515_16423 = G__16431;
chunk__15516_16424 = G__16432;
count__15517_16425 = G__16433;
i__15518_16426 = G__16434;
continue;
} else {
var temp__5735__auto___16435 = cljs.core.seq(seq__15515_16423);
if(temp__5735__auto___16435){
var seq__15515_16436__$1 = temp__5735__auto___16435;
if(cljs.core.chunked_seq_QMARK_(seq__15515_16436__$1)){
var c__4609__auto___16437 = cljs.core.chunk_first(seq__15515_16436__$1);
var G__16438 = cljs.core.chunk_rest(seq__15515_16436__$1);
var G__16439 = c__4609__auto___16437;
var G__16440 = cljs.core.count(c__4609__auto___16437);
var G__16441 = (0);
seq__15515_16423 = G__16438;
chunk__15516_16424 = G__16439;
count__15517_16425 = G__16440;
i__15518_16426 = G__16441;
continue;
} else {
var lib_16442 = cljs.core.first(seq__15515_16436__$1);
var map__15525_16450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16442));
var map__15525_16451__$1 = (((((!((map__15525_16450 == null))))?(((((map__15525_16450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15525_16450.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15525_16450):map__15525_16450);
var global_exports_16452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15525_16451__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16452,lib_16442);


var G__16453 = cljs.core.next(seq__15515_16436__$1);
var G__16454 = null;
var G__16455 = (0);
var G__16456 = (0);
seq__15515_16423 = G__16453;
chunk__15516_16424 = G__16454;
count__15517_16425 = G__16455;
i__15518_16426 = G__16456;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__15527){
var map__15528 = p__15527;
var map__15528__$1 = (((((!((map__15528 == null))))?(((((map__15528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15528.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15528):map__15528);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15528__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__15530){
var map__15531 = p__15530;
var map__15531__$1 = (((((!((map__15531 == null))))?(((((map__15531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15531):map__15531);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15531__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__15533){
var map__15534 = p__15533;
var map__15534__$1 = (((((!((map__15534 == null))))?(((((map__15534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15534):map__15534);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15534__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15534__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15534__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15534__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15534__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15536_16457 = cljs.core.seq(protocols);
var chunk__15537_16458 = null;
var count__15538_16459 = (0);
var i__15539_16460 = (0);
while(true){
if((i__15539_16460 < count__15538_16459)){
var protocol_16461 = chunk__15537_16458.cljs$core$IIndexed$_nth$arity$2(null,i__15539_16460);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16461)),"}");


var G__16462 = seq__15536_16457;
var G__16463 = chunk__15537_16458;
var G__16464 = count__15538_16459;
var G__16465 = (i__15539_16460 + (1));
seq__15536_16457 = G__16462;
chunk__15537_16458 = G__16463;
count__15538_16459 = G__16464;
i__15539_16460 = G__16465;
continue;
} else {
var temp__5735__auto___16466 = cljs.core.seq(seq__15536_16457);
if(temp__5735__auto___16466){
var seq__15536_16467__$1 = temp__5735__auto___16466;
if(cljs.core.chunked_seq_QMARK_(seq__15536_16467__$1)){
var c__4609__auto___16468 = cljs.core.chunk_first(seq__15536_16467__$1);
var G__16469 = cljs.core.chunk_rest(seq__15536_16467__$1);
var G__16470 = c__4609__auto___16468;
var G__16471 = cljs.core.count(c__4609__auto___16468);
var G__16472 = (0);
seq__15536_16457 = G__16469;
chunk__15537_16458 = G__16470;
count__15538_16459 = G__16471;
i__15539_16460 = G__16472;
continue;
} else {
var protocol_16473 = cljs.core.first(seq__15536_16467__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16473)),"}");


var G__16474 = cljs.core.next(seq__15536_16467__$1);
var G__16475 = null;
var G__16476 = (0);
var G__16477 = (0);
seq__15536_16457 = G__16474;
chunk__15537_16458 = G__16475;
count__15538_16459 = G__16476;
i__15539_16460 = G__16477;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15540_16478 = cljs.core.seq(fields__$1);
var chunk__15541_16479 = null;
var count__15542_16480 = (0);
var i__15543_16481 = (0);
while(true){
if((i__15543_16481 < count__15542_16480)){
var fld_16482 = chunk__15541_16479.cljs$core$IIndexed$_nth$arity$2(null,i__15543_16481);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16482," = ",fld_16482,";");


var G__16483 = seq__15540_16478;
var G__16484 = chunk__15541_16479;
var G__16485 = count__15542_16480;
var G__16486 = (i__15543_16481 + (1));
seq__15540_16478 = G__16483;
chunk__15541_16479 = G__16484;
count__15542_16480 = G__16485;
i__15543_16481 = G__16486;
continue;
} else {
var temp__5735__auto___16487 = cljs.core.seq(seq__15540_16478);
if(temp__5735__auto___16487){
var seq__15540_16488__$1 = temp__5735__auto___16487;
if(cljs.core.chunked_seq_QMARK_(seq__15540_16488__$1)){
var c__4609__auto___16495 = cljs.core.chunk_first(seq__15540_16488__$1);
var G__16496 = cljs.core.chunk_rest(seq__15540_16488__$1);
var G__16497 = c__4609__auto___16495;
var G__16498 = cljs.core.count(c__4609__auto___16495);
var G__16499 = (0);
seq__15540_16478 = G__16496;
chunk__15541_16479 = G__16497;
count__15542_16480 = G__16498;
i__15543_16481 = G__16499;
continue;
} else {
var fld_16500 = cljs.core.first(seq__15540_16488__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16500," = ",fld_16500,";");


var G__16501 = cljs.core.next(seq__15540_16488__$1);
var G__16502 = null;
var G__16503 = (0);
var G__16504 = (0);
seq__15540_16478 = G__16501;
chunk__15541_16479 = G__16502;
count__15542_16480 = G__16503;
i__15543_16481 = G__16504;
continue;
}
} else {
}
}
break;
}

var seq__15544_16505 = cljs.core.seq(pmasks);
var chunk__15545_16506 = null;
var count__15546_16507 = (0);
var i__15547_16508 = (0);
while(true){
if((i__15547_16508 < count__15546_16507)){
var vec__15554_16509 = chunk__15545_16506.cljs$core$IIndexed$_nth$arity$2(null,i__15547_16508);
var pno_16510 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15554_16509,(0),null);
var pmask_16511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15554_16509,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16510,"$ = ",pmask_16511,";");


var G__16515 = seq__15544_16505;
var G__16516 = chunk__15545_16506;
var G__16517 = count__15546_16507;
var G__16518 = (i__15547_16508 + (1));
seq__15544_16505 = G__16515;
chunk__15545_16506 = G__16516;
count__15546_16507 = G__16517;
i__15547_16508 = G__16518;
continue;
} else {
var temp__5735__auto___16519 = cljs.core.seq(seq__15544_16505);
if(temp__5735__auto___16519){
var seq__15544_16520__$1 = temp__5735__auto___16519;
if(cljs.core.chunked_seq_QMARK_(seq__15544_16520__$1)){
var c__4609__auto___16521 = cljs.core.chunk_first(seq__15544_16520__$1);
var G__16522 = cljs.core.chunk_rest(seq__15544_16520__$1);
var G__16523 = c__4609__auto___16521;
var G__16524 = cljs.core.count(c__4609__auto___16521);
var G__16525 = (0);
seq__15544_16505 = G__16522;
chunk__15545_16506 = G__16523;
count__15546_16507 = G__16524;
i__15547_16508 = G__16525;
continue;
} else {
var vec__15557_16526 = cljs.core.first(seq__15544_16520__$1);
var pno_16527 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15557_16526,(0),null);
var pmask_16528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15557_16526,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16527,"$ = ",pmask_16528,";");


var G__16529 = cljs.core.next(seq__15544_16520__$1);
var G__16530 = null;
var G__16531 = (0);
var G__16532 = (0);
seq__15544_16505 = G__16529;
chunk__15545_16506 = G__16530;
count__15546_16507 = G__16531;
i__15547_16508 = G__16532;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__15560){
var map__15561 = p__15560;
var map__15561__$1 = (((((!((map__15561 == null))))?(((((map__15561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15561.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15561):map__15561);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15561__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15561__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15561__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15561__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15561__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15563_16533 = cljs.core.seq(protocols);
var chunk__15564_16534 = null;
var count__15565_16535 = (0);
var i__15566_16536 = (0);
while(true){
if((i__15566_16536 < count__15565_16535)){
var protocol_16537 = chunk__15564_16534.cljs$core$IIndexed$_nth$arity$2(null,i__15566_16536);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16537)),"}");


var G__16538 = seq__15563_16533;
var G__16539 = chunk__15564_16534;
var G__16540 = count__15565_16535;
var G__16541 = (i__15566_16536 + (1));
seq__15563_16533 = G__16538;
chunk__15564_16534 = G__16539;
count__15565_16535 = G__16540;
i__15566_16536 = G__16541;
continue;
} else {
var temp__5735__auto___16542 = cljs.core.seq(seq__15563_16533);
if(temp__5735__auto___16542){
var seq__15563_16543__$1 = temp__5735__auto___16542;
if(cljs.core.chunked_seq_QMARK_(seq__15563_16543__$1)){
var c__4609__auto___16544 = cljs.core.chunk_first(seq__15563_16543__$1);
var G__16545 = cljs.core.chunk_rest(seq__15563_16543__$1);
var G__16546 = c__4609__auto___16544;
var G__16547 = cljs.core.count(c__4609__auto___16544);
var G__16548 = (0);
seq__15563_16533 = G__16545;
chunk__15564_16534 = G__16546;
count__15565_16535 = G__16547;
i__15566_16536 = G__16548;
continue;
} else {
var protocol_16549 = cljs.core.first(seq__15563_16543__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16549)),"}");


var G__16550 = cljs.core.next(seq__15563_16543__$1);
var G__16551 = null;
var G__16552 = (0);
var G__16553 = (0);
seq__15563_16533 = G__16550;
chunk__15564_16534 = G__16551;
count__15565_16535 = G__16552;
i__15566_16536 = G__16553;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15567_16554 = cljs.core.seq(fields__$1);
var chunk__15568_16555 = null;
var count__15569_16556 = (0);
var i__15570_16557 = (0);
while(true){
if((i__15570_16557 < count__15569_16556)){
var fld_16558 = chunk__15568_16555.cljs$core$IIndexed$_nth$arity$2(null,i__15570_16557);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16558," = ",fld_16558,";");


var G__16559 = seq__15567_16554;
var G__16560 = chunk__15568_16555;
var G__16561 = count__15569_16556;
var G__16562 = (i__15570_16557 + (1));
seq__15567_16554 = G__16559;
chunk__15568_16555 = G__16560;
count__15569_16556 = G__16561;
i__15570_16557 = G__16562;
continue;
} else {
var temp__5735__auto___16563 = cljs.core.seq(seq__15567_16554);
if(temp__5735__auto___16563){
var seq__15567_16564__$1 = temp__5735__auto___16563;
if(cljs.core.chunked_seq_QMARK_(seq__15567_16564__$1)){
var c__4609__auto___16565 = cljs.core.chunk_first(seq__15567_16564__$1);
var G__16566 = cljs.core.chunk_rest(seq__15567_16564__$1);
var G__16567 = c__4609__auto___16565;
var G__16568 = cljs.core.count(c__4609__auto___16565);
var G__16569 = (0);
seq__15567_16554 = G__16566;
chunk__15568_16555 = G__16567;
count__15569_16556 = G__16568;
i__15570_16557 = G__16569;
continue;
} else {
var fld_16571 = cljs.core.first(seq__15567_16564__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16571," = ",fld_16571,";");


var G__16574 = cljs.core.next(seq__15567_16564__$1);
var G__16575 = null;
var G__16576 = (0);
var G__16577 = (0);
seq__15567_16554 = G__16574;
chunk__15568_16555 = G__16575;
count__15569_16556 = G__16576;
i__15570_16557 = G__16577;
continue;
}
} else {
}
}
break;
}

var seq__15571_16578 = cljs.core.seq(pmasks);
var chunk__15572_16579 = null;
var count__15573_16580 = (0);
var i__15574_16581 = (0);
while(true){
if((i__15574_16581 < count__15573_16580)){
var vec__15581_16582 = chunk__15572_16579.cljs$core$IIndexed$_nth$arity$2(null,i__15574_16581);
var pno_16583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16582,(0),null);
var pmask_16584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16582,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16583,"$ = ",pmask_16584,";");


var G__16585 = seq__15571_16578;
var G__16586 = chunk__15572_16579;
var G__16587 = count__15573_16580;
var G__16588 = (i__15574_16581 + (1));
seq__15571_16578 = G__16585;
chunk__15572_16579 = G__16586;
count__15573_16580 = G__16587;
i__15574_16581 = G__16588;
continue;
} else {
var temp__5735__auto___16589 = cljs.core.seq(seq__15571_16578);
if(temp__5735__auto___16589){
var seq__15571_16590__$1 = temp__5735__auto___16589;
if(cljs.core.chunked_seq_QMARK_(seq__15571_16590__$1)){
var c__4609__auto___16591 = cljs.core.chunk_first(seq__15571_16590__$1);
var G__16595 = cljs.core.chunk_rest(seq__15571_16590__$1);
var G__16596 = c__4609__auto___16591;
var G__16597 = cljs.core.count(c__4609__auto___16591);
var G__16598 = (0);
seq__15571_16578 = G__16595;
chunk__15572_16579 = G__16596;
count__15573_16580 = G__16597;
i__15574_16581 = G__16598;
continue;
} else {
var vec__15584_16599 = cljs.core.first(seq__15571_16590__$1);
var pno_16600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15584_16599,(0),null);
var pmask_16601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15584_16599,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16600,"$ = ",pmask_16601,";");


var G__16602 = cljs.core.next(seq__15571_16590__$1);
var G__16603 = null;
var G__16604 = (0);
var G__16605 = (0);
seq__15571_16578 = G__16602;
chunk__15572_16579 = G__16603;
count__15573_16580 = G__16604;
i__15574_16581 = G__16605;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__15587){
var map__15588 = p__15587;
var map__15588__$1 = (((((!((map__15588 == null))))?(((((map__15588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15588):map__15588);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__15590){
var map__15591 = p__15590;
var map__15591__$1 = (((((!((map__15591 == null))))?(((((map__15591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15591.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15591):map__15591);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__14728__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__14728__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__15597 = cljs.core.seq(table);
var chunk__15598 = null;
var count__15599 = (0);
var i__15600 = (0);
while(true){
if((i__15600 < count__15599)){
var vec__15607 = chunk__15598.cljs$core$IIndexed$_nth$arity$2(null,i__15600);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15607,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15607,(1),null);
var ns_16612 = cljs.core.namespace(sym);
var name_16613 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16614 = seq__15597;
var G__16615 = chunk__15598;
var G__16616 = count__15599;
var G__16617 = (i__15600 + (1));
seq__15597 = G__16614;
chunk__15598 = G__16615;
count__15599 = G__16616;
i__15600 = G__16617;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15597);
if(temp__5735__auto__){
var seq__15597__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15597__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15597__$1);
var G__16618 = cljs.core.chunk_rest(seq__15597__$1);
var G__16619 = c__4609__auto__;
var G__16620 = cljs.core.count(c__4609__auto__);
var G__16621 = (0);
seq__15597 = G__16618;
chunk__15598 = G__16619;
count__15599 = G__16620;
i__15600 = G__16621;
continue;
} else {
var vec__15610 = cljs.core.first(seq__15597__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15610,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15610,(1),null);
var ns_16622 = cljs.core.namespace(sym);
var name_16623 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16624 = cljs.core.next(seq__15597__$1);
var G__16625 = null;
var G__16626 = (0);
var G__16627 = (0);
seq__15597 = G__16624;
chunk__15598 = G__16625;
count__15599 = G__16626;
i__15600 = G__16627;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__15614 = arguments.length;
switch (G__15614) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_16643 = cljs.core.first(ks);
var vec__15615_16644 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_16643);
var top_16645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15615_16644,(0),null);
var prefix_SINGLEQUOTE__16646 = vec__15615_16644;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_16643)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__16646) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_16645)) || (cljs.core.contains_QMARK_(known_externs,top_16645)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16646)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_16645);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16646)),";");
}
} else {
}

var m_16647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_16643);
if(cljs.core.empty_QMARK_(m_16647)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__16646,m_16647,top_level,known_externs);
}

var G__16648 = cljs.core.next(ks);
ks = G__16648;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

