goog.provide('pinkgorilla.explore.list');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('clojure.string');
goog.require('pinkgorilla.storage.storage');
goog.require('pinkgorilla.routes');
goog.require('pinkgorilla.explore.utils');
goog.require('pinkgorilla.explore.form_helpers');
pinkgorilla.explore.list.filter_tag = (function pinkgorilla$explore$list$filter_tag(tags,tag){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tag-container","span.tag-container",1432771456),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tag","span.tag",-825095461),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(tags,tag))?"active":null),new cljs.core.Keyword(null,"data-prevent-nav","data-prevent-nav",1791892696),true,new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (p1__55527_SHARP_){
p1__55527_SHARP_.stopPropagation();

p1__55527_SHARP_.preventDefault();

var G__55528 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"toggle-tag","toggle-tag",-2044979374),tag], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__55528) : re_frame.core.dispatch.call(null,G__55528));
})], null),tag], null)], null);
});
pinkgorilla.explore.list.sidebar = (function pinkgorilla$explore$list$sidebar(search_input,tags,selected_tags){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.mt-12","div.mt-12",-1953716378),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [search_input,new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"Search: `music`, `database` ..."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.section.tags","div.section.tags",635389487),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),(function (){var iter__4582__auto__ = (function pinkgorilla$explore$list$sidebar_$_iter__55529(s__55530){
return (new cljs.core.LazySeq(null,(function (){
var s__55530__$1 = s__55530;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__55530__$1);
if(temp__5735__auto__){
var s__55530__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__55530__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__55530__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__55532 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__55531 = (0);
while(true){
if((i__55531 < size__4581__auto__)){
var tag = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4580__auto__,i__55531);
cljs.core.chunk_append(b__55532,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.filter_tag,selected_tags,tag], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null)));

var G__55544 = (i__55531 + (1));
i__55531 = G__55544;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__55532),pinkgorilla$explore$list$sidebar_$_iter__55529(cljs.core.chunk_rest(s__55530__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__55532),null);
}
} else {
var tag = cljs.core.first(s__55530__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.filter_tag,selected_tags,tag], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null)),pinkgorilla$explore$list$sidebar_$_iter__55529(cljs.core.rest(s__55530__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(tags);
})()], null)], null)], null);
});
pinkgorilla.explore.list.project_name_old = (function pinkgorilla$explore$list$project_name_old(entry){
var name = (function (){var or__4185__auto__ = new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(entry);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "?";
}
})();
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),clojure.string.replace(name,/^(.+?)\/+$/,"$1")], null);
});
/**
 * extracts the only the name of the file, without extension and path
 */
pinkgorilla.explore.list.project_path_name = (function pinkgorilla$explore$list$project_path_name(l){
var full_file_name = new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(l);
var name = cljs.core.re_find(/(.+?)([\w-]*).cljg*$/,(function (){var or__4185__auto__ = full_file_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());
return name;
});
pinkgorilla.explore.list.project_name = (function pinkgorilla$explore$list$project_name(l){
return cljs.core.last(pinkgorilla.explore.list.project_path_name(l));
});
pinkgorilla.explore.list.subs2 = (function pinkgorilla$explore$list$subs2(s,start){
return s.substring(start,cljs.core.count(s));
});
pinkgorilla.explore.list.project_path = (function pinkgorilla$explore$list$project_path(l){
var p = cljs.core.second(pinkgorilla.explore.list.project_path_name(l));
var root_len = cljs.core.count(new cljs.core.Keyword(null,"root-dir","root-dir",-1206960301).cljs$core$IFn$_invoke$arity$1(l));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(l),new cljs.core.Keyword(null,"file","file",-1269645878))){
if((p == null)){
return null;
} else {
if((root_len == null)){
return p;
} else {
return pinkgorilla.explore.list.subs2(p,root_len);
}
}
} else {
return p;
}
});
pinkgorilla.explore.list.project_link = (function pinkgorilla$explore$list$project_link(entry){
var storage = new cljs.core.Keyword(null,"storage","storage",1867247511).cljs$core$IFn$_invoke$arity$1(entry);
if((storage == null)){
return "";
} else {
return pinkgorilla.storage.storage.gorilla_path(storage);
}
});
pinkgorilla.explore.list.project_storage_link = (function pinkgorilla$explore$list$project_storage_link(entry){
var storage = new cljs.core.Keyword(null,"storage","storage",1867247511).cljs$core$IFn$_invoke$arity$1(entry);
if((storage == null)){
return "";
} else {
return pinkgorilla.storage.storage.external_url(storage);
}
});
pinkgorilla.explore.list.tagline = (function pinkgorilla$explore$list$tagline(entry){
var tl = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tagline","tagline",281987682)], null));
var or__4185__auto__ = tl;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "No Tagline provided";
}
});
pinkgorilla.explore.list.project = (function pinkgorilla$explore$list$project(selected_tags,l){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"h-48 bg-green-400 w-1/2 border-r border-b border-l border-gray-400 lg:border-l-0 lg:border-t lg:border-gray-400  rounded-b lg:rounded-b-none lg:rounded-r p-4 flex flex-col justify-between leading-normal"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.mb-8","div.mb-8",255255619),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"href","href",-793805698),pinkgorilla.explore.list.project_storage_link(l),new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"rel","rel",1378823488),"noopener noreferrer"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.px-0.py-0.bg-White","div.px-0.py-0.bg-White",479268344),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pg-storage-prop mr-1"], null),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(l)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pg-storage-prop mr-1"], null),new cljs.core.Keyword(null,"repo","repo",-1999060679).cljs$core$IFn$_invoke$arity$1(l)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pg-storage-prop"], null),pinkgorilla.explore.list.project_path(l)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return pinkgorilla.routes.nav_BANG_(pinkgorilla.explore.list.project_link(l));
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"text-white font-bold text-xl mb-2"], null),pinkgorilla.explore.list.project_name(l)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"text-white text-base h-8 overflow-hidden"], null),pinkgorilla.explore.list.tagline(l)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.flex.items-center","div.flex.items-center",-1537844053),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"w-10 h-10 bg-white rounded-full mr-4",new cljs.core.Keyword(null,"src","src",-1651076051),"./pink-gorilla-32.png",new cljs.core.Keyword(null,"alt","alt",-3214426),"Avatar"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.text-sm.mr-4","div.text-sm.mr-4",651060586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p.text-white.leading-none","p.text-white.leading-none",511795674),new cljs.core.Keyword(null,"user","user",1532431356).cljs$core$IFn$_invoke$arity$1(l)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p.text-gray-600","p.text-gray-600",-123426867),new cljs.core.Keyword(null,"edit-date","edit-date",1885166597).cljs$core$IFn$_invoke$arity$1(l)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.text-sm.mr-4","div.text-sm.mr-4",651060586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.px-6.py-4","div.px-6.py-4",-1138945559),(function (){var temp__5733__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(l,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tags","tags",1771418977)], null));
if(cljs.core.truth_(temp__5733__auto__)){
var t = temp__5733__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tags","div.tags",-1073137818),(function (){var iter__4582__auto__ = (function pinkgorilla$explore$list$project_$_iter__55533(s__55534){
return (new cljs.core.LazySeq(null,(function (){
var s__55534__$1 = s__55534;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__55534__$1);
if(temp__5735__auto__){
var s__55534__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__55534__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__55534__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__55536 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__55535 = (0);
while(true){
if((i__55535 < size__4581__auto__)){
var tag = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4580__auto__,i__55535);
cljs.core.chunk_append(b__55536,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.filter_tag,selected_tags,tag], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null)));

var G__55545 = (i__55535 + (1));
i__55535 = G__55545;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__55536),pinkgorilla$explore$list$project_$_iter__55533(cljs.core.chunk_rest(s__55534__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__55536),null);
}
} else {
var tag = cljs.core.first(s__55534__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.filter_tag,selected_tags,tag], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null)),pinkgorilla$explore$list$project_$_iter__55533(cljs.core.rest(s__55534__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(pinkgorilla.explore.utils.split_tags(t));
})()], null);
} else {
return null;
}
})()], null)], null)], null)], null);
});
pinkgorilla.explore.list.view = (function pinkgorilla$explore$list$view(){
var listings = (function (){var G__55537 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filtered-projects","filtered-projects",239301462)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__55537) : re_frame.core.subscribe.call(null,G__55537));
})();
var search_input = pinkgorilla.explore.form_helpers.builder(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects","projects",-364845983),new cljs.core.Keyword(null,"search","search",1564939822)], null));
var selected_tags = (function (){var G__55538 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"forms","forms",2045992350),new cljs.core.Keyword(null,"projects","projects",-364845983),new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"tags","tags",1771418977)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__55538) : re_frame.core.subscribe.call(null,G__55538));
})();
var tags = (function (){var G__55539 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-tags","project-tags",-1698165588)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__55539) : re_frame.core.subscribe.call(null,G__55539));
})();
return (function (){
var listings__$1 = cljs.core.deref(listings);
var tags__$1 = cljs.core.deref(tags);
var selected_tags__$1 = cljs.core.deref(selected_tags);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.flex.w-100","div.flex.w-100",1316001921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.flex.flex-wrap","div.flex.flex-wrap",-407942064),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"w-3/4"], null),(function (){var iter__4582__auto__ = (function pinkgorilla$explore$list$view_$_iter__55540(s__55541){
return (new cljs.core.LazySeq(null,(function (){
var s__55541__$1 = s__55541;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__55541__$1);
if(temp__5735__auto__){
var s__55541__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__55541__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__55541__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__55543 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__55542 = (0);
while(true){
if((i__55542 < size__4581__auto__)){
var l = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4580__auto__,i__55542);
cljs.core.chunk_append(b__55543,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.project,selected_tags__$1,l], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["os-project-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(l))].join('')], null)));

var G__55549 = (i__55542 + (1));
i__55542 = G__55549;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__55543),pinkgorilla$explore$list$view_$_iter__55540(cljs.core.chunk_rest(s__55541__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__55543),null);
}
} else {
var l = cljs.core.first(s__55541__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.project,selected_tags__$1,l], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["os-project-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(l))].join('')], null)),pinkgorilla$explore$list$view_$_iter__55540(cljs.core.rest(s__55541__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(listings__$1);
})()], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"p-2 w-1/4"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.list.sidebar,search_input,tags__$1], null)], null)], null);
});
});

//# sourceMappingURL=pinkgorilla.explore.list.js.map
