goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4185__auto__ = elem.textContent;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__53459 = arguments.length;
switch (G__53459) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
}));

(dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
}));

(dommy.core.style.cljs$lang$maxFixedArity = 2);

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto__ = elem.classList;
if(cljs.core.truth_(temp__5733__auto__)){
var class_list = temp__5733__auto__;
return class_list.contains(c__$1);
} else {
var temp__5735__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__5735__auto__)){
var class_name = temp__5735__auto__;
var temp__5735__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__5735__auto____$1)){
var i = temp__5735__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__53461 = arguments.length;
switch (G__53461) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
}));

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
}));

(dommy.core.matches_pred.cljs$lang$maxFixedArity = 2);

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__53464 = arguments.length;
switch (G__53464) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__53462_SHARP_){
return (!((p1__53462_SHARP_ === base)));
}),dommy.core.ancestors(elem))));
}));

(dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
}));

(dommy.core.closest.cljs$lang$maxFixedArity = 3);

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
(elem.textContent = text);
} else {
(elem.innerText = text);
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
(elem.innerHTML = html);

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
(elem.value = value);

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return (elem.className = c);
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53907 = arguments.length;
var i__4790__auto___53908 = (0);
while(true){
if((i__4790__auto___53908 < len__4789__auto___53907)){
args__4795__auto__.push((arguments[i__4790__auto___53908]));

var G__53909 = (i__4790__auto___53908 + (1));
i__4790__auto___53908 = G__53909;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__53467_53910 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__53468_53911 = null;
var count__53469_53912 = (0);
var i__53470_53913 = (0);
while(true){
if((i__53470_53913 < count__53469_53912)){
var vec__53477_53914 = chunk__53468_53911.cljs$core$IIndexed$_nth$arity$2(null,i__53470_53913);
var k_53915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53477_53914,(0),null);
var v_53916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53477_53914,(1),null);
style.setProperty(dommy.utils.as_str(k_53915),v_53916);


var G__53917 = seq__53467_53910;
var G__53918 = chunk__53468_53911;
var G__53919 = count__53469_53912;
var G__53920 = (i__53470_53913 + (1));
seq__53467_53910 = G__53917;
chunk__53468_53911 = G__53918;
count__53469_53912 = G__53919;
i__53470_53913 = G__53920;
continue;
} else {
var temp__5735__auto___53921 = cljs.core.seq(seq__53467_53910);
if(temp__5735__auto___53921){
var seq__53467_53922__$1 = temp__5735__auto___53921;
if(cljs.core.chunked_seq_QMARK_(seq__53467_53922__$1)){
var c__4609__auto___53923 = cljs.core.chunk_first(seq__53467_53922__$1);
var G__53924 = cljs.core.chunk_rest(seq__53467_53922__$1);
var G__53925 = c__4609__auto___53923;
var G__53926 = cljs.core.count(c__4609__auto___53923);
var G__53927 = (0);
seq__53467_53910 = G__53924;
chunk__53468_53911 = G__53925;
count__53469_53912 = G__53926;
i__53470_53913 = G__53927;
continue;
} else {
var vec__53480_53928 = cljs.core.first(seq__53467_53922__$1);
var k_53929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53480_53928,(0),null);
var v_53930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53480_53928,(1),null);
style.setProperty(dommy.utils.as_str(k_53929),v_53930);


var G__53931 = cljs.core.next(seq__53467_53922__$1);
var G__53932 = null;
var G__53933 = (0);
var G__53934 = (0);
seq__53467_53910 = G__53931;
chunk__53468_53911 = G__53932;
count__53469_53912 = G__53933;
i__53470_53913 = G__53934;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq53465){
var G__53466 = cljs.core.first(seq53465);
var seq53465__$1 = cljs.core.next(seq53465);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53466,seq53465__$1);
}));

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53935 = arguments.length;
var i__4790__auto___53936 = (0);
while(true){
if((i__4790__auto___53936 < len__4789__auto___53935)){
args__4795__auto__.push((arguments[i__4790__auto___53936]));

var G__53937 = (i__4790__auto___53936 + (1));
i__4790__auto___53936 = G__53937;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__53492_53938 = cljs.core.seq(keywords);
var chunk__53493_53939 = null;
var count__53494_53940 = (0);
var i__53495_53941 = (0);
while(true){
if((i__53495_53941 < count__53494_53940)){
var kw_53942 = chunk__53493_53939.cljs$core$IIndexed$_nth$arity$2(null,i__53495_53941);
style.removeProperty(dommy.utils.as_str(kw_53942));


var G__53943 = seq__53492_53938;
var G__53944 = chunk__53493_53939;
var G__53945 = count__53494_53940;
var G__53946 = (i__53495_53941 + (1));
seq__53492_53938 = G__53943;
chunk__53493_53939 = G__53944;
count__53494_53940 = G__53945;
i__53495_53941 = G__53946;
continue;
} else {
var temp__5735__auto___53947 = cljs.core.seq(seq__53492_53938);
if(temp__5735__auto___53947){
var seq__53492_53948__$1 = temp__5735__auto___53947;
if(cljs.core.chunked_seq_QMARK_(seq__53492_53948__$1)){
var c__4609__auto___53949 = cljs.core.chunk_first(seq__53492_53948__$1);
var G__53950 = cljs.core.chunk_rest(seq__53492_53948__$1);
var G__53951 = c__4609__auto___53949;
var G__53952 = cljs.core.count(c__4609__auto___53949);
var G__53953 = (0);
seq__53492_53938 = G__53950;
chunk__53493_53939 = G__53951;
count__53494_53940 = G__53952;
i__53495_53941 = G__53953;
continue;
} else {
var kw_53954 = cljs.core.first(seq__53492_53948__$1);
style.removeProperty(dommy.utils.as_str(kw_53954));


var G__53955 = cljs.core.next(seq__53492_53948__$1);
var G__53956 = null;
var G__53957 = (0);
var G__53958 = (0);
seq__53492_53938 = G__53955;
chunk__53493_53939 = G__53956;
count__53494_53940 = G__53957;
i__53495_53941 = G__53958;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq53487){
var G__53488 = cljs.core.first(seq53487);
var seq53487__$1 = cljs.core.next(seq53487);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53488,seq53487__$1);
}));

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53959 = arguments.length;
var i__4790__auto___53960 = (0);
while(true){
if((i__4790__auto___53960 < len__4789__auto___53959)){
args__4795__auto__.push((arguments[i__4790__auto___53960]));

var G__53961 = (i__4790__auto___53960 + (1));
i__4790__auto___53960 = G__53961;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__53504_53962 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__53505_53963 = null;
var count__53506_53964 = (0);
var i__53507_53965 = (0);
while(true){
if((i__53507_53965 < count__53506_53964)){
var vec__53514_53966 = chunk__53505_53963.cljs$core$IIndexed$_nth$arity$2(null,i__53507_53965);
var k_53967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53514_53966,(0),null);
var v_53968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53514_53966,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_53967,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_53968),"px"].join('')], 0));


var G__53969 = seq__53504_53962;
var G__53970 = chunk__53505_53963;
var G__53971 = count__53506_53964;
var G__53972 = (i__53507_53965 + (1));
seq__53504_53962 = G__53969;
chunk__53505_53963 = G__53970;
count__53506_53964 = G__53971;
i__53507_53965 = G__53972;
continue;
} else {
var temp__5735__auto___53973 = cljs.core.seq(seq__53504_53962);
if(temp__5735__auto___53973){
var seq__53504_53974__$1 = temp__5735__auto___53973;
if(cljs.core.chunked_seq_QMARK_(seq__53504_53974__$1)){
var c__4609__auto___53975 = cljs.core.chunk_first(seq__53504_53974__$1);
var G__53976 = cljs.core.chunk_rest(seq__53504_53974__$1);
var G__53977 = c__4609__auto___53975;
var G__53978 = cljs.core.count(c__4609__auto___53975);
var G__53979 = (0);
seq__53504_53962 = G__53976;
chunk__53505_53963 = G__53977;
count__53506_53964 = G__53978;
i__53507_53965 = G__53979;
continue;
} else {
var vec__53517_53980 = cljs.core.first(seq__53504_53974__$1);
var k_53981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53517_53980,(0),null);
var v_53982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53517_53980,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_53981,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_53982),"px"].join('')], 0));


var G__53983 = cljs.core.next(seq__53504_53974__$1);
var G__53984 = null;
var G__53985 = (0);
var G__53986 = (0);
seq__53504_53962 = G__53983;
chunk__53505_53963 = G__53984;
count__53506_53964 = G__53985;
i__53507_53965 = G__53986;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq53501){
var G__53502 = cljs.core.first(seq53501);
var seq53501__$1 = cljs.core.next(seq53501);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53502,seq53501__$1);
}));

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__53525 = arguments.length;
switch (G__53525) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___53988 = arguments.length;
var i__4790__auto___53989 = (0);
while(true){
if((i__4790__auto___53989 < len__4789__auto___53988)){
args_arr__4810__auto__.push((arguments[i__4790__auto___53989]));

var G__53990 = (i__4790__auto___53989 + (1));
i__4790__auto___53989 = G__53990;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4811__auto__);

}
});

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__53528 = elem;
(G__53528[k__$1] = v);

return G__53528;
} else {
var G__53529 = elem;
G__53529.setAttribute(k__$1,v);

return G__53529;
}
} else {
return null;
}
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__53530_53991 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__53531_53992 = null;
var count__53532_53993 = (0);
var i__53533_53994 = (0);
while(true){
if((i__53533_53994 < count__53532_53993)){
var vec__53543_53995 = chunk__53531_53992.cljs$core$IIndexed$_nth$arity$2(null,i__53533_53994);
var k_53996__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53543_53995,(0),null);
var v_53997__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53543_53995,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_53996__$1,v_53997__$1);


var G__53998 = seq__53530_53991;
var G__53999 = chunk__53531_53992;
var G__54000 = count__53532_53993;
var G__54001 = (i__53533_53994 + (1));
seq__53530_53991 = G__53998;
chunk__53531_53992 = G__53999;
count__53532_53993 = G__54000;
i__53533_53994 = G__54001;
continue;
} else {
var temp__5735__auto___54002 = cljs.core.seq(seq__53530_53991);
if(temp__5735__auto___54002){
var seq__53530_54003__$1 = temp__5735__auto___54002;
if(cljs.core.chunked_seq_QMARK_(seq__53530_54003__$1)){
var c__4609__auto___54004 = cljs.core.chunk_first(seq__53530_54003__$1);
var G__54005 = cljs.core.chunk_rest(seq__53530_54003__$1);
var G__54006 = c__4609__auto___54004;
var G__54007 = cljs.core.count(c__4609__auto___54004);
var G__54008 = (0);
seq__53530_53991 = G__54005;
chunk__53531_53992 = G__54006;
count__53532_53993 = G__54007;
i__53533_53994 = G__54008;
continue;
} else {
var vec__53548_54009 = cljs.core.first(seq__53530_54003__$1);
var k_54010__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53548_54009,(0),null);
var v_54011__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53548_54009,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_54010__$1,v_54011__$1);


var G__54012 = cljs.core.next(seq__53530_54003__$1);
var G__54013 = null;
var G__54014 = (0);
var G__54015 = (0);
seq__53530_53991 = G__54012;
chunk__53531_53992 = G__54013;
count__53532_53993 = G__54014;
i__53533_53994 = G__54015;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq53521){
var G__53522 = cljs.core.first(seq53521);
var seq53521__$1 = cljs.core.next(seq53521);
var G__53523 = cljs.core.first(seq53521__$1);
var seq53521__$2 = cljs.core.next(seq53521__$1);
var G__53524 = cljs.core.first(seq53521__$2);
var seq53521__$3 = cljs.core.next(seq53521__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53522,G__53523,G__53524,seq53521__$3);
}));

(dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__53557 = arguments.length;
switch (G__53557) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54017 = arguments.length;
var i__4790__auto___54018 = (0);
while(true){
if((i__4790__auto___54018 < len__4789__auto___54017)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54018]));

var G__54019 = (i__4790__auto___54018 + (1));
i__4790__auto___54018 = G__54019;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_54020__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_((function (){var fexpr__53561 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null);
return (fexpr__53561.cljs$core$IFn$_invoke$arity$1 ? fexpr__53561.cljs$core$IFn$_invoke$arity$1(k_54020__$1) : fexpr__53561.call(null,k_54020__$1));
})())){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_54020__$1);
}

return elem;
}));

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__53565_54021 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__53566_54022 = null;
var count__53567_54023 = (0);
var i__53568_54024 = (0);
while(true){
if((i__53568_54024 < count__53567_54023)){
var k_54025__$1 = chunk__53566_54022.cljs$core$IIndexed$_nth$arity$2(null,i__53568_54024);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_54025__$1);


var G__54026 = seq__53565_54021;
var G__54027 = chunk__53566_54022;
var G__54028 = count__53567_54023;
var G__54029 = (i__53568_54024 + (1));
seq__53565_54021 = G__54026;
chunk__53566_54022 = G__54027;
count__53567_54023 = G__54028;
i__53568_54024 = G__54029;
continue;
} else {
var temp__5735__auto___54030 = cljs.core.seq(seq__53565_54021);
if(temp__5735__auto___54030){
var seq__53565_54031__$1 = temp__5735__auto___54030;
if(cljs.core.chunked_seq_QMARK_(seq__53565_54031__$1)){
var c__4609__auto___54032 = cljs.core.chunk_first(seq__53565_54031__$1);
var G__54033 = cljs.core.chunk_rest(seq__53565_54031__$1);
var G__54034 = c__4609__auto___54032;
var G__54035 = cljs.core.count(c__4609__auto___54032);
var G__54036 = (0);
seq__53565_54021 = G__54033;
chunk__53566_54022 = G__54034;
count__53567_54023 = G__54035;
i__53568_54024 = G__54036;
continue;
} else {
var k_54037__$1 = cljs.core.first(seq__53565_54031__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_54037__$1);


var G__54038 = cljs.core.next(seq__53565_54031__$1);
var G__54039 = null;
var G__54040 = (0);
var G__54041 = (0);
seq__53565_54021 = G__54038;
chunk__53566_54022 = G__54039;
count__53567_54023 = G__54040;
i__53568_54024 = G__54041;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq53553){
var G__53554 = cljs.core.first(seq53553);
var seq53553__$1 = cljs.core.next(seq53553);
var G__53555 = cljs.core.first(seq53553__$1);
var seq53553__$2 = cljs.core.next(seq53553__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53554,G__53555,seq53553__$2);
}));

(dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__53577 = arguments.length;
switch (G__53577) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
}));

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
}));

(dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__53582 = arguments.length;
switch (G__53582) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54044 = arguments.length;
var i__4790__auto___54045 = (0);
while(true){
if((i__4790__auto___54045 < len__4789__auto___54044)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54045]));

var G__54046 = (i__4790__auto___54045 + (1));
i__4790__auto___54045 = G__54046;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__5733__auto___54047 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54047)){
var class_list_54048 = temp__5733__auto___54047;
var seq__53583_54049 = cljs.core.seq(classes__$1);
var chunk__53584_54050 = null;
var count__53585_54051 = (0);
var i__53586_54052 = (0);
while(true){
if((i__53586_54052 < count__53585_54051)){
var c_54053 = chunk__53584_54050.cljs$core$IIndexed$_nth$arity$2(null,i__53586_54052);
class_list_54048.add(c_54053);


var G__54054 = seq__53583_54049;
var G__54055 = chunk__53584_54050;
var G__54056 = count__53585_54051;
var G__54057 = (i__53586_54052 + (1));
seq__53583_54049 = G__54054;
chunk__53584_54050 = G__54055;
count__53585_54051 = G__54056;
i__53586_54052 = G__54057;
continue;
} else {
var temp__5735__auto___54058 = cljs.core.seq(seq__53583_54049);
if(temp__5735__auto___54058){
var seq__53583_54059__$1 = temp__5735__auto___54058;
if(cljs.core.chunked_seq_QMARK_(seq__53583_54059__$1)){
var c__4609__auto___54060 = cljs.core.chunk_first(seq__53583_54059__$1);
var G__54061 = cljs.core.chunk_rest(seq__53583_54059__$1);
var G__54062 = c__4609__auto___54060;
var G__54063 = cljs.core.count(c__4609__auto___54060);
var G__54064 = (0);
seq__53583_54049 = G__54061;
chunk__53584_54050 = G__54062;
count__53585_54051 = G__54063;
i__53586_54052 = G__54064;
continue;
} else {
var c_54065 = cljs.core.first(seq__53583_54059__$1);
class_list_54048.add(c_54065);


var G__54066 = cljs.core.next(seq__53583_54059__$1);
var G__54067 = null;
var G__54068 = (0);
var G__54069 = (0);
seq__53583_54049 = G__54066;
chunk__53584_54050 = G__54067;
count__53585_54051 = G__54068;
i__53586_54052 = G__54069;
continue;
}
} else {
}
}
break;
}
} else {
var seq__53589_54070 = cljs.core.seq(classes__$1);
var chunk__53590_54071 = null;
var count__53591_54072 = (0);
var i__53592_54073 = (0);
while(true){
if((i__53592_54073 < count__53591_54072)){
var c_54074 = chunk__53590_54071.cljs$core$IIndexed$_nth$arity$2(null,i__53592_54073);
var class_name_54075 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_54075,c_54074))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_54075 === ""))?c_54074:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_54075)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_54074)].join('')));
}


var G__54076 = seq__53589_54070;
var G__54077 = chunk__53590_54071;
var G__54078 = count__53591_54072;
var G__54079 = (i__53592_54073 + (1));
seq__53589_54070 = G__54076;
chunk__53590_54071 = G__54077;
count__53591_54072 = G__54078;
i__53592_54073 = G__54079;
continue;
} else {
var temp__5735__auto___54080 = cljs.core.seq(seq__53589_54070);
if(temp__5735__auto___54080){
var seq__53589_54081__$1 = temp__5735__auto___54080;
if(cljs.core.chunked_seq_QMARK_(seq__53589_54081__$1)){
var c__4609__auto___54082 = cljs.core.chunk_first(seq__53589_54081__$1);
var G__54083 = cljs.core.chunk_rest(seq__53589_54081__$1);
var G__54084 = c__4609__auto___54082;
var G__54085 = cljs.core.count(c__4609__auto___54082);
var G__54086 = (0);
seq__53589_54070 = G__54083;
chunk__53590_54071 = G__54084;
count__53591_54072 = G__54085;
i__53592_54073 = G__54086;
continue;
} else {
var c_54087 = cljs.core.first(seq__53589_54081__$1);
var class_name_54088 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_54088,c_54087))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_54088 === ""))?c_54087:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_54088)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_54087)].join('')));
}


var G__54089 = cljs.core.next(seq__53589_54081__$1);
var G__54090 = null;
var G__54091 = (0);
var G__54092 = (0);
seq__53589_54070 = G__54089;
chunk__53590_54071 = G__54090;
count__53591_54072 = G__54091;
i__53592_54073 = G__54092;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
}));

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__53595_54093 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__53596_54094 = null;
var count__53597_54095 = (0);
var i__53598_54096 = (0);
while(true){
if((i__53598_54096 < count__53597_54095)){
var c_54097 = chunk__53596_54094.cljs$core$IIndexed$_nth$arity$2(null,i__53598_54096);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_54097);


var G__54098 = seq__53595_54093;
var G__54099 = chunk__53596_54094;
var G__54100 = count__53597_54095;
var G__54101 = (i__53598_54096 + (1));
seq__53595_54093 = G__54098;
chunk__53596_54094 = G__54099;
count__53597_54095 = G__54100;
i__53598_54096 = G__54101;
continue;
} else {
var temp__5735__auto___54102 = cljs.core.seq(seq__53595_54093);
if(temp__5735__auto___54102){
var seq__53595_54103__$1 = temp__5735__auto___54102;
if(cljs.core.chunked_seq_QMARK_(seq__53595_54103__$1)){
var c__4609__auto___54104 = cljs.core.chunk_first(seq__53595_54103__$1);
var G__54105 = cljs.core.chunk_rest(seq__53595_54103__$1);
var G__54106 = c__4609__auto___54104;
var G__54107 = cljs.core.count(c__4609__auto___54104);
var G__54108 = (0);
seq__53595_54093 = G__54105;
chunk__53596_54094 = G__54106;
count__53597_54095 = G__54107;
i__53598_54096 = G__54108;
continue;
} else {
var c_54109 = cljs.core.first(seq__53595_54103__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_54109);


var G__54110 = cljs.core.next(seq__53595_54103__$1);
var G__54111 = null;
var G__54112 = (0);
var G__54113 = (0);
seq__53595_54093 = G__54110;
chunk__53596_54094 = G__54111;
count__53597_54095 = G__54112;
i__53598_54096 = G__54113;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq53579){
var G__53580 = cljs.core.first(seq53579);
var seq53579__$1 = cljs.core.next(seq53579);
var G__53581 = cljs.core.first(seq53579__$1);
var seq53579__$2 = cljs.core.next(seq53579__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53580,G__53581,seq53579__$2);
}));

(dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__53609 = arguments.length;
switch (G__53609) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54115 = arguments.length;
var i__4790__auto___54116 = (0);
while(true){
if((i__4790__auto___54116 < len__4789__auto___54115)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54116]));

var G__54117 = (i__4790__auto___54116 + (1));
i__4790__auto___54116 = G__54117;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___54118 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54118)){
var class_list_54119 = temp__5733__auto___54118;
class_list_54119.remove(c__$1);
} else {
var class_name_54120 = dommy.core.class$(elem);
var new_class_name_54121 = dommy.utils.remove_class_str(class_name_54120,c__$1);
if((class_name_54120 === new_class_name_54121)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_54121);
}
}

return elem;
}));

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__53612 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__53613 = null;
var count__53614 = (0);
var i__53615 = (0);
while(true){
if((i__53615 < count__53614)){
var c = chunk__53613.cljs$core$IIndexed$_nth$arity$2(null,i__53615);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__54122 = seq__53612;
var G__54123 = chunk__53613;
var G__54124 = count__53614;
var G__54125 = (i__53615 + (1));
seq__53612 = G__54122;
chunk__53613 = G__54123;
count__53614 = G__54124;
i__53615 = G__54125;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__53612);
if(temp__5735__auto__){
var seq__53612__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53612__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__53612__$1);
var G__54126 = cljs.core.chunk_rest(seq__53612__$1);
var G__54127 = c__4609__auto__;
var G__54128 = cljs.core.count(c__4609__auto__);
var G__54129 = (0);
seq__53612 = G__54126;
chunk__53613 = G__54127;
count__53614 = G__54128;
i__53615 = G__54129;
continue;
} else {
var c = cljs.core.first(seq__53612__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__54130 = cljs.core.next(seq__53612__$1);
var G__54131 = null;
var G__54132 = (0);
var G__54133 = (0);
seq__53612 = G__54130;
chunk__53613 = G__54131;
count__53614 = G__54132;
i__53615 = G__54133;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq53606){
var G__53607 = cljs.core.first(seq53606);
var seq53606__$1 = cljs.core.next(seq53606);
var G__53608 = cljs.core.first(seq53606__$1);
var seq53606__$2 = cljs.core.next(seq53606__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53607,G__53608,seq53606__$2);
}));

(dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__53621 = arguments.length;
switch (G__53621) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___54135 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54135)){
var class_list_54136 = temp__5733__auto___54135;
class_list_54136.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,(!(dommy.core.has_class_QMARK_(elem,c__$1))));
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__53626 = arguments.length;
switch (G__53626) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none")], 0));
}));

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
}));

(dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__53628 = arguments.length;
switch (G__53628) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$lang$maxFixedArity = 2);

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__53633 = arguments.length;
switch (G__53633) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54140 = arguments.length;
var i__4790__auto___54141 = (0);
while(true){
if((i__4790__auto___54141 < len__4789__auto___54140)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54141]));

var G__54142 = (i__4790__auto___54141 + (1));
i__4790__auto___54141 = G__54142;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__53634 = parent;
G__53634.appendChild(child);

return G__53634;
}));

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__53635_54143 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__53636_54144 = null;
var count__53637_54145 = (0);
var i__53638_54146 = (0);
while(true){
if((i__53638_54146 < count__53637_54145)){
var c_54147 = chunk__53636_54144.cljs$core$IIndexed$_nth$arity$2(null,i__53638_54146);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54147);


var G__54148 = seq__53635_54143;
var G__54149 = chunk__53636_54144;
var G__54150 = count__53637_54145;
var G__54151 = (i__53638_54146 + (1));
seq__53635_54143 = G__54148;
chunk__53636_54144 = G__54149;
count__53637_54145 = G__54150;
i__53638_54146 = G__54151;
continue;
} else {
var temp__5735__auto___54152 = cljs.core.seq(seq__53635_54143);
if(temp__5735__auto___54152){
var seq__53635_54153__$1 = temp__5735__auto___54152;
if(cljs.core.chunked_seq_QMARK_(seq__53635_54153__$1)){
var c__4609__auto___54154 = cljs.core.chunk_first(seq__53635_54153__$1);
var G__54155 = cljs.core.chunk_rest(seq__53635_54153__$1);
var G__54156 = c__4609__auto___54154;
var G__54157 = cljs.core.count(c__4609__auto___54154);
var G__54158 = (0);
seq__53635_54143 = G__54155;
chunk__53636_54144 = G__54156;
count__53637_54145 = G__54157;
i__53638_54146 = G__54158;
continue;
} else {
var c_54159 = cljs.core.first(seq__53635_54153__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54159);


var G__54160 = cljs.core.next(seq__53635_54153__$1);
var G__54161 = null;
var G__54162 = (0);
var G__54163 = (0);
seq__53635_54143 = G__54160;
chunk__53636_54144 = G__54161;
count__53637_54145 = G__54162;
i__53638_54146 = G__54163;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq53630){
var G__53631 = cljs.core.first(seq53630);
var seq53630__$1 = cljs.core.next(seq53630);
var G__53632 = cljs.core.first(seq53630__$1);
var seq53630__$2 = cljs.core.next(seq53630__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53631,G__53632,seq53630__$2);
}));

(dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__53643 = arguments.length;
switch (G__53643) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54165 = arguments.length;
var i__4790__auto___54166 = (0);
while(true){
if((i__4790__auto___54166 < len__4789__auto___54165)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54166]));

var G__54167 = (i__4790__auto___54166 + (1));
i__4790__auto___54166 = G__54167;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__53644 = parent;
G__53644.insertBefore(child,parent.firstChild);

return G__53644;
}));

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__53645_54168 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__53646_54169 = null;
var count__53647_54170 = (0);
var i__53648_54171 = (0);
while(true){
if((i__53648_54171 < count__53647_54170)){
var c_54172 = chunk__53646_54169.cljs$core$IIndexed$_nth$arity$2(null,i__53648_54171);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54172);


var G__54173 = seq__53645_54168;
var G__54174 = chunk__53646_54169;
var G__54175 = count__53647_54170;
var G__54176 = (i__53648_54171 + (1));
seq__53645_54168 = G__54173;
chunk__53646_54169 = G__54174;
count__53647_54170 = G__54175;
i__53648_54171 = G__54176;
continue;
} else {
var temp__5735__auto___54177 = cljs.core.seq(seq__53645_54168);
if(temp__5735__auto___54177){
var seq__53645_54178__$1 = temp__5735__auto___54177;
if(cljs.core.chunked_seq_QMARK_(seq__53645_54178__$1)){
var c__4609__auto___54179 = cljs.core.chunk_first(seq__53645_54178__$1);
var G__54180 = cljs.core.chunk_rest(seq__53645_54178__$1);
var G__54181 = c__4609__auto___54179;
var G__54182 = cljs.core.count(c__4609__auto___54179);
var G__54183 = (0);
seq__53645_54168 = G__54180;
chunk__53646_54169 = G__54181;
count__53647_54170 = G__54182;
i__53648_54171 = G__54183;
continue;
} else {
var c_54184 = cljs.core.first(seq__53645_54178__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54184);


var G__54185 = cljs.core.next(seq__53645_54178__$1);
var G__54186 = null;
var G__54187 = (0);
var G__54188 = (0);
seq__53645_54168 = G__54185;
chunk__53646_54169 = G__54186;
count__53647_54170 = G__54187;
i__53648_54171 = G__54188;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq53640){
var G__53641 = cljs.core.first(seq53640);
var seq53640__$1 = cljs.core.next(seq53640);
var G__53642 = cljs.core.first(seq53640__$1);
var seq53640__$2 = cljs.core.next(seq53640__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53641,G__53642,seq53640__$2);
}));

(dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5733__auto___54189 = other.nextSibling;
if(cljs.core.truth_(temp__5733__auto___54189)){
var next_54190 = temp__5733__auto___54189;
dommy.core.insert_before_BANG_(elem,next_54190);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__53653 = arguments.length;
switch (G__53653) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
}));

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__53654 = p;
G__53654.removeChild(elem);

return G__53654;
}));

(dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__53656){
var vec__53657 = p__53656;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53657,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53657,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,(function (f){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4185__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4174__auto__ = related_target;
if(cljs.core.truth_(and__4174__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4174__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
})])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4174__auto__ = selected_target;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4174__auto__;
}
})())){
(event.selectedTarget = selected_target);

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4185__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54201 = arguments.length;
var i__4790__auto___54202 = (0);
while(true){
if((i__4790__auto___54202 < len__4789__auto___54201)){
args__4795__auto__.push((arguments[i__4790__auto___54202]));

var G__54204 = (i__4790__auto___54202 + (1));
i__4790__auto___54202 = G__54204;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return (elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args));
}));

(dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq53660){
var G__53661 = cljs.core.first(seq53660);
var seq53660__$1 = cljs.core.next(seq53660);
var G__53662 = cljs.core.first(seq53660__$1);
var seq53660__$2 = cljs.core.next(seq53660__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53661,G__53662,seq53660__$2);
}));

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
var fexpr__53667 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest);
return (fexpr__53667.cljs$core$IFn$_invoke$arity$1 ? fexpr__53667.cljs$core$IFn$_invoke$arity$1(elem_sel) : fexpr__53667.call(null,elem_sel));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54206 = arguments.length;
var i__4790__auto___54207 = (0);
while(true){
if((i__4790__auto___54207 < len__4789__auto___54206)){
args__4795__auto__.push((arguments[i__4790__auto___54207]));

var G__54208 = (i__4790__auto___54207 + (1));
i__4790__auto___54207 = G__54208;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53675_54213 = dommy.core.elem_and_selector(elem_sel);
var elem_54214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53675_54213,(0),null);
var selector_54215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53675_54213,(1),null);
var seq__53678_54216 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53685_54217 = null;
var count__53686_54218 = (0);
var i__53687_54219 = (0);
while(true){
if((i__53687_54219 < count__53686_54218)){
var vec__53744_54220 = chunk__53685_54217.cljs$core$IIndexed$_nth$arity$2(null,i__53687_54219);
var orig_type_54221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53744_54220,(0),null);
var f_54222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53744_54220,(1),null);
var seq__53688_54223 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54221,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54221,cljs.core.identity])));
var chunk__53690_54224 = null;
var count__53691_54225 = (0);
var i__53692_54226 = (0);
while(true){
if((i__53692_54226 < count__53691_54225)){
var vec__53757_54227 = chunk__53690_54224.cljs$core$IIndexed$_nth$arity$2(null,i__53692_54226);
var actual_type_54228 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53757_54227,(0),null);
var factory_54229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53757_54227,(1),null);
var canonical_f_54230 = (function (){var G__53761 = (factory_54229.cljs$core$IFn$_invoke$arity$1 ? factory_54229.cljs$core$IFn$_invoke$arity$1(f_54222) : factory_54229.call(null,f_54222));
var fexpr__53760 = (cljs.core.truth_(selector_54215)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54214,selector_54215):cljs.core.identity);
return (fexpr__53760.cljs$core$IFn$_invoke$arity$1 ? fexpr__53760.cljs$core$IFn$_invoke$arity$1(G__53761) : fexpr__53760.call(null,G__53761));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54214,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54215,actual_type_54228,f_54222], null),canonical_f_54230], 0));

if(cljs.core.truth_(elem_54214.addEventListener)){
elem_54214.addEventListener(cljs.core.name(actual_type_54228),canonical_f_54230);
} else {
elem_54214.attachEvent(cljs.core.name(actual_type_54228),canonical_f_54230);
}


var G__54231 = seq__53688_54223;
var G__54232 = chunk__53690_54224;
var G__54233 = count__53691_54225;
var G__54234 = (i__53692_54226 + (1));
seq__53688_54223 = G__54231;
chunk__53690_54224 = G__54232;
count__53691_54225 = G__54233;
i__53692_54226 = G__54234;
continue;
} else {
var temp__5735__auto___54235 = cljs.core.seq(seq__53688_54223);
if(temp__5735__auto___54235){
var seq__53688_54236__$1 = temp__5735__auto___54235;
if(cljs.core.chunked_seq_QMARK_(seq__53688_54236__$1)){
var c__4609__auto___54237 = cljs.core.chunk_first(seq__53688_54236__$1);
var G__54238 = cljs.core.chunk_rest(seq__53688_54236__$1);
var G__54239 = c__4609__auto___54237;
var G__54240 = cljs.core.count(c__4609__auto___54237);
var G__54241 = (0);
seq__53688_54223 = G__54238;
chunk__53690_54224 = G__54239;
count__53691_54225 = G__54240;
i__53692_54226 = G__54241;
continue;
} else {
var vec__53762_54242 = cljs.core.first(seq__53688_54236__$1);
var actual_type_54243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53762_54242,(0),null);
var factory_54244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53762_54242,(1),null);
var canonical_f_54245 = (function (){var G__53766 = (factory_54244.cljs$core$IFn$_invoke$arity$1 ? factory_54244.cljs$core$IFn$_invoke$arity$1(f_54222) : factory_54244.call(null,f_54222));
var fexpr__53765 = (cljs.core.truth_(selector_54215)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54214,selector_54215):cljs.core.identity);
return (fexpr__53765.cljs$core$IFn$_invoke$arity$1 ? fexpr__53765.cljs$core$IFn$_invoke$arity$1(G__53766) : fexpr__53765.call(null,G__53766));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54214,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54215,actual_type_54243,f_54222], null),canonical_f_54245], 0));

if(cljs.core.truth_(elem_54214.addEventListener)){
elem_54214.addEventListener(cljs.core.name(actual_type_54243),canonical_f_54245);
} else {
elem_54214.attachEvent(cljs.core.name(actual_type_54243),canonical_f_54245);
}


var G__54246 = cljs.core.next(seq__53688_54236__$1);
var G__54247 = null;
var G__54248 = (0);
var G__54249 = (0);
seq__53688_54223 = G__54246;
chunk__53690_54224 = G__54247;
count__53691_54225 = G__54248;
i__53692_54226 = G__54249;
continue;
}
} else {
}
}
break;
}

var G__54250 = seq__53678_54216;
var G__54251 = chunk__53685_54217;
var G__54252 = count__53686_54218;
var G__54253 = (i__53687_54219 + (1));
seq__53678_54216 = G__54250;
chunk__53685_54217 = G__54251;
count__53686_54218 = G__54252;
i__53687_54219 = G__54253;
continue;
} else {
var temp__5735__auto___54254 = cljs.core.seq(seq__53678_54216);
if(temp__5735__auto___54254){
var seq__53678_54255__$1 = temp__5735__auto___54254;
if(cljs.core.chunked_seq_QMARK_(seq__53678_54255__$1)){
var c__4609__auto___54256 = cljs.core.chunk_first(seq__53678_54255__$1);
var G__54257 = cljs.core.chunk_rest(seq__53678_54255__$1);
var G__54258 = c__4609__auto___54256;
var G__54259 = cljs.core.count(c__4609__auto___54256);
var G__54260 = (0);
seq__53678_54216 = G__54257;
chunk__53685_54217 = G__54258;
count__53686_54218 = G__54259;
i__53687_54219 = G__54260;
continue;
} else {
var vec__53767_54264 = cljs.core.first(seq__53678_54255__$1);
var orig_type_54265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53767_54264,(0),null);
var f_54266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53767_54264,(1),null);
var seq__53679_54267 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54265,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54265,cljs.core.identity])));
var chunk__53681_54268 = null;
var count__53682_54269 = (0);
var i__53683_54270 = (0);
while(true){
if((i__53683_54270 < count__53682_54269)){
var vec__53780_54271 = chunk__53681_54268.cljs$core$IIndexed$_nth$arity$2(null,i__53683_54270);
var actual_type_54272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53780_54271,(0),null);
var factory_54273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53780_54271,(1),null);
var canonical_f_54274 = (function (){var G__53784 = (factory_54273.cljs$core$IFn$_invoke$arity$1 ? factory_54273.cljs$core$IFn$_invoke$arity$1(f_54266) : factory_54273.call(null,f_54266));
var fexpr__53783 = (cljs.core.truth_(selector_54215)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54214,selector_54215):cljs.core.identity);
return (fexpr__53783.cljs$core$IFn$_invoke$arity$1 ? fexpr__53783.cljs$core$IFn$_invoke$arity$1(G__53784) : fexpr__53783.call(null,G__53784));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54214,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54215,actual_type_54272,f_54266], null),canonical_f_54274], 0));

if(cljs.core.truth_(elem_54214.addEventListener)){
elem_54214.addEventListener(cljs.core.name(actual_type_54272),canonical_f_54274);
} else {
elem_54214.attachEvent(cljs.core.name(actual_type_54272),canonical_f_54274);
}


var G__54275 = seq__53679_54267;
var G__54276 = chunk__53681_54268;
var G__54277 = count__53682_54269;
var G__54278 = (i__53683_54270 + (1));
seq__53679_54267 = G__54275;
chunk__53681_54268 = G__54276;
count__53682_54269 = G__54277;
i__53683_54270 = G__54278;
continue;
} else {
var temp__5735__auto___54279__$1 = cljs.core.seq(seq__53679_54267);
if(temp__5735__auto___54279__$1){
var seq__53679_54281__$1 = temp__5735__auto___54279__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53679_54281__$1)){
var c__4609__auto___54282 = cljs.core.chunk_first(seq__53679_54281__$1);
var G__54283 = cljs.core.chunk_rest(seq__53679_54281__$1);
var G__54284 = c__4609__auto___54282;
var G__54285 = cljs.core.count(c__4609__auto___54282);
var G__54286 = (0);
seq__53679_54267 = G__54283;
chunk__53681_54268 = G__54284;
count__53682_54269 = G__54285;
i__53683_54270 = G__54286;
continue;
} else {
var vec__53785_54287 = cljs.core.first(seq__53679_54281__$1);
var actual_type_54288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53785_54287,(0),null);
var factory_54289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53785_54287,(1),null);
var canonical_f_54290 = (function (){var G__53789 = (factory_54289.cljs$core$IFn$_invoke$arity$1 ? factory_54289.cljs$core$IFn$_invoke$arity$1(f_54266) : factory_54289.call(null,f_54266));
var fexpr__53788 = (cljs.core.truth_(selector_54215)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54214,selector_54215):cljs.core.identity);
return (fexpr__53788.cljs$core$IFn$_invoke$arity$1 ? fexpr__53788.cljs$core$IFn$_invoke$arity$1(G__53789) : fexpr__53788.call(null,G__53789));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54214,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54215,actual_type_54288,f_54266], null),canonical_f_54290], 0));

if(cljs.core.truth_(elem_54214.addEventListener)){
elem_54214.addEventListener(cljs.core.name(actual_type_54288),canonical_f_54290);
} else {
elem_54214.attachEvent(cljs.core.name(actual_type_54288),canonical_f_54290);
}


var G__54292 = cljs.core.next(seq__53679_54281__$1);
var G__54293 = null;
var G__54294 = (0);
var G__54295 = (0);
seq__53679_54267 = G__54292;
chunk__53681_54268 = G__54293;
count__53682_54269 = G__54294;
i__53683_54270 = G__54295;
continue;
}
} else {
}
}
break;
}

var G__54296 = cljs.core.next(seq__53678_54255__$1);
var G__54297 = null;
var G__54298 = (0);
var G__54299 = (0);
seq__53678_54216 = G__54296;
chunk__53685_54217 = G__54297;
count__53686_54218 = G__54298;
i__53687_54219 = G__54299;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq53669){
var G__53670 = cljs.core.first(seq53669);
var seq53669__$1 = cljs.core.next(seq53669);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53670,seq53669__$1);
}));

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54301 = arguments.length;
var i__4790__auto___54302 = (0);
while(true){
if((i__4790__auto___54302 < len__4789__auto___54301)){
args__4795__auto__.push((arguments[i__4790__auto___54302]));

var G__54303 = (i__4790__auto___54302 + (1));
i__4790__auto___54302 = G__54303;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53795_54305 = dommy.core.elem_and_selector(elem_sel);
var elem_54306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53795_54305,(0),null);
var selector_54307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53795_54305,(1),null);
var seq__53798_54308 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53805_54309 = null;
var count__53806_54310 = (0);
var i__53807_54311 = (0);
while(true){
if((i__53807_54311 < count__53806_54310)){
var vec__53850_54313 = chunk__53805_54309.cljs$core$IIndexed$_nth$arity$2(null,i__53807_54311);
var orig_type_54314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53850_54313,(0),null);
var f_54315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53850_54313,(1),null);
var seq__53808_54318 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54314,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54314,cljs.core.identity])));
var chunk__53810_54319 = null;
var count__53811_54320 = (0);
var i__53812_54321 = (0);
while(true){
if((i__53812_54321 < count__53811_54320)){
var vec__53860_54322 = chunk__53810_54319.cljs$core$IIndexed$_nth$arity$2(null,i__53812_54321);
var actual_type_54323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53860_54322,(0),null);
var __54324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53860_54322,(1),null);
var keys_54325 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54307,actual_type_54323,f_54315], null);
var canonical_f_54326 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54306),keys_54325);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54306,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54325], 0));

if(cljs.core.truth_(elem_54306.removeEventListener)){
elem_54306.removeEventListener(cljs.core.name(actual_type_54323),canonical_f_54326);
} else {
elem_54306.detachEvent(cljs.core.name(actual_type_54323),canonical_f_54326);
}


var G__54327 = seq__53808_54318;
var G__54328 = chunk__53810_54319;
var G__54329 = count__53811_54320;
var G__54330 = (i__53812_54321 + (1));
seq__53808_54318 = G__54327;
chunk__53810_54319 = G__54328;
count__53811_54320 = G__54329;
i__53812_54321 = G__54330;
continue;
} else {
var temp__5735__auto___54331 = cljs.core.seq(seq__53808_54318);
if(temp__5735__auto___54331){
var seq__53808_54332__$1 = temp__5735__auto___54331;
if(cljs.core.chunked_seq_QMARK_(seq__53808_54332__$1)){
var c__4609__auto___54333 = cljs.core.chunk_first(seq__53808_54332__$1);
var G__54334 = cljs.core.chunk_rest(seq__53808_54332__$1);
var G__54335 = c__4609__auto___54333;
var G__54336 = cljs.core.count(c__4609__auto___54333);
var G__54337 = (0);
seq__53808_54318 = G__54334;
chunk__53810_54319 = G__54335;
count__53811_54320 = G__54336;
i__53812_54321 = G__54337;
continue;
} else {
var vec__53865_54338 = cljs.core.first(seq__53808_54332__$1);
var actual_type_54339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53865_54338,(0),null);
var __54340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53865_54338,(1),null);
var keys_54341 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54307,actual_type_54339,f_54315], null);
var canonical_f_54342 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54306),keys_54341);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54306,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54341], 0));

if(cljs.core.truth_(elem_54306.removeEventListener)){
elem_54306.removeEventListener(cljs.core.name(actual_type_54339),canonical_f_54342);
} else {
elem_54306.detachEvent(cljs.core.name(actual_type_54339),canonical_f_54342);
}


var G__54343 = cljs.core.next(seq__53808_54332__$1);
var G__54344 = null;
var G__54345 = (0);
var G__54346 = (0);
seq__53808_54318 = G__54343;
chunk__53810_54319 = G__54344;
count__53811_54320 = G__54345;
i__53812_54321 = G__54346;
continue;
}
} else {
}
}
break;
}

var G__54347 = seq__53798_54308;
var G__54348 = chunk__53805_54309;
var G__54349 = count__53806_54310;
var G__54350 = (i__53807_54311 + (1));
seq__53798_54308 = G__54347;
chunk__53805_54309 = G__54348;
count__53806_54310 = G__54349;
i__53807_54311 = G__54350;
continue;
} else {
var temp__5735__auto___54351 = cljs.core.seq(seq__53798_54308);
if(temp__5735__auto___54351){
var seq__53798_54352__$1 = temp__5735__auto___54351;
if(cljs.core.chunked_seq_QMARK_(seq__53798_54352__$1)){
var c__4609__auto___54353 = cljs.core.chunk_first(seq__53798_54352__$1);
var G__54354 = cljs.core.chunk_rest(seq__53798_54352__$1);
var G__54355 = c__4609__auto___54353;
var G__54356 = cljs.core.count(c__4609__auto___54353);
var G__54357 = (0);
seq__53798_54308 = G__54354;
chunk__53805_54309 = G__54355;
count__53806_54310 = G__54356;
i__53807_54311 = G__54357;
continue;
} else {
var vec__53868_54358 = cljs.core.first(seq__53798_54352__$1);
var orig_type_54359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53868_54358,(0),null);
var f_54360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53868_54358,(1),null);
var seq__53799_54362 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54359,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54359,cljs.core.identity])));
var chunk__53801_54363 = null;
var count__53802_54364 = (0);
var i__53803_54365 = (0);
while(true){
if((i__53803_54365 < count__53802_54364)){
var vec__53877_54366 = chunk__53801_54363.cljs$core$IIndexed$_nth$arity$2(null,i__53803_54365);
var actual_type_54367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53877_54366,(0),null);
var __54368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53877_54366,(1),null);
var keys_54369 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54307,actual_type_54367,f_54360], null);
var canonical_f_54370 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54306),keys_54369);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54306,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54369], 0));

if(cljs.core.truth_(elem_54306.removeEventListener)){
elem_54306.removeEventListener(cljs.core.name(actual_type_54367),canonical_f_54370);
} else {
elem_54306.detachEvent(cljs.core.name(actual_type_54367),canonical_f_54370);
}


var G__54374 = seq__53799_54362;
var G__54375 = chunk__53801_54363;
var G__54376 = count__53802_54364;
var G__54377 = (i__53803_54365 + (1));
seq__53799_54362 = G__54374;
chunk__53801_54363 = G__54375;
count__53802_54364 = G__54376;
i__53803_54365 = G__54377;
continue;
} else {
var temp__5735__auto___54378__$1 = cljs.core.seq(seq__53799_54362);
if(temp__5735__auto___54378__$1){
var seq__53799_54379__$1 = temp__5735__auto___54378__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53799_54379__$1)){
var c__4609__auto___54380 = cljs.core.chunk_first(seq__53799_54379__$1);
var G__54381 = cljs.core.chunk_rest(seq__53799_54379__$1);
var G__54382 = c__4609__auto___54380;
var G__54383 = cljs.core.count(c__4609__auto___54380);
var G__54384 = (0);
seq__53799_54362 = G__54381;
chunk__53801_54363 = G__54382;
count__53802_54364 = G__54383;
i__53803_54365 = G__54384;
continue;
} else {
var vec__53880_54385 = cljs.core.first(seq__53799_54379__$1);
var actual_type_54386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53880_54385,(0),null);
var __54387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53880_54385,(1),null);
var keys_54388 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54307,actual_type_54386,f_54360], null);
var canonical_f_54389 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54306),keys_54388);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54306,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54388], 0));

if(cljs.core.truth_(elem_54306.removeEventListener)){
elem_54306.removeEventListener(cljs.core.name(actual_type_54386),canonical_f_54389);
} else {
elem_54306.detachEvent(cljs.core.name(actual_type_54386),canonical_f_54389);
}


var G__54390 = cljs.core.next(seq__53799_54379__$1);
var G__54391 = null;
var G__54392 = (0);
var G__54393 = (0);
seq__53799_54362 = G__54390;
chunk__53801_54363 = G__54391;
count__53802_54364 = G__54392;
i__53803_54365 = G__54393;
continue;
}
} else {
}
}
break;
}

var G__54394 = cljs.core.next(seq__53798_54352__$1);
var G__54395 = null;
var G__54396 = (0);
var G__54397 = (0);
seq__53798_54308 = G__54394;
chunk__53805_54309 = G__54395;
count__53806_54310 = G__54396;
i__53807_54311 = G__54397;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq53792){
var G__53793 = cljs.core.first(seq53792);
var seq53792__$1 = cljs.core.next(seq53792);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53793,seq53792__$1);
}));

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54399 = arguments.length;
var i__4790__auto___54400 = (0);
while(true){
if((i__4790__auto___54400 < len__4789__auto___54399)){
args__4795__auto__.push((arguments[i__4790__auto___54400]));

var G__54401 = (i__4790__auto___54400 + (1));
i__4790__auto___54400 = G__54401;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53885_54403 = dommy.core.elem_and_selector(elem_sel);
var elem_54404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53885_54403,(0),null);
var selector_54405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53885_54403,(1),null);
var seq__53888_54408 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53889_54409 = null;
var count__53890_54410 = (0);
var i__53891_54411 = (0);
while(true){
if((i__53891_54411 < count__53890_54410)){
var vec__53898_54412 = chunk__53889_54409.cljs$core$IIndexed$_nth$arity$2(null,i__53891_54411);
var type_54413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53898_54412,(0),null);
var f_54414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53898_54412,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54413,((function (seq__53888_54408,chunk__53889_54409,count__53890_54410,i__53891_54411,vec__53898_54412,type_54413,f_54414,vec__53885_54403,elem_54404,selector_54405){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54413,dommy$core$this_fn], 0));

return (f_54414.cljs$core$IFn$_invoke$arity$1 ? f_54414.cljs$core$IFn$_invoke$arity$1(e) : f_54414.call(null,e));
});})(seq__53888_54408,chunk__53889_54409,count__53890_54410,i__53891_54411,vec__53898_54412,type_54413,f_54414,vec__53885_54403,elem_54404,selector_54405))
], 0));


var G__54415 = seq__53888_54408;
var G__54416 = chunk__53889_54409;
var G__54417 = count__53890_54410;
var G__54418 = (i__53891_54411 + (1));
seq__53888_54408 = G__54415;
chunk__53889_54409 = G__54416;
count__53890_54410 = G__54417;
i__53891_54411 = G__54418;
continue;
} else {
var temp__5735__auto___54419 = cljs.core.seq(seq__53888_54408);
if(temp__5735__auto___54419){
var seq__53888_54420__$1 = temp__5735__auto___54419;
if(cljs.core.chunked_seq_QMARK_(seq__53888_54420__$1)){
var c__4609__auto___54421 = cljs.core.chunk_first(seq__53888_54420__$1);
var G__54422 = cljs.core.chunk_rest(seq__53888_54420__$1);
var G__54423 = c__4609__auto___54421;
var G__54424 = cljs.core.count(c__4609__auto___54421);
var G__54425 = (0);
seq__53888_54408 = G__54422;
chunk__53889_54409 = G__54423;
count__53890_54410 = G__54424;
i__53891_54411 = G__54425;
continue;
} else {
var vec__53901_54426 = cljs.core.first(seq__53888_54420__$1);
var type_54427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53901_54426,(0),null);
var f_54428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53901_54426,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54427,((function (seq__53888_54408,chunk__53889_54409,count__53890_54410,i__53891_54411,vec__53901_54426,type_54427,f_54428,seq__53888_54420__$1,temp__5735__auto___54419,vec__53885_54403,elem_54404,selector_54405){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54427,dommy$core$this_fn], 0));

return (f_54428.cljs$core$IFn$_invoke$arity$1 ? f_54428.cljs$core$IFn$_invoke$arity$1(e) : f_54428.call(null,e));
});})(seq__53888_54408,chunk__53889_54409,count__53890_54410,i__53891_54411,vec__53901_54426,type_54427,f_54428,seq__53888_54420__$1,temp__5735__auto___54419,vec__53885_54403,elem_54404,selector_54405))
], 0));


var G__54429 = cljs.core.next(seq__53888_54420__$1);
var G__54430 = null;
var G__54431 = (0);
var G__54432 = (0);
seq__53888_54408 = G__54429;
chunk__53889_54409 = G__54430;
count__53890_54410 = G__54431;
i__53891_54411 = G__54432;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq53883){
var G__53884 = cljs.core.first(seq53883);
var seq53883__$1 = cljs.core.next(seq53883);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53884,seq53883__$1);
}));


//# sourceMappingURL=dommy.core.js.map
