goog.provide('day8.re_frame_10x.utils.localstorage');
goog.require('cljs.core');
goog.require('goog.storage.Storage');
goog.require('goog.storage.mechanism.HTML5LocalStorage');
goog.require('cljs.reader');
goog.require('clojure.string');
day8.re_frame_10x.utils.localstorage.storage = (new goog.storage.Storage((new goog.storage.mechanism.HTML5LocalStorage())));
day8.re_frame_10x.utils.localstorage.safe_prefix = "day8.re-frame-10x.";
day8.re_frame_10x.utils.localstorage.safe_key = (function day8$re_frame_10x$utils$localstorage$safe_key(key){

return [day8.re_frame_10x.utils.localstorage.safe_prefix,cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
});
/**
 * Gets a re-frame-10x value from local storage.
 */
day8.re_frame_10x.utils.localstorage.get = (function day8$re_frame_10x$utils$localstorage$get(var_args){
var G__39613 = arguments.length;
switch (G__39613) {
case 1:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1 = (function (key){
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2(key,null);
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var value = day8.re_frame_10x.utils.localstorage.storage.get(day8.re_frame_10x.utils.localstorage.safe_key(key));
if((void 0 === value)){
return not_found;
} else {
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
}
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$lang$maxFixedArity = 2);

/**
 * Saves a re-frame-10x value to local storage.
 */
day8.re_frame_10x.utils.localstorage.save_BANG_ = (function day8$re_frame_10x$utils$localstorage$save_BANG_(key,value){
return day8.re_frame_10x.utils.localstorage.storage.set(day8.re_frame_10x.utils.localstorage.safe_key(key),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)));
});
/**
 * Deletes all re-frame-10x config keys
 */
day8.re_frame_10x.utils.localstorage.delete_all_keys_BANG_ = (function day8$re_frame_10x$utils$localstorage$delete_all_keys_BANG_(){
var seq__39619 = cljs.core.seq(Object.keys(localStorage));
var chunk__39620 = null;
var count__39621 = (0);
var i__39622 = (0);
while(true){
if((i__39622 < count__39621)){
var k = chunk__39620.cljs$core$IIndexed$_nth$arity$2(null,i__39622);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39651 = seq__39619;
var G__39652 = chunk__39620;
var G__39653 = count__39621;
var G__39654 = (i__39622 + (1));
seq__39619 = G__39651;
chunk__39620 = G__39652;
count__39621 = G__39653;
i__39622 = G__39654;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39619);
if(temp__5735__auto__){
var seq__39619__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39619__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39619__$1);
var G__39659 = cljs.core.chunk_rest(seq__39619__$1);
var G__39660 = c__4609__auto__;
var G__39661 = cljs.core.count(c__4609__auto__);
var G__39662 = (0);
seq__39619 = G__39659;
chunk__39620 = G__39660;
count__39621 = G__39661;
i__39622 = G__39662;
continue;
} else {
var k = cljs.core.first(seq__39619__$1);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39664 = cljs.core.next(seq__39619__$1);
var G__39666 = null;
var G__39667 = (0);
var G__39668 = (0);
seq__39619 = G__39664;
chunk__39620 = G__39666;
count__39621 = G__39667;
i__39622 = G__39668;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=day8.re_frame_10x.utils.localstorage.js.map
