goog.provide('pinkgorilla.kernel.cljs_helper');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('re_frame.core');
goog.require('pinkgorilla.ui.gorilla_renderable');
goog.require('pinkgorilla.ui.rendererCLJS');
pinkgorilla.kernel.cljs_helper.send_console = (function pinkgorilla$kernel$cljs_helper$send_console(segment_id,result){
var G__49316 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),result], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__49316) : re_frame.core.dispatch.call(null,G__49316));
});
/**
 * display the eval result in the notebook
 */
pinkgorilla.kernel.cljs_helper.send_value = (function pinkgorilla$kernel$cljs_helper$send_value(var_args){
var G__49318 = arguments.length;
switch (G__49318) {
case 2:
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$2 = (function (segment_id,result){
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3(segment_id,result,new cljs.core.Symbol(null,"cljs.user","cljs.user",877795071,null));
}));

(pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3 = (function (segment_id,result,namespace){
var G__49319 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:value-response","evaluator:value-response",-622097925),segment_id,result,namespace], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__49319) : re_frame.core.dispatch.call(null,G__49319));
}));

(pinkgorilla.kernel.cljs_helper.send_value.cljs$lang$maxFixedArity = 3);

pinkgorilla.kernel.cljs_helper.send_error = (function pinkgorilla$kernel$cljs_helper$send_error(segment_id,error_text){
var G__49321 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),error_text,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__49321) : re_frame.core.dispatch.call(null,G__49321));
});
/**
 * a simple render implementation for testing
 */
pinkgorilla.kernel.cljs_helper.render_embedded = (function pinkgorilla$kernel$cljs_helper$render_embedded(result){
var s = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([result], 0));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"html",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["span",s], null),new cljs.core.Keyword(null,"value","value",305978217),s], null)], null);
});
/**
 * rendering via the Renderable protocol (needs renderable project)
 * (users can define their own render implementations)
 */
pinkgorilla.kernel.cljs_helper.render_renderable = (function pinkgorilla$kernel$cljs_helper$render_renderable(result){
var response = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),pinkgorilla.ui.gorilla_renderable.render(result)], null);
return response;
});
/**
 * rendering via the Renderable protocol (needs renderable project)
 * (users can define their own render implementations)
 */
pinkgorilla.kernel.cljs_helper.render_renderable_meta = (function pinkgorilla$kernel$cljs_helper$render_renderable_meta(result){
var m = cljs.core.meta(result);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"r","r",-471384190)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),false], null):((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"R","R",-936662523)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),true], null):pinkgorilla.ui.gorilla_renderable.render(result)
))], null);
});
pinkgorilla.kernel.cljs_helper.send_result_eval = (function pinkgorilla$kernel$cljs_helper$send_result_eval(segment_id,result){
var vec__49329 = result;
var type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49329,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49329,(1),null);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.cljs-helper","/tmp/form-init1860564358436830039.clj",78,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cljs eval result:",result], null);
}),null)),null,-2013379953);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.cljs-helper","/tmp/form-init1860564358436830039.clj",79,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cljs eval result meta:",cljs.core.meta(data)], null);
}),null)),null,-632115666);

pinkgorilla.kernel.cljs_helper.send_console(segment_id,[" type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(data) : type.call(null,data))),"data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))].join(''));

var G__49333_49369 = type;
var G__49333_49370__$1 = (((G__49333_49369 instanceof cljs.core.Keyword))?G__49333_49369.fqn:null);
switch (G__49333_49370__$1) {
case "ok":
pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$2(segment_id,pinkgorilla.kernel.cljs_helper.render_renderable_meta(data));

break;
case "error":
pinkgorilla.kernel.cljs_helper.send_error(segment_id,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0)));

break;
default:
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.cljs-helper","/tmp/form-init1860564358436830039.clj",84,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cljs kernel received unknown result type: ",type,"data: ",data], null);
}),null)),null,697132574);

}

var G__49342 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__49342) : re_frame.core.dispatch.call(null,G__49342));
});

//# sourceMappingURL=pinkgorilla.kernel.cljs_helper.js.map
