goog.provide('pinkgorilla.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('secretary.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('pinkgorilla.subs');
goog.require('pinkgorilla.events');
goog.require('pinkgorilla.util');
goog.require('pinkgorilla.views');
goog.require('pinkgorilla.editor.core');
goog.require('pinkgorilla.routes');
goog.require('pinkgorilla.kernel.nrepl');
pinkgorilla.core.mount_root = (function pinkgorilla$core$mount_root(){
return reagent.core.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.views.gorilla_app], null),document.getElementById("react-app"));
});
pinkgorilla.core.init_BANG_ = (function pinkgorilla$core$init_BANG_(){
pinkgorilla.routes.app_routes();

pinkgorilla.editor.core.init_cm_globally_BANG_();

pinkgorilla.views.init_mathjax_globally_BANG_();

var app_url = pinkgorilla.util.application_url();
var route = app_url.anchor;
var read_write = ((cljs.core.not(route)) || (cljs.core.not(clojure.string.index_of.cljs$core$IFn$_invoke$arity$2(route,"/view"))));
var G__55559_55562 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"initialize-app-db","initialize-app-db",-1585144192),app_url], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__55559_55562) : re_frame.core.dispatch_sync.call(null,G__55559_55562));

var G__55560_55563 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"settings-localstorage-load","settings-localstorage-load",-1464956499)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__55560_55563) : re_frame.core.dispatch_sync.call(null,G__55560_55563));

var G__55561_55564 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"initialize-config","initialize-config",1399025996)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__55561_55564) : re_frame.core.dispatch_sync.call(null,G__55561_55564));

pinkgorilla.core.mount_root();

if(read_write){
pinkgorilla.kernel.nrepl.init_BANG_(pinkgorilla.util.ws_origin("repl/",app_url));
} else {
}

if(cljs.core.not(route)){
return pinkgorilla.routes.nav_BANG_("/new");
} else {
return secretary.core.dispatch_BANG_(route);
}
});
goog.exportSymbol('pinkgorilla.core.init_BANG_', pinkgorilla.core.init_BANG_);

//# sourceMappingURL=pinkgorilla.core.js.map
