goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4185__auto__ = elem.textContent;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__53459 = arguments.length;
switch (G__53459) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
}));

(dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
}));

(dommy.core.style.cljs$lang$maxFixedArity = 2);

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto__ = elem.classList;
if(cljs.core.truth_(temp__5733__auto__)){
var class_list = temp__5733__auto__;
return class_list.contains(c__$1);
} else {
var temp__5735__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__5735__auto__)){
var class_name = temp__5735__auto__;
var temp__5735__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__5735__auto____$1)){
var i = temp__5735__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__53461 = arguments.length;
switch (G__53461) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
}));

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
}));

(dommy.core.matches_pred.cljs$lang$maxFixedArity = 2);

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__53464 = arguments.length;
switch (G__53464) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__53462_SHARP_){
return (!((p1__53462_SHARP_ === base)));
}),dommy.core.ancestors(elem))));
}));

(dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
}));

(dommy.core.closest.cljs$lang$maxFixedArity = 3);

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
(elem.textContent = text);
} else {
(elem.innerText = text);
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
(elem.innerHTML = html);

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
(elem.value = value);

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return (elem.className = c);
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53901 = arguments.length;
var i__4790__auto___53902 = (0);
while(true){
if((i__4790__auto___53902 < len__4789__auto___53901)){
args__4795__auto__.push((arguments[i__4790__auto___53902]));

var G__53905 = (i__4790__auto___53902 + (1));
i__4790__auto___53902 = G__53905;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__53467_53907 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__53468_53908 = null;
var count__53469_53909 = (0);
var i__53470_53910 = (0);
while(true){
if((i__53470_53910 < count__53469_53909)){
var vec__53477_53911 = chunk__53468_53908.cljs$core$IIndexed$_nth$arity$2(null,i__53470_53910);
var k_53912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53477_53911,(0),null);
var v_53913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53477_53911,(1),null);
style.setProperty(dommy.utils.as_str(k_53912),v_53913);


var G__53914 = seq__53467_53907;
var G__53915 = chunk__53468_53908;
var G__53916 = count__53469_53909;
var G__53917 = (i__53470_53910 + (1));
seq__53467_53907 = G__53914;
chunk__53468_53908 = G__53915;
count__53469_53909 = G__53916;
i__53470_53910 = G__53917;
continue;
} else {
var temp__5735__auto___53918 = cljs.core.seq(seq__53467_53907);
if(temp__5735__auto___53918){
var seq__53467_53919__$1 = temp__5735__auto___53918;
if(cljs.core.chunked_seq_QMARK_(seq__53467_53919__$1)){
var c__4609__auto___53920 = cljs.core.chunk_first(seq__53467_53919__$1);
var G__53921 = cljs.core.chunk_rest(seq__53467_53919__$1);
var G__53922 = c__4609__auto___53920;
var G__53923 = cljs.core.count(c__4609__auto___53920);
var G__53924 = (0);
seq__53467_53907 = G__53921;
chunk__53468_53908 = G__53922;
count__53469_53909 = G__53923;
i__53470_53910 = G__53924;
continue;
} else {
var vec__53480_53925 = cljs.core.first(seq__53467_53919__$1);
var k_53926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53480_53925,(0),null);
var v_53927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53480_53925,(1),null);
style.setProperty(dommy.utils.as_str(k_53926),v_53927);


var G__53928 = cljs.core.next(seq__53467_53919__$1);
var G__53929 = null;
var G__53930 = (0);
var G__53931 = (0);
seq__53467_53907 = G__53928;
chunk__53468_53908 = G__53929;
count__53469_53909 = G__53930;
i__53470_53910 = G__53931;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq53465){
var G__53466 = cljs.core.first(seq53465);
var seq53465__$1 = cljs.core.next(seq53465);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53466,seq53465__$1);
}));

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53932 = arguments.length;
var i__4790__auto___53933 = (0);
while(true){
if((i__4790__auto___53933 < len__4789__auto___53932)){
args__4795__auto__.push((arguments[i__4790__auto___53933]));

var G__53934 = (i__4790__auto___53933 + (1));
i__4790__auto___53933 = G__53934;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__53485_53935 = cljs.core.seq(keywords);
var chunk__53486_53936 = null;
var count__53487_53937 = (0);
var i__53488_53938 = (0);
while(true){
if((i__53488_53938 < count__53487_53937)){
var kw_53939 = chunk__53486_53936.cljs$core$IIndexed$_nth$arity$2(null,i__53488_53938);
style.removeProperty(dommy.utils.as_str(kw_53939));


var G__53940 = seq__53485_53935;
var G__53941 = chunk__53486_53936;
var G__53942 = count__53487_53937;
var G__53943 = (i__53488_53938 + (1));
seq__53485_53935 = G__53940;
chunk__53486_53936 = G__53941;
count__53487_53937 = G__53942;
i__53488_53938 = G__53943;
continue;
} else {
var temp__5735__auto___53944 = cljs.core.seq(seq__53485_53935);
if(temp__5735__auto___53944){
var seq__53485_53945__$1 = temp__5735__auto___53944;
if(cljs.core.chunked_seq_QMARK_(seq__53485_53945__$1)){
var c__4609__auto___53946 = cljs.core.chunk_first(seq__53485_53945__$1);
var G__53947 = cljs.core.chunk_rest(seq__53485_53945__$1);
var G__53948 = c__4609__auto___53946;
var G__53949 = cljs.core.count(c__4609__auto___53946);
var G__53950 = (0);
seq__53485_53935 = G__53947;
chunk__53486_53936 = G__53948;
count__53487_53937 = G__53949;
i__53488_53938 = G__53950;
continue;
} else {
var kw_53951 = cljs.core.first(seq__53485_53945__$1);
style.removeProperty(dommy.utils.as_str(kw_53951));


var G__53952 = cljs.core.next(seq__53485_53945__$1);
var G__53953 = null;
var G__53954 = (0);
var G__53955 = (0);
seq__53485_53935 = G__53952;
chunk__53486_53936 = G__53953;
count__53487_53937 = G__53954;
i__53488_53938 = G__53955;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq53483){
var G__53484 = cljs.core.first(seq53483);
var seq53483__$1 = cljs.core.next(seq53483);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53484,seq53483__$1);
}));

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53959 = arguments.length;
var i__4790__auto___53960 = (0);
while(true){
if((i__4790__auto___53960 < len__4789__auto___53959)){
args__4795__auto__.push((arguments[i__4790__auto___53960]));

var G__53961 = (i__4790__auto___53960 + (1));
i__4790__auto___53960 = G__53961;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__53491_53962 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__53492_53963 = null;
var count__53493_53964 = (0);
var i__53494_53965 = (0);
while(true){
if((i__53494_53965 < count__53493_53964)){
var vec__53501_53966 = chunk__53492_53963.cljs$core$IIndexed$_nth$arity$2(null,i__53494_53965);
var k_53967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53501_53966,(0),null);
var v_53968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53501_53966,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_53967,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_53968),"px"].join('')], 0));


var G__53969 = seq__53491_53962;
var G__53970 = chunk__53492_53963;
var G__53971 = count__53493_53964;
var G__53972 = (i__53494_53965 + (1));
seq__53491_53962 = G__53969;
chunk__53492_53963 = G__53970;
count__53493_53964 = G__53971;
i__53494_53965 = G__53972;
continue;
} else {
var temp__5735__auto___53973 = cljs.core.seq(seq__53491_53962);
if(temp__5735__auto___53973){
var seq__53491_53974__$1 = temp__5735__auto___53973;
if(cljs.core.chunked_seq_QMARK_(seq__53491_53974__$1)){
var c__4609__auto___53975 = cljs.core.chunk_first(seq__53491_53974__$1);
var G__53976 = cljs.core.chunk_rest(seq__53491_53974__$1);
var G__53977 = c__4609__auto___53975;
var G__53978 = cljs.core.count(c__4609__auto___53975);
var G__53979 = (0);
seq__53491_53962 = G__53976;
chunk__53492_53963 = G__53977;
count__53493_53964 = G__53978;
i__53494_53965 = G__53979;
continue;
} else {
var vec__53504_53980 = cljs.core.first(seq__53491_53974__$1);
var k_53981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53504_53980,(0),null);
var v_53982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53504_53980,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_53981,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_53982),"px"].join('')], 0));


var G__53983 = cljs.core.next(seq__53491_53974__$1);
var G__53984 = null;
var G__53985 = (0);
var G__53986 = (0);
seq__53491_53962 = G__53983;
chunk__53492_53963 = G__53984;
count__53493_53964 = G__53985;
i__53494_53965 = G__53986;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq53489){
var G__53490 = cljs.core.first(seq53489);
var seq53489__$1 = cljs.core.next(seq53489);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53490,seq53489__$1);
}));

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__53512 = arguments.length;
switch (G__53512) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___53988 = arguments.length;
var i__4790__auto___53989 = (0);
while(true){
if((i__4790__auto___53989 < len__4789__auto___53988)){
args_arr__4810__auto__.push((arguments[i__4790__auto___53989]));

var G__53990 = (i__4790__auto___53989 + (1));
i__4790__auto___53989 = G__53990;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4811__auto__);

}
});

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__53513 = elem;
(G__53513[k__$1] = v);

return G__53513;
} else {
var G__53514 = elem;
G__53514.setAttribute(k__$1,v);

return G__53514;
}
} else {
return null;
}
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__53515_53991 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__53516_53992 = null;
var count__53517_53993 = (0);
var i__53518_53994 = (0);
while(true){
if((i__53518_53994 < count__53517_53993)){
var vec__53525_53995 = chunk__53516_53992.cljs$core$IIndexed$_nth$arity$2(null,i__53518_53994);
var k_53996__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53525_53995,(0),null);
var v_53997__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53525_53995,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_53996__$1,v_53997__$1);


var G__53998 = seq__53515_53991;
var G__53999 = chunk__53516_53992;
var G__54000 = count__53517_53993;
var G__54001 = (i__53518_53994 + (1));
seq__53515_53991 = G__53998;
chunk__53516_53992 = G__53999;
count__53517_53993 = G__54000;
i__53518_53994 = G__54001;
continue;
} else {
var temp__5735__auto___54002 = cljs.core.seq(seq__53515_53991);
if(temp__5735__auto___54002){
var seq__53515_54003__$1 = temp__5735__auto___54002;
if(cljs.core.chunked_seq_QMARK_(seq__53515_54003__$1)){
var c__4609__auto___54004 = cljs.core.chunk_first(seq__53515_54003__$1);
var G__54005 = cljs.core.chunk_rest(seq__53515_54003__$1);
var G__54006 = c__4609__auto___54004;
var G__54007 = cljs.core.count(c__4609__auto___54004);
var G__54008 = (0);
seq__53515_53991 = G__54005;
chunk__53516_53992 = G__54006;
count__53517_53993 = G__54007;
i__53518_53994 = G__54008;
continue;
} else {
var vec__53528_54009 = cljs.core.first(seq__53515_54003__$1);
var k_54010__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53528_54009,(0),null);
var v_54011__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53528_54009,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_54010__$1,v_54011__$1);


var G__54012 = cljs.core.next(seq__53515_54003__$1);
var G__54013 = null;
var G__54014 = (0);
var G__54015 = (0);
seq__53515_53991 = G__54012;
chunk__53516_53992 = G__54013;
count__53517_53993 = G__54014;
i__53518_53994 = G__54015;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq53508){
var G__53509 = cljs.core.first(seq53508);
var seq53508__$1 = cljs.core.next(seq53508);
var G__53510 = cljs.core.first(seq53508__$1);
var seq53508__$2 = cljs.core.next(seq53508__$1);
var G__53511 = cljs.core.first(seq53508__$2);
var seq53508__$3 = cljs.core.next(seq53508__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53509,G__53510,G__53511,seq53508__$3);
}));

(dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__53535 = arguments.length;
switch (G__53535) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54017 = arguments.length;
var i__4790__auto___54018 = (0);
while(true){
if((i__4790__auto___54018 < len__4789__auto___54017)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54018]));

var G__54019 = (i__4790__auto___54018 + (1));
i__4790__auto___54018 = G__54019;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_54020__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_((function (){var fexpr__53536 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null);
return (fexpr__53536.cljs$core$IFn$_invoke$arity$1 ? fexpr__53536.cljs$core$IFn$_invoke$arity$1(k_54020__$1) : fexpr__53536.call(null,k_54020__$1));
})())){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_54020__$1);
}

return elem;
}));

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__53537_54021 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__53538_54022 = null;
var count__53539_54023 = (0);
var i__53540_54024 = (0);
while(true){
if((i__53540_54024 < count__53539_54023)){
var k_54025__$1 = chunk__53538_54022.cljs$core$IIndexed$_nth$arity$2(null,i__53540_54024);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_54025__$1);


var G__54026 = seq__53537_54021;
var G__54027 = chunk__53538_54022;
var G__54028 = count__53539_54023;
var G__54029 = (i__53540_54024 + (1));
seq__53537_54021 = G__54026;
chunk__53538_54022 = G__54027;
count__53539_54023 = G__54028;
i__53540_54024 = G__54029;
continue;
} else {
var temp__5735__auto___54030 = cljs.core.seq(seq__53537_54021);
if(temp__5735__auto___54030){
var seq__53537_54031__$1 = temp__5735__auto___54030;
if(cljs.core.chunked_seq_QMARK_(seq__53537_54031__$1)){
var c__4609__auto___54032 = cljs.core.chunk_first(seq__53537_54031__$1);
var G__54033 = cljs.core.chunk_rest(seq__53537_54031__$1);
var G__54034 = c__4609__auto___54032;
var G__54035 = cljs.core.count(c__4609__auto___54032);
var G__54036 = (0);
seq__53537_54021 = G__54033;
chunk__53538_54022 = G__54034;
count__53539_54023 = G__54035;
i__53540_54024 = G__54036;
continue;
} else {
var k_54037__$1 = cljs.core.first(seq__53537_54031__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_54037__$1);


var G__54038 = cljs.core.next(seq__53537_54031__$1);
var G__54039 = null;
var G__54040 = (0);
var G__54041 = (0);
seq__53537_54021 = G__54038;
chunk__53538_54022 = G__54039;
count__53539_54023 = G__54040;
i__53540_54024 = G__54041;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq53532){
var G__53533 = cljs.core.first(seq53532);
var seq53532__$1 = cljs.core.next(seq53532);
var G__53534 = cljs.core.first(seq53532__$1);
var seq53532__$2 = cljs.core.next(seq53532__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53533,G__53534,seq53532__$2);
}));

(dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__53542 = arguments.length;
switch (G__53542) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
}));

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
}));

(dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__53547 = arguments.length;
switch (G__53547) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54044 = arguments.length;
var i__4790__auto___54045 = (0);
while(true){
if((i__4790__auto___54045 < len__4789__auto___54044)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54045]));

var G__54046 = (i__4790__auto___54045 + (1));
i__4790__auto___54045 = G__54046;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__5733__auto___54047 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54047)){
var class_list_54048 = temp__5733__auto___54047;
var seq__53555_54049 = cljs.core.seq(classes__$1);
var chunk__53556_54050 = null;
var count__53557_54051 = (0);
var i__53558_54052 = (0);
while(true){
if((i__53558_54052 < count__53557_54051)){
var c_54053 = chunk__53556_54050.cljs$core$IIndexed$_nth$arity$2(null,i__53558_54052);
class_list_54048.add(c_54053);


var G__54054 = seq__53555_54049;
var G__54055 = chunk__53556_54050;
var G__54056 = count__53557_54051;
var G__54057 = (i__53558_54052 + (1));
seq__53555_54049 = G__54054;
chunk__53556_54050 = G__54055;
count__53557_54051 = G__54056;
i__53558_54052 = G__54057;
continue;
} else {
var temp__5735__auto___54058 = cljs.core.seq(seq__53555_54049);
if(temp__5735__auto___54058){
var seq__53555_54059__$1 = temp__5735__auto___54058;
if(cljs.core.chunked_seq_QMARK_(seq__53555_54059__$1)){
var c__4609__auto___54060 = cljs.core.chunk_first(seq__53555_54059__$1);
var G__54061 = cljs.core.chunk_rest(seq__53555_54059__$1);
var G__54062 = c__4609__auto___54060;
var G__54063 = cljs.core.count(c__4609__auto___54060);
var G__54064 = (0);
seq__53555_54049 = G__54061;
chunk__53556_54050 = G__54062;
count__53557_54051 = G__54063;
i__53558_54052 = G__54064;
continue;
} else {
var c_54065 = cljs.core.first(seq__53555_54059__$1);
class_list_54048.add(c_54065);


var G__54066 = cljs.core.next(seq__53555_54059__$1);
var G__54067 = null;
var G__54068 = (0);
var G__54069 = (0);
seq__53555_54049 = G__54066;
chunk__53556_54050 = G__54067;
count__53557_54051 = G__54068;
i__53558_54052 = G__54069;
continue;
}
} else {
}
}
break;
}
} else {
var seq__53563_54070 = cljs.core.seq(classes__$1);
var chunk__53564_54071 = null;
var count__53565_54072 = (0);
var i__53566_54073 = (0);
while(true){
if((i__53566_54073 < count__53565_54072)){
var c_54074 = chunk__53564_54071.cljs$core$IIndexed$_nth$arity$2(null,i__53566_54073);
var class_name_54075 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_54075,c_54074))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_54075 === ""))?c_54074:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_54075)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_54074)].join('')));
}


var G__54076 = seq__53563_54070;
var G__54077 = chunk__53564_54071;
var G__54078 = count__53565_54072;
var G__54079 = (i__53566_54073 + (1));
seq__53563_54070 = G__54076;
chunk__53564_54071 = G__54077;
count__53565_54072 = G__54078;
i__53566_54073 = G__54079;
continue;
} else {
var temp__5735__auto___54080 = cljs.core.seq(seq__53563_54070);
if(temp__5735__auto___54080){
var seq__53563_54081__$1 = temp__5735__auto___54080;
if(cljs.core.chunked_seq_QMARK_(seq__53563_54081__$1)){
var c__4609__auto___54082 = cljs.core.chunk_first(seq__53563_54081__$1);
var G__54083 = cljs.core.chunk_rest(seq__53563_54081__$1);
var G__54084 = c__4609__auto___54082;
var G__54085 = cljs.core.count(c__4609__auto___54082);
var G__54086 = (0);
seq__53563_54070 = G__54083;
chunk__53564_54071 = G__54084;
count__53565_54072 = G__54085;
i__53566_54073 = G__54086;
continue;
} else {
var c_54087 = cljs.core.first(seq__53563_54081__$1);
var class_name_54088 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_54088,c_54087))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_54088 === ""))?c_54087:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_54088)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_54087)].join('')));
}


var G__54089 = cljs.core.next(seq__53563_54081__$1);
var G__54090 = null;
var G__54091 = (0);
var G__54092 = (0);
seq__53563_54070 = G__54089;
chunk__53564_54071 = G__54090;
count__53565_54072 = G__54091;
i__53566_54073 = G__54092;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
}));

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__53569_54093 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__53570_54094 = null;
var count__53571_54095 = (0);
var i__53572_54096 = (0);
while(true){
if((i__53572_54096 < count__53571_54095)){
var c_54097 = chunk__53570_54094.cljs$core$IIndexed$_nth$arity$2(null,i__53572_54096);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_54097);


var G__54098 = seq__53569_54093;
var G__54099 = chunk__53570_54094;
var G__54100 = count__53571_54095;
var G__54101 = (i__53572_54096 + (1));
seq__53569_54093 = G__54098;
chunk__53570_54094 = G__54099;
count__53571_54095 = G__54100;
i__53572_54096 = G__54101;
continue;
} else {
var temp__5735__auto___54102 = cljs.core.seq(seq__53569_54093);
if(temp__5735__auto___54102){
var seq__53569_54103__$1 = temp__5735__auto___54102;
if(cljs.core.chunked_seq_QMARK_(seq__53569_54103__$1)){
var c__4609__auto___54104 = cljs.core.chunk_first(seq__53569_54103__$1);
var G__54105 = cljs.core.chunk_rest(seq__53569_54103__$1);
var G__54106 = c__4609__auto___54104;
var G__54107 = cljs.core.count(c__4609__auto___54104);
var G__54108 = (0);
seq__53569_54093 = G__54105;
chunk__53570_54094 = G__54106;
count__53571_54095 = G__54107;
i__53572_54096 = G__54108;
continue;
} else {
var c_54109 = cljs.core.first(seq__53569_54103__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_54109);


var G__54110 = cljs.core.next(seq__53569_54103__$1);
var G__54111 = null;
var G__54112 = (0);
var G__54113 = (0);
seq__53569_54093 = G__54110;
chunk__53570_54094 = G__54111;
count__53571_54095 = G__54112;
i__53572_54096 = G__54113;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq53544){
var G__53545 = cljs.core.first(seq53544);
var seq53544__$1 = cljs.core.next(seq53544);
var G__53546 = cljs.core.first(seq53544__$1);
var seq53544__$2 = cljs.core.next(seq53544__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53545,G__53546,seq53544__$2);
}));

(dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__53579 = arguments.length;
switch (G__53579) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54115 = arguments.length;
var i__4790__auto___54116 = (0);
while(true){
if((i__4790__auto___54116 < len__4789__auto___54115)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54116]));

var G__54117 = (i__4790__auto___54116 + (1));
i__4790__auto___54116 = G__54117;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___54118 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54118)){
var class_list_54119 = temp__5733__auto___54118;
class_list_54119.remove(c__$1);
} else {
var class_name_54120 = dommy.core.class$(elem);
var new_class_name_54121 = dommy.utils.remove_class_str(class_name_54120,c__$1);
if((class_name_54120 === new_class_name_54121)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_54121);
}
}

return elem;
}));

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__53583 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__53584 = null;
var count__53585 = (0);
var i__53586 = (0);
while(true){
if((i__53586 < count__53585)){
var c = chunk__53584.cljs$core$IIndexed$_nth$arity$2(null,i__53586);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__54122 = seq__53583;
var G__54123 = chunk__53584;
var G__54124 = count__53585;
var G__54125 = (i__53586 + (1));
seq__53583 = G__54122;
chunk__53584 = G__54123;
count__53585 = G__54124;
i__53586 = G__54125;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__53583);
if(temp__5735__auto__){
var seq__53583__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53583__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__53583__$1);
var G__54126 = cljs.core.chunk_rest(seq__53583__$1);
var G__54127 = c__4609__auto__;
var G__54128 = cljs.core.count(c__4609__auto__);
var G__54129 = (0);
seq__53583 = G__54126;
chunk__53584 = G__54127;
count__53585 = G__54128;
i__53586 = G__54129;
continue;
} else {
var c = cljs.core.first(seq__53583__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__54130 = cljs.core.next(seq__53583__$1);
var G__54131 = null;
var G__54132 = (0);
var G__54133 = (0);
seq__53583 = G__54130;
chunk__53584 = G__54131;
count__53585 = G__54132;
i__53586 = G__54133;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq53576){
var G__53577 = cljs.core.first(seq53576);
var seq53576__$1 = cljs.core.next(seq53576);
var G__53578 = cljs.core.first(seq53576__$1);
var seq53576__$2 = cljs.core.next(seq53576__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53577,G__53578,seq53576__$2);
}));

(dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__53596 = arguments.length;
switch (G__53596) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___54135 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54135)){
var class_list_54136 = temp__5733__auto___54135;
class_list_54136.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,(!(dommy.core.has_class_QMARK_(elem,c__$1))));
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__53604 = arguments.length;
switch (G__53604) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none")], 0));
}));

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
}));

(dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__53609 = arguments.length;
switch (G__53609) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$lang$maxFixedArity = 2);

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__53615 = arguments.length;
switch (G__53615) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54140 = arguments.length;
var i__4790__auto___54141 = (0);
while(true){
if((i__4790__auto___54141 < len__4789__auto___54140)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54141]));

var G__54142 = (i__4790__auto___54141 + (1));
i__4790__auto___54141 = G__54142;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__53619 = parent;
G__53619.appendChild(child);

return G__53619;
}));

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__53620_54143 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__53621_54144 = null;
var count__53622_54145 = (0);
var i__53623_54146 = (0);
while(true){
if((i__53623_54146 < count__53622_54145)){
var c_54147 = chunk__53621_54144.cljs$core$IIndexed$_nth$arity$2(null,i__53623_54146);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54147);


var G__54148 = seq__53620_54143;
var G__54149 = chunk__53621_54144;
var G__54150 = count__53622_54145;
var G__54151 = (i__53623_54146 + (1));
seq__53620_54143 = G__54148;
chunk__53621_54144 = G__54149;
count__53622_54145 = G__54150;
i__53623_54146 = G__54151;
continue;
} else {
var temp__5735__auto___54152 = cljs.core.seq(seq__53620_54143);
if(temp__5735__auto___54152){
var seq__53620_54153__$1 = temp__5735__auto___54152;
if(cljs.core.chunked_seq_QMARK_(seq__53620_54153__$1)){
var c__4609__auto___54154 = cljs.core.chunk_first(seq__53620_54153__$1);
var G__54155 = cljs.core.chunk_rest(seq__53620_54153__$1);
var G__54156 = c__4609__auto___54154;
var G__54157 = cljs.core.count(c__4609__auto___54154);
var G__54158 = (0);
seq__53620_54143 = G__54155;
chunk__53621_54144 = G__54156;
count__53622_54145 = G__54157;
i__53623_54146 = G__54158;
continue;
} else {
var c_54159 = cljs.core.first(seq__53620_54153__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54159);


var G__54160 = cljs.core.next(seq__53620_54153__$1);
var G__54161 = null;
var G__54162 = (0);
var G__54163 = (0);
seq__53620_54143 = G__54160;
chunk__53621_54144 = G__54161;
count__53622_54145 = G__54162;
i__53623_54146 = G__54163;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq53612){
var G__53613 = cljs.core.first(seq53612);
var seq53612__$1 = cljs.core.next(seq53612);
var G__53614 = cljs.core.first(seq53612__$1);
var seq53612__$2 = cljs.core.next(seq53612__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53613,G__53614,seq53612__$2);
}));

(dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__53631 = arguments.length;
switch (G__53631) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54165 = arguments.length;
var i__4790__auto___54166 = (0);
while(true){
if((i__4790__auto___54166 < len__4789__auto___54165)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54166]));

var G__54167 = (i__4790__auto___54166 + (1));
i__4790__auto___54166 = G__54167;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__53635 = parent;
G__53635.insertBefore(child,parent.firstChild);

return G__53635;
}));

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__53636_54168 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__53637_54169 = null;
var count__53638_54170 = (0);
var i__53639_54171 = (0);
while(true){
if((i__53639_54171 < count__53638_54170)){
var c_54172 = chunk__53637_54169.cljs$core$IIndexed$_nth$arity$2(null,i__53639_54171);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54172);


var G__54173 = seq__53636_54168;
var G__54174 = chunk__53637_54169;
var G__54175 = count__53638_54170;
var G__54176 = (i__53639_54171 + (1));
seq__53636_54168 = G__54173;
chunk__53637_54169 = G__54174;
count__53638_54170 = G__54175;
i__53639_54171 = G__54176;
continue;
} else {
var temp__5735__auto___54177 = cljs.core.seq(seq__53636_54168);
if(temp__5735__auto___54177){
var seq__53636_54178__$1 = temp__5735__auto___54177;
if(cljs.core.chunked_seq_QMARK_(seq__53636_54178__$1)){
var c__4609__auto___54179 = cljs.core.chunk_first(seq__53636_54178__$1);
var G__54180 = cljs.core.chunk_rest(seq__53636_54178__$1);
var G__54181 = c__4609__auto___54179;
var G__54182 = cljs.core.count(c__4609__auto___54179);
var G__54183 = (0);
seq__53636_54168 = G__54180;
chunk__53637_54169 = G__54181;
count__53638_54170 = G__54182;
i__53639_54171 = G__54183;
continue;
} else {
var c_54184 = cljs.core.first(seq__53636_54178__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54184);


var G__54185 = cljs.core.next(seq__53636_54178__$1);
var G__54186 = null;
var G__54187 = (0);
var G__54188 = (0);
seq__53636_54168 = G__54185;
chunk__53637_54169 = G__54186;
count__53638_54170 = G__54187;
i__53639_54171 = G__54188;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq53628){
var G__53629 = cljs.core.first(seq53628);
var seq53628__$1 = cljs.core.next(seq53628);
var G__53630 = cljs.core.first(seq53628__$1);
var seq53628__$2 = cljs.core.next(seq53628__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53629,G__53630,seq53628__$2);
}));

(dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5733__auto___54189 = other.nextSibling;
if(cljs.core.truth_(temp__5733__auto___54189)){
var next_54190 = temp__5733__auto___54189;
dommy.core.insert_before_BANG_(elem,next_54190);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__53647 = arguments.length;
switch (G__53647) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
}));

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__53648 = p;
G__53648.removeChild(elem);

return G__53648;
}));

(dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__53649){
var vec__53650 = p__53649;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53650,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53650,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,(function (f){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4185__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4174__auto__ = related_target;
if(cljs.core.truth_(and__4174__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4174__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
})])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4174__auto__ = selected_target;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4174__auto__;
}
})())){
(event.selectedTarget = selected_target);

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4185__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54192 = arguments.length;
var i__4790__auto___54193 = (0);
while(true){
if((i__4790__auto___54193 < len__4789__auto___54192)){
args__4795__auto__.push((arguments[i__4790__auto___54193]));

var G__54194 = (i__4790__auto___54193 + (1));
i__4790__auto___54193 = G__54194;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return (elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args));
}));

(dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq53656){
var G__53657 = cljs.core.first(seq53656);
var seq53656__$1 = cljs.core.next(seq53656);
var G__53658 = cljs.core.first(seq53656__$1);
var seq53656__$2 = cljs.core.next(seq53656__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53657,G__53658,seq53656__$2);
}));

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
var fexpr__53659 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest);
return (fexpr__53659.cljs$core$IFn$_invoke$arity$1 ? fexpr__53659.cljs$core$IFn$_invoke$arity$1(elem_sel) : fexpr__53659.call(null,elem_sel));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54195 = arguments.length;
var i__4790__auto___54196 = (0);
while(true){
if((i__4790__auto___54196 < len__4789__auto___54195)){
args__4795__auto__.push((arguments[i__4790__auto___54196]));

var G__54197 = (i__4790__auto___54196 + (1));
i__4790__auto___54196 = G__54197;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53662_54198 = dommy.core.elem_and_selector(elem_sel);
var elem_54199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53662_54198,(0),null);
var selector_54200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53662_54198,(1),null);
var seq__53665_54201 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53672_54202 = null;
var count__53673_54203 = (0);
var i__53674_54204 = (0);
while(true){
if((i__53674_54204 < count__53673_54203)){
var vec__53727_54205 = chunk__53672_54202.cljs$core$IIndexed$_nth$arity$2(null,i__53674_54204);
var orig_type_54206 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53727_54205,(0),null);
var f_54207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53727_54205,(1),null);
var seq__53675_54208 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54206,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54206,cljs.core.identity])));
var chunk__53677_54209 = null;
var count__53678_54210 = (0);
var i__53679_54211 = (0);
while(true){
if((i__53679_54211 < count__53678_54210)){
var vec__53740_54212 = chunk__53677_54209.cljs$core$IIndexed$_nth$arity$2(null,i__53679_54211);
var actual_type_54213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53740_54212,(0),null);
var factory_54214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53740_54212,(1),null);
var canonical_f_54215 = (function (){var G__53744 = (factory_54214.cljs$core$IFn$_invoke$arity$1 ? factory_54214.cljs$core$IFn$_invoke$arity$1(f_54207) : factory_54214.call(null,f_54207));
var fexpr__53743 = (cljs.core.truth_(selector_54200)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54199,selector_54200):cljs.core.identity);
return (fexpr__53743.cljs$core$IFn$_invoke$arity$1 ? fexpr__53743.cljs$core$IFn$_invoke$arity$1(G__53744) : fexpr__53743.call(null,G__53744));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54199,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54200,actual_type_54213,f_54207], null),canonical_f_54215], 0));

if(cljs.core.truth_(elem_54199.addEventListener)){
elem_54199.addEventListener(cljs.core.name(actual_type_54213),canonical_f_54215);
} else {
elem_54199.attachEvent(cljs.core.name(actual_type_54213),canonical_f_54215);
}


var G__54216 = seq__53675_54208;
var G__54217 = chunk__53677_54209;
var G__54218 = count__53678_54210;
var G__54219 = (i__53679_54211 + (1));
seq__53675_54208 = G__54216;
chunk__53677_54209 = G__54217;
count__53678_54210 = G__54218;
i__53679_54211 = G__54219;
continue;
} else {
var temp__5735__auto___54220 = cljs.core.seq(seq__53675_54208);
if(temp__5735__auto___54220){
var seq__53675_54221__$1 = temp__5735__auto___54220;
if(cljs.core.chunked_seq_QMARK_(seq__53675_54221__$1)){
var c__4609__auto___54222 = cljs.core.chunk_first(seq__53675_54221__$1);
var G__54223 = cljs.core.chunk_rest(seq__53675_54221__$1);
var G__54224 = c__4609__auto___54222;
var G__54225 = cljs.core.count(c__4609__auto___54222);
var G__54226 = (0);
seq__53675_54208 = G__54223;
chunk__53677_54209 = G__54224;
count__53678_54210 = G__54225;
i__53679_54211 = G__54226;
continue;
} else {
var vec__53745_54227 = cljs.core.first(seq__53675_54221__$1);
var actual_type_54228 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53745_54227,(0),null);
var factory_54229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53745_54227,(1),null);
var canonical_f_54230 = (function (){var G__53749 = (factory_54229.cljs$core$IFn$_invoke$arity$1 ? factory_54229.cljs$core$IFn$_invoke$arity$1(f_54207) : factory_54229.call(null,f_54207));
var fexpr__53748 = (cljs.core.truth_(selector_54200)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54199,selector_54200):cljs.core.identity);
return (fexpr__53748.cljs$core$IFn$_invoke$arity$1 ? fexpr__53748.cljs$core$IFn$_invoke$arity$1(G__53749) : fexpr__53748.call(null,G__53749));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54199,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54200,actual_type_54228,f_54207], null),canonical_f_54230], 0));

if(cljs.core.truth_(elem_54199.addEventListener)){
elem_54199.addEventListener(cljs.core.name(actual_type_54228),canonical_f_54230);
} else {
elem_54199.attachEvent(cljs.core.name(actual_type_54228),canonical_f_54230);
}


var G__54231 = cljs.core.next(seq__53675_54221__$1);
var G__54232 = null;
var G__54233 = (0);
var G__54234 = (0);
seq__53675_54208 = G__54231;
chunk__53677_54209 = G__54232;
count__53678_54210 = G__54233;
i__53679_54211 = G__54234;
continue;
}
} else {
}
}
break;
}

var G__54235 = seq__53665_54201;
var G__54236 = chunk__53672_54202;
var G__54237 = count__53673_54203;
var G__54238 = (i__53674_54204 + (1));
seq__53665_54201 = G__54235;
chunk__53672_54202 = G__54236;
count__53673_54203 = G__54237;
i__53674_54204 = G__54238;
continue;
} else {
var temp__5735__auto___54239 = cljs.core.seq(seq__53665_54201);
if(temp__5735__auto___54239){
var seq__53665_54240__$1 = temp__5735__auto___54239;
if(cljs.core.chunked_seq_QMARK_(seq__53665_54240__$1)){
var c__4609__auto___54241 = cljs.core.chunk_first(seq__53665_54240__$1);
var G__54242 = cljs.core.chunk_rest(seq__53665_54240__$1);
var G__54243 = c__4609__auto___54241;
var G__54244 = cljs.core.count(c__4609__auto___54241);
var G__54245 = (0);
seq__53665_54201 = G__54242;
chunk__53672_54202 = G__54243;
count__53673_54203 = G__54244;
i__53674_54204 = G__54245;
continue;
} else {
var vec__53750_54246 = cljs.core.first(seq__53665_54240__$1);
var orig_type_54247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53750_54246,(0),null);
var f_54248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53750_54246,(1),null);
var seq__53666_54249 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54247,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54247,cljs.core.identity])));
var chunk__53668_54250 = null;
var count__53669_54251 = (0);
var i__53670_54252 = (0);
while(true){
if((i__53670_54252 < count__53669_54251)){
var vec__53767_54253 = chunk__53668_54250.cljs$core$IIndexed$_nth$arity$2(null,i__53670_54252);
var actual_type_54254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53767_54253,(0),null);
var factory_54255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53767_54253,(1),null);
var canonical_f_54256 = (function (){var G__53771 = (factory_54255.cljs$core$IFn$_invoke$arity$1 ? factory_54255.cljs$core$IFn$_invoke$arity$1(f_54248) : factory_54255.call(null,f_54248));
var fexpr__53770 = (cljs.core.truth_(selector_54200)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54199,selector_54200):cljs.core.identity);
return (fexpr__53770.cljs$core$IFn$_invoke$arity$1 ? fexpr__53770.cljs$core$IFn$_invoke$arity$1(G__53771) : fexpr__53770.call(null,G__53771));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54199,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54200,actual_type_54254,f_54248], null),canonical_f_54256], 0));

if(cljs.core.truth_(elem_54199.addEventListener)){
elem_54199.addEventListener(cljs.core.name(actual_type_54254),canonical_f_54256);
} else {
elem_54199.attachEvent(cljs.core.name(actual_type_54254),canonical_f_54256);
}


var G__54257 = seq__53666_54249;
var G__54258 = chunk__53668_54250;
var G__54259 = count__53669_54251;
var G__54260 = (i__53670_54252 + (1));
seq__53666_54249 = G__54257;
chunk__53668_54250 = G__54258;
count__53669_54251 = G__54259;
i__53670_54252 = G__54260;
continue;
} else {
var temp__5735__auto___54261__$1 = cljs.core.seq(seq__53666_54249);
if(temp__5735__auto___54261__$1){
var seq__53666_54262__$1 = temp__5735__auto___54261__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53666_54262__$1)){
var c__4609__auto___54263 = cljs.core.chunk_first(seq__53666_54262__$1);
var G__54264 = cljs.core.chunk_rest(seq__53666_54262__$1);
var G__54265 = c__4609__auto___54263;
var G__54266 = cljs.core.count(c__4609__auto___54263);
var G__54267 = (0);
seq__53666_54249 = G__54264;
chunk__53668_54250 = G__54265;
count__53669_54251 = G__54266;
i__53670_54252 = G__54267;
continue;
} else {
var vec__53772_54268 = cljs.core.first(seq__53666_54262__$1);
var actual_type_54269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53772_54268,(0),null);
var factory_54270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53772_54268,(1),null);
var canonical_f_54271 = (function (){var G__53776 = (factory_54270.cljs$core$IFn$_invoke$arity$1 ? factory_54270.cljs$core$IFn$_invoke$arity$1(f_54248) : factory_54270.call(null,f_54248));
var fexpr__53775 = (cljs.core.truth_(selector_54200)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54199,selector_54200):cljs.core.identity);
return (fexpr__53775.cljs$core$IFn$_invoke$arity$1 ? fexpr__53775.cljs$core$IFn$_invoke$arity$1(G__53776) : fexpr__53775.call(null,G__53776));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54199,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54200,actual_type_54269,f_54248], null),canonical_f_54271], 0));

if(cljs.core.truth_(elem_54199.addEventListener)){
elem_54199.addEventListener(cljs.core.name(actual_type_54269),canonical_f_54271);
} else {
elem_54199.attachEvent(cljs.core.name(actual_type_54269),canonical_f_54271);
}


var G__54272 = cljs.core.next(seq__53666_54262__$1);
var G__54273 = null;
var G__54274 = (0);
var G__54275 = (0);
seq__53666_54249 = G__54272;
chunk__53668_54250 = G__54273;
count__53669_54251 = G__54274;
i__53670_54252 = G__54275;
continue;
}
} else {
}
}
break;
}

var G__54276 = cljs.core.next(seq__53665_54240__$1);
var G__54277 = null;
var G__54278 = (0);
var G__54279 = (0);
seq__53665_54201 = G__54276;
chunk__53672_54202 = G__54277;
count__53673_54203 = G__54278;
i__53674_54204 = G__54279;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq53660){
var G__53661 = cljs.core.first(seq53660);
var seq53660__$1 = cljs.core.next(seq53660);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53661,seq53660__$1);
}));

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54280 = arguments.length;
var i__4790__auto___54281 = (0);
while(true){
if((i__4790__auto___54281 < len__4789__auto___54280)){
args__4795__auto__.push((arguments[i__4790__auto___54281]));

var G__54282 = (i__4790__auto___54281 + (1));
i__4790__auto___54281 = G__54282;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53779_54283 = dommy.core.elem_and_selector(elem_sel);
var elem_54284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53779_54283,(0),null);
var selector_54285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53779_54283,(1),null);
var seq__53783_54286 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53790_54287 = null;
var count__53791_54288 = (0);
var i__53792_54289 = (0);
while(true){
if((i__53792_54289 < count__53791_54288)){
var vec__53840_54290 = chunk__53790_54287.cljs$core$IIndexed$_nth$arity$2(null,i__53792_54289);
var orig_type_54291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53840_54290,(0),null);
var f_54292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53840_54290,(1),null);
var seq__53793_54293 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54291,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54291,cljs.core.identity])));
var chunk__53795_54294 = null;
var count__53796_54295 = (0);
var i__53797_54296 = (0);
while(true){
if((i__53797_54296 < count__53796_54295)){
var vec__53850_54297 = chunk__53795_54294.cljs$core$IIndexed$_nth$arity$2(null,i__53797_54296);
var actual_type_54298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53850_54297,(0),null);
var __54299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53850_54297,(1),null);
var keys_54300 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54285,actual_type_54298,f_54292], null);
var canonical_f_54301 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54284),keys_54300);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54284,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54300], 0));

if(cljs.core.truth_(elem_54284.removeEventListener)){
elem_54284.removeEventListener(cljs.core.name(actual_type_54298),canonical_f_54301);
} else {
elem_54284.detachEvent(cljs.core.name(actual_type_54298),canonical_f_54301);
}


var G__54302 = seq__53793_54293;
var G__54303 = chunk__53795_54294;
var G__54304 = count__53796_54295;
var G__54305 = (i__53797_54296 + (1));
seq__53793_54293 = G__54302;
chunk__53795_54294 = G__54303;
count__53796_54295 = G__54304;
i__53797_54296 = G__54305;
continue;
} else {
var temp__5735__auto___54306 = cljs.core.seq(seq__53793_54293);
if(temp__5735__auto___54306){
var seq__53793_54307__$1 = temp__5735__auto___54306;
if(cljs.core.chunked_seq_QMARK_(seq__53793_54307__$1)){
var c__4609__auto___54308 = cljs.core.chunk_first(seq__53793_54307__$1);
var G__54309 = cljs.core.chunk_rest(seq__53793_54307__$1);
var G__54310 = c__4609__auto___54308;
var G__54311 = cljs.core.count(c__4609__auto___54308);
var G__54312 = (0);
seq__53793_54293 = G__54309;
chunk__53795_54294 = G__54310;
count__53796_54295 = G__54311;
i__53797_54296 = G__54312;
continue;
} else {
var vec__53853_54313 = cljs.core.first(seq__53793_54307__$1);
var actual_type_54314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53853_54313,(0),null);
var __54315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53853_54313,(1),null);
var keys_54316 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54285,actual_type_54314,f_54292], null);
var canonical_f_54317 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54284),keys_54316);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54284,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54316], 0));

if(cljs.core.truth_(elem_54284.removeEventListener)){
elem_54284.removeEventListener(cljs.core.name(actual_type_54314),canonical_f_54317);
} else {
elem_54284.detachEvent(cljs.core.name(actual_type_54314),canonical_f_54317);
}


var G__54318 = cljs.core.next(seq__53793_54307__$1);
var G__54319 = null;
var G__54320 = (0);
var G__54321 = (0);
seq__53793_54293 = G__54318;
chunk__53795_54294 = G__54319;
count__53796_54295 = G__54320;
i__53797_54296 = G__54321;
continue;
}
} else {
}
}
break;
}

var G__54322 = seq__53783_54286;
var G__54323 = chunk__53790_54287;
var G__54324 = count__53791_54288;
var G__54325 = (i__53792_54289 + (1));
seq__53783_54286 = G__54322;
chunk__53790_54287 = G__54323;
count__53791_54288 = G__54324;
i__53792_54289 = G__54325;
continue;
} else {
var temp__5735__auto___54326 = cljs.core.seq(seq__53783_54286);
if(temp__5735__auto___54326){
var seq__53783_54327__$1 = temp__5735__auto___54326;
if(cljs.core.chunked_seq_QMARK_(seq__53783_54327__$1)){
var c__4609__auto___54328 = cljs.core.chunk_first(seq__53783_54327__$1);
var G__54329 = cljs.core.chunk_rest(seq__53783_54327__$1);
var G__54330 = c__4609__auto___54328;
var G__54331 = cljs.core.count(c__4609__auto___54328);
var G__54332 = (0);
seq__53783_54286 = G__54329;
chunk__53790_54287 = G__54330;
count__53791_54288 = G__54331;
i__53792_54289 = G__54332;
continue;
} else {
var vec__53856_54333 = cljs.core.first(seq__53783_54327__$1);
var orig_type_54334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53856_54333,(0),null);
var f_54335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53856_54333,(1),null);
var seq__53784_54336 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54334,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54334,cljs.core.identity])));
var chunk__53786_54337 = null;
var count__53787_54338 = (0);
var i__53788_54339 = (0);
while(true){
if((i__53788_54339 < count__53787_54338)){
var vec__53865_54340 = chunk__53786_54337.cljs$core$IIndexed$_nth$arity$2(null,i__53788_54339);
var actual_type_54341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53865_54340,(0),null);
var __54342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53865_54340,(1),null);
var keys_54343 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54285,actual_type_54341,f_54335], null);
var canonical_f_54344 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54284),keys_54343);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54284,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54343], 0));

if(cljs.core.truth_(elem_54284.removeEventListener)){
elem_54284.removeEventListener(cljs.core.name(actual_type_54341),canonical_f_54344);
} else {
elem_54284.detachEvent(cljs.core.name(actual_type_54341),canonical_f_54344);
}


var G__54345 = seq__53784_54336;
var G__54346 = chunk__53786_54337;
var G__54347 = count__53787_54338;
var G__54348 = (i__53788_54339 + (1));
seq__53784_54336 = G__54345;
chunk__53786_54337 = G__54346;
count__53787_54338 = G__54347;
i__53788_54339 = G__54348;
continue;
} else {
var temp__5735__auto___54349__$1 = cljs.core.seq(seq__53784_54336);
if(temp__5735__auto___54349__$1){
var seq__53784_54350__$1 = temp__5735__auto___54349__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53784_54350__$1)){
var c__4609__auto___54351 = cljs.core.chunk_first(seq__53784_54350__$1);
var G__54352 = cljs.core.chunk_rest(seq__53784_54350__$1);
var G__54353 = c__4609__auto___54351;
var G__54354 = cljs.core.count(c__4609__auto___54351);
var G__54355 = (0);
seq__53784_54336 = G__54352;
chunk__53786_54337 = G__54353;
count__53787_54338 = G__54354;
i__53788_54339 = G__54355;
continue;
} else {
var vec__53868_54356 = cljs.core.first(seq__53784_54350__$1);
var actual_type_54357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53868_54356,(0),null);
var __54358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53868_54356,(1),null);
var keys_54359 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54285,actual_type_54357,f_54335], null);
var canonical_f_54360 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54284),keys_54359);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54284,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54359], 0));

if(cljs.core.truth_(elem_54284.removeEventListener)){
elem_54284.removeEventListener(cljs.core.name(actual_type_54357),canonical_f_54360);
} else {
elem_54284.detachEvent(cljs.core.name(actual_type_54357),canonical_f_54360);
}


var G__54361 = cljs.core.next(seq__53784_54350__$1);
var G__54362 = null;
var G__54363 = (0);
var G__54364 = (0);
seq__53784_54336 = G__54361;
chunk__53786_54337 = G__54362;
count__53787_54338 = G__54363;
i__53788_54339 = G__54364;
continue;
}
} else {
}
}
break;
}

var G__54365 = cljs.core.next(seq__53783_54327__$1);
var G__54366 = null;
var G__54367 = (0);
var G__54368 = (0);
seq__53783_54286 = G__54365;
chunk__53790_54287 = G__54366;
count__53791_54288 = G__54367;
i__53792_54289 = G__54368;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq53777){
var G__53778 = cljs.core.first(seq53777);
var seq53777__$1 = cljs.core.next(seq53777);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53778,seq53777__$1);
}));

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54369 = arguments.length;
var i__4790__auto___54370 = (0);
while(true){
if((i__4790__auto___54370 < len__4789__auto___54369)){
args__4795__auto__.push((arguments[i__4790__auto___54370]));

var G__54371 = (i__4790__auto___54370 + (1));
i__4790__auto___54370 = G__54371;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53873_54372 = dommy.core.elem_and_selector(elem_sel);
var elem_54373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53873_54372,(0),null);
var selector_54374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53873_54372,(1),null);
var seq__53876_54377 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53877_54378 = null;
var count__53878_54379 = (0);
var i__53879_54380 = (0);
while(true){
if((i__53879_54380 < count__53878_54379)){
var vec__53886_54382 = chunk__53877_54378.cljs$core$IIndexed$_nth$arity$2(null,i__53879_54380);
var type_54383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53886_54382,(0),null);
var f_54384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53886_54382,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54383,((function (seq__53876_54377,chunk__53877_54378,count__53878_54379,i__53879_54380,vec__53886_54382,type_54383,f_54384,vec__53873_54372,elem_54373,selector_54374){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54383,dommy$core$this_fn], 0));

return (f_54384.cljs$core$IFn$_invoke$arity$1 ? f_54384.cljs$core$IFn$_invoke$arity$1(e) : f_54384.call(null,e));
});})(seq__53876_54377,chunk__53877_54378,count__53878_54379,i__53879_54380,vec__53886_54382,type_54383,f_54384,vec__53873_54372,elem_54373,selector_54374))
], 0));


var G__54388 = seq__53876_54377;
var G__54389 = chunk__53877_54378;
var G__54390 = count__53878_54379;
var G__54391 = (i__53879_54380 + (1));
seq__53876_54377 = G__54388;
chunk__53877_54378 = G__54389;
count__53878_54379 = G__54390;
i__53879_54380 = G__54391;
continue;
} else {
var temp__5735__auto___54392 = cljs.core.seq(seq__53876_54377);
if(temp__5735__auto___54392){
var seq__53876_54393__$1 = temp__5735__auto___54392;
if(cljs.core.chunked_seq_QMARK_(seq__53876_54393__$1)){
var c__4609__auto___54394 = cljs.core.chunk_first(seq__53876_54393__$1);
var G__54395 = cljs.core.chunk_rest(seq__53876_54393__$1);
var G__54396 = c__4609__auto___54394;
var G__54397 = cljs.core.count(c__4609__auto___54394);
var G__54398 = (0);
seq__53876_54377 = G__54395;
chunk__53877_54378 = G__54396;
count__53878_54379 = G__54397;
i__53879_54380 = G__54398;
continue;
} else {
var vec__53889_54400 = cljs.core.first(seq__53876_54393__$1);
var type_54401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53889_54400,(0),null);
var f_54402 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53889_54400,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54401,((function (seq__53876_54377,chunk__53877_54378,count__53878_54379,i__53879_54380,vec__53889_54400,type_54401,f_54402,seq__53876_54393__$1,temp__5735__auto___54392,vec__53873_54372,elem_54373,selector_54374){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54401,dommy$core$this_fn], 0));

return (f_54402.cljs$core$IFn$_invoke$arity$1 ? f_54402.cljs$core$IFn$_invoke$arity$1(e) : f_54402.call(null,e));
});})(seq__53876_54377,chunk__53877_54378,count__53878_54379,i__53879_54380,vec__53889_54400,type_54401,f_54402,seq__53876_54393__$1,temp__5735__auto___54392,vec__53873_54372,elem_54373,selector_54374))
], 0));


var G__54414 = cljs.core.next(seq__53876_54393__$1);
var G__54415 = null;
var G__54416 = (0);
var G__54417 = (0);
seq__53876_54377 = G__54414;
chunk__53877_54378 = G__54415;
count__53878_54379 = G__54416;
i__53879_54380 = G__54417;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq53871){
var G__53872 = cljs.core.first(seq53871);
var seq53871__$1 = cljs.core.next(seq53871);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53872,seq53871__$1);
}));


//# sourceMappingURL=dommy.core.js.map
