goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44630){
var vec__44631 = p__44630;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44631,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44631,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44641 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44641,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44641,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44641,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44641,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44641,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44649 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(4),null);
var vec__44652 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44652,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44652,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44652,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44652,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44652,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44657 = segmap;
var map__44657__$1 = (((((!((map__44657 == null))))?(((((map__44657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44657):map__44657);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44657__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44657__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44657__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44657__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44657__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44668 = arguments.length;
switch (G__44668) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44684 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45789 = cljs.core.next(segs__$1);
var G__45790 = nrelseg;
var G__45791 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45789;
relseg__$1 = G__45790;
result__$1 = G__45791;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44684,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44684,(1),null);
var G__45792 = (gline + (1));
var G__45793 = cljs.core.next(lines__$1);
var G__45794 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45795 = result__$1;
gline = G__45792;
lines__$1 = G__45793;
relseg = G__45794;
result = G__45795;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44690 = segmap;
var map__44690__$1 = (((((!((map__44690 == null))))?(((((map__44690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44690):map__44690);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44690__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44690__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44690__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44690__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44690__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44687_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44687_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44693 = arguments.length;
switch (G__44693) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44707 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45798 = cljs.core.next(segs__$1);
var G__45799 = nrelseg;
var G__45800 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45798;
relseg__$1 = G__45799;
result__$1 = G__45800;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44707,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44707,(1),null);
var G__45801 = (gline + (1));
var G__45802 = cljs.core.next(lines__$1);
var G__45803 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45804 = result__$1;
gline = G__45801;
lines__$1 = G__45802;
relseg = G__45803;
result = G__45804;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44714){
var vec__44715 = p__44714;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44719){
var vec__44723 = p__44719;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(4),null);
var seg = vec__44723;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44727){
var vec__44728 = p__44727;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44728,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44728,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44728,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44728,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44728,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44744 = cljs.core.seq(infos);
var chunk__44745 = null;
var count__44746 = (0);
var i__44747 = (0);
while(true){
if((i__44747 < count__44746)){
var info = chunk__44745.cljs$core$IIndexed$_nth$arity$2(null,i__44747);
var segv_45806 = info__GT_segv(info,source_idx,line,col);
var gline_45807 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45808 = cljs.core.count(cljs.core.deref(lines));
if((gline_45807 > (lc_45808 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44744,chunk__44745,count__44746,i__44747,segv_45806,gline_45807,lc_45808,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45807 - (lc_45808 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45806], null));
});})(seq__44744,chunk__44745,count__44746,i__44747,segv_45806,gline_45807,lc_45808,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44744,chunk__44745,count__44746,i__44747,segv_45806,gline_45807,lc_45808,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45807], null),cljs.core.conj,segv_45806);
});})(seq__44744,chunk__44745,count__44746,i__44747,segv_45806,gline_45807,lc_45808,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45812 = seq__44744;
var G__45813 = chunk__44745;
var G__45814 = count__44746;
var G__45815 = (i__44747 + (1));
seq__44744 = G__45812;
chunk__44745 = G__45813;
count__44746 = G__45814;
i__44747 = G__45815;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44744);
if(temp__5735__auto__){
var seq__44744__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44744__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44744__$1);
var G__45818 = cljs.core.chunk_rest(seq__44744__$1);
var G__45819 = c__4609__auto__;
var G__45820 = cljs.core.count(c__4609__auto__);
var G__45821 = (0);
seq__44744 = G__45818;
chunk__44745 = G__45819;
count__44746 = G__45820;
i__44747 = G__45821;
continue;
} else {
var info = cljs.core.first(seq__44744__$1);
var segv_45822 = info__GT_segv(info,source_idx,line,col);
var gline_45823 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45824 = cljs.core.count(cljs.core.deref(lines));
if((gline_45823 > (lc_45824 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44744,chunk__44745,count__44746,i__44747,segv_45822,gline_45823,lc_45824,info,seq__44744__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45823 - (lc_45824 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45822], null));
});})(seq__44744,chunk__44745,count__44746,i__44747,segv_45822,gline_45823,lc_45824,info,seq__44744__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44744,chunk__44745,count__44746,i__44747,segv_45822,gline_45823,lc_45824,info,seq__44744__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45823], null),cljs.core.conj,segv_45822);
});})(seq__44744,chunk__44745,count__44746,i__44747,segv_45822,gline_45823,lc_45824,info,seq__44744__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45827 = cljs.core.next(seq__44744__$1);
var G__45828 = null;
var G__45829 = (0);
var G__45830 = (0);
seq__44744 = G__45827;
chunk__44745 = G__45828;
count__44746 = G__45829;
i__44747 = G__45830;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44760_45831 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44761_45832 = null;
var count__44762_45833 = (0);
var i__44763_45834 = (0);
while(true){
if((i__44763_45834 < count__44762_45833)){
var vec__45034_45835 = chunk__44761_45832.cljs$core$IIndexed$_nth$arity$2(null,i__44763_45834);
var source_idx_45836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45034_45835,(0),null);
var vec__45037_45837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45034_45835,(1),null);
var __45838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45037_45837,(0),null);
var lines_45839__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45037_45837,(1),null);
var seq__45041_45840 = cljs.core.seq(lines_45839__$1);
var chunk__45042_45841 = null;
var count__45043_45842 = (0);
var i__45044_45843 = (0);
while(true){
if((i__45044_45843 < count__45043_45842)){
var vec__45099_45844 = chunk__45042_45841.cljs$core$IIndexed$_nth$arity$2(null,i__45044_45843);
var line_45845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45099_45844,(0),null);
var cols_45846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45099_45844,(1),null);
var seq__45102_45847 = cljs.core.seq(cols_45846);
var chunk__45103_45848 = null;
var count__45104_45849 = (0);
var i__45105_45850 = (0);
while(true){
if((i__45105_45850 < count__45104_45849)){
var vec__45117_45851 = chunk__45103_45848.cljs$core$IIndexed$_nth$arity$2(null,i__45105_45850);
var col_45852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45117_45851,(0),null);
var infos_45853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45117_45851,(1),null);
encode_cols(infos_45853,source_idx_45836,line_45845,col_45852);


var G__45857 = seq__45102_45847;
var G__45858 = chunk__45103_45848;
var G__45859 = count__45104_45849;
var G__45860 = (i__45105_45850 + (1));
seq__45102_45847 = G__45857;
chunk__45103_45848 = G__45858;
count__45104_45849 = G__45859;
i__45105_45850 = G__45860;
continue;
} else {
var temp__5735__auto___45861 = cljs.core.seq(seq__45102_45847);
if(temp__5735__auto___45861){
var seq__45102_45862__$1 = temp__5735__auto___45861;
if(cljs.core.chunked_seq_QMARK_(seq__45102_45862__$1)){
var c__4609__auto___45863 = cljs.core.chunk_first(seq__45102_45862__$1);
var G__45864 = cljs.core.chunk_rest(seq__45102_45862__$1);
var G__45865 = c__4609__auto___45863;
var G__45866 = cljs.core.count(c__4609__auto___45863);
var G__45867 = (0);
seq__45102_45847 = G__45864;
chunk__45103_45848 = G__45865;
count__45104_45849 = G__45866;
i__45105_45850 = G__45867;
continue;
} else {
var vec__45120_45869 = cljs.core.first(seq__45102_45862__$1);
var col_45870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45869,(0),null);
var infos_45871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45869,(1),null);
encode_cols(infos_45871,source_idx_45836,line_45845,col_45870);


var G__45872 = cljs.core.next(seq__45102_45862__$1);
var G__45873 = null;
var G__45874 = (0);
var G__45875 = (0);
seq__45102_45847 = G__45872;
chunk__45103_45848 = G__45873;
count__45104_45849 = G__45874;
i__45105_45850 = G__45875;
continue;
}
} else {
}
}
break;
}


var G__45876 = seq__45041_45840;
var G__45877 = chunk__45042_45841;
var G__45878 = count__45043_45842;
var G__45879 = (i__45044_45843 + (1));
seq__45041_45840 = G__45876;
chunk__45042_45841 = G__45877;
count__45043_45842 = G__45878;
i__45044_45843 = G__45879;
continue;
} else {
var temp__5735__auto___45880 = cljs.core.seq(seq__45041_45840);
if(temp__5735__auto___45880){
var seq__45041_45881__$1 = temp__5735__auto___45880;
if(cljs.core.chunked_seq_QMARK_(seq__45041_45881__$1)){
var c__4609__auto___45882 = cljs.core.chunk_first(seq__45041_45881__$1);
var G__45883 = cljs.core.chunk_rest(seq__45041_45881__$1);
var G__45884 = c__4609__auto___45882;
var G__45885 = cljs.core.count(c__4609__auto___45882);
var G__45886 = (0);
seq__45041_45840 = G__45883;
chunk__45042_45841 = G__45884;
count__45043_45842 = G__45885;
i__45044_45843 = G__45886;
continue;
} else {
var vec__45123_45887 = cljs.core.first(seq__45041_45881__$1);
var line_45888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45123_45887,(0),null);
var cols_45889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45123_45887,(1),null);
var seq__45126_45890 = cljs.core.seq(cols_45889);
var chunk__45127_45891 = null;
var count__45128_45892 = (0);
var i__45129_45893 = (0);
while(true){
if((i__45129_45893 < count__45128_45892)){
var vec__45136_45894 = chunk__45127_45891.cljs$core$IIndexed$_nth$arity$2(null,i__45129_45893);
var col_45895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45136_45894,(0),null);
var infos_45896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45136_45894,(1),null);
encode_cols(infos_45896,source_idx_45836,line_45888,col_45895);


var G__45898 = seq__45126_45890;
var G__45899 = chunk__45127_45891;
var G__45900 = count__45128_45892;
var G__45901 = (i__45129_45893 + (1));
seq__45126_45890 = G__45898;
chunk__45127_45891 = G__45899;
count__45128_45892 = G__45900;
i__45129_45893 = G__45901;
continue;
} else {
var temp__5735__auto___45902__$1 = cljs.core.seq(seq__45126_45890);
if(temp__5735__auto___45902__$1){
var seq__45126_45903__$1 = temp__5735__auto___45902__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45126_45903__$1)){
var c__4609__auto___45904 = cljs.core.chunk_first(seq__45126_45903__$1);
var G__45905 = cljs.core.chunk_rest(seq__45126_45903__$1);
var G__45906 = c__4609__auto___45904;
var G__45907 = cljs.core.count(c__4609__auto___45904);
var G__45908 = (0);
seq__45126_45890 = G__45905;
chunk__45127_45891 = G__45906;
count__45128_45892 = G__45907;
i__45129_45893 = G__45908;
continue;
} else {
var vec__45139_45909 = cljs.core.first(seq__45126_45903__$1);
var col_45910 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45139_45909,(0),null);
var infos_45911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45139_45909,(1),null);
encode_cols(infos_45911,source_idx_45836,line_45888,col_45910);


var G__45912 = cljs.core.next(seq__45126_45903__$1);
var G__45913 = null;
var G__45914 = (0);
var G__45915 = (0);
seq__45126_45890 = G__45912;
chunk__45127_45891 = G__45913;
count__45128_45892 = G__45914;
i__45129_45893 = G__45915;
continue;
}
} else {
}
}
break;
}


var G__45916 = cljs.core.next(seq__45041_45881__$1);
var G__45917 = null;
var G__45918 = (0);
var G__45919 = (0);
seq__45041_45840 = G__45916;
chunk__45042_45841 = G__45917;
count__45043_45842 = G__45918;
i__45044_45843 = G__45919;
continue;
}
} else {
}
}
break;
}


var G__45921 = seq__44760_45831;
var G__45922 = chunk__44761_45832;
var G__45923 = count__44762_45833;
var G__45924 = (i__44763_45834 + (1));
seq__44760_45831 = G__45921;
chunk__44761_45832 = G__45922;
count__44762_45833 = G__45923;
i__44763_45834 = G__45924;
continue;
} else {
var temp__5735__auto___45925 = cljs.core.seq(seq__44760_45831);
if(temp__5735__auto___45925){
var seq__44760_45926__$1 = temp__5735__auto___45925;
if(cljs.core.chunked_seq_QMARK_(seq__44760_45926__$1)){
var c__4609__auto___45927 = cljs.core.chunk_first(seq__44760_45926__$1);
var G__45928 = cljs.core.chunk_rest(seq__44760_45926__$1);
var G__45929 = c__4609__auto___45927;
var G__45930 = cljs.core.count(c__4609__auto___45927);
var G__45931 = (0);
seq__44760_45831 = G__45928;
chunk__44761_45832 = G__45929;
count__44762_45833 = G__45930;
i__44763_45834 = G__45931;
continue;
} else {
var vec__45144_45932 = cljs.core.first(seq__44760_45926__$1);
var source_idx_45933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45144_45932,(0),null);
var vec__45147_45934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45144_45932,(1),null);
var __45935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45147_45934,(0),null);
var lines_45936__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45147_45934,(1),null);
var seq__45153_45939 = cljs.core.seq(lines_45936__$1);
var chunk__45154_45940 = null;
var count__45155_45941 = (0);
var i__45156_45942 = (0);
while(true){
if((i__45156_45942 < count__45155_45941)){
var vec__45205_45943 = chunk__45154_45940.cljs$core$IIndexed$_nth$arity$2(null,i__45156_45942);
var line_45944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45205_45943,(0),null);
var cols_45945 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45205_45943,(1),null);
var seq__45208_45946 = cljs.core.seq(cols_45945);
var chunk__45209_45947 = null;
var count__45210_45948 = (0);
var i__45211_45949 = (0);
while(true){
if((i__45211_45949 < count__45210_45948)){
var vec__45219_45950 = chunk__45209_45947.cljs$core$IIndexed$_nth$arity$2(null,i__45211_45949);
var col_45951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45219_45950,(0),null);
var infos_45952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45219_45950,(1),null);
encode_cols(infos_45952,source_idx_45933,line_45944,col_45951);


var G__45953 = seq__45208_45946;
var G__45954 = chunk__45209_45947;
var G__45955 = count__45210_45948;
var G__45956 = (i__45211_45949 + (1));
seq__45208_45946 = G__45953;
chunk__45209_45947 = G__45954;
count__45210_45948 = G__45955;
i__45211_45949 = G__45956;
continue;
} else {
var temp__5735__auto___45957__$1 = cljs.core.seq(seq__45208_45946);
if(temp__5735__auto___45957__$1){
var seq__45208_45958__$1 = temp__5735__auto___45957__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45208_45958__$1)){
var c__4609__auto___45959 = cljs.core.chunk_first(seq__45208_45958__$1);
var G__45960 = cljs.core.chunk_rest(seq__45208_45958__$1);
var G__45961 = c__4609__auto___45959;
var G__45962 = cljs.core.count(c__4609__auto___45959);
var G__45963 = (0);
seq__45208_45946 = G__45960;
chunk__45209_45947 = G__45961;
count__45210_45948 = G__45962;
i__45211_45949 = G__45963;
continue;
} else {
var vec__45222_45964 = cljs.core.first(seq__45208_45958__$1);
var col_45965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45964,(0),null);
var infos_45966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45964,(1),null);
encode_cols(infos_45966,source_idx_45933,line_45944,col_45965);


var G__45969 = cljs.core.next(seq__45208_45958__$1);
var G__45970 = null;
var G__45971 = (0);
var G__45972 = (0);
seq__45208_45946 = G__45969;
chunk__45209_45947 = G__45970;
count__45210_45948 = G__45971;
i__45211_45949 = G__45972;
continue;
}
} else {
}
}
break;
}


var G__45973 = seq__45153_45939;
var G__45974 = chunk__45154_45940;
var G__45975 = count__45155_45941;
var G__45976 = (i__45156_45942 + (1));
seq__45153_45939 = G__45973;
chunk__45154_45940 = G__45974;
count__45155_45941 = G__45975;
i__45156_45942 = G__45976;
continue;
} else {
var temp__5735__auto___45977__$1 = cljs.core.seq(seq__45153_45939);
if(temp__5735__auto___45977__$1){
var seq__45153_45978__$1 = temp__5735__auto___45977__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45153_45978__$1)){
var c__4609__auto___45981 = cljs.core.chunk_first(seq__45153_45978__$1);
var G__45982 = cljs.core.chunk_rest(seq__45153_45978__$1);
var G__45983 = c__4609__auto___45981;
var G__45984 = cljs.core.count(c__4609__auto___45981);
var G__45985 = (0);
seq__45153_45939 = G__45982;
chunk__45154_45940 = G__45983;
count__45155_45941 = G__45984;
i__45156_45942 = G__45985;
continue;
} else {
var vec__45226_45986 = cljs.core.first(seq__45153_45978__$1);
var line_45987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45986,(0),null);
var cols_45988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45986,(1),null);
var seq__45229_45991 = cljs.core.seq(cols_45988);
var chunk__45230_45992 = null;
var count__45231_45993 = (0);
var i__45232_45994 = (0);
while(true){
if((i__45232_45994 < count__45231_45993)){
var vec__45240_45996 = chunk__45230_45992.cljs$core$IIndexed$_nth$arity$2(null,i__45232_45994);
var col_45997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45240_45996,(0),null);
var infos_45998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45240_45996,(1),null);
encode_cols(infos_45998,source_idx_45933,line_45987,col_45997);


var G__46000 = seq__45229_45991;
var G__46001 = chunk__45230_45992;
var G__46002 = count__45231_45993;
var G__46003 = (i__45232_45994 + (1));
seq__45229_45991 = G__46000;
chunk__45230_45992 = G__46001;
count__45231_45993 = G__46002;
i__45232_45994 = G__46003;
continue;
} else {
var temp__5735__auto___46004__$2 = cljs.core.seq(seq__45229_45991);
if(temp__5735__auto___46004__$2){
var seq__45229_46005__$1 = temp__5735__auto___46004__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45229_46005__$1)){
var c__4609__auto___46008 = cljs.core.chunk_first(seq__45229_46005__$1);
var G__46009 = cljs.core.chunk_rest(seq__45229_46005__$1);
var G__46010 = c__4609__auto___46008;
var G__46011 = cljs.core.count(c__4609__auto___46008);
var G__46012 = (0);
seq__45229_45991 = G__46009;
chunk__45230_45992 = G__46010;
count__45231_45993 = G__46011;
i__45232_45994 = G__46012;
continue;
} else {
var vec__45247_46013 = cljs.core.first(seq__45229_46005__$1);
var col_46014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45247_46013,(0),null);
var infos_46015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45247_46013,(1),null);
encode_cols(infos_46015,source_idx_45933,line_45987,col_46014);


var G__46018 = cljs.core.next(seq__45229_46005__$1);
var G__46019 = null;
var G__46020 = (0);
var G__46021 = (0);
seq__45229_45991 = G__46018;
chunk__45230_45992 = G__46019;
count__45231_45993 = G__46020;
i__45232_45994 = G__46021;
continue;
}
} else {
}
}
break;
}


var G__46022 = cljs.core.next(seq__45153_45978__$1);
var G__46023 = null;
var G__46024 = (0);
var G__46025 = (0);
seq__45153_45939 = G__46022;
chunk__45154_45940 = G__46023;
count__45155_45941 = G__46024;
i__45156_45942 = G__46025;
continue;
}
} else {
}
}
break;
}


var G__46026 = cljs.core.next(seq__44760_45926__$1);
var G__46027 = null;
var G__46028 = (0);
var G__46029 = (0);
seq__44760_45831 = G__46026;
chunk__44761_45832 = G__46027;
count__44762_45833 = G__46028;
i__44763_45834 = G__46029;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45250 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44737_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44737_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44740_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44740_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44741_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44741_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45251 = G__45250;
var G__45252_46037 = G__45251;
var G__45253_46038 = "sourcesContent";
var G__45254_46039 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45252_46037,G__45253_46038,G__45254_46039);

return G__45251;
} else {
return G__45250;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45265 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45265,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45265,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45271 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45271,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45271,(1),null);
var G__46044 = cljs.core.next(col_map_seq);
var G__46045 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45271,col,infos,vec__45265,line,col_map){
return (function (v,p__45274){
var map__45275 = p__45274;
var map__45275__$1 = (((((!((map__45275 == null))))?(((((map__45275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45275.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45275):map__45275);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45275__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45275__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45271,col,infos,vec__45265,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46044;
new_cols = G__46045;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46049 = cljs.core.next(line_map_seq);
var G__46050 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46049;
new_lines = G__46050;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45282_46056 = cljs.core.seq(reverse_map);
var chunk__45283_46057 = null;
var count__45284_46058 = (0);
var i__45285_46059 = (0);
while(true){
if((i__45285_46059 < count__45284_46058)){
var vec__45557_46062 = chunk__45283_46057.cljs$core$IIndexed$_nth$arity$2(null,i__45285_46059);
var line_46063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45557_46062,(0),null);
var columns_46064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45557_46062,(1),null);
var seq__45560_46065 = cljs.core.seq(columns_46064);
var chunk__45561_46066 = null;
var count__45562_46067 = (0);
var i__45563_46068 = (0);
while(true){
if((i__45563_46068 < count__45562_46067)){
var vec__45626_46069 = chunk__45561_46066.cljs$core$IIndexed$_nth$arity$2(null,i__45563_46068);
var column_46070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45626_46069,(0),null);
var column_info_46071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45626_46069,(1),null);
var seq__45629_46072 = cljs.core.seq(column_info_46071);
var chunk__45630_46073 = null;
var count__45631_46074 = (0);
var i__45632_46075 = (0);
while(true){
if((i__45632_46075 < count__45631_46074)){
var map__45646_46076 = chunk__45630_46073.cljs$core$IIndexed$_nth$arity$2(null,i__45632_46075);
var map__45646_46077__$1 = (((((!((map__45646_46076 == null))))?(((((map__45646_46076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45646_46076.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45646_46076):map__45646_46076);
var gline_46078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45646_46077__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45646_46077__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46080 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45646_46077__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46078], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45629_46072,chunk__45630_46073,count__45631_46074,i__45632_46075,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45646_46076,map__45646_46077__$1,gline_46078,gcol_46079,name_46080,vec__45626_46069,column_46070,column_info_46071,vec__45557_46062,line_46063,columns_46064,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46079], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46063,new cljs.core.Keyword(null,"col","col",-1959363084),column_46070,new cljs.core.Keyword(null,"name","name",1843675177),name_46080], null));
});})(seq__45629_46072,chunk__45630_46073,count__45631_46074,i__45632_46075,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45646_46076,map__45646_46077__$1,gline_46078,gcol_46079,name_46080,vec__45626_46069,column_46070,column_info_46071,vec__45557_46062,line_46063,columns_46064,inverted))
,cljs.core.sorted_map()));


var G__46082 = seq__45629_46072;
var G__46083 = chunk__45630_46073;
var G__46084 = count__45631_46074;
var G__46085 = (i__45632_46075 + (1));
seq__45629_46072 = G__46082;
chunk__45630_46073 = G__46083;
count__45631_46074 = G__46084;
i__45632_46075 = G__46085;
continue;
} else {
var temp__5735__auto___46088 = cljs.core.seq(seq__45629_46072);
if(temp__5735__auto___46088){
var seq__45629_46090__$1 = temp__5735__auto___46088;
if(cljs.core.chunked_seq_QMARK_(seq__45629_46090__$1)){
var c__4609__auto___46091 = cljs.core.chunk_first(seq__45629_46090__$1);
var G__46092 = cljs.core.chunk_rest(seq__45629_46090__$1);
var G__46093 = c__4609__auto___46091;
var G__46094 = cljs.core.count(c__4609__auto___46091);
var G__46095 = (0);
seq__45629_46072 = G__46092;
chunk__45630_46073 = G__46093;
count__45631_46074 = G__46094;
i__45632_46075 = G__46095;
continue;
} else {
var map__45650_46096 = cljs.core.first(seq__45629_46090__$1);
var map__45650_46097__$1 = (((((!((map__45650_46096 == null))))?(((((map__45650_46096.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45650_46096.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45650_46096):map__45650_46096);
var gline_46098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45650_46097__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45650_46097__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45650_46097__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46098], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45629_46072,chunk__45630_46073,count__45631_46074,i__45632_46075,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45650_46096,map__45650_46097__$1,gline_46098,gcol_46099,name_46100,seq__45629_46090__$1,temp__5735__auto___46088,vec__45626_46069,column_46070,column_info_46071,vec__45557_46062,line_46063,columns_46064,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46099], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46063,new cljs.core.Keyword(null,"col","col",-1959363084),column_46070,new cljs.core.Keyword(null,"name","name",1843675177),name_46100], null));
});})(seq__45629_46072,chunk__45630_46073,count__45631_46074,i__45632_46075,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45650_46096,map__45650_46097__$1,gline_46098,gcol_46099,name_46100,seq__45629_46090__$1,temp__5735__auto___46088,vec__45626_46069,column_46070,column_info_46071,vec__45557_46062,line_46063,columns_46064,inverted))
,cljs.core.sorted_map()));


var G__46101 = cljs.core.next(seq__45629_46090__$1);
var G__46102 = null;
var G__46103 = (0);
var G__46104 = (0);
seq__45629_46072 = G__46101;
chunk__45630_46073 = G__46102;
count__45631_46074 = G__46103;
i__45632_46075 = G__46104;
continue;
}
} else {
}
}
break;
}


var G__46106 = seq__45560_46065;
var G__46107 = chunk__45561_46066;
var G__46108 = count__45562_46067;
var G__46109 = (i__45563_46068 + (1));
seq__45560_46065 = G__46106;
chunk__45561_46066 = G__46107;
count__45562_46067 = G__46108;
i__45563_46068 = G__46109;
continue;
} else {
var temp__5735__auto___46111 = cljs.core.seq(seq__45560_46065);
if(temp__5735__auto___46111){
var seq__45560_46112__$1 = temp__5735__auto___46111;
if(cljs.core.chunked_seq_QMARK_(seq__45560_46112__$1)){
var c__4609__auto___46113 = cljs.core.chunk_first(seq__45560_46112__$1);
var G__46114 = cljs.core.chunk_rest(seq__45560_46112__$1);
var G__46115 = c__4609__auto___46113;
var G__46116 = cljs.core.count(c__4609__auto___46113);
var G__46117 = (0);
seq__45560_46065 = G__46114;
chunk__45561_46066 = G__46115;
count__45562_46067 = G__46116;
i__45563_46068 = G__46117;
continue;
} else {
var vec__45653_46118 = cljs.core.first(seq__45560_46112__$1);
var column_46119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45653_46118,(0),null);
var column_info_46120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45653_46118,(1),null);
var seq__45656_46121 = cljs.core.seq(column_info_46120);
var chunk__45657_46122 = null;
var count__45658_46123 = (0);
var i__45659_46124 = (0);
while(true){
if((i__45659_46124 < count__45658_46123)){
var map__45664_46125 = chunk__45657_46122.cljs$core$IIndexed$_nth$arity$2(null,i__45659_46124);
var map__45664_46126__$1 = (((((!((map__45664_46125 == null))))?(((((map__45664_46125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45664_46125.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45664_46125):map__45664_46125);
var gline_46127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45664_46126__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45664_46126__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45664_46126__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46127], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45656_46121,chunk__45657_46122,count__45658_46123,i__45659_46124,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45664_46125,map__45664_46126__$1,gline_46127,gcol_46128,name_46129,vec__45653_46118,column_46119,column_info_46120,seq__45560_46112__$1,temp__5735__auto___46111,vec__45557_46062,line_46063,columns_46064,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46128], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46063,new cljs.core.Keyword(null,"col","col",-1959363084),column_46119,new cljs.core.Keyword(null,"name","name",1843675177),name_46129], null));
});})(seq__45656_46121,chunk__45657_46122,count__45658_46123,i__45659_46124,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45664_46125,map__45664_46126__$1,gline_46127,gcol_46128,name_46129,vec__45653_46118,column_46119,column_info_46120,seq__45560_46112__$1,temp__5735__auto___46111,vec__45557_46062,line_46063,columns_46064,inverted))
,cljs.core.sorted_map()));


var G__46138 = seq__45656_46121;
var G__46139 = chunk__45657_46122;
var G__46140 = count__45658_46123;
var G__46141 = (i__45659_46124 + (1));
seq__45656_46121 = G__46138;
chunk__45657_46122 = G__46139;
count__45658_46123 = G__46140;
i__45659_46124 = G__46141;
continue;
} else {
var temp__5735__auto___46142__$1 = cljs.core.seq(seq__45656_46121);
if(temp__5735__auto___46142__$1){
var seq__45656_46143__$1 = temp__5735__auto___46142__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45656_46143__$1)){
var c__4609__auto___46144 = cljs.core.chunk_first(seq__45656_46143__$1);
var G__46145 = cljs.core.chunk_rest(seq__45656_46143__$1);
var G__46146 = c__4609__auto___46144;
var G__46147 = cljs.core.count(c__4609__auto___46144);
var G__46148 = (0);
seq__45656_46121 = G__46145;
chunk__45657_46122 = G__46146;
count__45658_46123 = G__46147;
i__45659_46124 = G__46148;
continue;
} else {
var map__45672_46149 = cljs.core.first(seq__45656_46143__$1);
var map__45672_46150__$1 = (((((!((map__45672_46149 == null))))?(((((map__45672_46149.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45672_46149.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45672_46149):map__45672_46149);
var gline_46151 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45672_46150__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45672_46150__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45672_46150__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46151], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45656_46121,chunk__45657_46122,count__45658_46123,i__45659_46124,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45672_46149,map__45672_46150__$1,gline_46151,gcol_46152,name_46153,seq__45656_46143__$1,temp__5735__auto___46142__$1,vec__45653_46118,column_46119,column_info_46120,seq__45560_46112__$1,temp__5735__auto___46111,vec__45557_46062,line_46063,columns_46064,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46152], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46063,new cljs.core.Keyword(null,"col","col",-1959363084),column_46119,new cljs.core.Keyword(null,"name","name",1843675177),name_46153], null));
});})(seq__45656_46121,chunk__45657_46122,count__45658_46123,i__45659_46124,seq__45560_46065,chunk__45561_46066,count__45562_46067,i__45563_46068,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45672_46149,map__45672_46150__$1,gline_46151,gcol_46152,name_46153,seq__45656_46143__$1,temp__5735__auto___46142__$1,vec__45653_46118,column_46119,column_info_46120,seq__45560_46112__$1,temp__5735__auto___46111,vec__45557_46062,line_46063,columns_46064,inverted))
,cljs.core.sorted_map()));


var G__46155 = cljs.core.next(seq__45656_46143__$1);
var G__46156 = null;
var G__46157 = (0);
var G__46158 = (0);
seq__45656_46121 = G__46155;
chunk__45657_46122 = G__46156;
count__45658_46123 = G__46157;
i__45659_46124 = G__46158;
continue;
}
} else {
}
}
break;
}


var G__46159 = cljs.core.next(seq__45560_46112__$1);
var G__46160 = null;
var G__46161 = (0);
var G__46162 = (0);
seq__45560_46065 = G__46159;
chunk__45561_46066 = G__46160;
count__45562_46067 = G__46161;
i__45563_46068 = G__46162;
continue;
}
} else {
}
}
break;
}


var G__46163 = seq__45282_46056;
var G__46164 = chunk__45283_46057;
var G__46165 = count__45284_46058;
var G__46166 = (i__45285_46059 + (1));
seq__45282_46056 = G__46163;
chunk__45283_46057 = G__46164;
count__45284_46058 = G__46165;
i__45285_46059 = G__46166;
continue;
} else {
var temp__5735__auto___46167 = cljs.core.seq(seq__45282_46056);
if(temp__5735__auto___46167){
var seq__45282_46168__$1 = temp__5735__auto___46167;
if(cljs.core.chunked_seq_QMARK_(seq__45282_46168__$1)){
var c__4609__auto___46169 = cljs.core.chunk_first(seq__45282_46168__$1);
var G__46170 = cljs.core.chunk_rest(seq__45282_46168__$1);
var G__46171 = c__4609__auto___46169;
var G__46172 = cljs.core.count(c__4609__auto___46169);
var G__46173 = (0);
seq__45282_46056 = G__46170;
chunk__45283_46057 = G__46171;
count__45284_46058 = G__46172;
i__45285_46059 = G__46173;
continue;
} else {
var vec__45674_46174 = cljs.core.first(seq__45282_46168__$1);
var line_46175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45674_46174,(0),null);
var columns_46176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45674_46174,(1),null);
var seq__45677_46177 = cljs.core.seq(columns_46176);
var chunk__45678_46178 = null;
var count__45679_46179 = (0);
var i__45680_46180 = (0);
while(true){
if((i__45680_46180 < count__45679_46179)){
var vec__45718_46181 = chunk__45678_46178.cljs$core$IIndexed$_nth$arity$2(null,i__45680_46180);
var column_46182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45718_46181,(0),null);
var column_info_46183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45718_46181,(1),null);
var seq__45722_46184 = cljs.core.seq(column_info_46183);
var chunk__45723_46185 = null;
var count__45724_46186 = (0);
var i__45725_46187 = (0);
while(true){
if((i__45725_46187 < count__45724_46186)){
var map__45736_46189 = chunk__45723_46185.cljs$core$IIndexed$_nth$arity$2(null,i__45725_46187);
var map__45736_46190__$1 = (((((!((map__45736_46189 == null))))?(((((map__45736_46189.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45736_46189.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45736_46189):map__45736_46189);
var gline_46191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45736_46190__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45736_46190__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45736_46190__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46191], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45722_46184,chunk__45723_46185,count__45724_46186,i__45725_46187,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45736_46189,map__45736_46190__$1,gline_46191,gcol_46192,name_46193,vec__45718_46181,column_46182,column_info_46183,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46192], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46175,new cljs.core.Keyword(null,"col","col",-1959363084),column_46182,new cljs.core.Keyword(null,"name","name",1843675177),name_46193], null));
});})(seq__45722_46184,chunk__45723_46185,count__45724_46186,i__45725_46187,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45736_46189,map__45736_46190__$1,gline_46191,gcol_46192,name_46193,vec__45718_46181,column_46182,column_info_46183,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted))
,cljs.core.sorted_map()));


var G__46196 = seq__45722_46184;
var G__46197 = chunk__45723_46185;
var G__46198 = count__45724_46186;
var G__46199 = (i__45725_46187 + (1));
seq__45722_46184 = G__46196;
chunk__45723_46185 = G__46197;
count__45724_46186 = G__46198;
i__45725_46187 = G__46199;
continue;
} else {
var temp__5735__auto___46202__$1 = cljs.core.seq(seq__45722_46184);
if(temp__5735__auto___46202__$1){
var seq__45722_46203__$1 = temp__5735__auto___46202__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45722_46203__$1)){
var c__4609__auto___46204 = cljs.core.chunk_first(seq__45722_46203__$1);
var G__46205 = cljs.core.chunk_rest(seq__45722_46203__$1);
var G__46206 = c__4609__auto___46204;
var G__46207 = cljs.core.count(c__4609__auto___46204);
var G__46208 = (0);
seq__45722_46184 = G__46205;
chunk__45723_46185 = G__46206;
count__45724_46186 = G__46207;
i__45725_46187 = G__46208;
continue;
} else {
var map__45748_46209 = cljs.core.first(seq__45722_46203__$1);
var map__45748_46210__$1 = (((((!((map__45748_46209 == null))))?(((((map__45748_46209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45748_46209.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45748_46209):map__45748_46209);
var gline_46211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45748_46210__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46212 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45748_46210__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46213 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45748_46210__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46211], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45722_46184,chunk__45723_46185,count__45724_46186,i__45725_46187,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45748_46209,map__45748_46210__$1,gline_46211,gcol_46212,name_46213,seq__45722_46203__$1,temp__5735__auto___46202__$1,vec__45718_46181,column_46182,column_info_46183,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46212], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46175,new cljs.core.Keyword(null,"col","col",-1959363084),column_46182,new cljs.core.Keyword(null,"name","name",1843675177),name_46213], null));
});})(seq__45722_46184,chunk__45723_46185,count__45724_46186,i__45725_46187,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45748_46209,map__45748_46210__$1,gline_46211,gcol_46212,name_46213,seq__45722_46203__$1,temp__5735__auto___46202__$1,vec__45718_46181,column_46182,column_info_46183,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted))
,cljs.core.sorted_map()));


var G__46218 = cljs.core.next(seq__45722_46203__$1);
var G__46219 = null;
var G__46220 = (0);
var G__46221 = (0);
seq__45722_46184 = G__46218;
chunk__45723_46185 = G__46219;
count__45724_46186 = G__46220;
i__45725_46187 = G__46221;
continue;
}
} else {
}
}
break;
}


var G__46222 = seq__45677_46177;
var G__46223 = chunk__45678_46178;
var G__46224 = count__45679_46179;
var G__46225 = (i__45680_46180 + (1));
seq__45677_46177 = G__46222;
chunk__45678_46178 = G__46223;
count__45679_46179 = G__46224;
i__45680_46180 = G__46225;
continue;
} else {
var temp__5735__auto___46226__$1 = cljs.core.seq(seq__45677_46177);
if(temp__5735__auto___46226__$1){
var seq__45677_46227__$1 = temp__5735__auto___46226__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45677_46227__$1)){
var c__4609__auto___46228 = cljs.core.chunk_first(seq__45677_46227__$1);
var G__46229 = cljs.core.chunk_rest(seq__45677_46227__$1);
var G__46230 = c__4609__auto___46228;
var G__46231 = cljs.core.count(c__4609__auto___46228);
var G__46232 = (0);
seq__45677_46177 = G__46229;
chunk__45678_46178 = G__46230;
count__45679_46179 = G__46231;
i__45680_46180 = G__46232;
continue;
} else {
var vec__45758_46233 = cljs.core.first(seq__45677_46227__$1);
var column_46234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45758_46233,(0),null);
var column_info_46235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45758_46233,(1),null);
var seq__45761_46236 = cljs.core.seq(column_info_46235);
var chunk__45762_46237 = null;
var count__45763_46238 = (0);
var i__45764_46239 = (0);
while(true){
if((i__45764_46239 < count__45763_46238)){
var map__45772_46240 = chunk__45762_46237.cljs$core$IIndexed$_nth$arity$2(null,i__45764_46239);
var map__45772_46241__$1 = (((((!((map__45772_46240 == null))))?(((((map__45772_46240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45772_46240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45772_46240):map__45772_46240);
var gline_46242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45772_46241__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45772_46241__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45772_46241__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46242], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45761_46236,chunk__45762_46237,count__45763_46238,i__45764_46239,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45772_46240,map__45772_46241__$1,gline_46242,gcol_46243,name_46244,vec__45758_46233,column_46234,column_info_46235,seq__45677_46227__$1,temp__5735__auto___46226__$1,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46243], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46175,new cljs.core.Keyword(null,"col","col",-1959363084),column_46234,new cljs.core.Keyword(null,"name","name",1843675177),name_46244], null));
});})(seq__45761_46236,chunk__45762_46237,count__45763_46238,i__45764_46239,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45772_46240,map__45772_46241__$1,gline_46242,gcol_46243,name_46244,vec__45758_46233,column_46234,column_info_46235,seq__45677_46227__$1,temp__5735__auto___46226__$1,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted))
,cljs.core.sorted_map()));


var G__46245 = seq__45761_46236;
var G__46246 = chunk__45762_46237;
var G__46247 = count__45763_46238;
var G__46248 = (i__45764_46239 + (1));
seq__45761_46236 = G__46245;
chunk__45762_46237 = G__46246;
count__45763_46238 = G__46247;
i__45764_46239 = G__46248;
continue;
} else {
var temp__5735__auto___46249__$2 = cljs.core.seq(seq__45761_46236);
if(temp__5735__auto___46249__$2){
var seq__45761_46250__$1 = temp__5735__auto___46249__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45761_46250__$1)){
var c__4609__auto___46251 = cljs.core.chunk_first(seq__45761_46250__$1);
var G__46252 = cljs.core.chunk_rest(seq__45761_46250__$1);
var G__46253 = c__4609__auto___46251;
var G__46254 = cljs.core.count(c__4609__auto___46251);
var G__46255 = (0);
seq__45761_46236 = G__46252;
chunk__45762_46237 = G__46253;
count__45763_46238 = G__46254;
i__45764_46239 = G__46255;
continue;
} else {
var map__45778_46256 = cljs.core.first(seq__45761_46250__$1);
var map__45778_46257__$1 = (((((!((map__45778_46256 == null))))?(((((map__45778_46256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45778_46256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45778_46256):map__45778_46256);
var gline_46258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45778_46257__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45778_46257__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45778_46257__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46258], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45761_46236,chunk__45762_46237,count__45763_46238,i__45764_46239,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45778_46256,map__45778_46257__$1,gline_46258,gcol_46259,name_46260,seq__45761_46250__$1,temp__5735__auto___46249__$2,vec__45758_46233,column_46234,column_info_46235,seq__45677_46227__$1,temp__5735__auto___46226__$1,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46259], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46175,new cljs.core.Keyword(null,"col","col",-1959363084),column_46234,new cljs.core.Keyword(null,"name","name",1843675177),name_46260], null));
});})(seq__45761_46236,chunk__45762_46237,count__45763_46238,i__45764_46239,seq__45677_46177,chunk__45678_46178,count__45679_46179,i__45680_46180,seq__45282_46056,chunk__45283_46057,count__45284_46058,i__45285_46059,map__45778_46256,map__45778_46257__$1,gline_46258,gcol_46259,name_46260,seq__45761_46250__$1,temp__5735__auto___46249__$2,vec__45758_46233,column_46234,column_info_46235,seq__45677_46227__$1,temp__5735__auto___46226__$1,vec__45674_46174,line_46175,columns_46176,seq__45282_46168__$1,temp__5735__auto___46167,inverted))
,cljs.core.sorted_map()));


var G__46261 = cljs.core.next(seq__45761_46250__$1);
var G__46262 = null;
var G__46263 = (0);
var G__46264 = (0);
seq__45761_46236 = G__46261;
chunk__45762_46237 = G__46262;
count__45763_46238 = G__46263;
i__45764_46239 = G__46264;
continue;
}
} else {
}
}
break;
}


var G__46265 = cljs.core.next(seq__45677_46227__$1);
var G__46266 = null;
var G__46267 = (0);
var G__46268 = (0);
seq__45677_46177 = G__46265;
chunk__45678_46178 = G__46266;
count__45679_46179 = G__46267;
i__45680_46180 = G__46268;
continue;
}
} else {
}
}
break;
}


var G__46270 = cljs.core.next(seq__45282_46168__$1);
var G__46271 = null;
var G__46272 = (0);
var G__46273 = (0);
seq__45282_46056 = G__46270;
chunk__45283_46057 = G__46271;
count__45284_46058 = G__46272;
i__45285_46059 = G__46273;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
