goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42188 = arguments.length;
switch (G__42188) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42189 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42189 = (function (f,blockable,meta42190){
this.f = f;
this.blockable = blockable;
this.meta42190 = meta42190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42191,meta42190__$1){
var self__ = this;
var _42191__$1 = this;
return (new cljs.core.async.t_cljs$core$async42189(self__.f,self__.blockable,meta42190__$1));
}));

(cljs.core.async.t_cljs$core$async42189.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42191){
var self__ = this;
var _42191__$1 = this;
return self__.meta42190;
}));

(cljs.core.async.t_cljs$core$async42189.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42189.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42189.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async42189.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async42189.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42190","meta42190",298370264,null)], null);
}));

(cljs.core.async.t_cljs$core$async42189.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42189.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42189");

(cljs.core.async.t_cljs$core$async42189.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async42189");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42189.
 */
cljs.core.async.__GT_t_cljs$core$async42189 = (function cljs$core$async$__GT_t_cljs$core$async42189(f__$1,blockable__$1,meta42190){
return (new cljs.core.async.t_cljs$core$async42189(f__$1,blockable__$1,meta42190));
});

}

return (new cljs.core.async.t_cljs$core$async42189(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42196 = arguments.length;
switch (G__42196) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__42198 = arguments.length;
switch (G__42198) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__42200 = arguments.length;
switch (G__42200) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_43653 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_43653) : fn1.call(null,val_43653));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_43653) : fn1.call(null,val_43653));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__42202 = arguments.length;
switch (G__42202) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4666__auto___43666 = n;
var x_43669 = (0);
while(true){
if((x_43669 < n__4666__auto___43666)){
(a[x_43669] = x_43669);

var G__43675 = (x_43669 + (1));
x_43669 = G__43675;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42203 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42203 = (function (flag,meta42204){
this.flag = flag;
this.meta42204 = meta42204;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42203.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42205,meta42204__$1){
var self__ = this;
var _42205__$1 = this;
return (new cljs.core.async.t_cljs$core$async42203(self__.flag,meta42204__$1));
}));

(cljs.core.async.t_cljs$core$async42203.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42205){
var self__ = this;
var _42205__$1 = this;
return self__.meta42204;
}));

(cljs.core.async.t_cljs$core$async42203.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42203.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async42203.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42203.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async42203.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42204","meta42204",-287608641,null)], null);
}));

(cljs.core.async.t_cljs$core$async42203.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42203.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42203");

(cljs.core.async.t_cljs$core$async42203.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async42203");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42203.
 */
cljs.core.async.__GT_t_cljs$core$async42203 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42203(flag__$1,meta42204){
return (new cljs.core.async.t_cljs$core$async42203(flag__$1,meta42204));
});

}

return (new cljs.core.async.t_cljs$core$async42203(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42206 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42206 = (function (flag,cb,meta42207){
this.flag = flag;
this.cb = cb;
this.meta42207 = meta42207;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42206.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42208,meta42207__$1){
var self__ = this;
var _42208__$1 = this;
return (new cljs.core.async.t_cljs$core$async42206(self__.flag,self__.cb,meta42207__$1));
}));

(cljs.core.async.t_cljs$core$async42206.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42208){
var self__ = this;
var _42208__$1 = this;
return self__.meta42207;
}));

(cljs.core.async.t_cljs$core$async42206.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42206.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async42206.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42206.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async42206.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42207","meta42207",1286266870,null)], null);
}));

(cljs.core.async.t_cljs$core$async42206.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42206.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42206");

(cljs.core.async.t_cljs$core$async42206.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async42206");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42206.
 */
cljs.core.async.__GT_t_cljs$core$async42206 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42206(flag__$1,cb__$1,meta42207){
return (new cljs.core.async.t_cljs$core$async42206(flag__$1,cb__$1,meta42207));
});

}

return (new cljs.core.async.t_cljs$core$async42206(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42209_SHARP_){
var G__42211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42209_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__42211) : fret.call(null,G__42211));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42210_SHARP_){
var G__42212 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42210_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__42212) : fret.call(null,G__42212));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4185__auto__ = wport;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__43676 = (i + (1));
i = G__43676;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4185__auto__ = ret;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4174__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4174__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___43679 = arguments.length;
var i__4790__auto___43680 = (0);
while(true){
if((i__4790__auto___43680 < len__4789__auto___43679)){
args__4795__auto__.push((arguments[i__4790__auto___43680]));

var G__43681 = (i__4790__auto___43680 + (1));
i__4790__auto___43680 = G__43681;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__42215){
var map__42216 = p__42215;
var map__42216__$1 = (((((!((map__42216 == null))))?(((((map__42216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42216.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42216):map__42216);
var opts = map__42216__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq42213){
var G__42214 = cljs.core.first(seq42213);
var seq42213__$1 = cljs.core.next(seq42213);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42214,seq42213__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__42219 = arguments.length;
switch (G__42219) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42130__auto___43683 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42243){
var state_val_42244 = (state_42243[(1)]);
if((state_val_42244 === (7))){
var inst_42239 = (state_42243[(2)]);
var state_42243__$1 = state_42243;
var statearr_42245_43684 = state_42243__$1;
(statearr_42245_43684[(2)] = inst_42239);

(statearr_42245_43684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (1))){
var state_42243__$1 = state_42243;
var statearr_42246_43685 = state_42243__$1;
(statearr_42246_43685[(2)] = null);

(statearr_42246_43685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (4))){
var inst_42222 = (state_42243[(7)]);
var inst_42222__$1 = (state_42243[(2)]);
var inst_42223 = (inst_42222__$1 == null);
var state_42243__$1 = (function (){var statearr_42247 = state_42243;
(statearr_42247[(7)] = inst_42222__$1);

return statearr_42247;
})();
if(cljs.core.truth_(inst_42223)){
var statearr_42248_43686 = state_42243__$1;
(statearr_42248_43686[(1)] = (5));

} else {
var statearr_42249_43687 = state_42243__$1;
(statearr_42249_43687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (13))){
var state_42243__$1 = state_42243;
var statearr_42250_43688 = state_42243__$1;
(statearr_42250_43688[(2)] = null);

(statearr_42250_43688[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (6))){
var inst_42222 = (state_42243[(7)]);
var state_42243__$1 = state_42243;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42243__$1,(11),to,inst_42222);
} else {
if((state_val_42244 === (3))){
var inst_42241 = (state_42243[(2)]);
var state_42243__$1 = state_42243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42243__$1,inst_42241);
} else {
if((state_val_42244 === (12))){
var state_42243__$1 = state_42243;
var statearr_42251_43689 = state_42243__$1;
(statearr_42251_43689[(2)] = null);

(statearr_42251_43689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (2))){
var state_42243__$1 = state_42243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42243__$1,(4),from);
} else {
if((state_val_42244 === (11))){
var inst_42232 = (state_42243[(2)]);
var state_42243__$1 = state_42243;
if(cljs.core.truth_(inst_42232)){
var statearr_42252_43690 = state_42243__$1;
(statearr_42252_43690[(1)] = (12));

} else {
var statearr_42253_43691 = state_42243__$1;
(statearr_42253_43691[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (9))){
var state_42243__$1 = state_42243;
var statearr_42254_43692 = state_42243__$1;
(statearr_42254_43692[(2)] = null);

(statearr_42254_43692[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (5))){
var state_42243__$1 = state_42243;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42255_43693 = state_42243__$1;
(statearr_42255_43693[(1)] = (8));

} else {
var statearr_42256_43694 = state_42243__$1;
(statearr_42256_43694[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (14))){
var inst_42237 = (state_42243[(2)]);
var state_42243__$1 = state_42243;
var statearr_42257_43695 = state_42243__$1;
(statearr_42257_43695[(2)] = inst_42237);

(statearr_42257_43695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (10))){
var inst_42229 = (state_42243[(2)]);
var state_42243__$1 = state_42243;
var statearr_42258_43696 = state_42243__$1;
(statearr_42258_43696[(2)] = inst_42229);

(statearr_42258_43696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42244 === (8))){
var inst_42226 = cljs.core.async.close_BANG_(to);
var state_42243__$1 = state_42243;
var statearr_42259_43697 = state_42243__$1;
(statearr_42259_43697[(2)] = inst_42226);

(statearr_42259_43697[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_42260 = [null,null,null,null,null,null,null,null];
(statearr_42260[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_42260[(1)] = (1));

return statearr_42260;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_42243){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42243);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42261){if((e42261 instanceof Object)){
var ex__42066__auto__ = e42261;
var statearr_42262_43698 = state_42243;
(statearr_42262_43698[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42261;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43699 = state_42243;
state_42243 = G__43699;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_42243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_42243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42263 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42263[(6)] = c__42130__auto___43683);

return statearr_42263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__42264){
var vec__42265 = p__42264;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42265,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42265,(1),null);
var job = vec__42265;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__42130__auto___43700 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42272){
var state_val_42273 = (state_42272[(1)]);
if((state_val_42273 === (1))){
var state_42272__$1 = state_42272;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42272__$1,(2),res,v);
} else {
if((state_val_42273 === (2))){
var inst_42269 = (state_42272[(2)]);
var inst_42270 = cljs.core.async.close_BANG_(res);
var state_42272__$1 = (function (){var statearr_42274 = state_42272;
(statearr_42274[(7)] = inst_42269);

return statearr_42274;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42272__$1,inst_42270);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_42275 = [null,null,null,null,null,null,null,null];
(statearr_42275[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__);

(statearr_42275[(1)] = (1));

return statearr_42275;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1 = (function (state_42272){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42272);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42276){if((e42276 instanceof Object)){
var ex__42066__auto__ = e42276;
var statearr_42277_43701 = state_42272;
(statearr_42277_43701[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42272);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42276;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43702 = state_42272;
state_42272 = G__43702;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = function(state_42272){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1.call(this,state_42272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42278 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42278[(6)] = c__42130__auto___43700);

return statearr_42278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__42279){
var vec__42280 = p__42279;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42280,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42280,(1),null);
var job = vec__42280;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4666__auto___43703 = n;
var __43704 = (0);
while(true){
if((__43704 < n__4666__auto___43703)){
var G__42283_43705 = type;
var G__42283_43706__$1 = (((G__42283_43705 instanceof cljs.core.Keyword))?G__42283_43705.fqn:null);
switch (G__42283_43706__$1) {
case "compute":
var c__42130__auto___43708 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__43704,c__42130__auto___43708,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async){
return (function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = ((function (__43704,c__42130__auto___43708,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async){
return (function (state_42296){
var state_val_42297 = (state_42296[(1)]);
if((state_val_42297 === (1))){
var state_42296__$1 = state_42296;
var statearr_42298_43709 = state_42296__$1;
(statearr_42298_43709[(2)] = null);

(statearr_42298_43709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42297 === (2))){
var state_42296__$1 = state_42296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42296__$1,(4),jobs);
} else {
if((state_val_42297 === (3))){
var inst_42294 = (state_42296[(2)]);
var state_42296__$1 = state_42296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42296__$1,inst_42294);
} else {
if((state_val_42297 === (4))){
var inst_42286 = (state_42296[(2)]);
var inst_42287 = process(inst_42286);
var state_42296__$1 = state_42296;
if(cljs.core.truth_(inst_42287)){
var statearr_42299_43710 = state_42296__$1;
(statearr_42299_43710[(1)] = (5));

} else {
var statearr_42300_43711 = state_42296__$1;
(statearr_42300_43711[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42297 === (5))){
var state_42296__$1 = state_42296;
var statearr_42301_43712 = state_42296__$1;
(statearr_42301_43712[(2)] = null);

(statearr_42301_43712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42297 === (6))){
var state_42296__$1 = state_42296;
var statearr_42302_43713 = state_42296__$1;
(statearr_42302_43713[(2)] = null);

(statearr_42302_43713[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42297 === (7))){
var inst_42292 = (state_42296[(2)]);
var state_42296__$1 = state_42296;
var statearr_42303_43714 = state_42296__$1;
(statearr_42303_43714[(2)] = inst_42292);

(statearr_42303_43714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43704,c__42130__auto___43708,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async))
;
return ((function (__43704,switch__42062__auto__,c__42130__auto___43708,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_42304 = [null,null,null,null,null,null,null];
(statearr_42304[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__);

(statearr_42304[(1)] = (1));

return statearr_42304;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1 = (function (state_42296){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42296);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42305){if((e42305 instanceof Object)){
var ex__42066__auto__ = e42305;
var statearr_42306_43715 = state_42296;
(statearr_42306_43715[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42305;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43716 = state_42296;
state_42296 = G__43716;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = function(state_42296){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1.call(this,state_42296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__;
})()
;})(__43704,switch__42062__auto__,c__42130__auto___43708,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async))
})();
var state__42132__auto__ = (function (){var statearr_42307 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42307[(6)] = c__42130__auto___43708);

return statearr_42307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
});})(__43704,c__42130__auto___43708,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async))
);


break;
case "async":
var c__42130__auto___43717 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__43704,c__42130__auto___43717,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async){
return (function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = ((function (__43704,c__42130__auto___43717,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async){
return (function (state_42320){
var state_val_42321 = (state_42320[(1)]);
if((state_val_42321 === (1))){
var state_42320__$1 = state_42320;
var statearr_42322_43718 = state_42320__$1;
(statearr_42322_43718[(2)] = null);

(statearr_42322_43718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42321 === (2))){
var state_42320__$1 = state_42320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42320__$1,(4),jobs);
} else {
if((state_val_42321 === (3))){
var inst_42318 = (state_42320[(2)]);
var state_42320__$1 = state_42320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42320__$1,inst_42318);
} else {
if((state_val_42321 === (4))){
var inst_42310 = (state_42320[(2)]);
var inst_42311 = async(inst_42310);
var state_42320__$1 = state_42320;
if(cljs.core.truth_(inst_42311)){
var statearr_42323_43719 = state_42320__$1;
(statearr_42323_43719[(1)] = (5));

} else {
var statearr_42324_43720 = state_42320__$1;
(statearr_42324_43720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42321 === (5))){
var state_42320__$1 = state_42320;
var statearr_42325_43721 = state_42320__$1;
(statearr_42325_43721[(2)] = null);

(statearr_42325_43721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42321 === (6))){
var state_42320__$1 = state_42320;
var statearr_42326_43722 = state_42320__$1;
(statearr_42326_43722[(2)] = null);

(statearr_42326_43722[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42321 === (7))){
var inst_42316 = (state_42320[(2)]);
var state_42320__$1 = state_42320;
var statearr_42327_43723 = state_42320__$1;
(statearr_42327_43723[(2)] = inst_42316);

(statearr_42327_43723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43704,c__42130__auto___43717,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async))
;
return ((function (__43704,switch__42062__auto__,c__42130__auto___43717,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_42328 = [null,null,null,null,null,null,null];
(statearr_42328[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__);

(statearr_42328[(1)] = (1));

return statearr_42328;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1 = (function (state_42320){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42320);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42329){if((e42329 instanceof Object)){
var ex__42066__auto__ = e42329;
var statearr_42330_43725 = state_42320;
(statearr_42330_43725[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42320);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42329;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43726 = state_42320;
state_42320 = G__43726;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = function(state_42320){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1.call(this,state_42320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__;
})()
;})(__43704,switch__42062__auto__,c__42130__auto___43717,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async))
})();
var state__42132__auto__ = (function (){var statearr_42331 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42331[(6)] = c__42130__auto___43717);

return statearr_42331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
});})(__43704,c__42130__auto___43717,G__42283_43705,G__42283_43706__$1,n__4666__auto___43703,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42283_43706__$1)].join('')));

}

var G__43734 = (__43704 + (1));
__43704 = G__43734;
continue;
} else {
}
break;
}

var c__42130__auto___43735 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42353){
var state_val_42354 = (state_42353[(1)]);
if((state_val_42354 === (7))){
var inst_42349 = (state_42353[(2)]);
var state_42353__$1 = state_42353;
var statearr_42355_43737 = state_42353__$1;
(statearr_42355_43737[(2)] = inst_42349);

(statearr_42355_43737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42354 === (1))){
var state_42353__$1 = state_42353;
var statearr_42356_43738 = state_42353__$1;
(statearr_42356_43738[(2)] = null);

(statearr_42356_43738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42354 === (4))){
var inst_42334 = (state_42353[(7)]);
var inst_42334__$1 = (state_42353[(2)]);
var inst_42335 = (inst_42334__$1 == null);
var state_42353__$1 = (function (){var statearr_42357 = state_42353;
(statearr_42357[(7)] = inst_42334__$1);

return statearr_42357;
})();
if(cljs.core.truth_(inst_42335)){
var statearr_42358_43739 = state_42353__$1;
(statearr_42358_43739[(1)] = (5));

} else {
var statearr_42359_43740 = state_42353__$1;
(statearr_42359_43740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42354 === (6))){
var inst_42334 = (state_42353[(7)]);
var inst_42339 = (state_42353[(8)]);
var inst_42339__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_42340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42341 = [inst_42334,inst_42339__$1];
var inst_42342 = (new cljs.core.PersistentVector(null,2,(5),inst_42340,inst_42341,null));
var state_42353__$1 = (function (){var statearr_42360 = state_42353;
(statearr_42360[(8)] = inst_42339__$1);

return statearr_42360;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42353__$1,(8),jobs,inst_42342);
} else {
if((state_val_42354 === (3))){
var inst_42351 = (state_42353[(2)]);
var state_42353__$1 = state_42353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42353__$1,inst_42351);
} else {
if((state_val_42354 === (2))){
var state_42353__$1 = state_42353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42353__$1,(4),from);
} else {
if((state_val_42354 === (9))){
var inst_42346 = (state_42353[(2)]);
var state_42353__$1 = (function (){var statearr_42361 = state_42353;
(statearr_42361[(9)] = inst_42346);

return statearr_42361;
})();
var statearr_42362_43744 = state_42353__$1;
(statearr_42362_43744[(2)] = null);

(statearr_42362_43744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42354 === (5))){
var inst_42337 = cljs.core.async.close_BANG_(jobs);
var state_42353__$1 = state_42353;
var statearr_42363_43745 = state_42353__$1;
(statearr_42363_43745[(2)] = inst_42337);

(statearr_42363_43745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42354 === (8))){
var inst_42339 = (state_42353[(8)]);
var inst_42344 = (state_42353[(2)]);
var state_42353__$1 = (function (){var statearr_42364 = state_42353;
(statearr_42364[(10)] = inst_42344);

return statearr_42364;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42353__$1,(9),results,inst_42339);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_42365 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42365[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__);

(statearr_42365[(1)] = (1));

return statearr_42365;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1 = (function (state_42353){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42353);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42366){if((e42366 instanceof Object)){
var ex__42066__auto__ = e42366;
var statearr_42367_43746 = state_42353;
(statearr_42367_43746[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42366;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43747 = state_42353;
state_42353 = G__43747;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = function(state_42353){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1.call(this,state_42353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42368 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42368[(6)] = c__42130__auto___43735);

return statearr_42368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42406){
var state_val_42407 = (state_42406[(1)]);
if((state_val_42407 === (7))){
var inst_42402 = (state_42406[(2)]);
var state_42406__$1 = state_42406;
var statearr_42408_43748 = state_42406__$1;
(statearr_42408_43748[(2)] = inst_42402);

(statearr_42408_43748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (20))){
var state_42406__$1 = state_42406;
var statearr_42409_43749 = state_42406__$1;
(statearr_42409_43749[(2)] = null);

(statearr_42409_43749[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (1))){
var state_42406__$1 = state_42406;
var statearr_42410_43750 = state_42406__$1;
(statearr_42410_43750[(2)] = null);

(statearr_42410_43750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (4))){
var inst_42371 = (state_42406[(7)]);
var inst_42371__$1 = (state_42406[(2)]);
var inst_42372 = (inst_42371__$1 == null);
var state_42406__$1 = (function (){var statearr_42411 = state_42406;
(statearr_42411[(7)] = inst_42371__$1);

return statearr_42411;
})();
if(cljs.core.truth_(inst_42372)){
var statearr_42412_43751 = state_42406__$1;
(statearr_42412_43751[(1)] = (5));

} else {
var statearr_42413_43752 = state_42406__$1;
(statearr_42413_43752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (15))){
var inst_42384 = (state_42406[(8)]);
var state_42406__$1 = state_42406;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42406__$1,(18),to,inst_42384);
} else {
if((state_val_42407 === (21))){
var inst_42397 = (state_42406[(2)]);
var state_42406__$1 = state_42406;
var statearr_42414_43753 = state_42406__$1;
(statearr_42414_43753[(2)] = inst_42397);

(statearr_42414_43753[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (13))){
var inst_42399 = (state_42406[(2)]);
var state_42406__$1 = (function (){var statearr_42415 = state_42406;
(statearr_42415[(9)] = inst_42399);

return statearr_42415;
})();
var statearr_42416_43754 = state_42406__$1;
(statearr_42416_43754[(2)] = null);

(statearr_42416_43754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (6))){
var inst_42371 = (state_42406[(7)]);
var state_42406__$1 = state_42406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42406__$1,(11),inst_42371);
} else {
if((state_val_42407 === (17))){
var inst_42392 = (state_42406[(2)]);
var state_42406__$1 = state_42406;
if(cljs.core.truth_(inst_42392)){
var statearr_42417_43755 = state_42406__$1;
(statearr_42417_43755[(1)] = (19));

} else {
var statearr_42418_43756 = state_42406__$1;
(statearr_42418_43756[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (3))){
var inst_42404 = (state_42406[(2)]);
var state_42406__$1 = state_42406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42406__$1,inst_42404);
} else {
if((state_val_42407 === (12))){
var inst_42381 = (state_42406[(10)]);
var state_42406__$1 = state_42406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42406__$1,(14),inst_42381);
} else {
if((state_val_42407 === (2))){
var state_42406__$1 = state_42406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42406__$1,(4),results);
} else {
if((state_val_42407 === (19))){
var state_42406__$1 = state_42406;
var statearr_42419_43757 = state_42406__$1;
(statearr_42419_43757[(2)] = null);

(statearr_42419_43757[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (11))){
var inst_42381 = (state_42406[(2)]);
var state_42406__$1 = (function (){var statearr_42420 = state_42406;
(statearr_42420[(10)] = inst_42381);

return statearr_42420;
})();
var statearr_42421_43758 = state_42406__$1;
(statearr_42421_43758[(2)] = null);

(statearr_42421_43758[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (9))){
var state_42406__$1 = state_42406;
var statearr_42422_43759 = state_42406__$1;
(statearr_42422_43759[(2)] = null);

(statearr_42422_43759[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (5))){
var state_42406__$1 = state_42406;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42423_43760 = state_42406__$1;
(statearr_42423_43760[(1)] = (8));

} else {
var statearr_42424_43761 = state_42406__$1;
(statearr_42424_43761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (14))){
var inst_42384 = (state_42406[(8)]);
var inst_42384__$1 = (state_42406[(2)]);
var inst_42385 = (inst_42384__$1 == null);
var inst_42386 = cljs.core.not(inst_42385);
var state_42406__$1 = (function (){var statearr_42425 = state_42406;
(statearr_42425[(8)] = inst_42384__$1);

return statearr_42425;
})();
if(inst_42386){
var statearr_42426_43762 = state_42406__$1;
(statearr_42426_43762[(1)] = (15));

} else {
var statearr_42427_43763 = state_42406__$1;
(statearr_42427_43763[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (16))){
var state_42406__$1 = state_42406;
var statearr_42428_43764 = state_42406__$1;
(statearr_42428_43764[(2)] = false);

(statearr_42428_43764[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (10))){
var inst_42378 = (state_42406[(2)]);
var state_42406__$1 = state_42406;
var statearr_42429_43765 = state_42406__$1;
(statearr_42429_43765[(2)] = inst_42378);

(statearr_42429_43765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (18))){
var inst_42389 = (state_42406[(2)]);
var state_42406__$1 = state_42406;
var statearr_42430_43766 = state_42406__$1;
(statearr_42430_43766[(2)] = inst_42389);

(statearr_42430_43766[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42407 === (8))){
var inst_42375 = cljs.core.async.close_BANG_(to);
var state_42406__$1 = state_42406;
var statearr_42431_43767 = state_42406__$1;
(statearr_42431_43767[(2)] = inst_42375);

(statearr_42431_43767[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_42432 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42432[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__);

(statearr_42432[(1)] = (1));

return statearr_42432;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1 = (function (state_42406){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42406);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42433){if((e42433 instanceof Object)){
var ex__42066__auto__ = e42433;
var statearr_42434_43768 = state_42406;
(statearr_42434_43768[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42406);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42433;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43769 = state_42406;
state_42406 = G__43769;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__ = function(state_42406){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1.call(this,state_42406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42063__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42435 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42435[(6)] = c__42130__auto__);

return statearr_42435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__42437 = arguments.length;
switch (G__42437) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__42439 = arguments.length;
switch (G__42439) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__42441 = arguments.length;
switch (G__42441) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__42130__auto___43775 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42467){
var state_val_42468 = (state_42467[(1)]);
if((state_val_42468 === (7))){
var inst_42463 = (state_42467[(2)]);
var state_42467__$1 = state_42467;
var statearr_42469_43777 = state_42467__$1;
(statearr_42469_43777[(2)] = inst_42463);

(statearr_42469_43777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (1))){
var state_42467__$1 = state_42467;
var statearr_42470_43780 = state_42467__$1;
(statearr_42470_43780[(2)] = null);

(statearr_42470_43780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (4))){
var inst_42444 = (state_42467[(7)]);
var inst_42444__$1 = (state_42467[(2)]);
var inst_42445 = (inst_42444__$1 == null);
var state_42467__$1 = (function (){var statearr_42471 = state_42467;
(statearr_42471[(7)] = inst_42444__$1);

return statearr_42471;
})();
if(cljs.core.truth_(inst_42445)){
var statearr_42472_43782 = state_42467__$1;
(statearr_42472_43782[(1)] = (5));

} else {
var statearr_42473_43783 = state_42467__$1;
(statearr_42473_43783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (13))){
var state_42467__$1 = state_42467;
var statearr_42474_43784 = state_42467__$1;
(statearr_42474_43784[(2)] = null);

(statearr_42474_43784[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (6))){
var inst_42444 = (state_42467[(7)]);
var inst_42450 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_42444) : p.call(null,inst_42444));
var state_42467__$1 = state_42467;
if(cljs.core.truth_(inst_42450)){
var statearr_42475_43788 = state_42467__$1;
(statearr_42475_43788[(1)] = (9));

} else {
var statearr_42476_43790 = state_42467__$1;
(statearr_42476_43790[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (3))){
var inst_42465 = (state_42467[(2)]);
var state_42467__$1 = state_42467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42467__$1,inst_42465);
} else {
if((state_val_42468 === (12))){
var state_42467__$1 = state_42467;
var statearr_42477_43791 = state_42467__$1;
(statearr_42477_43791[(2)] = null);

(statearr_42477_43791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (2))){
var state_42467__$1 = state_42467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42467__$1,(4),ch);
} else {
if((state_val_42468 === (11))){
var inst_42444 = (state_42467[(7)]);
var inst_42454 = (state_42467[(2)]);
var state_42467__$1 = state_42467;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42467__$1,(8),inst_42454,inst_42444);
} else {
if((state_val_42468 === (9))){
var state_42467__$1 = state_42467;
var statearr_42478_43795 = state_42467__$1;
(statearr_42478_43795[(2)] = tc);

(statearr_42478_43795[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (5))){
var inst_42447 = cljs.core.async.close_BANG_(tc);
var inst_42448 = cljs.core.async.close_BANG_(fc);
var state_42467__$1 = (function (){var statearr_42479 = state_42467;
(statearr_42479[(8)] = inst_42447);

return statearr_42479;
})();
var statearr_42480_43798 = state_42467__$1;
(statearr_42480_43798[(2)] = inst_42448);

(statearr_42480_43798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (14))){
var inst_42461 = (state_42467[(2)]);
var state_42467__$1 = state_42467;
var statearr_42481_43801 = state_42467__$1;
(statearr_42481_43801[(2)] = inst_42461);

(statearr_42481_43801[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (10))){
var state_42467__$1 = state_42467;
var statearr_42482_43804 = state_42467__$1;
(statearr_42482_43804[(2)] = fc);

(statearr_42482_43804[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42468 === (8))){
var inst_42456 = (state_42467[(2)]);
var state_42467__$1 = state_42467;
if(cljs.core.truth_(inst_42456)){
var statearr_42483_43805 = state_42467__$1;
(statearr_42483_43805[(1)] = (12));

} else {
var statearr_42484_43806 = state_42467__$1;
(statearr_42484_43806[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_42485 = [null,null,null,null,null,null,null,null,null];
(statearr_42485[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_42485[(1)] = (1));

return statearr_42485;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_42467){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42467);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42486){if((e42486 instanceof Object)){
var ex__42066__auto__ = e42486;
var statearr_42487_43807 = state_42467;
(statearr_42487_43807[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42467);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42486;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43808 = state_42467;
state_42467 = G__43808;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_42467){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_42467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42488 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42488[(6)] = c__42130__auto___43775);

return statearr_42488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42509){
var state_val_42510 = (state_42509[(1)]);
if((state_val_42510 === (7))){
var inst_42505 = (state_42509[(2)]);
var state_42509__$1 = state_42509;
var statearr_42511_43811 = state_42509__$1;
(statearr_42511_43811[(2)] = inst_42505);

(statearr_42511_43811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (1))){
var inst_42489 = init;
var state_42509__$1 = (function (){var statearr_42512 = state_42509;
(statearr_42512[(7)] = inst_42489);

return statearr_42512;
})();
var statearr_42513_43812 = state_42509__$1;
(statearr_42513_43812[(2)] = null);

(statearr_42513_43812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (4))){
var inst_42492 = (state_42509[(8)]);
var inst_42492__$1 = (state_42509[(2)]);
var inst_42493 = (inst_42492__$1 == null);
var state_42509__$1 = (function (){var statearr_42514 = state_42509;
(statearr_42514[(8)] = inst_42492__$1);

return statearr_42514;
})();
if(cljs.core.truth_(inst_42493)){
var statearr_42515_43814 = state_42509__$1;
(statearr_42515_43814[(1)] = (5));

} else {
var statearr_42516_43815 = state_42509__$1;
(statearr_42516_43815[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (6))){
var inst_42489 = (state_42509[(7)]);
var inst_42492 = (state_42509[(8)]);
var inst_42496 = (state_42509[(9)]);
var inst_42496__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_42489,inst_42492) : f.call(null,inst_42489,inst_42492));
var inst_42497 = cljs.core.reduced_QMARK_(inst_42496__$1);
var state_42509__$1 = (function (){var statearr_42517 = state_42509;
(statearr_42517[(9)] = inst_42496__$1);

return statearr_42517;
})();
if(inst_42497){
var statearr_42518_43816 = state_42509__$1;
(statearr_42518_43816[(1)] = (8));

} else {
var statearr_42519_43817 = state_42509__$1;
(statearr_42519_43817[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (3))){
var inst_42507 = (state_42509[(2)]);
var state_42509__$1 = state_42509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42509__$1,inst_42507);
} else {
if((state_val_42510 === (2))){
var state_42509__$1 = state_42509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42509__$1,(4),ch);
} else {
if((state_val_42510 === (9))){
var inst_42496 = (state_42509[(9)]);
var inst_42489 = inst_42496;
var state_42509__$1 = (function (){var statearr_42520 = state_42509;
(statearr_42520[(7)] = inst_42489);

return statearr_42520;
})();
var statearr_42521_43820 = state_42509__$1;
(statearr_42521_43820[(2)] = null);

(statearr_42521_43820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (5))){
var inst_42489 = (state_42509[(7)]);
var state_42509__$1 = state_42509;
var statearr_42522_43822 = state_42509__$1;
(statearr_42522_43822[(2)] = inst_42489);

(statearr_42522_43822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (10))){
var inst_42503 = (state_42509[(2)]);
var state_42509__$1 = state_42509;
var statearr_42523_43823 = state_42509__$1;
(statearr_42523_43823[(2)] = inst_42503);

(statearr_42523_43823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42510 === (8))){
var inst_42496 = (state_42509[(9)]);
var inst_42499 = cljs.core.deref(inst_42496);
var state_42509__$1 = state_42509;
var statearr_42524_43824 = state_42509__$1;
(statearr_42524_43824[(2)] = inst_42499);

(statearr_42524_43824[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__42063__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42063__auto____0 = (function (){
var statearr_42525 = [null,null,null,null,null,null,null,null,null,null];
(statearr_42525[(0)] = cljs$core$async$reduce_$_state_machine__42063__auto__);

(statearr_42525[(1)] = (1));

return statearr_42525;
});
var cljs$core$async$reduce_$_state_machine__42063__auto____1 = (function (state_42509){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42509);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42526){if((e42526 instanceof Object)){
var ex__42066__auto__ = e42526;
var statearr_42527_43826 = state_42509;
(statearr_42527_43826[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42509);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42526;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43827 = state_42509;
state_42509 = G__43827;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42063__auto__ = function(state_42509){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42063__auto____1.call(this,state_42509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42063__auto____0;
cljs$core$async$reduce_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42063__auto____1;
return cljs$core$async$reduce_$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42528 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42528[(6)] = c__42130__auto__);

return statearr_42528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42534){
var state_val_42535 = (state_42534[(1)]);
if((state_val_42535 === (1))){
var inst_42529 = cljs.core.async.reduce(f__$1,init,ch);
var state_42534__$1 = state_42534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42534__$1,(2),inst_42529);
} else {
if((state_val_42535 === (2))){
var inst_42531 = (state_42534[(2)]);
var inst_42532 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_42531) : f__$1.call(null,inst_42531));
var state_42534__$1 = state_42534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42534__$1,inst_42532);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__42063__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42063__auto____0 = (function (){
var statearr_42536 = [null,null,null,null,null,null,null];
(statearr_42536[(0)] = cljs$core$async$transduce_$_state_machine__42063__auto__);

(statearr_42536[(1)] = (1));

return statearr_42536;
});
var cljs$core$async$transduce_$_state_machine__42063__auto____1 = (function (state_42534){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42534);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42537){if((e42537 instanceof Object)){
var ex__42066__auto__ = e42537;
var statearr_42538_43828 = state_42534;
(statearr_42538_43828[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42534);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42537;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43829 = state_42534;
state_42534 = G__43829;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42063__auto__ = function(state_42534){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42063__auto____1.call(this,state_42534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42063__auto____0;
cljs$core$async$transduce_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42063__auto____1;
return cljs$core$async$transduce_$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42539 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42539[(6)] = c__42130__auto__);

return statearr_42539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__42541 = arguments.length;
switch (G__42541) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42566){
var state_val_42567 = (state_42566[(1)]);
if((state_val_42567 === (7))){
var inst_42548 = (state_42566[(2)]);
var state_42566__$1 = state_42566;
var statearr_42568_43831 = state_42566__$1;
(statearr_42568_43831[(2)] = inst_42548);

(statearr_42568_43831[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (1))){
var inst_42542 = cljs.core.seq(coll);
var inst_42543 = inst_42542;
var state_42566__$1 = (function (){var statearr_42569 = state_42566;
(statearr_42569[(7)] = inst_42543);

return statearr_42569;
})();
var statearr_42570_43832 = state_42566__$1;
(statearr_42570_43832[(2)] = null);

(statearr_42570_43832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (4))){
var inst_42543 = (state_42566[(7)]);
var inst_42546 = cljs.core.first(inst_42543);
var state_42566__$1 = state_42566;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42566__$1,(7),ch,inst_42546);
} else {
if((state_val_42567 === (13))){
var inst_42560 = (state_42566[(2)]);
var state_42566__$1 = state_42566;
var statearr_42571_43833 = state_42566__$1;
(statearr_42571_43833[(2)] = inst_42560);

(statearr_42571_43833[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (6))){
var inst_42551 = (state_42566[(2)]);
var state_42566__$1 = state_42566;
if(cljs.core.truth_(inst_42551)){
var statearr_42572_43834 = state_42566__$1;
(statearr_42572_43834[(1)] = (8));

} else {
var statearr_42573_43835 = state_42566__$1;
(statearr_42573_43835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (3))){
var inst_42564 = (state_42566[(2)]);
var state_42566__$1 = state_42566;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42566__$1,inst_42564);
} else {
if((state_val_42567 === (12))){
var state_42566__$1 = state_42566;
var statearr_42574_43836 = state_42566__$1;
(statearr_42574_43836[(2)] = null);

(statearr_42574_43836[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (2))){
var inst_42543 = (state_42566[(7)]);
var state_42566__$1 = state_42566;
if(cljs.core.truth_(inst_42543)){
var statearr_42575_43837 = state_42566__$1;
(statearr_42575_43837[(1)] = (4));

} else {
var statearr_42576_43838 = state_42566__$1;
(statearr_42576_43838[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (11))){
var inst_42557 = cljs.core.async.close_BANG_(ch);
var state_42566__$1 = state_42566;
var statearr_42577_43839 = state_42566__$1;
(statearr_42577_43839[(2)] = inst_42557);

(statearr_42577_43839[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (9))){
var state_42566__$1 = state_42566;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42578_43840 = state_42566__$1;
(statearr_42578_43840[(1)] = (11));

} else {
var statearr_42579_43841 = state_42566__$1;
(statearr_42579_43841[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (5))){
var inst_42543 = (state_42566[(7)]);
var state_42566__$1 = state_42566;
var statearr_42580_43842 = state_42566__$1;
(statearr_42580_43842[(2)] = inst_42543);

(statearr_42580_43842[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (10))){
var inst_42562 = (state_42566[(2)]);
var state_42566__$1 = state_42566;
var statearr_42581_43843 = state_42566__$1;
(statearr_42581_43843[(2)] = inst_42562);

(statearr_42581_43843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42567 === (8))){
var inst_42543 = (state_42566[(7)]);
var inst_42553 = cljs.core.next(inst_42543);
var inst_42543__$1 = inst_42553;
var state_42566__$1 = (function (){var statearr_42582 = state_42566;
(statearr_42582[(7)] = inst_42543__$1);

return statearr_42582;
})();
var statearr_42583_43844 = state_42566__$1;
(statearr_42583_43844[(2)] = null);

(statearr_42583_43844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_42584 = [null,null,null,null,null,null,null,null];
(statearr_42584[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_42584[(1)] = (1));

return statearr_42584;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_42566){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42566);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42585){if((e42585 instanceof Object)){
var ex__42066__auto__ = e42585;
var statearr_42586_43845 = state_42566;
(statearr_42586_43845[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42566);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42585;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43846 = state_42566;
state_42566 = G__43846;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_42566){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_42566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42587 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42587[(6)] = c__42130__auto__);

return statearr_42587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4487__auto__ = (((_ == null))?null:_);
var m__4488__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4488__auto__.call(null,_));
} else {
var m__4485__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4485__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4488__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4485__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42588 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42588 = (function (ch,cs,meta42589){
this.ch = ch;
this.cs = cs;
this.meta42589 = meta42589;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42590,meta42589__$1){
var self__ = this;
var _42590__$1 = this;
return (new cljs.core.async.t_cljs$core$async42588(self__.ch,self__.cs,meta42589__$1));
}));

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42590){
var self__ = this;
var _42590__$1 = this;
return self__.meta42589;
}));

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async42588.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async42588.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta42589","meta42589",-1432578090,null)], null);
}));

(cljs.core.async.t_cljs$core$async42588.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42588.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42588");

(cljs.core.async.t_cljs$core$async42588.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async42588");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42588.
 */
cljs.core.async.__GT_t_cljs$core$async42588 = (function cljs$core$async$mult_$___GT_t_cljs$core$async42588(ch__$1,cs__$1,meta42589){
return (new cljs.core.async.t_cljs$core$async42588(ch__$1,cs__$1,meta42589));
});

}

return (new cljs.core.async.t_cljs$core$async42588(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__42130__auto___43852 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42725){
var state_val_42726 = (state_42725[(1)]);
if((state_val_42726 === (7))){
var inst_42721 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42727_43853 = state_42725__$1;
(statearr_42727_43853[(2)] = inst_42721);

(statearr_42727_43853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (20))){
var inst_42624 = (state_42725[(7)]);
var inst_42636 = cljs.core.first(inst_42624);
var inst_42637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42636,(0),null);
var inst_42638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42636,(1),null);
var state_42725__$1 = (function (){var statearr_42728 = state_42725;
(statearr_42728[(8)] = inst_42637);

return statearr_42728;
})();
if(cljs.core.truth_(inst_42638)){
var statearr_42729_43854 = state_42725__$1;
(statearr_42729_43854[(1)] = (22));

} else {
var statearr_42730_43855 = state_42725__$1;
(statearr_42730_43855[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (27))){
var inst_42593 = (state_42725[(9)]);
var inst_42666 = (state_42725[(10)]);
var inst_42668 = (state_42725[(11)]);
var inst_42673 = (state_42725[(12)]);
var inst_42673__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_42666,inst_42668);
var inst_42674 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_42673__$1,inst_42593,done);
var state_42725__$1 = (function (){var statearr_42731 = state_42725;
(statearr_42731[(12)] = inst_42673__$1);

return statearr_42731;
})();
if(cljs.core.truth_(inst_42674)){
var statearr_42732_43856 = state_42725__$1;
(statearr_42732_43856[(1)] = (30));

} else {
var statearr_42733_43857 = state_42725__$1;
(statearr_42733_43857[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (1))){
var state_42725__$1 = state_42725;
var statearr_42734_43858 = state_42725__$1;
(statearr_42734_43858[(2)] = null);

(statearr_42734_43858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (24))){
var inst_42624 = (state_42725[(7)]);
var inst_42643 = (state_42725[(2)]);
var inst_42644 = cljs.core.next(inst_42624);
var inst_42602 = inst_42644;
var inst_42603 = null;
var inst_42604 = (0);
var inst_42605 = (0);
var state_42725__$1 = (function (){var statearr_42735 = state_42725;
(statearr_42735[(13)] = inst_42643);

(statearr_42735[(14)] = inst_42603);

(statearr_42735[(15)] = inst_42602);

(statearr_42735[(16)] = inst_42604);

(statearr_42735[(17)] = inst_42605);

return statearr_42735;
})();
var statearr_42736_43859 = state_42725__$1;
(statearr_42736_43859[(2)] = null);

(statearr_42736_43859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (39))){
var state_42725__$1 = state_42725;
var statearr_42740_43860 = state_42725__$1;
(statearr_42740_43860[(2)] = null);

(statearr_42740_43860[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (4))){
var inst_42593 = (state_42725[(9)]);
var inst_42593__$1 = (state_42725[(2)]);
var inst_42594 = (inst_42593__$1 == null);
var state_42725__$1 = (function (){var statearr_42741 = state_42725;
(statearr_42741[(9)] = inst_42593__$1);

return statearr_42741;
})();
if(cljs.core.truth_(inst_42594)){
var statearr_42742_43861 = state_42725__$1;
(statearr_42742_43861[(1)] = (5));

} else {
var statearr_42743_43862 = state_42725__$1;
(statearr_42743_43862[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (15))){
var inst_42603 = (state_42725[(14)]);
var inst_42602 = (state_42725[(15)]);
var inst_42604 = (state_42725[(16)]);
var inst_42605 = (state_42725[(17)]);
var inst_42620 = (state_42725[(2)]);
var inst_42621 = (inst_42605 + (1));
var tmp42737 = inst_42603;
var tmp42738 = inst_42602;
var tmp42739 = inst_42604;
var inst_42602__$1 = tmp42738;
var inst_42603__$1 = tmp42737;
var inst_42604__$1 = tmp42739;
var inst_42605__$1 = inst_42621;
var state_42725__$1 = (function (){var statearr_42744 = state_42725;
(statearr_42744[(14)] = inst_42603__$1);

(statearr_42744[(15)] = inst_42602__$1);

(statearr_42744[(18)] = inst_42620);

(statearr_42744[(16)] = inst_42604__$1);

(statearr_42744[(17)] = inst_42605__$1);

return statearr_42744;
})();
var statearr_42745_43863 = state_42725__$1;
(statearr_42745_43863[(2)] = null);

(statearr_42745_43863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (21))){
var inst_42647 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42749_43865 = state_42725__$1;
(statearr_42749_43865[(2)] = inst_42647);

(statearr_42749_43865[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (31))){
var inst_42673 = (state_42725[(12)]);
var inst_42677 = done(null);
var inst_42678 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_42673);
var state_42725__$1 = (function (){var statearr_42750 = state_42725;
(statearr_42750[(19)] = inst_42677);

return statearr_42750;
})();
var statearr_42751_43866 = state_42725__$1;
(statearr_42751_43866[(2)] = inst_42678);

(statearr_42751_43866[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (32))){
var inst_42666 = (state_42725[(10)]);
var inst_42668 = (state_42725[(11)]);
var inst_42667 = (state_42725[(20)]);
var inst_42665 = (state_42725[(21)]);
var inst_42680 = (state_42725[(2)]);
var inst_42681 = (inst_42668 + (1));
var tmp42746 = inst_42666;
var tmp42747 = inst_42667;
var tmp42748 = inst_42665;
var inst_42665__$1 = tmp42748;
var inst_42666__$1 = tmp42746;
var inst_42667__$1 = tmp42747;
var inst_42668__$1 = inst_42681;
var state_42725__$1 = (function (){var statearr_42752 = state_42725;
(statearr_42752[(22)] = inst_42680);

(statearr_42752[(10)] = inst_42666__$1);

(statearr_42752[(11)] = inst_42668__$1);

(statearr_42752[(20)] = inst_42667__$1);

(statearr_42752[(21)] = inst_42665__$1);

return statearr_42752;
})();
var statearr_42753_43869 = state_42725__$1;
(statearr_42753_43869[(2)] = null);

(statearr_42753_43869[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (40))){
var inst_42693 = (state_42725[(23)]);
var inst_42697 = done(null);
var inst_42698 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_42693);
var state_42725__$1 = (function (){var statearr_42754 = state_42725;
(statearr_42754[(24)] = inst_42697);

return statearr_42754;
})();
var statearr_42755_43870 = state_42725__$1;
(statearr_42755_43870[(2)] = inst_42698);

(statearr_42755_43870[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (33))){
var inst_42684 = (state_42725[(25)]);
var inst_42686 = cljs.core.chunked_seq_QMARK_(inst_42684);
var state_42725__$1 = state_42725;
if(inst_42686){
var statearr_42756_43871 = state_42725__$1;
(statearr_42756_43871[(1)] = (36));

} else {
var statearr_42757_43872 = state_42725__$1;
(statearr_42757_43872[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (13))){
var inst_42614 = (state_42725[(26)]);
var inst_42617 = cljs.core.async.close_BANG_(inst_42614);
var state_42725__$1 = state_42725;
var statearr_42758_43873 = state_42725__$1;
(statearr_42758_43873[(2)] = inst_42617);

(statearr_42758_43873[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (22))){
var inst_42637 = (state_42725[(8)]);
var inst_42640 = cljs.core.async.close_BANG_(inst_42637);
var state_42725__$1 = state_42725;
var statearr_42759_43874 = state_42725__$1;
(statearr_42759_43874[(2)] = inst_42640);

(statearr_42759_43874[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (36))){
var inst_42684 = (state_42725[(25)]);
var inst_42688 = cljs.core.chunk_first(inst_42684);
var inst_42689 = cljs.core.chunk_rest(inst_42684);
var inst_42690 = cljs.core.count(inst_42688);
var inst_42665 = inst_42689;
var inst_42666 = inst_42688;
var inst_42667 = inst_42690;
var inst_42668 = (0);
var state_42725__$1 = (function (){var statearr_42760 = state_42725;
(statearr_42760[(10)] = inst_42666);

(statearr_42760[(11)] = inst_42668);

(statearr_42760[(20)] = inst_42667);

(statearr_42760[(21)] = inst_42665);

return statearr_42760;
})();
var statearr_42761_43875 = state_42725__$1;
(statearr_42761_43875[(2)] = null);

(statearr_42761_43875[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (41))){
var inst_42684 = (state_42725[(25)]);
var inst_42700 = (state_42725[(2)]);
var inst_42701 = cljs.core.next(inst_42684);
var inst_42665 = inst_42701;
var inst_42666 = null;
var inst_42667 = (0);
var inst_42668 = (0);
var state_42725__$1 = (function (){var statearr_42762 = state_42725;
(statearr_42762[(10)] = inst_42666);

(statearr_42762[(11)] = inst_42668);

(statearr_42762[(27)] = inst_42700);

(statearr_42762[(20)] = inst_42667);

(statearr_42762[(21)] = inst_42665);

return statearr_42762;
})();
var statearr_42763_43876 = state_42725__$1;
(statearr_42763_43876[(2)] = null);

(statearr_42763_43876[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (43))){
var state_42725__$1 = state_42725;
var statearr_42764_43877 = state_42725__$1;
(statearr_42764_43877[(2)] = null);

(statearr_42764_43877[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (29))){
var inst_42709 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42765_43878 = state_42725__$1;
(statearr_42765_43878[(2)] = inst_42709);

(statearr_42765_43878[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (44))){
var inst_42718 = (state_42725[(2)]);
var state_42725__$1 = (function (){var statearr_42766 = state_42725;
(statearr_42766[(28)] = inst_42718);

return statearr_42766;
})();
var statearr_42767_43879 = state_42725__$1;
(statearr_42767_43879[(2)] = null);

(statearr_42767_43879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (6))){
var inst_42657 = (state_42725[(29)]);
var inst_42656 = cljs.core.deref(cs);
var inst_42657__$1 = cljs.core.keys(inst_42656);
var inst_42658 = cljs.core.count(inst_42657__$1);
var inst_42659 = cljs.core.reset_BANG_(dctr,inst_42658);
var inst_42664 = cljs.core.seq(inst_42657__$1);
var inst_42665 = inst_42664;
var inst_42666 = null;
var inst_42667 = (0);
var inst_42668 = (0);
var state_42725__$1 = (function (){var statearr_42768 = state_42725;
(statearr_42768[(10)] = inst_42666);

(statearr_42768[(30)] = inst_42659);

(statearr_42768[(11)] = inst_42668);

(statearr_42768[(29)] = inst_42657__$1);

(statearr_42768[(20)] = inst_42667);

(statearr_42768[(21)] = inst_42665);

return statearr_42768;
})();
var statearr_42769_43880 = state_42725__$1;
(statearr_42769_43880[(2)] = null);

(statearr_42769_43880[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (28))){
var inst_42684 = (state_42725[(25)]);
var inst_42665 = (state_42725[(21)]);
var inst_42684__$1 = cljs.core.seq(inst_42665);
var state_42725__$1 = (function (){var statearr_42770 = state_42725;
(statearr_42770[(25)] = inst_42684__$1);

return statearr_42770;
})();
if(inst_42684__$1){
var statearr_42771_43881 = state_42725__$1;
(statearr_42771_43881[(1)] = (33));

} else {
var statearr_42772_43882 = state_42725__$1;
(statearr_42772_43882[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (25))){
var inst_42668 = (state_42725[(11)]);
var inst_42667 = (state_42725[(20)]);
var inst_42670 = (inst_42668 < inst_42667);
var inst_42671 = inst_42670;
var state_42725__$1 = state_42725;
if(cljs.core.truth_(inst_42671)){
var statearr_42773_43883 = state_42725__$1;
(statearr_42773_43883[(1)] = (27));

} else {
var statearr_42774_43884 = state_42725__$1;
(statearr_42774_43884[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (34))){
var state_42725__$1 = state_42725;
var statearr_42775_43885 = state_42725__$1;
(statearr_42775_43885[(2)] = null);

(statearr_42775_43885[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (17))){
var state_42725__$1 = state_42725;
var statearr_42776_43886 = state_42725__$1;
(statearr_42776_43886[(2)] = null);

(statearr_42776_43886[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (3))){
var inst_42723 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42725__$1,inst_42723);
} else {
if((state_val_42726 === (12))){
var inst_42652 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42777_43887 = state_42725__$1;
(statearr_42777_43887[(2)] = inst_42652);

(statearr_42777_43887[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (2))){
var state_42725__$1 = state_42725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42725__$1,(4),ch);
} else {
if((state_val_42726 === (23))){
var state_42725__$1 = state_42725;
var statearr_42778_43888 = state_42725__$1;
(statearr_42778_43888[(2)] = null);

(statearr_42778_43888[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (35))){
var inst_42707 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42779_43889 = state_42725__$1;
(statearr_42779_43889[(2)] = inst_42707);

(statearr_42779_43889[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (19))){
var inst_42624 = (state_42725[(7)]);
var inst_42628 = cljs.core.chunk_first(inst_42624);
var inst_42629 = cljs.core.chunk_rest(inst_42624);
var inst_42630 = cljs.core.count(inst_42628);
var inst_42602 = inst_42629;
var inst_42603 = inst_42628;
var inst_42604 = inst_42630;
var inst_42605 = (0);
var state_42725__$1 = (function (){var statearr_42780 = state_42725;
(statearr_42780[(14)] = inst_42603);

(statearr_42780[(15)] = inst_42602);

(statearr_42780[(16)] = inst_42604);

(statearr_42780[(17)] = inst_42605);

return statearr_42780;
})();
var statearr_42781_43890 = state_42725__$1;
(statearr_42781_43890[(2)] = null);

(statearr_42781_43890[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (11))){
var inst_42624 = (state_42725[(7)]);
var inst_42602 = (state_42725[(15)]);
var inst_42624__$1 = cljs.core.seq(inst_42602);
var state_42725__$1 = (function (){var statearr_42782 = state_42725;
(statearr_42782[(7)] = inst_42624__$1);

return statearr_42782;
})();
if(inst_42624__$1){
var statearr_42783_43891 = state_42725__$1;
(statearr_42783_43891[(1)] = (16));

} else {
var statearr_42784_43892 = state_42725__$1;
(statearr_42784_43892[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (9))){
var inst_42654 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42785_43893 = state_42725__$1;
(statearr_42785_43893[(2)] = inst_42654);

(statearr_42785_43893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (5))){
var inst_42600 = cljs.core.deref(cs);
var inst_42601 = cljs.core.seq(inst_42600);
var inst_42602 = inst_42601;
var inst_42603 = null;
var inst_42604 = (0);
var inst_42605 = (0);
var state_42725__$1 = (function (){var statearr_42786 = state_42725;
(statearr_42786[(14)] = inst_42603);

(statearr_42786[(15)] = inst_42602);

(statearr_42786[(16)] = inst_42604);

(statearr_42786[(17)] = inst_42605);

return statearr_42786;
})();
var statearr_42787_43894 = state_42725__$1;
(statearr_42787_43894[(2)] = null);

(statearr_42787_43894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (14))){
var state_42725__$1 = state_42725;
var statearr_42788_43895 = state_42725__$1;
(statearr_42788_43895[(2)] = null);

(statearr_42788_43895[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (45))){
var inst_42715 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42789_43896 = state_42725__$1;
(statearr_42789_43896[(2)] = inst_42715);

(statearr_42789_43896[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (26))){
var inst_42657 = (state_42725[(29)]);
var inst_42711 = (state_42725[(2)]);
var inst_42712 = cljs.core.seq(inst_42657);
var state_42725__$1 = (function (){var statearr_42790 = state_42725;
(statearr_42790[(31)] = inst_42711);

return statearr_42790;
})();
if(inst_42712){
var statearr_42791_43897 = state_42725__$1;
(statearr_42791_43897[(1)] = (42));

} else {
var statearr_42792_43898 = state_42725__$1;
(statearr_42792_43898[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (16))){
var inst_42624 = (state_42725[(7)]);
var inst_42626 = cljs.core.chunked_seq_QMARK_(inst_42624);
var state_42725__$1 = state_42725;
if(inst_42626){
var statearr_42793_43899 = state_42725__$1;
(statearr_42793_43899[(1)] = (19));

} else {
var statearr_42794_43900 = state_42725__$1;
(statearr_42794_43900[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (38))){
var inst_42704 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42795_43901 = state_42725__$1;
(statearr_42795_43901[(2)] = inst_42704);

(statearr_42795_43901[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (30))){
var state_42725__$1 = state_42725;
var statearr_42796_43902 = state_42725__$1;
(statearr_42796_43902[(2)] = null);

(statearr_42796_43902[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (10))){
var inst_42603 = (state_42725[(14)]);
var inst_42605 = (state_42725[(17)]);
var inst_42613 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_42603,inst_42605);
var inst_42614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42613,(0),null);
var inst_42615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42613,(1),null);
var state_42725__$1 = (function (){var statearr_42797 = state_42725;
(statearr_42797[(26)] = inst_42614);

return statearr_42797;
})();
if(cljs.core.truth_(inst_42615)){
var statearr_42798_43903 = state_42725__$1;
(statearr_42798_43903[(1)] = (13));

} else {
var statearr_42799_43904 = state_42725__$1;
(statearr_42799_43904[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (18))){
var inst_42650 = (state_42725[(2)]);
var state_42725__$1 = state_42725;
var statearr_42800_43905 = state_42725__$1;
(statearr_42800_43905[(2)] = inst_42650);

(statearr_42800_43905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (42))){
var state_42725__$1 = state_42725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42725__$1,(45),dchan);
} else {
if((state_val_42726 === (37))){
var inst_42593 = (state_42725[(9)]);
var inst_42684 = (state_42725[(25)]);
var inst_42693 = (state_42725[(23)]);
var inst_42693__$1 = cljs.core.first(inst_42684);
var inst_42694 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_42693__$1,inst_42593,done);
var state_42725__$1 = (function (){var statearr_42801 = state_42725;
(statearr_42801[(23)] = inst_42693__$1);

return statearr_42801;
})();
if(cljs.core.truth_(inst_42694)){
var statearr_42802_43906 = state_42725__$1;
(statearr_42802_43906[(1)] = (39));

} else {
var statearr_42803_43907 = state_42725__$1;
(statearr_42803_43907[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42726 === (8))){
var inst_42604 = (state_42725[(16)]);
var inst_42605 = (state_42725[(17)]);
var inst_42607 = (inst_42605 < inst_42604);
var inst_42608 = inst_42607;
var state_42725__$1 = state_42725;
if(cljs.core.truth_(inst_42608)){
var statearr_42804_43908 = state_42725__$1;
(statearr_42804_43908[(1)] = (10));

} else {
var statearr_42805_43909 = state_42725__$1;
(statearr_42805_43909[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__42063__auto__ = null;
var cljs$core$async$mult_$_state_machine__42063__auto____0 = (function (){
var statearr_42806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42806[(0)] = cljs$core$async$mult_$_state_machine__42063__auto__);

(statearr_42806[(1)] = (1));

return statearr_42806;
});
var cljs$core$async$mult_$_state_machine__42063__auto____1 = (function (state_42725){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42725);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42807){if((e42807 instanceof Object)){
var ex__42066__auto__ = e42807;
var statearr_42808_43910 = state_42725;
(statearr_42808_43910[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42807;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43911 = state_42725;
state_42725 = G__43911;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42063__auto__ = function(state_42725){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42063__auto____1.call(this,state_42725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42063__auto____0;
cljs$core$async$mult_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42063__auto____1;
return cljs$core$async$mult_$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42809 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42809[(6)] = c__42130__auto___43852);

return statearr_42809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__42811 = arguments.length;
switch (G__42811) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4488__auto__.call(null,m,state_map));
} else {
var m__4485__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4485__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4488__auto__.call(null,m,mode));
} else {
var m__4485__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4485__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___43935 = arguments.length;
var i__4790__auto___43936 = (0);
while(true){
if((i__4790__auto___43936 < len__4789__auto___43935)){
args__4795__auto__.push((arguments[i__4790__auto___43936]));

var G__43937 = (i__4790__auto___43936 + (1));
i__4790__auto___43936 = G__43937;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((3) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4796__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__42816){
var map__42817 = p__42816;
var map__42817__$1 = (((((!((map__42817 == null))))?(((((map__42817.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42817.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42817):map__42817);
var opts = map__42817__$1;
var statearr_42819_43944 = state;
(statearr_42819_43944[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_42820_43945 = state;
(statearr_42820_43945[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_42821_43946 = state;
(statearr_42821_43946[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq42812){
var G__42813 = cljs.core.first(seq42812);
var seq42812__$1 = cljs.core.next(seq42812);
var G__42814 = cljs.core.first(seq42812__$1);
var seq42812__$2 = cljs.core.next(seq42812__$1);
var G__42815 = cljs.core.first(seq42812__$2);
var seq42812__$3 = cljs.core.next(seq42812__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42813,G__42814,G__42815,seq42812__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42822 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42822 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta42823){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta42823 = meta42823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42824,meta42823__$1){
var self__ = this;
var _42824__$1 = this;
return (new cljs.core.async.t_cljs$core$async42822(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta42823__$1));
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42824){
var self__ = this;
var _42824__$1 = this;
return self__.meta42823;
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42822.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta42823","meta42823",-1204862880,null)], null);
}));

(cljs.core.async.t_cljs$core$async42822.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42822.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42822");

(cljs.core.async.t_cljs$core$async42822.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async42822");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42822.
 */
cljs.core.async.__GT_t_cljs$core$async42822 = (function cljs$core$async$mix_$___GT_t_cljs$core$async42822(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta42823){
return (new cljs.core.async.t_cljs$core$async42822(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta42823));
});

}

return (new cljs.core.async.t_cljs$core$async42822(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42130__auto___43977 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_42926){
var state_val_42927 = (state_42926[(1)]);
if((state_val_42927 === (7))){
var inst_42841 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
var statearr_42928_43979 = state_42926__$1;
(statearr_42928_43979[(2)] = inst_42841);

(statearr_42928_43979[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (20))){
var inst_42853 = (state_42926[(7)]);
var state_42926__$1 = state_42926;
var statearr_42929_43984 = state_42926__$1;
(statearr_42929_43984[(2)] = inst_42853);

(statearr_42929_43984[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (27))){
var state_42926__$1 = state_42926;
var statearr_42930_43986 = state_42926__$1;
(statearr_42930_43986[(2)] = null);

(statearr_42930_43986[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (1))){
var inst_42828 = (state_42926[(8)]);
var inst_42828__$1 = calc_state();
var inst_42830 = (inst_42828__$1 == null);
var inst_42831 = cljs.core.not(inst_42830);
var state_42926__$1 = (function (){var statearr_42931 = state_42926;
(statearr_42931[(8)] = inst_42828__$1);

return statearr_42931;
})();
if(inst_42831){
var statearr_42932_43991 = state_42926__$1;
(statearr_42932_43991[(1)] = (2));

} else {
var statearr_42933_43992 = state_42926__$1;
(statearr_42933_43992[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (24))){
var inst_42900 = (state_42926[(9)]);
var inst_42877 = (state_42926[(10)]);
var inst_42886 = (state_42926[(11)]);
var inst_42900__$1 = (inst_42877.cljs$core$IFn$_invoke$arity$1 ? inst_42877.cljs$core$IFn$_invoke$arity$1(inst_42886) : inst_42877.call(null,inst_42886));
var state_42926__$1 = (function (){var statearr_42934 = state_42926;
(statearr_42934[(9)] = inst_42900__$1);

return statearr_42934;
})();
if(cljs.core.truth_(inst_42900__$1)){
var statearr_42935_43996 = state_42926__$1;
(statearr_42935_43996[(1)] = (29));

} else {
var statearr_42936_43997 = state_42926__$1;
(statearr_42936_43997[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (4))){
var inst_42844 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42844)){
var statearr_42937_44000 = state_42926__$1;
(statearr_42937_44000[(1)] = (8));

} else {
var statearr_42938_44001 = state_42926__$1;
(statearr_42938_44001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (15))){
var inst_42871 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42871)){
var statearr_42939_44002 = state_42926__$1;
(statearr_42939_44002[(1)] = (19));

} else {
var statearr_42940_44003 = state_42926__$1;
(statearr_42940_44003[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (21))){
var inst_42876 = (state_42926[(12)]);
var inst_42876__$1 = (state_42926[(2)]);
var inst_42877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42876__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_42878 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42876__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_42879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42876__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_42926__$1 = (function (){var statearr_42941 = state_42926;
(statearr_42941[(13)] = inst_42878);

(statearr_42941[(10)] = inst_42877);

(statearr_42941[(12)] = inst_42876__$1);

return statearr_42941;
})();
return cljs.core.async.ioc_alts_BANG_(state_42926__$1,(22),inst_42879);
} else {
if((state_val_42927 === (31))){
var inst_42908 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42908)){
var statearr_42942_44004 = state_42926__$1;
(statearr_42942_44004[(1)] = (32));

} else {
var statearr_42943_44005 = state_42926__$1;
(statearr_42943_44005[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (32))){
var inst_42885 = (state_42926[(14)]);
var state_42926__$1 = state_42926;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42926__$1,(35),out,inst_42885);
} else {
if((state_val_42927 === (33))){
var inst_42876 = (state_42926[(12)]);
var inst_42853 = inst_42876;
var state_42926__$1 = (function (){var statearr_42944 = state_42926;
(statearr_42944[(7)] = inst_42853);

return statearr_42944;
})();
var statearr_42945_44006 = state_42926__$1;
(statearr_42945_44006[(2)] = null);

(statearr_42945_44006[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (13))){
var inst_42853 = (state_42926[(7)]);
var inst_42860 = inst_42853.cljs$lang$protocol_mask$partition0$;
var inst_42861 = (inst_42860 & (64));
var inst_42862 = inst_42853.cljs$core$ISeq$;
var inst_42863 = (cljs.core.PROTOCOL_SENTINEL === inst_42862);
var inst_42864 = ((inst_42861) || (inst_42863));
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42864)){
var statearr_42946_44007 = state_42926__$1;
(statearr_42946_44007[(1)] = (16));

} else {
var statearr_42947_44008 = state_42926__$1;
(statearr_42947_44008[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (22))){
var inst_42885 = (state_42926[(14)]);
var inst_42886 = (state_42926[(11)]);
var inst_42884 = (state_42926[(2)]);
var inst_42885__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42884,(0),null);
var inst_42886__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42884,(1),null);
var inst_42887 = (inst_42885__$1 == null);
var inst_42888 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42886__$1,change);
var inst_42889 = ((inst_42887) || (inst_42888));
var state_42926__$1 = (function (){var statearr_42948 = state_42926;
(statearr_42948[(14)] = inst_42885__$1);

(statearr_42948[(11)] = inst_42886__$1);

return statearr_42948;
})();
if(cljs.core.truth_(inst_42889)){
var statearr_42949_44009 = state_42926__$1;
(statearr_42949_44009[(1)] = (23));

} else {
var statearr_42950_44012 = state_42926__$1;
(statearr_42950_44012[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (36))){
var inst_42876 = (state_42926[(12)]);
var inst_42853 = inst_42876;
var state_42926__$1 = (function (){var statearr_42951 = state_42926;
(statearr_42951[(7)] = inst_42853);

return statearr_42951;
})();
var statearr_42952_44013 = state_42926__$1;
(statearr_42952_44013[(2)] = null);

(statearr_42952_44013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (29))){
var inst_42900 = (state_42926[(9)]);
var state_42926__$1 = state_42926;
var statearr_42953_44015 = state_42926__$1;
(statearr_42953_44015[(2)] = inst_42900);

(statearr_42953_44015[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (6))){
var state_42926__$1 = state_42926;
var statearr_42954_44017 = state_42926__$1;
(statearr_42954_44017[(2)] = false);

(statearr_42954_44017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (28))){
var inst_42896 = (state_42926[(2)]);
var inst_42897 = calc_state();
var inst_42853 = inst_42897;
var state_42926__$1 = (function (){var statearr_42955 = state_42926;
(statearr_42955[(15)] = inst_42896);

(statearr_42955[(7)] = inst_42853);

return statearr_42955;
})();
var statearr_42956_44018 = state_42926__$1;
(statearr_42956_44018[(2)] = null);

(statearr_42956_44018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (25))){
var inst_42922 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
var statearr_42957_44019 = state_42926__$1;
(statearr_42957_44019[(2)] = inst_42922);

(statearr_42957_44019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (34))){
var inst_42920 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
var statearr_42958_44020 = state_42926__$1;
(statearr_42958_44020[(2)] = inst_42920);

(statearr_42958_44020[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (17))){
var state_42926__$1 = state_42926;
var statearr_42959_44021 = state_42926__$1;
(statearr_42959_44021[(2)] = false);

(statearr_42959_44021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (3))){
var state_42926__$1 = state_42926;
var statearr_42960_44022 = state_42926__$1;
(statearr_42960_44022[(2)] = false);

(statearr_42960_44022[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (12))){
var inst_42924 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42926__$1,inst_42924);
} else {
if((state_val_42927 === (2))){
var inst_42828 = (state_42926[(8)]);
var inst_42833 = inst_42828.cljs$lang$protocol_mask$partition0$;
var inst_42834 = (inst_42833 & (64));
var inst_42835 = inst_42828.cljs$core$ISeq$;
var inst_42836 = (cljs.core.PROTOCOL_SENTINEL === inst_42835);
var inst_42837 = ((inst_42834) || (inst_42836));
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42837)){
var statearr_42961_44023 = state_42926__$1;
(statearr_42961_44023[(1)] = (5));

} else {
var statearr_42962_44024 = state_42926__$1;
(statearr_42962_44024[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (23))){
var inst_42885 = (state_42926[(14)]);
var inst_42891 = (inst_42885 == null);
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42891)){
var statearr_42963_44025 = state_42926__$1;
(statearr_42963_44025[(1)] = (26));

} else {
var statearr_42964_44026 = state_42926__$1;
(statearr_42964_44026[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (35))){
var inst_42911 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
if(cljs.core.truth_(inst_42911)){
var statearr_42965_44027 = state_42926__$1;
(statearr_42965_44027[(1)] = (36));

} else {
var statearr_42966_44028 = state_42926__$1;
(statearr_42966_44028[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (19))){
var inst_42853 = (state_42926[(7)]);
var inst_42873 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42853);
var state_42926__$1 = state_42926;
var statearr_42967_44030 = state_42926__$1;
(statearr_42967_44030[(2)] = inst_42873);

(statearr_42967_44030[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (11))){
var inst_42853 = (state_42926[(7)]);
var inst_42857 = (inst_42853 == null);
var inst_42858 = cljs.core.not(inst_42857);
var state_42926__$1 = state_42926;
if(inst_42858){
var statearr_42968_44032 = state_42926__$1;
(statearr_42968_44032[(1)] = (13));

} else {
var statearr_42969_44033 = state_42926__$1;
(statearr_42969_44033[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (9))){
var inst_42828 = (state_42926[(8)]);
var state_42926__$1 = state_42926;
var statearr_42970_44034 = state_42926__$1;
(statearr_42970_44034[(2)] = inst_42828);

(statearr_42970_44034[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (5))){
var state_42926__$1 = state_42926;
var statearr_42971_44036 = state_42926__$1;
(statearr_42971_44036[(2)] = true);

(statearr_42971_44036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (14))){
var state_42926__$1 = state_42926;
var statearr_42972_44037 = state_42926__$1;
(statearr_42972_44037[(2)] = false);

(statearr_42972_44037[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (26))){
var inst_42886 = (state_42926[(11)]);
var inst_42893 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_42886);
var state_42926__$1 = state_42926;
var statearr_42973_44039 = state_42926__$1;
(statearr_42973_44039[(2)] = inst_42893);

(statearr_42973_44039[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (16))){
var state_42926__$1 = state_42926;
var statearr_42974_44040 = state_42926__$1;
(statearr_42974_44040[(2)] = true);

(statearr_42974_44040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (38))){
var inst_42916 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
var statearr_42975_44041 = state_42926__$1;
(statearr_42975_44041[(2)] = inst_42916);

(statearr_42975_44041[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (30))){
var inst_42878 = (state_42926[(13)]);
var inst_42877 = (state_42926[(10)]);
var inst_42886 = (state_42926[(11)]);
var inst_42903 = cljs.core.empty_QMARK_(inst_42877);
var inst_42904 = (inst_42878.cljs$core$IFn$_invoke$arity$1 ? inst_42878.cljs$core$IFn$_invoke$arity$1(inst_42886) : inst_42878.call(null,inst_42886));
var inst_42905 = cljs.core.not(inst_42904);
var inst_42906 = ((inst_42903) && (inst_42905));
var state_42926__$1 = state_42926;
var statearr_42976_44044 = state_42926__$1;
(statearr_42976_44044[(2)] = inst_42906);

(statearr_42976_44044[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (10))){
var inst_42828 = (state_42926[(8)]);
var inst_42849 = (state_42926[(2)]);
var inst_42850 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42849,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_42851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42849,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_42852 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42849,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_42853 = inst_42828;
var state_42926__$1 = (function (){var statearr_42977 = state_42926;
(statearr_42977[(16)] = inst_42850);

(statearr_42977[(17)] = inst_42851);

(statearr_42977[(7)] = inst_42853);

(statearr_42977[(18)] = inst_42852);

return statearr_42977;
})();
var statearr_42978_44046 = state_42926__$1;
(statearr_42978_44046[(2)] = null);

(statearr_42978_44046[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (18))){
var inst_42868 = (state_42926[(2)]);
var state_42926__$1 = state_42926;
var statearr_42979_44048 = state_42926__$1;
(statearr_42979_44048[(2)] = inst_42868);

(statearr_42979_44048[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (37))){
var state_42926__$1 = state_42926;
var statearr_42980_44049 = state_42926__$1;
(statearr_42980_44049[(2)] = null);

(statearr_42980_44049[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42927 === (8))){
var inst_42828 = (state_42926[(8)]);
var inst_42846 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42828);
var state_42926__$1 = state_42926;
var statearr_42981_44050 = state_42926__$1;
(statearr_42981_44050[(2)] = inst_42846);

(statearr_42981_44050[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__42063__auto__ = null;
var cljs$core$async$mix_$_state_machine__42063__auto____0 = (function (){
var statearr_42982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42982[(0)] = cljs$core$async$mix_$_state_machine__42063__auto__);

(statearr_42982[(1)] = (1));

return statearr_42982;
});
var cljs$core$async$mix_$_state_machine__42063__auto____1 = (function (state_42926){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_42926);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e42983){if((e42983 instanceof Object)){
var ex__42066__auto__ = e42983;
var statearr_42984_44055 = state_42926;
(statearr_42984_44055[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42983;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44056 = state_42926;
state_42926 = G__44056;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42063__auto__ = function(state_42926){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42063__auto____1.call(this,state_42926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42063__auto____0;
cljs$core$async$mix_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42063__auto____1;
return cljs$core$async$mix_$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_42985 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_42985[(6)] = c__42130__auto___43977);

return statearr_42985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4488__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4485__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4488__auto__.call(null,p,v,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4485__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__42987 = arguments.length;
switch (G__42987) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4488__auto__.call(null,p));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4485__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4488__auto__.call(null,p,v));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4485__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__42990 = arguments.length;
switch (G__42990) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__42988_SHARP_){
if(cljs.core.truth_((p1__42988_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__42988_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__42988_SHARP_.call(null,topic)))){
return p1__42988_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42988_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42991 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42991 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta42992){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta42992 = meta42992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42993,meta42992__$1){
var self__ = this;
var _42993__$1 = this;
return (new cljs.core.async.t_cljs$core$async42991(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta42992__$1));
}));

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42993){
var self__ = this;
var _42993__$1 = this;
return self__.meta42992;
}));

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async42991.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async42991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta42992","meta42992",-1987361553,null)], null);
}));

(cljs.core.async.t_cljs$core$async42991.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42991.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42991");

(cljs.core.async.t_cljs$core$async42991.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async42991");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42991.
 */
cljs.core.async.__GT_t_cljs$core$async42991 = (function cljs$core$async$__GT_t_cljs$core$async42991(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta42992){
return (new cljs.core.async.t_cljs$core$async42991(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta42992));
});

}

return (new cljs.core.async.t_cljs$core$async42991(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42130__auto___44082 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43065){
var state_val_43066 = (state_43065[(1)]);
if((state_val_43066 === (7))){
var inst_43061 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
var statearr_43067_44083 = state_43065__$1;
(statearr_43067_44083[(2)] = inst_43061);

(statearr_43067_44083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (20))){
var state_43065__$1 = state_43065;
var statearr_43068_44084 = state_43065__$1;
(statearr_43068_44084[(2)] = null);

(statearr_43068_44084[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (1))){
var state_43065__$1 = state_43065;
var statearr_43069_44085 = state_43065__$1;
(statearr_43069_44085[(2)] = null);

(statearr_43069_44085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (24))){
var inst_43044 = (state_43065[(7)]);
var inst_43053 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_43044);
var state_43065__$1 = state_43065;
var statearr_43070_44086 = state_43065__$1;
(statearr_43070_44086[(2)] = inst_43053);

(statearr_43070_44086[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (4))){
var inst_42996 = (state_43065[(8)]);
var inst_42996__$1 = (state_43065[(2)]);
var inst_42997 = (inst_42996__$1 == null);
var state_43065__$1 = (function (){var statearr_43071 = state_43065;
(statearr_43071[(8)] = inst_42996__$1);

return statearr_43071;
})();
if(cljs.core.truth_(inst_42997)){
var statearr_43072_44087 = state_43065__$1;
(statearr_43072_44087[(1)] = (5));

} else {
var statearr_43073_44088 = state_43065__$1;
(statearr_43073_44088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (15))){
var inst_43038 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
var statearr_43074_44089 = state_43065__$1;
(statearr_43074_44089[(2)] = inst_43038);

(statearr_43074_44089[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (21))){
var inst_43058 = (state_43065[(2)]);
var state_43065__$1 = (function (){var statearr_43075 = state_43065;
(statearr_43075[(9)] = inst_43058);

return statearr_43075;
})();
var statearr_43076_44090 = state_43065__$1;
(statearr_43076_44090[(2)] = null);

(statearr_43076_44090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (13))){
var inst_43020 = (state_43065[(10)]);
var inst_43022 = cljs.core.chunked_seq_QMARK_(inst_43020);
var state_43065__$1 = state_43065;
if(inst_43022){
var statearr_43077_44091 = state_43065__$1;
(statearr_43077_44091[(1)] = (16));

} else {
var statearr_43078_44092 = state_43065__$1;
(statearr_43078_44092[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (22))){
var inst_43050 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
if(cljs.core.truth_(inst_43050)){
var statearr_43079_44093 = state_43065__$1;
(statearr_43079_44093[(1)] = (23));

} else {
var statearr_43080_44094 = state_43065__$1;
(statearr_43080_44094[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (6))){
var inst_43044 = (state_43065[(7)]);
var inst_43046 = (state_43065[(11)]);
var inst_42996 = (state_43065[(8)]);
var inst_43044__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_42996) : topic_fn.call(null,inst_42996));
var inst_43045 = cljs.core.deref(mults);
var inst_43046__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43045,inst_43044__$1);
var state_43065__$1 = (function (){var statearr_43081 = state_43065;
(statearr_43081[(7)] = inst_43044__$1);

(statearr_43081[(11)] = inst_43046__$1);

return statearr_43081;
})();
if(cljs.core.truth_(inst_43046__$1)){
var statearr_43082_44095 = state_43065__$1;
(statearr_43082_44095[(1)] = (19));

} else {
var statearr_43083_44096 = state_43065__$1;
(statearr_43083_44096[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (25))){
var inst_43055 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
var statearr_43084_44097 = state_43065__$1;
(statearr_43084_44097[(2)] = inst_43055);

(statearr_43084_44097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (17))){
var inst_43020 = (state_43065[(10)]);
var inst_43029 = cljs.core.first(inst_43020);
var inst_43030 = cljs.core.async.muxch_STAR_(inst_43029);
var inst_43031 = cljs.core.async.close_BANG_(inst_43030);
var inst_43032 = cljs.core.next(inst_43020);
var inst_43006 = inst_43032;
var inst_43007 = null;
var inst_43008 = (0);
var inst_43009 = (0);
var state_43065__$1 = (function (){var statearr_43085 = state_43065;
(statearr_43085[(12)] = inst_43009);

(statearr_43085[(13)] = inst_43031);

(statearr_43085[(14)] = inst_43007);

(statearr_43085[(15)] = inst_43008);

(statearr_43085[(16)] = inst_43006);

return statearr_43085;
})();
var statearr_43086_44098 = state_43065__$1;
(statearr_43086_44098[(2)] = null);

(statearr_43086_44098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (3))){
var inst_43063 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43065__$1,inst_43063);
} else {
if((state_val_43066 === (12))){
var inst_43040 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
var statearr_43087_44099 = state_43065__$1;
(statearr_43087_44099[(2)] = inst_43040);

(statearr_43087_44099[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (2))){
var state_43065__$1 = state_43065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43065__$1,(4),ch);
} else {
if((state_val_43066 === (23))){
var state_43065__$1 = state_43065;
var statearr_43088_44100 = state_43065__$1;
(statearr_43088_44100[(2)] = null);

(statearr_43088_44100[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (19))){
var inst_43046 = (state_43065[(11)]);
var inst_42996 = (state_43065[(8)]);
var inst_43048 = cljs.core.async.muxch_STAR_(inst_43046);
var state_43065__$1 = state_43065;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43065__$1,(22),inst_43048,inst_42996);
} else {
if((state_val_43066 === (11))){
var inst_43020 = (state_43065[(10)]);
var inst_43006 = (state_43065[(16)]);
var inst_43020__$1 = cljs.core.seq(inst_43006);
var state_43065__$1 = (function (){var statearr_43089 = state_43065;
(statearr_43089[(10)] = inst_43020__$1);

return statearr_43089;
})();
if(inst_43020__$1){
var statearr_43090_44101 = state_43065__$1;
(statearr_43090_44101[(1)] = (13));

} else {
var statearr_43091_44102 = state_43065__$1;
(statearr_43091_44102[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (9))){
var inst_43042 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
var statearr_43092_44103 = state_43065__$1;
(statearr_43092_44103[(2)] = inst_43042);

(statearr_43092_44103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (5))){
var inst_43003 = cljs.core.deref(mults);
var inst_43004 = cljs.core.vals(inst_43003);
var inst_43005 = cljs.core.seq(inst_43004);
var inst_43006 = inst_43005;
var inst_43007 = null;
var inst_43008 = (0);
var inst_43009 = (0);
var state_43065__$1 = (function (){var statearr_43093 = state_43065;
(statearr_43093[(12)] = inst_43009);

(statearr_43093[(14)] = inst_43007);

(statearr_43093[(15)] = inst_43008);

(statearr_43093[(16)] = inst_43006);

return statearr_43093;
})();
var statearr_43094_44104 = state_43065__$1;
(statearr_43094_44104[(2)] = null);

(statearr_43094_44104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (14))){
var state_43065__$1 = state_43065;
var statearr_43098_44106 = state_43065__$1;
(statearr_43098_44106[(2)] = null);

(statearr_43098_44106[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (16))){
var inst_43020 = (state_43065[(10)]);
var inst_43024 = cljs.core.chunk_first(inst_43020);
var inst_43025 = cljs.core.chunk_rest(inst_43020);
var inst_43026 = cljs.core.count(inst_43024);
var inst_43006 = inst_43025;
var inst_43007 = inst_43024;
var inst_43008 = inst_43026;
var inst_43009 = (0);
var state_43065__$1 = (function (){var statearr_43099 = state_43065;
(statearr_43099[(12)] = inst_43009);

(statearr_43099[(14)] = inst_43007);

(statearr_43099[(15)] = inst_43008);

(statearr_43099[(16)] = inst_43006);

return statearr_43099;
})();
var statearr_43100_44110 = state_43065__$1;
(statearr_43100_44110[(2)] = null);

(statearr_43100_44110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (10))){
var inst_43009 = (state_43065[(12)]);
var inst_43007 = (state_43065[(14)]);
var inst_43008 = (state_43065[(15)]);
var inst_43006 = (state_43065[(16)]);
var inst_43014 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_43007,inst_43009);
var inst_43015 = cljs.core.async.muxch_STAR_(inst_43014);
var inst_43016 = cljs.core.async.close_BANG_(inst_43015);
var inst_43017 = (inst_43009 + (1));
var tmp43095 = inst_43007;
var tmp43096 = inst_43008;
var tmp43097 = inst_43006;
var inst_43006__$1 = tmp43097;
var inst_43007__$1 = tmp43095;
var inst_43008__$1 = tmp43096;
var inst_43009__$1 = inst_43017;
var state_43065__$1 = (function (){var statearr_43101 = state_43065;
(statearr_43101[(12)] = inst_43009__$1);

(statearr_43101[(14)] = inst_43007__$1);

(statearr_43101[(15)] = inst_43008__$1);

(statearr_43101[(16)] = inst_43006__$1);

(statearr_43101[(17)] = inst_43016);

return statearr_43101;
})();
var statearr_43102_44111 = state_43065__$1;
(statearr_43102_44111[(2)] = null);

(statearr_43102_44111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (18))){
var inst_43035 = (state_43065[(2)]);
var state_43065__$1 = state_43065;
var statearr_43103_44112 = state_43065__$1;
(statearr_43103_44112[(2)] = inst_43035);

(statearr_43103_44112[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43066 === (8))){
var inst_43009 = (state_43065[(12)]);
var inst_43008 = (state_43065[(15)]);
var inst_43011 = (inst_43009 < inst_43008);
var inst_43012 = inst_43011;
var state_43065__$1 = state_43065;
if(cljs.core.truth_(inst_43012)){
var statearr_43104_44113 = state_43065__$1;
(statearr_43104_44113[(1)] = (10));

} else {
var statearr_43105_44114 = state_43065__$1;
(statearr_43105_44114[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43106 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43106[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43106[(1)] = (1));

return statearr_43106;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43065){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43065);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43107){if((e43107 instanceof Object)){
var ex__42066__auto__ = e43107;
var statearr_43108_44115 = state_43065;
(statearr_43108_44115[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43107;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44116 = state_43065;
state_43065 = G__44116;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43065){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43109 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43109[(6)] = c__42130__auto___44082);

return statearr_43109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__43111 = arguments.length;
switch (G__43111) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__43113 = arguments.length;
switch (G__43113) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__43115 = arguments.length;
switch (G__43115) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__42130__auto___44133 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43154){
var state_val_43155 = (state_43154[(1)]);
if((state_val_43155 === (7))){
var state_43154__$1 = state_43154;
var statearr_43156_44136 = state_43154__$1;
(statearr_43156_44136[(2)] = null);

(statearr_43156_44136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (1))){
var state_43154__$1 = state_43154;
var statearr_43157_44138 = state_43154__$1;
(statearr_43157_44138[(2)] = null);

(statearr_43157_44138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (4))){
var inst_43118 = (state_43154[(7)]);
var inst_43120 = (inst_43118 < cnt);
var state_43154__$1 = state_43154;
if(cljs.core.truth_(inst_43120)){
var statearr_43158_44139 = state_43154__$1;
(statearr_43158_44139[(1)] = (6));

} else {
var statearr_43159_44141 = state_43154__$1;
(statearr_43159_44141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (15))){
var inst_43150 = (state_43154[(2)]);
var state_43154__$1 = state_43154;
var statearr_43160_44144 = state_43154__$1;
(statearr_43160_44144[(2)] = inst_43150);

(statearr_43160_44144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (13))){
var inst_43143 = cljs.core.async.close_BANG_(out);
var state_43154__$1 = state_43154;
var statearr_43161_44145 = state_43154__$1;
(statearr_43161_44145[(2)] = inst_43143);

(statearr_43161_44145[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (6))){
var state_43154__$1 = state_43154;
var statearr_43162_44148 = state_43154__$1;
(statearr_43162_44148[(2)] = null);

(statearr_43162_44148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (3))){
var inst_43152 = (state_43154[(2)]);
var state_43154__$1 = state_43154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43154__$1,inst_43152);
} else {
if((state_val_43155 === (12))){
var inst_43140 = (state_43154[(8)]);
var inst_43140__$1 = (state_43154[(2)]);
var inst_43141 = cljs.core.some(cljs.core.nil_QMARK_,inst_43140__$1);
var state_43154__$1 = (function (){var statearr_43163 = state_43154;
(statearr_43163[(8)] = inst_43140__$1);

return statearr_43163;
})();
if(cljs.core.truth_(inst_43141)){
var statearr_43164_44151 = state_43154__$1;
(statearr_43164_44151[(1)] = (13));

} else {
var statearr_43165_44154 = state_43154__$1;
(statearr_43165_44154[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (2))){
var inst_43117 = cljs.core.reset_BANG_(dctr,cnt);
var inst_43118 = (0);
var state_43154__$1 = (function (){var statearr_43166 = state_43154;
(statearr_43166[(7)] = inst_43118);

(statearr_43166[(9)] = inst_43117);

return statearr_43166;
})();
var statearr_43167_44156 = state_43154__$1;
(statearr_43167_44156[(2)] = null);

(statearr_43167_44156[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (11))){
var inst_43118 = (state_43154[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_43154,(10),Object,null,(9));
var inst_43127 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_43118) : chs__$1.call(null,inst_43118));
var inst_43128 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_43118) : done.call(null,inst_43118));
var inst_43129 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_43127,inst_43128);
var state_43154__$1 = state_43154;
var statearr_43168_44157 = state_43154__$1;
(statearr_43168_44157[(2)] = inst_43129);


cljs.core.async.impl.ioc_helpers.process_exception(state_43154__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (9))){
var inst_43118 = (state_43154[(7)]);
var inst_43131 = (state_43154[(2)]);
var inst_43132 = (inst_43118 + (1));
var inst_43118__$1 = inst_43132;
var state_43154__$1 = (function (){var statearr_43169 = state_43154;
(statearr_43169[(7)] = inst_43118__$1);

(statearr_43169[(10)] = inst_43131);

return statearr_43169;
})();
var statearr_43170_44160 = state_43154__$1;
(statearr_43170_44160[(2)] = null);

(statearr_43170_44160[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (5))){
var inst_43138 = (state_43154[(2)]);
var state_43154__$1 = (function (){var statearr_43171 = state_43154;
(statearr_43171[(11)] = inst_43138);

return statearr_43171;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43154__$1,(12),dchan);
} else {
if((state_val_43155 === (14))){
var inst_43140 = (state_43154[(8)]);
var inst_43145 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_43140);
var state_43154__$1 = state_43154;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43154__$1,(16),out,inst_43145);
} else {
if((state_val_43155 === (16))){
var inst_43147 = (state_43154[(2)]);
var state_43154__$1 = (function (){var statearr_43172 = state_43154;
(statearr_43172[(12)] = inst_43147);

return statearr_43172;
})();
var statearr_43173_44163 = state_43154__$1;
(statearr_43173_44163[(2)] = null);

(statearr_43173_44163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (10))){
var inst_43122 = (state_43154[(2)]);
var inst_43123 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_43154__$1 = (function (){var statearr_43174 = state_43154;
(statearr_43174[(13)] = inst_43122);

return statearr_43174;
})();
var statearr_43175_44164 = state_43154__$1;
(statearr_43175_44164[(2)] = inst_43123);


cljs.core.async.impl.ioc_helpers.process_exception(state_43154__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43155 === (8))){
var inst_43136 = (state_43154[(2)]);
var state_43154__$1 = state_43154;
var statearr_43176_44165 = state_43154__$1;
(statearr_43176_44165[(2)] = inst_43136);

(statearr_43176_44165[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43177[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43177[(1)] = (1));

return statearr_43177;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43154){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43154);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43178){if((e43178 instanceof Object)){
var ex__42066__auto__ = e43178;
var statearr_43179_44166 = state_43154;
(statearr_43179_44166[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43178;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44167 = state_43154;
state_43154 = G__44167;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43154){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43180 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43180[(6)] = c__42130__auto___44133);

return statearr_43180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__43183 = arguments.length;
switch (G__43183) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42130__auto___44170 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43215){
var state_val_43216 = (state_43215[(1)]);
if((state_val_43216 === (7))){
var inst_43194 = (state_43215[(7)]);
var inst_43195 = (state_43215[(8)]);
var inst_43194__$1 = (state_43215[(2)]);
var inst_43195__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43194__$1,(0),null);
var inst_43196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43194__$1,(1),null);
var inst_43197 = (inst_43195__$1 == null);
var state_43215__$1 = (function (){var statearr_43217 = state_43215;
(statearr_43217[(7)] = inst_43194__$1);

(statearr_43217[(8)] = inst_43195__$1);

(statearr_43217[(9)] = inst_43196);

return statearr_43217;
})();
if(cljs.core.truth_(inst_43197)){
var statearr_43218_44173 = state_43215__$1;
(statearr_43218_44173[(1)] = (8));

} else {
var statearr_43219_44174 = state_43215__$1;
(statearr_43219_44174[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (1))){
var inst_43184 = cljs.core.vec(chs);
var inst_43185 = inst_43184;
var state_43215__$1 = (function (){var statearr_43220 = state_43215;
(statearr_43220[(10)] = inst_43185);

return statearr_43220;
})();
var statearr_43221_44175 = state_43215__$1;
(statearr_43221_44175[(2)] = null);

(statearr_43221_44175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (4))){
var inst_43185 = (state_43215[(10)]);
var state_43215__$1 = state_43215;
return cljs.core.async.ioc_alts_BANG_(state_43215__$1,(7),inst_43185);
} else {
if((state_val_43216 === (6))){
var inst_43211 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43222_44177 = state_43215__$1;
(statearr_43222_44177[(2)] = inst_43211);

(statearr_43222_44177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (3))){
var inst_43213 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43215__$1,inst_43213);
} else {
if((state_val_43216 === (2))){
var inst_43185 = (state_43215[(10)]);
var inst_43187 = cljs.core.count(inst_43185);
var inst_43188 = (inst_43187 > (0));
var state_43215__$1 = state_43215;
if(cljs.core.truth_(inst_43188)){
var statearr_43224_44182 = state_43215__$1;
(statearr_43224_44182[(1)] = (4));

} else {
var statearr_43225_44183 = state_43215__$1;
(statearr_43225_44183[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (11))){
var inst_43185 = (state_43215[(10)]);
var inst_43204 = (state_43215[(2)]);
var tmp43223 = inst_43185;
var inst_43185__$1 = tmp43223;
var state_43215__$1 = (function (){var statearr_43226 = state_43215;
(statearr_43226[(11)] = inst_43204);

(statearr_43226[(10)] = inst_43185__$1);

return statearr_43226;
})();
var statearr_43227_44184 = state_43215__$1;
(statearr_43227_44184[(2)] = null);

(statearr_43227_44184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (9))){
var inst_43195 = (state_43215[(8)]);
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43215__$1,(11),out,inst_43195);
} else {
if((state_val_43216 === (5))){
var inst_43209 = cljs.core.async.close_BANG_(out);
var state_43215__$1 = state_43215;
var statearr_43228_44188 = state_43215__$1;
(statearr_43228_44188[(2)] = inst_43209);

(statearr_43228_44188[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (10))){
var inst_43207 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43229_44189 = state_43215__$1;
(statearr_43229_44189[(2)] = inst_43207);

(statearr_43229_44189[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (8))){
var inst_43194 = (state_43215[(7)]);
var inst_43195 = (state_43215[(8)]);
var inst_43185 = (state_43215[(10)]);
var inst_43196 = (state_43215[(9)]);
var inst_43199 = (function (){var cs = inst_43185;
var vec__43190 = inst_43194;
var v = inst_43195;
var c = inst_43196;
return (function (p1__43181_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__43181_SHARP_);
});
})();
var inst_43200 = cljs.core.filterv(inst_43199,inst_43185);
var inst_43185__$1 = inst_43200;
var state_43215__$1 = (function (){var statearr_43230 = state_43215;
(statearr_43230[(10)] = inst_43185__$1);

return statearr_43230;
})();
var statearr_43231_44190 = state_43215__$1;
(statearr_43231_44190[(2)] = null);

(statearr_43231_44190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43232 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43232[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43232[(1)] = (1));

return statearr_43232;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43215){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43215);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43233){if((e43233 instanceof Object)){
var ex__42066__auto__ = e43233;
var statearr_43234_44193 = state_43215;
(statearr_43234_44193[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43215);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43233;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44194 = state_43215;
state_43215 = G__44194;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43215){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43235 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43235[(6)] = c__42130__auto___44170);

return statearr_43235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__43237 = arguments.length;
switch (G__43237) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42130__auto___44196 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43261){
var state_val_43262 = (state_43261[(1)]);
if((state_val_43262 === (7))){
var inst_43243 = (state_43261[(7)]);
var inst_43243__$1 = (state_43261[(2)]);
var inst_43244 = (inst_43243__$1 == null);
var inst_43245 = cljs.core.not(inst_43244);
var state_43261__$1 = (function (){var statearr_43263 = state_43261;
(statearr_43263[(7)] = inst_43243__$1);

return statearr_43263;
})();
if(inst_43245){
var statearr_43264_44197 = state_43261__$1;
(statearr_43264_44197[(1)] = (8));

} else {
var statearr_43265_44198 = state_43261__$1;
(statearr_43265_44198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (1))){
var inst_43238 = (0);
var state_43261__$1 = (function (){var statearr_43266 = state_43261;
(statearr_43266[(8)] = inst_43238);

return statearr_43266;
})();
var statearr_43267_44201 = state_43261__$1;
(statearr_43267_44201[(2)] = null);

(statearr_43267_44201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (4))){
var state_43261__$1 = state_43261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43261__$1,(7),ch);
} else {
if((state_val_43262 === (6))){
var inst_43256 = (state_43261[(2)]);
var state_43261__$1 = state_43261;
var statearr_43268_44202 = state_43261__$1;
(statearr_43268_44202[(2)] = inst_43256);

(statearr_43268_44202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (3))){
var inst_43258 = (state_43261[(2)]);
var inst_43259 = cljs.core.async.close_BANG_(out);
var state_43261__$1 = (function (){var statearr_43269 = state_43261;
(statearr_43269[(9)] = inst_43258);

return statearr_43269;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43261__$1,inst_43259);
} else {
if((state_val_43262 === (2))){
var inst_43238 = (state_43261[(8)]);
var inst_43240 = (inst_43238 < n);
var state_43261__$1 = state_43261;
if(cljs.core.truth_(inst_43240)){
var statearr_43270_44207 = state_43261__$1;
(statearr_43270_44207[(1)] = (4));

} else {
var statearr_43271_44208 = state_43261__$1;
(statearr_43271_44208[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (11))){
var inst_43238 = (state_43261[(8)]);
var inst_43248 = (state_43261[(2)]);
var inst_43249 = (inst_43238 + (1));
var inst_43238__$1 = inst_43249;
var state_43261__$1 = (function (){var statearr_43272 = state_43261;
(statearr_43272[(8)] = inst_43238__$1);

(statearr_43272[(10)] = inst_43248);

return statearr_43272;
})();
var statearr_43273_44210 = state_43261__$1;
(statearr_43273_44210[(2)] = null);

(statearr_43273_44210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (9))){
var state_43261__$1 = state_43261;
var statearr_43274_44214 = state_43261__$1;
(statearr_43274_44214[(2)] = null);

(statearr_43274_44214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (5))){
var state_43261__$1 = state_43261;
var statearr_43275_44215 = state_43261__$1;
(statearr_43275_44215[(2)] = null);

(statearr_43275_44215[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (10))){
var inst_43253 = (state_43261[(2)]);
var state_43261__$1 = state_43261;
var statearr_43276_44217 = state_43261__$1;
(statearr_43276_44217[(2)] = inst_43253);

(statearr_43276_44217[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43262 === (8))){
var inst_43243 = (state_43261[(7)]);
var state_43261__$1 = state_43261;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43261__$1,(11),out,inst_43243);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43277 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43277[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43277[(1)] = (1));

return statearr_43277;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43261){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43261);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43278){if((e43278 instanceof Object)){
var ex__42066__auto__ = e43278;
var statearr_43279_44221 = state_43261;
(statearr_43279_44221[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43278;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44223 = state_43261;
state_43261 = G__44223;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43261){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43280 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43280[(6)] = c__42130__auto___44196);

return statearr_43280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43282 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43282 = (function (f,ch,meta43283){
this.f = f;
this.ch = ch;
this.meta43283 = meta43283;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43284,meta43283__$1){
var self__ = this;
var _43284__$1 = this;
return (new cljs.core.async.t_cljs$core$async43282(self__.f,self__.ch,meta43283__$1));
}));

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43284){
var self__ = this;
var _43284__$1 = this;
return self__.meta43283;
}));

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43285 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43285 = (function (f,ch,meta43283,_,fn1,meta43286){
this.f = f;
this.ch = ch;
this.meta43283 = meta43283;
this._ = _;
this.fn1 = fn1;
this.meta43286 = meta43286;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43285.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43287,meta43286__$1){
var self__ = this;
var _43287__$1 = this;
return (new cljs.core.async.t_cljs$core$async43285(self__.f,self__.ch,self__.meta43283,self__._,self__.fn1,meta43286__$1));
}));

(cljs.core.async.t_cljs$core$async43285.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43287){
var self__ = this;
var _43287__$1 = this;
return self__.meta43286;
}));

(cljs.core.async.t_cljs$core$async43285.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43285.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async43285.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43285.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__43281_SHARP_){
var G__43288 = (((p1__43281_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__43281_SHARP_) : self__.f.call(null,p1__43281_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__43288) : f1.call(null,G__43288));
});
}));

(cljs.core.async.t_cljs$core$async43285.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta43283","meta43283",-1055966474,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async43282","cljs.core.async/t_cljs$core$async43282",-396237397,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta43286","meta43286",397261784,null)], null);
}));

(cljs.core.async.t_cljs$core$async43285.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43285.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43285");

(cljs.core.async.t_cljs$core$async43285.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async43285");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43285.
 */
cljs.core.async.__GT_t_cljs$core$async43285 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async43285(f__$1,ch__$1,meta43283__$1,___$2,fn1__$1,meta43286){
return (new cljs.core.async.t_cljs$core$async43285(f__$1,ch__$1,meta43283__$1,___$2,fn1__$1,meta43286));
});

}

return (new cljs.core.async.t_cljs$core$async43285(self__.f,self__.ch,self__.meta43283,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4174__auto__ = ret;
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__43289 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__43289) : self__.f.call(null,G__43289));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43282.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async43282.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta43283","meta43283",-1055966474,null)], null);
}));

(cljs.core.async.t_cljs$core$async43282.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43282.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43282");

(cljs.core.async.t_cljs$core$async43282.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async43282");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43282.
 */
cljs.core.async.__GT_t_cljs$core$async43282 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async43282(f__$1,ch__$1,meta43283){
return (new cljs.core.async.t_cljs$core$async43282(f__$1,ch__$1,meta43283));
});

}

return (new cljs.core.async.t_cljs$core$async43282(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43290 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43290 = (function (f,ch,meta43291){
this.f = f;
this.ch = ch;
this.meta43291 = meta43291;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43292,meta43291__$1){
var self__ = this;
var _43292__$1 = this;
return (new cljs.core.async.t_cljs$core$async43290(self__.f,self__.ch,meta43291__$1));
}));

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43292){
var self__ = this;
var _43292__$1 = this;
return self__.meta43291;
}));

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43290.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async43290.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta43291","meta43291",-787429199,null)], null);
}));

(cljs.core.async.t_cljs$core$async43290.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43290.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43290");

(cljs.core.async.t_cljs$core$async43290.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async43290");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43290.
 */
cljs.core.async.__GT_t_cljs$core$async43290 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async43290(f__$1,ch__$1,meta43291){
return (new cljs.core.async.t_cljs$core$async43290(f__$1,ch__$1,meta43291));
});

}

return (new cljs.core.async.t_cljs$core$async43290(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43293 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43293 = (function (p,ch,meta43294){
this.p = p;
this.ch = ch;
this.meta43294 = meta43294;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43295,meta43294__$1){
var self__ = this;
var _43295__$1 = this;
return (new cljs.core.async.t_cljs$core$async43293(self__.p,self__.ch,meta43294__$1));
}));

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43295){
var self__ = this;
var _43295__$1 = this;
return self__.meta43294;
}));

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43293.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async43293.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta43294","meta43294",589262788,null)], null);
}));

(cljs.core.async.t_cljs$core$async43293.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43293.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43293");

(cljs.core.async.t_cljs$core$async43293.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async43293");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43293.
 */
cljs.core.async.__GT_t_cljs$core$async43293 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async43293(p__$1,ch__$1,meta43294){
return (new cljs.core.async.t_cljs$core$async43293(p__$1,ch__$1,meta43294));
});

}

return (new cljs.core.async.t_cljs$core$async43293(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__43297 = arguments.length;
switch (G__43297) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42130__auto___44239 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43318){
var state_val_43319 = (state_43318[(1)]);
if((state_val_43319 === (7))){
var inst_43314 = (state_43318[(2)]);
var state_43318__$1 = state_43318;
var statearr_43320_44240 = state_43318__$1;
(statearr_43320_44240[(2)] = inst_43314);

(statearr_43320_44240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (1))){
var state_43318__$1 = state_43318;
var statearr_43321_44241 = state_43318__$1;
(statearr_43321_44241[(2)] = null);

(statearr_43321_44241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (4))){
var inst_43300 = (state_43318[(7)]);
var inst_43300__$1 = (state_43318[(2)]);
var inst_43301 = (inst_43300__$1 == null);
var state_43318__$1 = (function (){var statearr_43322 = state_43318;
(statearr_43322[(7)] = inst_43300__$1);

return statearr_43322;
})();
if(cljs.core.truth_(inst_43301)){
var statearr_43323_44242 = state_43318__$1;
(statearr_43323_44242[(1)] = (5));

} else {
var statearr_43324_44243 = state_43318__$1;
(statearr_43324_44243[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (6))){
var inst_43300 = (state_43318[(7)]);
var inst_43305 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_43300) : p.call(null,inst_43300));
var state_43318__$1 = state_43318;
if(cljs.core.truth_(inst_43305)){
var statearr_43325_44244 = state_43318__$1;
(statearr_43325_44244[(1)] = (8));

} else {
var statearr_43326_44246 = state_43318__$1;
(statearr_43326_44246[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (3))){
var inst_43316 = (state_43318[(2)]);
var state_43318__$1 = state_43318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43318__$1,inst_43316);
} else {
if((state_val_43319 === (2))){
var state_43318__$1 = state_43318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43318__$1,(4),ch);
} else {
if((state_val_43319 === (11))){
var inst_43308 = (state_43318[(2)]);
var state_43318__$1 = state_43318;
var statearr_43327_44250 = state_43318__$1;
(statearr_43327_44250[(2)] = inst_43308);

(statearr_43327_44250[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (9))){
var state_43318__$1 = state_43318;
var statearr_43328_44253 = state_43318__$1;
(statearr_43328_44253[(2)] = null);

(statearr_43328_44253[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (5))){
var inst_43303 = cljs.core.async.close_BANG_(out);
var state_43318__$1 = state_43318;
var statearr_43329_44254 = state_43318__$1;
(statearr_43329_44254[(2)] = inst_43303);

(statearr_43329_44254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (10))){
var inst_43311 = (state_43318[(2)]);
var state_43318__$1 = (function (){var statearr_43330 = state_43318;
(statearr_43330[(8)] = inst_43311);

return statearr_43330;
})();
var statearr_43331_44256 = state_43318__$1;
(statearr_43331_44256[(2)] = null);

(statearr_43331_44256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43319 === (8))){
var inst_43300 = (state_43318[(7)]);
var state_43318__$1 = state_43318;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43318__$1,(11),out,inst_43300);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43332 = [null,null,null,null,null,null,null,null,null];
(statearr_43332[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43332[(1)] = (1));

return statearr_43332;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43318){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43318);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43333){if((e43333 instanceof Object)){
var ex__42066__auto__ = e43333;
var statearr_43334_44257 = state_43318;
(statearr_43334_44257[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43333;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44259 = state_43318;
state_43318 = G__44259;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43318){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43335 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43335[(6)] = c__42130__auto___44239);

return statearr_43335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__43337 = arguments.length;
switch (G__43337) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43399){
var state_val_43400 = (state_43399[(1)]);
if((state_val_43400 === (7))){
var inst_43395 = (state_43399[(2)]);
var state_43399__$1 = state_43399;
var statearr_43401_44262 = state_43399__$1;
(statearr_43401_44262[(2)] = inst_43395);

(statearr_43401_44262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (20))){
var inst_43365 = (state_43399[(7)]);
var inst_43376 = (state_43399[(2)]);
var inst_43377 = cljs.core.next(inst_43365);
var inst_43351 = inst_43377;
var inst_43352 = null;
var inst_43353 = (0);
var inst_43354 = (0);
var state_43399__$1 = (function (){var statearr_43402 = state_43399;
(statearr_43402[(8)] = inst_43376);

(statearr_43402[(9)] = inst_43352);

(statearr_43402[(10)] = inst_43354);

(statearr_43402[(11)] = inst_43353);

(statearr_43402[(12)] = inst_43351);

return statearr_43402;
})();
var statearr_43403_44263 = state_43399__$1;
(statearr_43403_44263[(2)] = null);

(statearr_43403_44263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (1))){
var state_43399__$1 = state_43399;
var statearr_43404_44264 = state_43399__$1;
(statearr_43404_44264[(2)] = null);

(statearr_43404_44264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (4))){
var inst_43340 = (state_43399[(13)]);
var inst_43340__$1 = (state_43399[(2)]);
var inst_43341 = (inst_43340__$1 == null);
var state_43399__$1 = (function (){var statearr_43405 = state_43399;
(statearr_43405[(13)] = inst_43340__$1);

return statearr_43405;
})();
if(cljs.core.truth_(inst_43341)){
var statearr_43406_44266 = state_43399__$1;
(statearr_43406_44266[(1)] = (5));

} else {
var statearr_43407_44268 = state_43399__$1;
(statearr_43407_44268[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (15))){
var state_43399__$1 = state_43399;
var statearr_43411_44269 = state_43399__$1;
(statearr_43411_44269[(2)] = null);

(statearr_43411_44269[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (21))){
var state_43399__$1 = state_43399;
var statearr_43412_44270 = state_43399__$1;
(statearr_43412_44270[(2)] = null);

(statearr_43412_44270[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (13))){
var inst_43352 = (state_43399[(9)]);
var inst_43354 = (state_43399[(10)]);
var inst_43353 = (state_43399[(11)]);
var inst_43351 = (state_43399[(12)]);
var inst_43361 = (state_43399[(2)]);
var inst_43362 = (inst_43354 + (1));
var tmp43408 = inst_43352;
var tmp43409 = inst_43353;
var tmp43410 = inst_43351;
var inst_43351__$1 = tmp43410;
var inst_43352__$1 = tmp43408;
var inst_43353__$1 = tmp43409;
var inst_43354__$1 = inst_43362;
var state_43399__$1 = (function (){var statearr_43413 = state_43399;
(statearr_43413[(9)] = inst_43352__$1);

(statearr_43413[(10)] = inst_43354__$1);

(statearr_43413[(14)] = inst_43361);

(statearr_43413[(11)] = inst_43353__$1);

(statearr_43413[(12)] = inst_43351__$1);

return statearr_43413;
})();
var statearr_43414_44273 = state_43399__$1;
(statearr_43414_44273[(2)] = null);

(statearr_43414_44273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (22))){
var state_43399__$1 = state_43399;
var statearr_43415_44274 = state_43399__$1;
(statearr_43415_44274[(2)] = null);

(statearr_43415_44274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (6))){
var inst_43340 = (state_43399[(13)]);
var inst_43349 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_43340) : f.call(null,inst_43340));
var inst_43350 = cljs.core.seq(inst_43349);
var inst_43351 = inst_43350;
var inst_43352 = null;
var inst_43353 = (0);
var inst_43354 = (0);
var state_43399__$1 = (function (){var statearr_43416 = state_43399;
(statearr_43416[(9)] = inst_43352);

(statearr_43416[(10)] = inst_43354);

(statearr_43416[(11)] = inst_43353);

(statearr_43416[(12)] = inst_43351);

return statearr_43416;
})();
var statearr_43417_44275 = state_43399__$1;
(statearr_43417_44275[(2)] = null);

(statearr_43417_44275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (17))){
var inst_43365 = (state_43399[(7)]);
var inst_43369 = cljs.core.chunk_first(inst_43365);
var inst_43370 = cljs.core.chunk_rest(inst_43365);
var inst_43371 = cljs.core.count(inst_43369);
var inst_43351 = inst_43370;
var inst_43352 = inst_43369;
var inst_43353 = inst_43371;
var inst_43354 = (0);
var state_43399__$1 = (function (){var statearr_43418 = state_43399;
(statearr_43418[(9)] = inst_43352);

(statearr_43418[(10)] = inst_43354);

(statearr_43418[(11)] = inst_43353);

(statearr_43418[(12)] = inst_43351);

return statearr_43418;
})();
var statearr_43419_44276 = state_43399__$1;
(statearr_43419_44276[(2)] = null);

(statearr_43419_44276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (3))){
var inst_43397 = (state_43399[(2)]);
var state_43399__$1 = state_43399;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43399__$1,inst_43397);
} else {
if((state_val_43400 === (12))){
var inst_43385 = (state_43399[(2)]);
var state_43399__$1 = state_43399;
var statearr_43420_44277 = state_43399__$1;
(statearr_43420_44277[(2)] = inst_43385);

(statearr_43420_44277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (2))){
var state_43399__$1 = state_43399;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43399__$1,(4),in$);
} else {
if((state_val_43400 === (23))){
var inst_43393 = (state_43399[(2)]);
var state_43399__$1 = state_43399;
var statearr_43421_44278 = state_43399__$1;
(statearr_43421_44278[(2)] = inst_43393);

(statearr_43421_44278[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (19))){
var inst_43380 = (state_43399[(2)]);
var state_43399__$1 = state_43399;
var statearr_43422_44279 = state_43399__$1;
(statearr_43422_44279[(2)] = inst_43380);

(statearr_43422_44279[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (11))){
var inst_43365 = (state_43399[(7)]);
var inst_43351 = (state_43399[(12)]);
var inst_43365__$1 = cljs.core.seq(inst_43351);
var state_43399__$1 = (function (){var statearr_43423 = state_43399;
(statearr_43423[(7)] = inst_43365__$1);

return statearr_43423;
})();
if(inst_43365__$1){
var statearr_43424_44280 = state_43399__$1;
(statearr_43424_44280[(1)] = (14));

} else {
var statearr_43425_44281 = state_43399__$1;
(statearr_43425_44281[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (9))){
var inst_43387 = (state_43399[(2)]);
var inst_43388 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_43399__$1 = (function (){var statearr_43426 = state_43399;
(statearr_43426[(15)] = inst_43387);

return statearr_43426;
})();
if(cljs.core.truth_(inst_43388)){
var statearr_43427_44282 = state_43399__$1;
(statearr_43427_44282[(1)] = (21));

} else {
var statearr_43428_44283 = state_43399__$1;
(statearr_43428_44283[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (5))){
var inst_43343 = cljs.core.async.close_BANG_(out);
var state_43399__$1 = state_43399;
var statearr_43429_44284 = state_43399__$1;
(statearr_43429_44284[(2)] = inst_43343);

(statearr_43429_44284[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (14))){
var inst_43365 = (state_43399[(7)]);
var inst_43367 = cljs.core.chunked_seq_QMARK_(inst_43365);
var state_43399__$1 = state_43399;
if(inst_43367){
var statearr_43430_44285 = state_43399__$1;
(statearr_43430_44285[(1)] = (17));

} else {
var statearr_43431_44286 = state_43399__$1;
(statearr_43431_44286[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (16))){
var inst_43383 = (state_43399[(2)]);
var state_43399__$1 = state_43399;
var statearr_43432_44287 = state_43399__$1;
(statearr_43432_44287[(2)] = inst_43383);

(statearr_43432_44287[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43400 === (10))){
var inst_43352 = (state_43399[(9)]);
var inst_43354 = (state_43399[(10)]);
var inst_43359 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_43352,inst_43354);
var state_43399__$1 = state_43399;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43399__$1,(13),out,inst_43359);
} else {
if((state_val_43400 === (18))){
var inst_43365 = (state_43399[(7)]);
var inst_43374 = cljs.core.first(inst_43365);
var state_43399__$1 = state_43399;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43399__$1,(20),out,inst_43374);
} else {
if((state_val_43400 === (8))){
var inst_43354 = (state_43399[(10)]);
var inst_43353 = (state_43399[(11)]);
var inst_43356 = (inst_43354 < inst_43353);
var inst_43357 = inst_43356;
var state_43399__$1 = state_43399;
if(cljs.core.truth_(inst_43357)){
var statearr_43433_44288 = state_43399__$1;
(statearr_43433_44288[(1)] = (10));

} else {
var statearr_43434_44289 = state_43399__$1;
(statearr_43434_44289[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42063__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_43435 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43435[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42063__auto__);

(statearr_43435[(1)] = (1));

return statearr_43435;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42063__auto____1 = (function (state_43399){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43399);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43436){if((e43436 instanceof Object)){
var ex__42066__auto__ = e43436;
var statearr_43437_44290 = state_43399;
(statearr_43437_44290[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43399);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43436;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44291 = state_43399;
state_43399 = G__44291;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42063__auto__ = function(state_43399){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42063__auto____1.call(this,state_43399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42063__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42063__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43438 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43438[(6)] = c__42130__auto__);

return statearr_43438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__43440 = arguments.length;
switch (G__43440) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__43442 = arguments.length;
switch (G__43442) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__43444 = arguments.length;
switch (G__43444) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42130__auto___44300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43468){
var state_val_43469 = (state_43468[(1)]);
if((state_val_43469 === (7))){
var inst_43463 = (state_43468[(2)]);
var state_43468__$1 = state_43468;
var statearr_43470_44301 = state_43468__$1;
(statearr_43470_44301[(2)] = inst_43463);

(statearr_43470_44301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (1))){
var inst_43445 = null;
var state_43468__$1 = (function (){var statearr_43471 = state_43468;
(statearr_43471[(7)] = inst_43445);

return statearr_43471;
})();
var statearr_43472_44302 = state_43468__$1;
(statearr_43472_44302[(2)] = null);

(statearr_43472_44302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (4))){
var inst_43448 = (state_43468[(8)]);
var inst_43448__$1 = (state_43468[(2)]);
var inst_43449 = (inst_43448__$1 == null);
var inst_43450 = cljs.core.not(inst_43449);
var state_43468__$1 = (function (){var statearr_43473 = state_43468;
(statearr_43473[(8)] = inst_43448__$1);

return statearr_43473;
})();
if(inst_43450){
var statearr_43474_44303 = state_43468__$1;
(statearr_43474_44303[(1)] = (5));

} else {
var statearr_43475_44304 = state_43468__$1;
(statearr_43475_44304[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (6))){
var state_43468__$1 = state_43468;
var statearr_43476_44305 = state_43468__$1;
(statearr_43476_44305[(2)] = null);

(statearr_43476_44305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (3))){
var inst_43465 = (state_43468[(2)]);
var inst_43466 = cljs.core.async.close_BANG_(out);
var state_43468__$1 = (function (){var statearr_43477 = state_43468;
(statearr_43477[(9)] = inst_43465);

return statearr_43477;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43468__$1,inst_43466);
} else {
if((state_val_43469 === (2))){
var state_43468__$1 = state_43468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43468__$1,(4),ch);
} else {
if((state_val_43469 === (11))){
var inst_43448 = (state_43468[(8)]);
var inst_43457 = (state_43468[(2)]);
var inst_43445 = inst_43448;
var state_43468__$1 = (function (){var statearr_43478 = state_43468;
(statearr_43478[(10)] = inst_43457);

(statearr_43478[(7)] = inst_43445);

return statearr_43478;
})();
var statearr_43479_44307 = state_43468__$1;
(statearr_43479_44307[(2)] = null);

(statearr_43479_44307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (9))){
var inst_43448 = (state_43468[(8)]);
var state_43468__$1 = state_43468;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43468__$1,(11),out,inst_43448);
} else {
if((state_val_43469 === (5))){
var inst_43448 = (state_43468[(8)]);
var inst_43445 = (state_43468[(7)]);
var inst_43452 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43448,inst_43445);
var state_43468__$1 = state_43468;
if(inst_43452){
var statearr_43481_44309 = state_43468__$1;
(statearr_43481_44309[(1)] = (8));

} else {
var statearr_43482_44310 = state_43468__$1;
(statearr_43482_44310[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (10))){
var inst_43460 = (state_43468[(2)]);
var state_43468__$1 = state_43468;
var statearr_43483_44311 = state_43468__$1;
(statearr_43483_44311[(2)] = inst_43460);

(statearr_43483_44311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43469 === (8))){
var inst_43445 = (state_43468[(7)]);
var tmp43480 = inst_43445;
var inst_43445__$1 = tmp43480;
var state_43468__$1 = (function (){var statearr_43484 = state_43468;
(statearr_43484[(7)] = inst_43445__$1);

return statearr_43484;
})();
var statearr_43485_44312 = state_43468__$1;
(statearr_43485_44312[(2)] = null);

(statearr_43485_44312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43486 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43486[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43486[(1)] = (1));

return statearr_43486;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43468){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43468);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43487){if((e43487 instanceof Object)){
var ex__42066__auto__ = e43487;
var statearr_43488_44316 = state_43468;
(statearr_43488_44316[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43468);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43487;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44317 = state_43468;
state_43468 = G__44317;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43489 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43489[(6)] = c__42130__auto___44300);

return statearr_43489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__43491 = arguments.length;
switch (G__43491) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42130__auto___44321 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43529){
var state_val_43530 = (state_43529[(1)]);
if((state_val_43530 === (7))){
var inst_43525 = (state_43529[(2)]);
var state_43529__$1 = state_43529;
var statearr_43531_44322 = state_43529__$1;
(statearr_43531_44322[(2)] = inst_43525);

(statearr_43531_44322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (1))){
var inst_43492 = (new Array(n));
var inst_43493 = inst_43492;
var inst_43494 = (0);
var state_43529__$1 = (function (){var statearr_43532 = state_43529;
(statearr_43532[(7)] = inst_43494);

(statearr_43532[(8)] = inst_43493);

return statearr_43532;
})();
var statearr_43533_44323 = state_43529__$1;
(statearr_43533_44323[(2)] = null);

(statearr_43533_44323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (4))){
var inst_43497 = (state_43529[(9)]);
var inst_43497__$1 = (state_43529[(2)]);
var inst_43498 = (inst_43497__$1 == null);
var inst_43499 = cljs.core.not(inst_43498);
var state_43529__$1 = (function (){var statearr_43534 = state_43529;
(statearr_43534[(9)] = inst_43497__$1);

return statearr_43534;
})();
if(inst_43499){
var statearr_43535_44324 = state_43529__$1;
(statearr_43535_44324[(1)] = (5));

} else {
var statearr_43536_44325 = state_43529__$1;
(statearr_43536_44325[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (15))){
var inst_43519 = (state_43529[(2)]);
var state_43529__$1 = state_43529;
var statearr_43537_44328 = state_43529__$1;
(statearr_43537_44328[(2)] = inst_43519);

(statearr_43537_44328[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (13))){
var state_43529__$1 = state_43529;
var statearr_43538_44329 = state_43529__$1;
(statearr_43538_44329[(2)] = null);

(statearr_43538_44329[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (6))){
var inst_43494 = (state_43529[(7)]);
var inst_43515 = (inst_43494 > (0));
var state_43529__$1 = state_43529;
if(cljs.core.truth_(inst_43515)){
var statearr_43539_44330 = state_43529__$1;
(statearr_43539_44330[(1)] = (12));

} else {
var statearr_43540_44331 = state_43529__$1;
(statearr_43540_44331[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (3))){
var inst_43527 = (state_43529[(2)]);
var state_43529__$1 = state_43529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43529__$1,inst_43527);
} else {
if((state_val_43530 === (12))){
var inst_43493 = (state_43529[(8)]);
var inst_43517 = cljs.core.vec(inst_43493);
var state_43529__$1 = state_43529;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43529__$1,(15),out,inst_43517);
} else {
if((state_val_43530 === (2))){
var state_43529__$1 = state_43529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43529__$1,(4),ch);
} else {
if((state_val_43530 === (11))){
var inst_43509 = (state_43529[(2)]);
var inst_43510 = (new Array(n));
var inst_43493 = inst_43510;
var inst_43494 = (0);
var state_43529__$1 = (function (){var statearr_43541 = state_43529;
(statearr_43541[(10)] = inst_43509);

(statearr_43541[(7)] = inst_43494);

(statearr_43541[(8)] = inst_43493);

return statearr_43541;
})();
var statearr_43542_44336 = state_43529__$1;
(statearr_43542_44336[(2)] = null);

(statearr_43542_44336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (9))){
var inst_43493 = (state_43529[(8)]);
var inst_43507 = cljs.core.vec(inst_43493);
var state_43529__$1 = state_43529;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43529__$1,(11),out,inst_43507);
} else {
if((state_val_43530 === (5))){
var inst_43497 = (state_43529[(9)]);
var inst_43494 = (state_43529[(7)]);
var inst_43502 = (state_43529[(11)]);
var inst_43493 = (state_43529[(8)]);
var inst_43501 = (inst_43493[inst_43494] = inst_43497);
var inst_43502__$1 = (inst_43494 + (1));
var inst_43503 = (inst_43502__$1 < n);
var state_43529__$1 = (function (){var statearr_43543 = state_43529;
(statearr_43543[(12)] = inst_43501);

(statearr_43543[(11)] = inst_43502__$1);

return statearr_43543;
})();
if(cljs.core.truth_(inst_43503)){
var statearr_43544_44337 = state_43529__$1;
(statearr_43544_44337[(1)] = (8));

} else {
var statearr_43545_44338 = state_43529__$1;
(statearr_43545_44338[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (14))){
var inst_43522 = (state_43529[(2)]);
var inst_43523 = cljs.core.async.close_BANG_(out);
var state_43529__$1 = (function (){var statearr_43547 = state_43529;
(statearr_43547[(13)] = inst_43522);

return statearr_43547;
})();
var statearr_43548_44339 = state_43529__$1;
(statearr_43548_44339[(2)] = inst_43523);

(statearr_43548_44339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (10))){
var inst_43513 = (state_43529[(2)]);
var state_43529__$1 = state_43529;
var statearr_43549_44340 = state_43529__$1;
(statearr_43549_44340[(2)] = inst_43513);

(statearr_43549_44340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43530 === (8))){
var inst_43502 = (state_43529[(11)]);
var inst_43493 = (state_43529[(8)]);
var tmp43546 = inst_43493;
var inst_43493__$1 = tmp43546;
var inst_43494 = inst_43502;
var state_43529__$1 = (function (){var statearr_43550 = state_43529;
(statearr_43550[(7)] = inst_43494);

(statearr_43550[(8)] = inst_43493__$1);

return statearr_43550;
})();
var statearr_43551_44341 = state_43529__$1;
(statearr_43551_44341[(2)] = null);

(statearr_43551_44341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43552 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43552[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43552[(1)] = (1));

return statearr_43552;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43529){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43529);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43553){if((e43553 instanceof Object)){
var ex__42066__auto__ = e43553;
var statearr_43554_44346 = state_43529;
(statearr_43554_44346[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43529);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43553;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44347 = state_43529;
state_43529 = G__44347;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43529){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43555 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43555[(6)] = c__42130__auto___44321);

return statearr_43555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__43557 = arguments.length;
switch (G__43557) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42130__auto___44350 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_43599){
var state_val_43600 = (state_43599[(1)]);
if((state_val_43600 === (7))){
var inst_43595 = (state_43599[(2)]);
var state_43599__$1 = state_43599;
var statearr_43601_44351 = state_43599__$1;
(statearr_43601_44351[(2)] = inst_43595);

(statearr_43601_44351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (1))){
var inst_43558 = [];
var inst_43559 = inst_43558;
var inst_43560 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_43599__$1 = (function (){var statearr_43602 = state_43599;
(statearr_43602[(7)] = inst_43559);

(statearr_43602[(8)] = inst_43560);

return statearr_43602;
})();
var statearr_43603_44352 = state_43599__$1;
(statearr_43603_44352[(2)] = null);

(statearr_43603_44352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (4))){
var inst_43563 = (state_43599[(9)]);
var inst_43563__$1 = (state_43599[(2)]);
var inst_43564 = (inst_43563__$1 == null);
var inst_43565 = cljs.core.not(inst_43564);
var state_43599__$1 = (function (){var statearr_43604 = state_43599;
(statearr_43604[(9)] = inst_43563__$1);

return statearr_43604;
})();
if(inst_43565){
var statearr_43605_44353 = state_43599__$1;
(statearr_43605_44353[(1)] = (5));

} else {
var statearr_43606_44354 = state_43599__$1;
(statearr_43606_44354[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (15))){
var inst_43589 = (state_43599[(2)]);
var state_43599__$1 = state_43599;
var statearr_43607_44355 = state_43599__$1;
(statearr_43607_44355[(2)] = inst_43589);

(statearr_43607_44355[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (13))){
var state_43599__$1 = state_43599;
var statearr_43608_44356 = state_43599__$1;
(statearr_43608_44356[(2)] = null);

(statearr_43608_44356[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (6))){
var inst_43559 = (state_43599[(7)]);
var inst_43584 = inst_43559.length;
var inst_43585 = (inst_43584 > (0));
var state_43599__$1 = state_43599;
if(cljs.core.truth_(inst_43585)){
var statearr_43609_44357 = state_43599__$1;
(statearr_43609_44357[(1)] = (12));

} else {
var statearr_43610_44358 = state_43599__$1;
(statearr_43610_44358[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (3))){
var inst_43597 = (state_43599[(2)]);
var state_43599__$1 = state_43599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43599__$1,inst_43597);
} else {
if((state_val_43600 === (12))){
var inst_43559 = (state_43599[(7)]);
var inst_43587 = cljs.core.vec(inst_43559);
var state_43599__$1 = state_43599;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43599__$1,(15),out,inst_43587);
} else {
if((state_val_43600 === (2))){
var state_43599__$1 = state_43599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43599__$1,(4),ch);
} else {
if((state_val_43600 === (11))){
var inst_43567 = (state_43599[(10)]);
var inst_43563 = (state_43599[(9)]);
var inst_43577 = (state_43599[(2)]);
var inst_43578 = [];
var inst_43579 = inst_43578.push(inst_43563);
var inst_43559 = inst_43578;
var inst_43560 = inst_43567;
var state_43599__$1 = (function (){var statearr_43611 = state_43599;
(statearr_43611[(11)] = inst_43577);

(statearr_43611[(12)] = inst_43579);

(statearr_43611[(7)] = inst_43559);

(statearr_43611[(8)] = inst_43560);

return statearr_43611;
})();
var statearr_43612_44359 = state_43599__$1;
(statearr_43612_44359[(2)] = null);

(statearr_43612_44359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (9))){
var inst_43559 = (state_43599[(7)]);
var inst_43575 = cljs.core.vec(inst_43559);
var state_43599__$1 = state_43599;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43599__$1,(11),out,inst_43575);
} else {
if((state_val_43600 === (5))){
var inst_43567 = (state_43599[(10)]);
var inst_43563 = (state_43599[(9)]);
var inst_43560 = (state_43599[(8)]);
var inst_43567__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_43563) : f.call(null,inst_43563));
var inst_43568 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43567__$1,inst_43560);
var inst_43569 = cljs.core.keyword_identical_QMARK_(inst_43560,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_43570 = ((inst_43568) || (inst_43569));
var state_43599__$1 = (function (){var statearr_43613 = state_43599;
(statearr_43613[(10)] = inst_43567__$1);

return statearr_43613;
})();
if(cljs.core.truth_(inst_43570)){
var statearr_43614_44360 = state_43599__$1;
(statearr_43614_44360[(1)] = (8));

} else {
var statearr_43615_44361 = state_43599__$1;
(statearr_43615_44361[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (14))){
var inst_43592 = (state_43599[(2)]);
var inst_43593 = cljs.core.async.close_BANG_(out);
var state_43599__$1 = (function (){var statearr_43617 = state_43599;
(statearr_43617[(13)] = inst_43592);

return statearr_43617;
})();
var statearr_43618_44362 = state_43599__$1;
(statearr_43618_44362[(2)] = inst_43593);

(statearr_43618_44362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (10))){
var inst_43582 = (state_43599[(2)]);
var state_43599__$1 = state_43599;
var statearr_43619_44363 = state_43599__$1;
(statearr_43619_44363[(2)] = inst_43582);

(statearr_43619_44363[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43600 === (8))){
var inst_43567 = (state_43599[(10)]);
var inst_43563 = (state_43599[(9)]);
var inst_43559 = (state_43599[(7)]);
var inst_43572 = inst_43559.push(inst_43563);
var tmp43616 = inst_43559;
var inst_43559__$1 = tmp43616;
var inst_43560 = inst_43567;
var state_43599__$1 = (function (){var statearr_43620 = state_43599;
(statearr_43620[(14)] = inst_43572);

(statearr_43620[(7)] = inst_43559__$1);

(statearr_43620[(8)] = inst_43560);

return statearr_43620;
})();
var statearr_43621_44365 = state_43599__$1;
(statearr_43621_44365[(2)] = null);

(statearr_43621_44365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42063__auto__ = null;
var cljs$core$async$state_machine__42063__auto____0 = (function (){
var statearr_43622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43622[(0)] = cljs$core$async$state_machine__42063__auto__);

(statearr_43622[(1)] = (1));

return statearr_43622;
});
var cljs$core$async$state_machine__42063__auto____1 = (function (state_43599){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_43599);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e43623){if((e43623 instanceof Object)){
var ex__42066__auto__ = e43623;
var statearr_43624_44366 = state_43599;
(statearr_43624_44366[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43599);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43623;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44367 = state_43599;
state_43599 = G__44367;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
cljs$core$async$state_machine__42063__auto__ = function(state_43599){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42063__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42063__auto____1.call(this,state_43599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42063__auto____0;
cljs$core$async$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42063__auto____1;
return cljs$core$async$state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_43625 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_43625[(6)] = c__42130__auto___44350);

return statearr_43625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
