goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44615){
var vec__44616 = p__44615;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44616,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44616,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44624 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44624,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44624,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44624,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44624,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44624,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44634 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(4),null);
var vec__44637 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44643 = segmap;
var map__44643__$1 = (((((!((map__44643 == null))))?(((((map__44643.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44643.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44643):map__44643);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44653 = arguments.length;
switch (G__44653) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44664 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45749 = cljs.core.next(segs__$1);
var G__45750 = nrelseg;
var G__45751 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45749;
relseg__$1 = G__45750;
result__$1 = G__45751;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(1),null);
var G__45752 = (gline + (1));
var G__45753 = cljs.core.next(lines__$1);
var G__45754 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45755 = result__$1;
gline = G__45752;
lines__$1 = G__45753;
relseg = G__45754;
result = G__45755;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44672 = segmap;
var map__44672__$1 = (((((!((map__44672 == null))))?(((((map__44672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44672):map__44672);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44672__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44672__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44672__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44672__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44672__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44669_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44669_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44680 = arguments.length;
switch (G__44680) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44695 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45762 = cljs.core.next(segs__$1);
var G__45763 = nrelseg;
var G__45764 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45762;
relseg__$1 = G__45763;
result__$1 = G__45764;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44695,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44695,(1),null);
var G__45765 = (gline + (1));
var G__45766 = cljs.core.next(lines__$1);
var G__45767 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45768 = result__$1;
gline = G__45765;
lines__$1 = G__45766;
relseg = G__45767;
result = G__45768;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44700){
var vec__44701 = p__44700;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44705){
var vec__44710 = p__44705;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(4),null);
var seg = vec__44710;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44714){
var vec__44715 = p__44714;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44729 = cljs.core.seq(infos);
var chunk__44730 = null;
var count__44731 = (0);
var i__44732 = (0);
while(true){
if((i__44732 < count__44731)){
var info = chunk__44730.cljs$core$IIndexed$_nth$arity$2(null,i__44732);
var segv_45790 = info__GT_segv(info,source_idx,line,col);
var gline_45791 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45792 = cljs.core.count(cljs.core.deref(lines));
if((gline_45791 > (lc_45792 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45790,gline_45791,lc_45792,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45791 - (lc_45792 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45790], null));
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45790,gline_45791,lc_45792,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45790,gline_45791,lc_45792,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45791], null),cljs.core.conj,segv_45790);
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45790,gline_45791,lc_45792,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45795 = seq__44729;
var G__45796 = chunk__44730;
var G__45797 = count__44731;
var G__45798 = (i__44732 + (1));
seq__44729 = G__45795;
chunk__44730 = G__45796;
count__44731 = G__45797;
i__44732 = G__45798;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44729);
if(temp__5735__auto__){
var seq__44729__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44729__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44729__$1);
var G__45799 = cljs.core.chunk_rest(seq__44729__$1);
var G__45800 = c__4609__auto__;
var G__45801 = cljs.core.count(c__4609__auto__);
var G__45802 = (0);
seq__44729 = G__45799;
chunk__44730 = G__45800;
count__44731 = G__45801;
i__44732 = G__45802;
continue;
} else {
var info = cljs.core.first(seq__44729__$1);
var segv_45805 = info__GT_segv(info,source_idx,line,col);
var gline_45806 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45807 = cljs.core.count(cljs.core.deref(lines));
if((gline_45806 > (lc_45807 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45805,gline_45806,lc_45807,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45806 - (lc_45807 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45805], null));
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45805,gline_45806,lc_45807,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45805,gline_45806,lc_45807,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45806], null),cljs.core.conj,segv_45805);
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45805,gline_45806,lc_45807,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45810 = cljs.core.next(seq__44729__$1);
var G__45811 = null;
var G__45812 = (0);
var G__45813 = (0);
seq__44729 = G__45810;
chunk__44730 = G__45811;
count__44731 = G__45812;
i__44732 = G__45813;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44748_45814 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44749_45815 = null;
var count__44750_45816 = (0);
var i__44751_45817 = (0);
while(true){
if((i__44751_45817 < count__44750_45816)){
var vec__44965_45821 = chunk__44749_45815.cljs$core$IIndexed$_nth$arity$2(null,i__44751_45817);
var source_idx_45822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44965_45821,(0),null);
var vec__44968_45823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44965_45821,(1),null);
var __45824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44968_45823,(0),null);
var lines_45825__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44968_45823,(1),null);
var seq__44971_45827 = cljs.core.seq(lines_45825__$1);
var chunk__44972_45828 = null;
var count__44973_45829 = (0);
var i__44974_45830 = (0);
while(true){
if((i__44974_45830 < count__44973_45829)){
var vec__45043_45831 = chunk__44972_45828.cljs$core$IIndexed$_nth$arity$2(null,i__44974_45830);
var line_45832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043_45831,(0),null);
var cols_45833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043_45831,(1),null);
var seq__45049_45834 = cljs.core.seq(cols_45833);
var chunk__45050_45835 = null;
var count__45051_45836 = (0);
var i__45052_45837 = (0);
while(true){
if((i__45052_45837 < count__45051_45836)){
var vec__45066_45838 = chunk__45050_45835.cljs$core$IIndexed$_nth$arity$2(null,i__45052_45837);
var col_45839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45066_45838,(0),null);
var infos_45840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45066_45838,(1),null);
encode_cols(infos_45840,source_idx_45822,line_45832,col_45839);


var G__45842 = seq__45049_45834;
var G__45843 = chunk__45050_45835;
var G__45844 = count__45051_45836;
var G__45845 = (i__45052_45837 + (1));
seq__45049_45834 = G__45842;
chunk__45050_45835 = G__45843;
count__45051_45836 = G__45844;
i__45052_45837 = G__45845;
continue;
} else {
var temp__5735__auto___45846 = cljs.core.seq(seq__45049_45834);
if(temp__5735__auto___45846){
var seq__45049_45847__$1 = temp__5735__auto___45846;
if(cljs.core.chunked_seq_QMARK_(seq__45049_45847__$1)){
var c__4609__auto___45848 = cljs.core.chunk_first(seq__45049_45847__$1);
var G__45849 = cljs.core.chunk_rest(seq__45049_45847__$1);
var G__45850 = c__4609__auto___45848;
var G__45851 = cljs.core.count(c__4609__auto___45848);
var G__45852 = (0);
seq__45049_45834 = G__45849;
chunk__45050_45835 = G__45850;
count__45051_45836 = G__45851;
i__45052_45837 = G__45852;
continue;
} else {
var vec__45071_45853 = cljs.core.first(seq__45049_45847__$1);
var col_45854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45071_45853,(0),null);
var infos_45855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45071_45853,(1),null);
encode_cols(infos_45855,source_idx_45822,line_45832,col_45854);


var G__45856 = cljs.core.next(seq__45049_45847__$1);
var G__45857 = null;
var G__45858 = (0);
var G__45859 = (0);
seq__45049_45834 = G__45856;
chunk__45050_45835 = G__45857;
count__45051_45836 = G__45858;
i__45052_45837 = G__45859;
continue;
}
} else {
}
}
break;
}


var G__45861 = seq__44971_45827;
var G__45862 = chunk__44972_45828;
var G__45863 = count__44973_45829;
var G__45864 = (i__44974_45830 + (1));
seq__44971_45827 = G__45861;
chunk__44972_45828 = G__45862;
count__44973_45829 = G__45863;
i__44974_45830 = G__45864;
continue;
} else {
var temp__5735__auto___45866 = cljs.core.seq(seq__44971_45827);
if(temp__5735__auto___45866){
var seq__44971_45868__$1 = temp__5735__auto___45866;
if(cljs.core.chunked_seq_QMARK_(seq__44971_45868__$1)){
var c__4609__auto___45869 = cljs.core.chunk_first(seq__44971_45868__$1);
var G__45870 = cljs.core.chunk_rest(seq__44971_45868__$1);
var G__45871 = c__4609__auto___45869;
var G__45872 = cljs.core.count(c__4609__auto___45869);
var G__45873 = (0);
seq__44971_45827 = G__45870;
chunk__44972_45828 = G__45871;
count__44973_45829 = G__45872;
i__44974_45830 = G__45873;
continue;
} else {
var vec__45074_45874 = cljs.core.first(seq__44971_45868__$1);
var line_45875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45074_45874,(0),null);
var cols_45876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45074_45874,(1),null);
var seq__45081_45877 = cljs.core.seq(cols_45876);
var chunk__45082_45878 = null;
var count__45083_45879 = (0);
var i__45084_45880 = (0);
while(true){
if((i__45084_45880 < count__45083_45879)){
var vec__45101_45881 = chunk__45082_45878.cljs$core$IIndexed$_nth$arity$2(null,i__45084_45880);
var col_45882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45101_45881,(0),null);
var infos_45883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45101_45881,(1),null);
encode_cols(infos_45883,source_idx_45822,line_45875,col_45882);


var G__45884 = seq__45081_45877;
var G__45885 = chunk__45082_45878;
var G__45886 = count__45083_45879;
var G__45887 = (i__45084_45880 + (1));
seq__45081_45877 = G__45884;
chunk__45082_45878 = G__45885;
count__45083_45879 = G__45886;
i__45084_45880 = G__45887;
continue;
} else {
var temp__5735__auto___45888__$1 = cljs.core.seq(seq__45081_45877);
if(temp__5735__auto___45888__$1){
var seq__45081_45889__$1 = temp__5735__auto___45888__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45081_45889__$1)){
var c__4609__auto___45890 = cljs.core.chunk_first(seq__45081_45889__$1);
var G__45891 = cljs.core.chunk_rest(seq__45081_45889__$1);
var G__45892 = c__4609__auto___45890;
var G__45893 = cljs.core.count(c__4609__auto___45890);
var G__45894 = (0);
seq__45081_45877 = G__45891;
chunk__45082_45878 = G__45892;
count__45083_45879 = G__45893;
i__45084_45880 = G__45894;
continue;
} else {
var vec__45109_45895 = cljs.core.first(seq__45081_45889__$1);
var col_45896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45109_45895,(0),null);
var infos_45897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45109_45895,(1),null);
encode_cols(infos_45897,source_idx_45822,line_45875,col_45896);


var G__45898 = cljs.core.next(seq__45081_45889__$1);
var G__45899 = null;
var G__45900 = (0);
var G__45901 = (0);
seq__45081_45877 = G__45898;
chunk__45082_45878 = G__45899;
count__45083_45879 = G__45900;
i__45084_45880 = G__45901;
continue;
}
} else {
}
}
break;
}


var G__45902 = cljs.core.next(seq__44971_45868__$1);
var G__45903 = null;
var G__45904 = (0);
var G__45905 = (0);
seq__44971_45827 = G__45902;
chunk__44972_45828 = G__45903;
count__44973_45829 = G__45904;
i__44974_45830 = G__45905;
continue;
}
} else {
}
}
break;
}


var G__45906 = seq__44748_45814;
var G__45907 = chunk__44749_45815;
var G__45908 = count__44750_45816;
var G__45909 = (i__44751_45817 + (1));
seq__44748_45814 = G__45906;
chunk__44749_45815 = G__45907;
count__44750_45816 = G__45908;
i__44751_45817 = G__45909;
continue;
} else {
var temp__5735__auto___45910 = cljs.core.seq(seq__44748_45814);
if(temp__5735__auto___45910){
var seq__44748_45911__$1 = temp__5735__auto___45910;
if(cljs.core.chunked_seq_QMARK_(seq__44748_45911__$1)){
var c__4609__auto___45912 = cljs.core.chunk_first(seq__44748_45911__$1);
var G__45913 = cljs.core.chunk_rest(seq__44748_45911__$1);
var G__45914 = c__4609__auto___45912;
var G__45915 = cljs.core.count(c__4609__auto___45912);
var G__45916 = (0);
seq__44748_45814 = G__45913;
chunk__44749_45815 = G__45914;
count__44750_45816 = G__45915;
i__44751_45817 = G__45916;
continue;
} else {
var vec__45117_45917 = cljs.core.first(seq__44748_45911__$1);
var source_idx_45918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45117_45917,(0),null);
var vec__45120_45919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45117_45917,(1),null);
var __45920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45919,(0),null);
var lines_45921__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45919,(1),null);
var seq__45123_45922 = cljs.core.seq(lines_45921__$1);
var chunk__45124_45923 = null;
var count__45125_45924 = (0);
var i__45126_45925 = (0);
while(true){
if((i__45126_45925 < count__45125_45924)){
var vec__45177_45926 = chunk__45124_45923.cljs$core$IIndexed$_nth$arity$2(null,i__45126_45925);
var line_45927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45177_45926,(0),null);
var cols_45928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45177_45926,(1),null);
var seq__45180_45929 = cljs.core.seq(cols_45928);
var chunk__45181_45930 = null;
var count__45182_45931 = (0);
var i__45183_45932 = (0);
while(true){
if((i__45183_45932 < count__45182_45931)){
var vec__45198_45933 = chunk__45181_45930.cljs$core$IIndexed$_nth$arity$2(null,i__45183_45932);
var col_45934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45198_45933,(0),null);
var infos_45935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45198_45933,(1),null);
encode_cols(infos_45935,source_idx_45918,line_45927,col_45934);


var G__45936 = seq__45180_45929;
var G__45937 = chunk__45181_45930;
var G__45938 = count__45182_45931;
var G__45939 = (i__45183_45932 + (1));
seq__45180_45929 = G__45936;
chunk__45181_45930 = G__45937;
count__45182_45931 = G__45938;
i__45183_45932 = G__45939;
continue;
} else {
var temp__5735__auto___45940__$1 = cljs.core.seq(seq__45180_45929);
if(temp__5735__auto___45940__$1){
var seq__45180_45941__$1 = temp__5735__auto___45940__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45180_45941__$1)){
var c__4609__auto___45942 = cljs.core.chunk_first(seq__45180_45941__$1);
var G__45943 = cljs.core.chunk_rest(seq__45180_45941__$1);
var G__45944 = c__4609__auto___45942;
var G__45945 = cljs.core.count(c__4609__auto___45942);
var G__45946 = (0);
seq__45180_45929 = G__45943;
chunk__45181_45930 = G__45944;
count__45182_45931 = G__45945;
i__45183_45932 = G__45946;
continue;
} else {
var vec__45202_45947 = cljs.core.first(seq__45180_45941__$1);
var col_45948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45202_45947,(0),null);
var infos_45949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45202_45947,(1),null);
encode_cols(infos_45949,source_idx_45918,line_45927,col_45948);


var G__45950 = cljs.core.next(seq__45180_45941__$1);
var G__45951 = null;
var G__45952 = (0);
var G__45953 = (0);
seq__45180_45929 = G__45950;
chunk__45181_45930 = G__45951;
count__45182_45931 = G__45952;
i__45183_45932 = G__45953;
continue;
}
} else {
}
}
break;
}


var G__45954 = seq__45123_45922;
var G__45955 = chunk__45124_45923;
var G__45956 = count__45125_45924;
var G__45957 = (i__45126_45925 + (1));
seq__45123_45922 = G__45954;
chunk__45124_45923 = G__45955;
count__45125_45924 = G__45956;
i__45126_45925 = G__45957;
continue;
} else {
var temp__5735__auto___45958__$1 = cljs.core.seq(seq__45123_45922);
if(temp__5735__auto___45958__$1){
var seq__45123_45959__$1 = temp__5735__auto___45958__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45123_45959__$1)){
var c__4609__auto___45960 = cljs.core.chunk_first(seq__45123_45959__$1);
var G__45961 = cljs.core.chunk_rest(seq__45123_45959__$1);
var G__45962 = c__4609__auto___45960;
var G__45963 = cljs.core.count(c__4609__auto___45960);
var G__45964 = (0);
seq__45123_45922 = G__45961;
chunk__45124_45923 = G__45962;
count__45125_45924 = G__45963;
i__45126_45925 = G__45964;
continue;
} else {
var vec__45209_45965 = cljs.core.first(seq__45123_45959__$1);
var line_45966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45209_45965,(0),null);
var cols_45967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45209_45965,(1),null);
var seq__45212_45968 = cljs.core.seq(cols_45967);
var chunk__45213_45969 = null;
var count__45214_45970 = (0);
var i__45215_45971 = (0);
while(true){
if((i__45215_45971 < count__45214_45970)){
var vec__45222_45972 = chunk__45213_45969.cljs$core$IIndexed$_nth$arity$2(null,i__45215_45971);
var col_45973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45972,(0),null);
var infos_45974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45972,(1),null);
encode_cols(infos_45974,source_idx_45918,line_45966,col_45973);


var G__45975 = seq__45212_45968;
var G__45976 = chunk__45213_45969;
var G__45977 = count__45214_45970;
var G__45978 = (i__45215_45971 + (1));
seq__45212_45968 = G__45975;
chunk__45213_45969 = G__45976;
count__45214_45970 = G__45977;
i__45215_45971 = G__45978;
continue;
} else {
var temp__5735__auto___45979__$2 = cljs.core.seq(seq__45212_45968);
if(temp__5735__auto___45979__$2){
var seq__45212_45980__$1 = temp__5735__auto___45979__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45212_45980__$1)){
var c__4609__auto___45981 = cljs.core.chunk_first(seq__45212_45980__$1);
var G__45982 = cljs.core.chunk_rest(seq__45212_45980__$1);
var G__45983 = c__4609__auto___45981;
var G__45984 = cljs.core.count(c__4609__auto___45981);
var G__45985 = (0);
seq__45212_45968 = G__45982;
chunk__45213_45969 = G__45983;
count__45214_45970 = G__45984;
i__45215_45971 = G__45985;
continue;
} else {
var vec__45225_45986 = cljs.core.first(seq__45212_45980__$1);
var col_45987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45225_45986,(0),null);
var infos_45988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45225_45986,(1),null);
encode_cols(infos_45988,source_idx_45918,line_45966,col_45987);


var G__45989 = cljs.core.next(seq__45212_45980__$1);
var G__45990 = null;
var G__45991 = (0);
var G__45992 = (0);
seq__45212_45968 = G__45989;
chunk__45213_45969 = G__45990;
count__45214_45970 = G__45991;
i__45215_45971 = G__45992;
continue;
}
} else {
}
}
break;
}


var G__45993 = cljs.core.next(seq__45123_45959__$1);
var G__45994 = null;
var G__45995 = (0);
var G__45996 = (0);
seq__45123_45922 = G__45993;
chunk__45124_45923 = G__45994;
count__45125_45924 = G__45995;
i__45126_45925 = G__45996;
continue;
}
} else {
}
}
break;
}


var G__45997 = cljs.core.next(seq__44748_45911__$1);
var G__45998 = null;
var G__45999 = (0);
var G__46000 = (0);
seq__44748_45814 = G__45997;
chunk__44749_45815 = G__45998;
count__44750_45816 = G__45999;
i__44751_45817 = G__46000;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45228 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44722_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44722_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44723_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44723_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44724_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44724_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45229 = G__45228;
var G__45230_46002 = G__45229;
var G__45231_46003 = "sourcesContent";
var G__45232_46004 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45230_46002,G__45231_46003,G__45232_46004);

return G__45229;
} else {
return G__45228;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45234 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45234,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45234,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45238 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45238,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45238,(1),null);
var G__46005 = cljs.core.next(col_map_seq);
var G__46006 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45238,col,infos,vec__45234,line,col_map){
return (function (v,p__45244){
var map__45245 = p__45244;
var map__45245__$1 = (((((!((map__45245 == null))))?(((((map__45245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45245.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45245):map__45245);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45245__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45245__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45238,col,infos,vec__45234,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46005;
new_cols = G__46006;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46007 = cljs.core.next(line_map_seq);
var G__46008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46007;
new_lines = G__46008;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45247_46009 = cljs.core.seq(reverse_map);
var chunk__45248_46010 = null;
var count__45249_46011 = (0);
var i__45250_46012 = (0);
while(true){
if((i__45250_46012 < count__45249_46011)){
var vec__45500_46013 = chunk__45248_46010.cljs$core$IIndexed$_nth$arity$2(null,i__45250_46012);
var line_46014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45500_46013,(0),null);
var columns_46015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45500_46013,(1),null);
var seq__45503_46016 = cljs.core.seq(columns_46015);
var chunk__45504_46017 = null;
var count__45505_46018 = (0);
var i__45506_46019 = (0);
while(true){
if((i__45506_46019 < count__45505_46018)){
var vec__45567_46020 = chunk__45504_46017.cljs$core$IIndexed$_nth$arity$2(null,i__45506_46019);
var column_46021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45567_46020,(0),null);
var column_info_46022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45567_46020,(1),null);
var seq__45570_46023 = cljs.core.seq(column_info_46022);
var chunk__45571_46024 = null;
var count__45572_46025 = (0);
var i__45573_46026 = (0);
while(true){
if((i__45573_46026 < count__45572_46025)){
var map__45584_46027 = chunk__45571_46024.cljs$core$IIndexed$_nth$arity$2(null,i__45573_46026);
var map__45584_46028__$1 = (((((!((map__45584_46027 == null))))?(((((map__45584_46027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45584_46027.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45584_46027):map__45584_46027);
var gline_46029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45584_46028__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45584_46028__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45584_46028__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46029], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45570_46023,chunk__45571_46024,count__45572_46025,i__45573_46026,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45584_46027,map__45584_46028__$1,gline_46029,gcol_46030,name_46031,vec__45567_46020,column_46021,column_info_46022,vec__45500_46013,line_46014,columns_46015,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46030], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46014,new cljs.core.Keyword(null,"col","col",-1959363084),column_46021,new cljs.core.Keyword(null,"name","name",1843675177),name_46031], null));
});})(seq__45570_46023,chunk__45571_46024,count__45572_46025,i__45573_46026,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45584_46027,map__45584_46028__$1,gline_46029,gcol_46030,name_46031,vec__45567_46020,column_46021,column_info_46022,vec__45500_46013,line_46014,columns_46015,inverted))
,cljs.core.sorted_map()));


var G__46032 = seq__45570_46023;
var G__46033 = chunk__45571_46024;
var G__46034 = count__45572_46025;
var G__46035 = (i__45573_46026 + (1));
seq__45570_46023 = G__46032;
chunk__45571_46024 = G__46033;
count__45572_46025 = G__46034;
i__45573_46026 = G__46035;
continue;
} else {
var temp__5735__auto___46036 = cljs.core.seq(seq__45570_46023);
if(temp__5735__auto___46036){
var seq__45570_46037__$1 = temp__5735__auto___46036;
if(cljs.core.chunked_seq_QMARK_(seq__45570_46037__$1)){
var c__4609__auto___46038 = cljs.core.chunk_first(seq__45570_46037__$1);
var G__46039 = cljs.core.chunk_rest(seq__45570_46037__$1);
var G__46040 = c__4609__auto___46038;
var G__46041 = cljs.core.count(c__4609__auto___46038);
var G__46042 = (0);
seq__45570_46023 = G__46039;
chunk__45571_46024 = G__46040;
count__45572_46025 = G__46041;
i__45573_46026 = G__46042;
continue;
} else {
var map__45594_46043 = cljs.core.first(seq__45570_46037__$1);
var map__45594_46044__$1 = (((((!((map__45594_46043 == null))))?(((((map__45594_46043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45594_46043.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45594_46043):map__45594_46043);
var gline_46045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45594_46044__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45594_46044__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45594_46044__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46045], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45570_46023,chunk__45571_46024,count__45572_46025,i__45573_46026,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45594_46043,map__45594_46044__$1,gline_46045,gcol_46046,name_46047,seq__45570_46037__$1,temp__5735__auto___46036,vec__45567_46020,column_46021,column_info_46022,vec__45500_46013,line_46014,columns_46015,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46046], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46014,new cljs.core.Keyword(null,"col","col",-1959363084),column_46021,new cljs.core.Keyword(null,"name","name",1843675177),name_46047], null));
});})(seq__45570_46023,chunk__45571_46024,count__45572_46025,i__45573_46026,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45594_46043,map__45594_46044__$1,gline_46045,gcol_46046,name_46047,seq__45570_46037__$1,temp__5735__auto___46036,vec__45567_46020,column_46021,column_info_46022,vec__45500_46013,line_46014,columns_46015,inverted))
,cljs.core.sorted_map()));


var G__46048 = cljs.core.next(seq__45570_46037__$1);
var G__46049 = null;
var G__46050 = (0);
var G__46051 = (0);
seq__45570_46023 = G__46048;
chunk__45571_46024 = G__46049;
count__45572_46025 = G__46050;
i__45573_46026 = G__46051;
continue;
}
} else {
}
}
break;
}


var G__46052 = seq__45503_46016;
var G__46053 = chunk__45504_46017;
var G__46054 = count__45505_46018;
var G__46055 = (i__45506_46019 + (1));
seq__45503_46016 = G__46052;
chunk__45504_46017 = G__46053;
count__45505_46018 = G__46054;
i__45506_46019 = G__46055;
continue;
} else {
var temp__5735__auto___46056 = cljs.core.seq(seq__45503_46016);
if(temp__5735__auto___46056){
var seq__45503_46057__$1 = temp__5735__auto___46056;
if(cljs.core.chunked_seq_QMARK_(seq__45503_46057__$1)){
var c__4609__auto___46058 = cljs.core.chunk_first(seq__45503_46057__$1);
var G__46059 = cljs.core.chunk_rest(seq__45503_46057__$1);
var G__46060 = c__4609__auto___46058;
var G__46061 = cljs.core.count(c__4609__auto___46058);
var G__46062 = (0);
seq__45503_46016 = G__46059;
chunk__45504_46017 = G__46060;
count__45505_46018 = G__46061;
i__45506_46019 = G__46062;
continue;
} else {
var vec__45600_46063 = cljs.core.first(seq__45503_46057__$1);
var column_46064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45600_46063,(0),null);
var column_info_46065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45600_46063,(1),null);
var seq__45603_46066 = cljs.core.seq(column_info_46065);
var chunk__45604_46067 = null;
var count__45605_46068 = (0);
var i__45606_46069 = (0);
while(true){
if((i__45606_46069 < count__45605_46068)){
var map__45614_46070 = chunk__45604_46067.cljs$core$IIndexed$_nth$arity$2(null,i__45606_46069);
var map__45614_46071__$1 = (((((!((map__45614_46070 == null))))?(((((map__45614_46070.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45614_46070.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45614_46070):map__45614_46070);
var gline_46072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45614_46071__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46073 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45614_46071__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46074 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45614_46071__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46072], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45603_46066,chunk__45604_46067,count__45605_46068,i__45606_46069,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45614_46070,map__45614_46071__$1,gline_46072,gcol_46073,name_46074,vec__45600_46063,column_46064,column_info_46065,seq__45503_46057__$1,temp__5735__auto___46056,vec__45500_46013,line_46014,columns_46015,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46073], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46014,new cljs.core.Keyword(null,"col","col",-1959363084),column_46064,new cljs.core.Keyword(null,"name","name",1843675177),name_46074], null));
});})(seq__45603_46066,chunk__45604_46067,count__45605_46068,i__45606_46069,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45614_46070,map__45614_46071__$1,gline_46072,gcol_46073,name_46074,vec__45600_46063,column_46064,column_info_46065,seq__45503_46057__$1,temp__5735__auto___46056,vec__45500_46013,line_46014,columns_46015,inverted))
,cljs.core.sorted_map()));


var G__46079 = seq__45603_46066;
var G__46080 = chunk__45604_46067;
var G__46081 = count__45605_46068;
var G__46082 = (i__45606_46069 + (1));
seq__45603_46066 = G__46079;
chunk__45604_46067 = G__46080;
count__45605_46068 = G__46081;
i__45606_46069 = G__46082;
continue;
} else {
var temp__5735__auto___46083__$1 = cljs.core.seq(seq__45603_46066);
if(temp__5735__auto___46083__$1){
var seq__45603_46084__$1 = temp__5735__auto___46083__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45603_46084__$1)){
var c__4609__auto___46085 = cljs.core.chunk_first(seq__45603_46084__$1);
var G__46086 = cljs.core.chunk_rest(seq__45603_46084__$1);
var G__46087 = c__4609__auto___46085;
var G__46088 = cljs.core.count(c__4609__auto___46085);
var G__46089 = (0);
seq__45603_46066 = G__46086;
chunk__45604_46067 = G__46087;
count__45605_46068 = G__46088;
i__45606_46069 = G__46089;
continue;
} else {
var map__45620_46091 = cljs.core.first(seq__45603_46084__$1);
var map__45620_46092__$1 = (((((!((map__45620_46091 == null))))?(((((map__45620_46091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45620_46091.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45620_46091):map__45620_46091);
var gline_46093 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45620_46092__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45620_46092__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46095 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45620_46092__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46093], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45603_46066,chunk__45604_46067,count__45605_46068,i__45606_46069,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45620_46091,map__45620_46092__$1,gline_46093,gcol_46094,name_46095,seq__45603_46084__$1,temp__5735__auto___46083__$1,vec__45600_46063,column_46064,column_info_46065,seq__45503_46057__$1,temp__5735__auto___46056,vec__45500_46013,line_46014,columns_46015,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46094], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46014,new cljs.core.Keyword(null,"col","col",-1959363084),column_46064,new cljs.core.Keyword(null,"name","name",1843675177),name_46095], null));
});})(seq__45603_46066,chunk__45604_46067,count__45605_46068,i__45606_46069,seq__45503_46016,chunk__45504_46017,count__45505_46018,i__45506_46019,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45620_46091,map__45620_46092__$1,gline_46093,gcol_46094,name_46095,seq__45603_46084__$1,temp__5735__auto___46083__$1,vec__45600_46063,column_46064,column_info_46065,seq__45503_46057__$1,temp__5735__auto___46056,vec__45500_46013,line_46014,columns_46015,inverted))
,cljs.core.sorted_map()));


var G__46099 = cljs.core.next(seq__45603_46084__$1);
var G__46100 = null;
var G__46101 = (0);
var G__46102 = (0);
seq__45603_46066 = G__46099;
chunk__45604_46067 = G__46100;
count__45605_46068 = G__46101;
i__45606_46069 = G__46102;
continue;
}
} else {
}
}
break;
}


var G__46103 = cljs.core.next(seq__45503_46057__$1);
var G__46104 = null;
var G__46105 = (0);
var G__46106 = (0);
seq__45503_46016 = G__46103;
chunk__45504_46017 = G__46104;
count__45505_46018 = G__46105;
i__45506_46019 = G__46106;
continue;
}
} else {
}
}
break;
}


var G__46107 = seq__45247_46009;
var G__46108 = chunk__45248_46010;
var G__46109 = count__45249_46011;
var G__46110 = (i__45250_46012 + (1));
seq__45247_46009 = G__46107;
chunk__45248_46010 = G__46108;
count__45249_46011 = G__46109;
i__45250_46012 = G__46110;
continue;
} else {
var temp__5735__auto___46111 = cljs.core.seq(seq__45247_46009);
if(temp__5735__auto___46111){
var seq__45247_46112__$1 = temp__5735__auto___46111;
if(cljs.core.chunked_seq_QMARK_(seq__45247_46112__$1)){
var c__4609__auto___46113 = cljs.core.chunk_first(seq__45247_46112__$1);
var G__46114 = cljs.core.chunk_rest(seq__45247_46112__$1);
var G__46115 = c__4609__auto___46113;
var G__46116 = cljs.core.count(c__4609__auto___46113);
var G__46117 = (0);
seq__45247_46009 = G__46114;
chunk__45248_46010 = G__46115;
count__45249_46011 = G__46116;
i__45250_46012 = G__46117;
continue;
} else {
var vec__45624_46118 = cljs.core.first(seq__45247_46112__$1);
var line_46119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45624_46118,(0),null);
var columns_46120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45624_46118,(1),null);
var seq__45628_46121 = cljs.core.seq(columns_46120);
var chunk__45629_46122 = null;
var count__45630_46123 = (0);
var i__45631_46124 = (0);
while(true){
if((i__45631_46124 < count__45630_46123)){
var vec__45693_46125 = chunk__45629_46122.cljs$core$IIndexed$_nth$arity$2(null,i__45631_46124);
var column_46126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45693_46125,(0),null);
var column_info_46127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45693_46125,(1),null);
var seq__45696_46128 = cljs.core.seq(column_info_46127);
var chunk__45697_46129 = null;
var count__45698_46130 = (0);
var i__45699_46131 = (0);
while(true){
if((i__45699_46131 < count__45698_46130)){
var map__45713_46132 = chunk__45697_46129.cljs$core$IIndexed$_nth$arity$2(null,i__45699_46131);
var map__45713_46133__$1 = (((((!((map__45713_46132 == null))))?(((((map__45713_46132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45713_46132.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45713_46132):map__45713_46132);
var gline_46134 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45713_46133__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46135 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45713_46133__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45713_46133__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46134], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45696_46128,chunk__45697_46129,count__45698_46130,i__45699_46131,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45713_46132,map__45713_46133__$1,gline_46134,gcol_46135,name_46136,vec__45693_46125,column_46126,column_info_46127,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46135], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46119,new cljs.core.Keyword(null,"col","col",-1959363084),column_46126,new cljs.core.Keyword(null,"name","name",1843675177),name_46136], null));
});})(seq__45696_46128,chunk__45697_46129,count__45698_46130,i__45699_46131,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45713_46132,map__45713_46133__$1,gline_46134,gcol_46135,name_46136,vec__45693_46125,column_46126,column_info_46127,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted))
,cljs.core.sorted_map()));


var G__46141 = seq__45696_46128;
var G__46142 = chunk__45697_46129;
var G__46143 = count__45698_46130;
var G__46144 = (i__45699_46131 + (1));
seq__45696_46128 = G__46141;
chunk__45697_46129 = G__46142;
count__45698_46130 = G__46143;
i__45699_46131 = G__46144;
continue;
} else {
var temp__5735__auto___46145__$1 = cljs.core.seq(seq__45696_46128);
if(temp__5735__auto___46145__$1){
var seq__45696_46146__$1 = temp__5735__auto___46145__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45696_46146__$1)){
var c__4609__auto___46147 = cljs.core.chunk_first(seq__45696_46146__$1);
var G__46148 = cljs.core.chunk_rest(seq__45696_46146__$1);
var G__46149 = c__4609__auto___46147;
var G__46150 = cljs.core.count(c__4609__auto___46147);
var G__46151 = (0);
seq__45696_46128 = G__46148;
chunk__45697_46129 = G__46149;
count__45698_46130 = G__46150;
i__45699_46131 = G__46151;
continue;
} else {
var map__45717_46152 = cljs.core.first(seq__45696_46146__$1);
var map__45717_46153__$1 = (((((!((map__45717_46152 == null))))?(((((map__45717_46152.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45717_46152.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45717_46152):map__45717_46152);
var gline_46154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45717_46153__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45717_46153__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45717_46153__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46154], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45696_46128,chunk__45697_46129,count__45698_46130,i__45699_46131,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45717_46152,map__45717_46153__$1,gline_46154,gcol_46155,name_46156,seq__45696_46146__$1,temp__5735__auto___46145__$1,vec__45693_46125,column_46126,column_info_46127,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46155], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46119,new cljs.core.Keyword(null,"col","col",-1959363084),column_46126,new cljs.core.Keyword(null,"name","name",1843675177),name_46156], null));
});})(seq__45696_46128,chunk__45697_46129,count__45698_46130,i__45699_46131,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45717_46152,map__45717_46153__$1,gline_46154,gcol_46155,name_46156,seq__45696_46146__$1,temp__5735__auto___46145__$1,vec__45693_46125,column_46126,column_info_46127,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted))
,cljs.core.sorted_map()));


var G__46159 = cljs.core.next(seq__45696_46146__$1);
var G__46160 = null;
var G__46161 = (0);
var G__46162 = (0);
seq__45696_46128 = G__46159;
chunk__45697_46129 = G__46160;
count__45698_46130 = G__46161;
i__45699_46131 = G__46162;
continue;
}
} else {
}
}
break;
}


var G__46163 = seq__45628_46121;
var G__46164 = chunk__45629_46122;
var G__46165 = count__45630_46123;
var G__46166 = (i__45631_46124 + (1));
seq__45628_46121 = G__46163;
chunk__45629_46122 = G__46164;
count__45630_46123 = G__46165;
i__45631_46124 = G__46166;
continue;
} else {
var temp__5735__auto___46167__$1 = cljs.core.seq(seq__45628_46121);
if(temp__5735__auto___46167__$1){
var seq__45628_46168__$1 = temp__5735__auto___46167__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45628_46168__$1)){
var c__4609__auto___46169 = cljs.core.chunk_first(seq__45628_46168__$1);
var G__46170 = cljs.core.chunk_rest(seq__45628_46168__$1);
var G__46171 = c__4609__auto___46169;
var G__46172 = cljs.core.count(c__4609__auto___46169);
var G__46173 = (0);
seq__45628_46121 = G__46170;
chunk__45629_46122 = G__46171;
count__45630_46123 = G__46172;
i__45631_46124 = G__46173;
continue;
} else {
var vec__45720_46174 = cljs.core.first(seq__45628_46168__$1);
var column_46175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46174,(0),null);
var column_info_46176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46174,(1),null);
var seq__45723_46179 = cljs.core.seq(column_info_46176);
var chunk__45724_46180 = null;
var count__45725_46181 = (0);
var i__45726_46182 = (0);
while(true){
if((i__45726_46182 < count__45725_46181)){
var map__45731_46183 = chunk__45724_46180.cljs$core$IIndexed$_nth$arity$2(null,i__45726_46182);
var map__45731_46184__$1 = (((((!((map__45731_46183 == null))))?(((((map__45731_46183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45731_46183.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45731_46183):map__45731_46183);
var gline_46185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46184__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46184__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46187 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46184__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46185], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46179,chunk__45724_46180,count__45725_46181,i__45726_46182,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45731_46183,map__45731_46184__$1,gline_46185,gcol_46186,name_46187,vec__45720_46174,column_46175,column_info_46176,seq__45628_46168__$1,temp__5735__auto___46167__$1,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46186], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46119,new cljs.core.Keyword(null,"col","col",-1959363084),column_46175,new cljs.core.Keyword(null,"name","name",1843675177),name_46187], null));
});})(seq__45723_46179,chunk__45724_46180,count__45725_46181,i__45726_46182,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45731_46183,map__45731_46184__$1,gline_46185,gcol_46186,name_46187,vec__45720_46174,column_46175,column_info_46176,seq__45628_46168__$1,temp__5735__auto___46167__$1,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted))
,cljs.core.sorted_map()));


var G__46190 = seq__45723_46179;
var G__46191 = chunk__45724_46180;
var G__46192 = count__45725_46181;
var G__46193 = (i__45726_46182 + (1));
seq__45723_46179 = G__46190;
chunk__45724_46180 = G__46191;
count__45725_46181 = G__46192;
i__45726_46182 = G__46193;
continue;
} else {
var temp__5735__auto___46194__$2 = cljs.core.seq(seq__45723_46179);
if(temp__5735__auto___46194__$2){
var seq__45723_46195__$1 = temp__5735__auto___46194__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45723_46195__$1)){
var c__4609__auto___46196 = cljs.core.chunk_first(seq__45723_46195__$1);
var G__46197 = cljs.core.chunk_rest(seq__45723_46195__$1);
var G__46198 = c__4609__auto___46196;
var G__46200 = cljs.core.count(c__4609__auto___46196);
var G__46201 = (0);
seq__45723_46179 = G__46197;
chunk__45724_46180 = G__46198;
count__45725_46181 = G__46200;
i__45726_46182 = G__46201;
continue;
} else {
var map__45738_46203 = cljs.core.first(seq__45723_46195__$1);
var map__45738_46204__$1 = (((((!((map__45738_46203 == null))))?(((((map__45738_46203.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45738_46203.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45738_46203):map__45738_46203);
var gline_46205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45738_46204__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45738_46204__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45738_46204__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46205], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46179,chunk__45724_46180,count__45725_46181,i__45726_46182,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45738_46203,map__45738_46204__$1,gline_46205,gcol_46206,name_46207,seq__45723_46195__$1,temp__5735__auto___46194__$2,vec__45720_46174,column_46175,column_info_46176,seq__45628_46168__$1,temp__5735__auto___46167__$1,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46206], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46119,new cljs.core.Keyword(null,"col","col",-1959363084),column_46175,new cljs.core.Keyword(null,"name","name",1843675177),name_46207], null));
});})(seq__45723_46179,chunk__45724_46180,count__45725_46181,i__45726_46182,seq__45628_46121,chunk__45629_46122,count__45630_46123,i__45631_46124,seq__45247_46009,chunk__45248_46010,count__45249_46011,i__45250_46012,map__45738_46203,map__45738_46204__$1,gline_46205,gcol_46206,name_46207,seq__45723_46195__$1,temp__5735__auto___46194__$2,vec__45720_46174,column_46175,column_info_46176,seq__45628_46168__$1,temp__5735__auto___46167__$1,vec__45624_46118,line_46119,columns_46120,seq__45247_46112__$1,temp__5735__auto___46111,inverted))
,cljs.core.sorted_map()));


var G__46215 = cljs.core.next(seq__45723_46195__$1);
var G__46216 = null;
var G__46217 = (0);
var G__46218 = (0);
seq__45723_46179 = G__46215;
chunk__45724_46180 = G__46216;
count__45725_46181 = G__46217;
i__45726_46182 = G__46218;
continue;
}
} else {
}
}
break;
}


var G__46220 = cljs.core.next(seq__45628_46168__$1);
var G__46221 = null;
var G__46222 = (0);
var G__46223 = (0);
seq__45628_46121 = G__46220;
chunk__45629_46122 = G__46221;
count__45630_46123 = G__46222;
i__45631_46124 = G__46223;
continue;
}
} else {
}
}
break;
}


var G__46224 = cljs.core.next(seq__45247_46112__$1);
var G__46225 = null;
var G__46226 = (0);
var G__46227 = (0);
seq__45247_46009 = G__46224;
chunk__45248_46010 = G__46225;
count__45249_46011 = G__46226;
i__45250_46012 = G__46227;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
