goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__26172 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__26173 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__26173);

try{try{var seq__26174 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__26175 = null;
var count__26176 = (0);
var i__26177 = (0);
while(true){
if((i__26177 < count__26176)){
var vec__26184 = chunk__26175.cljs$core$IIndexed$_nth$arity$2(null,i__26177);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26184,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26184,(1),null);
var temp__5733__auto___26229 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26229)){
var effect_fn_26230 = temp__5733__auto___26229;
(effect_fn_26230.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26230.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26230.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26231 = seq__26174;
var G__26232 = chunk__26175;
var G__26233 = count__26176;
var G__26234 = (i__26177 + (1));
seq__26174 = G__26231;
chunk__26175 = G__26232;
count__26176 = G__26233;
i__26177 = G__26234;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26174);
if(temp__5735__auto__){
var seq__26174__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26174__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26174__$1);
var G__26235 = cljs.core.chunk_rest(seq__26174__$1);
var G__26236 = c__4609__auto__;
var G__26237 = cljs.core.count(c__4609__auto__);
var G__26238 = (0);
seq__26174 = G__26235;
chunk__26175 = G__26236;
count__26176 = G__26237;
i__26177 = G__26238;
continue;
} else {
var vec__26187 = cljs.core.first(seq__26174__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26187,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26187,(1),null);
var temp__5733__auto___26239 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26239)){
var effect_fn_26240 = temp__5733__auto___26239;
(effect_fn_26240.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26240.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26240.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26241 = cljs.core.next(seq__26174__$1);
var G__26242 = null;
var G__26243 = (0);
var G__26244 = (0);
seq__26174 = G__26241;
chunk__26175 = G__26242;
count__26176 = G__26243;
i__26177 = G__26244;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__25891__auto___26245 = re_frame.interop.now();
var duration__25892__auto___26246 = (end__25891__auto___26245 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__25892__auto___26246,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__25891__auto___26245);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__26172);
}} else {
var seq__26190 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__26191 = null;
var count__26192 = (0);
var i__26193 = (0);
while(true){
if((i__26193 < count__26192)){
var vec__26202 = chunk__26191.cljs$core$IIndexed$_nth$arity$2(null,i__26193);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26202,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26202,(1),null);
var temp__5733__auto___26247 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26247)){
var effect_fn_26248 = temp__5733__auto___26247;
(effect_fn_26248.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26248.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26248.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26249 = seq__26190;
var G__26250 = chunk__26191;
var G__26251 = count__26192;
var G__26252 = (i__26193 + (1));
seq__26190 = G__26249;
chunk__26191 = G__26250;
count__26192 = G__26251;
i__26193 = G__26252;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26190);
if(temp__5735__auto__){
var seq__26190__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26190__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26190__$1);
var G__26253 = cljs.core.chunk_rest(seq__26190__$1);
var G__26254 = c__4609__auto__;
var G__26255 = cljs.core.count(c__4609__auto__);
var G__26256 = (0);
seq__26190 = G__26253;
chunk__26191 = G__26254;
count__26192 = G__26255;
i__26193 = G__26256;
continue;
} else {
var vec__26205 = cljs.core.first(seq__26190__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26205,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26205,(1),null);
var temp__5733__auto___26257 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26257)){
var effect_fn_26258 = temp__5733__auto___26257;
(effect_fn_26258.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26258.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26258.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26262 = cljs.core.next(seq__26190__$1);
var G__26263 = null;
var G__26264 = (0);
var G__26265 = (0);
seq__26190 = G__26262;
chunk__26191 = G__26263;
count__26192 = G__26264;
i__26193 = G__26265;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__26208 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__26209 = null;
var count__26210 = (0);
var i__26211 = (0);
while(true){
if((i__26211 < count__26210)){
var map__26217 = chunk__26209.cljs$core$IIndexed$_nth$arity$2(null,i__26211);
var map__26217__$1 = (((((!((map__26217 == null))))?(((((map__26217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26217.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26217):map__26217);
var effect = map__26217__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26217__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26217__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__26208,chunk__26209,count__26210,i__26211,map__26217,map__26217__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__26208,chunk__26209,count__26210,i__26211,map__26217,map__26217__$1,effect,ms,dispatch))
,ms);
}


var G__26266 = seq__26208;
var G__26267 = chunk__26209;
var G__26268 = count__26210;
var G__26269 = (i__26211 + (1));
seq__26208 = G__26266;
chunk__26209 = G__26267;
count__26210 = G__26268;
i__26211 = G__26269;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26208);
if(temp__5735__auto__){
var seq__26208__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26208__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26208__$1);
var G__26270 = cljs.core.chunk_rest(seq__26208__$1);
var G__26271 = c__4609__auto__;
var G__26272 = cljs.core.count(c__4609__auto__);
var G__26273 = (0);
seq__26208 = G__26270;
chunk__26209 = G__26271;
count__26210 = G__26272;
i__26211 = G__26273;
continue;
} else {
var map__26219 = cljs.core.first(seq__26208__$1);
var map__26219__$1 = (((((!((map__26219 == null))))?(((((map__26219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26219.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26219):map__26219);
var effect = map__26219__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26219__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26219__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__26208,chunk__26209,count__26210,i__26211,map__26219,map__26219__$1,effect,ms,dispatch,seq__26208__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__26208,chunk__26209,count__26210,i__26211,map__26219,map__26219__$1,effect,ms,dispatch,seq__26208__$1,temp__5735__auto__))
,ms);
}


var G__26278 = cljs.core.next(seq__26208__$1);
var G__26279 = null;
var G__26280 = (0);
var G__26281 = (0);
seq__26208 = G__26278;
chunk__26209 = G__26279;
count__26210 = G__26280;
i__26211 = G__26281;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__26221 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__26222 = null;
var count__26223 = (0);
var i__26224 = (0);
while(true){
if((i__26224 < count__26223)){
var event = chunk__26222.cljs$core$IIndexed$_nth$arity$2(null,i__26224);
re_frame.router.dispatch(event);


var G__26284 = seq__26221;
var G__26285 = chunk__26222;
var G__26286 = count__26223;
var G__26287 = (i__26224 + (1));
seq__26221 = G__26284;
chunk__26222 = G__26285;
count__26223 = G__26286;
i__26224 = G__26287;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26221);
if(temp__5735__auto__){
var seq__26221__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26221__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26221__$1);
var G__26288 = cljs.core.chunk_rest(seq__26221__$1);
var G__26289 = c__4609__auto__;
var G__26290 = cljs.core.count(c__4609__auto__);
var G__26291 = (0);
seq__26221 = G__26288;
chunk__26222 = G__26289;
count__26223 = G__26290;
i__26224 = G__26291;
continue;
} else {
var event = cljs.core.first(seq__26221__$1);
re_frame.router.dispatch(event);


var G__26292 = cljs.core.next(seq__26221__$1);
var G__26293 = null;
var G__26294 = (0);
var G__26295 = (0);
seq__26221 = G__26292;
chunk__26222 = G__26293;
count__26223 = G__26294;
i__26224 = G__26295;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__26225 = cljs.core.seq(value);
var chunk__26226 = null;
var count__26227 = (0);
var i__26228 = (0);
while(true){
if((i__26228 < count__26227)){
var event = chunk__26226.cljs$core$IIndexed$_nth$arity$2(null,i__26228);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__26300 = seq__26225;
var G__26301 = chunk__26226;
var G__26302 = count__26227;
var G__26303 = (i__26228 + (1));
seq__26225 = G__26300;
chunk__26226 = G__26301;
count__26227 = G__26302;
i__26228 = G__26303;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26225);
if(temp__5735__auto__){
var seq__26225__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26225__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26225__$1);
var G__26304 = cljs.core.chunk_rest(seq__26225__$1);
var G__26305 = c__4609__auto__;
var G__26306 = cljs.core.count(c__4609__auto__);
var G__26307 = (0);
seq__26225 = G__26304;
chunk__26226 = G__26305;
count__26227 = G__26306;
i__26228 = G__26307;
continue;
} else {
var event = cljs.core.first(seq__26225__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__26308 = cljs.core.next(seq__26225__$1);
var G__26309 = null;
var G__26310 = (0);
var G__26311 = (0);
seq__26225 = G__26308;
chunk__26226 = G__26309;
count__26227 = G__26310;
i__26228 = G__26311;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
