goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44568){
var vec__44569 = p__44568;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44569,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44569,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44573 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44573,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44573,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44573,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44573,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44573,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44577 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44577,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44577,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44577,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44577,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44577,(4),null);
var vec__44580 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44580,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44580,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44580,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44580,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44580,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44590 = segmap;
var map__44590__$1 = (((((!((map__44590 == null))))?(((((map__44590.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44590.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44590):map__44590);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44590__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44590__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44590__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44590__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44590__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44598 = arguments.length;
switch (G__44598) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44602 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45733 = cljs.core.next(segs__$1);
var G__45734 = nrelseg;
var G__45735 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45733;
relseg__$1 = G__45734;
result__$1 = G__45735;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44602,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44602,(1),null);
var G__45736 = (gline + (1));
var G__45737 = cljs.core.next(lines__$1);
var G__45738 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45739 = result__$1;
gline = G__45736;
lines__$1 = G__45737;
relseg = G__45738;
result = G__45739;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44617 = segmap;
var map__44617__$1 = (((((!((map__44617 == null))))?(((((map__44617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44617.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44617):map__44617);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44617__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44617__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44617__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44617__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44617__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44615_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44615_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44630 = arguments.length;
switch (G__44630) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44648 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45744 = cljs.core.next(segs__$1);
var G__45745 = nrelseg;
var G__45746 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45744;
relseg__$1 = G__45745;
result__$1 = G__45746;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44648,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44648,(1),null);
var G__45747 = (gline + (1));
var G__45748 = cljs.core.next(lines__$1);
var G__45749 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45750 = result__$1;
gline = G__45747;
lines__$1 = G__45748;
relseg = G__45749;
result = G__45750;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44659){
var vec__44660 = p__44659;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44660,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44660,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44660,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44660,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44660,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44665){
var vec__44666 = p__44665;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(4),null);
var seg = vec__44666;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44671){
var vec__44672 = p__44671;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44686 = cljs.core.seq(infos);
var chunk__44687 = null;
var count__44688 = (0);
var i__44689 = (0);
while(true){
if((i__44689 < count__44688)){
var info = chunk__44687.cljs$core$IIndexed$_nth$arity$2(null,i__44689);
var segv_45759 = info__GT_segv(info,source_idx,line,col);
var gline_45760 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45761 = cljs.core.count(cljs.core.deref(lines));
if((gline_45760 > (lc_45761 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44686,chunk__44687,count__44688,i__44689,segv_45759,gline_45760,lc_45761,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45760 - (lc_45761 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45759], null));
});})(seq__44686,chunk__44687,count__44688,i__44689,segv_45759,gline_45760,lc_45761,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44686,chunk__44687,count__44688,i__44689,segv_45759,gline_45760,lc_45761,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45760], null),cljs.core.conj,segv_45759);
});})(seq__44686,chunk__44687,count__44688,i__44689,segv_45759,gline_45760,lc_45761,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45766 = seq__44686;
var G__45767 = chunk__44687;
var G__45768 = count__44688;
var G__45769 = (i__44689 + (1));
seq__44686 = G__45766;
chunk__44687 = G__45767;
count__44688 = G__45768;
i__44689 = G__45769;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44686);
if(temp__5735__auto__){
var seq__44686__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44686__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44686__$1);
var G__45770 = cljs.core.chunk_rest(seq__44686__$1);
var G__45771 = c__4609__auto__;
var G__45772 = cljs.core.count(c__4609__auto__);
var G__45773 = (0);
seq__44686 = G__45770;
chunk__44687 = G__45771;
count__44688 = G__45772;
i__44689 = G__45773;
continue;
} else {
var info = cljs.core.first(seq__44686__$1);
var segv_45774 = info__GT_segv(info,source_idx,line,col);
var gline_45775 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45776 = cljs.core.count(cljs.core.deref(lines));
if((gline_45775 > (lc_45776 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44686,chunk__44687,count__44688,i__44689,segv_45774,gline_45775,lc_45776,info,seq__44686__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45775 - (lc_45776 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45774], null));
});})(seq__44686,chunk__44687,count__44688,i__44689,segv_45774,gline_45775,lc_45776,info,seq__44686__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44686,chunk__44687,count__44688,i__44689,segv_45774,gline_45775,lc_45776,info,seq__44686__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45775], null),cljs.core.conj,segv_45774);
});})(seq__44686,chunk__44687,count__44688,i__44689,segv_45774,gline_45775,lc_45776,info,seq__44686__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45778 = cljs.core.next(seq__44686__$1);
var G__45779 = null;
var G__45780 = (0);
var G__45781 = (0);
seq__44686 = G__45778;
chunk__44687 = G__45779;
count__44688 = G__45780;
i__44689 = G__45781;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44705_45782 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44706_45783 = null;
var count__44707_45784 = (0);
var i__44708_45785 = (0);
while(true){
if((i__44708_45785 < count__44707_45784)){
var vec__44945_45786 = chunk__44706_45783.cljs$core$IIndexed$_nth$arity$2(null,i__44708_45785);
var source_idx_45787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44945_45786,(0),null);
var vec__44948_45788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44945_45786,(1),null);
var __45789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44948_45788,(0),null);
var lines_45790__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44948_45788,(1),null);
var seq__44951_45791 = cljs.core.seq(lines_45790__$1);
var chunk__44952_45792 = null;
var count__44953_45793 = (0);
var i__44954_45794 = (0);
while(true){
if((i__44954_45794 < count__44953_45793)){
var vec__45005_45795 = chunk__44952_45792.cljs$core$IIndexed$_nth$arity$2(null,i__44954_45794);
var line_45796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45005_45795,(0),null);
var cols_45797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45005_45795,(1),null);
var seq__45008_45798 = cljs.core.seq(cols_45797);
var chunk__45009_45799 = null;
var count__45010_45800 = (0);
var i__45011_45801 = (0);
while(true){
if((i__45011_45801 < count__45010_45800)){
var vec__45020_45802 = chunk__45009_45799.cljs$core$IIndexed$_nth$arity$2(null,i__45011_45801);
var col_45803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45020_45802,(0),null);
var infos_45804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45020_45802,(1),null);
encode_cols(infos_45804,source_idx_45787,line_45796,col_45803);


var G__45805 = seq__45008_45798;
var G__45806 = chunk__45009_45799;
var G__45807 = count__45010_45800;
var G__45808 = (i__45011_45801 + (1));
seq__45008_45798 = G__45805;
chunk__45009_45799 = G__45806;
count__45010_45800 = G__45807;
i__45011_45801 = G__45808;
continue;
} else {
var temp__5735__auto___45809 = cljs.core.seq(seq__45008_45798);
if(temp__5735__auto___45809){
var seq__45008_45810__$1 = temp__5735__auto___45809;
if(cljs.core.chunked_seq_QMARK_(seq__45008_45810__$1)){
var c__4609__auto___45811 = cljs.core.chunk_first(seq__45008_45810__$1);
var G__45812 = cljs.core.chunk_rest(seq__45008_45810__$1);
var G__45813 = c__4609__auto___45811;
var G__45814 = cljs.core.count(c__4609__auto___45811);
var G__45815 = (0);
seq__45008_45798 = G__45812;
chunk__45009_45799 = G__45813;
count__45010_45800 = G__45814;
i__45011_45801 = G__45815;
continue;
} else {
var vec__45023_45816 = cljs.core.first(seq__45008_45810__$1);
var col_45817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45023_45816,(0),null);
var infos_45818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45023_45816,(1),null);
encode_cols(infos_45818,source_idx_45787,line_45796,col_45817);


var G__45819 = cljs.core.next(seq__45008_45810__$1);
var G__45820 = null;
var G__45821 = (0);
var G__45822 = (0);
seq__45008_45798 = G__45819;
chunk__45009_45799 = G__45820;
count__45010_45800 = G__45821;
i__45011_45801 = G__45822;
continue;
}
} else {
}
}
break;
}


var G__45823 = seq__44951_45791;
var G__45824 = chunk__44952_45792;
var G__45825 = count__44953_45793;
var G__45826 = (i__44954_45794 + (1));
seq__44951_45791 = G__45823;
chunk__44952_45792 = G__45824;
count__44953_45793 = G__45825;
i__44954_45794 = G__45826;
continue;
} else {
var temp__5735__auto___45827 = cljs.core.seq(seq__44951_45791);
if(temp__5735__auto___45827){
var seq__44951_45828__$1 = temp__5735__auto___45827;
if(cljs.core.chunked_seq_QMARK_(seq__44951_45828__$1)){
var c__4609__auto___45829 = cljs.core.chunk_first(seq__44951_45828__$1);
var G__45830 = cljs.core.chunk_rest(seq__44951_45828__$1);
var G__45831 = c__4609__auto___45829;
var G__45832 = cljs.core.count(c__4609__auto___45829);
var G__45833 = (0);
seq__44951_45791 = G__45830;
chunk__44952_45792 = G__45831;
count__44953_45793 = G__45832;
i__44954_45794 = G__45833;
continue;
} else {
var vec__45028_45834 = cljs.core.first(seq__44951_45828__$1);
var line_45835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45028_45834,(0),null);
var cols_45836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45028_45834,(1),null);
var seq__45031_45837 = cljs.core.seq(cols_45836);
var chunk__45032_45838 = null;
var count__45033_45839 = (0);
var i__45034_45840 = (0);
while(true){
if((i__45034_45840 < count__45033_45839)){
var vec__45041_45841 = chunk__45032_45838.cljs$core$IIndexed$_nth$arity$2(null,i__45034_45840);
var col_45842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45041_45841,(0),null);
var infos_45843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45041_45841,(1),null);
encode_cols(infos_45843,source_idx_45787,line_45835,col_45842);


var G__45844 = seq__45031_45837;
var G__45845 = chunk__45032_45838;
var G__45846 = count__45033_45839;
var G__45847 = (i__45034_45840 + (1));
seq__45031_45837 = G__45844;
chunk__45032_45838 = G__45845;
count__45033_45839 = G__45846;
i__45034_45840 = G__45847;
continue;
} else {
var temp__5735__auto___45848__$1 = cljs.core.seq(seq__45031_45837);
if(temp__5735__auto___45848__$1){
var seq__45031_45849__$1 = temp__5735__auto___45848__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45031_45849__$1)){
var c__4609__auto___45850 = cljs.core.chunk_first(seq__45031_45849__$1);
var G__45851 = cljs.core.chunk_rest(seq__45031_45849__$1);
var G__45852 = c__4609__auto___45850;
var G__45853 = cljs.core.count(c__4609__auto___45850);
var G__45854 = (0);
seq__45031_45837 = G__45851;
chunk__45032_45838 = G__45852;
count__45033_45839 = G__45853;
i__45034_45840 = G__45854;
continue;
} else {
var vec__45044_45855 = cljs.core.first(seq__45031_45849__$1);
var col_45856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45044_45855,(0),null);
var infos_45857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45044_45855,(1),null);
encode_cols(infos_45857,source_idx_45787,line_45835,col_45856);


var G__45858 = cljs.core.next(seq__45031_45849__$1);
var G__45859 = null;
var G__45860 = (0);
var G__45861 = (0);
seq__45031_45837 = G__45858;
chunk__45032_45838 = G__45859;
count__45033_45839 = G__45860;
i__45034_45840 = G__45861;
continue;
}
} else {
}
}
break;
}


var G__45862 = cljs.core.next(seq__44951_45828__$1);
var G__45863 = null;
var G__45864 = (0);
var G__45865 = (0);
seq__44951_45791 = G__45862;
chunk__44952_45792 = G__45863;
count__44953_45793 = G__45864;
i__44954_45794 = G__45865;
continue;
}
} else {
}
}
break;
}


var G__45866 = seq__44705_45782;
var G__45867 = chunk__44706_45783;
var G__45868 = count__44707_45784;
var G__45869 = (i__44708_45785 + (1));
seq__44705_45782 = G__45866;
chunk__44706_45783 = G__45867;
count__44707_45784 = G__45868;
i__44708_45785 = G__45869;
continue;
} else {
var temp__5735__auto___45870 = cljs.core.seq(seq__44705_45782);
if(temp__5735__auto___45870){
var seq__44705_45872__$1 = temp__5735__auto___45870;
if(cljs.core.chunked_seq_QMARK_(seq__44705_45872__$1)){
var c__4609__auto___45873 = cljs.core.chunk_first(seq__44705_45872__$1);
var G__45874 = cljs.core.chunk_rest(seq__44705_45872__$1);
var G__45875 = c__4609__auto___45873;
var G__45876 = cljs.core.count(c__4609__auto___45873);
var G__45877 = (0);
seq__44705_45782 = G__45874;
chunk__44706_45783 = G__45875;
count__44707_45784 = G__45876;
i__44708_45785 = G__45877;
continue;
} else {
var vec__45047_45878 = cljs.core.first(seq__44705_45872__$1);
var source_idx_45879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45047_45878,(0),null);
var vec__45050_45880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45047_45878,(1),null);
var __45881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45050_45880,(0),null);
var lines_45882__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45050_45880,(1),null);
var seq__45053_45887 = cljs.core.seq(lines_45882__$1);
var chunk__45054_45888 = null;
var count__45055_45889 = (0);
var i__45056_45890 = (0);
while(true){
if((i__45056_45890 < count__45055_45889)){
var vec__45122_45891 = chunk__45054_45888.cljs$core$IIndexed$_nth$arity$2(null,i__45056_45890);
var line_45892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45122_45891,(0),null);
var cols_45893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45122_45891,(1),null);
var seq__45125_45894 = cljs.core.seq(cols_45893);
var chunk__45126_45895 = null;
var count__45127_45896 = (0);
var i__45128_45897 = (0);
while(true){
if((i__45128_45897 < count__45127_45896)){
var vec__45142_45898 = chunk__45126_45895.cljs$core$IIndexed$_nth$arity$2(null,i__45128_45897);
var col_45899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45142_45898,(0),null);
var infos_45900 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45142_45898,(1),null);
encode_cols(infos_45900,source_idx_45879,line_45892,col_45899);


var G__45901 = seq__45125_45894;
var G__45902 = chunk__45126_45895;
var G__45903 = count__45127_45896;
var G__45904 = (i__45128_45897 + (1));
seq__45125_45894 = G__45901;
chunk__45126_45895 = G__45902;
count__45127_45896 = G__45903;
i__45128_45897 = G__45904;
continue;
} else {
var temp__5735__auto___45905__$1 = cljs.core.seq(seq__45125_45894);
if(temp__5735__auto___45905__$1){
var seq__45125_45908__$1 = temp__5735__auto___45905__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45125_45908__$1)){
var c__4609__auto___45909 = cljs.core.chunk_first(seq__45125_45908__$1);
var G__45910 = cljs.core.chunk_rest(seq__45125_45908__$1);
var G__45911 = c__4609__auto___45909;
var G__45912 = cljs.core.count(c__4609__auto___45909);
var G__45913 = (0);
seq__45125_45894 = G__45910;
chunk__45126_45895 = G__45911;
count__45127_45896 = G__45912;
i__45128_45897 = G__45913;
continue;
} else {
var vec__45150_45914 = cljs.core.first(seq__45125_45908__$1);
var col_45915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45150_45914,(0),null);
var infos_45916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45150_45914,(1),null);
encode_cols(infos_45916,source_idx_45879,line_45892,col_45915);


var G__45921 = cljs.core.next(seq__45125_45908__$1);
var G__45922 = null;
var G__45923 = (0);
var G__45924 = (0);
seq__45125_45894 = G__45921;
chunk__45126_45895 = G__45922;
count__45127_45896 = G__45923;
i__45128_45897 = G__45924;
continue;
}
} else {
}
}
break;
}


var G__45925 = seq__45053_45887;
var G__45926 = chunk__45054_45888;
var G__45927 = count__45055_45889;
var G__45928 = (i__45056_45890 + (1));
seq__45053_45887 = G__45925;
chunk__45054_45888 = G__45926;
count__45055_45889 = G__45927;
i__45056_45890 = G__45928;
continue;
} else {
var temp__5735__auto___45931__$1 = cljs.core.seq(seq__45053_45887);
if(temp__5735__auto___45931__$1){
var seq__45053_45932__$1 = temp__5735__auto___45931__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45053_45932__$1)){
var c__4609__auto___45933 = cljs.core.chunk_first(seq__45053_45932__$1);
var G__45936 = cljs.core.chunk_rest(seq__45053_45932__$1);
var G__45937 = c__4609__auto___45933;
var G__45938 = cljs.core.count(c__4609__auto___45933);
var G__45939 = (0);
seq__45053_45887 = G__45936;
chunk__45054_45888 = G__45937;
count__45055_45889 = G__45938;
i__45056_45890 = G__45939;
continue;
} else {
var vec__45158_45942 = cljs.core.first(seq__45053_45932__$1);
var line_45943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45158_45942,(0),null);
var cols_45944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45158_45942,(1),null);
var seq__45161_45947 = cljs.core.seq(cols_45944);
var chunk__45162_45948 = null;
var count__45163_45949 = (0);
var i__45164_45950 = (0);
while(true){
if((i__45164_45950 < count__45163_45949)){
var vec__45173_45951 = chunk__45162_45948.cljs$core$IIndexed$_nth$arity$2(null,i__45164_45950);
var col_45952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45173_45951,(0),null);
var infos_45953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45173_45951,(1),null);
encode_cols(infos_45953,source_idx_45879,line_45943,col_45952);


var G__45958 = seq__45161_45947;
var G__45959 = chunk__45162_45948;
var G__45960 = count__45163_45949;
var G__45961 = (i__45164_45950 + (1));
seq__45161_45947 = G__45958;
chunk__45162_45948 = G__45959;
count__45163_45949 = G__45960;
i__45164_45950 = G__45961;
continue;
} else {
var temp__5735__auto___45964__$2 = cljs.core.seq(seq__45161_45947);
if(temp__5735__auto___45964__$2){
var seq__45161_45965__$1 = temp__5735__auto___45964__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45161_45965__$1)){
var c__4609__auto___45966 = cljs.core.chunk_first(seq__45161_45965__$1);
var G__45967 = cljs.core.chunk_rest(seq__45161_45965__$1);
var G__45968 = c__4609__auto___45966;
var G__45969 = cljs.core.count(c__4609__auto___45966);
var G__45970 = (0);
seq__45161_45947 = G__45967;
chunk__45162_45948 = G__45968;
count__45163_45949 = G__45969;
i__45164_45950 = G__45970;
continue;
} else {
var vec__45185_45971 = cljs.core.first(seq__45161_45965__$1);
var col_45972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45185_45971,(0),null);
var infos_45973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45185_45971,(1),null);
encode_cols(infos_45973,source_idx_45879,line_45943,col_45972);


var G__45974 = cljs.core.next(seq__45161_45965__$1);
var G__45975 = null;
var G__45976 = (0);
var G__45977 = (0);
seq__45161_45947 = G__45974;
chunk__45162_45948 = G__45975;
count__45163_45949 = G__45976;
i__45164_45950 = G__45977;
continue;
}
} else {
}
}
break;
}


var G__45978 = cljs.core.next(seq__45053_45932__$1);
var G__45979 = null;
var G__45980 = (0);
var G__45981 = (0);
seq__45053_45887 = G__45978;
chunk__45054_45888 = G__45979;
count__45055_45889 = G__45980;
i__45056_45890 = G__45981;
continue;
}
} else {
}
}
break;
}


var G__45982 = cljs.core.next(seq__44705_45872__$1);
var G__45983 = null;
var G__45984 = (0);
var G__45985 = (0);
seq__44705_45782 = G__45982;
chunk__44706_45783 = G__45983;
count__44707_45784 = G__45984;
i__44708_45785 = G__45985;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45188 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44676_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44676_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44677_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44677_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44678_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44678_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45194 = G__45188;
var G__45195_45989 = G__45194;
var G__45196_45990 = "sourcesContent";
var G__45197_45991 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45195_45989,G__45196_45990,G__45197_45991);

return G__45194;
} else {
return G__45188;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45206 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45211 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45211,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45211,(1),null);
var G__45994 = cljs.core.next(col_map_seq);
var G__45995 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45211,col,infos,vec__45206,line,col_map){
return (function (v,p__45214){
var map__45217 = p__45214;
var map__45217__$1 = (((((!((map__45217 == null))))?(((((map__45217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45217.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45217):map__45217);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45217__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45217__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45211,col,infos,vec__45206,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__45994;
new_cols = G__45995;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46001 = cljs.core.next(line_map_seq);
var G__46002 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46001;
new_lines = G__46002;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45223_46003 = cljs.core.seq(reverse_map);
var chunk__45224_46004 = null;
var count__45225_46005 = (0);
var i__45226_46006 = (0);
while(true){
if((i__45226_46006 < count__45225_46005)){
var vec__45447_46008 = chunk__45224_46004.cljs$core$IIndexed$_nth$arity$2(null,i__45226_46006);
var line_46009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45447_46008,(0),null);
var columns_46010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45447_46008,(1),null);
var seq__45450_46011 = cljs.core.seq(columns_46010);
var chunk__45451_46012 = null;
var count__45452_46013 = (0);
var i__45453_46014 = (0);
while(true){
if((i__45453_46014 < count__45452_46013)){
var vec__45511_46015 = chunk__45451_46012.cljs$core$IIndexed$_nth$arity$2(null,i__45453_46014);
var column_46016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45511_46015,(0),null);
var column_info_46017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45511_46015,(1),null);
var seq__45517_46018 = cljs.core.seq(column_info_46017);
var chunk__45518_46019 = null;
var count__45519_46020 = (0);
var i__45520_46021 = (0);
while(true){
if((i__45520_46021 < count__45519_46020)){
var map__45534_46023 = chunk__45518_46019.cljs$core$IIndexed$_nth$arity$2(null,i__45520_46021);
var map__45534_46024__$1 = (((((!((map__45534_46023 == null))))?(((((map__45534_46023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45534_46023.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45534_46023):map__45534_46023);
var gline_46025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45534_46024__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45534_46024__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46027 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45534_46024__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46025], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45517_46018,chunk__45518_46019,count__45519_46020,i__45520_46021,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45534_46023,map__45534_46024__$1,gline_46025,gcol_46026,name_46027,vec__45511_46015,column_46016,column_info_46017,vec__45447_46008,line_46009,columns_46010,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46026], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46009,new cljs.core.Keyword(null,"col","col",-1959363084),column_46016,new cljs.core.Keyword(null,"name","name",1843675177),name_46027], null));
});})(seq__45517_46018,chunk__45518_46019,count__45519_46020,i__45520_46021,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45534_46023,map__45534_46024__$1,gline_46025,gcol_46026,name_46027,vec__45511_46015,column_46016,column_info_46017,vec__45447_46008,line_46009,columns_46010,inverted))
,cljs.core.sorted_map()));


var G__46031 = seq__45517_46018;
var G__46032 = chunk__45518_46019;
var G__46033 = count__45519_46020;
var G__46034 = (i__45520_46021 + (1));
seq__45517_46018 = G__46031;
chunk__45518_46019 = G__46032;
count__45519_46020 = G__46033;
i__45520_46021 = G__46034;
continue;
} else {
var temp__5735__auto___46035 = cljs.core.seq(seq__45517_46018);
if(temp__5735__auto___46035){
var seq__45517_46036__$1 = temp__5735__auto___46035;
if(cljs.core.chunked_seq_QMARK_(seq__45517_46036__$1)){
var c__4609__auto___46037 = cljs.core.chunk_first(seq__45517_46036__$1);
var G__46038 = cljs.core.chunk_rest(seq__45517_46036__$1);
var G__46039 = c__4609__auto___46037;
var G__46040 = cljs.core.count(c__4609__auto___46037);
var G__46041 = (0);
seq__45517_46018 = G__46038;
chunk__45518_46019 = G__46039;
count__45519_46020 = G__46040;
i__45520_46021 = G__46041;
continue;
} else {
var map__45542_46042 = cljs.core.first(seq__45517_46036__$1);
var map__45542_46043__$1 = (((((!((map__45542_46042 == null))))?(((((map__45542_46042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45542_46042.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45542_46042):map__45542_46042);
var gline_46044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45542_46043__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45542_46043__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45542_46043__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46044], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45517_46018,chunk__45518_46019,count__45519_46020,i__45520_46021,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45542_46042,map__45542_46043__$1,gline_46044,gcol_46045,name_46046,seq__45517_46036__$1,temp__5735__auto___46035,vec__45511_46015,column_46016,column_info_46017,vec__45447_46008,line_46009,columns_46010,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46045], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46009,new cljs.core.Keyword(null,"col","col",-1959363084),column_46016,new cljs.core.Keyword(null,"name","name",1843675177),name_46046], null));
});})(seq__45517_46018,chunk__45518_46019,count__45519_46020,i__45520_46021,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45542_46042,map__45542_46043__$1,gline_46044,gcol_46045,name_46046,seq__45517_46036__$1,temp__5735__auto___46035,vec__45511_46015,column_46016,column_info_46017,vec__45447_46008,line_46009,columns_46010,inverted))
,cljs.core.sorted_map()));


var G__46047 = cljs.core.next(seq__45517_46036__$1);
var G__46048 = null;
var G__46049 = (0);
var G__46050 = (0);
seq__45517_46018 = G__46047;
chunk__45518_46019 = G__46048;
count__45519_46020 = G__46049;
i__45520_46021 = G__46050;
continue;
}
} else {
}
}
break;
}


var G__46051 = seq__45450_46011;
var G__46052 = chunk__45451_46012;
var G__46053 = count__45452_46013;
var G__46054 = (i__45453_46014 + (1));
seq__45450_46011 = G__46051;
chunk__45451_46012 = G__46052;
count__45452_46013 = G__46053;
i__45453_46014 = G__46054;
continue;
} else {
var temp__5735__auto___46055 = cljs.core.seq(seq__45450_46011);
if(temp__5735__auto___46055){
var seq__45450_46056__$1 = temp__5735__auto___46055;
if(cljs.core.chunked_seq_QMARK_(seq__45450_46056__$1)){
var c__4609__auto___46057 = cljs.core.chunk_first(seq__45450_46056__$1);
var G__46058 = cljs.core.chunk_rest(seq__45450_46056__$1);
var G__46059 = c__4609__auto___46057;
var G__46060 = cljs.core.count(c__4609__auto___46057);
var G__46061 = (0);
seq__45450_46011 = G__46058;
chunk__45451_46012 = G__46059;
count__45452_46013 = G__46060;
i__45453_46014 = G__46061;
continue;
} else {
var vec__45552_46062 = cljs.core.first(seq__45450_46056__$1);
var column_46063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45552_46062,(0),null);
var column_info_46064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45552_46062,(1),null);
var seq__45555_46065 = cljs.core.seq(column_info_46064);
var chunk__45556_46066 = null;
var count__45557_46067 = (0);
var i__45558_46068 = (0);
while(true){
if((i__45558_46068 < count__45557_46067)){
var map__45567_46069 = chunk__45556_46066.cljs$core$IIndexed$_nth$arity$2(null,i__45558_46068);
var map__45567_46070__$1 = (((((!((map__45567_46069 == null))))?(((((map__45567_46069.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45567_46069.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45567_46069):map__45567_46069);
var gline_46071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45567_46070__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45567_46070__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46073 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45567_46070__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46071], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45555_46065,chunk__45556_46066,count__45557_46067,i__45558_46068,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45567_46069,map__45567_46070__$1,gline_46071,gcol_46072,name_46073,vec__45552_46062,column_46063,column_info_46064,seq__45450_46056__$1,temp__5735__auto___46055,vec__45447_46008,line_46009,columns_46010,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46072], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46009,new cljs.core.Keyword(null,"col","col",-1959363084),column_46063,new cljs.core.Keyword(null,"name","name",1843675177),name_46073], null));
});})(seq__45555_46065,chunk__45556_46066,count__45557_46067,i__45558_46068,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45567_46069,map__45567_46070__$1,gline_46071,gcol_46072,name_46073,vec__45552_46062,column_46063,column_info_46064,seq__45450_46056__$1,temp__5735__auto___46055,vec__45447_46008,line_46009,columns_46010,inverted))
,cljs.core.sorted_map()));


var G__46074 = seq__45555_46065;
var G__46075 = chunk__45556_46066;
var G__46076 = count__45557_46067;
var G__46077 = (i__45558_46068 + (1));
seq__45555_46065 = G__46074;
chunk__45556_46066 = G__46075;
count__45557_46067 = G__46076;
i__45558_46068 = G__46077;
continue;
} else {
var temp__5735__auto___46078__$1 = cljs.core.seq(seq__45555_46065);
if(temp__5735__auto___46078__$1){
var seq__45555_46079__$1 = temp__5735__auto___46078__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45555_46079__$1)){
var c__4609__auto___46080 = cljs.core.chunk_first(seq__45555_46079__$1);
var G__46081 = cljs.core.chunk_rest(seq__45555_46079__$1);
var G__46082 = c__4609__auto___46080;
var G__46083 = cljs.core.count(c__4609__auto___46080);
var G__46084 = (0);
seq__45555_46065 = G__46081;
chunk__45556_46066 = G__46082;
count__45557_46067 = G__46083;
i__45558_46068 = G__46084;
continue;
} else {
var map__45573_46086 = cljs.core.first(seq__45555_46079__$1);
var map__45573_46087__$1 = (((((!((map__45573_46086 == null))))?(((((map__45573_46086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45573_46086.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45573_46086):map__45573_46086);
var gline_46088 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45573_46087__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46089 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45573_46087__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46090 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45573_46087__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46088], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45555_46065,chunk__45556_46066,count__45557_46067,i__45558_46068,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45573_46086,map__45573_46087__$1,gline_46088,gcol_46089,name_46090,seq__45555_46079__$1,temp__5735__auto___46078__$1,vec__45552_46062,column_46063,column_info_46064,seq__45450_46056__$1,temp__5735__auto___46055,vec__45447_46008,line_46009,columns_46010,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46089], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46009,new cljs.core.Keyword(null,"col","col",-1959363084),column_46063,new cljs.core.Keyword(null,"name","name",1843675177),name_46090], null));
});})(seq__45555_46065,chunk__45556_46066,count__45557_46067,i__45558_46068,seq__45450_46011,chunk__45451_46012,count__45452_46013,i__45453_46014,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45573_46086,map__45573_46087__$1,gline_46088,gcol_46089,name_46090,seq__45555_46079__$1,temp__5735__auto___46078__$1,vec__45552_46062,column_46063,column_info_46064,seq__45450_46056__$1,temp__5735__auto___46055,vec__45447_46008,line_46009,columns_46010,inverted))
,cljs.core.sorted_map()));


var G__46091 = cljs.core.next(seq__45555_46079__$1);
var G__46092 = null;
var G__46093 = (0);
var G__46094 = (0);
seq__45555_46065 = G__46091;
chunk__45556_46066 = G__46092;
count__45557_46067 = G__46093;
i__45558_46068 = G__46094;
continue;
}
} else {
}
}
break;
}


var G__46095 = cljs.core.next(seq__45450_46056__$1);
var G__46096 = null;
var G__46097 = (0);
var G__46098 = (0);
seq__45450_46011 = G__46095;
chunk__45451_46012 = G__46096;
count__45452_46013 = G__46097;
i__45453_46014 = G__46098;
continue;
}
} else {
}
}
break;
}


var G__46099 = seq__45223_46003;
var G__46100 = chunk__45224_46004;
var G__46101 = count__45225_46005;
var G__46102 = (i__45226_46006 + (1));
seq__45223_46003 = G__46099;
chunk__45224_46004 = G__46100;
count__45225_46005 = G__46101;
i__45226_46006 = G__46102;
continue;
} else {
var temp__5735__auto___46103 = cljs.core.seq(seq__45223_46003);
if(temp__5735__auto___46103){
var seq__45223_46104__$1 = temp__5735__auto___46103;
if(cljs.core.chunked_seq_QMARK_(seq__45223_46104__$1)){
var c__4609__auto___46105 = cljs.core.chunk_first(seq__45223_46104__$1);
var G__46106 = cljs.core.chunk_rest(seq__45223_46104__$1);
var G__46107 = c__4609__auto___46105;
var G__46108 = cljs.core.count(c__4609__auto___46105);
var G__46109 = (0);
seq__45223_46003 = G__46106;
chunk__45224_46004 = G__46107;
count__45225_46005 = G__46108;
i__45226_46006 = G__46109;
continue;
} else {
var vec__45579_46110 = cljs.core.first(seq__45223_46104__$1);
var line_46111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45579_46110,(0),null);
var columns_46112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45579_46110,(1),null);
var seq__45582_46113 = cljs.core.seq(columns_46112);
var chunk__45583_46114 = null;
var count__45584_46115 = (0);
var i__45585_46116 = (0);
while(true){
if((i__45585_46116 < count__45584_46115)){
var vec__45652_46117 = chunk__45583_46114.cljs$core$IIndexed$_nth$arity$2(null,i__45585_46116);
var column_46118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45652_46117,(0),null);
var column_info_46119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45652_46117,(1),null);
var seq__45655_46120 = cljs.core.seq(column_info_46119);
var chunk__45656_46121 = null;
var count__45657_46122 = (0);
var i__45658_46123 = (0);
while(true){
if((i__45658_46123 < count__45657_46122)){
var map__45666_46124 = chunk__45656_46121.cljs$core$IIndexed$_nth$arity$2(null,i__45658_46123);
var map__45666_46125__$1 = (((((!((map__45666_46124 == null))))?(((((map__45666_46124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45666_46124.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45666_46124):map__45666_46124);
var gline_46126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45666_46125__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45666_46125__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45666_46125__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46126], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45655_46120,chunk__45656_46121,count__45657_46122,i__45658_46123,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45666_46124,map__45666_46125__$1,gline_46126,gcol_46127,name_46128,vec__45652_46117,column_46118,column_info_46119,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46127], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46111,new cljs.core.Keyword(null,"col","col",-1959363084),column_46118,new cljs.core.Keyword(null,"name","name",1843675177),name_46128], null));
});})(seq__45655_46120,chunk__45656_46121,count__45657_46122,i__45658_46123,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45666_46124,map__45666_46125__$1,gline_46126,gcol_46127,name_46128,vec__45652_46117,column_46118,column_info_46119,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted))
,cljs.core.sorted_map()));


var G__46129 = seq__45655_46120;
var G__46130 = chunk__45656_46121;
var G__46131 = count__45657_46122;
var G__46132 = (i__45658_46123 + (1));
seq__45655_46120 = G__46129;
chunk__45656_46121 = G__46130;
count__45657_46122 = G__46131;
i__45658_46123 = G__46132;
continue;
} else {
var temp__5735__auto___46133__$1 = cljs.core.seq(seq__45655_46120);
if(temp__5735__auto___46133__$1){
var seq__45655_46134__$1 = temp__5735__auto___46133__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45655_46134__$1)){
var c__4609__auto___46135 = cljs.core.chunk_first(seq__45655_46134__$1);
var G__46136 = cljs.core.chunk_rest(seq__45655_46134__$1);
var G__46137 = c__4609__auto___46135;
var G__46138 = cljs.core.count(c__4609__auto___46135);
var G__46139 = (0);
seq__45655_46120 = G__46136;
chunk__45656_46121 = G__46137;
count__45657_46122 = G__46138;
i__45658_46123 = G__46139;
continue;
} else {
var map__45672_46140 = cljs.core.first(seq__45655_46134__$1);
var map__45672_46141__$1 = (((((!((map__45672_46140 == null))))?(((((map__45672_46140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45672_46140.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45672_46140):map__45672_46140);
var gline_46142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45672_46141__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46143 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45672_46141__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45672_46141__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46142], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45655_46120,chunk__45656_46121,count__45657_46122,i__45658_46123,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45672_46140,map__45672_46141__$1,gline_46142,gcol_46143,name_46144,seq__45655_46134__$1,temp__5735__auto___46133__$1,vec__45652_46117,column_46118,column_info_46119,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46143], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46111,new cljs.core.Keyword(null,"col","col",-1959363084),column_46118,new cljs.core.Keyword(null,"name","name",1843675177),name_46144], null));
});})(seq__45655_46120,chunk__45656_46121,count__45657_46122,i__45658_46123,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45672_46140,map__45672_46141__$1,gline_46142,gcol_46143,name_46144,seq__45655_46134__$1,temp__5735__auto___46133__$1,vec__45652_46117,column_46118,column_info_46119,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted))
,cljs.core.sorted_map()));


var G__46149 = cljs.core.next(seq__45655_46134__$1);
var G__46150 = null;
var G__46151 = (0);
var G__46152 = (0);
seq__45655_46120 = G__46149;
chunk__45656_46121 = G__46150;
count__45657_46122 = G__46151;
i__45658_46123 = G__46152;
continue;
}
} else {
}
}
break;
}


var G__46153 = seq__45582_46113;
var G__46154 = chunk__45583_46114;
var G__46155 = count__45584_46115;
var G__46156 = (i__45585_46116 + (1));
seq__45582_46113 = G__46153;
chunk__45583_46114 = G__46154;
count__45584_46115 = G__46155;
i__45585_46116 = G__46156;
continue;
} else {
var temp__5735__auto___46159__$1 = cljs.core.seq(seq__45582_46113);
if(temp__5735__auto___46159__$1){
var seq__45582_46160__$1 = temp__5735__auto___46159__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45582_46160__$1)){
var c__4609__auto___46161 = cljs.core.chunk_first(seq__45582_46160__$1);
var G__46162 = cljs.core.chunk_rest(seq__45582_46160__$1);
var G__46163 = c__4609__auto___46161;
var G__46164 = cljs.core.count(c__4609__auto___46161);
var G__46165 = (0);
seq__45582_46113 = G__46162;
chunk__45583_46114 = G__46163;
count__45584_46115 = G__46164;
i__45585_46116 = G__46165;
continue;
} else {
var vec__45676_46166 = cljs.core.first(seq__45582_46160__$1);
var column_46167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45676_46166,(0),null);
var column_info_46168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45676_46166,(1),null);
var seq__45679_46169 = cljs.core.seq(column_info_46168);
var chunk__45680_46170 = null;
var count__45681_46171 = (0);
var i__45682_46172 = (0);
while(true){
if((i__45682_46172 < count__45681_46171)){
var map__45699_46175 = chunk__45680_46170.cljs$core$IIndexed$_nth$arity$2(null,i__45682_46172);
var map__45699_46176__$1 = (((((!((map__45699_46175 == null))))?(((((map__45699_46175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45699_46175.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45699_46175):map__45699_46175);
var gline_46177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45699_46176__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46178 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45699_46176__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45699_46176__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46177], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45679_46169,chunk__45680_46170,count__45681_46171,i__45682_46172,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45699_46175,map__45699_46176__$1,gline_46177,gcol_46178,name_46179,vec__45676_46166,column_46167,column_info_46168,seq__45582_46160__$1,temp__5735__auto___46159__$1,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46178], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46111,new cljs.core.Keyword(null,"col","col",-1959363084),column_46167,new cljs.core.Keyword(null,"name","name",1843675177),name_46179], null));
});})(seq__45679_46169,chunk__45680_46170,count__45681_46171,i__45682_46172,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45699_46175,map__45699_46176__$1,gline_46177,gcol_46178,name_46179,vec__45676_46166,column_46167,column_info_46168,seq__45582_46160__$1,temp__5735__auto___46159__$1,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted))
,cljs.core.sorted_map()));


var G__46180 = seq__45679_46169;
var G__46181 = chunk__45680_46170;
var G__46182 = count__45681_46171;
var G__46183 = (i__45682_46172 + (1));
seq__45679_46169 = G__46180;
chunk__45680_46170 = G__46181;
count__45681_46171 = G__46182;
i__45682_46172 = G__46183;
continue;
} else {
var temp__5735__auto___46184__$2 = cljs.core.seq(seq__45679_46169);
if(temp__5735__auto___46184__$2){
var seq__45679_46188__$1 = temp__5735__auto___46184__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45679_46188__$1)){
var c__4609__auto___46189 = cljs.core.chunk_first(seq__45679_46188__$1);
var G__46190 = cljs.core.chunk_rest(seq__45679_46188__$1);
var G__46191 = c__4609__auto___46189;
var G__46192 = cljs.core.count(c__4609__auto___46189);
var G__46193 = (0);
seq__45679_46169 = G__46190;
chunk__45680_46170 = G__46191;
count__45681_46171 = G__46192;
i__45682_46172 = G__46193;
continue;
} else {
var map__45709_46194 = cljs.core.first(seq__45679_46188__$1);
var map__45709_46195__$1 = (((((!((map__45709_46194 == null))))?(((((map__45709_46194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45709_46194.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45709_46194):map__45709_46194);
var gline_46196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45709_46195__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46197 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45709_46195__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46198 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45709_46195__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46196], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45679_46169,chunk__45680_46170,count__45681_46171,i__45682_46172,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45709_46194,map__45709_46195__$1,gline_46196,gcol_46197,name_46198,seq__45679_46188__$1,temp__5735__auto___46184__$2,vec__45676_46166,column_46167,column_info_46168,seq__45582_46160__$1,temp__5735__auto___46159__$1,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46197], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46111,new cljs.core.Keyword(null,"col","col",-1959363084),column_46167,new cljs.core.Keyword(null,"name","name",1843675177),name_46198], null));
});})(seq__45679_46169,chunk__45680_46170,count__45681_46171,i__45682_46172,seq__45582_46113,chunk__45583_46114,count__45584_46115,i__45585_46116,seq__45223_46003,chunk__45224_46004,count__45225_46005,i__45226_46006,map__45709_46194,map__45709_46195__$1,gline_46196,gcol_46197,name_46198,seq__45679_46188__$1,temp__5735__auto___46184__$2,vec__45676_46166,column_46167,column_info_46168,seq__45582_46160__$1,temp__5735__auto___46159__$1,vec__45579_46110,line_46111,columns_46112,seq__45223_46104__$1,temp__5735__auto___46103,inverted))
,cljs.core.sorted_map()));


var G__46200 = cljs.core.next(seq__45679_46188__$1);
var G__46201 = null;
var G__46202 = (0);
var G__46203 = (0);
seq__45679_46169 = G__46200;
chunk__45680_46170 = G__46201;
count__45681_46171 = G__46202;
i__45682_46172 = G__46203;
continue;
}
} else {
}
}
break;
}


var G__46204 = cljs.core.next(seq__45582_46160__$1);
var G__46205 = null;
var G__46206 = (0);
var G__46207 = (0);
seq__45582_46113 = G__46204;
chunk__45583_46114 = G__46205;
count__45584_46115 = G__46206;
i__45585_46116 = G__46207;
continue;
}
} else {
}
}
break;
}


var G__46209 = cljs.core.next(seq__45223_46104__$1);
var G__46210 = null;
var G__46211 = (0);
var G__46212 = (0);
seq__45223_46003 = G__46209;
chunk__45224_46004 = G__46210;
count__45225_46005 = G__46211;
i__45226_46006 = G__46212;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
