goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__46309 = s;
var map__46309__$1 = (((((!((map__46309 == null))))?(((((map__46309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46309):map__46309);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46309__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46309__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__46312 = info;
var map__46313 = G__46312;
var map__46313__$1 = (((((!((map__46313 == null))))?(((((map__46313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46313.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46313):map__46313);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46313__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__46312__$1 = G__46312;
while(true){
var d__$2 = d__$1;
var map__46317 = G__46312__$1;
var map__46317__$1 = (((((!((map__46317 == null))))?(((((map__46317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46317.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46317):map__46317);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46317__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__47057 = (d__$2 + (1));
var G__47058 = shadow__$2;
d__$1 = G__47057;
G__46312__$1 = G__47058;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__46319){
var map__46320 = p__46319;
var map__46320__$1 = (((((!((map__46320 == null))))?(((((map__46320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46320):map__46320);
var name_var = map__46320__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46320__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46320__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__46322 = info;
var map__46322__$1 = (((((!((map__46322 == null))))?(((((map__46322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46322.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46322):map__46322);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46322__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46322__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__46324 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__46324) : cljs.compiler.munge.call(null,G__46324));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__46351 = arguments.length;
switch (G__46351) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__46373 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__46373.cljs$core$IFn$_invoke$arity$1 ? fexpr__46373.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__46373.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__46377 = cp;
switch (G__46377) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__46378_47064 = cljs.core.seq(s);
var chunk__46379_47065 = null;
var count__46380_47066 = (0);
var i__46381_47067 = (0);
while(true){
if((i__46381_47067 < count__46380_47066)){
var c_47071 = chunk__46379_47065.cljs$core$IIndexed$_nth$arity$2(null,i__46381_47067);
sb.append(cljs.compiler.escape_char(c_47071));


var G__47075 = seq__46378_47064;
var G__47076 = chunk__46379_47065;
var G__47077 = count__46380_47066;
var G__47078 = (i__46381_47067 + (1));
seq__46378_47064 = G__47075;
chunk__46379_47065 = G__47076;
count__46380_47066 = G__47077;
i__46381_47067 = G__47078;
continue;
} else {
var temp__5735__auto___47079 = cljs.core.seq(seq__46378_47064);
if(temp__5735__auto___47079){
var seq__46378_47083__$1 = temp__5735__auto___47079;
if(cljs.core.chunked_seq_QMARK_(seq__46378_47083__$1)){
var c__4609__auto___47084 = cljs.core.chunk_first(seq__46378_47083__$1);
var G__47085 = cljs.core.chunk_rest(seq__46378_47083__$1);
var G__47086 = c__4609__auto___47084;
var G__47087 = cljs.core.count(c__4609__auto___47084);
var G__47088 = (0);
seq__46378_47064 = G__47085;
chunk__46379_47065 = G__47086;
count__46380_47066 = G__47087;
i__46381_47067 = G__47088;
continue;
} else {
var c_47089 = cljs.core.first(seq__46378_47083__$1);
sb.append(cljs.compiler.escape_char(c_47089));


var G__47090 = cljs.core.next(seq__46378_47083__$1);
var G__47091 = null;
var G__47092 = (0);
var G__47093 = (0);
seq__46378_47064 = G__47090;
chunk__46379_47065 = G__47091;
count__46380_47066 = G__47092;
i__46381_47067 = G__47093;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__46382 = cljs.core.get_global_hierarchy;
return (fexpr__46382.cljs$core$IFn$_invoke$arity$0 ? fexpr__46382.cljs$core$IFn$_invoke$arity$0() : fexpr__46382.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__46383_47094 = ast;
var map__46383_47095__$1 = (((((!((map__46383_47094 == null))))?(((((map__46383_47094.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46383_47094.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46383_47094):map__46383_47094);
var env_47096 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46383_47095__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_47096))){
var map__46385_47097 = env_47096;
var map__46385_47098__$1 = (((((!((map__46385_47097 == null))))?(((((map__46385_47097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46385_47097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46385_47097):map__46385_47097);
var line_47099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46385_47098__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_47100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46385_47098__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__46387 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__46389 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__46388 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__46388.cljs$core$IFn$_invoke$arity$1 ? fexpr__46388.cljs$core$IFn$_invoke$arity$1(G__46389) : fexpr__46388.call(null,G__46389));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__46387,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__46387;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_47099 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_47100)?(column_47100 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__46398 = arguments.length;
switch (G__46398) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___47119 = arguments.length;
var i__4790__auto___47120 = (0);
while(true){
if((i__4790__auto___47120 < len__4789__auto___47119)){
args_arr__4810__auto__.push((arguments[i__4790__auto___47120]));

var G__47121 = (i__4790__auto___47120 + (1));
i__4790__auto___47120 = G__47121;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_47122 = (function (){var G__46399 = a;
if((!(typeof a === 'string'))){
return G__46399.toString();
} else {
return G__46399;
}
})();
var temp__5739__auto___47123 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___47123 == null)){
} else {
var sm_data_47126 = temp__5739__auto___47123;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_47126,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__46390_SHARP_){
return (p1__46390_SHARP_ + s_47122.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_47122], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__46400 = cljs.core.seq(xs);
var chunk__46401 = null;
var count__46402 = (0);
var i__46403 = (0);
while(true){
if((i__46403 < count__46402)){
var x = chunk__46401.cljs$core$IIndexed$_nth$arity$2(null,i__46403);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__47127 = seq__46400;
var G__47128 = chunk__46401;
var G__47129 = count__46402;
var G__47130 = (i__46403 + (1));
seq__46400 = G__47127;
chunk__46401 = G__47128;
count__46402 = G__47129;
i__46403 = G__47130;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46400);
if(temp__5735__auto__){
var seq__46400__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46400__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46400__$1);
var G__47131 = cljs.core.chunk_rest(seq__46400__$1);
var G__47132 = c__4609__auto__;
var G__47133 = cljs.core.count(c__4609__auto__);
var G__47134 = (0);
seq__46400 = G__47131;
chunk__46401 = G__47132;
count__46402 = G__47133;
i__46403 = G__47134;
continue;
} else {
var x = cljs.core.first(seq__46400__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__47135 = cljs.core.next(seq__46400__$1);
var G__47136 = null;
var G__47137 = (0);
var G__47138 = (0);
seq__46400 = G__47135;
chunk__46401 = G__47136;
count__46402 = G__47137;
i__46403 = G__47138;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq46392){
var G__46393 = cljs.core.first(seq46392);
var seq46392__$1 = cljs.core.next(seq46392);
var G__46394 = cljs.core.first(seq46392__$1);
var seq46392__$2 = cljs.core.next(seq46392__$1);
var G__46395 = cljs.core.first(seq46392__$2);
var seq46392__$3 = cljs.core.next(seq46392__$2);
var G__46396 = cljs.core.first(seq46392__$3);
var seq46392__$4 = cljs.core.next(seq46392__$3);
var G__46397 = cljs.core.first(seq46392__$4);
var seq46392__$5 = cljs.core.next(seq46392__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46393,G__46394,G__46395,G__46396,G__46397,seq46392__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__46408){
var map__46409 = p__46408;
var map__46409__$1 = (((((!((map__46409 == null))))?(((((map__46409.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46409.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46409):map__46409);
var m = map__46409__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46409__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__46420 = arguments.length;
switch (G__46420) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___47161 = arguments.length;
var i__4790__auto___47162 = (0);
while(true){
if((i__4790__auto___47162 < len__4789__auto___47161)){
args_arr__4810__auto__.push((arguments[i__4790__auto___47162]));

var G__47163 = (i__4790__auto___47162 + (1));
i__4790__auto___47162 = G__47163;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__46422_47168 = cljs.core.seq(xs);
var chunk__46423_47169 = null;
var count__46424_47170 = (0);
var i__46425_47171 = (0);
while(true){
if((i__46425_47171 < count__46424_47170)){
var x_47172 = chunk__46423_47169.cljs$core$IIndexed$_nth$arity$2(null,i__46425_47171);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_47172);


var G__47173 = seq__46422_47168;
var G__47174 = chunk__46423_47169;
var G__47175 = count__46424_47170;
var G__47176 = (i__46425_47171 + (1));
seq__46422_47168 = G__47173;
chunk__46423_47169 = G__47174;
count__46424_47170 = G__47175;
i__46425_47171 = G__47176;
continue;
} else {
var temp__5735__auto___47177 = cljs.core.seq(seq__46422_47168);
if(temp__5735__auto___47177){
var seq__46422_47178__$1 = temp__5735__auto___47177;
if(cljs.core.chunked_seq_QMARK_(seq__46422_47178__$1)){
var c__4609__auto___47179 = cljs.core.chunk_first(seq__46422_47178__$1);
var G__47180 = cljs.core.chunk_rest(seq__46422_47178__$1);
var G__47181 = c__4609__auto___47179;
var G__47182 = cljs.core.count(c__4609__auto___47179);
var G__47183 = (0);
seq__46422_47168 = G__47180;
chunk__46423_47169 = G__47181;
count__46424_47170 = G__47182;
i__46425_47171 = G__47183;
continue;
} else {
var x_47184 = cljs.core.first(seq__46422_47178__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_47184);


var G__47185 = cljs.core.next(seq__46422_47178__$1);
var G__47186 = null;
var G__47187 = (0);
var G__47188 = (0);
seq__46422_47168 = G__47185;
chunk__46423_47169 = G__47186;
count__46424_47170 = G__47187;
i__46425_47171 = G__47188;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq46414){
var G__46415 = cljs.core.first(seq46414);
var seq46414__$1 = cljs.core.next(seq46414);
var G__46416 = cljs.core.first(seq46414__$1);
var seq46414__$2 = cljs.core.next(seq46414__$1);
var G__46417 = cljs.core.first(seq46414__$2);
var seq46414__$3 = cljs.core.next(seq46414__$2);
var G__46418 = cljs.core.first(seq46414__$3);
var seq46414__$4 = cljs.core.next(seq46414__$3);
var G__46419 = cljs.core.first(seq46414__$4);
var seq46414__$5 = cljs.core.next(seq46414__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46415,G__46416,G__46417,G__46418,G__46419,seq46414__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__46426_47189 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__46427_47190 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__46428_47191 = true;
var _STAR_print_fn_STAR__temp_val__46429_47192 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__46428_47191);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__46429_47192);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__46427_47190);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__46426_47189);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__46430 = cljs.core.get_global_hierarchy;
return (fexpr__46430.cljs$core$IFn$_invoke$arity$0 ? fexpr__46430.cljs$core$IFn$_invoke$arity$0() : fexpr__46430.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__46443 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46443,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46443,(1),null);
var G__46446 = ns;
var G__46447 = name;
var G__46448 = (function (){
var G__46449 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__46449) : cljs.compiler.emit_constant.call(null,G__46449));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__46446,G__46447,G__46448) : cljs.compiler.emit_record_value.call(null,G__46446,G__46447,G__46448));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__46451 = cljs.core.keys(x);
var G__46452 = cljs.core.vals(x);
var G__46453 = cljs.compiler.emit_constants_comma_sep;
var G__46454 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__46451,G__46452,G__46453,G__46454) : cljs.compiler.emit_map.call(null,G__46451,G__46452,G__46453,G__46454));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__46455 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__46456 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__46455,G__46456) : cljs.compiler.emit_with_meta.call(null,G__46455,G__46456));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__46458 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46458,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46458,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46458,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__46462 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__46462) : x.call(null,G__46462));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__46463 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__46463) : x.call(null,G__46463));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__46466 = items;
var G__46467 = (function (p1__46465_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__46465_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__46466,G__46467) : cljs.compiler.emit_js_object.call(null,G__46466,G__46467));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__46470){
var map__46471 = p__46470;
var map__46471__$1 = (((((!((map__46471 == null))))?(((((map__46471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46471):map__46471);
var ast = map__46471__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46471__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46471__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46471__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__46473 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__46473__$1 = (((((!((map__46473 == null))))?(((((map__46473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46473):map__46473);
var cenv = map__46473__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46473__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__46475 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__46478 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__46478) : cljs.compiler.es5_GT__EQ_.call(null,G__46478));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__46475,cljs.analyzer.es5_allowed);
} else {
return G__46475;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__46479 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__46479,reserved);
} else {
return G__46479;
}
})();
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__46480_47209 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__46480_47210__$1 = (((G__46480_47209 instanceof cljs.core.Keyword))?G__46480_47209.fqn:null);
switch (G__46480_47210__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__46485){
var map__46486 = p__46485;
var map__46486__$1 = (((((!((map__46486 == null))))?(((((map__46486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46486):map__46486);
var arg = map__46486__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46486__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46486__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46486__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46486__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__46489 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__46489__$1 = (((((!((map__46489 == null))))?(((((map__46489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46489.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46489):map__46489);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46489__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__46491){
var map__46492 = p__46491;
var map__46492__$1 = (((((!((map__46492 == null))))?(((((map__46492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46492.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46492):map__46492);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__46497_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__46497_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__46500 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46500) : comma_sep.call(null,G__46500));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__46501 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46501) : comma_sep.call(null,G__46501));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__46502){
var map__46503 = p__46502;
var map__46503__$1 = (((((!((map__46503 == null))))?(((((map__46503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46503):map__46503);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46503__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46503__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46503__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__46505){
var map__46506 = p__46505;
var map__46506__$1 = (((((!((map__46506 == null))))?(((((map__46506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46506.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46506):map__46506);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46506__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46506__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__46508_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__46508_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__46509 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46509) : comma_sep.call(null,G__46509));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__46510){
var map__46511 = p__46510;
var map__46511__$1 = (((((!((map__46511 == null))))?(((((map__46511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46511):map__46511);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46511__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46511__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___47236 = cljs.core.seq(items);
if(temp__5735__auto___47236){
var items_47237__$1 = temp__5735__auto___47236;
var vec__46513_47238 = items_47237__$1;
var seq__46514_47239 = cljs.core.seq(vec__46513_47238);
var first__46515_47240 = cljs.core.first(seq__46514_47239);
var seq__46514_47241__$1 = cljs.core.next(seq__46514_47239);
var vec__46516_47242 = first__46515_47240;
var k_47243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46516_47242,(0),null);
var v_47244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46516_47242,(1),null);
var r_47245 = seq__46514_47241__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_47243),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47244) : emit_js_object_val.call(null,v_47244)));

var seq__46519_47246 = cljs.core.seq(r_47245);
var chunk__46520_47247 = null;
var count__46521_47248 = (0);
var i__46522_47249 = (0);
while(true){
if((i__46522_47249 < count__46521_47248)){
var vec__46529_47250 = chunk__46520_47247.cljs$core$IIndexed$_nth$arity$2(null,i__46522_47249);
var k_47251__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46529_47250,(0),null);
var v_47252__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46529_47250,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_47251__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47252__$1) : emit_js_object_val.call(null,v_47252__$1)));


var G__47253 = seq__46519_47246;
var G__47254 = chunk__46520_47247;
var G__47255 = count__46521_47248;
var G__47256 = (i__46522_47249 + (1));
seq__46519_47246 = G__47253;
chunk__46520_47247 = G__47254;
count__46521_47248 = G__47255;
i__46522_47249 = G__47256;
continue;
} else {
var temp__5735__auto___47257__$1 = cljs.core.seq(seq__46519_47246);
if(temp__5735__auto___47257__$1){
var seq__46519_47258__$1 = temp__5735__auto___47257__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46519_47258__$1)){
var c__4609__auto___47259 = cljs.core.chunk_first(seq__46519_47258__$1);
var G__47260 = cljs.core.chunk_rest(seq__46519_47258__$1);
var G__47261 = c__4609__auto___47259;
var G__47262 = cljs.core.count(c__4609__auto___47259);
var G__47263 = (0);
seq__46519_47246 = G__47260;
chunk__46520_47247 = G__47261;
count__46521_47248 = G__47262;
i__46522_47249 = G__47263;
continue;
} else {
var vec__46533_47264 = cljs.core.first(seq__46519_47258__$1);
var k_47265__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46533_47264,(0),null);
var v_47266__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46533_47264,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_47265__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47266__$1) : emit_js_object_val.call(null,v_47266__$1)));


var G__47267 = cljs.core.next(seq__46519_47258__$1);
var G__47268 = null;
var G__47269 = (0);
var G__47270 = (0);
seq__46519_47246 = G__47267;
chunk__46520_47247 = G__47268;
count__46521_47248 = G__47269;
i__46522_47249 = G__47270;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__46536){
var map__46537 = p__46536;
var map__46537__$1 = (((((!((map__46537 == null))))?(((((map__46537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46537):map__46537);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46537__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46537__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46537__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__46540){
var map__46541 = p__46540;
var map__46541__$1 = (((((!((map__46541 == null))))?(((((map__46541.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46541.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46541):map__46541);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46541__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46541__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__46543){
var map__46544 = p__46543;
var map__46544__$1 = (((((!((map__46544 == null))))?(((((map__46544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46544):map__46544);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46544__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__46549){
var map__46550 = p__46549;
var map__46550__$1 = (((((!((map__46550 == null))))?(((((map__46550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46550):map__46550);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46550__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46550__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__46552 = cljs.analyzer.unwrap_quote(expr);
var map__46552__$1 = (((((!((map__46552 == null))))?(((((map__46552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46552):map__46552);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46552__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46552__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46552__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__46554 = cljs.analyzer.unwrap_quote(expr);
var map__46554__$1 = (((((!((map__46554 == null))))?(((((map__46554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46554):map__46554);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46554__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46554__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46554__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__46563 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__46563.cljs$core$IFn$_invoke$arity$1 ? fexpr__46563.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__46563.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__46564){
var map__46565 = p__46564;
var map__46565__$1 = (((((!((map__46565 == null))))?(((((map__46565.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46565.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46565):map__46565);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46565__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46565__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46565__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46565__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46565__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__46577){
var map__46578 = p__46577;
var map__46578__$1 = (((((!((map__46578 == null))))?(((((map__46578.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46578.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46578):map__46578);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46578__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46578__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46578__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46578__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__46586_47273 = cljs.core.seq(nodes);
var chunk__46587_47274 = null;
var count__46588_47275 = (0);
var i__46589_47276 = (0);
while(true){
if((i__46589_47276 < count__46588_47275)){
var map__46606_47277 = chunk__46587_47274.cljs$core$IIndexed$_nth$arity$2(null,i__46589_47276);
var map__46606_47278__$1 = (((((!((map__46606_47277 == null))))?(((((map__46606_47277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46606_47277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46606_47277):map__46606_47277);
var ts_47279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46606_47278__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__46607_47280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46606_47278__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__46607_47281__$1 = (((((!((map__46607_47280 == null))))?(((((map__46607_47280.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46607_47280.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46607_47280):map__46607_47280);
var then_47282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46607_47281__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__46610_47283 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_47279));
var chunk__46611_47284 = null;
var count__46612_47285 = (0);
var i__46613_47286 = (0);
while(true){
if((i__46613_47286 < count__46612_47285)){
var test_47287 = chunk__46611_47284.cljs$core$IIndexed$_nth$arity$2(null,i__46613_47286);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47287,":");


var G__47288 = seq__46610_47283;
var G__47289 = chunk__46611_47284;
var G__47290 = count__46612_47285;
var G__47291 = (i__46613_47286 + (1));
seq__46610_47283 = G__47288;
chunk__46611_47284 = G__47289;
count__46612_47285 = G__47290;
i__46613_47286 = G__47291;
continue;
} else {
var temp__5735__auto___47292 = cljs.core.seq(seq__46610_47283);
if(temp__5735__auto___47292){
var seq__46610_47293__$1 = temp__5735__auto___47292;
if(cljs.core.chunked_seq_QMARK_(seq__46610_47293__$1)){
var c__4609__auto___47294 = cljs.core.chunk_first(seq__46610_47293__$1);
var G__47295 = cljs.core.chunk_rest(seq__46610_47293__$1);
var G__47296 = c__4609__auto___47294;
var G__47297 = cljs.core.count(c__4609__auto___47294);
var G__47298 = (0);
seq__46610_47283 = G__47295;
chunk__46611_47284 = G__47296;
count__46612_47285 = G__47297;
i__46613_47286 = G__47298;
continue;
} else {
var test_47299 = cljs.core.first(seq__46610_47293__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47299,":");


var G__47300 = cljs.core.next(seq__46610_47293__$1);
var G__47301 = null;
var G__47302 = (0);
var G__47303 = (0);
seq__46610_47283 = G__47300;
chunk__46611_47284 = G__47301;
count__46612_47285 = G__47302;
i__46613_47286 = G__47303;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_47282);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_47282);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__47304 = seq__46586_47273;
var G__47305 = chunk__46587_47274;
var G__47306 = count__46588_47275;
var G__47307 = (i__46589_47276 + (1));
seq__46586_47273 = G__47304;
chunk__46587_47274 = G__47305;
count__46588_47275 = G__47306;
i__46589_47276 = G__47307;
continue;
} else {
var temp__5735__auto___47308 = cljs.core.seq(seq__46586_47273);
if(temp__5735__auto___47308){
var seq__46586_47309__$1 = temp__5735__auto___47308;
if(cljs.core.chunked_seq_QMARK_(seq__46586_47309__$1)){
var c__4609__auto___47310 = cljs.core.chunk_first(seq__46586_47309__$1);
var G__47311 = cljs.core.chunk_rest(seq__46586_47309__$1);
var G__47312 = c__4609__auto___47310;
var G__47313 = cljs.core.count(c__4609__auto___47310);
var G__47314 = (0);
seq__46586_47273 = G__47311;
chunk__46587_47274 = G__47312;
count__46588_47275 = G__47313;
i__46589_47276 = G__47314;
continue;
} else {
var map__46614_47315 = cljs.core.first(seq__46586_47309__$1);
var map__46614_47316__$1 = (((((!((map__46614_47315 == null))))?(((((map__46614_47315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46614_47315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46614_47315):map__46614_47315);
var ts_47317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46614_47316__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__46615_47318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46614_47316__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__46615_47319__$1 = (((((!((map__46615_47318 == null))))?(((((map__46615_47318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46615_47318.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46615_47318):map__46615_47318);
var then_47320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46615_47319__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__46618_47321 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_47317));
var chunk__46619_47322 = null;
var count__46620_47323 = (0);
var i__46621_47324 = (0);
while(true){
if((i__46621_47324 < count__46620_47323)){
var test_47325 = chunk__46619_47322.cljs$core$IIndexed$_nth$arity$2(null,i__46621_47324);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47325,":");


var G__47326 = seq__46618_47321;
var G__47327 = chunk__46619_47322;
var G__47328 = count__46620_47323;
var G__47329 = (i__46621_47324 + (1));
seq__46618_47321 = G__47326;
chunk__46619_47322 = G__47327;
count__46620_47323 = G__47328;
i__46621_47324 = G__47329;
continue;
} else {
var temp__5735__auto___47330__$1 = cljs.core.seq(seq__46618_47321);
if(temp__5735__auto___47330__$1){
var seq__46618_47331__$1 = temp__5735__auto___47330__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46618_47331__$1)){
var c__4609__auto___47332 = cljs.core.chunk_first(seq__46618_47331__$1);
var G__47333 = cljs.core.chunk_rest(seq__46618_47331__$1);
var G__47334 = c__4609__auto___47332;
var G__47335 = cljs.core.count(c__4609__auto___47332);
var G__47336 = (0);
seq__46618_47321 = G__47333;
chunk__46619_47322 = G__47334;
count__46620_47323 = G__47335;
i__46621_47324 = G__47336;
continue;
} else {
var test_47337 = cljs.core.first(seq__46618_47331__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47337,":");


var G__47338 = cljs.core.next(seq__46618_47331__$1);
var G__47339 = null;
var G__47340 = (0);
var G__47341 = (0);
seq__46618_47321 = G__47338;
chunk__46619_47322 = G__47339;
count__46620_47323 = G__47340;
i__46621_47324 = G__47341;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_47320);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_47320);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__47342 = cljs.core.next(seq__46586_47309__$1);
var G__47343 = null;
var G__47344 = (0);
var G__47345 = (0);
seq__46586_47273 = G__47342;
chunk__46587_47274 = G__47343;
count__46588_47275 = G__47344;
i__46589_47276 = G__47345;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__46623){
var map__46624 = p__46623;
var map__46624__$1 = (((((!((map__46624 == null))))?(((((map__46624.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46624.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46624):map__46624);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46624__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46624__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__46629 = env;
var G__46630 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__46629,G__46630) : cljs.compiler.resolve_type.call(null,G__46629,G__46630));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__46631 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46631,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46631,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__46626_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__46626_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__46626_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__46634 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__46634,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__46634;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__46639 = env;
var G__46640 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__46639,G__46640) : cljs.compiler.resolve_type.call(null,G__46639,G__46640));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46643_SHARP_){
return cljs.compiler.resolve_type(env,p1__46643_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__46644 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__46645 = cljs.core.seq(vec__46644);
var first__46646 = cljs.core.first(seq__46645);
var seq__46645__$1 = cljs.core.next(seq__46645);
var p = first__46646;
var first__46646__$1 = cljs.core.first(seq__46645__$1);
var seq__46645__$2 = cljs.core.next(seq__46645__$1);
var ts = first__46646__$1;
var first__46646__$2 = cljs.core.first(seq__46645__$2);
var seq__46645__$3 = cljs.core.next(seq__46645__$2);
var n = first__46646__$2;
var xs = seq__46645__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__46647 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__46648 = cljs.core.seq(vec__46647);
var first__46649 = cljs.core.first(seq__46648);
var seq__46648__$1 = cljs.core.next(seq__46648);
var p = first__46649;
var first__46649__$1 = cljs.core.first(seq__46648__$1);
var seq__46648__$2 = cljs.core.next(seq__46648__$1);
var ts = first__46649__$1;
var xs = seq__46648__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__46651 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__46650 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__46650.cljs$core$IFn$_invoke$arity$1 ? fexpr__46650.cljs$core$IFn$_invoke$arity$1(G__46651) : fexpr__46650.call(null,G__46651));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__46654 = arguments.length;
switch (G__46654) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__46662 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46652_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__46652_SHARP_);
} else {
return p1__46652_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__46663 = cljs.core.seq(vec__46662);
var first__46664 = cljs.core.first(seq__46663);
var seq__46663__$1 = cljs.core.next(seq__46663);
var x = first__46664;
var ys = seq__46663__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__46665 = cljs.core.seq(ys);
var chunk__46666 = null;
var count__46667 = (0);
var i__46668 = (0);
while(true){
if((i__46668 < count__46667)){
var next_line = chunk__46666.cljs$core$IIndexed$_nth$arity$2(null,i__46668);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__47352 = seq__46665;
var G__47353 = chunk__46666;
var G__47354 = count__46667;
var G__47355 = (i__46668 + (1));
seq__46665 = G__47352;
chunk__46666 = G__47353;
count__46667 = G__47354;
i__46668 = G__47355;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46665);
if(temp__5735__auto__){
var seq__46665__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46665__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46665__$1);
var G__47356 = cljs.core.chunk_rest(seq__46665__$1);
var G__47357 = c__4609__auto__;
var G__47358 = cljs.core.count(c__4609__auto__);
var G__47359 = (0);
seq__46665 = G__47356;
chunk__46666 = G__47357;
count__46667 = G__47358;
i__46668 = G__47359;
continue;
} else {
var next_line = cljs.core.first(seq__46665__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__47360 = cljs.core.next(seq__46665__$1);
var G__47361 = null;
var G__47362 = (0);
var G__47363 = (0);
seq__46665 = G__47360;
chunk__46666 = G__47361;
count__46667 = G__47362;
i__46668 = G__47363;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__46669_47364 = cljs.core.seq(docs__$2);
var chunk__46670_47365 = null;
var count__46671_47366 = (0);
var i__46672_47367 = (0);
while(true){
if((i__46672_47367 < count__46671_47366)){
var e_47368 = chunk__46670_47365.cljs$core$IIndexed$_nth$arity$2(null,i__46672_47367);
if(cljs.core.truth_(e_47368)){
print_comment_lines(e_47368);
} else {
}


var G__47369 = seq__46669_47364;
var G__47370 = chunk__46670_47365;
var G__47371 = count__46671_47366;
var G__47372 = (i__46672_47367 + (1));
seq__46669_47364 = G__47369;
chunk__46670_47365 = G__47370;
count__46671_47366 = G__47371;
i__46672_47367 = G__47372;
continue;
} else {
var temp__5735__auto___47373 = cljs.core.seq(seq__46669_47364);
if(temp__5735__auto___47373){
var seq__46669_47374__$1 = temp__5735__auto___47373;
if(cljs.core.chunked_seq_QMARK_(seq__46669_47374__$1)){
var c__4609__auto___47375 = cljs.core.chunk_first(seq__46669_47374__$1);
var G__47376 = cljs.core.chunk_rest(seq__46669_47374__$1);
var G__47377 = c__4609__auto___47375;
var G__47378 = cljs.core.count(c__4609__auto___47375);
var G__47379 = (0);
seq__46669_47364 = G__47376;
chunk__46670_47365 = G__47377;
count__46671_47366 = G__47378;
i__46672_47367 = G__47379;
continue;
} else {
var e_47380 = cljs.core.first(seq__46669_47374__$1);
if(cljs.core.truth_(e_47380)){
print_comment_lines(e_47380);
} else {
}


var G__47381 = cljs.core.next(seq__46669_47374__$1);
var G__47382 = null;
var G__47383 = (0);
var G__47384 = (0);
seq__46669_47364 = G__47381;
chunk__46670_47365 = G__47382;
count__46671_47366 = G__47383;
i__46672_47367 = G__47384;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__46674_SHARP_){
return goog.string.startsWith(p1__46674_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__46675){
var map__46676 = p__46675;
var map__46676__$1 = (((((!((map__46676 == null))))?(((((map__46676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46676):map__46676);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__46678){
var map__46679 = p__46678;
var map__46679__$1 = (((((!((map__46679 == null))))?(((((map__46679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46679):map__46679);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__46681_47385 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__46682_47386 = null;
var count__46683_47387 = (0);
var i__46684_47388 = (0);
while(true){
if((i__46684_47388 < count__46683_47387)){
var vec__46691_47389 = chunk__46682_47386.cljs$core$IIndexed$_nth$arity$2(null,i__46684_47388);
var i_47390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46691_47389,(0),null);
var param_47391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46691_47389,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_47391);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__47392 = seq__46681_47385;
var G__47393 = chunk__46682_47386;
var G__47394 = count__46683_47387;
var G__47395 = (i__46684_47388 + (1));
seq__46681_47385 = G__47392;
chunk__46682_47386 = G__47393;
count__46683_47387 = G__47394;
i__46684_47388 = G__47395;
continue;
} else {
var temp__5735__auto___47396 = cljs.core.seq(seq__46681_47385);
if(temp__5735__auto___47396){
var seq__46681_47397__$1 = temp__5735__auto___47396;
if(cljs.core.chunked_seq_QMARK_(seq__46681_47397__$1)){
var c__4609__auto___47398 = cljs.core.chunk_first(seq__46681_47397__$1);
var G__47399 = cljs.core.chunk_rest(seq__46681_47397__$1);
var G__47400 = c__4609__auto___47398;
var G__47401 = cljs.core.count(c__4609__auto___47398);
var G__47402 = (0);
seq__46681_47385 = G__47399;
chunk__46682_47386 = G__47400;
count__46683_47387 = G__47401;
i__46684_47388 = G__47402;
continue;
} else {
var vec__46694_47403 = cljs.core.first(seq__46681_47397__$1);
var i_47404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46694_47403,(0),null);
var param_47405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46694_47403,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_47405);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__47406 = cljs.core.next(seq__46681_47397__$1);
var G__47407 = null;
var G__47408 = (0);
var G__47409 = (0);
seq__46681_47385 = G__47406;
chunk__46682_47386 = G__47407;
count__46683_47387 = G__47408;
i__46684_47388 = G__47409;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__46697_47410 = cljs.core.seq(params);
var chunk__46698_47411 = null;
var count__46699_47412 = (0);
var i__46700_47413 = (0);
while(true){
if((i__46700_47413 < count__46699_47412)){
var param_47414 = chunk__46698_47411.cljs$core$IIndexed$_nth$arity$2(null,i__46700_47413);
cljs.compiler.emit(param_47414);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47414,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47415 = seq__46697_47410;
var G__47416 = chunk__46698_47411;
var G__47417 = count__46699_47412;
var G__47418 = (i__46700_47413 + (1));
seq__46697_47410 = G__47415;
chunk__46698_47411 = G__47416;
count__46699_47412 = G__47417;
i__46700_47413 = G__47418;
continue;
} else {
var temp__5735__auto___47419 = cljs.core.seq(seq__46697_47410);
if(temp__5735__auto___47419){
var seq__46697_47420__$1 = temp__5735__auto___47419;
if(cljs.core.chunked_seq_QMARK_(seq__46697_47420__$1)){
var c__4609__auto___47421 = cljs.core.chunk_first(seq__46697_47420__$1);
var G__47422 = cljs.core.chunk_rest(seq__46697_47420__$1);
var G__47423 = c__4609__auto___47421;
var G__47424 = cljs.core.count(c__4609__auto___47421);
var G__47425 = (0);
seq__46697_47410 = G__47422;
chunk__46698_47411 = G__47423;
count__46699_47412 = G__47424;
i__46700_47413 = G__47425;
continue;
} else {
var param_47426 = cljs.core.first(seq__46697_47420__$1);
cljs.compiler.emit(param_47426);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47426,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47427 = cljs.core.next(seq__46697_47420__$1);
var G__47428 = null;
var G__47429 = (0);
var G__47430 = (0);
seq__46697_47410 = G__47427;
chunk__46698_47411 = G__47428;
count__46699_47412 = G__47429;
i__46700_47413 = G__47430;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__46701_47431 = cljs.core.seq(params);
var chunk__46702_47432 = null;
var count__46703_47433 = (0);
var i__46704_47434 = (0);
while(true){
if((i__46704_47434 < count__46703_47433)){
var param_47435 = chunk__46702_47432.cljs$core$IIndexed$_nth$arity$2(null,i__46704_47434);
cljs.compiler.emit(param_47435);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47435,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47436 = seq__46701_47431;
var G__47437 = chunk__46702_47432;
var G__47438 = count__46703_47433;
var G__47439 = (i__46704_47434 + (1));
seq__46701_47431 = G__47436;
chunk__46702_47432 = G__47437;
count__46703_47433 = G__47438;
i__46704_47434 = G__47439;
continue;
} else {
var temp__5735__auto___47440 = cljs.core.seq(seq__46701_47431);
if(temp__5735__auto___47440){
var seq__46701_47441__$1 = temp__5735__auto___47440;
if(cljs.core.chunked_seq_QMARK_(seq__46701_47441__$1)){
var c__4609__auto___47442 = cljs.core.chunk_first(seq__46701_47441__$1);
var G__47443 = cljs.core.chunk_rest(seq__46701_47441__$1);
var G__47444 = c__4609__auto___47442;
var G__47445 = cljs.core.count(c__4609__auto___47442);
var G__47446 = (0);
seq__46701_47431 = G__47443;
chunk__46702_47432 = G__47444;
count__46703_47433 = G__47445;
i__46704_47434 = G__47446;
continue;
} else {
var param_47447 = cljs.core.first(seq__46701_47441__$1);
cljs.compiler.emit(param_47447);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47447,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47456 = cljs.core.next(seq__46701_47441__$1);
var G__47457 = null;
var G__47458 = (0);
var G__47459 = (0);
seq__46701_47431 = G__47456;
chunk__46702_47432 = G__47457;
count__46703_47433 = G__47458;
i__46704_47434 = G__47459;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__46705 = cljs.core.seq(params);
var chunk__46706 = null;
var count__46707 = (0);
var i__46708 = (0);
while(true){
if((i__46708 < count__46707)){
var param = chunk__46706.cljs$core$IIndexed$_nth$arity$2(null,i__46708);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47460 = seq__46705;
var G__47461 = chunk__46706;
var G__47462 = count__46707;
var G__47463 = (i__46708 + (1));
seq__46705 = G__47460;
chunk__46706 = G__47461;
count__46707 = G__47462;
i__46708 = G__47463;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46705);
if(temp__5735__auto__){
var seq__46705__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46705__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46705__$1);
var G__47464 = cljs.core.chunk_rest(seq__46705__$1);
var G__47465 = c__4609__auto__;
var G__47466 = cljs.core.count(c__4609__auto__);
var G__47467 = (0);
seq__46705 = G__47464;
chunk__46706 = G__47465;
count__46707 = G__47466;
i__46708 = G__47467;
continue;
} else {
var param = cljs.core.first(seq__46705__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47468 = cljs.core.next(seq__46705__$1);
var G__47469 = null;
var G__47470 = (0);
var G__47471 = (0);
seq__46705 = G__47468;
chunk__46706 = G__47469;
count__46707 = G__47470;
i__46708 = G__47471;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__46716){
var map__46718 = p__46716;
var map__46718__$1 = (((((!((map__46718 == null))))?(((((map__46718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46718):map__46718);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46718__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46718__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46718__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46718__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46718__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46718__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__46720){
var map__46721 = p__46720;
var map__46721__$1 = (((((!((map__46721 == null))))?(((((map__46721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46721.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46721):map__46721);
var f = map__46721__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_47474__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_47475 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_47474__$1);
var delegate_name_47476 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_47475),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_47476," = function (");

var seq__46723_47477 = cljs.core.seq(params);
var chunk__46724_47478 = null;
var count__46725_47479 = (0);
var i__46726_47480 = (0);
while(true){
if((i__46726_47480 < count__46725_47479)){
var param_47481 = chunk__46724_47478.cljs$core$IIndexed$_nth$arity$2(null,i__46726_47480);
cljs.compiler.emit(param_47481);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47481,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47482 = seq__46723_47477;
var G__47483 = chunk__46724_47478;
var G__47484 = count__46725_47479;
var G__47485 = (i__46726_47480 + (1));
seq__46723_47477 = G__47482;
chunk__46724_47478 = G__47483;
count__46725_47479 = G__47484;
i__46726_47480 = G__47485;
continue;
} else {
var temp__5735__auto___47486 = cljs.core.seq(seq__46723_47477);
if(temp__5735__auto___47486){
var seq__46723_47487__$1 = temp__5735__auto___47486;
if(cljs.core.chunked_seq_QMARK_(seq__46723_47487__$1)){
var c__4609__auto___47488 = cljs.core.chunk_first(seq__46723_47487__$1);
var G__47489 = cljs.core.chunk_rest(seq__46723_47487__$1);
var G__47490 = c__4609__auto___47488;
var G__47491 = cljs.core.count(c__4609__auto___47488);
var G__47492 = (0);
seq__46723_47477 = G__47489;
chunk__46724_47478 = G__47490;
count__46725_47479 = G__47491;
i__46726_47480 = G__47492;
continue;
} else {
var param_47494 = cljs.core.first(seq__46723_47487__$1);
cljs.compiler.emit(param_47494);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47494,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47495 = cljs.core.next(seq__46723_47487__$1);
var G__47496 = null;
var G__47497 = (0);
var G__47498 = (0);
seq__46723_47477 = G__47495;
chunk__46724_47478 = G__47496;
count__46725_47479 = G__47497;
i__46726_47480 = G__47498;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_47475," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_47499 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_47499,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_47476,".call(this,");

var seq__46727_47500 = cljs.core.seq(params);
var chunk__46728_47501 = null;
var count__46729_47502 = (0);
var i__46730_47503 = (0);
while(true){
if((i__46730_47503 < count__46729_47502)){
var param_47504 = chunk__46728_47501.cljs$core$IIndexed$_nth$arity$2(null,i__46730_47503);
cljs.compiler.emit(param_47504);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47504,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47505 = seq__46727_47500;
var G__47506 = chunk__46728_47501;
var G__47507 = count__46729_47502;
var G__47508 = (i__46730_47503 + (1));
seq__46727_47500 = G__47505;
chunk__46728_47501 = G__47506;
count__46729_47502 = G__47507;
i__46730_47503 = G__47508;
continue;
} else {
var temp__5735__auto___47509 = cljs.core.seq(seq__46727_47500);
if(temp__5735__auto___47509){
var seq__46727_47510__$1 = temp__5735__auto___47509;
if(cljs.core.chunked_seq_QMARK_(seq__46727_47510__$1)){
var c__4609__auto___47511 = cljs.core.chunk_first(seq__46727_47510__$1);
var G__47512 = cljs.core.chunk_rest(seq__46727_47510__$1);
var G__47513 = c__4609__auto___47511;
var G__47514 = cljs.core.count(c__4609__auto___47511);
var G__47515 = (0);
seq__46727_47500 = G__47512;
chunk__46728_47501 = G__47513;
count__46729_47502 = G__47514;
i__46730_47503 = G__47515;
continue;
} else {
var param_47516 = cljs.core.first(seq__46727_47510__$1);
cljs.compiler.emit(param_47516);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47516,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47517 = cljs.core.next(seq__46727_47510__$1);
var G__47518 = null;
var G__47519 = (0);
var G__47520 = (0);
seq__46727_47500 = G__47517;
chunk__46728_47501 = G__47518;
count__46729_47502 = G__47519;
i__46730_47503 = G__47520;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47475,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_47475,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_47474__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47475,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_47476,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_47475,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__46734){
var map__46735 = p__46734;
var map__46735__$1 = (((((!((map__46735 == null))))?(((((map__46735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46735):map__46735);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__46731_SHARP_){
var and__4174__auto__ = p1__46731_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__46731_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_47521__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_47522 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_47521__$1);
var maxparams_47523 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_47524 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_47522),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_47525 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__46732_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__46732_SHARP_)));
}),cljs.core.seq(mmap_47524));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_47522," = null;");

var seq__46738_47526 = cljs.core.seq(ms_47525);
var chunk__46739_47527 = null;
var count__46740_47528 = (0);
var i__46741_47529 = (0);
while(true){
if((i__46741_47529 < count__46740_47528)){
var vec__46749_47530 = chunk__46739_47527.cljs$core$IIndexed$_nth$arity$2(null,i__46741_47529);
var n_47531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46749_47530,(0),null);
var meth_47532 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46749_47530,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_47531," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47532))){
cljs.compiler.emit_variadic_fn_method(meth_47532);
} else {
cljs.compiler.emit_fn_method(meth_47532);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__47533 = seq__46738_47526;
var G__47534 = chunk__46739_47527;
var G__47535 = count__46740_47528;
var G__47536 = (i__46741_47529 + (1));
seq__46738_47526 = G__47533;
chunk__46739_47527 = G__47534;
count__46740_47528 = G__47535;
i__46741_47529 = G__47536;
continue;
} else {
var temp__5735__auto___47537 = cljs.core.seq(seq__46738_47526);
if(temp__5735__auto___47537){
var seq__46738_47538__$1 = temp__5735__auto___47537;
if(cljs.core.chunked_seq_QMARK_(seq__46738_47538__$1)){
var c__4609__auto___47539 = cljs.core.chunk_first(seq__46738_47538__$1);
var G__47540 = cljs.core.chunk_rest(seq__46738_47538__$1);
var G__47541 = c__4609__auto___47539;
var G__47542 = cljs.core.count(c__4609__auto___47539);
var G__47543 = (0);
seq__46738_47526 = G__47540;
chunk__46739_47527 = G__47541;
count__46740_47528 = G__47542;
i__46741_47529 = G__47543;
continue;
} else {
var vec__46752_47544 = cljs.core.first(seq__46738_47538__$1);
var n_47545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46752_47544,(0),null);
var meth_47546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46752_47544,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_47545," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47546))){
cljs.compiler.emit_variadic_fn_method(meth_47546);
} else {
cljs.compiler.emit_fn_method(meth_47546);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__47547 = cljs.core.next(seq__46738_47538__$1);
var G__47548 = null;
var G__47549 = (0);
var G__47550 = (0);
seq__46738_47526 = G__47547;
chunk__46739_47527 = G__47548;
count__46740_47528 = G__47549;
i__46741_47529 = G__47550;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47522," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_47523),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_47523)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_47523));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__46755_47551 = cljs.core.seq(ms_47525);
var chunk__46756_47552 = null;
var count__46757_47553 = (0);
var i__46758_47554 = (0);
while(true){
if((i__46758_47554 < count__46757_47553)){
var vec__46769_47555 = chunk__46756_47552.cljs$core$IIndexed$_nth$arity$2(null,i__46758_47554);
var n_47556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46769_47555,(0),null);
var meth_47557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46769_47555,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47557))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_47559 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_47559," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_47560 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_47559," = new cljs.core.IndexedSeq(",a_47560,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_47556,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_47523)),(((cljs.core.count(maxparams_47523) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_47559,");"], 0));
} else {
var pcnt_47561 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47557));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_47561,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_47556,".call(this",(((pcnt_47561 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_47561,maxparams_47523)),null,(1),null)),(2),null))),");");
}


var G__47562 = seq__46755_47551;
var G__47563 = chunk__46756_47552;
var G__47564 = count__46757_47553;
var G__47565 = (i__46758_47554 + (1));
seq__46755_47551 = G__47562;
chunk__46756_47552 = G__47563;
count__46757_47553 = G__47564;
i__46758_47554 = G__47565;
continue;
} else {
var temp__5735__auto___47566 = cljs.core.seq(seq__46755_47551);
if(temp__5735__auto___47566){
var seq__46755_47567__$1 = temp__5735__auto___47566;
if(cljs.core.chunked_seq_QMARK_(seq__46755_47567__$1)){
var c__4609__auto___47568 = cljs.core.chunk_first(seq__46755_47567__$1);
var G__47569 = cljs.core.chunk_rest(seq__46755_47567__$1);
var G__47570 = c__4609__auto___47568;
var G__47571 = cljs.core.count(c__4609__auto___47568);
var G__47572 = (0);
seq__46755_47551 = G__47569;
chunk__46756_47552 = G__47570;
count__46757_47553 = G__47571;
i__46758_47554 = G__47572;
continue;
} else {
var vec__46772_47573 = cljs.core.first(seq__46755_47567__$1);
var n_47574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46772_47573,(0),null);
var meth_47575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46772_47573,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47575))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_47576 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_47576," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_47577 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_47576," = new cljs.core.IndexedSeq(",a_47577,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_47574,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_47523)),(((cljs.core.count(maxparams_47523) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_47576,");"], 0));
} else {
var pcnt_47578 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47575));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_47578,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_47574,".call(this",(((pcnt_47578 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_47578,maxparams_47523)),null,(1),null)),(2),null))),");");
}


var G__47579 = cljs.core.next(seq__46755_47567__$1);
var G__47580 = null;
var G__47581 = (0);
var G__47582 = (0);
seq__46755_47551 = G__47579;
chunk__46756_47552 = G__47580;
count__46757_47553 = G__47581;
i__46758_47554 = G__47582;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_47583 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_47525)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_47583,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47522,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47522,".cljs$lang$applyTo = ",cljs.core.some((function (p1__46733_SHARP_){
var vec__46775 = p1__46733_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46775,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46775,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_47525),".cljs$lang$applyTo;");
} else {
}

var seq__46778_47584 = cljs.core.seq(ms_47525);
var chunk__46779_47585 = null;
var count__46780_47586 = (0);
var i__46781_47587 = (0);
while(true){
if((i__46781_47587 < count__46780_47586)){
var vec__46789_47588 = chunk__46779_47585.cljs$core$IIndexed$_nth$arity$2(null,i__46781_47587);
var n_47589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46789_47588,(0),null);
var meth_47590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46789_47588,(1),null);
var c_47591 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47590));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47590))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47522,".cljs$core$IFn$_invoke$arity$variadic = ",n_47589,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_47522,".cljs$core$IFn$_invoke$arity$",c_47591," = ",n_47589,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__47592 = seq__46778_47584;
var G__47593 = chunk__46779_47585;
var G__47594 = count__46780_47586;
var G__47595 = (i__46781_47587 + (1));
seq__46778_47584 = G__47592;
chunk__46779_47585 = G__47593;
count__46780_47586 = G__47594;
i__46781_47587 = G__47595;
continue;
} else {
var temp__5735__auto___47596 = cljs.core.seq(seq__46778_47584);
if(temp__5735__auto___47596){
var seq__46778_47597__$1 = temp__5735__auto___47596;
if(cljs.core.chunked_seq_QMARK_(seq__46778_47597__$1)){
var c__4609__auto___47598 = cljs.core.chunk_first(seq__46778_47597__$1);
var G__47599 = cljs.core.chunk_rest(seq__46778_47597__$1);
var G__47600 = c__4609__auto___47598;
var G__47601 = cljs.core.count(c__4609__auto___47598);
var G__47602 = (0);
seq__46778_47584 = G__47599;
chunk__46779_47585 = G__47600;
count__46780_47586 = G__47601;
i__46781_47587 = G__47602;
continue;
} else {
var vec__46793_47603 = cljs.core.first(seq__46778_47597__$1);
var n_47604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46793_47603,(0),null);
var meth_47605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46793_47603,(1),null);
var c_47606 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47605));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47605))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47522,".cljs$core$IFn$_invoke$arity$variadic = ",n_47604,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_47522,".cljs$core$IFn$_invoke$arity$",c_47606," = ",n_47604,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__47607 = cljs.core.next(seq__46778_47597__$1);
var G__47608 = null;
var G__47609 = (0);
var G__47610 = (0);
seq__46778_47584 = G__47607;
chunk__46779_47585 = G__47608;
count__46780_47586 = G__47609;
i__46781_47587 = G__47610;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_47522,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__46796){
var map__46797 = p__46796;
var map__46797__$1 = (((((!((map__46797 == null))))?(((((map__46797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46797.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46797):map__46797);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46797__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46797__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46797__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__46799_47611 = cljs.core.seq(statements);
var chunk__46800_47612 = null;
var count__46801_47613 = (0);
var i__46802_47614 = (0);
while(true){
if((i__46802_47614 < count__46801_47613)){
var s_47615 = chunk__46800_47612.cljs$core$IIndexed$_nth$arity$2(null,i__46802_47614);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_47615);


var G__47616 = seq__46799_47611;
var G__47617 = chunk__46800_47612;
var G__47618 = count__46801_47613;
var G__47619 = (i__46802_47614 + (1));
seq__46799_47611 = G__47616;
chunk__46800_47612 = G__47617;
count__46801_47613 = G__47618;
i__46802_47614 = G__47619;
continue;
} else {
var temp__5735__auto___47620 = cljs.core.seq(seq__46799_47611);
if(temp__5735__auto___47620){
var seq__46799_47621__$1 = temp__5735__auto___47620;
if(cljs.core.chunked_seq_QMARK_(seq__46799_47621__$1)){
var c__4609__auto___47622 = cljs.core.chunk_first(seq__46799_47621__$1);
var G__47623 = cljs.core.chunk_rest(seq__46799_47621__$1);
var G__47624 = c__4609__auto___47622;
var G__47625 = cljs.core.count(c__4609__auto___47622);
var G__47626 = (0);
seq__46799_47611 = G__47623;
chunk__46800_47612 = G__47624;
count__46801_47613 = G__47625;
i__46802_47614 = G__47626;
continue;
} else {
var s_47627 = cljs.core.first(seq__46799_47621__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_47627);


var G__47629 = cljs.core.next(seq__46799_47621__$1);
var G__47630 = null;
var G__47631 = (0);
var G__47632 = (0);
seq__46799_47611 = G__47629;
chunk__46800_47612 = G__47630;
count__46801_47613 = G__47631;
i__46802_47614 = G__47632;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__46803){
var map__46804 = p__46803;
var map__46804__$1 = (((((!((map__46804 == null))))?(((((map__46804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46804):map__46804);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46804__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46804__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46804__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46804__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46804__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__46806,is_loop){
var map__46807 = p__46806;
var map__46807__$1 = (((((!((map__46807 == null))))?(((((map__46807.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46807.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46807):map__46807);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46807__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46807__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46807__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__46809_47633 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__46810_47634 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__46810_47634);

try{var seq__46811_47635 = cljs.core.seq(bindings);
var chunk__46812_47636 = null;
var count__46813_47637 = (0);
var i__46814_47638 = (0);
while(true){
if((i__46814_47638 < count__46813_47637)){
var map__46819_47639 = chunk__46812_47636.cljs$core$IIndexed$_nth$arity$2(null,i__46814_47638);
var map__46819_47640__$1 = (((((!((map__46819_47639 == null))))?(((((map__46819_47639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46819_47639.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46819_47639):map__46819_47639);
var binding_47641 = map__46819_47640__$1;
var init_47642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46819_47640__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_47641);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_47642,";");


var G__47643 = seq__46811_47635;
var G__47644 = chunk__46812_47636;
var G__47645 = count__46813_47637;
var G__47646 = (i__46814_47638 + (1));
seq__46811_47635 = G__47643;
chunk__46812_47636 = G__47644;
count__46813_47637 = G__47645;
i__46814_47638 = G__47646;
continue;
} else {
var temp__5735__auto___47647 = cljs.core.seq(seq__46811_47635);
if(temp__5735__auto___47647){
var seq__46811_47648__$1 = temp__5735__auto___47647;
if(cljs.core.chunked_seq_QMARK_(seq__46811_47648__$1)){
var c__4609__auto___47649 = cljs.core.chunk_first(seq__46811_47648__$1);
var G__47650 = cljs.core.chunk_rest(seq__46811_47648__$1);
var G__47651 = c__4609__auto___47649;
var G__47652 = cljs.core.count(c__4609__auto___47649);
var G__47653 = (0);
seq__46811_47635 = G__47650;
chunk__46812_47636 = G__47651;
count__46813_47637 = G__47652;
i__46814_47638 = G__47653;
continue;
} else {
var map__46821_47654 = cljs.core.first(seq__46811_47648__$1);
var map__46821_47655__$1 = (((((!((map__46821_47654 == null))))?(((((map__46821_47654.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46821_47654.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46821_47654):map__46821_47654);
var binding_47656 = map__46821_47655__$1;
var init_47657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46821_47655__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_47656);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_47657,";");


var G__47658 = cljs.core.next(seq__46811_47648__$1);
var G__47659 = null;
var G__47660 = (0);
var G__47661 = (0);
seq__46811_47635 = G__47658;
chunk__46812_47636 = G__47659;
count__46813_47637 = G__47660;
i__46814_47638 = G__47661;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__46809_47633);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__46823){
var map__46824 = p__46823;
var map__46824__$1 = (((((!((map__46824 == null))))?(((((map__46824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46824):map__46824);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___47662 = cljs.core.count(exprs);
var i_47663 = (0);
while(true){
if((i_47663 < n__4666__auto___47662)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_47663) : temps.call(null,i_47663))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_47663) : exprs.call(null,i_47663)),";");

var G__47664 = (i_47663 + (1));
i_47663 = G__47664;
continue;
} else {
}
break;
}

var n__4666__auto___47665 = cljs.core.count(exprs);
var i_47666 = (0);
while(true){
if((i_47666 < n__4666__auto___47665)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_47666) : params.call(null,i_47666)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_47666) : temps.call(null,i_47666)),";");

var G__47667 = (i_47666 + (1));
i_47666 = G__47667;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__46826){
var map__46827 = p__46826;
var map__46827__$1 = (((((!((map__46827 == null))))?(((((map__46827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46827):map__46827);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__46829_47668 = cljs.core.seq(bindings);
var chunk__46830_47669 = null;
var count__46831_47670 = (0);
var i__46832_47671 = (0);
while(true){
if((i__46832_47671 < count__46831_47670)){
var map__46837_47672 = chunk__46830_47669.cljs$core$IIndexed$_nth$arity$2(null,i__46832_47671);
var map__46837_47673__$1 = (((((!((map__46837_47672 == null))))?(((((map__46837_47672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46837_47672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46837_47672):map__46837_47672);
var binding_47674 = map__46837_47673__$1;
var init_47675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46837_47673__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_47674)," = ",init_47675,";");


var G__47676 = seq__46829_47668;
var G__47677 = chunk__46830_47669;
var G__47678 = count__46831_47670;
var G__47679 = (i__46832_47671 + (1));
seq__46829_47668 = G__47676;
chunk__46830_47669 = G__47677;
count__46831_47670 = G__47678;
i__46832_47671 = G__47679;
continue;
} else {
var temp__5735__auto___47680 = cljs.core.seq(seq__46829_47668);
if(temp__5735__auto___47680){
var seq__46829_47681__$1 = temp__5735__auto___47680;
if(cljs.core.chunked_seq_QMARK_(seq__46829_47681__$1)){
var c__4609__auto___47682 = cljs.core.chunk_first(seq__46829_47681__$1);
var G__47683 = cljs.core.chunk_rest(seq__46829_47681__$1);
var G__47684 = c__4609__auto___47682;
var G__47685 = cljs.core.count(c__4609__auto___47682);
var G__47686 = (0);
seq__46829_47668 = G__47683;
chunk__46830_47669 = G__47684;
count__46831_47670 = G__47685;
i__46832_47671 = G__47686;
continue;
} else {
var map__46839_47687 = cljs.core.first(seq__46829_47681__$1);
var map__46839_47688__$1 = (((((!((map__46839_47687 == null))))?(((((map__46839_47687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46839_47687.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46839_47687):map__46839_47687);
var binding_47689 = map__46839_47688__$1;
var init_47690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46839_47688__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_47689)," = ",init_47690,";");


var G__47691 = cljs.core.next(seq__46829_47681__$1);
var G__47692 = null;
var G__47693 = (0);
var G__47694 = (0);
seq__46829_47668 = G__47691;
chunk__46830_47669 = G__47692;
count__46831_47670 = G__47693;
i__46832_47671 = G__47694;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__46843){
var map__46844 = p__46843;
var map__46844__$1 = (((((!((map__46844 == null))))?(((((map__46844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46844):map__46844);
var expr = map__46844__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__46859 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__46859.cljs$core$IFn$_invoke$arity$1 ? fexpr__46859.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__46859.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__46861 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__46861.cljs$core$IFn$_invoke$arity$1 ? fexpr__46861.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__46861.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__46846 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__46841_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__46841_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__46842_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__46842_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46846,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46846,(1),null);
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_47704 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_47704,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_47705 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_47705,args)),(((mfa_47705 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_47705,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__46863 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__46862 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__46862.cljs$core$IFn$_invoke$arity$1 ? fexpr__46862.cljs$core$IFn$_invoke$arity$1(G__46863) : fexpr__46862.call(null,G__46863));
} else {
return and__4174__auto__;
}
})())){
var fprop_47706 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_47706," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_47706,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_47706," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_47706,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__46864){
var map__46865 = p__46864;
var map__46865__$1 = (((((!((map__46865 == null))))?(((((map__46865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46865.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46865):map__46865);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46865__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46865__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46865__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__46867){
var map__46868 = p__46867;
var map__46868__$1 = (((((!((map__46868 == null))))?(((((map__46868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46868):map__46868);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46868__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46868__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46868__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__46870 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__46870__$1 = (((((!((map__46870 == null))))?(((((map__46870.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46870.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46870):map__46870);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46870__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46870__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__46871 = options;
var map__46871__$1 = (((((!((map__46871 == null))))?(((((map__46871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46871):map__46871);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46871__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46871__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__46872 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__46877 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__46877__$1 = (((((!((map__46877 == null))))?(((((map__46877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46877.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46877):map__46877);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46877__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46877__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46872,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46872,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__46879_47712 = cljs.core.seq(libs_to_load);
var chunk__46880_47713 = null;
var count__46881_47714 = (0);
var i__46882_47715 = (0);
while(true){
if((i__46882_47715 < count__46881_47714)){
var lib_47716 = chunk__46880_47713.cljs$core$IIndexed$_nth$arity$2(null,i__46882_47715);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_47716)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47716),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47716),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47716),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47716),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_47716,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47716),"');");
}

}
}
}


var G__47723 = seq__46879_47712;
var G__47724 = chunk__46880_47713;
var G__47725 = count__46881_47714;
var G__47726 = (i__46882_47715 + (1));
seq__46879_47712 = G__47723;
chunk__46880_47713 = G__47724;
count__46881_47714 = G__47725;
i__46882_47715 = G__47726;
continue;
} else {
var temp__5735__auto___47727 = cljs.core.seq(seq__46879_47712);
if(temp__5735__auto___47727){
var seq__46879_47728__$1 = temp__5735__auto___47727;
if(cljs.core.chunked_seq_QMARK_(seq__46879_47728__$1)){
var c__4609__auto___47729 = cljs.core.chunk_first(seq__46879_47728__$1);
var G__47730 = cljs.core.chunk_rest(seq__46879_47728__$1);
var G__47731 = c__4609__auto___47729;
var G__47732 = cljs.core.count(c__4609__auto___47729);
var G__47733 = (0);
seq__46879_47712 = G__47730;
chunk__46880_47713 = G__47731;
count__46881_47714 = G__47732;
i__46882_47715 = G__47733;
continue;
} else {
var lib_47734 = cljs.core.first(seq__46879_47728__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_47734)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47734),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47734),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47734),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47734),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_47734,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47734),"');");
}

}
}
}


var G__47735 = cljs.core.next(seq__46879_47728__$1);
var G__47736 = null;
var G__47737 = (0);
var G__47738 = (0);
seq__46879_47712 = G__47735;
chunk__46880_47713 = G__47736;
count__46881_47714 = G__47737;
i__46882_47715 = G__47738;
continue;
}
} else {
}
}
break;
}

var seq__46886_47739 = cljs.core.seq(node_libs);
var chunk__46887_47740 = null;
var count__46888_47741 = (0);
var i__46889_47742 = (0);
while(true){
if((i__46889_47742 < count__46888_47741)){
var lib_47743 = chunk__46887_47740.cljs$core$IIndexed$_nth$arity$2(null,i__46889_47742);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_47743)," = require('",lib_47743,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__47744 = seq__46886_47739;
var G__47745 = chunk__46887_47740;
var G__47746 = count__46888_47741;
var G__47747 = (i__46889_47742 + (1));
seq__46886_47739 = G__47744;
chunk__46887_47740 = G__47745;
count__46888_47741 = G__47746;
i__46889_47742 = G__47747;
continue;
} else {
var temp__5735__auto___47748 = cljs.core.seq(seq__46886_47739);
if(temp__5735__auto___47748){
var seq__46886_47749__$1 = temp__5735__auto___47748;
if(cljs.core.chunked_seq_QMARK_(seq__46886_47749__$1)){
var c__4609__auto___47750 = cljs.core.chunk_first(seq__46886_47749__$1);
var G__47751 = cljs.core.chunk_rest(seq__46886_47749__$1);
var G__47752 = c__4609__auto___47750;
var G__47753 = cljs.core.count(c__4609__auto___47750);
var G__47754 = (0);
seq__46886_47739 = G__47751;
chunk__46887_47740 = G__47752;
count__46888_47741 = G__47753;
i__46889_47742 = G__47754;
continue;
} else {
var lib_47755 = cljs.core.first(seq__46886_47749__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_47755)," = require('",lib_47755,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__47756 = cljs.core.next(seq__46886_47749__$1);
var G__47757 = null;
var G__47758 = (0);
var G__47759 = (0);
seq__46886_47739 = G__47756;
chunk__46887_47740 = G__47757;
count__46888_47741 = G__47758;
i__46889_47742 = G__47759;
continue;
}
} else {
}
}
break;
}

var seq__46894_47760 = cljs.core.seq(global_exports_libs);
var chunk__46895_47761 = null;
var count__46896_47762 = (0);
var i__46897_47763 = (0);
while(true){
if((i__46897_47763 < count__46896_47762)){
var lib_47764 = chunk__46895_47761.cljs$core$IIndexed$_nth$arity$2(null,i__46897_47763);
var map__46902_47765 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_47764));
var map__46902_47766__$1 = (((((!((map__46902_47765 == null))))?(((((map__46902_47765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46902_47765.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46902_47765):map__46902_47765);
var global_exports_47767 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46902_47766__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_47767,lib_47764);


var G__47768 = seq__46894_47760;
var G__47769 = chunk__46895_47761;
var G__47770 = count__46896_47762;
var G__47771 = (i__46897_47763 + (1));
seq__46894_47760 = G__47768;
chunk__46895_47761 = G__47769;
count__46896_47762 = G__47770;
i__46897_47763 = G__47771;
continue;
} else {
var temp__5735__auto___47772 = cljs.core.seq(seq__46894_47760);
if(temp__5735__auto___47772){
var seq__46894_47773__$1 = temp__5735__auto___47772;
if(cljs.core.chunked_seq_QMARK_(seq__46894_47773__$1)){
var c__4609__auto___47774 = cljs.core.chunk_first(seq__46894_47773__$1);
var G__47775 = cljs.core.chunk_rest(seq__46894_47773__$1);
var G__47776 = c__4609__auto___47774;
var G__47777 = cljs.core.count(c__4609__auto___47774);
var G__47778 = (0);
seq__46894_47760 = G__47775;
chunk__46895_47761 = G__47776;
count__46896_47762 = G__47777;
i__46897_47763 = G__47778;
continue;
} else {
var lib_47779 = cljs.core.first(seq__46894_47773__$1);
var map__46904_47780 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_47779));
var map__46904_47781__$1 = (((((!((map__46904_47780 == null))))?(((((map__46904_47780.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46904_47780.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46904_47780):map__46904_47780);
var global_exports_47782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46904_47781__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_47782,lib_47779);


var G__47783 = cljs.core.next(seq__46894_47773__$1);
var G__47784 = null;
var G__47785 = (0);
var G__47786 = (0);
seq__46894_47760 = G__47783;
chunk__46895_47761 = G__47784;
count__46896_47762 = G__47785;
i__46897_47763 = G__47786;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__46906){
var map__46907 = p__46906;
var map__46907__$1 = (((((!((map__46907 == null))))?(((((map__46907.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46907.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46907):map__46907);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46907__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__46909){
var map__46910 = p__46909;
var map__46910__$1 = (((((!((map__46910 == null))))?(((((map__46910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46910.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46910):map__46910);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46910__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__46912){
var map__46913 = p__46912;
var map__46913__$1 = (((((!((map__46913 == null))))?(((((map__46913.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46913.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46913):map__46913);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46913__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46913__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46913__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46913__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46913__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__46915_47787 = cljs.core.seq(protocols);
var chunk__46916_47788 = null;
var count__46917_47789 = (0);
var i__46918_47790 = (0);
while(true){
if((i__46918_47790 < count__46917_47789)){
var protocol_47791 = chunk__46916_47788.cljs$core$IIndexed$_nth$arity$2(null,i__46918_47790);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47791)),"}");


var G__47792 = seq__46915_47787;
var G__47793 = chunk__46916_47788;
var G__47794 = count__46917_47789;
var G__47795 = (i__46918_47790 + (1));
seq__46915_47787 = G__47792;
chunk__46916_47788 = G__47793;
count__46917_47789 = G__47794;
i__46918_47790 = G__47795;
continue;
} else {
var temp__5735__auto___47796 = cljs.core.seq(seq__46915_47787);
if(temp__5735__auto___47796){
var seq__46915_47797__$1 = temp__5735__auto___47796;
if(cljs.core.chunked_seq_QMARK_(seq__46915_47797__$1)){
var c__4609__auto___47798 = cljs.core.chunk_first(seq__46915_47797__$1);
var G__47799 = cljs.core.chunk_rest(seq__46915_47797__$1);
var G__47800 = c__4609__auto___47798;
var G__47801 = cljs.core.count(c__4609__auto___47798);
var G__47802 = (0);
seq__46915_47787 = G__47799;
chunk__46916_47788 = G__47800;
count__46917_47789 = G__47801;
i__46918_47790 = G__47802;
continue;
} else {
var protocol_47803 = cljs.core.first(seq__46915_47797__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47803)),"}");


var G__47804 = cljs.core.next(seq__46915_47797__$1);
var G__47805 = null;
var G__47806 = (0);
var G__47807 = (0);
seq__46915_47787 = G__47804;
chunk__46916_47788 = G__47805;
count__46917_47789 = G__47806;
i__46918_47790 = G__47807;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__46919_47808 = cljs.core.seq(fields__$1);
var chunk__46920_47809 = null;
var count__46921_47810 = (0);
var i__46922_47811 = (0);
while(true){
if((i__46922_47811 < count__46921_47810)){
var fld_47812 = chunk__46920_47809.cljs$core$IIndexed$_nth$arity$2(null,i__46922_47811);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47812," = ",fld_47812,";");


var G__47813 = seq__46919_47808;
var G__47814 = chunk__46920_47809;
var G__47815 = count__46921_47810;
var G__47816 = (i__46922_47811 + (1));
seq__46919_47808 = G__47813;
chunk__46920_47809 = G__47814;
count__46921_47810 = G__47815;
i__46922_47811 = G__47816;
continue;
} else {
var temp__5735__auto___47817 = cljs.core.seq(seq__46919_47808);
if(temp__5735__auto___47817){
var seq__46919_47818__$1 = temp__5735__auto___47817;
if(cljs.core.chunked_seq_QMARK_(seq__46919_47818__$1)){
var c__4609__auto___47819 = cljs.core.chunk_first(seq__46919_47818__$1);
var G__47820 = cljs.core.chunk_rest(seq__46919_47818__$1);
var G__47821 = c__4609__auto___47819;
var G__47822 = cljs.core.count(c__4609__auto___47819);
var G__47823 = (0);
seq__46919_47808 = G__47820;
chunk__46920_47809 = G__47821;
count__46921_47810 = G__47822;
i__46922_47811 = G__47823;
continue;
} else {
var fld_47824 = cljs.core.first(seq__46919_47818__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47824," = ",fld_47824,";");


var G__47825 = cljs.core.next(seq__46919_47818__$1);
var G__47826 = null;
var G__47827 = (0);
var G__47828 = (0);
seq__46919_47808 = G__47825;
chunk__46920_47809 = G__47826;
count__46921_47810 = G__47827;
i__46922_47811 = G__47828;
continue;
}
} else {
}
}
break;
}

var seq__46923_47829 = cljs.core.seq(pmasks);
var chunk__46924_47830 = null;
var count__46925_47831 = (0);
var i__46926_47832 = (0);
while(true){
if((i__46926_47832 < count__46925_47831)){
var vec__46933_47833 = chunk__46924_47830.cljs$core$IIndexed$_nth$arity$2(null,i__46926_47832);
var pno_47834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46933_47833,(0),null);
var pmask_47835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46933_47833,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47834,"$ = ",pmask_47835,";");


var G__47836 = seq__46923_47829;
var G__47837 = chunk__46924_47830;
var G__47838 = count__46925_47831;
var G__47839 = (i__46926_47832 + (1));
seq__46923_47829 = G__47836;
chunk__46924_47830 = G__47837;
count__46925_47831 = G__47838;
i__46926_47832 = G__47839;
continue;
} else {
var temp__5735__auto___47840 = cljs.core.seq(seq__46923_47829);
if(temp__5735__auto___47840){
var seq__46923_47841__$1 = temp__5735__auto___47840;
if(cljs.core.chunked_seq_QMARK_(seq__46923_47841__$1)){
var c__4609__auto___47842 = cljs.core.chunk_first(seq__46923_47841__$1);
var G__47843 = cljs.core.chunk_rest(seq__46923_47841__$1);
var G__47844 = c__4609__auto___47842;
var G__47845 = cljs.core.count(c__4609__auto___47842);
var G__47846 = (0);
seq__46923_47829 = G__47843;
chunk__46924_47830 = G__47844;
count__46925_47831 = G__47845;
i__46926_47832 = G__47846;
continue;
} else {
var vec__46936_47847 = cljs.core.first(seq__46923_47841__$1);
var pno_47848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46936_47847,(0),null);
var pmask_47849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46936_47847,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47848,"$ = ",pmask_47849,";");


var G__47850 = cljs.core.next(seq__46923_47841__$1);
var G__47851 = null;
var G__47852 = (0);
var G__47853 = (0);
seq__46923_47829 = G__47850;
chunk__46924_47830 = G__47851;
count__46925_47831 = G__47852;
i__46926_47832 = G__47853;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__46940){
var map__46941 = p__46940;
var map__46941__$1 = (((((!((map__46941 == null))))?(((((map__46941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46941.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46941):map__46941);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46941__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46941__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46941__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46941__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46941__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__46943_47854 = cljs.core.seq(protocols);
var chunk__46944_47855 = null;
var count__46945_47856 = (0);
var i__46946_47857 = (0);
while(true){
if((i__46946_47857 < count__46945_47856)){
var protocol_47858 = chunk__46944_47855.cljs$core$IIndexed$_nth$arity$2(null,i__46946_47857);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47858)),"}");


var G__47859 = seq__46943_47854;
var G__47860 = chunk__46944_47855;
var G__47861 = count__46945_47856;
var G__47862 = (i__46946_47857 + (1));
seq__46943_47854 = G__47859;
chunk__46944_47855 = G__47860;
count__46945_47856 = G__47861;
i__46946_47857 = G__47862;
continue;
} else {
var temp__5735__auto___47863 = cljs.core.seq(seq__46943_47854);
if(temp__5735__auto___47863){
var seq__46943_47864__$1 = temp__5735__auto___47863;
if(cljs.core.chunked_seq_QMARK_(seq__46943_47864__$1)){
var c__4609__auto___47865 = cljs.core.chunk_first(seq__46943_47864__$1);
var G__47866 = cljs.core.chunk_rest(seq__46943_47864__$1);
var G__47867 = c__4609__auto___47865;
var G__47868 = cljs.core.count(c__4609__auto___47865);
var G__47869 = (0);
seq__46943_47854 = G__47866;
chunk__46944_47855 = G__47867;
count__46945_47856 = G__47868;
i__46946_47857 = G__47869;
continue;
} else {
var protocol_47870 = cljs.core.first(seq__46943_47864__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47870)),"}");


var G__47871 = cljs.core.next(seq__46943_47864__$1);
var G__47872 = null;
var G__47873 = (0);
var G__47874 = (0);
seq__46943_47854 = G__47871;
chunk__46944_47855 = G__47872;
count__46945_47856 = G__47873;
i__46946_47857 = G__47874;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__46951_47875 = cljs.core.seq(fields__$1);
var chunk__46952_47876 = null;
var count__46953_47877 = (0);
var i__46954_47878 = (0);
while(true){
if((i__46954_47878 < count__46953_47877)){
var fld_47879 = chunk__46952_47876.cljs$core$IIndexed$_nth$arity$2(null,i__46954_47878);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47879," = ",fld_47879,";");


var G__47880 = seq__46951_47875;
var G__47881 = chunk__46952_47876;
var G__47882 = count__46953_47877;
var G__47883 = (i__46954_47878 + (1));
seq__46951_47875 = G__47880;
chunk__46952_47876 = G__47881;
count__46953_47877 = G__47882;
i__46954_47878 = G__47883;
continue;
} else {
var temp__5735__auto___47884 = cljs.core.seq(seq__46951_47875);
if(temp__5735__auto___47884){
var seq__46951_47885__$1 = temp__5735__auto___47884;
if(cljs.core.chunked_seq_QMARK_(seq__46951_47885__$1)){
var c__4609__auto___47886 = cljs.core.chunk_first(seq__46951_47885__$1);
var G__47887 = cljs.core.chunk_rest(seq__46951_47885__$1);
var G__47888 = c__4609__auto___47886;
var G__47889 = cljs.core.count(c__4609__auto___47886);
var G__47890 = (0);
seq__46951_47875 = G__47887;
chunk__46952_47876 = G__47888;
count__46953_47877 = G__47889;
i__46954_47878 = G__47890;
continue;
} else {
var fld_47891 = cljs.core.first(seq__46951_47885__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47891," = ",fld_47891,";");


var G__47892 = cljs.core.next(seq__46951_47885__$1);
var G__47893 = null;
var G__47894 = (0);
var G__47895 = (0);
seq__46951_47875 = G__47892;
chunk__46952_47876 = G__47893;
count__46953_47877 = G__47894;
i__46954_47878 = G__47895;
continue;
}
} else {
}
}
break;
}

var seq__46955_47896 = cljs.core.seq(pmasks);
var chunk__46956_47897 = null;
var count__46957_47898 = (0);
var i__46958_47899 = (0);
while(true){
if((i__46958_47899 < count__46957_47898)){
var vec__46966_47900 = chunk__46956_47897.cljs$core$IIndexed$_nth$arity$2(null,i__46958_47899);
var pno_47901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46966_47900,(0),null);
var pmask_47902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46966_47900,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47901,"$ = ",pmask_47902,";");


var G__47903 = seq__46955_47896;
var G__47904 = chunk__46956_47897;
var G__47905 = count__46957_47898;
var G__47906 = (i__46958_47899 + (1));
seq__46955_47896 = G__47903;
chunk__46956_47897 = G__47904;
count__46957_47898 = G__47905;
i__46958_47899 = G__47906;
continue;
} else {
var temp__5735__auto___47907 = cljs.core.seq(seq__46955_47896);
if(temp__5735__auto___47907){
var seq__46955_47908__$1 = temp__5735__auto___47907;
if(cljs.core.chunked_seq_QMARK_(seq__46955_47908__$1)){
var c__4609__auto___47909 = cljs.core.chunk_first(seq__46955_47908__$1);
var G__47910 = cljs.core.chunk_rest(seq__46955_47908__$1);
var G__47911 = c__4609__auto___47909;
var G__47912 = cljs.core.count(c__4609__auto___47909);
var G__47913 = (0);
seq__46955_47896 = G__47910;
chunk__46956_47897 = G__47911;
count__46957_47898 = G__47912;
i__46958_47899 = G__47913;
continue;
} else {
var vec__46969_47914 = cljs.core.first(seq__46955_47908__$1);
var pno_47915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46969_47914,(0),null);
var pmask_47916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46969_47914,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47915,"$ = ",pmask_47916,";");


var G__47917 = cljs.core.next(seq__46955_47908__$1);
var G__47918 = null;
var G__47919 = (0);
var G__47920 = (0);
seq__46955_47896 = G__47917;
chunk__46956_47897 = G__47918;
count__46957_47898 = G__47919;
i__46958_47899 = G__47920;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__46972){
var map__46973 = p__46972;
var map__46973__$1 = (((((!((map__46973 == null))))?(((((map__46973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46973):map__46973);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__46980){
var map__46985 = p__46980;
var map__46985__$1 = (((((!((map__46985 == null))))?(((((map__46985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46985.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46985):map__46985);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46985__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46985__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46985__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46985__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46985__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__46987 = clojure.string.trim(code);
var G__46988 = "/*";
return goog.string.startsWith(G__46987,G__46988);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__46301__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46301__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__46998 = cljs.core.seq(table);
var chunk__46999 = null;
var count__47000 = (0);
var i__47001 = (0);
while(true){
if((i__47001 < count__47000)){
var vec__47008 = chunk__46999.cljs$core$IIndexed$_nth$arity$2(null,i__47001);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47008,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47008,(1),null);
var ns_47921 = cljs.core.namespace(sym);
var name_47922 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__47923 = seq__46998;
var G__47924 = chunk__46999;
var G__47925 = count__47000;
var G__47926 = (i__47001 + (1));
seq__46998 = G__47923;
chunk__46999 = G__47924;
count__47000 = G__47925;
i__47001 = G__47926;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46998);
if(temp__5735__auto__){
var seq__46998__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46998__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46998__$1);
var G__47927 = cljs.core.chunk_rest(seq__46998__$1);
var G__47928 = c__4609__auto__;
var G__47929 = cljs.core.count(c__4609__auto__);
var G__47930 = (0);
seq__46998 = G__47927;
chunk__46999 = G__47928;
count__47000 = G__47929;
i__47001 = G__47930;
continue;
} else {
var vec__47019 = cljs.core.first(seq__46998__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47019,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47019,(1),null);
var ns_47931 = cljs.core.namespace(sym);
var name_47932 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__47933 = cljs.core.next(seq__46998__$1);
var G__47934 = null;
var G__47935 = (0);
var G__47936 = (0);
seq__46998 = G__47933;
chunk__46999 = G__47934;
count__47000 = G__47935;
i__47001 = G__47936;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__47032 = arguments.length;
switch (G__47032) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_47938 = cljs.core.first(ks);
var vec__47040_47939 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_47938);
var top_47940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47040_47939,(0),null);
var prefix_SINGLEQUOTE__47941 = vec__47040_47939;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_47938)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__47941) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_47940)) || (cljs.core.contains_QMARK_(known_externs,top_47940)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__47941)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_47940);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__47941)),";");
}
} else {
}

var m_47942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_47938);
if(cljs.core.empty_QMARK_(m_47942)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__47941,m_47942,top_level,known_externs);
}

var G__47943 = cljs.core.next(ks);
ks = G__47943;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
