var shadow$provide = {};
var CLOSURE_NO_DEPS = true;
var CLOSURE_BASE_PATH = './js/cljs/cljs-runtime/';
var CLOSURE_DEFINES = {"goog.DEBUG":true,"goog.LOCALE":"en","goog.TRANSPILE":"never","goog.ENABLE_DEBUG_LOADER":false};
/** @define {boolean} */ var COMPILED = false;
/** @const */ var goog = goog || {};
/**
 * @const
 * @type {!Global}
 * @suppress {undefinedVars}
 */
goog.global = this || self;
/** @type {(Object<string,(string|number|boolean)>|undefined)} */ goog.global.CLOSURE_UNCOMPILED_DEFINES;
/** @type {(Object<string,(string|number|boolean)>|undefined)} */ goog.global.CLOSURE_DEFINES;
/**
 * @param {?} val
 * @return {boolean}
 * @deprecated Use `val !== undefined` instead.
 */
goog.isDef = function(val) {
  return val !== void 0;
};
/**
 * @param {?} val
 * @return {boolean}
 * @deprecated Use `typeof val === 'string'` instead.
 */
goog.isString = function(val) {
  return typeof val == "string";
};
/**
 * @param {?} val
 * @return {boolean}
 * @deprecated Use `typeof val === 'boolean'` instead.
 */
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
/**
 * @param {?} val
 * @return {boolean}
 * @deprecated Use `typeof val === 'number'` instead.
 */
goog.isNumber = function(val) {
  return typeof val == "number";
};
/**
 * @private
 * @param {string} name
 * @param {*=} opt_object
 * @param {Object=} opt_objectToExportTo
 */
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && typeof cur.execScript != "undefined") {
    cur.execScript("var " + parts[0]);
  }
  for (var part; parts.length && (part = parts.shift());) {
    if (!parts.length && opt_object !== undefined) {
      cur[part] = opt_object;
    } else {
      if (cur[part] && cur[part] !== Object.prototype[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
/**
 * @param {string} name
 * @param {T} defaultValue
 * @return {T}
 * @template T
 */
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    var uncompiledDefines = goog.global.CLOSURE_UNCOMPILED_DEFINES;
    var defines = goog.global.CLOSURE_DEFINES;
    if (uncompiledDefines && /** @type {?} */ (uncompiledDefines).nodeType === undefined && Object.prototype.hasOwnProperty.call(uncompiledDefines, name)) {
      value = uncompiledDefines[name];
    } else {
      if (defines && /** @type {?} */ (defines).nodeType === undefined && Object.prototype.hasOwnProperty.call(defines, name)) {
        value = defines[name];
      }
    }
  }
  return value;
};
/** @define {number} */ goog.FEATURESET_YEAR = goog.define("goog.FEATURESET_YEAR", 2012);
/** @define {boolean} */ goog.DEBUG = goog.define("goog.DEBUG", true);
/** @define {string} */ goog.LOCALE = goog.define("goog.LOCALE", "en");
/** @define {boolean} */ goog.TRUSTED_SITE = goog.define("goog.TRUSTED_SITE", true);
/** @define {boolean} */ goog.STRICT_MODE_COMPATIBLE = goog.define("goog.STRICT_MODE_COMPATIBLE", false);
/** @define {boolean} */ goog.DISALLOW_TEST_ONLY_CODE = goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
/** @define {boolean} */ goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING = goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
/**
 * @param {string} name
 */
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw new Error("goog.provide cannot be used within a module.");
  }
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw new Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
/**
 * @private
 * @param {string} name
 * @param {Object=} opt_obj
 */
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
/**
 * @param {?Window=} opt_window
 * @return {string}
 */
goog.getScriptNonce = function(opt_window) {
  if (opt_window && opt_window != goog.global) {
    return goog.getScriptNonce_(opt_window.document);
  }
  if (goog.cspNonce_ === null) {
    goog.cspNonce_ = goog.getScriptNonce_(goog.global.document);
  }
  return goog.cspNonce_;
};
/** @private @const */ goog.NONCE_PATTERN_ = /^[\w+/_-]+[=]{0,2}$/;
/** @private @type {?string} */ goog.cspNonce_ = null;
/**
 * @private
 * @param {!Document} doc
 * @return {string}
 */
goog.getScriptNonce_ = function(doc) {
  var script = doc.querySelector && doc.querySelector("script[nonce]");
  if (script) {
    var nonce = script["nonce"] || script.getAttribute("nonce");
    if (nonce && goog.NONCE_PATTERN_.test(nonce)) {
      return nonce;
    }
  }
  return "";
};
/** @private */ goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
/**
 * @param {string} name
 * @return {void}
 */
goog.module = function(name) {
  if (typeof name !== "string" || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw new Error("Invalid module identifier");
  }
  if (!goog.isInGoogModuleLoader_()) {
    throw new Error("Module " + name + " has been loaded incorrectly. Note, " + "modules cannot be loaded as normal scripts. They require some kind of " + "pre-processing step. You're likely trying to load a module via a " + "script tag or as a part of a concatenated bundle without rewriting the " + "module. For more info see: " + "https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw new Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw new Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
/**
 * @param {string} name
 * @return {?}
 * @suppress {missingProvide}
 */
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
/**
 * @private
 * @param {string} name
 * @return {?}
 */
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (name in goog.loadedModules_) {
      return goog.loadedModules_[name].exports;
    } else {
      if (!goog.implicitNamespaces_[name]) {
        var ns = goog.getObjectByName(name);
        return ns != null ? ns : null;
      }
    }
  }
  return null;
};
/** @enum {string} */ goog.ModuleType = {ES6:"es6", GOOG:"goog"};
/** @private @type {?{moduleName:(string|undefined),declareLegacyNamespace:boolean,type:?goog.ModuleType}} */ goog.moduleLoaderState_ = null;
/**
 * @private
 * @return {boolean}
 */
goog.isInModuleLoader_ = function() {
  return goog.isInGoogModuleLoader_() || goog.isInEs6ModuleLoader_();
};
/**
 * @private
 * @return {boolean}
 */
goog.isInGoogModuleLoader_ = function() {
  return !!goog.moduleLoaderState_ && goog.moduleLoaderState_.type == goog.ModuleType.GOOG;
};
/**
 * @private
 * @return {boolean}
 */
goog.isInEs6ModuleLoader_ = function() {
  var inLoader = !!goog.moduleLoaderState_ && goog.moduleLoaderState_.type == goog.ModuleType.ES6;
  if (inLoader) {
    return true;
  }
  var jscomp = goog.global["$jscomp"];
  if (jscomp) {
    if (typeof jscomp.getCurrentModulePath != "function") {
      return false;
    }
    return !!jscomp.getCurrentModulePath();
  }
  return false;
};
/**
 * @suppress {missingProvide}
 */
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInGoogModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw new Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
/**
 * @param {string} namespace
 * @suppress {missingProvide}
 */
goog.declareModuleId = function(namespace) {
  if (!COMPILED) {
    if (!goog.isInEs6ModuleLoader_()) {
      throw new Error("goog.declareModuleId may only be called from " + "within an ES6 module");
    }
    if (goog.moduleLoaderState_ && goog.moduleLoaderState_.moduleName) {
      throw new Error("goog.declareModuleId may only be called once per module.");
    }
    if (namespace in goog.loadedModules_) {
      throw new Error('Module with namespace "' + namespace + '" already exists.');
    }
  }
  if (goog.moduleLoaderState_) {
    goog.moduleLoaderState_.moduleName = namespace;
  } else {
    var jscomp = goog.global["$jscomp"];
    if (!jscomp || typeof jscomp.getCurrentModulePath != "function") {
      throw new Error('Module with namespace "' + namespace + '" has been loaded incorrectly.');
    }
    var exports = jscomp.require(jscomp.getCurrentModulePath());
    goog.loadedModules_[namespace] = {exports:exports, type:goog.ModuleType.ES6, moduleId:namespace};
  }
};
/**
 * @param {string=} opt_message
 */
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw new Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
/**
 * @param {string} name
 */
goog.forwardDeclare = function(name) {
};
goog.forwardDeclare("Document");
goog.forwardDeclare("HTMLScriptElement");
goog.forwardDeclare("XMLHttpRequest");
if (!COMPILED) {
  /**
   * @private
   * @param {string} name
   * @return {boolean}
   */
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.getObjectByName(name) != null;
  };
  /** @private @type {!Object<string,(boolean|undefined)>} */ goog.implicitNamespaces_ = {"goog.module":true};
}
/**
 * @param {string} name
 * @param {Object=} opt_obj
 * @return {?}
 */
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var i = 0; i < parts.length; i++) {
    cur = cur[parts[i]];
    if (cur == null) {
      return null;
    }
  }
  return cur;
};
/**
 * @param {!Object} obj
 * @param {Object=} opt_global
 * @deprecated Properties may be explicitly exported to the global scope, but this should no longer be done in bulk.
 */
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
/**
 * @param {string} relPath
 * @param {!Array<string>} provides
 * @param {!Array<string>} requires
 * @param {(boolean|!Object<?,string>)=} opt_loadFlags
 */
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
  if (!COMPILED && goog.DEPENDENCIES_ENABLED) {
    goog.debugLoader_.addDependency(relPath, provides, requires, opt_loadFlags);
  }
};
/** @define {boolean} */ goog.ENABLE_DEBUG_LOADER = goog.define("goog.ENABLE_DEBUG_LOADER", true);
/**
 * @private
 * @param {string} msg
 */
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
/**
 * @param {string} namespace
 * @return {?}
 */
goog.require = function(namespace) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER) {
      goog.debugLoader_.requested(namespace);
    }
    if (goog.isProvided_(namespace)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(namespace);
      }
    } else {
      if (goog.ENABLE_DEBUG_LOADER) {
        var moduleLoaderState = goog.moduleLoaderState_;
        goog.moduleLoaderState_ = null;
        try {
          goog.debugLoader_.load_(namespace);
        } finally {
          goog.moduleLoaderState_ = moduleLoaderState;
        }
      }
    }
    return null;
  }
};
/**
 * @param {string} namespace
 * @return {?}
 */
goog.requireType = function(namespace) {
  return {};
};
/** @type {string} */ goog.basePath = "";
/** @type {(string|undefined)} */ goog.global.CLOSURE_BASE_PATH;
/** @type {(boolean|undefined)} */ goog.global.CLOSURE_NO_DEPS;
/** @type {(function(string,string=):boolean|undefined)} */ goog.global.CLOSURE_IMPORT_SCRIPT;
/**
 * @return {void}
 */
goog.nullFunction = function() {
};
/**
 * @type {!Function}
 * @deprecated Use "@abstract" annotation instead of goog.abstractMethod in new code. See https://github.com/google/closure-compiler/wiki/@abstract-classes-and-methods
 */
goog.abstractMethod = function() {
  throw new Error("unimplemented abstract method");
};
/**
 * @param {!Function} ctor
 * @suppress {missingProperties}
 */
goog.addSingletonGetter = function(ctor) {
  /**
   * @type {(undefined|!Object)}
   * @suppress {underscore}
   */
  ctor.instance_ = undefined;
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return /** @type {(!Object|undefined)} */ (ctor.instance_) = new ctor;
  };
};
/** @private @type {!Array<!Function>} */ goog.instantiatedSingletons_ = [];
/** @define {boolean} */ goog.LOAD_MODULE_USING_EVAL = goog.define("goog.LOAD_MODULE_USING_EVAL", true);
/** @define {boolean} */ goog.SEAL_MODULE_EXPORTS = goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
/** @private @const @type {!Object<string,{exports:?,type:string,moduleId:string}>} */ goog.loadedModules_ = {};
/** @const @type {boolean} */ goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
/** @define {string} */ goog.TRANSPILE = goog.define("goog.TRANSPILE", "detect");
/** @define {boolean} */ goog.ASSUME_ES_MODULES_TRANSPILED = goog.define("goog.ASSUME_ES_MODULES_TRANSPILED", false);
/** @define {string} */ goog.TRANSPILE_TO_LANGUAGE = goog.define("goog.TRANSPILE_TO_LANGUAGE", "");
/** @define {string} */ goog.TRANSPILER = goog.define("goog.TRANSPILER", "transpile.js");
/** @package @type {?boolean} */ goog.hasBadLetScoping = null;
/**
 * @package
 * @return {boolean}
 */
goog.useSafari10Workaround = function() {
  if (goog.hasBadLetScoping == null) {
    var hasBadLetScoping;
    try {
      hasBadLetScoping = !eval('"use strict";' + "let x \x3d 1; function f() { return typeof x; };" + 'f() \x3d\x3d "number";');
    } catch (e) {
      hasBadLetScoping = false;
    }
    goog.hasBadLetScoping = hasBadLetScoping;
  }
  return goog.hasBadLetScoping;
};
/**
 * @package
 * @param {string} moduleDef
 * @return {string}
 */
goog.workaroundSafari10EvalBug = function(moduleDef) {
  return "(function(){" + moduleDef + "\n" + ";" + "})();\n";
};
/**
 * @param {(function(?):?|string)} moduleDef
 */
goog.loadModule = function(moduleDef) {
  var previousState = goog.moduleLoaderState_;
  try {
    goog.moduleLoaderState_ = {moduleName:"", declareLegacyNamespace:false, type:goog.ModuleType.GOOG};
    var exports;
    if (goog.isFunction(moduleDef)) {
      exports = moduleDef.call(undefined, {});
    } else {
      if (typeof moduleDef === "string") {
        if (goog.useSafari10Workaround()) {
          moduleDef = goog.workaroundSafari10EvalBug(moduleDef);
        }
        exports = goog.loadModuleFromSource_.call(undefined, moduleDef);
      } else {
        throw new Error("Invalid module definition");
      }
    }
    var moduleName = goog.moduleLoaderState_.moduleName;
    if (typeof moduleName === "string" && moduleName) {
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal && typeof exports == "object" && exports != null) {
          Object.seal(exports);
        }
      }
      var data = {exports:exports, type:goog.ModuleType.GOOG, moduleId:goog.moduleLoaderState_.moduleName};
      goog.loadedModules_[moduleName] = data;
    } else {
      throw new Error('Invalid module name "' + moduleName + '"');
    }
  } finally {
    goog.moduleLoaderState_ = previousState;
  }
};
/** @private @const */ goog.loadModuleFromSource_ = /** @type {function(string):?} */ (function() {
  var exports = {};
  eval(arguments[0]);
  return exports;
});
/**
 * @private
 * @param {string} path
 * @return {string}
 */
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
/** @type {(function(string):string|undefined)} */ goog.global.CLOSURE_LOAD_FILE_SYNC;
/**
 * @private
 * @param {string} src
 * @return {?string}
 */
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    try {
      /** @type {XMLHttpRequest} */ var xhr = new goog.global["XMLHttpRequest"];
      xhr.open("get", src, false);
      xhr.send();
      return xhr.status == 0 || xhr.status == 200 ? xhr.responseText : null;
    } catch (err) {
      return null;
    }
  }
};
/**
 * @private
 * @param {string} code
 * @param {string} path
 * @param {string} target
 * @return {string}
 */
goog.transpile_ = function(code, path, target) {
  var jscomp = goog.global["$jscomp"];
  if (!jscomp) {
    goog.global["$jscomp"] = jscomp = {};
  }
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER;
    var transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      (function() {
        (0, eval)(transpilerCode + "\n//# sourceURL\x3d" + transpilerPath);
      }).call(goog.global);
      if (goog.global["$gwtExport"] && goog.global["$gwtExport"]["$jscomp"] && !goog.global["$gwtExport"]["$jscomp"]["transpile"]) {
        throw new Error('The transpiler did not properly export the "transpile" ' + "method. $gwtExport: " + JSON.stringify(goog.global["$gwtExport"]));
      }
      goog.global["$jscomp"].transpile = goog.global["$gwtExport"]["$jscomp"]["transpile"];
      jscomp = goog.global["$jscomp"];
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    var suffix = " requires transpilation but no transpiler was found.";
    transpile = jscomp.transpile = function(code, path) {
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  return transpile(code, path, target);
};
/**
 * @param {?} value
 * @return {string}
 */
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call(/** @type {!Object} */ (value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
/**
 * @param {?} val
 * @return {boolean}
 * @deprecated Use `val === null` instead.
 */
goog.isNull = function(val) {
  return val === null;
};
/**
 * @param {?} val
 * @return {boolean}
 * @deprecated Use `val != null` instead.
 */
goog.isDefAndNotNull = function(val) {
  return val != null;
};
/**
 * @param {?} val
 * @return {boolean}
 */
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
/**
 * @param {?} val
 * @return {boolean}
 */
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
/**
 * @param {?} val
 * @return {boolean}
 */
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
/**
 * @param {?} val
 * @return {boolean}
 */
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
/**
 * @param {?} val
 * @return {boolean}
 */
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
/**
 * @param {Object} obj
 * @return {number}
 */
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
/**
 * @param {!Object} obj
 * @return {boolean}
 */
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
/**
 * @param {Object} obj
 */
goog.removeUid = function(obj) {
  if (obj !== null && "removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
/** @private @type {string} */ goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1e9 >>> 0);
/** @private @type {number} */ goog.uidCounter_ = 0;
/**
 * @param {Object} obj
 * @return {number}
 * @deprecated Use goog.getUid instead.
 */
goog.getHashCode = goog.getUid;
/**
 * @param {Object} obj
 * @deprecated Use goog.removeUid instead.
 */
goog.removeHashCode = goog.removeUid;
/**
 * @param {*} obj
 * @return {*}
 * @deprecated goog.cloneObject is unsafe. Prefer the goog.object methods.
 */
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (typeof obj.clone === "function") {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
/**
 * @private
 * @param {?function(this:T,...)} fn
 * @param {T} selfObj
 * @param {...*} var_args
 * @return {!Function}
 * @template T
 */
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (/** @type {!Function} */ (fn.call.apply(fn.bind, arguments)));
};
/**
 * @private
 * @param {?function(this:T,...)} fn
 * @param {T} selfObj
 * @param {...*} var_args
 * @return {!Function}
 * @template T
 */
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
/**
 * @param {?function(this:T,...)} fn
 * @param {T} selfObj
 * @param {...*} var_args
 * @return {!Function}
 * @template T
 * @suppress {deprecated}
 */
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
/**
 * @param {Function} fn
 * @param {...*} var_args
 * @return {!Function}
 */
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(/** @type {?} */ (this), newArgs);
  };
};
/**
 * @param {Object} target
 * @param {Object} source
 * @deprecated Prefer Object.assign
 */
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
/**
 * @return {number}
 * @deprecated Use Date.now
 */
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
/**
 * @param {string} script
 */
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        try {
          goog.global.eval("var _evalTest_ \x3d 1;");
        } catch (ignore) {
        }
        if (typeof goog.global["_evalTest_"] != "undefined") {
          try {
            delete goog.global["_evalTest_"];
          } catch (ignore$0) {
          }
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        /** @type {!Document} */ var doc = goog.global.document;
        var scriptElt = /** @type {!HTMLScriptElement} */ (doc.createElement("script"));
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.head.appendChild(scriptElt);
        doc.head.removeChild(scriptElt);
      }
    } else {
      throw new Error("goog.globalEval not available");
    }
  }
};
/** @private @type {?boolean} */ goog.evalWorksForGlobals_ = null;
/** @private @type {(!Object<string,string>|undefined)} */ goog.cssNameMapping_;
/** @private @type {(string|undefined)} */ goog.cssNameMappingStyle_;
/** @type {(function(string):string|undefined)} */ goog.global.CLOSURE_CSS_NAME_MAP_FN;
/**
 * @param {string} className
 * @param {string=} opt_modifier
 * @return {string}
 */
goog.getCssName = function(className, opt_modifier) {
  if (String(className).charAt(0) == ".") {
    throw new Error('className passed in goog.getCssName must not start with ".".' + " You passed: " + className);
  }
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0; i < parts.length; i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  var result = opt_modifier ? className + "-" + rename(opt_modifier) : rename(className);
  if (goog.global.CLOSURE_CSS_NAME_MAP_FN) {
    return goog.global.CLOSURE_CSS_NAME_MAP_FN(result);
  }
  return result;
};
/**
 * @param {!Object} mapping
 * @param {string=} opt_style
 */
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
/** @type {(!Object<string,string>|undefined)} */ goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
/**
 * @param {string} str
 * @param {Object<string,string>=} opt_values
 * @param {{html:boolean}=} opt_options
 * @return {string}
 */
goog.getMsg = function(str, opt_values, opt_options) {
  if (opt_options && opt_options.html) {
    str = str.replace(/</g, "\x26lt;");
  }
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return opt_values != null && key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
/**
 * @param {string} a
 * @param {string} b
 * @return {string}
 */
goog.getMsgWithFallback = function(a, b) {
  return a;
};
/**
 * @param {string} publicPath
 * @param {*} object
 * @param {Object=} opt_objectToExportTo
 */
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
/**
 * @param {Object} object
 * @param {string} publicName
 * @param {*} symbol
 */
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
/**
 * @param {!Function} childCtor
 * @param {!Function} parentCtor
 * @suppress {strictMissingProperties}
 */
goog.inherits = function(childCtor, parentCtor) {
  /** @constructor */ function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  /** @override */ childCtor.prototype.constructor = childCtor;
  /**
   * @param {!Object} me
   * @param {string} methodName
   * @param {...*} var_args
   * @return {*}
   */
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2; i < arguments.length; i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
/**
 * @param {!Object} me
 * @param {*=} opt_methodName
 * @param {...*} var_args
 * @return {*}
 * @suppress {es5Strict}
 * @deprecated goog.base is not strict mode compatible.  Prefer the static "base" method added to the constructor by goog.inherits or ES6 classes and the "super" keyword.
 */
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw new Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (typeof caller.superClass_ !== "undefined") {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return /** @type {!Function} */ (caller.superClass_).constructor.apply(me, ctorArgs);
  }
  if (typeof opt_methodName != "string" && typeof opt_methodName != "symbol") {
    throw new Error("method names provided to goog.base must be a string or a symbol");
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2; i < arguments.length; i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var proto = me.constructor.prototype; proto; proto = Object.getPrototypeOf(proto)) {
    if (proto[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return proto[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw new Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
/**
 * @param {function()} fn
 */
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw new Error("goog.scope is not supported within a module.");
  }
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
/**
 * @param {Function} superClass
 * @param {goog.defineClass.ClassDescriptor} def
 * @return {!Function}
 * @deprecated Use ES6 class syntax instead.
 */
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw new Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
/** @typedef {{constructor:(!Function|undefined),statics:(Object|undefined|function(Function):void)}} */ goog.defineClass.ClassDescriptor;
/** @define {boolean} */ goog.defineClass.SEAL_CLASS_INSTANCES = goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
/**
 * @private
 * @param {!Function} ctr
 * @param {Function} superClass
 * @return {!Function}
 */
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (!goog.defineClass.SEAL_CLASS_INSTANCES) {
    return ctr;
  }
  var superclassSealable = !goog.defineClass.isUnsealable_(superClass);
  /**
   * @this {Object}
   * @return {?}
   */
  var wrappedCtr = function() {
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
    if (this.constructor === wrappedCtr && superclassSealable && Object.seal instanceof Function) {
      Object.seal(instance);
    }
    return instance;
  };
  return wrappedCtr;
};
/**
 * @private
 * @param {Function} ctr
 * @return {boolean}
 */
goog.defineClass.isUnsealable_ = function(ctr) {
  return ctr && ctr.prototype && ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
};
/** @private @const @type {!Array<string>} */ goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
/**
 * @private
 * @param {!Object} target
 * @param {!Object} source
 */
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0; i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
/**
 * @param {!Function} ctr
 */
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
/** @private @const @type {string} */ goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
if (!COMPILED && goog.DEPENDENCIES_ENABLED) {
  /**
   * @private
   * @return {boolean}
   */
  goog.inHtmlDocument_ = function() {
    /** @type {!Document} */ var doc = goog.global.document;
    return doc != null && "write" in doc;
  };
  /**
   * @private
   * @return {boolean}
   */
  goog.isDocumentLoading_ = function() {
    /** @type {!HTMLDocument} */ var doc = goog.global.document;
    return doc.attachEvent ? doc.readyState != "complete" : doc.readyState == "loading";
  };
  /** @private */ goog.findBasePath_ = function() {
    if (goog.global.CLOSURE_BASE_PATH != undefined && typeof goog.global.CLOSURE_BASE_PATH === "string") {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    /** @type {!Document} */ var doc = goog.global.document;
    var currentScript = doc.currentScript;
    if (currentScript) {
      var scripts = [currentScript];
    } else {
      var scripts = doc.getElementsByTagName("SCRIPT");
    }
    for (var i = scripts.length - 1; i >= 0; --i) {
      var script = /** @type {!HTMLScriptElement} */ (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.findBasePath_();
  /** @final @struct @constructor */ goog.Transpiler = function() {
    /** @private @type {?Object<string,boolean>} */ this.requiresTranspilation_ = null;
    /** @private @type {string} */ this.transpilationTarget_ = goog.TRANSPILE_TO_LANGUAGE;
  };
  /**
   * @private
   * @return {{target:string,map:!Object<string,boolean>}}
   */
  goog.Transpiler.prototype.createRequiresTranspilation_ = function() {
    var transpilationTarget = "es3";
    var /** !Object<string,boolean> */ requiresTranspilation = {"es3":false};
    var transpilationRequiredForAllLaterModes = false;
    /**
     * @param {string} modeName
     * @param {function():boolean} isSupported
     */
    function addNewerLanguageTranspilationCheck(modeName, isSupported) {
      if (transpilationRequiredForAllLaterModes) {
        requiresTranspilation[modeName] = true;
      } else {
        if (isSupported()) {
          transpilationTarget = modeName;
          requiresTranspilation[modeName] = false;
        } else {
          requiresTranspilation[modeName] = true;
          transpilationRequiredForAllLaterModes = true;
        }
      }
    }
    function/** boolean */ evalCheck(/** string */ code) {
      try {
        return !!eval(code);
      } catch (ignored) {
        return false;
      }
    }
    var userAgent = goog.global.navigator && goog.global.navigator.userAgent ? goog.global.navigator.userAgent : "";
    addNewerLanguageTranspilationCheck("es5", function() {
      return evalCheck("[1,].length\x3d\x3d1");
    });
    addNewerLanguageTranspilationCheck("es6", function() {
      var re = /Edge\/(\d+)(\.\d)*/i;
      var edgeUserAgent = userAgent.match(re);
      if (edgeUserAgent) {
        return false;
      }
      var es6fullTest = "class X{constructor(){if(new.target!\x3dString)throw 1;this.x\x3d42}}" + "let q\x3dReflect.construct(X,[],String);if(q.x!\x3d42||!(q instanceof " + "String))throw 1;for(const a of[2,3]){if(a\x3d\x3d2)continue;function " + "f(z\x3d{a}){let a\x3d0;return z.a}{function f(){return 0;}}return f()" + "\x3d\x3d3}";
      return evalCheck('(()\x3d\x3e{"use strict";' + es6fullTest + "})()");
    });
    addNewerLanguageTranspilationCheck("es7", function() {
      return evalCheck("2 ** 2 \x3d\x3d 4");
    });
    addNewerLanguageTranspilationCheck("es8", function() {
      return evalCheck("async () \x3d\x3e 1, true");
    });
    addNewerLanguageTranspilationCheck("es9", function() {
      return evalCheck("({...rest} \x3d {}), true");
    });
    addNewerLanguageTranspilationCheck("es_next", function() {
      return false;
    });
    return {target:transpilationTarget, map:requiresTranspilation};
  };
  /**
   * @param {string} lang
   * @param {(string|undefined)} module
   * @return {boolean}
   */
  goog.Transpiler.prototype.needsTranspile = function(lang, module) {
    if (goog.TRANSPILE == "always") {
      return true;
    } else {
      if (goog.TRANSPILE == "never") {
        return false;
      } else {
        if (!this.requiresTranspilation_) {
          var obj = this.createRequiresTranspilation_();
          this.requiresTranspilation_ = obj.map;
          this.transpilationTarget_ = this.transpilationTarget_ || obj.target;
        }
      }
    }
    if (lang in this.requiresTranspilation_) {
      if (this.requiresTranspilation_[lang]) {
        return true;
      } else {
        if (goog.inHtmlDocument_() && module == "es6" && !("noModule" in goog.global.document.createElement("script"))) {
          return true;
        } else {
          return false;
        }
      }
    } else {
      throw new Error("Unknown language mode: " + lang);
    }
  };
  /**
   * @param {string} code
   * @param {string} path
   * @return {string}
   */
  goog.Transpiler.prototype.transpile = function(code, path) {
    return goog.transpile_(code, path, this.transpilationTarget_);
  };
  /** @private @final @type {!goog.Transpiler} */ goog.transpiler_ = new goog.Transpiler;
  /**
   * @private
   * @param {string} str
   * @return {string}
   */
  goog.protectScriptTag_ = function(str) {
    return str.replace(/<\/(SCRIPT)/ig, "\\x3c/$1");
  };
  /** @private @final @struct @constructor */ goog.DebugLoader_ = function() {
    /** @private @const @type {!Object<string,!goog.Dependency>} */ this.dependencies_ = {};
    /** @private @const @type {!Object<string,string>} */ this.idToPath_ = {};
    /** @private @const @type {!Object<string,boolean>} */ this.written_ = {};
    /** @private @const @type {!Array<!goog.Dependency>} */ this.loadingDeps_ = [];
    /** @private @type {!Array<!goog.Dependency>} */ this.depsToLoad_ = [];
    /** @private @type {boolean} */ this.paused_ = false;
    /** @private @type {!goog.DependencyFactory} */ this.factory_ = new goog.DependencyFactory(goog.transpiler_);
    /** @private @const @type {!Object<string,!Function>} */ this.deferredCallbacks_ = {};
    /** @private @const @type {!Array<string>} */ this.deferredQueue_ = [];
  };
  /**
   * @param {!Array<string>} namespaces
   * @param {function():undefined} callback
   */
  goog.DebugLoader_.prototype.bootstrap = function(namespaces, callback) {
    var cb = callback;
    function resolve() {
      if (cb) {
        goog.global.setTimeout(cb, 0);
        cb = null;
      }
    }
    if (!namespaces.length) {
      resolve();
      return;
    }
    var deps = [];
    for (var i = 0; i < namespaces.length; i++) {
      var path = this.getPathFromDeps_(namespaces[i]);
      if (!path) {
        throw new Error("Unregonized namespace: " + namespaces[i]);
      }
      deps.push(this.dependencies_[path]);
    }
    var require = goog.require;
    var loaded = 0;
    for (var i = 0; i < namespaces.length; i++) {
      require(namespaces[i]);
      deps[i].onLoad(function() {
        if (++loaded == namespaces.length) {
          resolve();
        }
      });
    }
  };
  goog.DebugLoader_.prototype.loadClosureDeps = function() {
    var relPath = "deps.js";
    this.depsToLoad_.push(this.factory_.createDependency(goog.normalizePath_(goog.basePath + relPath), relPath, [], [], {}, false));
    this.loadDeps_();
  };
  /**
   * @param {string} absPathOrId
   * @param {boolean=} opt_force
   */
  goog.DebugLoader_.prototype.requested = function(absPathOrId, opt_force) {
    var path = this.getPathFromDeps_(absPathOrId);
    if (path && (opt_force || this.areDepsLoaded_(this.dependencies_[path].requires))) {
      var callback = this.deferredCallbacks_[path];
      if (callback) {
        delete this.deferredCallbacks_[path];
        callback();
      }
    }
  };
  /**
   * @param {!goog.DependencyFactory} factory
   */
  goog.DebugLoader_.prototype.setDependencyFactory = function(factory) {
    this.factory_ = factory;
  };
  /**
   * @private
   * @param {string} namespace
   */
  goog.DebugLoader_.prototype.load_ = function(namespace) {
    if (!this.getPathFromDeps_(namespace)) {
      var errorMessage = "goog.require could not find: " + namespace;
      goog.logToConsole_(errorMessage);
      throw Error(errorMessage);
    } else {
      var loader = this;
      var deps = [];
      /**
       * @param {string} namespace
       */
      var visit = function(namespace) {
        var path = loader.getPathFromDeps_(namespace);
        if (!path) {
          throw new Error("Bad dependency path or symbol: " + namespace);
        }
        if (loader.written_[path]) {
          return;
        }
        loader.written_[path] = true;
        var dep = loader.dependencies_[path];
        for (var i = 0; i < dep.requires.length; i++) {
          if (!goog.isProvided_(dep.requires[i])) {
            visit(dep.requires[i]);
          }
        }
        deps.push(dep);
      };
      visit(namespace);
      var wasLoading = !!this.depsToLoad_.length;
      this.depsToLoad_ = this.depsToLoad_.concat(deps);
      if (!this.paused_ && !wasLoading) {
        this.loadDeps_();
      }
    }
  };
  /** @private */ goog.DebugLoader_.prototype.loadDeps_ = function() {
    var loader = this;
    var paused = this.paused_;
    while (this.depsToLoad_.length && !paused) {
      (function() {
        var loadCallDone = false;
        var dep = loader.depsToLoad_.shift();
        var loaded = false;
        loader.loading_(dep);
        var controller = {pause:function() {
          if (loadCallDone) {
            throw new Error("Cannot call pause after the call to load.");
          } else {
            paused = true;
          }
        }, resume:function() {
          if (loadCallDone) {
            loader.resume_();
          } else {
            paused = false;
          }
        }, loaded:function() {
          if (loaded) {
            throw new Error("Double call to loaded.");
          }
          loaded = true;
          loader.loaded_(dep);
        }, pending:function() {
          var pending = [];
          for (var i = 0; i < loader.loadingDeps_.length; i++) {
            pending.push(loader.loadingDeps_[i]);
          }
          return pending;
        }, /**
         * @param {goog.ModuleType} type
         */
        setModuleState:function(type) {
          goog.moduleLoaderState_ = {type:type, moduleName:"", declareLegacyNamespace:false};
        }, /** @type {function(string,string,string=)} */ registerEs6ModuleExports:function(path, exports, opt_closureNamespace) {
          if (opt_closureNamespace) {
            goog.loadedModules_[opt_closureNamespace] = {exports:exports, type:goog.ModuleType.ES6, moduleId:opt_closureNamespace || ""};
          }
        }, /** @type {function(string,?)} */ registerGoogModuleExports:function(moduleId, exports) {
          goog.loadedModules_[moduleId] = {exports:exports, type:goog.ModuleType.GOOG, moduleId:moduleId};
        }, clearModuleState:function() {
          goog.moduleLoaderState_ = null;
        }, defer:function(callback) {
          if (loadCallDone) {
            throw new Error("Cannot register with defer after the call to load.");
          }
          loader.defer_(dep, callback);
        }, areDepsLoaded:function() {
          return loader.areDepsLoaded_(dep.requires);
        }};
        try {
          dep.load(controller);
        } finally {
          loadCallDone = true;
        }
      })();
    }
    if (paused) {
      this.pause_();
    }
  };
  /** @private */ goog.DebugLoader_.prototype.pause_ = function() {
    this.paused_ = true;
  };
  /** @private */ goog.DebugLoader_.prototype.resume_ = function() {
    if (this.paused_) {
      this.paused_ = false;
      this.loadDeps_();
    }
  };
  /**
   * @private
   * @param {!goog.Dependency} dep
   */
  goog.DebugLoader_.prototype.loading_ = function(dep) {
    this.loadingDeps_.push(dep);
  };
  /**
   * @private
   * @param {!goog.Dependency} dep
   */
  goog.DebugLoader_.prototype.loaded_ = function(dep) {
    for (var i = 0; i < this.loadingDeps_.length; i++) {
      if (this.loadingDeps_[i] == dep) {
        this.loadingDeps_.splice(i, 1);
        break;
      }
    }
    for (var i = 0; i < this.deferredQueue_.length; i++) {
      if (this.deferredQueue_[i] == dep.path) {
        this.deferredQueue_.splice(i, 1);
        break;
      }
    }
    if (this.loadingDeps_.length == this.deferredQueue_.length && !this.depsToLoad_.length) {
      while (this.deferredQueue_.length) {
        this.requested(this.deferredQueue_.shift(), true);
      }
    }
    dep.loaded();
  };
  /**
   * @private
   * @param {!Array<string>} pathsOrIds
   * @return {boolean}
   */
  goog.DebugLoader_.prototype.areDepsLoaded_ = function(pathsOrIds) {
    for (var i = 0; i < pathsOrIds.length; i++) {
      var path = this.getPathFromDeps_(pathsOrIds[i]);
      if (!path || !(path in this.deferredCallbacks_) && !goog.isProvided_(pathsOrIds[i])) {
        return false;
      }
    }
    return true;
  };
  /**
   * @private
   * @param {string} absPathOrId
   * @return {?string}
   */
  goog.DebugLoader_.prototype.getPathFromDeps_ = function(absPathOrId) {
    if (absPathOrId in this.idToPath_) {
      return this.idToPath_[absPathOrId];
    } else {
      if (absPathOrId in this.dependencies_) {
        return absPathOrId;
      } else {
        return null;
      }
    }
  };
  /**
   * @private
   * @param {!goog.Dependency} dependency
   * @param {!Function} callback
   */
  goog.DebugLoader_.prototype.defer_ = function(dependency, callback) {
    this.deferredCallbacks_[dependency.path] = callback;
    this.deferredQueue_.push(dependency.path);
  };
  /** @record */ goog.LoadController = function() {
  };
  goog.LoadController.prototype.pause = function() {
  };
  goog.LoadController.prototype.resume = function() {
  };
  goog.LoadController.prototype.loaded = function() {
  };
  /**
   * @return {!Array<!goog.Dependency>}
   */
  goog.LoadController.prototype.pending = function() {
  };
  /**
   * @param {string} path
   * @param {?} exports
   * @param {string=} opt_closureNamespace
   */
  goog.LoadController.prototype.registerEs6ModuleExports = function(path, exports, opt_closureNamespace) {
  };
  /**
   * @param {goog.ModuleType} type
   */
  goog.LoadController.prototype.setModuleState = function(type) {
  };
  goog.LoadController.prototype.clearModuleState = function() {
  };
  /**
   * @param {!Function} callback
   */
  goog.LoadController.prototype.defer = function(callback) {
  };
  /**
   * @return {boolean}
   */
  goog.LoadController.prototype.areDepsLoaded = function() {
  };
  /**
   * @struct
   * @constructor
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   */
  goog.Dependency = function(path, relativePath, provides, requires, loadFlags) {
    /** @const */ this.path = path;
    /** @const */ this.relativePath = relativePath;
    /** @const */ this.provides = provides;
    /** @const */ this.requires = requires;
    /** @const */ this.loadFlags = loadFlags;
    /** @private @type {boolean} */ this.loaded_ = false;
    /** @private @type {!Array<function()>} */ this.loadCallbacks_ = [];
  };
  /**
   * @return {string}
   */
  goog.Dependency.prototype.getPathName = function() {
    var pathName = this.path;
    var protocolIndex = pathName.indexOf("://");
    if (protocolIndex >= 0) {
      pathName = pathName.substring(protocolIndex + 3);
      var slashIndex = pathName.indexOf("/");
      if (slashIndex >= 0) {
        pathName = pathName.substring(slashIndex + 1);
      }
    }
    return pathName;
  };
  /**
   * @final
   * @param {function()} callback
   */
  goog.Dependency.prototype.onLoad = function(callback) {
    if (this.loaded_) {
      callback();
    } else {
      this.loadCallbacks_.push(callback);
    }
  };
  /** @final */ goog.Dependency.prototype.loaded = function() {
    this.loaded_ = true;
    var callbacks = this.loadCallbacks_;
    this.loadCallbacks_ = [];
    for (var i = 0; i < callbacks.length; i++) {
      callbacks[i]();
    }
  };
  /** @private @type {boolean} */ goog.Dependency.defer_ = false;
  /** @private @const @type {!Object<string,function(?):undefined>} */ goog.Dependency.callbackMap_ = {};
  /**
   * @private
   * @param {function(...?):?} callback
   * @return {string}
   */
  goog.Dependency.registerCallback_ = function(callback) {
    var key = Math.random().toString(32);
    goog.Dependency.callbackMap_[key] = callback;
    return key;
  };
  /**
   * @private
   * @param {string} key
   */
  goog.Dependency.unregisterCallback_ = function(key) {
    delete goog.Dependency.callbackMap_[key];
  };
  /**
   * @private
   * @param {string} key
   * @param {...?} var_args
   * @suppress {unusedPrivateMembers}
   */
  goog.Dependency.callback_ = function(key, var_args) {
    if (key in goog.Dependency.callbackMap_) {
      var callback = goog.Dependency.callbackMap_[key];
      var args = [];
      for (var i = 1; i < arguments.length; i++) {
        args.push(arguments[i]);
      }
      callback.apply(undefined, args);
    } else {
      var errorMessage = "Callback key " + key + " does not exist (was base.js loaded more than once?).";
      throw Error(errorMessage);
    }
  };
  /**
   * @param {!goog.LoadController} controller
   */
  goog.Dependency.prototype.load = function(controller) {
    if (goog.global.CLOSURE_IMPORT_SCRIPT) {
      if (goog.global.CLOSURE_IMPORT_SCRIPT(this.path)) {
        controller.loaded();
      } else {
        controller.pause();
      }
      return;
    }
    if (!goog.inHtmlDocument_()) {
      goog.logToConsole_("Cannot use default debug loader outside of HTML documents.");
      if (this.relativePath == "deps.js") {
        goog.logToConsole_("Consider setting CLOSURE_IMPORT_SCRIPT before loading base.js, " + "or setting CLOSURE_NO_DEPS to true.");
        controller.loaded();
      } else {
        controller.pause();
      }
      return;
    }
    /** @type {!HTMLDocument} */ var doc = goog.global.document;
    if (doc.readyState == "complete" && !goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
      var isDeps = /\bdeps.js$/.test(this.path);
      if (isDeps) {
        controller.loaded();
        return;
      } else {
        throw Error('Cannot write "' + this.path + '" after document load');
      }
    }
    if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && goog.isDocumentLoading_()) {
      var key = goog.Dependency.registerCallback_(function(script) {
        if (!goog.DebugLoader_.IS_OLD_IE_ || script.readyState == "complete") {
          goog.Dependency.unregisterCallback_(key);
          controller.loaded();
        }
      });
      var nonceAttr = !goog.DebugLoader_.IS_OLD_IE_ && goog.getScriptNonce() ? ' nonce\x3d"' + goog.getScriptNonce() + '"' : "";
      var event = goog.DebugLoader_.IS_OLD_IE_ ? "onreadystatechange" : "onload";
      var defer = goog.Dependency.defer_ ? "defer" : "";
      var script = '\x3cscript src\x3d"' + this.path + '" ' + event + "\x3d\"goog.Dependency.callback_('" + key + '\', this)" type\x3d"text/javascript" ' + defer + nonceAttr + "\x3e\x3c" + "/script\x3e";
      doc.write(goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createHTML(script) : script);
    } else {
      var scriptEl = /** @type {!HTMLScriptElement} */ (doc.createElement("script"));
      scriptEl.defer = goog.Dependency.defer_;
      scriptEl.async = false;
      scriptEl.type = "text/javascript";
      var nonce = goog.getScriptNonce();
      if (nonce) {
        scriptEl.setAttribute("nonce", nonce);
      }
      if (goog.DebugLoader_.IS_OLD_IE_) {
        controller.pause();
        scriptEl.onreadystatechange = function() {
          if (scriptEl.readyState == "loaded" || scriptEl.readyState == "complete") {
            controller.loaded();
            controller.resume();
          }
        };
      } else {
        scriptEl.onload = function() {
          scriptEl.onload = null;
          controller.loaded();
        };
      }
      scriptEl.src = goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createScriptURL(this.path) : this.path;
      doc.head.appendChild(scriptEl);
    }
  };
  /**
   * @struct
   * @constructor
   * @extends {goog.Dependency}
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   */
  goog.Es6ModuleDependency = function(path, relativePath, provides, requires, loadFlags) {
    goog.Es6ModuleDependency.base(this, "constructor", path, relativePath, provides, requires, loadFlags);
  };
  goog.inherits(goog.Es6ModuleDependency, goog.Dependency);
  /** @override */ goog.Es6ModuleDependency.prototype.load = function(controller) {
    if (goog.global.CLOSURE_IMPORT_SCRIPT) {
      if (goog.global.CLOSURE_IMPORT_SCRIPT(this.path)) {
        controller.loaded();
      } else {
        controller.pause();
      }
      return;
    }
    if (!goog.inHtmlDocument_()) {
      goog.logToConsole_("Cannot use default debug loader outside of HTML documents.");
      controller.pause();
      return;
    }
    /** @type {!HTMLDocument} */ var doc = goog.global.document;
    var dep = this;
    function write(src, contents) {
      if (contents) {
        var script = '\x3cscript type\x3d"module" crossorigin\x3e' + contents + "\x3c/" + "script\x3e";
        doc.write(goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createHTML(script) : script);
      } else {
        var script = '\x3cscript type\x3d"module" crossorigin src\x3d"' + src + '"\x3e\x3c/' + "script\x3e";
        doc.write(goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createHTML(script) : script);
      }
    }
    function append(src, contents) {
      var scriptEl = /** @type {!HTMLScriptElement} */ (doc.createElement("script"));
      scriptEl.defer = true;
      scriptEl.async = false;
      scriptEl.type = "module";
      scriptEl.setAttribute("crossorigin", true);
      var nonce = goog.getScriptNonce();
      if (nonce) {
        scriptEl.setAttribute("nonce", nonce);
      }
      if (contents) {
        scriptEl.textContent = goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createScript(contents) : contents;
      } else {
        scriptEl.src = goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createScriptURL(src) : src;
      }
      doc.head.appendChild(scriptEl);
    }
    var create;
    if (goog.isDocumentLoading_()) {
      create = write;
      goog.Dependency.defer_ = true;
    } else {
      create = append;
    }
    var beforeKey = goog.Dependency.registerCallback_(function() {
      goog.Dependency.unregisterCallback_(beforeKey);
      controller.setModuleState(goog.ModuleType.ES6);
    });
    create(undefined, 'goog.Dependency.callback_("' + beforeKey + '")');
    create(this.path, undefined);
    var registerKey = goog.Dependency.registerCallback_(function(exports) {
      goog.Dependency.unregisterCallback_(registerKey);
      controller.registerEs6ModuleExports(dep.path, exports, goog.moduleLoaderState_.moduleName);
    });
    create(undefined, 'import * as m from "' + this.path + '"; goog.Dependency.callback_("' + registerKey + '", m)');
    var afterKey = goog.Dependency.registerCallback_(function() {
      goog.Dependency.unregisterCallback_(afterKey);
      controller.clearModuleState();
      controller.loaded();
    });
    create(undefined, 'goog.Dependency.callback_("' + afterKey + '")');
  };
  /**
   * @abstract
   * @struct
   * @constructor
   * @extends {goog.Dependency}
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   */
  goog.TransformedDependency = function(path, relativePath, provides, requires, loadFlags) {
    goog.TransformedDependency.base(this, "constructor", path, relativePath, provides, requires, loadFlags);
    /** @private @type {?string} */ this.contents_ = null;
    /** @private @const @type {boolean} */ this.lazyFetch_ = !goog.inHtmlDocument_() || !("noModule" in goog.global.document.createElement("script"));
  };
  goog.inherits(goog.TransformedDependency, goog.Dependency);
  /** @override */ goog.TransformedDependency.prototype.load = function(controller) {
    var dep = this;
    function fetch() {
      dep.contents_ = goog.loadFileSync_(dep.path);
      if (dep.contents_) {
        dep.contents_ = dep.transform(dep.contents_);
        if (dep.contents_) {
          dep.contents_ += "\n//# sourceURL\x3d" + dep.path;
        }
      }
    }
    if (goog.global.CLOSURE_IMPORT_SCRIPT) {
      fetch();
      if (this.contents_ && goog.global.CLOSURE_IMPORT_SCRIPT("", this.contents_)) {
        this.contents_ = null;
        controller.loaded();
      } else {
        controller.pause();
      }
      return;
    }
    var isEs6 = this.loadFlags["module"] == goog.ModuleType.ES6;
    if (!this.lazyFetch_) {
      fetch();
    }
    function load() {
      if (dep.lazyFetch_) {
        fetch();
      }
      if (!dep.contents_) {
        return;
      }
      if (isEs6) {
        controller.setModuleState(goog.ModuleType.ES6);
      }
      var namespace;
      try {
        var contents = dep.contents_;
        dep.contents_ = null;
        goog.globalEval(contents);
        if (isEs6) {
          namespace = goog.moduleLoaderState_.moduleName;
        }
      } finally {
        if (isEs6) {
          controller.clearModuleState();
        }
      }
      if (isEs6) {
        goog.global["$jscomp"]["require"]["ensure"]([dep.getPathName()], function() {
          controller.registerEs6ModuleExports(dep.path, goog.global["$jscomp"]["require"](dep.getPathName()), namespace);
        });
      }
      controller.loaded();
    }
    function fetchInOwnScriptThenLoad() {
      /** @type {!HTMLDocument} */ var doc = goog.global.document;
      var key = goog.Dependency.registerCallback_(function() {
        goog.Dependency.unregisterCallback_(key);
        load();
      });
      var script = '\x3cscript type\x3d"text/javascript"\x3e' + goog.protectScriptTag_('goog.Dependency.callback_("' + key + '");') + "\x3c/" + "script\x3e";
      doc.write(goog.TRUSTED_TYPES_POLICY_ ? goog.TRUSTED_TYPES_POLICY_.createHTML(script) : script);
    }
    var anythingElsePending = controller.pending().length > 1;
    var useOldIeWorkAround = anythingElsePending && goog.DebugLoader_.IS_OLD_IE_;
    var needsAsyncLoading = goog.Dependency.defer_ && (anythingElsePending || goog.isDocumentLoading_());
    if (useOldIeWorkAround || needsAsyncLoading) {
      controller.defer(function() {
        load();
      });
      return;
    }
    /** @type {?} */ var doc = goog.global.document;
    var isInternetExplorer = goog.inHtmlDocument_() && "ActiveXObject" in goog.global;
    if (isEs6 && goog.inHtmlDocument_() && goog.isDocumentLoading_() && !isInternetExplorer) {
      goog.Dependency.defer_ = true;
      controller.pause();
      var oldCallback = doc.onreadystatechange;
      doc.onreadystatechange = function() {
        if (doc.readyState == "interactive") {
          doc.onreadystatechange = oldCallback;
          load();
          controller.resume();
        }
        if (goog.isFunction(oldCallback)) {
          oldCallback.apply(undefined, arguments);
        }
      };
    } else {
      if (goog.DebugLoader_.IS_OLD_IE_ || !goog.inHtmlDocument_() || !goog.isDocumentLoading_()) {
        load();
      } else {
        fetchInOwnScriptThenLoad();
      }
    }
  };
  /**
   * @abstract
   * @param {string} contents
   * @return {string}
   */
  goog.TransformedDependency.prototype.transform = function(contents) {
  };
  /**
   * @struct
   * @constructor
   * @extends {goog.TransformedDependency}
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   * @param {!goog.Transpiler} transpiler
   */
  goog.TranspiledDependency = function(path, relativePath, provides, requires, loadFlags, transpiler) {
    goog.TranspiledDependency.base(this, "constructor", path, relativePath, provides, requires, loadFlags);
    /** @protected @const */ this.transpiler = transpiler;
  };
  goog.inherits(goog.TranspiledDependency, goog.TransformedDependency);
  /** @override */ goog.TranspiledDependency.prototype.transform = function(contents) {
    return this.transpiler.transpile(contents, this.getPathName());
  };
  /**
   * @struct
   * @constructor
   * @extends {goog.TransformedDependency}
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   */
  goog.PreTranspiledEs6ModuleDependency = function(path, relativePath, provides, requires, loadFlags) {
    goog.PreTranspiledEs6ModuleDependency.base(this, "constructor", path, relativePath, provides, requires, loadFlags);
  };
  goog.inherits(goog.PreTranspiledEs6ModuleDependency, goog.TransformedDependency);
  /** @override */ goog.PreTranspiledEs6ModuleDependency.prototype.transform = function(contents) {
    return contents;
  };
  /**
   * @struct
   * @constructor
   * @extends {goog.TransformedDependency}
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   * @param {boolean} needsTranspile
   * @param {!goog.Transpiler} transpiler
   */
  goog.GoogModuleDependency = function(path, relativePath, provides, requires, loadFlags, needsTranspile, transpiler) {
    goog.GoogModuleDependency.base(this, "constructor", path, relativePath, provides, requires, loadFlags);
    /** @private @const */ this.needsTranspile_ = needsTranspile;
    /** @private @const */ this.transpiler_ = transpiler;
  };
  goog.inherits(goog.GoogModuleDependency, goog.TransformedDependency);
  /** @override */ goog.GoogModuleDependency.prototype.transform = function(contents) {
    if (this.needsTranspile_) {
      contents = this.transpiler_.transpile(contents, this.getPathName());
    }
    if (!goog.LOAD_MODULE_USING_EVAL || goog.global.JSON === undefined) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + contents + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + this.path + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(contents + "\n//# sourceURL\x3d" + this.path + "\n") + ");";
    }
  };
  /** @private @const @type {boolean} */ goog.DebugLoader_.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document["all"]);
  /**
   * @param {string} relPath
   * @param {(!Array<string>|undefined)} provides
   * @param {!Array<string>} requires
   * @param {(boolean|!Object<?,string>)=} opt_loadFlags
   */
  goog.DebugLoader_.prototype.addDependency = function(relPath, provides, requires, opt_loadFlags) {
    provides = provides || [];
    relPath = relPath.replace(/\\/g, "/");
    var path = goog.normalizePath_(goog.basePath + relPath);
    if (!opt_loadFlags || typeof opt_loadFlags === "boolean") {
      opt_loadFlags = opt_loadFlags ? {"module":goog.ModuleType.GOOG} : {};
    }
    var dep = this.factory_.createDependency(path, relPath, provides, requires, opt_loadFlags, goog.transpiler_.needsTranspile(opt_loadFlags["lang"] || "es3", opt_loadFlags["module"]));
    this.dependencies_[path] = dep;
    for (var i = 0; i < provides.length; i++) {
      this.idToPath_[provides[i]] = path;
    }
    this.idToPath_[relPath] = path;
  };
  /**
   * @struct
   * @constructor
   * @param {!goog.Transpiler} transpiler
   */
  goog.DependencyFactory = function(transpiler) {
    /** @protected @const */ this.transpiler = transpiler;
  };
  /**
   * @param {string} path
   * @param {string} relativePath
   * @param {!Array<string>} provides
   * @param {!Array<string>} requires
   * @param {!Object<string,string>} loadFlags
   * @param {boolean} needsTranspile
   * @return {!goog.Dependency}
   */
  goog.DependencyFactory.prototype.createDependency = function(path, relativePath, provides, requires, loadFlags, needsTranspile) {
    if (loadFlags["module"] == goog.ModuleType.GOOG) {
      return new goog.GoogModuleDependency(path, relativePath, provides, requires, loadFlags, needsTranspile, this.transpiler);
    } else {
      if (needsTranspile) {
        return new goog.TranspiledDependency(path, relativePath, provides, requires, loadFlags, this.transpiler);
      } else {
        if (loadFlags["module"] == goog.ModuleType.ES6) {
          if (goog.TRANSPILE == "never" && goog.ASSUME_ES_MODULES_TRANSPILED) {
            return new goog.PreTranspiledEs6ModuleDependency(path, relativePath, provides, requires, loadFlags);
          } else {
            return new goog.Es6ModuleDependency(path, relativePath, provides, requires, loadFlags);
          }
        } else {
          return new goog.Dependency(path, relativePath, provides, requires, loadFlags);
        }
      }
    }
  };
  /** @private @const */ goog.debugLoader_ = new goog.DebugLoader_;
  goog.loadClosureDeps = function() {
    goog.debugLoader_.loadClosureDeps();
  };
  /**
   * @param {!goog.DependencyFactory} factory
   */
  goog.setDependencyFactory = function(factory) {
    goog.debugLoader_.setDependencyFactory(factory);
  };
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.debugLoader_.loadClosureDeps();
  }
  /**
   * @param {!Array<string>} namespaces
   * @param {function():?} callback
   */
  goog.bootstrap = function(namespaces, callback) {
    goog.debugLoader_.bootstrap(namespaces, callback);
  };
}
/** @define {string} */ goog.TRUSTED_TYPES_POLICY_NAME = goog.define("goog.TRUSTED_TYPES_POLICY_NAME", "");
/**
 * @private
 * @param {string} s
 * @return {string}
 */
goog.identity_ = function(s) {
  return s;
};
/**
 * @param {string} name
 * @return {?TrustedTypePolicy}
 */
goog.createTrustedTypesPolicy = function(name) {
  var policy = null;
  var policyFactory = goog.global.trustedTypes || goog.global.TrustedTypes;
  if (!policyFactory || !policyFactory.createPolicy) {
    return policy;
  }
  try {
    policy = policyFactory.createPolicy(name, {createHTML:goog.identity_, createScript:goog.identity_, createScriptURL:goog.identity_, createURL:goog.identity_});
  } catch (e) {
    goog.logToConsole_(e.message);
  }
  return policy;
};
/** @private @const @type {?TrustedTypePolicy} */ goog.TRUSTED_TYPES_POLICY_ = goog.TRUSTED_TYPES_POLICY_NAME ? goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME + "#base") : null;

var SHADOW_ENV = function() {
  var loadedFiles = {};

  var env = {};

  var doc = goog.global.document;

  if (!doc) {
    throw new Error("browser bootstrap used in incorrect target");
  }

  var scriptBase = goog.global.window.location.origin;
  if (CLOSURE_BASE_PATH[0] == '/') {
    scriptBase = scriptBase + CLOSURE_BASE_PATH;
  } else {
    // FIXME: need to handle relative paths
    scriptBase = CLOSURE_BASE_PATH;
  }

  var wentAsync = false;

  var canDocumentWrite = function() {
    return !wentAsync && doc.readyState == "loading";
  };

  var asyncLoad = (function() {
    var loadOrder = [];
    var loadState = {};

    function loadPending() {
      for (var i = 0, len = loadOrder.length; i < len; i++) {
        var uri = loadOrder[i];
        var state = loadState[uri];

        if (typeof state === "string") {
          loadState[uri] = true;
          if (state != "") {
            var code = state + "\n//# sourceURL=" + uri + "\n";
            goog.globalEval(code);
          }
        } else if (state === true) {
          continue;
        } else {
          break;
        }
      }
    }

    // ie11 doesn't have fetch, use xhr instead
    // FIXME: not sure if fetch provides any benefit over xhr
    if (typeof window.fetch === "undefined") {
      return function asyncXhr(uri) {
        loadOrder.push(uri);
        loadState[uri] = false;
        var req = new XMLHttpRequest();
        req.onload = function(e) {
          loadState[uri] = req.responseText;
          loadPending();
        };
        req.open("GET", uri);
        req.send();
      }
    } else {
      function responseText(response) {
        // FIXME: check status
        return response.text();
      }

      function evalFetch(uri) {
        return function(code) {
          loadState[uri] = code;
          loadPending();
        };
      }

      return function asyncFetch(uri) {
        if (loadState[uri] == undefined) {
          loadState[uri] = false;
          loadOrder.push(uri);
          fetch(uri)
            .then(responseText)
            .then(evalFetch(uri));
        }
      };
    }
  })();

  env.load = function(opts, paths) {
    var docWrite = opts.forceAsync ? false : canDocumentWrite();

    paths.forEach(function(path) {
      if (!loadedFiles[path]) {
        loadedFiles[path] = true;

        var uri = scriptBase + path;

        if (docWrite) {
          document.write(
            "<script src='" + uri + "' type='text/javascript'></script>"
          );
        } else {
          // once async always async
          wentAsync = true;
          asyncLoad(uri);
        }
      }
    });
  };

  env.isLoaded = function(path) {
    return loadedFiles[path] || false; // false is better than undefined
  };

  env.setLoaded = function(path) {
    loadedFiles[path] = true;
  };

  env.evalLoad = function(path, sourceMap, code) {
    loadedFiles[path] = true;
    code += ("\n//# sourceURL=" + scriptBase + path);
    if (sourceMap) {
      code += ("\n//# sourceMappingURL=" + path + ".map");
    }
    try {
      goog.globalEval(code);
    } catch (e) {
      console.warn("failed to load", path, e);
    }
  }

  return env;
}.call(this);


goog.global["$CLJS"] = goog.global;



SHADOW_ENV.evalLoad("goog.debug.error.js", true , "goog.provide(\x22goog.debug.Error\x22);\n/**\n * @constructor\n * @extends {Error}\n * @param {*\x3d} opt_msg\n */\ngoog.debug.Error \x3d function(opt_msg) {\n  if (Error.captureStackTrace) {\n    Error.captureStackTrace(this, goog.debug.Error);\n  } else {\n    /** @const */ var stack \x3d (new Error).stack;\n    if (stack) {\n      /** @override */ this.stack \x3d stack;\n    }\n  }\n  if (opt_msg) {\n    /** @override */ this.message \x3d String(opt_msg);\n  }\n  /** @type {boolean} */ this.reportErrorToServer \x3d true;\n};\ngoog.inherits(goog.debug.Error, Error);\n/** @override */ goog.debug.Error.prototype.name \x3d \x22CustomError\x22;\n");
SHADOW_ENV.evalLoad("goog.dom.nodetype.js", true , "goog.provide(\x22goog.dom.NodeType\x22);\n/** @enum {number} */ goog.dom.NodeType \x3d {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};\n");
SHADOW_ENV.evalLoad("goog.asserts.asserts.js", true , "goog.provide(\x22goog.asserts\x22);\ngoog.provide(\x22goog.asserts.AssertionError\x22);\ngoog.require(\x22goog.debug.Error\x22);\ngoog.require(\x22goog.dom.NodeType\x22);\n/** @define {boolean} */ goog.asserts.ENABLE_ASSERTS \x3d goog.define(\x22goog.asserts.ENABLE_ASSERTS\x22, goog.DEBUG);\n/**\n * @final\n * @constructor\n * @extends {goog.debug.Error}\n * @param {string} messagePattern\n * @param {!Array\x3c*\x3e} messageArgs\n */\ngoog.asserts.AssertionError \x3d function(messagePattern, messageArgs) {\n  goog.debug.Error.call(this, goog.asserts.subs_(messagePattern, messageArgs));\n  /** @type {string} */ this.messagePattern \x3d messagePattern;\n};\ngoog.inherits(goog.asserts.AssertionError, goog.debug.Error);\n/** @override */ goog.asserts.AssertionError.prototype.name \x3d \x22AssertionError\x22;\n/**\n * @param {!goog.asserts.AssertionError} e\n */\ngoog.asserts.DEFAULT_ERROR_HANDLER \x3d function(e) {\n  throw e;\n};\n/** @private @type {function(!goog.asserts.AssertionError)} */ goog.asserts.errorHandler_ \x3d goog.asserts.DEFAULT_ERROR_HANDLER;\n/**\n * @private\n * @param {string} pattern\n * @param {!Array\x3c*\x3e} subs\n * @return {string}\n */\ngoog.asserts.subs_ \x3d function(pattern, subs) {\n  var splitParts \x3d pattern.split(\x22%s\x22);\n  var returnString \x3d \x22\x22;\n  var subLast \x3d splitParts.length - 1;\n  for (var i \x3d 0; i \x3c subLast; i++) {\n    var sub \x3d i \x3c subs.length ? subs[i] : \x22%s\x22;\n    returnString +\x3d splitParts[i] + sub;\n  }\n  return returnString + splitParts[subLast];\n};\n/**\n * @private\n * @param {string} defaultMessage\n * @param {Array\x3c*\x3e} defaultArgs\n * @param {(string|undefined)} givenMessage\n * @param {Array\x3c*\x3e} givenArgs\n * @throws {goog.asserts.AssertionError}\n */\ngoog.asserts.doAssertFailure_ \x3d function(defaultMessage, defaultArgs, givenMessage, givenArgs) {\n  var message \x3d \x22Assertion failed\x22;\n  if (givenMessage) {\n    message +\x3d \x22: \x22 + givenMessage;\n    var args \x3d givenArgs;\n  } else {\n    if (defaultMessage) {\n      message +\x3d \x22: \x22 + defaultMessage;\n      args \x3d defaultArgs;\n    }\n  }\n  var e \x3d new goog.asserts.AssertionError(\x22\x22 + message, args || []);\n  goog.asserts.errorHandler_(e);\n};\n/**\n * @param {function(!goog.asserts.AssertionError)} errorHandler\n */\ngoog.asserts.setErrorHandler \x3d function(errorHandler) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    goog.asserts.errorHandler_ \x3d errorHandler;\n  }\n};\n/**\n * @param {T} condition\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {T}\n * @throws {goog.asserts.AssertionError}\n * @template T\n * @closurePrimitive {asserts.truthy}\n */\ngoog.asserts.assert \x3d function(condition, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !condition) {\n    goog.asserts.doAssertFailure_(\x22\x22, null, opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return condition;\n};\n/**\n * @param {T} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {R}\n * @throws {!goog.asserts.AssertionError}\n * @template T\n * @template R :\x3d mapunion(T,V\x3d\x3econd(eq(V,\x22null\x22),none(),cond(eq(V,\x22undefined\x22),none(),V))) \x3d:\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertExists \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 value \x3d\x3d null) {\n    goog.asserts.doAssertFailure_(\x22Expected to exist: %s.\x22, [value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return value;\n};\n/**\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.fail}\n */\ngoog.asserts.fail \x3d function(opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    goog.asserts.errorHandler_(new goog.asserts.AssertionError(\x22Failure\x22 + (opt_message ? \x22: \x22 + opt_message : \x22\x22), Array.prototype.slice.call(arguments, 1)));\n  }\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {number}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertNumber \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 typeof value !\x3d\x3d \x22number\x22) {\n    goog.asserts.doAssertFailure_(\x22Expected number but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {number} */ (value));\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {string}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertString \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 typeof value !\x3d\x3d \x22string\x22) {\n    goog.asserts.doAssertFailure_(\x22Expected string but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {string} */ (value));\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {!Function}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertFunction \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isFunction(value)) {\n    goog.asserts.doAssertFailure_(\x22Expected function but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {!Function} */ (value));\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {!Object}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertObject \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isObject(value)) {\n    goog.asserts.doAssertFailure_(\x22Expected object but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {!Object} */ (value));\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {!Array\x3c?\x3e}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertArray \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isArray(value)) {\n    goog.asserts.doAssertFailure_(\x22Expected array but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {!Array\x3c?\x3e} */ (value));\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {boolean}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertBoolean \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 typeof value !\x3d\x3d \x22boolean\x22) {\n    goog.asserts.doAssertFailure_(\x22Expected boolean but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {boolean} */ (value));\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {!Element}\n * @throws {goog.asserts.AssertionError}\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertElement \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 (!goog.isObject(value) || value.nodeType !\x3d goog.dom.NodeType.ELEMENT)) {\n    goog.asserts.doAssertFailure_(\x22Expected Element but got %s: %s.\x22, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {!Element} */ (value));\n};\n/**\n * @param {?} value\n * @param {function(new:T,...)} type\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {T}\n * @throws {goog.asserts.AssertionError}\n * @template T\n * @closurePrimitive {asserts.matchesReturn}\n */\ngoog.asserts.assertInstanceof \x3d function(value, type, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !(value instanceof type)) {\n    goog.asserts.doAssertFailure_(\x22Expected instanceof %s but got %s.\x22, [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));\n  }\n  return value;\n};\n/**\n * @param {*} value\n * @param {string\x3d} opt_message\n * @param {...*} var_args\n * @return {number}\n * @throws {goog.asserts.AssertionError}\n */\ngoog.asserts.assertFinite \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 (typeof value !\x3d \x22number\x22 || !isFinite(value))) {\n    goog.asserts.doAssertFailure_(\x22Expected %s to be a finite number but it is not.\x22, [value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return (/** @type {number} */ (value));\n};\ngoog.asserts.assertObjectPrototypeIsIntact \x3d function() {\n  for (var key in Object.prototype) {\n    goog.asserts.fail(key + \x22 should not be enumerable in Object.prototype.\x22);\n  }\n};\n/**\n * @private\n * @param {*} value\n * @return {string}\n */\ngoog.asserts.getType_ \x3d function(value) {\n  if (value instanceof Function) {\n    return value.displayName || value.name || \x22unknown type name\x22;\n  } else {\n    if (value instanceof Object) {\n      return /** @type {string} */ (value.constructor.displayName) || value.constructor.name || Object.prototype.toString.call(value);\n    } else {\n      return value \x3d\x3d\x3d null ? \x22null\x22 : typeof value;\n    }\n  }\n};\n");
SHADOW_ENV.evalLoad("goog.reflect.reflect.js", true , "goog.provide(\x22goog.reflect\x22);\n/**\n * @param {!Function} type\n * @param {Object} object\n * @return {Object}\n */\ngoog.reflect.object \x3d function(type, object) {\n  return object;\n};\n/**\n * @param {string} prop\n * @param {!Object} object\n * @return {string}\n */\ngoog.reflect.objectProperty \x3d function(prop, object) {\n  return prop;\n};\n/**\n * @param {T} x\n * @return {T}\n * @template T\n */\ngoog.reflect.sinkValue \x3d function(x) {\n  goog.reflect.sinkValue[\x22 \x22](x);\n  return x;\n};\ngoog.reflect.sinkValue[\x22 \x22] \x3d goog.nullFunction;\n/**\n * @param {Object} obj\n * @param {string} prop\n * @return {boolean}\n */\ngoog.reflect.canAccessProperty \x3d function(obj, prop) {\n  try {\n    goog.reflect.sinkValue(obj[prop]);\n    return true;\n  } catch (e) {\n  }\n  return false;\n};\n/**\n * @param {!Object\x3cK,V\x3e} cacheObj\n * @param {?} key\n * @param {function(?):V} valueFn\n * @param {function(?):K\x3d} opt_keyFn\n * @return {V}\n * @template K\n * @template V\n */\ngoog.reflect.cache \x3d function(cacheObj, key, valueFn, opt_keyFn) {\n  /** @const */ var storedKey \x3d opt_keyFn ? opt_keyFn(key) : key;\n  if (Object.prototype.hasOwnProperty.call(cacheObj, storedKey)) {\n    return cacheObj[storedKey];\n  }\n  return cacheObj[storedKey] \x3d valueFn(key);\n};\n");
SHADOW_ENV.evalLoad("goog.math.long.js", true , "goog.loadModule(function(exports) {\n  \x22use strict\x22;\n  goog.module(\x22goog.math.Long\x22);\n  goog.module.declareLegacyNamespace();\n  /** @const */ var asserts \x3d goog.require(\x22goog.asserts\x22);\n  /** @const */ var reflect \x3d goog.require(\x22goog.reflect\x22);\n  /** @final @constructor */ var Long \x3d function(low, high) {\n    /** @private @const @type {number} */ this.low_ \x3d low | 0;\n    /** @private @const @type {number} */ this.high_ \x3d high | 0;\n  };\n  /**\n   * @return {number}\n   */\n  Long.prototype.toInt \x3d function() {\n    return this.low_;\n  };\n  /**\n   * @return {number}\n   */\n  Long.prototype.toNumber \x3d function() {\n    return this.high_ * TWO_PWR_32_DBL_ + this.getLowBitsUnsigned();\n  };\n  /**\n   * @return {boolean}\n   */\n  Long.prototype.isSafeInteger \x3d function() {\n    var top11Bits \x3d this.high_ \x3e\x3e 21;\n    return top11Bits \x3d\x3d 0 || top11Bits \x3d\x3d -1 \x26\x26 !(this.low_ \x3d\x3d 0 \x26\x26 this.high_ \x3d\x3d (4292870144 | 0));\n  };\n  /**\n   * @param {number\x3d} opt_radix\n   * @return {string}\n   * @override\n   */\n  Long.prototype.toString \x3d function(opt_radix) {\n    var radix \x3d opt_radix || 10;\n    if (radix \x3c 2 || 36 \x3c radix) {\n      throw new Error(\x22radix out of range: \x22 + radix);\n    }\n    if (this.isSafeInteger()) {\n      var asNumber \x3d this.toNumber();\n      return radix \x3d\x3d 10 ? \x22\x22 + asNumber : asNumber.toString(radix);\n    }\n    var safeDigits \x3d 14 - (radix \x3e\x3e 2);\n    var radixPowSafeDigits \x3d Math.pow(radix, safeDigits);\n    var radixToPower \x3d Long.fromBits(radixPowSafeDigits, radixPowSafeDigits / TWO_PWR_32_DBL_);\n    var remDiv \x3d this.div(radixToPower);\n    var val \x3d Math.abs(this.subtract(remDiv.multiply(radixToPower)).toNumber());\n    var digits \x3d radix \x3d\x3d 10 ? \x22\x22 + val : val.toString(radix);\n    if (digits.length \x3c safeDigits) {\n      digits \x3d \x220000000000000\x22.substr(digits.length - safeDigits) + digits;\n    }\n    val \x3d remDiv.toNumber();\n    return (radix \x3d\x3d 10 ? val : val.toString(radix)) + digits;\n  };\n  /**\n   * @return {number}\n   */\n  Long.prototype.getHighBits \x3d function() {\n    return this.high_;\n  };\n  /**\n   * @return {number}\n   */\n  Long.prototype.getLowBits \x3d function() {\n    return this.low_;\n  };\n  /**\n   * @return {number}\n   */\n  Long.prototype.getLowBitsUnsigned \x3d function() {\n    return this.low_ \x3e\x3e\x3e 0;\n  };\n  /**\n   * @return {number}\n   */\n  Long.prototype.getNumBitsAbs \x3d function() {\n    if (this.isNegative()) {\n      if (this.equals(Long.getMinValue())) {\n        return 64;\n      } else {\n        return this.negate().getNumBitsAbs();\n      }\n    } else {\n      var val \x3d this.high_ !\x3d 0 ? this.high_ : this.low_;\n      for (var bit \x3d 31; bit \x3e 0; bit--) {\n        if ((val \x26 1 \x3c\x3c bit) !\x3d 0) {\n          break;\n        }\n      }\n      return this.high_ !\x3d 0 ? bit + 33 : bit + 1;\n    }\n  };\n  /**\n   * @return {boolean}\n   */\n  Long.prototype.isZero \x3d function() {\n    return this.low_ \x3d\x3d 0 \x26\x26 this.high_ \x3d\x3d 0;\n  };\n  /**\n   * @return {boolean}\n   */\n  Long.prototype.isNegative \x3d function() {\n    return this.high_ \x3c 0;\n  };\n  /**\n   * @return {boolean}\n   */\n  Long.prototype.isOdd \x3d function() {\n    return (this.low_ \x26 1) \x3d\x3d 1;\n  };\n  /**\n   * @param {?Long} other\n   * @return {boolean}\n   */\n  Long.prototype.equals \x3d function(other) {\n    return this.low_ \x3d\x3d other.low_ \x26\x26 this.high_ \x3d\x3d other.high_;\n  };\n  /**\n   * @param {?Long} other\n   * @return {boolean}\n   */\n  Long.prototype.notEquals \x3d function(other) {\n    return !this.equals(other);\n  };\n  /**\n   * @param {?Long} other\n   * @return {boolean}\n   */\n  Long.prototype.lessThan \x3d function(other) {\n    return this.compare(other) \x3c 0;\n  };\n  /**\n   * @param {?Long} other\n   * @return {boolean}\n   */\n  Long.prototype.lessThanOrEqual \x3d function(other) {\n    return this.compare(other) \x3c\x3d 0;\n  };\n  /**\n   * @param {?Long} other\n   * @return {boolean}\n   */\n  Long.prototype.greaterThan \x3d function(other) {\n    return this.compare(other) \x3e 0;\n  };\n  /**\n   * @param {?Long} other\n   * @return {boolean}\n   */\n  Long.prototype.greaterThanOrEqual \x3d function(other) {\n    return this.compare(other) \x3e\x3d 0;\n  };\n  /**\n   * @param {?Long} other\n   * @return {number}\n   */\n  Long.prototype.compare \x3d function(other) {\n    if (this.high_ \x3d\x3d other.high_) {\n      if (this.low_ \x3d\x3d other.low_) {\n        return 0;\n      }\n      return this.getLowBitsUnsigned() \x3e other.getLowBitsUnsigned() ? 1 : -1;\n    }\n    return this.high_ \x3e other.high_ ? 1 : -1;\n  };\n  /**\n   * @return {!Long}\n   */\n  Long.prototype.negate \x3d function() {\n    var negLow \x3d ~this.low_ + 1 | 0;\n    var overflowFromLow \x3d !negLow;\n    var negHigh \x3d ~this.high_ + overflowFromLow | 0;\n    return Long.fromBits(negLow, negHigh);\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.add \x3d function(other) {\n    var a48 \x3d this.high_ \x3e\x3e\x3e 16;\n    var a32 \x3d this.high_ \x26 65535;\n    var a16 \x3d this.low_ \x3e\x3e\x3e 16;\n    var a00 \x3d this.low_ \x26 65535;\n    var b48 \x3d other.high_ \x3e\x3e\x3e 16;\n    var b32 \x3d other.high_ \x26 65535;\n    var b16 \x3d other.low_ \x3e\x3e\x3e 16;\n    var b00 \x3d other.low_ \x26 65535;\n    var c48 \x3d 0, c32 \x3d 0, c16 \x3d 0, c00 \x3d 0;\n    c00 +\x3d a00 + b00;\n    c16 +\x3d c00 \x3e\x3e\x3e 16;\n    c00 \x26\x3d 65535;\n    c16 +\x3d a16 + b16;\n    c32 +\x3d c16 \x3e\x3e\x3e 16;\n    c16 \x26\x3d 65535;\n    c32 +\x3d a32 + b32;\n    c48 +\x3d c32 \x3e\x3e\x3e 16;\n    c32 \x26\x3d 65535;\n    c48 +\x3d a48 + b48;\n    c48 \x26\x3d 65535;\n    return Long.fromBits(c16 \x3c\x3c 16 | c00, c48 \x3c\x3c 16 | c32);\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.subtract \x3d function(other) {\n    return this.add(other.negate());\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.multiply \x3d function(other) {\n    if (this.isZero()) {\n      return this;\n    }\n    if (other.isZero()) {\n      return other;\n    }\n    var a48 \x3d this.high_ \x3e\x3e\x3e 16;\n    var a32 \x3d this.high_ \x26 65535;\n    var a16 \x3d this.low_ \x3e\x3e\x3e 16;\n    var a00 \x3d this.low_ \x26 65535;\n    var b48 \x3d other.high_ \x3e\x3e\x3e 16;\n    var b32 \x3d other.high_ \x26 65535;\n    var b16 \x3d other.low_ \x3e\x3e\x3e 16;\n    var b00 \x3d other.low_ \x26 65535;\n    var c48 \x3d 0, c32 \x3d 0, c16 \x3d 0, c00 \x3d 0;\n    c00 +\x3d a00 * b00;\n    c16 +\x3d c00 \x3e\x3e\x3e 16;\n    c00 \x26\x3d 65535;\n    c16 +\x3d a16 * b00;\n    c32 +\x3d c16 \x3e\x3e\x3e 16;\n    c16 \x26\x3d 65535;\n    c16 +\x3d a00 * b16;\n    c32 +\x3d c16 \x3e\x3e\x3e 16;\n    c16 \x26\x3d 65535;\n    c32 +\x3d a32 * b00;\n    c48 +\x3d c32 \x3e\x3e\x3e 16;\n    c32 \x26\x3d 65535;\n    c32 +\x3d a16 * b16;\n    c48 +\x3d c32 \x3e\x3e\x3e 16;\n    c32 \x26\x3d 65535;\n    c32 +\x3d a00 * b32;\n    c48 +\x3d c32 \x3e\x3e\x3e 16;\n    c32 \x26\x3d 65535;\n    c48 +\x3d a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;\n    c48 \x26\x3d 65535;\n    return Long.fromBits(c16 \x3c\x3c 16 | c00, c48 \x3c\x3c 16 | c32);\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.div \x3d function(other) {\n    if (other.isZero()) {\n      throw new Error(\x22division by zero\x22);\n    }\n    if (this.isNegative()) {\n      if (this.equals(Long.getMinValue())) {\n        if (other.equals(Long.getOne()) || other.equals(Long.getNegOne())) {\n          return Long.getMinValue();\n        }\n        if (other.equals(Long.getMinValue())) {\n          return Long.getOne();\n        }\n        var halfThis \x3d this.shiftRight(1);\n        var approx \x3d halfThis.div(other).shiftLeft(1);\n        if (approx.equals(Long.getZero())) {\n          return other.isNegative() ? Long.getOne() : Long.getNegOne();\n        }\n        var rem \x3d this.subtract(other.multiply(approx));\n        var result \x3d approx.add(rem.div(other));\n        return result;\n      }\n      if (other.isNegative()) {\n        return this.negate().div(other.negate());\n      }\n      return this.negate().div(other).negate();\n    }\n    if (this.isZero()) {\n      return Long.getZero();\n    }\n    if (other.isNegative()) {\n      if (other.equals(Long.getMinValue())) {\n        return Long.getZero();\n      }\n      return this.div(other.negate()).negate();\n    }\n    var res \x3d Long.getZero();\n    var rem \x3d this;\n    while (rem.greaterThanOrEqual(other)) {\n      var approx \x3d Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));\n      var log2 \x3d Math.ceil(Math.log(approx) / Math.LN2);\n      var delta \x3d log2 \x3c\x3d 48 ? 1 : Math.pow(2, log2 - 48);\n      var approxRes \x3d Long.fromNumber(approx);\n      var approxRem \x3d approxRes.multiply(other);\n      while (approxRem.isNegative() || approxRem.greaterThan(rem)) {\n        approx -\x3d delta;\n        approxRes \x3d Long.fromNumber(approx);\n        approxRem \x3d approxRes.multiply(other);\n      }\n      if (approxRes.isZero()) {\n        approxRes \x3d Long.getOne();\n      }\n      res \x3d res.add(approxRes);\n      rem \x3d rem.subtract(approxRem);\n    }\n    return res;\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.modulo \x3d function(other) {\n    return this.subtract(this.div(other).multiply(other));\n  };\n  /**\n   * @return {!Long}\n   */\n  Long.prototype.not \x3d function() {\n    return Long.fromBits(~this.low_, ~this.high_);\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.and \x3d function(other) {\n    return Long.fromBits(this.low_ \x26 other.low_, this.high_ \x26 other.high_);\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.or \x3d function(other) {\n    return Long.fromBits(this.low_ | other.low_, this.high_ | other.high_);\n  };\n  /**\n   * @param {?Long} other\n   * @return {!Long}\n   */\n  Long.prototype.xor \x3d function(other) {\n    return Long.fromBits(this.low_ ^ other.low_, this.high_ ^ other.high_);\n  };\n  /**\n   * @param {number} numBits\n   * @return {!Long}\n   */\n  Long.prototype.shiftLeft \x3d function(numBits) {\n    numBits \x26\x3d 63;\n    if (numBits \x3d\x3d 0) {\n      return this;\n    } else {\n      var low \x3d this.low_;\n      if (numBits \x3c 32) {\n        var high \x3d this.high_;\n        return Long.fromBits(low \x3c\x3c numBits, high \x3c\x3c numBits | low \x3e\x3e\x3e 32 - numBits);\n      } else {\n        return Long.fromBits(0, low \x3c\x3c numBits - 32);\n      }\n    }\n  };\n  /**\n   * @param {number} numBits\n   * @return {!Long}\n   */\n  Long.prototype.shiftRight \x3d function(numBits) {\n    numBits \x26\x3d 63;\n    if (numBits \x3d\x3d 0) {\n      return this;\n    } else {\n      var high \x3d this.high_;\n      if (numBits \x3c 32) {\n        var low \x3d this.low_;\n        return Long.fromBits(low \x3e\x3e\x3e numBits | high \x3c\x3c 32 - numBits, high \x3e\x3e numBits);\n      } else {\n        return Long.fromBits(high \x3e\x3e numBits - 32, high \x3e\x3d 0 ? 0 : -1);\n      }\n    }\n  };\n  /**\n   * @param {number} numBits\n   * @return {!Long}\n   */\n  Long.prototype.shiftRightUnsigned \x3d function(numBits) {\n    numBits \x26\x3d 63;\n    if (numBits \x3d\x3d 0) {\n      return this;\n    } else {\n      var high \x3d this.high_;\n      if (numBits \x3c 32) {\n        var low \x3d this.low_;\n        return Long.fromBits(low \x3e\x3e\x3e numBits | high \x3c\x3c 32 - numBits, high \x3e\x3e\x3e numBits);\n      } else {\n        if (numBits \x3d\x3d 32) {\n          return Long.fromBits(high, 0);\n        } else {\n          return Long.fromBits(high \x3e\x3e\x3e numBits - 32, 0);\n        }\n      }\n    }\n  };\n  /**\n   * @param {number} value\n   * @return {!Long}\n   */\n  Long.fromInt \x3d function(value) {\n    var intValue \x3d value | 0;\n    asserts.assert(value \x3d\x3d\x3d intValue, \x22value should be a 32-bit integer\x22);\n    if (-128 \x3c\x3d intValue \x26\x26 intValue \x3c 128) {\n      return getCachedIntValue_(intValue);\n    } else {\n      return new Long(intValue, intValue \x3c 0 ? -1 : 0);\n    }\n  };\n  /**\n   * @param {number} value\n   * @return {!Long}\n   */\n  Long.fromNumber \x3d function(value) {\n    if (value \x3e 0) {\n      if (value \x3e\x3d TWO_PWR_63_DBL_) {\n        return Long.getMaxValue();\n      }\n      return new Long(value, value / TWO_PWR_32_DBL_);\n    } else {\n      if (value \x3c 0) {\n        if (value \x3c\x3d -TWO_PWR_63_DBL_) {\n          return Long.getMinValue();\n        }\n        return (new Long(-value, -value / TWO_PWR_32_DBL_)).negate();\n      } else {\n        return Long.getZero();\n      }\n    }\n  };\n  /**\n   * @param {number} lowBits\n   * @param {number} highBits\n   * @return {!Long}\n   */\n  Long.fromBits \x3d function(lowBits, highBits) {\n    return new Long(lowBits, highBits);\n  };\n  /**\n   * @param {string} str\n   * @param {number\x3d} opt_radix\n   * @return {!Long}\n   */\n  Long.fromString \x3d function(str, opt_radix) {\n    if (str.charAt(0) \x3d\x3d \x22-\x22) {\n      return Long.fromString(str.substring(1), opt_radix).negate();\n    }\n    var numberValue \x3d parseInt(str, opt_radix || 10);\n    if (numberValue \x3c\x3d MAX_SAFE_INTEGER_) {\n      return new Long(numberValue % TWO_PWR_32_DBL_ | 0, numberValue / TWO_PWR_32_DBL_ | 0);\n    }\n    if (str.length \x3d\x3d 0) {\n      throw new Error(\x22number format error: empty string\x22);\n    }\n    if (str.indexOf(\x22-\x22) \x3e\x3d 0) {\n      throw new Error(\x27number format error: interior \x22-\x22 character: \x27 + str);\n    }\n    var radix \x3d opt_radix || 10;\n    if (radix \x3c 2 || 36 \x3c radix) {\n      throw new Error(\x22radix out of range: \x22 + radix);\n    }\n    var radixToPower \x3d Long.fromNumber(Math.pow(radix, 8));\n    var result \x3d Long.getZero();\n    for (var i \x3d 0; i \x3c str.length; i +\x3d 8) {\n      var size \x3d Math.min(8, str.length - i);\n      var value \x3d parseInt(str.substring(i, i + size), radix);\n      if (size \x3c 8) {\n        var power \x3d Long.fromNumber(Math.pow(radix, size));\n        result \x3d result.multiply(power).add(Long.fromNumber(value));\n      } else {\n        result \x3d result.multiply(radixToPower);\n        result \x3d result.add(Long.fromNumber(value));\n      }\n    }\n    return result;\n  };\n  /**\n   * @param {string} str\n   * @param {number\x3d} opt_radix\n   * @return {boolean}\n   */\n  Long.isStringInRange \x3d function(str, opt_radix) {\n    var radix \x3d opt_radix || 10;\n    if (radix \x3c 2 || 36 \x3c radix) {\n      throw new Error(\x22radix out of range: \x22 + radix);\n    }\n    var extremeValue \x3d str.charAt(0) \x3d\x3d \x22-\x22 ? MIN_VALUE_FOR_RADIX_[radix] : MAX_VALUE_FOR_RADIX_[radix];\n    if (str.length \x3c extremeValue.length) {\n      return true;\n    } else {\n      if (str.length \x3d\x3d extremeValue.length \x26\x26 str \x3c\x3d extremeValue) {\n        return true;\n      } else {\n        return false;\n      }\n    }\n  };\n  /**\n   * @public\n   * @return {!Long}\n   */\n  Long.getZero \x3d function() {\n    return ZERO_;\n  };\n  /**\n   * @public\n   * @return {!Long}\n   */\n  Long.getOne \x3d function() {\n    return ONE_;\n  };\n  /**\n   * @public\n   * @return {!Long}\n   */\n  Long.getNegOne \x3d function() {\n    return NEG_ONE_;\n  };\n  /**\n   * @public\n   * @return {!Long}\n   */\n  Long.getMaxValue \x3d function() {\n    return MAX_VALUE_;\n  };\n  /**\n   * @public\n   * @return {!Long}\n   */\n  Long.getMinValue \x3d function() {\n    return MIN_VALUE_;\n  };\n  /**\n   * @public\n   * @return {!Long}\n   */\n  Long.getTwoPwr24 \x3d function() {\n    return TWO_PWR_24_;\n  };\n  exports \x3d Long;\n  /** @private @const @type {!Object\x3cnumber,!Long\x3e} */ var IntCache_ \x3d {};\n  /**\n   * @private\n   * @param {number} value\n   * @return {!Long}\n   */\n  function getCachedIntValue_(value) {\n    return reflect.cache(IntCache_, value, function(val) {\n      return new Long(val, val \x3c 0 ? -1 : 0);\n    });\n  }\n  /** @private @const @type {!Array\x3cstring\x3e} */ var MAX_VALUE_FOR_RADIX_ \x3d [\x22\x22, \x22\x22, \x22111111111111111111111111111111111111111111111111111111111111111\x22, \x222021110011022210012102010021220101220221\x22, \x2213333333333333333333333333333333\x22, \x221104332401304422434310311212\x22, \x221540241003031030222122211\x22, \x2222341010611245052052300\x22, \x22777777777777777777777\x22, \x2267404283172107811827\x22, \x229223372036854775807\x22, \x221728002635214590697\x22, \x2241a792678515120367\x22, \x2210b269549075433c37\x22, \x224340724c6c71dc7a7\x22, \x22160e2ad3246366807\x22, \x227fffffffffffffff\x22, \n  \x2233d3d8307b214008\x22, \x2216agh595df825fa7\x22, \x22ba643dci0ffeehh\x22, \x225cbfjia3fh26ja7\x22, \x222heiciiie82dh97\x22, \x221adaibb21dckfa7\x22, \x22i6k448cf4192c2\x22, \x22acd772jnc9l0l7\x22, \x2264ie1focnn5g77\x22, \x223igoecjbmca687\x22, \x2227c48l5b37oaop\x22, \x221bk39f3ah3dmq7\x22, \x22q1se8f0m04isb\x22, \x22hajppbc1fc207\x22, \x22bm03i95hia437\x22, \x227vvvvvvvvvvvv\x22, \x225hg4ck9jd4u37\x22, \x223tdtk1v8j6tpp\x22, \x222pijmikexrxp7\x22, \x221y2p0ij32e8e7\x22];\n  /** @private @const @type {!Array\x3cstring\x3e} */ var MIN_VALUE_FOR_RADIX_ \x3d [\x22\x22, \x22\x22, \x22-1000000000000000000000000000000000000000000000000000000000000000\x22, \x22-2021110011022210012102010021220101220222\x22, \x22-20000000000000000000000000000000\x22, \x22-1104332401304422434310311213\x22, \x22-1540241003031030222122212\x22, \x22-22341010611245052052301\x22, \x22-1000000000000000000000\x22, \x22-67404283172107811828\x22, \x22-9223372036854775808\x22, \x22-1728002635214590698\x22, \x22-41a792678515120368\x22, \x22-10b269549075433c38\x22, \x22-4340724c6c71dc7a8\x22, \x22-160e2ad3246366808\x22, \n  \x22-8000000000000000\x22, \x22-33d3d8307b214009\x22, \x22-16agh595df825fa8\x22, \x22-ba643dci0ffeehi\x22, \x22-5cbfjia3fh26ja8\x22, \x22-2heiciiie82dh98\x22, \x22-1adaibb21dckfa8\x22, \x22-i6k448cf4192c3\x22, \x22-acd772jnc9l0l8\x22, \x22-64ie1focnn5g78\x22, \x22-3igoecjbmca688\x22, \x22-27c48l5b37oaoq\x22, \x22-1bk39f3ah3dmq8\x22, \x22-q1se8f0m04isc\x22, \x22-hajppbc1fc208\x22, \x22-bm03i95hia438\x22, \x22-8000000000000\x22, \x22-5hg4ck9jd4u38\x22, \x22-3tdtk1v8j6tpq\x22, \x22-2pijmikexrxp8\x22, \x22-1y2p0ij32e8e8\x22];\n  /** @private @const @type {number} */ var MAX_SAFE_INTEGER_ \x3d 9007199254740991;\n  /** @private @const @type {number} */ var TWO_PWR_32_DBL_ \x3d 4294967296;\n  /** @private @const @type {number} */ var TWO_PWR_63_DBL_ \x3d 0x7fffffffffffffff;\n  /** @private @const @type {!Long} */ var ZERO_ \x3d Long.fromBits(0, 0);\n  /** @private @const @type {!Long} */ var ONE_ \x3d Long.fromBits(1, 0);\n  /** @private @const @type {!Long} */ var NEG_ONE_ \x3d Long.fromBits(-1, -1);\n  /** @private @const @type {!Long} */ var MAX_VALUE_ \x3d Long.fromBits(4294967295, 2147483647);\n  /** @private @const @type {!Long} */ var MIN_VALUE_ \x3d Long.fromBits(0, 2147483648);\n  /** @private @const @type {!Long} */ var TWO_PWR_24_ \x3d Long.fromBits(1 \x3c\x3c 24, 0);\n  return exports;\n});\n");
SHADOW_ENV.evalLoad("goog.math.integer.js", true , "goog.provide(\x22goog.math.Integer\x22);\ngoog.require(\x22goog.reflect\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @param {Array\x3cnumber\x3e} bits\n * @param {number} sign\n */\ngoog.math.Integer \x3d function(bits, sign) {\n  /** @private @type {number} */ this.sign_ \x3d sign;\n  var localBits \x3d [];\n  var top \x3d true;\n  for (var i \x3d bits.length - 1; i \x3e\x3d 0; i--) {\n    var val \x3d bits[i] | 0;\n    if (!top || val !\x3d sign) {\n      localBits[i] \x3d val;\n      top \x3d false;\n    }\n  }\n  /** @private @const @type {!Array\x3cnumber\x3e} */ this.bits_ \x3d localBits;\n};\n/** @private @type {!Object\x3cnumber,!goog.math.Integer\x3e} */ goog.math.Integer.IntCache_ \x3d {};\n/**\n * @param {number} value\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.fromInt \x3d function(value) {\n  if (-128 \x3c\x3d value \x26\x26 value \x3c 128) {\n    return goog.reflect.cache(goog.math.Integer.IntCache_, value, function(val) {\n      return new goog.math.Integer([val | 0], val \x3c 0 ? -1 : 0);\n    });\n  }\n  return new goog.math.Integer([value | 0], value \x3c 0 ? -1 : 0);\n};\n/**\n * @param {number} value\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.fromNumber \x3d function(value) {\n  if (isNaN(value) || !isFinite(value)) {\n    return goog.math.Integer.ZERO;\n  } else {\n    if (value \x3c 0) {\n      return goog.math.Integer.fromNumber(-value).negate();\n    } else {\n      var bits \x3d [];\n      var pow \x3d 1;\n      for (var i \x3d 0; value \x3e\x3d pow; i++) {\n        bits[i] \x3d value / pow | 0;\n        pow *\x3d goog.math.Integer.TWO_PWR_32_DBL_;\n      }\n      return new goog.math.Integer(bits, 0);\n    }\n  }\n};\n/**\n * @param {Array\x3cnumber\x3e} bits\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.fromBits \x3d function(bits) {\n  var high \x3d bits[bits.length - 1];\n  return new goog.math.Integer(bits, high \x26 1 \x3c\x3c 31 ? -1 : 0);\n};\n/**\n * @param {string} str\n * @param {number\x3d} opt_radix\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.fromString \x3d function(str, opt_radix) {\n  if (str.length \x3d\x3d 0) {\n    throw new Error(\x22number format error: empty string\x22);\n  }\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw new Error(\x22radix out of range: \x22 + radix);\n  }\n  if (str.charAt(0) \x3d\x3d \x22-\x22) {\n    return goog.math.Integer.fromString(str.substring(1), radix).negate();\n  } else {\n    if (str.indexOf(\x22-\x22) \x3e\x3d 0) {\n      throw new Error(\x27number format error: interior \x22-\x22 character\x27);\n    }\n  }\n  var radixToPower \x3d goog.math.Integer.fromNumber(Math.pow(radix, 8));\n  var result \x3d goog.math.Integer.ZERO;\n  for (var i \x3d 0; i \x3c str.length; i +\x3d 8) {\n    var size \x3d Math.min(8, str.length - i);\n    var value \x3d parseInt(str.substring(i, i + size), radix);\n    if (size \x3c 8) {\n      var power \x3d goog.math.Integer.fromNumber(Math.pow(radix, size));\n      result \x3d result.multiply(power).add(goog.math.Integer.fromNumber(value));\n    } else {\n      result \x3d result.multiply(radixToPower);\n      result \x3d result.add(goog.math.Integer.fromNumber(value));\n    }\n  }\n  return result;\n};\n/** @private @type {number} */ goog.math.Integer.TWO_PWR_32_DBL_ \x3d (1 \x3c\x3c 16) * (1 \x3c\x3c 16);\n/** @type {!goog.math.Integer} */ goog.math.Integer.ZERO \x3d goog.math.Integer.fromInt(0);\n/** @type {!goog.math.Integer} */ goog.math.Integer.ONE \x3d goog.math.Integer.fromInt(1);\n/** @private @const @type {!goog.math.Integer} */ goog.math.Integer.TWO_PWR_24_ \x3d goog.math.Integer.fromInt(1 \x3c\x3c 24);\n/**\n * @return {number}\n */\ngoog.math.Integer.prototype.toInt \x3d function() {\n  return this.bits_.length \x3e 0 ? this.bits_[0] : this.sign_;\n};\n/**\n * @return {number}\n */\ngoog.math.Integer.prototype.toNumber \x3d function() {\n  if (this.isNegative()) {\n    return -this.negate().toNumber();\n  } else {\n    var val \x3d 0;\n    var pow \x3d 1;\n    for (var i \x3d 0; i \x3c this.bits_.length; i++) {\n      val +\x3d this.getBitsUnsigned(i) * pow;\n      pow *\x3d goog.math.Integer.TWO_PWR_32_DBL_;\n    }\n    return val;\n  }\n};\n/**\n * @param {number\x3d} opt_radix\n * @return {string}\n * @override\n */\ngoog.math.Integer.prototype.toString \x3d function(opt_radix) {\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw new Error(\x22radix out of range: \x22 + radix);\n  }\n  if (this.isZero()) {\n    return \x220\x22;\n  } else {\n    if (this.isNegative()) {\n      return \x22-\x22 + this.negate().toString(radix);\n    }\n  }\n  var radixToPower \x3d goog.math.Integer.fromNumber(Math.pow(radix, 6));\n  var rem \x3d this;\n  var result \x3d \x22\x22;\n  while (true) {\n    var remDiv \x3d rem.divide(radixToPower);\n    var intval \x3d rem.subtract(remDiv.multiply(radixToPower)).toInt() \x3e\x3e\x3e 0;\n    var digits \x3d intval.toString(radix);\n    rem \x3d remDiv;\n    if (rem.isZero()) {\n      return digits + result;\n    } else {\n      while (digits.length \x3c 6) {\n        digits \x3d \x220\x22 + digits;\n      }\n      result \x3d \x22\x22 + digits + result;\n    }\n  }\n};\n/**\n * @param {number} index\n * @return {number}\n */\ngoog.math.Integer.prototype.getBits \x3d function(index) {\n  if (index \x3c 0) {\n    return 0;\n  } else {\n    if (index \x3c this.bits_.length) {\n      return this.bits_[index];\n    } else {\n      return this.sign_;\n    }\n  }\n};\n/**\n * @param {number} index\n * @return {number}\n */\ngoog.math.Integer.prototype.getBitsUnsigned \x3d function(index) {\n  var val \x3d this.getBits(index);\n  return val \x3e\x3d 0 ? val : goog.math.Integer.TWO_PWR_32_DBL_ + val;\n};\n/**\n * @return {number}\n */\ngoog.math.Integer.prototype.getSign \x3d function() {\n  return this.sign_;\n};\n/**\n * @return {boolean}\n */\ngoog.math.Integer.prototype.isZero \x3d function() {\n  if (this.sign_ !\x3d 0) {\n    return false;\n  }\n  for (var i \x3d 0; i \x3c this.bits_.length; i++) {\n    if (this.bits_[i] !\x3d 0) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @return {boolean}\n */\ngoog.math.Integer.prototype.isNegative \x3d function() {\n  return this.sign_ \x3d\x3d -1;\n};\n/**\n * @return {boolean}\n */\ngoog.math.Integer.prototype.isOdd \x3d function() {\n  return this.bits_.length \x3d\x3d 0 \x26\x26 this.sign_ \x3d\x3d -1 || this.bits_.length \x3e 0 \x26\x26 (this.bits_[0] \x26 1) !\x3d 0;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {boolean}\n */\ngoog.math.Integer.prototype.equals \x3d function(other) {\n  if (this.sign_ !\x3d other.sign_) {\n    return false;\n  }\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  for (var i \x3d 0; i \x3c len; i++) {\n    if (this.getBits(i) !\x3d other.getBits(i)) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {boolean}\n */\ngoog.math.Integer.prototype.notEquals \x3d function(other) {\n  return !this.equals(other);\n};\n/**\n * @param {goog.math.Integer} other\n * @return {boolean}\n */\ngoog.math.Integer.prototype.greaterThan \x3d function(other) {\n  return this.compare(other) \x3e 0;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {boolean}\n */\ngoog.math.Integer.prototype.greaterThanOrEqual \x3d function(other) {\n  return this.compare(other) \x3e\x3d 0;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {boolean}\n */\ngoog.math.Integer.prototype.lessThan \x3d function(other) {\n  return this.compare(other) \x3c 0;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {boolean}\n */\ngoog.math.Integer.prototype.lessThanOrEqual \x3d function(other) {\n  return this.compare(other) \x3c\x3d 0;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {number}\n */\ngoog.math.Integer.prototype.compare \x3d function(other) {\n  var diff \x3d this.subtract(other);\n  if (diff.isNegative()) {\n    return -1;\n  } else {\n    if (diff.isZero()) {\n      return 0;\n    } else {\n      return +1;\n    }\n  }\n};\n/**\n * @param {number} numBits\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.shorten \x3d function(numBits) {\n  var arr_index \x3d numBits - 1 \x3e\x3e 5;\n  var bit_index \x3d (numBits - 1) % 32;\n  var bits \x3d [];\n  for (var i \x3d 0; i \x3c arr_index; i++) {\n    bits[i] \x3d this.getBits(i);\n  }\n  var sigBits \x3d bit_index \x3d\x3d 31 ? 4294967295 : (1 \x3c\x3c bit_index + 1) - 1;\n  var val \x3d this.getBits(arr_index) \x26 sigBits;\n  if (val \x26 1 \x3c\x3c bit_index) {\n    val |\x3d 4294967295 - sigBits;\n    bits[arr_index] \x3d val;\n    return new goog.math.Integer(bits, -1);\n  } else {\n    bits[arr_index] \x3d val;\n    return new goog.math.Integer(bits, 0);\n  }\n};\n/**\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.negate \x3d function() {\n  return this.not().add(goog.math.Integer.ONE);\n};\n/**\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.abs \x3d function() {\n  return this.isNegative() ? this.negate() : this;\n};\n/**\n * @param {goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.add \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  var carry \x3d 0;\n  for (var i \x3d 0; i \x3c\x3d len; i++) {\n    var a1 \x3d this.getBits(i) \x3e\x3e\x3e 16;\n    var a0 \x3d this.getBits(i) \x26 65535;\n    var b1 \x3d other.getBits(i) \x3e\x3e\x3e 16;\n    var b0 \x3d other.getBits(i) \x26 65535;\n    var c0 \x3d carry + a0 + b0;\n    var c1 \x3d (c0 \x3e\x3e\x3e 16) + a1 + b1;\n    carry \x3d c1 \x3e\x3e\x3e 16;\n    c0 \x26\x3d 65535;\n    c1 \x26\x3d 65535;\n    arr[i] \x3d c1 \x3c\x3c 16 | c0;\n  }\n  return goog.math.Integer.fromBits(arr);\n};\n/**\n * @param {goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.subtract \x3d function(other) {\n  return this.add(other.negate());\n};\n/**\n * @param {goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.multiply \x3d function(other) {\n  if (this.isZero()) {\n    return goog.math.Integer.ZERO;\n  } else {\n    if (other.isZero()) {\n      return goog.math.Integer.ZERO;\n    }\n  }\n  if (this.isNegative()) {\n    if (other.isNegative()) {\n      return this.negate().multiply(other.negate());\n    } else {\n      return this.negate().multiply(other).negate();\n    }\n  } else {\n    if (other.isNegative()) {\n      return this.multiply(other.negate()).negate();\n    }\n  }\n  if (this.lessThan(goog.math.Integer.TWO_PWR_24_) \x26\x26 other.lessThan(goog.math.Integer.TWO_PWR_24_)) {\n    return goog.math.Integer.fromNumber(this.toNumber() * other.toNumber());\n  }\n  var len \x3d this.bits_.length + other.bits_.length;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c 2 * len; i++) {\n    arr[i] \x3d 0;\n  }\n  for (var i \x3d 0; i \x3c this.bits_.length; i++) {\n    for (var j \x3d 0; j \x3c other.bits_.length; j++) {\n      var a1 \x3d this.getBits(i) \x3e\x3e\x3e 16;\n      var a0 \x3d this.getBits(i) \x26 65535;\n      var b1 \x3d other.getBits(j) \x3e\x3e\x3e 16;\n      var b0 \x3d other.getBits(j) \x26 65535;\n      arr[2 * i + 2 * j] +\x3d a0 * b0;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j);\n      arr[2 * i + 2 * j + 1] +\x3d a1 * b0;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);\n      arr[2 * i + 2 * j + 1] +\x3d a0 * b1;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);\n      arr[2 * i + 2 * j + 2] +\x3d a1 * b1;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 2);\n    }\n  }\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d arr[2 * i + 1] \x3c\x3c 16 | arr[2 * i];\n  }\n  for (var i \x3d len; i \x3c 2 * len; i++) {\n    arr[i] \x3d 0;\n  }\n  return new goog.math.Integer(arr, 0);\n};\n/**\n * @private\n * @param {Array\x3cnumber\x3e} bits\n * @param {number} index\n */\ngoog.math.Integer.carry16_ \x3d function(bits, index) {\n  while ((bits[index] \x26 65535) !\x3d bits[index]) {\n    bits[index + 1] +\x3d bits[index] \x3e\x3e\x3e 16;\n    bits[index] \x26\x3d 65535;\n    index++;\n  }\n};\n/**\n * @private\n * @param {!goog.math.Integer} other\n * @return {!goog.math.Integer.DivisionResult}\n */\ngoog.math.Integer.prototype.slowDivide_ \x3d function(other) {\n  if (this.isNegative() || other.isNegative()) {\n    throw new Error(\x22slowDivide_ only works with positive integers.\x22);\n  }\n  var twoPower \x3d goog.math.Integer.ONE;\n  var multiple \x3d other;\n  while (multiple.lessThanOrEqual(this)) {\n    twoPower \x3d twoPower.shiftLeft(1);\n    multiple \x3d multiple.shiftLeft(1);\n  }\n  var res \x3d twoPower.shiftRight(1);\n  var total \x3d multiple.shiftRight(1);\n  var total2;\n  multiple \x3d multiple.shiftRight(2);\n  twoPower \x3d twoPower.shiftRight(2);\n  while (!multiple.isZero()) {\n    total2 \x3d total.add(multiple);\n    if (total2.lessThanOrEqual(this)) {\n      res \x3d res.add(twoPower);\n      total \x3d total2;\n    }\n    multiple \x3d multiple.shiftRight(1);\n    twoPower \x3d twoPower.shiftRight(1);\n  }\n  var remainder \x3d this.subtract(res.multiply(other));\n  return new goog.math.Integer.DivisionResult(res, remainder);\n};\n/**\n * @param {!goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.divide \x3d function(other) {\n  return this.divideAndRemainder(other).quotient;\n};\n/**\n * @final\n * @struct\n * @constructor\n * @param {!goog.math.Integer} quotient\n * @param {!goog.math.Integer} remainder\n */\ngoog.math.Integer.DivisionResult \x3d function(quotient, remainder) {\n  /** @const */ this.quotient \x3d quotient;\n  /** @const */ this.remainder \x3d remainder;\n};\n/**\n * @param {!goog.math.Integer} other\n * @return {!goog.math.Integer.DivisionResult}\n */\ngoog.math.Integer.prototype.divideAndRemainder \x3d function(other) {\n  if (other.isZero()) {\n    throw new Error(\x22division by zero\x22);\n  } else {\n    if (this.isZero()) {\n      return new goog.math.Integer.DivisionResult(goog.math.Integer.ZERO, goog.math.Integer.ZERO);\n    }\n  }\n  if (this.isNegative()) {\n    var result \x3d this.negate().divideAndRemainder(other);\n    return new goog.math.Integer.DivisionResult(result.quotient.negate(), result.remainder.negate());\n  } else {\n    if (other.isNegative()) {\n      var result \x3d this.divideAndRemainder(other.negate());\n      return new goog.math.Integer.DivisionResult(result.quotient.negate(), result.remainder);\n    }\n  }\n  if (this.bits_.length \x3e 30) {\n    return this.slowDivide_(other);\n  }\n  var res \x3d goog.math.Integer.ZERO;\n  var rem \x3d this;\n  while (rem.greaterThanOrEqual(other)) {\n    var approx \x3d Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));\n    var log2 \x3d Math.ceil(Math.log(approx) / Math.LN2);\n    var delta \x3d log2 \x3c\x3d 48 ? 1 : Math.pow(2, log2 - 48);\n    var approxRes \x3d goog.math.Integer.fromNumber(approx);\n    var approxRem \x3d approxRes.multiply(other);\n    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {\n      approx -\x3d delta;\n      approxRes \x3d goog.math.Integer.fromNumber(approx);\n      approxRem \x3d approxRes.multiply(other);\n    }\n    if (approxRes.isZero()) {\n      approxRes \x3d goog.math.Integer.ONE;\n    }\n    res \x3d res.add(approxRes);\n    rem \x3d rem.subtract(approxRem);\n  }\n  return new goog.math.Integer.DivisionResult(res, rem);\n};\n/**\n * @param {!goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.modulo \x3d function(other) {\n  return this.divideAndRemainder(other).remainder;\n};\n/**\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.not \x3d function() {\n  var len \x3d this.bits_.length;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d ~this.bits_[i];\n  }\n  return new goog.math.Integer(arr, ~this.sign_);\n};\n/**\n * @param {goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.and \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d this.getBits(i) \x26 other.getBits(i);\n  }\n  return new goog.math.Integer(arr, this.sign_ \x26 other.sign_);\n};\n/**\n * @param {goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.or \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d this.getBits(i) | other.getBits(i);\n  }\n  return new goog.math.Integer(arr, this.sign_ | other.sign_);\n};\n/**\n * @param {goog.math.Integer} other\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.xor \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d this.getBits(i) ^ other.getBits(i);\n  }\n  return new goog.math.Integer(arr, this.sign_ ^ other.sign_);\n};\n/**\n * @param {number} numBits\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.shiftLeft \x3d function(numBits) {\n  var arr_delta \x3d numBits \x3e\x3e 5;\n  var bit_delta \x3d numBits % 32;\n  var len \x3d this.bits_.length + arr_delta + (bit_delta \x3e 0 ? 1 : 0);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    if (bit_delta \x3e 0) {\n      arr[i] \x3d this.getBits(i - arr_delta) \x3c\x3c bit_delta | this.getBits(i - arr_delta - 1) \x3e\x3e\x3e 32 - bit_delta;\n    } else {\n      arr[i] \x3d this.getBits(i - arr_delta);\n    }\n  }\n  return new goog.math.Integer(arr, this.sign_);\n};\n/**\n * @param {number} numBits\n * @return {!goog.math.Integer}\n */\ngoog.math.Integer.prototype.shiftRight \x3d function(numBits) {\n  var arr_delta \x3d numBits \x3e\x3e 5;\n  var bit_delta \x3d numBits % 32;\n  var len \x3d this.bits_.length - arr_delta;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    if (bit_delta \x3e 0) {\n      arr[i] \x3d this.getBits(i + arr_delta) \x3e\x3e\x3e bit_delta | this.getBits(i + arr_delta + 1) \x3c\x3c 32 - bit_delta;\n    } else {\n      arr[i] \x3d this.getBits(i + arr_delta);\n    }\n  }\n  return new goog.math.Integer(arr, this.sign_);\n};\n");
SHADOW_ENV.evalLoad("goog.dom.asserts.js", true , "goog.provide(\x22goog.dom.asserts\x22);\ngoog.require(\x22goog.asserts\x22);\n/**\n * @param {?Object} o\n * @return {!Location}\n */\ngoog.dom.asserts.assertIsLocation \x3d function(o) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    var win \x3d goog.dom.asserts.getWindow_(o);\n    if (win) {\n      if (!o || !(o instanceof win.Location) \x26\x26 o instanceof win.Element) {\n        goog.asserts.fail(\x22Argument is not a Location (or a non-Element mock); got: %s\x22, goog.dom.asserts.debugStringForType_(o));\n      }\n    }\n  }\n  return (/** @type {!Location} */ (o));\n};\n/**\n * @private\n * @param {?Object} o\n * @param {string} typename\n * @return {!Element}\n */\ngoog.dom.asserts.assertIsElementType_ \x3d function(o, typename) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    var win \x3d goog.dom.asserts.getWindow_(o);\n    if (win \x26\x26 typeof win[typename] !\x3d \x22undefined\x22) {\n      if (!o || !(o instanceof win[typename]) \x26\x26 (o instanceof win.Location || o instanceof win.Element)) {\n        goog.asserts.fail(\x22Argument is not a %s (or a non-Element, non-Location mock); \x22 + \x22got: %s\x22, typename, goog.dom.asserts.debugStringForType_(o));\n      }\n    }\n  }\n  return (/** @type {!Element} */ (o));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLAnchorElement}\n */\ngoog.dom.asserts.assertIsHTMLAnchorElement \x3d function(o) {\n  return (/** @type {!HTMLAnchorElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLAnchorElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLButtonElement}\n */\ngoog.dom.asserts.assertIsHTMLButtonElement \x3d function(o) {\n  return (/** @type {!HTMLButtonElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLButtonElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLLinkElement}\n */\ngoog.dom.asserts.assertIsHTMLLinkElement \x3d function(o) {\n  return (/** @type {!HTMLLinkElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLLinkElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLImageElement}\n */\ngoog.dom.asserts.assertIsHTMLImageElement \x3d function(o) {\n  return (/** @type {!HTMLImageElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLImageElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLAudioElement}\n */\ngoog.dom.asserts.assertIsHTMLAudioElement \x3d function(o) {\n  return (/** @type {!HTMLAudioElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLAudioElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLVideoElement}\n */\ngoog.dom.asserts.assertIsHTMLVideoElement \x3d function(o) {\n  return (/** @type {!HTMLVideoElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLVideoElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLInputElement}\n */\ngoog.dom.asserts.assertIsHTMLInputElement \x3d function(o) {\n  return (/** @type {!HTMLInputElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLInputElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLTextAreaElement}\n */\ngoog.dom.asserts.assertIsHTMLTextAreaElement \x3d function(o) {\n  return (/** @type {!HTMLTextAreaElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLTextAreaElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLCanvasElement}\n */\ngoog.dom.asserts.assertIsHTMLCanvasElement \x3d function(o) {\n  return (/** @type {!HTMLCanvasElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLCanvasElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLEmbedElement}\n */\ngoog.dom.asserts.assertIsHTMLEmbedElement \x3d function(o) {\n  return (/** @type {!HTMLEmbedElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLEmbedElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLFormElement}\n */\ngoog.dom.asserts.assertIsHTMLFormElement \x3d function(o) {\n  return (/** @type {!HTMLFormElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLFormElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLFrameElement}\n */\ngoog.dom.asserts.assertIsHTMLFrameElement \x3d function(o) {\n  return (/** @type {!HTMLFrameElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLFrameElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLIFrameElement}\n */\ngoog.dom.asserts.assertIsHTMLIFrameElement \x3d function(o) {\n  return (/** @type {!HTMLIFrameElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLIFrameElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLObjectElement}\n */\ngoog.dom.asserts.assertIsHTMLObjectElement \x3d function(o) {\n  return (/** @type {!HTMLObjectElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLObjectElement\x22)));\n};\n/**\n * @param {?Object} o\n * @return {!HTMLScriptElement}\n */\ngoog.dom.asserts.assertIsHTMLScriptElement \x3d function(o) {\n  return (/** @type {!HTMLScriptElement} */ (goog.dom.asserts.assertIsElementType_(o, \x22HTMLScriptElement\x22)));\n};\n/**\n * @private\n * @param {*} value\n * @return {string}\n */\ngoog.dom.asserts.debugStringForType_ \x3d function(value) {\n  if (goog.isObject(value)) {\n    try {\n      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);\n    } catch (e) {\n      return \x22\\x3cobject could not be stringified\\x3e\x22;\n    }\n  } else {\n    return value \x3d\x3d\x3d undefined ? \x22undefined\x22 : value \x3d\x3d\x3d null ? \x22null\x22 : typeof value;\n  }\n};\n/**\n * @private\n * @param {?Object} o\n * @return {?Window}\n * @suppress {strictMissingProperties}\n */\ngoog.dom.asserts.getWindow_ \x3d function(o) {\n  try {\n    var doc \x3d o \x26\x26 o.ownerDocument;\n    var win \x3d doc \x26\x26 (/** @type {?Window} */ (doc.defaultView || doc.parentWindow));\n    win \x3d win || /** @type {!Window} */ (goog.global);\n    if (win.Element \x26\x26 win.Location) {\n      return win;\n    }\n  } catch (ex) {\n  }\n  return null;\n};\n");
SHADOW_ENV.evalLoad("goog.functions.functions.js", true , "goog.provide(\x22goog.functions\x22);\n/**\n * @param {T} retValue\n * @return {function():T}\n * @template T\n */\ngoog.functions.constant \x3d function(retValue) {\n  return function() {\n    return retValue;\n  };\n};\n/** @type {function(...):boolean} */ goog.functions.FALSE \x3d function() {\n  return false;\n};\n/** @type {function(...):boolean} */ goog.functions.TRUE \x3d function() {\n  return true;\n};\n/** @type {function(...):null} */ goog.functions.NULL \x3d function() {\n  return null;\n};\n/**\n * @param {T\x3d} opt_returnValue\n * @param {...*} var_args\n * @return {T}\n * @template T\n */\ngoog.functions.identity \x3d function(opt_returnValue, var_args) {\n  return opt_returnValue;\n};\n/**\n * @param {string} message\n * @return {!Function}\n */\ngoog.functions.error \x3d function(message) {\n  return function() {\n    throw new Error(message);\n  };\n};\n/**\n * @param {*} err\n * @return {!Function}\n */\ngoog.functions.fail \x3d function(err) {\n  return function() {\n    throw err;\n  };\n};\n/**\n * @param {Function} f\n * @param {number\x3d} opt_numArgs\n * @return {!Function}\n */\ngoog.functions.lock \x3d function(f, opt_numArgs) {\n  opt_numArgs \x3d opt_numArgs || 0;\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    return f.apply(self, Array.prototype.slice.call(arguments, 0, opt_numArgs));\n  };\n};\n/**\n * @param {number} n\n * @return {!Function}\n */\ngoog.functions.nth \x3d function(n) {\n  return function() {\n    return arguments[n];\n  };\n};\n/**\n * @param {!Function} fn\n * @param {...*} var_args\n * @return {!Function}\n */\ngoog.functions.partialRight \x3d function(fn, var_args) {\n  /** @const */ var rightArgs \x3d Array.prototype.slice.call(arguments, 1);\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    /** @const */ var newArgs \x3d Array.prototype.slice.call(arguments);\n    newArgs.push.apply(newArgs, rightArgs);\n    return fn.apply(self, newArgs);\n  };\n};\n/**\n * @param {Function} f\n * @param {T} retValue\n * @return {function(...?):T}\n * @template T\n */\ngoog.functions.withReturnValue \x3d function(f, retValue) {\n  return goog.functions.sequence(f, goog.functions.constant(retValue));\n};\n/**\n * @param {*} value\n * @param {boolean\x3d} opt_useLooseComparison\n * @return {function(*):boolean}\n */\ngoog.functions.equalTo \x3d function(value, opt_useLooseComparison) {\n  return function(other) {\n    return opt_useLooseComparison ? value \x3d\x3d other : value \x3d\x3d\x3d other;\n  };\n};\n/**\n * @param {function(...?):T} fn\n * @param {...Function} var_args\n * @return {function(...?):T}\n * @template T\n */\ngoog.functions.compose \x3d function(fn, var_args) {\n  /** @const */ var functions \x3d arguments;\n  /** @const */ var length \x3d functions.length;\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    var result;\n    if (length) {\n      result \x3d functions[length - 1].apply(self, arguments);\n    }\n    for (var i \x3d length - 2; i \x3e\x3d 0; i--) {\n      result \x3d functions[i].call(self, result);\n    }\n    return result;\n  };\n};\n/**\n * @param {...Function} var_args\n * @return {!Function}\n */\ngoog.functions.sequence \x3d function(var_args) {\n  /** @const */ var functions \x3d arguments;\n  /** @const */ var length \x3d functions.length;\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    var result;\n    for (var i \x3d 0; i \x3c length; i++) {\n      result \x3d functions[i].apply(self, arguments);\n    }\n    return result;\n  };\n};\n/**\n * @param {...Function} var_args\n * @return {function(...?):boolean}\n */\ngoog.functions.and \x3d function(var_args) {\n  /** @const */ var functions \x3d arguments;\n  /** @const */ var length \x3d functions.length;\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    for (var i \x3d 0; i \x3c length; i++) {\n      if (!functions[i].apply(self, arguments)) {\n        return false;\n      }\n    }\n    return true;\n  };\n};\n/**\n * @param {...Function} var_args\n * @return {function(...?):boolean}\n */\ngoog.functions.or \x3d function(var_args) {\n  /** @const */ var functions \x3d arguments;\n  /** @const */ var length \x3d functions.length;\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    for (var i \x3d 0; i \x3c length; i++) {\n      if (functions[i].apply(self, arguments)) {\n        return true;\n      }\n    }\n    return false;\n  };\n};\n/**\n * @param {!Function} f\n * @return {function(...?):boolean}\n */\ngoog.functions.not \x3d function(f) {\n  return function() {\n    /** @const */ var self \x3d /** @type {*} */ (this);\n    return !f.apply(self, arguments);\n  };\n};\n/**\n * @param {function(new:T,...)} constructor\n * @param {...*} var_args\n * @return {T}\n * @template T\n */\ngoog.functions.create \x3d function(constructor, var_args) {\n  /** @const @final @constructor */ var temp \x3d function() {\n  };\n  temp.prototype \x3d constructor.prototype;\n  /** @const */ var obj \x3d new temp;\n  constructor.apply(obj, Array.prototype.slice.call(arguments, 1));\n  return obj;\n};\n/** @define {boolean} */ goog.functions.CACHE_RETURN_VALUE \x3d goog.define(\x22goog.functions.CACHE_RETURN_VALUE\x22, true);\n/**\n * @param {function():T} fn\n * @return {function():T}\n * @template T\n */\ngoog.functions.cacheReturnValue \x3d function(fn) {\n  var called \x3d false;\n  var value;\n  return function() {\n    if (!goog.functions.CACHE_RETURN_VALUE) {\n      return fn();\n    }\n    if (!called) {\n      value \x3d fn();\n      called \x3d true;\n    }\n    return value;\n  };\n};\n/**\n * @param {function():*} f\n * @return {function():undefined}\n */\ngoog.functions.once \x3d function(f) {\n  var inner \x3d f;\n  return function() {\n    if (inner) {\n      /** @const */ var tmp \x3d inner;\n      inner \x3d null;\n      tmp();\n    }\n  };\n};\n/**\n * @param {function(this:SCOPE,...?)} f\n * @param {number} interval\n * @param {SCOPE\x3d} opt_scope\n * @return {function(...?):undefined}\n * @template SCOPE\n */\ngoog.functions.debounce \x3d function(f, interval, opt_scope) {\n  var timeout \x3d 0;\n  return (/** @type {function(...?)} */ (function(var_args) {\n    goog.global.clearTimeout(timeout);\n    /** @const */ var args \x3d arguments;\n    timeout \x3d goog.global.setTimeout(function() {\n      f.apply(opt_scope, args);\n    }, interval);\n  }));\n};\n/**\n * @param {function(this:SCOPE,...?)} f\n * @param {number} interval\n * @param {SCOPE\x3d} opt_scope\n * @return {function(...?):undefined}\n * @template SCOPE\n */\ngoog.functions.throttle \x3d function(f, interval, opt_scope) {\n  var timeout \x3d 0;\n  var shouldFire \x3d false;\n  var args \x3d [];\n  /** @const */ var handleTimeout \x3d function() {\n    timeout \x3d 0;\n    if (shouldFire) {\n      shouldFire \x3d false;\n      fire();\n    }\n  };\n  /** @const */ var fire \x3d function() {\n    timeout \x3d goog.global.setTimeout(handleTimeout, interval);\n    f.apply(opt_scope, args);\n  };\n  return (/** @type {function(...?)} */ (function(var_args) {\n    args \x3d arguments;\n    if (!timeout) {\n      fire();\n    } else {\n      shouldFire \x3d true;\n    }\n  }));\n};\n/**\n * @param {function(this:SCOPE,...?)} f\n * @param {number} interval\n * @param {SCOPE\x3d} opt_scope\n * @return {function(...?):undefined}\n * @template SCOPE\n */\ngoog.functions.rateLimit \x3d function(f, interval, opt_scope) {\n  var timeout \x3d 0;\n  /** @const */ var handleTimeout \x3d function() {\n    timeout \x3d 0;\n  };\n  return (/** @type {function(...?)} */ (function(var_args) {\n    if (!timeout) {\n      timeout \x3d goog.global.setTimeout(handleTimeout, interval);\n      f.apply(opt_scope, arguments);\n    }\n  }));\n};\n");
SHADOW_ENV.evalLoad("goog.array.array.js", true , "goog.provide(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\n/** @define {boolean} */ goog.NATIVE_ARRAY_PROTOTYPES \x3d goog.define(\x22goog.NATIVE_ARRAY_PROTOTYPES\x22, goog.TRUSTED_SITE);\n/** @define {boolean} */ goog.array.ASSUME_NATIVE_FUNCTIONS \x3d goog.define(\x22goog.array.ASSUME_NATIVE_FUNCTIONS\x22, goog.FEATURESET_YEAR \x3e 2012);\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} array\n * @return {T}\n * @template T\n */\ngoog.array.peek \x3d function(array) {\n  return array[array.length - 1];\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} array\n * @return {T}\n * @template T\n */\ngoog.array.last \x3d goog.array.peek;\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {T} obj\n * @param {number\x3d} opt_fromIndex\n * @return {number}\n * @template T\n */\ngoog.array.indexOf \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(arr, obj, opt_fromIndex) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);\n} : function(arr, obj, opt_fromIndex) {\n  var fromIndex \x3d opt_fromIndex \x3d\x3d null ? 0 : opt_fromIndex \x3c 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;\n  if (typeof arr \x3d\x3d\x3d \x22string\x22) {\n    if (typeof obj !\x3d\x3d \x22string\x22 || obj.length !\x3d 1) {\n      return -1;\n    }\n    return arr.indexOf(obj, fromIndex);\n  }\n  for (var i \x3d fromIndex; i \x3c arr.length; i++) {\n    if (i in arr \x26\x26 arr[i] \x3d\x3d\x3d obj) {\n      return i;\n    }\n  }\n  return -1;\n};\n/**\n * @param {(!IArrayLike\x3cT\x3e|string)} arr\n * @param {T} obj\n * @param {?number\x3d} opt_fromIndex\n * @return {number}\n * @template T\n */\ngoog.array.lastIndexOf \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(arr, obj, opt_fromIndex) {\n  goog.asserts.assert(arr.length !\x3d null);\n  var fromIndex \x3d opt_fromIndex \x3d\x3d null ? arr.length - 1 : opt_fromIndex;\n  return Array.prototype.lastIndexOf.call(arr, obj, fromIndex);\n} : function(arr, obj, opt_fromIndex) {\n  var fromIndex \x3d opt_fromIndex \x3d\x3d null ? arr.length - 1 : opt_fromIndex;\n  if (fromIndex \x3c 0) {\n    fromIndex \x3d Math.max(0, arr.length + fromIndex);\n  }\n  if (typeof arr \x3d\x3d\x3d \x22string\x22) {\n    if (typeof obj !\x3d\x3d \x22string\x22 || obj.length !\x3d 1) {\n      return -1;\n    }\n    return arr.lastIndexOf(obj, fromIndex);\n  }\n  for (var i \x3d fromIndex; i \x3e\x3d 0; i--) {\n    if (i in arr \x26\x26 arr[i] \x3d\x3d\x3d obj) {\n      return i;\n    }\n  }\n  return -1;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):?} f\n * @param {S\x3d} opt_obj\n * @template T\n * @template S\n */\ngoog.array.forEach \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  Array.prototype.forEach.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2) {\n      f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr);\n    }\n  }\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):?} f\n * @param {S\x3d} opt_obj\n * @template T\n * @template S\n */\ngoog.array.forEachRight \x3d function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d l - 1; i \x3e\x3d 0; --i) {\n    if (i in arr2) {\n      f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr);\n    }\n  }\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {!Array\x3cT\x3e}\n * @template T\n * @template S\n */\ngoog.array.filter \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.filter.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var res \x3d [];\n  var resLength \x3d 0;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2) {\n      var val \x3d arr2[i];\n      if (f.call(/** @type {?} */ (opt_obj), val, i, arr)) {\n        res[resLength++] \x3d val;\n      }\n    }\n  }\n  return res;\n};\n/**\n * @param {(IArrayLike\x3cVALUE\x3e|string)} arr\n * @param {function(this:THIS,VALUE,number,?):RESULT} f\n * @param {THIS\x3d} opt_obj\n * @return {!Array\x3cRESULT\x3e}\n * @template THIS\n * @template VALUE\n * @template RESULT\n */\ngoog.array.map \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.map.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var res \x3d new Array(l);\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2) {\n      res[i] \x3d f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr);\n    }\n  }\n  return res;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {function(this:S,R,T,number,?):R} f\n * @param {?} val\n * @param {S\x3d} opt_obj\n * @return {R}\n * @template T\n * @template S\n * @template R\n */\ngoog.array.reduce \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(arr, f, val, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  if (opt_obj) {\n    f \x3d goog.bind(f, opt_obj);\n  }\n  return Array.prototype.reduce.call(arr, f, val);\n} : function(arr, f, val, opt_obj) {\n  var rval \x3d val;\n  goog.array.forEach(arr, function(val, index) {\n    rval \x3d f.call(/** @type {?} */ (opt_obj), rval, val, index, arr);\n  });\n  return rval;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,R,T,number,?):R} f\n * @param {?} val\n * @param {S\x3d} opt_obj\n * @return {R}\n * @template T\n * @template S\n * @template R\n */\ngoog.array.reduceRight \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(arr, f, val, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  goog.asserts.assert(f !\x3d null);\n  if (opt_obj) {\n    f \x3d goog.bind(f, opt_obj);\n  }\n  return Array.prototype.reduceRight.call(arr, f, val);\n} : function(arr, f, val, opt_obj) {\n  var rval \x3d val;\n  goog.array.forEachRight(arr, function(val, index) {\n    rval \x3d f.call(/** @type {?} */ (opt_obj), rval, val, index, arr);\n  });\n  return rval;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template S\n */\ngoog.array.some \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.some.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2 \x26\x26 f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n      return true;\n    }\n  }\n  return false;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template S\n */\ngoog.array.every \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26 (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.every.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2 \x26\x26 !f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {(!IArrayLike\x3cT\x3e|string)} arr\n * @param {function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {number}\n * @template T\n * @template S\n */\ngoog.array.count \x3d function(arr, f, opt_obj) {\n  var count \x3d 0;\n  goog.array.forEach(arr, function(element, index, arr) {\n    if (f.call(/** @type {?} */ (opt_obj), element, index, arr)) {\n      ++count;\n    }\n  }, opt_obj);\n  return count;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {(T|null)}\n * @template T\n * @template S\n */\ngoog.array.find \x3d function(arr, f, opt_obj) {\n  var i \x3d goog.array.findIndex(arr, f, opt_obj);\n  return i \x3c 0 ? null : typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.charAt(i) : arr[i];\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {number}\n * @template T\n * @template S\n */\ngoog.array.findIndex \x3d function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2 \x26\x26 f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n      return i;\n    }\n  }\n  return -1;\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {(T|null)}\n * @template T\n * @template S\n */\ngoog.array.findRight \x3d function(arr, f, opt_obj) {\n  var i \x3d goog.array.findIndexRight(arr, f, opt_obj);\n  return i \x3c 0 ? null : typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.charAt(i) : arr[i];\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {number}\n * @template T\n * @template S\n */\ngoog.array.findIndexRight \x3d function(arr, f, opt_obj) {\n  var l \x3d arr.length;\n  var arr2 \x3d typeof arr \x3d\x3d\x3d \x22string\x22 ? arr.split(\x22\x22) : arr;\n  for (var i \x3d l - 1; i \x3e\x3d 0; i--) {\n    if (i in arr2 \x26\x26 f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n      return i;\n    }\n  }\n  return -1;\n};\n/**\n * @param {(IArrayLike\x3c?\x3e|string)} arr\n * @param {*} obj\n * @return {boolean}\n */\ngoog.array.contains \x3d function(arr, obj) {\n  return goog.array.indexOf(arr, obj) \x3e\x3d 0;\n};\n/**\n * @param {(IArrayLike\x3c?\x3e|string)} arr\n * @return {boolean}\n */\ngoog.array.isEmpty \x3d function(arr) {\n  return arr.length \x3d\x3d 0;\n};\n/**\n * @param {IArrayLike\x3c?\x3e} arr\n */\ngoog.array.clear \x3d function(arr) {\n  if (!goog.isArray(arr)) {\n    for (var i \x3d arr.length - 1; i \x3e\x3d 0; i--) {\n      delete arr[i];\n    }\n  }\n  arr.length \x3d 0;\n};\n/**\n * @param {Array\x3cT\x3e} arr\n * @param {T} obj\n * @template T\n */\ngoog.array.insert \x3d function(arr, obj) {\n  if (!goog.array.contains(arr, obj)) {\n    arr.push(obj);\n  }\n};\n/**\n * @param {IArrayLike\x3c?\x3e} arr\n * @param {*} obj\n * @param {number\x3d} opt_i\n */\ngoog.array.insertAt \x3d function(arr, obj, opt_i) {\n  goog.array.splice(arr, opt_i, 0, obj);\n};\n/**\n * @param {IArrayLike\x3c?\x3e} arr\n * @param {IArrayLike\x3c?\x3e} elementsToAdd\n * @param {number\x3d} opt_i\n */\ngoog.array.insertArrayAt \x3d function(arr, elementsToAdd, opt_i) {\n  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);\n};\n/**\n * @param {Array\x3cT\x3e} arr\n * @param {T} obj\n * @param {T\x3d} opt_obj2\n * @template T\n */\ngoog.array.insertBefore \x3d function(arr, obj, opt_obj2) {\n  var i;\n  if (arguments.length \x3d\x3d 2 || (i \x3d goog.array.indexOf(arr, opt_obj2)) \x3c 0) {\n    arr.push(obj);\n  } else {\n    goog.array.insertAt(arr, obj, i);\n  }\n};\n/**\n * @param {IArrayLike\x3cT\x3e} arr\n * @param {T} obj\n * @return {boolean}\n * @template T\n */\ngoog.array.remove \x3d function(arr, obj) {\n  var i \x3d goog.array.indexOf(arr, obj);\n  var rv;\n  if (rv \x3d i \x3e\x3d 0) {\n    goog.array.removeAt(arr, i);\n  }\n  return rv;\n};\n/**\n * @param {!IArrayLike\x3cT\x3e} arr\n * @param {T} obj\n * @return {boolean}\n * @template T\n */\ngoog.array.removeLast \x3d function(arr, obj) {\n  var i \x3d goog.array.lastIndexOf(arr, obj);\n  if (i \x3e\x3d 0) {\n    goog.array.removeAt(arr, i);\n    return true;\n  }\n  return false;\n};\n/**\n * @param {IArrayLike\x3c?\x3e} arr\n * @param {number} i\n * @return {boolean}\n */\ngoog.array.removeAt \x3d function(arr, i) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.splice.call(arr, i, 1).length \x3d\x3d 1;\n};\n/**\n * @param {IArrayLike\x3cT\x3e} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template S\n */\ngoog.array.removeIf \x3d function(arr, f, opt_obj) {\n  var i \x3d goog.array.findIndex(arr, f, opt_obj);\n  if (i \x3e\x3d 0) {\n    goog.array.removeAt(arr, i);\n    return true;\n  }\n  return false;\n};\n/**\n * @param {IArrayLike\x3cT\x3e} arr\n * @param {?function(this:S,T,number,?):boolean} f\n * @param {S\x3d} opt_obj\n * @return {number}\n * @template T\n * @template S\n */\ngoog.array.removeAllIf \x3d function(arr, f, opt_obj) {\n  var removedCount \x3d 0;\n  goog.array.forEachRight(arr, function(val, index) {\n    if (f.call(/** @type {?} */ (opt_obj), val, index, arr)) {\n      if (goog.array.removeAt(arr, index)) {\n        removedCount++;\n      }\n    }\n  });\n  return removedCount;\n};\n/**\n * @param {...*} var_args\n * @return {!Array\x3c?\x3e}\n */\ngoog.array.concat \x3d function(var_args) {\n  return Array.prototype.concat.apply([], arguments);\n};\n/**\n * @param {...!Array\x3cT\x3e} var_args\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.join \x3d function(var_args) {\n  return Array.prototype.concat.apply([], arguments);\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} object\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.toArray \x3d function(object) {\n  var length \x3d object.length;\n  if (length \x3e 0) {\n    var rv \x3d new Array(length);\n    for (var i \x3d 0; i \x3c length; i++) {\n      rv[i] \x3d object[i];\n    }\n    return rv;\n  }\n  return [];\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.clone \x3d goog.array.toArray;\n/**\n * @param {Array\x3cVALUE\x3e} arr1\n * @param {...(IArrayLike\x3cVALUE\x3e|VALUE)} var_args\n * @template VALUE\n */\ngoog.array.extend \x3d function(arr1, var_args) {\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    var arr2 \x3d arguments[i];\n    if (goog.isArrayLike(arr2)) {\n      var len1 \x3d arr1.length || 0;\n      var len2 \x3d arr2.length || 0;\n      arr1.length \x3d len1 + len2;\n      for (var j \x3d 0; j \x3c len2; j++) {\n        arr1[len1 + j] \x3d arr2[j];\n      }\n    } else {\n      arr1.push(arr2);\n    }\n  }\n};\n/**\n * @param {IArrayLike\x3cT\x3e} arr\n * @param {(number|undefined)} index\n * @param {number} howMany\n * @param {...T} var_args\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.splice \x3d function(arr, index, howMany, var_args) {\n  goog.asserts.assert(arr.length !\x3d null);\n  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));\n};\n/**\n * @param {(IArrayLike\x3cT\x3e|string)} arr\n * @param {number} start\n * @param {number\x3d} opt_end\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.slice \x3d function(arr, start, opt_end) {\n  goog.asserts.assert(arr.length !\x3d null);\n  if (arguments.length \x3c\x3d 2) {\n    return Array.prototype.slice.call(arr, start);\n  } else {\n    return Array.prototype.slice.call(arr, start, opt_end);\n  }\n};\n/**\n * @param {IArrayLike\x3cT\x3e} arr\n * @param {Array\x3d} opt_rv\n * @param {function(T):string\x3d} opt_hashFn\n * @template T\n */\ngoog.array.removeDuplicates \x3d function(arr, opt_rv, opt_hashFn) {\n  var returnArray \x3d opt_rv || arr;\n  var defaultHashFn \x3d function(item) {\n    return goog.isObject(item) ? \x22o\x22 + goog.getUid(item) : (typeof item).charAt(0) + item;\n  };\n  var hashFn \x3d opt_hashFn || defaultHashFn;\n  var seen \x3d {}, cursorInsert \x3d 0, cursorRead \x3d 0;\n  while (cursorRead \x3c arr.length) {\n    var current \x3d arr[cursorRead++];\n    var key \x3d hashFn(current);\n    if (!Object.prototype.hasOwnProperty.call(seen, key)) {\n      seen[key] \x3d true;\n      returnArray[cursorInsert++] \x3d current;\n    }\n  }\n  returnArray.length \x3d cursorInsert;\n};\n/**\n * @param {IArrayLike\x3cVALUE\x3e} arr\n * @param {TARGET} target\n * @param {function(TARGET,VALUE):number\x3d} opt_compareFn\n * @return {number}\n * @template TARGET\n * @template VALUE\n */\ngoog.array.binarySearch \x3d function(arr, target, opt_compareFn) {\n  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);\n};\n/**\n * @param {IArrayLike\x3cVALUE\x3e} arr\n * @param {function(this:THIS,VALUE,number,?):number} evaluator\n * @param {THIS\x3d} opt_obj\n * @return {number}\n * @template THIS\n * @template VALUE\n */\ngoog.array.binarySelect \x3d function(arr, evaluator, opt_obj) {\n  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);\n};\n/**\n * @private\n * @param {IArrayLike\x3c?\x3e} arr\n * @param {(function(?,?,?):number|function(?,?):number)} compareFn\n * @param {boolean} isEvaluator\n * @param {?\x3d} opt_target\n * @param {Object\x3d} opt_selfObj\n * @return {number}\n */\ngoog.array.binarySearch_ \x3d function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {\n  var left \x3d 0;\n  var right \x3d arr.length;\n  var found;\n  while (left \x3c right) {\n    var middle \x3d left + (right - left \x3e\x3e\x3e 1);\n    var compareResult;\n    if (isEvaluator) {\n      compareResult \x3d compareFn.call(opt_selfObj, arr[middle], middle, arr);\n    } else {\n      compareResult \x3d /** @type {function(?,?):number} */ (compareFn)(opt_target, arr[middle]);\n    }\n    if (compareResult \x3e 0) {\n      left \x3d middle + 1;\n    } else {\n      right \x3d middle;\n      found \x3d !compareResult;\n    }\n  }\n  return found ? left : -left - 1;\n};\n/**\n * @param {Array\x3cT\x3e} arr\n * @param {?function(T,T):number\x3d} opt_compareFn\n * @template T\n */\ngoog.array.sort \x3d function(arr, opt_compareFn) {\n  arr.sort(opt_compareFn || goog.array.defaultCompare);\n};\n/**\n * @param {Array\x3cT\x3e} arr\n * @param {?function(T,T):number\x3d} opt_compareFn\n * @template T\n */\ngoog.array.stableSort \x3d function(arr, opt_compareFn) {\n  var compArr \x3d new Array(arr.length);\n  for (var i \x3d 0; i \x3c arr.length; i++) {\n    compArr[i] \x3d {index:i, value:arr[i]};\n  }\n  var valueCompareFn \x3d opt_compareFn || goog.array.defaultCompare;\n  function stableCompareFn(obj1, obj2) {\n    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;\n  }\n  goog.array.sort(compArr, stableCompareFn);\n  for (var i \x3d 0; i \x3c arr.length; i++) {\n    arr[i] \x3d compArr[i].value;\n  }\n};\n/**\n * @param {Array\x3cT\x3e} arr\n * @param {function(T):K} keyFn\n * @param {?function(K,K):number\x3d} opt_compareFn\n * @template T\n * @template K\n */\ngoog.array.sortByKey \x3d function(arr, keyFn, opt_compareFn) {\n  var keyCompareFn \x3d opt_compareFn || goog.array.defaultCompare;\n  goog.array.sort(arr, function(a, b) {\n    return keyCompareFn(keyFn(a), keyFn(b));\n  });\n};\n/**\n * @param {Array\x3cObject\x3e} arr\n * @param {string} key\n * @param {Function\x3d} opt_compareFn\n */\ngoog.array.sortObjectsByKey \x3d function(arr, key, opt_compareFn) {\n  goog.array.sortByKey(arr, function(obj) {\n    return obj[key];\n  }, opt_compareFn);\n};\n/**\n * @param {!IArrayLike\x3cT\x3e} arr\n * @param {?function(T,T):number\x3d} opt_compareFn\n * @param {boolean\x3d} opt_strict\n * @return {boolean}\n * @template T\n */\ngoog.array.isSorted \x3d function(arr, opt_compareFn, opt_strict) {\n  var compare \x3d opt_compareFn || goog.array.defaultCompare;\n  for (var i \x3d 1; i \x3c arr.length; i++) {\n    var compareResult \x3d compare(arr[i - 1], arr[i]);\n    if (compareResult \x3e 0 || compareResult \x3d\x3d 0 \x26\x26 opt_strict) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {IArrayLike\x3c?\x3e} arr1\n * @param {IArrayLike\x3c?\x3e} arr2\n * @param {Function\x3d} opt_equalsFn\n * @return {boolean}\n */\ngoog.array.equals \x3d function(arr1, arr2, opt_equalsFn) {\n  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length !\x3d arr2.length) {\n    return false;\n  }\n  var l \x3d arr1.length;\n  var equalsFn \x3d opt_equalsFn || goog.array.defaultCompareEquality;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (!equalsFn(arr1[i], arr2[i])) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {!IArrayLike\x3cVALUE\x3e} arr1\n * @param {!IArrayLike\x3cVALUE\x3e} arr2\n * @param {function(VALUE,VALUE):number\x3d} opt_compareFn\n * @return {number}\n * @template VALUE\n */\ngoog.array.compare3 \x3d function(arr1, arr2, opt_compareFn) {\n  var compare \x3d opt_compareFn || goog.array.defaultCompare;\n  var l \x3d Math.min(arr1.length, arr2.length);\n  for (var i \x3d 0; i \x3c l; i++) {\n    var result \x3d compare(arr1[i], arr2[i]);\n    if (result !\x3d 0) {\n      return result;\n    }\n  }\n  return goog.array.defaultCompare(arr1.length, arr2.length);\n};\n/**\n * @param {VALUE} a\n * @param {VALUE} b\n * @return {number}\n * @template VALUE\n */\ngoog.array.defaultCompare \x3d function(a, b) {\n  return a \x3e b ? 1 : a \x3c b ? -1 : 0;\n};\n/**\n * @param {VALUE} a\n * @param {VALUE} b\n * @return {number}\n * @template VALUE\n */\ngoog.array.inverseDefaultCompare \x3d function(a, b) {\n  return -goog.array.defaultCompare(a, b);\n};\n/**\n * @param {*} a\n * @param {*} b\n * @return {boolean}\n */\ngoog.array.defaultCompareEquality \x3d function(a, b) {\n  return a \x3d\x3d\x3d b;\n};\n/**\n * @param {IArrayLike\x3cVALUE\x3e} array\n * @param {VALUE} value\n * @param {function(VALUE,VALUE):number\x3d} opt_compareFn\n * @return {boolean}\n * @template VALUE\n */\ngoog.array.binaryInsert \x3d function(array, value, opt_compareFn) {\n  var index \x3d goog.array.binarySearch(array, value, opt_compareFn);\n  if (index \x3c 0) {\n    goog.array.insertAt(array, value, -(index + 1));\n    return true;\n  }\n  return false;\n};\n/**\n * @param {!IArrayLike\x3cVALUE\x3e} array\n * @param {VALUE} value\n * @param {function(VALUE,VALUE):number\x3d} opt_compareFn\n * @return {boolean}\n * @template VALUE\n */\ngoog.array.binaryRemove \x3d function(array, value, opt_compareFn) {\n  var index \x3d goog.array.binarySearch(array, value, opt_compareFn);\n  return index \x3e\x3d 0 ? goog.array.removeAt(array, index) : false;\n};\n/**\n * @param {IArrayLike\x3cT\x3e} array\n * @param {function(this:S,T,number,!IArrayLike\x3cT\x3e):?} sorter\n * @param {S\x3d} opt_obj\n * @return {!Object\x3c?,!Array\x3cT\x3e\x3e}\n * @template T\n * @template S\n */\ngoog.array.bucket \x3d function(array, sorter, opt_obj) {\n  var buckets \x3d {};\n  for (var i \x3d 0; i \x3c array.length; i++) {\n    var value \x3d array[i];\n    var key \x3d sorter.call(/** @type {?} */ (opt_obj), value, i, array);\n    if (key !\x3d\x3d undefined) {\n      var bucket \x3d buckets[key] || (buckets[key] \x3d []);\n      bucket.push(value);\n    }\n  }\n  return buckets;\n};\n/**\n * @param {IArrayLike\x3cT\x3e} arr\n * @param {?function(this:S,T,number,?):string} keyFunc\n * @param {S\x3d} opt_obj\n * @return {!Object\x3c?,T\x3e}\n * @template T\n * @template S\n */\ngoog.array.toObject \x3d function(arr, keyFunc, opt_obj) {\n  var ret \x3d {};\n  goog.array.forEach(arr, function(element, index) {\n    ret[keyFunc.call(/** @type {?} */ (opt_obj), element, index, arr)] \x3d element;\n  });\n  return ret;\n};\n/**\n * @param {number} startOrEnd\n * @param {number\x3d} opt_end\n * @param {number\x3d} opt_step\n * @return {!Array\x3cnumber\x3e}\n */\ngoog.array.range \x3d function(startOrEnd, opt_end, opt_step) {\n  var array \x3d [];\n  var start \x3d 0;\n  var end \x3d startOrEnd;\n  var step \x3d opt_step || 1;\n  if (opt_end !\x3d\x3d undefined) {\n    start \x3d startOrEnd;\n    end \x3d opt_end;\n  }\n  if (step * (end - start) \x3c 0) {\n    return [];\n  }\n  if (step \x3e 0) {\n    for (var i \x3d start; i \x3c end; i +\x3d step) {\n      array.push(i);\n    }\n  } else {\n    for (var i \x3d start; i \x3e end; i +\x3d step) {\n      array.push(i);\n    }\n  }\n  return array;\n};\n/**\n * @param {VALUE} value\n * @param {number} n\n * @return {!Array\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.array.repeat \x3d function(value, n) {\n  var array \x3d [];\n  for (var i \x3d 0; i \x3c n; i++) {\n    array[i] \x3d value;\n  }\n  return array;\n};\n/**\n * @param {...*} var_args\n * @return {!Array\x3c?\x3e}\n */\ngoog.array.flatten \x3d function(var_args) {\n  var CHUNK_SIZE \x3d 8192;\n  var result \x3d [];\n  for (var i \x3d 0; i \x3c arguments.length; i++) {\n    var element \x3d arguments[i];\n    if (goog.isArray(element)) {\n      for (var c \x3d 0; c \x3c element.length; c +\x3d CHUNK_SIZE) {\n        var chunk \x3d goog.array.slice(element, c, c + CHUNK_SIZE);\n        var recurseResult \x3d goog.array.flatten.apply(null, chunk);\n        for (var r \x3d 0; r \x3c recurseResult.length; r++) {\n          result.push(recurseResult[r]);\n        }\n      }\n    } else {\n      result.push(element);\n    }\n  }\n  return result;\n};\n/**\n * @param {!Array\x3cT\x3e} array\n * @param {number} n\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.rotate \x3d function(array, n) {\n  goog.asserts.assert(array.length !\x3d null);\n  if (array.length) {\n    n %\x3d array.length;\n    if (n \x3e 0) {\n      Array.prototype.unshift.apply(array, array.splice(-n, n));\n    } else {\n      if (n \x3c 0) {\n        Array.prototype.push.apply(array, array.splice(0, -n));\n      }\n    }\n  }\n  return array;\n};\n/**\n * @param {!IArrayLike\x3c?\x3e} arr\n * @param {number} fromIndex\n * @param {number} toIndex\n */\ngoog.array.moveItem \x3d function(arr, fromIndex, toIndex) {\n  goog.asserts.assert(fromIndex \x3e\x3d 0 \x26\x26 fromIndex \x3c arr.length);\n  goog.asserts.assert(toIndex \x3e\x3d 0 \x26\x26 toIndex \x3c arr.length);\n  var removedItems \x3d Array.prototype.splice.call(arr, fromIndex, 1);\n  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);\n};\n/**\n * @param {...!IArrayLike\x3c?\x3e} var_args\n * @return {!Array\x3c!Array\x3c?\x3e\x3e}\n */\ngoog.array.zip \x3d function(var_args) {\n  if (!arguments.length) {\n    return [];\n  }\n  var result \x3d [];\n  var minLen \x3d arguments[0].length;\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    if (arguments[i].length \x3c minLen) {\n      minLen \x3d arguments[i].length;\n    }\n  }\n  for (var i \x3d 0; i \x3c minLen; i++) {\n    var value \x3d [];\n    for (var j \x3d 0; j \x3c arguments.length; j++) {\n      value.push(arguments[j][i]);\n    }\n    result.push(value);\n  }\n  return result;\n};\n/**\n * @param {!Array\x3c?\x3e} arr\n * @param {function():number\x3d} opt_randFn\n */\ngoog.array.shuffle \x3d function(arr, opt_randFn) {\n  var randFn \x3d opt_randFn || Math.random;\n  for (var i \x3d arr.length - 1; i \x3e 0; i--) {\n    var j \x3d Math.floor(randFn() * (i + 1));\n    var tmp \x3d arr[i];\n    arr[i] \x3d arr[j];\n    arr[j] \x3d tmp;\n  }\n};\n/**\n * @param {!IArrayLike\x3cT\x3e} arr\n * @param {!IArrayLike\x3cnumber\x3e} index_arr\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.copyByIndex \x3d function(arr, index_arr) {\n  var result \x3d [];\n  goog.array.forEach(index_arr, function(index) {\n    result.push(arr[index]);\n  });\n  return result;\n};\n/**\n * @param {(!IArrayLike\x3cVALUE\x3e|string)} arr\n * @param {function(this:THIS,VALUE,number,?):!Array\x3cRESULT\x3e} f\n * @param {THIS\x3d} opt_obj\n * @return {!Array\x3cRESULT\x3e}\n * @template THIS\n * @template VALUE\n * @template RESULT\n */\ngoog.array.concatMap \x3d function(arr, f, opt_obj) {\n  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));\n};\n");
SHADOW_ENV.evalLoad("goog.dom.htmlelement.js", true , "goog.provide(\x22goog.dom.HtmlElement\x22);\n/**\n * @constructor\n * @extends {HTMLElement}\n */\ngoog.dom.HtmlElement \x3d function() {\n};\n");
SHADOW_ENV.evalLoad("goog.dom.tagname.js", true , "goog.provide(\x22goog.dom.TagName\x22);\ngoog.require(\x22goog.dom.HtmlElement\x22);\n/**\n * @constructor\n * @param {string} tagName\n * @template T\n */\ngoog.dom.TagName \x3d function(tagName) {\n  /** @private @type {string} */ this.tagName_ \x3d tagName;\n};\n/**\n * @return {string}\n * @override\n */\ngoog.dom.TagName.prototype.toString \x3d function() {\n  return this.tagName_;\n};\n/** @type {!goog.dom.TagName\x3c!HTMLAnchorElement\x3e} */ goog.dom.TagName.A \x3d new goog.dom.TagName(\x22A\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.ABBR \x3d new goog.dom.TagName(\x22ABBR\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.ACRONYM \x3d new goog.dom.TagName(\x22ACRONYM\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.ADDRESS \x3d new goog.dom.TagName(\x22ADDRESS\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLAppletElement\x3e} */ goog.dom.TagName.APPLET \x3d new goog.dom.TagName(\x22APPLET\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLAreaElement\x3e} */ goog.dom.TagName.AREA \x3d new goog.dom.TagName(\x22AREA\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.ARTICLE \x3d new goog.dom.TagName(\x22ARTICLE\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.ASIDE \x3d new goog.dom.TagName(\x22ASIDE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLAudioElement\x3e} */ goog.dom.TagName.AUDIO \x3d new goog.dom.TagName(\x22AUDIO\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.B \x3d new goog.dom.TagName(\x22B\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLBaseElement\x3e} */ goog.dom.TagName.BASE \x3d new goog.dom.TagName(\x22BASE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLBaseFontElement\x3e} */ goog.dom.TagName.BASEFONT \x3d new goog.dom.TagName(\x22BASEFONT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.BDI \x3d new goog.dom.TagName(\x22BDI\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.BDO \x3d new goog.dom.TagName(\x22BDO\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.BIG \x3d new goog.dom.TagName(\x22BIG\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLQuoteElement\x3e} */ goog.dom.TagName.BLOCKQUOTE \x3d new goog.dom.TagName(\x22BLOCKQUOTE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLBodyElement\x3e} */ goog.dom.TagName.BODY \x3d new goog.dom.TagName(\x22BODY\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLBRElement\x3e} */ goog.dom.TagName.BR \x3d new goog.dom.TagName(\x22BR\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLButtonElement\x3e} */ goog.dom.TagName.BUTTON \x3d new goog.dom.TagName(\x22BUTTON\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLCanvasElement\x3e} */ goog.dom.TagName.CANVAS \x3d new goog.dom.TagName(\x22CANVAS\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableCaptionElement\x3e} */ goog.dom.TagName.CAPTION \x3d new goog.dom.TagName(\x22CAPTION\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.CENTER \x3d new goog.dom.TagName(\x22CENTER\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.CITE \x3d new goog.dom.TagName(\x22CITE\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.CODE \x3d new goog.dom.TagName(\x22CODE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableColElement\x3e} */ goog.dom.TagName.COL \x3d new goog.dom.TagName(\x22COL\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableColElement\x3e} */ goog.dom.TagName.COLGROUP \x3d new goog.dom.TagName(\x22COLGROUP\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.COMMAND \x3d new goog.dom.TagName(\x22COMMAND\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.DATA \x3d new goog.dom.TagName(\x22DATA\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLDataListElement\x3e} */ goog.dom.TagName.DATALIST \x3d new goog.dom.TagName(\x22DATALIST\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.DD \x3d new goog.dom.TagName(\x22DD\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLModElement\x3e} */ goog.dom.TagName.DEL \x3d new goog.dom.TagName(\x22DEL\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLDetailsElement\x3e} */ goog.dom.TagName.DETAILS \x3d new goog.dom.TagName(\x22DETAILS\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.DFN \x3d new goog.dom.TagName(\x22DFN\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLDialogElement\x3e} */ goog.dom.TagName.DIALOG \x3d new goog.dom.TagName(\x22DIALOG\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLDirectoryElement\x3e} */ goog.dom.TagName.DIR \x3d new goog.dom.TagName(\x22DIR\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLDivElement\x3e} */ goog.dom.TagName.DIV \x3d new goog.dom.TagName(\x22DIV\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLDListElement\x3e} */ goog.dom.TagName.DL \x3d new goog.dom.TagName(\x22DL\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.DT \x3d new goog.dom.TagName(\x22DT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.EM \x3d new goog.dom.TagName(\x22EM\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLEmbedElement\x3e} */ goog.dom.TagName.EMBED \x3d new goog.dom.TagName(\x22EMBED\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLFieldSetElement\x3e} */ goog.dom.TagName.FIELDSET \x3d new goog.dom.TagName(\x22FIELDSET\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.FIGCAPTION \x3d new goog.dom.TagName(\x22FIGCAPTION\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.FIGURE \x3d new goog.dom.TagName(\x22FIGURE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLFontElement\x3e} */ goog.dom.TagName.FONT \x3d new goog.dom.TagName(\x22FONT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.FOOTER \x3d new goog.dom.TagName(\x22FOOTER\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLFormElement\x3e} */ goog.dom.TagName.FORM \x3d new goog.dom.TagName(\x22FORM\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLFrameElement\x3e} */ goog.dom.TagName.FRAME \x3d new goog.dom.TagName(\x22FRAME\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLFrameSetElement\x3e} */ goog.dom.TagName.FRAMESET \x3d new goog.dom.TagName(\x22FRAMESET\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadingElement\x3e} */ goog.dom.TagName.H1 \x3d new goog.dom.TagName(\x22H1\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadingElement\x3e} */ goog.dom.TagName.H2 \x3d new goog.dom.TagName(\x22H2\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadingElement\x3e} */ goog.dom.TagName.H3 \x3d new goog.dom.TagName(\x22H3\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadingElement\x3e} */ goog.dom.TagName.H4 \x3d new goog.dom.TagName(\x22H4\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadingElement\x3e} */ goog.dom.TagName.H5 \x3d new goog.dom.TagName(\x22H5\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadingElement\x3e} */ goog.dom.TagName.H6 \x3d new goog.dom.TagName(\x22H6\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHeadElement\x3e} */ goog.dom.TagName.HEAD \x3d new goog.dom.TagName(\x22HEAD\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.HEADER \x3d new goog.dom.TagName(\x22HEADER\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.HGROUP \x3d new goog.dom.TagName(\x22HGROUP\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHRElement\x3e} */ goog.dom.TagName.HR \x3d new goog.dom.TagName(\x22HR\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLHtmlElement\x3e} */ goog.dom.TagName.HTML \x3d new goog.dom.TagName(\x22HTML\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.I \x3d new goog.dom.TagName(\x22I\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLIFrameElement\x3e} */ goog.dom.TagName.IFRAME \x3d new goog.dom.TagName(\x22IFRAME\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLImageElement\x3e} */ goog.dom.TagName.IMG \x3d new goog.dom.TagName(\x22IMG\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLInputElement\x3e} */ goog.dom.TagName.INPUT \x3d new goog.dom.TagName(\x22INPUT\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLModElement\x3e} */ goog.dom.TagName.INS \x3d new goog.dom.TagName(\x22INS\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLIsIndexElement\x3e} */ goog.dom.TagName.ISINDEX \x3d new goog.dom.TagName(\x22ISINDEX\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.KBD \x3d new goog.dom.TagName(\x22KBD\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.KEYGEN \x3d new goog.dom.TagName(\x22KEYGEN\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLLabelElement\x3e} */ goog.dom.TagName.LABEL \x3d new goog.dom.TagName(\x22LABEL\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLLegendElement\x3e} */ goog.dom.TagName.LEGEND \x3d new goog.dom.TagName(\x22LEGEND\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLLIElement\x3e} */ goog.dom.TagName.LI \x3d new goog.dom.TagName(\x22LI\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLLinkElement\x3e} */ goog.dom.TagName.LINK \x3d new goog.dom.TagName(\x22LINK\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.MAIN \x3d new goog.dom.TagName(\x22MAIN\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLMapElement\x3e} */ goog.dom.TagName.MAP \x3d new goog.dom.TagName(\x22MAP\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.MARK \x3d new goog.dom.TagName(\x22MARK\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.MATH \x3d new goog.dom.TagName(\x22MATH\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLMenuElement\x3e} */ goog.dom.TagName.MENU \x3d new goog.dom.TagName(\x22MENU\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLMenuItemElement\x3e} */ goog.dom.TagName.MENUITEM \x3d new goog.dom.TagName(\x22MENUITEM\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLMetaElement\x3e} */ goog.dom.TagName.META \x3d new goog.dom.TagName(\x22META\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLMeterElement\x3e} */ goog.dom.TagName.METER \x3d new goog.dom.TagName(\x22METER\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.NAV \x3d new goog.dom.TagName(\x22NAV\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.NOFRAMES \x3d new goog.dom.TagName(\x22NOFRAMES\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.NOSCRIPT \x3d new goog.dom.TagName(\x22NOSCRIPT\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLObjectElement\x3e} */ goog.dom.TagName.OBJECT \x3d new goog.dom.TagName(\x22OBJECT\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLOListElement\x3e} */ goog.dom.TagName.OL \x3d new goog.dom.TagName(\x22OL\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLOptGroupElement\x3e} */ goog.dom.TagName.OPTGROUP \x3d new goog.dom.TagName(\x22OPTGROUP\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLOptionElement\x3e} */ goog.dom.TagName.OPTION \x3d new goog.dom.TagName(\x22OPTION\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLOutputElement\x3e} */ goog.dom.TagName.OUTPUT \x3d new goog.dom.TagName(\x22OUTPUT\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLParagraphElement\x3e} */ goog.dom.TagName.P \x3d new goog.dom.TagName(\x22P\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLParamElement\x3e} */ goog.dom.TagName.PARAM \x3d new goog.dom.TagName(\x22PARAM\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLPictureElement\x3e} */ goog.dom.TagName.PICTURE \x3d new goog.dom.TagName(\x22PICTURE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLPreElement\x3e} */ goog.dom.TagName.PRE \x3d new goog.dom.TagName(\x22PRE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLProgressElement\x3e} */ goog.dom.TagName.PROGRESS \x3d new goog.dom.TagName(\x22PROGRESS\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLQuoteElement\x3e} */ goog.dom.TagName.Q \x3d new goog.dom.TagName(\x22Q\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.RP \x3d new goog.dom.TagName(\x22RP\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.RT \x3d new goog.dom.TagName(\x22RT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.RTC \x3d new goog.dom.TagName(\x22RTC\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.RUBY \x3d new goog.dom.TagName(\x22RUBY\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.S \x3d new goog.dom.TagName(\x22S\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SAMP \x3d new goog.dom.TagName(\x22SAMP\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLScriptElement\x3e} */ goog.dom.TagName.SCRIPT \x3d new goog.dom.TagName(\x22SCRIPT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SECTION \x3d new goog.dom.TagName(\x22SECTION\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLSelectElement\x3e} */ goog.dom.TagName.SELECT \x3d new goog.dom.TagName(\x22SELECT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SMALL \x3d new goog.dom.TagName(\x22SMALL\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLSourceElement\x3e} */ goog.dom.TagName.SOURCE \x3d new goog.dom.TagName(\x22SOURCE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLSpanElement\x3e} */ goog.dom.TagName.SPAN \x3d new goog.dom.TagName(\x22SPAN\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.STRIKE \x3d new goog.dom.TagName(\x22STRIKE\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.STRONG \x3d new goog.dom.TagName(\x22STRONG\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLStyleElement\x3e} */ goog.dom.TagName.STYLE \x3d new goog.dom.TagName(\x22STYLE\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SUB \x3d new goog.dom.TagName(\x22SUB\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SUMMARY \x3d new goog.dom.TagName(\x22SUMMARY\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SUP \x3d new goog.dom.TagName(\x22SUP\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.SVG \x3d new goog.dom.TagName(\x22SVG\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableElement\x3e} */ goog.dom.TagName.TABLE \x3d new goog.dom.TagName(\x22TABLE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableSectionElement\x3e} */ goog.dom.TagName.TBODY \x3d new goog.dom.TagName(\x22TBODY\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableCellElement\x3e} */ goog.dom.TagName.TD \x3d new goog.dom.TagName(\x22TD\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTemplateElement\x3e} */ goog.dom.TagName.TEMPLATE \x3d new goog.dom.TagName(\x22TEMPLATE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTextAreaElement\x3e} */ goog.dom.TagName.TEXTAREA \x3d new goog.dom.TagName(\x22TEXTAREA\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableSectionElement\x3e} */ goog.dom.TagName.TFOOT \x3d new goog.dom.TagName(\x22TFOOT\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableCellElement\x3e} */ goog.dom.TagName.TH \x3d new goog.dom.TagName(\x22TH\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableSectionElement\x3e} */ goog.dom.TagName.THEAD \x3d new goog.dom.TagName(\x22THEAD\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.TIME \x3d new goog.dom.TagName(\x22TIME\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTitleElement\x3e} */ goog.dom.TagName.TITLE \x3d new goog.dom.TagName(\x22TITLE\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTableRowElement\x3e} */ goog.dom.TagName.TR \x3d new goog.dom.TagName(\x22TR\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLTrackElement\x3e} */ goog.dom.TagName.TRACK \x3d new goog.dom.TagName(\x22TRACK\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.TT \x3d new goog.dom.TagName(\x22TT\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.U \x3d new goog.dom.TagName(\x22U\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLUListElement\x3e} */ goog.dom.TagName.UL \x3d new goog.dom.TagName(\x22UL\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.VAR \x3d new goog.dom.TagName(\x22VAR\x22);\n/** @type {!goog.dom.TagName\x3c!HTMLVideoElement\x3e} */ goog.dom.TagName.VIDEO \x3d new goog.dom.TagName(\x22VIDEO\x22);\n/** @type {!goog.dom.TagName\x3c!goog.dom.HtmlElement\x3e} */ goog.dom.TagName.WBR \x3d new goog.dom.TagName(\x22WBR\x22);\n");
SHADOW_ENV.evalLoad("goog.object.object.js", true , "goog.provide(\x22goog.object\x22);\n/**\n * @param {*} v\n * @param {*} v2\n * @return {boolean}\n */\ngoog.object.is \x3d function(v, v2) {\n  if (v \x3d\x3d\x3d v2) {\n    return v !\x3d\x3d 0 || 1 / v \x3d\x3d\x3d 1 / /** @type {?} */ (v2);\n  }\n  return v !\x3d\x3d v \x26\x26 v2 !\x3d\x3d v2;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):?} f\n * @param {T\x3d} opt_obj\n * @template T\n * @template K\n * @template V\n */\ngoog.object.forEach \x3d function(obj, f, opt_obj) {\n  for (var key in obj) {\n    f.call(/** @type {?} */ (opt_obj), obj[key], key, obj);\n  }\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):boolean} f\n * @param {T\x3d} opt_obj\n * @return {!Object\x3cK,V\x3e}\n * @template T\n * @template K\n * @template V\n */\ngoog.object.filter \x3d function(obj, f, opt_obj) {\n  /** @const */ var res \x3d {};\n  for (var key in obj) {\n    if (f.call(/** @type {?} */ (opt_obj), obj[key], key, obj)) {\n      res[key] \x3d obj[key];\n    }\n  }\n  return res;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):R} f\n * @param {T\x3d} opt_obj\n * @return {!Object\x3cK,R\x3e}\n * @template T\n * @template K\n * @template V\n * @template R\n */\ngoog.object.map \x3d function(obj, f, opt_obj) {\n  /** @const */ var res \x3d {};\n  for (var key in obj) {\n    res[key] \x3d f.call(/** @type {?} */ (opt_obj), obj[key], key, obj);\n  }\n  return res;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):boolean} f\n * @param {T\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template K\n * @template V\n */\ngoog.object.some \x3d function(obj, f, opt_obj) {\n  for (var key in obj) {\n    if (f.call(/** @type {?} */ (opt_obj), obj[key], key, obj)) {\n      return true;\n    }\n  }\n  return false;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {?function(this:T,V,?,Object\x3cK,V\x3e):boolean} f\n * @param {T\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template K\n * @template V\n */\ngoog.object.every \x3d function(obj, f, opt_obj) {\n  for (var key in obj) {\n    if (!f.call(/** @type {?} */ (opt_obj), obj[key], key, obj)) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {Object} obj\n * @return {number}\n */\ngoog.object.getCount \x3d function(obj) {\n  var rv \x3d 0;\n  for (var key in obj) {\n    rv++;\n  }\n  return rv;\n};\n/**\n * @param {Object} obj\n * @return {(string|undefined)}\n */\ngoog.object.getAnyKey \x3d function(obj) {\n  for (var key in obj) {\n    return key;\n  }\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @return {(V|undefined)}\n * @template K\n * @template V\n */\ngoog.object.getAnyValue \x3d function(obj) {\n  for (var key in obj) {\n    return obj[key];\n  }\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {V} val\n * @return {boolean}\n * @template K\n * @template V\n */\ngoog.object.contains \x3d function(obj, val) {\n  return goog.object.containsValue(obj, val);\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @return {!Array\x3cV\x3e}\n * @template K\n * @template V\n */\ngoog.object.getValues \x3d function(obj) {\n  /** @const */ var res \x3d [];\n  var i \x3d 0;\n  for (var key in obj) {\n    res[i++] \x3d obj[key];\n  }\n  return res;\n};\n/**\n * @param {Object} obj\n * @return {!Array\x3cstring\x3e}\n */\ngoog.object.getKeys \x3d function(obj) {\n  /** @const */ var res \x3d [];\n  var i \x3d 0;\n  for (var key in obj) {\n    res[i++] \x3d key;\n  }\n  return res;\n};\n/**\n * @param {!Object} obj\n * @param {...(string|number|!IArrayLike\x3c(number|string)\x3e)} var_args\n * @return {*}\n */\ngoog.object.getValueByKeys \x3d function(obj, var_args) {\n  /** @const */ var isArrayLike \x3d goog.isArrayLike(var_args);\n  /** @const */ var keys \x3d isArrayLike ? /** @type {!IArrayLike\x3c(number|string)\x3e} */ (var_args) : arguments;\n  for (var i \x3d isArrayLike ? 0 : 1; i \x3c keys.length; i++) {\n    if (obj \x3d\x3d null) {\n      return undefined;\n    }\n    obj \x3d obj[keys[i]];\n  }\n  return obj;\n};\n/**\n * @param {Object} obj\n * @param {?} key\n * @return {boolean}\n */\ngoog.object.containsKey \x3d function(obj, key) {\n  return obj !\x3d\x3d null \x26\x26 key in obj;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {V} val\n * @return {boolean}\n * @template K\n * @template V\n */\ngoog.object.containsValue \x3d function(obj, val) {\n  for (var key in obj) {\n    if (obj[key] \x3d\x3d val) {\n      return true;\n    }\n  }\n  return false;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {function(this:T,V,string,Object\x3cK,V\x3e):boolean} f\n * @param {T\x3d} opt_this\n * @return {(string|undefined)}\n * @template T\n * @template K\n * @template V\n */\ngoog.object.findKey \x3d function(obj, f, opt_this) {\n  for (var key in obj) {\n    if (f.call(/** @type {?} */ (opt_this), obj[key], key, obj)) {\n      return key;\n    }\n  }\n  return undefined;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {function(this:T,V,string,Object\x3cK,V\x3e):boolean} f\n * @param {T\x3d} opt_this\n * @return {V}\n * @template T\n * @template K\n * @template V\n */\ngoog.object.findValue \x3d function(obj, f, opt_this) {\n  /** @const */ var key \x3d goog.object.findKey(obj, f, opt_this);\n  return key \x26\x26 obj[key];\n};\n/**\n * @param {Object} obj\n * @return {boolean}\n */\ngoog.object.isEmpty \x3d function(obj) {\n  for (var key in obj) {\n    return false;\n  }\n  return true;\n};\n/**\n * @param {Object} obj\n */\ngoog.object.clear \x3d function(obj) {\n  for (var i in obj) {\n    delete obj[i];\n  }\n};\n/**\n * @param {Object} obj\n * @param {?} key\n * @return {boolean}\n */\ngoog.object.remove \x3d function(obj, key) {\n  var rv;\n  if (rv \x3d key in /** @type {!Object} */ (obj)) {\n    delete obj[key];\n  }\n  return rv;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {string} key\n * @param {V} val\n * @template K\n * @template V\n */\ngoog.object.add \x3d function(obj, key, val) {\n  if (obj !\x3d\x3d null \x26\x26 key in obj) {\n    throw new Error(\x27The object already contains the key \x22\x27 + key + \x27\x22\x27);\n  }\n  goog.object.set(obj, key, val);\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {string} key\n * @param {R\x3d} opt_val\n * @return {(V|R|undefined)}\n * @template K\n * @template V\n * @template R\n */\ngoog.object.get \x3d function(obj, key, opt_val) {\n  if (obj !\x3d\x3d null \x26\x26 key in obj) {\n    return obj[key];\n  }\n  return opt_val;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {string} key\n * @param {V} value\n * @template K\n * @template V\n */\ngoog.object.set \x3d function(obj, key, value) {\n  obj[key] \x3d value;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @param {string} key\n * @param {V} value\n * @return {V}\n * @template K\n * @template V\n */\ngoog.object.setIfUndefined \x3d function(obj, key, value) {\n  return key in /** @type {!Object} */ (obj) ? obj[key] : obj[key] \x3d value;\n};\n/**\n * @param {!Object\x3cK,V\x3e} obj\n * @param {string} key\n * @param {function():V} f\n * @return {V}\n * @template K\n * @template V\n */\ngoog.object.setWithReturnValueIfNotSet \x3d function(obj, key, f) {\n  if (key in obj) {\n    return obj[key];\n  }\n  /** @const */ var val \x3d f();\n  obj[key] \x3d val;\n  return val;\n};\n/**\n * @param {!Object\x3cK,V\x3e} a\n * @param {!Object\x3cK,V\x3e} b\n * @return {boolean}\n * @template K\n * @template V\n */\ngoog.object.equals \x3d function(a, b) {\n  for (var k in a) {\n    if (!(k in b) || a[k] !\x3d\x3d b[k]) {\n      return false;\n    }\n  }\n  for (var k$1 in b) {\n    if (!(k$1 in a)) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {Object\x3cK,V\x3e} obj\n * @return {!Object\x3cK,V\x3e}\n * @template K\n * @template V\n */\ngoog.object.clone \x3d function(obj) {\n  /** @const */ var res \x3d {};\n  for (var key in obj) {\n    res[key] \x3d obj[key];\n  }\n  return res;\n};\n/**\n * @param {T} obj\n * @return {T}\n * @template T\n */\ngoog.object.unsafeClone \x3d function(obj) {\n  /** @const */ var type \x3d goog.typeOf(obj);\n  if (type \x3d\x3d \x22object\x22 || type \x3d\x3d \x22array\x22) {\n    if (goog.isFunction(obj.clone)) {\n      return obj.clone();\n    }\n    /** @const */ var clone \x3d type \x3d\x3d \x22array\x22 ? [] : {};\n    for (var key in obj) {\n      clone[key] \x3d goog.object.unsafeClone(obj[key]);\n    }\n    return clone;\n  }\n  return obj;\n};\n/**\n * @param {Object} obj\n * @return {!Object}\n */\ngoog.object.transpose \x3d function(obj) {\n  /** @const */ var transposed \x3d {};\n  for (var key in obj) {\n    transposed[obj[key]] \x3d key;\n  }\n  return transposed;\n};\n/** @private @type {Array\x3cstring\x3e} */ goog.object.PROTOTYPE_FIELDS_ \x3d [\x22constructor\x22, \x22hasOwnProperty\x22, \x22isPrototypeOf\x22, \x22propertyIsEnumerable\x22, \x22toLocaleString\x22, \x22toString\x22, \x22valueOf\x22];\n/**\n * @param {Object} target\n * @param {...(Object|null|undefined)} var_args\n * @deprecated Prefer Object.assign\n */\ngoog.object.extend \x3d function(target, var_args) {\n  var key;\n  var source;\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    source \x3d arguments[i];\n    for (key in source) {\n      target[key] \x3d source[key];\n    }\n    for (var j \x3d 0; j \x3c goog.object.PROTOTYPE_FIELDS_.length; j++) {\n      key \x3d goog.object.PROTOTYPE_FIELDS_[j];\n      if (Object.prototype.hasOwnProperty.call(source, key)) {\n        target[key] \x3d source[key];\n      }\n    }\n  }\n};\n/**\n * @param {...*} var_args\n * @return {!Object}\n * @throws {Error}\n */\ngoog.object.create \x3d function(var_args) {\n  /** @const */ var argLength \x3d arguments.length;\n  if (argLength \x3d\x3d 1 \x26\x26 goog.isArray(arguments[0])) {\n    return goog.object.create.apply(null, arguments[0]);\n  }\n  if (argLength % 2) {\n    throw new Error(\x22Uneven number of arguments\x22);\n  }\n  /** @const */ var rv \x3d {};\n  for (var i \x3d 0; i \x3c argLength; i +\x3d 2) {\n    rv[arguments[i]] \x3d arguments[i + 1];\n  }\n  return rv;\n};\n/**\n * @param {...*} var_args\n * @return {!Object}\n */\ngoog.object.createSet \x3d function(var_args) {\n  /** @const */ var argLength \x3d arguments.length;\n  if (argLength \x3d\x3d 1 \x26\x26 goog.isArray(arguments[0])) {\n    return goog.object.createSet.apply(null, arguments[0]);\n  }\n  /** @const */ var rv \x3d {};\n  for (var i \x3d 0; i \x3c argLength; i++) {\n    rv[arguments[i]] \x3d true;\n  }\n  return rv;\n};\n/**\n * @param {!Object\x3cK,V\x3e} obj\n * @return {!Object\x3cK,V\x3e}\n * @template K\n * @template V\n */\ngoog.object.createImmutableView \x3d function(obj) {\n  var result \x3d obj;\n  if (Object.isFrozen \x26\x26 !Object.isFrozen(obj)) {\n    result \x3d Object.create(obj);\n    Object.freeze(result);\n  }\n  return result;\n};\n/**\n * @param {!Object} obj\n * @return {boolean}\n */\ngoog.object.isImmutableView \x3d function(obj) {\n  return !!Object.isFrozen \x26\x26 Object.isFrozen(obj);\n};\n/**\n * @public\n * @param {?Object} obj\n * @param {boolean\x3d} opt_includeObjectPrototype\n * @param {boolean\x3d} opt_includeFunctionPrototype\n * @return {!Array\x3cstring\x3e}\n */\ngoog.object.getAllPropertyNames \x3d function(obj, opt_includeObjectPrototype, opt_includeFunctionPrototype) {\n  if (!obj) {\n    return [];\n  }\n  if (!Object.getOwnPropertyNames || !Object.getPrototypeOf) {\n    return goog.object.getKeys(obj);\n  }\n  /** @const */ var visitedSet \x3d {};\n  var proto \x3d obj;\n  while (proto \x26\x26 (proto !\x3d\x3d Object.prototype || !!opt_includeObjectPrototype) \x26\x26 (proto !\x3d\x3d Function.prototype || !!opt_includeFunctionPrototype)) {\n    /** @const */ var names \x3d Object.getOwnPropertyNames(proto);\n    for (var i \x3d 0; i \x3c names.length; i++) {\n      visitedSet[names[i]] \x3d true;\n    }\n    proto \x3d Object.getPrototypeOf(proto);\n  }\n  return goog.object.getKeys(visitedSet);\n};\n/**\n * @param {function(new:?)} constructor\n * @return {?Object}\n */\ngoog.object.getSuperClass \x3d function(constructor) {\n  var proto \x3d Object.getPrototypeOf(constructor.prototype);\n  return proto \x26\x26 proto.constructor;\n};\n");
SHADOW_ENV.evalLoad("goog.dom.tags.js", true , "goog.provide(\x22goog.dom.tags\x22);\ngoog.require(\x22goog.object\x22);\n/** @private @const @type {!Object\x3cstring,boolean\x3e} */ goog.dom.tags.VOID_TAGS_ \x3d goog.object.createSet(\x22area\x22, \x22base\x22, \x22br\x22, \x22col\x22, \x22command\x22, \x22embed\x22, \x22hr\x22, \x22img\x22, \x22input\x22, \x22keygen\x22, \x22link\x22, \x22meta\x22, \x22param\x22, \x22source\x22, \x22track\x22, \x22wbr\x22);\n/**\n * @param {string} tagName\n * @return {boolean}\n */\ngoog.dom.tags.isVoidTag \x3d function(tagName) {\n  return goog.dom.tags.VOID_TAGS_[tagName] \x3d\x3d\x3d true;\n};\n");
SHADOW_ENV.evalLoad("goog.html.trustedtypes.js", true , "goog.provide(\x22goog.html.trustedtypes\x22);\n/** @package @const @type {?TrustedTypePolicy} */ goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY \x3d goog.TRUSTED_TYPES_POLICY_NAME ? goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME + \x22#html\x22) : null;\n");
SHADOW_ENV.evalLoad("goog.string.typedstring.js", true , "goog.provide(\x22goog.string.TypedString\x22);\n/** @interface */ goog.string.TypedString \x3d function() {\n};\n/** @type {boolean} */ goog.string.TypedString.prototype.implementsGoogStringTypedString;\n/**\n * @return {string}\n */\ngoog.string.TypedString.prototype.getTypedStringValue;\n");
SHADOW_ENV.evalLoad("goog.string.const.js", true , "goog.provide(\x22goog.string.Const\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.string.TypedString\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.string.TypedString}\n * @param {Object\x3d} opt_token\n * @param {string\x3d} opt_content\n */\ngoog.string.Const \x3d function(opt_token, opt_content) {\n  /** @private @type {string} */ this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ \x3d opt_token \x3d\x3d\x3d goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_ \x26\x26 opt_content || \x22\x22;\n  /** @private @const @type {!Object} */ this.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ \x3d goog.string.Const.TYPE_MARKER_;\n};\n/** @const @override */ goog.string.Const.prototype.implementsGoogStringTypedString \x3d true;\n/** @override */ goog.string.Const.prototype.getTypedStringValue \x3d function() {\n  return this.stringConstValueWithSecurityContract__googStringSecurityPrivate_;\n};\nif (goog.DEBUG) {\n  /** @override */ goog.string.Const.prototype.toString \x3d function() {\n    return \x22Const{\x22 + this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.string.Const} stringConst\n * @return {string}\n */\ngoog.string.Const.unwrap \x3d function(stringConst) {\n  if (stringConst instanceof goog.string.Const \x26\x26 stringConst.constructor \x3d\x3d\x3d goog.string.Const \x26\x26 stringConst.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.string.Const.TYPE_MARKER_) {\n    return stringConst.stringConstValueWithSecurityContract__googStringSecurityPrivate_;\n  } else {\n    goog.asserts.fail(\x22expected object of type Const, got \x27\x22 + stringConst + \x22\x27\x22);\n    return \x22type_error:Const\x22;\n  }\n};\n/**\n * @param {string} s\n * @return {!goog.string.Const}\n */\ngoog.string.Const.from \x3d function(s) {\n  return new goog.string.Const(goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_, s);\n};\n/** @private @const @type {!Object} */ goog.string.Const.TYPE_MARKER_ \x3d {};\n/** @private @const @type {!Object} */ goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_ \x3d {};\n/** @const @type {!goog.string.Const} */ goog.string.Const.EMPTY \x3d goog.string.Const.from(\x22\x22);\n");
SHADOW_ENV.evalLoad("goog.html.safescript.js", true , "goog.provide(\x22goog.html.SafeScript\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.html.trustedtypes\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.TypedString\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.string.TypedString}\n */\ngoog.html.SafeScript \x3d function() {\n  /** @private @type {(!TrustedScript|string)} */ this.privateDoNotAccessOrElseSafeScriptWrappedValue_ \x3d \x22\x22;\n  /** @private @const @type {!Object} */ this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;\n};\n/** @const @override */ goog.html.SafeScript.prototype.implementsGoogStringTypedString \x3d true;\n/** @private @const @type {!Object} */ goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d {};\n/**\n * @param {!goog.string.Const} script\n * @return {!goog.html.SafeScript}\n */\ngoog.html.SafeScript.fromConstant \x3d function(script) {\n  var scriptString \x3d goog.string.Const.unwrap(script);\n  if (scriptString.length \x3d\x3d\x3d 0) {\n    return goog.html.SafeScript.EMPTY;\n  }\n  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(scriptString);\n};\n/**\n * @param {!goog.string.Const} code\n * @param {...*} var_args\n * @return {!goog.html.SafeScript}\n */\ngoog.html.SafeScript.fromConstantAndArgs \x3d function(code, var_args) {\n  var args \x3d [];\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    args.push(goog.html.SafeScript.stringify_(arguments[i]));\n  }\n  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(\x22(\x22 + goog.string.Const.unwrap(code) + \x22)(\x22 + args.join(\x22, \x22) + \x22);\x22);\n};\n/**\n * @param {*} val\n * @return {!goog.html.SafeScript}\n */\ngoog.html.SafeScript.fromJson \x3d function(val) {\n  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(goog.html.SafeScript.stringify_(val));\n};\n/** @override */ goog.html.SafeScript.prototype.getTypedStringValue \x3d function() {\n  return this.privateDoNotAccessOrElseSafeScriptWrappedValue_.toString();\n};\nif (goog.DEBUG) {\n  /** @override */ goog.html.SafeScript.prototype.toString \x3d function() {\n    return \x22SafeScript{\x22 + this.privateDoNotAccessOrElseSafeScriptWrappedValue_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.html.SafeScript} safeScript\n * @return {string}\n */\ngoog.html.SafeScript.unwrap \x3d function(safeScript) {\n  return goog.html.SafeScript.unwrapTrustedScript(safeScript).toString();\n};\n/**\n * @param {!goog.html.SafeScript} safeScript\n * @return {(!TrustedScript|string)}\n */\ngoog.html.SafeScript.unwrapTrustedScript \x3d function(safeScript) {\n  if (safeScript instanceof goog.html.SafeScript \x26\x26 safeScript.constructor \x3d\x3d\x3d goog.html.SafeScript \x26\x26 safeScript.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {\n    return safeScript.privateDoNotAccessOrElseSafeScriptWrappedValue_;\n  } else {\n    goog.asserts.fail(\x22expected object of type SafeScript, got \x27\x22 + safeScript + \x22\x27 of type \x22 + goog.typeOf(safeScript));\n    return \x22type_error:SafeScript\x22;\n  }\n};\n/**\n * @private\n * @param {*} val\n * @return {string}\n */\ngoog.html.SafeScript.stringify_ \x3d function(val) {\n  var json \x3d JSON.stringify(val);\n  return json.replace(/\x3c/g, \x22\\\\x3c\x22);\n};\n/**\n * @package\n * @param {string} script\n * @return {!goog.html.SafeScript}\n */\ngoog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse \x3d function(script) {\n  return (new goog.html.SafeScript).initSecurityPrivateDoNotAccessOrElse_(script);\n};\n/**\n * @private\n * @param {string} script\n * @return {!goog.html.SafeScript}\n */\ngoog.html.SafeScript.prototype.initSecurityPrivateDoNotAccessOrElse_ \x3d function(script) {\n  this.privateDoNotAccessOrElseSafeScriptWrappedValue_ \x3d goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY ? goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createScript(script) : script;\n  return this;\n};\n/** @const @type {!goog.html.SafeScript} */ goog.html.SafeScript.EMPTY \x3d goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(\x22\x22);\n");
SHADOW_ENV.evalLoad("goog.fs.url.js", true , "goog.provide(\x22goog.fs.url\x22);\n/**\n * @param {!Blob} blob\n * @return {string}\n */\ngoog.fs.url.createObjectUrl \x3d function(blob) {\n  return goog.fs.url.getUrlObject_().createObjectURL(blob);\n};\n/**\n * @param {string} url\n */\ngoog.fs.url.revokeObjectUrl \x3d function(url) {\n  goog.fs.url.getUrlObject_().revokeObjectURL(url);\n};\n/** @typedef {{createObjectURL:function(!Blob):string,revokeObjectURL:function(string):void}} */ goog.fs.url.UrlObject_;\n/**\n * @private\n * @return {goog.fs.url.UrlObject_}\n */\ngoog.fs.url.getUrlObject_ \x3d function() {\n  /** @const */ var urlObject \x3d goog.fs.url.findUrlObject_();\n  if (urlObject !\x3d null) {\n    return urlObject;\n  } else {\n    throw new Error(\x22This browser doesn\x27t seem to support blob URLs\x22);\n  }\n};\n/**\n * @private\n * @return {?goog.fs.url.UrlObject_}\n */\ngoog.fs.url.findUrlObject_ \x3d function() {\n  if (goog.global.URL !\x3d\x3d undefined \x26\x26 goog.global.URL.createObjectURL !\x3d\x3d undefined) {\n    return (/** @type {goog.fs.url.UrlObject_} */ (goog.global.URL));\n  } else {\n    if (goog.global.webkitURL !\x3d\x3d undefined \x26\x26 goog.global.webkitURL.createObjectURL !\x3d\x3d undefined) {\n      return (/** @type {goog.fs.url.UrlObject_} */ (goog.global.webkitURL));\n    } else {\n      if (goog.global.createObjectURL !\x3d\x3d undefined) {\n        return (/** @type {goog.fs.url.UrlObject_} */ (goog.global));\n      } else {\n        return null;\n      }\n    }\n  }\n};\n/**\n * @return {boolean}\n */\ngoog.fs.url.browserSupportsObjectUrls \x3d function() {\n  return goog.fs.url.findUrlObject_() !\x3d null;\n};\n");
SHADOW_ENV.evalLoad("goog.i18n.bidi.js", true , "goog.provide(\x22goog.i18n.bidi\x22);\ngoog.provide(\x22goog.i18n.bidi.Dir\x22);\ngoog.provide(\x22goog.i18n.bidi.DirectionalString\x22);\ngoog.provide(\x22goog.i18n.bidi.Format\x22);\n/** @define {boolean} */ goog.i18n.bidi.FORCE_RTL \x3d goog.define(\x22goog.i18n.bidi.FORCE_RTL\x22, false);\n/** @type {boolean} */ goog.i18n.bidi.IS_RTL \x3d goog.i18n.bidi.FORCE_RTL || (goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22ar\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22fa\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22he\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22iw\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22ps\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22sd\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22ug\x22 || goog.LOCALE.substring(0, 2).toLowerCase() \x3d\x3d \x22ur\x22 || goog.LOCALE.substring(0, \n2).toLowerCase() \x3d\x3d \x22yi\x22) \x26\x26 (goog.LOCALE.length \x3d\x3d 2 || goog.LOCALE.substring(2, 3) \x3d\x3d \x22-\x22 || goog.LOCALE.substring(2, 3) \x3d\x3d \x22_\x22) || goog.LOCALE.length \x3e\x3d 3 \x26\x26 goog.LOCALE.substring(0, 3).toLowerCase() \x3d\x3d \x22ckb\x22 \x26\x26 (goog.LOCALE.length \x3d\x3d 3 || goog.LOCALE.substring(3, 4) \x3d\x3d \x22-\x22 || goog.LOCALE.substring(3, 4) \x3d\x3d \x22_\x22) || goog.LOCALE.length \x3e\x3d 7 \x26\x26 ((goog.LOCALE.substring(2, 3) \x3d\x3d \x22-\x22 || goog.LOCALE.substring(2, 3) \x3d\x3d \x22_\x22) \x26\x26 (goog.LOCALE.substring(3, 7).toLowerCase() \x3d\x3d \x22adlm\x22 || goog.LOCALE.substring(3, \n7).toLowerCase() \x3d\x3d \x22arab\x22 || goog.LOCALE.substring(3, 7).toLowerCase() \x3d\x3d \x22hebr\x22 || goog.LOCALE.substring(3, 7).toLowerCase() \x3d\x3d \x22nkoo\x22 || goog.LOCALE.substring(3, 7).toLowerCase() \x3d\x3d \x22rohg\x22 || goog.LOCALE.substring(3, 7).toLowerCase() \x3d\x3d \x22thaa\x22)) || goog.LOCALE.length \x3e\x3d 8 \x26\x26 ((goog.LOCALE.substring(3, 4) \x3d\x3d \x22-\x22 || goog.LOCALE.substring(3, 4) \x3d\x3d \x22_\x22) \x26\x26 (goog.LOCALE.substring(4, 8).toLowerCase() \x3d\x3d \x22adlm\x22 || goog.LOCALE.substring(4, 8).toLowerCase() \x3d\x3d \x22arab\x22 || goog.LOCALE.substring(4, 8).toLowerCase() \x3d\x3d \n\x22hebr\x22 || goog.LOCALE.substring(4, 8).toLowerCase() \x3d\x3d \x22nkoo\x22 || goog.LOCALE.substring(4, 8).toLowerCase() \x3d\x3d \x22rohg\x22 || goog.LOCALE.substring(4, 8).toLowerCase() \x3d\x3d \x22thaa\x22));\n/** @enum {string} */ goog.i18n.bidi.Format \x3d {LRE:\x22\u202a\x22, RLE:\x22\u202b\x22, PDF:\x22\u202c\x22, LRM:\x22\u200e\x22, RLM:\x22\u200f\x22};\n/** @enum {number} */ goog.i18n.bidi.Dir \x3d {LTR:1, RTL:-1, NEUTRAL:0};\n/** @type {string} */ goog.i18n.bidi.RIGHT \x3d \x22right\x22;\n/** @type {string} */ goog.i18n.bidi.LEFT \x3d \x22left\x22;\n/** @type {string} */ goog.i18n.bidi.I18N_RIGHT \x3d goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.LEFT : goog.i18n.bidi.RIGHT;\n/** @type {string} */ goog.i18n.bidi.I18N_LEFT \x3d goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;\n/**\n * @param {(goog.i18n.bidi.Dir|number|boolean|null)} givenDir\n * @param {boolean\x3d} opt_noNeutral\n * @return {?goog.i18n.bidi.Dir}\n */\ngoog.i18n.bidi.toDir \x3d function(givenDir, opt_noNeutral) {\n  if (typeof givenDir \x3d\x3d \x22number\x22) {\n    return givenDir \x3e 0 ? goog.i18n.bidi.Dir.LTR : givenDir \x3c 0 ? goog.i18n.bidi.Dir.RTL : opt_noNeutral ? null : goog.i18n.bidi.Dir.NEUTRAL;\n  } else {\n    if (givenDir \x3d\x3d null) {\n      return null;\n    } else {\n      return givenDir ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;\n    }\n  }\n};\n/** @private @type {string} */ goog.i18n.bidi.ltrChars_ \x3d \x22A-Za-z\xc0-\xd6\xd8-\xf6\xf8-\u02b8\u0300-\u0590\u0900-\u1fff\x22 + \x22\u200e\u2c00-\\ud801\\ud804-\\ud839\\ud83c-\\udbff\x22 + \x22\uf900-\ufb1c\ufe00-\ufe6f\ufefd-\uffff\x22;\n/** @private @type {string} */ goog.i18n.bidi.rtlChars_ \x3d \x22\u0591-\u06ef\u06fa-\u08ff\u200f\\ud802-\\ud803\\ud83a-\\ud83b\x22 + \x22\ufb1d-\ufdff\ufe70-\ufefc\x22;\n/** @private @type {RegExp} */ goog.i18n.bidi.htmlSkipReg_ \x3d /\x3c[^\x3e]*\x3e|\x26[^;]+;/g;\n/**\n * @private\n * @param {string} str\n * @param {boolean\x3d} opt_isStripNeeded\n * @return {string}\n */\ngoog.i18n.bidi.stripHtmlIfNeeded_ \x3d function(str, opt_isStripNeeded) {\n  return opt_isStripNeeded ? str.replace(goog.i18n.bidi.htmlSkipReg_, \x22\x22) : str;\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.rtlCharReg_ \x3d new RegExp(\x22[\x22 + goog.i18n.bidi.rtlChars_ + \x22]\x22);\n/** @private @type {RegExp} */ goog.i18n.bidi.ltrCharReg_ \x3d new RegExp(\x22[\x22 + goog.i18n.bidi.ltrChars_ + \x22]\x22);\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.hasAnyRtl \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));\n};\n/**\n * @param {string} str\n * @return {boolean}\n * @deprecated Use hasAnyRtl.\n */\ngoog.i18n.bidi.hasRtlChar \x3d goog.i18n.bidi.hasAnyRtl;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.hasAnyLtr \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.ltrRe_ \x3d new RegExp(\x22^[\x22 + goog.i18n.bidi.ltrChars_ + \x22]\x22);\n/** @private @type {RegExp} */ goog.i18n.bidi.rtlRe_ \x3d new RegExp(\x22^[\x22 + goog.i18n.bidi.rtlChars_ + \x22]\x22);\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.i18n.bidi.isRtlChar \x3d function(str) {\n  return goog.i18n.bidi.rtlRe_.test(str);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.i18n.bidi.isLtrChar \x3d function(str) {\n  return goog.i18n.bidi.ltrRe_.test(str);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.i18n.bidi.isNeutralChar \x3d function(str) {\n  return !goog.i18n.bidi.isLtrChar(str) \x26\x26 !goog.i18n.bidi.isRtlChar(str);\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.ltrDirCheckRe_ \x3d new RegExp(\x22^[^\x22 + goog.i18n.bidi.rtlChars_ + \x22]*[\x22 + goog.i18n.bidi.ltrChars_ + \x22]\x22);\n/** @private @type {RegExp} */ goog.i18n.bidi.rtlDirCheckRe_ \x3d new RegExp(\x22^[^\x22 + goog.i18n.bidi.ltrChars_ + \x22]*[\x22 + goog.i18n.bidi.rtlChars_ + \x22]\x22);\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.startsWithRtl \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n * @deprecated Use startsWithRtl.\n */\ngoog.i18n.bidi.isRtlText \x3d goog.i18n.bidi.startsWithRtl;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.startsWithLtr \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n * @deprecated Use startsWithLtr.\n */\ngoog.i18n.bidi.isLtrText \x3d goog.i18n.bidi.startsWithLtr;\n/** @private @type {RegExp} */ goog.i18n.bidi.isRequiredLtrRe_ \x3d /^http:\\/\\/.*/;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.isNeutralText \x3d function(str, opt_isHtml) {\n  str \x3d goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml);\n  return goog.i18n.bidi.isRequiredLtrRe_.test(str) || !goog.i18n.bidi.hasAnyLtr(str) \x26\x26 !goog.i18n.bidi.hasAnyRtl(str);\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.ltrExitDirCheckRe_ \x3d new RegExp(\x22[\x22 + goog.i18n.bidi.ltrChars_ + \x22]\x22 + \x22[^\x22 + goog.i18n.bidi.rtlChars_ + \x22]*$\x22);\n/** @private @type {RegExp} */ goog.i18n.bidi.rtlExitDirCheckRe_ \x3d new RegExp(\x22[\x22 + goog.i18n.bidi.rtlChars_ + \x22]\x22 + \x22[^\x22 + goog.i18n.bidi.ltrChars_ + \x22]*$\x22);\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.endsWithLtr \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.ltrExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n * @deprecated Use endsWithLtr.\n */\ngoog.i18n.bidi.isLtrExitText \x3d goog.i18n.bidi.endsWithLtr;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.endsWithRtl \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.rtlExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n * @deprecated Use endsWithRtl.\n */\ngoog.i18n.bidi.isRtlExitText \x3d goog.i18n.bidi.endsWithRtl;\n/** @private @type {!RegExp} */ goog.i18n.bidi.rtlLocalesRe_ \x3d new RegExp(\x22^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|\x22 + \x22.*[-_](Adlm|Arab|Hebr|Nkoo|Rohg|Thaa))\x22 + \x22(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)\x22, \x22i\x22);\n/**\n * @param {string} lang\n * @return {boolean}\n */\ngoog.i18n.bidi.isRtlLanguage \x3d function(lang) {\n  return goog.i18n.bidi.rtlLocalesRe_.test(lang);\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.bracketGuardTextRe_ \x3d /(\\(.*?\\)+)|(\\[.*?\\]+)|(\\{.*?\\}+)|(\x3c.*?\x3e+)/g;\n/**\n * @param {string} s\n * @param {boolean\x3d} opt_isRtlContext\n * @return {string}\n */\ngoog.i18n.bidi.guardBracketInText \x3d function(s, opt_isRtlContext) {\n  /** @const */ var useRtl \x3d opt_isRtlContext \x3d\x3d\x3d undefined ? goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext;\n  /** @const */ var mark \x3d useRtl ? goog.i18n.bidi.Format.RLM : goog.i18n.bidi.Format.LRM;\n  return s.replace(goog.i18n.bidi.bracketGuardTextRe_, mark + \x22$\\x26\x22 + mark);\n};\n/**\n * @param {string} html\n * @return {string}\n */\ngoog.i18n.bidi.enforceRtlInHtml \x3d function(html) {\n  if (html.charAt(0) \x3d\x3d \x22\\x3c\x22) {\n    return html.replace(/\x3c\\w+/, \x22$\\x26 dir\\x3drtl\x22);\n  }\n  return \x22\\n\\x3cspan dir\\x3drtl\\x3e\x22 + html + \x22\\x3c/span\\x3e\x22;\n};\n/**\n * @param {string} text\n * @return {string}\n */\ngoog.i18n.bidi.enforceRtlInText \x3d function(text) {\n  return goog.i18n.bidi.Format.RLE + text + goog.i18n.bidi.Format.PDF;\n};\n/**\n * @param {string} html\n * @return {string}\n */\ngoog.i18n.bidi.enforceLtrInHtml \x3d function(html) {\n  if (html.charAt(0) \x3d\x3d \x22\\x3c\x22) {\n    return html.replace(/\x3c\\w+/, \x22$\\x26 dir\\x3dltr\x22);\n  }\n  return \x22\\n\\x3cspan dir\\x3dltr\\x3e\x22 + html + \x22\\x3c/span\\x3e\x22;\n};\n/**\n * @param {string} text\n * @return {string}\n */\ngoog.i18n.bidi.enforceLtrInText \x3d function(text) {\n  return goog.i18n.bidi.Format.LRE + text + goog.i18n.bidi.Format.PDF;\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.dimensionsRe_ \x3d /:\\s*([.\\d][.\\w]*)\\s+([.\\d][.\\w]*)\\s+([.\\d][.\\w]*)\\s+([.\\d][.\\w]*)/g;\n/** @private @type {RegExp} */ goog.i18n.bidi.leftRe_ \x3d /left/gi;\n/** @private @type {RegExp} */ goog.i18n.bidi.rightRe_ \x3d /right/gi;\n/** @private @type {RegExp} */ goog.i18n.bidi.tempRe_ \x3d /%%%%/g;\n/**\n * @param {string} cssStr\n * @return {string}\n */\ngoog.i18n.bidi.mirrorCSS \x3d function(cssStr) {\n  return cssStr.replace(goog.i18n.bidi.dimensionsRe_, \x22:$1 $4 $3 $2\x22).replace(goog.i18n.bidi.leftRe_, \x22%%%%\x22).replace(goog.i18n.bidi.rightRe_, goog.i18n.bidi.LEFT).replace(goog.i18n.bidi.tempRe_, goog.i18n.bidi.RIGHT);\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.doubleQuoteSubstituteRe_ \x3d /([\\u0591-\\u05f2])\x22/g;\n/** @private @type {RegExp} */ goog.i18n.bidi.singleQuoteSubstituteRe_ \x3d /([\\u0591-\\u05f2])\x27/g;\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.i18n.bidi.normalizeHebrewQuote \x3d function(str) {\n  return str.replace(goog.i18n.bidi.doubleQuoteSubstituteRe_, \x22$1\u05f4\x22).replace(goog.i18n.bidi.singleQuoteSubstituteRe_, \x22$1\u05f3\x22);\n};\n/** @private @type {RegExp} */ goog.i18n.bidi.wordSeparatorRe_ \x3d /\\s+/;\n/** @private @type {RegExp} */ goog.i18n.bidi.hasNumeralsRe_ \x3d /[\\d\\u06f0-\\u06f9]/;\n/** @private @type {number} */ goog.i18n.bidi.rtlDetectionThreshold_ \x3d 0.40;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {goog.i18n.bidi.Dir}\n */\ngoog.i18n.bidi.estimateDirection \x3d function(str, opt_isHtml) {\n  var rtlCount \x3d 0;\n  var totalCount \x3d 0;\n  var hasWeaklyLtr \x3d false;\n  /** @const */ var tokens \x3d goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml).split(goog.i18n.bidi.wordSeparatorRe_);\n  for (var i \x3d 0; i \x3c tokens.length; i++) {\n    /** @const */ var token \x3d tokens[i];\n    if (goog.i18n.bidi.startsWithRtl(token)) {\n      rtlCount++;\n      totalCount++;\n    } else {\n      if (goog.i18n.bidi.isRequiredLtrRe_.test(token)) {\n        hasWeaklyLtr \x3d true;\n      } else {\n        if (goog.i18n.bidi.hasAnyLtr(token)) {\n          totalCount++;\n        } else {\n          if (goog.i18n.bidi.hasNumeralsRe_.test(token)) {\n            hasWeaklyLtr \x3d true;\n          }\n        }\n      }\n    }\n  }\n  return totalCount \x3d\x3d 0 ? hasWeaklyLtr ? goog.i18n.bidi.Dir.LTR : goog.i18n.bidi.Dir.NEUTRAL : rtlCount / totalCount \x3e goog.i18n.bidi.rtlDetectionThreshold_ ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isHtml\n * @return {boolean}\n */\ngoog.i18n.bidi.detectRtlDirectionality \x3d function(str, opt_isHtml) {\n  return goog.i18n.bidi.estimateDirection(str, opt_isHtml) \x3d\x3d goog.i18n.bidi.Dir.RTL;\n};\n/**\n * @param {Element} element\n * @param {(goog.i18n.bidi.Dir|number|boolean|null)} dir\n */\ngoog.i18n.bidi.setElementDirAndAlign \x3d function(element, dir) {\n  if (element) {\n    /** @const */ var htmlElement \x3d /** @type {!HTMLElement} */ (element);\n    dir \x3d goog.i18n.bidi.toDir(dir);\n    if (dir) {\n      htmlElement.style.textAlign \x3d dir \x3d\x3d goog.i18n.bidi.Dir.RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;\n      htmlElement.dir \x3d dir \x3d\x3d goog.i18n.bidi.Dir.RTL ? \x22rtl\x22 : \x22ltr\x22;\n    }\n  }\n};\n/**\n * @param {!Element} element\n * @param {string} text\n */\ngoog.i18n.bidi.setElementDirByTextDirectionality \x3d function(element, text) {\n  /** @const */ var htmlElement \x3d /** @type {!HTMLElement} */ (element);\n  switch(goog.i18n.bidi.estimateDirection(text)) {\n    case goog.i18n.bidi.Dir.LTR:\n      htmlElement.dir \x3d \x22ltr\x22;\n      break;\n    case goog.i18n.bidi.Dir.RTL:\n      htmlElement.dir \x3d \x22rtl\x22;\n      break;\n    default:\n      htmlElement.removeAttribute(\x22dir\x22);\n  }\n};\n/** @interface */ goog.i18n.bidi.DirectionalString \x3d function() {\n};\n/** @type {boolean} */ goog.i18n.bidi.DirectionalString.prototype.implementsGoogI18nBidiDirectionalString;\n/**\n * @return {?goog.i18n.bidi.Dir}\n */\ngoog.i18n.bidi.DirectionalString.prototype.getDirection;\n");
SHADOW_ENV.evalLoad("goog.html.trustedresourceurl.js", true , "goog.provide(\x22goog.html.TrustedResourceUrl\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.html.trustedtypes\x22);\ngoog.require(\x22goog.i18n.bidi.Dir\x22);\ngoog.require(\x22goog.i18n.bidi.DirectionalString\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.TypedString\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.i18n.bidi.DirectionalString}\n * @implements {goog.string.TypedString}\n * @param {!Object\x3d} opt_token\n * @param {(!TrustedScriptURL|string)\x3d} opt_content\n */\ngoog.html.TrustedResourceUrl \x3d function(opt_token, opt_content) {\n  /** @private @const @type {(!TrustedScriptURL|string)} */ this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ \x3d opt_token \x3d\x3d\x3d goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_ \x26\x26 opt_content || \x22\x22;\n  /** @private @const @type {!Object} */ this.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;\n};\n/** @const @override */ goog.html.TrustedResourceUrl.prototype.implementsGoogStringTypedString \x3d true;\n/** @override */ goog.html.TrustedResourceUrl.prototype.getTypedStringValue \x3d function() {\n  return this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_.toString();\n};\n/** @const @override */ goog.html.TrustedResourceUrl.prototype.implementsGoogI18nBidiDirectionalString \x3d true;\n/** @override */ goog.html.TrustedResourceUrl.prototype.getDirection \x3d function() {\n  return goog.i18n.bidi.Dir.LTR;\n};\n/**\n * @param {(string|?Object\x3cstring,*\x3e|undefined)} searchParams\n * @param {(string|?Object\x3cstring,*\x3e)\x3d} opt_hashParams\n * @return {!goog.html.TrustedResourceUrl}\n */\ngoog.html.TrustedResourceUrl.prototype.cloneWithParams \x3d function(searchParams, opt_hashParams) {\n  var url \x3d goog.html.TrustedResourceUrl.unwrap(this);\n  var parts \x3d goog.html.TrustedResourceUrl.URL_PARAM_PARSER_.exec(url);\n  var urlBase \x3d parts[1];\n  var urlSearch \x3d parts[2] || \x22\x22;\n  var urlHash \x3d parts[3] || \x22\x22;\n  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(urlBase + goog.html.TrustedResourceUrl.stringifyParams_(\x22?\x22, urlSearch, searchParams) + goog.html.TrustedResourceUrl.stringifyParams_(\x22#\x22, urlHash, opt_hashParams));\n};\nif (goog.DEBUG) {\n  /** @override */ goog.html.TrustedResourceUrl.prototype.toString \x3d function() {\n    return \x22TrustedResourceUrl{\x22 + this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.html.TrustedResourceUrl} trustedResourceUrl\n * @return {string}\n */\ngoog.html.TrustedResourceUrl.unwrap \x3d function(trustedResourceUrl) {\n  return goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(trustedResourceUrl).toString();\n};\n/**\n * @param {!goog.html.TrustedResourceUrl} trustedResourceUrl\n * @return {(!TrustedScriptURL|string)}\n */\ngoog.html.TrustedResourceUrl.unwrapTrustedScriptURL \x3d function(trustedResourceUrl) {\n  if (trustedResourceUrl instanceof goog.html.TrustedResourceUrl \x26\x26 trustedResourceUrl.constructor \x3d\x3d\x3d goog.html.TrustedResourceUrl \x26\x26 trustedResourceUrl.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {\n    return trustedResourceUrl.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_;\n  } else {\n    goog.asserts.fail(\x22expected object of type TrustedResourceUrl, got \x27\x22 + trustedResourceUrl + \x22\x27 of type \x22 + goog.typeOf(trustedResourceUrl));\n    return \x22type_error:TrustedResourceUrl\x22;\n  }\n};\n/**\n * @param {!goog.string.Const} format\n * @param {!Object\x3cstring,(string|number|!goog.string.Const)\x3e} args\n * @return {!goog.html.TrustedResourceUrl}\n * @throws {!Error}\n */\ngoog.html.TrustedResourceUrl.format \x3d function(format, args) {\n  var formatStr \x3d goog.string.Const.unwrap(format);\n  if (!goog.html.TrustedResourceUrl.BASE_URL_.test(formatStr)) {\n    throw new Error(\x22Invalid TrustedResourceUrl format: \x22 + formatStr);\n  }\n  var result \x3d formatStr.replace(goog.html.TrustedResourceUrl.FORMAT_MARKER_, function(match, id) {\n    if (!Object.prototype.hasOwnProperty.call(args, id)) {\n      throw new Error(\x27Found marker, \x22\x27 + id + \x27\x22, in format string, \x22\x27 + formatStr + \x27\x22, but no valid label mapping found \x27 + \x22in args: \x22 + JSON.stringify(args));\n    }\n    var arg \x3d args[id];\n    if (arg instanceof goog.string.Const) {\n      return goog.string.Const.unwrap(arg);\n    } else {\n      return encodeURIComponent(String(arg));\n    }\n  });\n  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(result);\n};\n/** @private @const @type {!RegExp} */ goog.html.TrustedResourceUrl.FORMAT_MARKER_ \x3d /%{(\\w+)}/g;\n/** @private @const @type {!RegExp} */ goog.html.TrustedResourceUrl.BASE_URL_ \x3d new RegExp(\x22^((https:)?//[0-9a-z.:[\\\\]-]+/\x22 + \x22|/[^/\\\\\\\\]\x22 + \x22|[^:/\\\\\\\\%]+/\x22 + \x22|[^:/\\\\\\\\%]*[?#]\x22 + \x22|about:blank#\x22 + \x22)\x22, \x22i\x22);\n/** @private @const @type {!RegExp} */ goog.html.TrustedResourceUrl.URL_PARAM_PARSER_ \x3d /^([^?#]*)(\\?[^#]*)?(#[\\s\\S]*)?/;\n/**\n * @param {!goog.string.Const} format\n * @param {!Object\x3cstring,(string|number|!goog.string.Const)\x3e} args\n * @param {(string|?Object\x3cstring,*\x3e|undefined)} searchParams\n * @param {(string|?Object\x3cstring,*\x3e)\x3d} opt_hashParams\n * @return {!goog.html.TrustedResourceUrl}\n * @throws {!Error}\n */\ngoog.html.TrustedResourceUrl.formatWithParams \x3d function(format, args, searchParams, opt_hashParams) {\n  var url \x3d goog.html.TrustedResourceUrl.format(format, args);\n  return url.cloneWithParams(searchParams, opt_hashParams);\n};\n/**\n * @param {!goog.string.Const} url\n * @return {!goog.html.TrustedResourceUrl}\n */\ngoog.html.TrustedResourceUrl.fromConstant \x3d function(url) {\n  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(url));\n};\n/**\n * @param {!Array\x3c!goog.string.Const\x3e} parts\n * @return {!goog.html.TrustedResourceUrl}\n */\ngoog.html.TrustedResourceUrl.fromConstants \x3d function(parts) {\n  var unwrapped \x3d \x22\x22;\n  for (var i \x3d 0; i \x3c parts.length; i++) {\n    unwrapped +\x3d goog.string.Const.unwrap(parts[i]);\n  }\n  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(unwrapped);\n};\n/** @private @const @type {!Object} */ goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d {};\n/**\n * @package\n * @param {string} url\n * @return {!goog.html.TrustedResourceUrl}\n */\ngoog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse \x3d function(url) {\n  var value \x3d goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY ? goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createScriptURL(url) : url;\n  return new goog.html.TrustedResourceUrl(goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_, value);\n};\n/**\n * @private\n * @param {string} prefix\n * @param {string} currentString\n * @param {(string|?Object\x3cstring,*\x3e|undefined)} params\n * @return {string}\n */\ngoog.html.TrustedResourceUrl.stringifyParams_ \x3d function(prefix, currentString, params) {\n  if (params \x3d\x3d null) {\n    return currentString;\n  }\n  if (typeof params \x3d\x3d\x3d \x22string\x22) {\n    return params ? prefix + encodeURIComponent(params) : \x22\x22;\n  }\n  for (var key in params) {\n    var value \x3d params[key];\n    var outputValues \x3d goog.isArray(value) ? value : [value];\n    for (var i \x3d 0; i \x3c outputValues.length; i++) {\n      var outputValue \x3d outputValues[i];\n      if (outputValue !\x3d null) {\n        if (!currentString) {\n          currentString \x3d prefix;\n        }\n        currentString +\x3d (currentString.length \x3e prefix.length ? \x22\\x26\x22 : \x22\x22) + encodeURIComponent(key) + \x22\\x3d\x22 + encodeURIComponent(String(outputValue));\n      }\n    }\n  }\n  return currentString;\n};\n/** @private @const @type {!Object} */ goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_ \x3d {};\n");
SHADOW_ENV.evalLoad("goog.string.internal.js", true , "goog.provide(\x22goog.string.internal\x22);\n/**\n * @param {string} str\n * @param {string} prefix\n * @return {boolean}\n */\ngoog.string.internal.startsWith \x3d function(str, prefix) {\n  return str.lastIndexOf(prefix, 0) \x3d\x3d 0;\n};\n/**\n * @param {string} str\n * @param {string} suffix\n * @return {boolean}\n */\ngoog.string.internal.endsWith \x3d function(str, suffix) {\n  /** @const */ var l \x3d str.length - suffix.length;\n  return l \x3e\x3d 0 \x26\x26 str.indexOf(suffix, l) \x3d\x3d l;\n};\n/**\n * @param {string} str\n * @param {string} prefix\n * @return {boolean}\n */\ngoog.string.internal.caseInsensitiveStartsWith \x3d function(str, prefix) {\n  return goog.string.internal.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) \x3d\x3d 0;\n};\n/**\n * @param {string} str\n * @param {string} suffix\n * @return {boolean}\n */\ngoog.string.internal.caseInsensitiveEndsWith \x3d function(str, suffix) {\n  return goog.string.internal.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) \x3d\x3d 0;\n};\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {boolean}\n */\ngoog.string.internal.caseInsensitiveEquals \x3d function(str1, str2) {\n  return str1.toLowerCase() \x3d\x3d str2.toLowerCase();\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.internal.isEmptyOrWhitespace \x3d function(str) {\n  return /^[\\s\\xa0]*$/.test(str);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.internal.trim \x3d goog.TRUSTED_SITE \x26\x26 String.prototype.trim ? function(str) {\n  return str.trim();\n} : function(str) {\n  return /^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(str)[1];\n};\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {number}\n */\ngoog.string.internal.caseInsensitiveCompare \x3d function(str1, str2) {\n  /** @const */ var test1 \x3d String(str1).toLowerCase();\n  /** @const */ var test2 \x3d String(str2).toLowerCase();\n  if (test1 \x3c test2) {\n    return -1;\n  } else {\n    if (test1 \x3d\x3d test2) {\n      return 0;\n    } else {\n      return 1;\n    }\n  }\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_xml\n * @return {string}\n */\ngoog.string.internal.newLineToBr \x3d function(str, opt_xml) {\n  return str.replace(/(\\r\\n|\\r|\\n)/g, opt_xml ? \x22\\x3cbr /\\x3e\x22 : \x22\\x3cbr\\x3e\x22);\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isLikelyToContainHtmlChars\n * @return {string}\n */\ngoog.string.internal.htmlEscape \x3d function(str, opt_isLikelyToContainHtmlChars) {\n  if (opt_isLikelyToContainHtmlChars) {\n    str \x3d str.replace(goog.string.internal.AMP_RE_, \x22\\x26amp;\x22).replace(goog.string.internal.LT_RE_, \x22\\x26lt;\x22).replace(goog.string.internal.GT_RE_, \x22\\x26gt;\x22).replace(goog.string.internal.QUOT_RE_, \x22\\x26quot;\x22).replace(goog.string.internal.SINGLE_QUOTE_RE_, \x22\\x26#39;\x22).replace(goog.string.internal.NULL_RE_, \x22\\x26#0;\x22);\n    return str;\n  } else {\n    if (!goog.string.internal.ALL_RE_.test(str)) {\n      return str;\n    }\n    if (str.indexOf(\x22\\x26\x22) !\x3d -1) {\n      str \x3d str.replace(goog.string.internal.AMP_RE_, \x22\\x26amp;\x22);\n    }\n    if (str.indexOf(\x22\\x3c\x22) !\x3d -1) {\n      str \x3d str.replace(goog.string.internal.LT_RE_, \x22\\x26lt;\x22);\n    }\n    if (str.indexOf(\x22\\x3e\x22) !\x3d -1) {\n      str \x3d str.replace(goog.string.internal.GT_RE_, \x22\\x26gt;\x22);\n    }\n    if (str.indexOf(\x27\x22\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.internal.QUOT_RE_, \x22\\x26quot;\x22);\n    }\n    if (str.indexOf(\x22\x27\x22) !\x3d -1) {\n      str \x3d str.replace(goog.string.internal.SINGLE_QUOTE_RE_, \x22\\x26#39;\x22);\n    }\n    if (str.indexOf(\x22\\x00\x22) !\x3d -1) {\n      str \x3d str.replace(goog.string.internal.NULL_RE_, \x22\\x26#0;\x22);\n    }\n    return str;\n  }\n};\n/** @private @const @type {!RegExp} */ goog.string.internal.AMP_RE_ \x3d /\x26/g;\n/** @private @const @type {!RegExp} */ goog.string.internal.LT_RE_ \x3d /\x3c/g;\n/** @private @const @type {!RegExp} */ goog.string.internal.GT_RE_ \x3d /\x3e/g;\n/** @private @const @type {!RegExp} */ goog.string.internal.QUOT_RE_ \x3d /\x22/g;\n/** @private @const @type {!RegExp} */ goog.string.internal.SINGLE_QUOTE_RE_ \x3d /\x27/g;\n/** @private @const @type {!RegExp} */ goog.string.internal.NULL_RE_ \x3d /\\x00/g;\n/** @private @const @type {!RegExp} */ goog.string.internal.ALL_RE_ \x3d /[\\x00\x26\x3c\x3e\x22\x27]/;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_xml\n * @return {string}\n */\ngoog.string.internal.whitespaceEscape \x3d function(str, opt_xml) {\n  return goog.string.internal.newLineToBr(str.replace(/  /g, \x22 \\x26#160;\x22), opt_xml);\n};\n/**\n * @param {string} str\n * @param {string} subString\n * @return {boolean}\n */\ngoog.string.internal.contains \x3d function(str, subString) {\n  return str.indexOf(subString) !\x3d -1;\n};\n/**\n * @param {string} str\n * @param {string} subString\n * @return {boolean}\n */\ngoog.string.internal.caseInsensitiveContains \x3d function(str, subString) {\n  return goog.string.internal.contains(str.toLowerCase(), subString.toLowerCase());\n};\n/**\n * @param {(string|number)} version1\n * @param {(string|number)} version2\n * @return {number}\n */\ngoog.string.internal.compareVersions \x3d function(version1, version2) {\n  var order \x3d 0;\n  /** @const */ var v1Subs \x3d goog.string.internal.trim(String(version1)).split(\x22.\x22);\n  /** @const */ var v2Subs \x3d goog.string.internal.trim(String(version2)).split(\x22.\x22);\n  /** @const */ var subCount \x3d Math.max(v1Subs.length, v2Subs.length);\n  for (var subIdx \x3d 0; order \x3d\x3d 0 \x26\x26 subIdx \x3c subCount; subIdx++) {\n    var v1Sub \x3d v1Subs[subIdx] || \x22\x22;\n    var v2Sub \x3d v2Subs[subIdx] || \x22\x22;\n    do {\n      /** @const */ var v1Comp \x3d /(\\d*)(\\D*)(.*)/.exec(v1Sub) || [\x22\x22, \x22\x22, \x22\x22, \x22\x22];\n      /** @const */ var v2Comp \x3d /(\\d*)(\\D*)(.*)/.exec(v2Sub) || [\x22\x22, \x22\x22, \x22\x22, \x22\x22];\n      if (v1Comp[0].length \x3d\x3d 0 \x26\x26 v2Comp[0].length \x3d\x3d 0) {\n        break;\n      }\n      /** @const */ var v1CompNum \x3d v1Comp[1].length \x3d\x3d 0 ? 0 : parseInt(v1Comp[1], 10);\n      /** @const */ var v2CompNum \x3d v2Comp[1].length \x3d\x3d 0 ? 0 : parseInt(v2Comp[1], 10);\n      order \x3d goog.string.internal.compareElements_(v1CompNum, v2CompNum) || goog.string.internal.compareElements_(v1Comp[2].length \x3d\x3d 0, v2Comp[2].length \x3d\x3d 0) || goog.string.internal.compareElements_(v1Comp[2], v2Comp[2]);\n      v1Sub \x3d v1Comp[3];\n      v2Sub \x3d v2Comp[3];\n    } while (order \x3d\x3d 0);\n  }\n  return order;\n};\n/**\n * @private\n * @param {(string|number|boolean)} left\n * @param {(string|number|boolean)} right\n * @return {number}\n */\ngoog.string.internal.compareElements_ \x3d function(left, right) {\n  if (left \x3c right) {\n    return -1;\n  } else {\n    if (left \x3e right) {\n      return 1;\n    }\n  }\n  return 0;\n};\n");
SHADOW_ENV.evalLoad("goog.html.safeurl.js", true , "goog.provide(\x22goog.html.SafeUrl\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.fs.url\x22);\ngoog.require(\x22goog.html.TrustedResourceUrl\x22);\ngoog.require(\x22goog.i18n.bidi.Dir\x22);\ngoog.require(\x22goog.i18n.bidi.DirectionalString\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.TypedString\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.i18n.bidi.DirectionalString}\n * @implements {goog.string.TypedString}\n * @param {!Object\x3d} opt_token\n * @param {string\x3d} opt_content\n */\ngoog.html.SafeUrl \x3d function(opt_token, opt_content) {\n  /** @private @type {string} */ this.privateDoNotAccessOrElseSafeUrlWrappedValue_ \x3d opt_token \x3d\x3d\x3d goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_ \x26\x26 opt_content || \x22\x22;\n  /** @private @const @type {!Object} */ this.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;\n};\n/** @const @type {string} */ goog.html.SafeUrl.INNOCUOUS_STRING \x3d \x22about:invalid#zClosurez\x22;\n/** @const @override */ goog.html.SafeUrl.prototype.implementsGoogStringTypedString \x3d true;\n/** @override */ goog.html.SafeUrl.prototype.getTypedStringValue \x3d function() {\n  return this.privateDoNotAccessOrElseSafeUrlWrappedValue_.toString();\n};\n/** @const @override */ goog.html.SafeUrl.prototype.implementsGoogI18nBidiDirectionalString \x3d true;\n/** @override */ goog.html.SafeUrl.prototype.getDirection \x3d function() {\n  return goog.i18n.bidi.Dir.LTR;\n};\nif (goog.DEBUG) {\n  /** @override */ goog.html.SafeUrl.prototype.toString \x3d function() {\n    return \x22SafeUrl{\x22 + this.privateDoNotAccessOrElseSafeUrlWrappedValue_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.html.SafeUrl} safeUrl\n * @return {string}\n */\ngoog.html.SafeUrl.unwrap \x3d function(safeUrl) {\n  if (safeUrl instanceof goog.html.SafeUrl \x26\x26 safeUrl.constructor \x3d\x3d\x3d goog.html.SafeUrl \x26\x26 safeUrl.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {\n    return safeUrl.privateDoNotAccessOrElseSafeUrlWrappedValue_;\n  } else {\n    goog.asserts.fail(\x22expected object of type SafeUrl, got \x27\x22 + safeUrl + \x22\x27 of type \x22 + goog.typeOf(safeUrl));\n    return \x22type_error:SafeUrl\x22;\n  }\n};\n/**\n * @param {!goog.string.Const} url\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromConstant \x3d function(url) {\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(url));\n};\n/** @private @const */ goog.html.SAFE_MIME_TYPE_PATTERN_ \x3d new RegExp(\x22^(?:audio/(?:3gpp2|3gpp|aac|L16|midi|mp3|mp4|mpeg|oga|ogg|opus|x-m4a|x-wav|wav|webm)|\x22 + \x22image/(?:bmp|gif|jpeg|jpg|png|tiff|webp|x-icon)|\x22 + \x22text/csv|\x22 + \x22video/(?:mpeg|mp4|ogg|webm|quicktime))\x22 + \x27(?:;\\\\w+\\x3d(?:\\\\w+|\x22[\\\\w;\\x3d]+\x22))*$\x27, \x22i\x22);\n/**\n * @param {string} mimeType\n * @return {boolean}\n */\ngoog.html.SafeUrl.isSafeMimeType \x3d function(mimeType) {\n  return goog.html.SAFE_MIME_TYPE_PATTERN_.test(mimeType);\n};\n/**\n * @param {!Blob} blob\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromBlob \x3d function(blob) {\n  var url \x3d goog.html.SAFE_MIME_TYPE_PATTERN_.test(blob.type) ? goog.fs.url.createObjectUrl(blob) : goog.html.SafeUrl.INNOCUOUS_STRING;\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);\n};\n/** @private @const */ goog.html.DATA_URL_PATTERN_ \x3d /^data:([^,]*);base64,[a-z0-9+\\/]+\x3d*$/i;\n/**\n * @param {string} dataUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromDataUrl \x3d function(dataUrl) {\n  var filteredDataUrl \x3d dataUrl.replace(/(%0A|%0D)/g, \x22\x22);\n  var match \x3d filteredDataUrl.match(goog.html.DATA_URL_PATTERN_);\n  var valid \x3d match \x26\x26 goog.html.SAFE_MIME_TYPE_PATTERN_.test(match[1]);\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(valid ? filteredDataUrl : goog.html.SafeUrl.INNOCUOUS_STRING);\n};\n/**\n * @param {string} telUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromTelUrl \x3d function(telUrl) {\n  if (!goog.string.internal.caseInsensitiveStartsWith(telUrl, \x22tel:\x22)) {\n    telUrl \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(telUrl);\n};\n/** @private @const */ goog.html.SIP_URL_PATTERN_ \x3d new RegExp(\x22^sip[s]?:[+a-z0-9_.!$%\\x26\x27*\\\\/\\x3d^`{|}~-]+@([a-z0-9-]+\\\\.)+[a-z0-9]{2,63}$\x22, \x22i\x22);\n/**\n * @param {string} sipUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromSipUrl \x3d function(sipUrl) {\n  if (!goog.html.SIP_URL_PATTERN_.test(decodeURIComponent(sipUrl))) {\n    sipUrl \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(sipUrl);\n};\n/**\n * @param {string} facebookMessengerUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromFacebookMessengerUrl \x3d function(facebookMessengerUrl) {\n  if (!goog.string.internal.caseInsensitiveStartsWith(facebookMessengerUrl, \x22fb-messenger://share\x22)) {\n    facebookMessengerUrl \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(facebookMessengerUrl);\n};\n/**\n * @param {string} whatsAppUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromWhatsAppUrl \x3d function(whatsAppUrl) {\n  if (!goog.string.internal.caseInsensitiveStartsWith(whatsAppUrl, \x22whatsapp://send\x22)) {\n    whatsAppUrl \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(whatsAppUrl);\n};\n/**\n * @param {string} smsUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromSmsUrl \x3d function(smsUrl) {\n  if (!goog.string.internal.caseInsensitiveStartsWith(smsUrl, \x22sms:\x22) || !goog.html.SafeUrl.isSmsUrlBodyValid_(smsUrl)) {\n    smsUrl \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(smsUrl);\n};\n/**\n * @private\n * @param {string} smsUrl\n * @return {boolean}\n */\ngoog.html.SafeUrl.isSmsUrlBodyValid_ \x3d function(smsUrl) {\n  var hash \x3d smsUrl.indexOf(\x22#\x22);\n  if (hash \x3e 0) {\n    smsUrl \x3d smsUrl.substring(0, hash);\n  }\n  var bodyParams \x3d smsUrl.match(/[?\x26]body\x3d/gi);\n  if (!bodyParams) {\n    return true;\n  }\n  if (bodyParams.length \x3e 1) {\n    return false;\n  }\n  var bodyValue \x3d smsUrl.match(/[?\x26]body\x3d([^\x26]*)/)[1];\n  if (!bodyValue) {\n    return true;\n  }\n  try {\n    decodeURIComponent(bodyValue);\n  } catch (error) {\n    return false;\n  }\n  return /^(?:[a-z0-9\\-_.~]|%[0-9a-f]{2})+$/i.test(bodyValue);\n};\n/**\n * @param {string} sshUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromSshUrl \x3d function(sshUrl) {\n  if (!goog.string.internal.caseInsensitiveStartsWith(sshUrl, \x22ssh://\x22)) {\n    sshUrl \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(sshUrl);\n};\n/**\n * @param {string} url\n * @param {(!goog.string.Const|!Array\x3c!goog.string.Const\x3e)} extensionId\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.sanitizeChromeExtensionUrl \x3d function(url, extensionId) {\n  return goog.html.SafeUrl.sanitizeExtensionUrl_(/^chrome-extension:\\/\\/([^\\/]+)\\//, url, extensionId);\n};\n/**\n * @param {string} url\n * @param {(!goog.string.Const|!Array\x3c!goog.string.Const\x3e)} extensionId\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.sanitizeFirefoxExtensionUrl \x3d function(url, extensionId) {\n  return goog.html.SafeUrl.sanitizeExtensionUrl_(/^moz-extension:\\/\\/([^\\/]+)\\//, url, extensionId);\n};\n/**\n * @param {string} url\n * @param {(!goog.string.Const|!Array\x3c!goog.string.Const\x3e)} extensionId\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.sanitizeEdgeExtensionUrl \x3d function(url, extensionId) {\n  return goog.html.SafeUrl.sanitizeExtensionUrl_(/^ms-browser-extension:\\/\\/([^\\/]+)\\//, url, extensionId);\n};\n/**\n * @private\n * @param {!RegExp} scheme\n * @param {string} url\n * @param {(!goog.string.Const|!Array\x3c!goog.string.Const\x3e)} extensionId\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.sanitizeExtensionUrl_ \x3d function(scheme, url, extensionId) {\n  var matches \x3d scheme.exec(url);\n  if (!matches) {\n    url \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  } else {\n    var extractedExtensionId \x3d matches[1];\n    var acceptedExtensionIds;\n    if (extensionId instanceof goog.string.Const) {\n      acceptedExtensionIds \x3d [goog.string.Const.unwrap(extensionId)];\n    } else {\n      acceptedExtensionIds \x3d extensionId.map(function unwrap(x) {\n        return goog.string.Const.unwrap(x);\n      });\n    }\n    if (acceptedExtensionIds.indexOf(extractedExtensionId) \x3d\x3d -1) {\n      url \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n    }\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);\n};\n/**\n * @param {!goog.html.TrustedResourceUrl} trustedResourceUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.fromTrustedResourceUrl \x3d function(trustedResourceUrl) {\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.html.TrustedResourceUrl.unwrap(trustedResourceUrl));\n};\n/** @private @const @type {!RegExp} */ goog.html.SAFE_URL_PATTERN_ \x3d /^(?:(?:https?|mailto|ftp):|[^:/?#]*(?:[/?#]|$))/i;\n/** @const @type {!RegExp} */ goog.html.SafeUrl.SAFE_URL_PATTERN \x3d goog.html.SAFE_URL_PATTERN_;\n/**\n * @param {(string|!goog.string.TypedString)} url\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.sanitize \x3d function(url) {\n  if (url instanceof goog.html.SafeUrl) {\n    return url;\n  } else {\n    if (typeof url \x3d\x3d \x22object\x22 \x26\x26 url.implementsGoogStringTypedString) {\n      url \x3d /** @type {!goog.string.TypedString} */ (url).getTypedStringValue();\n    } else {\n      url \x3d String(url);\n    }\n  }\n  if (!goog.html.SAFE_URL_PATTERN_.test(url)) {\n    url \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);\n};\n/**\n * @param {(string|!goog.string.TypedString)} url\n * @param {boolean\x3d} opt_allowDataUrl\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.sanitizeAssertUnchanged \x3d function(url, opt_allowDataUrl) {\n  if (url instanceof goog.html.SafeUrl) {\n    return url;\n  } else {\n    if (typeof url \x3d\x3d \x22object\x22 \x26\x26 url.implementsGoogStringTypedString) {\n      url \x3d /** @type {!goog.string.TypedString} */ (url).getTypedStringValue();\n    } else {\n      url \x3d String(url);\n    }\n  }\n  if (opt_allowDataUrl \x26\x26 /^data:/i.test(url)) {\n    var safeUrl \x3d goog.html.SafeUrl.fromDataUrl(url);\n    if (safeUrl.getTypedStringValue() \x3d\x3d url) {\n      return safeUrl;\n    }\n  }\n  if (!goog.asserts.assert(goog.html.SAFE_URL_PATTERN_.test(url), \x22%s does not match the safe URL pattern\x22, url)) {\n    url \x3d goog.html.SafeUrl.INNOCUOUS_STRING;\n  }\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);\n};\n/** @private @const @type {!Object} */ goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d {};\n/**\n * @package\n * @param {string} url\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse \x3d function(url) {\n  return new goog.html.SafeUrl(goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_, url);\n};\n/** @const @type {!goog.html.SafeUrl} */ goog.html.SafeUrl.ABOUT_BLANK \x3d goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(\x22about:blank\x22);\n/** @private @const @type {!Object} */ goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_ \x3d {};\n");
SHADOW_ENV.evalLoad("goog.html.safestyle.js", true , "goog.provide(\x22goog.html.SafeStyle\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.html.SafeUrl\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.TypedString\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.string.TypedString}\n */\ngoog.html.SafeStyle \x3d function() {\n  /** @private @type {string} */ this.privateDoNotAccessOrElseSafeStyleWrappedValue_ \x3d \x22\x22;\n  /** @private @const @type {!Object} */ this.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;\n};\n/** @const @override */ goog.html.SafeStyle.prototype.implementsGoogStringTypedString \x3d true;\n/** @private @const @type {!Object} */ goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d {};\n/**\n * @param {!goog.string.Const} style\n * @return {!goog.html.SafeStyle}\n */\ngoog.html.SafeStyle.fromConstant \x3d function(style) {\n  var styleString \x3d goog.string.Const.unwrap(style);\n  if (styleString.length \x3d\x3d\x3d 0) {\n    return goog.html.SafeStyle.EMPTY;\n  }\n  goog.asserts.assert(goog.string.internal.endsWith(styleString, \x22;\x22), \x22Last character of style string is not \x27;\x27: \x22 + styleString);\n  goog.asserts.assert(goog.string.internal.contains(styleString, \x22:\x22), \x22Style string must contain at least one \x27:\x27, to \x22 + \x27specify a \x22name: value\x22 pair: \x27 + styleString);\n  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(styleString);\n};\n/** @override */ goog.html.SafeStyle.prototype.getTypedStringValue \x3d function() {\n  return this.privateDoNotAccessOrElseSafeStyleWrappedValue_;\n};\nif (goog.DEBUG) {\n  /** @override */ goog.html.SafeStyle.prototype.toString \x3d function() {\n    return \x22SafeStyle{\x22 + this.privateDoNotAccessOrElseSafeStyleWrappedValue_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.html.SafeStyle} safeStyle\n * @return {string}\n */\ngoog.html.SafeStyle.unwrap \x3d function(safeStyle) {\n  if (safeStyle instanceof goog.html.SafeStyle \x26\x26 safeStyle.constructor \x3d\x3d\x3d goog.html.SafeStyle \x26\x26 safeStyle.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {\n    return safeStyle.privateDoNotAccessOrElseSafeStyleWrappedValue_;\n  } else {\n    goog.asserts.fail(\x22expected object of type SafeStyle, got \x27\x22 + safeStyle + \x22\x27 of type \x22 + goog.typeOf(safeStyle));\n    return \x22type_error:SafeStyle\x22;\n  }\n};\n/**\n * @package\n * @param {string} style\n * @return {!goog.html.SafeStyle}\n */\ngoog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse \x3d function(style) {\n  return (new goog.html.SafeStyle).initSecurityPrivateDoNotAccessOrElse_(style);\n};\n/**\n * @private\n * @param {string} style\n * @return {!goog.html.SafeStyle}\n */\ngoog.html.SafeStyle.prototype.initSecurityPrivateDoNotAccessOrElse_ \x3d function(style) {\n  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ \x3d style;\n  return this;\n};\n/** @const @type {!goog.html.SafeStyle} */ goog.html.SafeStyle.EMPTY \x3d goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(\x22\x22);\n/** @const @type {string} */ goog.html.SafeStyle.INNOCUOUS_STRING \x3d \x22zClosurez\x22;\n/** @typedef {(string|!goog.string.Const|!goog.html.SafeUrl)} */ goog.html.SafeStyle.PropertyValue;\n/** @typedef {!Object\x3cstring,(?goog.html.SafeStyle.PropertyValue|?Array\x3c!goog.html.SafeStyle.PropertyValue\x3e)\x3e} */ goog.html.SafeStyle.PropertyMap;\n/**\n * @param {goog.html.SafeStyle.PropertyMap} map\n * @return {!goog.html.SafeStyle}\n * @throws {Error}\n */\ngoog.html.SafeStyle.create \x3d function(map) {\n  var style \x3d \x22\x22;\n  for (var name in map) {\n    if (!/^[-_a-zA-Z0-9]+$/.test(name)) {\n      throw new Error(\x22Name allows only [-_a-zA-Z0-9], got: \x22 + name);\n    }\n    var value \x3d map[name];\n    if (value \x3d\x3d null) {\n      continue;\n    }\n    if (goog.isArray(value)) {\n      value \x3d goog.array.map(value, goog.html.SafeStyle.sanitizePropertyValue_).join(\x22 \x22);\n    } else {\n      value \x3d goog.html.SafeStyle.sanitizePropertyValue_(value);\n    }\n    style +\x3d name + \x22:\x22 + value + \x22;\x22;\n  }\n  if (!style) {\n    return goog.html.SafeStyle.EMPTY;\n  }\n  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style);\n};\n/**\n * @private\n * @param {!goog.html.SafeStyle.PropertyValue} value\n * @return {string}\n */\ngoog.html.SafeStyle.sanitizePropertyValue_ \x3d function(value) {\n  if (value instanceof goog.html.SafeUrl) {\n    var url \x3d goog.html.SafeUrl.unwrap(value);\n    return \x27url(\x22\x27 + url.replace(/\x3c/g, \x22%3c\x22).replace(/[\\\\\x22]/g, \x22\\\\$\\x26\x22) + \x27\x22)\x27;\n  }\n  var result \x3d value instanceof goog.string.Const ? goog.string.Const.unwrap(value) : goog.html.SafeStyle.sanitizePropertyValueString_(String(value));\n  if (/[{;}]/.test(result)) {\n    throw new goog.asserts.AssertionError(\x22Value does not allow [{;}], got: %s.\x22, [result]);\n  }\n  return result;\n};\n/**\n * @private\n * @param {string} value\n * @return {string}\n */\ngoog.html.SafeStyle.sanitizePropertyValueString_ \x3d function(value) {\n  var valueWithoutFunctions \x3d value.replace(goog.html.SafeStyle.FUNCTIONS_RE_, \x22$1\x22).replace(goog.html.SafeStyle.FUNCTIONS_RE_, \x22$1\x22).replace(goog.html.SafeStyle.URL_RE_, \x22url\x22);\n  if (!goog.html.SafeStyle.VALUE_RE_.test(valueWithoutFunctions)) {\n    goog.asserts.fail(\x22String value allows only \x22 + goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ + \x22 and simple functions, got: \x22 + value);\n    return goog.html.SafeStyle.INNOCUOUS_STRING;\n  } else {\n    if (goog.html.SafeStyle.COMMENT_RE_.test(value)) {\n      goog.asserts.fail(\x22String value disallows comments, got: \x22 + value);\n      return goog.html.SafeStyle.INNOCUOUS_STRING;\n    } else {\n      if (!goog.html.SafeStyle.hasBalancedQuotes_(value)) {\n        goog.asserts.fail(\x22String value requires balanced quotes, got: \x22 + value);\n        return goog.html.SafeStyle.INNOCUOUS_STRING;\n      } else {\n        if (!goog.html.SafeStyle.hasBalancedSquareBrackets_(value)) {\n          goog.asserts.fail(\x22String value requires balanced square brackets and one\x22 + \x22 identifier per pair of brackets, got: \x22 + value);\n          return goog.html.SafeStyle.INNOCUOUS_STRING;\n        }\n      }\n    }\n  }\n  return goog.html.SafeStyle.sanitizeUrl_(value);\n};\n/**\n * @private\n * @param {string} value\n * @return {boolean}\n */\ngoog.html.SafeStyle.hasBalancedQuotes_ \x3d function(value) {\n  var outsideSingle \x3d true;\n  var outsideDouble \x3d true;\n  for (var i \x3d 0; i \x3c value.length; i++) {\n    var c \x3d value.charAt(i);\n    if (c \x3d\x3d \x22\x27\x22 \x26\x26 outsideDouble) {\n      outsideSingle \x3d !outsideSingle;\n    } else {\n      if (c \x3d\x3d \x27\x22\x27 \x26\x26 outsideSingle) {\n        outsideDouble \x3d !outsideDouble;\n      }\n    }\n  }\n  return outsideSingle \x26\x26 outsideDouble;\n};\n/**\n * @private\n * @param {string} value\n * @return {boolean}\n */\ngoog.html.SafeStyle.hasBalancedSquareBrackets_ \x3d function(value) {\n  var outside \x3d true;\n  var tokenRe \x3d /^[-_a-zA-Z0-9]$/;\n  for (var i \x3d 0; i \x3c value.length; i++) {\n    var c \x3d value.charAt(i);\n    if (c \x3d\x3d \x22]\x22) {\n      if (outside) {\n        return false;\n      }\n      outside \x3d true;\n    } else {\n      if (c \x3d\x3d \x22[\x22) {\n        if (!outside) {\n          return false;\n        }\n        outside \x3d false;\n      } else {\n        if (!outside \x26\x26 !tokenRe.test(c)) {\n          return false;\n        }\n      }\n    }\n  }\n  return outside;\n};\n/** @private @type {string} */ goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ \x3d \x22[-,.\\\x22\x27%_!# a-zA-Z0-9\\\\[\\\\]]\x22;\n/** @private @const @type {!RegExp} */ goog.html.SafeStyle.VALUE_RE_ \x3d new RegExp(\x22^\x22 + goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ + \x22+$\x22);\n/** @private @const @type {!RegExp} */ goog.html.SafeStyle.URL_RE_ \x3d new RegExp(\x22\\\\b(url\\\\([ \\t\\n]*)(\x22 + \x22\x27[ -\\x26(-\\\\[\\\\]-~]*\x27\x22 + \x27|\x22[ !#-\\\\[\\\\]-~]*\x22\x27 + \x22|[!#-\\x26*-\\\\[\\\\]-~]*\x22 + \x22)([ \\t\\n]*\\\\))\x22, \x22g\x22);\n/** @private @const @type {!Array\x3cstring\x3e} */ goog.html.SafeStyle.ALLOWED_FUNCTIONS_ \x3d [\x22calc\x22, \x22cubic-bezier\x22, \x22fit-content\x22, \x22hsl\x22, \x22hsla\x22, \x22matrix\x22, \x22minmax\x22, \x22repeat\x22, \x22rgb\x22, \x22rgba\x22, \x22(rotate|scale|translate)(X|Y|Z|3d)?\x22];\n/** @private @const @type {!RegExp} */ goog.html.SafeStyle.FUNCTIONS_RE_ \x3d new RegExp(\x22\\\\b(\x22 + goog.html.SafeStyle.ALLOWED_FUNCTIONS_.join(\x22|\x22) + \x22)\x22 + \x22\\\\([-+*/0-9a-z.%\\\\[\\\\], ]+\\\\)\x22, \x22g\x22);\n/** @private @const @type {!RegExp} */ goog.html.SafeStyle.COMMENT_RE_ \x3d /\\/\\*/;\n/**\n * @private\n * @param {string} value\n * @return {string}\n */\ngoog.html.SafeStyle.sanitizeUrl_ \x3d function(value) {\n  return value.replace(goog.html.SafeStyle.URL_RE_, function(match, before, url, after) {\n    var quote \x3d \x22\x22;\n    url \x3d url.replace(/^([\x27\x22])(.*)\\1$/, function(match, start, inside) {\n      quote \x3d start;\n      return inside;\n    });\n    var sanitized \x3d goog.html.SafeUrl.sanitize(url).getTypedStringValue();\n    return before + quote + sanitized + quote + after;\n  });\n};\n/**\n * @param {...(!goog.html.SafeStyle|!Array\x3c!goog.html.SafeStyle\x3e)} var_args\n * @return {!goog.html.SafeStyle}\n */\ngoog.html.SafeStyle.concat \x3d function(var_args) {\n  var style \x3d \x22\x22;\n  /**\n   * @param {(!goog.html.SafeStyle|!Array\x3c!goog.html.SafeStyle\x3e)} argument\n   */\n  var addArgument \x3d function(argument) {\n    if (goog.isArray(argument)) {\n      goog.array.forEach(argument, addArgument);\n    } else {\n      style +\x3d goog.html.SafeStyle.unwrap(argument);\n    }\n  };\n  goog.array.forEach(arguments, addArgument);\n  if (!style) {\n    return goog.html.SafeStyle.EMPTY;\n  }\n  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style);\n};\n");
SHADOW_ENV.evalLoad("goog.html.safestylesheet.js", true , "goog.provide(\x22goog.html.SafeStyleSheet\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.html.SafeStyle\x22);\ngoog.require(\x22goog.object\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.TypedString\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.string.TypedString}\n */\ngoog.html.SafeStyleSheet \x3d function() {\n  /** @private @type {string} */ this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ \x3d \x22\x22;\n  /** @private @const @type {!Object} */ this.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;\n};\n/** @const @override */ goog.html.SafeStyleSheet.prototype.implementsGoogStringTypedString \x3d true;\n/** @private @const @type {!Object} */ goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d {};\n/**\n * @param {string} selector\n * @param {(!goog.html.SafeStyle.PropertyMap|!goog.html.SafeStyle)} style\n * @return {!goog.html.SafeStyleSheet}\n * @throws {Error}\n */\ngoog.html.SafeStyleSheet.createRule \x3d function(selector, style) {\n  if (goog.string.internal.contains(selector, \x22\\x3c\x22)) {\n    throw new Error(\x22Selector does not allow \x27\\x3c\x27, got: \x22 + selector);\n  }\n  var selectorToCheck \x3d selector.replace(/(\x27|\x22)((?!\\1)[^\\r\\n\\f\\\\]|\\\\[\\s\\S])*\\1/g, \x22\x22);\n  if (!/^[-_a-zA-Z0-9#.:* ,\x3e+~[\\]()\x3d^$|]+$/.test(selectorToCheck)) {\n    throw new Error(\x22Selector allows only [-_a-zA-Z0-9#.:* ,\\x3e+~[\\\\]()\\x3d^$|] and \x22 + \x22strings, got: \x22 + selector);\n  }\n  if (!goog.html.SafeStyleSheet.hasBalancedBrackets_(selectorToCheck)) {\n    throw new Error(\x22() and [] in selector must be balanced, got: \x22 + selector);\n  }\n  if (!(style instanceof goog.html.SafeStyle)) {\n    style \x3d goog.html.SafeStyle.create(style);\n  }\n  var styleSheet \x3d selector + \x22{\x22 + goog.html.SafeStyle.unwrap(style).replace(/\x3c/g, \x22\\\\3C \x22) + \x22}\x22;\n  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheet);\n};\n/**\n * @private\n * @param {string} s\n * @return {boolean}\n */\ngoog.html.SafeStyleSheet.hasBalancedBrackets_ \x3d function(s) {\n  var brackets \x3d {\x22(\x22:\x22)\x22, \x22[\x22:\x22]\x22};\n  var expectedBrackets \x3d [];\n  for (var i \x3d 0; i \x3c s.length; i++) {\n    var ch \x3d s[i];\n    if (brackets[ch]) {\n      expectedBrackets.push(brackets[ch]);\n    } else {\n      if (goog.object.contains(brackets, ch)) {\n        if (expectedBrackets.pop() !\x3d ch) {\n          return false;\n        }\n      }\n    }\n  }\n  return expectedBrackets.length \x3d\x3d 0;\n};\n/**\n * @param {...(!goog.html.SafeStyleSheet|!Array\x3c!goog.html.SafeStyleSheet\x3e)} var_args\n * @return {!goog.html.SafeStyleSheet}\n */\ngoog.html.SafeStyleSheet.concat \x3d function(var_args) {\n  var result \x3d \x22\x22;\n  /**\n   * @param {(!goog.html.SafeStyleSheet|!Array\x3c!goog.html.SafeStyleSheet\x3e)} argument\n   */\n  var addArgument \x3d function(argument) {\n    if (goog.isArray(argument)) {\n      goog.array.forEach(argument, addArgument);\n    } else {\n      result +\x3d goog.html.SafeStyleSheet.unwrap(argument);\n    }\n  };\n  goog.array.forEach(arguments, addArgument);\n  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(result);\n};\n/**\n * @param {!goog.string.Const} styleSheet\n * @return {!goog.html.SafeStyleSheet}\n */\ngoog.html.SafeStyleSheet.fromConstant \x3d function(styleSheet) {\n  var styleSheetString \x3d goog.string.Const.unwrap(styleSheet);\n  if (styleSheetString.length \x3d\x3d\x3d 0) {\n    return goog.html.SafeStyleSheet.EMPTY;\n  }\n  goog.asserts.assert(!goog.string.internal.contains(styleSheetString, \x22\\x3c\x22), \x22Forbidden \x27\\x3c\x27 character in style sheet string: \x22 + styleSheetString);\n  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheetString);\n};\n/** @override */ goog.html.SafeStyleSheet.prototype.getTypedStringValue \x3d function() {\n  return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;\n};\nif (goog.DEBUG) {\n  /** @override */ goog.html.SafeStyleSheet.prototype.toString \x3d function() {\n    return \x22SafeStyleSheet{\x22 + this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.html.SafeStyleSheet} safeStyleSheet\n * @return {string}\n */\ngoog.html.SafeStyleSheet.unwrap \x3d function(safeStyleSheet) {\n  if (safeStyleSheet instanceof goog.html.SafeStyleSheet \x26\x26 safeStyleSheet.constructor \x3d\x3d\x3d goog.html.SafeStyleSheet \x26\x26 safeStyleSheet.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {\n    return safeStyleSheet.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;\n  } else {\n    goog.asserts.fail(\x22expected object of type SafeStyleSheet, got \x27\x22 + safeStyleSheet + \x22\x27 of type \x22 + goog.typeOf(safeStyleSheet));\n    return \x22type_error:SafeStyleSheet\x22;\n  }\n};\n/**\n * @package\n * @param {string} styleSheet\n * @return {!goog.html.SafeStyleSheet}\n */\ngoog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse \x3d function(styleSheet) {\n  return (new goog.html.SafeStyleSheet).initSecurityPrivateDoNotAccessOrElse_(styleSheet);\n};\n/**\n * @private\n * @param {string} styleSheet\n * @return {!goog.html.SafeStyleSheet}\n */\ngoog.html.SafeStyleSheet.prototype.initSecurityPrivateDoNotAccessOrElse_ \x3d function(styleSheet) {\n  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ \x3d styleSheet;\n  return this;\n};\n/** @const @type {!goog.html.SafeStyleSheet} */ goog.html.SafeStyleSheet.EMPTY \x3d goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(\x22\x22);\n");
SHADOW_ENV.evalLoad("goog.labs.useragent.util.js", true , "goog.provide(\x22goog.labs.userAgent.util\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @private\n * @return {string}\n */\ngoog.labs.userAgent.util.getNativeUserAgentString_ \x3d function() {\n  var navigator \x3d goog.labs.userAgent.util.getNavigator_();\n  if (navigator) {\n    var userAgent \x3d navigator.userAgent;\n    if (userAgent) {\n      return userAgent;\n    }\n  }\n  return \x22\x22;\n};\n/**\n * @private\n * @return {Navigator}\n */\ngoog.labs.userAgent.util.getNavigator_ \x3d function() {\n  return goog.global.navigator;\n};\n/** @private @type {string} */ goog.labs.userAgent.util.userAgent_ \x3d goog.labs.userAgent.util.getNativeUserAgentString_();\n/**\n * @param {?string\x3d} opt_userAgent\n */\ngoog.labs.userAgent.util.setUserAgent \x3d function(opt_userAgent) {\n  goog.labs.userAgent.util.userAgent_ \x3d opt_userAgent || goog.labs.userAgent.util.getNativeUserAgentString_();\n};\n/**\n * @return {string}\n */\ngoog.labs.userAgent.util.getUserAgent \x3d function() {\n  return goog.labs.userAgent.util.userAgent_;\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.labs.userAgent.util.matchUserAgent \x3d function(str) {\n  var userAgent \x3d goog.labs.userAgent.util.getUserAgent();\n  return goog.string.internal.contains(userAgent, str);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.labs.userAgent.util.matchUserAgentIgnoreCase \x3d function(str) {\n  var userAgent \x3d goog.labs.userAgent.util.getUserAgent();\n  return goog.string.internal.caseInsensitiveContains(userAgent, str);\n};\n/**\n * @param {string} userAgent\n * @return {!Array\x3c!Array\x3cstring\x3e\x3e}\n */\ngoog.labs.userAgent.util.extractVersionTuples \x3d function(userAgent) {\n  var versionRegExp \x3d new RegExp(\x22(\\\\w[\\\\w ]+)\x22 + \x22/\x22 + \x22([^\\\\s]+)\x22 + \x22\\\\s*\x22 + \x22(?:\\\\((.*?)\\\\))?\x22, \x22g\x22);\n  var data \x3d [];\n  var match;\n  while (match \x3d versionRegExp.exec(userAgent)) {\n    data.push([match[1], match[2], match[3] || undefined]);\n  }\n  return data;\n};\n");
SHADOW_ENV.evalLoad("goog.labs.useragent.browser.js", true , "goog.provide(\x22goog.labs.userAgent.browser\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.labs.userAgent.util\x22);\ngoog.require(\x22goog.object\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchOpera_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Opera\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchIE_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Trident\x22) || goog.labs.userAgent.util.matchUserAgent(\x22MSIE\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchEdgeHtml_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Edge\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchEdgeChromium_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Edg/\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchOperaChromium_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22OPR\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchFirefox_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Firefox\x22) || goog.labs.userAgent.util.matchUserAgent(\x22FxiOS\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchSafari_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Safari\x22) \x26\x26 !(goog.labs.userAgent.browser.matchChrome_() || goog.labs.userAgent.browser.matchCoast_() || goog.labs.userAgent.browser.matchOpera_() || goog.labs.userAgent.browser.matchEdgeHtml_() || goog.labs.userAgent.browser.matchEdgeChromium_() || goog.labs.userAgent.browser.matchOperaChromium_() || goog.labs.userAgent.browser.matchFirefox_() || goog.labs.userAgent.browser.isSilk() || goog.labs.userAgent.util.matchUserAgent(\x22Android\x22));\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchCoast_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Coast\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchIosWebview_ \x3d function() {\n  return (goog.labs.userAgent.util.matchUserAgent(\x22iPad\x22) || goog.labs.userAgent.util.matchUserAgent(\x22iPhone\x22)) \x26\x26 !goog.labs.userAgent.browser.matchSafari_() \x26\x26 !goog.labs.userAgent.browser.matchChrome_() \x26\x26 !goog.labs.userAgent.browser.matchCoast_() \x26\x26 !goog.labs.userAgent.browser.matchFirefox_() \x26\x26 goog.labs.userAgent.util.matchUserAgent(\x22AppleWebKit\x22);\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchChrome_ \x3d function() {\n  return (goog.labs.userAgent.util.matchUserAgent(\x22Chrome\x22) || goog.labs.userAgent.util.matchUserAgent(\x22CriOS\x22)) \x26\x26 !goog.labs.userAgent.browser.matchEdgeHtml_();\n};\n/**\n * @private\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.matchAndroidBrowser_ \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Android\x22) \x26\x26 !(goog.labs.userAgent.browser.isChrome() || goog.labs.userAgent.browser.isFirefox() || goog.labs.userAgent.browser.isOpera() || goog.labs.userAgent.browser.isSilk());\n};\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isOpera \x3d goog.labs.userAgent.browser.matchOpera_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isIE \x3d goog.labs.userAgent.browser.matchIE_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isEdge \x3d goog.labs.userAgent.browser.matchEdgeHtml_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isEdgeChromium \x3d goog.labs.userAgent.browser.matchEdgeChromium_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isOperaChromium \x3d goog.labs.userAgent.browser.matchOperaChromium_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isFirefox \x3d goog.labs.userAgent.browser.matchFirefox_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isSafari \x3d goog.labs.userAgent.browser.matchSafari_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isCoast \x3d goog.labs.userAgent.browser.matchCoast_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isIosWebview \x3d goog.labs.userAgent.browser.matchIosWebview_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isChrome \x3d goog.labs.userAgent.browser.matchChrome_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isAndroidBrowser \x3d goog.labs.userAgent.browser.matchAndroidBrowser_;\n/**\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isSilk \x3d function() {\n  return goog.labs.userAgent.util.matchUserAgent(\x22Silk\x22);\n};\n/**\n * @return {string}\n */\ngoog.labs.userAgent.browser.getVersion \x3d function() {\n  var userAgentString \x3d goog.labs.userAgent.util.getUserAgent();\n  if (goog.labs.userAgent.browser.isIE()) {\n    return goog.labs.userAgent.browser.getIEVersion_(userAgentString);\n  }\n  var versionTuples \x3d goog.labs.userAgent.util.extractVersionTuples(userAgentString);\n  var versionMap \x3d {};\n  goog.array.forEach(versionTuples, function(tuple) {\n    var key \x3d tuple[0];\n    var value \x3d tuple[1];\n    versionMap[key] \x3d value;\n  });\n  var versionMapHasKey \x3d goog.partial(goog.object.containsKey, versionMap);\n  function lookUpValueWithKeys(keys) {\n    var key \x3d goog.array.find(keys, versionMapHasKey);\n    return versionMap[key] || \x22\x22;\n  }\n  if (goog.labs.userAgent.browser.isOpera()) {\n    return lookUpValueWithKeys([\x22Version\x22, \x22Opera\x22]);\n  }\n  if (goog.labs.userAgent.browser.isEdge()) {\n    return lookUpValueWithKeys([\x22Edge\x22]);\n  }\n  if (goog.labs.userAgent.browser.isEdgeChromium()) {\n    return lookUpValueWithKeys([\x22Edg\x22]);\n  }\n  if (goog.labs.userAgent.browser.isChrome()) {\n    return lookUpValueWithKeys([\x22Chrome\x22, \x22CriOS\x22]);\n  }\n  var tuple \x3d versionTuples[2];\n  return tuple \x26\x26 tuple[1] || \x22\x22;\n};\n/**\n * @param {(string|number)} version\n * @return {boolean}\n */\ngoog.labs.userAgent.browser.isVersionOrHigher \x3d function(version) {\n  return goog.string.internal.compareVersions(goog.labs.userAgent.browser.getVersion(), version) \x3e\x3d 0;\n};\n/**\n * @private\n * @param {string} userAgent\n * @return {string}\n */\ngoog.labs.userAgent.browser.getIEVersion_ \x3d function(userAgent) {\n  var rv \x3d /rv: *([\\d\\.]*)/.exec(userAgent);\n  if (rv \x26\x26 rv[1]) {\n    return rv[1];\n  }\n  var version \x3d \x22\x22;\n  var msie \x3d /MSIE +([\\d\\.]+)/.exec(userAgent);\n  if (msie \x26\x26 msie[1]) {\n    var tridentVersion \x3d /Trident\\/(\\d.\\d)/.exec(userAgent);\n    if (msie[1] \x3d\x3d \x227.0\x22) {\n      if (tridentVersion \x26\x26 tridentVersion[1]) {\n        switch(tridentVersion[1]) {\n          case \x224.0\x22:\n            version \x3d \x228.0\x22;\n            break;\n          case \x225.0\x22:\n            version \x3d \x229.0\x22;\n            break;\n          case \x226.0\x22:\n            version \x3d \x2210.0\x22;\n            break;\n          case \x227.0\x22:\n            version \x3d \x2211.0\x22;\n            break;\n        }\n      } else {\n        version \x3d \x227.0\x22;\n      }\n    } else {\n      version \x3d msie[1];\n    }\n  }\n  return version;\n};\n");
SHADOW_ENV.evalLoad("goog.html.safehtml.js", true , "goog.provide(\x22goog.html.SafeHtml\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.dom.TagName\x22);\ngoog.require(\x22goog.dom.tags\x22);\ngoog.require(\x22goog.html.SafeScript\x22);\ngoog.require(\x22goog.html.SafeStyle\x22);\ngoog.require(\x22goog.html.SafeStyleSheet\x22);\ngoog.require(\x22goog.html.SafeUrl\x22);\ngoog.require(\x22goog.html.TrustedResourceUrl\x22);\ngoog.require(\x22goog.html.trustedtypes\x22);\ngoog.require(\x22goog.i18n.bidi.Dir\x22);\ngoog.require(\x22goog.i18n.bidi.DirectionalString\x22);\ngoog.require(\x22goog.labs.userAgent.browser\x22);\ngoog.require(\x22goog.object\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.TypedString\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @final\n * @struct\n * @constructor\n * @implements {goog.i18n.bidi.DirectionalString}\n * @implements {goog.string.TypedString}\n */\ngoog.html.SafeHtml \x3d function() {\n  /** @private @type {(!TrustedHTML|string)} */ this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ \x3d \x22\x22;\n  /** @private @const @type {!Object} */ this.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;\n  /** @private @type {?goog.i18n.bidi.Dir} */ this.dir_ \x3d null;\n};\n/** @define {boolean} */ goog.html.SafeHtml.ENABLE_ERROR_MESSAGES \x3d goog.define(\x22goog.html.SafeHtml.ENABLE_ERROR_MESSAGES\x22, goog.DEBUG);\n/** @define {boolean} */ goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE \x3d goog.define(\x22goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE\x22, true);\n/** @const @override */ goog.html.SafeHtml.prototype.implementsGoogI18nBidiDirectionalString \x3d true;\n/** @override */ goog.html.SafeHtml.prototype.getDirection \x3d function() {\n  return this.dir_;\n};\n/** @const @override */ goog.html.SafeHtml.prototype.implementsGoogStringTypedString \x3d true;\n/** @override */ goog.html.SafeHtml.prototype.getTypedStringValue \x3d function() {\n  return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_.toString();\n};\nif (goog.DEBUG) {\n  /** @override */ goog.html.SafeHtml.prototype.toString \x3d function() {\n    return \x22SafeHtml{\x22 + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ + \x22}\x22;\n  };\n}\n/**\n * @param {!goog.html.SafeHtml} safeHtml\n * @return {string}\n */\ngoog.html.SafeHtml.unwrap \x3d function(safeHtml) {\n  return goog.html.SafeHtml.unwrapTrustedHTML(safeHtml).toString();\n};\n/**\n * @param {!goog.html.SafeHtml} safeHtml\n * @return {(!TrustedHTML|string)}\n */\ngoog.html.SafeHtml.unwrapTrustedHTML \x3d function(safeHtml) {\n  if (safeHtml instanceof goog.html.SafeHtml \x26\x26 safeHtml.constructor \x3d\x3d\x3d goog.html.SafeHtml \x26\x26 safeHtml.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d\x3d\x3d goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {\n    return safeHtml.privateDoNotAccessOrElseSafeHtmlWrappedValue_;\n  } else {\n    goog.asserts.fail(\x22expected object of type SafeHtml, got \x27\x22 + safeHtml + \x22\x27 of type \x22 + goog.typeOf(safeHtml));\n    return \x22type_error:SafeHtml\x22;\n  }\n};\n/** @private @typedef {(string|number|boolean|!goog.string.TypedString|!goog.i18n.bidi.DirectionalString)} */ goog.html.SafeHtml.TextOrHtml_;\n/**\n * @param {!goog.html.SafeHtml.TextOrHtml_} textOrHtml\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.htmlEscape \x3d function(textOrHtml) {\n  if (textOrHtml instanceof goog.html.SafeHtml) {\n    return textOrHtml;\n  }\n  var textIsObject \x3d typeof textOrHtml \x3d\x3d \x22object\x22;\n  var dir \x3d null;\n  if (textIsObject \x26\x26 textOrHtml.implementsGoogI18nBidiDirectionalString) {\n    dir \x3d /** @type {!goog.i18n.bidi.DirectionalString} */ (textOrHtml).getDirection();\n  }\n  var textAsString;\n  if (textIsObject \x26\x26 textOrHtml.implementsGoogStringTypedString) {\n    textAsString \x3d /** @type {!goog.string.TypedString} */ (textOrHtml).getTypedStringValue();\n  } else {\n    textAsString \x3d String(textOrHtml);\n  }\n  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.htmlEscape(textAsString), dir);\n};\n/**\n * @param {!goog.html.SafeHtml.TextOrHtml_} textOrHtml\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.htmlEscapePreservingNewlines \x3d function(textOrHtml) {\n  if (textOrHtml instanceof goog.html.SafeHtml) {\n    return textOrHtml;\n  }\n  var html \x3d goog.html.SafeHtml.htmlEscape(textOrHtml);\n  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.newLineToBr(goog.html.SafeHtml.unwrap(html)), html.getDirection());\n};\n/**\n * @param {!goog.html.SafeHtml.TextOrHtml_} textOrHtml\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces \x3d function(textOrHtml) {\n  if (textOrHtml instanceof goog.html.SafeHtml) {\n    return textOrHtml;\n  }\n  var html \x3d goog.html.SafeHtml.htmlEscape(textOrHtml);\n  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.whitespaceEscape(goog.html.SafeHtml.unwrap(html)), html.getDirection());\n};\n/**\n * @param {!goog.html.SafeHtml.TextOrHtml_} textOrHtml\n * @return {!goog.html.SafeHtml}\n * @deprecated Use goog.html.SafeHtml.htmlEscape.\n */\ngoog.html.SafeHtml.from \x3d goog.html.SafeHtml.htmlEscape;\n/** @private @const */ goog.html.SafeHtml.VALID_NAMES_IN_TAG_ \x3d /^[a-zA-Z0-9-]+$/;\n/** @private @const @type {!Object\x3cstring,boolean\x3e} */ goog.html.SafeHtml.URL_ATTRIBUTES_ \x3d goog.object.createSet(\x22action\x22, \x22cite\x22, \x22data\x22, \x22formaction\x22, \x22href\x22, \x22manifest\x22, \x22poster\x22, \x22src\x22);\n/** @private @const @type {!Object\x3cstring,boolean\x3e} */ goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_ \x3d goog.object.createSet(goog.dom.TagName.APPLET, goog.dom.TagName.BASE, goog.dom.TagName.EMBED, goog.dom.TagName.IFRAME, goog.dom.TagName.LINK, goog.dom.TagName.MATH, goog.dom.TagName.META, goog.dom.TagName.OBJECT, goog.dom.TagName.SCRIPT, goog.dom.TagName.STYLE, goog.dom.TagName.SVG, goog.dom.TagName.TEMPLATE);\n/** @typedef {(string|number|goog.string.TypedString|goog.html.SafeStyle.PropertyMap|undefined)} */ goog.html.SafeHtml.AttributeValue;\n/**\n * @param {(!goog.dom.TagName|string)} tagName\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @param {(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)\x3d} opt_content\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.create \x3d function(tagName, opt_attributes, opt_content) {\n  goog.html.SafeHtml.verifyTagName(String(tagName));\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(String(tagName), opt_attributes, opt_content);\n};\n/**\n * @package\n * @param {string} tagName\n * @throws {Error}\n */\ngoog.html.SafeHtml.verifyTagName \x3d function(tagName) {\n  if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(tagName)) {\n    throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x22Invalid tag name \\x3c\x22 + tagName + \x22\\x3e.\x22 : \x22\x22);\n  }\n  if (tagName.toUpperCase() in goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_) {\n    throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x22Tag name \\x3c\x22 + tagName + \x22\\x3e is not allowed for SafeHtml.\x22 : \x22\x22);\n  }\n};\n/**\n * @param {?goog.html.TrustedResourceUrl\x3d} opt_src\n * @param {?goog.html.SafeHtml\x3d} opt_srcdoc\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @param {(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)\x3d} opt_content\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.createIframe \x3d function(opt_src, opt_srcdoc, opt_attributes, opt_content) {\n  if (opt_src) {\n    goog.html.TrustedResourceUrl.unwrap(opt_src);\n  }\n  var fixedAttributes \x3d {};\n  fixedAttributes[\x22src\x22] \x3d opt_src || null;\n  fixedAttributes[\x22srcdoc\x22] \x3d opt_srcdoc \x26\x26 goog.html.SafeHtml.unwrap(opt_srcdoc);\n  var defaultAttributes \x3d {\x22sandbox\x22:\x22\x22};\n  var attributes \x3d goog.html.SafeHtml.combineAttributes(fixedAttributes, defaultAttributes, opt_attributes);\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(\x22iframe\x22, attributes, opt_content);\n};\n/**\n * @param {(string|!goog.html.SafeUrl)\x3d} opt_src\n * @param {string\x3d} opt_srcdoc\n * @param {!Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @param {(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)\x3d} opt_content\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.createSandboxIframe \x3d function(opt_src, opt_srcdoc, opt_attributes, opt_content) {\n  if (!goog.html.SafeHtml.canUseSandboxIframe()) {\n    throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x22The browser does not support sandboxed iframes.\x22 : \x22\x22);\n  }\n  var fixedAttributes \x3d {};\n  if (opt_src) {\n    fixedAttributes[\x22src\x22] \x3d goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(opt_src));\n  } else {\n    fixedAttributes[\x22src\x22] \x3d null;\n  }\n  fixedAttributes[\x22srcdoc\x22] \x3d opt_srcdoc || null;\n  fixedAttributes[\x22sandbox\x22] \x3d \x22\x22;\n  var attributes \x3d goog.html.SafeHtml.combineAttributes(fixedAttributes, {}, opt_attributes);\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(\x22iframe\x22, attributes, opt_content);\n};\n/**\n * @return {boolean}\n */\ngoog.html.SafeHtml.canUseSandboxIframe \x3d function() {\n  return goog.global[\x22HTMLIFrameElement\x22] \x26\x26 \x22sandbox\x22 in goog.global[\x22HTMLIFrameElement\x22].prototype;\n};\n/**\n * @param {!goog.html.TrustedResourceUrl} src\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.createScriptSrc \x3d function(src, opt_attributes) {\n  goog.html.TrustedResourceUrl.unwrap(src);\n  var fixedAttributes \x3d {\x22src\x22:src};\n  var defaultAttributes \x3d {};\n  var attributes \x3d goog.html.SafeHtml.combineAttributes(fixedAttributes, defaultAttributes, opt_attributes);\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(\x22script\x22, attributes);\n};\n/**\n * @param {(!goog.html.SafeScript|!Array\x3c!goog.html.SafeScript\x3e)} script\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.createScript \x3d function(script, opt_attributes) {\n  for (var attr in opt_attributes) {\n    var attrLower \x3d attr.toLowerCase();\n    if (attrLower \x3d\x3d \x22language\x22 || attrLower \x3d\x3d \x22src\x22 || attrLower \x3d\x3d \x22text\x22 || attrLower \x3d\x3d \x22type\x22) {\n      throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27Cannot set \x22\x27 + attrLower + \x27\x22 attribute\x27 : \x22\x22);\n    }\n  }\n  var content \x3d \x22\x22;\n  script \x3d goog.array.concat(script);\n  for (var i \x3d 0; i \x3c script.length; i++) {\n    content +\x3d goog.html.SafeScript.unwrap(script[i]);\n  }\n  var htmlContent \x3d goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content, goog.i18n.bidi.Dir.NEUTRAL);\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(\x22script\x22, opt_attributes, htmlContent);\n};\n/**\n * @param {(!goog.html.SafeStyleSheet|!Array\x3c!goog.html.SafeStyleSheet\x3e)} styleSheet\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.createStyle \x3d function(styleSheet, opt_attributes) {\n  var fixedAttributes \x3d {\x22type\x22:\x22text/css\x22};\n  var defaultAttributes \x3d {};\n  var attributes \x3d goog.html.SafeHtml.combineAttributes(fixedAttributes, defaultAttributes, opt_attributes);\n  var content \x3d \x22\x22;\n  styleSheet \x3d goog.array.concat(styleSheet);\n  for (var i \x3d 0; i \x3c styleSheet.length; i++) {\n    content +\x3d goog.html.SafeStyleSheet.unwrap(styleSheet[i]);\n  }\n  var htmlContent \x3d goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content, goog.i18n.bidi.Dir.NEUTRAL);\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(\x22style\x22, attributes, htmlContent);\n};\n/**\n * @param {(!goog.html.SafeUrl|string)} url\n * @param {number\x3d} opt_secs\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.createMetaRefresh \x3d function(url, opt_secs) {\n  var unwrappedUrl \x3d goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(url));\n  if (goog.labs.userAgent.browser.isIE() || goog.labs.userAgent.browser.isEdge()) {\n    if (goog.string.internal.contains(unwrappedUrl, \x22;\x22)) {\n      unwrappedUrl \x3d \x22\x27\x22 + unwrappedUrl.replace(/\x27/g, \x22%27\x22) + \x22\x27\x22;\n    }\n  }\n  var attributes \x3d {\x22http-equiv\x22:\x22refresh\x22, \x22content\x22:(opt_secs || 0) + \x22; url\\x3d\x22 + unwrappedUrl};\n  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(\x22meta\x22, attributes);\n};\n/**\n * @private\n * @param {string} tagName\n * @param {string} name\n * @param {!goog.html.SafeHtml.AttributeValue} value\n * @return {string}\n * @throws {Error}\n */\ngoog.html.SafeHtml.getAttrNameAndValue_ \x3d function(tagName, name, value) {\n  if (value instanceof goog.string.Const) {\n    value \x3d goog.string.Const.unwrap(value);\n  } else {\n    if (name.toLowerCase() \x3d\x3d \x22style\x22) {\n      if (goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE) {\n        value \x3d goog.html.SafeHtml.getStyleValue_(value);\n      } else {\n        throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27Attribute \x22style\x22 not supported.\x27 : \x22\x22);\n      }\n    } else {\n      if (/^on/i.test(name)) {\n        throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27Attribute \x22\x27 + name + \x27\x22 requires goog.string.Const value, \x22\x27 + value + \x27\x22 given.\x27 : \x22\x22);\n      } else {\n        if (name.toLowerCase() in goog.html.SafeHtml.URL_ATTRIBUTES_) {\n          if (value instanceof goog.html.TrustedResourceUrl) {\n            value \x3d goog.html.TrustedResourceUrl.unwrap(value);\n          } else {\n            if (value instanceof goog.html.SafeUrl) {\n              value \x3d goog.html.SafeUrl.unwrap(value);\n            } else {\n              if (typeof value \x3d\x3d\x3d \x22string\x22) {\n                value \x3d goog.html.SafeUrl.sanitize(value).getTypedStringValue();\n              } else {\n                throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27Attribute \x22\x27 + name + \x27\x22 on tag \x22\x27 + tagName + \x27\x22 requires goog.html.SafeUrl, goog.string.Const, or\x27 + \x27 string, value \x22\x27 + value + \x27\x22 given.\x27 : \x22\x22);\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n  if (value.implementsGoogStringTypedString) {\n    value \x3d /** @type {!goog.string.TypedString} */ (value).getTypedStringValue();\n  }\n  goog.asserts.assert(typeof value \x3d\x3d\x3d \x22string\x22 || typeof value \x3d\x3d\x3d \x22number\x22, \x22String or number value expected, got \x22 + typeof value + \x22 with value: \x22 + value);\n  return name + \x27\\x3d\x22\x27 + goog.string.internal.htmlEscape(String(value)) + \x27\x22\x27;\n};\n/**\n * @private\n * @param {!goog.html.SafeHtml.AttributeValue} value\n * @return {string}\n * @throws {Error}\n */\ngoog.html.SafeHtml.getStyleValue_ \x3d function(value) {\n  if (!goog.isObject(value)) {\n    throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27The \x22style\x22 attribute requires goog.html.SafeStyle or map \x27 + \x22of style properties, \x22 + typeof value + \x22 given: \x22 + value : \x22\x22);\n  }\n  if (!(value instanceof goog.html.SafeStyle)) {\n    value \x3d goog.html.SafeStyle.create(value);\n  }\n  return goog.html.SafeStyle.unwrap(value);\n};\n/**\n * @param {!goog.i18n.bidi.Dir} dir\n * @param {string} tagName\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @param {(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)\x3d} opt_content\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.createWithDir \x3d function(dir, tagName, opt_attributes, opt_content) {\n  var html \x3d goog.html.SafeHtml.create(tagName, opt_attributes, opt_content);\n  html.dir_ \x3d dir;\n  return html;\n};\n/**\n * @param {!goog.html.SafeHtml.TextOrHtml_} separator\n * @param {!Array\x3c(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)\x3e} parts\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.join \x3d function(separator, parts) {\n  var separatorHtml \x3d goog.html.SafeHtml.htmlEscape(separator);\n  var dir \x3d separatorHtml.getDirection();\n  var content \x3d [];\n  /**\n   * @param {(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)} argument\n   */\n  var addArgument \x3d function(argument) {\n    if (goog.isArray(argument)) {\n      goog.array.forEach(argument, addArgument);\n    } else {\n      var html \x3d goog.html.SafeHtml.htmlEscape(argument);\n      content.push(goog.html.SafeHtml.unwrap(html));\n      var htmlDir \x3d html.getDirection();\n      if (dir \x3d\x3d goog.i18n.bidi.Dir.NEUTRAL) {\n        dir \x3d htmlDir;\n      } else {\n        if (htmlDir !\x3d goog.i18n.bidi.Dir.NEUTRAL \x26\x26 dir !\x3d htmlDir) {\n          dir \x3d null;\n        }\n      }\n    }\n  };\n  goog.array.forEach(parts, addArgument);\n  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content.join(goog.html.SafeHtml.unwrap(separatorHtml)), dir);\n};\n/**\n * @param {...(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)} var_args\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.concat \x3d function(var_args) {\n  return goog.html.SafeHtml.join(goog.html.SafeHtml.EMPTY, Array.prototype.slice.call(arguments));\n};\n/**\n * @param {!goog.i18n.bidi.Dir} dir\n * @param {...(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)} var_args\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.concatWithDir \x3d function(dir, var_args) {\n  var html \x3d goog.html.SafeHtml.concat(goog.array.slice(arguments, 1));\n  html.dir_ \x3d dir;\n  return html;\n};\n/** @private @const @type {!Object} */ goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ \x3d {};\n/**\n * @package\n * @param {string} html\n * @param {?goog.i18n.bidi.Dir} dir\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse \x3d function(html, dir) {\n  return (new goog.html.SafeHtml).initSecurityPrivateDoNotAccessOrElse_(html, dir);\n};\n/**\n * @private\n * @param {string} html\n * @param {?goog.i18n.bidi.Dir} dir\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.SafeHtml.prototype.initSecurityPrivateDoNotAccessOrElse_ \x3d function(html, dir) {\n  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ \x3d goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY ? goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createHTML(html) : html;\n  this.dir_ \x3d dir;\n  return this;\n};\n/**\n * @package\n * @param {string} tagName\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @param {(!goog.html.SafeHtml.TextOrHtml_|!Array\x3c!goog.html.SafeHtml.TextOrHtml_\x3e)\x3d} opt_content\n * @return {!goog.html.SafeHtml}\n * @throws {Error}\n */\ngoog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse \x3d function(tagName, opt_attributes, opt_content) {\n  var dir \x3d null;\n  var result \x3d \x22\\x3c\x22 + tagName;\n  result +\x3d goog.html.SafeHtml.stringifyAttributes(tagName, opt_attributes);\n  var content \x3d opt_content;\n  if (content \x3d\x3d null) {\n    content \x3d [];\n  } else {\n    if (!goog.isArray(content)) {\n      content \x3d [content];\n    }\n  }\n  if (goog.dom.tags.isVoidTag(tagName.toLowerCase())) {\n    goog.asserts.assert(!content.length, \x22Void tag \\x3c\x22 + tagName + \x22\\x3e does not allow content.\x22);\n    result +\x3d \x22\\x3e\x22;\n  } else {\n    var html \x3d goog.html.SafeHtml.concat(content);\n    result +\x3d \x22\\x3e\x22 + goog.html.SafeHtml.unwrap(html) + \x22\\x3c/\x22 + tagName + \x22\\x3e\x22;\n    dir \x3d html.getDirection();\n  }\n  var dirAttribute \x3d opt_attributes \x26\x26 opt_attributes[\x22dir\x22];\n  if (dirAttribute) {\n    if (/^(ltr|rtl|auto)$/i.test(dirAttribute)) {\n      dir \x3d goog.i18n.bidi.Dir.NEUTRAL;\n    } else {\n      dir \x3d null;\n    }\n  }\n  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(result, dir);\n};\n/**\n * @package\n * @param {string} tagName\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @return {string}\n * @throws {Error}\n */\ngoog.html.SafeHtml.stringifyAttributes \x3d function(tagName, opt_attributes) {\n  var result \x3d \x22\x22;\n  if (opt_attributes) {\n    for (var name in opt_attributes) {\n      if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(name)) {\n        throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27Invalid attribute name \x22\x27 + name + \x27\x22.\x27 : \x22\x22);\n      }\n      var value \x3d opt_attributes[name];\n      if (value \x3d\x3d null) {\n        continue;\n      }\n      result +\x3d \x22 \x22 + goog.html.SafeHtml.getAttrNameAndValue_(tagName, name, value);\n    }\n  }\n  return result;\n};\n/**\n * @package\n * @param {!Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e} fixedAttributes\n * @param {!Object\x3cstring,string\x3e} defaultAttributes\n * @param {?Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e\x3d} opt_attributes\n * @return {!Object\x3cstring,?goog.html.SafeHtml.AttributeValue\x3e}\n * @throws {Error}\n */\ngoog.html.SafeHtml.combineAttributes \x3d function(fixedAttributes, defaultAttributes, opt_attributes) {\n  var combinedAttributes \x3d {};\n  var name;\n  for (name in fixedAttributes) {\n    goog.asserts.assert(name.toLowerCase() \x3d\x3d name, \x22Must be lower case\x22);\n    combinedAttributes[name] \x3d fixedAttributes[name];\n  }\n  for (name in defaultAttributes) {\n    goog.asserts.assert(name.toLowerCase() \x3d\x3d name, \x22Must be lower case\x22);\n    combinedAttributes[name] \x3d defaultAttributes[name];\n  }\n  if (opt_attributes) {\n    for (name in opt_attributes) {\n      var nameLower \x3d name.toLowerCase();\n      if (nameLower in fixedAttributes) {\n        throw new Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? \x27Cannot override \x22\x27 + nameLower + \x27\x22 attribute, got \x22\x27 + name + \x27\x22 with value \x22\x27 + opt_attributes[name] + \x27\x22\x27 : \x22\x22);\n      }\n      if (nameLower in defaultAttributes) {\n        delete combinedAttributes[nameLower];\n      }\n      combinedAttributes[name] \x3d opt_attributes[name];\n    }\n  }\n  return combinedAttributes;\n};\n/** @const @type {!goog.html.SafeHtml} */ goog.html.SafeHtml.DOCTYPE_HTML \x3d goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(\x22\\x3c!DOCTYPE html\\x3e\x22, goog.i18n.bidi.Dir.NEUTRAL);\n/** @const @type {!goog.html.SafeHtml} */ goog.html.SafeHtml.EMPTY \x3d goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(\x22\x22, goog.i18n.bidi.Dir.NEUTRAL);\n/** @const @type {!goog.html.SafeHtml} */ goog.html.SafeHtml.BR \x3d goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(\x22\\x3cbr\\x3e\x22, goog.i18n.bidi.Dir.NEUTRAL);\n");
SHADOW_ENV.evalLoad("goog.html.uncheckedconversions.js", true , "goog.provide(\x22goog.html.uncheckedconversions\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.html.SafeHtml\x22);\ngoog.require(\x22goog.html.SafeScript\x22);\ngoog.require(\x22goog.html.SafeStyle\x22);\ngoog.require(\x22goog.html.SafeStyleSheet\x22);\ngoog.require(\x22goog.html.SafeUrl\x22);\ngoog.require(\x22goog.html.TrustedResourceUrl\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.internal\x22);\n/**\n * @param {!goog.string.Const} justification\n * @param {string} html\n * @param {?goog.i18n.bidi.Dir\x3d} opt_dir\n * @return {!goog.html.SafeHtml}\n */\ngoog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract \x3d function(justification, html, opt_dir) {\n  goog.asserts.assertString(goog.string.Const.unwrap(justification), \x22must provide justification\x22);\n  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), \x22must provide non-empty justification\x22);\n  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(html, opt_dir || null);\n};\n/**\n * @param {!goog.string.Const} justification\n * @param {string} script\n * @return {!goog.html.SafeScript}\n */\ngoog.html.uncheckedconversions.safeScriptFromStringKnownToSatisfyTypeContract \x3d function(justification, script) {\n  goog.asserts.assertString(goog.string.Const.unwrap(justification), \x22must provide justification\x22);\n  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), \x22must provide non-empty justification\x22);\n  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(script);\n};\n/**\n * @param {!goog.string.Const} justification\n * @param {string} style\n * @return {!goog.html.SafeStyle}\n */\ngoog.html.uncheckedconversions.safeStyleFromStringKnownToSatisfyTypeContract \x3d function(justification, style) {\n  goog.asserts.assertString(goog.string.Const.unwrap(justification), \x22must provide justification\x22);\n  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), \x22must provide non-empty justification\x22);\n  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style);\n};\n/**\n * @param {!goog.string.Const} justification\n * @param {string} styleSheet\n * @return {!goog.html.SafeStyleSheet}\n */\ngoog.html.uncheckedconversions.safeStyleSheetFromStringKnownToSatisfyTypeContract \x3d function(justification, styleSheet) {\n  goog.asserts.assertString(goog.string.Const.unwrap(justification), \x22must provide justification\x22);\n  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), \x22must provide non-empty justification\x22);\n  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheet);\n};\n/**\n * @param {!goog.string.Const} justification\n * @param {string} url\n * @return {!goog.html.SafeUrl}\n */\ngoog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract \x3d function(justification, url) {\n  goog.asserts.assertString(goog.string.Const.unwrap(justification), \x22must provide justification\x22);\n  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), \x22must provide non-empty justification\x22);\n  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);\n};\n/**\n * @param {!goog.string.Const} justification\n * @param {string} url\n * @return {!goog.html.TrustedResourceUrl}\n */\ngoog.html.uncheckedconversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract \x3d function(justification, url) {\n  goog.asserts.assertString(goog.string.Const.unwrap(justification), \x22must provide justification\x22);\n  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), \x22must provide non-empty justification\x22);\n  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(url);\n};\n");
SHADOW_ENV.evalLoad("goog.dom.safe.js", true , "goog.provide(\x22goog.dom.safe\x22);\ngoog.provide(\x22goog.dom.safe.InsertAdjacentHtmlPosition\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.dom.asserts\x22);\ngoog.require(\x22goog.functions\x22);\ngoog.require(\x22goog.html.SafeHtml\x22);\ngoog.require(\x22goog.html.SafeScript\x22);\ngoog.require(\x22goog.html.SafeStyle\x22);\ngoog.require(\x22goog.html.SafeUrl\x22);\ngoog.require(\x22goog.html.TrustedResourceUrl\x22);\ngoog.require(\x22goog.html.uncheckedconversions\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.internal\x22);\n/** @enum {string} */ goog.dom.safe.InsertAdjacentHtmlPosition \x3d {AFTERBEGIN:\x22afterbegin\x22, AFTEREND:\x22afterend\x22, BEFOREBEGIN:\x22beforebegin\x22, BEFOREEND:\x22beforeend\x22};\n/**\n * @param {!Node} node\n * @param {!goog.dom.safe.InsertAdjacentHtmlPosition} position\n * @param {!goog.html.SafeHtml} html\n */\ngoog.dom.safe.insertAdjacentHtml \x3d function(node, position, html) {\n  node.insertAdjacentHTML(position, goog.html.SafeHtml.unwrapTrustedHTML(html));\n};\n/** @private @const @type {!Object\x3cstring,boolean\x3e} */ goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_ \x3d {\x22MATH\x22:true, \x22SCRIPT\x22:true, \x22STYLE\x22:true, \x22SVG\x22:true, \x22TEMPLATE\x22:true};\n/**\n * @private\n * @return {boolean}\n */\ngoog.dom.safe.isInnerHtmlCleanupRecursive_ \x3d goog.functions.cacheReturnValue(function() {\n  if (goog.DEBUG \x26\x26 typeof document \x3d\x3d\x3d \x22undefined\x22) {\n    return false;\n  }\n  var div \x3d document.createElement(\x22div\x22);\n  var childDiv \x3d document.createElement(\x22div\x22);\n  childDiv.appendChild(document.createElement(\x22div\x22));\n  div.appendChild(childDiv);\n  if (goog.DEBUG \x26\x26 !div.firstChild) {\n    return false;\n  }\n  var innerChild \x3d div.firstChild.firstChild;\n  div.innerHTML \x3d goog.html.SafeHtml.unwrapTrustedHTML(goog.html.SafeHtml.EMPTY);\n  return !innerChild.parentElement;\n});\n/**\n * @param {?Element} elem\n * @param {!goog.html.SafeHtml} html\n */\ngoog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse \x3d function(elem, html) {\n  if (goog.dom.safe.isInnerHtmlCleanupRecursive_()) {\n    while (elem.lastChild) {\n      elem.removeChild(elem.lastChild);\n    }\n  }\n  elem.innerHTML \x3d goog.html.SafeHtml.unwrapTrustedHTML(html);\n};\n/**\n * @param {!Element} elem\n * @param {!goog.html.SafeHtml} html\n * @throws {Error}\n */\ngoog.dom.safe.setInnerHtml \x3d function(elem, html) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    var tagName \x3d elem.tagName.toUpperCase();\n    if (goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_[tagName]) {\n      throw new Error(\x22goog.dom.safe.setInnerHtml cannot be used to set content of \x22 + elem.tagName + \x22.\x22);\n    }\n  }\n  goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse(elem, html);\n};\n/**\n * @param {!Element} elem\n * @param {!goog.html.SafeHtml} html\n */\ngoog.dom.safe.setOuterHtml \x3d function(elem, html) {\n  elem.outerHTML \x3d goog.html.SafeHtml.unwrapTrustedHTML(html);\n};\n/**\n * @param {!Element} form\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setFormElementAction \x3d function(form, url) {\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  goog.dom.asserts.assertIsHTMLFormElement(form).action \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!Element} button\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setButtonFormAction \x3d function(button, url) {\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  goog.dom.asserts.assertIsHTMLButtonElement(button).formAction \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!Element} input\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setInputFormAction \x3d function(input, url) {\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  goog.dom.asserts.assertIsHTMLInputElement(input).formAction \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!Element} elem\n * @param {!goog.html.SafeStyle} style\n */\ngoog.dom.safe.setStyle \x3d function(elem, style) {\n  elem.style.cssText \x3d goog.html.SafeStyle.unwrap(style);\n};\n/**\n * @param {!Document} doc\n * @param {!goog.html.SafeHtml} html\n */\ngoog.dom.safe.documentWrite \x3d function(doc, html) {\n  doc.write(goog.html.SafeHtml.unwrapTrustedHTML(html));\n};\n/**\n * @param {!HTMLAnchorElement} anchor\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setAnchorHref \x3d function(anchor, url) {\n  goog.dom.asserts.assertIsHTMLAnchorElement(anchor);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  anchor.href \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!HTMLImageElement} imageElement\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setImageSrc \x3d function(imageElement, url) {\n  goog.dom.asserts.assertIsHTMLImageElement(imageElement);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    var allowDataUrl \x3d /^data:image\\//i.test(url);\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url, allowDataUrl);\n  }\n  imageElement.src \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!HTMLAudioElement} audioElement\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setAudioSrc \x3d function(audioElement, url) {\n  goog.dom.asserts.assertIsHTMLAudioElement(audioElement);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    var allowDataUrl \x3d /^data:audio\\//i.test(url);\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url, allowDataUrl);\n  }\n  audioElement.src \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!HTMLVideoElement} videoElement\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setVideoSrc \x3d function(videoElement, url) {\n  goog.dom.asserts.assertIsHTMLVideoElement(videoElement);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    var allowDataUrl \x3d /^data:video\\//i.test(url);\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url, allowDataUrl);\n  }\n  videoElement.src \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!HTMLEmbedElement} embed\n * @param {!goog.html.TrustedResourceUrl} url\n */\ngoog.dom.safe.setEmbedSrc \x3d function(embed, url) {\n  goog.dom.asserts.assertIsHTMLEmbedElement(embed);\n  embed.src \x3d goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(url);\n};\n/**\n * @param {!HTMLFrameElement} frame\n * @param {!goog.html.TrustedResourceUrl} url\n */\ngoog.dom.safe.setFrameSrc \x3d function(frame, url) {\n  goog.dom.asserts.assertIsHTMLFrameElement(frame);\n  frame.src \x3d goog.html.TrustedResourceUrl.unwrap(url);\n};\n/**\n * @param {!HTMLIFrameElement} iframe\n * @param {!goog.html.TrustedResourceUrl} url\n */\ngoog.dom.safe.setIframeSrc \x3d function(iframe, url) {\n  goog.dom.asserts.assertIsHTMLIFrameElement(iframe);\n  iframe.src \x3d goog.html.TrustedResourceUrl.unwrap(url);\n};\n/**\n * @param {!HTMLIFrameElement} iframe\n * @param {!goog.html.SafeHtml} html\n */\ngoog.dom.safe.setIframeSrcdoc \x3d function(iframe, html) {\n  goog.dom.asserts.assertIsHTMLIFrameElement(iframe);\n  iframe.srcdoc \x3d goog.html.SafeHtml.unwrapTrustedHTML(html);\n};\n/**\n * @param {!HTMLLinkElement} link\n * @param {(string|!goog.html.SafeUrl|!goog.html.TrustedResourceUrl)} url\n * @param {string} rel\n * @throws {Error}\n */\ngoog.dom.safe.setLinkHrefAndRel \x3d function(link, url, rel) {\n  goog.dom.asserts.assertIsHTMLLinkElement(link);\n  link.rel \x3d rel;\n  if (goog.string.internal.caseInsensitiveContains(rel, \x22stylesheet\x22)) {\n    goog.asserts.assert(url instanceof goog.html.TrustedResourceUrl, \x27URL must be TrustedResourceUrl because \x22rel\x22 contains \x22stylesheet\x22\x27);\n    link.href \x3d goog.html.TrustedResourceUrl.unwrap(url);\n  } else {\n    if (url instanceof goog.html.TrustedResourceUrl) {\n      link.href \x3d goog.html.TrustedResourceUrl.unwrap(url);\n    } else {\n      if (url instanceof goog.html.SafeUrl) {\n        link.href \x3d goog.html.SafeUrl.unwrap(url);\n      } else {\n        link.href \x3d goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitizeAssertUnchanged(url));\n      }\n    }\n  }\n};\n/**\n * @param {!HTMLObjectElement} object\n * @param {!goog.html.TrustedResourceUrl} url\n */\ngoog.dom.safe.setObjectData \x3d function(object, url) {\n  goog.dom.asserts.assertIsHTMLObjectElement(object);\n  object.data \x3d goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(url);\n};\n/**\n * @param {!HTMLScriptElement} script\n * @param {!goog.html.TrustedResourceUrl} url\n */\ngoog.dom.safe.setScriptSrc \x3d function(script, url) {\n  goog.dom.asserts.assertIsHTMLScriptElement(script);\n  script.src \x3d goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(url);\n  var nonce \x3d goog.getScriptNonce();\n  if (nonce) {\n    script.setAttribute(\x22nonce\x22, nonce);\n  }\n};\n/**\n * @param {!HTMLScriptElement} script\n * @param {!goog.html.SafeScript} content\n */\ngoog.dom.safe.setScriptContent \x3d function(script, content) {\n  goog.dom.asserts.assertIsHTMLScriptElement(script);\n  script.text \x3d goog.html.SafeScript.unwrapTrustedScript(content);\n  var nonce \x3d goog.getScriptNonce();\n  if (nonce) {\n    script.setAttribute(\x22nonce\x22, nonce);\n  }\n};\n/**\n * @param {!Location} loc\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.setLocationHref \x3d function(loc, url) {\n  goog.dom.asserts.assertIsLocation(loc);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  loc.href \x3d goog.html.SafeUrl.unwrap(safeUrl);\n};\n/**\n * @param {!Location} loc\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.assignLocation \x3d function(loc, url) {\n  goog.dom.asserts.assertIsLocation(loc);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  loc.assign(goog.html.SafeUrl.unwrap(safeUrl));\n};\n/**\n * @param {!Location} loc\n * @param {(string|!goog.html.SafeUrl)} url\n */\ngoog.dom.safe.replaceLocation \x3d function(loc, url) {\n  goog.dom.asserts.assertIsLocation(loc);\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  loc.replace(goog.html.SafeUrl.unwrap(safeUrl));\n};\n/**\n * @param {(string|!goog.html.SafeUrl)} url\n * @param {Window\x3d} opt_openerWin\n * @param {!goog.string.Const\x3d} opt_name\n * @param {string\x3d} opt_specs\n * @param {boolean\x3d} opt_replace\n * @return {Window}\n */\ngoog.dom.safe.openInWindow \x3d function(url, opt_openerWin, opt_name, opt_specs, opt_replace) {\n  /** @type {!goog.html.SafeUrl} */ var safeUrl;\n  if (url instanceof goog.html.SafeUrl) {\n    safeUrl \x3d url;\n  } else {\n    safeUrl \x3d goog.html.SafeUrl.sanitizeAssertUnchanged(url);\n  }\n  var win \x3d opt_openerWin || goog.global;\n  return win.open(goog.html.SafeUrl.unwrap(safeUrl), opt_name ? goog.string.Const.unwrap(opt_name) : \x22\x22, opt_specs, opt_replace);\n};\n/**\n * @param {!DOMParser} parser\n * @param {!goog.html.SafeHtml} html\n * @return {?Document}\n */\ngoog.dom.safe.parseFromStringHtml \x3d function(parser, html) {\n  return goog.dom.safe.parseFromString(parser, html, \x22text/html\x22);\n};\n/**\n * @param {!DOMParser} parser\n * @param {!goog.html.SafeHtml} content\n * @param {string} type\n * @return {?Document}\n */\ngoog.dom.safe.parseFromString \x3d function(parser, content, type) {\n  return parser.parseFromString(goog.html.SafeHtml.unwrapTrustedHTML(content), type);\n};\n/**\n * @param {!Blob} blob\n * @return {!HTMLImageElement}\n * @throws {!Error}\n */\ngoog.dom.safe.createImageFromBlob \x3d function(blob) {\n  if (!/^image\\/.*/g.test(blob.type)) {\n    throw new Error(\x22goog.dom.safe.createImageFromBlob only accepts MIME type image/.*.\x22);\n  }\n  var objectUrl \x3d goog.global.URL.createObjectURL(blob);\n  var image \x3d new goog.global.Image;\n  image.onload \x3d function() {\n    goog.global.URL.revokeObjectURL(objectUrl);\n  };\n  goog.dom.safe.setImageSrc(image, goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract(goog.string.Const.from(\x22Image blob URL.\x22), objectUrl));\n  return image;\n};\n");
SHADOW_ENV.evalLoad("goog.string.string.js", true , "goog.provide(\x22goog.string\x22);\ngoog.provide(\x22goog.string.Unicode\x22);\ngoog.require(\x22goog.dom.safe\x22);\ngoog.require(\x22goog.html.uncheckedconversions\x22);\ngoog.require(\x22goog.string.Const\x22);\ngoog.require(\x22goog.string.internal\x22);\n/** @define {boolean} */ goog.string.DETECT_DOUBLE_ESCAPING \x3d goog.define(\x22goog.string.DETECT_DOUBLE_ESCAPING\x22, false);\n/** @define {boolean} */ goog.string.FORCE_NON_DOM_HTML_UNESCAPING \x3d goog.define(\x22goog.string.FORCE_NON_DOM_HTML_UNESCAPING\x22, false);\n/** @enum {string} */ goog.string.Unicode \x3d {NBSP:\x22\xa0\x22};\n/**\n * @param {string} str\n * @param {string} prefix\n * @return {boolean}\n */\ngoog.string.startsWith \x3d goog.string.internal.startsWith;\n/**\n * @param {string} str\n * @param {string} suffix\n * @return {boolean}\n */\ngoog.string.endsWith \x3d goog.string.internal.endsWith;\n/**\n * @param {string} str\n * @param {string} prefix\n * @return {boolean}\n */\ngoog.string.caseInsensitiveStartsWith \x3d goog.string.internal.caseInsensitiveStartsWith;\n/**\n * @param {string} str\n * @param {string} suffix\n * @return {boolean}\n */\ngoog.string.caseInsensitiveEndsWith \x3d goog.string.internal.caseInsensitiveEndsWith;\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {boolean}\n */\ngoog.string.caseInsensitiveEquals \x3d goog.string.internal.caseInsensitiveEquals;\n/**\n * @param {string} str\n * @param {...*} var_args\n * @return {string}\n */\ngoog.string.subs \x3d function(str, var_args) {\n  var splitParts \x3d str.split(\x22%s\x22);\n  var returnString \x3d \x22\x22;\n  var subsArguments \x3d Array.prototype.slice.call(arguments, 1);\n  while (subsArguments.length \x26\x26 splitParts.length \x3e 1) {\n    returnString +\x3d splitParts.shift() + subsArguments.shift();\n  }\n  return returnString + splitParts.join(\x22%s\x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.collapseWhitespace \x3d function(str) {\n  return str.replace(/[\\s\\xa0]+/g, \x22 \x22).replace(/^\\s+|\\s+$/g, \x22\x22);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isEmptyOrWhitespace \x3d goog.string.internal.isEmptyOrWhitespace;\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isEmptyString \x3d function(str) {\n  return str.length \x3d\x3d 0;\n};\n/**\n * @param {string} str\n * @return {boolean}\n * @deprecated Use goog.string.isEmptyOrWhitespace instead.\n */\ngoog.string.isEmpty \x3d goog.string.isEmptyOrWhitespace;\n/**\n * @param {*} str\n * @return {boolean}\n * @deprecated Use goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str)) instead.\n */\ngoog.string.isEmptyOrWhitespaceSafe \x3d function(str) {\n  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));\n};\n/**\n * @param {*} str\n * @return {boolean}\n * @deprecated Use goog.string.isEmptyOrWhitespace instead.\n */\ngoog.string.isEmptySafe \x3d goog.string.isEmptyOrWhitespaceSafe;\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isBreakingWhitespace \x3d function(str) {\n  return !/[^\\t\\n\\r ]/.test(str);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isAlpha \x3d function(str) {\n  return !/[^a-zA-Z]/.test(str);\n};\n/**\n * @param {*} str\n * @return {boolean}\n */\ngoog.string.isNumeric \x3d function(str) {\n  return !/[^0-9]/.test(str);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isAlphaNumeric \x3d function(str) {\n  return !/[^a-zA-Z0-9]/.test(str);\n};\n/**\n * @param {string} ch\n * @return {boolean}\n */\ngoog.string.isSpace \x3d function(ch) {\n  return ch \x3d\x3d \x22 \x22;\n};\n/**\n * @param {string} ch\n * @return {boolean}\n */\ngoog.string.isUnicodeChar \x3d function(ch) {\n  return ch.length \x3d\x3d 1 \x26\x26 ch \x3e\x3d \x22 \x22 \x26\x26 ch \x3c\x3d \x22~\x22 || ch \x3e\x3d \x22\x80\x22 \x26\x26 ch \x3c\x3d \x22\ufffd\x22;\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.stripNewlines \x3d function(str) {\n  return str.replace(/(\\r\\n|\\r|\\n)+/g, \x22 \x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.canonicalizeNewlines \x3d function(str) {\n  return str.replace(/(\\r\\n|\\r|\\n)/g, \x22\\n\x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.normalizeWhitespace \x3d function(str) {\n  return str.replace(/\\xa0|\\s/g, \x22 \x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.normalizeSpaces \x3d function(str) {\n  return str.replace(/\\xa0|[ \\t]+/g, \x22 \x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.collapseBreakingSpaces \x3d function(str) {\n  return str.replace(/[\\t\\r\\n ]+/g, \x22 \x22).replace(/^[\\t\\r\\n ]+|[\\t\\r\\n ]+$/g, \x22\x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.trim \x3d goog.string.internal.trim;\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.trimLeft \x3d function(str) {\n  return str.replace(/^[\\s\\xa0]+/, \x22\x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.trimRight \x3d function(str) {\n  return str.replace(/[\\s\\xa0]+$/, \x22\x22);\n};\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {number}\n */\ngoog.string.caseInsensitiveCompare \x3d goog.string.internal.caseInsensitiveCompare;\n/**\n * @private\n * @param {string} str1\n * @param {string} str2\n * @param {!RegExp} tokenizerRegExp\n * @return {number}\n */\ngoog.string.numberAwareCompare_ \x3d function(str1, str2, tokenizerRegExp) {\n  if (str1 \x3d\x3d str2) {\n    return 0;\n  }\n  if (!str1) {\n    return -1;\n  }\n  if (!str2) {\n    return 1;\n  }\n  var tokens1 \x3d str1.toLowerCase().match(tokenizerRegExp);\n  var tokens2 \x3d str2.toLowerCase().match(tokenizerRegExp);\n  var count \x3d Math.min(tokens1.length, tokens2.length);\n  for (var i \x3d 0; i \x3c count; i++) {\n    var a \x3d tokens1[i];\n    var b \x3d tokens2[i];\n    if (a !\x3d b) {\n      var num1 \x3d parseInt(a, 10);\n      if (!isNaN(num1)) {\n        var num2 \x3d parseInt(b, 10);\n        if (!isNaN(num2) \x26\x26 num1 - num2) {\n          return num1 - num2;\n        }\n      }\n      return a \x3c b ? -1 : 1;\n    }\n  }\n  if (tokens1.length !\x3d tokens2.length) {\n    return tokens1.length - tokens2.length;\n  }\n  return str1 \x3c str2 ? -1 : 1;\n};\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {number}\n */\ngoog.string.intAwareCompare \x3d function(str1, str2) {\n  return goog.string.numberAwareCompare_(str1, str2, /\\d+|\\D+/g);\n};\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {number}\n */\ngoog.string.floatAwareCompare \x3d function(str1, str2) {\n  return goog.string.numberAwareCompare_(str1, str2, /\\d+|\\.\\d+|\\D+/g);\n};\n/**\n * @param {string} str1\n * @param {string} str2\n * @return {number}\n */\ngoog.string.numerateCompare \x3d goog.string.floatAwareCompare;\n/**\n * @param {*} str\n * @return {string}\n */\ngoog.string.urlEncode \x3d function(str) {\n  return encodeURIComponent(String(str));\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.urlDecode \x3d function(str) {\n  return decodeURIComponent(str.replace(/\\+/g, \x22 \x22));\n};\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_xml\n * @return {string}\n */\ngoog.string.newLineToBr \x3d goog.string.internal.newLineToBr;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_isLikelyToContainHtmlChars\n * @return {string}\n */\ngoog.string.htmlEscape \x3d function(str, opt_isLikelyToContainHtmlChars) {\n  str \x3d goog.string.internal.htmlEscape(str, opt_isLikelyToContainHtmlChars);\n  if (goog.string.DETECT_DOUBLE_ESCAPING) {\n    str \x3d str.replace(goog.string.E_RE_, \x22\\x26#101;\x22);\n  }\n  return str;\n};\n/** @private @const @type {!RegExp} */ goog.string.E_RE_ \x3d /e/g;\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.unescapeEntities \x3d function(str) {\n  if (goog.string.contains(str, \x22\\x26\x22)) {\n    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING \x26\x26 \x22document\x22 in goog.global) {\n      return goog.string.unescapeEntitiesUsingDom_(str);\n    } else {\n      return goog.string.unescapePureXmlEntities_(str);\n    }\n  }\n  return str;\n};\n/**\n * @param {string} str\n * @param {!Document} document\n * @return {string}\n */\ngoog.string.unescapeEntitiesWithDocument \x3d function(str, document) {\n  if (goog.string.contains(str, \x22\\x26\x22)) {\n    return goog.string.unescapeEntitiesUsingDom_(str, document);\n  }\n  return str;\n};\n/**\n * @private\n * @param {string} str\n * @param {Document\x3d} opt_document\n * @return {string}\n */\ngoog.string.unescapeEntitiesUsingDom_ \x3d function(str, opt_document) {\n  /** @type {!Object\x3cstring,string\x3e} */ var seen \x3d {\x22\\x26amp;\x22:\x22\\x26\x22, \x22\\x26lt;\x22:\x22\\x3c\x22, \x22\\x26gt;\x22:\x22\\x3e\x22, \x22\\x26quot;\x22:\x27\x22\x27};\n  /** @type {!Element} */ var div;\n  if (opt_document) {\n    div \x3d opt_document.createElement(\x22div\x22);\n  } else {\n    div \x3d goog.global.document.createElement(\x22div\x22);\n  }\n  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {\n    var value \x3d seen[s];\n    if (value) {\n      return value;\n    }\n    if (entity.charAt(0) \x3d\x3d \x22#\x22) {\n      var n \x3d Number(\x220\x22 + entity.substr(1));\n      if (!isNaN(n)) {\n        value \x3d String.fromCharCode(n);\n      }\n    }\n    if (!value) {\n      goog.dom.safe.setInnerHtml(div, goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from(\x22Single HTML entity.\x22), s + \x22 \x22));\n      value \x3d div.firstChild.nodeValue.slice(0, -1);\n    }\n    return seen[s] \x3d value;\n  });\n};\n/**\n * @private\n * @param {string} str\n * @return {string}\n */\ngoog.string.unescapePureXmlEntities_ \x3d function(str) {\n  return str.replace(/\x26([^;]+);/g, function(s, entity) {\n    switch(entity) {\n      case \x22amp\x22:\n        return \x22\\x26\x22;\n      case \x22lt\x22:\n        return \x22\\x3c\x22;\n      case \x22gt\x22:\n        return \x22\\x3e\x22;\n      case \x22quot\x22:\n        return \x27\x22\x27;\n      default:\n        if (entity.charAt(0) \x3d\x3d \x22#\x22) {\n          var n \x3d Number(\x220\x22 + entity.substr(1));\n          if (!isNaN(n)) {\n            return String.fromCharCode(n);\n          }\n        }\n        return s;\n    }\n  });\n};\n/** @private @type {!RegExp} */ goog.string.HTML_ENTITY_PATTERN_ \x3d /\x26([^;\\s\x3c\x26]+);?/g;\n/**\n * @param {string} str\n * @param {boolean\x3d} opt_xml\n * @return {string}\n */\ngoog.string.whitespaceEscape \x3d function(str, opt_xml) {\n  return goog.string.newLineToBr(str.replace(/  /g, \x22 \\x26#160;\x22), opt_xml);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.preserveSpaces \x3d function(str) {\n  return str.replace(/(^|[\\n ]) /g, \x22$1\x22 + goog.string.Unicode.NBSP);\n};\n/**\n * @param {string} str\n * @param {string} quoteChars\n * @return {string}\n */\ngoog.string.stripQuotes \x3d function(str, quoteChars) {\n  var length \x3d quoteChars.length;\n  for (var i \x3d 0; i \x3c length; i++) {\n    var quoteChar \x3d length \x3d\x3d 1 ? quoteChars : quoteChars.charAt(i);\n    if (str.charAt(0) \x3d\x3d quoteChar \x26\x26 str.charAt(str.length - 1) \x3d\x3d quoteChar) {\n      return str.substring(1, str.length - 1);\n    }\n  }\n  return str;\n};\n/**\n * @param {string} str\n * @param {number} chars\n * @param {boolean\x3d} opt_protectEscapedCharacters\n * @return {string}\n */\ngoog.string.truncate \x3d function(str, chars, opt_protectEscapedCharacters) {\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.unescapeEntities(str);\n  }\n  if (str.length \x3e chars) {\n    str \x3d str.substring(0, chars - 3) + \x22...\x22;\n  }\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.htmlEscape(str);\n  }\n  return str;\n};\n/**\n * @param {string} str\n * @param {number} chars\n * @param {boolean\x3d} opt_protectEscapedCharacters\n * @param {number\x3d} opt_trailingChars\n * @return {string}\n */\ngoog.string.truncateMiddle \x3d function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.unescapeEntities(str);\n  }\n  if (opt_trailingChars \x26\x26 str.length \x3e chars) {\n    if (opt_trailingChars \x3e chars) {\n      opt_trailingChars \x3d chars;\n    }\n    var endPoint \x3d str.length - opt_trailingChars;\n    var startPoint \x3d chars - opt_trailingChars;\n    str \x3d str.substring(0, startPoint) + \x22...\x22 + str.substring(endPoint);\n  } else {\n    if (str.length \x3e chars) {\n      var half \x3d Math.floor(chars / 2);\n      var endPos \x3d str.length - half;\n      half +\x3d chars % 2;\n      str \x3d str.substring(0, half) + \x22...\x22 + str.substring(endPos);\n    }\n  }\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.htmlEscape(str);\n  }\n  return str;\n};\n/** @private @type {!Object\x3cstring,string\x3e} */ goog.string.specialEscapeChars_ \x3d {\x22\\x00\x22:\x22\\\\0\x22, \x22\\b\x22:\x22\\\\b\x22, \x22\\f\x22:\x22\\\\f\x22, \x22\\n\x22:\x22\\\\n\x22, \x22\\r\x22:\x22\\\\r\x22, \x22\\t\x22:\x22\\\\t\x22, \x22\\x0B\x22:\x22\\\\x0B\x22, \x27\x22\x27:\x27\\\\\x22\x27, \x22\\\\\x22:\x22\\\\\\\\\x22, \x22\\x3c\x22:\x22\\\\u003C\x22};\n/** @private @type {!Object\x3cstring,string\x3e} */ goog.string.jsEscapeCache_ \x3d {\x22\x27\x22:\x22\\\\\x27\x22};\n/**\n * @param {string} s\n * @return {string}\n */\ngoog.string.quote \x3d function(s) {\n  s \x3d String(s);\n  var sb \x3d [\x27\x22\x27];\n  for (var i \x3d 0; i \x3c s.length; i++) {\n    var ch \x3d s.charAt(i);\n    var cc \x3d ch.charCodeAt(0);\n    sb[i + 1] \x3d goog.string.specialEscapeChars_[ch] || (cc \x3e 31 \x26\x26 cc \x3c 127 ? ch : goog.string.escapeChar(ch));\n  }\n  sb.push(\x27\x22\x27);\n  return sb.join(\x22\x22);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.escapeString \x3d function(str) {\n  var sb \x3d [];\n  for (var i \x3d 0; i \x3c str.length; i++) {\n    sb[i] \x3d goog.string.escapeChar(str.charAt(i));\n  }\n  return sb.join(\x22\x22);\n};\n/**\n * @param {string} c\n * @return {string}\n */\ngoog.string.escapeChar \x3d function(c) {\n  if (c in goog.string.jsEscapeCache_) {\n    return goog.string.jsEscapeCache_[c];\n  }\n  if (c in goog.string.specialEscapeChars_) {\n    return goog.string.jsEscapeCache_[c] \x3d goog.string.specialEscapeChars_[c];\n  }\n  var rv \x3d c;\n  var cc \x3d c.charCodeAt(0);\n  if (cc \x3e 31 \x26\x26 cc \x3c 127) {\n    rv \x3d c;\n  } else {\n    if (cc \x3c 256) {\n      rv \x3d \x22\\\\x\x22;\n      if (cc \x3c 16 || cc \x3e 256) {\n        rv +\x3d \x220\x22;\n      }\n    } else {\n      rv \x3d \x22\\\\u\x22;\n      if (cc \x3c 4096) {\n        rv +\x3d \x220\x22;\n      }\n    }\n    rv +\x3d cc.toString(16).toUpperCase();\n  }\n  return goog.string.jsEscapeCache_[c] \x3d rv;\n};\n/**\n * @param {string} str\n * @param {string} subString\n * @return {boolean}\n */\ngoog.string.contains \x3d goog.string.internal.contains;\n/**\n * @param {string} str\n * @param {string} subString\n * @return {boolean}\n */\ngoog.string.caseInsensitiveContains \x3d goog.string.internal.caseInsensitiveContains;\n/**\n * @param {string} s\n * @param {string} ss\n * @return {number}\n */\ngoog.string.countOf \x3d function(s, ss) {\n  return s \x26\x26 ss ? s.split(ss).length - 1 : 0;\n};\n/**\n * @param {string} s\n * @param {number} index\n * @param {number} stringLength\n * @return {string}\n */\ngoog.string.removeAt \x3d function(s, index, stringLength) {\n  var resultStr \x3d s;\n  if (index \x3e\x3d 0 \x26\x26 index \x3c s.length \x26\x26 stringLength \x3e 0) {\n    resultStr \x3d s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);\n  }\n  return resultStr;\n};\n/**\n * @param {string} str\n * @param {string} substr\n * @return {string}\n */\ngoog.string.remove \x3d function(str, substr) {\n  return str.replace(substr, \x22\x22);\n};\n/**\n * @param {string} s\n * @param {string} ss\n * @return {string}\n */\ngoog.string.removeAll \x3d function(s, ss) {\n  var re \x3d new RegExp(goog.string.regExpEscape(ss), \x22g\x22);\n  return s.replace(re, \x22\x22);\n};\n/**\n * @param {string} s\n * @param {string} ss\n * @param {string} replacement\n * @return {string}\n */\ngoog.string.replaceAll \x3d function(s, ss, replacement) {\n  var re \x3d new RegExp(goog.string.regExpEscape(ss), \x22g\x22);\n  return s.replace(re, replacement.replace(/\\$/g, \x22$$$$\x22));\n};\n/**\n * @param {*} s\n * @return {string}\n */\ngoog.string.regExpEscape \x3d function(s) {\n  return String(s).replace(/([-()\\[\\]{}+?*.$\\^|,:#\x3c!\\\\])/g, \x22\\\\$1\x22).replace(/\\x08/g, \x22\\\\x08\x22);\n};\n/**\n * @param {string} string\n * @param {number} length\n * @return {string}\n */\ngoog.string.repeat \x3d String.prototype.repeat ? function(string, length) {\n  return string.repeat(length);\n} : function(string, length) {\n  return (new Array(length + 1)).join(string);\n};\n/**\n * @param {number} num\n * @param {number} length\n * @param {number\x3d} opt_precision\n * @return {string}\n */\ngoog.string.padNumber \x3d function(num, length, opt_precision) {\n  var s \x3d opt_precision !\x3d\x3d undefined ? num.toFixed(opt_precision) : String(num);\n  var index \x3d s.indexOf(\x22.\x22);\n  if (index \x3d\x3d -1) {\n    index \x3d s.length;\n  }\n  return goog.string.repeat(\x220\x22, Math.max(0, length - index)) + s;\n};\n/**\n * @param {*} obj\n * @return {string}\n */\ngoog.string.makeSafe \x3d function(obj) {\n  return obj \x3d\x3d null ? \x22\x22 : String(obj);\n};\n/**\n * @param {...*} var_args\n * @return {string}\n */\ngoog.string.buildString \x3d function(var_args) {\n  return Array.prototype.join.call(arguments, \x22\x22);\n};\n/**\n * @return {string}\n */\ngoog.string.getRandomString \x3d function() {\n  var x \x3d 2147483648;\n  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);\n};\n/**\n * @param {(string|number)} version1\n * @param {(string|number)} version2\n * @return {number}\n */\ngoog.string.compareVersions \x3d goog.string.internal.compareVersions;\n/**\n * @param {string} str\n * @return {number}\n */\ngoog.string.hashCode \x3d function(str) {\n  var result \x3d 0;\n  for (var i \x3d 0; i \x3c str.length; ++i) {\n    result \x3d 31 * result + str.charCodeAt(i) \x3e\x3e\x3e 0;\n  }\n  return result;\n};\n/** @private @type {number} */ goog.string.uniqueStringCounter_ \x3d Math.random() * 2147483648 | 0;\n/**\n * @return {string}\n */\ngoog.string.createUniqueString \x3d function() {\n  return \x22goog_\x22 + goog.string.uniqueStringCounter_++;\n};\n/**\n * @param {string} str\n * @return {number}\n */\ngoog.string.toNumber \x3d function(str) {\n  var num \x3d Number(str);\n  if (num \x3d\x3d 0 \x26\x26 goog.string.isEmptyOrWhitespace(str)) {\n    return NaN;\n  }\n  return num;\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isLowerCamelCase \x3d function(str) {\n  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);\n};\n/**\n * @param {string} str\n * @return {boolean}\n */\ngoog.string.isUpperCamelCase \x3d function(str) {\n  return /^([A-Z][a-z]*)+$/.test(str);\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.toCamelCase \x3d function(str) {\n  return String(str).replace(/\\-([a-z])/g, function(all, match) {\n    return match.toUpperCase();\n  });\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.toSelectorCase \x3d function(str) {\n  return String(str).replace(/([A-Z])/g, \x22-$1\x22).toLowerCase();\n};\n/**\n * @param {string} str\n * @param {string\x3d} opt_delimiters\n * @return {string}\n */\ngoog.string.toTitleCase \x3d function(str, opt_delimiters) {\n  var delimiters \x3d typeof opt_delimiters \x3d\x3d\x3d \x22string\x22 ? goog.string.regExpEscape(opt_delimiters) : \x22\\\\s\x22;\n  delimiters \x3d delimiters ? \x22|[\x22 + delimiters + \x22]+\x22 : \x22\x22;\n  var regexp \x3d new RegExp(\x22(^\x22 + delimiters + \x22)([a-z])\x22, \x22g\x22);\n  return str.replace(regexp, function(all, p1, p2) {\n    return p1 + p2.toUpperCase();\n  });\n};\n/**\n * @param {string} str\n * @return {string}\n */\ngoog.string.capitalize \x3d function(str) {\n  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();\n};\n/**\n * @param {(string|number|null|undefined)} value\n * @return {number}\n */\ngoog.string.parseInt \x3d function(value) {\n  if (isFinite(value)) {\n    value \x3d String(value);\n  }\n  if (typeof value \x3d\x3d\x3d \x22string\x22) {\n    return /^\\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);\n  }\n  return NaN;\n};\n/**\n * @param {string} str\n * @param {string} separator\n * @param {number} limit\n * @return {!Array\x3cstring\x3e}\n */\ngoog.string.splitLimit \x3d function(str, separator, limit) {\n  var parts \x3d str.split(separator);\n  var returnVal \x3d [];\n  while (limit \x3e 0 \x26\x26 parts.length) {\n    returnVal.push(parts.shift());\n    limit--;\n  }\n  if (parts.length) {\n    returnVal.push(parts.join(separator));\n  }\n  return returnVal;\n};\n/**\n * @param {string} str\n * @param {(string|!Array\x3cstring\x3e)} separators\n * @return {string}\n */\ngoog.string.lastComponent \x3d function(str, separators) {\n  if (!separators) {\n    return str;\n  } else {\n    if (typeof separators \x3d\x3d \x22string\x22) {\n      separators \x3d [separators];\n    }\n  }\n  var lastSeparatorIndex \x3d -1;\n  for (var i \x3d 0; i \x3c separators.length; i++) {\n    if (separators[i] \x3d\x3d \x22\x22) {\n      continue;\n    }\n    var currentSeparatorIndex \x3d str.lastIndexOf(separators[i]);\n    if (currentSeparatorIndex \x3e lastSeparatorIndex) {\n      lastSeparatorIndex \x3d currentSeparatorIndex;\n    }\n  }\n  if (lastSeparatorIndex \x3d\x3d -1) {\n    return str;\n  }\n  return str.slice(lastSeparatorIndex + 1);\n};\n/**\n * @param {string} a\n * @param {string} b\n * @return {number}\n */\ngoog.string.editDistance \x3d function(a, b) {\n  var v0 \x3d [];\n  var v1 \x3d [];\n  if (a \x3d\x3d b) {\n    return 0;\n  }\n  if (!a.length || !b.length) {\n    return Math.max(a.length, b.length);\n  }\n  for (var i \x3d 0; i \x3c b.length + 1; i++) {\n    v0[i] \x3d i;\n  }\n  for (var i \x3d 0; i \x3c a.length; i++) {\n    v1[0] \x3d i + 1;\n    for (var j \x3d 0; j \x3c b.length; j++) {\n      var cost \x3d Number(a[i] !\x3d b[j]);\n      v1[j + 1] \x3d Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);\n    }\n    for (var j \x3d 0; j \x3c v0.length; j++) {\n      v0[j] \x3d v1[j];\n    }\n  }\n  return v1[b.length];\n};\n");
SHADOW_ENV.evalLoad("goog.structs.structs.js", true , "/**\n * @suppress {strictMissingProperties}\n */\ngoog.provide(\x22goog.structs\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.object\x22);\n/**\n * @param {Object} col\n * @return {number}\n */\ngoog.structs.getCount \x3d function(col) {\n  if (col.getCount \x26\x26 typeof col.getCount \x3d\x3d \x22function\x22) {\n    return col.getCount();\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return col.length;\n  }\n  return goog.object.getCount(col);\n};\n/**\n * @param {Object} col\n * @return {!Array\x3c?\x3e}\n */\ngoog.structs.getValues \x3d function(col) {\n  if (col.getValues \x26\x26 typeof col.getValues \x3d\x3d \x22function\x22) {\n    return col.getValues();\n  }\n  if (typeof col \x3d\x3d\x3d \x22string\x22) {\n    return col.split(\x22\x22);\n  }\n  if (goog.isArrayLike(col)) {\n    var rv \x3d [];\n    var l \x3d col.length;\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv.push(col[i]);\n    }\n    return rv;\n  }\n  return goog.object.getValues(col);\n};\n/**\n * @param {Object} col\n * @return {(!Array|undefined)}\n */\ngoog.structs.getKeys \x3d function(col) {\n  if (col.getKeys \x26\x26 typeof col.getKeys \x3d\x3d \x22function\x22) {\n    return col.getKeys();\n  }\n  if (col.getValues \x26\x26 typeof col.getValues \x3d\x3d \x22function\x22) {\n    return undefined;\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    var rv \x3d [];\n    var l \x3d col.length;\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv.push(i);\n    }\n    return rv;\n  }\n  return goog.object.getKeys(col);\n};\n/**\n * @param {Object} col\n * @param {*} val\n * @return {boolean}\n */\ngoog.structs.contains \x3d function(col, val) {\n  if (col.contains \x26\x26 typeof col.contains \x3d\x3d \x22function\x22) {\n    return col.contains(val);\n  }\n  if (col.containsValue \x26\x26 typeof col.containsValue \x3d\x3d \x22function\x22) {\n    return col.containsValue(val);\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return goog.array.contains(/** @type {!Array\x3c?\x3e} */ (col), val);\n  }\n  return goog.object.containsValue(col, val);\n};\n/**\n * @param {Object} col\n * @return {boolean}\n */\ngoog.structs.isEmpty \x3d function(col) {\n  if (col.isEmpty \x26\x26 typeof col.isEmpty \x3d\x3d \x22function\x22) {\n    return col.isEmpty();\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return goog.array.isEmpty(/** @type {!Array\x3c?\x3e} */ (col));\n  }\n  return goog.object.isEmpty(col);\n};\n/**\n * @param {Object} col\n */\ngoog.structs.clear \x3d function(col) {\n  if (col.clear \x26\x26 typeof col.clear \x3d\x3d \x22function\x22) {\n    col.clear();\n  } else {\n    if (goog.isArrayLike(col)) {\n      goog.array.clear(/** @type {IArrayLike\x3c?\x3e} */ (col));\n    } else {\n      goog.object.clear(col);\n    }\n  }\n};\n/**\n * @param {S} col\n * @param {function(this:T,?,?,S):?} f\n * @param {T\x3d} opt_obj\n * @template T\n * @template S\n * @deprecated Use a more specific method, e.g. goog.array.forEach, goog.object.forEach, or for-of.\n */\ngoog.structs.forEach \x3d function(col, f, opt_obj) {\n  if (col.forEach \x26\x26 typeof col.forEach \x3d\x3d \x22function\x22) {\n    col.forEach(f, opt_obj);\n  } else {\n    if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n      goog.array.forEach(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n    } else {\n      var keys \x3d goog.structs.getKeys(col);\n      var values \x3d goog.structs.getValues(col);\n      var l \x3d values.length;\n      for (var i \x3d 0; i \x3c l; i++) {\n        f.call(/** @type {?} */ (opt_obj), values[i], keys \x26\x26 keys[i], col);\n      }\n    }\n  }\n};\n/**\n * @param {S} col\n * @param {function(this:T,?,?,S):boolean} f\n * @param {T\x3d} opt_obj\n * @return {(!Object|!Array\x3c?\x3e)}\n * @template T\n * @template S\n */\ngoog.structs.filter \x3d function(col, f, opt_obj) {\n  if (typeof col.filter \x3d\x3d \x22function\x22) {\n    return col.filter(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return goog.array.filter(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n  var rv;\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  if (keys) {\n    rv \x3d {};\n    for (var i \x3d 0; i \x3c l; i++) {\n      if (f.call(/** @type {?} */ (opt_obj), values[i], keys[i], col)) {\n        rv[keys[i]] \x3d values[i];\n      }\n    }\n  } else {\n    rv \x3d [];\n    for (var i \x3d 0; i \x3c l; i++) {\n      if (f.call(opt_obj, values[i], undefined, col)) {\n        rv.push(values[i]);\n      }\n    }\n  }\n  return rv;\n};\n/**\n * @param {S} col\n * @param {function(this:T,?,?,S):V} f\n * @param {T\x3d} opt_obj\n * @return {(!Object\x3c?,V\x3e|!Array\x3cV\x3e)}\n * @template T\n * @template S\n * @template V\n */\ngoog.structs.map \x3d function(col, f, opt_obj) {\n  if (typeof col.map \x3d\x3d \x22function\x22) {\n    return col.map(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return goog.array.map(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n  var rv;\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  if (keys) {\n    rv \x3d {};\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv[keys[i]] \x3d f.call(/** @type {?} */ (opt_obj), values[i], keys[i], col);\n    }\n  } else {\n    rv \x3d [];\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv[i] \x3d f.call(/** @type {?} */ (opt_obj), values[i], undefined, col);\n    }\n  }\n  return rv;\n};\n/**\n * @param {S} col\n * @param {function(this:T,?,?,S):boolean} f\n * @param {T\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template S\n */\ngoog.structs.some \x3d function(col, f, opt_obj) {\n  if (typeof col.some \x3d\x3d \x22function\x22) {\n    return col.some(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return goog.array.some(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (f.call(/** @type {?} */ (opt_obj), values[i], keys \x26\x26 keys[i], col)) {\n      return true;\n    }\n  }\n  return false;\n};\n/**\n * @param {S} col\n * @param {function(this:T,?,?,S):boolean} f\n * @param {T\x3d} opt_obj\n * @return {boolean}\n * @template T\n * @template S\n */\ngoog.structs.every \x3d function(col, f, opt_obj) {\n  if (typeof col.every \x3d\x3d \x22function\x22) {\n    return col.every(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || typeof col \x3d\x3d\x3d \x22string\x22) {\n    return goog.array.every(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (!f.call(/** @type {?} */ (opt_obj), values[i], keys \x26\x26 keys[i], col)) {\n      return false;\n    }\n  }\n  return true;\n};\n");
SHADOW_ENV.evalLoad("goog.math.math.js", true , "goog.provide(\x22goog.math\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\n/**\n * @param {number} a\n * @return {number}\n */\ngoog.math.randomInt \x3d function(a) {\n  return Math.floor(Math.random() * a);\n};\n/**\n * @param {number} a\n * @param {number} b\n * @return {number}\n */\ngoog.math.uniformRandom \x3d function(a, b) {\n  return a + Math.random() * (b - a);\n};\n/**\n * @param {number} value\n * @param {number} min\n * @param {number} max\n * @return {number}\n */\ngoog.math.clamp \x3d function(value, min, max) {\n  return Math.min(Math.max(value, min), max);\n};\n/**\n * @param {number} a\n * @param {number} b\n * @return {number}\n */\ngoog.math.modulo \x3d function(a, b) {\n  var r \x3d a % b;\n  return r * b \x3c 0 ? r + b : r;\n};\n/**\n * @param {number} a\n * @param {number} b\n * @param {number} x\n * @return {number}\n */\ngoog.math.lerp \x3d function(a, b, x) {\n  return a + x * (b - a);\n};\n/**\n * @param {number} a\n * @param {number} b\n * @param {number\x3d} opt_tolerance\n * @return {boolean}\n */\ngoog.math.nearlyEquals \x3d function(a, b, opt_tolerance) {\n  return Math.abs(a - b) \x3c\x3d (opt_tolerance || 0.000001);\n};\n/**\n * @param {number} angle\n * @return {number}\n */\ngoog.math.standardAngle \x3d function(angle) {\n  return goog.math.modulo(angle, 360);\n};\n/**\n * @param {number} angle\n * @return {number}\n */\ngoog.math.standardAngleInRadians \x3d function(angle) {\n  return goog.math.modulo(angle, 2 * Math.PI);\n};\n/**\n * @param {number} angleDegrees\n * @return {number}\n */\ngoog.math.toRadians \x3d function(angleDegrees) {\n  return angleDegrees * Math.PI / 180;\n};\n/**\n * @param {number} angleRadians\n * @return {number}\n */\ngoog.math.toDegrees \x3d function(angleRadians) {\n  return angleRadians * 180 / Math.PI;\n};\n/**\n * @param {number} degrees\n * @param {number} radius\n * @return {number}\n */\ngoog.math.angleDx \x3d function(degrees, radius) {\n  return radius * Math.cos(goog.math.toRadians(degrees));\n};\n/**\n * @param {number} degrees\n * @param {number} radius\n * @return {number}\n */\ngoog.math.angleDy \x3d function(degrees, radius) {\n  return radius * Math.sin(goog.math.toRadians(degrees));\n};\n/**\n * @param {number} x1\n * @param {number} y1\n * @param {number} x2\n * @param {number} y2\n * @return {number}\n */\ngoog.math.angle \x3d function(x1, y1, x2, y2) {\n  return goog.math.standardAngle(goog.math.toDegrees(Math.atan2(y2 - y1, x2 - x1)));\n};\n/**\n * @param {number} startAngle\n * @param {number} endAngle\n * @return {number}\n */\ngoog.math.angleDifference \x3d function(startAngle, endAngle) {\n  var d \x3d goog.math.standardAngle(endAngle) - goog.math.standardAngle(startAngle);\n  if (d \x3e 180) {\n    d \x3d d - 360;\n  } else {\n    if (d \x3c\x3d -180) {\n      d \x3d 360 + d;\n    }\n  }\n  return d;\n};\n/**\n * @param {number} x\n * @return {number}\n */\ngoog.math.sign \x3d function(x) {\n  if (x \x3e 0) {\n    return 1;\n  }\n  if (x \x3c 0) {\n    return -1;\n  }\n  return x;\n};\n/**\n * @param {IArrayLike\x3cS\x3e} array1\n * @param {IArrayLike\x3cT\x3e} array2\n * @param {Function\x3d} opt_compareFn\n * @param {Function\x3d} opt_collectorFn\n * @return {!Array\x3c(S|T)\x3e}\n * @template S\n * @template T\n */\ngoog.math.longestCommonSubsequence \x3d function(array1, array2, opt_compareFn, opt_collectorFn) {\n  var compare \x3d opt_compareFn || function(a, b) {\n    return a \x3d\x3d b;\n  };\n  var collect \x3d opt_collectorFn || function(i1, i2) {\n    return array1[i1];\n  };\n  var length1 \x3d array1.length;\n  var length2 \x3d array2.length;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c length1 + 1; i++) {\n    arr[i] \x3d [];\n    arr[i][0] \x3d 0;\n  }\n  for (var j \x3d 0; j \x3c length2 + 1; j++) {\n    arr[0][j] \x3d 0;\n  }\n  for (i \x3d 1; i \x3c\x3d length1; i++) {\n    for (j \x3d 1; j \x3c\x3d length2; j++) {\n      if (compare(array1[i - 1], array2[j - 1])) {\n        arr[i][j] \x3d arr[i - 1][j - 1] + 1;\n      } else {\n        arr[i][j] \x3d Math.max(arr[i - 1][j], arr[i][j - 1]);\n      }\n    }\n  }\n  var result \x3d [];\n  var i \x3d length1, j \x3d length2;\n  while (i \x3e 0 \x26\x26 j \x3e 0) {\n    if (compare(array1[i - 1], array2[j - 1])) {\n      result.unshift(collect(i - 1, j - 1));\n      i--;\n      j--;\n    } else {\n      if (arr[i - 1][j] \x3e arr[i][j - 1]) {\n        i--;\n      } else {\n        j--;\n      }\n    }\n  }\n  return result;\n};\n/**\n * @param {...number} var_args\n * @return {number}\n */\ngoog.math.sum \x3d function(var_args) {\n  return (/** @type {number} */ (goog.array.reduce(arguments, function(sum, value) {\n    return sum + value;\n  }, 0)));\n};\n/**\n * @param {...number} var_args\n * @return {number}\n */\ngoog.math.average \x3d function(var_args) {\n  return goog.math.sum.apply(null, arguments) / arguments.length;\n};\n/**\n * @param {...number} var_args\n * @return {number}\n */\ngoog.math.sampleVariance \x3d function(var_args) {\n  var sampleSize \x3d arguments.length;\n  if (sampleSize \x3c 2) {\n    return 0;\n  }\n  var mean \x3d goog.math.average.apply(null, arguments);\n  var variance \x3d goog.math.sum.apply(null, goog.array.map(arguments, function(val) {\n    return Math.pow(val - mean, 2);\n  })) / (sampleSize - 1);\n  return variance;\n};\n/**\n * @param {...number} var_args\n * @return {number}\n */\ngoog.math.standardDeviation \x3d function(var_args) {\n  return Math.sqrt(goog.math.sampleVariance.apply(null, arguments));\n};\n/**\n * @param {number} num\n * @return {boolean}\n */\ngoog.math.isInt \x3d function(num) {\n  return isFinite(num) \x26\x26 num % 1 \x3d\x3d 0;\n};\n/**\n * @param {number} num\n * @return {boolean}\n * @deprecated Use {@link isFinite} instead.\n */\ngoog.math.isFiniteNumber \x3d function(num) {\n  return isFinite(num);\n};\n/**\n * @param {number} num\n * @return {boolean}\n */\ngoog.math.isNegativeZero \x3d function(num) {\n  return num \x3d\x3d 0 \x26\x26 1 / num \x3c 0;\n};\n/**\n * @param {number} num\n * @return {number}\n */\ngoog.math.log10Floor \x3d function(num) {\n  if (num \x3e 0) {\n    var x \x3d Math.round(Math.log(num) * Math.LOG10E);\n    return x - (parseFloat(\x221e\x22 + x) \x3e num ? 1 : 0);\n  }\n  return num \x3d\x3d 0 ? -Infinity : NaN;\n};\n/**\n * @param {number} num\n * @param {number\x3d} opt_epsilon\n * @return {number}\n */\ngoog.math.safeFloor \x3d function(num, opt_epsilon) {\n  goog.asserts.assert(opt_epsilon \x3d\x3d\x3d undefined || opt_epsilon \x3e 0);\n  return Math.floor(num + (opt_epsilon || 2e-15));\n};\n/**\n * @param {number} num\n * @param {number\x3d} opt_epsilon\n * @return {number}\n */\ngoog.math.safeCeil \x3d function(num, opt_epsilon) {\n  goog.asserts.assert(opt_epsilon \x3d\x3d\x3d undefined || opt_epsilon \x3e 0);\n  return Math.ceil(num - (opt_epsilon || 2e-15));\n};\n");
SHADOW_ENV.evalLoad("goog.iter.iter.js", true , "goog.provide(\x22goog.iter\x22);\ngoog.provide(\x22goog.iter.Iterable\x22);\ngoog.provide(\x22goog.iter.Iterator\x22);\ngoog.provide(\x22goog.iter.StopIteration\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.functions\x22);\ngoog.require(\x22goog.math\x22);\n/** @typedef {({length:number}|{__iterator__})} */ goog.iter.Iterable;\n/** @const @type {!Error} */ goog.iter.StopIteration \x3d \x22StopIteration\x22 in goog.global ? goog.global[\x22StopIteration\x22] : {message:\x22StopIteration\x22, stack:\x22\x22};\n/**\n * @constructor\n * @template VALUE\n */\ngoog.iter.Iterator \x3d function() {\n};\n/**\n * @return {VALUE}\n */\ngoog.iter.Iterator.prototype.next \x3d function() {\n  throw goog.iter.StopIteration;\n};\n/**\n * @param {boolean\x3d} opt_keys\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n */\ngoog.iter.Iterator.prototype.__iterator__ \x3d function(opt_keys) {\n  return this;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.toIterator \x3d function(iterable) {\n  if (iterable instanceof goog.iter.Iterator) {\n    return iterable;\n  }\n  if (typeof iterable.__iterator__ \x3d\x3d \x22function\x22) {\n    return /** @type {{__iterator__:function(this:?,boolean\x3d)}} */ (iterable).__iterator__(false);\n  }\n  if (goog.isArrayLike(iterable)) {\n    var like \x3d /** @type {!IArrayLike\x3c(number|string)\x3e} */ (iterable);\n    var i \x3d 0;\n    var newIter \x3d new goog.iter.Iterator;\n    newIter.next \x3d function() {\n      while (true) {\n        if (i \x3e\x3d like.length) {\n          throw goog.iter.StopIteration;\n        }\n        if (!(i in like)) {\n          i++;\n          continue;\n        }\n        return like[i++];\n      }\n    };\n    return newIter;\n  }\n  throw new Error(\x22Not implemented\x22);\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,?,!goog.iter.Iterator\x3cVALUE\x3e)} f\n * @param {THIS\x3d} opt_obj\n * @template THIS\n * @template VALUE\n */\ngoog.iter.forEach \x3d function(iterable, f, opt_obj) {\n  if (goog.isArrayLike(iterable)) {\n    try {\n      goog.array.forEach(/** @type {IArrayLike\x3c?\x3e} */ (iterable), f, opt_obj);\n    } catch (ex) {\n      if (ex !\x3d\x3d goog.iter.StopIteration) {\n        throw ex;\n      }\n    }\n  } else {\n    iterable \x3d goog.iter.toIterator(iterable);\n    try {\n      while (true) {\n        f.call(opt_obj, iterable.next(), undefined, iterable);\n      }\n    } catch (ex$2) {\n      if (ex$2 !\x3d\x3d goog.iter.StopIteration) {\n        throw ex$2;\n      }\n    }\n  }\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n * @param {THIS\x3d} opt_obj\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.filter \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    while (true) {\n      var val \x3d iterator.next();\n      if (f.call(opt_obj, val, undefined, iterator)) {\n        return val;\n      }\n    }\n  };\n  return newIter;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n * @param {THIS\x3d} opt_obj\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.filterFalse \x3d function(iterable, f, opt_obj) {\n  return goog.iter.filter(iterable, goog.functions.not(f), opt_obj);\n};\n/**\n * @param {number} startOrStop\n * @param {number\x3d} opt_stop\n * @param {number\x3d} opt_step\n * @return {!goog.iter.Iterator\x3cnumber\x3e}\n */\ngoog.iter.range \x3d function(startOrStop, opt_stop, opt_step) {\n  var start \x3d 0;\n  var stop \x3d startOrStop;\n  var step \x3d opt_step || 1;\n  if (arguments.length \x3e 1) {\n    start \x3d startOrStop;\n    stop \x3d +opt_stop;\n  }\n  if (step \x3d\x3d 0) {\n    throw new Error(\x22Range step argument must not be zero\x22);\n  }\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    if (step \x3e 0 \x26\x26 start \x3e\x3d stop || step \x3c 0 \x26\x26 start \x3c\x3d stop) {\n      throw goog.iter.StopIteration;\n    }\n    var rv \x3d start;\n    start +\x3d step;\n    return rv;\n  };\n  return newIter;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {string} deliminator\n * @return {string}\n * @template VALUE\n */\ngoog.iter.join \x3d function(iterable, deliminator) {\n  return goog.iter.toArray(iterable).join(deliminator);\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):RESULT} f\n * @param {THIS\x3d} opt_obj\n * @return {!goog.iter.Iterator\x3cRESULT\x3e}\n * @template THIS\n * @template VALUE\n * @template RESULT\n */\ngoog.iter.map \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    var val \x3d iterator.next();\n    return f.call(opt_obj, val, undefined, iterator);\n  };\n  return newIter;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,VALUE):VALUE} f\n * @param {VALUE} val\n * @param {THIS\x3d} opt_obj\n * @return {VALUE}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.reduce \x3d function(iterable, f, val, opt_obj) {\n  var rval \x3d val;\n  goog.iter.forEach(iterable, function(val) {\n    rval \x3d f.call(opt_obj, rval, val);\n  });\n  return rval;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n * @param {THIS\x3d} opt_obj\n * @return {boolean}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.some \x3d function(iterable, f, opt_obj) {\n  iterable \x3d goog.iter.toIterator(iterable);\n  try {\n    while (true) {\n      if (f.call(opt_obj, iterable.next(), undefined, iterable)) {\n        return true;\n      }\n    }\n  } catch (ex) {\n    if (ex !\x3d\x3d goog.iter.StopIteration) {\n      throw ex;\n    }\n  }\n  return false;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n * @param {THIS\x3d} opt_obj\n * @return {boolean}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.every \x3d function(iterable, f, opt_obj) {\n  iterable \x3d goog.iter.toIterator(iterable);\n  try {\n    while (true) {\n      if (!f.call(opt_obj, iterable.next(), undefined, iterable)) {\n        return false;\n      }\n    }\n  } catch (ex) {\n    if (ex !\x3d\x3d goog.iter.StopIteration) {\n      throw ex;\n    }\n  }\n  return true;\n};\n/**\n * @param {...(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} var_args\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.chain \x3d function(var_args) {\n  return goog.iter.chainFromIterable(arguments);\n};\n/**\n * @param {(goog.iter.Iterator\x3c?\x3e|goog.iter.Iterable)} iterable\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.chainFromIterable \x3d function(iterable) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator;\n  var current \x3d null;\n  iter.next \x3d function() {\n    while (true) {\n      if (current \x3d\x3d null) {\n        var it \x3d iterator.next();\n        current \x3d goog.iter.toIterator(it);\n      }\n      try {\n        return current.next();\n      } catch (ex) {\n        if (ex !\x3d\x3d goog.iter.StopIteration) {\n          throw ex;\n        }\n        current \x3d null;\n      }\n    }\n  };\n  return iter;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n * @param {THIS\x3d} opt_obj\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.dropWhile \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var newIter \x3d new goog.iter.Iterator;\n  var dropping \x3d true;\n  newIter.next \x3d function() {\n    while (true) {\n      var val \x3d iterator.next();\n      if (dropping \x26\x26 f.call(opt_obj, val, undefined, iterator)) {\n        continue;\n      } else {\n        dropping \x3d false;\n      }\n      return val;\n    }\n  };\n  return newIter;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n * @param {THIS\x3d} opt_obj\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template THIS\n * @template VALUE\n */\ngoog.iter.takeWhile \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator;\n  iter.next \x3d function() {\n    var val \x3d iterator.next();\n    if (f.call(opt_obj, val, undefined, iterator)) {\n      return val;\n    }\n    throw goog.iter.StopIteration;\n  };\n  return iter;\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @return {!Array\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.toArray \x3d function(iterable) {\n  if (goog.isArrayLike(iterable)) {\n    return goog.array.toArray(/** @type {!IArrayLike\x3c?\x3e} */ (iterable));\n  }\n  iterable \x3d goog.iter.toIterator(iterable);\n  var array \x3d [];\n  goog.iter.forEach(iterable, function(val) {\n    array.push(val);\n  });\n  return array;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable1\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable2\n * @param {function(VALUE,VALUE):boolean\x3d} opt_equalsFn\n * @return {boolean}\n * @template VALUE\n */\ngoog.iter.equals \x3d function(iterable1, iterable2, opt_equalsFn) {\n  var fillValue \x3d {};\n  var pairs \x3d goog.iter.zipLongest(fillValue, iterable1, iterable2);\n  var equalsFn \x3d opt_equalsFn || goog.array.defaultCompareEquality;\n  return goog.iter.every(pairs, function(pair) {\n    return equalsFn(pair[0], pair[1]);\n  });\n};\n/**\n * @param {(goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable)} iterable\n * @param {VALUE} defaultValue\n * @return {VALUE}\n * @template VALUE\n */\ngoog.iter.nextOrValue \x3d function(iterable, defaultValue) {\n  try {\n    return goog.iter.toIterator(iterable).next();\n  } catch (e) {\n    if (e !\x3d goog.iter.StopIteration) {\n      throw e;\n    }\n    return defaultValue;\n  }\n};\n/**\n * @param {...!IArrayLike\x3cVALUE\x3e} var_args\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.product \x3d function(var_args) {\n  var someArrayEmpty \x3d goog.array.some(arguments, function(arr) {\n    return !arr.length;\n  });\n  if (someArrayEmpty || !arguments.length) {\n    return new goog.iter.Iterator;\n  }\n  var iter \x3d new goog.iter.Iterator;\n  var arrays \x3d arguments;\n  /** @type {?Array\x3cnumber\x3e} */ var indicies \x3d goog.array.repeat(0, arrays.length);\n  iter.next \x3d function() {\n    if (indicies) {\n      var retVal \x3d goog.array.map(indicies, function(valueIndex, arrayIndex) {\n        return arrays[arrayIndex][valueIndex];\n      });\n      for (var i \x3d indicies.length - 1; i \x3e\x3d 0; i--) {\n        goog.asserts.assert(indicies);\n        if (indicies[i] \x3c arrays[i].length - 1) {\n          indicies[i]++;\n          break;\n        }\n        if (i \x3d\x3d 0) {\n          indicies \x3d null;\n          break;\n        }\n        indicies[i] \x3d 0;\n      }\n      return retVal;\n    }\n    throw goog.iter.StopIteration;\n  };\n  return iter;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.cycle \x3d function(iterable) {\n  var baseIterator \x3d goog.iter.toIterator(iterable);\n  var cache \x3d [];\n  var cacheIndex \x3d 0;\n  var iter \x3d new goog.iter.Iterator;\n  var useCache \x3d false;\n  iter.next \x3d function() {\n    var returnElement \x3d null;\n    if (!useCache) {\n      try {\n        returnElement \x3d baseIterator.next();\n        cache.push(returnElement);\n        return returnElement;\n      } catch (e) {\n        if (e !\x3d goog.iter.StopIteration || goog.array.isEmpty(cache)) {\n          throw e;\n        }\n        useCache \x3d true;\n      }\n    }\n    returnElement \x3d cache[cacheIndex];\n    cacheIndex \x3d (cacheIndex + 1) % cache.length;\n    return returnElement;\n  };\n  return iter;\n};\n/**\n * @param {number\x3d} opt_start\n * @param {number\x3d} opt_step\n * @return {!goog.iter.Iterator\x3cnumber\x3e}\n */\ngoog.iter.count \x3d function(opt_start, opt_step) {\n  var counter \x3d opt_start || 0;\n  var step \x3d opt_step !\x3d\x3d undefined ? opt_step : 1;\n  var iter \x3d new goog.iter.Iterator;\n  iter.next \x3d function() {\n    var returnValue \x3d counter;\n    counter +\x3d step;\n    return returnValue;\n  };\n  return iter;\n};\n/**\n * @param {VALUE} value\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.repeat \x3d function(value) {\n  var iter \x3d new goog.iter.Iterator;\n  iter.next \x3d goog.functions.constant(value);\n  return iter;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cnumber\x3e|!goog.iter.Iterable)} iterable\n * @return {!goog.iter.Iterator\x3cnumber\x3e}\n */\ngoog.iter.accumulate \x3d function(iterable) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var total \x3d 0;\n  var iter \x3d new goog.iter.Iterator;\n  iter.next \x3d function() {\n    total +\x3d iterator.next();\n    return total;\n  };\n  return iter;\n};\n/**\n * @param {...(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} var_args\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.zip \x3d function(var_args) {\n  var args \x3d arguments;\n  var iter \x3d new goog.iter.Iterator;\n  if (args.length \x3e 0) {\n    var iterators \x3d goog.array.map(args, goog.iter.toIterator);\n    iter.next \x3d function() {\n      var arr \x3d goog.array.map(iterators, function(it) {\n        return it.next();\n      });\n      return arr;\n    };\n  }\n  return iter;\n};\n/**\n * @param {VALUE} fillValue\n * @param {...(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} var_args\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.zipLongest \x3d function(fillValue, var_args) {\n  var args \x3d goog.array.slice(arguments, 1);\n  var iter \x3d new goog.iter.Iterator;\n  if (args.length \x3e 0) {\n    var iterators \x3d goog.array.map(args, goog.iter.toIterator);\n    iter.next \x3d function() {\n      var iteratorsHaveValues \x3d false;\n      var arr \x3d goog.array.map(iterators, function(it) {\n        var returnValue;\n        try {\n          returnValue \x3d it.next();\n          iteratorsHaveValues \x3d true;\n        } catch (ex) {\n          if (ex !\x3d\x3d goog.iter.StopIteration) {\n            throw ex;\n          }\n          returnValue \x3d fillValue;\n        }\n        return returnValue;\n      });\n      if (!iteratorsHaveValues) {\n        throw goog.iter.StopIteration;\n      }\n      return arr;\n    };\n  }\n  return iter;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} selectors\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.compress \x3d function(iterable, selectors) {\n  var selectorIterator \x3d goog.iter.toIterator(selectors);\n  return goog.iter.filter(iterable, function() {\n    return !!selectorIterator.next();\n  });\n};\n/**\n * @private\n * @constructor\n * @extends {goog.iter.Iterator\x3c!Array\x3c?\x3e\x3e}\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {function(VALUE):KEY\x3d} opt_keyFunc\n * @template KEY\n * @template VALUE\n */\ngoog.iter.GroupByIterator_ \x3d function(iterable, opt_keyFunc) {\n  /** @type {!goog.iter.Iterator} */ this.iterator \x3d goog.iter.toIterator(iterable);\n  /** @type {function(VALUE):KEY} */ this.keyFunc \x3d opt_keyFunc || goog.functions.identity;\n  /** @type {KEY} */ this.targetKey;\n  /** @type {KEY} */ this.currentKey;\n  /** @type {VALUE} */ this.currentValue;\n};\ngoog.inherits(goog.iter.GroupByIterator_, goog.iter.Iterator);\n/** @override */ goog.iter.GroupByIterator_.prototype.next \x3d function() {\n  while (this.currentKey \x3d\x3d this.targetKey) {\n    this.currentValue \x3d this.iterator.next();\n    this.currentKey \x3d this.keyFunc(this.currentValue);\n  }\n  this.targetKey \x3d this.currentKey;\n  return [this.currentKey, this.groupItems_(this.targetKey)];\n};\n/**\n * @private\n * @param {KEY} targetKey\n * @return {!Array\x3cVALUE\x3e}\n */\ngoog.iter.GroupByIterator_.prototype.groupItems_ \x3d function(targetKey) {\n  var arr \x3d [];\n  while (this.currentKey \x3d\x3d targetKey) {\n    arr.push(this.currentValue);\n    try {\n      this.currentValue \x3d this.iterator.next();\n    } catch (ex) {\n      if (ex !\x3d\x3d goog.iter.StopIteration) {\n        throw ex;\n      }\n      break;\n    }\n    this.currentKey \x3d this.keyFunc(this.currentValue);\n  }\n  return arr;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {function(VALUE):KEY\x3d} opt_keyFunc\n * @return {!goog.iter.Iterator\x3c!Array\x3c?\x3e\x3e}\n * @template KEY\n * @template VALUE\n */\ngoog.iter.groupBy \x3d function(iterable, opt_keyFunc) {\n  return new goog.iter.GroupByIterator_(iterable, opt_keyFunc);\n};\n/**\n * @param {(!goog.iter.Iterator\x3c?\x3e|!goog.iter.Iterable)} iterable\n * @param {function(this:THIS,...*):RESULT} f\n * @param {THIS\x3d} opt_obj\n * @return {!goog.iter.Iterator\x3cRESULT\x3e}\n * @template THIS\n * @template RESULT\n */\ngoog.iter.starMap \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator;\n  iter.next \x3d function() {\n    var args \x3d goog.iter.toArray(iterator.next());\n    return f.apply(opt_obj, goog.array.concat(args, undefined, iterator));\n  };\n  return iter;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number\x3d} opt_num\n * @return {!Array\x3cgoog.iter.Iterator\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.tee \x3d function(iterable, opt_num) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var num \x3d typeof opt_num \x3d\x3d\x3d \x22number\x22 ? opt_num : 2;\n  var buffers \x3d goog.array.map(goog.array.range(num), function() {\n    return [];\n  });\n  var addNextIteratorValueToBuffers \x3d function() {\n    var val \x3d iterator.next();\n    goog.array.forEach(buffers, function(buffer) {\n      buffer.push(val);\n    });\n  };\n  var createIterator \x3d function(buffer) {\n    var iter \x3d new goog.iter.Iterator;\n    iter.next \x3d function() {\n      if (goog.array.isEmpty(buffer)) {\n        addNextIteratorValueToBuffers();\n      }\n      goog.asserts.assert(!goog.array.isEmpty(buffer));\n      return buffer.shift();\n    };\n    return iter;\n  };\n  return goog.array.map(buffers, createIterator);\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number\x3d} opt_start\n * @return {!goog.iter.Iterator\x3c!Array\x3c?\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.enumerate \x3d function(iterable, opt_start) {\n  return goog.iter.zip(goog.iter.count(opt_start), iterable);\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number} limitSize\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.limit \x3d function(iterable, limitSize) {\n  goog.asserts.assert(goog.math.isInt(limitSize) \x26\x26 limitSize \x3e\x3d 0);\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator;\n  var remaining \x3d limitSize;\n  iter.next \x3d function() {\n    if (remaining-- \x3e 0) {\n      return iterator.next();\n    }\n    throw goog.iter.StopIteration;\n  };\n  return iter;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number} count\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.consume \x3d function(iterable, count) {\n  goog.asserts.assert(goog.math.isInt(count) \x26\x26 count \x3e\x3d 0);\n  var iterator \x3d goog.iter.toIterator(iterable);\n  while (count-- \x3e 0) {\n    goog.iter.nextOrValue(iterator, null);\n  }\n  return iterator;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number} start\n * @param {number\x3d} opt_end\n * @return {!goog.iter.Iterator\x3cVALUE\x3e}\n * @template VALUE\n */\ngoog.iter.slice \x3d function(iterable, start, opt_end) {\n  goog.asserts.assert(goog.math.isInt(start) \x26\x26 start \x3e\x3d 0);\n  var iterator \x3d goog.iter.consume(iterable, start);\n  if (typeof opt_end \x3d\x3d\x3d \x22number\x22) {\n    goog.asserts.assert(goog.math.isInt(opt_end) \x26\x26 opt_end \x3e\x3d start);\n    iterator \x3d goog.iter.limit(iterator, opt_end - start);\n  }\n  return iterator;\n};\n/**\n * @private\n * @param {?IArrayLike\x3cVALUE\x3e} arr\n * @return {boolean}\n * @template VALUE\n */\ngoog.iter.hasDuplicates_ \x3d function(arr) {\n  var deduped \x3d [];\n  goog.array.removeDuplicates(arr, deduped);\n  return arr.length !\x3d deduped.length;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number\x3d} opt_length\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.permutations \x3d function(iterable, opt_length) {\n  var elements \x3d goog.iter.toArray(iterable);\n  var length \x3d typeof opt_length \x3d\x3d\x3d \x22number\x22 ? opt_length : elements.length;\n  var sets \x3d goog.array.repeat(elements, length);\n  var product \x3d goog.iter.product.apply(undefined, sets);\n  return goog.iter.filter(product, function(arr) {\n    return !goog.iter.hasDuplicates_(arr);\n  });\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number} length\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.combinations \x3d function(iterable, length) {\n  var elements \x3d goog.iter.toArray(iterable);\n  var indexes \x3d goog.iter.range(elements.length);\n  var indexIterator \x3d goog.iter.permutations(indexes, length);\n  var sortedIndexIterator \x3d goog.iter.filter(indexIterator, function(arr) {\n    return goog.array.isSorted(arr);\n  });\n  var iter \x3d new goog.iter.Iterator;\n  function getIndexFromElements(index) {\n    return elements[index];\n  }\n  iter.next \x3d function() {\n    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);\n  };\n  return iter;\n};\n/**\n * @param {(!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable)} iterable\n * @param {number} length\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e}\n * @template VALUE\n */\ngoog.iter.combinationsWithReplacement \x3d function(iterable, length) {\n  var elements \x3d goog.iter.toArray(iterable);\n  var indexes \x3d goog.array.range(elements.length);\n  var sets \x3d goog.array.repeat(indexes, length);\n  var indexIterator \x3d goog.iter.product.apply(undefined, sets);\n  var sortedIndexIterator \x3d goog.iter.filter(indexIterator, function(arr) {\n    return goog.array.isSorted(arr);\n  });\n  var iter \x3d new goog.iter.Iterator;\n  function getIndexFromElements(index) {\n    return elements[index];\n  }\n  iter.next \x3d function() {\n    return goog.array.map(/** @type {!Array\x3cnumber\x3e} */ (sortedIndexIterator.next()), getIndexFromElements);\n  };\n  return iter;\n};\n");
SHADOW_ENV.evalLoad("goog.structs.map.js", true , "goog.provide(\x22goog.structs.Map\x22);\ngoog.require(\x22goog.iter.Iterator\x22);\ngoog.require(\x22goog.iter.StopIteration\x22);\n/**\n * @constructor\n * @param {*\x3d} opt_map\n * @param {...*} var_args\n * @template K\n * @template V\n * @deprecated This type is misleading: use ES6 Map instead.\n */\ngoog.structs.Map \x3d function(opt_map, var_args) {\n  /** @private @type {!Object} */ this.map_ \x3d {};\n  /** @private @type {!Array\x3cstring\x3e} */ this.keys_ \x3d [];\n  /** @private @type {number} */ this.count_ \x3d 0;\n  /** @private @type {number} */ this.version_ \x3d 0;\n  var argLength \x3d arguments.length;\n  if (argLength \x3e 1) {\n    if (argLength % 2) {\n      throw new Error(\x22Uneven number of arguments\x22);\n    }\n    for (var i \x3d 0; i \x3c argLength; i +\x3d 2) {\n      this.set(arguments[i], arguments[i + 1]);\n    }\n  } else {\n    if (opt_map) {\n      this.addAll(/** @type {!Object} */ (opt_map));\n    }\n  }\n};\n/**\n * @return {number}\n */\ngoog.structs.Map.prototype.getCount \x3d function() {\n  return this.count_;\n};\n/**\n * @return {!Array\x3cV\x3e}\n */\ngoog.structs.Map.prototype.getValues \x3d function() {\n  this.cleanupKeysArray_();\n  var rv \x3d [];\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    rv.push(this.map_[key]);\n  }\n  return rv;\n};\n/**\n * @return {!Array\x3cstring\x3e}\n */\ngoog.structs.Map.prototype.getKeys \x3d function() {\n  this.cleanupKeysArray_();\n  return (/** @type {!Array\x3cstring\x3e} */ (this.keys_.concat()));\n};\n/**\n * @param {*} key\n * @return {boolean}\n */\ngoog.structs.Map.prototype.containsKey \x3d function(key) {\n  return goog.structs.Map.hasKey_(this.map_, key);\n};\n/**\n * @param {V} val\n * @return {boolean}\n */\ngoog.structs.Map.prototype.containsValue \x3d function(val) {\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    if (goog.structs.Map.hasKey_(this.map_, key) \x26\x26 this.map_[key] \x3d\x3d val) {\n      return true;\n    }\n  }\n  return false;\n};\n/**\n * @param {goog.structs.Map} otherMap\n * @param {function(V,V):boolean\x3d} opt_equalityFn\n * @return {boolean}\n */\ngoog.structs.Map.prototype.equals \x3d function(otherMap, opt_equalityFn) {\n  if (this \x3d\x3d\x3d otherMap) {\n    return true;\n  }\n  if (this.count_ !\x3d otherMap.getCount()) {\n    return false;\n  }\n  var equalityFn \x3d opt_equalityFn || goog.structs.Map.defaultEquals;\n  this.cleanupKeysArray_();\n  for (var key, i \x3d 0; key \x3d this.keys_[i]; i++) {\n    if (!equalityFn(this.get(key), otherMap.get(key))) {\n      return false;\n    }\n  }\n  return true;\n};\n/**\n * @param {*} a\n * @param {*} b\n * @return {boolean}\n */\ngoog.structs.Map.defaultEquals \x3d function(a, b) {\n  return a \x3d\x3d\x3d b;\n};\n/**\n * @return {boolean}\n */\ngoog.structs.Map.prototype.isEmpty \x3d function() {\n  return this.count_ \x3d\x3d 0;\n};\ngoog.structs.Map.prototype.clear \x3d function() {\n  this.map_ \x3d {};\n  this.keys_.length \x3d 0;\n  this.count_ \x3d 0;\n  this.version_ \x3d 0;\n};\n/**\n * @param {*} key\n * @return {boolean}\n */\ngoog.structs.Map.prototype.remove \x3d function(key) {\n  if (goog.structs.Map.hasKey_(this.map_, key)) {\n    delete this.map_[key];\n    this.count_--;\n    this.version_++;\n    if (this.keys_.length \x3e 2 * this.count_) {\n      this.cleanupKeysArray_();\n    }\n    return true;\n  }\n  return false;\n};\n/** @private */ goog.structs.Map.prototype.cleanupKeysArray_ \x3d function() {\n  if (this.count_ !\x3d this.keys_.length) {\n    var srcIndex \x3d 0;\n    var destIndex \x3d 0;\n    while (srcIndex \x3c this.keys_.length) {\n      var key \x3d this.keys_[srcIndex];\n      if (goog.structs.Map.hasKey_(this.map_, key)) {\n        this.keys_[destIndex++] \x3d key;\n      }\n      srcIndex++;\n    }\n    this.keys_.length \x3d destIndex;\n  }\n  if (this.count_ !\x3d this.keys_.length) {\n    var seen \x3d {};\n    var srcIndex \x3d 0;\n    var destIndex \x3d 0;\n    while (srcIndex \x3c this.keys_.length) {\n      var key \x3d this.keys_[srcIndex];\n      if (!goog.structs.Map.hasKey_(seen, key)) {\n        this.keys_[destIndex++] \x3d key;\n        seen[key] \x3d 1;\n      }\n      srcIndex++;\n    }\n    this.keys_.length \x3d destIndex;\n  }\n};\n/**\n * @param {*} key\n * @param {DEFAULT\x3d} opt_val\n * @return {(V|DEFAULT)}\n * @template DEFAULT\n */\ngoog.structs.Map.prototype.get \x3d function(key, opt_val) {\n  if (goog.structs.Map.hasKey_(this.map_, key)) {\n    return this.map_[key];\n  }\n  return opt_val;\n};\n/**\n * @param {*} key\n * @param {V} value\n * @return {*}\n */\ngoog.structs.Map.prototype.set \x3d function(key, value) {\n  if (!goog.structs.Map.hasKey_(this.map_, key)) {\n    this.count_++;\n    this.keys_.push(/** @type {?} */ (key));\n    this.version_++;\n  }\n  this.map_[key] \x3d value;\n};\n/**\n * @param {?Object} map\n */\ngoog.structs.Map.prototype.addAll \x3d function(map) {\n  if (map instanceof goog.structs.Map) {\n    var keys \x3d map.getKeys();\n    for (var i \x3d 0; i \x3c keys.length; i++) {\n      this.set(keys[i], map.get(keys[i]));\n    }\n  } else {\n    for (var key in map) {\n      this.set(key, map[key]);\n    }\n  }\n};\n/**\n * @param {function(this:T,V,K,goog.structs.Map\x3cK,V\x3e)} f\n * @param {T\x3d} opt_obj\n * @template T\n */\ngoog.structs.Map.prototype.forEach \x3d function(f, opt_obj) {\n  var keys \x3d this.getKeys();\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var key \x3d keys[i];\n    var value \x3d this.get(key);\n    f.call(opt_obj, value, key, this);\n  }\n};\n/**\n * @return {!goog.structs.Map}\n */\ngoog.structs.Map.prototype.clone \x3d function() {\n  return new goog.structs.Map(this);\n};\n/**\n * @return {!goog.structs.Map}\n */\ngoog.structs.Map.prototype.transpose \x3d function() {\n  var transposed \x3d new goog.structs.Map;\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    var value \x3d this.map_[key];\n    transposed.set(value, key);\n  }\n  return transposed;\n};\n/**\n * @return {!Object}\n */\ngoog.structs.Map.prototype.toObject \x3d function() {\n  this.cleanupKeysArray_();\n  var obj \x3d {};\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    obj[key] \x3d this.map_[key];\n  }\n  return obj;\n};\n/**\n * @return {!goog.iter.Iterator}\n */\ngoog.structs.Map.prototype.getKeyIterator \x3d function() {\n  return this.__iterator__(true);\n};\n/**\n * @return {!goog.iter.Iterator}\n */\ngoog.structs.Map.prototype.getValueIterator \x3d function() {\n  return this.__iterator__(false);\n};\n/**\n * @param {boolean\x3d} opt_keys\n * @return {!goog.iter.Iterator}\n */\ngoog.structs.Map.prototype.__iterator__ \x3d function(opt_keys) {\n  this.cleanupKeysArray_();\n  var i \x3d 0;\n  var version \x3d this.version_;\n  var selfObj \x3d this;\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    if (version !\x3d selfObj.version_) {\n      throw new Error(\x22The map has changed since the iterator was created\x22);\n    }\n    if (i \x3e\x3d selfObj.keys_.length) {\n      throw goog.iter.StopIteration;\n    }\n    var key \x3d selfObj.keys_[i++];\n    return opt_keys ? key : selfObj.map_[key];\n  };\n  return newIter;\n};\n/**\n * @private\n * @param {!Object} obj\n * @param {*} key\n * @return {boolean}\n */\ngoog.structs.Map.hasKey_ \x3d function(obj, key) {\n  return Object.prototype.hasOwnProperty.call(obj, key);\n};\n");
SHADOW_ENV.evalLoad("goog.uri.utils.js", true , "goog.provide(\x22goog.uri.utils\x22);\ngoog.provide(\x22goog.uri.utils.ComponentIndex\x22);\ngoog.provide(\x22goog.uri.utils.QueryArray\x22);\ngoog.provide(\x22goog.uri.utils.QueryValue\x22);\ngoog.provide(\x22goog.uri.utils.StandardQueryParam\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.string\x22);\n/** @private @enum {number} */ goog.uri.utils.CharCode_ \x3d {AMPERSAND:38, EQUAL:61, HASH:35, QUESTION:63};\n/**\n * @param {?string\x3d} opt_scheme\n * @param {?string\x3d} opt_userInfo\n * @param {?string\x3d} opt_domain\n * @param {(string|number|null)\x3d} opt_port\n * @param {?string\x3d} opt_path\n * @param {?string\x3d} opt_queryData\n * @param {?string\x3d} opt_fragment\n * @return {string}\n */\ngoog.uri.utils.buildFromEncodedParts \x3d function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {\n  var out \x3d \x22\x22;\n  if (opt_scheme) {\n    out +\x3d opt_scheme + \x22:\x22;\n  }\n  if (opt_domain) {\n    out +\x3d \x22//\x22;\n    if (opt_userInfo) {\n      out +\x3d opt_userInfo + \x22@\x22;\n    }\n    out +\x3d opt_domain;\n    if (opt_port) {\n      out +\x3d \x22:\x22 + opt_port;\n    }\n  }\n  if (opt_path) {\n    out +\x3d opt_path;\n  }\n  if (opt_queryData) {\n    out +\x3d \x22?\x22 + opt_queryData;\n  }\n  if (opt_fragment) {\n    out +\x3d \x22#\x22 + opt_fragment;\n  }\n  return out;\n};\n/** @private @type {!RegExp} */ goog.uri.utils.splitRe_ \x3d new RegExp(\x22^\x22 + \x22(?:\x22 + \x22([^:/?#.]+)\x22 + \x22:)?\x22 + \x22(?://\x22 + \x22(?:([^/?#]*)@)?\x22 + \x22([^/#?]*?)\x22 + \x22(?::([0-9]+))?\x22 + \x22(?\\x3d[/#?]|$)\x22 + \x22)?\x22 + \x22([^?#]+)?\x22 + \x22(?:\\\\?([^#]*))?\x22 + \x22(?:#([\\\\s\\\\S]*))?\x22 + \x22$\x22);\n/** @enum {number} */ goog.uri.utils.ComponentIndex \x3d {SCHEME:1, USER_INFO:2, DOMAIN:3, PORT:4, PATH:5, QUERY_DATA:6, FRAGMENT:7};\n/**\n * @param {string} uri\n * @return {!Array\x3c(string|undefined)\x3e}\n */\ngoog.uri.utils.split \x3d function(uri) {\n  return (/** @type {!Array\x3c(string|undefined)\x3e} */ (uri.match(goog.uri.utils.splitRe_)));\n};\n/**\n * @private\n * @param {?string} uri\n * @param {boolean\x3d} opt_preserveReserved\n * @return {?string}\n */\ngoog.uri.utils.decodeIfPossible_ \x3d function(uri, opt_preserveReserved) {\n  if (!uri) {\n    return uri;\n  }\n  return opt_preserveReserved ? decodeURI(uri) : decodeURIComponent(uri);\n};\n/**\n * @private\n * @param {goog.uri.utils.ComponentIndex} componentIndex\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getComponentByIndex_ \x3d function(componentIndex, uri) {\n  return goog.uri.utils.split(uri)[componentIndex] || null;\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getScheme \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.SCHEME, uri);\n};\n/**\n * @param {string} uri\n * @return {string}\n */\ngoog.uri.utils.getEffectiveScheme \x3d function(uri) {\n  var scheme \x3d goog.uri.utils.getScheme(uri);\n  if (!scheme \x26\x26 goog.global.self \x26\x26 goog.global.self.location) {\n    var protocol \x3d goog.global.self.location.protocol;\n    scheme \x3d protocol.substr(0, protocol.length - 1);\n  }\n  return scheme ? scheme.toLowerCase() : \x22\x22;\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getUserInfoEncoded \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.USER_INFO, uri);\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getUserInfo \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getUserInfoEncoded(uri));\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getDomainEncoded \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.DOMAIN, uri);\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getDomain \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getDomainEncoded(uri), true);\n};\n/**\n * @param {string} uri\n * @return {?number}\n */\ngoog.uri.utils.getPort \x3d function(uri) {\n  return Number(goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PORT, uri)) || null;\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getPathEncoded \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PATH, uri);\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getPath \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getPathEncoded(uri), true);\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getQueryData \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.QUERY_DATA, uri);\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getFragmentEncoded \x3d function(uri) {\n  var hashIndex \x3d uri.indexOf(\x22#\x22);\n  return hashIndex \x3c 0 ? null : uri.substr(hashIndex + 1);\n};\n/**\n * @param {string} uri\n * @param {?string} fragment\n * @return {string}\n */\ngoog.uri.utils.setFragmentEncoded \x3d function(uri, fragment) {\n  return goog.uri.utils.removeFragment(uri) + (fragment ? \x22#\x22 + fragment : \x22\x22);\n};\n/**\n * @param {string} uri\n * @return {?string}\n */\ngoog.uri.utils.getFragment \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getFragmentEncoded(uri));\n};\n/**\n * @param {string} uri\n * @return {string}\n */\ngoog.uri.utils.getHost \x3d function(uri) {\n  var pieces \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], pieces[goog.uri.utils.ComponentIndex.USER_INFO], pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT]);\n};\n/**\n * @param {string} uri\n * @return {string}\n */\ngoog.uri.utils.getOrigin \x3d function(uri) {\n  var pieces \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], null, pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT]);\n};\n/**\n * @param {string} uri\n * @return {string}\n */\ngoog.uri.utils.getPathAndAfter \x3d function(uri) {\n  var pieces \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(null, null, null, null, pieces[goog.uri.utils.ComponentIndex.PATH], pieces[goog.uri.utils.ComponentIndex.QUERY_DATA], pieces[goog.uri.utils.ComponentIndex.FRAGMENT]);\n};\n/**\n * @param {string} uri\n * @return {string}\n */\ngoog.uri.utils.removeFragment \x3d function(uri) {\n  var hashIndex \x3d uri.indexOf(\x22#\x22);\n  return hashIndex \x3c 0 ? uri : uri.substr(0, hashIndex);\n};\n/**\n * @param {string} uri1\n * @param {string} uri2\n * @return {boolean}\n */\ngoog.uri.utils.haveSameDomain \x3d function(uri1, uri2) {\n  var pieces1 \x3d goog.uri.utils.split(uri1);\n  var pieces2 \x3d goog.uri.utils.split(uri2);\n  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] \x3d\x3d pieces2[goog.uri.utils.ComponentIndex.DOMAIN] \x26\x26 pieces1[goog.uri.utils.ComponentIndex.SCHEME] \x3d\x3d pieces2[goog.uri.utils.ComponentIndex.SCHEME] \x26\x26 pieces1[goog.uri.utils.ComponentIndex.PORT] \x3d\x3d pieces2[goog.uri.utils.ComponentIndex.PORT];\n};\n/**\n * @private\n * @param {string} uri\n */\ngoog.uri.utils.assertNoFragmentsOrQueries_ \x3d function(uri) {\n  goog.asserts.assert(uri.indexOf(\x22#\x22) \x3c 0 \x26\x26 uri.indexOf(\x22?\x22) \x3c 0, \x22goog.uri.utils: Fragment or query identifiers are not supported: [%s]\x22, uri);\n};\n/** @typedef {*} */ goog.uri.utils.QueryValue;\n/** @typedef {!Array\x3c(string|goog.uri.utils.QueryValue)\x3e} */ goog.uri.utils.QueryArray;\n/**\n * @param {string} encodedQuery\n * @param {function(string,string)} callback\n */\ngoog.uri.utils.parseQueryData \x3d function(encodedQuery, callback) {\n  if (!encodedQuery) {\n    return;\n  }\n  var pairs \x3d encodedQuery.split(\x22\\x26\x22);\n  for (var i \x3d 0; i \x3c pairs.length; i++) {\n    var indexOfEquals \x3d pairs[i].indexOf(\x22\\x3d\x22);\n    var name \x3d null;\n    var value \x3d null;\n    if (indexOfEquals \x3e\x3d 0) {\n      name \x3d pairs[i].substring(0, indexOfEquals);\n      value \x3d pairs[i].substring(indexOfEquals + 1);\n    } else {\n      name \x3d pairs[i];\n    }\n    callback(name, value ? goog.string.urlDecode(value) : \x22\x22);\n  }\n};\n/**\n * @private\n * @param {string} uri\n * @return {!Array\x3cstring\x3e}\n */\ngoog.uri.utils.splitQueryData_ \x3d function(uri) {\n  var hashIndex \x3d uri.indexOf(\x22#\x22);\n  if (hashIndex \x3c 0) {\n    hashIndex \x3d uri.length;\n  }\n  var questionIndex \x3d uri.indexOf(\x22?\x22);\n  var queryData;\n  if (questionIndex \x3c 0 || questionIndex \x3e hashIndex) {\n    questionIndex \x3d hashIndex;\n    queryData \x3d \x22\x22;\n  } else {\n    queryData \x3d uri.substring(questionIndex + 1, hashIndex);\n  }\n  return [uri.substr(0, questionIndex), queryData, uri.substr(hashIndex)];\n};\n/**\n * @private\n * @param {!Array\x3cstring\x3e} parts\n * @return {string}\n */\ngoog.uri.utils.joinQueryData_ \x3d function(parts) {\n  return parts[0] + (parts[1] ? \x22?\x22 + parts[1] : \x22\x22) + parts[2];\n};\n/**\n * @private\n * @param {string} queryData\n * @param {string} newData\n * @return {string}\n */\ngoog.uri.utils.appendQueryData_ \x3d function(queryData, newData) {\n  if (!newData) {\n    return queryData;\n  }\n  return queryData ? queryData + \x22\\x26\x22 + newData : newData;\n};\n/**\n * @private\n * @param {string} uri\n * @param {string} queryData\n * @return {string}\n */\ngoog.uri.utils.appendQueryDataToUri_ \x3d function(uri, queryData) {\n  if (!queryData) {\n    return uri;\n  }\n  var parts \x3d goog.uri.utils.splitQueryData_(uri);\n  parts[1] \x3d goog.uri.utils.appendQueryData_(parts[1], queryData);\n  return goog.uri.utils.joinQueryData_(parts);\n};\n/**\n * @private\n * @param {*} key\n * @param {goog.uri.utils.QueryValue} value\n * @param {!Array\x3cstring\x3e} pairs\n */\ngoog.uri.utils.appendKeyValuePairs_ \x3d function(key, value, pairs) {\n  goog.asserts.assertString(key);\n  if (goog.isArray(value)) {\n    goog.asserts.assertArray(value);\n    for (var j \x3d 0; j \x3c value.length; j++) {\n      goog.uri.utils.appendKeyValuePairs_(key, String(value[j]), pairs);\n    }\n  } else {\n    if (value !\x3d null) {\n      pairs.push(key + (value \x3d\x3d\x3d \x22\x22 ? \x22\x22 : \x22\\x3d\x22 + goog.string.urlEncode(value)));\n    }\n  }\n};\n/**\n * @param {!IArrayLike\x3c(string|goog.uri.utils.QueryValue)\x3e} keysAndValues\n * @param {number\x3d} opt_startIndex\n * @return {string}\n */\ngoog.uri.utils.buildQueryData \x3d function(keysAndValues, opt_startIndex) {\n  goog.asserts.assert(Math.max(keysAndValues.length - (opt_startIndex || 0), 0) % 2 \x3d\x3d 0, \x22goog.uri.utils: Key/value lists must be even in length.\x22);\n  var params \x3d [];\n  for (var i \x3d opt_startIndex || 0; i \x3c keysAndValues.length; i +\x3d 2) {\n    var key \x3d /** @type {string} */ (keysAndValues[i]);\n    goog.uri.utils.appendKeyValuePairs_(key, keysAndValues[i + 1], params);\n  }\n  return params.join(\x22\\x26\x22);\n};\n/**\n * @param {!Object\x3cstring,goog.uri.utils.QueryValue\x3e} map\n * @return {string}\n */\ngoog.uri.utils.buildQueryDataFromMap \x3d function(map) {\n  var params \x3d [];\n  for (var key in map) {\n    goog.uri.utils.appendKeyValuePairs_(key, map[key], params);\n  }\n  return params.join(\x22\\x26\x22);\n};\n/**\n * @param {string} uri\n * @param {...(goog.uri.utils.QueryArray|goog.uri.utils.QueryValue)} var_args\n * @return {string}\n */\ngoog.uri.utils.appendParams \x3d function(uri, var_args) {\n  var queryData \x3d arguments.length \x3d\x3d 2 ? goog.uri.utils.buildQueryData(arguments[1], 0) : goog.uri.utils.buildQueryData(arguments, 1);\n  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);\n};\n/**\n * @param {string} uri\n * @param {!Object\x3c?,goog.uri.utils.QueryValue\x3e} map\n * @return {string}\n */\ngoog.uri.utils.appendParamsFromMap \x3d function(uri, map) {\n  var queryData \x3d goog.uri.utils.buildQueryDataFromMap(map);\n  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);\n};\n/**\n * @param {string} uri\n * @param {string} key\n * @param {*\x3d} opt_value\n * @return {string}\n */\ngoog.uri.utils.appendParam \x3d function(uri, key, opt_value) {\n  var value \x3d opt_value !\x3d null ? \x22\\x3d\x22 + goog.string.urlEncode(opt_value) : \x22\x22;\n  return goog.uri.utils.appendQueryDataToUri_(uri, key + value);\n};\n/**\n * @private\n * @param {string} uri\n * @param {number} startIndex\n * @param {string} keyEncoded\n * @param {number} hashOrEndIndex\n * @return {number}\n */\ngoog.uri.utils.findParam_ \x3d function(uri, startIndex, keyEncoded, hashOrEndIndex) {\n  var index \x3d startIndex;\n  var keyLength \x3d keyEncoded.length;\n  while ((index \x3d uri.indexOf(keyEncoded, index)) \x3e\x3d 0 \x26\x26 index \x3c hashOrEndIndex) {\n    var precedingChar \x3d uri.charCodeAt(index - 1);\n    if (precedingChar \x3d\x3d goog.uri.utils.CharCode_.AMPERSAND || precedingChar \x3d\x3d goog.uri.utils.CharCode_.QUESTION) {\n      var followingChar \x3d uri.charCodeAt(index + keyLength);\n      if (!followingChar || followingChar \x3d\x3d goog.uri.utils.CharCode_.EQUAL || followingChar \x3d\x3d goog.uri.utils.CharCode_.AMPERSAND || followingChar \x3d\x3d goog.uri.utils.CharCode_.HASH) {\n        return index;\n      }\n    }\n    index +\x3d keyLength + 1;\n  }\n  return -1;\n};\n/** @private @type {RegExp} */ goog.uri.utils.hashOrEndRe_ \x3d /#|$/;\n/**\n * @param {string} uri\n * @param {string} keyEncoded\n * @return {boolean}\n */\ngoog.uri.utils.hasParam \x3d function(uri, keyEncoded) {\n  return goog.uri.utils.findParam_(uri, 0, keyEncoded, uri.search(goog.uri.utils.hashOrEndRe_)) \x3e\x3d 0;\n};\n/**\n * @param {string} uri\n * @param {string} keyEncoded\n * @return {?string}\n */\ngoog.uri.utils.getParamValue \x3d function(uri, keyEncoded) {\n  var hashOrEndIndex \x3d uri.search(goog.uri.utils.hashOrEndRe_);\n  var foundIndex \x3d goog.uri.utils.findParam_(uri, 0, keyEncoded, hashOrEndIndex);\n  if (foundIndex \x3c 0) {\n    return null;\n  } else {\n    var endPosition \x3d uri.indexOf(\x22\\x26\x22, foundIndex);\n    if (endPosition \x3c 0 || endPosition \x3e hashOrEndIndex) {\n      endPosition \x3d hashOrEndIndex;\n    }\n    foundIndex +\x3d keyEncoded.length + 1;\n    return goog.string.urlDecode(uri.substr(foundIndex, endPosition - foundIndex));\n  }\n};\n/**\n * @param {string} uri\n * @param {string} keyEncoded\n * @return {!Array\x3cstring\x3e}\n */\ngoog.uri.utils.getParamValues \x3d function(uri, keyEncoded) {\n  var hashOrEndIndex \x3d uri.search(goog.uri.utils.hashOrEndRe_);\n  var position \x3d 0;\n  var foundIndex;\n  var result \x3d [];\n  while ((foundIndex \x3d goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex)) \x3e\x3d 0) {\n    position \x3d uri.indexOf(\x22\\x26\x22, foundIndex);\n    if (position \x3c 0 || position \x3e hashOrEndIndex) {\n      position \x3d hashOrEndIndex;\n    }\n    foundIndex +\x3d keyEncoded.length + 1;\n    result.push(goog.string.urlDecode(uri.substr(foundIndex, position - foundIndex)));\n  }\n  return result;\n};\n/** @private @type {RegExp} */ goog.uri.utils.trailingQueryPunctuationRe_ \x3d /[?\x26]($|#)/;\n/**\n * @param {string} uri\n * @param {string} keyEncoded\n * @return {string}\n */\ngoog.uri.utils.removeParam \x3d function(uri, keyEncoded) {\n  var hashOrEndIndex \x3d uri.search(goog.uri.utils.hashOrEndRe_);\n  var position \x3d 0;\n  var foundIndex;\n  var buffer \x3d [];\n  while ((foundIndex \x3d goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex)) \x3e\x3d 0) {\n    buffer.push(uri.substring(position, foundIndex));\n    position \x3d Math.min(uri.indexOf(\x22\\x26\x22, foundIndex) + 1 || hashOrEndIndex, hashOrEndIndex);\n  }\n  buffer.push(uri.substr(position));\n  return buffer.join(\x22\x22).replace(goog.uri.utils.trailingQueryPunctuationRe_, \x22$1\x22);\n};\n/**\n * @param {string} uri\n * @param {string} keyEncoded\n * @param {*} value\n * @return {string}\n */\ngoog.uri.utils.setParam \x3d function(uri, keyEncoded, value) {\n  return goog.uri.utils.appendParam(goog.uri.utils.removeParam(uri, keyEncoded), keyEncoded, value);\n};\n/**\n * @param {string} uri\n * @param {!Object\x3cstring,goog.uri.utils.QueryValue\x3e} params\n * @return {string}\n */\ngoog.uri.utils.setParamsFromMap \x3d function(uri, params) {\n  var parts \x3d goog.uri.utils.splitQueryData_(uri);\n  var queryData \x3d parts[1];\n  var buffer \x3d [];\n  if (queryData) {\n    goog.array.forEach(queryData.split(\x22\\x26\x22), function(pair) {\n      var indexOfEquals \x3d pair.indexOf(\x22\\x3d\x22);\n      var name \x3d indexOfEquals \x3e\x3d 0 ? pair.substr(0, indexOfEquals) : pair;\n      if (!params.hasOwnProperty(name)) {\n        buffer.push(pair);\n      }\n    });\n  }\n  parts[1] \x3d goog.uri.utils.appendQueryData_(buffer.join(\x22\\x26\x22), goog.uri.utils.buildQueryDataFromMap(params));\n  return goog.uri.utils.joinQueryData_(parts);\n};\n/**\n * @param {string} baseUri\n * @param {string} path\n * @return {string}\n */\ngoog.uri.utils.appendPath \x3d function(baseUri, path) {\n  goog.uri.utils.assertNoFragmentsOrQueries_(baseUri);\n  if (goog.string.endsWith(baseUri, \x22/\x22)) {\n    baseUri \x3d baseUri.substr(0, baseUri.length - 1);\n  }\n  if (goog.string.startsWith(path, \x22/\x22)) {\n    path \x3d path.substr(1);\n  }\n  return goog.string.buildString(baseUri, \x22/\x22, path);\n};\n/**\n * @param {string} uri\n * @param {string} path\n * @return {string}\n */\ngoog.uri.utils.setPath \x3d function(uri, path) {\n  if (!goog.string.startsWith(path, \x22/\x22)) {\n    path \x3d \x22/\x22 + path;\n  }\n  var parts \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(parts[goog.uri.utils.ComponentIndex.SCHEME], parts[goog.uri.utils.ComponentIndex.USER_INFO], parts[goog.uri.utils.ComponentIndex.DOMAIN], parts[goog.uri.utils.ComponentIndex.PORT], path, parts[goog.uri.utils.ComponentIndex.QUERY_DATA], parts[goog.uri.utils.ComponentIndex.FRAGMENT]);\n};\n/** @enum {string} */ goog.uri.utils.StandardQueryParam \x3d {RANDOM:\x22zx\x22};\n/**\n * @param {string} uri\n * @return {string}\n */\ngoog.uri.utils.makeUnique \x3d function(uri) {\n  return goog.uri.utils.setParam(uri, goog.uri.utils.StandardQueryParam.RANDOM, goog.string.getRandomString());\n};\n");
SHADOW_ENV.evalLoad("goog.uri.uri.js", true , "goog.provide(\x22goog.Uri\x22);\ngoog.provide(\x22goog.Uri.QueryData\x22);\ngoog.require(\x22goog.array\x22);\ngoog.require(\x22goog.asserts\x22);\ngoog.require(\x22goog.string\x22);\ngoog.require(\x22goog.structs\x22);\ngoog.require(\x22goog.structs.Map\x22);\ngoog.require(\x22goog.uri.utils\x22);\ngoog.require(\x22goog.uri.utils.ComponentIndex\x22);\ngoog.require(\x22goog.uri.utils.StandardQueryParam\x22);\n/**\n * @struct\n * @constructor\n * @param {*\x3d} opt_uri\n * @param {boolean\x3d} opt_ignoreCase\n */\ngoog.Uri \x3d function(opt_uri, opt_ignoreCase) {\n  /** @private @type {string} */ this.scheme_ \x3d \x22\x22;\n  /** @private @type {string} */ this.userInfo_ \x3d \x22\x22;\n  /** @private @type {string} */ this.domain_ \x3d \x22\x22;\n  /** @private @type {?number} */ this.port_ \x3d null;\n  /** @private @type {string} */ this.path_ \x3d \x22\x22;\n  /** @private @type {string} */ this.fragment_ \x3d \x22\x22;\n  /** @private @type {boolean} */ this.isReadOnly_ \x3d false;\n  /** @private @type {boolean} */ this.ignoreCase_ \x3d false;\n  /** @private @type {!goog.Uri.QueryData} */ this.queryData_;\n  var m;\n  if (opt_uri instanceof goog.Uri) {\n    this.ignoreCase_ \x3d opt_ignoreCase !\x3d\x3d undefined ? opt_ignoreCase : opt_uri.getIgnoreCase();\n    this.setScheme(opt_uri.getScheme());\n    this.setUserInfo(opt_uri.getUserInfo());\n    this.setDomain(opt_uri.getDomain());\n    this.setPort(opt_uri.getPort());\n    this.setPath(opt_uri.getPath());\n    this.setQueryData(opt_uri.getQueryData().clone());\n    this.setFragment(opt_uri.getFragment());\n  } else {\n    if (opt_uri \x26\x26 (m \x3d goog.uri.utils.split(String(opt_uri)))) {\n      this.ignoreCase_ \x3d !!opt_ignoreCase;\n      this.setScheme(m[goog.uri.utils.ComponentIndex.SCHEME] || \x22\x22, true);\n      this.setUserInfo(m[goog.uri.utils.ComponentIndex.USER_INFO] || \x22\x22, true);\n      this.setDomain(m[goog.uri.utils.ComponentIndex.DOMAIN] || \x22\x22, true);\n      this.setPort(m[goog.uri.utils.ComponentIndex.PORT]);\n      this.setPath(m[goog.uri.utils.ComponentIndex.PATH] || \x22\x22, true);\n      this.setQueryData(m[goog.uri.utils.ComponentIndex.QUERY_DATA] || \x22\x22, true);\n      this.setFragment(m[goog.uri.utils.ComponentIndex.FRAGMENT] || \x22\x22, true);\n    } else {\n      this.ignoreCase_ \x3d !!opt_ignoreCase;\n      this.queryData_ \x3d new goog.Uri.QueryData(null, null, this.ignoreCase_);\n    }\n  }\n};\n/** @type {string} */ goog.Uri.RANDOM_PARAM \x3d goog.uri.utils.StandardQueryParam.RANDOM;\n/**\n * @return {string}\n * @override\n */\ngoog.Uri.prototype.toString \x3d function() {\n  var out \x3d [];\n  var scheme \x3d this.getScheme();\n  if (scheme) {\n    out.push(goog.Uri.encodeSpecialChars_(scheme, goog.Uri.reDisallowedInSchemeOrUserInfo_, true), \x22:\x22);\n  }\n  var domain \x3d this.getDomain();\n  if (domain || scheme \x3d\x3d \x22file\x22) {\n    out.push(\x22//\x22);\n    var userInfo \x3d this.getUserInfo();\n    if (userInfo) {\n      out.push(goog.Uri.encodeSpecialChars_(userInfo, goog.Uri.reDisallowedInSchemeOrUserInfo_, true), \x22@\x22);\n    }\n    out.push(goog.Uri.removeDoubleEncoding_(goog.string.urlEncode(domain)));\n    var port \x3d this.getPort();\n    if (port !\x3d null) {\n      out.push(\x22:\x22, String(port));\n    }\n  }\n  var path \x3d this.getPath();\n  if (path) {\n    if (this.hasDomain() \x26\x26 path.charAt(0) !\x3d \x22/\x22) {\n      out.push(\x22/\x22);\n    }\n    out.push(goog.Uri.encodeSpecialChars_(path, path.charAt(0) \x3d\x3d \x22/\x22 ? goog.Uri.reDisallowedInAbsolutePath_ : goog.Uri.reDisallowedInRelativePath_, true));\n  }\n  var query \x3d this.getEncodedQuery();\n  if (query) {\n    out.push(\x22?\x22, query);\n  }\n  var fragment \x3d this.getFragment();\n  if (fragment) {\n    out.push(\x22#\x22, goog.Uri.encodeSpecialChars_(fragment, goog.Uri.reDisallowedInFragment_));\n  }\n  return out.join(\x22\x22);\n};\n/**\n * @param {!goog.Uri} relativeUri\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.resolve \x3d function(relativeUri) {\n  var absoluteUri \x3d this.clone();\n  var overridden \x3d relativeUri.hasScheme();\n  if (overridden) {\n    absoluteUri.setScheme(relativeUri.getScheme());\n  } else {\n    overridden \x3d relativeUri.hasUserInfo();\n  }\n  if (overridden) {\n    absoluteUri.setUserInfo(relativeUri.getUserInfo());\n  } else {\n    overridden \x3d relativeUri.hasDomain();\n  }\n  if (overridden) {\n    absoluteUri.setDomain(relativeUri.getDomain());\n  } else {\n    overridden \x3d relativeUri.hasPort();\n  }\n  var path \x3d relativeUri.getPath();\n  if (overridden) {\n    absoluteUri.setPort(relativeUri.getPort());\n  } else {\n    overridden \x3d relativeUri.hasPath();\n    if (overridden) {\n      if (path.charAt(0) !\x3d \x22/\x22) {\n        if (this.hasDomain() \x26\x26 !this.hasPath()) {\n          path \x3d \x22/\x22 + path;\n        } else {\n          var lastSlashIndex \x3d absoluteUri.getPath().lastIndexOf(\x22/\x22);\n          if (lastSlashIndex !\x3d -1) {\n            path \x3d absoluteUri.getPath().substr(0, lastSlashIndex + 1) + path;\n          }\n        }\n      }\n      path \x3d goog.Uri.removeDotSegments(path);\n    }\n  }\n  if (overridden) {\n    absoluteUri.setPath(path);\n  } else {\n    overridden \x3d relativeUri.hasQuery();\n  }\n  if (overridden) {\n    absoluteUri.setQueryData(relativeUri.getQueryData().clone());\n  } else {\n    overridden \x3d relativeUri.hasFragment();\n  }\n  if (overridden) {\n    absoluteUri.setFragment(relativeUri.getFragment());\n  }\n  return absoluteUri;\n};\n/**\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.clone \x3d function() {\n  return new goog.Uri(this);\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getScheme \x3d function() {\n  return this.scheme_;\n};\n/**\n * @param {string} newScheme\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setScheme \x3d function(newScheme, opt_decode) {\n  this.enforceReadOnly();\n  this.scheme_ \x3d opt_decode ? goog.Uri.decodeOrEmpty_(newScheme, true) : newScheme;\n  if (this.scheme_) {\n    this.scheme_ \x3d this.scheme_.replace(/:$/, \x22\x22);\n  }\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasScheme \x3d function() {\n  return !!this.scheme_;\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getUserInfo \x3d function() {\n  return this.userInfo_;\n};\n/**\n * @param {string} newUserInfo\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setUserInfo \x3d function(newUserInfo, opt_decode) {\n  this.enforceReadOnly();\n  this.userInfo_ \x3d opt_decode ? goog.Uri.decodeOrEmpty_(newUserInfo) : newUserInfo;\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasUserInfo \x3d function() {\n  return !!this.userInfo_;\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getDomain \x3d function() {\n  return this.domain_;\n};\n/**\n * @param {string} newDomain\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setDomain \x3d function(newDomain, opt_decode) {\n  this.enforceReadOnly();\n  this.domain_ \x3d opt_decode ? goog.Uri.decodeOrEmpty_(newDomain, true) : newDomain;\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasDomain \x3d function() {\n  return !!this.domain_;\n};\n/**\n * @return {?number}\n */\ngoog.Uri.prototype.getPort \x3d function() {\n  return this.port_;\n};\n/**\n * @param {*} newPort\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setPort \x3d function(newPort) {\n  this.enforceReadOnly();\n  if (newPort) {\n    newPort \x3d Number(newPort);\n    if (isNaN(newPort) || newPort \x3c 0) {\n      throw new Error(\x22Bad port number \x22 + newPort);\n    }\n    this.port_ \x3d newPort;\n  } else {\n    this.port_ \x3d null;\n  }\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasPort \x3d function() {\n  return this.port_ !\x3d null;\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getPath \x3d function() {\n  return this.path_;\n};\n/**\n * @param {string} newPath\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setPath \x3d function(newPath, opt_decode) {\n  this.enforceReadOnly();\n  this.path_ \x3d opt_decode ? goog.Uri.decodeOrEmpty_(newPath, true) : newPath;\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasPath \x3d function() {\n  return !!this.path_;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasQuery \x3d function() {\n  return this.queryData_.toString() !\x3d\x3d \x22\x22;\n};\n/**\n * @param {(goog.Uri.QueryData|string|undefined)} queryData\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setQueryData \x3d function(queryData, opt_decode) {\n  this.enforceReadOnly();\n  if (queryData instanceof goog.Uri.QueryData) {\n    this.queryData_ \x3d queryData;\n    this.queryData_.setIgnoreCase(this.ignoreCase_);\n  } else {\n    if (!opt_decode) {\n      queryData \x3d goog.Uri.encodeSpecialChars_(queryData, goog.Uri.reDisallowedInQuery_);\n    }\n    this.queryData_ \x3d new goog.Uri.QueryData(queryData, null, this.ignoreCase_);\n  }\n  return this;\n};\n/**\n * @param {string} newQuery\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setQuery \x3d function(newQuery, opt_decode) {\n  return this.setQueryData(newQuery, opt_decode);\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getEncodedQuery \x3d function() {\n  return this.queryData_.toString();\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getDecodedQuery \x3d function() {\n  return this.queryData_.toDecodedString();\n};\n/**\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.prototype.getQueryData \x3d function() {\n  return this.queryData_;\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getQuery \x3d function() {\n  return this.getEncodedQuery();\n};\n/**\n * @param {string} key\n * @param {*} value\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setParameterValue \x3d function(key, value) {\n  this.enforceReadOnly();\n  this.queryData_.set(key, value);\n  return this;\n};\n/**\n * @param {string} key\n * @param {*} values\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setParameterValues \x3d function(key, values) {\n  this.enforceReadOnly();\n  if (!goog.isArray(values)) {\n    values \x3d [String(values)];\n  }\n  this.queryData_.setValues(key, values);\n  return this;\n};\n/**\n * @param {string} name\n * @return {!Array\x3c?\x3e}\n */\ngoog.Uri.prototype.getParameterValues \x3d function(name) {\n  return this.queryData_.getValues(name);\n};\n/**\n * @param {string} paramName\n * @return {(string|undefined)}\n */\ngoog.Uri.prototype.getParameterValue \x3d function(paramName) {\n  return (/** @type {(string|undefined)} */ (this.queryData_.get(paramName)));\n};\n/**\n * @return {string}\n */\ngoog.Uri.prototype.getFragment \x3d function() {\n  return this.fragment_;\n};\n/**\n * @param {string} newFragment\n * @param {boolean\x3d} opt_decode\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setFragment \x3d function(newFragment, opt_decode) {\n  this.enforceReadOnly();\n  this.fragment_ \x3d opt_decode ? goog.Uri.decodeOrEmpty_(newFragment) : newFragment;\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.hasFragment \x3d function() {\n  return !!this.fragment_;\n};\n/**\n * @param {!goog.Uri} uri2\n * @return {boolean}\n */\ngoog.Uri.prototype.hasSameDomainAs \x3d function(uri2) {\n  return (!this.hasDomain() \x26\x26 !uri2.hasDomain() || this.getDomain() \x3d\x3d uri2.getDomain()) \x26\x26 (!this.hasPort() \x26\x26 !uri2.hasPort() || this.getPort() \x3d\x3d uri2.getPort());\n};\n/**\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.makeUnique \x3d function() {\n  this.enforceReadOnly();\n  this.setParameterValue(goog.Uri.RANDOM_PARAM, goog.string.getRandomString());\n  return this;\n};\n/**\n * @param {string} key\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.removeParameter \x3d function(key) {\n  this.enforceReadOnly();\n  this.queryData_.remove(key);\n  return this;\n};\n/**\n * @param {boolean} isReadOnly\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setReadOnly \x3d function(isReadOnly) {\n  this.isReadOnly_ \x3d isReadOnly;\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.isReadOnly \x3d function() {\n  return this.isReadOnly_;\n};\ngoog.Uri.prototype.enforceReadOnly \x3d function() {\n  if (this.isReadOnly_) {\n    throw new Error(\x22Tried to modify a read-only Uri\x22);\n  }\n};\n/**\n * @param {boolean} ignoreCase\n * @return {!goog.Uri}\n */\ngoog.Uri.prototype.setIgnoreCase \x3d function(ignoreCase) {\n  this.ignoreCase_ \x3d ignoreCase;\n  if (this.queryData_) {\n    this.queryData_.setIgnoreCase(ignoreCase);\n  }\n  return this;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.prototype.getIgnoreCase \x3d function() {\n  return this.ignoreCase_;\n};\n/**\n * @param {*} uri\n * @param {boolean\x3d} opt_ignoreCase\n * @return {!goog.Uri}\n */\ngoog.Uri.parse \x3d function(uri, opt_ignoreCase) {\n  return uri instanceof goog.Uri ? uri.clone() : new goog.Uri(uri, opt_ignoreCase);\n};\n/**\n * @param {?string\x3d} opt_scheme\n * @param {?string\x3d} opt_userInfo\n * @param {?string\x3d} opt_domain\n * @param {?number\x3d} opt_port\n * @param {?string\x3d} opt_path\n * @param {(string|goog.Uri.QueryData)\x3d} opt_query\n * @param {?string\x3d} opt_fragment\n * @param {boolean\x3d} opt_ignoreCase\n * @return {!goog.Uri}\n */\ngoog.Uri.create \x3d function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_query, opt_fragment, opt_ignoreCase) {\n  var uri \x3d new goog.Uri(null, opt_ignoreCase);\n  opt_scheme \x26\x26 uri.setScheme(opt_scheme);\n  opt_userInfo \x26\x26 uri.setUserInfo(opt_userInfo);\n  opt_domain \x26\x26 uri.setDomain(opt_domain);\n  opt_port \x26\x26 uri.setPort(opt_port);\n  opt_path \x26\x26 uri.setPath(opt_path);\n  opt_query \x26\x26 uri.setQueryData(opt_query);\n  opt_fragment \x26\x26 uri.setFragment(opt_fragment);\n  return uri;\n};\n/**\n * @param {*} base\n * @param {*} rel\n * @return {!goog.Uri}\n */\ngoog.Uri.resolve \x3d function(base, rel) {\n  if (!(base instanceof goog.Uri)) {\n    base \x3d goog.Uri.parse(base);\n  }\n  if (!(rel instanceof goog.Uri)) {\n    rel \x3d goog.Uri.parse(rel);\n  }\n  return base.resolve(rel);\n};\n/**\n * @param {string} path\n * @return {string}\n */\ngoog.Uri.removeDotSegments \x3d function(path) {\n  if (path \x3d\x3d \x22..\x22 || path \x3d\x3d \x22.\x22) {\n    return \x22\x22;\n  } else {\n    if (!goog.string.contains(path, \x22./\x22) \x26\x26 !goog.string.contains(path, \x22/.\x22)) {\n      return path;\n    } else {\n      var leadingSlash \x3d goog.string.startsWith(path, \x22/\x22);\n      var segments \x3d path.split(\x22/\x22);\n      var out \x3d [];\n      for (var pos \x3d 0; pos \x3c segments.length;) {\n        var segment \x3d segments[pos++];\n        if (segment \x3d\x3d \x22.\x22) {\n          if (leadingSlash \x26\x26 pos \x3d\x3d segments.length) {\n            out.push(\x22\x22);\n          }\n        } else {\n          if (segment \x3d\x3d \x22..\x22) {\n            if (out.length \x3e 1 || out.length \x3d\x3d 1 \x26\x26 out[0] !\x3d \x22\x22) {\n              out.pop();\n            }\n            if (leadingSlash \x26\x26 pos \x3d\x3d segments.length) {\n              out.push(\x22\x22);\n            }\n          } else {\n            out.push(segment);\n            leadingSlash \x3d true;\n          }\n        }\n      }\n      return out.join(\x22/\x22);\n    }\n  }\n};\n/**\n * @private\n * @param {(string|undefined)} val\n * @param {boolean\x3d} opt_preserveReserved\n * @return {string}\n */\ngoog.Uri.decodeOrEmpty_ \x3d function(val, opt_preserveReserved) {\n  if (!val) {\n    return \x22\x22;\n  }\n  return opt_preserveReserved ? decodeURI(val.replace(/%25/g, \x22%2525\x22)) : decodeURIComponent(val);\n};\n/**\n * @private\n * @param {*} unescapedPart\n * @param {RegExp} extra\n * @param {boolean\x3d} opt_removeDoubleEncoding\n * @return {?string}\n */\ngoog.Uri.encodeSpecialChars_ \x3d function(unescapedPart, extra, opt_removeDoubleEncoding) {\n  if (typeof unescapedPart \x3d\x3d\x3d \x22string\x22) {\n    var encoded \x3d encodeURI(unescapedPart).replace(extra, goog.Uri.encodeChar_);\n    if (opt_removeDoubleEncoding) {\n      encoded \x3d goog.Uri.removeDoubleEncoding_(encoded);\n    }\n    return encoded;\n  }\n  return null;\n};\n/**\n * @private\n * @param {string} ch\n * @return {string}\n */\ngoog.Uri.encodeChar_ \x3d function(ch) {\n  var n \x3d ch.charCodeAt(0);\n  return \x22%\x22 + (n \x3e\x3e 4 \x26 15).toString(16) + (n \x26 15).toString(16);\n};\n/**\n * @private\n * @param {string} doubleEncodedString\n * @return {string}\n */\ngoog.Uri.removeDoubleEncoding_ \x3d function(doubleEncodedString) {\n  return doubleEncodedString.replace(/%25([0-9a-fA-F]{2})/g, \x22%$1\x22);\n};\n/** @private @type {RegExp} */ goog.Uri.reDisallowedInSchemeOrUserInfo_ \x3d /[#\\/\\?@]/g;\n/** @private @type {RegExp} */ goog.Uri.reDisallowedInRelativePath_ \x3d /[#\\?:]/g;\n/** @private @type {RegExp} */ goog.Uri.reDisallowedInAbsolutePath_ \x3d /[#\\?]/g;\n/** @private @type {RegExp} */ goog.Uri.reDisallowedInQuery_ \x3d /[#\\?@]/g;\n/** @private @type {RegExp} */ goog.Uri.reDisallowedInFragment_ \x3d /#/g;\n/**\n * @param {string} uri1String\n * @param {string} uri2String\n * @return {boolean}\n */\ngoog.Uri.haveSameDomain \x3d function(uri1String, uri2String) {\n  var pieces1 \x3d goog.uri.utils.split(uri1String);\n  var pieces2 \x3d goog.uri.utils.split(uri2String);\n  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] \x3d\x3d pieces2[goog.uri.utils.ComponentIndex.DOMAIN] \x26\x26 pieces1[goog.uri.utils.ComponentIndex.PORT] \x3d\x3d pieces2[goog.uri.utils.ComponentIndex.PORT];\n};\n/**\n * @final\n * @struct\n * @constructor\n * @param {?string\x3d} opt_query\n * @param {goog.Uri\x3d} opt_uri\n * @param {boolean\x3d} opt_ignoreCase\n */\ngoog.Uri.QueryData \x3d function(opt_query, opt_uri, opt_ignoreCase) {\n  /** @private @type {?goog.structs.Map\x3cstring,!Array\x3c*\x3e\x3e} */ this.keyMap_ \x3d null;\n  /** @private @type {?number} */ this.count_ \x3d null;\n  /** @private @type {?string} */ this.encodedQuery_ \x3d opt_query || null;\n  /** @private @type {boolean} */ this.ignoreCase_ \x3d !!opt_ignoreCase;\n};\n/** @private */ goog.Uri.QueryData.prototype.ensureKeyMapInitialized_ \x3d function() {\n  if (!this.keyMap_) {\n    this.keyMap_ \x3d new goog.structs.Map;\n    this.count_ \x3d 0;\n    if (this.encodedQuery_) {\n      var self \x3d this;\n      goog.uri.utils.parseQueryData(this.encodedQuery_, function(name, value) {\n        self.add(goog.string.urlDecode(name), value);\n      });\n    }\n  }\n};\n/**\n * @param {(!goog.structs.Map\x3cstring,?\x3e|!Object)} map\n * @param {goog.Uri\x3d} opt_uri\n * @param {boolean\x3d} opt_ignoreCase\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.QueryData.createFromMap \x3d function(map, opt_uri, opt_ignoreCase) {\n  var keys \x3d goog.structs.getKeys(map);\n  if (typeof keys \x3d\x3d \x22undefined\x22) {\n    throw new Error(\x22Keys are undefined\x22);\n  }\n  var queryData \x3d new goog.Uri.QueryData(null, null, opt_ignoreCase);\n  var values \x3d goog.structs.getValues(map);\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var key \x3d keys[i];\n    var value \x3d values[i];\n    if (!goog.isArray(value)) {\n      queryData.add(key, value);\n    } else {\n      queryData.setValues(key, value);\n    }\n  }\n  return queryData;\n};\n/**\n * @param {!Array\x3cstring\x3e} keys\n * @param {!Array\x3c?\x3e} values\n * @param {goog.Uri\x3d} opt_uri\n * @param {boolean\x3d} opt_ignoreCase\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.QueryData.createFromKeysValues \x3d function(keys, values, opt_uri, opt_ignoreCase) {\n  if (keys.length !\x3d values.length) {\n    throw new Error(\x22Mismatched lengths for keys/values\x22);\n  }\n  var queryData \x3d new goog.Uri.QueryData(null, null, opt_ignoreCase);\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    queryData.add(keys[i], values[i]);\n  }\n  return queryData;\n};\n/**\n * @return {?number}\n */\ngoog.Uri.QueryData.prototype.getCount \x3d function() {\n  this.ensureKeyMapInitialized_();\n  return this.count_;\n};\n/**\n * @param {string} key\n * @param {*} value\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.QueryData.prototype.add \x3d function(key, value) {\n  this.ensureKeyMapInitialized_();\n  this.invalidateCache_();\n  key \x3d this.getKeyName_(key);\n  var values \x3d this.keyMap_.get(key);\n  if (!values) {\n    this.keyMap_.set(key, values \x3d []);\n  }\n  values.push(value);\n  this.count_ \x3d goog.asserts.assertNumber(this.count_) + 1;\n  return this;\n};\n/**\n * @param {string} key\n * @return {boolean}\n */\ngoog.Uri.QueryData.prototype.remove \x3d function(key) {\n  this.ensureKeyMapInitialized_();\n  key \x3d this.getKeyName_(key);\n  if (this.keyMap_.containsKey(key)) {\n    this.invalidateCache_();\n    this.count_ \x3d goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length;\n    return this.keyMap_.remove(key);\n  }\n  return false;\n};\ngoog.Uri.QueryData.prototype.clear \x3d function() {\n  this.invalidateCache_();\n  this.keyMap_ \x3d null;\n  this.count_ \x3d 0;\n};\n/**\n * @return {boolean}\n */\ngoog.Uri.QueryData.prototype.isEmpty \x3d function() {\n  this.ensureKeyMapInitialized_();\n  return this.count_ \x3d\x3d 0;\n};\n/**\n * @param {string} key\n * @return {boolean}\n */\ngoog.Uri.QueryData.prototype.containsKey \x3d function(key) {\n  this.ensureKeyMapInitialized_();\n  key \x3d this.getKeyName_(key);\n  return this.keyMap_.containsKey(key);\n};\n/**\n * @param {*} value\n * @return {boolean}\n */\ngoog.Uri.QueryData.prototype.containsValue \x3d function(value) {\n  var vals \x3d this.getValues();\n  return goog.array.contains(vals, value);\n};\n/**\n * @param {function(this:SCOPE,?,string,!goog.Uri.QueryData)} f\n * @param {SCOPE\x3d} opt_scope\n * @template SCOPE\n */\ngoog.Uri.QueryData.prototype.forEach \x3d function(f, opt_scope) {\n  this.ensureKeyMapInitialized_();\n  this.keyMap_.forEach(function(values, key) {\n    goog.array.forEach(values, function(value) {\n      f.call(opt_scope, value, key, this);\n    }, this);\n  }, this);\n};\n/**\n * @return {!Array\x3cstring\x3e}\n */\ngoog.Uri.QueryData.prototype.getKeys \x3d function() {\n  this.ensureKeyMapInitialized_();\n  var vals \x3d this.keyMap_.getValues();\n  var keys \x3d this.keyMap_.getKeys();\n  var rv \x3d [];\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var val \x3d vals[i];\n    for (var j \x3d 0; j \x3c val.length; j++) {\n      rv.push(keys[i]);\n    }\n  }\n  return rv;\n};\n/**\n * @param {string\x3d} opt_key\n * @return {!Array\x3c?\x3e}\n */\ngoog.Uri.QueryData.prototype.getValues \x3d function(opt_key) {\n  this.ensureKeyMapInitialized_();\n  var rv \x3d [];\n  if (typeof opt_key \x3d\x3d\x3d \x22string\x22) {\n    if (this.containsKey(opt_key)) {\n      rv \x3d goog.array.concat(rv, this.keyMap_.get(this.getKeyName_(opt_key)));\n    }\n  } else {\n    var values \x3d this.keyMap_.getValues();\n    for (var i \x3d 0; i \x3c values.length; i++) {\n      rv \x3d goog.array.concat(rv, values[i]);\n    }\n  }\n  return rv;\n};\n/**\n * @param {string} key\n * @param {*} value\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.QueryData.prototype.set \x3d function(key, value) {\n  this.ensureKeyMapInitialized_();\n  this.invalidateCache_();\n  key \x3d this.getKeyName_(key);\n  if (this.containsKey(key)) {\n    this.count_ \x3d goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length;\n  }\n  this.keyMap_.set(key, [value]);\n  this.count_ \x3d goog.asserts.assertNumber(this.count_) + 1;\n  return this;\n};\n/**\n * @param {string} key\n * @param {*\x3d} opt_default\n * @return {*}\n */\ngoog.Uri.QueryData.prototype.get \x3d function(key, opt_default) {\n  if (!key) {\n    return opt_default;\n  }\n  var values \x3d this.getValues(key);\n  return values.length \x3e 0 ? String(values[0]) : opt_default;\n};\n/**\n * @param {string} key\n * @param {!Array\x3c?\x3e} values\n */\ngoog.Uri.QueryData.prototype.setValues \x3d function(key, values) {\n  this.remove(key);\n  if (values.length \x3e 0) {\n    this.invalidateCache_();\n    this.keyMap_.set(this.getKeyName_(key), goog.array.clone(values));\n    this.count_ \x3d goog.asserts.assertNumber(this.count_) + values.length;\n  }\n};\n/**\n * @return {string}\n * @override\n */\ngoog.Uri.QueryData.prototype.toString \x3d function() {\n  if (this.encodedQuery_) {\n    return this.encodedQuery_;\n  }\n  if (!this.keyMap_) {\n    return \x22\x22;\n  }\n  var sb \x3d [];\n  var keys \x3d this.keyMap_.getKeys();\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var key \x3d keys[i];\n    var encodedKey \x3d goog.string.urlEncode(key);\n    var val \x3d this.getValues(key);\n    for (var j \x3d 0; j \x3c val.length; j++) {\n      var param \x3d encodedKey;\n      if (val[j] !\x3d\x3d \x22\x22) {\n        param +\x3d \x22\\x3d\x22 + goog.string.urlEncode(val[j]);\n      }\n      sb.push(param);\n    }\n  }\n  return this.encodedQuery_ \x3d sb.join(\x22\\x26\x22);\n};\n/**\n * @return {string}\n */\ngoog.Uri.QueryData.prototype.toDecodedString \x3d function() {\n  return goog.Uri.decodeOrEmpty_(this.toString());\n};\n/** @private */ goog.Uri.QueryData.prototype.invalidateCache_ \x3d function() {\n  this.encodedQuery_ \x3d null;\n};\n/**\n * @param {Array\x3cstring\x3e} keys\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.QueryData.prototype.filterKeys \x3d function(keys) {\n  this.ensureKeyMapInitialized_();\n  this.keyMap_.forEach(function(value, key) {\n    if (!goog.array.contains(keys, key)) {\n      this.remove(key);\n    }\n  }, this);\n  return this;\n};\n/**\n * @return {!goog.Uri.QueryData}\n */\ngoog.Uri.QueryData.prototype.clone \x3d function() {\n  var rv \x3d new goog.Uri.QueryData;\n  rv.encodedQuery_ \x3d this.encodedQuery_;\n  if (this.keyMap_) {\n    rv.keyMap_ \x3d this.keyMap_.clone();\n    rv.count_ \x3d this.count_;\n  }\n  return rv;\n};\n/**\n * @private\n * @param {*} arg\n * @return {string}\n */\ngoog.Uri.QueryData.prototype.getKeyName_ \x3d function(arg) {\n  var keyName \x3d String(arg);\n  if (this.ignoreCase_) {\n    keyName \x3d keyName.toLowerCase();\n  }\n  return keyName;\n};\n/**\n * @param {boolean} ignoreCase\n */\ngoog.Uri.QueryData.prototype.setIgnoreCase \x3d function(ignoreCase) {\n  var resetKeys \x3d ignoreCase \x26\x26 !this.ignoreCase_;\n  if (resetKeys) {\n    this.ensureKeyMapInitialized_();\n    this.invalidateCache_();\n    this.keyMap_.forEach(function(value, key) {\n      var lowerCase \x3d key.toLowerCase();\n      if (key !\x3d lowerCase) {\n        this.remove(key);\n        this.setValues(lowerCase, value);\n      }\n    }, this);\n  }\n  this.ignoreCase_ \x3d ignoreCase;\n};\n/**\n * @param {...(?goog.Uri.QueryData|?goog.structs.Map\x3c?,?\x3e|?Object)} var_args\n * @suppress {deprecated}\n */\ngoog.Uri.QueryData.prototype.extend \x3d function(var_args) {\n  for (var i \x3d 0; i \x3c arguments.length; i++) {\n    var data \x3d arguments[i];\n    goog.structs.forEach(data, function(value, key) {\n      this.add(key, value);\n    }, this);\n  }\n};\n");
SHADOW_ENV.evalLoad("goog.string.stringbuffer.js", true , "goog.provide(\x22goog.string.StringBuffer\x22);\n/**\n * @constructor\n * @param {*\x3d} opt_a1\n * @param {...*} var_args\n */\ngoog.string.StringBuffer \x3d function(opt_a1, var_args) {\n  if (opt_a1 !\x3d null) {\n    this.append.apply(this, arguments);\n  }\n};\n/** @private @type {string} */ goog.string.StringBuffer.prototype.buffer_ \x3d \x22\x22;\n/**\n * @param {*} s\n */\ngoog.string.StringBuffer.prototype.set \x3d function(s) {\n  this.buffer_ \x3d \x22\x22 + s;\n};\n/**\n * @param {*} a1\n * @param {*\x3d} opt_a2\n * @param {...?} var_args\n * @return {!goog.string.StringBuffer}\n * @suppress {duplicate}\n */\ngoog.string.StringBuffer.prototype.append \x3d function(a1, opt_a2, var_args) {\n  this.buffer_ +\x3d String(a1);\n  if (opt_a2 !\x3d null) {\n    for (var i \x3d 1; i \x3c arguments.length; i++) {\n      this.buffer_ +\x3d arguments[i];\n    }\n  }\n  return this;\n};\ngoog.string.StringBuffer.prototype.clear \x3d function() {\n  this.buffer_ \x3d \x22\x22;\n};\n/**\n * @return {number}\n */\ngoog.string.StringBuffer.prototype.getLength \x3d function() {\n  return this.buffer_.length;\n};\n/**\n * @return {string}\n * @override\n */\ngoog.string.StringBuffer.prototype.toString \x3d function() {\n  return this.buffer_;\n};\n");
SHADOW_ENV.evalLoad("cljs.core.js", true , "goog.provide(\x27cljs.core\x27);\ngoog.require(\x27goog.math.Long\x27);\ngoog.require(\x27goog.math.Integer\x27);\ngoog.require(\x27goog.string\x27);\ngoog.require(\x27goog.object\x27);\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.Uri\x27);\ngoog.require(\x27goog.string.StringBuffer\x27);\ncljs.core._STAR_clojurescript_version_STAR_ \x3d \x221.10.741\x22;\ncljs.core._STAR_unchecked_if_STAR_ \x3d false;\ncljs.core._STAR_unchecked_arrays_STAR_ \x3d false;\ncljs.core._STAR_warn_on_infer_STAR_ \x3d false;\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core.PROTOCOL_SENTINEL !\x3d\x3d \x27undefined\x27)){\n} else {\ncljs.core.PROTOCOL_SENTINEL \x3d ({});\n}\ncljs.core.MODULE_URIS \x3d null;\ncljs.core.MODULE_INFOS \x3d null;\n/**\n * Var bound to the name value of the compiler build :target option.\n *   For example, if the compiler build :target is :nodejs, *target* will be bound\n *   to \x22nodejs\x22. *target* is a Google Closure define and can be set by compiler\n *   :closure-defines option.\n * @define {string}\n */\ncljs.core._STAR_target_STAR_ \x3d goog.define(\x22cljs.core._STAR_target_STAR_\x22,\x22default\x22);\n/**\n * Manually set the JavaScript global context. Only \x22window\x22, \x22self\x22\n *   , and \x22global\x22 supported. \n * @define {string}\n */\ncljs.core._STAR_global_STAR_ \x3d goog.define(\x22cljs.core._STAR_global_STAR_\x22,\x22default\x22);\n/**\n * Var bound to the current namespace. Only used for bootstrapping.\n * @type {*}\n */\ncljs.core._STAR_ns_STAR_ \x3d null;\n/**\n * @type {*}\n */\ncljs.core._STAR_out_STAR_ \x3d null;\ncljs.core._STAR_assert_STAR_ \x3d true;\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core._STAR_print_fn_STAR_ !\x3d\x3d \x27undefined\x27)){\n} else {\n/**\n * Each runtime environment provides a different way to print output.\n *   Whatever function *print-fn* is bound to will be passed any\n *   Strings which should be printed.\n */\ncljs.core._STAR_print_fn_STAR_ \x3d null;\n}\n/**\n * Arranges to have tap functions executed via the supplied f, a\n *   function of no arguments. Returns true if successful, false otherwise.\n */\ncljs.core._STAR_exec_tap_fn_STAR_ \x3d (function cljs$core$_STAR_exec_tap_fn_STAR_(f){\nif((typeof setTimeout !\x3d\x3d \x27undefined\x27)){\nvar and__4109__auto__ \x3d setTimeout(f,(0));\nif(cljs.core.truth_(and__4109__auto__)){\nreturn true;\n} else {\nreturn and__4109__auto__;\n}\n} else {\nreturn false;\n}\n});\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core._STAR_print_err_fn_STAR_ !\x3d\x3d \x27undefined\x27)){\n} else {\n/**\n * Each runtime environment provides a different way to print error output.\n *   Whatever function *print-err-fn* is bound to will be passed any\n *   Strings which should be printed.\n */\ncljs.core._STAR_print_err_fn_STAR_ \x3d null;\n}\n/**\n * Set *print-fn* to f.\n */\ncljs.core.set_print_fn_BANG_ \x3d (function cljs$core$set_print_fn_BANG_(f){\nreturn (cljs.core._STAR_print_fn_STAR_ \x3d f);\n});\n/**\n * Set *print-err-fn* to f.\n */\ncljs.core.set_print_err_fn_BANG_ \x3d (function cljs$core$set_print_err_fn_BANG_(f){\nreturn (cljs.core._STAR_print_err_fn_STAR_ \x3d f);\n});\n/**\n * When set to true, output will be flushed whenever a newline is printed.\n * \n *   Defaults to true.\n */\ncljs.core._STAR_flush_on_newline_STAR_ \x3d true;\n/**\n * When set to logical false will drop newlines from printing calls.\n *   This is to work around the implicit newlines emitted by standard JavaScript\n *   console objects.\n */\ncljs.core._STAR_print_newline_STAR_ \x3d true;\n/**\n * When set to logical false, strings and characters will be printed with\n *   non-alphanumeric characters converted to the appropriate escape sequences.\n * \n *   Defaults to true\n */\ncljs.core._STAR_print_readably_STAR_ \x3d true;\n/**\n * If set to logical true, when printing an object, its metadata will also\n *   be printed in a form that can be read back by the reader.\n * \n *   Defaults to false.\n */\ncljs.core._STAR_print_meta_STAR_ \x3d false;\n/**\n * When set to logical true, objects will be printed in a way that preserves\n *   their type when read in later.\n * \n *   Defaults to false.\n */\ncljs.core._STAR_print_dup_STAR_ \x3d false;\n/**\n * *print-namespace-maps* controls whether the printer will print\n *   namespace map literal syntax.\n * \n *   Defaults to false, but the REPL binds it to true.\n */\ncljs.core._STAR_print_namespace_maps_STAR_ \x3d false;\n/**\n * *print-length* controls how many items of each collection the\n *   printer will print. If it is bound to logical false, there is no\n *   limit. Otherwise, it must be bound to an integer indicating the maximum\n *   number of items of each collection to print. If a collection contains\n *   more items, the printer will print items up to the limit followed by\n *   \x27...\x27 to represent the remaining items. The root binding is nil\n *   indicating no limit.\n * @type {null|number}\n */\ncljs.core._STAR_print_length_STAR_ \x3d null;\n/**\n * *print-level* controls how many levels deep the printer will\n *   print nested objects. If it is bound to logical false, there is no\n *   limit. Otherwise, it must be bound to an integer indicating the maximum\n *   level to print. Each argument to print is at level 0; if an argument is a\n *   collection, its items are at level 1; and so on. If an object is a\n *   collection and is at a level greater than or equal to the value bound to\n *   *print-level*, the printer prints \x27#\x27 to represent it. The root binding\n *   is nil indicating no limit.\n * @type {null|number}\n */\ncljs.core._STAR_print_level_STAR_ \x3d null;\n/**\n * *print-fns-bodies* controls whether functions print their source or\n *  only their names.\n */\ncljs.core._STAR_print_fn_bodies_STAR_ \x3d false;\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core._STAR_loaded_libs_STAR_ !\x3d\x3d \x27undefined\x27)){\n} else {\n/**\n * @type {*}\n */\ncljs.core._STAR_loaded_libs_STAR_ \x3d null;\n}\ncljs.core.pr_opts \x3d (function cljs$core$pr_opts(){\nreturn new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,\x22flush-on-newline\x22,\x22flush-on-newline\x22,-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,\x22readably\x22,\x22readably\x22,1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,\x22meta\x22,\x22meta\x22,1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,\x22dup\x22,\x22dup\x22,556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,\x22print-length\x22,\x22print-length\x22,1931866356),cljs.core._STAR_print_length_STAR_], null);\n});\n/**\n * Set *print-fn* to console.log\n */\ncljs.core.enable_console_print_BANG_ \x3d (function cljs$core$enable_console_print_BANG_(){\n(cljs.core._STAR_print_newline_STAR_ \x3d false);\n\ncljs.core.set_print_fn_BANG_((function (){\nvar xs \x3d arguments;\nreturn console.log.apply(console,goog.array.clone(xs));\n}));\n\ncljs.core.set_print_err_fn_BANG_((function (){\nvar xs \x3d arguments;\nreturn console.error.apply(console,goog.array.clone(xs));\n}));\n\nreturn null;\n});\n/**\n * Internal - do not use!\n */\ncljs.core.truth_ \x3d (function cljs$core$truth_(x){\nreturn (x !\x3d null \x26\x26 x !\x3d\x3d false);\n});\ncljs.core.not_native \x3d null;\n\n/**\n * Tests if 2 arguments are the same object\n */\ncljs.core.identical_QMARK_ \x3d (function cljs$core$identical_QMARK_(x,y){\nreturn (x \x3d\x3d\x3d y);\n});\n/**\n * Returns true if x is nil, false otherwise.\n */\ncljs.core.nil_QMARK_ \x3d (function cljs$core$nil_QMARK_(x){\nreturn (x \x3d\x3d null);\n});\n/**\n * Returns true if x is a JavaScript array.\n */\ncljs.core.array_QMARK_ \x3d (function cljs$core$array_QMARK_(x){\nif((cljs.core._STAR_target_STAR_ \x3d\x3d\x3d \x22nodejs\x22)){\nreturn Array.isArray(x);\n} else {\nreturn (x instanceof Array);\n}\n});\n/**\n * Returns true if x is a JavaScript number.\n */\ncljs.core.number_QMARK_ \x3d (function cljs$core$number_QMARK_(x){\nreturn typeof x \x3d\x3d\x3d \x27number\x27;\n});\n/**\n * Returns true if x is logical false, false otherwise.\n */\ncljs.core.not \x3d (function cljs$core$not(x){\nif((x \x3d\x3d null)){\nreturn true;\n} else {\nif(x \x3d\x3d\x3d false){\nreturn true;\n} else {\nreturn false;\n\n}\n}\n});\n/**\n * Returns true if x is not nil, false otherwise.\n */\ncljs.core.some_QMARK_ \x3d (function cljs$core$some_QMARK_(x){\nreturn (!((x \x3d\x3d null)));\n});\n/**\n * Returns true if x\x27s constructor is Object\n */\ncljs.core.object_QMARK_ \x3d (function cljs$core$object_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nreturn (x.constructor \x3d\x3d\x3d Object);\n} else {\nreturn false;\n}\n});\n/**\n * Returns true if x is a JavaScript string.\n */\ncljs.core.string_QMARK_ \x3d (function cljs$core$string_QMARK_(x){\nreturn goog.isString(x);\n});\n/**\n * Returns true if x is a JavaScript string of length one.\n */\ncljs.core.char_QMARK_ \x3d (function cljs$core$char_QMARK_(x){\nreturn ((typeof x \x3d\x3d\x3d \x27string\x27) \x26\x26 (((1) \x3d\x3d\x3d x.length)));\n});\n/**\n * Returns true if given any argument.\n */\ncljs.core.any_QMARK_ \x3d (function cljs$core$any_QMARK_(x){\nreturn true;\n});\n/**\n * Internal - do not use!\n */\ncljs.core.native_satisfies_QMARK_ \x3d (function cljs$core$native_satisfies_QMARK_(p,x){\nvar x__$1 \x3d (((x \x3d\x3d null))?null:x);\nif((p[goog.typeOf(x__$1)])){\nreturn true;\n} else {\nif((p[\x22_\x22])){\nreturn true;\n} else {\nreturn false;\n\n}\n}\n});\ncljs.core.is_proto_ \x3d (function cljs$core$is_proto_(x){\nreturn (x.constructor.prototype \x3d\x3d\x3d x);\n});\n/**\n * When compiled for a command-line target, whatever function\n *   *main-cli-fn* is set to will be called with the command-line\n *   argv as arguments\n */\ncljs.core._STAR_main_cli_fn_STAR_ \x3d null;\n/**\n * A sequence of the supplied command line arguments, or nil if\n *   none were supplied\n */\ncljs.core._STAR_command_line_args_STAR_ \x3d null;\n/**\n * Return x\x27s constructor.\n */\ncljs.core.type \x3d (function cljs$core$type(x){\nif((x \x3d\x3d null)){\nreturn null;\n} else {\nreturn x.constructor;\n}\n});\ncljs.core.missing_protocol \x3d (function cljs$core$missing_protocol(proto,obj){\nvar ty \x3d cljs.core.type(obj);\nvar ty__$1 \x3d (cljs.core.truth_((function (){var and__4109__auto__ \x3d ty;\nif(cljs.core.truth_(and__4109__auto__)){\nreturn ty.cljs$lang$type;\n} else {\nreturn and__4109__auto__;\n}\n})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));\nreturn (new Error([\x22No protocol method \x22,proto,\x22 defined for type \x22,ty__$1,\x22: \x22,obj].join(\x22\x22)));\n});\ncljs.core.type__GT_str \x3d (function cljs$core$type__GT_str(ty){\nvar temp__5733__auto__ \x3d ty.cljs$lang$ctorStr;\nif(cljs.core.truth_(temp__5733__auto__)){\nvar s \x3d temp__5733__auto__;\nreturn s;\n} else {\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);\n}\n});\ncljs.core.load_file \x3d (function cljs$core$load_file(file){\nif(cljs.core.truth_(COMPILED)){\nreturn null;\n} else {\nreturn goog.nodeGlobalRequire(file);\n}\n});\nif((((typeof Symbol !\x3d\x3d \x27undefined\x27)) \x26\x26 ((goog.typeOf(Symbol) \x3d\x3d\x3d \x22function\x22)))){\ncljs.core.ITER_SYMBOL \x3d Symbol.iterator;\n} else {\ncljs.core.ITER_SYMBOL \x3d \x22@@iterator\x22;\n}\n/**\n * @enum {string}\n */\ncljs.core.CHAR_MAP \x3d ({\x22]\x22: \x22_RBRACK_\x22, \x22\x27\x22: \x22_SINGLEQUOTE_\x22, \x22\x3d\x22: \x22_EQ_\x22, \x22\\\x22\x22: \x22_DOUBLEQUOTE_\x22, \x22!\x22: \x22_BANG_\x22, \x22*\x22: \x22_STAR_\x22, \x22%\x22: \x22_PERCENT_\x22, \x22|\x22: \x22_BAR_\x22, \x22~\x22: \x22_TILDE_\x22, \x22/\x22: \x22_SLASH_\x22, \x22\\\\\x22: \x22_BSLASH_\x22, \x22-\x22: \x22_\x22, \x22?\x22: \x22_QMARK_\x22, \x22\x26\x22: \x22_AMPERSAND_\x22, \x22:\x22: \x22_COLON_\x22, \x22\x3c\x22: \x22_LT_\x22, \x22{\x22: \x22_LBRACE_\x22, \x22}\x22: \x22_RBRACE_\x22, \x22[\x22: \x22_LBRACK_\x22, \x22#\x22: \x22_SHARP_\x22, \x22^\x22: \x22_CARET_\x22, \x22+\x22: \x22_PLUS_\x22, \x22@\x22: \x22_CIRCA_\x22, \x22\x3e\x22: \x22_GT_\x22});\n/**\n * @enum {string}\n */\ncljs.core.DEMUNGE_MAP \x3d ({\x22_RBRACE_\x22: \x22}\x22, \x22_COLON_\x22: \x22:\x22, \x22_BANG_\x22: \x22!\x22, \x22_QMARK_\x22: \x22?\x22, \x22_BSLASH_\x22: \x22\\\\\\\\\x22, \x22_SLASH_\x22: \x22/\x22, \x22_PERCENT_\x22: \x22%\x22, \x22_PLUS_\x22: \x22+\x22, \x22_SHARP_\x22: \x22#\x22, \x22_LBRACE_\x22: \x22{\x22, \x22_BAR_\x22: \x22|\x22, \x22_LBRACK_\x22: \x22[\x22, \x22_EQ_\x22: \x22\x3d\x22, \x22_\x22: \x22-\x22, \x22_TILDE_\x22: \x22~\x22, \x22_RBRACK_\x22: \x22]\x22, \x22_GT_\x22: \x22\x3e\x22, \x22_SINGLEQUOTE_\x22: \x22\x27\x22, \x22_CIRCA_\x22: \x22@\x22, \x22_AMPERSAND_\x22: \x22\x26\x22, \x22_DOUBLEQUOTE_\x22: \x22\\\\\\\x22\x22, \x22_CARET_\x22: \x22^\x22, \x22_LT_\x22: \x22\x3c\x22, \x22_STAR_\x22: \x22*\x22});\ncljs.core.DEMUNGE_PATTERN \x3d null;\n/**\n * Returns highest resolution time offered by host in milliseconds.\n */\ncljs.core.system_time \x3d (function cljs$core$system_time(){\nif((((typeof performance !\x3d\x3d \x27undefined\x27)) \x26\x26 ((!((performance.now \x3d\x3d null)))))){\nreturn performance.now();\n} else {\nif((((typeof process !\x3d\x3d \x27undefined\x27)) \x26\x26 ((!((process.hrtime \x3d\x3d null)))))){\nvar t \x3d process.hrtime();\nreturn ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);\n} else {\nreturn (new Date()).getTime();\n\n}\n}\n});\n/**\n * Construct a JavaScript array of the specified dimensions. Accepts ignored\n *   type argument for compatibility with Clojure. Note that there is no efficient\n *   way to allocate multi-dimensional arrays in JavaScript; as such, this function\n *   will run in polynomial time when called with 3 or more arguments.\n */\ncljs.core.make_array \x3d (function cljs$core$make_array(var_args){\nvar G__18296 \x3d arguments.length;\nswitch (G__18296) {\ncase 1:\nreturn cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19893 \x3d arguments.length;\nvar i__4731__auto___19894 \x3d (0);\nwhile(true){\nif((i__4731__auto___19894 \x3c len__4730__auto___19893)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19894]));\n\nvar G__19895 \x3d (i__4731__auto___19894 + (1));\ni__4731__auto___19894 \x3d G__19895;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size){\nreturn (new Array(size));\n}));\n\n(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (type,size){\nreturn (new Array(size));\n}));\n\n(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic \x3d (function (type,size,more_sizes){\nvar dims \x3d more_sizes;\nvar dimarray \x3d (new Array(size));\nvar n__4607__auto___19899 \x3d dimarray.length;\nvar i_19900 \x3d (0);\nwhile(true){\nif((i_19900 \x3c n__4607__auto___19899)){\n(dimarray[i_19900] \x3d (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null,cljs.core.make_array,null,dims)));\n\nvar G__19903 \x3d (i_19900 + (1));\ni_19900 \x3d G__19903;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn dimarray;\n}));\n\n/** @this {Function} */\n(cljs.core.make_array.cljs$lang$applyTo \x3d (function (seq18293){\nvar G__18294 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18293) : cljs.core.first.call(null,seq18293));\nvar seq18293__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18293) : cljs.core.next.call(null,seq18293));\nvar G__18295 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18293__$1) : cljs.core.first.call(null,seq18293__$1));\nvar seq18293__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18293__$1) : cljs.core.next.call(null,seq18293__$1));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18294,G__18295,seq18293__$2);\n}));\n\n(cljs.core.make_array.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns a javascript array, cloned from the passed in array\n */\ncljs.core.aclone \x3d (function cljs$core$aclone(arr){\nvar len \x3d arr.length;\nvar new_arr \x3d (new Array(len));\nvar n__4607__auto___19904 \x3d len;\nvar i_19905 \x3d (0);\nwhile(true){\nif((i_19905 \x3c n__4607__auto___19904)){\n(new_arr[i_19905] \x3d (arr[i_19905]));\n\nvar G__19910 \x3d (i_19905 + (1));\ni_19905 \x3d G__19910;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn new_arr;\n});\n/**\n * Creates a new javascript array.\n * @param {...*} var_args\n */\ncljs.core.array \x3d (function cljs$core$array(var_args){\nvar a \x3d (new Array(arguments.length));\nvar i \x3d (0);\nwhile(true){\nif((i \x3c a.length)){\n(a[i] \x3d (arguments[i]));\n\nvar G__19912 \x3d (i + (1));\ni \x3d G__19912;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n});\ncljs.core.maybe_warn \x3d (function cljs$core$maybe_warn(e){\nif(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){\nreturn cljs.core._STAR_print_err_fn_STAR_.call(null,e);\n} else {\nreturn null;\n}\n});\ncljs.core.checked_aget \x3d (function cljs$core$checked_aget(var_args){\nvar G__18301 \x3d arguments.length;\nswitch (G__18301) {\ncase 2:\nreturn cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19918 \x3d arguments.length;\nvar i__4731__auto___19919 \x3d (0);\nwhile(true){\nif((i__4731__auto___19919 \x3c len__4730__auto___19918)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19919]));\n\nvar G__19920 \x3d (i__4731__auto___19919 + (1));\ni__4731__auto___19919 \x3d G__19920;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,idx){\ntry{if(cljs.core.truth_((function (){var or__4120__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif((!((idx \x3c (0))))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n}catch (e18302){var e_19926 \x3d e18302;\ncljs.core.maybe_warn(e_19926);\n}\nreturn (array[idx]);\n}));\n\n(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idxs){\nvar G__18303 \x3d cljs.core.checked_aget;\nvar G__18304 \x3d cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__18305 \x3d idxs;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__18303,G__18304,G__18305) : cljs.core.apply.call(null,G__18303,G__18304,G__18305));\n}));\n\n/** @this {Function} */\n(cljs.core.checked_aget.cljs$lang$applyTo \x3d (function (seq18298){\nvar G__18299 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18298) : cljs.core.first.call(null,seq18298));\nvar seq18298__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18298) : cljs.core.next.call(null,seq18298));\nvar G__18300 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18298__$1) : cljs.core.first.call(null,seq18298__$1));\nvar seq18298__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18298__$1) : cljs.core.next.call(null,seq18298__$1));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18299,G__18300,seq18298__$2);\n}));\n\n(cljs.core.checked_aget.cljs$lang$maxFixedArity \x3d (2));\n\ncljs.core.checked_aset \x3d (function cljs$core$checked_aset(var_args){\nvar G__18311 \x3d arguments.length;\nswitch (G__18311) {\ncase 3:\nreturn cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19933 \x3d arguments.length;\nvar i__4731__auto___19934 \x3d (0);\nwhile(true){\nif((i__4731__auto___19934 \x3c len__4730__auto___19933)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19934]));\n\nvar G__19935 \x3d (i__4731__auto___19934 + (1));\ni__4731__auto___19934 \x3d G__19935;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));\nreturn cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 \x3d (function (array,idx,val){\ntry{if(cljs.core.truth_((function (){var or__4120__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif((!((idx \x3c (0))))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n}catch (e18312){var e_19936 \x3d e18312;\ncljs.core.maybe_warn(e_19936);\n}\nreturn (array[idx] \x3d val);\n}));\n\n(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idx2,idxv){\nvar G__18313 \x3d cljs.core.checked_aset;\nvar G__18314 \x3d cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__18315 \x3d idx2;\nvar G__18316 \x3d idxv;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__18313,G__18314,G__18315,G__18316) : cljs.core.apply.call(null,G__18313,G__18314,G__18315,G__18316));\n}));\n\n/** @this {Function} */\n(cljs.core.checked_aset.cljs$lang$applyTo \x3d (function (seq18307){\nvar G__18308 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18307) : cljs.core.first.call(null,seq18307));\nvar seq18307__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18307) : cljs.core.next.call(null,seq18307));\nvar G__18309 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18307__$1) : cljs.core.first.call(null,seq18307__$1));\nvar seq18307__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18307__$1) : cljs.core.next.call(null,seq18307__$1));\nvar G__18310 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18307__$2) : cljs.core.first.call(null,seq18307__$2));\nvar seq18307__$3 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18307__$2) : cljs.core.next.call(null,seq18307__$2));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18308,G__18309,G__18310,seq18307__$3);\n}));\n\n(cljs.core.checked_aset.cljs$lang$maxFixedArity \x3d (3));\n\ncljs.core.checked_aget_SINGLEQUOTE_ \x3d (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){\nvar G__18321 \x3d arguments.length;\nswitch (G__18321) {\ncase 2:\nreturn cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19943 \x3d arguments.length;\nvar i__4731__auto___19946 \x3d (0);\nwhile(true){\nif((i__4731__auto___19946 \x3c len__4730__auto___19943)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19946]));\n\nvar G__19949 \x3d (i__4731__auto___19946 + (1));\ni__4731__auto___19946 \x3d G__19949;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,idx){\nif(cljs.core.truth_((function (){var or__4120__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif((!((idx \x3c (0))))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n\nreturn (array[idx]);\n}));\n\n(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idxs){\nvar G__18322 \x3d cljs.core.checked_aget_SINGLEQUOTE_;\nvar G__18323 \x3d cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__18324 \x3d idxs;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__18322,G__18323,G__18324) : cljs.core.apply.call(null,G__18322,G__18323,G__18324));\n}));\n\n/** @this {Function} */\n(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo \x3d (function (seq18318){\nvar G__18319 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18318) : cljs.core.first.call(null,seq18318));\nvar seq18318__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18318) : cljs.core.next.call(null,seq18318));\nvar G__18320 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18318__$1) : cljs.core.first.call(null,seq18318__$1));\nvar seq18318__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18318__$1) : cljs.core.next.call(null,seq18318__$1));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18319,G__18320,seq18318__$2);\n}));\n\n(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity \x3d (2));\n\ncljs.core.checked_aset_SINGLEQUOTE_ \x3d (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){\nvar G__18330 \x3d arguments.length;\nswitch (G__18330) {\ncase 3:\nreturn cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19964 \x3d arguments.length;\nvar i__4731__auto___19965 \x3d (0);\nwhile(true){\nif((i__4731__auto___19965 \x3c len__4730__auto___19964)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19965]));\n\nvar G__19968 \x3d (i__4731__auto___19965 + (1));\ni__4731__auto___19965 \x3d G__19968;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));\nreturn cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 \x3d (function (array,idx,val){\nif(cljs.core.truth_((function (){var or__4120__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif((!((idx \x3c (0))))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n\nreturn (array[idx] \x3d val);\n}));\n\n(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idx2,idxv){\nvar G__18331 \x3d cljs.core.checked_aset_SINGLEQUOTE_;\nvar G__18332 \x3d cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__18333 \x3d idx2;\nvar G__18334 \x3d idxv;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__18331,G__18332,G__18333,G__18334) : cljs.core.apply.call(null,G__18331,G__18332,G__18333,G__18334));\n}));\n\n/** @this {Function} */\n(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo \x3d (function (seq18326){\nvar G__18327 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18326) : cljs.core.first.call(null,seq18326));\nvar seq18326__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18326) : cljs.core.next.call(null,seq18326));\nvar G__18328 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18326__$1) : cljs.core.first.call(null,seq18326__$1));\nvar seq18326__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18326__$1) : cljs.core.next.call(null,seq18326__$1));\nvar G__18329 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18326__$2) : cljs.core.first.call(null,seq18326__$2));\nvar seq18326__$3 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18326__$2) : cljs.core.next.call(null,seq18326__$2));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18327,G__18328,G__18329,seq18326__$3);\n}));\n\n(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity \x3d (3));\n\n/**\n * Returns the value at the index/indices. Works on JavaScript arrays.\n */\ncljs.core.aget \x3d (function cljs$core$aget(var_args){\nvar G__18339 \x3d arguments.length;\nswitch (G__18339) {\ncase 2:\nreturn cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19980 \x3d arguments.length;\nvar i__4731__auto___19981 \x3d (0);\nwhile(true){\nif((i__4731__auto___19981 \x3c len__4730__auto___19980)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19981]));\n\nvar G__19982 \x3d (i__4731__auto___19981 + (1));\ni__4731__auto___19981 \x3d G__19982;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,idx){\nreturn (array[idx]);\n}));\n\n(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idxs){\nvar G__18340 \x3d cljs.core.aget;\nvar G__18341 \x3d (array[idx]);\nvar G__18342 \x3d idxs;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__18340,G__18341,G__18342) : cljs.core.apply.call(null,G__18340,G__18341,G__18342));\n}));\n\n/** @this {Function} */\n(cljs.core.aget.cljs$lang$applyTo \x3d (function (seq18336){\nvar G__18337 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18336) : cljs.core.first.call(null,seq18336));\nvar seq18336__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18336) : cljs.core.next.call(null,seq18336));\nvar G__18338 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18336__$1) : cljs.core.first.call(null,seq18336__$1));\nvar seq18336__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18336__$1) : cljs.core.next.call(null,seq18336__$1));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18337,G__18338,seq18336__$2);\n}));\n\n(cljs.core.aget.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Sets the value at the index/indices. Works on JavaScript arrays.\n *   Returns val.\n */\ncljs.core.aset \x3d (function cljs$core$aset(var_args){\nvar G__18348 \x3d arguments.length;\nswitch (G__18348) {\ncase 3:\nreturn cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___19984 \x3d arguments.length;\nvar i__4731__auto___19985 \x3d (0);\nwhile(true){\nif((i__4731__auto___19985 \x3c len__4730__auto___19984)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___19985]));\n\nvar G__19986 \x3d (i__4731__auto___19985 + (1));\ni__4731__auto___19985 \x3d G__19986;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));\nreturn cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 \x3d (function (array,idx,val){\nreturn (array[idx] \x3d val);\n}));\n\n(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idx2,idxv){\nvar G__18349 \x3d cljs.core.aset;\nvar G__18350 \x3d (array[idx]);\nvar G__18351 \x3d idx2;\nvar G__18352 \x3d idxv;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__18349,G__18350,G__18351,G__18352) : cljs.core.apply.call(null,G__18349,G__18350,G__18351,G__18352));\n}));\n\n/** @this {Function} */\n(cljs.core.aset.cljs$lang$applyTo \x3d (function (seq18344){\nvar G__18345 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18344) : cljs.core.first.call(null,seq18344));\nvar seq18344__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18344) : cljs.core.next.call(null,seq18344));\nvar G__18346 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18344__$1) : cljs.core.first.call(null,seq18344__$1));\nvar seq18344__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18344__$1) : cljs.core.next.call(null,seq18344__$1));\nvar G__18347 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18344__$2) : cljs.core.first.call(null,seq18344__$2));\nvar seq18344__$3 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18344__$2) : cljs.core.next.call(null,seq18344__$2));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18345,G__18346,G__18347,seq18344__$3);\n}));\n\n(cljs.core.aset.cljs$lang$maxFixedArity \x3d (3));\n\n/**\n * Returns the length of the array. Works on arrays of all types.\n */\ncljs.core.alength \x3d (function cljs$core$alength(array){\nreturn array.length;\n});\n/**\n * Returns an array with components set to the values in aseq. Optional type\n *   argument accepted for compatibility with Clojure.\n */\ncljs.core.into_array \x3d (function cljs$core$into_array(var_args){\nvar G__18354 \x3d arguments.length;\nswitch (G__18354) {\ncase 1:\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (aseq){\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);\n}));\n\n(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (type,aseq){\nvar G__18355 \x3d (function (a,x){\na.push(x);\n\nreturn a;\n});\nvar G__18356 \x3d [];\nvar G__18357 \x3d aseq;\nreturn (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__18355,G__18356,G__18357) : cljs.core.reduce.call(null,G__18355,G__18356,G__18357));\n}));\n\n(cljs.core.into_array.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Invoke JavaScript object method via string. Needed when the\n *   string is not a valid unquoted property name.\n */\ncljs.core.js_invoke \x3d (function cljs$core$js_invoke(var_args){\nvar args__4736__auto__ \x3d [];\nvar len__4730__auto___19988 \x3d arguments.length;\nvar i__4731__auto___19989 \x3d (0);\nwhile(true){\nif((i__4731__auto___19989 \x3c len__4730__auto___19988)){\nargs__4736__auto__.push((arguments[i__4731__auto___19989]));\n\nvar G__19990 \x3d (i__4731__auto___19989 + (1));\ni__4731__auto___19989 \x3d G__19990;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4737__auto__ \x3d ((((2) \x3c args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);\nreturn cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);\n});\n\n(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic \x3d (function (obj,s,args){\nreturn (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));\n}));\n\n(cljs.core.js_invoke.cljs$lang$maxFixedArity \x3d (2));\n\n/** @this {Function} */\n(cljs.core.js_invoke.cljs$lang$applyTo \x3d (function (seq18358){\nvar G__18359 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18358) : cljs.core.first.call(null,seq18358));\nvar seq18358__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18358) : cljs.core.next.call(null,seq18358));\nvar G__18360 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq18358__$1) : cljs.core.first.call(null,seq18358__$1));\nvar seq18358__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq18358__$1) : cljs.core.next.call(null,seq18358__$1));\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18359,G__18360,seq18358__$2);\n}));\n\n/**\n * Returns true if x is an instance of Symbol\n */\ncljs.core.js_symbol_QMARK_ \x3d (function cljs$core$js_symbol_QMARK_(x){\nreturn (((goog.typeOf(x) \x3d\x3d\x3d \x22symbol\x22)) || ((((typeof Symbol !\x3d\x3d \x27undefined\x27)) \x26\x26 ((x instanceof Symbol)))));\n});\n\n/**\n * Marker protocol\n * @interface\n */\ncljs.core.Fn \x3d function(){};\n\n\n/**\n * Protocol for adding the ability to invoke an object as a function.\n *   For example, a vector can also be used to look up a value:\n *   ([1 2 3 4] 1) \x3d\x3e 2\n * @interface\n */\ncljs.core.IFn \x3d function(){};\n\nvar cljs$core$IFn$_invoke$dyn_19991 \x3d (function() {\nvar G__19992 \x3d null;\nvar G__19992__1 \x3d (function (this$){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4423__auto__.call(null,this$));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4420__auto__.call(null,this$));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__2 \x3d (function (this$,a){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4423__auto__.call(null,this$,a));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4420__auto__.call(null,this$,a));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__3 \x3d (function (this$,a,b){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4423__auto__.call(null,this$,a,b));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4420__auto__.call(null,this$,a,b));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__4 \x3d (function (this$,a,b,c){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4423__auto__.call(null,this$,a,b,c));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4420__auto__.call(null,this$,a,b,c));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__5 \x3d (function (this$,a,b,c,d){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4423__auto__.call(null,this$,a,b,c,d));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4420__auto__.call(null,this$,a,b,c,d));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__6 \x3d (function (this$,a,b,c,d,e){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4423__auto__.call(null,this$,a,b,c,d,e));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4420__auto__.call(null,this$,a,b,c,d,e));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__7 \x3d (function (this$,a,b,c,d,e,f){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4423__auto__.call(null,this$,a,b,c,d,e,f));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4420__auto__.call(null,this$,a,b,c,d,e,f));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__8 \x3d (function (this$,a,b,c,d,e,f,g){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__9 \x3d (function (this$,a,b,c,d,e,f,g,h){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__10 \x3d (function (this$,a,b,c,d,e,f,g,h,i){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__11 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__12 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__13 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__14 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__15 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__16 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__17 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__18 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__19 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__20 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__21 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nvar G__19992__22 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4423__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._invoke[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4420__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n});\nG__19992 \x3d function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nswitch(arguments.length){\ncase 1:\nreturn G__19992__1.call(this,this$);\ncase 2:\nreturn G__19992__2.call(this,this$,a);\ncase 3:\nreturn G__19992__3.call(this,this$,a,b);\ncase 4:\nreturn G__19992__4.call(this,this$,a,b,c);\ncase 5:\nreturn G__19992__5.call(this,this$,a,b,c,d);\ncase 6:\nreturn G__19992__6.call(this,this$,a,b,c,d,e);\ncase 7:\nreturn G__19992__7.call(this,this$,a,b,c,d,e,f);\ncase 8:\nreturn G__19992__8.call(this,this$,a,b,c,d,e,f,g);\ncase 9:\nreturn G__19992__9.call(this,this$,a,b,c,d,e,f,g,h);\ncase 10:\nreturn G__19992__10.call(this,this$,a,b,c,d,e,f,g,h,i);\ncase 11:\nreturn G__19992__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);\ncase 12:\nreturn G__19992__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);\ncase 13:\nreturn G__19992__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);\ncase 14:\nreturn G__19992__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);\ncase 15:\nreturn G__19992__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);\ncase 16:\nreturn G__19992__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);\ncase 17:\nreturn G__19992__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);\ncase 18:\nreturn G__19992__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\ncase 19:\nreturn G__19992__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);\ncase 20:\nreturn G__19992__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);\ncase 21:\nreturn G__19992__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);\ncase 22:\nreturn G__19992__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__19992.cljs$core$IFn$_invoke$arity$1 \x3d G__19992__1;\nG__19992.cljs$core$IFn$_invoke$arity$2 \x3d G__19992__2;\nG__19992.cljs$core$IFn$_invoke$arity$3 \x3d G__19992__3;\nG__19992.cljs$core$IFn$_invoke$arity$4 \x3d G__19992__4;\nG__19992.cljs$core$IFn$_invoke$arity$5 \x3d G__19992__5;\nG__19992.cljs$core$IFn$_invoke$arity$6 \x3d G__19992__6;\nG__19992.cljs$core$IFn$_invoke$arity$7 \x3d G__19992__7;\nG__19992.cljs$core$IFn$_invoke$arity$8 \x3d G__19992__8;\nG__19992.cljs$core$IFn$_invoke$arity$9 \x3d G__19992__9;\nG__19992.cljs$core$IFn$_invoke$arity$10 \x3d G__19992__10;\nG__19992.cljs$core$IFn$_invoke$arity$11 \x3d G__19992__11;\nG__19992.cljs$core$IFn$_invoke$arity$12 \x3d G__19992__12;\nG__19992.cljs$core$IFn$_invoke$arity$13 \x3d G__19992__13;\nG__19992.cljs$core$IFn$_invoke$arity$14 \x3d G__19992__14;\nG__19992.cljs$core$IFn$_invoke$arity$15 \x3d G__19992__15;\nG__19992.cljs$core$IFn$_invoke$arity$16 \x3d G__19992__16;\nG__19992.cljs$core$IFn$_invoke$arity$17 \x3d G__19992__17;\nG__19992.cljs$core$IFn$_invoke$arity$18 \x3d G__19992__18;\nG__19992.cljs$core$IFn$_invoke$arity$19 \x3d G__19992__19;\nG__19992.cljs$core$IFn$_invoke$arity$20 \x3d G__19992__20;\nG__19992.cljs$core$IFn$_invoke$arity$21 \x3d G__19992__21;\nG__19992.cljs$core$IFn$_invoke$arity$22 \x3d G__19992__22;\nreturn G__19992;\n})()\n;\ncljs.core._invoke \x3d (function cljs$core$_invoke(var_args){\nvar G__18362 \x3d arguments.length;\nswitch (G__18362) {\ncase 1:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase 6:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ncase 7:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));\n\nbreak;\ncase 8:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));\n\nbreak;\ncase 9:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));\n\nbreak;\ncase 10:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));\n\nbreak;\ncase 11:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));\n\nbreak;\ncase 12:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));\n\nbreak;\ncase 13:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));\n\nbreak;\ncase 14:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));\n\nbreak;\ncase 15:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));\n\nbreak;\ncase 16:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));\n\nbreak;\ncase 17:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));\n\nbreak;\ncase 18:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));\n\nbreak;\ncase 19:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));\n\nbreak;\ncase 20:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));\n\nbreak;\ncase 21:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));\n\nbreak;\ncase 22:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 \x3d (function (this$){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$1 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$1(this$);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 \x3d (function (this$,a){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$2 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$2(this$,a);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 \x3d (function (this$,a,b){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$3 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 \x3d (function (this$,a,b,c){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$4 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 \x3d (function (this$,a,b,c,d){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$5 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 \x3d (function (this$,a,b,c,d,e){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$6 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 \x3d (function (this$,a,b,c,d,e,f){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$7 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 \x3d (function (this$,a,b,c,d,e,f,g){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$8 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 \x3d (function (this$,a,b,c,d,e,f,g,h){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$9 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 \x3d (function (this$,a,b,c,d,e,f,g,h,i){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$10 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$11 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$12 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$13 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$14 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$15 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$16 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$17 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$18 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$19 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$20 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$21 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);\n}\n}));\n\n(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IFn$_invoke$arity$22 \x3d\x3d null)))))){\nreturn this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);\n} else {\nreturn cljs$core$IFn$_invoke$dyn_19991(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);\n}\n}));\n\n(cljs.core._invoke.cljs$lang$maxFixedArity \x3d 22);\n\n\n\n/**\n * Protocol for cloning a value.\n * @interface\n */\ncljs.core.ICloneable \x3d function(){};\n\nvar cljs$core$ICloneable$_clone$dyn_20235 \x3d (function (value){\nvar x__4422__auto__ \x3d (((value \x3d\x3d null))?null:value);\nvar m__4423__auto__ \x3d (cljs.core._clone[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4423__auto__.call(null,value));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._clone[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4420__auto__.call(null,value));\n} else {\nthrow cljs.core.missing_protocol(\x22ICloneable.-clone\x22,value);\n}\n}\n});\n/**\n * Creates a clone of value.\n */\ncljs.core._clone \x3d (function cljs$core$_clone(value){\nif((((!((value \x3d\x3d null)))) \x26\x26 ((!((value.cljs$core$ICloneable$_clone$arity$1 \x3d\x3d null)))))){\nreturn value.cljs$core$ICloneable$_clone$arity$1(value);\n} else {\nreturn cljs$core$ICloneable$_clone$dyn_20235(value);\n}\n});\n\n\n/**\n * Protocol for adding the ability to count a collection in constant time.\n * @interface\n */\ncljs.core.ICounted \x3d function(){};\n\nvar cljs$core$ICounted$_count$dyn_20238 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._count[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._count[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ICounted.-count\x22,coll);\n}\n}\n});\n/**\n * Calculates the count of coll in constant time. Used by cljs.core/count.\n */\ncljs.core._count \x3d (function cljs$core$_count(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ICounted$_count$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$ICounted$_count$arity$1(coll);\n} else {\nreturn cljs$core$ICounted$_count$dyn_20238(coll);\n}\n});\n\n\n/**\n * Protocol for creating an empty collection.\n * @interface\n */\ncljs.core.IEmptyableCollection \x3d function(){};\n\nvar cljs$core$IEmptyableCollection$_empty$dyn_20246 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._empty[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._empty[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IEmptyableCollection.-empty\x22,coll);\n}\n}\n});\n/**\n * Returns an empty collection of the same category as coll. Used\n *   by cljs.core/empty.\n */\ncljs.core._empty \x3d (function cljs$core$_empty(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);\n} else {\nreturn cljs$core$IEmptyableCollection$_empty$dyn_20246(coll);\n}\n});\n\n\n/**\n * Protocol for adding to a collection.\n * @interface\n */\ncljs.core.ICollection \x3d function(){};\n\nvar cljs$core$ICollection$_conj$dyn_20251 \x3d (function (coll,o){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._conj[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4423__auto__.call(null,coll,o));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._conj[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4420__auto__.call(null,coll,o));\n} else {\nthrow cljs.core.missing_protocol(\x22ICollection.-conj\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll with o added to it. The new item\n *   should be added to the most efficient place, e.g.\n *   (conj [1 2 3 4] 5) \x3d\x3e [1 2 3 4 5]\n *   (conj \x27(2 3 4 5) 1) \x3d\x3e \x27(1 2 3 4 5)\n */\ncljs.core._conj \x3d (function cljs$core$_conj(coll,o){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ICollection$_conj$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$ICollection$_conj$arity$2(coll,o);\n} else {\nreturn cljs$core$ICollection$_conj$dyn_20251(coll,o);\n}\n});\n\n\n/**\n * Protocol for collections to provide indexed-based access to their items.\n * @interface\n */\ncljs.core.IIndexed \x3d function(){};\n\nvar cljs$core$IIndexed$_nth$dyn_20258 \x3d (function() {\nvar G__20261 \x3d null;\nvar G__20261__2 \x3d (function (coll,n){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._nth[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4423__auto__.call(null,coll,n));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._nth[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4420__auto__.call(null,coll,n));\n} else {\nthrow cljs.core.missing_protocol(\x22IIndexed.-nth\x22,coll);\n}\n}\n});\nvar G__20261__3 \x3d (function (coll,n,not_found){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._nth[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4423__auto__.call(null,coll,n,not_found));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._nth[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4420__auto__.call(null,coll,n,not_found));\n} else {\nthrow cljs.core.missing_protocol(\x22IIndexed.-nth\x22,coll);\n}\n}\n});\nG__20261 \x3d function(coll,n,not_found){\nswitch(arguments.length){\ncase 2:\nreturn G__20261__2.call(this,coll,n);\ncase 3:\nreturn G__20261__3.call(this,coll,n,not_found);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20261.cljs$core$IFn$_invoke$arity$2 \x3d G__20261__2;\nG__20261.cljs$core$IFn$_invoke$arity$3 \x3d G__20261__3;\nreturn G__20261;\n})()\n;\n/**\n * Returns the value at the index n in the collection coll.\n *   Returns not-found if index n is out of bounds and not-found is supplied.\n */\ncljs.core._nth \x3d (function cljs$core$_nth(var_args){\nvar G__18364 \x3d arguments.length;\nswitch (G__18364) {\ncase 2:\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,n){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IIndexed$_nth$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$IIndexed$_nth$arity$2(coll,n);\n} else {\nreturn cljs$core$IIndexed$_nth$dyn_20258(coll,n);\n}\n}));\n\n(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,n,not_found){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IIndexed$_nth$arity$3 \x3d\x3d null)))))){\nreturn coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);\n} else {\nreturn cljs$core$IIndexed$_nth$dyn_20258(coll,n,not_found);\n}\n}));\n\n(cljs.core._nth.cljs$lang$maxFixedArity \x3d 3);\n\n\n\n/**\n * Marker protocol indicating an array sequence.\n * @interface\n */\ncljs.core.ASeq \x3d function(){};\n\n\n/**\n * Protocol for collections to provide access to their items as sequences.\n * @interface\n */\ncljs.core.ISeq \x3d function(){};\n\nvar cljs$core$ISeq$_first$dyn_20278 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._first[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._first[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ISeq.-first\x22,coll);\n}\n}\n});\n/**\n * Returns the first item in the collection coll. Used by cljs.core/first.\n */\ncljs.core._first \x3d (function cljs$core$_first(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISeq$_first$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISeq$_first$arity$1(coll);\n} else {\nreturn cljs$core$ISeq$_first$dyn_20278(coll);\n}\n});\n\nvar cljs$core$ISeq$_rest$dyn_20285 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._rest[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._rest[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ISeq.-rest\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll without the first item. It should\n *   always return a seq, e.g.\n *   (rest []) \x3d\x3e ()\n *   (rest nil) \x3d\x3e ()\n */\ncljs.core._rest \x3d (function cljs$core$_rest(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISeq$_rest$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISeq$_rest$arity$1(coll);\n} else {\nreturn cljs$core$ISeq$_rest$dyn_20285(coll);\n}\n});\n\n\n/**\n * Protocol for accessing the next items of a collection.\n * @interface\n */\ncljs.core.INext \x3d function(){};\n\nvar cljs$core$INext$_next$dyn_20290 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._next[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._next[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22INext.-next\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll without the first item. In contrast to\n *   rest, it should return nil if there are no more items, e.g.\n *   (next []) \x3d\x3e nil\n *   (next nil) \x3d\x3e nil\n */\ncljs.core._next \x3d (function cljs$core$_next(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$INext$_next$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$INext$_next$arity$1(coll);\n} else {\nreturn cljs$core$INext$_next$dyn_20290(coll);\n}\n});\n\n\n/**\n * Protocol for looking up a value in a data structure.\n * @interface\n */\ncljs.core.ILookup \x3d function(){};\n\nvar cljs$core$ILookup$_lookup$dyn_20291 \x3d (function() {\nvar G__20292 \x3d null;\nvar G__20292__2 \x3d (function (o,k){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._lookup[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4423__auto__.call(null,o,k));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._lookup[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4420__auto__.call(null,o,k));\n} else {\nthrow cljs.core.missing_protocol(\x22ILookup.-lookup\x22,o);\n}\n}\n});\nvar G__20292__3 \x3d (function (o,k,not_found){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._lookup[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4423__auto__.call(null,o,k,not_found));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._lookup[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4420__auto__.call(null,o,k,not_found));\n} else {\nthrow cljs.core.missing_protocol(\x22ILookup.-lookup\x22,o);\n}\n}\n});\nG__20292 \x3d function(o,k,not_found){\nswitch(arguments.length){\ncase 2:\nreturn G__20292__2.call(this,o,k);\ncase 3:\nreturn G__20292__3.call(this,o,k,not_found);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20292.cljs$core$IFn$_invoke$arity$2 \x3d G__20292__2;\nG__20292.cljs$core$IFn$_invoke$arity$3 \x3d G__20292__3;\nreturn G__20292;\n})()\n;\n/**\n * Use k to look up a value in o. If not-found is supplied and k is not\n *   a valid value that can be used for look up, not-found is returned.\n */\ncljs.core._lookup \x3d (function cljs$core$_lookup(var_args){\nvar G__18366 \x3d arguments.length;\nswitch (G__18366) {\ncase 2:\nreturn cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 \x3d (function (o,k){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ILookup$_lookup$arity$2 \x3d\x3d null)))))){\nreturn o.cljs$core$ILookup$_lookup$arity$2(o,k);\n} else {\nreturn cljs$core$ILookup$_lookup$dyn_20291(o,k);\n}\n}));\n\n(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 \x3d (function (o,k,not_found){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ILookup$_lookup$arity$3 \x3d\x3d null)))))){\nreturn o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);\n} else {\nreturn cljs$core$ILookup$_lookup$dyn_20291(o,k,not_found);\n}\n}));\n\n(cljs.core._lookup.cljs$lang$maxFixedArity \x3d 3);\n\n\n\n/**\n * Protocol for adding associativity to collections.\n * @interface\n */\ncljs.core.IAssociative \x3d function(){};\n\nvar cljs$core$IAssociative$_contains_key_QMARK_$dyn_20294 \x3d (function (coll,k){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._contains_key_QMARK_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4423__auto__.call(null,coll,k));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._contains_key_QMARK_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4420__auto__.call(null,coll,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IAssociative.-contains-key?\x22,coll);\n}\n}\n});\n/**\n * Returns true if k is a key in coll.\n */\ncljs.core._contains_key_QMARK_ \x3d (function cljs$core$_contains_key_QMARK_(coll,k){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);\n} else {\nreturn cljs$core$IAssociative$_contains_key_QMARK_$dyn_20294(coll,k);\n}\n});\n\nvar cljs$core$IAssociative$_assoc$dyn_20295 \x3d (function (coll,k,v){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._assoc[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4423__auto__.call(null,coll,k,v));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._assoc[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4420__auto__.call(null,coll,k,v));\n} else {\nthrow cljs.core.missing_protocol(\x22IAssociative.-assoc\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll with a mapping from key k to\n *   value v added to it.\n */\ncljs.core._assoc \x3d (function cljs$core$_assoc(coll,k,v){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IAssociative$_assoc$arity$3 \x3d\x3d null)))))){\nreturn coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);\n} else {\nreturn cljs$core$IAssociative$_assoc$dyn_20295(coll,k,v);\n}\n});\n\n\n/**\n * Protocol for implementing entry finding in collections.\n * @interface\n */\ncljs.core.IFind \x3d function(){};\n\nvar cljs$core$IFind$_find$dyn_20296 \x3d (function (coll,k){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._find[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4423__auto__.call(null,coll,k));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._find[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4420__auto__.call(null,coll,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IFind.-find\x22,coll);\n}\n}\n});\n/**\n * Returns the map entry for key, or nil if key not present.\n */\ncljs.core._find \x3d (function cljs$core$_find(coll,k){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IFind$_find$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$IFind$_find$arity$2(coll,k);\n} else {\nreturn cljs$core$IFind$_find$dyn_20296(coll,k);\n}\n});\n\n\n/**\n * Protocol for adding mapping functionality to collections.\n * @interface\n */\ncljs.core.IMap \x3d function(){};\n\nvar cljs$core$IMap$_dissoc$dyn_20297 \x3d (function (coll,k){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._dissoc[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4423__auto__.call(null,coll,k));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._dissoc[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4420__auto__.call(null,coll,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IMap.-dissoc\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll without the mapping for key k.\n */\ncljs.core._dissoc \x3d (function cljs$core$_dissoc(coll,k){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IMap$_dissoc$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$IMap$_dissoc$arity$2(coll,k);\n} else {\nreturn cljs$core$IMap$_dissoc$dyn_20297(coll,k);\n}\n});\n\n\n/**\n * Protocol for examining a map entry.\n * @interface\n */\ncljs.core.IMapEntry \x3d function(){};\n\nvar cljs$core$IMapEntry$_key$dyn_20298 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._key[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._key[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IMapEntry.-key\x22,coll);\n}\n}\n});\n/**\n * Returns the key of the map entry.\n */\ncljs.core._key \x3d (function cljs$core$_key(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IMapEntry$_key$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IMapEntry$_key$arity$1(coll);\n} else {\nreturn cljs$core$IMapEntry$_key$dyn_20298(coll);\n}\n});\n\nvar cljs$core$IMapEntry$_val$dyn_20299 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._val[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._val[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IMapEntry.-val\x22,coll);\n}\n}\n});\n/**\n * Returns the value of the map entry.\n */\ncljs.core._val \x3d (function cljs$core$_val(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IMapEntry$_val$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IMapEntry$_val$arity$1(coll);\n} else {\nreturn cljs$core$IMapEntry$_val$dyn_20299(coll);\n}\n});\n\n\n/**\n * Protocol for adding set functionality to a collection.\n * @interface\n */\ncljs.core.ISet \x3d function(){};\n\nvar cljs$core$ISet$_disjoin$dyn_20300 \x3d (function (coll,v){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._disjoin[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4423__auto__.call(null,coll,v));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._disjoin[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4420__auto__.call(null,coll,v));\n} else {\nthrow cljs.core.missing_protocol(\x22ISet.-disjoin\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll that does not contain v.\n */\ncljs.core._disjoin \x3d (function cljs$core$_disjoin(coll,v){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISet$_disjoin$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISet$_disjoin$arity$2(coll,v);\n} else {\nreturn cljs$core$ISet$_disjoin$dyn_20300(coll,v);\n}\n});\n\n\n/**\n * Protocol for collections to provide access to their items as stacks. The top\n *   of the stack should be accessed in the most efficient way for the different\n *   data structures.\n * @interface\n */\ncljs.core.IStack \x3d function(){};\n\nvar cljs$core$IStack$_peek$dyn_20301 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._peek[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._peek[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IStack.-peek\x22,coll);\n}\n}\n});\n/**\n * Returns the item from the top of the stack. Is used by cljs.core/peek.\n */\ncljs.core._peek \x3d (function cljs$core$_peek(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IStack$_peek$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IStack$_peek$arity$1(coll);\n} else {\nreturn cljs$core$IStack$_peek$dyn_20301(coll);\n}\n});\n\nvar cljs$core$IStack$_pop$dyn_20302 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._pop[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._pop[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IStack.-pop\x22,coll);\n}\n}\n});\n/**\n * Returns a new stack without the item on top of the stack. Is used\n *   by cljs.core/pop.\n */\ncljs.core._pop \x3d (function cljs$core$_pop(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IStack$_pop$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IStack$_pop$arity$1(coll);\n} else {\nreturn cljs$core$IStack$_pop$dyn_20302(coll);\n}\n});\n\n\n/**\n * Protocol for adding vector functionality to collections.\n * @interface\n */\ncljs.core.IVector \x3d function(){};\n\nvar cljs$core$IVector$_assoc_n$dyn_20303 \x3d (function (coll,n,val){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._assoc_n[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4423__auto__.call(null,coll,n,val));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._assoc_n[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4420__auto__.call(null,coll,n,val));\n} else {\nthrow cljs.core.missing_protocol(\x22IVector.-assoc-n\x22,coll);\n}\n}\n});\n/**\n * Returns a new vector with value val added at position n.\n */\ncljs.core._assoc_n \x3d (function cljs$core$_assoc_n(coll,n,val){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IVector$_assoc_n$arity$3 \x3d\x3d null)))))){\nreturn coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);\n} else {\nreturn cljs$core$IVector$_assoc_n$dyn_20303(coll,n,val);\n}\n});\n\n\n/**\n * Protocol for adding dereference functionality to a reference.\n * @interface\n */\ncljs.core.IDeref \x3d function(){};\n\nvar cljs$core$IDeref$_deref$dyn_20304 \x3d (function (o){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._deref[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4423__auto__.call(null,o));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._deref[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4420__auto__.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IDeref.-deref\x22,o);\n}\n}\n});\n/**\n * Returns the value of the reference o.\n */\ncljs.core._deref \x3d (function cljs$core$_deref(o){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IDeref$_deref$arity$1 \x3d\x3d null)))))){\nreturn o.cljs$core$IDeref$_deref$arity$1(o);\n} else {\nreturn cljs$core$IDeref$_deref$dyn_20304(o);\n}\n});\n\n\n/**\n * @interface\n */\ncljs.core.IDerefWithTimeout \x3d function(){};\n\nvar cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_20305 \x3d (function (o,msec,timeout_val){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._deref_with_timeout[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4423__auto__.call(null,o,msec,timeout_val));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._deref_with_timeout[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4420__auto__.call(null,o,msec,timeout_val));\n} else {\nthrow cljs.core.missing_protocol(\x22IDerefWithTimeout.-deref-with-timeout\x22,o);\n}\n}\n});\ncljs.core._deref_with_timeout \x3d (function cljs$core$_deref_with_timeout(o,msec,timeout_val){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 \x3d\x3d null)))))){\nreturn o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);\n} else {\nreturn cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_20305(o,msec,timeout_val);\n}\n});\n\n\n/**\n * Protocol for accessing the metadata of an object.\n * @interface\n */\ncljs.core.IMeta \x3d function(){};\n\nvar cljs$core$IMeta$_meta$dyn_20306 \x3d (function (o){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._meta[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4423__auto__.call(null,o));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._meta[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4420__auto__.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IMeta.-meta\x22,o);\n}\n}\n});\n/**\n * Returns the metadata of object o.\n */\ncljs.core._meta \x3d (function cljs$core$_meta(o){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IMeta$_meta$arity$1 \x3d\x3d null)))))){\nreturn o.cljs$core$IMeta$_meta$arity$1(o);\n} else {\nreturn cljs$core$IMeta$_meta$dyn_20306(o);\n}\n});\n\n\n/**\n * Protocol for adding metadata to an object.\n * @interface\n */\ncljs.core.IWithMeta \x3d function(){};\n\nvar cljs$core$IWithMeta$_with_meta$dyn_20307 \x3d (function (o,meta){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._with_meta[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4423__auto__.call(null,o,meta));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._with_meta[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4420__auto__.call(null,o,meta));\n} else {\nthrow cljs.core.missing_protocol(\x22IWithMeta.-with-meta\x22,o);\n}\n}\n});\n/**\n * Returns a new object with value of o and metadata meta added to it.\n */\ncljs.core._with_meta \x3d (function cljs$core$_with_meta(o,meta){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 \x3d\x3d null)))))){\nreturn o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);\n} else {\nreturn cljs$core$IWithMeta$_with_meta$dyn_20307(o,meta);\n}\n});\n\n\n/**\n * Protocol for seq types that can reduce themselves.\n *   Called by cljs.core/reduce.\n * @interface\n */\ncljs.core.IReduce \x3d function(){};\n\nvar cljs$core$IReduce$_reduce$dyn_20308 \x3d (function() {\nvar G__20309 \x3d null;\nvar G__20309__2 \x3d (function (coll,f){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._reduce[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4423__auto__.call(null,coll,f));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._reduce[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4420__auto__.call(null,coll,f));\n} else {\nthrow cljs.core.missing_protocol(\x22IReduce.-reduce\x22,coll);\n}\n}\n});\nvar G__20309__3 \x3d (function (coll,f,start){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._reduce[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4423__auto__.call(null,coll,f,start));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._reduce[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4420__auto__.call(null,coll,f,start));\n} else {\nthrow cljs.core.missing_protocol(\x22IReduce.-reduce\x22,coll);\n}\n}\n});\nG__20309 \x3d function(coll,f,start){\nswitch(arguments.length){\ncase 2:\nreturn G__20309__2.call(this,coll,f);\ncase 3:\nreturn G__20309__3.call(this,coll,f,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20309.cljs$core$IFn$_invoke$arity$2 \x3d G__20309__2;\nG__20309.cljs$core$IFn$_invoke$arity$3 \x3d G__20309__3;\nreturn G__20309;\n})()\n;\n/**\n * f should be a function of 2 arguments. If start is not supplied,\n *   returns the result of applying f to the first 2 items in coll, then\n *   applying f to that result and the 3rd item, etc.\n */\ncljs.core._reduce \x3d (function cljs$core$_reduce(var_args){\nvar G__18368 \x3d arguments.length;\nswitch (G__18368) {\ncase 2:\nreturn cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,f){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IReduce$_reduce$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$IReduce$_reduce$arity$2(coll,f);\n} else {\nreturn cljs$core$IReduce$_reduce$dyn_20308(coll,f);\n}\n}));\n\n(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,f,start){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IReduce$_reduce$arity$3 \x3d\x3d null)))))){\nreturn coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);\n} else {\nreturn cljs$core$IReduce$_reduce$dyn_20308(coll,f,start);\n}\n}));\n\n(cljs.core._reduce.cljs$lang$maxFixedArity \x3d 3);\n\n\n\n/**\n * Protocol for associative types that can reduce themselves\n *   via a function of key and val. Called by cljs.core/reduce-kv.\n * @interface\n */\ncljs.core.IKVReduce \x3d function(){};\n\nvar cljs$core$IKVReduce$_kv_reduce$dyn_20311 \x3d (function (coll,f,init){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._kv_reduce[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4423__auto__.call(null,coll,f,init));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._kv_reduce[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4420__auto__.call(null,coll,f,init));\n} else {\nthrow cljs.core.missing_protocol(\x22IKVReduce.-kv-reduce\x22,coll);\n}\n}\n});\n/**\n * Reduces an associative collection and returns the result. f should be\n *   a function that takes three arguments.\n */\ncljs.core._kv_reduce \x3d (function cljs$core$_kv_reduce(coll,f,init){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 \x3d\x3d null)))))){\nreturn coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);\n} else {\nreturn cljs$core$IKVReduce$_kv_reduce$dyn_20311(coll,f,init);\n}\n});\n\n\n/**\n * Protocol for adding value comparison functionality to a type.\n * @interface\n */\ncljs.core.IEquiv \x3d function(){};\n\nvar cljs$core$IEquiv$_equiv$dyn_20312 \x3d (function (o,other){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._equiv[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4423__auto__.call(null,o,other));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._equiv[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4420__auto__.call(null,o,other));\n} else {\nthrow cljs.core.missing_protocol(\x22IEquiv.-equiv\x22,o);\n}\n}\n});\n/**\n * Returns true if o and other are equal, false otherwise.\n */\ncljs.core._equiv \x3d (function cljs$core$_equiv(o,other){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IEquiv$_equiv$arity$2 \x3d\x3d null)))))){\nreturn o.cljs$core$IEquiv$_equiv$arity$2(o,other);\n} else {\nreturn cljs$core$IEquiv$_equiv$dyn_20312(o,other);\n}\n});\n\n\n/**\n * Protocol for adding hashing functionality to a type.\n * @interface\n */\ncljs.core.IHash \x3d function(){};\n\nvar cljs$core$IHash$_hash$dyn_20313 \x3d (function (o){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._hash[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4423__auto__.call(null,o));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._hash[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4420__auto__.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IHash.-hash\x22,o);\n}\n}\n});\n/**\n * Returns the hash code of o.\n */\ncljs.core._hash \x3d (function cljs$core$_hash(o){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IHash$_hash$arity$1 \x3d\x3d null)))))){\nreturn o.cljs$core$IHash$_hash$arity$1(o);\n} else {\nreturn cljs$core$IHash$_hash$dyn_20313(o);\n}\n});\n\n\n/**\n * Protocol for adding the ability to a type to be transformed into a sequence.\n * @interface\n */\ncljs.core.ISeqable \x3d function(){};\n\nvar cljs$core$ISeqable$_seq$dyn_20314 \x3d (function (o){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._seq[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4423__auto__.call(null,o));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._seq[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4420__auto__.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22ISeqable.-seq\x22,o);\n}\n}\n});\n/**\n * Returns a seq of o, or nil if o is empty.\n */\ncljs.core._seq \x3d (function cljs$core$_seq(o){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ISeqable$_seq$arity$1 \x3d\x3d null)))))){\nreturn o.cljs$core$ISeqable$_seq$arity$1(o);\n} else {\nreturn cljs$core$ISeqable$_seq$dyn_20314(o);\n}\n});\n\n\n/**\n * Marker interface indicating a persistent collection of sequential items\n * @interface\n */\ncljs.core.ISequential \x3d function(){};\n\n\n/**\n * Marker interface indicating a persistent list\n * @interface\n */\ncljs.core.IList \x3d function(){};\n\n\n/**\n * Marker interface indicating a record object\n * @interface\n */\ncljs.core.IRecord \x3d function(){};\n\n\n/**\n * Protocol for reversing a seq.\n * @interface\n */\ncljs.core.IReversible \x3d function(){};\n\nvar cljs$core$IReversible$_rseq$dyn_20315 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._rseq[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._rseq[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IReversible.-rseq\x22,coll);\n}\n}\n});\n/**\n * Returns a seq of the items in coll in reversed order.\n */\ncljs.core._rseq \x3d (function cljs$core$_rseq(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IReversible$_rseq$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IReversible$_rseq$arity$1(coll);\n} else {\nreturn cljs$core$IReversible$_rseq$dyn_20315(coll);\n}\n});\n\n\n/**\n * Protocol for a collection which can represent their items\n *   in a sorted manner. \n * @interface\n */\ncljs.core.ISorted \x3d function(){};\n\nvar cljs$core$ISorted$_sorted_seq$dyn_20316 \x3d (function (coll,ascending_QMARK_){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._sorted_seq[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4423__auto__.call(null,coll,ascending_QMARK_));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._sorted_seq[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4420__auto__.call(null,coll,ascending_QMARK_));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-sorted-seq\x22,coll);\n}\n}\n});\n/**\n * Returns a sorted seq from coll in either ascending or descending order.\n */\ncljs.core._sorted_seq \x3d (function cljs$core$_sorted_seq(coll,ascending_QMARK_){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);\n} else {\nreturn cljs$core$ISorted$_sorted_seq$dyn_20316(coll,ascending_QMARK_);\n}\n});\n\nvar cljs$core$ISorted$_sorted_seq_from$dyn_20317 \x3d (function (coll,k,ascending_QMARK_){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._sorted_seq_from[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4423__auto__.call(null,coll,k,ascending_QMARK_));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._sorted_seq_from[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4420__auto__.call(null,coll,k,ascending_QMARK_));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-sorted-seq-from\x22,coll);\n}\n}\n});\n/**\n * Returns a sorted seq from coll in either ascending or descending order.\n *   If ascending is true, the result should contain all items which are \x3e or \x3e\x3d\n *   than k. If ascending is false, the result should contain all items which\n *   are \x3c or \x3c\x3d than k, e.g.\n *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) \x3d\x3e (3 4 5)\n *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) \x3d\x3e (3 2 1)\n */\ncljs.core._sorted_seq_from \x3d (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);\n} else {\nreturn cljs$core$ISorted$_sorted_seq_from$dyn_20317(coll,k,ascending_QMARK_);\n}\n});\n\nvar cljs$core$ISorted$_entry_key$dyn_20318 \x3d (function (coll,entry){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._entry_key[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4423__auto__.call(null,coll,entry));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._entry_key[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4420__auto__.call(null,coll,entry));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-entry-key\x22,coll);\n}\n}\n});\n/**\n * Returns the key for entry.\n */\ncljs.core._entry_key \x3d (function cljs$core$_entry_key(coll,entry){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISorted$_entry_key$arity$2 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);\n} else {\nreturn cljs$core$ISorted$_entry_key$dyn_20318(coll,entry);\n}\n});\n\nvar cljs$core$ISorted$_comparator$dyn_20319 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._comparator[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._comparator[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-comparator\x22,coll);\n}\n}\n});\n/**\n * Returns the comparator for coll.\n */\ncljs.core._comparator \x3d (function cljs$core$_comparator(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$ISorted$_comparator$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$ISorted$_comparator$arity$1(coll);\n} else {\nreturn cljs$core$ISorted$_comparator$dyn_20319(coll);\n}\n});\n\n\n/**\n * Protocol for writing. Currently only implemented by StringBufferWriter.\n * @interface\n */\ncljs.core.IWriter \x3d function(){};\n\nvar cljs$core$IWriter$_write$dyn_20320 \x3d (function (writer,s){\nvar x__4422__auto__ \x3d (((writer \x3d\x3d null))?null:writer);\nvar m__4423__auto__ \x3d (cljs.core._write[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4423__auto__.call(null,writer,s));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._write[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4420__auto__.call(null,writer,s));\n} else {\nthrow cljs.core.missing_protocol(\x22IWriter.-write\x22,writer);\n}\n}\n});\n/**\n * Writes s with writer and returns the result.\n */\ncljs.core._write \x3d (function cljs$core$_write(writer,s){\nif((((!((writer \x3d\x3d null)))) \x26\x26 ((!((writer.cljs$core$IWriter$_write$arity$2 \x3d\x3d null)))))){\nreturn writer.cljs$core$IWriter$_write$arity$2(writer,s);\n} else {\nreturn cljs$core$IWriter$_write$dyn_20320(writer,s);\n}\n});\n\nvar cljs$core$IWriter$_flush$dyn_20321 \x3d (function (writer){\nvar x__4422__auto__ \x3d (((writer \x3d\x3d null))?null:writer);\nvar m__4423__auto__ \x3d (cljs.core._flush[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4423__auto__.call(null,writer));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._flush[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4420__auto__.call(null,writer));\n} else {\nthrow cljs.core.missing_protocol(\x22IWriter.-flush\x22,writer);\n}\n}\n});\n/**\n * Flush writer.\n */\ncljs.core._flush \x3d (function cljs$core$_flush(writer){\nif((((!((writer \x3d\x3d null)))) \x26\x26 ((!((writer.cljs$core$IWriter$_flush$arity$1 \x3d\x3d null)))))){\nreturn writer.cljs$core$IWriter$_flush$arity$1(writer);\n} else {\nreturn cljs$core$IWriter$_flush$dyn_20321(writer);\n}\n});\n\n\n/**\n * The old IPrintable protocol\x27s implementation consisted of building a giant\n * list of strings to concatenate.  This involved lots of concat calls,\n * intermediate vectors, and lazy-seqs, and was very slow in some older JS\n * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n * be implemented efficiently in terms of e.g. a StringBuffer append.\n * @interface\n */\ncljs.core.IPrintWithWriter \x3d function(){};\n\nvar cljs$core$IPrintWithWriter$_pr_writer$dyn_20322 \x3d (function (o,writer,opts){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._pr_writer[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4423__auto__.call(null,o,writer,opts));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._pr_writer[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4420__auto__.call(null,o,writer,opts));\n} else {\nthrow cljs.core.missing_protocol(\x22IPrintWithWriter.-pr-writer\x22,o);\n}\n}\n});\ncljs.core._pr_writer \x3d (function cljs$core$_pr_writer(o,writer,opts){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 \x3d\x3d null)))))){\nreturn o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);\n} else {\nreturn cljs$core$IPrintWithWriter$_pr_writer$dyn_20322(o,writer,opts);\n}\n});\n\n\n/**\n * Protocol for types which can have a deferred realization. Currently only\n *   implemented by Delay and LazySeq.\n * @interface\n */\ncljs.core.IPending \x3d function(){};\n\nvar cljs$core$IPending$_realized_QMARK_$dyn_20323 \x3d (function (x){\nvar x__4422__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4423__auto__ \x3d (cljs.core._realized_QMARK_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4423__auto__.call(null,x));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._realized_QMARK_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4420__auto__.call(null,x));\n} else {\nthrow cljs.core.missing_protocol(\x22IPending.-realized?\x22,x);\n}\n}\n});\n/**\n * Returns true if a value for x has been produced, false otherwise.\n */\ncljs.core._realized_QMARK_ \x3d (function cljs$core$_realized_QMARK_(x){\nif((((!((x \x3d\x3d null)))) \x26\x26 ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 \x3d\x3d null)))))){\nreturn x.cljs$core$IPending$_realized_QMARK_$arity$1(x);\n} else {\nreturn cljs$core$IPending$_realized_QMARK_$dyn_20323(x);\n}\n});\n\n\n/**\n * Protocol for types that can be watched. Currently only implemented by Atom.\n * @interface\n */\ncljs.core.IWatchable \x3d function(){};\n\nvar cljs$core$IWatchable$_notify_watches$dyn_20324 \x3d (function (this$,oldval,newval){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._notify_watches[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4423__auto__.call(null,this$,oldval,newval));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._notify_watches[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4420__auto__.call(null,this$,oldval,newval));\n} else {\nthrow cljs.core.missing_protocol(\x22IWatchable.-notify-watches\x22,this$);\n}\n}\n});\n/**\n * Calls all watchers with this, oldval and newval.\n */\ncljs.core._notify_watches \x3d (function cljs$core$_notify_watches(this$,oldval,newval){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 \x3d\x3d null)))))){\nreturn this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);\n} else {\nreturn cljs$core$IWatchable$_notify_watches$dyn_20324(this$,oldval,newval);\n}\n});\n\nvar cljs$core$IWatchable$_add_watch$dyn_20325 \x3d (function (this$,key,f){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._add_watch[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4423__auto__.call(null,this$,key,f));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._add_watch[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4420__auto__.call(null,this$,key,f));\n} else {\nthrow cljs.core.missing_protocol(\x22IWatchable.-add-watch\x22,this$);\n}\n}\n});\n/**\n * Adds a watcher function f to this. Keys must be unique per reference,\n *   and can be used to remove the watch with -remove-watch.\n */\ncljs.core._add_watch \x3d (function cljs$core$_add_watch(this$,key,f){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 \x3d\x3d null)))))){\nreturn this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);\n} else {\nreturn cljs$core$IWatchable$_add_watch$dyn_20325(this$,key,f);\n}\n});\n\nvar cljs$core$IWatchable$_remove_watch$dyn_20326 \x3d (function (this$,key){\nvar x__4422__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4423__auto__ \x3d (cljs.core._remove_watch[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4423__auto__.call(null,this$,key));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._remove_watch[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4420__auto__.call(null,this$,key));\n} else {\nthrow cljs.core.missing_protocol(\x22IWatchable.-remove-watch\x22,this$);\n}\n}\n});\n/**\n * Removes watcher that corresponds to key from this.\n */\ncljs.core._remove_watch \x3d (function cljs$core$_remove_watch(this$,key){\nif((((!((this$ \x3d\x3d null)))) \x26\x26 ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 \x3d\x3d null)))))){\nreturn this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);\n} else {\nreturn cljs$core$IWatchable$_remove_watch$dyn_20326(this$,key);\n}\n});\n\n\n/**\n * Protocol for collections which can transformed to transients.\n * @interface\n */\ncljs.core.IEditableCollection \x3d function(){};\n\nvar cljs$core$IEditableCollection$_as_transient$dyn_20327 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._as_transient[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._as_transient[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IEditableCollection.-as-transient\x22,coll);\n}\n}\n});\n/**\n * Returns a new, transient version of the collection, in constant time.\n */\ncljs.core._as_transient \x3d (function cljs$core$_as_transient(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);\n} else {\nreturn cljs$core$IEditableCollection$_as_transient$dyn_20327(coll);\n}\n});\n\n\n/**\n * Protocol for adding basic functionality to transient collections.\n * @interface\n */\ncljs.core.ITransientCollection \x3d function(){};\n\nvar cljs$core$ITransientCollection$_conj_BANG_$dyn_20328 \x3d (function (tcoll,val){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._conj_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4423__auto__.call(null,tcoll,val));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._conj_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4420__auto__.call(null,tcoll,val));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientCollection.-conj!\x22,tcoll);\n}\n}\n});\n/**\n * Adds value val to tcoll and returns tcoll.\n */\ncljs.core._conj_BANG_ \x3d (function cljs$core$_conj_BANG_(tcoll,val){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);\n} else {\nreturn cljs$core$ITransientCollection$_conj_BANG_$dyn_20328(tcoll,val);\n}\n});\n\nvar cljs$core$ITransientCollection$_persistent_BANG_$dyn_20329 \x3d (function (tcoll){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._persistent_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4423__auto__.call(null,tcoll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._persistent_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4420__auto__.call(null,tcoll));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientCollection.-persistent!\x22,tcoll);\n}\n}\n});\n/**\n * Creates a persistent data structure from tcoll and returns it.\n */\ncljs.core._persistent_BANG_ \x3d (function cljs$core$_persistent_BANG_(tcoll){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);\n} else {\nreturn cljs$core$ITransientCollection$_persistent_BANG_$dyn_20329(tcoll);\n}\n});\n\n\n/**\n * Protocol for adding associativity to transient collections.\n * @interface\n */\ncljs.core.ITransientAssociative \x3d function(){};\n\nvar cljs$core$ITransientAssociative$_assoc_BANG_$dyn_20330 \x3d (function (tcoll,key,val){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._assoc_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4423__auto__.call(null,tcoll,key,val));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._assoc_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4420__auto__.call(null,tcoll,key,val));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientAssociative.-assoc!\x22,tcoll);\n}\n}\n});\n/**\n * Returns a new transient collection of tcoll with a mapping from key to\n *   val added to it.\n */\ncljs.core._assoc_BANG_ \x3d (function cljs$core$_assoc_BANG_(tcoll,key,val){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);\n} else {\nreturn cljs$core$ITransientAssociative$_assoc_BANG_$dyn_20330(tcoll,key,val);\n}\n});\n\n\n/**\n * Protocol for adding mapping functionality to transient collections.\n * @interface\n */\ncljs.core.ITransientMap \x3d function(){};\n\nvar cljs$core$ITransientMap$_dissoc_BANG_$dyn_20331 \x3d (function (tcoll,key){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._dissoc_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4423__auto__.call(null,tcoll,key));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._dissoc_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4420__auto__.call(null,tcoll,key));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientMap.-dissoc!\x22,tcoll);\n}\n}\n});\n/**\n * Returns a new transient collection of tcoll without the mapping for key.\n */\ncljs.core._dissoc_BANG_ \x3d (function cljs$core$_dissoc_BANG_(tcoll,key){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);\n} else {\nreturn cljs$core$ITransientMap$_dissoc_BANG_$dyn_20331(tcoll,key);\n}\n});\n\n\n/**\n * Protocol for adding vector functionality to transient collections.\n * @interface\n */\ncljs.core.ITransientVector \x3d function(){};\n\nvar cljs$core$ITransientVector$_assoc_n_BANG_$dyn_20332 \x3d (function (tcoll,n,val){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._assoc_n_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4423__auto__.call(null,tcoll,n,val));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._assoc_n_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4420__auto__.call(null,tcoll,n,val));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientVector.-assoc-n!\x22,tcoll);\n}\n}\n});\n/**\n * Returns tcoll with value val added at position n.\n */\ncljs.core._assoc_n_BANG_ \x3d (function cljs$core$_assoc_n_BANG_(tcoll,n,val){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);\n} else {\nreturn cljs$core$ITransientVector$_assoc_n_BANG_$dyn_20332(tcoll,n,val);\n}\n});\n\nvar cljs$core$ITransientVector$_pop_BANG_$dyn_20333 \x3d (function (tcoll){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._pop_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4423__auto__.call(null,tcoll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._pop_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4420__auto__.call(null,tcoll));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientVector.-pop!\x22,tcoll);\n}\n}\n});\n/**\n * Returns tcoll with the last item removed from it.\n */\ncljs.core._pop_BANG_ \x3d (function cljs$core$_pop_BANG_(tcoll){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);\n} else {\nreturn cljs$core$ITransientVector$_pop_BANG_$dyn_20333(tcoll);\n}\n});\n\n\n/**\n * Protocol for adding set functionality to a transient collection.\n * @interface\n */\ncljs.core.ITransientSet \x3d function(){};\n\nvar cljs$core$ITransientSet$_disjoin_BANG_$dyn_20334 \x3d (function (tcoll,v){\nvar x__4422__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4423__auto__ \x3d (cljs.core._disjoin_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4423__auto__.call(null,tcoll,v));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._disjoin_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4420__auto__.call(null,tcoll,v));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientSet.-disjoin!\x22,tcoll);\n}\n}\n});\n/**\n * Returns tcoll without v.\n */\ncljs.core._disjoin_BANG_ \x3d (function cljs$core$_disjoin_BANG_(tcoll,v){\nif((((!((tcoll \x3d\x3d null)))) \x26\x26 ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 \x3d\x3d null)))))){\nreturn tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);\n} else {\nreturn cljs$core$ITransientSet$_disjoin_BANG_$dyn_20334(tcoll,v);\n}\n});\n\n\n/**\n * Protocol for values that can be compared.\n * @interface\n */\ncljs.core.IComparable \x3d function(){};\n\nvar cljs$core$IComparable$_compare$dyn_20335 \x3d (function (x,y){\nvar x__4422__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4423__auto__ \x3d (cljs.core._compare[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4423__auto__.call(null,x,y));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._compare[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4420__auto__.call(null,x,y));\n} else {\nthrow cljs.core.missing_protocol(\x22IComparable.-compare\x22,x);\n}\n}\n});\n/**\n * Returns a negative number, zero, or a positive number when x is logically\n *   \x27less than\x27, \x27equal to\x27, or \x27greater than\x27 y.\n */\ncljs.core._compare \x3d (function cljs$core$_compare(x,y){\nif((((!((x \x3d\x3d null)))) \x26\x26 ((!((x.cljs$core$IComparable$_compare$arity$2 \x3d\x3d null)))))){\nreturn x.cljs$core$IComparable$_compare$arity$2(x,y);\n} else {\nreturn cljs$core$IComparable$_compare$dyn_20335(x,y);\n}\n});\n\n\n/**\n * Protocol for accessing the items of a chunk.\n * @interface\n */\ncljs.core.IChunk \x3d function(){};\n\nvar cljs$core$IChunk$_drop_first$dyn_20336 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._drop_first[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._drop_first[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunk.-drop-first\x22,coll);\n}\n}\n});\n/**\n * Return a new chunk of coll with the first item removed.\n */\ncljs.core._drop_first \x3d (function cljs$core$_drop_first(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IChunk$_drop_first$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IChunk$_drop_first$arity$1(coll);\n} else {\nreturn cljs$core$IChunk$_drop_first$dyn_20336(coll);\n}\n});\n\n\n/**\n * Protocol for accessing a collection as sequential chunks.\n * @interface\n */\ncljs.core.IChunkedSeq \x3d function(){};\n\nvar cljs$core$IChunkedSeq$_chunked_first$dyn_20337 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._chunked_first[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._chunked_first[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunkedSeq.-chunked-first\x22,coll);\n}\n}\n});\n/**\n * Returns the first chunk in coll.\n */\ncljs.core._chunked_first \x3d (function cljs$core$_chunked_first(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);\n} else {\nreturn cljs$core$IChunkedSeq$_chunked_first$dyn_20337(coll);\n}\n});\n\nvar cljs$core$IChunkedSeq$_chunked_rest$dyn_20338 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._chunked_rest[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._chunked_rest[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunkedSeq.-chunked-rest\x22,coll);\n}\n}\n});\n/**\n * Return a new collection of coll with the first chunk removed.\n */\ncljs.core._chunked_rest \x3d (function cljs$core$_chunked_rest(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);\n} else {\nreturn cljs$core$IChunkedSeq$_chunked_rest$dyn_20338(coll);\n}\n});\n\n\n/**\n * Protocol for accessing the chunks of a collection.\n * @interface\n */\ncljs.core.IChunkedNext \x3d function(){};\n\nvar cljs$core$IChunkedNext$_chunked_next$dyn_20339 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._chunked_next[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._chunked_next[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunkedNext.-chunked-next\x22,coll);\n}\n}\n});\n/**\n * Returns a new collection of coll without the first chunk.\n */\ncljs.core._chunked_next \x3d (function cljs$core$_chunked_next(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);\n} else {\nreturn cljs$core$IChunkedNext$_chunked_next$dyn_20339(coll);\n}\n});\n\n\n/**\n * Protocol for adding a name.\n * @interface\n */\ncljs.core.INamed \x3d function(){};\n\nvar cljs$core$INamed$_name$dyn_20340 \x3d (function (x){\nvar x__4422__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4423__auto__ \x3d (cljs.core._name[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4423__auto__.call(null,x));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._name[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4420__auto__.call(null,x));\n} else {\nthrow cljs.core.missing_protocol(\x22INamed.-name\x22,x);\n}\n}\n});\n/**\n * Returns the name String of x.\n */\ncljs.core._name \x3d (function cljs$core$_name(x){\nif((((!((x \x3d\x3d null)))) \x26\x26 ((!((x.cljs$core$INamed$_name$arity$1 \x3d\x3d null)))))){\nreturn x.cljs$core$INamed$_name$arity$1(x);\n} else {\nreturn cljs$core$INamed$_name$dyn_20340(x);\n}\n});\n\nvar cljs$core$INamed$_namespace$dyn_20343 \x3d (function (x){\nvar x__4422__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4423__auto__ \x3d (cljs.core._namespace[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4423__auto__.call(null,x));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._namespace[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4420__auto__.call(null,x));\n} else {\nthrow cljs.core.missing_protocol(\x22INamed.-namespace\x22,x);\n}\n}\n});\n/**\n * Returns the namespace String of x.\n */\ncljs.core._namespace \x3d (function cljs$core$_namespace(x){\nif((((!((x \x3d\x3d null)))) \x26\x26 ((!((x.cljs$core$INamed$_namespace$arity$1 \x3d\x3d null)))))){\nreturn x.cljs$core$INamed$_namespace$arity$1(x);\n} else {\nreturn cljs$core$INamed$_namespace$dyn_20343(x);\n}\n});\n\n\n/**\n * Marker protocol indicating an atom.\n * @interface\n */\ncljs.core.IAtom \x3d function(){};\n\n\n/**\n * Protocol for adding resetting functionality.\n * @interface\n */\ncljs.core.IReset \x3d function(){};\n\nvar cljs$core$IReset$_reset_BANG_$dyn_20349 \x3d (function (o,new_value){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._reset_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4423__auto__.call(null,o,new_value));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._reset_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4420__auto__.call(null,o,new_value));\n} else {\nthrow cljs.core.missing_protocol(\x22IReset.-reset!\x22,o);\n}\n}\n});\n/**\n * Sets the value of o to new-value.\n */\ncljs.core._reset_BANG_ \x3d (function cljs$core$_reset_BANG_(o,new_value){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 \x3d\x3d null)))))){\nreturn o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);\n} else {\nreturn cljs$core$IReset$_reset_BANG_$dyn_20349(o,new_value);\n}\n});\n\n\n/**\n * Protocol for adding swapping functionality.\n * @interface\n */\ncljs.core.ISwap \x3d function(){};\n\nvar cljs$core$ISwap$_swap_BANG_$dyn_20355 \x3d (function() {\nvar G__20356 \x3d null;\nvar G__20356__2 \x3d (function (o,f){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4423__auto__.call(null,o,f));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4420__auto__.call(null,o,f));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n});\nvar G__20356__3 \x3d (function (o,f,a){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4423__auto__.call(null,o,f,a));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4420__auto__.call(null,o,f,a));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n});\nvar G__20356__4 \x3d (function (o,f,a,b){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4423__auto__.call(null,o,f,a,b));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4420__auto__.call(null,o,f,a,b));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n});\nvar G__20356__5 \x3d (function (o,f,a,b,xs){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4423__auto__.call(null,o,f,a,b,xs));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4420__auto__.call(null,o,f,a,b,xs));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n});\nG__20356 \x3d function(o,f,a,b,xs){\nswitch(arguments.length){\ncase 2:\nreturn G__20356__2.call(this,o,f);\ncase 3:\nreturn G__20356__3.call(this,o,f,a);\ncase 4:\nreturn G__20356__4.call(this,o,f,a,b);\ncase 5:\nreturn G__20356__5.call(this,o,f,a,b,xs);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20356.cljs$core$IFn$_invoke$arity$2 \x3d G__20356__2;\nG__20356.cljs$core$IFn$_invoke$arity$3 \x3d G__20356__3;\nG__20356.cljs$core$IFn$_invoke$arity$4 \x3d G__20356__4;\nG__20356.cljs$core$IFn$_invoke$arity$5 \x3d G__20356__5;\nreturn G__20356;\n})()\n;\n/**\n * Swaps the value of o to be (apply f current-value-of-atom args).\n */\ncljs.core._swap_BANG_ \x3d (function cljs$core$_swap_BANG_(var_args){\nvar G__18370 \x3d arguments.length;\nswitch (G__18370) {\ncase 2:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (o,f){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 \x3d\x3d null)))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);\n} else {\nreturn cljs$core$ISwap$_swap_BANG_$dyn_20355(o,f);\n}\n}));\n\n(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 \x3d (function (o,f,a){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 \x3d\x3d null)))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);\n} else {\nreturn cljs$core$ISwap$_swap_BANG_$dyn_20355(o,f,a);\n}\n}));\n\n(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 \x3d (function (o,f,a,b){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 \x3d\x3d null)))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);\n} else {\nreturn cljs$core$ISwap$_swap_BANG_$dyn_20355(o,f,a,b);\n}\n}));\n\n(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 \x3d (function (o,f,a,b,xs){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 \x3d\x3d null)))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);\n} else {\nreturn cljs$core$ISwap$_swap_BANG_$dyn_20355(o,f,a,b,xs);\n}\n}));\n\n(cljs.core._swap_BANG_.cljs$lang$maxFixedArity \x3d 5);\n\n\n\n/**\n * Protocol for adding volatile functionality.\n * @interface\n */\ncljs.core.IVolatile \x3d function(){};\n\nvar cljs$core$IVolatile$_vreset_BANG_$dyn_20368 \x3d (function (o,new_value){\nvar x__4422__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4423__auto__ \x3d (cljs.core._vreset_BANG_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4423__auto__.call(null,o,new_value));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._vreset_BANG_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4420__auto__.call(null,o,new_value));\n} else {\nthrow cljs.core.missing_protocol(\x22IVolatile.-vreset!\x22,o);\n}\n}\n});\n/**\n * Sets the value of volatile o to new-value without regard for the\n *   current value. Returns new-value.\n */\ncljs.core._vreset_BANG_ \x3d (function cljs$core$_vreset_BANG_(o,new_value){\nif((((!((o \x3d\x3d null)))) \x26\x26 ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 \x3d\x3d null)))))){\nreturn o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);\n} else {\nreturn cljs$core$IVolatile$_vreset_BANG_$dyn_20368(o,new_value);\n}\n});\n\n\n/**\n * Protocol for iterating over a collection.\n * @interface\n */\ncljs.core.IIterable \x3d function(){};\n\nvar cljs$core$IIterable$_iterator$dyn_20372 \x3d (function (coll){\nvar x__4422__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4423__auto__ \x3d (cljs.core._iterator[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4423__auto__.call(null,coll));\n} else {\nvar m__4420__auto__ \x3d (cljs.core._iterator[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4420__auto__.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IIterable.-iterator\x22,coll);\n}\n}\n});\n/**\n * Returns an iterator for coll.\n */\ncljs.core._iterator \x3d (function cljs$core$_iterator(coll){\nif((((!((coll \x3d\x3d null)))) \x26\x26 ((!((coll.cljs$core$IIterable$_iterator$arity$1 \x3d\x3d null)))))){\nreturn coll.cljs$core$IIterable$_iterator$arity$1(coll);\n} else {\nreturn cljs$core$IIterable$_iterator$dyn_20372(coll);\n}\n});\n\n\n/**\n* @constructor\n * @implements {cljs.core.IWriter}\n*/\ncljs.core.StringBufferWriter \x3d (function (sb){\nthis.sb \x3d sb;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 1073741824;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 \x3d (function (_,s){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.sb.append(s);\n}));\n\n(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn null;\n}));\n\n(cljs.core.StringBufferWriter.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22sb\x22,\x22sb\x22,-1249746442,null)], null);\n}));\n\n(cljs.core.StringBufferWriter.cljs$lang$type \x3d true);\n\n(cljs.core.StringBufferWriter.cljs$lang$ctorStr \x3d \x22cljs.core/StringBufferWriter\x22);\n\n(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/StringBufferWriter\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/StringBufferWriter.\n */\ncljs.core.__GT_StringBufferWriter \x3d (function cljs$core$__GT_StringBufferWriter(sb){\nreturn (new cljs.core.StringBufferWriter(sb));\n});\n\n/**\n * Support so that collections can implement toString without\n * loading all the printing machinery.\n */\ncljs.core.pr_str_STAR_ \x3d (function cljs$core$pr_str_STAR_(obj){\nvar sb \x3d (new goog.string.StringBuffer());\nvar writer \x3d (new cljs.core.StringBufferWriter(sb));\nobj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());\n\nwriter.cljs$core$IWriter$_flush$arity$1(null);\n\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);\n});\ncljs.core.int_rotate_left \x3d (function cljs$core$int_rotate_left(x,n){\nreturn ((x \x3c\x3c n) | (x \x3e\x3e\x3e (- n)));\n});\nif((((typeof Math !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof Math.imul !\x3d\x3d \x27undefined\x27)) \x26\x26 ((!((Math.imul((4294967295),(5)) \x3d\x3d\x3d (0))))))){\ncljs.core.imul \x3d (function cljs$core$imul(a,b){\nreturn Math.imul(a,b);\n});\n} else {\ncljs.core.imul \x3d (function cljs$core$imul(a,b){\nvar ah \x3d ((a \x3e\x3e\x3e (16)) \x26 (65535));\nvar al \x3d (a \x26 (65535));\nvar bh \x3d ((b \x3e\x3e\x3e (16)) \x26 (65535));\nvar bl \x3d (b \x26 (65535));\nreturn (((al * bl) + ((((ah * bl) + (al * bh)) \x3c\x3c (16)) \x3e\x3e\x3e (0))) | (0));\n});\n}\ncljs.core.m3_seed \x3d (0);\ncljs.core.m3_C1 \x3d ((3432918353) | (0));\ncljs.core.m3_C2 \x3d ((461845907) | (0));\ncljs.core.m3_mix_K1 \x3d (function cljs$core$m3_mix_K1(k1){\nreturn cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);\n});\ncljs.core.m3_mix_H1 \x3d (function cljs$core$m3_mix_H1(h1,k1){\nreturn ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));\n});\ncljs.core.m3_fmix \x3d (function cljs$core$m3_fmix(h1,len){\nvar h1__$1 \x3d (h1 | (0));\nvar h1__$2 \x3d (h1__$1 ^ len);\nvar h1__$3 \x3d (h1__$2 ^ (h1__$2 \x3e\x3e\x3e (16)));\nvar h1__$4 \x3d cljs.core.imul(h1__$3,((2246822507) | (0)));\nvar h1__$5 \x3d (h1__$4 ^ (h1__$4 \x3e\x3e\x3e (13)));\nvar h1__$6 \x3d cljs.core.imul(h1__$5,((3266489909) | (0)));\nreturn (h1__$6 ^ (h1__$6 \x3e\x3e\x3e (16)));\n});\ncljs.core.m3_hash_int \x3d (function cljs$core$m3_hash_int(in$){\nif((in$ \x3d\x3d\x3d (0))){\nreturn in$;\n} else {\nvar k1 \x3d cljs.core.m3_mix_K1(in$);\nvar h1 \x3d cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);\nreturn cljs.core.m3_fmix(h1,(4));\n}\n});\ncljs.core.m3_hash_unencoded_chars \x3d (function cljs$core$m3_hash_unencoded_chars(in$){\nvar h1 \x3d (function (){var i \x3d (1);\nvar h1 \x3d cljs.core.m3_seed;\nwhile(true){\nif((i \x3c in$.length)){\nvar G__20376 \x3d (i + (2));\nvar G__20377 \x3d cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) \x3c\x3c (16)))));\ni \x3d G__20376;\nh1 \x3d G__20377;\ncontinue;\n} else {\nreturn h1;\n}\nbreak;\n}\n})();\nvar h1__$1 \x3d ((((in$.length \x26 (1)) \x3d\x3d\x3d (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);\nreturn cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));\n});\n\n\n\ncljs.core.string_hash_cache \x3d ({});\ncljs.core.string_hash_cache_count \x3d (0);\ncljs.core.hash_string_STAR_ \x3d (function cljs$core$hash_string_STAR_(s){\nif((!((s \x3d\x3d null)))){\nvar len \x3d s.length;\nif((len \x3e (0))){\nvar i \x3d (0);\nvar hash \x3d (0);\nwhile(true){\nif((i \x3c len)){\nvar G__20378 \x3d (i + (1));\nvar G__20379 \x3d (cljs.core.imul((31),hash) + s.charCodeAt(i));\ni \x3d G__20378;\nhash \x3d G__20379;\ncontinue;\n} else {\nreturn hash;\n}\nbreak;\n}\n} else {\nreturn (0);\n}\n} else {\nreturn (0);\n}\n});\ncljs.core.add_to_string_hash_cache \x3d (function cljs$core$add_to_string_hash_cache(k){\nvar h \x3d cljs.core.hash_string_STAR_(k);\ngoog.object.set(cljs.core.string_hash_cache,k,h);\n\n(cljs.core.string_hash_cache_count \x3d (cljs.core.string_hash_cache_count + (1)));\n\nreturn h;\n});\ncljs.core.hash_string \x3d (function cljs$core$hash_string(k){\nif((cljs.core.string_hash_cache_count \x3e (255))){\n(cljs.core.string_hash_cache \x3d ({}));\n\n(cljs.core.string_hash_cache_count \x3d (0));\n} else {\n}\n\nif((k \x3d\x3d null)){\nreturn (0);\n} else {\nvar h \x3d (cljs.core.string_hash_cache[k]);\nif(typeof h \x3d\x3d\x3d \x27number\x27){\nreturn h;\n} else {\nreturn cljs.core.add_to_string_hash_cache(k);\n}\n}\n});\n/**\n * Returns the hash code of its argument. Note this is the hash code\n * consistent with \x3d.\n */\ncljs.core.hash \x3d (function cljs$core$hash(o){\nif((((!((o \x3d\x3d null))))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (4194304))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$IHash$))))?true:false):false)){\nreturn (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));\n} else {\nif(typeof o \x3d\x3d\x3d \x27number\x27){\nif(cljs.core.truth_(isFinite(o))){\nreturn (Math.floor(o) % (2147483647));\n} else {\nvar G__18376 \x3d o;\nswitch (G__18376) {\ncase Infinity:\nreturn (2146435072);\n\nbreak;\ncase -Infinity:\nreturn (-1048576);\n\nbreak;\ndefault:\nreturn (2146959360);\n\n}\n}\n} else {\nif(o \x3d\x3d\x3d true){\nreturn (1231);\n} else {\nif(o \x3d\x3d\x3d false){\nreturn (1237);\n} else {\nif(typeof o \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.m3_hash_int(cljs.core.hash_string(o));\n} else {\nif((o instanceof Date)){\nreturn (o.valueOf() ^ (0));\n} else {\nif((o \x3d\x3d null)){\nreturn (0);\n} else {\nreturn (cljs.core._hash(o) ^ (0));\n\n}\n}\n}\n}\n}\n}\n}\n});\ncljs.core.hash_combine \x3d (function cljs$core$hash_combine(seed,hash){\nreturn (seed ^ (((hash + (2654435769)) + (seed \x3c\x3c (6))) + (seed \x3e\x3e (2))));\n});\n/**\n * Evaluates x and tests if it is an instance of the type\n *   c. Returns true or false\n */\ncljs.core.instance_QMARK_ \x3d (function cljs$core$instance_QMARK_(c,x){\nreturn (x instanceof c);\n});\n/**\n * Return true if x is a Symbol\n */\ncljs.core.symbol_QMARK_ \x3d (function cljs$core$symbol_QMARK_(x){\nreturn (x instanceof cljs.core.Symbol);\n});\ncljs.core.hash_symbol \x3d (function cljs$core$hash_symbol(sym){\nreturn cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));\n});\ncljs.core.compare_symbols \x3d (function cljs$core$compare_symbols(a,b){\nif((a.str \x3d\x3d\x3d b.str)){\nreturn (0);\n} else {\nif(cljs.core.truth_(((cljs.core.not(a.ns))?b.ns:false))){\nreturn (-1);\n} else {\nif(cljs.core.truth_(a.ns)){\nif(cljs.core.not(b.ns)){\nreturn (1);\n} else {\nvar nsc \x3d goog.array.defaultCompare(a.ns,b.ns);\nif(((0) \x3d\x3d\x3d nsc)){\nreturn goog.array.defaultCompare(a.name,b.name);\n} else {\nreturn nsc;\n}\n}\n} else {\nreturn goog.array.defaultCompare(a.name,b.name);\n\n}\n}\n}\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.INamed}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.IPrintWithWriter}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.Symbol \x3d (function (ns,name,str,_hash,_meta){\nthis.ns \x3d ns;\nthis.name \x3d name;\nthis.str \x3d str;\nthis._hash \x3d _hash;\nthis._meta \x3d _meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 2154168321;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 4096;\n});\n(cljs.core.Symbol.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn self__.str;\n}));\n\n(cljs.core.Symbol.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (_,other){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif((other instanceof cljs.core.Symbol)){\nreturn (self__.str \x3d\x3d\x3d other.str);\n} else {\nreturn false;\n}\n}));\n\n(cljs.core.Symbol.prototype.call \x3d (function (unused__10738__auto__){\nvar self__ \x3d this;\nvar self__ \x3d this;\nvar G__18378 \x3d (arguments.length - (1));\nswitch (G__18378) {\ncase (1):\nreturn self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));\n\nbreak;\ncase (2):\nreturn self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join(\x27\x27)));\n\n}\n}));\n\n(cljs.core.Symbol.prototype.apply \x3d (function (self__,args18377){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18377)));\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar sym \x3d this;\nreturn (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,not_found){\nvar self__ \x3d this;\nvar sym \x3d this;\nreturn (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__._meta;\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_,new_meta){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (sym){\nvar self__ \x3d this;\nvar sym__$1 \x3d this;\nvar h__4232__auto__ \x3d self__._hash;\nif((!((h__4232__auto__ \x3d\x3d null)))){\nreturn h__4232__auto__;\n} else {\nvar h__4232__auto____$1 \x3d cljs.core.hash_symbol(sym__$1);\n(self__._hash \x3d h__4232__auto____$1);\n\nreturn h__4232__auto____$1;\n}\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.name;\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.ns;\n}));\n\n(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 \x3d (function (o,writer,_){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn cljs.core._write(writer,self__.str);\n}));\n\n(cljs.core.Symbol.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22ns\x22,\x22ns\x22,2082130287,null),new cljs.core.Symbol(null,\x22name\x22,\x22name\x22,-810760592,null),new cljs.core.Symbol(null,\x22str\x22,\x22str\x22,-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_hash\x22,\x22_hash\x22,-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),new cljs.core.Symbol(null,\x22_meta\x22,\x22_meta\x22,-1716892533,null)], null);\n}));\n\n(cljs.core.Symbol.cljs$lang$type \x3d true);\n\n(cljs.core.Symbol.cljs$lang$ctorStr \x3d \x22cljs.core/Symbol\x22);\n\n(cljs.core.Symbol.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Symbol\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Symbol.\n */\ncljs.core.__GT_Symbol \x3d (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){\nreturn (new cljs.core.Symbol(ns,name,str,_hash,_meta));\n});\n\n/**\n * Returns true if v is of type cljs.core.Var\n */\ncljs.core.var_QMARK_ \x3d (function cljs$core$var_QMARK_(v){\nreturn (v instanceof cljs.core.Var);\n});\n/**\n * Returns a Symbol with the given namespace and name. Arity-1 works\n *   on strings, keywords, and vars.\n */\ncljs.core.symbol \x3d (function cljs$core$symbol(var_args){\nvar G__18380 \x3d arguments.length;\nswitch (G__18380) {\ncase 1:\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 \x3d (function (name){\nwhile(true){\nif((name instanceof cljs.core.Symbol)){\nreturn name;\n} else {\nif(typeof name \x3d\x3d\x3d \x27string\x27){\nvar idx \x3d name.indexOf(\x22/\x22);\nif((idx \x3c (1))){\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);\n} else {\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));\n}\n} else {\nif(cljs.core.var_QMARK_(name)){\nreturn name.sym;\n} else {\nif((name instanceof cljs.core.Keyword)){\nvar G__20383 \x3d name.fqn;\nname \x3d G__20383;\ncontinue;\n} else {\nthrow (new Error(\x22no conversion to symbol\x22));\n\n}\n}\n}\n}\nbreak;\n}\n}));\n\n(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 \x3d (function (ns,name){\nvar sym_str \x3d (((!((ns \x3d\x3d null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),\x22/\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(\x27\x27):name);\nreturn (new cljs.core.Symbol(ns,name,sym_str,null,null));\n}));\n\n(cljs.core.symbol.cljs$lang$maxFixedArity \x3d 2);\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.Fn}\n * @implements {cljs.core.IDeref}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.Var \x3d (function (val,sym,_meta){\nthis.val \x3d val;\nthis.sym \x3d sym;\nthis._meta \x3d _meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 6717441;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.Var.prototype.isMacro \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;\n}));\n\n(cljs.core.Var.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn [\x22#\x27\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join(\x27\x27);\n}));\n\n(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__._meta;\n}));\n\n(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_,new_meta){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.Var(self__.val,self__.sym,new_meta));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (this$,other){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nif((other instanceof cljs.core.Var)){\nvar G__18382 \x3d this$__$1.sym;\nvar G__18383 \x3d other.sym;\nreturn (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__18382,G__18383) : cljs.core._EQ_.call(null,G__18382,G__18383));\n} else {\nreturn false;\n}\n}));\n\n(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn cljs.core.hash_symbol(self__.sym);\n}));\n\n(cljs.core.Var.prototype.cljs$core$Fn$ \x3d cljs.core.PROTOCOL_SENTINEL);\n\n(cljs.core.Var.prototype.call \x3d (function (unused__10738__auto__){\nvar self__ \x3d this;\nvar self__ \x3d this;\nvar G__18384 \x3d (arguments.length - (1));\nswitch (G__18384) {\ncase (0):\nreturn self__.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase (1):\nreturn self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));\n\nbreak;\ncase (2):\nreturn self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase (3):\nreturn self__.cljs$core$IFn$_invoke$arity$3((arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase (4):\nreturn self__.cljs$core$IFn$_invoke$arity$4((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase (5):\nreturn self__.cljs$core$IFn$_invoke$arity$5((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ncase (6):\nreturn self__.cljs$core$IFn$_invoke$arity$6((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));\n\nbreak;\ncase (7):\nreturn self__.cljs$core$IFn$_invoke$arity$7((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));\n\nbreak;\ncase (8):\nreturn self__.cljs$core$IFn$_invoke$arity$8((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));\n\nbreak;\ncase (9):\nreturn self__.cljs$core$IFn$_invoke$arity$9((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));\n\nbreak;\ncase (10):\nreturn self__.cljs$core$IFn$_invoke$arity$10((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));\n\nbreak;\ncase (11):\nreturn self__.cljs$core$IFn$_invoke$arity$11((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));\n\nbreak;\ncase (12):\nreturn self__.cljs$core$IFn$_invoke$arity$12((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));\n\nbreak;\ncase (13):\nreturn self__.cljs$core$IFn$_invoke$arity$13((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));\n\nbreak;\ncase (14):\nreturn self__.cljs$core$IFn$_invoke$arity$14((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));\n\nbreak;\ncase (15):\nreturn self__.cljs$core$IFn$_invoke$arity$15((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));\n\nbreak;\ncase (16):\nreturn self__.cljs$core$IFn$_invoke$arity$16((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));\n\nbreak;\ncase (17):\nreturn self__.cljs$core$IFn$_invoke$arity$17((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));\n\nbreak;\ncase (18):\nreturn self__.cljs$core$IFn$_invoke$arity$18((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));\n\nbreak;\ncase (19):\nreturn self__.cljs$core$IFn$_invoke$arity$19((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));\n\nbreak;\ncase (20):\nreturn self__.cljs$core$IFn$_invoke$arity$20((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));\n\nbreak;\ncase (21):\nreturn self__.cljs$core$IFn$_invoke$arity$21((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join(\x27\x27)));\n\n}\n}));\n\n(cljs.core.Var.prototype.apply \x3d (function (self__,args18381){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18381)));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18385 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18385.cljs$core$IFn$_invoke$arity$0 ? fexpr__18385.cljs$core$IFn$_invoke$arity$0() : fexpr__18385.call(null));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (a){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18386 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18386.cljs$core$IFn$_invoke$arity$1 ? fexpr__18386.cljs$core$IFn$_invoke$arity$1(a) : fexpr__18386.call(null,a));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (a,b){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18387 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18387.cljs$core$IFn$_invoke$arity$2 ? fexpr__18387.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__18387.call(null,a,b));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 \x3d (function (a,b,c){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18388 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18388.cljs$core$IFn$_invoke$arity$3 ? fexpr__18388.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__18388.call(null,a,b,c));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 \x3d (function (a,b,c,d){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18389 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18389.cljs$core$IFn$_invoke$arity$4 ? fexpr__18389.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__18389.call(null,a,b,c,d));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 \x3d (function (a,b,c,d,e){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18390 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18390.cljs$core$IFn$_invoke$arity$5 ? fexpr__18390.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__18390.call(null,a,b,c,d,e));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 \x3d (function (a,b,c,d,e,f){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18391 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18391.cljs$core$IFn$_invoke$arity$6 ? fexpr__18391.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__18391.call(null,a,b,c,d,e,f));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 \x3d (function (a,b,c,d,e,f,g){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18392 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18392.cljs$core$IFn$_invoke$arity$7 ? fexpr__18392.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__18392.call(null,a,b,c,d,e,f,g));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 \x3d (function (a,b,c,d,e,f,g,h){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18393 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18393.cljs$core$IFn$_invoke$arity$8 ? fexpr__18393.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__18393.call(null,a,b,c,d,e,f,g,h));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 \x3d (function (a,b,c,d,e,f,g,h,i){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18394 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18394.cljs$core$IFn$_invoke$arity$9 ? fexpr__18394.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__18394.call(null,a,b,c,d,e,f,g,h,i));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 \x3d (function (a,b,c,d,e,f,g,h,i,j){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18395 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18395.cljs$core$IFn$_invoke$arity$10 ? fexpr__18395.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__18395.call(null,a,b,c,d,e,f,g,h,i,j));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 \x3d (function (a,b,c,d,e,f,g,h,i,j,k){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18396 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18396.cljs$core$IFn$_invoke$arity$11 ? fexpr__18396.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__18396.call(null,a,b,c,d,e,f,g,h,i,j,k));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18397 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18397.cljs$core$IFn$_invoke$arity$12 ? fexpr__18397.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__18397.call(null,a,b,c,d,e,f,g,h,i,j,k,l));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18398 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18398.cljs$core$IFn$_invoke$arity$13 ? fexpr__18398.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__18398.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18399 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18399.cljs$core$IFn$_invoke$arity$14 ? fexpr__18399.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__18399.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18400 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18400.cljs$core$IFn$_invoke$arity$15 ? fexpr__18400.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__18400.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18401 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18401.cljs$core$IFn$_invoke$arity$16 ? fexpr__18401.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__18401.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18402 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18402.cljs$core$IFn$_invoke$arity$17 ? fexpr__18402.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__18402.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18403 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18403.cljs$core$IFn$_invoke$arity$18 ? fexpr__18403.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__18403.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18404 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18404.cljs$core$IFn$_invoke$arity$19 ? fexpr__18404.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__18404.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__18405 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__18405.cljs$core$IFn$_invoke$arity$20 ? fexpr__18405.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__18405.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n}));\n\n(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar G__18406 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nvar G__18407 \x3d a;\nvar G__18408 \x3d b;\nvar G__18409 \x3d c;\nvar G__18410 \x3d d;\nvar G__18411 \x3d e;\nvar G__18412 \x3d f;\nvar G__18413 \x3d g;\nvar G__18414 \x3d h;\nvar G__18415 \x3d i;\nvar G__18416 \x3d j;\nvar G__18417 \x3d k;\nvar G__18418 \x3d l;\nvar G__18419 \x3d m;\nvar G__18420 \x3d n;\nvar G__18421 \x3d o;\nvar G__18422 \x3d p;\nvar G__18423 \x3d q;\nvar G__18424 \x3d r;\nvar G__18425 \x3d s;\nvar G__18426 \x3d t;\nvar G__18427 \x3d rest;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__18406,G__18407,G__18408,G__18409,G__18410,G__18411,G__18412,G__18413,G__18414,G__18415,G__18416,G__18417,G__18418,G__18419,G__18420,G__18421,G__18422,G__18423,G__18424,G__18425,G__18426,G__18427) : cljs.core.apply.call(null,G__18406,G__18407,G__18408,G__18409,G__18410,G__18411,G__18412,G__18413,G__18414,G__18415,G__18416,G__18417,G__18418,G__18419,G__18420,G__18421,G__18422,G__18423,G__18424,G__18425,G__18426,G__18427));\n}));\n\n(cljs.core.Var.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22val\x22,\x22val\x22,1769233139,null),new cljs.core.Symbol(null,\x22sym\x22,\x22sym\x22,195671222,null),new cljs.core.Symbol(null,\x22_meta\x22,\x22_meta\x22,-1716892533,null)], null);\n}));\n\n(cljs.core.Var.cljs$lang$type \x3d true);\n\n(cljs.core.Var.cljs$lang$ctorStr \x3d \x22cljs.core/Var\x22);\n\n(cljs.core.Var.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Var\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Var.\n */\ncljs.core.__GT_Var \x3d (function cljs$core$__GT_Var(val,sym,_meta){\nreturn (new cljs.core.Var(val,sym,_meta));\n});\n\n\n\n/**\n * Return true if x implements IIterable protocol.\n */\ncljs.core.iterable_QMARK_ \x3d (function cljs$core$iterable_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition1$ \x26 (131072))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IIterable$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition1$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);\n}\n});\n/**\n * Return true if x has a JavaScript iterator property\n */\ncljs.core.js_iterable_QMARK_ \x3d (function cljs$core$js_iterable_QMARK_(x){\nreturn (((!((x \x3d\x3d null)))) \x26\x26 ((!((x[cljs.core.ITER_SYMBOL] \x3d\x3d null)))));\n});\n/**\n * Clone the supplied value which must implement ICloneable.\n */\ncljs.core.clone \x3d (function cljs$core$clone(value){\nreturn cljs.core._clone(value);\n});\n/**\n * Return true if x implements ICloneable protocol.\n */\ncljs.core.cloneable_QMARK_ \x3d (function cljs$core$cloneable_QMARK_(value){\nif((!((value \x3d\x3d null)))){\nif((((value.cljs$lang$protocol_mask$partition1$ \x26 (8192))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d value.cljs$core$ICloneable$)))){\nreturn true;\n} else {\nif((!value.cljs$lang$protocol_mask$partition1$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);\n}\n});\n/**\n * Returns a seq on the collection. If the collection is\n *   empty, returns nil.  (seq nil) returns nil. seq also works on\n *   Strings.\n */\ncljs.core.seq \x3d (function cljs$core$seq(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (8388608))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeqable$))))?true:false):false)){\nreturn coll.cljs$core$ISeqable$_seq$arity$1(null);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nif((coll.length \x3d\x3d\x3d (0))){\nreturn null;\n} else {\nreturn (new cljs.core.IndexedSeq(coll,(0),null));\n}\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nif((coll.length \x3d\x3d\x3d (0))){\nreturn null;\n} else {\nreturn (new cljs.core.IndexedSeq(coll,(0),null));\n}\n} else {\nif(cljs.core.js_iterable_QMARK_(coll)){\nvar G__18431 \x3d goog.object.get(coll,cljs.core.ITER_SYMBOL).call(coll);\nreturn (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__18431) : cljs.core.es6_iterator_seq.call(null,G__18431));\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){\nreturn cljs.core._seq(coll);\n} else {\nthrow (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll),\x22 is not ISeqable\x22].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n}\n});\n/**\n * Returns the first item in the collection. Calls seq on its\n *   argument. If coll is nil, returns nil.\n */\ncljs.core.first \x3d (function cljs$core$first(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false)){\nreturn coll.cljs$core$ISeq$_first$arity$1(null);\n} else {\nvar s \x3d cljs.core.seq(coll);\nif((s \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._first(s);\n}\n}\n}\n});\n/**\n * Returns a possibly empty seq of the items after the first. Calls seq on its\n *   argument.\n */\ncljs.core.rest \x3d (function cljs$core$rest(coll){\nif((!((coll \x3d\x3d null)))){\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false)){\nreturn coll.cljs$core$ISeq$_rest$arity$1(null);\n} else {\nvar s \x3d cljs.core.seq(coll);\nif(s){\nreturn s.cljs$core$ISeq$_rest$arity$1(null);\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}\n} else {\nreturn cljs.core.List.EMPTY;\n}\n});\n/**\n * Returns a seq of the items after the first. Calls seq on its\n *   argument.  If there are no more items, returns nil\n */\ncljs.core.next \x3d (function cljs$core$next(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (128))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$INext$))))?true:false):false)){\nreturn coll.cljs$core$INext$_next$arity$1(null);\n} else {\nreturn cljs.core.seq(cljs.core.rest(coll));\n}\n}\n});\n/**\n * Equality. Returns true if x equals y, false if not. Compares\n *   numbers and collections in a type-independent manner.  Clojure\x27s immutable data\n *   structures define -equiv (and thus \x3d) as a value, not an identity,\n *   comparison.\n */\ncljs.core._EQ_ \x3d (function cljs$core$_EQ_(var_args){\nvar G__18439 \x3d arguments.length;\nswitch (G__18439) {\ncase 1:\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20416 \x3d arguments.length;\nvar i__4731__auto___20417 \x3d (0);\nwhile(true){\nif((i__4731__auto___20417 \x3c len__4730__auto___20416)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20417]));\n\nvar G__20418 \x3d (i__4731__auto___20417 + (1));\ni__4731__auto___20417 \x3d G__20418;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nif((x \x3d\x3d null)){\nreturn (y \x3d\x3d null);\n} else {\nreturn (((x \x3d\x3d\x3d y)) || (cljs.core._equiv(x,y)));\n}\n}));\n\n(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){\nif(cljs.core.next(more)){\nvar G__20420 \x3d y;\nvar G__20421 \x3d cljs.core.first(more);\nvar G__20422 \x3d cljs.core.next(more);\nx \x3d G__20420;\ny \x3d G__20421;\nmore \x3d G__20422;\ncontinue;\n} else {\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core._EQ_.cljs$lang$applyTo \x3d (function (seq18436){\nvar G__18437 \x3d cljs.core.first(seq18436);\nvar seq18436__$1 \x3d cljs.core.next(seq18436);\nvar G__18438 \x3d cljs.core.first(seq18436__$1);\nvar seq18436__$2 \x3d cljs.core.next(seq18436__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18437,G__18438,seq18436__$2);\n}));\n\n(cljs.core._EQ_.cljs$lang$maxFixedArity \x3d (2));\n\n\n/**\n* @constructor\n*/\ncljs.core.ES6Iterator \x3d (function (s){\nthis.s \x3d s;\n});\n(cljs.core.ES6Iterator.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nif((!((self__.s \x3d\x3d null)))){\nvar x \x3d cljs.core.first(self__.s);\n(self__.s \x3d cljs.core.next(self__.s));\n\nreturn ({\x22value\x22: x, \x22done\x22: false});\n} else {\nreturn ({\x22value\x22: null, \x22done\x22: true});\n}\n}));\n\n(cljs.core.ES6Iterator.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22s\x22,\x22s\x22,-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.ES6Iterator.cljs$lang$type \x3d true);\n\n(cljs.core.ES6Iterator.cljs$lang$ctorStr \x3d \x22cljs.core/ES6Iterator\x22);\n\n(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/ES6Iterator\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/ES6Iterator.\n */\ncljs.core.__GT_ES6Iterator \x3d (function cljs$core$__GT_ES6Iterator(s){\nreturn (new cljs.core.ES6Iterator(s));\n});\n\n/**\n * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.\n */\ncljs.core.es6_iterator \x3d (function cljs$core$es6_iterator(coll){\nreturn (new cljs.core.ES6Iterator(cljs.core.seq(coll)));\n});\n\n/**\n* @constructor\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.ISeqable}\n*/\ncljs.core.ES6IteratorSeq \x3d (function (value,iter,_rest){\nthis.value \x3d value;\nthis.iter \x3d iter;\nthis._rest \x3d _rest;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 8388672;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (this$){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nreturn this$__$1;\n}));\n\n(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.value;\n}));\n\n(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif((self__._rest \x3d\x3d null)){\n(self__._rest \x3d (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter)));\n} else {\n}\n\nreturn self__._rest;\n}));\n\n(cljs.core.ES6IteratorSeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22value\x22,\x22value\x22,1946509744,null),new cljs.core.Symbol(null,\x22iter\x22,\x22iter\x22,-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_rest\x22,\x22_rest\x22,-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.ES6IteratorSeq.cljs$lang$type \x3d true);\n\n(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr \x3d \x22cljs.core/ES6IteratorSeq\x22);\n\n(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/ES6IteratorSeq\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/ES6IteratorSeq.\n */\ncljs.core.__GT_ES6IteratorSeq \x3d (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){\nreturn (new cljs.core.ES6IteratorSeq(value,iter,_rest));\n});\n\n/**\n * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.\n */\ncljs.core.es6_iterator_seq \x3d (function cljs$core$es6_iterator_seq(iter){\nvar v \x3d iter.next();\nif(cljs.core.truth_(v.done)){\nreturn null;\n} else {\nreturn (new cljs.core.ES6IteratorSeq(v.value,iter,null));\n}\n});\n/**\n * Mix final collection hash for ordered or unordered collections.\n * hash-basis is the combined collection hash, count is the number\n * of elements included in the basis. Note this is the hash code\n * consistent with \x3d, different from .hashCode.\n * See http://clojure.org/data_structures#hash for full algorithms.\n */\ncljs.core.mix_collection_hash \x3d (function cljs$core$mix_collection_hash(hash_basis,count){\nvar h1 \x3d cljs.core.m3_seed;\nvar k1 \x3d cljs.core.m3_mix_K1(hash_basis);\nvar h1__$1 \x3d cljs.core.m3_mix_H1(h1,k1);\nreturn cljs.core.m3_fmix(h1__$1,count);\n});\n/**\n * Returns the hash code, consistent with \x3d, for an external ordered\n * collection implementing Iterable.\n * See http://clojure.org/data_structures#hash for full algorithms.\n */\ncljs.core.hash_ordered_coll \x3d (function cljs$core$hash_ordered_coll(coll){\nvar n \x3d (0);\nvar hash_code \x3d (1);\nvar coll__$1 \x3d cljs.core.seq(coll);\nwhile(true){\nif((!((coll__$1 \x3d\x3d null)))){\nvar G__20423 \x3d (n + (1));\nvar G__20424 \x3d ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));\nvar G__20425 \x3d cljs.core.next(coll__$1);\nn \x3d G__20423;\nhash_code \x3d G__20424;\ncoll__$1 \x3d G__20425;\ncontinue;\n} else {\nreturn cljs.core.mix_collection_hash(hash_code,n);\n}\nbreak;\n}\n});\ncljs.core.empty_ordered_hash \x3d cljs.core.mix_collection_hash((1),(0));\n/**\n * Returns the hash code, consistent with \x3d, for an external unordered\n * collection implementing Iterable. For maps, the iterator should\n * return map entries whose hash is computed as\n *   (hash-ordered-coll [k v]).\n * See http://clojure.org/data_structures#hash for full algorithms.\n */\ncljs.core.hash_unordered_coll \x3d (function cljs$core$hash_unordered_coll(coll){\nvar n \x3d (0);\nvar hash_code \x3d (0);\nvar coll__$1 \x3d cljs.core.seq(coll);\nwhile(true){\nif((!((coll__$1 \x3d\x3d null)))){\nvar G__20426 \x3d (n + (1));\nvar G__20427 \x3d ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));\nvar G__20428 \x3d cljs.core.next(coll__$1);\nn \x3d G__20426;\nhash_code \x3d G__20427;\ncoll__$1 \x3d G__20428;\ncontinue;\n} else {\nreturn cljs.core.mix_collection_hash(hash_code,n);\n}\nbreak;\n}\n});\ncljs.core.empty_unordered_hash \x3d cljs.core.mix_collection_hash((0),(0));\n\n\ngoog.object.set(cljs.core.ICounted,\x22null\x22,true);\n\ngoog.object.set(cljs.core._count,\x22null\x22,(function (_){\nreturn (0);\n}));\n(Date.prototype.cljs$core$IEquiv$ \x3d cljs.core.PROTOCOL_SENTINEL);\n\n(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (o,other){\nvar o__$1 \x3d this;\nreturn (((other instanceof Date)) \x26\x26 ((o__$1.valueOf() \x3d\x3d\x3d other.valueOf())));\n}));\n\n(Date.prototype.cljs$core$IComparable$ \x3d cljs.core.PROTOCOL_SENTINEL);\n\n(Date.prototype.cljs$core$IComparable$_compare$arity$2 \x3d (function (this$,other){\nvar this$__$1 \x3d this;\nif((other instanceof Date)){\nreturn goog.array.defaultCompare(this$__$1.valueOf(),other.valueOf());\n} else {\nthrow (new Error([\x22Cannot compare \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1),\x22 to \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join(\x27\x27)));\n}\n}));\n\n/**\n * @interface\n */\ncljs.core.Inst \x3d function(){};\n\nvar cljs$core$Inst$inst_ms_STAR_$dyn_20429 \x3d (function (inst){\nvar x__4422__auto__ \x3d (((inst \x3d\x3d null))?null:inst);\nvar m__4423__auto__ \x3d (cljs.core.inst_ms_STAR_[goog.typeOf(x__4422__auto__)]);\nif((!((m__4423__auto__ \x3d\x3d null)))){\nreturn (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4423__auto__.call(null,inst));\n} else {\nvar m__4420__auto__ \x3d (cljs.core.inst_ms_STAR_[\x22_\x22]);\nif((!((m__4420__auto__ \x3d\x3d null)))){\nreturn (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4420__auto__.call(null,inst));\n} else {\nthrow cljs.core.missing_protocol(\x22Inst.inst-ms*\x22,inst);\n}\n}\n});\ncljs.core.inst_ms_STAR_ \x3d (function cljs$core$inst_ms_STAR_(inst){\nif((((!((inst \x3d\x3d null)))) \x26\x26 ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 \x3d\x3d null)))))){\nreturn inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);\n} else {\nreturn cljs$core$Inst$inst_ms_STAR_$dyn_20429(inst);\n}\n});\n\n(Date.prototype.cljs$core$Inst$ \x3d cljs.core.PROTOCOL_SENTINEL);\n\n(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 \x3d (function (inst){\nvar inst__$1 \x3d this;\nreturn inst__$1.getTime();\n}));\n/**\n * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT\n */\ncljs.core.inst_ms \x3d (function cljs$core$inst_ms(inst){\nreturn cljs.core.inst_ms_STAR_(inst);\n});\n/**\n * Return true if x satisfies Inst\n */\ncljs.core.inst_QMARK_ \x3d (function cljs$core$inst_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif(((false) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$Inst$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);\n}\n});\ngoog.object.set(cljs.core.IEquiv,\x22number\x22,true);\n\ngoog.object.set(cljs.core._equiv,\x22number\x22,(function (x,o){\nreturn (x \x3d\x3d\x3d o);\n}));\ngoog.object.set(cljs.core.Fn,\x22function\x22,true);\n\ngoog.object.set(cljs.core.IMeta,\x22function\x22,true);\n\ngoog.object.set(cljs.core._meta,\x22function\x22,(function (_){\nreturn null;\n}));\ngoog.object.set(cljs.core.IHash,\x22_\x22,true);\n\ngoog.object.set(cljs.core._hash,\x22_\x22,(function (o){\nreturn goog.getUid(o);\n}));\n/**\n * Returns a number one greater than num.\n */\ncljs.core.inc \x3d (function cljs$core$inc(x){\nreturn (x + (1));\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IDeref}\n*/\ncljs.core.Reduced \x3d (function (val){\nthis.val \x3d val;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 32768;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 \x3d (function (o){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn self__.val;\n}));\n\n(cljs.core.Reduced.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22val\x22,\x22val\x22,1769233139,null)], null);\n}));\n\n(cljs.core.Reduced.cljs$lang$type \x3d true);\n\n(cljs.core.Reduced.cljs$lang$ctorStr \x3d \x22cljs.core/Reduced\x22);\n\n(cljs.core.Reduced.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Reduced\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Reduced.\n */\ncljs.core.__GT_Reduced \x3d (function cljs$core$__GT_Reduced(val){\nreturn (new cljs.core.Reduced(val));\n});\n\n/**\n * Wraps x in a way such that a reduce will terminate with the value x\n */\ncljs.core.reduced \x3d (function cljs$core$reduced(x){\nreturn (new cljs.core.Reduced(x));\n});\n/**\n * Returns true if x is the result of a call to reduced\n */\ncljs.core.reduced_QMARK_ \x3d (function cljs$core$reduced_QMARK_(r){\nreturn (r instanceof cljs.core.Reduced);\n});\n/**\n * If x is already reduced?, returns it, else returns (reduced x)\n */\ncljs.core.ensure_reduced \x3d (function cljs$core$ensure_reduced(x){\nif(cljs.core.reduced_QMARK_(x)){\nreturn x;\n} else {\nreturn cljs.core.reduced(x);\n}\n});\n/**\n * If x is reduced?, returns (deref x), else returns x\n */\ncljs.core.unreduced \x3d (function cljs$core$unreduced(x){\nif(cljs.core.reduced_QMARK_(x)){\nreturn (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));\n} else {\nreturn x;\n}\n});\n/**\n * Also reader macro: @var/@atom/@delay. Returns the\n * most-recently-committed value of ref. When applied to a var\n * or atom, returns its current state. When applied to a delay, forces\n * it if not already forced. See also - realized?.\n */\ncljs.core.deref \x3d (function cljs$core$deref(o){\nreturn cljs.core._deref(o);\n});\n/**\n * Accepts any collection which satisfies the ICount and IIndexed protocols and\n * reduces them without incurring seq initialization\n */\ncljs.core.ci_reduce \x3d (function cljs$core$ci_reduce(var_args){\nvar G__18442 \x3d arguments.length;\nswitch (G__18442) {\ncase 2:\nreturn cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (cicoll,f){\nvar cnt \x3d cicoll.cljs$core$ICounted$_count$arity$1(null);\nif((cnt \x3d\x3d\x3d (0))){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n} else {\nvar val \x3d cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));\nvar n \x3d (1);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__18443 \x3d val;\nvar G__18444 \x3d cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18443,G__18444) : f.call(null,G__18443,G__18444));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__20432 \x3d nval;\nvar G__20433 \x3d (n + (1));\nval \x3d G__20432;\nn \x3d G__20433;\ncontinue;\n}\n} else {\nreturn val;\n}\nbreak;\n}\n}\n}));\n\n(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (cicoll,f,val){\nvar cnt \x3d cicoll.cljs$core$ICounted$_count$arity$1(null);\nvar val__$1 \x3d val;\nvar n \x3d (0);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__18445 \x3d val__$1;\nvar G__18446 \x3d cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18445,G__18446) : f.call(null,G__18445,G__18446));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__20434 \x3d nval;\nvar G__20435 \x3d (n + (1));\nval__$1 \x3d G__20434;\nn \x3d G__20435;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n}));\n\n(cljs.core.ci_reduce.cljs$lang$maxFixedArity \x3d 3);\n\ncljs.core.array_reduce \x3d (function cljs$core$array_reduce(var_args){\nvar G__18448 \x3d arguments.length;\nswitch (G__18448) {\ncase 2:\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (arr,f){\nvar cnt \x3d arr.length;\nif((arr.length \x3d\x3d\x3d (0))){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n} else {\nvar val \x3d (arr[(0)]);\nvar n \x3d (1);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__18449 \x3d val;\nvar G__18450 \x3d (arr[n]);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18449,G__18450) : f.call(null,G__18449,G__18450));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__20437 \x3d nval;\nvar G__20438 \x3d (n + (1));\nval \x3d G__20437;\nn \x3d G__20438;\ncontinue;\n}\n} else {\nreturn val;\n}\nbreak;\n}\n}\n}));\n\n(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (arr,f,val){\nvar cnt \x3d arr.length;\nvar val__$1 \x3d val;\nvar n \x3d (0);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__18451 \x3d val__$1;\nvar G__18452 \x3d (arr[n]);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18451,G__18452) : f.call(null,G__18451,G__18452));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__20445 \x3d nval;\nvar G__20446 \x3d (n + (1));\nval__$1 \x3d G__20445;\nn \x3d G__20446;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n}));\n\n(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 \x3d (function (arr,f,val,idx){\nvar cnt \x3d arr.length;\nvar val__$1 \x3d val;\nvar n \x3d idx;\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__18453 \x3d val__$1;\nvar G__18454 \x3d (arr[n]);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18453,G__18454) : f.call(null,G__18453,G__18454));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__20455 \x3d nval;\nvar G__20456 \x3d (n + (1));\nval__$1 \x3d G__20455;\nn \x3d G__20456;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n}));\n\n(cljs.core.array_reduce.cljs$lang$maxFixedArity \x3d 4);\n\n\n\n\n\n\n\n/**\n * Returns true if coll implements count in constant time\n */\ncljs.core.counted_QMARK_ \x3d (function cljs$core$counted_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (2))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ICounted$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);\n}\n});\n/**\n * Returns true if coll implements nth in constant time\n */\ncljs.core.indexed_QMARK_ \x3d (function cljs$core$indexed_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (16))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IIndexed$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);\n}\n});\ncljs.core._indexOf \x3d (function cljs$core$_indexOf(var_args){\nvar G__18458 \x3d arguments.length;\nswitch (G__18458) {\ncase 2:\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,x){\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n}));\n\n(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,x,start){\nvar len \x3d (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));\nif((start \x3e\x3d len)){\nreturn (-1);\n} else {\nvar idx \x3d (((start \x3e (0)))?start:(((start \x3c (0)))?(function (){var x__4208__auto__ \x3d (0);\nvar y__4209__auto__ \x3d (start + len);\nreturn ((x__4208__auto__ \x3e y__4209__auto__) ? x__4208__auto__ : y__4209__auto__);\n})():start\n));\nwhile(true){\nif((idx \x3c len)){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){\nreturn idx;\n} else {\nvar G__20467 \x3d (idx + (1));\nidx \x3d G__20467;\ncontinue;\n}\n} else {\nreturn (-1);\n}\nbreak;\n}\n}\n}));\n\n(cljs.core._indexOf.cljs$lang$maxFixedArity \x3d 3);\n\ncljs.core._lastIndexOf \x3d (function cljs$core$_lastIndexOf(var_args){\nvar G__18460 \x3d arguments.length;\nswitch (G__18460) {\ncase 2:\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,x){\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));\n}));\n\n(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,x,start){\nvar len \x3d (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));\nif((len \x3d\x3d\x3d (0))){\nreturn (-1);\n} else {\nvar idx \x3d (((start \x3e (0)))?(function (){var x__4211__auto__ \x3d (len - (1));\nvar y__4212__auto__ \x3d start;\nreturn ((x__4211__auto__ \x3c y__4212__auto__) ? x__4211__auto__ : y__4212__auto__);\n})():(((start \x3c (0)))?(len + start):start\n));\nwhile(true){\nif((idx \x3e\x3d (0))){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){\nreturn idx;\n} else {\nvar G__20469 \x3d (idx - (1));\nidx \x3d G__20469;\ncontinue;\n}\n} else {\nreturn (-1);\n}\nbreak;\n}\n}\n}));\n\n(cljs.core._lastIndexOf.cljs$lang$maxFixedArity \x3d 3);\n\n\n/**\n* @constructor\n*/\ncljs.core.IndexedSeqIterator \x3d (function (arr,i){\nthis.arr \x3d arr;\nthis.i \x3d i;\n});\n(cljs.core.IndexedSeqIterator.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.i \x3c self__.arr.length);\n}));\n\n(cljs.core.IndexedSeqIterator.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar ret \x3d (self__.arr[self__.i]);\n(self__.i \x3d (self__.i + (1)));\n\nreturn ret;\n}));\n\n(cljs.core.IndexedSeqIterator.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.IndexedSeqIterator.cljs$lang$type \x3d true);\n\n(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr \x3d \x22cljs.core/IndexedSeqIterator\x22);\n\n(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/IndexedSeqIterator\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/IndexedSeqIterator.\n */\ncljs.core.__GT_IndexedSeqIterator \x3d (function cljs$core$__GT_IndexedSeqIterator(arr,i){\nreturn (new cljs.core.IndexedSeqIterator(arr,i));\n});\n\n\n/**\n* @constructor\n * @implements {cljs.core.IIndexed}\n * @implements {cljs.core.IReversible}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.IIterable}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.IndexedSeq \x3d (function (arr,i,meta){\nthis.arr \x3d arr;\nthis.i \x3d i;\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 166592766;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 139264;\n});\n(cljs.core.IndexedSeq.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.IndexedSeq.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.IndexedSeq.prototype.indexOf \x3d (function() {\nvar G__20476 \x3d null;\nvar G__20476__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20476__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20476 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20476__1.call(this,x);\ncase 2:\nreturn G__20476__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20476.cljs$core$IFn$_invoke$arity$1 \x3d G__20476__1;\nG__20476.cljs$core$IFn$_invoke$arity$2 \x3d G__20476__2;\nreturn G__20476;\n})()\n);\n\n(cljs.core.IndexedSeq.prototype.lastIndexOf \x3d (function() {\nvar G__20480 \x3d null;\nvar G__20480__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));\n});\nvar G__20480__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20480 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20480__1.call(this,x);\ncase 2:\nreturn G__20480__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20480.cljs$core$IFn$_invoke$arity$1 \x3d G__20480__1;\nG__20480.cljs$core$IFn$_invoke$arity$2 \x3d G__20480__2;\nreturn G__20480;\n})()\n);\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 \x3d (function (coll,n){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar i__$1 \x3d (n + self__.i);\nif(((((0) \x3c\x3d i__$1)) \x26\x26 ((i__$1 \x3c self__.arr.length)))){\nreturn (self__.arr[i__$1]);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 \x3d (function (coll,n,not_found){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar i__$1 \x3d (n + self__.i);\nif(((((0) \x3c\x3d i__$1)) \x26\x26 ((i__$1 \x3c self__.arr.length)))){\nreturn (self__.arr[i__$1]);\n} else {\nreturn not_found;\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif(((self__.i + (1)) \x3c self__.arr.length)){\nreturn (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));\n} else {\nreturn null;\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nvar x__4208__auto__ \x3d (0);\nvar y__4209__auto__ \x3d (self__.arr.length - self__.i);\nreturn ((x__4208__auto__ \x3e y__4209__auto__) ? x__4208__auto__ : y__4209__auto__);\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar c \x3d coll__$1.cljs$core$ICounted$_count$arity$1(null);\nif((c \x3e (0))){\nreturn (new cljs.core.RSeq(coll__$1,(c - (1)),null));\n} else {\nreturn null;\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.hash_ordered_coll(coll__$1);\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (self__.arr[self__.i]);\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif(((self__.i + (1)) \x3c self__.arr.length)){\nreturn (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (this$){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nif((self__.i \x3c self__.arr.length)){\nreturn this$__$1;\n} else {\nreturn null;\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));\n}\n}));\n\n(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));\n}));\n\n(cljs.core.IndexedSeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n}));\n\n(cljs.core.IndexedSeq.cljs$lang$type \x3d true);\n\n(cljs.core.IndexedSeq.cljs$lang$ctorStr \x3d \x22cljs.core/IndexedSeq\x22);\n\n(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/IndexedSeq\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/IndexedSeq.\n */\ncljs.core.__GT_IndexedSeq \x3d (function cljs$core$__GT_IndexedSeq(arr,i,meta){\nreturn (new cljs.core.IndexedSeq(arr,i,meta));\n});\n\ngoog.object.set(cljs.core.IndexedSeq.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\n/**\n * Create seq from a primitive JavaScript Array-like.\n */\ncljs.core.prim_seq \x3d (function cljs$core$prim_seq(var_args){\nvar G__18462 \x3d arguments.length;\nswitch (G__18462) {\ncase 1:\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 \x3d (function (prim){\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));\n}));\n\n(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 \x3d (function (prim,i){\nif((i \x3c prim.length)){\nreturn (new cljs.core.IndexedSeq(prim,i,null));\n} else {\nreturn null;\n}\n}));\n\n(cljs.core.prim_seq.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Create a seq from a JavaScript array.\n */\ncljs.core.array_seq \x3d (function cljs$core$array_seq(var_args){\nvar G__18464 \x3d arguments.length;\nswitch (G__18464) {\ncase 1:\nreturn cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 \x3d (function (array){\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));\n}));\n\n(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,i){\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);\n}));\n\n(cljs.core.array_seq.cljs$lang$maxFixedArity \x3d 2);\n\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.RSeq \x3d (function (ci,i,meta){\nthis.ci \x3d ci;\nthis.i \x3d i;\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 32374990;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\n(cljs.core.RSeq.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.RSeq.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.RSeq.prototype.indexOf \x3d (function() {\nvar G__20504 \x3d null;\nvar G__20504__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20504__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20504 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20504__1.call(this,x);\ncase 2:\nreturn G__20504__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20504.cljs$core$IFn$_invoke$arity$1 \x3d G__20504__1;\nG__20504.cljs$core$IFn$_invoke$arity$2 \x3d G__20504__2;\nreturn G__20504;\n})()\n);\n\n(cljs.core.RSeq.prototype.lastIndexOf \x3d (function() {\nvar G__20505 \x3d null;\nvar G__20505__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));\n});\nvar G__20505__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20505 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20505__1.call(this,x);\ncase 2:\nreturn G__20505__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20505.cljs$core$IFn$_invoke$arity$1 \x3d G__20505__1;\nG__20505.cljs$core$IFn$_invoke$arity$2 \x3d G__20505__2;\nreturn G__20505;\n})()\n);\n\n(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.i \x3e (0))){\nreturn (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));\n} else {\nreturn null;\n}\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (self__.i + (1));\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.hash_ordered_coll(coll__$1);\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (col,f){\nvar self__ \x3d this;\nvar col__$1 \x3d this;\nreturn (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (col,f,start){\nvar self__ \x3d this;\nvar col__$1 \x3d this;\nreturn (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._nth(self__.ci,self__.i);\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.i \x3e (0))){\nreturn (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.RSeq(self__.ci,self__.i,new_meta));\n}\n}));\n\n(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));\n}));\n\n(cljs.core.RSeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22ci\x22,\x22ci\x22,2049808339,null),new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n}));\n\n(cljs.core.RSeq.cljs$lang$type \x3d true);\n\n(cljs.core.RSeq.cljs$lang$ctorStr \x3d \x22cljs.core/RSeq\x22);\n\n(cljs.core.RSeq.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/RSeq\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/RSeq.\n */\ncljs.core.__GT_RSeq \x3d (function cljs$core$__GT_RSeq(ci,i,meta){\nreturn (new cljs.core.RSeq(ci,i,meta));\n});\n\ngoog.object.set(cljs.core.RSeq.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\n/**\n * Same as (first (next x))\n */\ncljs.core.second \x3d (function cljs$core$second(coll){\nreturn cljs.core.first(cljs.core.next(coll));\n});\n/**\n * Same as (first (first x))\n */\ncljs.core.ffirst \x3d (function cljs$core$ffirst(coll){\nreturn cljs.core.first(cljs.core.first(coll));\n});\n/**\n * Same as (next (first x))\n */\ncljs.core.nfirst \x3d (function cljs$core$nfirst(coll){\nreturn cljs.core.next(cljs.core.first(coll));\n});\n/**\n * Same as (first (next x))\n */\ncljs.core.fnext \x3d (function cljs$core$fnext(coll){\nreturn cljs.core.first(cljs.core.next(coll));\n});\n/**\n * Same as (next (next x))\n */\ncljs.core.nnext \x3d (function cljs$core$nnext(coll){\nreturn cljs.core.next(cljs.core.next(coll));\n});\n/**\n * Return the last item in coll, in linear time\n */\ncljs.core.last \x3d (function cljs$core$last(s){\nwhile(true){\nvar sn \x3d cljs.core.next(s);\nif((!((sn \x3d\x3d null)))){\nvar G__20520 \x3d sn;\ns \x3d G__20520;\ncontinue;\n} else {\nreturn cljs.core.first(s);\n}\nbreak;\n}\n});\ngoog.object.set(cljs.core.IEquiv,\x22_\x22,true);\n\ngoog.object.set(cljs.core._equiv,\x22_\x22,(function (x,o){\nreturn (x \x3d\x3d\x3d o);\n}));\n/**\n * conj[oin]. Returns a new collection with the xs\n *   \x27added\x27. (conj nil item) returns (item).  The \x27addition\x27 may\n *   happen at different \x27places\x27 depending on the concrete type.\n */\ncljs.core.conj \x3d (function cljs$core$conj(var_args){\nvar G__18469 \x3d arguments.length;\nswitch (G__18469) {\ncase 0:\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20525 \x3d arguments.length;\nvar i__4731__auto___20526 \x3d (0);\nwhile(true){\nif((i__4731__auto___20526 \x3c len__4730__auto___20525)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20526]));\n\nvar G__20527 \x3d (i__4731__auto___20526 + (1));\ni__4731__auto___20526 \x3d G__20527;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn cljs.core.PersistentVector.EMPTY;\n}));\n\n(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn coll;\n}));\n\n(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,x){\nif((!((coll \x3d\x3d null)))){\nreturn cljs.core._conj(coll,x);\n} else {\nreturn (new cljs.core.List(null,x,null,(1),null));\n}\n}));\n\n(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,x,xs){\nwhile(true){\nif(cljs.core.truth_(xs)){\nvar G__20528 \x3d cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);\nvar G__20529 \x3d cljs.core.first(xs);\nvar G__20530 \x3d cljs.core.next(xs);\ncoll \x3d G__20528;\nx \x3d G__20529;\nxs \x3d G__20530;\ncontinue;\n} else {\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.conj.cljs$lang$applyTo \x3d (function (seq18466){\nvar G__18467 \x3d cljs.core.first(seq18466);\nvar seq18466__$1 \x3d cljs.core.next(seq18466);\nvar G__18468 \x3d cljs.core.first(seq18466__$1);\nvar seq18466__$2 \x3d cljs.core.next(seq18466__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18467,G__18468,seq18466__$2);\n}));\n\n(cljs.core.conj.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns an empty collection of the same category as coll, or nil\n */\ncljs.core.empty \x3d (function cljs$core$empty(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (4))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IEmptyableCollection$))))?true:false):false)){\nreturn coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (4))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){\nreturn cljs.core._empty(coll);\n} else {\nreturn null;\n\n}\n}\n}\n});\ncljs.core.accumulating_seq_count \x3d (function cljs$core$accumulating_seq_count(coll){\nvar s \x3d cljs.core.seq(coll);\nvar acc \x3d (0);\nwhile(true){\nif(cljs.core.counted_QMARK_(s)){\nreturn (acc + cljs.core._count(s));\n} else {\nvar G__20531 \x3d cljs.core.next(s);\nvar G__20532 \x3d (acc + (1));\ns \x3d G__20531;\nacc \x3d G__20532;\ncontinue;\n}\nbreak;\n}\n});\n/**\n * Returns the number of items in the collection. (count nil) returns\n *   0.  Also works on strings, arrays, and Maps\n */\ncljs.core.count \x3d (function cljs$core$count(coll){\nif((!((coll \x3d\x3d null)))){\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (2))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ICounted$))))?true:false):false)){\nreturn coll.cljs$core$ICounted$_count$arity$1(null);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn coll.length;\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn coll.length;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (8388608))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeqable$))))?true:false):false)){\nreturn cljs.core.accumulating_seq_count(coll);\n} else {\nreturn cljs.core._count(coll);\n\n}\n}\n}\n}\n} else {\nreturn (0);\n}\n});\ncljs.core.linear_traversal_nth \x3d (function cljs$core$linear_traversal_nth(var_args){\nvar G__18475 \x3d arguments.length;\nswitch (G__18475) {\ncase 2:\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,n){\nwhile(true){\nif((coll \x3d\x3d null)){\nthrow (new Error(\x22Index out of bounds\x22));\n} else {\nif((n \x3d\x3d\x3d (0))){\nif(cljs.core.seq(coll)){\nreturn cljs.core.first(coll);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n} else {\nif(cljs.core.indexed_QMARK_(coll)){\nreturn cljs.core._nth(coll,n);\n} else {\nif(cljs.core.seq(coll)){\nvar G__20537 \x3d cljs.core.next(coll);\nvar G__20538 \x3d (n - (1));\ncoll \x3d G__20537;\nn \x3d G__20538;\ncontinue;\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n\n}\n}\n}\n}\nbreak;\n}\n}));\n\n(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,n,not_found){\nwhile(true){\nif((coll \x3d\x3d null)){\nreturn not_found;\n} else {\nif((n \x3d\x3d\x3d (0))){\nif(cljs.core.seq(coll)){\nreturn cljs.core.first(coll);\n} else {\nreturn not_found;\n}\n} else {\nif(cljs.core.indexed_QMARK_(coll)){\nreturn cljs.core._nth(coll,n,not_found);\n} else {\nif(cljs.core.seq(coll)){\nvar G__20542 \x3d cljs.core.next(coll);\nvar G__20543 \x3d (n - (1));\nvar G__20544 \x3d not_found;\ncoll \x3d G__20542;\nn \x3d G__20543;\nnot_found \x3d G__20544;\ncontinue;\n} else {\nreturn not_found;\n\n}\n}\n}\n}\nbreak;\n}\n}));\n\n(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity \x3d 3);\n\n/**\n * Returns the value at the index. get returns nil if index out of\n *   bounds, nth throws an exception unless not-found is supplied.  nth\n *   also works for strings, arrays, regex Matchers and Lists, and,\n *   in O(n) time, for sequences.\n */\ncljs.core.nth \x3d (function cljs$core$nth(var_args){\nvar G__18477 \x3d arguments.length;\nswitch (G__18477) {\ncase 2:\nreturn cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,n){\nif((!(typeof n \x3d\x3d\x3d \x27number\x27))){\nthrow (new Error(\x22Index argument to nth must be a number\x22));\n} else {\nif((coll \x3d\x3d null)){\nreturn coll;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IIndexed$))))?true:false):false)){\nreturn coll.cljs$core$IIndexed$_nth$arity$2(null,n);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nif(((((-1) \x3c n)) \x26\x26 ((n \x3c coll.length)))){\nreturn (coll[(n | (0))]);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nif(((((-1) \x3c n)) \x26\x26 ((n \x3c coll.length)))){\nreturn coll.charAt((n | (0)));\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n} else {\nif((function (){var or__4120__auto__ \x3d (((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nif((!((coll \x3d\x3d null)))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16777216))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISequential$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n}\n})()){\nif((n \x3c (0))){\nthrow (new Error(\x22Index out of bounds\x22));\n} else {\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){\nreturn cljs.core._nth(coll,n);\n} else {\nthrow (new Error([\x22nth not supported on this type \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n}\n}\n}));\n\n(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,n,not_found){\nif((!(typeof n \x3d\x3d\x3d \x27number\x27))){\nthrow (new Error(\x22Index argument to nth must be a number.\x22));\n} else {\nif((coll \x3d\x3d null)){\nreturn not_found;\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IIndexed$))))?true:false):false)){\nreturn coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nif(((((-1) \x3c n)) \x26\x26 ((n \x3c coll.length)))){\nreturn (coll[(n | (0))]);\n} else {\nreturn not_found;\n}\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nif(((((-1) \x3c n)) \x26\x26 ((n \x3c coll.length)))){\nreturn coll.charAt((n | (0)));\n} else {\nreturn not_found;\n}\n} else {\nif((function (){var or__4120__auto__ \x3d (((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nif((!((coll \x3d\x3d null)))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16777216))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISequential$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n}\n})()){\nif((n \x3c (0))){\nreturn not_found;\n} else {\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){\nreturn cljs.core._nth(coll,n,not_found);\n} else {\nthrow (new Error([\x22nth not supported on this type \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n}\n}\n}));\n\n(cljs.core.nth.cljs$lang$maxFixedArity \x3d 3);\n\n/**\n * Returns the nth rest of coll, coll when n is 0.\n */\ncljs.core.nthrest \x3d (function cljs$core$nthrest(coll,n){\nvar n__$1 \x3d n;\nvar xs \x3d coll;\nwhile(true){\nvar temp__5733__auto__ \x3d (((n__$1 \x3e (0))) \x26\x26 (cljs.core.seq(xs)));\nif(temp__5733__auto__){\nvar xs__$1 \x3d temp__5733__auto__;\nvar G__20550 \x3d (n__$1 - (1));\nvar G__20551 \x3d cljs.core.rest(xs__$1);\nn__$1 \x3d G__20550;\nxs \x3d G__20551;\ncontinue;\n} else {\nreturn xs;\n}\nbreak;\n}\n});\n/**\n * Returns the value mapped to key, not-found or nil if key not present.\n */\ncljs.core.get \x3d (function cljs$core$get(var_args){\nvar G__18487 \x3d arguments.length;\nswitch (G__18487) {\ncase 2:\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.get.cljs$core$IFn$_invoke$arity$2 \x3d (function (o,k){\nif((o \x3d\x3d null)){\nreturn null;\n} else {\nif((((!((o \x3d\x3d null))))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (256))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$ILookup$))))?true:false):false)){\nreturn o.cljs$core$ILookup$_lookup$arity$2(null,k);\n} else {\nif(cljs.core.array_QMARK_(o)){\nif((((!((k \x3d\x3d null)))) \x26\x26 ((k \x3c o.length)))){\nreturn (o[(k | (0))]);\n} else {\nreturn null;\n}\n} else {\nif(typeof o \x3d\x3d\x3d \x27string\x27){\nif((((!((k \x3d\x3d null)))) \x26\x26 (((((-1) \x3c k)) \x26\x26 ((k \x3c o.length)))))){\nreturn o.charAt((k | (0)));\n} else {\nreturn null;\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){\nreturn cljs.core._lookup(o,k);\n} else {\nreturn null;\n\n}\n}\n}\n}\n}\n}));\n\n(cljs.core.get.cljs$core$IFn$_invoke$arity$3 \x3d (function (o,k,not_found){\nif((!((o \x3d\x3d null)))){\nif((((!((o \x3d\x3d null))))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (256))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$ILookup$))))?true:false):false)){\nreturn o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);\n} else {\nif(cljs.core.array_QMARK_(o)){\nif((((!((k \x3d\x3d null)))) \x26\x26 (((((-1) \x3c k)) \x26\x26 ((k \x3c o.length)))))){\nreturn (o[(k | (0))]);\n} else {\nreturn not_found;\n}\n} else {\nif(typeof o \x3d\x3d\x3d \x27string\x27){\nif((((!((k \x3d\x3d null)))) \x26\x26 (((((-1) \x3c k)) \x26\x26 ((k \x3c o.length)))))){\nreturn o.charAt((k | (0)));\n} else {\nreturn not_found;\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){\nreturn cljs.core._lookup(o,k,not_found);\n} else {\nreturn not_found;\n\n}\n}\n}\n}\n} else {\nreturn not_found;\n}\n}));\n\n(cljs.core.get.cljs$lang$maxFixedArity \x3d 3);\n\n\n\n/**\n * assoc[iate]. When applied to a map, returns a new map of the\n * same (hashed/sorted) type, that contains the mapping of key(s) to\n * val(s). When applied to a vector, returns a new vector that\n * contains val at index. Note - index must be \x3c\x3d (count vector).\n */\ncljs.core.assoc \x3d (function cljs$core$assoc(var_args){\nvar G__18495 \x3d arguments.length;\nswitch (G__18495) {\ncase 3:\nreturn cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20566 \x3d arguments.length;\nvar i__4731__auto___20567 \x3d (0);\nwhile(true){\nif((i__4731__auto___20567 \x3c len__4730__auto___20566)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20567]));\n\nvar G__20568 \x3d (i__4731__auto___20567 + (1));\ni__4731__auto___20567 \x3d G__20568;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));\nreturn cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,k,v){\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (512))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IAssociative$))))?true:false):false)){\nreturn coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);\n} else {\nif((!((coll \x3d\x3d null)))){\nreturn cljs.core._assoc(coll,k,v);\n} else {\nreturn cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);\n}\n}\n}));\n\n(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,k,v,kvs){\nwhile(true){\nvar ret \x3d cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);\nif(cljs.core.truth_(kvs)){\nvar G__20571 \x3d ret;\nvar G__20572 \x3d cljs.core.first(kvs);\nvar G__20573 \x3d cljs.core.second(kvs);\nvar G__20574 \x3d cljs.core.nnext(kvs);\ncoll \x3d G__20571;\nk \x3d G__20572;\nv \x3d G__20573;\nkvs \x3d G__20574;\ncontinue;\n} else {\nreturn ret;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.assoc.cljs$lang$applyTo \x3d (function (seq18491){\nvar G__18492 \x3d cljs.core.first(seq18491);\nvar seq18491__$1 \x3d cljs.core.next(seq18491);\nvar G__18493 \x3d cljs.core.first(seq18491__$1);\nvar seq18491__$2 \x3d cljs.core.next(seq18491__$1);\nvar G__18494 \x3d cljs.core.first(seq18491__$2);\nvar seq18491__$3 \x3d cljs.core.next(seq18491__$2);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18492,G__18493,G__18494,seq18491__$3);\n}));\n\n(cljs.core.assoc.cljs$lang$maxFixedArity \x3d (3));\n\n/**\n * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n *   that does not contain a mapping for key(s).\n */\ncljs.core.dissoc \x3d (function cljs$core$dissoc(var_args){\nvar G__18501 \x3d arguments.length;\nswitch (G__18501) {\ncase 1:\nreturn cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20576 \x3d arguments.length;\nvar i__4731__auto___20577 \x3d (0);\nwhile(true){\nif((i__4731__auto___20577 \x3c len__4730__auto___20576)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20577]));\n\nvar G__20580 \x3d (i__4731__auto___20577 + (1));\ni__4731__auto___20577 \x3d G__20580;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn coll;\n}));\n\n(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,k){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._dissoc(coll,k);\n}\n}));\n\n(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,k,ks){\nwhile(true){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nvar ret \x3d cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);\nif(cljs.core.truth_(ks)){\nvar G__20581 \x3d ret;\nvar G__20582 \x3d cljs.core.first(ks);\nvar G__20583 \x3d cljs.core.next(ks);\ncoll \x3d G__20581;\nk \x3d G__20582;\nks \x3d G__20583;\ncontinue;\n} else {\nreturn ret;\n}\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.dissoc.cljs$lang$applyTo \x3d (function (seq18498){\nvar G__18499 \x3d cljs.core.first(seq18498);\nvar seq18498__$1 \x3d cljs.core.next(seq18498);\nvar G__18500 \x3d cljs.core.first(seq18498__$1);\nvar seq18498__$2 \x3d cljs.core.next(seq18498__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18499,G__18500,seq18498__$2);\n}));\n\n(cljs.core.dissoc.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Return true if f is a JavaScript function or satisfies the Fn protocol.\n */\ncljs.core.fn_QMARK_ \x3d (function cljs$core$fn_QMARK_(f){\nvar or__4120__auto__ \x3d goog.isFunction(f);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nif((!((f \x3d\x3d null)))){\nif(((false) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d f.cljs$core$Fn$)))){\nreturn true;\n} else {\nif((!f.cljs$lang$protocol_mask$partition$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);\n}\n}\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.Fn}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.MetaFn \x3d (function (afn,meta){\nthis.afn \x3d afn;\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 393217;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_,new_meta){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.MetaFn(self__.afn,new_meta));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$Fn$ \x3d cljs.core.PROTOCOL_SENTINEL);\n\n(cljs.core.MetaFn.prototype.call \x3d (function (unused__10738__auto__){\nvar self__ \x3d this;\nvar self__ \x3d this;\nvar G__18505 \x3d (arguments.length - (1));\nswitch (G__18505) {\ncase (0):\nreturn self__.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase (1):\nreturn self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));\n\nbreak;\ncase (2):\nreturn self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase (3):\nreturn self__.cljs$core$IFn$_invoke$arity$3((arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase (4):\nreturn self__.cljs$core$IFn$_invoke$arity$4((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase (5):\nreturn self__.cljs$core$IFn$_invoke$arity$5((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ncase (6):\nreturn self__.cljs$core$IFn$_invoke$arity$6((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));\n\nbreak;\ncase (7):\nreturn self__.cljs$core$IFn$_invoke$arity$7((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));\n\nbreak;\ncase (8):\nreturn self__.cljs$core$IFn$_invoke$arity$8((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));\n\nbreak;\ncase (9):\nreturn self__.cljs$core$IFn$_invoke$arity$9((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));\n\nbreak;\ncase (10):\nreturn self__.cljs$core$IFn$_invoke$arity$10((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));\n\nbreak;\ncase (11):\nreturn self__.cljs$core$IFn$_invoke$arity$11((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));\n\nbreak;\ncase (12):\nreturn self__.cljs$core$IFn$_invoke$arity$12((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));\n\nbreak;\ncase (13):\nreturn self__.cljs$core$IFn$_invoke$arity$13((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));\n\nbreak;\ncase (14):\nreturn self__.cljs$core$IFn$_invoke$arity$14((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));\n\nbreak;\ncase (15):\nreturn self__.cljs$core$IFn$_invoke$arity$15((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));\n\nbreak;\ncase (16):\nreturn self__.cljs$core$IFn$_invoke$arity$16((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));\n\nbreak;\ncase (17):\nreturn self__.cljs$core$IFn$_invoke$arity$17((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));\n\nbreak;\ncase (18):\nreturn self__.cljs$core$IFn$_invoke$arity$18((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));\n\nbreak;\ncase (19):\nreturn self__.cljs$core$IFn$_invoke$arity$19((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));\n\nbreak;\ncase (20):\nreturn self__.cljs$core$IFn$_invoke$arity$20((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));\n\nbreak;\ncase (21):\nreturn self__.cljs$core$IFn$_invoke$arity$21((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join(\x27\x27)));\n\n}\n}));\n\n(cljs.core.MetaFn.prototype.apply \x3d (function (self__,args18504){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18504)));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (a){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (a,b){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 \x3d (function (a,b,c){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 \x3d (function (a,b,c,d){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 \x3d (function (a,b,c,d,e){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 \x3d (function (a,b,c,d,e,f){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 \x3d (function (a,b,c,d,e,f,g){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 \x3d (function (a,b,c,d,e,f,g,h){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 \x3d (function (a,b,c,d,e,f,g,h,i){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 \x3d (function (a,b,c,d,e,f,g,h,i,j){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 \x3d (function (a,b,c,d,e,f,g,h,i,j,k){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n}));\n\n(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n}));\n\n(cljs.core.MetaFn.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22afn\x22,\x22afn\x22,216963467,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n}));\n\n(cljs.core.MetaFn.cljs$lang$type \x3d true);\n\n(cljs.core.MetaFn.cljs$lang$ctorStr \x3d \x22cljs.core/MetaFn\x22);\n\n(cljs.core.MetaFn.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/MetaFn\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/MetaFn.\n */\ncljs.core.__GT_MetaFn \x3d (function cljs$core$__GT_MetaFn(afn,meta){\nreturn (new cljs.core.MetaFn(afn,meta));\n});\n\n/**\n * Returns an object of the same type and value as obj, with\n *   map m as its metadata.\n */\ncljs.core.with_meta \x3d (function cljs$core$with_meta(o,meta){\nif(goog.isFunction(o)){\nreturn (new cljs.core.MetaFn(o,meta));\n} else {\nif((o \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._with_meta(o,meta);\n}\n}\n});\n/**\n * Returns the metadata of obj, returns nil if there is no metadata.\n */\ncljs.core.meta \x3d (function cljs$core$meta(o){\nif((((!((o \x3d\x3d null))))?(((!((o \x3d\x3d null))))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (131072))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$IMeta$))))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o)):false)){\nreturn cljs.core._meta(o);\n} else {\nreturn null;\n}\n});\n/**\n * For a list or queue, same as first, for a vector, same as, but much\n *   more efficient than, last. If the collection is empty, returns nil.\n */\ncljs.core.peek \x3d (function cljs$core$peek(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._peek(coll);\n}\n});\n/**\n * For a list or queue, returns a new list/queue without the first\n *   item, for a vector, returns a new vector without the last item.\n *   Note - not the same as next/butlast.\n */\ncljs.core.pop \x3d (function cljs$core$pop(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._pop(coll);\n}\n});\n/**\n * disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n *   does not contain key(s).\n */\ncljs.core.disj \x3d (function cljs$core$disj(var_args){\nvar G__18512 \x3d arguments.length;\nswitch (G__18512) {\ncase 1:\nreturn cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20588 \x3d arguments.length;\nvar i__4731__auto___20589 \x3d (0);\nwhile(true){\nif((i__4731__auto___20589 \x3c len__4730__auto___20588)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20589]));\n\nvar G__20591 \x3d (i__4731__auto___20589 + (1));\ni__4731__auto___20589 \x3d G__20591;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn coll;\n}));\n\n(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,k){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._disjoin(coll,k);\n}\n}));\n\n(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,k,ks){\nwhile(true){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nvar ret \x3d cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);\nif(cljs.core.truth_(ks)){\nvar G__20592 \x3d ret;\nvar G__20593 \x3d cljs.core.first(ks);\nvar G__20594 \x3d cljs.core.next(ks);\ncoll \x3d G__20592;\nk \x3d G__20593;\nks \x3d G__20594;\ncontinue;\n} else {\nreturn ret;\n}\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.disj.cljs$lang$applyTo \x3d (function (seq18509){\nvar G__18510 \x3d cljs.core.first(seq18509);\nvar seq18509__$1 \x3d cljs.core.next(seq18509);\nvar G__18511 \x3d cljs.core.first(seq18509__$1);\nvar seq18509__$2 \x3d cljs.core.next(seq18509__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18510,G__18511,seq18509__$2);\n}));\n\n(cljs.core.disj.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns true if coll has no items - same as (not (seq coll)).\n *   Please use the idiom (seq x) rather than (not (empty? x))\n */\ncljs.core.empty_QMARK_ \x3d (function cljs$core$empty_QMARK_(coll){\nreturn (((coll \x3d\x3d null)) || (cljs.core.not(cljs.core.seq(coll))));\n});\n/**\n * Returns true if x satisfies ICollection\n */\ncljs.core.coll_QMARK_ \x3d (function cljs$core$coll_QMARK_(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (8))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ICollection$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);\n}\n}\n});\n/**\n * Returns true if x satisfies ISet\n */\ncljs.core.set_QMARK_ \x3d (function cljs$core$set_QMARK_(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (4096))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ISet$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);\n}\n}\n});\n/**\n * Returns true if coll implements IAssociative\n */\ncljs.core.associative_QMARK_ \x3d (function cljs$core$associative_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (512))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IAssociative$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);\n}\n});\n/**\n * Returns true if coll implements IFind\n */\ncljs.core.ifind_QMARK_ \x3d (function cljs$core$ifind_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif(((false) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IFind$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);\n}\n});\n/**\n * Returns true if coll satisfies ISequential\n */\ncljs.core.sequential_QMARK_ \x3d (function cljs$core$sequential_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (16777216))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ISequential$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);\n}\n});\n/**\n * Returns true if coll satisfies ISorted\n */\ncljs.core.sorted_QMARK_ \x3d (function cljs$core$sorted_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (268435456))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ISorted$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);\n}\n});\n/**\n * Returns true if coll satisfies IReduce\n */\ncljs.core.reduceable_QMARK_ \x3d (function cljs$core$reduceable_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (524288))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IReduce$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);\n}\n});\n/**\n * Return true if x satisfies IMap\n */\ncljs.core.map_QMARK_ \x3d (function cljs$core$map_QMARK_(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (1024))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IMap$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);\n}\n}\n});\n/**\n * Return true if x satisfies IRecord\n */\ncljs.core.record_QMARK_ \x3d (function cljs$core$record_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (67108864))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IRecord$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);\n}\n});\n/**\n * Return true if x satisfies IVector\n */\ncljs.core.vector_QMARK_ \x3d (function cljs$core$vector_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (16384))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IVector$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);\n}\n});\n\n/**\n * Return true if x satisfies IChunkedSeq.\n */\ncljs.core.chunked_seq_QMARK_ \x3d (function cljs$core$chunked_seq_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition1$ \x26 (512))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IChunkedSeq$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n});\n/**\n * Create JavaSript object from an even number arguments representing\n *   interleaved keys and values.\n */\ncljs.core.js_obj \x3d (function cljs$core$js_obj(var_args){\nvar G__18526 \x3d arguments.length;\nswitch (G__18526) {\ncase 0:\nreturn cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20632 \x3d arguments.length;\nvar i__4731__auto___20633 \x3d (0);\nwhile(true){\nif((i__4731__auto___20633 \x3c len__4730__auto___20632)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20633]));\n\nvar G__20634 \x3d (i__4731__auto___20633 + (1));\ni__4731__auto___20633 \x3d G__20634;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((0)),(0),null));\nreturn cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn ({});\n}));\n\n(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic \x3d (function (keyvals){\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));\n}));\n\n/** @this {Function} */\n(cljs.core.js_obj.cljs$lang$applyTo \x3d (function (seq18525){\nvar self__4718__auto__ \x3d this;\nreturn self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18525));\n}));\n\n(cljs.core.js_obj.cljs$lang$maxFixedArity \x3d (0));\n\n/**\n * Return the JavaScript keys for an object.\n */\ncljs.core.js_keys \x3d (function cljs$core$js_keys(obj){\nreturn goog.object.getKeys(obj);\n});\n/**\n * Delete a property from a JavaScript object.\n *   Returns true upon success, false otherwise.\n */\ncljs.core.js_delete \x3d (function cljs$core$js_delete(obj,key){\nreturn delete obj[key];\n});\ncljs.core.array_copy \x3d (function cljs$core$array_copy(from,i,to,j,len){\nvar i__$1 \x3d i;\nvar j__$1 \x3d j;\nvar len__$1 \x3d len;\nwhile(true){\nif((len__$1 \x3d\x3d\x3d (0))){\nreturn to;\n} else {\n(to[j__$1] \x3d (from[i__$1]));\n\nvar G__20635 \x3d (i__$1 + (1));\nvar G__20636 \x3d (j__$1 + (1));\nvar G__20637 \x3d (len__$1 - (1));\ni__$1 \x3d G__20635;\nj__$1 \x3d G__20636;\nlen__$1 \x3d G__20637;\ncontinue;\n}\nbreak;\n}\n});\ncljs.core.array_copy_downward \x3d (function cljs$core$array_copy_downward(from,i,to,j,len){\nvar i__$1 \x3d (i + (len - (1)));\nvar j__$1 \x3d (j + (len - (1)));\nvar len__$1 \x3d len;\nwhile(true){\nif((len__$1 \x3d\x3d\x3d (0))){\nreturn to;\n} else {\n(to[j__$1] \x3d (from[i__$1]));\n\nvar G__20638 \x3d (i__$1 - (1));\nvar G__20639 \x3d (j__$1 - (1));\nvar G__20640 \x3d (len__$1 - (1));\ni__$1 \x3d G__20638;\nj__$1 \x3d G__20639;\nlen__$1 \x3d G__20640;\ncontinue;\n}\nbreak;\n}\n});\ncljs.core.lookup_sentinel \x3d ({});\n/**\n * Returns true if x is the value false, false otherwise.\n */\ncljs.core.false_QMARK_ \x3d (function cljs$core$false_QMARK_(x){\nreturn x \x3d\x3d\x3d false;\n});\n/**\n * Returns true if x is the value true, false otherwise.\n */\ncljs.core.true_QMARK_ \x3d (function cljs$core$true_QMARK_(x){\nreturn x \x3d\x3d\x3d true;\n});\n/**\n * Return true if x is a Boolean\n */\ncljs.core.boolean_QMARK_ \x3d (function cljs$core$boolean_QMARK_(x){\nreturn ((x \x3d\x3d\x3d true) || (x \x3d\x3d\x3d false));\n});\n/**\n * Returns true if x identical to the JavaScript undefined value.\n */\ncljs.core.undefined_QMARK_ \x3d (function cljs$core$undefined_QMARK_(x){\nreturn (void 0 \x3d\x3d\x3d x);\n});\n/**\n * Return true if s satisfies ISeq\n */\ncljs.core.seq_QMARK_ \x3d (function cljs$core$seq_QMARK_(s){\nif((s \x3d\x3d null)){\nreturn false;\n} else {\nif((!((s \x3d\x3d null)))){\nif((((s.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d s.cljs$core$ISeq$)))){\nreturn true;\n} else {\nif((!s.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);\n}\n}\n});\n/**\n * Return true if the seq function is supported for s\n */\ncljs.core.seqable_QMARK_ \x3d (function cljs$core$seqable_QMARK_(s){\nvar or__4120__auto__ \x3d (s \x3d\x3d null);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nvar or__4120__auto____$1 \x3d (((!((s \x3d\x3d null))))?(((((s.cljs$lang$protocol_mask$partition0$ \x26 (8388608))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));\nif(or__4120__auto____$1){\nreturn or__4120__auto____$1;\n} else {\nreturn ((cljs.core.array_QMARK_(s)) || (typeof s \x3d\x3d\x3d \x27string\x27));\n}\n}\n});\n/**\n * Coerce to boolean\n */\ncljs.core.boolean$ \x3d (function cljs$core$boolean(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif(x \x3d\x3d\x3d false){\nreturn false;\n} else {\nreturn true;\n\n}\n}\n});\n/**\n * Returns true if f returns true for fn? or satisfies IFn.\n */\ncljs.core.ifn_QMARK_ \x3d (function cljs$core$ifn_QMARK_(f){\nvar or__4120__auto__ \x3d cljs.core.fn_QMARK_(f);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nif((!((f \x3d\x3d null)))){\nif((((f.cljs$lang$protocol_mask$partition0$ \x26 (1))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d f.cljs$core$IFn$)))){\nreturn true;\n} else {\nif((!f.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);\n}\n}\n});\n/**\n * Returns true if n is a JavaScript number with no decimal part.\n */\ncljs.core.integer_QMARK_ \x3d (function cljs$core$integer_QMARK_(n){\nreturn ((typeof n \x3d\x3d\x3d \x27number\x27) \x26\x26 ((!(isNaN(n)))) \x26\x26 ((!((n \x3d\x3d\x3d Infinity)))) \x26\x26 ((parseFloat(n) \x3d\x3d\x3d parseInt(n,(10)))));\n});\n/**\n * Return true if x satisfies integer? or is an instance of goog.math.Integer\n * or goog.math.Long.\n */\ncljs.core.int_QMARK_ \x3d (function cljs$core$int_QMARK_(x){\nreturn ((cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long)));\n});\n/**\n * Return true if x satisfies int? and is positive.\n */\ncljs.core.pos_int_QMARK_ \x3d (function cljs$core$pos_int_QMARK_(x){\nif(cljs.core.integer_QMARK_(x)){\nreturn (x \x3e (0));\n} else {\nif((x instanceof goog.math.Integer)){\nreturn ((cljs.core.not(x.isNegative())) \x26\x26 (cljs.core.not(x.isZero())));\n} else {\nif((x instanceof goog.math.Long)){\nreturn ((cljs.core.not(x.isNegative())) \x26\x26 (cljs.core.not(x.isZero())));\n} else {\nreturn false;\n\n}\n}\n}\n});\n/**\n * Return true if x satisfies int? and is negative.\n */\ncljs.core.neg_int_QMARK_ \x3d (function cljs$core$neg_int_QMARK_(x){\nif(cljs.core.integer_QMARK_(x)){\nreturn (x \x3c (0));\n} else {\nif((x instanceof goog.math.Integer)){\nreturn x.isNegative();\n} else {\nif((x instanceof goog.math.Long)){\nreturn x.isNegative();\n} else {\nreturn false;\n\n}\n}\n}\n});\n/**\n * Return true if x satisfies int? and is a natural integer value.\n */\ncljs.core.nat_int_QMARK_ \x3d (function cljs$core$nat_int_QMARK_(x){\nif(cljs.core.integer_QMARK_(x)){\nreturn (!((x \x3c (0))));\n} else {\nif((x instanceof goog.math.Integer)){\nreturn cljs.core.not(x.isNegative());\n} else {\nif((x instanceof goog.math.Long)){\nreturn cljs.core.not(x.isNegative());\n} else {\nreturn false;\n\n}\n}\n}\n});\n/**\n * Returns true for JavaScript numbers, false otherwise.\n */\ncljs.core.float_QMARK_ \x3d (function cljs$core$float_QMARK_(x){\nreturn typeof x \x3d\x3d\x3d \x27number\x27;\n});\n/**\n * Returns true for JavaScript numbers, false otherwise.\n */\ncljs.core.double_QMARK_ \x3d (function cljs$core$double_QMARK_(x){\nreturn typeof x \x3d\x3d\x3d \x27number\x27;\n});\n/**\n * Returns true for Infinity and -Infinity values.\n */\ncljs.core.infinite_QMARK_ \x3d (function cljs$core$infinite_QMARK_(x){\nreturn (((x \x3d\x3d\x3d Number.POSITIVE_INFINITY)) || ((x \x3d\x3d\x3d Number.NEGATIVE_INFINITY)));\n});\n/**\n * Returns true if key is present in the given collection, otherwise\n *   returns false.  Note that for numerically indexed collections like\n *   vectors and arrays, this tests if the numeric key is within the\n *   range of indexes. \x27contains?\x27 operates constant or logarithmic time;\n *   it will not perform a linear search for a value.  See also \x27some\x27.\n */\ncljs.core.contains_QMARK_ \x3d (function cljs$core$contains_QMARK_(coll,v){\nif((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) \x3d\x3d\x3d cljs.core.lookup_sentinel)){\nreturn false;\n} else {\nreturn true;\n}\n});\n/**\n * Returns the map entry for key, or nil if key not present.\n */\ncljs.core.find \x3d (function cljs$core$find(coll,k){\nif(cljs.core.ifind_QMARK_(coll)){\nreturn cljs.core._find(coll,k);\n} else {\nif((((!((coll \x3d\x3d null)))) \x26\x26 (cljs.core.associative_QMARK_(coll)) \x26\x26 (cljs.core.contains_QMARK_(coll,k)))){\nreturn (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));\n} else {\nreturn null;\n}\n}\n});\n/**\n * Returns true if no two of the arguments are \x3d\n */\ncljs.core.distinct_QMARK_ \x3d (function cljs$core$distinct_QMARK_(var_args){\nvar G__18541 \x3d arguments.length;\nswitch (G__18541) {\ncase 1:\nreturn cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20642 \x3d arguments.length;\nvar i__4731__auto___20643 \x3d (0);\nwhile(true){\nif((i__4731__auto___20643 \x3c len__4730__auto___20642)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20643]));\n\nvar G__20644 \x3d (i__4731__auto___20643 + (1));\ni__4731__auto___20643 \x3d G__20644;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));\n}));\n\n(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nif((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){\nvar s \x3d cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);\nvar xs \x3d more;\nwhile(true){\nvar x__$1 \x3d cljs.core.first(xs);\nvar etc \x3d cljs.core.next(xs);\nif(cljs.core.truth_(xs)){\nif(cljs.core.contains_QMARK_(s,x__$1)){\nreturn false;\n} else {\nvar G__20645 \x3d cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);\nvar G__20646 \x3d etc;\ns \x3d G__20645;\nxs \x3d G__20646;\ncontinue;\n}\n} else {\nreturn true;\n}\nbreak;\n}\n} else {\nreturn false;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.distinct_QMARK_.cljs$lang$applyTo \x3d (function (seq18538){\nvar G__18539 \x3d cljs.core.first(seq18538);\nvar seq18538__$1 \x3d cljs.core.next(seq18538);\nvar G__18540 \x3d cljs.core.first(seq18538__$1);\nvar seq18538__$2 \x3d cljs.core.next(seq18538__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18539,G__18540,seq18538__$2);\n}));\n\n(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Comparator. Returns a negative number, zero, or a positive number\n *   when x is logically \x27less than\x27, \x27equal to\x27, or \x27greater than\x27\n *   y. Uses IComparable if available and google.array.defaultCompare for objects\n *  of the same type and special-cases nil to be less than any other object.\n */\ncljs.core.compare \x3d (function cljs$core$compare(x,y){\nif((x \x3d\x3d\x3d y)){\nreturn (0);\n} else {\nif((x \x3d\x3d null)){\nreturn (-1);\n} else {\nif((y \x3d\x3d null)){\nreturn (1);\n} else {\nif(typeof x \x3d\x3d\x3d \x27number\x27){\nif(typeof y \x3d\x3d\x3d \x27number\x27){\nreturn goog.array.defaultCompare(x,y);\n} else {\nthrow (new Error([\x22Cannot compare \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),\x22 to \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(\x27\x27)));\n}\n} else {\nif((((!((x \x3d\x3d null))))?(((((x.cljs$lang$protocol_mask$partition1$ \x26 (2048))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){\nreturn cljs.core._compare(x,y);\n} else {\nif(((((typeof x \x3d\x3d\x3d \x27string\x27) || (cljs.core.array_QMARK_(x)) || (x \x3d\x3d\x3d true) || (x \x3d\x3d\x3d false))) \x26\x26 ((cljs.core.type(x) \x3d\x3d\x3d cljs.core.type(y))))){\nreturn goog.array.defaultCompare(x,y);\n} else {\nthrow (new Error([\x22Cannot compare \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),\x22 to \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(\x27\x27)));\n}\n\n}\n}\n}\n}\n}\n});\n/**\n * Compare indexed collection.\n */\ncljs.core.compare_indexed \x3d (function cljs$core$compare_indexed(var_args){\nvar G__18544 \x3d arguments.length;\nswitch (G__18544) {\ncase 2:\nreturn cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 4:\nreturn cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 \x3d (function (xs,ys){\nvar xl \x3d cljs.core.count(xs);\nvar yl \x3d cljs.core.count(ys);\nif((xl \x3c yl)){\nreturn (-1);\n} else {\nif((xl \x3e yl)){\nreturn (1);\n} else {\nif((xl \x3d\x3d\x3d (0))){\nreturn (0);\n} else {\nreturn cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));\n\n}\n}\n}\n}));\n\n(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 \x3d (function (xs,ys,len,n){\nwhile(true){\nvar d \x3d cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));\nif((((d \x3d\x3d\x3d (0))) \x26\x26 (((n + (1)) \x3c len)))){\nvar G__20648 \x3d xs;\nvar G__20649 \x3d ys;\nvar G__20650 \x3d len;\nvar G__20651 \x3d (n + (1));\nxs \x3d G__20648;\nys \x3d G__20649;\nlen \x3d G__20650;\nn \x3d G__20651;\ncontinue;\n} else {\nreturn d;\n}\nbreak;\n}\n}));\n\n(cljs.core.compare_indexed.cljs$lang$maxFixedArity \x3d 4);\n\n/**\n * Given a fn that might be boolean valued or a comparator,\n * return a fn that is a comparator.\n */\ncljs.core.fn__GT_comparator \x3d (function cljs$core$fn__GT_comparator(f){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){\nreturn cljs.core.compare;\n} else {\nreturn (function (x,y){\nvar r \x3d (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));\nif(typeof r \x3d\x3d\x3d \x27number\x27){\nreturn r;\n} else {\nif(cljs.core.truth_(r)){\nreturn (-1);\n} else {\nif(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){\nreturn (1);\n} else {\nreturn (0);\n}\n}\n}\n});\n}\n});\n/**\n * Returns a sorted sequence of the items in coll. Comp can be\n * boolean-valued comparison function, or a -/0/+ valued comparator.\n * Comp defaults to compare.\n */\ncljs.core.sort \x3d (function cljs$core$sort(var_args){\nvar G__18546 \x3d arguments.length;\nswitch (G__18546) {\ncase 1:\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);\n}));\n\n(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 \x3d (function (comp,coll){\nif(cljs.core.seq(coll)){\nvar a \x3d (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));\ngoog.array.stableSort(a,cljs.core.fn__GT_comparator(comp));\n\nreturn cljs.core.seq(a);\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}));\n\n(cljs.core.sort.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Returns a sorted sequence of the items in coll, where the sort\n * order is determined by comparing (keyfn item).  Comp can be\n * boolean-valued comparison function, or a -/0/+ valued comparator.\n * Comp defaults to compare.\n */\ncljs.core.sort_by \x3d (function cljs$core$sort_by(var_args){\nvar G__18548 \x3d arguments.length;\nswitch (G__18548) {\ncase 2:\nreturn cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 \x3d (function (keyfn,coll){\nreturn cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);\n}));\n\n(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 \x3d (function (keyfn,comp,coll){\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){\nvar G__18550 \x3d (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));\nvar G__18551 \x3d (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));\nvar fexpr__18549 \x3d cljs.core.fn__GT_comparator(comp);\nreturn (fexpr__18549.cljs$core$IFn$_invoke$arity$2 ? fexpr__18549.cljs$core$IFn$_invoke$arity$2(G__18550,G__18551) : fexpr__18549.call(null,G__18550,G__18551));\n}),coll);\n}));\n\n(cljs.core.sort_by.cljs$lang$maxFixedArity \x3d 3);\n\ncljs.core.seq_reduce \x3d (function cljs$core$seq_reduce(var_args){\nvar G__18553 \x3d arguments.length;\nswitch (G__18553) {\ncase 2:\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,coll){\nvar temp__5733__auto__ \x3d cljs.core.seq(coll);\nif(temp__5733__auto__){\nvar s \x3d temp__5733__auto__;\nvar G__18554 \x3d f;\nvar G__18555 \x3d cljs.core.first(s);\nvar G__18556 \x3d cljs.core.next(s);\nreturn (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__18554,G__18555,G__18556) : cljs.core.reduce.call(null,G__18554,G__18555,G__18556));\n} else {\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n}\n}));\n\n(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,val,coll){\nvar val__$1 \x3d val;\nvar coll__$1 \x3d cljs.core.seq(coll);\nwhile(true){\nif(coll__$1){\nvar nval \x3d (function (){var G__18557 \x3d val__$1;\nvar G__18558 \x3d cljs.core.first(coll__$1);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18557,G__18558) : f.call(null,G__18557,G__18558));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__20655 \x3d nval;\nvar G__20656 \x3d cljs.core.next(coll__$1);\nval__$1 \x3d G__20655;\ncoll__$1 \x3d G__20656;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n}));\n\n(cljs.core.seq_reduce.cljs$lang$maxFixedArity \x3d 3);\n\n/**\n * Return a random permutation of coll\n */\ncljs.core.shuffle \x3d (function cljs$core$shuffle(coll){\nvar a \x3d (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));\ngoog.array.shuffle(a);\n\nreturn (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));\n});\ncljs.core.iter_reduce \x3d (function cljs$core$iter_reduce(var_args){\nvar G__18560 \x3d arguments.length;\nswitch (G__18560) {\ncase 2:\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,f){\nvar iter \x3d cljs.core._iterator(coll);\nif(cljs.core.truth_(iter.hasNext())){\nvar init \x3d iter.next();\nvar acc \x3d init;\nwhile(true){\nif(iter.hasNext()){\nvar nacc \x3d (function (){var G__18561 \x3d acc;\nvar G__18562 \x3d iter.next();\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18561,G__18562) : f.call(null,G__18561,G__18562));\n})();\nif(cljs.core.reduced_QMARK_(nacc)){\nreturn cljs.core.deref(nacc);\n} else {\nvar G__20665 \x3d nacc;\nacc \x3d G__20665;\ncontinue;\n}\n} else {\nreturn acc;\n}\nbreak;\n}\n} else {\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n}\n}));\n\n(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,f,init){\nvar iter \x3d cljs.core._iterator(coll);\nvar acc \x3d init;\nwhile(true){\nif(iter.hasNext()){\nvar nacc \x3d (function (){var G__18563 \x3d acc;\nvar G__18564 \x3d iter.next();\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18563,G__18564) : f.call(null,G__18563,G__18564));\n})();\nif(cljs.core.reduced_QMARK_(nacc)){\nreturn cljs.core.deref(nacc);\n} else {\nvar G__20670 \x3d nacc;\nacc \x3d G__20670;\ncontinue;\n}\n} else {\nreturn acc;\n}\nbreak;\n}\n}));\n\n(cljs.core.iter_reduce.cljs$lang$maxFixedArity \x3d 3);\n\n/**\n * f should be a function of 2 arguments. If val is not supplied,\n *   returns the result of applying f to the first 2 items in coll, then\n *   applying f to that result and the 3rd item, etc. If coll contains no\n *   items, f must accept no arguments as well, and reduce returns the\n *   result of calling f with no arguments.  If coll has only 1 item, it\n *   is returned and f is not called.  If val is supplied, returns the\n *   result of applying f to val and the first item in coll, then\n *   applying f to that result and the 2nd item, etc. If coll contains no\n *   items, returns val and f is not called.\n */\ncljs.core.reduce \x3d (function cljs$core$reduce(var_args){\nvar G__18566 \x3d arguments.length;\nswitch (G__18566) {\ncase 2:\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,coll){\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (524288))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IReduce$))))?true:false):false)){\nreturn coll.cljs$core$IReduce$_reduce$arity$2(null,f);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){\nreturn cljs.core._reduce(coll,f);\n} else {\nif(cljs.core.iterable_QMARK_(coll)){\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);\n\n}\n}\n}\n}\n}\n}));\n\n(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,val,coll){\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (524288))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IReduce$))))?true:false):false)){\nreturn coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){\nreturn cljs.core._reduce(coll,f,val);\n} else {\nif(cljs.core.iterable_QMARK_(coll)){\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);\n\n}\n}\n}\n}\n}\n}));\n\n(cljs.core.reduce.cljs$lang$maxFixedArity \x3d 3);\n\n/**\n * Reduces an associative collection. f should be a function of 3\n *   arguments. Returns the result of applying f to init, the first key\n *   and the first value in coll, then applying f to that result and the\n *   2nd key and value, etc. If coll contains no entries, returns init\n *   and f is not called. Note that reduce-kv is supported on vectors,\n *   where the keys will be the ordinals.\n */\ncljs.core.reduce_kv \x3d (function cljs$core$reduce_kv(f,init,coll){\nif((!((coll \x3d\x3d null)))){\nreturn cljs.core._kv_reduce(coll,f,init);\n} else {\nreturn init;\n}\n});\n/**\n * Returns its argument.\n */\ncljs.core.identity \x3d (function cljs$core$identity(x){\nreturn x;\n});\n/**\n * Takes a reducing function f of 2 args and returns a fn suitable for\n *   transduce by adding an arity-1 signature that calls cf (default -\n *   identity) on the result argument.\n */\ncljs.core.completing \x3d (function cljs$core$completing(var_args){\nvar G__18570 \x3d arguments.length;\nswitch (G__18570) {\ncase 1:\nreturn cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 \x3d (function (f){\nreturn cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);\n}));\n\n(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,cf){\nreturn (function() {\nvar G__20680 \x3d null;\nvar G__20680__0 \x3d (function (){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n});\nvar G__20680__1 \x3d (function (x){\nreturn (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));\n});\nvar G__20680__2 \x3d (function (x,y){\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));\n});\nG__20680 \x3d function(x,y){\nswitch(arguments.length){\ncase 0:\nreturn G__20680__0.call(this);\ncase 1:\nreturn G__20680__1.call(this,x);\ncase 2:\nreturn G__20680__2.call(this,x,y);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20680.cljs$core$IFn$_invoke$arity$0 \x3d G__20680__0;\nG__20680.cljs$core$IFn$_invoke$arity$1 \x3d G__20680__1;\nG__20680.cljs$core$IFn$_invoke$arity$2 \x3d G__20680__2;\nreturn G__20680;\n})()\n}));\n\n(cljs.core.completing.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * reduce with a transformation of f (xf). If init is not\n *   supplied, (f) will be called to produce it. f should be a reducing\n *   step function that accepts both 1 and 2 arguments, if it accepts\n *   only 2 you can add the arity-1 with \x27completing\x27. Returns the result\n *   of applying (the transformed) xf to init and the first item in coll,\n *   then applying xf to that result and the 2nd item, etc. If coll\n *   contains no items, returns init and f is not called. Note that\n *   certain transforms may inject or skip items.\n */\ncljs.core.transduce \x3d (function cljs$core$transduce(var_args){\nvar G__18572 \x3d arguments.length;\nswitch (G__18572) {\ncase 3:\nreturn cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (xform,f,coll){\nreturn cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);\n}));\n\n(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 \x3d (function (xform,f,init,coll){\nvar f__$1 \x3d (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));\nvar ret \x3d cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);\nreturn (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));\n}));\n\n(cljs.core.transduce.cljs$lang$maxFixedArity \x3d 4);\n\n/**\n * Returns the sum of nums. (+) returns 0.\n */\ncljs.core._PLUS_ \x3d (function cljs$core$_PLUS_(var_args){\nvar G__18577 \x3d arguments.length;\nswitch (G__18577) {\ncase 0:\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20691 \x3d arguments.length;\nvar i__4731__auto___20692 \x3d (0);\nwhile(true){\nif((i__4731__auto___20692 \x3c len__4730__auto___20691)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20692]));\n\nvar G__20693 \x3d (i__4731__auto___20692 + (1));\ni__4731__auto___20692 \x3d G__20693;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (0);\n}));\n\n(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x + y);\n}));\n\n(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);\n}));\n\n/** @this {Function} */\n(cljs.core._PLUS_.cljs$lang$applyTo \x3d (function (seq18574){\nvar G__18575 \x3d cljs.core.first(seq18574);\nvar seq18574__$1 \x3d cljs.core.next(seq18574);\nvar G__18576 \x3d cljs.core.first(seq18574__$1);\nvar seq18574__$2 \x3d cljs.core.next(seq18574__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18575,G__18576,seq18574__$2);\n}));\n\n(cljs.core._PLUS_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * If no ys are supplied, returns the negation of x, else subtracts\n *   the ys from x and returns the result.\n */\ncljs.core._ \x3d (function cljs$core$_(var_args){\nvar G__18582 \x3d arguments.length;\nswitch (G__18582) {\ncase 1:\nreturn cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20698 \x3d arguments.length;\nvar i__4731__auto___20699 \x3d (0);\nwhile(true){\nif((i__4731__auto___20699 \x3c len__4730__auto___20698)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20699]));\n\nvar G__20700 \x3d (i__4731__auto___20699 + (1));\ni__4731__auto___20699 \x3d G__20700;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (- x);\n}));\n\n(cljs.core._.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x - y);\n}));\n\n(cljs.core._.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);\n}));\n\n/** @this {Function} */\n(cljs.core._.cljs$lang$applyTo \x3d (function (seq18579){\nvar G__18580 \x3d cljs.core.first(seq18579);\nvar seq18579__$1 \x3d cljs.core.next(seq18579);\nvar G__18581 \x3d cljs.core.first(seq18579__$1);\nvar seq18579__$2 \x3d cljs.core.next(seq18579__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18580,G__18581,seq18579__$2);\n}));\n\n(cljs.core._.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns the product of nums. (*) returns 1.\n */\ncljs.core._STAR_ \x3d (function cljs$core$_STAR_(var_args){\nvar G__18587 \x3d arguments.length;\nswitch (G__18587) {\ncase 0:\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20709 \x3d arguments.length;\nvar i__4731__auto___20710 \x3d (0);\nwhile(true){\nif((i__4731__auto___20710 \x3c len__4730__auto___20709)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20710]));\n\nvar G__20711 \x3d (i__4731__auto___20710 + (1));\ni__4731__auto___20710 \x3d G__20711;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (1);\n}));\n\n(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x * y);\n}));\n\n(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);\n}));\n\n/** @this {Function} */\n(cljs.core._STAR_.cljs$lang$applyTo \x3d (function (seq18584){\nvar G__18585 \x3d cljs.core.first(seq18584);\nvar seq18584__$1 \x3d cljs.core.next(seq18584);\nvar G__18586 \x3d cljs.core.first(seq18584__$1);\nvar seq18584__$2 \x3d cljs.core.next(seq18584__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18585,G__18586,seq18584__$2);\n}));\n\n(cljs.core._STAR_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * If no denominators are supplied, returns 1/numerator,\n *   else returns numerator divided by all of the denominators.\n */\ncljs.core._SLASH_ \x3d (function cljs$core$_SLASH_(var_args){\nvar G__18592 \x3d arguments.length;\nswitch (G__18592) {\ncase 1:\nreturn cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20723 \x3d arguments.length;\nvar i__4731__auto___20724 \x3d (0);\nwhile(true){\nif((i__4731__auto___20724 \x3c len__4730__auto___20723)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20724]));\n\nvar G__20725 \x3d (i__4731__auto___20724 + (1));\ni__4731__auto___20724 \x3d G__20725;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn ((1) / x);\n}));\n\n(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x / y);\n}));\n\n(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);\n}));\n\n/** @this {Function} */\n(cljs.core._SLASH_.cljs$lang$applyTo \x3d (function (seq18589){\nvar G__18590 \x3d cljs.core.first(seq18589);\nvar seq18589__$1 \x3d cljs.core.next(seq18589);\nvar G__18591 \x3d cljs.core.first(seq18589__$1);\nvar seq18589__$2 \x3d cljs.core.next(seq18589__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18590,G__18591,seq18589__$2);\n}));\n\n(cljs.core._SLASH_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns non-nil if nums are in monotonically increasing order,\n *   otherwise false.\n */\ncljs.core._LT_ \x3d (function cljs$core$_LT_(var_args){\nvar G__18597 \x3d arguments.length;\nswitch (G__18597) {\ncase 1:\nreturn cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20737 \x3d arguments.length;\nvar i__4731__auto___20738 \x3d (0);\nwhile(true){\nif((i__4731__auto___20738 \x3c len__4730__auto___20737)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20738]));\n\nvar G__20739 \x3d (i__4731__auto___20738 + (1));\ni__4731__auto___20738 \x3d G__20739;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3c y);\n}));\n\n(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3c y)){\nif(cljs.core.next(more)){\nvar G__20741 \x3d y;\nvar G__20742 \x3d cljs.core.first(more);\nvar G__20743 \x3d cljs.core.next(more);\nx \x3d G__20741;\ny \x3d G__20742;\nmore \x3d G__20743;\ncontinue;\n} else {\nreturn (y \x3c cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core._LT_.cljs$lang$applyTo \x3d (function (seq18594){\nvar G__18595 \x3d cljs.core.first(seq18594);\nvar seq18594__$1 \x3d cljs.core.next(seq18594);\nvar G__18596 \x3d cljs.core.first(seq18594__$1);\nvar seq18594__$2 \x3d cljs.core.next(seq18594__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18595,G__18596,seq18594__$2);\n}));\n\n(cljs.core._LT_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns non-nil if nums are in monotonically non-decreasing order,\n *   otherwise false.\n */\ncljs.core._LT__EQ_ \x3d (function cljs$core$_LT__EQ_(var_args){\nvar G__18602 \x3d arguments.length;\nswitch (G__18602) {\ncase 1:\nreturn cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20750 \x3d arguments.length;\nvar i__4731__auto___20751 \x3d (0);\nwhile(true){\nif((i__4731__auto___20751 \x3c len__4730__auto___20750)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20751]));\n\nvar G__20752 \x3d (i__4731__auto___20751 + (1));\ni__4731__auto___20751 \x3d G__20752;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3c\x3d y);\n}));\n\n(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3c\x3d y)){\nif(cljs.core.next(more)){\nvar G__20754 \x3d y;\nvar G__20755 \x3d cljs.core.first(more);\nvar G__20756 \x3d cljs.core.next(more);\nx \x3d G__20754;\ny \x3d G__20755;\nmore \x3d G__20756;\ncontinue;\n} else {\nreturn (y \x3c\x3d cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core._LT__EQ_.cljs$lang$applyTo \x3d (function (seq18599){\nvar G__18600 \x3d cljs.core.first(seq18599);\nvar seq18599__$1 \x3d cljs.core.next(seq18599);\nvar G__18601 \x3d cljs.core.first(seq18599__$1);\nvar seq18599__$2 \x3d cljs.core.next(seq18599__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18600,G__18601,seq18599__$2);\n}));\n\n(cljs.core._LT__EQ_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns non-nil if nums are in monotonically decreasing order,\n *   otherwise false.\n */\ncljs.core._GT_ \x3d (function cljs$core$_GT_(var_args){\nvar G__18607 \x3d arguments.length;\nswitch (G__18607) {\ncase 1:\nreturn cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20762 \x3d arguments.length;\nvar i__4731__auto___20763 \x3d (0);\nwhile(true){\nif((i__4731__auto___20763 \x3c len__4730__auto___20762)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20763]));\n\nvar G__20766 \x3d (i__4731__auto___20763 + (1));\ni__4731__auto___20763 \x3d G__20766;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3e y);\n}));\n\n(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3e y)){\nif(cljs.core.next(more)){\nvar G__20768 \x3d y;\nvar G__20769 \x3d cljs.core.first(more);\nvar G__20770 \x3d cljs.core.next(more);\nx \x3d G__20768;\ny \x3d G__20769;\nmore \x3d G__20770;\ncontinue;\n} else {\nreturn (y \x3e cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core._GT_.cljs$lang$applyTo \x3d (function (seq18604){\nvar G__18605 \x3d cljs.core.first(seq18604);\nvar seq18604__$1 \x3d cljs.core.next(seq18604);\nvar G__18606 \x3d cljs.core.first(seq18604__$1);\nvar seq18604__$2 \x3d cljs.core.next(seq18604__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18605,G__18606,seq18604__$2);\n}));\n\n(cljs.core._GT_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns non-nil if nums are in monotonically non-increasing order,\n *   otherwise false.\n */\ncljs.core._GT__EQ_ \x3d (function cljs$core$_GT__EQ_(var_args){\nvar G__18612 \x3d arguments.length;\nswitch (G__18612) {\ncase 1:\nreturn cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20774 \x3d arguments.length;\nvar i__4731__auto___20776 \x3d (0);\nwhile(true){\nif((i__4731__auto___20776 \x3c len__4730__auto___20774)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20776]));\n\nvar G__20777 \x3d (i__4731__auto___20776 + (1));\ni__4731__auto___20776 \x3d G__20777;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3e\x3d y);\n}));\n\n(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3e\x3d y)){\nif(cljs.core.next(more)){\nvar G__20781 \x3d y;\nvar G__20783 \x3d cljs.core.first(more);\nvar G__20784 \x3d cljs.core.next(more);\nx \x3d G__20781;\ny \x3d G__20783;\nmore \x3d G__20784;\ncontinue;\n} else {\nreturn (y \x3e\x3d cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core._GT__EQ_.cljs$lang$applyTo \x3d (function (seq18609){\nvar G__18610 \x3d cljs.core.first(seq18609);\nvar seq18609__$1 \x3d cljs.core.next(seq18609);\nvar G__18611 \x3d cljs.core.first(seq18609__$1);\nvar seq18609__$2 \x3d cljs.core.next(seq18609__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18610,G__18611,seq18609__$2);\n}));\n\n(cljs.core._GT__EQ_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns a number one less than num.\n */\ncljs.core.dec \x3d (function cljs$core$dec(x){\nreturn (x - (1));\n});\n/**\n * Returns the greatest of the nums.\n */\ncljs.core.max \x3d (function cljs$core$max(var_args){\nvar G__18617 \x3d arguments.length;\nswitch (G__18617) {\ncase 1:\nreturn cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20787 \x3d arguments.length;\nvar i__4731__auto___20788 \x3d (0);\nwhile(true){\nif((i__4731__auto___20788 \x3c len__4730__auto___20787)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20788]));\n\nvar G__20789 \x3d (i__4731__auto___20788 + (1));\ni__4731__auto___20788 \x3d G__20789;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.max.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core.max.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nvar x__4208__auto__ \x3d x;\nvar y__4209__auto__ \x3d y;\nreturn ((x__4208__auto__ \x3e y__4209__auto__) ? x__4208__auto__ : y__4209__auto__);\n}));\n\n(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4208__auto__ \x3d x;\nvar y__4209__auto__ \x3d y;\nreturn ((x__4208__auto__ \x3e y__4209__auto__) ? x__4208__auto__ : y__4209__auto__);\n})(),more);\n}));\n\n/** @this {Function} */\n(cljs.core.max.cljs$lang$applyTo \x3d (function (seq18614){\nvar G__18615 \x3d cljs.core.first(seq18614);\nvar seq18614__$1 \x3d cljs.core.next(seq18614);\nvar G__18616 \x3d cljs.core.first(seq18614__$1);\nvar seq18614__$2 \x3d cljs.core.next(seq18614__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18615,G__18616,seq18614__$2);\n}));\n\n(cljs.core.max.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns the least of the nums.\n */\ncljs.core.min \x3d (function cljs$core$min(var_args){\nvar G__18622 \x3d arguments.length;\nswitch (G__18622) {\ncase 1:\nreturn cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20791 \x3d arguments.length;\nvar i__4731__auto___20792 \x3d (0);\nwhile(true){\nif((i__4731__auto___20792 \x3c len__4730__auto___20791)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20792]));\n\nvar G__20793 \x3d (i__4731__auto___20792 + (1));\ni__4731__auto___20792 \x3d G__20793;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.min.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core.min.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nvar x__4211__auto__ \x3d x;\nvar y__4212__auto__ \x3d y;\nreturn ((x__4211__auto__ \x3c y__4212__auto__) ? x__4211__auto__ : y__4212__auto__);\n}));\n\n(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4211__auto__ \x3d x;\nvar y__4212__auto__ \x3d y;\nreturn ((x__4211__auto__ \x3c y__4212__auto__) ? x__4211__auto__ : y__4212__auto__);\n})(),more);\n}));\n\n/** @this {Function} */\n(cljs.core.min.cljs$lang$applyTo \x3d (function (seq18619){\nvar G__18620 \x3d cljs.core.first(seq18619);\nvar seq18619__$1 \x3d cljs.core.next(seq18619);\nvar G__18621 \x3d cljs.core.first(seq18619__$1);\nvar seq18619__$2 \x3d cljs.core.next(seq18619__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18620,G__18621,seq18619__$2);\n}));\n\n(cljs.core.min.cljs$lang$maxFixedArity \x3d (2));\n\ncljs.core.byte$ \x3d (function cljs$core$byte(x){\nreturn x;\n});\n/**\n * Coerce to char\n */\ncljs.core.char$ \x3d (function cljs$core$char(x){\nif(typeof x \x3d\x3d\x3d \x27number\x27){\nreturn String.fromCharCode(x);\n} else {\nif(((typeof x \x3d\x3d\x3d \x27string\x27) \x26\x26 ((x.length \x3d\x3d\x3d (1))))){\nreturn x;\n} else {\nthrow (new Error(\x22Argument to char must be a character or number\x22));\n\n}\n}\n});\ncljs.core.short$ \x3d (function cljs$core$short(x){\nreturn x;\n});\ncljs.core.float$ \x3d (function cljs$core$float(x){\nreturn x;\n});\ncljs.core.double$ \x3d (function cljs$core$double(x){\nreturn x;\n});\ncljs.core.unchecked_byte \x3d (function cljs$core$unchecked_byte(x){\nreturn x;\n});\ncljs.core.unchecked_char \x3d (function cljs$core$unchecked_char(x){\nreturn x;\n});\ncljs.core.unchecked_short \x3d (function cljs$core$unchecked_short(x){\nreturn x;\n});\ncljs.core.unchecked_float \x3d (function cljs$core$unchecked_float(x){\nreturn x;\n});\ncljs.core.unchecked_double \x3d (function cljs$core$unchecked_double(x){\nreturn x;\n});\n/**\n * Returns the sum of nums. (+) returns 0.\n */\ncljs.core.unchecked_add \x3d (function cljs$core$unchecked_add(var_args){\nvar G__18627 \x3d arguments.length;\nswitch (G__18627) {\ncase 0:\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20795 \x3d arguments.length;\nvar i__4731__auto___20796 \x3d (0);\nwhile(true){\nif((i__4731__auto___20796 \x3c len__4730__auto___20795)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20796]));\n\nvar G__20797 \x3d (i__4731__auto___20796 + (1));\ni__4731__auto___20796 \x3d G__20797;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (0);\n}));\n\n(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x + y);\n}));\n\n(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_add.cljs$lang$applyTo \x3d (function (seq18624){\nvar G__18625 \x3d cljs.core.first(seq18624);\nvar seq18624__$1 \x3d cljs.core.next(seq18624);\nvar G__18626 \x3d cljs.core.first(seq18624__$1);\nvar seq18624__$2 \x3d cljs.core.next(seq18624__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18625,G__18626,seq18624__$2);\n}));\n\n(cljs.core.unchecked_add.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns the sum of nums. (+) returns 0.\n */\ncljs.core.unchecked_add_int \x3d (function cljs$core$unchecked_add_int(var_args){\nvar G__18632 \x3d arguments.length;\nswitch (G__18632) {\ncase 0:\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20799 \x3d arguments.length;\nvar i__4731__auto___20800 \x3d (0);\nwhile(true){\nif((i__4731__auto___20800 \x3c len__4730__auto___20799)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20800]));\n\nvar G__20801 \x3d (i__4731__auto___20800 + (1));\ni__4731__auto___20800 \x3d G__20801;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (0);\n}));\n\n(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x + y);\n}));\n\n(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_add_int.cljs$lang$applyTo \x3d (function (seq18629){\nvar G__18630 \x3d cljs.core.first(seq18629);\nvar seq18629__$1 \x3d cljs.core.next(seq18629);\nvar G__18631 \x3d cljs.core.first(seq18629__$1);\nvar seq18629__$2 \x3d cljs.core.next(seq18629__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18630,G__18631,seq18629__$2);\n}));\n\n(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns a number one less than x, an int.\n */\ncljs.core.unchecked_dec \x3d (function cljs$core$unchecked_dec(x){\nreturn (x - (1));\n});\n/**\n * Returns a number one less than x, an int.\n */\ncljs.core.unchecked_dec_int \x3d (function cljs$core$unchecked_dec_int(x){\nreturn (x - (1));\n});\n/**\n * If no denominators are supplied, returns 1/numerator,\n *   else returns numerator divided by all of the denominators.\n */\ncljs.core.unchecked_divide_int \x3d (function cljs$core$unchecked_divide_int(var_args){\nvar G__18637 \x3d arguments.length;\nswitch (G__18637) {\ncase 1:\nreturn cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20806 \x3d arguments.length;\nvar i__4731__auto___20807 \x3d (0);\nwhile(true){\nif((i__4731__auto___20807 \x3c len__4730__auto___20806)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20807]));\n\nvar G__20808 \x3d (i__4731__auto___20807 + (1));\ni__4731__auto___20807 \x3d G__20808;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn ((1) / x);\n}));\n\n(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x / y);\n}));\n\n(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_divide_int.cljs$lang$applyTo \x3d (function (seq18634){\nvar G__18635 \x3d cljs.core.first(seq18634);\nvar seq18634__$1 \x3d cljs.core.next(seq18634);\nvar G__18636 \x3d cljs.core.first(seq18634__$1);\nvar seq18634__$2 \x3d cljs.core.next(seq18634__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18635,G__18636,seq18634__$2);\n}));\n\n(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity \x3d (2));\n\ncljs.core.unchecked_inc \x3d (function cljs$core$unchecked_inc(x){\nreturn (x + (1));\n});\ncljs.core.unchecked_inc_int \x3d (function cljs$core$unchecked_inc_int(x){\nreturn (x + (1));\n});\n/**\n * Returns the product of nums. (*) returns 1.\n */\ncljs.core.unchecked_multiply \x3d (function cljs$core$unchecked_multiply(var_args){\nvar G__18642 \x3d arguments.length;\nswitch (G__18642) {\ncase 0:\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20810 \x3d arguments.length;\nvar i__4731__auto___20811 \x3d (0);\nwhile(true){\nif((i__4731__auto___20811 \x3c len__4730__auto___20810)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20811]));\n\nvar G__20812 \x3d (i__4731__auto___20811 + (1));\ni__4731__auto___20811 \x3d G__20812;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (1);\n}));\n\n(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x * y);\n}));\n\n(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_multiply.cljs$lang$applyTo \x3d (function (seq18639){\nvar G__18640 \x3d cljs.core.first(seq18639);\nvar seq18639__$1 \x3d cljs.core.next(seq18639);\nvar G__18641 \x3d cljs.core.first(seq18639__$1);\nvar seq18639__$2 \x3d cljs.core.next(seq18639__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18640,G__18641,seq18639__$2);\n}));\n\n(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns the product of nums. (*) returns 1.\n */\ncljs.core.unchecked_multiply_int \x3d (function cljs$core$unchecked_multiply_int(var_args){\nvar G__18647 \x3d arguments.length;\nswitch (G__18647) {\ncase 0:\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20814 \x3d arguments.length;\nvar i__4731__auto___20815 \x3d (0);\nwhile(true){\nif((i__4731__auto___20815 \x3c len__4730__auto___20814)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20815]));\n\nvar G__20816 \x3d (i__4731__auto___20815 + (1));\ni__4731__auto___20815 \x3d G__20816;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (1);\n}));\n\n(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n}));\n\n(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x * y);\n}));\n\n(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_multiply_int.cljs$lang$applyTo \x3d (function (seq18644){\nvar G__18645 \x3d cljs.core.first(seq18644);\nvar seq18644__$1 \x3d cljs.core.next(seq18644);\nvar G__18646 \x3d cljs.core.first(seq18644__$1);\nvar seq18644__$2 \x3d cljs.core.next(seq18644__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18645,G__18646,seq18644__$2);\n}));\n\n(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity \x3d (2));\n\ncljs.core.unchecked_negate \x3d (function cljs$core$unchecked_negate(x){\nreturn (- x);\n});\ncljs.core.unchecked_negate_int \x3d (function cljs$core$unchecked_negate_int(x){\nreturn (- x);\n});\ncljs.core.unchecked_remainder_int \x3d (function cljs$core$unchecked_remainder_int(x,n){\nreturn (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));\n});\n/**\n * If no ys are supplied, returns the negation of x, else subtracts\n *   the ys from x and returns the result.\n */\ncljs.core.unchecked_subtract \x3d (function cljs$core$unchecked_subtract(var_args){\nvar G__18652 \x3d arguments.length;\nswitch (G__18652) {\ncase 1:\nreturn cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20818 \x3d arguments.length;\nvar i__4731__auto___20819 \x3d (0);\nwhile(true){\nif((i__4731__auto___20819 \x3c len__4730__auto___20818)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20819]));\n\nvar G__20820 \x3d (i__4731__auto___20819 + (1));\ni__4731__auto___20819 \x3d G__20820;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (- x);\n}));\n\n(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x - y);\n}));\n\n(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_subtract.cljs$lang$applyTo \x3d (function (seq18649){\nvar G__18650 \x3d cljs.core.first(seq18649);\nvar seq18649__$1 \x3d cljs.core.next(seq18649);\nvar G__18651 \x3d cljs.core.first(seq18649__$1);\nvar seq18649__$2 \x3d cljs.core.next(seq18649__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18650,G__18651,seq18649__$2);\n}));\n\n(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * If no ys are supplied, returns the negation of x, else subtracts\n *   the ys from x and returns the result.\n */\ncljs.core.unchecked_subtract_int \x3d (function cljs$core$unchecked_subtract_int(var_args){\nvar G__18657 \x3d arguments.length;\nswitch (G__18657) {\ncase 1:\nreturn cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20822 \x3d arguments.length;\nvar i__4731__auto___20823 \x3d (0);\nwhile(true){\nif((i__4731__auto___20823 \x3c len__4730__auto___20822)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20823]));\n\nvar G__20824 \x3d (i__4731__auto___20823 + (1));\ni__4731__auto___20823 \x3d G__20824;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (- x);\n}));\n\n(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x - y);\n}));\n\n(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.unchecked_subtract_int.cljs$lang$applyTo \x3d (function (seq18654){\nvar G__18655 \x3d cljs.core.first(seq18654);\nvar seq18654__$1 \x3d cljs.core.next(seq18654);\nvar G__18656 \x3d cljs.core.first(seq18654__$1);\nvar seq18654__$2 \x3d cljs.core.next(seq18654__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18655,G__18656,seq18654__$2);\n}));\n\n(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity \x3d (2));\n\ncljs.core.fix \x3d (function cljs$core$fix(q){\nif((q \x3e\x3d (0))){\nreturn Math.floor(q);\n} else {\nreturn Math.ceil(q);\n}\n});\n/**\n * Coerce to int by stripping decimal places.\n */\ncljs.core.int$ \x3d (function cljs$core$int(x){\nreturn (x | (0));\n});\n/**\n * Coerce to int by stripping decimal places.\n */\ncljs.core.unchecked_int \x3d (function cljs$core$unchecked_int(x){\nreturn cljs.core.fix(x);\n});\n/**\n * Coerce to long by stripping decimal places. Identical to `int\x27.\n */\ncljs.core.long$ \x3d (function cljs$core$long(x){\nreturn cljs.core.fix(x);\n});\n/**\n * Coerce to long by stripping decimal places. Identical to `int\x27.\n */\ncljs.core.unchecked_long \x3d (function cljs$core$unchecked_long(x){\nreturn cljs.core.fix(x);\n});\ncljs.core.booleans \x3d (function cljs$core$booleans(x){\nreturn x;\n});\ncljs.core.bytes \x3d (function cljs$core$bytes(x){\nreturn x;\n});\ncljs.core.chars \x3d (function cljs$core$chars(x){\nreturn x;\n});\ncljs.core.shorts \x3d (function cljs$core$shorts(x){\nreturn x;\n});\ncljs.core.ints \x3d (function cljs$core$ints(x){\nreturn x;\n});\ncljs.core.floats \x3d (function cljs$core$floats(x){\nreturn x;\n});\ncljs.core.doubles \x3d (function cljs$core$doubles(x){\nreturn x;\n});\ncljs.core.longs \x3d (function cljs$core$longs(x){\nreturn x;\n});\n/**\n * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers\n */\ncljs.core.js_mod \x3d (function cljs$core$js_mod(n,d){\nreturn (n % d);\n});\n/**\n * Modulus of num and div. Truncates toward negative infinity.\n */\ncljs.core.mod \x3d (function cljs$core$mod(n,d){\nreturn (((n % d) + d) % d);\n});\n/**\n * quot[ient] of dividing numerator by denominator.\n */\ncljs.core.quot \x3d (function cljs$core$quot(n,d){\nvar rem \x3d (n % d);\nreturn cljs.core.fix(((n - rem) / d));\n});\n/**\n * remainder of dividing numerator by denominator.\n */\ncljs.core.rem \x3d (function cljs$core$rem(n,d){\nvar q \x3d cljs.core.quot(n,d);\nreturn (n - (d * q));\n});\n/**\n * Bitwise exclusive or\n */\ncljs.core.bit_xor \x3d (function cljs$core$bit_xor(var_args){\nvar G__18662 \x3d arguments.length;\nswitch (G__18662) {\ncase 2:\nreturn cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20830 \x3d arguments.length;\nvar i__4731__auto___20831 \x3d (0);\nwhile(true){\nif((i__4731__auto___20831 \x3c len__4730__auto___20830)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20831]));\n\nvar G__20832 \x3d (i__4731__auto___20831 + (1));\ni__4731__auto___20831 \x3d G__20832;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x ^ y);\n}));\n\n(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.bit_xor.cljs$lang$applyTo \x3d (function (seq18659){\nvar G__18660 \x3d cljs.core.first(seq18659);\nvar seq18659__$1 \x3d cljs.core.next(seq18659);\nvar G__18661 \x3d cljs.core.first(seq18659__$1);\nvar seq18659__$2 \x3d cljs.core.next(seq18659__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18660,G__18661,seq18659__$2);\n}));\n\n(cljs.core.bit_xor.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Bitwise and\n */\ncljs.core.bit_and \x3d (function cljs$core$bit_and(var_args){\nvar G__18667 \x3d arguments.length;\nswitch (G__18667) {\ncase 2:\nreturn cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20834 \x3d arguments.length;\nvar i__4731__auto___20835 \x3d (0);\nwhile(true){\nif((i__4731__auto___20835 \x3c len__4730__auto___20834)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20835]));\n\nvar G__20836 \x3d (i__4731__auto___20835 + (1));\ni__4731__auto___20835 \x3d G__20836;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x26 y);\n}));\n\n(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x \x26 y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.bit_and.cljs$lang$applyTo \x3d (function (seq18664){\nvar G__18665 \x3d cljs.core.first(seq18664);\nvar seq18664__$1 \x3d cljs.core.next(seq18664);\nvar G__18666 \x3d cljs.core.first(seq18664__$1);\nvar seq18664__$2 \x3d cljs.core.next(seq18664__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18665,G__18666,seq18664__$2);\n}));\n\n(cljs.core.bit_and.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Bitwise or\n */\ncljs.core.bit_or \x3d (function cljs$core$bit_or(var_args){\nvar G__18672 \x3d arguments.length;\nswitch (G__18672) {\ncase 2:\nreturn cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20838 \x3d arguments.length;\nvar i__4731__auto___20839 \x3d (0);\nwhile(true){\nif((i__4731__auto___20839 \x3c len__4730__auto___20838)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20839]));\n\nvar G__20840 \x3d (i__4731__auto___20839 + (1));\ni__4731__auto___20839 \x3d G__20840;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x | y);\n}));\n\n(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.bit_or.cljs$lang$applyTo \x3d (function (seq18669){\nvar G__18670 \x3d cljs.core.first(seq18669);\nvar seq18669__$1 \x3d cljs.core.next(seq18669);\nvar G__18671 \x3d cljs.core.first(seq18669__$1);\nvar seq18669__$2 \x3d cljs.core.next(seq18669__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18670,G__18671,seq18669__$2);\n}));\n\n(cljs.core.bit_or.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Bitwise and with complement\n */\ncljs.core.bit_and_not \x3d (function cljs$core$bit_and_not(var_args){\nvar G__18677 \x3d arguments.length;\nswitch (G__18677) {\ncase 2:\nreturn cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20842 \x3d arguments.length;\nvar i__4731__auto___20843 \x3d (0);\nwhile(true){\nif((i__4731__auto___20843 \x3c len__4730__auto___20842)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20843]));\n\nvar G__20844 \x3d (i__4731__auto___20843 + (1));\ni__4731__auto___20843 \x3d G__20844;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x26 ~y);\n}));\n\n(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x \x26 ~y),more);\n}));\n\n/** @this {Function} */\n(cljs.core.bit_and_not.cljs$lang$applyTo \x3d (function (seq18674){\nvar G__18675 \x3d cljs.core.first(seq18674);\nvar seq18674__$1 \x3d cljs.core.next(seq18674);\nvar G__18676 \x3d cljs.core.first(seq18674__$1);\nvar seq18674__$2 \x3d cljs.core.next(seq18674__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18675,G__18676,seq18674__$2);\n}));\n\n(cljs.core.bit_and_not.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Clear bit at index n\n */\ncljs.core.bit_clear \x3d (function cljs$core$bit_clear(x,n){\nreturn (x \x26 ~(1 \x3c\x3c n));\n});\n/**\n * Flip bit at index n\n */\ncljs.core.bit_flip \x3d (function cljs$core$bit_flip(x,n){\nreturn (x ^ (1 \x3c\x3c n));\n});\n/**\n * Bitwise complement\n */\ncljs.core.bit_not \x3d (function cljs$core$bit_not(x){\nreturn (~ x);\n});\n/**\n * Set bit at index n\n */\ncljs.core.bit_set \x3d (function cljs$core$bit_set(x,n){\nreturn (x | (1 \x3c\x3c n));\n});\n/**\n * Test bit at index n\n */\ncljs.core.bit_test \x3d (function cljs$core$bit_test(x,n){\nreturn ((x \x26 (1 \x3c\x3c n)) !\x3d 0);\n});\n/**\n * Bitwise shift left\n */\ncljs.core.bit_shift_left \x3d (function cljs$core$bit_shift_left(x,n){\nreturn (x \x3c\x3c n);\n});\n/**\n * Bitwise shift right\n */\ncljs.core.bit_shift_right \x3d (function cljs$core$bit_shift_right(x,n){\nreturn (x \x3e\x3e n);\n});\n/**\n * DEPRECATED: Bitwise shift right with zero fill\n */\ncljs.core.bit_shift_right_zero_fill \x3d (function cljs$core$bit_shift_right_zero_fill(x,n){\nreturn (x \x3e\x3e\x3e n);\n});\n/**\n * Bitwise shift right with zero fill\n */\ncljs.core.unsigned_bit_shift_right \x3d (function cljs$core$unsigned_bit_shift_right(x,n){\nreturn (x \x3e\x3e\x3e n);\n});\n/**\n * Counts the number of bits set in n\n */\ncljs.core.bit_count \x3d (function cljs$core$bit_count(v){\nvar v__$1 \x3d (v - ((v \x3e\x3e (1)) \x26 (1431655765)));\nvar v__$2 \x3d ((v__$1 \x26 (858993459)) + ((v__$1 \x3e\x3e (2)) \x26 (858993459)));\nreturn ((((v__$2 + (v__$2 \x3e\x3e (4))) \x26 (252645135)) * (16843009)) \x3e\x3e (24));\n});\n/**\n * Returns non-nil if nums all have the equivalent\n *   value, otherwise false. Behavior on non nums is\n *   undefined.\n */\ncljs.core._EQ__EQ_ \x3d (function cljs$core$_EQ__EQ_(var_args){\nvar G__18682 \x3d arguments.length;\nswitch (G__18682) {\ncase 1:\nreturn cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20846 \x3d arguments.length;\nvar i__4731__auto___20847 \x3d (0);\nwhile(true){\nif((i__4731__auto___20847 \x3c len__4730__auto___20846)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20847]));\n\nvar G__20848 \x3d (i__4731__auto___20847 + (1));\ni__4731__auto___20847 \x3d G__20848;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n}));\n\n(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn cljs.core._equiv(x,y);\n}));\n\n(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3d\x3d\x3d y)){\nif(cljs.core.next(more)){\nvar G__20849 \x3d y;\nvar G__20850 \x3d cljs.core.first(more);\nvar G__20851 \x3d cljs.core.next(more);\nx \x3d G__20849;\ny \x3d G__20850;\nmore \x3d G__20851;\ncontinue;\n} else {\nreturn (y \x3d\x3d\x3d cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core._EQ__EQ_.cljs$lang$applyTo \x3d (function (seq18679){\nvar G__18680 \x3d cljs.core.first(seq18679);\nvar seq18679__$1 \x3d cljs.core.next(seq18679);\nvar G__18681 \x3d cljs.core.first(seq18679__$1);\nvar seq18679__$2 \x3d cljs.core.next(seq18679__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18680,G__18681,seq18679__$2);\n}));\n\n(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns true if num is greater than zero, else false\n */\ncljs.core.pos_QMARK_ \x3d (function cljs$core$pos_QMARK_(x){\nreturn (x \x3e (0));\n});\n/**\n * Returns true if num is zero, else false\n */\ncljs.core.zero_QMARK_ \x3d (function cljs$core$zero_QMARK_(x){\nreturn (x \x3d\x3d\x3d (0));\n});\n/**\n * Returns true if num is less than zero, else false\n */\ncljs.core.neg_QMARK_ \x3d (function cljs$core$neg_QMARK_(x){\nreturn (x \x3c (0));\n});\n/**\n * Returns the nth next of coll, (seq coll) when n is 0.\n */\ncljs.core.nthnext \x3d (function cljs$core$nthnext(coll,n){\nvar n__$1 \x3d n;\nvar xs \x3d cljs.core.seq(coll);\nwhile(true){\nif(((xs) \x26\x26 ((n__$1 \x3e (0))))){\nvar G__20852 \x3d (n__$1 - (1));\nvar G__20853 \x3d cljs.core.next(xs);\nn__$1 \x3d G__20852;\nxs \x3d G__20853;\ncontinue;\n} else {\nreturn xs;\n}\nbreak;\n}\n});\n/**\n * With no args, returns the empty string. With one arg x, returns\n *   x.toString().  (str nil) returns the empty string. With more than\n *   one arg, returns the concatenation of the str values of the args.\n */\ncljs.core.str \x3d (function cljs$core$str(var_args){\nvar G__18686 \x3d arguments.length;\nswitch (G__18686) {\ncase 0:\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___20855 \x3d arguments.length;\nvar i__4731__auto___20856 \x3d (0);\nwhile(true){\nif((i__4731__auto___20856 \x3c len__4730__auto___20855)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___20856]));\n\nvar G__20857 \x3d (i__4731__auto___20856 + (1));\ni__4731__auto___20856 \x3d G__20857;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((1)),(0),null));\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.str.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn \x22\x22;\n}));\n\n(cljs.core.str.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nif((x \x3d\x3d null)){\nreturn \x22\x22;\n} else {\nreturn [x].join(\x22\x22);\n}\n}));\n\n(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,ys){\nvar sb \x3d (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));\nvar more \x3d ys;\nwhile(true){\nif(cljs.core.truth_(more)){\nvar G__20858 \x3d sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));\nvar G__20859 \x3d cljs.core.next(more);\nsb \x3d G__20858;\nmore \x3d G__20859;\ncontinue;\n} else {\nreturn sb.toString();\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.str.cljs$lang$applyTo \x3d (function (seq18684){\nvar G__18685 \x3d cljs.core.first(seq18684);\nvar seq18684__$1 \x3d cljs.core.next(seq18684);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18685,seq18684__$1);\n}));\n\n(cljs.core.str.cljs$lang$maxFixedArity \x3d (1));\n\n/**\n * Returns the substring of s beginning at start inclusive, and ending\n *   at end (defaults to length of string), exclusive.\n */\ncljs.core.subs \x3d (function cljs$core$subs(var_args){\nvar G__18688 \x3d arguments.length;\nswitch (G__18688) {\ncase 2:\nreturn cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 \x3d (function (s,start){\nreturn s.substring(start);\n}));\n\n(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 \x3d (function (s,start,end){\nreturn s.substring(start,end);\n}));\n\n(cljs.core.subs.cljs$lang$maxFixedArity \x3d 3);\n\n\n/**\n * Assumes x is sequential. Returns true if x equals y, otherwise\n *   returns false.\n */\ncljs.core.equiv_sequential \x3d (function cljs$core$equiv_sequential(x,y){\nreturn cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) \x26\x26 (cljs.core.counted_QMARK_(y)) \x26\x26 ((!((cljs.core.count(x) \x3d\x3d\x3d cljs.core.count(y)))))))?false:(function (){var xs \x3d cljs.core.seq(x);\nvar ys \x3d cljs.core.seq(y);\nwhile(true){\nif((xs \x3d\x3d null)){\nreturn (ys \x3d\x3d null);\n} else {\nif((ys \x3d\x3d null)){\nreturn false;\n} else {\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){\nvar G__20867 \x3d cljs.core.next(xs);\nvar G__20868 \x3d cljs.core.next(ys);\nxs \x3d G__20867;\nys \x3d G__20868;\ncontinue;\n} else {\nreturn false;\n\n}\n}\n}\nbreak;\n}\n})()):null));\n});\ncljs.core.hash_coll \x3d (function cljs$core$hash_coll(coll){\nif(cljs.core.seq(coll)){\nvar res \x3d cljs.core.hash(cljs.core.first(coll));\nvar s \x3d cljs.core.next(coll);\nwhile(true){\nif((s \x3d\x3d null)){\nreturn res;\n} else {\nvar G__20869 \x3d cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));\nvar G__20870 \x3d cljs.core.next(s);\nres \x3d G__20869;\ns \x3d G__20870;\ncontinue;\n}\nbreak;\n}\n} else {\nreturn (0);\n}\n});\n\ncljs.core.hash_imap \x3d (function cljs$core$hash_imap(m){\nvar h \x3d (0);\nvar s \x3d cljs.core.seq(m);\nwhile(true){\nif(s){\nvar e \x3d cljs.core.first(s);\nvar G__20871 \x3d ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));\nvar G__20872 \x3d cljs.core.next(s);\nh \x3d G__20871;\ns \x3d G__20872;\ncontinue;\n} else {\nreturn h;\n}\nbreak;\n}\n});\ncljs.core.hash_iset \x3d (function cljs$core$hash_iset(s){\nvar h \x3d (0);\nvar s__$1 \x3d cljs.core.seq(s);\nwhile(true){\nif(s__$1){\nvar e \x3d cljs.core.first(s__$1);\nvar G__20873 \x3d ((h + cljs.core.hash(e)) % (4503599627370496));\nvar G__20874 \x3d cljs.core.next(s__$1);\nh \x3d G__20873;\ns__$1 \x3d G__20874;\ncontinue;\n} else {\nreturn h;\n}\nbreak;\n}\n});\n\n\n/**\n * Takes a JavaScript object and a map of names to functions and\n *   attaches said functions as methods on the object.  Any references to\n *   JavaScript\x27s implicit this (via the this-as macro) will resolve to the\n *   object that the function is attached.\n */\ncljs.core.extend_object_BANG_ \x3d (function cljs$core$extend_object_BANG_(obj,fn_map){\nvar seq__18689_20875 \x3d cljs.core.seq(fn_map);\nvar chunk__18690_20876 \x3d null;\nvar count__18691_20877 \x3d (0);\nvar i__18692_20878 \x3d (0);\nwhile(true){\nif((i__18692_20878 \x3c count__18691_20877)){\nvar vec__18699_20879 \x3d chunk__18690_20876.cljs$core$IIndexed$_nth$arity$2(null,i__18692_20878);\nvar key_name_20880 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18699_20879,(0),null);\nvar f_20881 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18699_20879,(1),null);\nvar str_name_20882 \x3d (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_20880) : cljs.core.name.call(null,key_name_20880));\ngoog.object.set(obj,str_name_20882,f_20881);\n\n\nvar G__20884 \x3d seq__18689_20875;\nvar G__20885 \x3d chunk__18690_20876;\nvar G__20886 \x3d count__18691_20877;\nvar G__20887 \x3d (i__18692_20878 + (1));\nseq__18689_20875 \x3d G__20884;\nchunk__18690_20876 \x3d G__20885;\ncount__18691_20877 \x3d G__20886;\ni__18692_20878 \x3d G__20887;\ncontinue;\n} else {\nvar temp__5735__auto___20888 \x3d cljs.core.seq(seq__18689_20875);\nif(temp__5735__auto___20888){\nvar seq__18689_20890__$1 \x3d temp__5735__auto___20888;\nif(cljs.core.chunked_seq_QMARK_(seq__18689_20890__$1)){\nvar c__4550__auto___20894 \x3d (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__18689_20890__$1) : cljs.core.chunk_first.call(null,seq__18689_20890__$1));\nvar G__20896 \x3d (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__18689_20890__$1) : cljs.core.chunk_rest.call(null,seq__18689_20890__$1));\nvar G__20897 \x3d c__4550__auto___20894;\nvar G__20898 \x3d cljs.core.count(c__4550__auto___20894);\nvar G__20899 \x3d (0);\nseq__18689_20875 \x3d G__20896;\nchunk__18690_20876 \x3d G__20897;\ncount__18691_20877 \x3d G__20898;\ni__18692_20878 \x3d G__20899;\ncontinue;\n} else {\nvar vec__18702_20900 \x3d cljs.core.first(seq__18689_20890__$1);\nvar key_name_20901 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18702_20900,(0),null);\nvar f_20902 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18702_20900,(1),null);\nvar str_name_20903 \x3d (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_20901) : cljs.core.name.call(null,key_name_20901));\ngoog.object.set(obj,str_name_20903,f_20902);\n\n\nvar G__20904 \x3d cljs.core.next(seq__18689_20890__$1);\nvar G__20905 \x3d null;\nvar G__20906 \x3d (0);\nvar G__20907 \x3d (0);\nseq__18689_20875 \x3d G__20904;\nchunk__18690_20876 \x3d G__20905;\ncount__18691_20877 \x3d G__20906;\ni__18692_20878 \x3d G__20907;\ncontinue;\n}\n} else {\n}\n}\nbreak;\n}\n\nreturn obj;\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IList}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.IStack}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.List \x3d (function (meta,first,rest,count,__hash){\nthis.meta \x3d meta;\nthis.first \x3d first;\nthis.rest \x3d rest;\nthis.count \x3d count;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 65937646;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\n(cljs.core.List.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.List.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.List.prototype.indexOf \x3d (function() {\nvar G__20908 \x3d null;\nvar G__20908__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20908__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20908 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20908__1.call(this,x);\ncase 2:\nreturn G__20908__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20908.cljs$core$IFn$_invoke$arity$1 \x3d G__20908__1;\nG__20908.cljs$core$IFn$_invoke$arity$2 \x3d G__20908__2;\nreturn G__20908;\n})()\n);\n\n(cljs.core.List.prototype.lastIndexOf \x3d (function() {\nvar G__20909 \x3d null;\nvar G__20909__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);\n});\nvar G__20909__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20909 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20909__1.call(this,x);\ncase 2:\nreturn G__20909__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20909.cljs$core$IFn$_invoke$arity$1 \x3d G__20909__1;\nG__20909.cljs$core$IFn$_invoke$arity$2 \x3d G__20909__2;\nreturn G__20909;\n})()\n);\n\n(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));\n}));\n\n(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.count \x3d\x3d\x3d (1))){\nreturn null;\n} else {\nreturn self__.rest;\n}\n}));\n\n(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.count;\n}));\n\n(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.first;\n}));\n\n(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1.cljs$core$ISeq$_rest$arity$1(null);\n}));\n\n(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4232__auto__ \x3d self__.__hash;\nif((!((h__4232__auto__ \x3d\x3d null)))){\nreturn h__4232__auto__;\n} else {\nvar h__4232__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\n(self__.__hash \x3d h__4232__auto____$1);\n\nreturn h__4232__auto____$1;\n}\n}));\n\n(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n}));\n\n(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n}));\n\n(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n}));\n\n(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n}));\n\n(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.first;\n}));\n\n(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.count \x3d\x3d\x3d (1))){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.rest;\n}\n}));\n\n(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n}));\n\n(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));\n}\n}));\n\n(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));\n}));\n\n(cljs.core.List.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),new cljs.core.Symbol(null,\x22first\x22,\x22first\x22,996428481,null),new cljs.core.Symbol(null,\x22rest\x22,\x22rest\x22,398835108,null),new cljs.core.Symbol(null,\x22count\x22,\x22count\x22,-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.List.cljs$lang$type \x3d true);\n\n(cljs.core.List.cljs$lang$ctorStr \x3d \x22cljs.core/List\x22);\n\n(cljs.core.List.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/List\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/List.\n */\ncljs.core.__GT_List \x3d (function cljs$core$__GT_List(meta,first,rest,count,__hash){\nreturn (new cljs.core.List(meta,first,rest,count,__hash));\n});\n\n/**\n * Returns true if x implements IList\n */\ncljs.core.list_QMARK_ \x3d (function cljs$core$list_QMARK_(x){\nif((!((x \x3d\x3d null)))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (33554432))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IList$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);\n}\n});\ngoog.object.set(cljs.core.List.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\n\n/**\n* @constructor\n * @implements {cljs.core.IList}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.IStack}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.EmptyList \x3d (function (meta){\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 65937614;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\n(cljs.core.EmptyList.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.EmptyList.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.EmptyList.prototype.indexOf \x3d (function() {\nvar G__20916 \x3d null;\nvar G__20916__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20916__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20916 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20916__1.call(this,x);\ncase 2:\nreturn G__20916__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20916.cljs$core$IFn$_invoke$arity$1 \x3d G__20916__1;\nG__20916.cljs$core$IFn$_invoke$arity$2 \x3d G__20916__2;\nreturn G__20916;\n})()\n);\n\n(cljs.core.EmptyList.prototype.lastIndexOf \x3d (function() {\nvar G__20921 \x3d null;\nvar G__20921__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__20921__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20921 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20921__1.call(this,x);\ncase 2:\nreturn G__20921__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20921.cljs$core$IFn$_invoke$arity$1 \x3d G__20921__1;\nG__20921.cljs$core$IFn$_invoke$arity$2 \x3d G__20921__2;\nreturn G__20921;\n})()\n);\n\n(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.EmptyList(self__.meta));\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (0);\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nthrow (new Error(\x22Can\x27t pop empty list\x22));\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.empty_ordered_hash;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){\nreturn (cljs.core.seq(other) \x3d\x3d null);\n} else {\nreturn false;\n}\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.EmptyList(new_meta));\n}\n}));\n\n(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.List(self__.meta,o,null,(1),null));\n}));\n\n(cljs.core.EmptyList.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n}));\n\n(cljs.core.EmptyList.cljs$lang$type \x3d true);\n\n(cljs.core.EmptyList.cljs$lang$ctorStr \x3d \x22cljs.core/EmptyList\x22);\n\n(cljs.core.EmptyList.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/EmptyList\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/EmptyList.\n */\ncljs.core.__GT_EmptyList \x3d (function cljs$core$__GT_EmptyList(meta){\nreturn (new cljs.core.EmptyList(meta));\n});\n\n(cljs.core.List.EMPTY \x3d (new cljs.core.EmptyList(null)));\ngoog.object.set(cljs.core.EmptyList.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\n/**\n * Returns true if coll satisfies? IReversible.\n */\ncljs.core.reversible_QMARK_ \x3d (function cljs$core$reversible_QMARK_(coll){\nif((!((coll \x3d\x3d null)))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (134217728))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IReversible$)))){\nreturn true;\n} else {\nif((!coll.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);\n}\n});\n/**\n * Returns, in constant time, a seq of the items in rev (which\n *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil\n */\ncljs.core.rseq \x3d (function cljs$core$rseq(rev){\nreturn cljs.core._rseq(rev);\n});\n/**\n * Returns a seq of the items in coll in reverse order. Not lazy.\n */\ncljs.core.reverse \x3d (function cljs$core$reverse(coll){\nif(cljs.core.reversible_QMARK_(coll)){\nvar or__4120__auto__ \x3d cljs.core.rseq(coll);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nreturn cljs.core.List.EMPTY;\n}\n} else {\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);\n}\n});\n/**\n * Creates a new list containing the items.\n */\ncljs.core.list \x3d (function cljs$core$list(var_args){\nvar args__4736__auto__ \x3d [];\nvar len__4730__auto___20936 \x3d arguments.length;\nvar i__4731__auto___20937 \x3d (0);\nwhile(true){\nif((i__4731__auto___20937 \x3c len__4730__auto___20936)){\nargs__4736__auto__.push((arguments[i__4731__auto___20937]));\n\nvar G__20938 \x3d (i__4731__auto___20937 + (1));\ni__4731__auto___20937 \x3d G__20938;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4737__auto__ \x3d ((((0) \x3c args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);\nreturn cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);\n});\n\n(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic \x3d (function (xs){\nvar arr \x3d (((((xs instanceof cljs.core.IndexedSeq)) \x26\x26 ((xs.i \x3d\x3d\x3d (0)))))?xs.arr:(function (){var arr \x3d [];\nvar xs__$1 \x3d xs;\nwhile(true){\nif((!((xs__$1 \x3d\x3d null)))){\narr.push(cljs.core._first(xs__$1));\n\nvar G__20940 \x3d cljs.core._next(xs__$1);\nxs__$1 \x3d G__20940;\ncontinue;\n} else {\nreturn arr;\n}\nbreak;\n}\n})());\nvar i \x3d arr.length;\nvar r \x3d cljs.core.List.EMPTY;\nwhile(true){\nif((i \x3e (0))){\nvar G__20944 \x3d (i - (1));\nvar G__20945 \x3d cljs.core._conj(r,(arr[(i - (1))]));\ni \x3d G__20944;\nr \x3d G__20945;\ncontinue;\n} else {\nreturn r;\n}\nbreak;\n}\n}));\n\n(cljs.core.list.cljs$lang$maxFixedArity \x3d (0));\n\n/** @this {Function} */\n(cljs.core.list.cljs$lang$applyTo \x3d (function (seq18707){\nvar self__4718__auto__ \x3d this;\nreturn self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18707));\n}));\n\n\n/**\n* @constructor\n * @implements {cljs.core.IList}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.Cons \x3d (function (meta,first,rest,__hash){\nthis.meta \x3d meta;\nthis.first \x3d first;\nthis.rest \x3d rest;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 65929452;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\n(cljs.core.Cons.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.Cons.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.Cons.prototype.indexOf \x3d (function() {\nvar G__20948 \x3d null;\nvar G__20948__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20948__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20948 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20948__1.call(this,x);\ncase 2:\nreturn G__20948__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20948.cljs$core$IFn$_invoke$arity$1 \x3d G__20948__1;\nG__20948.cljs$core$IFn$_invoke$arity$2 \x3d G__20948__2;\nreturn G__20948;\n})()\n);\n\n(cljs.core.Cons.prototype.lastIndexOf \x3d (function() {\nvar G__20949 \x3d null;\nvar G__20949__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__20949__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20949 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20949__1.call(this,x);\ncase 2:\nreturn G__20949__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20949.cljs$core$IFn$_invoke$arity$1 \x3d G__20949__1;\nG__20949.cljs$core$IFn$_invoke$arity$2 \x3d G__20949__2;\nreturn G__20949;\n})()\n);\n\n(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));\n}));\n\n(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.rest \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core.seq(self__.rest);\n}\n}));\n\n(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4232__auto__ \x3d self__.__hash;\nif((!((h__4232__auto__ \x3d\x3d null)))){\nreturn h__4232__auto__;\n} else {\nvar h__4232__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\n(self__.__hash \x3d h__4232__auto____$1);\n\nreturn h__4232__auto____$1;\n}\n}));\n\n(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n}));\n\n(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n}));\n\n(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n}));\n\n(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n}));\n\n(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.first;\n}));\n\n(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.rest \x3d\x3d null)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.rest;\n}\n}));\n\n(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n}));\n\n(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));\n}\n}));\n\n(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.Cons(null,o,coll__$1,null));\n}));\n\n(cljs.core.Cons.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),new cljs.core.Symbol(null,\x22first\x22,\x22first\x22,996428481,null),new cljs.core.Symbol(null,\x22rest\x22,\x22rest\x22,398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.Cons.cljs$lang$type \x3d true);\n\n(cljs.core.Cons.cljs$lang$ctorStr \x3d \x22cljs.core/Cons\x22);\n\n(cljs.core.Cons.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Cons\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Cons.\n */\ncljs.core.__GT_Cons \x3d (function cljs$core$__GT_Cons(meta,first,rest,__hash){\nreturn (new cljs.core.Cons(meta,first,rest,__hash));\n});\n\ngoog.object.set(cljs.core.Cons.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\n/**\n * Returns a new seq where x is the first element and coll is the rest.\n */\ncljs.core.cons \x3d (function cljs$core$cons(x,coll){\nif((coll \x3d\x3d null)){\nreturn (new cljs.core.List(null,x,null,(1),null));\n} else {\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false)){\nreturn (new cljs.core.Cons(null,x,coll,null));\n} else {\nreturn (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));\n\n}\n}\n});\ncljs.core.hash_keyword \x3d (function cljs$core$hash_keyword(k){\nreturn ((cljs.core.hash_symbol(k) + (2654435769)) | (0));\n});\ncljs.core.compare_keywords \x3d (function cljs$core$compare_keywords(a,b){\nif((a.fqn \x3d\x3d\x3d b.fqn)){\nreturn (0);\n} else {\nif(cljs.core.truth_(((cljs.core.not(a.ns))?b.ns:false))){\nreturn (-1);\n} else {\nif(cljs.core.truth_(a.ns)){\nif(cljs.core.not(b.ns)){\nreturn (1);\n} else {\nvar nsc \x3d goog.array.defaultCompare(a.ns,b.ns);\nif(((0) \x3d\x3d\x3d nsc)){\nreturn goog.array.defaultCompare(a.name,b.name);\n} else {\nreturn nsc;\n}\n}\n} else {\nreturn goog.array.defaultCompare(a.name,b.name);\n\n}\n}\n}\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.INamed}\n * @implements {cljs.core.IPrintWithWriter}\n*/\ncljs.core.Keyword \x3d (function (ns,name,fqn,_hash){\nthis.ns \x3d ns;\nthis.name \x3d name;\nthis.fqn \x3d fqn;\nthis._hash \x3d _hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 2153775105;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 4096;\n});\n(cljs.core.Keyword.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn [\x22:\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(\x27\x27);\n}));\n\n(cljs.core.Keyword.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (_,other){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif((other instanceof cljs.core.Keyword)){\nreturn (self__.fqn \x3d\x3d\x3d other.fqn);\n} else {\nreturn false;\n}\n}));\n\n(cljs.core.Keyword.prototype.call \x3d (function (unused__10738__auto__){\nvar self__ \x3d this;\nvar self__ \x3d this;\nvar G__18710 \x3d (arguments.length - (1));\nswitch (G__18710) {\ncase (1):\nreturn self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));\n\nbreak;\ncase (2):\nreturn self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join(\x27\x27)));\n\n}\n}));\n\n(cljs.core.Keyword.prototype.apply \x3d (function (self__,args18709){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18709)));\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar kw \x3d this;\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,not_found){\nvar self__ \x3d this;\nvar kw \x3d this;\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (this$){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nvar h__4232__auto__ \x3d self__._hash;\nif((!((h__4232__auto__ \x3d\x3d null)))){\nreturn h__4232__auto__;\n} else {\nvar h__4232__auto____$1 \x3d cljs.core.hash_keyword(this$__$1);\n(self__._hash \x3d h__4232__auto____$1);\n\nreturn h__4232__auto____$1;\n}\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.name;\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.ns;\n}));\n\n(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 \x3d (function (o,writer,_){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn cljs.core._write(writer,[\x22:\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(\x27\x27));\n}));\n\n(cljs.core.Keyword.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22ns\x22,\x22ns\x22,2082130287,null),new cljs.core.Symbol(null,\x22name\x22,\x22name\x22,-810760592,null),new cljs.core.Symbol(null,\x22fqn\x22,\x22fqn\x22,-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_hash\x22,\x22_hash\x22,-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.Keyword.cljs$lang$type \x3d true);\n\n(cljs.core.Keyword.cljs$lang$ctorStr \x3d \x22cljs.core/Keyword\x22);\n\n(cljs.core.Keyword.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Keyword\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Keyword.\n */\ncljs.core.__GT_Keyword \x3d (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){\nreturn (new cljs.core.Keyword(ns,name,fqn,_hash));\n});\n\n/**\n * Return true if x is a Keyword\n */\ncljs.core.keyword_QMARK_ \x3d (function cljs$core$keyword_QMARK_(x){\nreturn (x instanceof cljs.core.Keyword);\n});\n/**\n * Efficient test to determine that two keywords are identical.\n */\ncljs.core.keyword_identical_QMARK_ \x3d (function cljs$core$keyword_identical_QMARK_(x,y){\nif((x \x3d\x3d\x3d y)){\nreturn true;\n} else {\nif((((x instanceof cljs.core.Keyword)) \x26\x26 ((y instanceof cljs.core.Keyword)))){\nreturn (x.fqn \x3d\x3d\x3d y.fqn);\n} else {\nreturn false;\n}\n}\n});\n/**\n * Efficient test to determine that two symbols are identical.\n */\ncljs.core.symbol_identical_QMARK_ \x3d (function cljs$core$symbol_identical_QMARK_(x,y){\nif((x \x3d\x3d\x3d y)){\nreturn true;\n} else {\nif((((x instanceof cljs.core.Symbol)) \x26\x26 ((y instanceof cljs.core.Symbol)))){\nreturn (x.str \x3d\x3d\x3d y.str);\n} else {\nreturn false;\n}\n}\n});\n/**\n * Returns the namespace String of a symbol or keyword, or nil if not present.\n */\ncljs.core.namespace \x3d (function cljs$core$namespace(x){\nif((((!((x \x3d\x3d null))))?(((((x.cljs$lang$protocol_mask$partition1$ \x26 (4096))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$INamed$))))?true:false):false)){\nreturn x.cljs$core$INamed$_namespace$arity$1(null);\n} else {\nthrow (new Error([\x22Doesn\x27t support namespace: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(\x27\x27)));\n}\n});\n/**\n * Return true if x is a symbol or keyword\n */\ncljs.core.ident_QMARK_ \x3d (function cljs$core$ident_QMARK_(x){\nreturn (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));\n});\n/**\n * Return true if x is a symbol or keyword without a namespace\n */\ncljs.core.simple_ident_QMARK_ \x3d (function cljs$core$simple_ident_QMARK_(x){\nreturn ((cljs.core.ident_QMARK_(x)) \x26\x26 ((cljs.core.namespace(x) \x3d\x3d null)));\n});\n/**\n * Return true if x is a symbol or keyword with a namespace\n */\ncljs.core.qualified_ident_QMARK_ \x3d (function cljs$core$qualified_ident_QMARK_(x){\nreturn cljs.core.boolean$(((cljs.core.ident_QMARK_(x))?(function (){var and__4109__auto__ \x3d cljs.core.namespace(x);\nif(cljs.core.truth_(and__4109__auto__)){\nreturn true;\n} else {\nreturn and__4109__auto__;\n}\n})():false));\n});\n/**\n * Return true if x is a symbol without a namespace\n */\ncljs.core.simple_symbol_QMARK_ \x3d (function cljs$core$simple_symbol_QMARK_(x){\nreturn (((x instanceof cljs.core.Symbol)) \x26\x26 ((cljs.core.namespace(x) \x3d\x3d null)));\n});\n/**\n * Return true if x is a symbol with a namespace\n */\ncljs.core.qualified_symbol_QMARK_ \x3d (function cljs$core$qualified_symbol_QMARK_(x){\nreturn cljs.core.boolean$((((x instanceof cljs.core.Symbol))?(function (){var and__4109__auto__ \x3d cljs.core.namespace(x);\nif(cljs.core.truth_(and__4109__auto__)){\nreturn true;\n} else {\nreturn and__4109__auto__;\n}\n})():false));\n});\n/**\n * Return true if x is a keyword without a namespace\n */\ncljs.core.simple_keyword_QMARK_ \x3d (function cljs$core$simple_keyword_QMARK_(x){\nreturn (((x instanceof cljs.core.Keyword)) \x26\x26 ((cljs.core.namespace(x) \x3d\x3d null)));\n});\n/**\n * Return true if x is a keyword with a namespace\n */\ncljs.core.qualified_keyword_QMARK_ \x3d (function cljs$core$qualified_keyword_QMARK_(x){\nreturn cljs.core.boolean$((((x instanceof cljs.core.Keyword))?(function (){var and__4109__auto__ \x3d cljs.core.namespace(x);\nif(cljs.core.truth_(and__4109__auto__)){\nreturn true;\n} else {\nreturn and__4109__auto__;\n}\n})():false));\n});\n/**\n * Returns a Keyword with the given namespace and name.  Do not use :\n *   in the keyword strings, it will be added automatically.\n */\ncljs.core.keyword \x3d (function cljs$core$keyword(var_args){\nvar G__18713 \x3d arguments.length;\nswitch (G__18713) {\ncase 1:\nreturn cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 \x3d (function (name){\nif((name instanceof cljs.core.Keyword)){\nreturn name;\n} else {\nif((name instanceof cljs.core.Symbol)){\nreturn (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));\n} else {\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(\x22/\x22,name)){\nreturn (new cljs.core.Keyword(null,name,name,null));\n} else {\nif(typeof name \x3d\x3d\x3d \x27string\x27){\nvar parts \x3d name.split(\x22/\x22);\nif((parts.length \x3d\x3d\x3d (2))){\nreturn (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));\n} else {\nreturn (new cljs.core.Keyword(null,(parts[(0)]),name,null));\n}\n} else {\nreturn null;\n}\n}\n}\n}\n}));\n\n(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 \x3d (function (ns,name){\nvar ns__$1 \x3d (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):ns\n));\nvar name__$1 \x3d (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):name\n));\nreturn (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),\x22/\x22].join(\x27\x27):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(\x27\x27),null));\n}));\n\n(cljs.core.keyword.cljs$lang$maxFixedArity \x3d 2);\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IPending}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.LazySeq \x3d (function (meta,fn,s,__hash){\nthis.meta \x3d meta;\nthis.fn \x3d fn;\nthis.s \x3d s;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 32374988;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 1;\n});\n(cljs.core.LazySeq.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.LazySeq.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.LazySeq.prototype.sval \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nif((self__.fn \x3d\x3d null)){\nreturn self__.s;\n} else {\n(self__.s \x3d (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));\n\n(self__.fn \x3d null);\n\nreturn self__.s;\n}\n}));\n\n(cljs.core.LazySeq.prototype.indexOf \x3d (function() {\nvar G__20968 \x3d null;\nvar G__20968__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20968__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20968 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20968__1.call(this,x);\ncase 2:\nreturn G__20968__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20968.cljs$core$IFn$_invoke$arity$1 \x3d G__20968__1;\nG__20968.cljs$core$IFn$_invoke$arity$2 \x3d G__20968__2;\nreturn G__20968;\n})()\n);\n\n(cljs.core.LazySeq.prototype.lastIndexOf \x3d (function() {\nvar G__20969 \x3d null;\nvar G__20969__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__20969__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20969 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20969__1.call(this,x);\ncase 2:\nreturn G__20969__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20969.cljs$core$IFn$_invoke$arity$1 \x3d G__20969__1;\nG__20969.cljs$core$IFn$_invoke$arity$2 \x3d G__20969__2;\nreturn G__20969;\n})()\n);\n\n(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n\nif((self__.s \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core.next(self__.s);\n}\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4232__auto__ \x3d self__.__hash;\nif((!((h__4232__auto__ \x3d\x3d null)))){\nreturn h__4232__auto__;\n} else {\nvar h__4232__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\n(self__.__hash \x3d h__4232__auto____$1);\n\nreturn h__4232__auto____$1;\n}\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.not(self__.fn);\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n\nif((self__.s \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core.first(self__.s);\n}\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n\nif((!((self__.s \x3d\x3d null)))){\nreturn cljs.core.rest(self__.s);\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.sval();\n\nif((self__.s \x3d\x3d null)){\nreturn null;\n} else {\nvar ls \x3d self__.s;\nwhile(true){\nif((ls instanceof cljs.core.LazySeq)){\nvar G__20970 \x3d ls.sval();\nls \x3d G__20970;\ncontinue;\n} else {\n(self__.s \x3d ls);\n\nreturn cljs.core.seq(self__.s);\n}\nbreak;\n}\n}\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.LazySeq(new_meta,(function (){\nreturn coll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n}),null,self__.__hash));\n}\n}));\n\n(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.cons(o,coll__$1);\n}));\n\n(cljs.core.LazySeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22fn\x22,\x22fn\x22,465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22s\x22,\x22s\x22,-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.LazySeq.cljs$lang$type \x3d true);\n\n(cljs.core.LazySeq.cljs$lang$ctorStr \x3d \x22cljs.core/LazySeq\x22);\n\n(cljs.core.LazySeq.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/LazySeq\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/LazySeq.\n */\ncljs.core.__GT_LazySeq \x3d (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){\nreturn (new cljs.core.LazySeq(meta,fn,s,__hash));\n});\n\ngoog.object.set(cljs.core.LazySeq.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\n\n/**\n* @constructor\n * @implements {cljs.core.ICounted}\n*/\ncljs.core.ChunkBuffer \x3d (function (buf,end){\nthis.buf \x3d buf;\nthis.end \x3d end;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 2;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.ChunkBuffer.prototype.add \x3d (function (o){\nvar self__ \x3d this;\nvar _ \x3d this;\n(self__.buf[self__.end] \x3d o);\n\nreturn (self__.end \x3d (self__.end + (1)));\n}));\n\n(cljs.core.ChunkBuffer.prototype.chunk \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar ret \x3d (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));\n(self__.buf \x3d null);\n\nreturn ret;\n}));\n\n(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.end;\n}));\n\n(cljs.core.ChunkBuffer.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22buf\x22,\x22buf\x22,1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22end\x22,\x22end\x22,1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.ChunkBuffer.cljs$lang$type \x3d true);\n\n(cljs.core.ChunkBuffer.cljs$lang$ctorStr \x3d \x22cljs.core/ChunkBuffer\x22);\n\n(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/ChunkBuffer\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/ChunkBuffer.\n */\ncljs.core.__GT_ChunkBuffer \x3d (function cljs$core$__GT_ChunkBuffer(buf,end){\nreturn (new cljs.core.ChunkBuffer(buf,end));\n});\n\ncljs.core.chunk_buffer \x3d (function cljs$core$chunk_buffer(capacity){\nreturn (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IIndexed}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.IChunk}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.ArrayChunk \x3d (function (arr,off,end){\nthis.arr \x3d arr;\nthis.off \x3d off;\nthis.end \x3d end;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 524306;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (self__.end - self__.off);\n}));\n\n(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 \x3d (function (coll,i){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (self__.arr[(self__.off + i)]);\n}));\n\n(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 \x3d (function (coll,i,not_found){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((((i \x3e\x3d (0))) \x26\x26 ((i \x3c (self__.end - self__.off))))){\nreturn (self__.arr[(self__.off + i)]);\n} else {\nreturn not_found;\n}\n}));\n\n(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ \x3d cljs.core.PROTOCOL_SENTINEL);\n\n(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.off \x3d\x3d\x3d self__.end)){\nthrow (new Error(\x22-drop-first of empty chunk\x22));\n} else {\nreturn (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));\n}\n}));\n\n(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));\n}));\n\n(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);\n}));\n\n(cljs.core.ArrayChunk.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),new cljs.core.Symbol(null,\x22off\x22,\x22off\x22,-2047994980,null),new cljs.core.Symbol(null,\x22end\x22,\x22end\x22,1372345569,null)], null);\n}));\n\n(cljs.core.ArrayChunk.cljs$lang$type \x3d true);\n\n(cljs.core.ArrayChunk.cljs$lang$ctorStr \x3d \x22cljs.core/ArrayChunk\x22);\n\n(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/ArrayChunk\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/ArrayChunk.\n */\ncljs.core.__GT_ArrayChunk \x3d (function cljs$core$__GT_ArrayChunk(arr,off,end){\nreturn (new cljs.core.ArrayChunk(arr,off,end));\n});\n\ncljs.core.array_chunk \x3d (function cljs$core$array_chunk(var_args){\nvar G__18715 \x3d arguments.length;\nswitch (G__18715) {\ncase 1:\nreturn cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 \x3d (function (arr){\nreturn (new cljs.core.ArrayChunk(arr,(0),arr.length));\n}));\n\n(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 \x3d (function (arr,off){\nreturn (new cljs.core.ArrayChunk(arr,off,arr.length));\n}));\n\n(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 \x3d (function (arr,off,end){\nreturn (new cljs.core.ArrayChunk(arr,off,end));\n}));\n\n(cljs.core.array_chunk.cljs$lang$maxFixedArity \x3d 3);\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IChunkedNext}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.IChunkedSeq}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.ChunkedCons \x3d (function (chunk,more,meta,__hash){\nthis.chunk \x3d chunk;\nthis.more \x3d more;\nthis.meta \x3d meta;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 31850732;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 1536;\n});\n(cljs.core.ChunkedCons.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n}));\n\n(cljs.core.ChunkedCons.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.ChunkedCons.prototype.indexOf \x3d (function() {\nvar G__20972 \x3d null;\nvar G__20972__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__20972__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20972 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20972__1.call(this,x);\ncase 2:\nreturn G__20972__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20972.cljs$core$IFn$_invoke$arity$1 \x3d G__20972__1;\nG__20972.cljs$core$IFn$_invoke$arity$2 \x3d G__20972__2;\nreturn G__20972;\n})()\n);\n\n(cljs.core.ChunkedCons.prototype.lastIndexOf \x3d (function() {\nvar G__20973 \x3d null;\nvar G__20973__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__20973__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__20973 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__20973__1.call(this,x);\ncase 2:\nreturn G__20973__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__20973.cljs$core$IFn$_invoke$arity$1 \x3d G__20973__1;\nG__20973.cljs$core$IFn$_invoke$arity$2 \x3d G__20973__2;\nreturn G__20973;\n})()\n);\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((cljs.core._count(self__.chunk) \x3e (1))){\nreturn (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));\n} else {\nif((self__.more \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._seq(self__.more);\n}\n}\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4232__auto__ \x3d self__.__hash;\nif((!((h__4232__auto__ \x3d\x3d null)))){\nreturn h__4232__auto__;\n} else {\nvar h__4232__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\n(self__.__hash \x3d h__4232__auto____$1);\n\nreturn h__4232__auto____$1;\n}\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._nth(self__.chunk,(0));\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((cljs.core._count(self__.chunk) \x3e (1))){\nreturn (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));\n} else {\nif((self__.more \x3d\x3d null)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.more;\n}\n}\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.chunk;\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.more \x3d\x3d null)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.more;\n}\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((new_meta \x3d\x3d\x3d self__.meta)){\nreturn coll__$1;\n} else {\nreturn (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));\n}\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (this$,o){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nreturn cljs.core.cons(o,this$__$1);\n}));\n\n(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.more \x3d\x3d null)){\nreturn null;\n} else {\nreturn self__.more;\n}\n}));\n\n(cljs.core.ChunkedCons.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22chunk\x22,\x22chunk\x22,449371907,null),new cljs.core.Symbol(null,\x22more\x22,\x22more\x22,-418290273,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.ChunkedCons.cljs$lang$type \x3d true);\n\n(cljs.core.ChunkedCons.cljs$lang$ctorStr \x3d \x22cljs.core/ChunkedCons\x22);\n\n(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/ChunkedCons\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/ChunkedCons.\n */\ncljs.core.__GT_ChunkedCons \x3d (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){\nreturn (new cljs.core.ChunkedCons(chunk,more,meta,__hash));\n});\n\ngoog.object.set(cljs.core.ChunkedCons.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\ncljs.core.chunk_cons \x3d (function cljs$core$chunk_cons(chunk,rest){\nif((cljs.core._count(chunk) \x3d\x3d\x3d (0))){\nreturn rest;\n} else {\nreturn (new cljs.core.ChunkedCons(chunk,rest,null,null));\n}\n});\ncljs.core.chunk_append \x3d (function cljs$core$chunk_append(b,x){\nreturn b.add(x);\n});\ncljs.core.chunk \x3d (function cljs$core$chunk(b){\nreturn b.chunk();\n});\ncljs.core.chunk_first \x3d (function cljs$core$chunk_first(s){\nreturn cljs.core._chunked_first(s);\n});\ncljs.core.chunk_rest \x3d (function cljs$core$chunk_rest(s){\nreturn cljs.core._chunked_rest(s);\n});\ncljs.core.chunk_next \x3d (function cljs$core$chunk_next(s){\nif((((!((s \x3d\x3d null))))?(((((s.cljs$lang$protocol_mask$partition1$ \x26 (1024))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d s.cljs$core$IChunkedNext$))))?true:false):false)){\nreturn s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);\n} else {\nreturn cljs.core.seq(cljs.core._chunked_rest(s));\n}\n});\n/**\n * Returns an array containing the contents of coll.\n */\ncljs.core.to_array \x3d (function cljs$core$to_array(coll){\nvar ary \x3d [];\nvar s \x3d cljs.core.seq(coll);\nwhile(true){\nif((!((s \x3d\x3d null)))){\nary.push(cljs.core.first(s));\n\nvar G__20981 \x3d cljs.core.next(s);\ns \x3d G__20981;\ncontinue;\n} else {\nreturn ary;\n}\nbreak;\n}\n});\n/**\n * Returns a (potentially-ragged) 2-dimensional array\n *   containing the contents of coll.\n */\ncljs.core.to_array_2d \x3d (function cljs$core$to_array_2d(coll){\nvar ret \x3d (new Array(cljs.core.count(coll)));\nvar i_20982 \x3d (0);\nvar xs_20983 \x3d cljs.core.seq(coll);\nwhile(true){\nif((xs_20983 \x3d\x3d null)){\n} else {\n(ret[i_20982] \x3d cljs.core.to_array(cljs.core.first(xs_20983)));\n\nvar G__20984 \x3d (i_20982 + (1));\nvar G__20985 \x3d cljs.core.next(xs_20983);\ni_20982 \x3d G__20984;\nxs_20983 \x3d G__20985;\ncontinue;\n}\nbreak;\n}\n\nreturn ret;\n});\n/**\n * Creates an array of ints. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.int_array \x3d (function cljs$core$int_array(var_args){\nvar G__18718 \x3d arguments.length;\nswitch (G__18718) {\ncase 1:\nreturn cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n}));\n\n(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__20987 \x3d (i + (1));\nvar G__20988 \x3d cljs.core.next(s__$1);\ni \x3d G__20987;\ns__$1 \x3d G__20988;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4607__auto___20989 \x3d size;\nvar i_20990 \x3d (0);\nwhile(true){\nif((i_20990 \x3c n__4607__auto___20989)){\n(a[i_20990] \x3d init_val_or_seq);\n\nvar G__20991 \x3d (i_20990 + (1));\ni_20990 \x3d G__20991;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n}));\n\n(cljs.core.int_array.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Creates an array of longs. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.long_array \x3d (function cljs$core$long_array(var_args){\nvar G__18720 \x3d arguments.length;\nswitch (G__18720) {\ncase 1:\nreturn cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n}));\n\n(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__20995 \x3d (i + (1));\nvar G__20996 \x3d cljs.core.next(s__$1);\ni \x3d G__20995;\ns__$1 \x3d G__20996;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4607__auto___20997 \x3d size;\nvar i_20998 \x3d (0);\nwhile(true){\nif((i_20998 \x3c n__4607__auto___20997)){\n(a[i_20998] \x3d init_val_or_seq);\n\nvar G__20999 \x3d (i_20998 + (1));\ni_20998 \x3d G__20999;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n}));\n\n(cljs.core.long_array.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Creates an array of doubles. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.double_array \x3d (function cljs$core$double_array(var_args){\nvar G__18722 \x3d arguments.length;\nswitch (G__18722) {\ncase 1:\nreturn cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n}));\n\n(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__21001 \x3d (i + (1));\nvar G__21002 \x3d cljs.core.next(s__$1);\ni \x3d G__21001;\ns__$1 \x3d G__21002;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4607__auto___21003 \x3d size;\nvar i_21004 \x3d (0);\nwhile(true){\nif((i_21004 \x3c n__4607__auto___21003)){\n(a[i_21004] \x3d init_val_or_seq);\n\nvar G__21005 \x3d (i_21004 + (1));\ni_21004 \x3d G__21005;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n}));\n\n(cljs.core.double_array.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Creates an array of objects. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.object_array \x3d (function cljs$core$object_array(var_args){\nvar G__18724 \x3d arguments.length;\nswitch (G__18724) {\ncase 1:\nreturn cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n}));\n\n(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__21007 \x3d (i + (1));\nvar G__21008 \x3d cljs.core.next(s__$1);\ni \x3d G__21007;\ns__$1 \x3d G__21008;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4607__auto___21009 \x3d size;\nvar i_21010 \x3d (0);\nwhile(true){\nif((i_21010 \x3c n__4607__auto___21009)){\n(a[i_21010] \x3d init_val_or_seq);\n\nvar G__21011 \x3d (i_21010 + (1));\ni_21010 \x3d G__21011;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n}));\n\n(cljs.core.object_array.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * If coll is counted? returns its count, else will count at most the first n\n * elements of coll using its seq\n */\ncljs.core.bounded_count \x3d (function cljs$core$bounded_count(n,coll){\nif(cljs.core.counted_QMARK_(coll)){\nreturn cljs.core.count(coll);\n} else {\nvar i \x3d (0);\nvar s \x3d cljs.core.seq(coll);\nwhile(true){\nif((((!((s \x3d\x3d null)))) \x26\x26 ((i \x3c n)))){\nvar G__21012 \x3d (i + (1));\nvar G__21013 \x3d cljs.core.next(s);\ni \x3d G__21012;\ns \x3d G__21013;\ncontinue;\n} else {\nreturn i;\n}\nbreak;\n}\n}\n});\ncljs.core.spread \x3d (function cljs$core$spread(arglist){\nif((arglist \x3d\x3d null)){\nreturn null;\n} else {\nvar n \x3d cljs.core.next(arglist);\nif((n \x3d\x3d null)){\nreturn cljs.core.seq(cljs.core.first(arglist));\n} else {\nreturn cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));\n}\n}\n});\n/**\n * Returns a lazy seq representing the concatenation of the elements in the supplied colls.\n */\ncljs.core.concat \x3d (function cljs$core$concat(var_args){\nvar G__18729 \x3d arguments.length;\nswitch (G__18729) {\ncase 0:\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21015 \x3d arguments.length;\nvar i__4731__auto___21016 \x3d (0);\nwhile(true){\nif((i__4731__auto___21016 \x3c len__4730__auto___21015)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21016]));\n\nvar G__21017 \x3d (i__4731__auto___21016 + (1));\ni__4731__auto___21016 \x3d G__21017;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (new cljs.core.LazySeq(null,(function (){\nreturn null;\n}),null,null));\n}));\n\n(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (new cljs.core.LazySeq(null,(function (){\nreturn x;\n}),null,null));\n}));\n\n(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (new cljs.core.LazySeq(null,(function (){\nvar s \x3d cljs.core.seq(x);\nif(s){\nif(cljs.core.chunked_seq_QMARK_(s)){\nreturn cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));\n} else {\nreturn cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));\n}\n} else {\nreturn y;\n}\n}),null,null));\n}));\n\n(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,zs){\nvar cat \x3d (function cljs$core$cat(xys,zs__$1){\nreturn (new cljs.core.LazySeq(null,(function (){\nvar xys__$1 \x3d cljs.core.seq(xys);\nif(xys__$1){\nif(cljs.core.chunked_seq_QMARK_(xys__$1)){\nreturn cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));\n} else {\nreturn cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));\n}\n} else {\nif(cljs.core.truth_(zs__$1)){\nreturn cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));\n} else {\nreturn null;\n}\n}\n}),null,null));\n});\nreturn cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);\n}));\n\n/** @this {Function} */\n(cljs.core.concat.cljs$lang$applyTo \x3d (function (seq18726){\nvar G__18727 \x3d cljs.core.first(seq18726);\nvar seq18726__$1 \x3d cljs.core.next(seq18726);\nvar G__18728 \x3d cljs.core.first(seq18726__$1);\nvar seq18726__$2 \x3d cljs.core.next(seq18726__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18727,G__18728,seq18726__$2);\n}));\n\n(cljs.core.concat.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Creates a new list containing the items prepended to the rest, the\n *   last of which will be treated as a sequence.\n */\ncljs.core.list_STAR_ \x3d (function cljs$core$list_STAR_(var_args){\nvar G__18736 \x3d arguments.length;\nswitch (G__18736) {\ncase 1:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21021 \x3d arguments.length;\nvar i__4731__auto___21022 \x3d (0);\nwhile(true){\nif((i__4731__auto___21022 \x3c len__4730__auto___21021)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21022]));\n\nvar G__21024 \x3d (i__4731__auto___21022 + (1));\ni__4731__auto___21022 \x3d G__21024;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 \x3d (function (args){\nreturn cljs.core.seq(args);\n}));\n\n(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 \x3d (function (a,args){\nreturn cljs.core.cons(a,args);\n}));\n\n(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 \x3d (function (a,b,args){\nreturn cljs.core.cons(a,cljs.core.cons(b,args));\n}));\n\n(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 \x3d (function (a,b,c,args){\nreturn cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));\n}));\n\n(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (a,b,c,d,more){\nreturn cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));\n}));\n\n/** @this {Function} */\n(cljs.core.list_STAR_.cljs$lang$applyTo \x3d (function (seq18731){\nvar G__18732 \x3d cljs.core.first(seq18731);\nvar seq18731__$1 \x3d cljs.core.next(seq18731);\nvar G__18733 \x3d cljs.core.first(seq18731__$1);\nvar seq18731__$2 \x3d cljs.core.next(seq18731__$1);\nvar G__18734 \x3d cljs.core.first(seq18731__$2);\nvar seq18731__$3 \x3d cljs.core.next(seq18731__$2);\nvar G__18735 \x3d cljs.core.first(seq18731__$3);\nvar seq18731__$4 \x3d cljs.core.next(seq18731__$3);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18732,G__18733,G__18734,G__18735,seq18731__$4);\n}));\n\n(cljs.core.list_STAR_.cljs$lang$maxFixedArity \x3d (4));\n\n/**\n * Returns a new, transient version of the collection, in constant time.\n */\ncljs.core.transient$ \x3d (function cljs$core$transient(coll){\nreturn cljs.core._as_transient(coll);\n});\n/**\n * Returns a new, persistent version of the transient collection, in\n *   constant time. The transient collection cannot be used after this\n *   call, any such use will throw an exception.\n */\ncljs.core.persistent_BANG_ \x3d (function cljs$core$persistent_BANG_(tcoll){\nreturn cljs.core._persistent_BANG_(tcoll);\n});\n/**\n * Adds val to the transient collection, and return tcoll. The \x27addition\x27\n *   may happen at different \x27places\x27 depending on the concrete type.\n */\ncljs.core.conj_BANG_ \x3d (function cljs$core$conj_BANG_(var_args){\nvar G__18741 \x3d arguments.length;\nswitch (G__18741) {\ncase 0:\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21026 \x3d arguments.length;\nvar i__4731__auto___21027 \x3d (0);\nwhile(true){\nif((i__4731__auto___21027 \x3c len__4730__auto___21026)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21027]));\n\nvar G__21029 \x3d (i__4731__auto___21027 + (1));\ni__4731__auto___21027 \x3d G__21029;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn cljs.core.transient$(cljs.core.PersistentVector.EMPTY);\n}));\n\n(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 \x3d (function (tcoll){\nreturn tcoll;\n}));\n\n(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (tcoll,val){\nreturn cljs.core._conj_BANG_(tcoll,val);\n}));\n\n(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,val,vals){\nwhile(true){\nvar ntcoll \x3d cljs.core._conj_BANG_(tcoll,val);\nif(cljs.core.truth_(vals)){\nvar G__21032 \x3d ntcoll;\nvar G__21033 \x3d cljs.core.first(vals);\nvar G__21034 \x3d cljs.core.next(vals);\ntcoll \x3d G__21032;\nval \x3d G__21033;\nvals \x3d G__21034;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.conj_BANG_.cljs$lang$applyTo \x3d (function (seq18738){\nvar G__18739 \x3d cljs.core.first(seq18738);\nvar seq18738__$1 \x3d cljs.core.next(seq18738);\nvar G__18740 \x3d cljs.core.first(seq18738__$1);\nvar seq18738__$2 \x3d cljs.core.next(seq18738__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18739,G__18740,seq18738__$2);\n}));\n\n(cljs.core.conj_BANG_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * When applied to a transient map, adds mapping of key(s) to\n *   val(s). When applied to a transient vector, sets the val at index.\n *   Note - index must be \x3c\x3d (count vector). Returns coll.\n */\ncljs.core.assoc_BANG_ \x3d (function cljs$core$assoc_BANG_(var_args){\nvar G__18747 \x3d arguments.length;\nswitch (G__18747) {\ncase 3:\nreturn cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21036 \x3d arguments.length;\nvar i__4731__auto___21037 \x3d (0);\nwhile(true){\nif((i__4731__auto___21037 \x3c len__4730__auto___21036)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21037]));\n\nvar G__21038 \x3d (i__4731__auto___21037 + (1));\ni__4731__auto___21037 \x3d G__21038;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));\nreturn cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 \x3d (function (tcoll,key,val){\nreturn cljs.core._assoc_BANG_(tcoll,key,val);\n}));\n\n(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,key,val,kvs){\nwhile(true){\nvar ntcoll \x3d cljs.core._assoc_BANG_(tcoll,key,val);\nif(cljs.core.truth_(kvs)){\nvar G__21039 \x3d ntcoll;\nvar G__21040 \x3d cljs.core.first(kvs);\nvar G__21041 \x3d cljs.core.second(kvs);\nvar G__21042 \x3d cljs.core.nnext(kvs);\ntcoll \x3d G__21039;\nkey \x3d G__21040;\nval \x3d G__21041;\nkvs \x3d G__21042;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.assoc_BANG_.cljs$lang$applyTo \x3d (function (seq18743){\nvar G__18744 \x3d cljs.core.first(seq18743);\nvar seq18743__$1 \x3d cljs.core.next(seq18743);\nvar G__18745 \x3d cljs.core.first(seq18743__$1);\nvar seq18743__$2 \x3d cljs.core.next(seq18743__$1);\nvar G__18746 \x3d cljs.core.first(seq18743__$2);\nvar seq18743__$3 \x3d cljs.core.next(seq18743__$2);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18744,G__18745,G__18746,seq18743__$3);\n}));\n\n(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity \x3d (3));\n\n/**\n * Returns a transient map that doesn\x27t contain a mapping for key(s).\n */\ncljs.core.dissoc_BANG_ \x3d (function cljs$core$dissoc_BANG_(var_args){\nvar G__18752 \x3d arguments.length;\nswitch (G__18752) {\ncase 2:\nreturn cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21044 \x3d arguments.length;\nvar i__4731__auto___21045 \x3d (0);\nwhile(true){\nif((i__4731__auto___21045 \x3c len__4730__auto___21044)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21045]));\n\nvar G__21047 \x3d (i__4731__auto___21045 + (1));\ni__4731__auto___21045 \x3d G__21047;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (tcoll,key){\nreturn cljs.core._dissoc_BANG_(tcoll,key);\n}));\n\n(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,key,ks){\nwhile(true){\nvar ntcoll \x3d cljs.core._dissoc_BANG_(tcoll,key);\nif(cljs.core.truth_(ks)){\nvar G__21048 \x3d ntcoll;\nvar G__21049 \x3d cljs.core.first(ks);\nvar G__21050 \x3d cljs.core.next(ks);\ntcoll \x3d G__21048;\nkey \x3d G__21049;\nks \x3d G__21050;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.dissoc_BANG_.cljs$lang$applyTo \x3d (function (seq18749){\nvar G__18750 \x3d cljs.core.first(seq18749);\nvar seq18749__$1 \x3d cljs.core.next(seq18749);\nvar G__18751 \x3d cljs.core.first(seq18749__$1);\nvar seq18749__$2 \x3d cljs.core.next(seq18749__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18750,G__18751,seq18749__$2);\n}));\n\n(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Removes the last item from a transient vector. If\n *   the collection is empty, throws an exception. Returns tcoll\n */\ncljs.core.pop_BANG_ \x3d (function cljs$core$pop_BANG_(tcoll){\nreturn cljs.core._pop_BANG_(tcoll);\n});\n/**\n * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that\n *   does not contain key(s).\n */\ncljs.core.disj_BANG_ \x3d (function cljs$core$disj_BANG_(var_args){\nvar G__18757 \x3d arguments.length;\nswitch (G__18757) {\ncase 2:\nreturn cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21052 \x3d arguments.length;\nvar i__4731__auto___21053 \x3d (0);\nwhile(true){\nif((i__4731__auto___21053 \x3c len__4730__auto___21052)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21053]));\n\nvar G__21055 \x3d (i__4731__auto___21053 + (1));\ni__4731__auto___21053 \x3d G__21055;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (tcoll,val){\nreturn cljs.core._disjoin_BANG_(tcoll,val);\n}));\n\n(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,val,vals){\nwhile(true){\nvar ntcoll \x3d cljs.core._disjoin_BANG_(tcoll,val);\nif(cljs.core.truth_(vals)){\nvar G__21056 \x3d ntcoll;\nvar G__21057 \x3d cljs.core.first(vals);\nvar G__21058 \x3d cljs.core.next(vals);\ntcoll \x3d G__21056;\nval \x3d G__21057;\nvals \x3d G__21058;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.disj_BANG_.cljs$lang$applyTo \x3d (function (seq18754){\nvar G__18755 \x3d cljs.core.first(seq18754);\nvar seq18754__$1 \x3d cljs.core.next(seq18754);\nvar G__18756 \x3d cljs.core.first(seq18754__$1);\nvar seq18754__$2 \x3d cljs.core.next(seq18754__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18755,G__18756,seq18754__$2);\n}));\n\n(cljs.core.disj_BANG_.cljs$lang$maxFixedArity \x3d (2));\n\n\ncljs.core.apply_to \x3d (function cljs$core$apply_to(f,argc,args){\nvar args__$1 \x3d cljs.core.seq(args);\nif((argc \x3d\x3d\x3d (0))){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n} else {\nvar a442 \x3d cljs.core._first(args__$1);\nvar args__$2 \x3d cljs.core._rest(args__$1);\nif((argc \x3d\x3d\x3d (1))){\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a442) : f.call(null,a442));\n} else {\nvar b443 \x3d cljs.core._first(args__$2);\nvar args__$3 \x3d cljs.core._rest(args__$2);\nif((argc \x3d\x3d\x3d (2))){\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a442,b443) : f.call(null,a442,b443));\n} else {\nvar c444 \x3d cljs.core._first(args__$3);\nvar args__$4 \x3d cljs.core._rest(args__$3);\nif((argc \x3d\x3d\x3d (3))){\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a442,b443,c444) : f.call(null,a442,b443,c444));\n} else {\nvar d445 \x3d cljs.core._first(args__$4);\nvar args__$5 \x3d cljs.core._rest(args__$4);\nif((argc \x3d\x3d\x3d (4))){\nreturn (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a442,b443,c444,d445) : f.call(null,a442,b443,c444,d445));\n} else {\nvar e446 \x3d cljs.core._first(args__$5);\nvar args__$6 \x3d cljs.core._rest(args__$5);\nif((argc \x3d\x3d\x3d (5))){\nreturn (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a442,b443,c444,d445,e446) : f.call(null,a442,b443,c444,d445,e446));\n} else {\nvar f447 \x3d cljs.core._first(args__$6);\nvar args__$7 \x3d cljs.core._rest(args__$6);\nif((argc \x3d\x3d\x3d (6))){\nreturn (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a442,b443,c444,d445,e446,f447) : f.call(null,a442,b443,c444,d445,e446,f447));\n} else {\nvar g448 \x3d cljs.core._first(args__$7);\nvar args__$8 \x3d cljs.core._rest(args__$7);\nif((argc \x3d\x3d\x3d (7))){\nreturn (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a442,b443,c444,d445,e446,f447,g448) : f.call(null,a442,b443,c444,d445,e446,f447,g448));\n} else {\nvar h449 \x3d cljs.core._first(args__$8);\nvar args__$9 \x3d cljs.core._rest(args__$8);\nif((argc \x3d\x3d\x3d (8))){\nreturn (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a442,b443,c444,d445,e446,f447,g448,h449) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449));\n} else {\nvar i450 \x3d cljs.core._first(args__$9);\nvar args__$10 \x3d cljs.core._rest(args__$9);\nif((argc \x3d\x3d\x3d (9))){\nreturn (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a442,b443,c444,d445,e446,f447,g448,h449,i450) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450));\n} else {\nvar j451 \x3d cljs.core._first(args__$10);\nvar args__$11 \x3d cljs.core._rest(args__$10);\nif((argc \x3d\x3d\x3d (10))){\nreturn (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451));\n} else {\nvar k452 \x3d cljs.core._first(args__$11);\nvar args__$12 \x3d cljs.core._rest(args__$11);\nif((argc \x3d\x3d\x3d (11))){\nreturn (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452));\n} else {\nvar l453 \x3d cljs.core._first(args__$12);\nvar args__$13 \x3d cljs.core._rest(args__$12);\nif((argc \x3d\x3d\x3d (12))){\nreturn (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453));\n} else {\nvar m454 \x3d cljs.core._first(args__$13);\nvar args__$14 \x3d cljs.core._rest(args__$13);\nif((argc \x3d\x3d\x3d (13))){\nreturn (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454));\n} else {\nvar n455 \x3d cljs.core._first(args__$14);\nvar args__$15 \x3d cljs.core._rest(args__$14);\nif((argc \x3d\x3d\x3d (14))){\nreturn (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455));\n} else {\nvar o456 \x3d cljs.core._first(args__$15);\nvar args__$16 \x3d cljs.core._rest(args__$15);\nif((argc \x3d\x3d\x3d (15))){\nreturn (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456));\n} else {\nvar p457 \x3d cljs.core._first(args__$16);\nvar args__$17 \x3d cljs.core._rest(args__$16);\nif((argc \x3d\x3d\x3d (16))){\nreturn (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457));\n} else {\nvar q458 \x3d cljs.core._first(args__$17);\nvar args__$18 \x3d cljs.core._rest(args__$17);\nif((argc \x3d\x3d\x3d (17))){\nreturn (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458));\n} else {\nvar r459 \x3d cljs.core._first(args__$18);\nvar args__$19 \x3d cljs.core._rest(args__$18);\nif((argc \x3d\x3d\x3d (18))){\nreturn (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458,r459) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458,r459));\n} else {\nvar s460 \x3d cljs.core._first(args__$19);\nvar args__$20 \x3d cljs.core._rest(args__$19);\nif((argc \x3d\x3d\x3d (19))){\nreturn (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458,r459,s460) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458,r459,s460));\n} else {\nvar t461 \x3d cljs.core._first(args__$20);\nvar args__$21 \x3d cljs.core._rest(args__$20);\nif((argc \x3d\x3d\x3d (20))){\nreturn (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458,r459,s460,t461) : f.call(null,a442,b443,c444,d445,e446,f447,g448,h449,i450,j451,k452,l453,m454,n455,o456,p457,q458,r459,s460,t461));\n} else {\nthrow (new Error(\x22Only up to 20 arguments supported on functions\x22));\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n});\n\n/**\n * Internal. DO NOT USE! Next without the nil? check.\n */\ncljs.core.next_STAR_ \x3d (function cljs$core$next_STAR_(coll){\nif((((!((coll \x3d\x3d null))))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (128))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$INext$))))?true:false):false)){\nreturn coll.cljs$core$INext$_next$arity$1(null);\n} else {\nreturn cljs.core.seq(cljs.core.rest(coll));\n}\n});\n/**\n * Internal. DO NOT USE!\n *   Assumes args was already called with seq beforehand!\n */\ncljs.core.apply_to_simple \x3d (function cljs$core$apply_to_simple(var_args){\nvar G__18760 \x3d arguments.length;\nswitch (G__18760) {\ncase 2:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase 6:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$0){\nreturn f.cljs$core$IFn$_invoke$arity$0();\n} else {\nreturn f.call(f);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));\n}\n}));\n\n(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,a0,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$1){\nreturn f.cljs$core$IFn$_invoke$arity$1(a0);\n} else {\nreturn f.call(f,a0);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));\n}\n}));\n\n(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 \x3d (function (f,a0,a1,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$2){\nreturn f.cljs$core$IFn$_invoke$arity$2(a0,a1);\n} else {\nreturn f.call(f,a0,a1);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));\n}\n}));\n\n(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 \x3d (function (f,a0,a1,a2,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$3){\nreturn f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);\n} else {\nreturn f.call(f,a0,a1,a2);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));\n}\n}));\n\n(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 \x3d (function (f,a0,a1,a2,a3,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$4){\nreturn f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);\n} else {\nreturn f.call(f,a0,a1,a2,a3);\n}\n} else {\nvar a4 \x3d cljs.core._first(args);\nvar next_4 \x3d cljs.core.next(args);\nif((next_4 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$5){\nreturn f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4);\n}\n} else {\nvar a5 \x3d cljs.core._first(next_4);\nvar next_5 \x3d cljs.core.next(next_4);\nif((next_5 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$6){\nreturn f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5);\n}\n} else {\nvar a6 \x3d cljs.core._first(next_5);\nvar next_6 \x3d cljs.core.next(next_5);\nif((next_6 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$7){\nreturn f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6);\n}\n} else {\nvar a7 \x3d cljs.core._first(next_6);\nvar next_7 \x3d cljs.core.next(next_6);\nif((next_7 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$8){\nreturn f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);\n}\n} else {\nvar a8 \x3d cljs.core._first(next_7);\nvar next_8 \x3d cljs.core.next(next_7);\nif((next_8 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$9){\nreturn f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);\n}\n} else {\nvar a9 \x3d cljs.core._first(next_8);\nvar next_9 \x3d cljs.core.next(next_8);\nif((next_9 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$10){\nreturn f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);\n}\n} else {\nvar a10 \x3d cljs.core._first(next_9);\nvar next_10 \x3d cljs.core.next(next_9);\nif((next_10 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$11){\nreturn f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);\n}\n} else {\nvar a11 \x3d cljs.core._first(next_10);\nvar next_11 \x3d cljs.core.next(next_10);\nif((next_11 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$12){\nreturn f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);\n}\n} else {\nvar a12 \x3d cljs.core._first(next_11);\nvar next_12 \x3d cljs.core.next(next_11);\nif((next_12 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$13){\nreturn f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);\n}\n} else {\nvar a13 \x3d cljs.core._first(next_12);\nvar next_13 \x3d cljs.core.next(next_12);\nif((next_13 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$14){\nreturn f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);\n}\n} else {\nvar a14 \x3d cljs.core._first(next_13);\nvar next_14 \x3d cljs.core.next(next_13);\nif((next_14 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$15){\nreturn f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);\n}\n} else {\nvar a15 \x3d cljs.core._first(next_14);\nvar next_15 \x3d cljs.core.next(next_14);\nif((next_15 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$16){\nreturn f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);\n}\n} else {\nvar a16 \x3d cljs.core._first(next_15);\nvar next_16 \x3d cljs.core.next(next_15);\nif((next_16 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$17){\nreturn f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);\n}\n} else {\nvar a17 \x3d cljs.core._first(next_16);\nvar next_17 \x3d cljs.core.next(next_16);\nif((next_17 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$18){\nreturn f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);\n}\n} else {\nvar a18 \x3d cljs.core._first(next_17);\nvar next_18 \x3d cljs.core.next(next_17);\nif((next_18 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$19){\nreturn f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);\n}\n} else {\nvar a19 \x3d cljs.core._first(next_18);\nvar next_19 \x3d cljs.core.next(next_18);\nif((next_19 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$20){\nreturn f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);\n}\n} else {\nvar arr__4655__auto__ \x3d [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];\nvar s__4656__auto___21077 \x3d next_19;\nwhile(true){\nif(s__4656__auto___21077){\narr__4655__auto__.push(cljs.core._first(s__4656__auto___21077));\n\nvar G__21078 \x3d cljs.core.next(s__4656__auto___21077);\ns__4656__auto___21077 \x3d G__21078;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn f.apply(f,arr__4655__auto__);\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}));\n\n(cljs.core.apply_to_simple.cljs$lang$maxFixedArity \x3d 6);\n\n/**\n * Applies fn f to the argument list formed by prepending intervening arguments to args.\n */\ncljs.core.apply \x3d (function cljs$core$apply(var_args){\nvar G__18768 \x3d arguments.length;\nswitch (G__18768) {\ncase 2:\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21080 \x3d arguments.length;\nvar i__4731__auto___21081 \x3d (0);\nwhile(true){\nif((i__4731__auto___21081 \x3c len__4730__auto___21080)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21081]));\n\nvar G__21082 \x3d (i__4731__auto___21081 + (1));\ni__4731__auto___21081 \x3d G__21082;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,args){\nif(f.cljs$lang$applyTo){\nvar fixed_arity \x3d f.cljs$lang$maxFixedArity;\nvar bc \x3d cljs.core.bounded_count((fixed_arity + (1)),args);\nif((bc \x3c\x3d fixed_arity)){\nreturn cljs.core.apply_to(f,bc,args);\n} else {\nreturn f.cljs$lang$applyTo(args);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));\n}\n}));\n\n(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,x,args){\nif(f.cljs$lang$applyTo){\nvar arglist \x3d cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);\nvar fixed_arity \x3d f.cljs$lang$maxFixedArity;\nvar bc \x3d (cljs.core.bounded_count(fixed_arity,args) + (1));\nif((bc \x3c\x3d fixed_arity)){\nreturn cljs.core.apply_to(f,bc,arglist);\n} else {\nreturn f.cljs$lang$applyTo(arglist);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));\n}\n}));\n\n(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 \x3d (function (f,x,y,args){\nif(f.cljs$lang$applyTo){\nvar arglist \x3d cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);\nvar fixed_arity \x3d f.cljs$lang$maxFixedArity;\nvar bc \x3d ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));\nif((bc \x3c\x3d fixed_arity)){\nreturn cljs.core.apply_to(f,bc,arglist);\n} else {\nreturn f.cljs$lang$applyTo(arglist);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));\n}\n}));\n\n(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 \x3d (function (f,x,y,z,args){\nif(f.cljs$lang$applyTo){\nvar arglist \x3d cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);\nvar fixed_arity \x3d f.cljs$lang$maxFixedArity;\nvar bc \x3d ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));\nif((bc \x3c\x3d fixed_arity)){\nreturn cljs.core.apply_to(f,bc,arglist);\n} else {\nreturn f.cljs$lang$applyTo(arglist);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));\n}\n}));\n\n(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic \x3d (function (f,a,b,c,d,args){\nif(f.cljs$lang$applyTo){\nvar spread_args \x3d cljs.core.spread(args);\nvar arglist \x3d cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));\nvar fixed_arity \x3d f.cljs$lang$maxFixedArity;\nvar bc \x3d ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));\nif((bc \x3c\x3d fixed_arity)){\nreturn cljs.core.apply_to(f,bc,arglist);\n} else {\nreturn f.cljs$lang$applyTo(arglist);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));\n}\n}));\n\n/** @this {Function} */\n(cljs.core.apply.cljs$lang$applyTo \x3d (function (seq18762){\nvar G__18763 \x3d cljs.core.first(seq18762);\nvar seq18762__$1 \x3d cljs.core.next(seq18762);\nvar G__18764 \x3d cljs.core.first(seq18762__$1);\nvar seq18762__$2 \x3d cljs.core.next(seq18762__$1);\nvar G__18765 \x3d cljs.core.first(seq18762__$2);\nvar seq18762__$3 \x3d cljs.core.next(seq18762__$2);\nvar G__18766 \x3d cljs.core.first(seq18762__$3);\nvar seq18762__$4 \x3d cljs.core.next(seq18762__$3);\nvar G__18767 \x3d cljs.core.first(seq18762__$4);\nvar seq18762__$5 \x3d cljs.core.next(seq18762__$4);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18763,G__18764,G__18765,G__18766,G__18767,seq18762__$5);\n}));\n\n(cljs.core.apply.cljs$lang$maxFixedArity \x3d (5));\n\n/**\n * Returns an object of the same type and value as obj, with\n *   (apply f (meta obj) args) as its metadata.\n */\ncljs.core.vary_meta \x3d (function cljs$core$vary_meta(var_args){\nvar G__18777 \x3d arguments.length;\nswitch (G__18777) {\ncase 2:\nreturn cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase 6:\nreturn cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21084 \x3d arguments.length;\nvar i__4731__auto___21085 \x3d (0);\nwhile(true){\nif((i__4731__auto___21085 \x3c len__4730__auto___21084)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21085]));\n\nvar G__21086 \x3d (i__4731__auto___21085 + (1));\ni__4731__auto___21085 \x3d G__21086;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((6)),(0),null));\nreturn cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 \x3d (function (obj,f){\nreturn cljs.core.with_meta(obj,(function (){var G__18778 \x3d cljs.core.meta(obj);\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18778) : f.call(null,G__18778));\n})());\n}));\n\n(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 \x3d (function (obj,f,a){\nreturn cljs.core.with_meta(obj,(function (){var G__18779 \x3d cljs.core.meta(obj);\nvar G__18780 \x3d a;\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18779,G__18780) : f.call(null,G__18779,G__18780));\n})());\n}));\n\n(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 \x3d (function (obj,f,a,b){\nreturn cljs.core.with_meta(obj,(function (){var G__18781 \x3d cljs.core.meta(obj);\nvar G__18782 \x3d a;\nvar G__18783 \x3d b;\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18781,G__18782,G__18783) : f.call(null,G__18781,G__18782,G__18783));\n})());\n}));\n\n(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 \x3d (function (obj,f,a,b,c){\nreturn cljs.core.with_meta(obj,(function (){var G__18784 \x3d cljs.core.meta(obj);\nvar G__18785 \x3d a;\nvar G__18786 \x3d b;\nvar G__18787 \x3d c;\nreturn (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18784,G__18785,G__18786,G__18787) : f.call(null,G__18784,G__18785,G__18786,G__18787));\n})());\n}));\n\n(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 \x3d (function (obj,f,a,b,c,d){\nreturn cljs.core.with_meta(obj,(function (){var G__18788 \x3d cljs.core.meta(obj);\nvar G__18789 \x3d a;\nvar G__18790 \x3d b;\nvar G__18791 \x3d c;\nvar G__18792 \x3d d;\nreturn (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__18788,G__18789,G__18790,G__18791,G__18792) : f.call(null,G__18788,G__18789,G__18790,G__18791,G__18792));\n})());\n}));\n\n(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic \x3d (function (obj,f,a,b,c,d,args){\nreturn cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));\n}));\n\n/** @this {Function} */\n(cljs.core.vary_meta.cljs$lang$applyTo \x3d (function (seq18770){\nvar G__18771 \x3d cljs.core.first(seq18770);\nvar seq18770__$1 \x3d cljs.core.next(seq18770);\nvar G__18772 \x3d cljs.core.first(seq18770__$1);\nvar seq18770__$2 \x3d cljs.core.next(seq18770__$1);\nvar G__18773 \x3d cljs.core.first(seq18770__$2);\nvar seq18770__$3 \x3d cljs.core.next(seq18770__$2);\nvar G__18774 \x3d cljs.core.first(seq18770__$3);\nvar seq18770__$4 \x3d cljs.core.next(seq18770__$3);\nvar G__18775 \x3d cljs.core.first(seq18770__$4);\nvar seq18770__$5 \x3d cljs.core.next(seq18770__$4);\nvar G__18776 \x3d cljs.core.first(seq18770__$5);\nvar seq18770__$6 \x3d cljs.core.next(seq18770__$5);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18771,G__18772,G__18773,G__18774,G__18775,G__18776,seq18770__$6);\n}));\n\n(cljs.core.vary_meta.cljs$lang$maxFixedArity \x3d (6));\n\n/**\n * Same as (not (\x3d obj1 obj2))\n */\ncljs.core.not_EQ_ \x3d (function cljs$core$not_EQ_(var_args){\nvar G__18797 \x3d arguments.length;\nswitch (G__18797) {\ncase 1:\nreturn cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21101 \x3d arguments.length;\nvar i__4731__auto___21102 \x3d (0);\nwhile(true){\nif((i__4731__auto___21102 \x3c len__4730__auto___21101)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21102]));\n\nvar G__21103 \x3d (i__4731__auto___21102 + (1));\ni__4731__auto___21102 \x3d G__21103;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn false;\n}));\n\n(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));\n}));\n\n(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));\n}));\n\n/** @this {Function} */\n(cljs.core.not_EQ_.cljs$lang$applyTo \x3d (function (seq18794){\nvar G__18795 \x3d cljs.core.first(seq18794);\nvar seq18794__$1 \x3d cljs.core.next(seq18794);\nvar G__18796 \x3d cljs.core.first(seq18794__$1);\nvar seq18794__$2 \x3d cljs.core.next(seq18794__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18795,G__18796,seq18794__$2);\n}));\n\n(cljs.core.not_EQ_.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * If coll is empty, returns nil, else coll\n */\ncljs.core.not_empty \x3d (function cljs$core$not_empty(coll){\nif(cljs.core.seq(coll)){\nreturn coll;\n} else {\nreturn null;\n}\n});\ncljs.core.nil_iter \x3d (function cljs$core$nil_iter(){\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core.t_cljs$core18798 !\x3d\x3d \x27undefined\x27)){\n} else {\n\n/**\n* @constructor\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.t_cljs$core18798 \x3d (function (meta18799){\nthis.meta18799 \x3d meta18799;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 393216;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\n(cljs.core.t_cljs$core18798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_18800,meta18799__$1){\nvar self__ \x3d this;\nvar _18800__$1 \x3d this;\nreturn (new cljs.core.t_cljs$core18798(meta18799__$1));\n}));\n\n(cljs.core.t_cljs$core18798.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_18800){\nvar self__ \x3d this;\nvar _18800__$1 \x3d this;\nreturn self__.meta18799;\n}));\n\n(cljs.core.t_cljs$core18798.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn false;\n}));\n\n(cljs.core.t_cljs$core18798.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (new Error(\x22No such element\x22));\n}));\n\n(cljs.core.t_cljs$core18798.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (new Error(\x22Unsupported operation\x22));\n}));\n\n(cljs.core.t_cljs$core18798.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta18799\x22,\x22meta18799\x22,-943115174,null)], null);\n}));\n\n(cljs.core.t_cljs$core18798.cljs$lang$type \x3d true);\n\n(cljs.core.t_cljs$core18798.cljs$lang$ctorStr \x3d \x22cljs.core/t_cljs$core18798\x22);\n\n(cljs.core.t_cljs$core18798.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/t_cljs$core18798\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/t_cljs$core18798.\n */\ncljs.core.__GT_t_cljs$core18798 \x3d (function cljs$core$nil_iter_$___GT_t_cljs$core18798(meta18799){\nreturn (new cljs.core.t_cljs$core18798(meta18799));\n});\n\n}\n\nreturn (new cljs.core.t_cljs$core18798(cljs.core.PersistentArrayMap.EMPTY));\n});\n\n/**\n* @constructor\n*/\ncljs.core.StringIter \x3d (function (s,i){\nthis.s \x3d s;\nthis.i \x3d i;\n});\n(cljs.core.StringIter.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.i \x3c self__.s.length);\n}));\n\n(cljs.core.StringIter.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar ret \x3d self__.s.charAt(self__.i);\n(self__.i \x3d (self__.i + (1)));\n\nreturn ret;\n}));\n\n(cljs.core.StringIter.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (new Error(\x22Unsupported operation\x22));\n}));\n\n(cljs.core.StringIter.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22s\x22,\x22s\x22,-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.StringIter.cljs$lang$type \x3d true);\n\n(cljs.core.StringIter.cljs$lang$ctorStr \x3d \x22cljs.core/StringIter\x22);\n\n(cljs.core.StringIter.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/StringIter\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/StringIter.\n */\ncljs.core.__GT_StringIter \x3d (function cljs$core$__GT_StringIter(s,i){\nreturn (new cljs.core.StringIter(s,i));\n});\n\ncljs.core.string_iter \x3d (function cljs$core$string_iter(x){\nreturn (new cljs.core.StringIter(x,(0)));\n});\n\n/**\n* @constructor\n*/\ncljs.core.ArrayIter \x3d (function (arr,i){\nthis.arr \x3d arr;\nthis.i \x3d i;\n});\n(cljs.core.ArrayIter.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.i \x3c self__.arr.length);\n}));\n\n(cljs.core.ArrayIter.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar ret \x3d (self__.arr[self__.i]);\n(self__.i \x3d (self__.i + (1)));\n\nreturn ret;\n}));\n\n(cljs.core.ArrayIter.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (new Error(\x22Unsupported operation\x22));\n}));\n\n(cljs.core.ArrayIter.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.ArrayIter.cljs$lang$type \x3d true);\n\n(cljs.core.ArrayIter.cljs$lang$ctorStr \x3d \x22cljs.core/ArrayIter\x22);\n\n(cljs.core.ArrayIter.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/ArrayIter\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/ArrayIter.\n */\ncljs.core.__GT_ArrayIter \x3d (function cljs$core$__GT_ArrayIter(arr,i){\nreturn (new cljs.core.ArrayIter(arr,i));\n});\n\ncljs.core.array_iter \x3d (function cljs$core$array_iter(x){\nreturn (new cljs.core.ArrayIter(x,(0)));\n});\ncljs.core.INIT \x3d ({});\ncljs.core.START \x3d ({});\n\n/**\n* @constructor\n*/\ncljs.core.SeqIter \x3d (function (_seq,_next){\nthis._seq \x3d _seq;\nthis._next \x3d _next;\n});\n(cljs.core.SeqIter.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nif((self__._seq \x3d\x3d\x3d cljs.core.INIT)){\n(self__._seq \x3d cljs.core.START);\n\n(self__._next \x3d cljs.core.seq(self__._next));\n} else {\nif((self__._seq \x3d\x3d\x3d self__._next)){\n(self__._next \x3d cljs.core.next(self__._seq));\n} else {\n}\n}\n\nreturn (!((self__._next \x3d\x3d null)));\n}));\n\n(cljs.core.SeqIter.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nif((!(this$.hasNext()))){\nthrow (new Error(\x22No such element\x22));\n} else {\n(self__._seq \x3d self__._next);\n\nreturn cljs.core.first(self__._next);\n}\n}));\n\n(cljs.core.SeqIter.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (new Error(\x22Unsupported operation\x22));\n}));\n\n(cljs.core.SeqIter.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22_seq\x22,\x22_seq\x22,-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_next\x22,\x22_next\x22,101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.SeqIter.cljs$lang$type \x3d true);\n\n(cljs.core.SeqIter.cljs$lang$ctorStr \x3d \x22cljs.core/SeqIter\x22);\n\n(cljs.core.SeqIter.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/SeqIter\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/SeqIter.\n */\ncljs.core.__GT_SeqIter \x3d (function cljs$core$__GT_SeqIter(_seq,_next){\nreturn (new cljs.core.SeqIter(_seq,_next));\n});\n\ncljs.core.seq_iter \x3d (function cljs$core$seq_iter(coll){\nreturn (new cljs.core.SeqIter(cljs.core.INIT,coll));\n});\ncljs.core.iter \x3d (function cljs$core$iter(coll){\nif(cljs.core.iterable_QMARK_(coll)){\nreturn cljs.core._iterator(coll);\n} else {\nif((coll \x3d\x3d null)){\nreturn cljs.core.nil_iter();\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.string_iter(coll);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn cljs.core.array_iter(coll);\n} else {\nif(cljs.core.seqable_QMARK_(coll)){\nreturn cljs.core.seq_iter(coll);\n} else {\nthrow (new Error([\x22Cannot create iterator from \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n});\n\n/**\n* @constructor\n*/\ncljs.core.Many \x3d (function (vals){\nthis.vals \x3d vals;\n});\n(cljs.core.Many.prototype.add \x3d (function (o){\nvar self__ \x3d this;\nvar this$ \x3d this;\nself__.vals.push(o);\n\nreturn this$;\n}));\n\n(cljs.core.Many.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn self__.vals.shift();\n}));\n\n(cljs.core.Many.prototype.isEmpty \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn (self__.vals.length \x3d\x3d\x3d (0));\n}));\n\n(cljs.core.Many.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn [\x22Many: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join(\x27\x27);\n}));\n\n(cljs.core.Many.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22vals\x22,\x22vals\x22,-1886377036,null)], null);\n}));\n\n(cljs.core.Many.cljs$lang$type \x3d true);\n\n(cljs.core.Many.cljs$lang$ctorStr \x3d \x22cljs.core/Many\x22);\n\n(cljs.core.Many.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Many\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Many.\n */\ncljs.core.__GT_Many \x3d (function cljs$core$__GT_Many(vals){\nreturn (new cljs.core.Many(vals));\n});\n\ncljs.core.NONE \x3d ({});\n\n/**\n* @constructor\n*/\ncljs.core.Single \x3d (function (val){\nthis.val \x3d val;\n});\n(cljs.core.Single.prototype.add \x3d (function (o){\nvar self__ \x3d this;\nvar this$ \x3d this;\nif((self__.val \x3d\x3d\x3d cljs.core.NONE)){\n(self__.val \x3d o);\n\nreturn this$;\n} else {\nreturn (new cljs.core.Many([self__.val,o]));\n}\n}));\n\n(cljs.core.Single.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nif((self__.val \x3d\x3d\x3d cljs.core.NONE)){\nthrow (new Error(\x22Removing object from empty buffer\x22));\n} else {\nvar ret \x3d self__.val;\n(self__.val \x3d cljs.core.NONE);\n\nreturn ret;\n}\n}));\n\n(cljs.core.Single.prototype.isEmpty \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn (self__.val \x3d\x3d\x3d cljs.core.NONE);\n}));\n\n(cljs.core.Single.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn [\x22Single: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join(\x27\x27);\n}));\n\n(cljs.core.Single.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22val\x22,\x22val\x22,1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n}));\n\n(cljs.core.Single.cljs$lang$type \x3d true);\n\n(cljs.core.Single.cljs$lang$ctorStr \x3d \x22cljs.core/Single\x22);\n\n(cljs.core.Single.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Single\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Single.\n */\ncljs.core.__GT_Single \x3d (function cljs$core$__GT_Single(val){\nreturn (new cljs.core.Single(val));\n});\n\n\n/**\n* @constructor\n*/\ncljs.core.Empty \x3d (function (){\n});\n(cljs.core.Empty.prototype.add \x3d (function (o){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn (new cljs.core.Single(o));\n}));\n\n(cljs.core.Empty.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nthrow (new Error(\x22Removing object from empty buffer\x22));\n}));\n\n(cljs.core.Empty.prototype.isEmpty \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn true;\n}));\n\n(cljs.core.Empty.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn \x22Empty\x22;\n}));\n\n(cljs.core.Empty.getBasis \x3d (function (){\nreturn cljs.core.PersistentVector.EMPTY;\n}));\n\n(cljs.core.Empty.cljs$lang$type \x3d true);\n\n(cljs.core.Empty.cljs$lang$ctorStr \x3d \x22cljs.core/Empty\x22);\n\n(cljs.core.Empty.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/Empty\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/Empty.\n */\ncljs.core.__GT_Empty \x3d (function cljs$core$__GT_Empty(){\nreturn (new cljs.core.Empty());\n});\n\ncljs.core.EMPTY \x3d (new cljs.core.Empty());\n\n/**\n* @constructor\n*/\ncljs.core.MultiIterator \x3d (function (iters){\nthis.iters \x3d iters;\n});\n(cljs.core.MultiIterator.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar iters__$1 \x3d cljs.core.seq(self__.iters);\nwhile(true){\nif((!((iters__$1 \x3d\x3d null)))){\nvar iter \x3d cljs.core.first(iters__$1);\nif((!(iter.hasNext()))){\nreturn false;\n} else {\nvar G__21148 \x3d cljs.core.next(iters__$1);\niters__$1 \x3d G__21148;\ncontinue;\n}\n} else {\nreturn true;\n}\nbreak;\n}\n}));\n\n(cljs.core.MultiIterator.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar nexts \x3d [];\nvar n__4607__auto___21149 \x3d self__.iters.length;\nvar i_21150 \x3d (0);\nwhile(true){\nif((i_21150 \x3c n__4607__auto___21149)){\n(nexts[i_21150] \x3d (self__.iters[i_21150]).next());\n\nvar G__21151 \x3d (i_21150 + (1));\ni_21150 \x3d G__21151;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));\n}));\n\n(cljs.core.MultiIterator.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22iters\x22,\x22iters\x22,719353031,null)], null);\n}));\n\n(cljs.core.MultiIterator.cljs$lang$type \x3d true);\n\n(cljs.core.MultiIterator.cljs$lang$ctorStr \x3d \x22cljs.core/MultiIterator\x22);\n\n(cljs.core.MultiIterator.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/MultiIterator\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/MultiIterator.\n */\ncljs.core.__GT_MultiIterator \x3d (function cljs$core$__GT_MultiIterator(iters){\nreturn (new cljs.core.MultiIterator(iters));\n});\n\ncljs.core.chunkIteratorSeq \x3d (function cljs$core$chunkIteratorSeq(iter){\nreturn (new cljs.core.LazySeq(null,(function (){\nif(iter.hasNext()){\nvar arr \x3d [];\nvar n \x3d (0);\nwhile(true){\nif(cljs.core.truth_((function (){var and__4109__auto__ \x3d iter.hasNext();\nif(cljs.core.truth_(and__4109__auto__)){\nreturn (n \x3c (32));\n} else {\nreturn and__4109__auto__;\n}\n})())){\n(arr[n] \x3d iter.next());\n\nvar G__21165 \x3d (n + (1));\nn \x3d G__21165;\ncontinue;\n} else {\nreturn cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));\n}\nbreak;\n}\n} else {\nreturn null;\n}\n}),null,null));\n});\n\n/**\n* @constructor\n*/\ncljs.core.TransformerIterator \x3d (function (buffer,_next,completed,xf,sourceIter,multi){\nthis.buffer \x3d buffer;\nthis._next \x3d _next;\nthis.completed \x3d completed;\nthis.xf \x3d xf;\nthis.sourceIter \x3d sourceIter;\nthis.multi \x3d multi;\n});\n(cljs.core.TransformerIterator.prototype.step \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nif((!((self__._next \x3d\x3d\x3d cljs.core.NONE)))){\nreturn true;\n} else {\nwhile(true){\nif((self__._next \x3d\x3d\x3d cljs.core.NONE)){\nif(self__.buffer.isEmpty()){\nif(self__.completed){\nreturn false;\n} else {\nif(self__.sourceIter.hasNext()){\nvar iter \x3d ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__18801 \x3d null;\nvar G__18802 \x3d self__.sourceIter.next();\nreturn (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__18801,G__18802) : self__.xf.call(null,G__18801,G__18802));\n})());\nif(cljs.core.reduced_QMARK_(iter)){\n(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));\n\n(self__.completed \x3d true);\n} else {\n}\n\ncontinue;\n} else {\n(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));\n\n(self__.completed \x3d true);\n\ncontinue;\n}\n}\n} else {\n(self__._next \x3d self__.buffer.remove());\n\ncontinue;\n}\n} else {\nreturn true;\n}\nbreak;\n}\n}\n}));\n\n(cljs.core.TransformerIterator.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.step();\n}));\n\n(cljs.core.TransformerIterator.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar this$ \x3d this;\nif(this$.hasNext()){\nvar ret \x3d self__._next;\n(self__._next \x3d cljs.core.NONE);\n\nreturn ret;\n} else {\nthrow (new Error(\x22No such element\x22));\n}\n}));\n\n(cljs.core.TransformerIterator.prototype.remove \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (new Error(\x22Unsupported operation\x22));\n}));\n\n(cljs.core.TransformerIterator.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22buffer\x22,\x22buffer\x22,-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_next\x22,\x22_next\x22,101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22completed\x22,\x22completed\x22,1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22xf\x22,\x22xf\x22,2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),new cljs.core.Symbol(null,\x22sourceIter\x22,\x22sourceIter\x22,1068220306,null),new cljs.core.Symbol(null,\x22multi\x22,\x22multi\x22,1450238522,null)], null);\n}));\n\n(cljs.core.TransformerIterator.cljs$lang$type \x3d true);\n\n(cljs.core.TransformerIterator.cljs$lang$ctorStr \x3d \x22cljs.core/TransformerIterator\x22);\n\n(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter \x3d (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){\nreturn cljs.core._write(writer__4364__auto__,\x22cljs.core/TransformerIterator\x22);\n}));\n\n/**\n * Positional factory function for cljs.core/TransformerIterator.\n */\ncljs.core.__GT_TransformerIterator \x3d (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){\nreturn (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));\n});\n\ngoog.object.set(cljs.core.TransformerIterator.prototype,cljs.core.ITER_SYMBOL,(function (){\nvar this__4669__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4669__auto__);\n}));\ncljs.core.transformer_iterator \x3d (function cljs$core$transformer_iterator(xform,sourceIter,multi){\nvar iterator \x3d (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));\n(iterator.xf \x3d (function (){var G__18803 \x3d (function() {\nvar G__21185 \x3d null;\nvar G__21185__0 \x3d (function (){\nreturn null;\n});\nvar G__21185__1 \x3d (function (acc){\nreturn acc;\n});\nvar G__21185__2 \x3d (function (acc,o){\n(iterator.buffer \x3d iterator.buffer.add(o));\n\nreturn acc;\n});\nG__21185 \x3d function(acc,o){\nswitch(arguments.length){\ncase 0:\nreturn G__21185__0.call(this);\ncase 1:\nreturn G__21185__1.call(this,acc);\ncase 2:\nreturn G__21185__2.call(this,acc,o);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21185.cljs$core$IFn$_invoke$arity$0 \x3d G__21185__0;\nG__21185.cljs$core$IFn$_invoke$arity$1 \x3d G__21185__1;\nG__21185.cljs$core$IFn$_invoke$arity$2 \x3d G__21185__2;\nreturn G__21185;\n})()\n;\nreturn (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__18803) : xform.call(null,G__18803));\n})());\n\nreturn iterator;\n});\n(cljs.core.TransformerIterator.create \x3d (function (xform,source){\nreturn cljs.core.transformer_iterator(xform,source,false);\n}));\n(cljs.core.TransformerIterator.createMulti \x3d (function (xform,sources){\nreturn cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);\n}));\n/**\n * Coerces coll to a (possibly empty) sequence, if it is not already\n *   one. Will not force a lazy seq. (sequence nil) yields (), When a\n *   transducer is supplied, returns a lazy sequence of applications of\n *   the transform to the items in coll(s), i.e. to the set of first\n *   items of each coll, followed by the set of second\n *   items in each coll, until any one of the colls is exhausted.  Any\n *   remaining items in other colls are ignored. The transform should accept\n *   number-of-colls arguments\n */\ncljs.core.sequence \x3d (function cljs$core$sequence(var_args){\nvar G__18808 \x3d arguments.length;\nswitch (G__18808) {\ncase 1:\nreturn cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21192 \x3d arguments.length;\nvar i__4731__auto___21193 \x3d (0);\nwhile(true){\nif((i__4731__auto___21193 \x3c len__4730__auto___21192)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21193]));\n\nvar G__21194 \x3d (i__4731__auto___21193 + (1));\ni__4731__auto___21193 \x3d G__21194;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));\nreturn cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nif(cljs.core.seq_QMARK_(coll)){\nreturn coll;\n} else {\nvar or__4120__auto__ \x3d cljs.core.seq(coll);\nif(or__4120__auto__){\nreturn or__4120__auto__;\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}\n}));\n\n(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 \x3d (function (xform,coll){\nvar or__4120__auto__ \x3d cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));\nif(cljs.core.truth_(or__4120__auto__)){\nreturn or__4120__auto__;\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}));\n\n(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic \x3d (function (xform,coll,colls){\nvar or__4120__auto__ \x3d cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,(function (){var G__18811 \x3d cljs.core.iter;\nvar G__18812 \x3d cljs.core.cons(coll,colls);\nreturn (cljs.core.map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.map.cljs$core$IFn$_invoke$arity$2(G__18811,G__18812) : cljs.core.map.call(null,G__18811,G__18812));\n})()));\nif(cljs.core.truth_(or__4120__auto__)){\nreturn or__4120__auto__;\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}));\n\n/** @this {Function} */\n(cljs.core.sequence.cljs$lang$applyTo \x3d (function (seq18805){\nvar G__18806 \x3d cljs.core.first(seq18805);\nvar seq18805__$1 \x3d cljs.core.next(seq18805);\nvar G__18807 \x3d cljs.core.first(seq18805__$1);\nvar seq18805__$2 \x3d cljs.core.next(seq18805__$1);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18806,G__18807,seq18805__$2);\n}));\n\n(cljs.core.sequence.cljs$lang$maxFixedArity \x3d (2));\n\n/**\n * Returns true if (pred x) is logical true for every x in coll, else\n *   false.\n */\ncljs.core.every_QMARK_ \x3d (function cljs$core$every_QMARK_(pred,coll){\nwhile(true){\nif((cljs.core.seq(coll) \x3d\x3d null)){\nreturn true;\n} else {\nif(cljs.core.truth_((function (){var G__18813 \x3d cljs.core.first(coll);\nreturn (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18813) : pred.call(null,G__18813));\n})())){\nvar G__21197 \x3d pred;\nvar G__21198 \x3d cljs.core.next(coll);\npred \x3d G__21197;\ncoll \x3d G__21198;\ncontinue;\n} else {\nreturn false;\n\n}\n}\nbreak;\n}\n});\n/**\n * Returns false if (pred x) is logical true for every x in\n *   coll, else true.\n */\ncljs.core.not_every_QMARK_ \x3d (function cljs$core$not_every_QMARK_(pred,coll){\nreturn (!(cljs.core.every_QMARK_(pred,coll)));\n});\n/**\n * Returns the first logical true value of (pred x) for any x in coll,\n *   else nil.  One common idiom is to use a set as pred, for example\n *   this will return :fred if :fred is in the sequence, otherwise nil:\n *   (some #{:fred} coll)\n */\ncljs.core.some \x3d (function cljs$core$some(pred,coll){\nwhile(true){\nvar temp__5735__auto__ \x3d cljs.core.seq(coll);\nif(temp__5735__auto__){\nvar s \x3d temp__5735__auto__;\nvar or__4120__auto__ \x3d (function (){var G__18815 \x3d cljs.core.first(s);\nreturn (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18815) : pred.call(null,G__18815));\n})();\nif(cljs.core.truth_(or__4120__auto__)){\nreturn or__4120__auto__;\n} else {\nvar G__21199 \x3d pred;\nvar G__21200 \x3d cljs.core.next(s);\npred \x3d G__21199;\ncoll \x3d G__21200;\ncontinue;\n}\n} else {\nreturn null;\n}\nbreak;\n}\n});\n/**\n * Returns false if (pred x) is logical true for any x in coll,\n *   else true.\n */\ncljs.core.not_any_QMARK_ \x3d (function cljs$core$not_any_QMARK_(pred,coll){\nreturn cljs.core.not(cljs.core.some(pred,coll));\n});\n/**\n * Returns true if n is even, throws an exception if n is not an integer\n */\ncljs.core.even_QMARK_ \x3d (function cljs$core$even_QMARK_(n){\nif(cljs.core.integer_QMARK_(n)){\nreturn ((n \x26 (1)) \x3d\x3d\x3d (0));\n} else {\nthrow (new Error([\x22Argument must be an integer: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join(\x27\x27)));\n}\n});\n/**\n * Returns true if n is odd, throws an exception if n is not an integer\n */\ncljs.core.odd_QMARK_ \x3d (function cljs$core$odd_QMARK_(n){\nreturn (!(cljs.core.even_QMARK_(n)));\n});\n/**\n * Takes a fn f and returns a fn that takes the same arguments as f,\n *   has the same effects, if any, and returns the opposite truth value.\n */\ncljs.core.complement \x3d (function cljs$core$complement(f){\nreturn (function() {\nvar G__21201 \x3d null;\nvar G__21201__0 \x3d (function (){\nreturn cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));\n});\nvar G__21201__1 \x3d (function (x){\nreturn cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));\n});\nvar G__21201__2 \x3d (function (x,y){\nreturn cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));\n});\nvar G__21201__3 \x3d (function() { \nvar G__21209__delegate \x3d function (x,y,zs){\nreturn cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));\n};\nvar G__21209 \x3d function (x,y,var_args){\nvar zs \x3d null;\nif (arguments.length \x3e 2) {\nvar G__21214__i \x3d 0, G__21214__a \x3d new Array(arguments.length -  2);\nwhile (G__21214__i \x3c G__21214__a.length) {G__21214__a[G__21214__i] \x3d arguments[G__21214__i + 2]; ++G__21214__i;}\n  zs \x3d new cljs.core.IndexedSeq(G__21214__a,0,null);\n} \nreturn G__21209__delegate.call(this,x,y,zs);};\nG__21209.cljs$lang$maxFixedArity \x3d 2;\nG__21209.cljs$lang$applyTo \x3d (function (arglist__21217){\nvar x \x3d cljs.core.first(arglist__21217);\narglist__21217 \x3d cljs.core.next(arglist__21217);\nvar y \x3d cljs.core.first(arglist__21217);\nvar zs \x3d cljs.core.rest(arglist__21217);\nreturn G__21209__delegate(x,y,zs);\n});\nG__21209.cljs$core$IFn$_invoke$arity$variadic \x3d G__21209__delegate;\nreturn G__21209;\n})()\n;\nG__21201 \x3d function(x,y,var_args){\nvar zs \x3d var_args;\nswitch(arguments.length){\ncase 0:\nreturn G__21201__0.call(this);\ncase 1:\nreturn G__21201__1.call(this,x);\ncase 2:\nreturn G__21201__2.call(this,x,y);\ndefault:\nvar G__21224 \x3d null;\nif (arguments.length \x3e 2) {\nvar G__21225__i \x3d 0, G__21225__a \x3d new Array(arguments.length -  2);\nwhile (G__21225__i \x3c G__21225__a.length) {G__21225__a[G__21225__i] \x3d arguments[G__21225__i + 2]; ++G__21225__i;}\nG__21224 \x3d new cljs.core.IndexedSeq(G__21225__a,0,null);\n}\nreturn G__21201__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__21224);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21201.cljs$lang$maxFixedArity \x3d 2;\nG__21201.cljs$lang$applyTo \x3d G__21201__3.cljs$lang$applyTo;\nG__21201.cljs$core$IFn$_invoke$arity$0 \x3d G__21201__0;\nG__21201.cljs$core$IFn$_invoke$arity$1 \x3d G__21201__1;\nG__21201.cljs$core$IFn$_invoke$arity$2 \x3d G__21201__2;\nG__21201.cljs$core$IFn$_invoke$arity$variadic \x3d G__21201__3.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21201;\n})()\n});\n/**\n * Returns a function that takes any number of arguments and returns x.\n */\ncljs.core.constantly \x3d (function cljs$core$constantly(x){\nreturn (function() { \nvar G__21227__delegate \x3d function (args){\nreturn x;\n};\nvar G__21227 \x3d function (var_args){\nvar args \x3d null;\nif (arguments.length \x3e 0) {\nvar G__21228__i \x3d 0, G__21228__a \x3d new Array(arguments.length -  0);\nwhile (G__21228__i \x3c G__21228__a.length) {G__21228__a[G__21228__i] \x3d arguments[G__21228__i + 0]; ++G__21228__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21228__a,0,null);\n} \nreturn G__21227__delegate.call(this,args);};\nG__21227.cljs$lang$maxFixedArity \x3d 0;\nG__21227.cljs$lang$applyTo \x3d (function (arglist__21229){\nvar args \x3d cljs.core.seq(arglist__21229);\nreturn G__21227__delegate(args);\n});\nG__21227.cljs$core$IFn$_invoke$arity$variadic \x3d G__21227__delegate;\nreturn G__21227;\n})()\n;\n});\n/**\n * Takes a set of functions and returns a fn that is the composition\n *   of those fns.  The returned fn takes a variable number of args,\n *   applies the rightmost of fns to the args, the next\n *   fn (right-to-left) to the result, etc.\n */\ncljs.core.comp \x3d (function cljs$core$comp(var_args){\nvar G__18821 \x3d arguments.length;\nswitch (G__18821) {\ncase 0:\nreturn cljs.core.comp.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21231 \x3d arguments.length;\nvar i__4731__auto___21232 \x3d (0);\nwhile(true){\nif((i__4731__auto___21232 \x3c len__4730__auto___21231)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21232]));\n\nvar G__21233 \x3d (i__4731__auto___21232 + (1));\ni__4731__auto___21232 \x3d G__21233;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));\nreturn cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn cljs.core.identity;\n}));\n\n(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 \x3d (function (f){\nreturn f;\n}));\n\n(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,g){\nreturn (function() {\nvar G__21235 \x3d null;\nvar G__21235__0 \x3d (function (){\nvar G__18822 \x3d (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18822) : f.call(null,G__18822));\n});\nvar G__21235__1 \x3d (function (x){\nvar G__18823 \x3d (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18823) : f.call(null,G__18823));\n});\nvar G__21235__2 \x3d (function (x,y){\nvar G__18824 \x3d (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18824) : f.call(null,G__18824));\n});\nvar G__21235__3 \x3d (function (x,y,z){\nvar G__18825 \x3d (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18825) : f.call(null,G__18825));\n});\nvar G__21235__4 \x3d (function() { \nvar G__21236__delegate \x3d function (x,y,z,args){\nvar G__18826 \x3d cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18826) : f.call(null,G__18826));\n};\nvar G__21236 \x3d function (x,y,z,var_args){\nvar args \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21237__i \x3d 0, G__21237__a \x3d new Array(arguments.length -  3);\nwhile (G__21237__i \x3c G__21237__a.length) {G__21237__a[G__21237__i] \x3d arguments[G__21237__i + 3]; ++G__21237__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21237__a,0,null);\n} \nreturn G__21236__delegate.call(this,x,y,z,args);};\nG__21236.cljs$lang$maxFixedArity \x3d 3;\nG__21236.cljs$lang$applyTo \x3d (function (arglist__21238){\nvar x \x3d cljs.core.first(arglist__21238);\narglist__21238 \x3d cljs.core.next(arglist__21238);\nvar y \x3d cljs.core.first(arglist__21238);\narglist__21238 \x3d cljs.core.next(arglist__21238);\nvar z \x3d cljs.core.first(arglist__21238);\nvar args \x3d cljs.core.rest(arglist__21238);\nreturn G__21236__delegate(x,y,z,args);\n});\nG__21236.cljs$core$IFn$_invoke$arity$variadic \x3d G__21236__delegate;\nreturn G__21236;\n})()\n;\nG__21235 \x3d function(x,y,z,var_args){\nvar args \x3d var_args;\nswitch(arguments.length){\ncase 0:\nreturn G__21235__0.call(this);\ncase 1:\nreturn G__21235__1.call(this,x);\ncase 2:\nreturn G__21235__2.call(this,x,y);\ncase 3:\nreturn G__21235__3.call(this,x,y,z);\ndefault:\nvar G__21239 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21240__i \x3d 0, G__21240__a \x3d new Array(arguments.length -  3);\nwhile (G__21240__i \x3c G__21240__a.length) {G__21240__a[G__21240__i] \x3d arguments[G__21240__i + 3]; ++G__21240__i;}\nG__21239 \x3d new cljs.core.IndexedSeq(G__21240__a,0,null);\n}\nreturn G__21235__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__21239);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21235.cljs$lang$maxFixedArity \x3d 3;\nG__21235.cljs$lang$applyTo \x3d G__21235__4.cljs$lang$applyTo;\nG__21235.cljs$core$IFn$_invoke$arity$0 \x3d G__21235__0;\nG__21235.cljs$core$IFn$_invoke$arity$1 \x3d G__21235__1;\nG__21235.cljs$core$IFn$_invoke$arity$2 \x3d G__21235__2;\nG__21235.cljs$core$IFn$_invoke$arity$3 \x3d G__21235__3;\nG__21235.cljs$core$IFn$_invoke$arity$variadic \x3d G__21235__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21235;\n})()\n}));\n\n(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,g,h){\nreturn (function() {\nvar G__21241 \x3d null;\nvar G__21241__0 \x3d (function (){\nvar G__18827 \x3d (function (){var G__18828 \x3d (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));\nreturn (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18828) : g.call(null,G__18828));\n})();\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18827) : f.call(null,G__18827));\n});\nvar G__21241__1 \x3d (function (x){\nvar G__18829 \x3d (function (){var G__18830 \x3d (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));\nreturn (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18830) : g.call(null,G__18830));\n})();\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18829) : f.call(null,G__18829));\n});\nvar G__21241__2 \x3d (function (x,y){\nvar G__18831 \x3d (function (){var G__18832 \x3d (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));\nreturn (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18832) : g.call(null,G__18832));\n})();\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18831) : f.call(null,G__18831));\n});\nvar G__21241__3 \x3d (function (x,y,z){\nvar G__18833 \x3d (function (){var G__18834 \x3d (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));\nreturn (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18834) : g.call(null,G__18834));\n})();\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18833) : f.call(null,G__18833));\n});\nvar G__21241__4 \x3d (function() { \nvar G__21248__delegate \x3d function (x,y,z,args){\nvar G__18835 \x3d (function (){var G__18836 \x3d cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);\nreturn (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18836) : g.call(null,G__18836));\n})();\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18835) : f.call(null,G__18835));\n};\nvar G__21248 \x3d function (x,y,z,var_args){\nvar args \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21249__i \x3d 0, G__21249__a \x3d new Array(arguments.length -  3);\nwhile (G__21249__i \x3c G__21249__a.length) {G__21249__a[G__21249__i] \x3d arguments[G__21249__i + 3]; ++G__21249__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21249__a,0,null);\n} \nreturn G__21248__delegate.call(this,x,y,z,args);};\nG__21248.cljs$lang$maxFixedArity \x3d 3;\nG__21248.cljs$lang$applyTo \x3d (function (arglist__21250){\nvar x \x3d cljs.core.first(arglist__21250);\narglist__21250 \x3d cljs.core.next(arglist__21250);\nvar y \x3d cljs.core.first(arglist__21250);\narglist__21250 \x3d cljs.core.next(arglist__21250);\nvar z \x3d cljs.core.first(arglist__21250);\nvar args \x3d cljs.core.rest(arglist__21250);\nreturn G__21248__delegate(x,y,z,args);\n});\nG__21248.cljs$core$IFn$_invoke$arity$variadic \x3d G__21248__delegate;\nreturn G__21248;\n})()\n;\nG__21241 \x3d function(x,y,z,var_args){\nvar args \x3d var_args;\nswitch(arguments.length){\ncase 0:\nreturn G__21241__0.call(this);\ncase 1:\nreturn G__21241__1.call(this,x);\ncase 2:\nreturn G__21241__2.call(this,x,y);\ncase 3:\nreturn G__21241__3.call(this,x,y,z);\ndefault:\nvar G__21254 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21255__i \x3d 0, G__21255__a \x3d new Array(arguments.length -  3);\nwhile (G__21255__i \x3c G__21255__a.length) {G__21255__a[G__21255__i] \x3d arguments[G__21255__i + 3]; ++G__21255__i;}\nG__21254 \x3d new cljs.core.IndexedSeq(G__21255__a,0,null);\n}\nreturn G__21241__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__21254);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21241.cljs$lang$maxFixedArity \x3d 3;\nG__21241.cljs$lang$applyTo \x3d G__21241__4.cljs$lang$applyTo;\nG__21241.cljs$core$IFn$_invoke$arity$0 \x3d G__21241__0;\nG__21241.cljs$core$IFn$_invoke$arity$1 \x3d G__21241__1;\nG__21241.cljs$core$IFn$_invoke$arity$2 \x3d G__21241__2;\nG__21241.cljs$core$IFn$_invoke$arity$3 \x3d G__21241__3;\nG__21241.cljs$core$IFn$_invoke$arity$variadic \x3d G__21241__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21241;\n})()\n}));\n\n(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic \x3d (function (f1,f2,f3,fs){\nvar fs__$1 \x3d cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));\nreturn (function() { \nvar G__21259__delegate \x3d function (args){\nvar ret \x3d cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);\nvar fs__$2 \x3d cljs.core.next(fs__$1);\nwhile(true){\nif(fs__$2){\nvar G__21260 \x3d (function (){var fexpr__18837 \x3d cljs.core.first(fs__$2);\nreturn (fexpr__18837.cljs$core$IFn$_invoke$arity$1 ? fexpr__18837.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__18837.call(null,ret));\n})();\nvar G__21261 \x3d cljs.core.next(fs__$2);\nret \x3d G__21260;\nfs__$2 \x3d G__21261;\ncontinue;\n} else {\nreturn ret;\n}\nbreak;\n}\n};\nvar G__21259 \x3d function (var_args){\nvar args \x3d null;\nif (arguments.length \x3e 0) {\nvar G__21262__i \x3d 0, G__21262__a \x3d new Array(arguments.length -  0);\nwhile (G__21262__i \x3c G__21262__a.length) {G__21262__a[G__21262__i] \x3d arguments[G__21262__i + 0]; ++G__21262__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21262__a,0,null);\n} \nreturn G__21259__delegate.call(this,args);};\nG__21259.cljs$lang$maxFixedArity \x3d 0;\nG__21259.cljs$lang$applyTo \x3d (function (arglist__21266){\nvar args \x3d cljs.core.seq(arglist__21266);\nreturn G__21259__delegate(args);\n});\nG__21259.cljs$core$IFn$_invoke$arity$variadic \x3d G__21259__delegate;\nreturn G__21259;\n})()\n;\n}));\n\n/** @this {Function} */\n(cljs.core.comp.cljs$lang$applyTo \x3d (function (seq18817){\nvar G__18818 \x3d cljs.core.first(seq18817);\nvar seq18817__$1 \x3d cljs.core.next(seq18817);\nvar G__18819 \x3d cljs.core.first(seq18817__$1);\nvar seq18817__$2 \x3d cljs.core.next(seq18817__$1);\nvar G__18820 \x3d cljs.core.first(seq18817__$2);\nvar seq18817__$3 \x3d cljs.core.next(seq18817__$2);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18818,G__18819,G__18820,seq18817__$3);\n}));\n\n(cljs.core.comp.cljs$lang$maxFixedArity \x3d (3));\n\n/**\n * Takes a function f and fewer than the normal arguments to f, and\n *   returns a fn that takes a variable number of additional args. When\n *   called, the returned function calls f with args + additional args.\n */\ncljs.core.partial \x3d (function cljs$core$partial(var_args){\nvar G__18844 \x3d arguments.length;\nswitch (G__18844) {\ncase 1:\nreturn cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nvar args_arr__4751__auto__ \x3d [];\nvar len__4730__auto___21271 \x3d arguments.length;\nvar i__4731__auto___21272 \x3d (0);\nwhile(true){\nif((i__4731__auto___21272 \x3c len__4730__auto___21271)){\nargs_arr__4751__auto__.push((arguments[i__4731__auto___21272]));\n\nvar G__21273 \x3d (i__4731__auto___21272 + (1));\ni__4731__auto___21272 \x3d G__21273;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4752__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));\nreturn cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);\n\n}\n});\n\n(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 \x3d (function (f){\nreturn f;\n}));\n\n(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,arg1){\nreturn (function() {\nvar G__21274 \x3d null;\nvar G__21274__0 \x3d (function (){\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));\n});\nvar G__21274__1 \x3d (function (x){\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));\n});\nvar G__21274__2 \x3d (function (x,y){\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));\n});\nvar G__21274__3 \x3d (function (x,y,z){\nreturn (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));\n});\nvar G__21274__4 \x3d (function() { \nvar G__21275__delegate \x3d function (x,y,z,args){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));\n};\nvar G__21275 \x3d function (x,y,z,var_args){\nvar args \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21278__i \x3d 0, G__21278__a \x3d new Array(arguments.length -  3);\nwhile (G__21278__i \x3c G__21278__a.length) {G__21278__a[G__21278__i] \x3d arguments[G__21278__i + 3]; ++G__21278__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21278__a,0,null);\n} \nreturn G__21275__delegate.call(this,x,y,z,args);};\nG__21275.cljs$lang$maxFixedArity \x3d 3;\nG__21275.cljs$lang$applyTo \x3d (function (arglist__21279){\nvar x \x3d cljs.core.first(arglist__21279);\narglist__21279 \x3d cljs.core.next(arglist__21279);\nvar y \x3d cljs.core.first(arglist__21279);\narglist__21279 \x3d cljs.core.next(arglist__21279);\nvar z \x3d cljs.core.first(arglist__21279);\nvar args \x3d cljs.core.rest(arglist__21279);\nreturn G__21275__delegate(x,y,z,args);\n});\nG__21275.cljs$core$IFn$_invoke$arity$variadic \x3d G__21275__delegate;\nreturn G__21275;\n})()\n;\nG__21274 \x3d function(x,y,z,var_args){\nvar args \x3d var_args;\nswitch(arguments.length){\ncase 0:\nreturn G__21274__0.call(this);\ncase 1:\nreturn G__21274__1.call(this,x);\ncase 2:\nreturn G__21274__2.call(this,x,y);\ncase 3:\nreturn G__21274__3.call(this,x,y,z);\ndefault:\nvar G__21282 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21283__i \x3d 0, G__21283__a \x3d new Array(arguments.length -  3);\nwhile (G__21283__i \x3c G__21283__a.length) {G__21283__a[G__21283__i] \x3d arguments[G__21283__i + 3]; ++G__21283__i;}\nG__21282 \x3d new cljs.core.IndexedSeq(G__21283__a,0,null);\n}\nreturn G__21274__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__21282);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21274.cljs$lang$maxFixedArity \x3d 3;\nG__21274.cljs$lang$applyTo \x3d G__21274__4.cljs$lang$applyTo;\nG__21274.cljs$core$IFn$_invoke$arity$0 \x3d G__21274__0;\nG__21274.cljs$core$IFn$_invoke$arity$1 \x3d G__21274__1;\nG__21274.cljs$core$IFn$_invoke$arity$2 \x3d G__21274__2;\nG__21274.cljs$core$IFn$_invoke$arity$3 \x3d G__21274__3;\nG__21274.cljs$core$IFn$_invoke$arity$variadic \x3d G__21274__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21274;\n})()\n}));\n\n(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,arg1,arg2){\nreturn (function() {\nvar G__21284 \x3d null;\nvar G__21284__0 \x3d (function (){\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));\n});\nvar G__21284__1 \x3d (function (x){\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));\n});\nvar G__21284__2 \x3d (function (x,y){\nreturn (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));\n});\nvar G__21284__3 \x3d (function (x,y,z){\nreturn (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));\n});\nvar G__21284__4 \x3d (function() { \nvar G__21291__delegate \x3d function (x,y,z,args){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));\n};\nvar G__21291 \x3d function (x,y,z,var_args){\nvar args \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21292__i \x3d 0, G__21292__a \x3d new Array(arguments.length -  3);\nwhile (G__21292__i \x3c G__21292__a.length) {G__21292__a[G__21292__i] \x3d arguments[G__21292__i + 3]; ++G__21292__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21292__a,0,null);\n} \nreturn G__21291__delegate.call(this,x,y,z,args);};\nG__21291.cljs$lang$maxFixedArity \x3d 3;\nG__21291.cljs$lang$applyTo \x3d (function (arglist__21293){\nvar x \x3d cljs.core.first(arglist__21293);\narglist__21293 \x3d cljs.core.next(arglist__21293);\nvar y \x3d cljs.core.first(arglist__21293);\narglist__21293 \x3d cljs.core.next(arglist__21293);\nvar z \x3d cljs.core.first(arglist__21293);\nvar args \x3d cljs.core.rest(arglist__21293);\nreturn G__21291__delegate(x,y,z,args);\n});\nG__21291.cljs$core$IFn$_invoke$arity$variadic \x3d G__21291__delegate;\nreturn G__21291;\n})()\n;\nG__21284 \x3d function(x,y,z,var_args){\nvar args \x3d var_args;\nswitch(arguments.length){\ncase 0:\nreturn G__21284__0.call(this);\ncase 1:\nreturn G__21284__1.call(this,x);\ncase 2:\nreturn G__21284__2.call(this,x,y);\ncase 3:\nreturn G__21284__3.call(this,x,y,z);\ndefault:\nvar G__21300 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21301__i \x3d 0, G__21301__a \x3d new Array(arguments.length -  3);\nwhile (G__21301__i \x3c G__21301__a.length) {G__21301__a[G__21301__i] \x3d arguments[G__21301__i + 3]; ++G__21301__i;}\nG__21300 \x3d new cljs.core.IndexedSeq(G__21301__a,0,null);\n}\nreturn G__21284__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__21300);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21284.cljs$lang$maxFixedArity \x3d 3;\nG__21284.cljs$lang$applyTo \x3d G__21284__4.cljs$lang$applyTo;\nG__21284.cljs$core$IFn$_invoke$arity$0 \x3d G__21284__0;\nG__21284.cljs$core$IFn$_invoke$arity$1 \x3d G__21284__1;\nG__21284.cljs$core$IFn$_invoke$arity$2 \x3d G__21284__2;\nG__21284.cljs$core$IFn$_invoke$arity$3 \x3d G__21284__3;\nG__21284.cljs$core$IFn$_invoke$arity$variadic \x3d G__21284__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21284;\n})()\n}));\n\n(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 \x3d (function (f,arg1,arg2,arg3){\nreturn (function() {\nvar G__21306 \x3d null;\nvar G__21306__0 \x3d (function (){\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));\n});\nvar G__21306__1 \x3d (function (x){\nreturn (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));\n});\nvar G__21306__2 \x3d (function (x,y){\nreturn (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));\n});\nvar G__21306__3 \x3d (function (x,y,z){\nreturn (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));\n});\nvar G__21306__4 \x3d (function() { \nvar G__21313__delegate \x3d function (x,y,z,args){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));\n};\nvar G__21313 \x3d function (x,y,z,var_args){\nvar args \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21314__i \x3d 0, G__21314__a \x3d new Array(arguments.length -  3);\nwhile (G__21314__i \x3c G__21314__a.length) {G__21314__a[G__21314__i] \x3d arguments[G__21314__i + 3]; ++G__21314__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21314__a,0,null);\n} \nreturn G__21313__delegate.call(this,x,y,z,args);};\nG__21313.cljs$lang$maxFixedArity \x3d 3;\nG__21313.cljs$lang$applyTo \x3d (function (arglist__21315){\nvar x \x3d cljs.core.first(arglist__21315);\narglist__21315 \x3d cljs.core.next(arglist__21315);\nvar y \x3d cljs.core.first(arglist__21315);\narglist__21315 \x3d cljs.core.next(arglist__21315);\nvar z \x3d cljs.core.first(arglist__21315);\nvar args \x3d cljs.core.rest(arglist__21315);\nreturn G__21313__delegate(x,y,z,args);\n});\nG__21313.cljs$core$IFn$_invoke$arity$variadic \x3d G__21313__delegate;\nreturn G__21313;\n})()\n;\nG__21306 \x3d function(x,y,z,var_args){\nvar args \x3d var_args;\nswitch(arguments.length){\ncase 0:\nreturn G__21306__0.call(this);\ncase 1:\nreturn G__21306__1.call(this,x);\ncase 2:\nreturn G__21306__2.call(this,x,y);\ncase 3:\nreturn G__21306__3.call(this,x,y,z);\ndefault:\nvar G__21322 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21323__i \x3d 0, G__21323__a \x3d new Array(arguments.length -  3);\nwhile (G__21323__i \x3c G__21323__a.length) {G__21323__a[G__21323__i] \x3d arguments[G__21323__i + 3]; ++G__21323__i;}\nG__21322 \x3d new cljs.core.IndexedSeq(G__21323__a,0,null);\n}\nreturn G__21306__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__21322);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21306.cljs$lang$maxFixedArity \x3d 3;\nG__21306.cljs$lang$applyTo \x3d G__21306__4.cljs$lang$applyTo;\nG__21306.cljs$core$IFn$_invoke$arity$0 \x3d G__21306__0;\nG__21306.cljs$core$IFn$_invoke$arity$1 \x3d G__21306__1;\nG__21306.cljs$core$IFn$_invoke$arity$2 \x3d G__21306__2;\nG__21306.cljs$core$IFn$_invoke$arity$3 \x3d G__21306__3;\nG__21306.cljs$core$IFn$_invoke$arity$variadic \x3d G__21306__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21306;\n})()\n}));\n\n(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic \x3d (function (f,arg1,arg2,arg3,more){\nreturn (function() { \nvar G__21324__delegate \x3d function (args){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));\n};\nvar G__21324 \x3d function (var_args){\nvar args \x3d null;\nif (arguments.length \x3e 0) {\nvar G__21325__i \x3d 0, G__21325__a \x3d new Array(arguments.length -  0);\nwhile (G__21325__i \x3c G__21325__a.length) {G__21325__a[G__21325__i] \x3d arguments[G__21325__i + 0]; ++G__21325__i;}\n  args \x3d new cljs.core.IndexedSeq(G__21325__a,0,null);\n} \nreturn G__21324__delegate.call(this,args);};\nG__21324.cljs$lang$maxFixedArity \x3d 0;\nG__21324.cljs$lang$applyTo \x3d (function (arglist__21326){\nvar args \x3d cljs.core.seq(arglist__21326);\nreturn G__21324__delegate(args);\n});\nG__21324.cljs$core$IFn$_invoke$arity$variadic \x3d G__21324__delegate;\nreturn G__21324;\n})()\n;\n}));\n\n/** @this {Function} */\n(cljs.core.partial.cljs$lang$applyTo \x3d (function (seq18839){\nvar G__18840 \x3d cljs.core.first(seq18839);\nvar seq18839__$1 \x3d cljs.core.next(seq18839);\nvar G__18841 \x3d cljs.core.first(seq18839__$1);\nvar seq18839__$2 \x3d cljs.core.next(seq18839__$1);\nvar G__18842 \x3d cljs.core.first(seq18839__$2);\nvar seq18839__$3 \x3d cljs.core.next(seq18839__$2);\nvar G__18843 \x3d cljs.core.first(seq18839__$3);\nvar seq18839__$4 \x3d cljs.core.next(seq18839__$3);\nvar self__4717__auto__ \x3d this;\nreturn self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18840,G__18841,G__18842,G__18843,seq18839__$4);\n}));\n\n(cljs.core.partial.cljs$lang$maxFixedArity \x3d (4));\n\n/**\n * Takes a function f, and returns a function that calls f, replacing\n *   a nil first argument to f with the supplied value x. Higher arity\n *   versions can replace arguments in the second and third\n *   positions (y, z). Note that the function f can take any number of\n *   arguments, not just the one(s) being nil-patched.\n */\ncljs.core.fnil \x3d (function cljs$core$fnil(var_args){\nvar G__18846 \x3d arguments.length;\nswitch (G__18846) {\ncase 2:\nreturn cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,x){\nreturn (function() {\nvar G__21338 \x3d null;\nvar G__21338__1 \x3d (function (a){\nvar G__18847 \x3d (((a \x3d\x3d null))?x:a);\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18847) : f.call(null,G__18847));\n});\nvar G__21338__2 \x3d (function (a,b){\nvar G__18848 \x3d (((a \x3d\x3d null))?x:a);\nvar G__18849 \x3d b;\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18848,G__18849) : f.call(null,G__18848,G__18849));\n});\nvar G__21338__3 \x3d (function (a,b,c){\nvar G__18850 \x3d (((a \x3d\x3d null))?x:a);\nvar G__18851 \x3d b;\nvar G__18852 \x3d c;\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18850,G__18851,G__18852) : f.call(null,G__18850,G__18851,G__18852));\n});\nvar G__21338__4 \x3d (function() { \nvar G__21339__delegate \x3d function (a,b,c,ds){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a \x3d\x3d null))?x:a),b,c,ds);\n};\nvar G__21339 \x3d function (a,b,c,var_args){\nvar ds \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21340__i \x3d 0, G__21340__a \x3d new Array(arguments.length -  3);\nwhile (G__21340__i \x3c G__21340__a.length) {G__21340__a[G__21340__i] \x3d arguments[G__21340__i + 3]; ++G__21340__i;}\n  ds \x3d new cljs.core.IndexedSeq(G__21340__a,0,null);\n} \nreturn G__21339__delegate.call(this,a,b,c,ds);};\nG__21339.cljs$lang$maxFixedArity \x3d 3;\nG__21339.cljs$lang$applyTo \x3d (function (arglist__21341){\nvar a \x3d cljs.core.first(arglist__21341);\narglist__21341 \x3d cljs.core.next(arglist__21341);\nvar b \x3d cljs.core.first(arglist__21341);\narglist__21341 \x3d cljs.core.next(arglist__21341);\nvar c \x3d cljs.core.first(arglist__21341);\nvar ds \x3d cljs.core.rest(arglist__21341);\nreturn G__21339__delegate(a,b,c,ds);\n});\nG__21339.cljs$core$IFn$_invoke$arity$variadic \x3d G__21339__delegate;\nreturn G__21339;\n})()\n;\nG__21338 \x3d function(a,b,c,var_args){\nvar ds \x3d var_args;\nswitch(arguments.length){\ncase 1:\nreturn G__21338__1.call(this,a);\ncase 2:\nreturn G__21338__2.call(this,a,b);\ncase 3:\nreturn G__21338__3.call(this,a,b,c);\ndefault:\nvar G__21342 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21343__i \x3d 0, G__21343__a \x3d new Array(arguments.length -  3);\nwhile (G__21343__i \x3c G__21343__a.length) {G__21343__a[G__21343__i] \x3d arguments[G__21343__i + 3]; ++G__21343__i;}\nG__21342 \x3d new cljs.core.IndexedSeq(G__21343__a,0,null);\n}\nreturn G__21338__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__21342);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21338.cljs$lang$maxFixedArity \x3d 3;\nG__21338.cljs$lang$applyTo \x3d G__21338__4.cljs$lang$applyTo;\nG__21338.cljs$core$IFn$_invoke$arity$1 \x3d G__21338__1;\nG__21338.cljs$core$IFn$_invoke$arity$2 \x3d G__21338__2;\nG__21338.cljs$core$IFn$_invoke$arity$3 \x3d G__21338__3;\nG__21338.cljs$core$IFn$_invoke$arity$variadic \x3d G__21338__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21338;\n})()\n}));\n\n(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,x,y){\nreturn (function() {\nvar G__21344 \x3d null;\nvar G__21344__2 \x3d (function (a,b){\nvar G__18853 \x3d (((a \x3d\x3d null))?x:a);\nvar G__18854 \x3d (((b \x3d\x3d null))?y:b);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18853,G__18854) : f.call(null,G__18853,G__18854));\n});\nvar G__21344__3 \x3d (function (a,b,c){\nvar G__18855 \x3d (((a \x3d\x3d null))?x:a);\nvar G__18856 \x3d (((b \x3d\x3d null))?y:b);\nvar G__18857 \x3d c;\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18855,G__18856,G__18857) : f.call(null,G__18855,G__18856,G__18857));\n});\nvar G__21344__4 \x3d (function() { \nvar G__21345__delegate \x3d function (a,b,c,ds){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a \x3d\x3d null))?x:a),(((b \x3d\x3d null))?y:b),c,ds);\n};\nvar G__21345 \x3d function (a,b,c,var_args){\nvar ds \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21346__i \x3d 0, G__21346__a \x3d new Array(arguments.length -  3);\nwhile (G__21346__i \x3c G__21346__a.length) {G__21346__a[G__21346__i] \x3d arguments[G__21346__i + 3]; ++G__21346__i;}\n  ds \x3d new cljs.core.IndexedSeq(G__21346__a,0,null);\n} \nreturn G__21345__delegate.call(this,a,b,c,ds);};\nG__21345.cljs$lang$maxFixedArity \x3d 3;\nG__21345.cljs$lang$applyTo \x3d (function (arglist__21347){\nvar a \x3d cljs.core.first(arglist__21347);\narglist__21347 \x3d cljs.core.next(arglist__21347);\nvar b \x3d cljs.core.first(arglist__21347);\narglist__21347 \x3d cljs.core.next(arglist__21347);\nvar c \x3d cljs.core.first(arglist__21347);\nvar ds \x3d cljs.core.rest(arglist__21347);\nreturn G__21345__delegate(a,b,c,ds);\n});\nG__21345.cljs$core$IFn$_invoke$arity$variadic \x3d G__21345__delegate;\nreturn G__21345;\n})()\n;\nG__21344 \x3d function(a,b,c,var_args){\nvar ds \x3d var_args;\nswitch(arguments.length){\ncase 2:\nreturn G__21344__2.call(this,a,b);\ncase 3:\nreturn G__21344__3.call(this,a,b,c);\ndefault:\nvar G__21348 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21349__i \x3d 0, G__21349__a \x3d new Array(arguments.length -  3);\nwhile (G__21349__i \x3c G__21349__a.length) {G__21349__a[G__21349__i] \x3d arguments[G__21349__i + 3]; ++G__21349__i;}\nG__21348 \x3d new cljs.core.IndexedSeq(G__21349__a,0,null);\n}\nreturn G__21344__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__21348);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21344.cljs$lang$maxFixedArity \x3d 3;\nG__21344.cljs$lang$applyTo \x3d G__21344__4.cljs$lang$applyTo;\nG__21344.cljs$core$IFn$_invoke$arity$2 \x3d G__21344__2;\nG__21344.cljs$core$IFn$_invoke$arity$3 \x3d G__21344__3;\nG__21344.cljs$core$IFn$_invoke$arity$variadic \x3d G__21344__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21344;\n})()\n}));\n\n(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 \x3d (function (f,x,y,z){\nreturn (function() {\nvar G__21351 \x3d null;\nvar G__21351__2 \x3d (function (a,b){\nvar G__18858 \x3d (((a \x3d\x3d null))?x:a);\nvar G__18859 \x3d (((b \x3d\x3d null))?y:b);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18858,G__18859) : f.call(null,G__18858,G__18859));\n});\nvar G__21351__3 \x3d (function (a,b,c){\nvar G__18860 \x3d (((a \x3d\x3d null))?x:a);\nvar G__18861 \x3d (((b \x3d\x3d null))?y:b);\nvar G__18862 \x3d (((c \x3d\x3d null))?z:c);\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18860,G__18861,G__18862) : f.call(null,G__18860,G__18861,G__18862));\n});\nvar G__21351__4 \x3d (function() { \nvar G__21353__delegate \x3d function (a,b,c,ds){\nreturn cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a \x3d\x3d null))?x:a),(((b \x3d\x3d null))?y:b),(((c \x3d\x3d null))?z:c),ds);\n};\nvar G__21353 \x3d function (a,b,c,var_args){\nvar ds \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21354__i \x3d 0, G__21354__a \x3d new Array(arguments.length -  3);\nwhile (G__21354__i \x3c G__21354__a.length) {G__21354__a[G__21354__i] \x3d arguments[G__21354__i + 3]; ++G__21354__i;}\n  ds \x3d new cljs.core.IndexedSeq(G__21354__a,0,null);\n} \nreturn G__21353__delegate.call(this,a,b,c,ds);};\nG__21353.cljs$lang$maxFixedArity \x3d 3;\nG__21353.cljs$lang$applyTo \x3d (function (arglist__21355){\nvar a \x3d cljs.core.first(arglist__21355);\narglist__21355 \x3d cljs.core.next(arglist__21355);\nvar b \x3d cljs.core.first(arglist__21355);\narglist__21355 \x3d cljs.core.next(arglist__21355);\nvar c \x3d cljs.core.first(arglist__21355);\nvar ds \x3d cljs.core.rest(arglist__21355);\nreturn G__21353__delegate(a,b,c,ds);\n});\nG__21353.cljs$core$IFn$_invoke$arity$variadic \x3d G__21353__delegate;\nreturn G__21353;\n})()\n;\nG__21351 \x3d function(a,b,c,var_args){\nvar ds \x3d var_args;\nswitch(arguments.length){\ncase 2:\nreturn G__21351__2.call(this,a,b);\ncase 3:\nreturn G__21351__3.call(this,a,b,c);\ndefault:\nvar G__21356 \x3d null;\nif (arguments.length \x3e 3) {\nvar G__21357__i \x3d 0, G__21357__a \x3d new Array(arguments.length -  3);\nwhile (G__21357__i \x3c G__21357__a.length) {G__21357__a[G__21357__i] \x3d arguments[G__21357__i + 3]; ++G__21357__i;}\nG__21356 \x3d new cljs.core.IndexedSeq(G__21357__a,0,null);\n}\nreturn G__21351__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__21356);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21351.cljs$lang$maxFixedArity \x3d 3;\nG__21351.cljs$lang$applyTo \x3d G__21351__4.cljs$lang$applyTo;\nG__21351.cljs$core$IFn$_invoke$arity$2 \x3d G__21351__2;\nG__21351.cljs$core$IFn$_invoke$arity$3 \x3d G__21351__3;\nG__21351.cljs$core$IFn$_invoke$arity$variadic \x3d G__21351__4.cljs$core$IFn$_invoke$arity$variadic;\nreturn G__21351;\n})()\n}));\n\n(cljs.core.fnil.cljs$lang$maxFixedArity \x3d 4);\n\n/**\n * Returns a lazy sequence consisting of the result of applying f to 0\n *   and the first item of coll, followed by applying f to 1 and the second\n *   item in coll, etc, until coll is exhausted. Thus function f should\n *   accept 2 arguments, index and item. Returns a stateful transducer when\n *   no collection is provided.\n */\ncljs.core.map_indexed \x3d (function cljs$core$map_indexed(var_args){\nvar G__18864 \x3d arguments.length;\nswitch (G__18864) {\ncase 1:\nreturn cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 \x3d (function (f){\nreturn (function (rf){\nvar i \x3d (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));\nreturn (function() {\nvar G__21360 \x3d null;\nvar G__21360__0 \x3d (function (){\nreturn (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));\n});\nvar G__21360__1 \x3d (function (result){\nreturn (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));\n});\nvar G__21360__2 \x3d (function (result,input){\nvar G__18865 \x3d result;\nvar G__18866 \x3d (function (){var G__18867 \x3d cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));\nvar G__18868 \x3d input;\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18867,G__18868) : f.call(null,G__18867,G__18868));\n})();\nreturn (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18865,G__18866) : rf.call(null,G__18865,G__18866));\n});\nG__21360 \x3d function(result,input){\nswitch(arguments.length){\ncase 0:\nreturn G__21360__0.call(this);\ncase 1:\nreturn G__21360__1.call(this,result);\ncase 2:\nreturn G__21360__2.call(this,result,input);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21360.cljs$core$IFn$_invoke$arity$0 \x3d G__21360__0;\nG__21360.cljs$core$IFn$_invoke$arity$1 \x3d G__21360__1;\nG__21360.cljs$core$IFn$_invoke$arity$2 \x3d G__21360__2;\nreturn G__21360;\n})()\n});\n}));\n\n(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,coll){\nvar mapi \x3d (function cljs$core$mapi(idx,coll__$1){\nreturn (new cljs.core.LazySeq(null,(function (){\nvar temp__5735__auto__ \x3d cljs.core.seq(coll__$1);\nif(temp__5735__auto__){\nvar s \x3d temp__5735__auto__;\nif(cljs.core.chunked_seq_QMARK_(s)){\nvar c \x3d cljs.core.chunk_first(s);\nvar size \x3d cljs.core.count(c);\nvar b \x3d cljs.core.chunk_buffer(size);\nvar n__4607__auto___21361 \x3d size;\nvar i_21362 \x3d (0);\nwhile(true){\nif((i_21362 \x3c n__4607__auto___21361)){\ncljs.core.chunk_append(b,(function (){var G__18873 \x3d (idx + i_21362);\nvar G__18874 \x3d cljs.core._nth(c,i_21362);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18873,G__18874) : f.call(null,G__18873,G__18874));\n})());\n\nvar G__21363 \x3d (i_21362 + (1));\ni_21362 \x3d G__21363;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));\n} else {\nreturn cljs.core.cons((function (){var G__18875 \x3d idx;\nvar G__18876 \x3d cljs.core.first(s);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18875,G__18876) : f.call(null,G__18875,G__18876));\n})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));\n}\n} else {\nreturn null;\n}\n}),null,null));\n});\nreturn mapi((0),coll);\n}));\n\n(cljs.core.map_indexed.cljs$lang$maxFixedArity \x3d 2);\n\n/**\n * Returns a lazy sequence of the non-nil results of (f item). Note,\n *   this means false return values will be included.  f must be free of\n *   side-effects.  Returns a transducer when no collection is provided.\n */\ncljs.core.keep \x3d (function cljs$core$keep(var_args){\nvar G__18878 \x3d arguments.length;\nswitch (G__18878) {\ncase 1:\nreturn cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\n(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 \x3d (function (f){\nreturn (function (rf){\nreturn (function() {\nvar G__21365 \x3d null;\nvar G__21365__0 \x3d (function (){\nreturn (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));\n});\nvar G__21365__1 \x3d (function (result){\nreturn (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));\n});\nvar G__21365__2 \x3d (function (result,input){\nvar v \x3d (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));\nif((v \x3d\x3d null)){\nreturn result;\n} else {\nreturn (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));\n}\n});\nG__21365 \x3d function(result,input){\nswitch(arguments.length){\ncase 0:\nreturn G__21365__0.call(this);\ncase 1:\nreturn G__21365__1.call(this,result);\ncase 2:\nreturn G__21365__2.call(this,result,input);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__21365.cljs$core$IFn$_invoke$arity$0 \x3d G__21365__0;\nG__21365.cljs$core$IFn$_invoke$arity$1 \x3d G__21365__1;\nG__21365.cljs$core$IFn$_invoke$arity$2 \x3d G__21365__2;\nreturn G__21365;\n})()\n});\n}));\n\n(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,coll){\nreturn (new cljs.core.LazySeq(null,(function (){\nvar temp__5735__auto__ \x3d cljs.core.seq(coll);\nif(temp__5735__auto__){\nvar s \x3d temp__5735__auto__;\nif(cljs.core.chunked_seq_QMARK_(s)){\nvar c \x3d cljs.core.chunk_first(s);\nvar size \x3d cljs.core.count(c);\nvar b \x3d cljs.core.chunk_buffer(size);\nvar n__4607__auto___21369 \x3d size;\nvar i_21370 \x3d (0);\nwhile(true){\nif((i_21370 \x3c n__4607__auto___21369)){\nvar x_21371 \x3d (function (){var G__18879 \x3d cljs.core._nth(c,i_21370);\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18879) : f.call(null,G__18879));\n})();\nif((x_21371 \x3d\x3d null)){\n} else {\ncljs.core.chunk_append(b,x_21371);\n}\n\nvar G__21375 \x3d (i_21370 + (1));\ni_21370 \x3d G__21375;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));\n} else {\nvar x \x3d (function (){var G__18880 \x3d cljs.core.first(s);\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18880) : f.call(null,G__18880));\n})();\nif((x \x3d\x3d null)){\nreturn cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));\n} else {\nreturn cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));\n}\n}\n} else {\nreturn null;\n}\n}),null,null));\n}));\n\n(cljs.core.keep.cljs$lang$maxFixedArity \x3d 2);\n\n\n/**\n* @constructor\n * @implements {cljs.core.IWatchable}\n * @implements {cljs.core.IAtom}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.IDeref}\n*/\ncljs.core.Atom \x3d (function (state,meta,validator,watches){\nthis.state \x3d state;\nthis.meta \x3d meta;\nthis.validator \x3d validator;\nthis.watches \x3d watches;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 16386;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 6455296;\n});\n(cljs.core.Atom.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n}));\n\n(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (o,other){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn (o__$1 \x3d\x3d\x3d other);\n}));\n\n(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.state;\n}));\n\n(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.meta;\n}));\n\n(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 \x3d (function (this$,oldval,newval){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nvar seq__18881 \x3d cljs.core.seq(self__.watches);\nvar chunk__18882 \x3d null;\nvar count__18883 \x3d (0);\nvar i__18884 \x3d (0);\nwhile(true){\nif((i__18884 \x3c count__18883)){\nvar vec__18891 \x3d chunk__18882.cljs$core$IIndexed$_nth$arity$2(null,i__18884);\nvar key \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18891,(0),null);\nvar f \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18891,(1),null);\n(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));\n\n\nvar G__21379 \x3d seq__18881;\nvar G__21380 \x3d chunk__18882;\nvar G__21381 \x3d count__18883;\nvar G__21382 \x3d (i__18884 + (1));\nseq__18881 \x3d G__21379;\nchunk__18882 \x3d G__21380;\ncount__18883 \x3d G__21381;\ni__18884 \x3d G__21382;\ncontinue;\n} else {\nvar temp__5735__auto__ \x3d cljs.core.seq(seq__18881);\nif(temp__5735__auto__){\nvar seq__18881__$1 \x3d temp__5735__auto__;\nif(cljs.core.chunked_seq_QMARK_(seq__18881__$1)){\nvar c__4550__auto__ \x3d cljs.core.chunk_first(seq__18881__$1);\nvar G__21383 \x3d cljs.core.chunk_rest(seq__18881__$1);\nvar G__21384 \x3d c__4550__auto__;\nvar G__21385 \x3d cljs.core.count(c__4550__auto__);\nvar G__21386 \x3d (0);\nseq__18881 \x3d G__21383;\nchunk