goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__25194){
var map__25195 = p__25194;
var map__25195__$1 = (((((!((map__25195 == null))))?(((((map__25195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25195.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25195):map__25195);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25195__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25195__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25195__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25195__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4120__auto__ = child_of;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__25197_25225 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__25198_25226 = null;
var count__25199_25227 = (0);
var i__25200_25228 = (0);
while(true){
if((i__25200_25228 < count__25199_25227)){
var vec__25211_25229 = chunk__25198_25226.cljs$core$IIndexed$_nth$arity$2(null,i__25200_25228);
var k_25230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25211_25229,(0),null);
var cb_25231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25211_25229,(1),null);
try{var G__25215_25232 = cljs.core.deref(re_frame.trace.traces);
(cb_25231.cljs$core$IFn$_invoke$arity$1 ? cb_25231.cljs$core$IFn$_invoke$arity$1(G__25215_25232) : cb_25231.call(null,G__25215_25232));
}catch (e25214){var e_25233 = e25214;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_25230,"while storing",cljs.core.deref(re_frame.trace.traces),e_25233], 0));
}

var G__25234 = seq__25197_25225;
var G__25235 = chunk__25198_25226;
var G__25236 = count__25199_25227;
var G__25237 = (i__25200_25228 + (1));
seq__25197_25225 = G__25234;
chunk__25198_25226 = G__25235;
count__25199_25227 = G__25236;
i__25200_25228 = G__25237;
continue;
} else {
var temp__5735__auto___25241 = cljs.core.seq(seq__25197_25225);
if(temp__5735__auto___25241){
var seq__25197_25242__$1 = temp__5735__auto___25241;
if(cljs.core.chunked_seq_QMARK_(seq__25197_25242__$1)){
var c__4550__auto___25243 = cljs.core.chunk_first(seq__25197_25242__$1);
var G__25244 = cljs.core.chunk_rest(seq__25197_25242__$1);
var G__25245 = c__4550__auto___25243;
var G__25246 = cljs.core.count(c__4550__auto___25243);
var G__25247 = (0);
seq__25197_25225 = G__25244;
chunk__25198_25226 = G__25245;
count__25199_25227 = G__25246;
i__25200_25228 = G__25247;
continue;
} else {
var vec__25216_25248 = cljs.core.first(seq__25197_25242__$1);
var k_25249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25216_25248,(0),null);
var cb_25250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25216_25248,(1),null);
try{var G__25220_25251 = cljs.core.deref(re_frame.trace.traces);
(cb_25250.cljs$core$IFn$_invoke$arity$1 ? cb_25250.cljs$core$IFn$_invoke$arity$1(G__25220_25251) : cb_25250.call(null,G__25220_25251));
}catch (e25219){var e_25252 = e25219;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_25249,"while storing",cljs.core.deref(re_frame.trace.traces),e_25252], 0));
}

var G__25253 = cljs.core.next(seq__25197_25242__$1);
var G__25254 = null;
var G__25255 = (0);
var G__25256 = (0);
seq__25197_25225 = G__25253;
chunk__25198_25226 = G__25254;
count__25199_25227 = G__25255;
i__25200_25228 = G__25256;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
