goog.provide('pinkgorilla.storage.repo');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('clojure.string');
goog.require('pinkgorilla.storage.storage');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
pinkgorilla.storage.repo.StorageRepo = (function (user,repo,filename,__meta,__extmap,__hash){
this.user = user;
this.repo = repo;
this.filename = filename;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4374__auto__,k__4375__auto__){
var self__ = this;
var this__4374__auto____$1 = this;
return this__4374__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4375__auto__,null);
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4376__auto__,k46325,else__4377__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var G__46329 = k46325;
var G__46329__$1 = (((G__46329 instanceof cljs.core.Keyword))?G__46329.fqn:null);
switch (G__46329__$1) {
case "user":
return self__.user;

break;
case "repo":
return self__.repo;

break;
case "filename":
return self__.filename;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46325,else__4377__auto__);

}
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4393__auto__,f__4394__auto__,init__4395__auto__){
var self__ = this;
var this__4393__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4396__auto__,p__46330){
var vec__46331 = p__46330;
var k__4397__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46331,(0),null);
var v__4398__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46331,(1),null);
return (f__4394__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4394__auto__.cljs$core$IFn$_invoke$arity$3(ret__4396__auto__,k__4397__auto__,v__4398__auto__) : f__4394__auto__.call(null,ret__4396__auto__,k__4397__auto__,v__4398__auto__));
}),init__4395__auto__,this__4393__auto____$1);
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4388__auto__,writer__4389__auto__,opts__4390__auto__){
var self__ = this;
var this__4388__auto____$1 = this;
var pr_pair__4391__auto__ = (function (keyval__4392__auto__){
return cljs.core.pr_sequential_writer(writer__4389__auto__,cljs.core.pr_writer,""," ","",opts__4390__auto__,keyval__4392__auto__);
});
return cljs.core.pr_sequential_writer(writer__4389__auto__,pr_pair__4391__auto__,"#pinkgorilla.storage.repo.StorageRepo{",", ","}",opts__4390__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"user","user",1532431356),self__.user],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"repo","repo",-1999060679),self__.repo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"filename","filename",-1428840783),self__.filename],null))], null),self__.__extmap));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46324){
var self__ = this;
var G__46324__$1 = this;
return (new cljs.core.RecordIter((0),G__46324__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"repo","repo",-1999060679),new cljs.core.Keyword(null,"filename","filename",-1428840783)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4372__auto__){
var self__ = this;
var this__4372__auto____$1 = this;
return self__.__meta;
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4369__auto__){
var self__ = this;
var this__4369__auto____$1 = this;
return (new pinkgorilla.storage.repo.StorageRepo(self__.user,self__.repo,self__.filename,self__.__meta,self__.__extmap,self__.__hash));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4370__auto__){
var self__ = this;
var this__4370__auto____$1 = this;
var h__4232__auto__ = self__.__hash;
if((!((h__4232__auto__ == null)))){
return h__4232__auto__;
} else {
var h__4232__auto____$1 = (function (coll__4371__auto__){
return (1911499952 ^ cljs.core.hash_unordered_coll(coll__4371__auto__));
})(this__4370__auto____$1);
(self__.__hash = h__4232__auto____$1);

return h__4232__auto____$1;
}
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46326,other46327){
var self__ = this;
var this46326__$1 = this;
return (((!((other46327 == null)))) && ((this46326__$1.constructor === other46327.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46326__$1.user,other46327.user)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46326__$1.repo,other46327.repo)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46326__$1.filename,other46327.filename)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46326__$1.__extmap,other46327.__extmap)));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4383__auto__,k__4384__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),null,new cljs.core.Keyword(null,"repo","repo",-1999060679),null,new cljs.core.Keyword(null,"user","user",1532431356),null], null), null),k__4384__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4383__auto____$1),self__.__meta),k__4384__auto__);
} else {
return (new pinkgorilla.storage.repo.StorageRepo(self__.user,self__.repo,self__.filename,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4384__auto__)),null));
}
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4381__auto__,k__4382__auto__,G__46324){
var self__ = this;
var this__4381__auto____$1 = this;
var pred__46334 = cljs.core.keyword_identical_QMARK_;
var expr__46335 = k__4382__auto__;
if(cljs.core.truth_((pred__46334.cljs$core$IFn$_invoke$arity$2 ? pred__46334.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"user","user",1532431356),expr__46335) : pred__46334.call(null,new cljs.core.Keyword(null,"user","user",1532431356),expr__46335)))){
return (new pinkgorilla.storage.repo.StorageRepo(G__46324,self__.repo,self__.filename,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46334.cljs$core$IFn$_invoke$arity$2 ? pred__46334.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"repo","repo",-1999060679),expr__46335) : pred__46334.call(null,new cljs.core.Keyword(null,"repo","repo",-1999060679),expr__46335)))){
return (new pinkgorilla.storage.repo.StorageRepo(self__.user,G__46324,self__.filename,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46334.cljs$core$IFn$_invoke$arity$2 ? pred__46334.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"filename","filename",-1428840783),expr__46335) : pred__46334.call(null,new cljs.core.Keyword(null,"filename","filename",-1428840783),expr__46335)))){
return (new pinkgorilla.storage.repo.StorageRepo(self__.user,self__.repo,G__46324,self__.__meta,self__.__extmap,null));
} else {
return (new pinkgorilla.storage.repo.StorageRepo(self__.user,self__.repo,self__.filename,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4382__auto__,G__46324),null));
}
}
}
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4386__auto__){
var self__ = this;
var this__4386__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"user","user",1532431356),self__.user,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"repo","repo",-1999060679),self__.repo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"filename","filename",-1428840783),self__.filename,null))], null),self__.__extmap));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4373__auto__,G__46324){
var self__ = this;
var this__4373__auto____$1 = this;
return (new pinkgorilla.storage.repo.StorageRepo(self__.user,self__.repo,self__.filename,G__46324,self__.__extmap,self__.__hash));
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4379__auto__,entry__4380__auto__){
var self__ = this;
var this__4379__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4380__auto__)){
return this__4379__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4380__auto__,(0)),cljs.core._nth(entry__4380__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4379__auto____$1,entry__4380__auto__);
}
}));

(pinkgorilla.storage.repo.StorageRepo.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"user","user",-1122004413,null),new cljs.core.Symbol(null,"repo","repo",-358529152,null),new cljs.core.Symbol(null,"filename","filename",211690744,null)], null);
}));

(pinkgorilla.storage.repo.StorageRepo.cljs$lang$type = true);

(pinkgorilla.storage.repo.StorageRepo.cljs$lang$ctorPrSeq = (function (this__4417__auto__){
return (new cljs.core.List(null,"pinkgorilla.storage.repo/StorageRepo",null,(1),null));
}));

(pinkgorilla.storage.repo.StorageRepo.cljs$lang$ctorPrWriter = (function (this__4417__auto__,writer__4418__auto__){
return cljs.core._write(writer__4418__auto__,"pinkgorilla.storage.repo/StorageRepo");
}));

/**
 * Positional factory function for pinkgorilla.storage.repo/StorageRepo.
 */
pinkgorilla.storage.repo.__GT_StorageRepo = (function pinkgorilla$storage$repo$__GT_StorageRepo(user,repo,filename){
return (new pinkgorilla.storage.repo.StorageRepo(user,repo,filename,null,null,null));
});

/**
 * Factory function for pinkgorilla.storage.repo/StorageRepo, taking a map of keywords to field values.
 */
pinkgorilla.storage.repo.map__GT_StorageRepo = (function pinkgorilla$storage$repo$map__GT_StorageRepo(G__46328){
var extmap__4413__auto__ = (function (){var G__46337 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46328,new cljs.core.Keyword(null,"user","user",1532431356),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"repo","repo",-1999060679),new cljs.core.Keyword(null,"filename","filename",-1428840783)], 0));
if(cljs.core.record_QMARK_(G__46328)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46337);
} else {
return G__46337;
}
})();
return (new pinkgorilla.storage.repo.StorageRepo(new cljs.core.Keyword(null,"user","user",1532431356).cljs$core$IFn$_invoke$arity$1(G__46328),new cljs.core.Keyword(null,"repo","repo",-1999060679).cljs$core$IFn$_invoke$arity$1(G__46328),new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(G__46328),null,cljs.core.not_empty(extmap__4413__auto__),null));
});

pinkgorilla.storage.storage.query_params_to_storage.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"repo","repo",-1999060679),(function (_,params){
return (new pinkgorilla.storage.repo.StorageRepo(new cljs.core.Keyword(null,"user","user",1532431356).cljs$core$IFn$_invoke$arity$1(params),new cljs.core.Keyword(null,"repo","repo",-1999060679).cljs$core$IFn$_invoke$arity$1(params),(function (){var or__4120__auto__ = new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(params);
}
})(),null,null,null));
}));
(pinkgorilla.storage.repo.StorageRepo.prototype.pinkgorilla$storage$storage$Storage$ = cljs.core.PROTOCOL_SENTINEL);

(pinkgorilla.storage.repo.StorageRepo.prototype.pinkgorilla$storage$storage$Storage$storagetype$arity$1 = (function (self){
var self__$1 = this;
return new cljs.core.Keyword(null,"repo","repo",-1999060679);
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.pinkgorilla$storage$storage$Storage$storageformat$arity$1 = (function (self){
var self__$1 = this;
return new cljs.core.Keyword(null,"gorilla","gorilla",-211534157);
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.pinkgorilla$storage$storage$Storage$external_url$arity$1 = (function (self){
var self__$1 = this;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.storage.repo","/tmp/form-init2806228143329832606.clj",28,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["local-storage.external-url"], null);
}),null)),null,1016096343);

return ["https://github.com/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.user),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.repo),"/blob/master/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.filename)].join('');
}));

(pinkgorilla.storage.repo.StorageRepo.prototype.pinkgorilla$storage$storage$Storage$gorilla_path$arity$1 = (function (self){
var self__$1 = this;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.storage.repo","/tmp/form-init2806228143329832606.clj",33,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["repo-storage.gorilla-path"], null);
}),null)),null,1764513386);

return ["/edit?source=repo&filename=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.filename),"&user=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.user),"&repo=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.repo)].join('');
}));

//# sourceMappingURL=pinkgorilla.storage.repo.js.map
