goog.provide('pinkgorilla.kernel.nrepl');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.spec.alpha');
goog.require('cljs.core.async');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('re_frame.core');
goog.require('cljs.reader');
goog.require('chord.client');
goog.require('pinkgorilla.notifications');
goog.require('pinkgorilla.kernel.cljs_helper');
goog.require('pinkgorilla.kernel.nrepl_specs');
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.nrepl !== 'undefined') && (typeof pinkgorilla.kernel.nrepl.ws_repl !== 'undefined')){
} else {
pinkgorilla.kernel.nrepl.ws_repl = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"channel","channel",734187692),null,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),null,new cljs.core.Keyword(null,"evaluations","evaluations",57802423),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ciders","ciders",-1421942407),cljs.core.PersistentArrayMap.EMPTY], null));
}
/**
 * awb99: TODO: if websocket is nil, this will throw! (or not?).
 * This could be the error of some of the notebooks not loading.
 * Why dont we keep the core.async channels open all the time. And when we have a
 * websocket connection, then the messages get sent. Or we just dump messages that happen
 * before the socket gets opened. But in this case we have to LOG message dumping.
 * I have seen situations where the first eval does not go through. Might be this issue.
 * 
 * - generates request id
 * - sends message to websocket (so nrepl/cider can process the request)
 * - saves the callback function into a lookup map to an atom
 * - returns the val id.
 * 
 */
pinkgorilla.kernel.nrepl.send_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_message_BANG_(key,message,callback){
var eval_id = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
var nrepl_msg = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),eval_id,new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl))], null)], 0));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(eval_id)], null),callback);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",50,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws sending ws message: ",nrepl_msg], null);
}),null)),null,1630348690);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl)),nrepl_msg);

return eval_id;
});
pinkgorilla.kernel.nrepl.eval_BANG_ = (function pinkgorilla$kernel$nrepl$eval_BANG_(segment_id,code){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"evaluations","evaluations",57802423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),code], null),segment_id);
});
pinkgorilla.kernel.nrepl.send_cider_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_cider_message_BANG_(message,callback){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"ciders","ciders",-1421942407),message,callback);
});
/**
 * Query the REPL server for autocompletion suggestions. Relies on the cider-nrepl middleware.
 *   We call the given callback with the list of symbols once the REPL server replies.
 */
pinkgorilla.kernel.nrepl.get_completions = (function pinkgorilla$kernel$nrepl$get_completions(symbol,ns,context,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (msg){
var G__43527 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43526_SHARP_){
return new cljs.core.Keyword(null,"candidate","candidate",-940308314).cljs$core$IFn$_invoke$arity$1(p1__43526_SHARP_);
}),new cljs.core.Keyword(null,"completions","completions",-190930179).cljs$core$IFn$_invoke$arity$1(msg));
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__43527) : callback.call(null,G__43527));
}));
});
/**
 * Queries the REPL server for docs for the given symbol. Relies on the cider-nrepl middleware.
 *   Calls back with the documentation text
 */
pinkgorilla.kernel.nrepl.get_completion_doc = (function pinkgorilla$kernel$nrepl$get_completion_doc(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__43528 = new cljs.core.Keyword(null,"completion-doc","completion-doc",792734283).cljs$core$IFn$_invoke$arity$1(msg);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__43528) : callback.call(null,G__43528));
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.kernel.nrepl.resolve_symbol = (function pinkgorilla$kernel$nrepl$resolve_symbol(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__43529 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(msg)], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__43529) : callback.call(null,G__43529));
}));
});
/**
 * converts (:value message)
 * nrepl has to serialize the value before it hits clojure.
 * So this value gets formatted with edn.
 * Since the message is packaged as edn too, we have edn within edn.
 * 
 */
pinkgorilla.kernel.nrepl.parse_value = (function pinkgorilla$kernel$nrepl$parse_value(value){
try{var data = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
var data2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(data);
return data2;
}catch (e43530){if((e43530 instanceof Error)){
var e = e43530;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",106,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["parse-value ex: ",e," tried to parse: ",value], null);
}),null)),null,921875649);
} else {
throw e43530;

}
}});
/**
 * processes an incoming message from websocket that comes from nrepl (and has cider enhancements)
 * dispatches events to reagent to update notebook state ui.
 */
pinkgorilla.kernel.nrepl.process_msg = (function pinkgorilla$kernel$nrepl$process_msg(message){
var map__43531 = message;
var map__43531__$1 = (((((!((map__43531 == null))))?(((((map__43531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43531):map__43531);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"out","out",-910545517));
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"err","err",-2089457205));
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"value","value",305978217));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var eval_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(id);
var segment_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),eval_id], null));
var cider_cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),eval_id], null));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",120,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws rcvd message eval-id ",id," for segment ",segment_id], null);
}),null)),null,1085144275);

if(cljs.core.truth_(segment_id)){
if(cljs.core.truth_(ns)){
var data = pinkgorilla.kernel.nrepl.parse_value(value);
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3(segment_id,data,ns);
} else {
if(cljs.core.truth_(out)){
var G__43533 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),out], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43533) : re_frame.core.dispatch.call(null,G__43533));
} else {
if(cljs.core.truth_(err)){
var error = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),err,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null));
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (msg){
var status__$1 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(msg);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",152,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["err status: ",status__$1], null);
}),null)),null,-535224762);

if(cljs.core.contains_QMARK_(status__$1,new cljs.core.Keyword(null,"done","done",-889844188))){
var G__43534 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),cljs.core.deref(error)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43534) : re_frame.core.dispatch.call(null,G__43534));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(error,(function (err__$1,ex){
if(cljs.core.truth_(new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(err__$1))){
return cljs.core.assoc_in(err__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"cause","cause",231901252)], null),new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(ex));
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ex,err__$1], 0));
}
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"exception","exception",-335277064),msg], null));
}
}));
} else {
if(cljs.core.truth_(root_ex)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",164,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got root-ex",root_ex,"for",segment_id], null);
}),null)),null,526487554);
} else {
if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));

var G__43535 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43535) : re_frame.core.dispatch.call(null,G__43535));
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",173,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rcvd unhandled segment message: ",message], null);
}),null)),null,618393701);

}
}
}
}
}
} else {
if(cljs.core.truth_(cider_cb)){
if(cljs.spec.alpha.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("nrepl-msg","stacktrace-msg","nrepl-msg/stacktrace-msg",1039649502),message)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",180,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rcvd valid stacktrace: ",message], null);
}),null)),null,1324542902);
} else {
}

(cider_cb.cljs$core$IFn$_invoke$arity$1 ? cider_cb.cljs$core$IFn$_invoke$arity$1(message) : cider_cb.call(null,message));

if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
} else {
return null;
}
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",186,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rcvd neither segment nor cider: ",message], null);
}),null)),null,-1587453571);

}
}
});
pinkgorilla.kernel.nrepl.set_clj_kernel_status = (function pinkgorilla$kernel$nrepl$set_clj_kernel_status(connected,session_id){
var G__43536 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kernel-clj-status-set","kernel-clj-status-set",-1158664458),connected,session_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43536) : re_frame.core.dispatch.call(null,G__43536));
});
pinkgorilla.kernel.nrepl.clj_eval = (function pinkgorilla$kernel$nrepl$clj_eval(snippet,callback){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",200,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(snippet)].join('')], null);
}),null)),null,1538646627);

return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),snippet], null),(function (message){
var map__43537 = message;
var map__43537__$1 = (((((!((map__43537 == null))))?(((((map__43537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43537):map__43537);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43537__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43537__$1,new cljs.core.Keyword(null,"value","value",305978217));
var data = pinkgorilla.kernel.nrepl.parse_value(value);
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",206,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval ns: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data)].join('')], null);
}),null)),null,-1346728783);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",207,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["data value:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.Keyword(null,"value","value",305978217)], null)))].join('')], null);
}),null)),null,1468246121);
if(cljs.core.truth_(ns)){
var v2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.Keyword(null,"value","value",305978217)], null)));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",209,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval result: ",v2," type: ",cljs.core.type(v2)], null);
}),null)),null,-604039800);

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(v2) : callback.call(null,v2));
} else {
return null;
}
}));
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval', pinkgorilla.kernel.nrepl.clj_eval);
/**
 * executes a clojure expression
 * and returns the result to the ```result-atom```
 */
pinkgorilla.kernel.nrepl.clj_eval_sync = (function pinkgorilla$kernel$nrepl$clj_eval_sync(result_atom,snippet){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28446__auto___43949 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43542){
var state_val_43543 = (state_43542[(1)]);
if((state_val_43543 === (1))){
var inst_43539 = (function (){return (function (result){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",219,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["async evalued result: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(result)].join('')], null);
}),null)),null,217488553);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_chan,result);
});
})();
var inst_43540 = pinkgorilla.kernel.nrepl.clj_eval(snippet,inst_43539);
var state_43542__$1 = state_43542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43542__$1,inst_43540);
} else {
return null;
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____0 = (function (){
var statearr_43544 = [null,null,null,null,null,null,null];
(statearr_43544[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__);

(statearr_43544[(1)] = (1));

return statearr_43544;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____1 = (function (state_43542){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43542);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43545){var ex__28414__auto__ = e43545;
var statearr_43546_43951 = state_43542;
(statearr_43546_43951[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43542[(4)]))){
var statearr_43547_43952 = state_43542;
(statearr_43547_43952[(1)] = cljs.core.first((state_43542[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43953 = state_43542;
state_43542 = G__43953;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__ = function(state_43542){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____1.call(this,state_43542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43548 = f__28447__auto__();
(statearr_43548[(6)] = c__28446__auto___43949);

return statearr_43548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


var c__28446__auto___43955 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43553){
var state_val_43554 = (state_43553[(1)]);
if((state_val_43554 === (1))){
var state_43553__$1 = state_43553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43553__$1,(2),result_chan);
} else {
if((state_val_43554 === (2))){
var inst_43550 = (state_43553[(2)]);
var inst_43551 = cljs.core.reset_BANG_(result_atom,inst_43550);
var state_43553__$1 = state_43553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43553__$1,inst_43551);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____0 = (function (){
var statearr_43555 = [null,null,null,null,null,null,null];
(statearr_43555[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__);

(statearr_43555[(1)] = (1));

return statearr_43555;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____1 = (function (state_43553){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43553);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43556){var ex__28414__auto__ = e43556;
var statearr_43557_43956 = state_43553;
(statearr_43557_43956[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43553[(4)]))){
var statearr_43558_43957 = state_43553;
(statearr_43558_43957[(1)] = cljs.core.first((state_43553[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43958 = state_43553;
state_43553 = G__43958;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__ = function(state_43553){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____1.call(this,state_43553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43559 = f__28447__auto__();
(statearr_43559[(6)] = c__28446__auto___43955);

return statearr_43559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return result_atom;
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval_sync', pinkgorilla.kernel.nrepl.clj_eval_sync);
/**
 * executes a clojure ```function-as-string``` (from clojurescript) 
 * and stores the result in ```result-atom```
 */
pinkgorilla.kernel.nrepl.clj = (function pinkgorilla$kernel$nrepl$clj(var_args){
var args__4736__auto__ = [];
var len__4730__auto___43959 = arguments.length;
var i__4731__auto___43960 = (0);
while(true){
if((i__4731__auto___43960 < len__4730__auto___43959)){
args__4736__auto__.push((arguments[i__4731__auto___43960]));

var G__43961 = (i__4731__auto___43960 + (1));
i__4731__auto___43960 = G__43961;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj', pinkgorilla.kernel.nrepl.clj);

(pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic = (function (result_atom,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",228,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,1753504560);
var expr = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
var str_eval = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",expr);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",231,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Calling CLJ: ",str_eval].join('')], null);
}),null)),null,-967643702);
return pinkgorilla.kernel.nrepl.clj_eval_sync(result_atom,str_eval);
}));

(pinkgorilla.kernel.nrepl.clj.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.kernel.nrepl.clj.cljs$lang$applyTo = (function (seq43560){
var G__43561 = cljs.core.first(seq43560);
var seq43560__$1 = cljs.core.next(seq43560);
var G__43562 = cljs.core.first(seq43560__$1);
var seq43560__$2 = cljs.core.next(seq43560__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43561,G__43562,seq43560__$2);
}));

pinkgorilla.kernel.nrepl.receive_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$receive_msgs_BANG_(ws_chan,msg_chan){
var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43655){
var state_val_43656 = (state_43655[(1)]);
if((state_val_43656 === (7))){
var state_43655__$1 = state_43655;
var statearr_43657_43963 = state_43655__$1;
(statearr_43657_43963[(2)] = false);

(statearr_43657_43963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (1))){
var state_43655__$1 = state_43655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43655__$1,(2),ws_chan);
} else {
if((state_val_43656 === (4))){
var state_43655__$1 = state_43655;
var statearr_43658_43965 = state_43655__$1;
(statearr_43658_43965[(2)] = false);

(statearr_43658_43965[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (15))){
var inst_43594 = (state_43655[(7)]);
var inst_43596 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),inst_43594);
var inst_43597 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(true,inst_43594);
var inst_43598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43599 = [new cljs.core.Keyword(null,"set-clj-secrets","set-clj-secrets",-1555981976)];
var inst_43600 = (new cljs.core.PersistentVector(null,1,(5),inst_43598,inst_43599,null));
var inst_43601 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_43600) : re_frame.core.dispatch.call(null,inst_43600));
var state_43655__$1 = (function (){var statearr_43659 = state_43655;
(statearr_43659[(8)] = inst_43596);

(statearr_43659[(9)] = inst_43597);

return statearr_43659;
})();
var statearr_43660_43967 = state_43655__$1;
(statearr_43660_43967[(2)] = inst_43601);

(statearr_43660_43967[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (13))){
var inst_43588 = (state_43655[(10)]);
var inst_43589 = (state_43655[(11)]);
var inst_43651 = (inst_43589.cljs$core$IFn$_invoke$arity$1 ? inst_43589.cljs$core$IFn$_invoke$arity$1(inst_43588) : inst_43589.call(null,inst_43588));
var state_43655__$1 = state_43655;
var statearr_43661_43968 = state_43655__$1;
(statearr_43661_43968[(2)] = inst_43651);

(statearr_43661_43968[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (6))){
var state_43655__$1 = state_43655;
var statearr_43662_43969 = state_43655__$1;
(statearr_43662_43969[(2)] = true);

(statearr_43662_43969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (17))){
var inst_43588 = (state_43655[(10)]);
var inst_43586 = (state_43655[(12)]);
var inst_43589 = (state_43655[(11)]);
var inst_43587 = (state_43655[(13)]);
var inst_43607 = (state_43655[(2)]);
var inst_43647 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_43648 = (function (){var map__43563 = inst_43586;
var message = inst_43587;
var error = inst_43588;
var fail_fn = inst_43589;
var c__28446__auto____$1 = inst_43647;
return (function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43645){
var state_val_43646 = (state_43645[(1)]);
if((state_val_43646 === (7))){
var inst_43627 = (state_43645[(2)]);
var state_43645__$1 = state_43645;
if(cljs.core.truth_(inst_43627)){
var statearr_43663_43970 = state_43645__$1;
(statearr_43663_43970[(1)] = (11));

} else {
var statearr_43664_43971 = state_43645__$1;
(statearr_43664_43971[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (1))){
var state_43645__$1 = state_43645;
var statearr_43665_43972 = state_43645__$1;
(statearr_43665_43972[(2)] = null);

(statearr_43665_43972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (4))){
var inst_43611 = (state_43645[(7)]);
var inst_43611__$1 = (state_43645[(2)]);
var inst_43613 = (inst_43611__$1 == null);
var inst_43614 = cljs.core.not(inst_43613);
var state_43645__$1 = (function (){var statearr_43666 = state_43645;
(statearr_43666[(7)] = inst_43611__$1);

return statearr_43666;
})();
if(inst_43614){
var statearr_43667_43973 = state_43645__$1;
(statearr_43667_43973[(1)] = (5));

} else {
var statearr_43668_43974 = state_43645__$1;
(statearr_43668_43974[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (15))){
var inst_43634 = (state_43645[(8)]);
var inst_43639 = (fail_fn.cljs$core$IFn$_invoke$arity$1 ? fail_fn.cljs$core$IFn$_invoke$arity$1(inst_43634) : fail_fn.call(null,inst_43634));
var state_43645__$1 = state_43645;
var statearr_43669_43975 = state_43645__$1;
(statearr_43669_43975[(2)] = inst_43639);

(statearr_43669_43975[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (13))){
var inst_43633 = (state_43645[(9)]);
var inst_43632 = (state_43645[(2)]);
var inst_43633__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43632,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_43634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43632,new cljs.core.Keyword(null,"error","error",-978969032));
var state_43645__$1 = (function (){var statearr_43670 = state_43645;
(statearr_43670[(8)] = inst_43634);

(statearr_43670[(9)] = inst_43633__$1);

return statearr_43670;
})();
if(cljs.core.truth_(inst_43633__$1)){
var statearr_43671_43976 = state_43645__$1;
(statearr_43671_43976[(1)] = (14));

} else {
var statearr_43672_43977 = state_43645__$1;
(statearr_43672_43977[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (6))){
var state_43645__$1 = state_43645;
var statearr_43673_43978 = state_43645__$1;
(statearr_43673_43978[(2)] = false);

(statearr_43673_43978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (3))){
var inst_43643 = (state_43645[(2)]);
var state_43645__$1 = state_43645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43645__$1,inst_43643);
} else {
if((state_val_43646 === (12))){
var inst_43611 = (state_43645[(7)]);
var state_43645__$1 = state_43645;
var statearr_43674_43979 = state_43645__$1;
(statearr_43674_43979[(2)] = inst_43611);

(statearr_43674_43979[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (2))){
var state_43645__$1 = state_43645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43645__$1,(4),ws_chan);
} else {
if((state_val_43646 === (11))){
var inst_43611 = (state_43645[(7)]);
var inst_43629 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_43611);
var state_43645__$1 = state_43645;
var statearr_43675_43980 = state_43645__$1;
(statearr_43675_43980[(2)] = inst_43629);

(statearr_43675_43980[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (9))){
var state_43645__$1 = state_43645;
var statearr_43676_43981 = state_43645__$1;
(statearr_43676_43981[(2)] = false);

(statearr_43676_43981[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (5))){
var inst_43611 = (state_43645[(7)]);
var inst_43616 = inst_43611.cljs$lang$protocol_mask$partition0$;
var inst_43617 = (inst_43616 & (64));
var inst_43618 = inst_43611.cljs$core$ISeq$;
var inst_43619 = (cljs.core.PROTOCOL_SENTINEL === inst_43618);
var inst_43620 = ((inst_43617) || (inst_43619));
var state_43645__$1 = state_43645;
if(cljs.core.truth_(inst_43620)){
var statearr_43677_43982 = state_43645__$1;
(statearr_43677_43982[(1)] = (8));

} else {
var statearr_43678_43983 = state_43645__$1;
(statearr_43678_43983[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (14))){
var inst_43633 = (state_43645[(9)]);
var inst_43636 = pinkgorilla.kernel.nrepl.process_msg(inst_43633);
var state_43645__$1 = (function (){var statearr_43679 = state_43645;
(statearr_43679[(10)] = inst_43636);

return statearr_43679;
})();
var statearr_43680_43984 = state_43645__$1;
(statearr_43680_43984[(2)] = null);

(statearr_43680_43984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (16))){
var inst_43641 = (state_43645[(2)]);
var state_43645__$1 = state_43645;
var statearr_43681_43985 = state_43645__$1;
(statearr_43681_43985[(2)] = inst_43641);

(statearr_43681_43985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (10))){
var inst_43624 = (state_43645[(2)]);
var state_43645__$1 = state_43645;
var statearr_43682_43986 = state_43645__$1;
(statearr_43682_43986[(2)] = inst_43624);

(statearr_43682_43986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43646 === (8))){
var state_43645__$1 = state_43645;
var statearr_43683_43987 = state_43645__$1;
(statearr_43683_43987[(2)] = true);

(statearr_43683_43987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____0 = (function (){
var statearr_43684 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43684[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__);

(statearr_43684[(1)] = (1));

return statearr_43684;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____1 = (function (state_43645){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43645);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43685){var ex__28414__auto__ = e43685;
var statearr_43686_43988 = state_43645;
(statearr_43686_43988[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43645[(4)]))){
var statearr_43687_43989 = state_43645;
(statearr_43687_43989[(1)] = cljs.core.first((state_43645[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43990 = state_43645;
state_43645 = G__43990;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__ = function(state_43645){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____1.call(this,state_43645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43688 = f__28447__auto__();
(statearr_43688[(6)] = c__28446__auto____$1);

return statearr_43688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
});
})();
var inst_43649 = cljs.core.async.impl.dispatch.run(inst_43648);
var state_43655__$1 = (function (){var statearr_43689 = state_43655;
(statearr_43689[(14)] = inst_43649);

(statearr_43689[(15)] = inst_43607);

return statearr_43689;
})();
var statearr_43690_43991 = state_43655__$1;
(statearr_43690_43991[(2)] = inst_43647);

(statearr_43690_43991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (3))){
var inst_43565 = (state_43655[(16)]);
var inst_43570 = inst_43565.cljs$lang$protocol_mask$partition0$;
var inst_43571 = (inst_43570 & (64));
var inst_43572 = inst_43565.cljs$core$ISeq$;
var inst_43573 = (cljs.core.PROTOCOL_SENTINEL === inst_43572);
var inst_43574 = ((inst_43571) || (inst_43573));
var state_43655__$1 = state_43655;
if(cljs.core.truth_(inst_43574)){
var statearr_43691_43992 = state_43655__$1;
(statearr_43691_43992[(1)] = (6));

} else {
var statearr_43692_43993 = state_43655__$1;
(statearr_43692_43993[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (12))){
var inst_43588 = (state_43655[(10)]);
var inst_43594 = (state_43655[(7)]);
var inst_43586 = (state_43655[(12)]);
var inst_43589 = (state_43655[(11)]);
var inst_43587 = (state_43655[(13)]);
var inst_43591 = (function (){var map__43563 = inst_43586;
var message = inst_43587;
var error = inst_43588;
var fail_fn = inst_43589;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got initial message ",message], null);
});
})();
var inst_43592 = (new cljs.core.Delay(inst_43591,null));
var inst_43593 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",249,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_43592,null,-1230282410);
var inst_43594__$1 = new cljs.core.Keyword(null,"new-session","new-session",-1358977165).cljs$core$IFn$_invoke$arity$1(inst_43587);
var state_43655__$1 = (function (){var statearr_43693 = state_43655;
(statearr_43693[(7)] = inst_43594__$1);

(statearr_43693[(17)] = inst_43593);

return statearr_43693;
})();
if(cljs.core.truth_(inst_43594__$1)){
var statearr_43694_43994 = state_43655__$1;
(statearr_43694_43994[(1)] = (15));

} else {
var statearr_43695_43995 = state_43655__$1;
(statearr_43695_43995[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (2))){
var inst_43565 = (state_43655[(16)]);
var inst_43565__$1 = (state_43655[(2)]);
var inst_43567 = (inst_43565__$1 == null);
var inst_43568 = cljs.core.not(inst_43567);
var state_43655__$1 = (function (){var statearr_43696 = state_43655;
(statearr_43696[(16)] = inst_43565__$1);

return statearr_43696;
})();
if(inst_43568){
var statearr_43697_43996 = state_43655__$1;
(statearr_43697_43996[(1)] = (3));

} else {
var statearr_43698_43997 = state_43655__$1;
(statearr_43698_43997[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (11))){
var inst_43588 = (state_43655[(10)]);
var inst_43586 = (state_43655[(12)]);
var inst_43587 = (state_43655[(13)]);
var inst_43586__$1 = (state_43655[(2)]);
var inst_43587__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43586__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_43588__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43586__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_43589 = (function (){var map__43563 = inst_43586__$1;
var message = inst_43587__$1;
var error = inst_43588__$1;
return (function (error__$1){
cljs.core.async.close_BANG_(ws_chan);

cljs.core.async.close_BANG_(msg_chan);

pinkgorilla.notifications.add_notification(pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),["clj-kernel Fatal Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(error__$1)].join('')));

return pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
});
})();
var state_43655__$1 = (function (){var statearr_43699 = state_43655;
(statearr_43699[(10)] = inst_43588__$1);

(statearr_43699[(12)] = inst_43586__$1);

(statearr_43699[(11)] = inst_43589);

(statearr_43699[(13)] = inst_43587__$1);

return statearr_43699;
})();
if(cljs.core.truth_(inst_43587__$1)){
var statearr_43700_43998 = state_43655__$1;
(statearr_43700_43998[(1)] = (12));

} else {
var statearr_43701_43999 = state_43655__$1;
(statearr_43701_43999[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (9))){
var inst_43565 = (state_43655[(16)]);
var inst_43583 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_43565);
var state_43655__$1 = state_43655;
var statearr_43702_44000 = state_43655__$1;
(statearr_43702_44000[(2)] = inst_43583);

(statearr_43702_44000[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (5))){
var inst_43581 = (state_43655[(2)]);
var state_43655__$1 = state_43655;
if(cljs.core.truth_(inst_43581)){
var statearr_43703_44001 = state_43655__$1;
(statearr_43703_44001[(1)] = (9));

} else {
var statearr_43704_44002 = state_43655__$1;
(statearr_43704_44002[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (14))){
var inst_43653 = (state_43655[(2)]);
var state_43655__$1 = state_43655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43655__$1,inst_43653);
} else {
if((state_val_43656 === (16))){
var inst_43588 = (state_43655[(10)]);
var inst_43594 = (state_43655[(7)]);
var inst_43586 = (state_43655[(12)]);
var inst_43589 = (state_43655[(11)]);
var inst_43587 = (state_43655[(13)]);
var inst_43603 = (function (){var map__43563 = inst_43586;
var message = inst_43587;
var error = inst_43588;
var fail_fn = inst_43589;
var temp__5733__auto__ = inst_43594;
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["could not extract session id!!! "], null);
});
})();
var inst_43604 = (new cljs.core.Delay(inst_43603,null));
var inst_43605 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"pinkgorilla.kernel.nrepl","/tmp/form-init2806228143329832606.clj",255,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_43604,null,1958358527);
var state_43655__$1 = state_43655;
var statearr_43705_44003 = state_43655__$1;
(statearr_43705_44003[(2)] = inst_43605);

(statearr_43705_44003[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (10))){
var inst_43565 = (state_43655[(16)]);
var state_43655__$1 = state_43655;
var statearr_43706_44004 = state_43655__$1;
(statearr_43706_44004[(2)] = inst_43565);

(statearr_43706_44004[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43656 === (8))){
var inst_43578 = (state_43655[(2)]);
var state_43655__$1 = state_43655;
var statearr_43707_44005 = state_43655__$1;
(statearr_43707_44005[(2)] = inst_43578);

(statearr_43707_44005[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____0 = (function (){
var statearr_43708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43708[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__);

(statearr_43708[(1)] = (1));

return statearr_43708;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____1 = (function (state_43655){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43655);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43709){var ex__28414__auto__ = e43709;
var statearr_43710_44006 = state_43655;
(statearr_43710_44006[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43655[(4)]))){
var statearr_43711_44007 = state_43655;
(statearr_43711_44007[(1)] = cljs.core.first((state_43655[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44008 = state_43655;
state_43655 = G__44008;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__ = function(state_43655){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____1.call(this,state_43655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43712 = f__28447__auto__();
(statearr_43712[(6)] = c__28446__auto__);

return statearr_43712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});
pinkgorilla.kernel.nrepl.start_repl_BANG_ = (function pinkgorilla$kernel$nrepl$start_repl_BANG_(ws_url){
var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43836){
var state_val_43837 = (state_43836[(1)]);
if((state_val_43837 === (7))){
var state_43836__$1 = state_43836;
var statearr_43838_44009 = state_43836__$1;
(statearr_43838_44009[(2)] = false);

(statearr_43838_44009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (20))){
var inst_43745 = (state_43836[(7)]);
var inst_43766 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_43745);
var state_43836__$1 = state_43836;
var statearr_43839_44010 = state_43836__$1;
(statearr_43839_44010[(2)] = inst_43766);

(statearr_43839_44010[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (27))){
var state_43836__$1 = state_43836;
var statearr_43840_44011 = state_43836__$1;
(statearr_43840_44011[(2)] = null);

(statearr_43840_44011[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (1))){
var inst_43716 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_43717 = [new cljs.core.Keyword(null,"edn","edn",1317840885)];
var inst_43718 = cljs.core.PersistentHashMap.fromArrays(inst_43716,inst_43717);
var inst_43719 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43718], 0));
var state_43836__$1 = state_43836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(2),inst_43719);
} else {
if((state_val_43837 === (24))){
var inst_43816 = (state_43836[(8)]);
var inst_43771 = (state_43836[(9)]);
var inst_43815 = cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl);
var inst_43816__$1 = new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(inst_43815);
var inst_43817 = ["clj-kernel error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43771)," - trying to recover with session ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43816__$1)].join('');
var inst_43818 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_43817);
var inst_43819 = pinkgorilla.notifications.add_notification(inst_43818);
var inst_43820 = cljs.core.async.timeout((3000));
var state_43836__$1 = (function (){var statearr_43841 = state_43836;
(statearr_43841[(8)] = inst_43816__$1);

(statearr_43841[(10)] = inst_43819);

return statearr_43841;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(38),inst_43820);
} else {
if((state_val_43837 === (39))){
var inst_43816 = (state_43836[(8)]);
var inst_43828 = (state_43836[(2)]);
var inst_43829 = (inst_43816 == null);
var inst_43745 = inst_43828;
var inst_43746 = inst_43829;
var state_43836__$1 = (function (){var statearr_43842 = state_43836;
(statearr_43842[(11)] = inst_43746);

(statearr_43842[(7)] = inst_43745);

return statearr_43842;
})();
var statearr_43843_44012 = state_43836__$1;
(statearr_43843_44012[(2)] = null);

(statearr_43843_44012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (4))){
var state_43836__$1 = state_43836;
var statearr_43844_44013 = state_43836__$1;
(statearr_43844_44013[(2)] = false);

(statearr_43844_44013[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (15))){
var state_43836__$1 = state_43836;
var statearr_43845_44014 = state_43836__$1;
(statearr_43845_44014[(2)] = false);

(statearr_43845_44014[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (21))){
var inst_43745 = (state_43836[(7)]);
var state_43836__$1 = state_43836;
var statearr_43846_44015 = state_43836__$1;
(statearr_43846_44015[(2)] = inst_43745);

(statearr_43846_44015[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (31))){
var inst_43794 = (state_43836[(12)]);
var inst_43794__$1 = (state_43836[(2)]);
var state_43836__$1 = (function (){var statearr_43847 = state_43836;
(statearr_43847[(12)] = inst_43794__$1);

return statearr_43847;
})();
if(cljs.core.truth_(inst_43794__$1)){
var statearr_43848_44016 = state_43836__$1;
(statearr_43848_44016[(1)] = (32));

} else {
var statearr_43849_44017 = state_43836__$1;
(statearr_43849_44017[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (32))){
var inst_43794 = (state_43836[(12)]);
var inst_43770 = (state_43836[(13)]);
var state_43836__$1 = state_43836;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43836__$1,(35),inst_43770,inst_43794);
} else {
if((state_val_43837 === (33))){
var state_43836__$1 = state_43836;
var statearr_43850_44018 = state_43836__$1;
(statearr_43850_44018[(2)] = null);

(statearr_43850_44018[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (13))){
var inst_43834 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43836__$1,inst_43834);
} else {
if((state_val_43837 === (22))){
var inst_43769 = (state_43836[(14)]);
var inst_43771 = (state_43836[(9)]);
var inst_43769__$1 = (state_43836[(2)]);
var inst_43770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43769__$1,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_43771__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43769__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_43772 = cljs.core.not(inst_43771__$1);
var state_43836__$1 = (function (){var statearr_43851 = state_43836;
(statearr_43851[(13)] = inst_43770);

(statearr_43851[(14)] = inst_43769__$1);

(statearr_43851[(9)] = inst_43771__$1);

return statearr_43851;
})();
if(inst_43772){
var statearr_43852_44019 = state_43836__$1;
(statearr_43852_44019[(1)] = (23));

} else {
var statearr_43853_44020 = state_43836__$1;
(statearr_43853_44020[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (36))){
var inst_43806 = (state_43836[(2)]);
var inst_43807 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_43808 = [new cljs.core.Keyword(null,"edn","edn",1317840885)];
var inst_43809 = cljs.core.PersistentHashMap.fromArrays(inst_43807,inst_43808);
var inst_43810 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43809], 0));
var state_43836__$1 = (function (){var statearr_43854 = state_43836;
(statearr_43854[(15)] = inst_43806);

return statearr_43854;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(37),inst_43810);
} else {
if((state_val_43837 === (29))){
var inst_43774 = (state_43836[(16)]);
var state_43836__$1 = state_43836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(31),inst_43774);
} else {
if((state_val_43837 === (6))){
var state_43836__$1 = state_43836;
var statearr_43855_44021 = state_43836__$1;
(statearr_43855_44021[(2)] = true);

(statearr_43855_44021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (28))){
var inst_43774 = (state_43836[(16)]);
var inst_43770 = (state_43836[(13)]);
var inst_43790 = (state_43836[(2)]);
var inst_43791 = pinkgorilla.kernel.nrepl.receive_msgs_BANG_(inst_43770,inst_43774);
var state_43836__$1 = (function (){var statearr_43856 = state_43836;
(statearr_43856[(17)] = inst_43790);

(statearr_43856[(18)] = inst_43791);

return statearr_43856;
})();
var statearr_43857_44022 = state_43836__$1;
(statearr_43857_44022[(2)] = null);

(statearr_43857_44022[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (25))){
var inst_43832 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
var statearr_43858_44023 = state_43836__$1;
(statearr_43858_44023[(2)] = inst_43832);

(statearr_43858_44023[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (34))){
var inst_43801 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
var statearr_43859_44024 = state_43836__$1;
(statearr_43859_44024[(2)] = inst_43801);

(statearr_43859_44024[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (17))){
var state_43836__$1 = state_43836;
var statearr_43860_44025 = state_43836__$1;
(statearr_43860_44025[(2)] = true);

(statearr_43860_44025[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (3))){
var inst_43721 = (state_43836[(19)]);
var inst_43726 = inst_43721.cljs$lang$protocol_mask$partition0$;
var inst_43727 = (inst_43726 & (64));
var inst_43728 = inst_43721.cljs$core$ISeq$;
var inst_43729 = (cljs.core.PROTOCOL_SENTINEL === inst_43728);
var inst_43730 = ((inst_43727) || (inst_43729));
var state_43836__$1 = state_43836;
if(cljs.core.truth_(inst_43730)){
var statearr_43861_44026 = state_43836__$1;
(statearr_43861_44026[(1)] = (6));

} else {
var statearr_43862_44027 = state_43836__$1;
(statearr_43862_44027[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (12))){
var inst_43745 = (state_43836[(7)]);
var inst_43750 = (inst_43745 == null);
var inst_43751 = cljs.core.not(inst_43750);
var state_43836__$1 = state_43836;
if(inst_43751){
var statearr_43863_44028 = state_43836__$1;
(statearr_43863_44028[(1)] = (14));

} else {
var statearr_43864_44029 = state_43836__$1;
(statearr_43864_44029[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (2))){
var inst_43721 = (state_43836[(19)]);
var inst_43721__$1 = (state_43836[(2)]);
var inst_43723 = (inst_43721__$1 == null);
var inst_43724 = cljs.core.not(inst_43723);
var state_43836__$1 = (function (){var statearr_43865 = state_43836;
(statearr_43865[(19)] = inst_43721__$1);

return statearr_43865;
})();
if(inst_43724){
var statearr_43866_44030 = state_43836__$1;
(statearr_43866_44030[(1)] = (3));

} else {
var statearr_43867_44031 = state_43836__$1;
(statearr_43867_44031[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (23))){
var inst_43774 = (state_43836[(16)]);
var inst_43746 = (state_43836[(11)]);
var inst_43774__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_43775 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"channel","channel",734187692),inst_43774__$1);
var state_43836__$1 = (function (){var statearr_43868 = state_43836;
(statearr_43868[(16)] = inst_43774__$1);

(statearr_43868[(20)] = inst_43775);

return statearr_43868;
})();
if(cljs.core.truth_(inst_43746)){
var statearr_43869_44032 = state_43836__$1;
(statearr_43869_44032[(1)] = (26));

} else {
var statearr_43870_44033 = state_43836__$1;
(statearr_43870_44033[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (35))){
var inst_43797 = (state_43836[(2)]);
var state_43836__$1 = (function (){var statearr_43871 = state_43836;
(statearr_43871[(21)] = inst_43797);

return statearr_43871;
})();
var statearr_43872_44034 = state_43836__$1;
(statearr_43872_44034[(2)] = null);

(statearr_43872_44034[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (19))){
var inst_43761 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
var statearr_43873_44035 = state_43836__$1;
(statearr_43873_44035[(2)] = inst_43761);

(statearr_43873_44035[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (11))){
var inst_43742 = (state_43836[(22)]);
var inst_43721 = (state_43836[(19)]);
var inst_43742__$1 = (state_43836[(2)]);
var inst_43743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43742__$1,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_43744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43742__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_43745 = inst_43721;
var inst_43746 = true;
var state_43836__$1 = (function (){var statearr_43874 = state_43836;
(statearr_43874[(22)] = inst_43742__$1);

(statearr_43874[(23)] = inst_43743);

(statearr_43874[(24)] = inst_43744);

(statearr_43874[(11)] = inst_43746);

(statearr_43874[(7)] = inst_43745);

return statearr_43874;
})();
var statearr_43875_44036 = state_43836__$1;
(statearr_43875_44036[(2)] = null);

(statearr_43875_44036[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (9))){
var inst_43721 = (state_43836[(19)]);
var inst_43739 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_43721);
var state_43836__$1 = state_43836;
var statearr_43876_44037 = state_43836__$1;
(statearr_43876_44037[(2)] = inst_43739);

(statearr_43876_44037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (5))){
var inst_43737 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
if(cljs.core.truth_(inst_43737)){
var statearr_43877_44038 = state_43836__$1;
(statearr_43877_44038[(1)] = (9));

} else {
var statearr_43878_44039 = state_43836__$1;
(statearr_43878_44039[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (14))){
var inst_43745 = (state_43836[(7)]);
var inst_43753 = inst_43745.cljs$lang$protocol_mask$partition0$;
var inst_43754 = (inst_43753 & (64));
var inst_43755 = inst_43745.cljs$core$ISeq$;
var inst_43756 = (cljs.core.PROTOCOL_SENTINEL === inst_43755);
var inst_43757 = ((inst_43754) || (inst_43756));
var state_43836__$1 = state_43836;
if(cljs.core.truth_(inst_43757)){
var statearr_43879_44040 = state_43836__$1;
(statearr_43879_44040[(1)] = (17));

} else {
var statearr_43880_44041 = state_43836__$1;
(statearr_43880_44041[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (26))){
var inst_43742 = (state_43836[(22)]);
var inst_43774 = (state_43836[(16)]);
var inst_43770 = (state_43836[(13)]);
var inst_43746 = (state_43836[(11)]);
var inst_43769 = (state_43836[(14)]);
var inst_43771 = (state_43836[(9)]);
var inst_43745 = (state_43836[(7)]);
var inst_43785 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_43786 = (function (){var G__43714 = inst_43745;
var map__43715 = inst_43742;
var ws_channel = inst_43770;
var error = inst_43771;
var new_session = inst_43746;
var map__43748 = inst_43769;
var msg_ch = inst_43774;
var c__28446__auto____$1 = inst_43785;
return (function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43783){
var state_val_43784 = (state_43783[(1)]);
if((state_val_43784 === (1))){
var inst_43777 = [new cljs.core.Keyword(null,"op","op",-1882987955)];
var inst_43778 = ["clone"];
var inst_43779 = cljs.core.PersistentHashMap.fromArrays(inst_43777,inst_43778);
var state_43783__$1 = state_43783;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43783__$1,(2),msg_ch,inst_43779);
} else {
if((state_val_43784 === (2))){
var inst_43781 = (state_43783[(2)]);
var state_43783__$1 = state_43783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43783__$1,inst_43781);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____0 = (function (){
var statearr_43881 = [null,null,null,null,null,null,null];
(statearr_43881[(0)] = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__);

(statearr_43881[(1)] = (1));

return statearr_43881;
});
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____1 = (function (state_43783){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43783);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43882){var ex__28414__auto__ = e43882;
var statearr_43883_44042 = state_43783;
(statearr_43883_44042[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43783[(4)]))){
var statearr_43884_44043 = state_43783;
(statearr_43884_44043[(1)] = cljs.core.first((state_43783[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44044 = state_43783;
state_43783 = G__44044;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__ = function(state_43783){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____1.call(this,state_43783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____0;
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____1;
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43885 = f__28447__auto__();
(statearr_43885[(6)] = c__28446__auto____$1);

return statearr_43885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
});
})();
var inst_43787 = cljs.core.async.impl.dispatch.run(inst_43786);
var state_43836__$1 = (function (){var statearr_43886 = state_43836;
(statearr_43886[(25)] = inst_43787);

return statearr_43886;
})();
var statearr_43887_44045 = state_43836__$1;
(statearr_43887_44045[(2)] = inst_43785);

(statearr_43887_44045[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (16))){
var inst_43764 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
if(cljs.core.truth_(inst_43764)){
var statearr_43888_44046 = state_43836__$1;
(statearr_43888_44046[(1)] = (20));

} else {
var statearr_43889_44047 = state_43836__$1;
(statearr_43889_44047[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (38))){
var inst_43822 = (state_43836[(2)]);
var inst_43823 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_43824 = [new cljs.core.Keyword(null,"edn","edn",1317840885)];
var inst_43825 = cljs.core.PersistentHashMap.fromArrays(inst_43823,inst_43824);
var inst_43826 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43825], 0));
var state_43836__$1 = (function (){var statearr_43890 = state_43836;
(statearr_43890[(26)] = inst_43822);

return statearr_43890;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(39),inst_43826);
} else {
if((state_val_43837 === (30))){
var inst_43803 = (state_43836[(2)]);
var inst_43804 = cljs.core.async.timeout((3000));
var state_43836__$1 = (function (){var statearr_43891 = state_43836;
(statearr_43891[(27)] = inst_43803);

return statearr_43891;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(36),inst_43804);
} else {
if((state_val_43837 === (10))){
var inst_43721 = (state_43836[(19)]);
var state_43836__$1 = state_43836;
var statearr_43892_44048 = state_43836__$1;
(statearr_43892_44048[(2)] = inst_43721);

(statearr_43892_44048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (18))){
var state_43836__$1 = state_43836;
var statearr_43893_44049 = state_43836__$1;
(statearr_43893_44049[(2)] = false);

(statearr_43893_44049[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (37))){
var inst_43812 = (state_43836[(2)]);
var inst_43745 = inst_43812;
var inst_43746 = false;
var state_43836__$1 = (function (){var statearr_43894 = state_43836;
(statearr_43894[(11)] = inst_43746);

(statearr_43894[(7)] = inst_43745);

return statearr_43894;
})();
var statearr_43895_44050 = state_43836__$1;
(statearr_43895_44050[(2)] = null);

(statearr_43895_44050[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (8))){
var inst_43734 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
var statearr_43896_44051 = state_43836__$1;
(statearr_43896_44051[(2)] = inst_43734);

(statearr_43896_44051[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____0 = (function (){
var statearr_43897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43897[(0)] = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__);

(statearr_43897[(1)] = (1));

return statearr_43897;
});
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____1 = (function (state_43836){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43836);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43898){var ex__28414__auto__ = e43898;
var statearr_43899_44052 = state_43836;
(statearr_43899_44052[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43836[(4)]))){
var statearr_43900_44053 = state_43836;
(statearr_43900_44053[(1)] = cljs.core.first((state_43836[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44054 = state_43836;
state_43836 = G__44054;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__ = function(state_43836){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____1.call(this,state_43836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____0;
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto____1;
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43901 = f__28447__auto__();
(statearr_43901[(6)] = c__28446__auto__);

return statearr_43901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});

//# sourceMappingURL=pinkgorilla.kernel.nrepl.js.map
