goog.provide('pinkgorilla.explore.notebook');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('pinkgorilla.storage.storage');
goog.require('pinkgorilla.routes');
goog.require('pinkgorilla.explore.tags');
pinkgorilla.explore.notebook.project_name_old = (function pinkgorilla$explore$notebook$project_name_old(notebook){
var name = (function (){var or__4120__auto__ = new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(notebook);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "?";
}
})();
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),clojure.string.replace(name,/^(.+?)\/+$/,"$1")], null);
});
/**
 * extracts the only the name of the file, without extension and path
 */
pinkgorilla.explore.notebook.project_path_name = (function pinkgorilla$explore$notebook$project_path_name(l){
var full_file_name = new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(l);
var name = cljs.core.re_find(/(.+?)([\w-]*).(cljg|ipynb)*$/,(function (){var or__4120__auto__ = full_file_name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})());
return name;
});
pinkgorilla.explore.notebook.notebook_name = (function pinkgorilla$explore$notebook$notebook_name(l){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pinkgorilla.explore.notebook.project_path_name(l),(2));
});
pinkgorilla.explore.notebook.subs2 = (function pinkgorilla$explore$notebook$subs2(s,start){
return s.substring(start,cljs.core.count(s));
});
pinkgorilla.explore.notebook.project_path = (function pinkgorilla$explore$notebook$project_path(l){
var p = cljs.core.second(pinkgorilla.explore.notebook.project_path_name(l));
var root_len = cljs.core.count(new cljs.core.Keyword(null,"root-dir","root-dir",-1206960301).cljs$core$IFn$_invoke$arity$1(l));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(l),new cljs.core.Keyword(null,"file","file",-1269645878))){
if((p == null)){
return null;
} else {
if((root_len == null)){
return p;
} else {
return pinkgorilla.explore.notebook.subs2(p,root_len);
}
}
} else {
return p;
}
});
pinkgorilla.explore.notebook.notebook_link_gorilla = (function pinkgorilla$explore$notebook$notebook_link_gorilla(notebook){
var storage = new cljs.core.Keyword(null,"storage","storage",1867247511).cljs$core$IFn$_invoke$arity$1(notebook);
if((storage == null)){
return "";
} else {
return pinkgorilla.storage.storage.gorilla_path(storage);
}
});
pinkgorilla.explore.notebook.storage_link = (function pinkgorilla$explore$notebook$storage_link(notebook){
var storage = new cljs.core.Keyword(null,"storage","storage",1867247511).cljs$core$IFn$_invoke$arity$1(notebook);
if((storage == null)){
return "";
} else {
return pinkgorilla.storage.storage.external_url(storage);
}
});
pinkgorilla.explore.notebook.tagline = (function pinkgorilla$explore$notebook$tagline(notebook){
var tl = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(notebook,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tagline","tagline",281987682)], null));
var or__4120__auto__ = tl;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "No Tagline provided";
}
});
pinkgorilla.explore.notebook.border = " border-r border-b border-l border-gray-400";
pinkgorilla.explore.notebook.lg = " lg:border-l-0 lg:border-t lg:border-gray-400 lg:rounded-b-none lg:rounded-r";
pinkgorilla.explore.notebook.notebook_box = (function pinkgorilla$explore$notebook$notebook_box(selected_tags,notebook){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),["h-48 bg-green-400 w-1/2 rounded-b  p-4 flex flex-col justify-between leading-normal hover:bg-orange-400",pinkgorilla.explore.notebook.border,pinkgorilla.explore.notebook.lg].join('')], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.mb-8","div.mb-8",255255619),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"href","href",-793805698),pinkgorilla.explore.notebook.storage_link(notebook),new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"rel","rel",1378823488),"noopener noreferrer"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.px-0.py-0.bg-White","div.px-0.py-0.bg-White",479268344),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pg-storage-prop mr-1"], null),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(notebook)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pg-storage-prop mr-1"], null),new cljs.core.Keyword(null,"repo","repo",-1999060679).cljs$core$IFn$_invoke$arity$1(notebook)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pg-storage-prop"], null),pinkgorilla.explore.notebook.project_path(notebook)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return pinkgorilla.routes.nav_BANG_(pinkgorilla.explore.notebook.notebook_link_gorilla(notebook));
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"text-white font-bold text-xl mb-2"], null),pinkgorilla.explore.notebook.notebook_name(notebook)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"text-white text-base h-8 overflow-hidden"], null),pinkgorilla.explore.notebook.tagline(notebook)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.flex.items-center","div.flex.items-center",-1537844053),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"w-10 h-10 bg-white rounded-full mr-4",new cljs.core.Keyword(null,"src","src",-1651076051),"./pink-gorilla-32.png",new cljs.core.Keyword(null,"alt","alt",-3214426),"Avatar"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.text-sm.mr-4","div.text-sm.mr-4",651060586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p.text-white.leading-none","p.text-white.leading-none",511795674),new cljs.core.Keyword(null,"user","user",1532431356).cljs$core$IFn$_invoke$arity$1(notebook)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p.text-gray-600","p.text-gray-600",-123426867),new cljs.core.Keyword(null,"edit-date","edit-date",1885166597).cljs$core$IFn$_invoke$arity$1(notebook)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.text-sm.mr-4","div.text-sm.mr-4",651060586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.px-6.py-4","div.px-6.py-4",-1138945559),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.tags.tag_box,pinkgorilla.explore.tags.notebook_tags__GT_list(notebook),selected_tags], null)], null)], null)], null)], null);
});

//# sourceMappingURL=pinkgorilla.explore.notebook.js.map
