goog.provide('pinkgorilla.codemirror.editor_support');
goog.require('cljs.core');
goog.require('pinkgorilla.codemirror.parinfer');
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.codemirror !== 'undefined') && (typeof pinkgorilla.codemirror.editor_support !== 'undefined') && (typeof pinkgorilla.codemirror.editor_support.state !== 'undefined')){
} else {
pinkgorilla.codemirror.editor_support.state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}

/**
 * Custom data/methods for a CodeMirror editor.
 * @interface
 */
pinkgorilla.codemirror.editor_support.IEditor = function(){};

var pinkgorilla$codemirror$editor_support$IEditor$frame_updated_QMARK_$dyn_45938 = (function (this$){
var x__4422__auto__ = (((this$ == null))?null:this$);
var m__4423__auto__ = (pinkgorilla.codemirror.editor_support.frame_updated_QMARK_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4423__auto__.call(null,this$));
} else {
var m__4420__auto__ = (pinkgorilla.codemirror.editor_support.frame_updated_QMARK_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4420__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IEditor.frame-updated?",this$);
}
}
});
pinkgorilla.codemirror.editor_support.frame_updated_QMARK_ = (function pinkgorilla$codemirror$editor_support$frame_updated_QMARK_(this$){
if((((!((this$ == null)))) && ((!((this$.pinkgorilla$codemirror$editor_support$IEditor$frame_updated_QMARK_$arity$1 == null)))))){
return this$.pinkgorilla$codemirror$editor_support$IEditor$frame_updated_QMARK_$arity$1(this$);
} else {
return pinkgorilla$codemirror$editor_support$IEditor$frame_updated_QMARK_$dyn_45938(this$);
}
});

var pinkgorilla$codemirror$editor_support$IEditor$set_frame_updated_BANG_$dyn_45939 = (function (this$,value){
var x__4422__auto__ = (((this$ == null))?null:this$);
var m__4423__auto__ = (pinkgorilla.codemirror.editor_support.set_frame_updated_BANG_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(this$,value) : m__4423__auto__.call(null,this$,value));
} else {
var m__4420__auto__ = (pinkgorilla.codemirror.editor_support.set_frame_updated_BANG_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(this$,value) : m__4420__auto__.call(null,this$,value));
} else {
throw cljs.core.missing_protocol("IEditor.set-frame-updated!",this$);
}
}
});
pinkgorilla.codemirror.editor_support.set_frame_updated_BANG_ = (function pinkgorilla$codemirror$editor_support$set_frame_updated_BANG_(this$,value){
if((((!((this$ == null)))) && ((!((this$.pinkgorilla$codemirror$editor_support$IEditor$set_frame_updated_BANG_$arity$2 == null)))))){
return this$.pinkgorilla$codemirror$editor_support$IEditor$set_frame_updated_BANG_$arity$2(this$,value);
} else {
return pinkgorilla$codemirror$editor_support$IEditor$set_frame_updated_BANG_$dyn_45939(this$,value);
}
});

pinkgorilla.codemirror.editor_support.compute_cursor_dx = (function pinkgorilla$codemirror$editor_support$compute_cursor_dx(_,change){
if(cljs.core.truth_(change)){
var ignore_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("+indenthack",change.origin);
if(ignore_QMARK_){
return (0);
} else {
var start_x = change.to.ch;
var new_lines = change.text;
var len_last_line = cljs.core.count(cljs.core.last(new_lines));
var end_x = (((cljs.core.count(new_lines) > (1)))?len_last_line:(len_last_line + change.from.ch));
return (end_x - start_x);
}
} else {
return null;
}
});
pinkgorilla.codemirror.editor_support.compute_cm_change = (function pinkgorilla$codemirror$editor_support$compute_cm_change(cm,change,_,prev_state){
var map__45926 = (cljs.core.truth_(change)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"start-line","start-line",-41746654),change.from.line,new cljs.core.Keyword(null,"end-line","end-line",1837326455),(change.to.line + (1)),new cljs.core.Keyword(null,"num-new-lines","num-new-lines",-1319642646),change.text.length], null):(function (){var start = new cljs.core.Keyword(null,"cursor-line","cursor-line",-1089611007).cljs$core$IFn$_invoke$arity$1(prev_state);
var end = (start + (1));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"start-line","start-line",-41746654),start,new cljs.core.Keyword(null,"end-line","end-line",1837326455),end,new cljs.core.Keyword(null,"num-new-lines","num-new-lines",-1319642646),(end - start)], null);
})());
var map__45926__$1 = (((((!((map__45926 == null))))?(((((map__45926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45926.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45926):map__45926);
var start_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45926__$1,new cljs.core.Keyword(null,"start-line","start-line",-41746654));
var end_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45926__$1,new cljs.core.Keyword(null,"end-line","end-line",1837326455));
var num_new_lines = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45926__$1,new cljs.core.Keyword(null,"num-new-lines","num-new-lines",-1319642646));
var lines = (function (){var iter__4523__auto__ = (function pinkgorilla$codemirror$editor_support$compute_cm_change_$_iter__45928(s__45929){
return (new cljs.core.LazySeq(null,(function (){
var s__45929__$1 = s__45929;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45929__$1);
if(temp__5735__auto__){
var s__45929__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45929__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__45929__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__45931 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__45930 = (0);
while(true){
if((i__45930 < size__4522__auto__)){
var i = cljs.core._nth(c__4521__auto__,i__45930);
cljs.core.chunk_append(b__45931,cm.getLine(i));

var G__45940 = (i__45930 + (1));
i__45930 = G__45940;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45931),pinkgorilla$codemirror$editor_support$compute_cm_change_$_iter__45928(cljs.core.chunk_rest(s__45929__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45931),null);
}
} else {
var i = cljs.core.first(s__45929__$2);
return cljs.core.cons(cm.getLine(i),pinkgorilla$codemirror$editor_support$compute_cm_change_$_iter__45928(cljs.core.rest(s__45929__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start_line,(start_line + num_new_lines)));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line-no","line-no",-666819466),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_line,end_line], null),new cljs.core.Keyword(null,"new-line","new-line",1060819447),lines], null);
});
/**
 * Correctly format the text from the given editor.
 * @param {CodeMirror} cm
 */
pinkgorilla.codemirror.editor_support.fix_text_BANG_ = (function pinkgorilla$codemirror$editor_support$fix_text_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___45942 = arguments.length;
var i__4731__auto___45943 = (0);
while(true){
if((i__4731__auto___45943 < len__4730__auto___45942)){
args__4736__auto__.push((arguments[i__4731__auto___45943]));

var G__45944 = (i__4731__auto___45943 + (1));
i__4731__auto___45943 = G__45944;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return pinkgorilla.codemirror.editor_support.fix_text_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(pinkgorilla.codemirror.editor_support.fix_text_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (cm,p__45934){
var map__45935 = p__45934;
var map__45935__$1 = (((((!((map__45935 == null))))?(((((map__45935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45935):map__45935);
var change = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__45935__$1,new cljs.core.Keyword(null,"change","change",-1163046502),null);
var current_text = cm.getValue();
var selection_QMARK_ = cm.somethingSelected();
var selections = cm.listSelections();
var cursor = cm.getCursor();
var scroller = cm.getScrollerElement();
var scroll_x = scroller.scrollLeft;
var scroll_y = scroller.scrollTop;
var options = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"cursor-line","cursor-line",-1089611007),cursor.line,new cljs.core.Keyword(null,"cursor-x","cursor-x",475204266),cursor.ch,new cljs.core.Keyword(null,"cursor-dx","cursor-dx",133069327),pinkgorilla.codemirror.editor_support.compute_cursor_dx(cursor,change)], null);
var options__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([options,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.codemirror.editor_support.state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489)], null))], 0));
var mode = (function (){var or__4120__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.codemirror.editor_support.state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mode","mode",654403691)], null));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return new cljs.core.Keyword(null,"indent-mode","indent-mode",1737814542);
}
})();
var result = (function (){var G__45937 = mode;
var G__45937__$1 = (((G__45937 instanceof cljs.core.Keyword))?G__45937.fqn:null);
switch (G__45937__$1) {
case "indent-mode":
return pinkgorilla.codemirror.parinfer.indent_mode.cljs$core$IFn$_invoke$arity$2(current_text,options__$1);

break;
case "paren-mode":
return pinkgorilla.codemirror.parinfer.paren_mode.cljs$core$IFn$_invoke$arity$2(current_text,options__$1);

break;
default:
return null;

}
})();
var new_text = new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(result);
var new_cursor_x = new cljs.core.Keyword(null,"cursor-x","cursor-x",475204266).cljs$core$IFn$_invoke$arity$1(result);
cm.setValue(new_text);

if(cljs.core.truth_(selection_QMARK_)){
cm.setSelections(selections);
} else {
cm.setCursor((cursor["line"]),new_cursor_x);
}

return cm.scrollTo(scroll_x,scroll_y);
}));

(pinkgorilla.codemirror.editor_support.fix_text_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.codemirror.editor_support.fix_text_BANG_.cljs$lang$applyTo = (function (seq45932){
var G__45933 = cljs.core.first(seq45932);
var seq45932__$1 = cljs.core.next(seq45932);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45933,seq45932__$1);
}));


//# sourceMappingURL=pinkgorilla.codemirror.editor_support.js.map
