goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4120__auto__ = elem.textContent;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__46476 = arguments.length;
switch (G__46476) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
}));

(dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
}));

(dommy.core.style.cljs$lang$maxFixedArity = 2);

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto__ = elem.classList;
if(cljs.core.truth_(temp__5733__auto__)){
var class_list = temp__5733__auto__;
return class_list.contains(c__$1);
} else {
var temp__5735__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__5735__auto__)){
var class_name = temp__5735__auto__;
var temp__5735__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__5735__auto____$1)){
var i = temp__5735__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__46478 = arguments.length;
switch (G__46478) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
}));

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
}));

(dommy.core.matches_pred.cljs$lang$maxFixedArity = 2);

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__46487 = arguments.length;
switch (G__46487) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__46484_SHARP_){
return (!((p1__46484_SHARP_ === base)));
}),dommy.core.ancestors(elem))));
}));

(dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
}));

(dommy.core.closest.cljs$lang$maxFixedArity = 3);

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
(elem.textContent = text);
} else {
(elem.innerText = text);
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
(elem.innerHTML = html);

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
(elem.value = value);

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return (elem.className = c);
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___46872 = arguments.length;
var i__4731__auto___46873 = (0);
while(true){
if((i__4731__auto___46873 < len__4730__auto___46872)){
args__4736__auto__.push((arguments[i__4731__auto___46873]));

var G__46874 = (i__4731__auto___46873 + (1));
i__4731__auto___46873 = G__46874;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__46505_46875 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__46506_46876 = null;
var count__46507_46877 = (0);
var i__46508_46878 = (0);
while(true){
if((i__46508_46878 < count__46507_46877)){
var vec__46519_46879 = chunk__46506_46876.cljs$core$IIndexed$_nth$arity$2(null,i__46508_46878);
var k_46880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46519_46879,(0),null);
var v_46881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46519_46879,(1),null);
style.setProperty(dommy.utils.as_str(k_46880),v_46881);


var G__46882 = seq__46505_46875;
var G__46883 = chunk__46506_46876;
var G__46884 = count__46507_46877;
var G__46885 = (i__46508_46878 + (1));
seq__46505_46875 = G__46882;
chunk__46506_46876 = G__46883;
count__46507_46877 = G__46884;
i__46508_46878 = G__46885;
continue;
} else {
var temp__5735__auto___46886 = cljs.core.seq(seq__46505_46875);
if(temp__5735__auto___46886){
var seq__46505_46887__$1 = temp__5735__auto___46886;
if(cljs.core.chunked_seq_QMARK_(seq__46505_46887__$1)){
var c__4550__auto___46888 = cljs.core.chunk_first(seq__46505_46887__$1);
var G__46889 = cljs.core.chunk_rest(seq__46505_46887__$1);
var G__46890 = c__4550__auto___46888;
var G__46891 = cljs.core.count(c__4550__auto___46888);
var G__46892 = (0);
seq__46505_46875 = G__46889;
chunk__46506_46876 = G__46890;
count__46507_46877 = G__46891;
i__46508_46878 = G__46892;
continue;
} else {
var vec__46522_46893 = cljs.core.first(seq__46505_46887__$1);
var k_46894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46522_46893,(0),null);
var v_46895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46522_46893,(1),null);
style.setProperty(dommy.utils.as_str(k_46894),v_46895);


var G__46896 = cljs.core.next(seq__46505_46887__$1);
var G__46897 = null;
var G__46898 = (0);
var G__46899 = (0);
seq__46505_46875 = G__46896;
chunk__46506_46876 = G__46897;
count__46507_46877 = G__46898;
i__46508_46878 = G__46899;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq46502){
var G__46503 = cljs.core.first(seq46502);
var seq46502__$1 = cljs.core.next(seq46502);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46503,seq46502__$1);
}));

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___46900 = arguments.length;
var i__4731__auto___46901 = (0);
while(true){
if((i__4731__auto___46901 < len__4730__auto___46900)){
args__4736__auto__.push((arguments[i__4731__auto___46901]));

var G__46902 = (i__4731__auto___46901 + (1));
i__4731__auto___46901 = G__46902;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__46527_46903 = cljs.core.seq(keywords);
var chunk__46528_46904 = null;
var count__46529_46905 = (0);
var i__46530_46906 = (0);
while(true){
if((i__46530_46906 < count__46529_46905)){
var kw_46907 = chunk__46528_46904.cljs$core$IIndexed$_nth$arity$2(null,i__46530_46906);
style.removeProperty(dommy.utils.as_str(kw_46907));


var G__46908 = seq__46527_46903;
var G__46909 = chunk__46528_46904;
var G__46910 = count__46529_46905;
var G__46911 = (i__46530_46906 + (1));
seq__46527_46903 = G__46908;
chunk__46528_46904 = G__46909;
count__46529_46905 = G__46910;
i__46530_46906 = G__46911;
continue;
} else {
var temp__5735__auto___46912 = cljs.core.seq(seq__46527_46903);
if(temp__5735__auto___46912){
var seq__46527_46913__$1 = temp__5735__auto___46912;
if(cljs.core.chunked_seq_QMARK_(seq__46527_46913__$1)){
var c__4550__auto___46914 = cljs.core.chunk_first(seq__46527_46913__$1);
var G__46915 = cljs.core.chunk_rest(seq__46527_46913__$1);
var G__46916 = c__4550__auto___46914;
var G__46917 = cljs.core.count(c__4550__auto___46914);
var G__46918 = (0);
seq__46527_46903 = G__46915;
chunk__46528_46904 = G__46916;
count__46529_46905 = G__46917;
i__46530_46906 = G__46918;
continue;
} else {
var kw_46919 = cljs.core.first(seq__46527_46913__$1);
style.removeProperty(dommy.utils.as_str(kw_46919));


var G__46920 = cljs.core.next(seq__46527_46913__$1);
var G__46921 = null;
var G__46922 = (0);
var G__46923 = (0);
seq__46527_46903 = G__46920;
chunk__46528_46904 = G__46921;
count__46529_46905 = G__46922;
i__46530_46906 = G__46923;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq46525){
var G__46526 = cljs.core.first(seq46525);
var seq46525__$1 = cljs.core.next(seq46525);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46526,seq46525__$1);
}));

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___46924 = arguments.length;
var i__4731__auto___46925 = (0);
while(true){
if((i__4731__auto___46925 < len__4730__auto___46924)){
args__4736__auto__.push((arguments[i__4731__auto___46925]));

var G__46926 = (i__4731__auto___46925 + (1));
i__4731__auto___46925 = G__46926;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__46533_46927 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__46534_46928 = null;
var count__46535_46929 = (0);
var i__46536_46930 = (0);
while(true){
if((i__46536_46930 < count__46535_46929)){
var vec__46543_46931 = chunk__46534_46928.cljs$core$IIndexed$_nth$arity$2(null,i__46536_46930);
var k_46932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46543_46931,(0),null);
var v_46933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46543_46931,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_46932,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_46933),"px"].join('')], 0));


var G__46934 = seq__46533_46927;
var G__46935 = chunk__46534_46928;
var G__46936 = count__46535_46929;
var G__46937 = (i__46536_46930 + (1));
seq__46533_46927 = G__46934;
chunk__46534_46928 = G__46935;
count__46535_46929 = G__46936;
i__46536_46930 = G__46937;
continue;
} else {
var temp__5735__auto___46938 = cljs.core.seq(seq__46533_46927);
if(temp__5735__auto___46938){
var seq__46533_46939__$1 = temp__5735__auto___46938;
if(cljs.core.chunked_seq_QMARK_(seq__46533_46939__$1)){
var c__4550__auto___46940 = cljs.core.chunk_first(seq__46533_46939__$1);
var G__46941 = cljs.core.chunk_rest(seq__46533_46939__$1);
var G__46942 = c__4550__auto___46940;
var G__46943 = cljs.core.count(c__4550__auto___46940);
var G__46944 = (0);
seq__46533_46927 = G__46941;
chunk__46534_46928 = G__46942;
count__46535_46929 = G__46943;
i__46536_46930 = G__46944;
continue;
} else {
var vec__46546_46945 = cljs.core.first(seq__46533_46939__$1);
var k_46946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46546_46945,(0),null);
var v_46947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46546_46945,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_46946,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_46947),"px"].join('')], 0));


var G__46948 = cljs.core.next(seq__46533_46939__$1);
var G__46949 = null;
var G__46950 = (0);
var G__46951 = (0);
seq__46533_46927 = G__46948;
chunk__46534_46928 = G__46949;
count__46535_46929 = G__46950;
i__46536_46930 = G__46951;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq46531){
var G__46532 = cljs.core.first(seq46531);
var seq46531__$1 = cljs.core.next(seq46531);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46532,seq46531__$1);
}));

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__46554 = arguments.length;
switch (G__46554) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___46953 = arguments.length;
var i__4731__auto___46954 = (0);
while(true){
if((i__4731__auto___46954 < len__4730__auto___46953)){
args_arr__4751__auto__.push((arguments[i__4731__auto___46954]));

var G__46955 = (i__4731__auto___46954 + (1));
i__4731__auto___46954 = G__46955;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__46555 = elem;
(G__46555[k__$1] = v);

return G__46555;
} else {
var G__46556 = elem;
G__46556.setAttribute(k__$1,v);

return G__46556;
}
} else {
return null;
}
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__46557_46956 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__46558_46957 = null;
var count__46559_46958 = (0);
var i__46560_46959 = (0);
while(true){
if((i__46560_46959 < count__46559_46958)){
var vec__46567_46960 = chunk__46558_46957.cljs$core$IIndexed$_nth$arity$2(null,i__46560_46959);
var k_46961__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46567_46960,(0),null);
var v_46962__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46567_46960,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_46961__$1,v_46962__$1);


var G__46963 = seq__46557_46956;
var G__46964 = chunk__46558_46957;
var G__46965 = count__46559_46958;
var G__46966 = (i__46560_46959 + (1));
seq__46557_46956 = G__46963;
chunk__46558_46957 = G__46964;
count__46559_46958 = G__46965;
i__46560_46959 = G__46966;
continue;
} else {
var temp__5735__auto___46967 = cljs.core.seq(seq__46557_46956);
if(temp__5735__auto___46967){
var seq__46557_46968__$1 = temp__5735__auto___46967;
if(cljs.core.chunked_seq_QMARK_(seq__46557_46968__$1)){
var c__4550__auto___46969 = cljs.core.chunk_first(seq__46557_46968__$1);
var G__46970 = cljs.core.chunk_rest(seq__46557_46968__$1);
var G__46971 = c__4550__auto___46969;
var G__46972 = cljs.core.count(c__4550__auto___46969);
var G__46973 = (0);
seq__46557_46956 = G__46970;
chunk__46558_46957 = G__46971;
count__46559_46958 = G__46972;
i__46560_46959 = G__46973;
continue;
} else {
var vec__46570_46974 = cljs.core.first(seq__46557_46968__$1);
var k_46975__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46570_46974,(0),null);
var v_46976__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46570_46974,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_46975__$1,v_46976__$1);


var G__46977 = cljs.core.next(seq__46557_46968__$1);
var G__46978 = null;
var G__46979 = (0);
var G__46980 = (0);
seq__46557_46956 = G__46977;
chunk__46558_46957 = G__46978;
count__46559_46958 = G__46979;
i__46560_46959 = G__46980;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq46550){
var G__46551 = cljs.core.first(seq46550);
var seq46550__$1 = cljs.core.next(seq46550);
var G__46552 = cljs.core.first(seq46550__$1);
var seq46550__$2 = cljs.core.next(seq46550__$1);
var G__46553 = cljs.core.first(seq46550__$2);
var seq46550__$3 = cljs.core.next(seq46550__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46551,G__46552,G__46553,seq46550__$3);
}));

(dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__46577 = arguments.length;
switch (G__46577) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___46982 = arguments.length;
var i__4731__auto___46983 = (0);
while(true){
if((i__4731__auto___46983 < len__4730__auto___46982)){
args_arr__4751__auto__.push((arguments[i__4731__auto___46983]));

var G__46984 = (i__4731__auto___46983 + (1));
i__4731__auto___46983 = G__46984;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_46985__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_((function (){var fexpr__46578 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null);
return (fexpr__46578.cljs$core$IFn$_invoke$arity$1 ? fexpr__46578.cljs$core$IFn$_invoke$arity$1(k_46985__$1) : fexpr__46578.call(null,k_46985__$1));
})())){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_46985__$1);
}

return elem;
}));

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__46579_46986 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__46580_46987 = null;
var count__46581_46988 = (0);
var i__46582_46989 = (0);
while(true){
if((i__46582_46989 < count__46581_46988)){
var k_46990__$1 = chunk__46580_46987.cljs$core$IIndexed$_nth$arity$2(null,i__46582_46989);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_46990__$1);


var G__46991 = seq__46579_46986;
var G__46992 = chunk__46580_46987;
var G__46993 = count__46581_46988;
var G__46994 = (i__46582_46989 + (1));
seq__46579_46986 = G__46991;
chunk__46580_46987 = G__46992;
count__46581_46988 = G__46993;
i__46582_46989 = G__46994;
continue;
} else {
var temp__5735__auto___46995 = cljs.core.seq(seq__46579_46986);
if(temp__5735__auto___46995){
var seq__46579_46996__$1 = temp__5735__auto___46995;
if(cljs.core.chunked_seq_QMARK_(seq__46579_46996__$1)){
var c__4550__auto___46997 = cljs.core.chunk_first(seq__46579_46996__$1);
var G__46998 = cljs.core.chunk_rest(seq__46579_46996__$1);
var G__46999 = c__4550__auto___46997;
var G__47000 = cljs.core.count(c__4550__auto___46997);
var G__47001 = (0);
seq__46579_46986 = G__46998;
chunk__46580_46987 = G__46999;
count__46581_46988 = G__47000;
i__46582_46989 = G__47001;
continue;
} else {
var k_47002__$1 = cljs.core.first(seq__46579_46996__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_47002__$1);


var G__47003 = cljs.core.next(seq__46579_46996__$1);
var G__47004 = null;
var G__47005 = (0);
var G__47006 = (0);
seq__46579_46986 = G__47003;
chunk__46580_46987 = G__47004;
count__46581_46988 = G__47005;
i__46582_46989 = G__47006;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq46574){
var G__46575 = cljs.core.first(seq46574);
var seq46574__$1 = cljs.core.next(seq46574);
var G__46576 = cljs.core.first(seq46574__$1);
var seq46574__$2 = cljs.core.next(seq46574__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46575,G__46576,seq46574__$2);
}));

(dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__46584 = arguments.length;
switch (G__46584) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
}));

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
}));

(dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__46589 = arguments.length;
switch (G__46589) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___47009 = arguments.length;
var i__4731__auto___47010 = (0);
while(true){
if((i__4731__auto___47010 < len__4730__auto___47009)){
args_arr__4751__auto__.push((arguments[i__4731__auto___47010]));

var G__47011 = (i__4731__auto___47010 + (1));
i__4731__auto___47010 = G__47011;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__5733__auto___47012 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___47012)){
var class_list_47013 = temp__5733__auto___47012;
var seq__46590_47014 = cljs.core.seq(classes__$1);
var chunk__46591_47015 = null;
var count__46592_47016 = (0);
var i__46593_47017 = (0);
while(true){
if((i__46593_47017 < count__46592_47016)){
var c_47018 = chunk__46591_47015.cljs$core$IIndexed$_nth$arity$2(null,i__46593_47017);
class_list_47013.add(c_47018);


var G__47019 = seq__46590_47014;
var G__47020 = chunk__46591_47015;
var G__47021 = count__46592_47016;
var G__47022 = (i__46593_47017 + (1));
seq__46590_47014 = G__47019;
chunk__46591_47015 = G__47020;
count__46592_47016 = G__47021;
i__46593_47017 = G__47022;
continue;
} else {
var temp__5735__auto___47023 = cljs.core.seq(seq__46590_47014);
if(temp__5735__auto___47023){
var seq__46590_47025__$1 = temp__5735__auto___47023;
if(cljs.core.chunked_seq_QMARK_(seq__46590_47025__$1)){
var c__4550__auto___47027 = cljs.core.chunk_first(seq__46590_47025__$1);
var G__47030 = cljs.core.chunk_rest(seq__46590_47025__$1);
var G__47031 = c__4550__auto___47027;
var G__47032 = cljs.core.count(c__4550__auto___47027);
var G__47033 = (0);
seq__46590_47014 = G__47030;
chunk__46591_47015 = G__47031;
count__46592_47016 = G__47032;
i__46593_47017 = G__47033;
continue;
} else {
var c_47034 = cljs.core.first(seq__46590_47025__$1);
class_list_47013.add(c_47034);


var G__47035 = cljs.core.next(seq__46590_47025__$1);
var G__47036 = null;
var G__47037 = (0);
var G__47038 = (0);
seq__46590_47014 = G__47035;
chunk__46591_47015 = G__47036;
count__46592_47016 = G__47037;
i__46593_47017 = G__47038;
continue;
}
} else {
}
}
break;
}
} else {
var seq__46594_47040 = cljs.core.seq(classes__$1);
var chunk__46595_47041 = null;
var count__46596_47042 = (0);
var i__46597_47043 = (0);
while(true){
if((i__46597_47043 < count__46596_47042)){
var c_47044 = chunk__46595_47041.cljs$core$IIndexed$_nth$arity$2(null,i__46597_47043);
var class_name_47046 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_47046,c_47044))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_47046 === ""))?c_47044:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_47046)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_47044)].join('')));
}


var G__47048 = seq__46594_47040;
var G__47049 = chunk__46595_47041;
var G__47050 = count__46596_47042;
var G__47051 = (i__46597_47043 + (1));
seq__46594_47040 = G__47048;
chunk__46595_47041 = G__47049;
count__46596_47042 = G__47050;
i__46597_47043 = G__47051;
continue;
} else {
var temp__5735__auto___47052 = cljs.core.seq(seq__46594_47040);
if(temp__5735__auto___47052){
var seq__46594_47054__$1 = temp__5735__auto___47052;
if(cljs.core.chunked_seq_QMARK_(seq__46594_47054__$1)){
var c__4550__auto___47055 = cljs.core.chunk_first(seq__46594_47054__$1);
var G__47056 = cljs.core.chunk_rest(seq__46594_47054__$1);
var G__47057 = c__4550__auto___47055;
var G__47058 = cljs.core.count(c__4550__auto___47055);
var G__47059 = (0);
seq__46594_47040 = G__47056;
chunk__46595_47041 = G__47057;
count__46596_47042 = G__47058;
i__46597_47043 = G__47059;
continue;
} else {
var c_47060 = cljs.core.first(seq__46594_47054__$1);
var class_name_47061 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_47061,c_47060))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_47061 === ""))?c_47060:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_47061)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_47060)].join('')));
}


var G__47066 = cljs.core.next(seq__46594_47054__$1);
var G__47067 = null;
var G__47068 = (0);
var G__47069 = (0);
seq__46594_47040 = G__47066;
chunk__46595_47041 = G__47067;
count__46596_47042 = G__47068;
i__46597_47043 = G__47069;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
}));

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__46598_47070 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__46599_47071 = null;
var count__46600_47072 = (0);
var i__46601_47073 = (0);
while(true){
if((i__46601_47073 < count__46600_47072)){
var c_47074 = chunk__46599_47071.cljs$core$IIndexed$_nth$arity$2(null,i__46601_47073);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_47074);


var G__47075 = seq__46598_47070;
var G__47076 = chunk__46599_47071;
var G__47077 = count__46600_47072;
var G__47078 = (i__46601_47073 + (1));
seq__46598_47070 = G__47075;
chunk__46599_47071 = G__47076;
count__46600_47072 = G__47077;
i__46601_47073 = G__47078;
continue;
} else {
var temp__5735__auto___47079 = cljs.core.seq(seq__46598_47070);
if(temp__5735__auto___47079){
var seq__46598_47080__$1 = temp__5735__auto___47079;
if(cljs.core.chunked_seq_QMARK_(seq__46598_47080__$1)){
var c__4550__auto___47082 = cljs.core.chunk_first(seq__46598_47080__$1);
var G__47083 = cljs.core.chunk_rest(seq__46598_47080__$1);
var G__47084 = c__4550__auto___47082;
var G__47085 = cljs.core.count(c__4550__auto___47082);
var G__47086 = (0);
seq__46598_47070 = G__47083;
chunk__46599_47071 = G__47084;
count__46600_47072 = G__47085;
i__46601_47073 = G__47086;
continue;
} else {
var c_47087 = cljs.core.first(seq__46598_47080__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_47087);


var G__47088 = cljs.core.next(seq__46598_47080__$1);
var G__47089 = null;
var G__47090 = (0);
var G__47091 = (0);
seq__46598_47070 = G__47088;
chunk__46599_47071 = G__47089;
count__46600_47072 = G__47090;
i__46601_47073 = G__47091;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq46586){
var G__46587 = cljs.core.first(seq46586);
var seq46586__$1 = cljs.core.next(seq46586);
var G__46588 = cljs.core.first(seq46586__$1);
var seq46586__$2 = cljs.core.next(seq46586__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46587,G__46588,seq46586__$2);
}));

(dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__46606 = arguments.length;
switch (G__46606) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___47096 = arguments.length;
var i__4731__auto___47097 = (0);
while(true){
if((i__4731__auto___47097 < len__4730__auto___47096)){
args_arr__4751__auto__.push((arguments[i__4731__auto___47097]));

var G__47098 = (i__4731__auto___47097 + (1));
i__4731__auto___47097 = G__47098;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___47099 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___47099)){
var class_list_47100 = temp__5733__auto___47099;
class_list_47100.remove(c__$1);
} else {
var class_name_47101 = dommy.core.class$(elem);
var new_class_name_47102 = dommy.utils.remove_class_str(class_name_47101,c__$1);
if((class_name_47101 === new_class_name_47102)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_47102);
}
}

return elem;
}));

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__46607 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__46608 = null;
var count__46609 = (0);
var i__46610 = (0);
while(true){
if((i__46610 < count__46609)){
var c = chunk__46608.cljs$core$IIndexed$_nth$arity$2(null,i__46610);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__47105 = seq__46607;
var G__47106 = chunk__46608;
var G__47107 = count__46609;
var G__47108 = (i__46610 + (1));
seq__46607 = G__47105;
chunk__46608 = G__47106;
count__46609 = G__47107;
i__46610 = G__47108;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46607);
if(temp__5735__auto__){
var seq__46607__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46607__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__46607__$1);
var G__47109 = cljs.core.chunk_rest(seq__46607__$1);
var G__47110 = c__4550__auto__;
var G__47111 = cljs.core.count(c__4550__auto__);
var G__47112 = (0);
seq__46607 = G__47109;
chunk__46608 = G__47110;
count__46609 = G__47111;
i__46610 = G__47112;
continue;
} else {
var c = cljs.core.first(seq__46607__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__47114 = cljs.core.next(seq__46607__$1);
var G__47115 = null;
var G__47116 = (0);
var G__47117 = (0);
seq__46607 = G__47114;
chunk__46608 = G__47115;
count__46609 = G__47116;
i__46610 = G__47117;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq46603){
var G__46604 = cljs.core.first(seq46603);
var seq46603__$1 = cljs.core.next(seq46603);
var G__46605 = cljs.core.first(seq46603__$1);
var seq46603__$2 = cljs.core.next(seq46603__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46604,G__46605,seq46603__$2);
}));

(dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__46612 = arguments.length;
switch (G__46612) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___47122 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___47122)){
var class_list_47124 = temp__5733__auto___47122;
class_list_47124.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,(!(dommy.core.has_class_QMARK_(elem,c__$1))));
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__46614 = arguments.length;
switch (G__46614) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none")], 0));
}));

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
}));

(dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__46616 = arguments.length;
switch (G__46616) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$lang$maxFixedArity = 2);

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__46621 = arguments.length;
switch (G__46621) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___47128 = arguments.length;
var i__4731__auto___47129 = (0);
while(true){
if((i__4731__auto___47129 < len__4730__auto___47128)){
args_arr__4751__auto__.push((arguments[i__4731__auto___47129]));

var G__47130 = (i__4731__auto___47129 + (1));
i__4731__auto___47129 = G__47130;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__46622 = parent;
G__46622.appendChild(child);

return G__46622;
}));

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__46623_47131 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__46624_47132 = null;
var count__46625_47133 = (0);
var i__46626_47134 = (0);
while(true){
if((i__46626_47134 < count__46625_47133)){
var c_47135 = chunk__46624_47132.cljs$core$IIndexed$_nth$arity$2(null,i__46626_47134);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_47135);


var G__47136 = seq__46623_47131;
var G__47137 = chunk__46624_47132;
var G__47138 = count__46625_47133;
var G__47139 = (i__46626_47134 + (1));
seq__46623_47131 = G__47136;
chunk__46624_47132 = G__47137;
count__46625_47133 = G__47138;
i__46626_47134 = G__47139;
continue;
} else {
var temp__5735__auto___47140 = cljs.core.seq(seq__46623_47131);
if(temp__5735__auto___47140){
var seq__46623_47141__$1 = temp__5735__auto___47140;
if(cljs.core.chunked_seq_QMARK_(seq__46623_47141__$1)){
var c__4550__auto___47142 = cljs.core.chunk_first(seq__46623_47141__$1);
var G__47143 = cljs.core.chunk_rest(seq__46623_47141__$1);
var G__47144 = c__4550__auto___47142;
var G__47145 = cljs.core.count(c__4550__auto___47142);
var G__47146 = (0);
seq__46623_47131 = G__47143;
chunk__46624_47132 = G__47144;
count__46625_47133 = G__47145;
i__46626_47134 = G__47146;
continue;
} else {
var c_47147 = cljs.core.first(seq__46623_47141__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_47147);


var G__47149 = cljs.core.next(seq__46623_47141__$1);
var G__47150 = null;
var G__47151 = (0);
var G__47152 = (0);
seq__46623_47131 = G__47149;
chunk__46624_47132 = G__47150;
count__46625_47133 = G__47151;
i__46626_47134 = G__47152;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq46618){
var G__46619 = cljs.core.first(seq46618);
var seq46618__$1 = cljs.core.next(seq46618);
var G__46620 = cljs.core.first(seq46618__$1);
var seq46618__$2 = cljs.core.next(seq46618__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46619,G__46620,seq46618__$2);
}));

(dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__46631 = arguments.length;
switch (G__46631) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___47154 = arguments.length;
var i__4731__auto___47155 = (0);
while(true){
if((i__4731__auto___47155 < len__4730__auto___47154)){
args_arr__4751__auto__.push((arguments[i__4731__auto___47155]));

var G__47156 = (i__4731__auto___47155 + (1));
i__4731__auto___47155 = G__47156;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__46632 = parent;
G__46632.insertBefore(child,parent.firstChild);

return G__46632;
}));

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__46633_47157 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__46634_47158 = null;
var count__46635_47159 = (0);
var i__46636_47160 = (0);
while(true){
if((i__46636_47160 < count__46635_47159)){
var c_47161 = chunk__46634_47158.cljs$core$IIndexed$_nth$arity$2(null,i__46636_47160);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_47161);


var G__47162 = seq__46633_47157;
var G__47163 = chunk__46634_47158;
var G__47164 = count__46635_47159;
var G__47165 = (i__46636_47160 + (1));
seq__46633_47157 = G__47162;
chunk__46634_47158 = G__47163;
count__46635_47159 = G__47164;
i__46636_47160 = G__47165;
continue;
} else {
var temp__5735__auto___47166 = cljs.core.seq(seq__46633_47157);
if(temp__5735__auto___47166){
var seq__46633_47167__$1 = temp__5735__auto___47166;
if(cljs.core.chunked_seq_QMARK_(seq__46633_47167__$1)){
var c__4550__auto___47168 = cljs.core.chunk_first(seq__46633_47167__$1);
var G__47169 = cljs.core.chunk_rest(seq__46633_47167__$1);
var G__47170 = c__4550__auto___47168;
var G__47171 = cljs.core.count(c__4550__auto___47168);
var G__47172 = (0);
seq__46633_47157 = G__47169;
chunk__46634_47158 = G__47170;
count__46635_47159 = G__47171;
i__46636_47160 = G__47172;
continue;
} else {
var c_47174 = cljs.core.first(seq__46633_47167__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_47174);


var G__47175 = cljs.core.next(seq__46633_47167__$1);
var G__47176 = null;
var G__47177 = (0);
var G__47178 = (0);
seq__46633_47157 = G__47175;
chunk__46634_47158 = G__47176;
count__46635_47159 = G__47177;
i__46636_47160 = G__47178;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq46628){
var G__46629 = cljs.core.first(seq46628);
var seq46628__$1 = cljs.core.next(seq46628);
var G__46630 = cljs.core.first(seq46628__$1);
var seq46628__$2 = cljs.core.next(seq46628__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46629,G__46630,seq46628__$2);
}));

(dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5733__auto___47179 = other.nextSibling;
if(cljs.core.truth_(temp__5733__auto___47179)){
var next_47180 = temp__5733__auto___47179;
dommy.core.insert_before_BANG_(elem,next_47180);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__46638 = arguments.length;
switch (G__46638) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
}));

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__46639 = p;
G__46639.removeChild(elem);

return G__46639;
}));

(dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__46640){
var vec__46641 = p__46640;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46641,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46641,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,(function (f){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4120__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4109__auto__ = related_target;
if(cljs.core.truth_(and__4109__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4109__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
})])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4109__auto__ = selected_target;
if(cljs.core.truth_(and__4109__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4109__auto__;
}
})())){
(event.selectedTarget = selected_target);

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4120__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47182 = arguments.length;
var i__4731__auto___47183 = (0);
while(true){
if((i__4731__auto___47183 < len__4730__auto___47182)){
args__4736__auto__.push((arguments[i__4731__auto___47183]));

var G__47184 = (i__4731__auto___47183 + (1));
i__4731__auto___47183 = G__47184;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

(dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return (elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args));
}));

(dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq46644){
var G__46645 = cljs.core.first(seq46644);
var seq46644__$1 = cljs.core.next(seq46644);
var G__46646 = cljs.core.first(seq46644__$1);
var seq46644__$2 = cljs.core.next(seq46644__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46645,G__46646,seq46644__$2);
}));

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest)(elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47185 = arguments.length;
var i__4731__auto___47186 = (0);
while(true){
if((i__4731__auto___47186 < len__4730__auto___47185)){
args__4736__auto__.push((arguments[i__4731__auto___47186]));

var G__47187 = (i__4731__auto___47186 + (1));
i__4731__auto___47186 = G__47187;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__46649_47188 = dommy.core.elem_and_selector(elem_sel);
var elem_47189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46649_47188,(0),null);
var selector_47190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46649_47188,(1),null);
var seq__46652_47191 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__46659_47192 = null;
var count__46660_47193 = (0);
var i__46661_47194 = (0);
while(true){
if((i__46661_47194 < count__46660_47193)){
var vec__46714_47195 = chunk__46659_47192.cljs$core$IIndexed$_nth$arity$2(null,i__46661_47194);
var orig_type_47196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46714_47195,(0),null);
var f_47197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46714_47195,(1),null);
var seq__46662_47198 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_47196,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_47196,cljs.core.identity])));
var chunk__46664_47199 = null;
var count__46665_47200 = (0);
var i__46666_47201 = (0);
while(true){
if((i__46666_47201 < count__46665_47200)){
var vec__46727_47202 = chunk__46664_47199.cljs$core$IIndexed$_nth$arity$2(null,i__46666_47201);
var actual_type_47203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46727_47202,(0),null);
var factory_47204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46727_47202,(1),null);
var canonical_f_47205 = (function (){var G__46731 = (factory_47204.cljs$core$IFn$_invoke$arity$1 ? factory_47204.cljs$core$IFn$_invoke$arity$1(f_47197) : factory_47204.call(null,f_47197));
var fexpr__46730 = (cljs.core.truth_(selector_47190)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_47189,selector_47190):cljs.core.identity);
return (fexpr__46730.cljs$core$IFn$_invoke$arity$1 ? fexpr__46730.cljs$core$IFn$_invoke$arity$1(G__46731) : fexpr__46730.call(null,G__46731));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47189,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47190,actual_type_47203,f_47197], null),canonical_f_47205], 0));

if(cljs.core.truth_(elem_47189.addEventListener)){
elem_47189.addEventListener(cljs.core.name(actual_type_47203),canonical_f_47205);
} else {
elem_47189.attachEvent(cljs.core.name(actual_type_47203),canonical_f_47205);
}


var G__47206 = seq__46662_47198;
var G__47207 = chunk__46664_47199;
var G__47208 = count__46665_47200;
var G__47209 = (i__46666_47201 + (1));
seq__46662_47198 = G__47206;
chunk__46664_47199 = G__47207;
count__46665_47200 = G__47208;
i__46666_47201 = G__47209;
continue;
} else {
var temp__5735__auto___47210 = cljs.core.seq(seq__46662_47198);
if(temp__5735__auto___47210){
var seq__46662_47211__$1 = temp__5735__auto___47210;
if(cljs.core.chunked_seq_QMARK_(seq__46662_47211__$1)){
var c__4550__auto___47212 = cljs.core.chunk_first(seq__46662_47211__$1);
var G__47213 = cljs.core.chunk_rest(seq__46662_47211__$1);
var G__47214 = c__4550__auto___47212;
var G__47215 = cljs.core.count(c__4550__auto___47212);
var G__47216 = (0);
seq__46662_47198 = G__47213;
chunk__46664_47199 = G__47214;
count__46665_47200 = G__47215;
i__46666_47201 = G__47216;
continue;
} else {
var vec__46732_47217 = cljs.core.first(seq__46662_47211__$1);
var actual_type_47218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46732_47217,(0),null);
var factory_47219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46732_47217,(1),null);
var canonical_f_47220 = (function (){var G__46736 = (factory_47219.cljs$core$IFn$_invoke$arity$1 ? factory_47219.cljs$core$IFn$_invoke$arity$1(f_47197) : factory_47219.call(null,f_47197));
var fexpr__46735 = (cljs.core.truth_(selector_47190)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_47189,selector_47190):cljs.core.identity);
return (fexpr__46735.cljs$core$IFn$_invoke$arity$1 ? fexpr__46735.cljs$core$IFn$_invoke$arity$1(G__46736) : fexpr__46735.call(null,G__46736));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47189,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47190,actual_type_47218,f_47197], null),canonical_f_47220], 0));

if(cljs.core.truth_(elem_47189.addEventListener)){
elem_47189.addEventListener(cljs.core.name(actual_type_47218),canonical_f_47220);
} else {
elem_47189.attachEvent(cljs.core.name(actual_type_47218),canonical_f_47220);
}


var G__47221 = cljs.core.next(seq__46662_47211__$1);
var G__47222 = null;
var G__47223 = (0);
var G__47224 = (0);
seq__46662_47198 = G__47221;
chunk__46664_47199 = G__47222;
count__46665_47200 = G__47223;
i__46666_47201 = G__47224;
continue;
}
} else {
}
}
break;
}

var G__47225 = seq__46652_47191;
var G__47226 = chunk__46659_47192;
var G__47227 = count__46660_47193;
var G__47228 = (i__46661_47194 + (1));
seq__46652_47191 = G__47225;
chunk__46659_47192 = G__47226;
count__46660_47193 = G__47227;
i__46661_47194 = G__47228;
continue;
} else {
var temp__5735__auto___47229 = cljs.core.seq(seq__46652_47191);
if(temp__5735__auto___47229){
var seq__46652_47230__$1 = temp__5735__auto___47229;
if(cljs.core.chunked_seq_QMARK_(seq__46652_47230__$1)){
var c__4550__auto___47231 = cljs.core.chunk_first(seq__46652_47230__$1);
var G__47232 = cljs.core.chunk_rest(seq__46652_47230__$1);
var G__47233 = c__4550__auto___47231;
var G__47234 = cljs.core.count(c__4550__auto___47231);
var G__47235 = (0);
seq__46652_47191 = G__47232;
chunk__46659_47192 = G__47233;
count__46660_47193 = G__47234;
i__46661_47194 = G__47235;
continue;
} else {
var vec__46737_47236 = cljs.core.first(seq__46652_47230__$1);
var orig_type_47237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46737_47236,(0),null);
var f_47238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46737_47236,(1),null);
var seq__46653_47239 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_47237,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_47237,cljs.core.identity])));
var chunk__46655_47240 = null;
var count__46656_47241 = (0);
var i__46657_47242 = (0);
while(true){
if((i__46657_47242 < count__46656_47241)){
var vec__46750_47243 = chunk__46655_47240.cljs$core$IIndexed$_nth$arity$2(null,i__46657_47242);
var actual_type_47244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46750_47243,(0),null);
var factory_47245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46750_47243,(1),null);
var canonical_f_47246 = (function (){var G__46754 = (factory_47245.cljs$core$IFn$_invoke$arity$1 ? factory_47245.cljs$core$IFn$_invoke$arity$1(f_47238) : factory_47245.call(null,f_47238));
var fexpr__46753 = (cljs.core.truth_(selector_47190)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_47189,selector_47190):cljs.core.identity);
return (fexpr__46753.cljs$core$IFn$_invoke$arity$1 ? fexpr__46753.cljs$core$IFn$_invoke$arity$1(G__46754) : fexpr__46753.call(null,G__46754));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47189,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47190,actual_type_47244,f_47238], null),canonical_f_47246], 0));

if(cljs.core.truth_(elem_47189.addEventListener)){
elem_47189.addEventListener(cljs.core.name(actual_type_47244),canonical_f_47246);
} else {
elem_47189.attachEvent(cljs.core.name(actual_type_47244),canonical_f_47246);
}


var G__47247 = seq__46653_47239;
var G__47248 = chunk__46655_47240;
var G__47249 = count__46656_47241;
var G__47250 = (i__46657_47242 + (1));
seq__46653_47239 = G__47247;
chunk__46655_47240 = G__47248;
count__46656_47241 = G__47249;
i__46657_47242 = G__47250;
continue;
} else {
var temp__5735__auto___47251__$1 = cljs.core.seq(seq__46653_47239);
if(temp__5735__auto___47251__$1){
var seq__46653_47252__$1 = temp__5735__auto___47251__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46653_47252__$1)){
var c__4550__auto___47253 = cljs.core.chunk_first(seq__46653_47252__$1);
var G__47254 = cljs.core.chunk_rest(seq__46653_47252__$1);
var G__47255 = c__4550__auto___47253;
var G__47256 = cljs.core.count(c__4550__auto___47253);
var G__47257 = (0);
seq__46653_47239 = G__47254;
chunk__46655_47240 = G__47255;
count__46656_47241 = G__47256;
i__46657_47242 = G__47257;
continue;
} else {
var vec__46755_47258 = cljs.core.first(seq__46653_47252__$1);
var actual_type_47259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46755_47258,(0),null);
var factory_47260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46755_47258,(1),null);
var canonical_f_47261 = (function (){var G__46759 = (factory_47260.cljs$core$IFn$_invoke$arity$1 ? factory_47260.cljs$core$IFn$_invoke$arity$1(f_47238) : factory_47260.call(null,f_47238));
var fexpr__46758 = (cljs.core.truth_(selector_47190)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_47189,selector_47190):cljs.core.identity);
return (fexpr__46758.cljs$core$IFn$_invoke$arity$1 ? fexpr__46758.cljs$core$IFn$_invoke$arity$1(G__46759) : fexpr__46758.call(null,G__46759));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47189,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47190,actual_type_47259,f_47238], null),canonical_f_47261], 0));

if(cljs.core.truth_(elem_47189.addEventListener)){
elem_47189.addEventListener(cljs.core.name(actual_type_47259),canonical_f_47261);
} else {
elem_47189.attachEvent(cljs.core.name(actual_type_47259),canonical_f_47261);
}


var G__47262 = cljs.core.next(seq__46653_47252__$1);
var G__47263 = null;
var G__47264 = (0);
var G__47265 = (0);
seq__46653_47239 = G__47262;
chunk__46655_47240 = G__47263;
count__46656_47241 = G__47264;
i__46657_47242 = G__47265;
continue;
}
} else {
}
}
break;
}

var G__47266 = cljs.core.next(seq__46652_47230__$1);
var G__47267 = null;
var G__47268 = (0);
var G__47269 = (0);
seq__46652_47191 = G__47266;
chunk__46659_47192 = G__47267;
count__46660_47193 = G__47268;
i__46661_47194 = G__47269;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq46647){
var G__46648 = cljs.core.first(seq46647);
var seq46647__$1 = cljs.core.next(seq46647);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46648,seq46647__$1);
}));

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47270 = arguments.length;
var i__4731__auto___47271 = (0);
while(true){
if((i__4731__auto___47271 < len__4730__auto___47270)){
args__4736__auto__.push((arguments[i__4731__auto___47271]));

var G__47272 = (i__4731__auto___47271 + (1));
i__4731__auto___47271 = G__47272;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__46762_47273 = dommy.core.elem_and_selector(elem_sel);
var elem_47274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46762_47273,(0),null);
var selector_47275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46762_47273,(1),null);
var seq__46765_47276 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__46772_47277 = null;
var count__46773_47278 = (0);
var i__46774_47279 = (0);
while(true){
if((i__46774_47279 < count__46773_47278)){
var vec__46811_47280 = chunk__46772_47277.cljs$core$IIndexed$_nth$arity$2(null,i__46774_47279);
var orig_type_47281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46811_47280,(0),null);
var f_47282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46811_47280,(1),null);
var seq__46775_47283 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_47281,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_47281,cljs.core.identity])));
var chunk__46777_47284 = null;
var count__46778_47285 = (0);
var i__46779_47286 = (0);
while(true){
if((i__46779_47286 < count__46778_47285)){
var vec__46820_47287 = chunk__46777_47284.cljs$core$IIndexed$_nth$arity$2(null,i__46779_47286);
var actual_type_47288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46820_47287,(0),null);
var __47289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46820_47287,(1),null);
var keys_47290 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47275,actual_type_47288,f_47282], null);
var canonical_f_47291 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_47274),keys_47290);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47274,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_47290], 0));

if(cljs.core.truth_(elem_47274.removeEventListener)){
elem_47274.removeEventListener(cljs.core.name(actual_type_47288),canonical_f_47291);
} else {
elem_47274.detachEvent(cljs.core.name(actual_type_47288),canonical_f_47291);
}


var G__47292 = seq__46775_47283;
var G__47293 = chunk__46777_47284;
var G__47294 = count__46778_47285;
var G__47295 = (i__46779_47286 + (1));
seq__46775_47283 = G__47292;
chunk__46777_47284 = G__47293;
count__46778_47285 = G__47294;
i__46779_47286 = G__47295;
continue;
} else {
var temp__5735__auto___47296 = cljs.core.seq(seq__46775_47283);
if(temp__5735__auto___47296){
var seq__46775_47297__$1 = temp__5735__auto___47296;
if(cljs.core.chunked_seq_QMARK_(seq__46775_47297__$1)){
var c__4550__auto___47298 = cljs.core.chunk_first(seq__46775_47297__$1);
var G__47299 = cljs.core.chunk_rest(seq__46775_47297__$1);
var G__47300 = c__4550__auto___47298;
var G__47301 = cljs.core.count(c__4550__auto___47298);
var G__47302 = (0);
seq__46775_47283 = G__47299;
chunk__46777_47284 = G__47300;
count__46778_47285 = G__47301;
i__46779_47286 = G__47302;
continue;
} else {
var vec__46823_47303 = cljs.core.first(seq__46775_47297__$1);
var actual_type_47304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46823_47303,(0),null);
var __47305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46823_47303,(1),null);
var keys_47306 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47275,actual_type_47304,f_47282], null);
var canonical_f_47307 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_47274),keys_47306);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47274,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_47306], 0));

if(cljs.core.truth_(elem_47274.removeEventListener)){
elem_47274.removeEventListener(cljs.core.name(actual_type_47304),canonical_f_47307);
} else {
elem_47274.detachEvent(cljs.core.name(actual_type_47304),canonical_f_47307);
}


var G__47308 = cljs.core.next(seq__46775_47297__$1);
var G__47309 = null;
var G__47310 = (0);
var G__47311 = (0);
seq__46775_47283 = G__47308;
chunk__46777_47284 = G__47309;
count__46778_47285 = G__47310;
i__46779_47286 = G__47311;
continue;
}
} else {
}
}
break;
}

var G__47312 = seq__46765_47276;
var G__47313 = chunk__46772_47277;
var G__47314 = count__46773_47278;
var G__47315 = (i__46774_47279 + (1));
seq__46765_47276 = G__47312;
chunk__46772_47277 = G__47313;
count__46773_47278 = G__47314;
i__46774_47279 = G__47315;
continue;
} else {
var temp__5735__auto___47316 = cljs.core.seq(seq__46765_47276);
if(temp__5735__auto___47316){
var seq__46765_47317__$1 = temp__5735__auto___47316;
if(cljs.core.chunked_seq_QMARK_(seq__46765_47317__$1)){
var c__4550__auto___47318 = cljs.core.chunk_first(seq__46765_47317__$1);
var G__47319 = cljs.core.chunk_rest(seq__46765_47317__$1);
var G__47320 = c__4550__auto___47318;
var G__47321 = cljs.core.count(c__4550__auto___47318);
var G__47322 = (0);
seq__46765_47276 = G__47319;
chunk__46772_47277 = G__47320;
count__46773_47278 = G__47321;
i__46774_47279 = G__47322;
continue;
} else {
var vec__46826_47323 = cljs.core.first(seq__46765_47317__$1);
var orig_type_47324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46826_47323,(0),null);
var f_47325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46826_47323,(1),null);
var seq__46766_47326 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_47324,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_47324,cljs.core.identity])));
var chunk__46768_47327 = null;
var count__46769_47328 = (0);
var i__46770_47329 = (0);
while(true){
if((i__46770_47329 < count__46769_47328)){
var vec__46835_47330 = chunk__46768_47327.cljs$core$IIndexed$_nth$arity$2(null,i__46770_47329);
var actual_type_47331 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46835_47330,(0),null);
var __47332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46835_47330,(1),null);
var keys_47333 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47275,actual_type_47331,f_47325], null);
var canonical_f_47334 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_47274),keys_47333);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47274,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_47333], 0));

if(cljs.core.truth_(elem_47274.removeEventListener)){
elem_47274.removeEventListener(cljs.core.name(actual_type_47331),canonical_f_47334);
} else {
elem_47274.detachEvent(cljs.core.name(actual_type_47331),canonical_f_47334);
}


var G__47335 = seq__46766_47326;
var G__47336 = chunk__46768_47327;
var G__47337 = count__46769_47328;
var G__47338 = (i__46770_47329 + (1));
seq__46766_47326 = G__47335;
chunk__46768_47327 = G__47336;
count__46769_47328 = G__47337;
i__46770_47329 = G__47338;
continue;
} else {
var temp__5735__auto___47339__$1 = cljs.core.seq(seq__46766_47326);
if(temp__5735__auto___47339__$1){
var seq__46766_47340__$1 = temp__5735__auto___47339__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46766_47340__$1)){
var c__4550__auto___47341 = cljs.core.chunk_first(seq__46766_47340__$1);
var G__47342 = cljs.core.chunk_rest(seq__46766_47340__$1);
var G__47343 = c__4550__auto___47341;
var G__47344 = cljs.core.count(c__4550__auto___47341);
var G__47345 = (0);
seq__46766_47326 = G__47342;
chunk__46768_47327 = G__47343;
count__46769_47328 = G__47344;
i__46770_47329 = G__47345;
continue;
} else {
var vec__46838_47346 = cljs.core.first(seq__46766_47340__$1);
var actual_type_47347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46838_47346,(0),null);
var __47348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46838_47346,(1),null);
var keys_47349 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_47275,actual_type_47347,f_47325], null);
var canonical_f_47350 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_47274),keys_47349);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_47274,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_47349], 0));

if(cljs.core.truth_(elem_47274.removeEventListener)){
elem_47274.removeEventListener(cljs.core.name(actual_type_47347),canonical_f_47350);
} else {
elem_47274.detachEvent(cljs.core.name(actual_type_47347),canonical_f_47350);
}


var G__47351 = cljs.core.next(seq__46766_47340__$1);
var G__47352 = null;
var G__47353 = (0);
var G__47354 = (0);
seq__46766_47326 = G__47351;
chunk__46768_47327 = G__47352;
count__46769_47328 = G__47353;
i__46770_47329 = G__47354;
continue;
}
} else {
}
}
break;
}

var G__47355 = cljs.core.next(seq__46765_47317__$1);
var G__47356 = null;
var G__47357 = (0);
var G__47358 = (0);
seq__46765_47276 = G__47355;
chunk__46772_47277 = G__47356;
count__46773_47278 = G__47357;
i__46774_47279 = G__47358;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq46760){
var G__46761 = cljs.core.first(seq46760);
var seq46760__$1 = cljs.core.next(seq46760);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46761,seq46760__$1);
}));

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47359 = arguments.length;
var i__4731__auto___47360 = (0);
while(true){
if((i__4731__auto___47360 < len__4730__auto___47359)){
args__4736__auto__.push((arguments[i__4731__auto___47360]));

var G__47361 = (i__4731__auto___47360 + (1));
i__4731__auto___47360 = G__47361;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__46843_47362 = dommy.core.elem_and_selector(elem_sel);
var elem_47363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46843_47362,(0),null);
var selector_47364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46843_47362,(1),null);
var seq__46846_47365 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__46847_47366 = null;
var count__46848_47367 = (0);
var i__46849_47368 = (0);
while(true){
if((i__46849_47368 < count__46848_47367)){
var vec__46856_47369 = chunk__46847_47366.cljs$core$IIndexed$_nth$arity$2(null,i__46849_47368);
var type_47370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46856_47369,(0),null);
var f_47371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46856_47369,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_47370,((function (seq__46846_47365,chunk__46847_47366,count__46848_47367,i__46849_47368,vec__46856_47369,type_47370,f_47371,vec__46843_47362,elem_47363,selector_47364){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_47370,dommy$core$this_fn], 0));

return (f_47371.cljs$core$IFn$_invoke$arity$1 ? f_47371.cljs$core$IFn$_invoke$arity$1(e) : f_47371.call(null,e));
});})(seq__46846_47365,chunk__46847_47366,count__46848_47367,i__46849_47368,vec__46856_47369,type_47370,f_47371,vec__46843_47362,elem_47363,selector_47364))
], 0));


var G__47372 = seq__46846_47365;
var G__47373 = chunk__46847_47366;
var G__47374 = count__46848_47367;
var G__47375 = (i__46849_47368 + (1));
seq__46846_47365 = G__47372;
chunk__46847_47366 = G__47373;
count__46848_47367 = G__47374;
i__46849_47368 = G__47375;
continue;
} else {
var temp__5735__auto___47376 = cljs.core.seq(seq__46846_47365);
if(temp__5735__auto___47376){
var seq__46846_47377__$1 = temp__5735__auto___47376;
if(cljs.core.chunked_seq_QMARK_(seq__46846_47377__$1)){
var c__4550__auto___47378 = cljs.core.chunk_first(seq__46846_47377__$1);
var G__47379 = cljs.core.chunk_rest(seq__46846_47377__$1);
var G__47380 = c__4550__auto___47378;
var G__47381 = cljs.core.count(c__4550__auto___47378);
var G__47382 = (0);
seq__46846_47365 = G__47379;
chunk__46847_47366 = G__47380;
count__46848_47367 = G__47381;
i__46849_47368 = G__47382;
continue;
} else {
var vec__46859_47383 = cljs.core.first(seq__46846_47377__$1);
var type_47384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46859_47383,(0),null);
var f_47385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46859_47383,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_47384,((function (seq__46846_47365,chunk__46847_47366,count__46848_47367,i__46849_47368,vec__46859_47383,type_47384,f_47385,seq__46846_47377__$1,temp__5735__auto___47376,vec__46843_47362,elem_47363,selector_47364){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_47384,dommy$core$this_fn], 0));

return (f_47385.cljs$core$IFn$_invoke$arity$1 ? f_47385.cljs$core$IFn$_invoke$arity$1(e) : f_47385.call(null,e));
});})(seq__46846_47365,chunk__46847_47366,count__46848_47367,i__46849_47368,vec__46859_47383,type_47384,f_47385,seq__46846_47377__$1,temp__5735__auto___47376,vec__46843_47362,elem_47363,selector_47364))
], 0));


var G__47386 = cljs.core.next(seq__46846_47377__$1);
var G__47387 = null;
var G__47388 = (0);
var G__47389 = (0);
seq__46846_47365 = G__47386;
chunk__46847_47366 = G__47387;
count__46848_47367 = G__47388;
i__46849_47368 = G__47389;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq46841){
var G__46842 = cljs.core.first(seq46841);
var seq46841__$1 = cljs.core.next(seq46841);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46842,seq46841__$1);
}));


//# sourceMappingURL=dommy.core.js.map
