goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__37916){
var vec__37917 = p__37916;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37917,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37917,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__37920 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__37923 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37923,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37923,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37923,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37923,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37923,(4),null);
var vec__37926 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37926,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37926,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37926,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37926,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37926,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4120__auto__ = source;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4120__auto__ = line;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4120__auto__ = col;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4120__auto__ = name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__37929 = segmap;
var map__37929__$1 = (((((!((map__37929 == null))))?(((((map__37929.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37929.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37929):map__37929);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37929__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37929__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37929__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37929__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37929__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__37936 = arguments.length;
switch (G__37936) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__37940 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__38890 = cljs.core.next(segs__$1);
var G__38891 = nrelseg;
var G__38892 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__38890;
relseg__$1 = G__38891;
result__$1 = G__38892;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37940,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37940,(1),null);
var G__38893 = (gline + (1));
var G__38894 = cljs.core.next(lines__$1);
var G__38895 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__38896 = result__$1;
gline = G__38893;
lines__$1 = G__38894;
relseg = G__38895;
result = G__38896;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__37947 = segmap;
var map__37947__$1 = (((((!((map__37947 == null))))?(((((map__37947.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37947.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37947):map__37947);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37947__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37947__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37947__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37947__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37947__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__37943_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__37943_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__37954 = arguments.length;
switch (G__37954) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__37967 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__38911 = cljs.core.next(segs__$1);
var G__38912 = nrelseg;
var G__38913 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__38911;
relseg__$1 = G__38912;
result__$1 = G__38913;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37967,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37967,(1),null);
var G__38914 = (gline + (1));
var G__38915 = cljs.core.next(lines__$1);
var G__38916 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__38917 = result__$1;
gline = G__38914;
lines__$1 = G__38915;
relseg = G__38916;
result = G__38917;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__37976){
var vec__37977 = p__37976;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37977,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37977,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37977,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37977,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37977,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__37983){
var vec__37984 = p__37983;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37984,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37984,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37984,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37984,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37984,(4),null);
var seg = vec__37984;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__37988){
var vec__37989 = p__37988;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37989,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37989,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37989,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37989,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37989,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4120__auto__ = name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4120__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__38000 = cljs.core.seq(infos);
var chunk__38001 = null;
var count__38002 = (0);
var i__38003 = (0);
while(true){
if((i__38003 < count__38002)){
var info = chunk__38001.cljs$core$IIndexed$_nth$arity$2(null,i__38003);
var segv_38920 = info__GT_segv(info,source_idx,line,col);
var gline_38921 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_38922 = cljs.core.count(cljs.core.deref(lines));
if((gline_38921 > (lc_38922 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__38000,chunk__38001,count__38002,i__38003,segv_38920,gline_38921,lc_38922,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_38921 - (lc_38922 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_38920], null));
});})(seq__38000,chunk__38001,count__38002,i__38003,segv_38920,gline_38921,lc_38922,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__38000,chunk__38001,count__38002,i__38003,segv_38920,gline_38921,lc_38922,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_38921], null),cljs.core.conj,segv_38920);
});})(seq__38000,chunk__38001,count__38002,i__38003,segv_38920,gline_38921,lc_38922,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__38930 = seq__38000;
var G__38931 = chunk__38001;
var G__38932 = count__38002;
var G__38933 = (i__38003 + (1));
seq__38000 = G__38930;
chunk__38001 = G__38931;
count__38002 = G__38932;
i__38003 = G__38933;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__38000);
if(temp__5735__auto__){
var seq__38000__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38000__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__38000__$1);
var G__38934 = cljs.core.chunk_rest(seq__38000__$1);
var G__38935 = c__4550__auto__;
var G__38936 = cljs.core.count(c__4550__auto__);
var G__38937 = (0);
seq__38000 = G__38934;
chunk__38001 = G__38935;
count__38002 = G__38936;
i__38003 = G__38937;
continue;
} else {
var info = cljs.core.first(seq__38000__$1);
var segv_38938 = info__GT_segv(info,source_idx,line,col);
var gline_38939 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_38940 = cljs.core.count(cljs.core.deref(lines));
if((gline_38939 > (lc_38940 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__38000,chunk__38001,count__38002,i__38003,segv_38938,gline_38939,lc_38940,info,seq__38000__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_38939 - (lc_38940 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_38938], null));
});})(seq__38000,chunk__38001,count__38002,i__38003,segv_38938,gline_38939,lc_38940,info,seq__38000__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__38000,chunk__38001,count__38002,i__38003,segv_38938,gline_38939,lc_38940,info,seq__38000__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_38939], null),cljs.core.conj,segv_38938);
});})(seq__38000,chunk__38001,count__38002,i__38003,segv_38938,gline_38939,lc_38940,info,seq__38000__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__38944 = cljs.core.next(seq__38000__$1);
var G__38945 = null;
var G__38946 = (0);
var G__38947 = (0);
seq__38000 = G__38944;
chunk__38001 = G__38945;
count__38002 = G__38946;
i__38003 = G__38947;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__38016_38950 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__38017_38951 = null;
var count__38018_38952 = (0);
var i__38019_38953 = (0);
while(true){
if((i__38019_38953 < count__38018_38952)){
var vec__38228_38954 = chunk__38017_38951.cljs$core$IIndexed$_nth$arity$2(null,i__38019_38953);
var source_idx_38955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38228_38954,(0),null);
var vec__38231_38956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38228_38954,(1),null);
var __38957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38231_38956,(0),null);
var lines_38958__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38231_38956,(1),null);
var seq__38234_38959 = cljs.core.seq(lines_38958__$1);
var chunk__38235_38960 = null;
var count__38236_38961 = (0);
var i__38237_38962 = (0);
while(true){
if((i__38237_38962 < count__38236_38961)){
var vec__38280_38963 = chunk__38235_38960.cljs$core$IIndexed$_nth$arity$2(null,i__38237_38962);
var line_38964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38280_38963,(0),null);
var cols_38965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38280_38963,(1),null);
var seq__38283_38966 = cljs.core.seq(cols_38965);
var chunk__38284_38967 = null;
var count__38285_38968 = (0);
var i__38286_38969 = (0);
while(true){
if((i__38286_38969 < count__38285_38968)){
var vec__38293_38970 = chunk__38284_38967.cljs$core$IIndexed$_nth$arity$2(null,i__38286_38969);
var col_38971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38293_38970,(0),null);
var infos_38972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38293_38970,(1),null);
encode_cols(infos_38972,source_idx_38955,line_38964,col_38971);


var G__38973 = seq__38283_38966;
var G__38974 = chunk__38284_38967;
var G__38975 = count__38285_38968;
var G__38976 = (i__38286_38969 + (1));
seq__38283_38966 = G__38973;
chunk__38284_38967 = G__38974;
count__38285_38968 = G__38975;
i__38286_38969 = G__38976;
continue;
} else {
var temp__5735__auto___38977 = cljs.core.seq(seq__38283_38966);
if(temp__5735__auto___38977){
var seq__38283_38978__$1 = temp__5735__auto___38977;
if(cljs.core.chunked_seq_QMARK_(seq__38283_38978__$1)){
var c__4550__auto___38979 = cljs.core.chunk_first(seq__38283_38978__$1);
var G__38980 = cljs.core.chunk_rest(seq__38283_38978__$1);
var G__38981 = c__4550__auto___38979;
var G__38982 = cljs.core.count(c__4550__auto___38979);
var G__38983 = (0);
seq__38283_38966 = G__38980;
chunk__38284_38967 = G__38981;
count__38285_38968 = G__38982;
i__38286_38969 = G__38983;
continue;
} else {
var vec__38296_38984 = cljs.core.first(seq__38283_38978__$1);
var col_38985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38296_38984,(0),null);
var infos_38986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38296_38984,(1),null);
encode_cols(infos_38986,source_idx_38955,line_38964,col_38985);


var G__38987 = cljs.core.next(seq__38283_38978__$1);
var G__38988 = null;
var G__38989 = (0);
var G__38990 = (0);
seq__38283_38966 = G__38987;
chunk__38284_38967 = G__38988;
count__38285_38968 = G__38989;
i__38286_38969 = G__38990;
continue;
}
} else {
}
}
break;
}


var G__38991 = seq__38234_38959;
var G__38992 = chunk__38235_38960;
var G__38993 = count__38236_38961;
var G__38994 = (i__38237_38962 + (1));
seq__38234_38959 = G__38991;
chunk__38235_38960 = G__38992;
count__38236_38961 = G__38993;
i__38237_38962 = G__38994;
continue;
} else {
var temp__5735__auto___38995 = cljs.core.seq(seq__38234_38959);
if(temp__5735__auto___38995){
var seq__38234_38996__$1 = temp__5735__auto___38995;
if(cljs.core.chunked_seq_QMARK_(seq__38234_38996__$1)){
var c__4550__auto___38998 = cljs.core.chunk_first(seq__38234_38996__$1);
var G__38999 = cljs.core.chunk_rest(seq__38234_38996__$1);
var G__39000 = c__4550__auto___38998;
var G__39001 = cljs.core.count(c__4550__auto___38998);
var G__39002 = (0);
seq__38234_38959 = G__38999;
chunk__38235_38960 = G__39000;
count__38236_38961 = G__39001;
i__38237_38962 = G__39002;
continue;
} else {
var vec__38299_39006 = cljs.core.first(seq__38234_38996__$1);
var line_39007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38299_39006,(0),null);
var cols_39008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38299_39006,(1),null);
var seq__38302_39009 = cljs.core.seq(cols_39008);
var chunk__38303_39010 = null;
var count__38304_39011 = (0);
var i__38305_39012 = (0);
while(true){
if((i__38305_39012 < count__38304_39011)){
var vec__38312_39013 = chunk__38303_39010.cljs$core$IIndexed$_nth$arity$2(null,i__38305_39012);
var col_39014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38312_39013,(0),null);
var infos_39015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38312_39013,(1),null);
encode_cols(infos_39015,source_idx_38955,line_39007,col_39014);


var G__39022 = seq__38302_39009;
var G__39023 = chunk__38303_39010;
var G__39024 = count__38304_39011;
var G__39025 = (i__38305_39012 + (1));
seq__38302_39009 = G__39022;
chunk__38303_39010 = G__39023;
count__38304_39011 = G__39024;
i__38305_39012 = G__39025;
continue;
} else {
var temp__5735__auto___39026__$1 = cljs.core.seq(seq__38302_39009);
if(temp__5735__auto___39026__$1){
var seq__38302_39028__$1 = temp__5735__auto___39026__$1;
if(cljs.core.chunked_seq_QMARK_(seq__38302_39028__$1)){
var c__4550__auto___39029 = cljs.core.chunk_first(seq__38302_39028__$1);
var G__39034 = cljs.core.chunk_rest(seq__38302_39028__$1);
var G__39035 = c__4550__auto___39029;
var G__39036 = cljs.core.count(c__4550__auto___39029);
var G__39037 = (0);
seq__38302_39009 = G__39034;
chunk__38303_39010 = G__39035;
count__38304_39011 = G__39036;
i__38305_39012 = G__39037;
continue;
} else {
var vec__38315_39039 = cljs.core.first(seq__38302_39028__$1);
var col_39040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38315_39039,(0),null);
var infos_39041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38315_39039,(1),null);
encode_cols(infos_39041,source_idx_38955,line_39007,col_39040);


var G__39042 = cljs.core.next(seq__38302_39028__$1);
var G__39043 = null;
var G__39044 = (0);
var G__39045 = (0);
seq__38302_39009 = G__39042;
chunk__38303_39010 = G__39043;
count__38304_39011 = G__39044;
i__38305_39012 = G__39045;
continue;
}
} else {
}
}
break;
}


var G__39048 = cljs.core.next(seq__38234_38996__$1);
var G__39049 = null;
var G__39050 = (0);
var G__39051 = (0);
seq__38234_38959 = G__39048;
chunk__38235_38960 = G__39049;
count__38236_38961 = G__39050;
i__38237_38962 = G__39051;
continue;
}
} else {
}
}
break;
}


var G__39052 = seq__38016_38950;
var G__39053 = chunk__38017_38951;
var G__39054 = count__38018_38952;
var G__39055 = (i__38019_38953 + (1));
seq__38016_38950 = G__39052;
chunk__38017_38951 = G__39053;
count__38018_38952 = G__39054;
i__38019_38953 = G__39055;
continue;
} else {
var temp__5735__auto___39058 = cljs.core.seq(seq__38016_38950);
if(temp__5735__auto___39058){
var seq__38016_39060__$1 = temp__5735__auto___39058;
if(cljs.core.chunked_seq_QMARK_(seq__38016_39060__$1)){
var c__4550__auto___39061 = cljs.core.chunk_first(seq__38016_39060__$1);
var G__39062 = cljs.core.chunk_rest(seq__38016_39060__$1);
var G__39063 = c__4550__auto___39061;
var G__39064 = cljs.core.count(c__4550__auto___39061);
var G__39065 = (0);
seq__38016_38950 = G__39062;
chunk__38017_38951 = G__39063;
count__38018_38952 = G__39064;
i__38019_38953 = G__39065;
continue;
} else {
var vec__38318_39066 = cljs.core.first(seq__38016_39060__$1);
var source_idx_39067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38318_39066,(0),null);
var vec__38321_39068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38318_39066,(1),null);
var __39069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38321_39068,(0),null);
var lines_39070__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38321_39068,(1),null);
var seq__38324_39071 = cljs.core.seq(lines_39070__$1);
var chunk__38325_39072 = null;
var count__38326_39073 = (0);
var i__38327_39074 = (0);
while(true){
if((i__38327_39074 < count__38326_39073)){
var vec__38373_39075 = chunk__38325_39072.cljs$core$IIndexed$_nth$arity$2(null,i__38327_39074);
var line_39076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38373_39075,(0),null);
var cols_39077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38373_39075,(1),null);
var seq__38376_39084 = cljs.core.seq(cols_39077);
var chunk__38377_39085 = null;
var count__38378_39086 = (0);
var i__38379_39087 = (0);
while(true){
if((i__38379_39087 < count__38378_39086)){
var vec__38386_39089 = chunk__38377_39085.cljs$core$IIndexed$_nth$arity$2(null,i__38379_39087);
var col_39090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38386_39089,(0),null);
var infos_39091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38386_39089,(1),null);
encode_cols(infos_39091,source_idx_39067,line_39076,col_39090);


var G__39092 = seq__38376_39084;
var G__39093 = chunk__38377_39085;
var G__39094 = count__38378_39086;
var G__39095 = (i__38379_39087 + (1));
seq__38376_39084 = G__39092;
chunk__38377_39085 = G__39093;
count__38378_39086 = G__39094;
i__38379_39087 = G__39095;
continue;
} else {
var temp__5735__auto___39098__$1 = cljs.core.seq(seq__38376_39084);
if(temp__5735__auto___39098__$1){
var seq__38376_39099__$1 = temp__5735__auto___39098__$1;
if(cljs.core.chunked_seq_QMARK_(seq__38376_39099__$1)){
var c__4550__auto___39100 = cljs.core.chunk_first(seq__38376_39099__$1);
var G__39101 = cljs.core.chunk_rest(seq__38376_39099__$1);
var G__39102 = c__4550__auto___39100;
var G__39103 = cljs.core.count(c__4550__auto___39100);
var G__39104 = (0);
seq__38376_39084 = G__39101;
chunk__38377_39085 = G__39102;
count__38378_39086 = G__39103;
i__38379_39087 = G__39104;
continue;
} else {
var vec__38392_39105 = cljs.core.first(seq__38376_39099__$1);
var col_39106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38392_39105,(0),null);
var infos_39107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38392_39105,(1),null);
encode_cols(infos_39107,source_idx_39067,line_39076,col_39106);


var G__39110 = cljs.core.next(seq__38376_39099__$1);
var G__39111 = null;
var G__39112 = (0);
var G__39113 = (0);
seq__38376_39084 = G__39110;
chunk__38377_39085 = G__39111;
count__38378_39086 = G__39112;
i__38379_39087 = G__39113;
continue;
}
} else {
}
}
break;
}


var G__39114 = seq__38324_39071;
var G__39115 = chunk__38325_39072;
var G__39116 = count__38326_39073;
var G__39117 = (i__38327_39074 + (1));
seq__38324_39071 = G__39114;
chunk__38325_39072 = G__39115;
count__38326_39073 = G__39116;
i__38327_39074 = G__39117;
continue;
} else {
var temp__5735__auto___39119__$1 = cljs.core.seq(seq__38324_39071);
if(temp__5735__auto___39119__$1){
var seq__38324_39120__$1 = temp__5735__auto___39119__$1;
if(cljs.core.chunked_seq_QMARK_(seq__38324_39120__$1)){
var c__4550__auto___39121 = cljs.core.chunk_first(seq__38324_39120__$1);
var G__39122 = cljs.core.chunk_rest(seq__38324_39120__$1);
var G__39123 = c__4550__auto___39121;
var G__39124 = cljs.core.count(c__4550__auto___39121);
var G__39125 = (0);
seq__38324_39071 = G__39122;
chunk__38325_39072 = G__39123;
count__38326_39073 = G__39124;
i__38327_39074 = G__39125;
continue;
} else {
var vec__38396_39128 = cljs.core.first(seq__38324_39120__$1);
var line_39129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38396_39128,(0),null);
var cols_39130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38396_39128,(1),null);
var seq__38400_39131 = cljs.core.seq(cols_39130);
var chunk__38401_39132 = null;
var count__38402_39133 = (0);
var i__38403_39134 = (0);
while(true){
if((i__38403_39134 < count__38402_39133)){
var vec__38410_39137 = chunk__38401_39132.cljs$core$IIndexed$_nth$arity$2(null,i__38403_39134);
var col_39138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38410_39137,(0),null);
var infos_39139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38410_39137,(1),null);
encode_cols(infos_39139,source_idx_39067,line_39129,col_39138);


var G__39140 = seq__38400_39131;
var G__39141 = chunk__38401_39132;
var G__39142 = count__38402_39133;
var G__39143 = (i__38403_39134 + (1));
seq__38400_39131 = G__39140;
chunk__38401_39132 = G__39141;
count__38402_39133 = G__39142;
i__38403_39134 = G__39143;
continue;
} else {
var temp__5735__auto___39144__$2 = cljs.core.seq(seq__38400_39131);
if(temp__5735__auto___39144__$2){
var seq__38400_39146__$1 = temp__5735__auto___39144__$2;
if(cljs.core.chunked_seq_QMARK_(seq__38400_39146__$1)){
var c__4550__auto___39147 = cljs.core.chunk_first(seq__38400_39146__$1);
var G__39151 = cljs.core.chunk_rest(seq__38400_39146__$1);
var G__39152 = c__4550__auto___39147;
var G__39153 = cljs.core.count(c__4550__auto___39147);
var G__39154 = (0);
seq__38400_39131 = G__39151;
chunk__38401_39132 = G__39152;
count__38402_39133 = G__39153;
i__38403_39134 = G__39154;
continue;
} else {
var vec__38413_39155 = cljs.core.first(seq__38400_39146__$1);
var col_39156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38413_39155,(0),null);
var infos_39157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38413_39155,(1),null);
encode_cols(infos_39157,source_idx_39067,line_39129,col_39156);


var G__39160 = cljs.core.next(seq__38400_39146__$1);
var G__39161 = null;
var G__39162 = (0);
var G__39163 = (0);
seq__38400_39131 = G__39160;
chunk__38401_39132 = G__39161;
count__38402_39133 = G__39162;
i__38403_39134 = G__39163;
continue;
}
} else {
}
}
break;
}


var G__39164 = cljs.core.next(seq__38324_39120__$1);
var G__39165 = null;
var G__39166 = (0);
var G__39167 = (0);
seq__38324_39071 = G__39164;
chunk__38325_39072 = G__39165;
count__38326_39073 = G__39166;
i__38327_39074 = G__39167;
continue;
}
} else {
}
}
break;
}


var G__39170 = cljs.core.next(seq__38016_39060__$1);
var G__39171 = null;
var G__39172 = (0);
var G__39173 = (0);
seq__38016_38950 = G__39170;
chunk__38017_38951 = G__39171;
count__38018_38952 = G__39172;
i__38019_38953 = G__39173;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__38416 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__37996_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37996_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__37997_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__37997_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37998_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__37998_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__38419 = G__38416;
goog.object.set(G__38419,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__38419;
} else {
return G__38416;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__38423 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38423,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38423,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__38427 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38427,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38427,(1),null);
var G__39177 = cljs.core.next(col_map_seq);
var G__39178 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__38427,col,infos,vec__38423,line,col_map){
return (function (v,p__38430){
var map__38431 = p__38430;
var map__38431__$1 = (((((!((map__38431 == null))))?(((((map__38431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38431):map__38431);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38431__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38431__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__38427,col,infos,vec__38423,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__39177;
new_cols = G__39178;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__39182 = cljs.core.next(line_map_seq);
var G__39183 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__39182;
new_lines = G__39183;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__38433_39184 = cljs.core.seq(reverse_map);
var chunk__38434_39185 = null;
var count__38435_39186 = (0);
var i__38436_39187 = (0);
while(true){
if((i__38436_39187 < count__38435_39186)){
var vec__38627_39188 = chunk__38434_39185.cljs$core$IIndexed$_nth$arity$2(null,i__38436_39187);
var line_39189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38627_39188,(0),null);
var columns_39190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38627_39188,(1),null);
var seq__38630_39191 = cljs.core.seq(columns_39190);
var chunk__38631_39192 = null;
var count__38632_39193 = (0);
var i__38633_39194 = (0);
while(true){
if((i__38633_39194 < count__38632_39193)){
var vec__38689_39195 = chunk__38631_39192.cljs$core$IIndexed$_nth$arity$2(null,i__38633_39194);
var column_39196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38689_39195,(0),null);
var column_info_39197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38689_39195,(1),null);
var seq__38692_39198 = cljs.core.seq(column_info_39197);
var chunk__38693_39199 = null;
var count__38694_39200 = (0);
var i__38695_39201 = (0);
while(true){
if((i__38695_39201 < count__38694_39200)){
var map__38712_39202 = chunk__38693_39199.cljs$core$IIndexed$_nth$arity$2(null,i__38695_39201);
var map__38712_39203__$1 = (((((!((map__38712_39202 == null))))?(((((map__38712_39202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38712_39202.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38712_39202):map__38712_39202);
var gline_39204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38712_39203__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38712_39203__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38712_39203__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39204], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38692_39198,chunk__38693_39199,count__38694_39200,i__38695_39201,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38712_39202,map__38712_39203__$1,gline_39204,gcol_39205,name_39206,vec__38689_39195,column_39196,column_info_39197,vec__38627_39188,line_39189,columns_39190,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39205], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39189,new cljs.core.Keyword(null,"col","col",-1959363084),column_39196,new cljs.core.Keyword(null,"name","name",1843675177),name_39206], null));
});})(seq__38692_39198,chunk__38693_39199,count__38694_39200,i__38695_39201,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38712_39202,map__38712_39203__$1,gline_39204,gcol_39205,name_39206,vec__38689_39195,column_39196,column_info_39197,vec__38627_39188,line_39189,columns_39190,inverted))
,cljs.core.sorted_map()));


var G__39210 = seq__38692_39198;
var G__39211 = chunk__38693_39199;
var G__39212 = count__38694_39200;
var G__39213 = (i__38695_39201 + (1));
seq__38692_39198 = G__39210;
chunk__38693_39199 = G__39211;
count__38694_39200 = G__39212;
i__38695_39201 = G__39213;
continue;
} else {
var temp__5735__auto___39214 = cljs.core.seq(seq__38692_39198);
if(temp__5735__auto___39214){
var seq__38692_39215__$1 = temp__5735__auto___39214;
if(cljs.core.chunked_seq_QMARK_(seq__38692_39215__$1)){
var c__4550__auto___39216 = cljs.core.chunk_first(seq__38692_39215__$1);
var G__39217 = cljs.core.chunk_rest(seq__38692_39215__$1);
var G__39218 = c__4550__auto___39216;
var G__39219 = cljs.core.count(c__4550__auto___39216);
var G__39220 = (0);
seq__38692_39198 = G__39217;
chunk__38693_39199 = G__39218;
count__38694_39200 = G__39219;
i__38695_39201 = G__39220;
continue;
} else {
var map__38722_39223 = cljs.core.first(seq__38692_39215__$1);
var map__38722_39224__$1 = (((((!((map__38722_39223 == null))))?(((((map__38722_39223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38722_39223.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38722_39223):map__38722_39223);
var gline_39225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38722_39224__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38722_39224__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38722_39224__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39225], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38692_39198,chunk__38693_39199,count__38694_39200,i__38695_39201,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38722_39223,map__38722_39224__$1,gline_39225,gcol_39226,name_39227,seq__38692_39215__$1,temp__5735__auto___39214,vec__38689_39195,column_39196,column_info_39197,vec__38627_39188,line_39189,columns_39190,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39226], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39189,new cljs.core.Keyword(null,"col","col",-1959363084),column_39196,new cljs.core.Keyword(null,"name","name",1843675177),name_39227], null));
});})(seq__38692_39198,chunk__38693_39199,count__38694_39200,i__38695_39201,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38722_39223,map__38722_39224__$1,gline_39225,gcol_39226,name_39227,seq__38692_39215__$1,temp__5735__auto___39214,vec__38689_39195,column_39196,column_info_39197,vec__38627_39188,line_39189,columns_39190,inverted))
,cljs.core.sorted_map()));


var G__39234 = cljs.core.next(seq__38692_39215__$1);
var G__39235 = null;
var G__39236 = (0);
var G__39237 = (0);
seq__38692_39198 = G__39234;
chunk__38693_39199 = G__39235;
count__38694_39200 = G__39236;
i__38695_39201 = G__39237;
continue;
}
} else {
}
}
break;
}


var G__39238 = seq__38630_39191;
var G__39239 = chunk__38631_39192;
var G__39240 = count__38632_39193;
var G__39241 = (i__38633_39194 + (1));
seq__38630_39191 = G__39238;
chunk__38631_39192 = G__39239;
count__38632_39193 = G__39240;
i__38633_39194 = G__39241;
continue;
} else {
var temp__5735__auto___39242 = cljs.core.seq(seq__38630_39191);
if(temp__5735__auto___39242){
var seq__38630_39243__$1 = temp__5735__auto___39242;
if(cljs.core.chunked_seq_QMARK_(seq__38630_39243__$1)){
var c__4550__auto___39244 = cljs.core.chunk_first(seq__38630_39243__$1);
var G__39245 = cljs.core.chunk_rest(seq__38630_39243__$1);
var G__39246 = c__4550__auto___39244;
var G__39247 = cljs.core.count(c__4550__auto___39244);
var G__39248 = (0);
seq__38630_39191 = G__39245;
chunk__38631_39192 = G__39246;
count__38632_39193 = G__39247;
i__38633_39194 = G__39248;
continue;
} else {
var vec__38730_39249 = cljs.core.first(seq__38630_39243__$1);
var column_39250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38730_39249,(0),null);
var column_info_39251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38730_39249,(1),null);
var seq__38733_39252 = cljs.core.seq(column_info_39251);
var chunk__38734_39253 = null;
var count__38735_39254 = (0);
var i__38736_39255 = (0);
while(true){
if((i__38736_39255 < count__38735_39254)){
var map__38743_39256 = chunk__38734_39253.cljs$core$IIndexed$_nth$arity$2(null,i__38736_39255);
var map__38743_39257__$1 = (((((!((map__38743_39256 == null))))?(((((map__38743_39256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38743_39256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38743_39256):map__38743_39256);
var gline_39258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38743_39257__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38743_39257__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38743_39257__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39258], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38733_39252,chunk__38734_39253,count__38735_39254,i__38736_39255,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38743_39256,map__38743_39257__$1,gline_39258,gcol_39259,name_39260,vec__38730_39249,column_39250,column_info_39251,seq__38630_39243__$1,temp__5735__auto___39242,vec__38627_39188,line_39189,columns_39190,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39259], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39189,new cljs.core.Keyword(null,"col","col",-1959363084),column_39250,new cljs.core.Keyword(null,"name","name",1843675177),name_39260], null));
});})(seq__38733_39252,chunk__38734_39253,count__38735_39254,i__38736_39255,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38743_39256,map__38743_39257__$1,gline_39258,gcol_39259,name_39260,vec__38730_39249,column_39250,column_info_39251,seq__38630_39243__$1,temp__5735__auto___39242,vec__38627_39188,line_39189,columns_39190,inverted))
,cljs.core.sorted_map()));


var G__39272 = seq__38733_39252;
var G__39273 = chunk__38734_39253;
var G__39274 = count__38735_39254;
var G__39275 = (i__38736_39255 + (1));
seq__38733_39252 = G__39272;
chunk__38734_39253 = G__39273;
count__38735_39254 = G__39274;
i__38736_39255 = G__39275;
continue;
} else {
var temp__5735__auto___39276__$1 = cljs.core.seq(seq__38733_39252);
if(temp__5735__auto___39276__$1){
var seq__38733_39278__$1 = temp__5735__auto___39276__$1;
if(cljs.core.chunked_seq_QMARK_(seq__38733_39278__$1)){
var c__4550__auto___39279 = cljs.core.chunk_first(seq__38733_39278__$1);
var G__39280 = cljs.core.chunk_rest(seq__38733_39278__$1);
var G__39281 = c__4550__auto___39279;
var G__39282 = cljs.core.count(c__4550__auto___39279);
var G__39283 = (0);
seq__38733_39252 = G__39280;
chunk__38734_39253 = G__39281;
count__38735_39254 = G__39282;
i__38736_39255 = G__39283;
continue;
} else {
var map__38757_39284 = cljs.core.first(seq__38733_39278__$1);
var map__38757_39285__$1 = (((((!((map__38757_39284 == null))))?(((((map__38757_39284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38757_39284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38757_39284):map__38757_39284);
var gline_39286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38757_39285__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38757_39285__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38757_39285__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39286], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38733_39252,chunk__38734_39253,count__38735_39254,i__38736_39255,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38757_39284,map__38757_39285__$1,gline_39286,gcol_39287,name_39288,seq__38733_39278__$1,temp__5735__auto___39276__$1,vec__38730_39249,column_39250,column_info_39251,seq__38630_39243__$1,temp__5735__auto___39242,vec__38627_39188,line_39189,columns_39190,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39287], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39189,new cljs.core.Keyword(null,"col","col",-1959363084),column_39250,new cljs.core.Keyword(null,"name","name",1843675177),name_39288], null));
});})(seq__38733_39252,chunk__38734_39253,count__38735_39254,i__38736_39255,seq__38630_39191,chunk__38631_39192,count__38632_39193,i__38633_39194,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38757_39284,map__38757_39285__$1,gline_39286,gcol_39287,name_39288,seq__38733_39278__$1,temp__5735__auto___39276__$1,vec__38730_39249,column_39250,column_info_39251,seq__38630_39243__$1,temp__5735__auto___39242,vec__38627_39188,line_39189,columns_39190,inverted))
,cljs.core.sorted_map()));


var G__39291 = cljs.core.next(seq__38733_39278__$1);
var G__39292 = null;
var G__39293 = (0);
var G__39294 = (0);
seq__38733_39252 = G__39291;
chunk__38734_39253 = G__39292;
count__38735_39254 = G__39293;
i__38736_39255 = G__39294;
continue;
}
} else {
}
}
break;
}


var G__39295 = cljs.core.next(seq__38630_39243__$1);
var G__39296 = null;
var G__39297 = (0);
var G__39298 = (0);
seq__38630_39191 = G__39295;
chunk__38631_39192 = G__39296;
count__38632_39193 = G__39297;
i__38633_39194 = G__39298;
continue;
}
} else {
}
}
break;
}


var G__39299 = seq__38433_39184;
var G__39300 = chunk__38434_39185;
var G__39301 = count__38435_39186;
var G__39302 = (i__38436_39187 + (1));
seq__38433_39184 = G__39299;
chunk__38434_39185 = G__39300;
count__38435_39186 = G__39301;
i__38436_39187 = G__39302;
continue;
} else {
var temp__5735__auto___39303 = cljs.core.seq(seq__38433_39184);
if(temp__5735__auto___39303){
var seq__38433_39304__$1 = temp__5735__auto___39303;
if(cljs.core.chunked_seq_QMARK_(seq__38433_39304__$1)){
var c__4550__auto___39305 = cljs.core.chunk_first(seq__38433_39304__$1);
var G__39306 = cljs.core.chunk_rest(seq__38433_39304__$1);
var G__39307 = c__4550__auto___39305;
var G__39308 = cljs.core.count(c__4550__auto___39305);
var G__39309 = (0);
seq__38433_39184 = G__39306;
chunk__38434_39185 = G__39307;
count__38435_39186 = G__39308;
i__38436_39187 = G__39309;
continue;
} else {
var vec__38764_39310 = cljs.core.first(seq__38433_39304__$1);
var line_39311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38764_39310,(0),null);
var columns_39312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38764_39310,(1),null);
var seq__38767_39313 = cljs.core.seq(columns_39312);
var chunk__38768_39314 = null;
var count__38769_39315 = (0);
var i__38770_39316 = (0);
while(true){
if((i__38770_39316 < count__38769_39315)){
var vec__38841_39317 = chunk__38768_39314.cljs$core$IIndexed$_nth$arity$2(null,i__38770_39316);
var column_39318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38841_39317,(0),null);
var column_info_39319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38841_39317,(1),null);
var seq__38845_39321 = cljs.core.seq(column_info_39319);
var chunk__38846_39322 = null;
var count__38847_39323 = (0);
var i__38848_39324 = (0);
while(true){
if((i__38848_39324 < count__38847_39323)){
var map__38853_39325 = chunk__38846_39322.cljs$core$IIndexed$_nth$arity$2(null,i__38848_39324);
var map__38853_39326__$1 = (((((!((map__38853_39325 == null))))?(((((map__38853_39325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38853_39325.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38853_39325):map__38853_39325);
var gline_39327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38853_39326__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38853_39326__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38853_39326__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39327], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38845_39321,chunk__38846_39322,count__38847_39323,i__38848_39324,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38853_39325,map__38853_39326__$1,gline_39327,gcol_39328,name_39329,vec__38841_39317,column_39318,column_info_39319,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39328], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39311,new cljs.core.Keyword(null,"col","col",-1959363084),column_39318,new cljs.core.Keyword(null,"name","name",1843675177),name_39329], null));
});})(seq__38845_39321,chunk__38846_39322,count__38847_39323,i__38848_39324,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38853_39325,map__38853_39326__$1,gline_39327,gcol_39328,name_39329,vec__38841_39317,column_39318,column_info_39319,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted))
,cljs.core.sorted_map()));


var G__39339 = seq__38845_39321;
var G__39340 = chunk__38846_39322;
var G__39341 = count__38847_39323;
var G__39342 = (i__38848_39324 + (1));
seq__38845_39321 = G__39339;
chunk__38846_39322 = G__39340;
count__38847_39323 = G__39341;
i__38848_39324 = G__39342;
continue;
} else {
var temp__5735__auto___39343__$1 = cljs.core.seq(seq__38845_39321);
if(temp__5735__auto___39343__$1){
var seq__38845_39344__$1 = temp__5735__auto___39343__$1;
if(cljs.core.chunked_seq_QMARK_(seq__38845_39344__$1)){
var c__4550__auto___39345 = cljs.core.chunk_first(seq__38845_39344__$1);
var G__39346 = cljs.core.chunk_rest(seq__38845_39344__$1);
var G__39347 = c__4550__auto___39345;
var G__39348 = cljs.core.count(c__4550__auto___39345);
var G__39349 = (0);
seq__38845_39321 = G__39346;
chunk__38846_39322 = G__39347;
count__38847_39323 = G__39348;
i__38848_39324 = G__39349;
continue;
} else {
var map__38856_39350 = cljs.core.first(seq__38845_39344__$1);
var map__38856_39351__$1 = (((((!((map__38856_39350 == null))))?(((((map__38856_39350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38856_39350.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38856_39350):map__38856_39350);
var gline_39352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38856_39351__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38856_39351__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39354 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38856_39351__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39352], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38845_39321,chunk__38846_39322,count__38847_39323,i__38848_39324,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38856_39350,map__38856_39351__$1,gline_39352,gcol_39353,name_39354,seq__38845_39344__$1,temp__5735__auto___39343__$1,vec__38841_39317,column_39318,column_info_39319,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39353], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39311,new cljs.core.Keyword(null,"col","col",-1959363084),column_39318,new cljs.core.Keyword(null,"name","name",1843675177),name_39354], null));
});})(seq__38845_39321,chunk__38846_39322,count__38847_39323,i__38848_39324,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38856_39350,map__38856_39351__$1,gline_39352,gcol_39353,name_39354,seq__38845_39344__$1,temp__5735__auto___39343__$1,vec__38841_39317,column_39318,column_info_39319,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted))
,cljs.core.sorted_map()));


var G__39359 = cljs.core.next(seq__38845_39344__$1);
var G__39360 = null;
var G__39361 = (0);
var G__39362 = (0);
seq__38845_39321 = G__39359;
chunk__38846_39322 = G__39360;
count__38847_39323 = G__39361;
i__38848_39324 = G__39362;
continue;
}
} else {
}
}
break;
}


var G__39363 = seq__38767_39313;
var G__39364 = chunk__38768_39314;
var G__39365 = count__38769_39315;
var G__39366 = (i__38770_39316 + (1));
seq__38767_39313 = G__39363;
chunk__38768_39314 = G__39364;
count__38769_39315 = G__39365;
i__38770_39316 = G__39366;
continue;
} else {
var temp__5735__auto___39367__$1 = cljs.core.seq(seq__38767_39313);
if(temp__5735__auto___39367__$1){
var seq__38767_39368__$1 = temp__5735__auto___39367__$1;
if(cljs.core.chunked_seq_QMARK_(seq__38767_39368__$1)){
var c__4550__auto___39369 = cljs.core.chunk_first(seq__38767_39368__$1);
var G__39370 = cljs.core.chunk_rest(seq__38767_39368__$1);
var G__39371 = c__4550__auto___39369;
var G__39372 = cljs.core.count(c__4550__auto___39369);
var G__39373 = (0);
seq__38767_39313 = G__39370;
chunk__38768_39314 = G__39371;
count__38769_39315 = G__39372;
i__38770_39316 = G__39373;
continue;
} else {
var vec__38858_39374 = cljs.core.first(seq__38767_39368__$1);
var column_39375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38858_39374,(0),null);
var column_info_39376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38858_39374,(1),null);
var seq__38861_39381 = cljs.core.seq(column_info_39376);
var chunk__38862_39382 = null;
var count__38863_39383 = (0);
var i__38864_39384 = (0);
while(true){
if((i__38864_39384 < count__38863_39383)){
var map__38869_39385 = chunk__38862_39382.cljs$core$IIndexed$_nth$arity$2(null,i__38864_39384);
var map__38869_39386__$1 = (((((!((map__38869_39385 == null))))?(((((map__38869_39385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38869_39385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38869_39385):map__38869_39385);
var gline_39387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38869_39386__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38869_39386__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39389 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38869_39386__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39387], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38861_39381,chunk__38862_39382,count__38863_39383,i__38864_39384,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38869_39385,map__38869_39386__$1,gline_39387,gcol_39388,name_39389,vec__38858_39374,column_39375,column_info_39376,seq__38767_39368__$1,temp__5735__auto___39367__$1,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39388], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39311,new cljs.core.Keyword(null,"col","col",-1959363084),column_39375,new cljs.core.Keyword(null,"name","name",1843675177),name_39389], null));
});})(seq__38861_39381,chunk__38862_39382,count__38863_39383,i__38864_39384,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38869_39385,map__38869_39386__$1,gline_39387,gcol_39388,name_39389,vec__38858_39374,column_39375,column_info_39376,seq__38767_39368__$1,temp__5735__auto___39367__$1,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted))
,cljs.core.sorted_map()));


var G__39397 = seq__38861_39381;
var G__39398 = chunk__38862_39382;
var G__39399 = count__38863_39383;
var G__39400 = (i__38864_39384 + (1));
seq__38861_39381 = G__39397;
chunk__38862_39382 = G__39398;
count__38863_39383 = G__39399;
i__38864_39384 = G__39400;
continue;
} else {
var temp__5735__auto___39401__$2 = cljs.core.seq(seq__38861_39381);
if(temp__5735__auto___39401__$2){
var seq__38861_39404__$1 = temp__5735__auto___39401__$2;
if(cljs.core.chunked_seq_QMARK_(seq__38861_39404__$1)){
var c__4550__auto___39405 = cljs.core.chunk_first(seq__38861_39404__$1);
var G__39406 = cljs.core.chunk_rest(seq__38861_39404__$1);
var G__39407 = c__4550__auto___39405;
var G__39408 = cljs.core.count(c__4550__auto___39405);
var G__39409 = (0);
seq__38861_39381 = G__39406;
chunk__38862_39382 = G__39407;
count__38863_39383 = G__39408;
i__38864_39384 = G__39409;
continue;
} else {
var map__38871_39410 = cljs.core.first(seq__38861_39404__$1);
var map__38871_39411__$1 = (((((!((map__38871_39410 == null))))?(((((map__38871_39410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38871_39410.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38871_39410):map__38871_39410);
var gline_39412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38871_39411__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_39413 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38871_39411__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_39414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38871_39411__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39412], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__38861_39381,chunk__38862_39382,count__38863_39383,i__38864_39384,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38871_39410,map__38871_39411__$1,gline_39412,gcol_39413,name_39414,seq__38861_39404__$1,temp__5735__auto___39401__$2,vec__38858_39374,column_39375,column_info_39376,seq__38767_39368__$1,temp__5735__auto___39367__$1,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_39413], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_39311,new cljs.core.Keyword(null,"col","col",-1959363084),column_39375,new cljs.core.Keyword(null,"name","name",1843675177),name_39414], null));
});})(seq__38861_39381,chunk__38862_39382,count__38863_39383,i__38864_39384,seq__38767_39313,chunk__38768_39314,count__38769_39315,i__38770_39316,seq__38433_39184,chunk__38434_39185,count__38435_39186,i__38436_39187,map__38871_39410,map__38871_39411__$1,gline_39412,gcol_39413,name_39414,seq__38861_39404__$1,temp__5735__auto___39401__$2,vec__38858_39374,column_39375,column_info_39376,seq__38767_39368__$1,temp__5735__auto___39367__$1,vec__38764_39310,line_39311,columns_39312,seq__38433_39304__$1,temp__5735__auto___39303,inverted))
,cljs.core.sorted_map()));


var G__39417 = cljs.core.next(seq__38861_39404__$1);
var G__39418 = null;
var G__39419 = (0);
var G__39420 = (0);
seq__38861_39381 = G__39417;
chunk__38862_39382 = G__39418;
count__38863_39383 = G__39419;
i__38864_39384 = G__39420;
continue;
}
} else {
}
}
break;
}


var G__39421 = cljs.core.next(seq__38767_39368__$1);
var G__39422 = null;
var G__39423 = (0);
var G__39424 = (0);
seq__38767_39313 = G__39421;
chunk__38768_39314 = G__39422;
count__38769_39315 = G__39423;
i__38770_39316 = G__39424;
continue;
}
} else {
}
}
break;
}


var G__39425 = cljs.core.next(seq__38433_39304__$1);
var G__39426 = null;
var G__39427 = (0);
var G__39428 = (0);
seq__38433_39184 = G__39425;
chunk__38434_39185 = G__39426;
count__38435_39186 = G__39427;
i__38436_39187 = G__39428;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
