goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__38977){
var vec__38978 = p__38977;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__38981 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__38984 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(4),null);
var vec__38987 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__38990 = segmap;
var map__38990__$1 = (((((!((map__38990 == null))))?(((((map__38990.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38990.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38990):map__38990);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__38997 = arguments.length;
switch (G__38997) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39001 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39948 = cljs.core.next(segs__$1);
var G__39949 = nrelseg;
var G__39950 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39948;
relseg__$1 = G__39949;
result__$1 = G__39950;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39001,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39001,(1),null);
var G__39951 = (gline + (1));
var G__39952 = cljs.core.next(lines__$1);
var G__39953 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39954 = result__$1;
gline = G__39951;
lines__$1 = G__39952;
relseg = G__39953;
result = G__39954;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__39009 = segmap;
var map__39009__$1 = (((((!((map__39009 == null))))?(((((map__39009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39009.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39009):map__39009);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39009__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39009__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39009__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39009__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39009__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__39008_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39008_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__39019 = arguments.length;
switch (G__39019) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39031 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39961 = cljs.core.next(segs__$1);
var G__39962 = nrelseg;
var G__39963 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39961;
relseg__$1 = G__39962;
result__$1 = G__39963;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39031,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39031,(1),null);
var G__39964 = (gline + (1));
var G__39965 = cljs.core.next(lines__$1);
var G__39966 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39967 = result__$1;
gline = G__39964;
lines__$1 = G__39965;
relseg = G__39966;
result = G__39967;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39041){
var vec__39042 = p__39041;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__39045){
var vec__39048 = p__39045;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39048,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39048,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39048,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39048,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39048,(4),null);
var seg = vec__39048;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39053){
var vec__39054 = p__39053;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__39061 = cljs.core.seq(infos);
var chunk__39062 = null;
var count__39063 = (0);
var i__39064 = (0);
while(true){
if((i__39064 < count__39063)){
var info = chunk__39062.cljs$core$IIndexed$_nth$arity$2(null,i__39064);
var segv_39982 = info__GT_segv(info,source_idx,line,col);
var gline_39983 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39984 = cljs.core.count(cljs.core.deref(lines));
if((gline_39983 > (lc_39984 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39982,gline_39983,lc_39984,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39983 - (lc_39984 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39982], null));
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39982,gline_39983,lc_39984,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39982,gline_39983,lc_39984,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39983], null),cljs.core.conj,segv_39982);
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39982,gline_39983,lc_39984,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39988 = seq__39061;
var G__39989 = chunk__39062;
var G__39990 = count__39063;
var G__39991 = (i__39064 + (1));
seq__39061 = G__39988;
chunk__39062 = G__39989;
count__39063 = G__39990;
i__39064 = G__39991;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39061);
if(temp__5735__auto__){
var seq__39061__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39061__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39061__$1);
var G__39992 = cljs.core.chunk_rest(seq__39061__$1);
var G__39993 = c__4609__auto__;
var G__39994 = cljs.core.count(c__4609__auto__);
var G__39995 = (0);
seq__39061 = G__39992;
chunk__39062 = G__39993;
count__39063 = G__39994;
i__39064 = G__39995;
continue;
} else {
var info = cljs.core.first(seq__39061__$1);
var segv_39996 = info__GT_segv(info,source_idx,line,col);
var gline_39997 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39998 = cljs.core.count(cljs.core.deref(lines));
if((gline_39997 > (lc_39998 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39996,gline_39997,lc_39998,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39997 - (lc_39998 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39996], null));
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39996,gline_39997,lc_39998,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39996,gline_39997,lc_39998,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39997], null),cljs.core.conj,segv_39996);
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39996,gline_39997,lc_39998,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39999 = cljs.core.next(seq__39061__$1);
var G__40000 = null;
var G__40001 = (0);
var G__40002 = (0);
seq__39061 = G__39999;
chunk__39062 = G__40000;
count__39063 = G__40001;
i__39064 = G__40002;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__39075_40003 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__39076_40004 = null;
var count__39077_40005 = (0);
var i__39078_40006 = (0);
while(true){
if((i__39078_40006 < count__39077_40005)){
var vec__39286_40008 = chunk__39076_40004.cljs$core$IIndexed$_nth$arity$2(null,i__39078_40006);
var source_idx_40009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39286_40008,(0),null);
var vec__39289_40010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39286_40008,(1),null);
var __40011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39289_40010,(0),null);
var lines_40012__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39289_40010,(1),null);
var seq__39292_40013 = cljs.core.seq(lines_40012__$1);
var chunk__39293_40014 = null;
var count__39294_40015 = (0);
var i__39295_40016 = (0);
while(true){
if((i__39295_40016 < count__39294_40015)){
var vec__39339_40017 = chunk__39293_40014.cljs$core$IIndexed$_nth$arity$2(null,i__39295_40016);
var line_40018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39339_40017,(0),null);
var cols_40019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39339_40017,(1),null);
var seq__39342_40020 = cljs.core.seq(cols_40019);
var chunk__39343_40021 = null;
var count__39344_40022 = (0);
var i__39345_40023 = (0);
while(true){
if((i__39345_40023 < count__39344_40022)){
var vec__39354_40024 = chunk__39343_40021.cljs$core$IIndexed$_nth$arity$2(null,i__39345_40023);
var col_40025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39354_40024,(0),null);
var infos_40026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39354_40024,(1),null);
encode_cols(infos_40026,source_idx_40009,line_40018,col_40025);


var G__40027 = seq__39342_40020;
var G__40028 = chunk__39343_40021;
var G__40029 = count__39344_40022;
var G__40030 = (i__39345_40023 + (1));
seq__39342_40020 = G__40027;
chunk__39343_40021 = G__40028;
count__39344_40022 = G__40029;
i__39345_40023 = G__40030;
continue;
} else {
var temp__5735__auto___40032 = cljs.core.seq(seq__39342_40020);
if(temp__5735__auto___40032){
var seq__39342_40033__$1 = temp__5735__auto___40032;
if(cljs.core.chunked_seq_QMARK_(seq__39342_40033__$1)){
var c__4609__auto___40034 = cljs.core.chunk_first(seq__39342_40033__$1);
var G__40035 = cljs.core.chunk_rest(seq__39342_40033__$1);
var G__40036 = c__4609__auto___40034;
var G__40037 = cljs.core.count(c__4609__auto___40034);
var G__40038 = (0);
seq__39342_40020 = G__40035;
chunk__39343_40021 = G__40036;
count__39344_40022 = G__40037;
i__39345_40023 = G__40038;
continue;
} else {
var vec__39357_40039 = cljs.core.first(seq__39342_40033__$1);
var col_40040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39357_40039,(0),null);
var infos_40041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39357_40039,(1),null);
encode_cols(infos_40041,source_idx_40009,line_40018,col_40040);


var G__40042 = cljs.core.next(seq__39342_40033__$1);
var G__40043 = null;
var G__40044 = (0);
var G__40045 = (0);
seq__39342_40020 = G__40042;
chunk__39343_40021 = G__40043;
count__39344_40022 = G__40044;
i__39345_40023 = G__40045;
continue;
}
} else {
}
}
break;
}


var G__40047 = seq__39292_40013;
var G__40048 = chunk__39293_40014;
var G__40049 = count__39294_40015;
var G__40050 = (i__39295_40016 + (1));
seq__39292_40013 = G__40047;
chunk__39293_40014 = G__40048;
count__39294_40015 = G__40049;
i__39295_40016 = G__40050;
continue;
} else {
var temp__5735__auto___40054 = cljs.core.seq(seq__39292_40013);
if(temp__5735__auto___40054){
var seq__39292_40055__$1 = temp__5735__auto___40054;
if(cljs.core.chunked_seq_QMARK_(seq__39292_40055__$1)){
var c__4609__auto___40056 = cljs.core.chunk_first(seq__39292_40055__$1);
var G__40057 = cljs.core.chunk_rest(seq__39292_40055__$1);
var G__40058 = c__4609__auto___40056;
var G__40059 = cljs.core.count(c__4609__auto___40056);
var G__40060 = (0);
seq__39292_40013 = G__40057;
chunk__39293_40014 = G__40058;
count__39294_40015 = G__40059;
i__39295_40016 = G__40060;
continue;
} else {
var vec__39362_40064 = cljs.core.first(seq__39292_40055__$1);
var line_40065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39362_40064,(0),null);
var cols_40066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39362_40064,(1),null);
var seq__39365_40067 = cljs.core.seq(cols_40066);
var chunk__39366_40068 = null;
var count__39367_40069 = (0);
var i__39368_40070 = (0);
while(true){
if((i__39368_40070 < count__39367_40069)){
var vec__39375_40071 = chunk__39366_40068.cljs$core$IIndexed$_nth$arity$2(null,i__39368_40070);
var col_40072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39375_40071,(0),null);
var infos_40073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39375_40071,(1),null);
encode_cols(infos_40073,source_idx_40009,line_40065,col_40072);


var G__40074 = seq__39365_40067;
var G__40075 = chunk__39366_40068;
var G__40076 = count__39367_40069;
var G__40077 = (i__39368_40070 + (1));
seq__39365_40067 = G__40074;
chunk__39366_40068 = G__40075;
count__39367_40069 = G__40076;
i__39368_40070 = G__40077;
continue;
} else {
var temp__5735__auto___40078__$1 = cljs.core.seq(seq__39365_40067);
if(temp__5735__auto___40078__$1){
var seq__39365_40080__$1 = temp__5735__auto___40078__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39365_40080__$1)){
var c__4609__auto___40081 = cljs.core.chunk_first(seq__39365_40080__$1);
var G__40082 = cljs.core.chunk_rest(seq__39365_40080__$1);
var G__40083 = c__4609__auto___40081;
var G__40084 = cljs.core.count(c__4609__auto___40081);
var G__40085 = (0);
seq__39365_40067 = G__40082;
chunk__39366_40068 = G__40083;
count__39367_40069 = G__40084;
i__39368_40070 = G__40085;
continue;
} else {
var vec__39378_40088 = cljs.core.first(seq__39365_40080__$1);
var col_40089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39378_40088,(0),null);
var infos_40090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39378_40088,(1),null);
encode_cols(infos_40090,source_idx_40009,line_40065,col_40089);


var G__40091 = cljs.core.next(seq__39365_40080__$1);
var G__40092 = null;
var G__40093 = (0);
var G__40094 = (0);
seq__39365_40067 = G__40091;
chunk__39366_40068 = G__40092;
count__39367_40069 = G__40093;
i__39368_40070 = G__40094;
continue;
}
} else {
}
}
break;
}


var G__40095 = cljs.core.next(seq__39292_40055__$1);
var G__40096 = null;
var G__40097 = (0);
var G__40098 = (0);
seq__39292_40013 = G__40095;
chunk__39293_40014 = G__40096;
count__39294_40015 = G__40097;
i__39295_40016 = G__40098;
continue;
}
} else {
}
}
break;
}


var G__40101 = seq__39075_40003;
var G__40102 = chunk__39076_40004;
var G__40103 = count__39077_40005;
var G__40104 = (i__39078_40006 + (1));
seq__39075_40003 = G__40101;
chunk__39076_40004 = G__40102;
count__39077_40005 = G__40103;
i__39078_40006 = G__40104;
continue;
} else {
var temp__5735__auto___40105 = cljs.core.seq(seq__39075_40003);
if(temp__5735__auto___40105){
var seq__39075_40106__$1 = temp__5735__auto___40105;
if(cljs.core.chunked_seq_QMARK_(seq__39075_40106__$1)){
var c__4609__auto___40107 = cljs.core.chunk_first(seq__39075_40106__$1);
var G__40108 = cljs.core.chunk_rest(seq__39075_40106__$1);
var G__40109 = c__4609__auto___40107;
var G__40110 = cljs.core.count(c__4609__auto___40107);
var G__40111 = (0);
seq__39075_40003 = G__40108;
chunk__39076_40004 = G__40109;
count__39077_40005 = G__40110;
i__39078_40006 = G__40111;
continue;
} else {
var vec__39381_40112 = cljs.core.first(seq__39075_40106__$1);
var source_idx_40113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40112,(0),null);
var vec__39384_40114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40112,(1),null);
var __40115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40114,(0),null);
var lines_40116__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40114,(1),null);
var seq__39387_40117 = cljs.core.seq(lines_40116__$1);
var chunk__39388_40118 = null;
var count__39389_40119 = (0);
var i__39390_40120 = (0);
while(true){
if((i__39390_40120 < count__39389_40119)){
var vec__39429_40121 = chunk__39388_40118.cljs$core$IIndexed$_nth$arity$2(null,i__39390_40120);
var line_40122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40121,(0),null);
var cols_40123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40121,(1),null);
var seq__39432_40124 = cljs.core.seq(cols_40123);
var chunk__39433_40125 = null;
var count__39434_40126 = (0);
var i__39435_40127 = (0);
while(true){
if((i__39435_40127 < count__39434_40126)){
var vec__39442_40128 = chunk__39433_40125.cljs$core$IIndexed$_nth$arity$2(null,i__39435_40127);
var col_40129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39442_40128,(0),null);
var infos_40130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39442_40128,(1),null);
encode_cols(infos_40130,source_idx_40113,line_40122,col_40129);


var G__40131 = seq__39432_40124;
var G__40132 = chunk__39433_40125;
var G__40133 = count__39434_40126;
var G__40134 = (i__39435_40127 + (1));
seq__39432_40124 = G__40131;
chunk__39433_40125 = G__40132;
count__39434_40126 = G__40133;
i__39435_40127 = G__40134;
continue;
} else {
var temp__5735__auto___40135__$1 = cljs.core.seq(seq__39432_40124);
if(temp__5735__auto___40135__$1){
var seq__39432_40136__$1 = temp__5735__auto___40135__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39432_40136__$1)){
var c__4609__auto___40137 = cljs.core.chunk_first(seq__39432_40136__$1);
var G__40138 = cljs.core.chunk_rest(seq__39432_40136__$1);
var G__40139 = c__4609__auto___40137;
var G__40140 = cljs.core.count(c__4609__auto___40137);
var G__40141 = (0);
seq__39432_40124 = G__40138;
chunk__39433_40125 = G__40139;
count__39434_40126 = G__40140;
i__39435_40127 = G__40141;
continue;
} else {
var vec__39450_40142 = cljs.core.first(seq__39432_40136__$1);
var col_40143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39450_40142,(0),null);
var infos_40144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39450_40142,(1),null);
encode_cols(infos_40144,source_idx_40113,line_40122,col_40143);


var G__40146 = cljs.core.next(seq__39432_40136__$1);
var G__40147 = null;
var G__40148 = (0);
var G__40149 = (0);
seq__39432_40124 = G__40146;
chunk__39433_40125 = G__40147;
count__39434_40126 = G__40148;
i__39435_40127 = G__40149;
continue;
}
} else {
}
}
break;
}


var G__40153 = seq__39387_40117;
var G__40154 = chunk__39388_40118;
var G__40155 = count__39389_40119;
var G__40156 = (i__39390_40120 + (1));
seq__39387_40117 = G__40153;
chunk__39388_40118 = G__40154;
count__39389_40119 = G__40155;
i__39390_40120 = G__40156;
continue;
} else {
var temp__5735__auto___40157__$1 = cljs.core.seq(seq__39387_40117);
if(temp__5735__auto___40157__$1){
var seq__39387_40158__$1 = temp__5735__auto___40157__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39387_40158__$1)){
var c__4609__auto___40159 = cljs.core.chunk_first(seq__39387_40158__$1);
var G__40160 = cljs.core.chunk_rest(seq__39387_40158__$1);
var G__40161 = c__4609__auto___40159;
var G__40162 = cljs.core.count(c__4609__auto___40159);
var G__40163 = (0);
seq__39387_40117 = G__40160;
chunk__39388_40118 = G__40161;
count__39389_40119 = G__40162;
i__39390_40120 = G__40163;
continue;
} else {
var vec__39453_40164 = cljs.core.first(seq__39387_40158__$1);
var line_40165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39453_40164,(0),null);
var cols_40166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39453_40164,(1),null);
var seq__39456_40173 = cljs.core.seq(cols_40166);
var chunk__39457_40174 = null;
var count__39458_40175 = (0);
var i__39459_40176 = (0);
while(true){
if((i__39459_40176 < count__39458_40175)){
var vec__39466_40177 = chunk__39457_40174.cljs$core$IIndexed$_nth$arity$2(null,i__39459_40176);
var col_40178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39466_40177,(0),null);
var infos_40179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39466_40177,(1),null);
encode_cols(infos_40179,source_idx_40113,line_40165,col_40178);


var G__40186 = seq__39456_40173;
var G__40187 = chunk__39457_40174;
var G__40188 = count__39458_40175;
var G__40189 = (i__39459_40176 + (1));
seq__39456_40173 = G__40186;
chunk__39457_40174 = G__40187;
count__39458_40175 = G__40188;
i__39459_40176 = G__40189;
continue;
} else {
var temp__5735__auto___40190__$2 = cljs.core.seq(seq__39456_40173);
if(temp__5735__auto___40190__$2){
var seq__39456_40191__$1 = temp__5735__auto___40190__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39456_40191__$1)){
var c__4609__auto___40192 = cljs.core.chunk_first(seq__39456_40191__$1);
var G__40193 = cljs.core.chunk_rest(seq__39456_40191__$1);
var G__40194 = c__4609__auto___40192;
var G__40195 = cljs.core.count(c__4609__auto___40192);
var G__40196 = (0);
seq__39456_40173 = G__40193;
chunk__39457_40174 = G__40194;
count__39458_40175 = G__40195;
i__39459_40176 = G__40196;
continue;
} else {
var vec__39469_40199 = cljs.core.first(seq__39456_40191__$1);
var col_40200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39469_40199,(0),null);
var infos_40201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39469_40199,(1),null);
encode_cols(infos_40201,source_idx_40113,line_40165,col_40200);


var G__40204 = cljs.core.next(seq__39456_40191__$1);
var G__40205 = null;
var G__40206 = (0);
var G__40207 = (0);
seq__39456_40173 = G__40204;
chunk__39457_40174 = G__40205;
count__39458_40175 = G__40206;
i__39459_40176 = G__40207;
continue;
}
} else {
}
}
break;
}


var G__40209 = cljs.core.next(seq__39387_40158__$1);
var G__40210 = null;
var G__40211 = (0);
var G__40212 = (0);
seq__39387_40117 = G__40209;
chunk__39388_40118 = G__40210;
count__39389_40119 = G__40211;
i__39390_40120 = G__40212;
continue;
}
} else {
}
}
break;
}


var G__40213 = cljs.core.next(seq__39075_40106__$1);
var G__40214 = null;
var G__40215 = (0);
var G__40216 = (0);
seq__39075_40003 = G__40213;
chunk__39076_40004 = G__40214;
count__39077_40005 = G__40215;
i__39078_40006 = G__40216;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__39473 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__39057_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39057_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__39058_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__39058_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39059_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__39059_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__39475 = G__39473;
var G__39476_40226 = G__39475;
var G__39477_40227 = "sourcesContent";
var G__39478_40228 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__39476_40226,G__39477_40227,G__39478_40228);

return G__39475;
} else {
return G__39473;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__39482 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39482,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39482,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__39485 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39485,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39485,(1),null);
var G__40234 = cljs.core.next(col_map_seq);
var G__40235 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__39485,col,infos,vec__39482,line,col_map){
return (function (v,p__39488){
var map__39489 = p__39488;
var map__39489__$1 = (((((!((map__39489 == null))))?(((((map__39489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39489.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39489):map__39489);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39489__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39489__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__39485,col,infos,vec__39482,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__40234;
new_cols = G__40235;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__40238 = cljs.core.next(line_map_seq);
var G__40239 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__40238;
new_lines = G__40239;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__39493_40240 = cljs.core.seq(reverse_map);
var chunk__39494_40241 = null;
var count__39495_40242 = (0);
var i__39496_40243 = (0);
while(true){
if((i__39496_40243 < count__39495_40242)){
var vec__39690_40248 = chunk__39494_40241.cljs$core$IIndexed$_nth$arity$2(null,i__39496_40243);
var line_40249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39690_40248,(0),null);
var columns_40250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39690_40248,(1),null);
var seq__39693_40251 = cljs.core.seq(columns_40250);
var chunk__39694_40252 = null;
var count__39695_40253 = (0);
var i__39696_40254 = (0);
while(true){
if((i__39696_40254 < count__39695_40253)){
var vec__39750_40257 = chunk__39694_40252.cljs$core$IIndexed$_nth$arity$2(null,i__39696_40254);
var column_40258 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39750_40257,(0),null);
var column_info_40259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39750_40257,(1),null);
var seq__39753_40260 = cljs.core.seq(column_info_40259);
var chunk__39754_40261 = null;
var count__39755_40262 = (0);
var i__39756_40263 = (0);
while(true){
if((i__39756_40263 < count__39755_40262)){
var map__39765_40266 = chunk__39754_40261.cljs$core$IIndexed$_nth$arity$2(null,i__39756_40263);
var map__39765_40267__$1 = (((((!((map__39765_40266 == null))))?(((((map__39765_40266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39765_40266.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39765_40266):map__39765_40266);
var gline_40268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39765_40267__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40269 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39765_40267__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39765_40267__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40268], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39753_40260,chunk__39754_40261,count__39755_40262,i__39756_40263,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39765_40266,map__39765_40267__$1,gline_40268,gcol_40269,name_40270,vec__39750_40257,column_40258,column_info_40259,vec__39690_40248,line_40249,columns_40250,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40269], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40249,new cljs.core.Keyword(null,"col","col",-1959363084),column_40258,new cljs.core.Keyword(null,"name","name",1843675177),name_40270], null));
});})(seq__39753_40260,chunk__39754_40261,count__39755_40262,i__39756_40263,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39765_40266,map__39765_40267__$1,gline_40268,gcol_40269,name_40270,vec__39750_40257,column_40258,column_info_40259,vec__39690_40248,line_40249,columns_40250,inverted))
,cljs.core.sorted_map()));


var G__40273 = seq__39753_40260;
var G__40274 = chunk__39754_40261;
var G__40275 = count__39755_40262;
var G__40276 = (i__39756_40263 + (1));
seq__39753_40260 = G__40273;
chunk__39754_40261 = G__40274;
count__39755_40262 = G__40275;
i__39756_40263 = G__40276;
continue;
} else {
var temp__5735__auto___40277 = cljs.core.seq(seq__39753_40260);
if(temp__5735__auto___40277){
var seq__39753_40278__$1 = temp__5735__auto___40277;
if(cljs.core.chunked_seq_QMARK_(seq__39753_40278__$1)){
var c__4609__auto___40279 = cljs.core.chunk_first(seq__39753_40278__$1);
var G__40281 = cljs.core.chunk_rest(seq__39753_40278__$1);
var G__40282 = c__4609__auto___40279;
var G__40283 = cljs.core.count(c__4609__auto___40279);
var G__40284 = (0);
seq__39753_40260 = G__40281;
chunk__39754_40261 = G__40282;
count__39755_40262 = G__40283;
i__39756_40263 = G__40284;
continue;
} else {
var map__39771_40285 = cljs.core.first(seq__39753_40278__$1);
var map__39771_40286__$1 = (((((!((map__39771_40285 == null))))?(((((map__39771_40285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39771_40285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39771_40285):map__39771_40285);
var gline_40287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39771_40286__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39771_40286__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39771_40286__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40287], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39753_40260,chunk__39754_40261,count__39755_40262,i__39756_40263,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39771_40285,map__39771_40286__$1,gline_40287,gcol_40288,name_40289,seq__39753_40278__$1,temp__5735__auto___40277,vec__39750_40257,column_40258,column_info_40259,vec__39690_40248,line_40249,columns_40250,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40288], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40249,new cljs.core.Keyword(null,"col","col",-1959363084),column_40258,new cljs.core.Keyword(null,"name","name",1843675177),name_40289], null));
});})(seq__39753_40260,chunk__39754_40261,count__39755_40262,i__39756_40263,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39771_40285,map__39771_40286__$1,gline_40287,gcol_40288,name_40289,seq__39753_40278__$1,temp__5735__auto___40277,vec__39750_40257,column_40258,column_info_40259,vec__39690_40248,line_40249,columns_40250,inverted))
,cljs.core.sorted_map()));


var G__40297 = cljs.core.next(seq__39753_40278__$1);
var G__40298 = null;
var G__40299 = (0);
var G__40300 = (0);
seq__39753_40260 = G__40297;
chunk__39754_40261 = G__40298;
count__39755_40262 = G__40299;
i__39756_40263 = G__40300;
continue;
}
} else {
}
}
break;
}


var G__40301 = seq__39693_40251;
var G__40302 = chunk__39694_40252;
var G__40303 = count__39695_40253;
var G__40304 = (i__39696_40254 + (1));
seq__39693_40251 = G__40301;
chunk__39694_40252 = G__40302;
count__39695_40253 = G__40303;
i__39696_40254 = G__40304;
continue;
} else {
var temp__5735__auto___40305 = cljs.core.seq(seq__39693_40251);
if(temp__5735__auto___40305){
var seq__39693_40306__$1 = temp__5735__auto___40305;
if(cljs.core.chunked_seq_QMARK_(seq__39693_40306__$1)){
var c__4609__auto___40307 = cljs.core.chunk_first(seq__39693_40306__$1);
var G__40308 = cljs.core.chunk_rest(seq__39693_40306__$1);
var G__40309 = c__4609__auto___40307;
var G__40310 = cljs.core.count(c__4609__auto___40307);
var G__40311 = (0);
seq__39693_40251 = G__40308;
chunk__39694_40252 = G__40309;
count__39695_40253 = G__40310;
i__39696_40254 = G__40311;
continue;
} else {
var vec__39777_40312 = cljs.core.first(seq__39693_40306__$1);
var column_40313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39777_40312,(0),null);
var column_info_40314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39777_40312,(1),null);
var seq__39780_40315 = cljs.core.seq(column_info_40314);
var chunk__39781_40316 = null;
var count__39782_40317 = (0);
var i__39783_40318 = (0);
while(true){
if((i__39783_40318 < count__39782_40317)){
var map__39804_40322 = chunk__39781_40316.cljs$core$IIndexed$_nth$arity$2(null,i__39783_40318);
var map__39804_40323__$1 = (((((!((map__39804_40322 == null))))?(((((map__39804_40322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39804_40322.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39804_40322):map__39804_40322);
var gline_40324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39804_40323__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39804_40323__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39804_40323__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40324], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39780_40315,chunk__39781_40316,count__39782_40317,i__39783_40318,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39804_40322,map__39804_40323__$1,gline_40324,gcol_40325,name_40326,vec__39777_40312,column_40313,column_info_40314,seq__39693_40306__$1,temp__5735__auto___40305,vec__39690_40248,line_40249,columns_40250,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40325], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40249,new cljs.core.Keyword(null,"col","col",-1959363084),column_40313,new cljs.core.Keyword(null,"name","name",1843675177),name_40326], null));
});})(seq__39780_40315,chunk__39781_40316,count__39782_40317,i__39783_40318,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39804_40322,map__39804_40323__$1,gline_40324,gcol_40325,name_40326,vec__39777_40312,column_40313,column_info_40314,seq__39693_40306__$1,temp__5735__auto___40305,vec__39690_40248,line_40249,columns_40250,inverted))
,cljs.core.sorted_map()));


var G__40331 = seq__39780_40315;
var G__40332 = chunk__39781_40316;
var G__40333 = count__39782_40317;
var G__40334 = (i__39783_40318 + (1));
seq__39780_40315 = G__40331;
chunk__39781_40316 = G__40332;
count__39782_40317 = G__40333;
i__39783_40318 = G__40334;
continue;
} else {
var temp__5735__auto___40335__$1 = cljs.core.seq(seq__39780_40315);
if(temp__5735__auto___40335__$1){
var seq__39780_40338__$1 = temp__5735__auto___40335__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39780_40338__$1)){
var c__4609__auto___40339 = cljs.core.chunk_first(seq__39780_40338__$1);
var G__40340 = cljs.core.chunk_rest(seq__39780_40338__$1);
var G__40341 = c__4609__auto___40339;
var G__40342 = cljs.core.count(c__4609__auto___40339);
var G__40343 = (0);
seq__39780_40315 = G__40340;
chunk__39781_40316 = G__40341;
count__39782_40317 = G__40342;
i__39783_40318 = G__40343;
continue;
} else {
var map__39808_40344 = cljs.core.first(seq__39780_40338__$1);
var map__39808_40345__$1 = (((((!((map__39808_40344 == null))))?(((((map__39808_40344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39808_40344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39808_40344):map__39808_40344);
var gline_40346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39808_40345__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39808_40345__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39808_40345__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40346], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39780_40315,chunk__39781_40316,count__39782_40317,i__39783_40318,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39808_40344,map__39808_40345__$1,gline_40346,gcol_40347,name_40348,seq__39780_40338__$1,temp__5735__auto___40335__$1,vec__39777_40312,column_40313,column_info_40314,seq__39693_40306__$1,temp__5735__auto___40305,vec__39690_40248,line_40249,columns_40250,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40347], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40249,new cljs.core.Keyword(null,"col","col",-1959363084),column_40313,new cljs.core.Keyword(null,"name","name",1843675177),name_40348], null));
});})(seq__39780_40315,chunk__39781_40316,count__39782_40317,i__39783_40318,seq__39693_40251,chunk__39694_40252,count__39695_40253,i__39696_40254,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39808_40344,map__39808_40345__$1,gline_40346,gcol_40347,name_40348,seq__39780_40338__$1,temp__5735__auto___40335__$1,vec__39777_40312,column_40313,column_info_40314,seq__39693_40306__$1,temp__5735__auto___40305,vec__39690_40248,line_40249,columns_40250,inverted))
,cljs.core.sorted_map()));


var G__40355 = cljs.core.next(seq__39780_40338__$1);
var G__40356 = null;
var G__40357 = (0);
var G__40358 = (0);
seq__39780_40315 = G__40355;
chunk__39781_40316 = G__40356;
count__39782_40317 = G__40357;
i__39783_40318 = G__40358;
continue;
}
} else {
}
}
break;
}


var G__40359 = cljs.core.next(seq__39693_40306__$1);
var G__40360 = null;
var G__40361 = (0);
var G__40362 = (0);
seq__39693_40251 = G__40359;
chunk__39694_40252 = G__40360;
count__39695_40253 = G__40361;
i__39696_40254 = G__40362;
continue;
}
} else {
}
}
break;
}


var G__40363 = seq__39493_40240;
var G__40364 = chunk__39494_40241;
var G__40365 = count__39495_40242;
var G__40366 = (i__39496_40243 + (1));
seq__39493_40240 = G__40363;
chunk__39494_40241 = G__40364;
count__39495_40242 = G__40365;
i__39496_40243 = G__40366;
continue;
} else {
var temp__5735__auto___40367 = cljs.core.seq(seq__39493_40240);
if(temp__5735__auto___40367){
var seq__39493_40368__$1 = temp__5735__auto___40367;
if(cljs.core.chunked_seq_QMARK_(seq__39493_40368__$1)){
var c__4609__auto___40369 = cljs.core.chunk_first(seq__39493_40368__$1);
var G__40370 = cljs.core.chunk_rest(seq__39493_40368__$1);
var G__40371 = c__4609__auto___40369;
var G__40372 = cljs.core.count(c__4609__auto___40369);
var G__40373 = (0);
seq__39493_40240 = G__40370;
chunk__39494_40241 = G__40371;
count__39495_40242 = G__40372;
i__39496_40243 = G__40373;
continue;
} else {
var vec__39814_40374 = cljs.core.first(seq__39493_40368__$1);
var line_40375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39814_40374,(0),null);
var columns_40376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39814_40374,(1),null);
var seq__39817_40377 = cljs.core.seq(columns_40376);
var chunk__39818_40378 = null;
var count__39819_40379 = (0);
var i__39820_40380 = (0);
while(true){
if((i__39820_40380 < count__39819_40379)){
var vec__39892_40382 = chunk__39818_40378.cljs$core$IIndexed$_nth$arity$2(null,i__39820_40380);
var column_40383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39892_40382,(0),null);
var column_info_40384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39892_40382,(1),null);
var seq__39895_40388 = cljs.core.seq(column_info_40384);
var chunk__39896_40389 = null;
var count__39897_40390 = (0);
var i__39898_40391 = (0);
while(true){
if((i__39898_40391 < count__39897_40390)){
var map__39907_40392 = chunk__39896_40389.cljs$core$IIndexed$_nth$arity$2(null,i__39898_40391);
var map__39907_40393__$1 = (((((!((map__39907_40392 == null))))?(((((map__39907_40392.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39907_40392.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39907_40392):map__39907_40392);
var gline_40394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39907_40393__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39907_40393__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39907_40393__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40394], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39895_40388,chunk__39896_40389,count__39897_40390,i__39898_40391,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39907_40392,map__39907_40393__$1,gline_40394,gcol_40395,name_40396,vec__39892_40382,column_40383,column_info_40384,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40395], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40375,new cljs.core.Keyword(null,"col","col",-1959363084),column_40383,new cljs.core.Keyword(null,"name","name",1843675177),name_40396], null));
});})(seq__39895_40388,chunk__39896_40389,count__39897_40390,i__39898_40391,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39907_40392,map__39907_40393__$1,gline_40394,gcol_40395,name_40396,vec__39892_40382,column_40383,column_info_40384,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted))
,cljs.core.sorted_map()));


var G__40405 = seq__39895_40388;
var G__40406 = chunk__39896_40389;
var G__40407 = count__39897_40390;
var G__40408 = (i__39898_40391 + (1));
seq__39895_40388 = G__40405;
chunk__39896_40389 = G__40406;
count__39897_40390 = G__40407;
i__39898_40391 = G__40408;
continue;
} else {
var temp__5735__auto___40409__$1 = cljs.core.seq(seq__39895_40388);
if(temp__5735__auto___40409__$1){
var seq__39895_40410__$1 = temp__5735__auto___40409__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39895_40410__$1)){
var c__4609__auto___40411 = cljs.core.chunk_first(seq__39895_40410__$1);
var G__40412 = cljs.core.chunk_rest(seq__39895_40410__$1);
var G__40413 = c__4609__auto___40411;
var G__40414 = cljs.core.count(c__4609__auto___40411);
var G__40415 = (0);
seq__39895_40388 = G__40412;
chunk__39896_40389 = G__40413;
count__39897_40390 = G__40414;
i__39898_40391 = G__40415;
continue;
} else {
var map__39912_40418 = cljs.core.first(seq__39895_40410__$1);
var map__39912_40419__$1 = (((((!((map__39912_40418 == null))))?(((((map__39912_40418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39912_40418.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39912_40418):map__39912_40418);
var gline_40420 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39912_40419__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39912_40419__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40422 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39912_40419__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40420], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39895_40388,chunk__39896_40389,count__39897_40390,i__39898_40391,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39912_40418,map__39912_40419__$1,gline_40420,gcol_40421,name_40422,seq__39895_40410__$1,temp__5735__auto___40409__$1,vec__39892_40382,column_40383,column_info_40384,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40421], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40375,new cljs.core.Keyword(null,"col","col",-1959363084),column_40383,new cljs.core.Keyword(null,"name","name",1843675177),name_40422], null));
});})(seq__39895_40388,chunk__39896_40389,count__39897_40390,i__39898_40391,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39912_40418,map__39912_40419__$1,gline_40420,gcol_40421,name_40422,seq__39895_40410__$1,temp__5735__auto___40409__$1,vec__39892_40382,column_40383,column_info_40384,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted))
,cljs.core.sorted_map()));


var G__40423 = cljs.core.next(seq__39895_40410__$1);
var G__40424 = null;
var G__40425 = (0);
var G__40426 = (0);
seq__39895_40388 = G__40423;
chunk__39896_40389 = G__40424;
count__39897_40390 = G__40425;
i__39898_40391 = G__40426;
continue;
}
} else {
}
}
break;
}


var G__40428 = seq__39817_40377;
var G__40429 = chunk__39818_40378;
var G__40430 = count__39819_40379;
var G__40431 = (i__39820_40380 + (1));
seq__39817_40377 = G__40428;
chunk__39818_40378 = G__40429;
count__39819_40379 = G__40430;
i__39820_40380 = G__40431;
continue;
} else {
var temp__5735__auto___40432__$1 = cljs.core.seq(seq__39817_40377);
if(temp__5735__auto___40432__$1){
var seq__39817_40433__$1 = temp__5735__auto___40432__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39817_40433__$1)){
var c__4609__auto___40434 = cljs.core.chunk_first(seq__39817_40433__$1);
var G__40435 = cljs.core.chunk_rest(seq__39817_40433__$1);
var G__40436 = c__4609__auto___40434;
var G__40437 = cljs.core.count(c__4609__auto___40434);
var G__40438 = (0);
seq__39817_40377 = G__40435;
chunk__39818_40378 = G__40436;
count__39819_40379 = G__40437;
i__39820_40380 = G__40438;
continue;
} else {
var vec__39919_40440 = cljs.core.first(seq__39817_40433__$1);
var column_40441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39919_40440,(0),null);
var column_info_40442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39919_40440,(1),null);
var seq__39923_40446 = cljs.core.seq(column_info_40442);
var chunk__39924_40447 = null;
var count__39925_40448 = (0);
var i__39926_40449 = (0);
while(true){
if((i__39926_40449 < count__39925_40448)){
var map__39935_40450 = chunk__39924_40447.cljs$core$IIndexed$_nth$arity$2(null,i__39926_40449);
var map__39935_40451__$1 = (((((!((map__39935_40450 == null))))?(((((map__39935_40450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39935_40450.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39935_40450):map__39935_40450);
var gline_40452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39935_40451__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39935_40451__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39935_40451__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40452], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39923_40446,chunk__39924_40447,count__39925_40448,i__39926_40449,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39935_40450,map__39935_40451__$1,gline_40452,gcol_40453,name_40454,vec__39919_40440,column_40441,column_info_40442,seq__39817_40433__$1,temp__5735__auto___40432__$1,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40453], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40375,new cljs.core.Keyword(null,"col","col",-1959363084),column_40441,new cljs.core.Keyword(null,"name","name",1843675177),name_40454], null));
});})(seq__39923_40446,chunk__39924_40447,count__39925_40448,i__39926_40449,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39935_40450,map__39935_40451__$1,gline_40452,gcol_40453,name_40454,vec__39919_40440,column_40441,column_info_40442,seq__39817_40433__$1,temp__5735__auto___40432__$1,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted))
,cljs.core.sorted_map()));


var G__40460 = seq__39923_40446;
var G__40461 = chunk__39924_40447;
var G__40462 = count__39925_40448;
var G__40463 = (i__39926_40449 + (1));
seq__39923_40446 = G__40460;
chunk__39924_40447 = G__40461;
count__39925_40448 = G__40462;
i__39926_40449 = G__40463;
continue;
} else {
var temp__5735__auto___40464__$2 = cljs.core.seq(seq__39923_40446);
if(temp__5735__auto___40464__$2){
var seq__39923_40465__$1 = temp__5735__auto___40464__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39923_40465__$1)){
var c__4609__auto___40466 = cljs.core.chunk_first(seq__39923_40465__$1);
var G__40467 = cljs.core.chunk_rest(seq__39923_40465__$1);
var G__40468 = c__4609__auto___40466;
var G__40469 = cljs.core.count(c__4609__auto___40466);
var G__40470 = (0);
seq__39923_40446 = G__40467;
chunk__39924_40447 = G__40468;
count__39925_40448 = G__40469;
i__39926_40449 = G__40470;
continue;
} else {
var map__39937_40471 = cljs.core.first(seq__39923_40465__$1);
var map__39937_40472__$1 = (((((!((map__39937_40471 == null))))?(((((map__39937_40471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39937_40471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39937_40471):map__39937_40471);
var gline_40473 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39937_40472__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40474 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39937_40472__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39937_40472__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40473], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39923_40446,chunk__39924_40447,count__39925_40448,i__39926_40449,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39937_40471,map__39937_40472__$1,gline_40473,gcol_40474,name_40475,seq__39923_40465__$1,temp__5735__auto___40464__$2,vec__39919_40440,column_40441,column_info_40442,seq__39817_40433__$1,temp__5735__auto___40432__$1,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40474], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40375,new cljs.core.Keyword(null,"col","col",-1959363084),column_40441,new cljs.core.Keyword(null,"name","name",1843675177),name_40475], null));
});})(seq__39923_40446,chunk__39924_40447,count__39925_40448,i__39926_40449,seq__39817_40377,chunk__39818_40378,count__39819_40379,i__39820_40380,seq__39493_40240,chunk__39494_40241,count__39495_40242,i__39496_40243,map__39937_40471,map__39937_40472__$1,gline_40473,gcol_40474,name_40475,seq__39923_40465__$1,temp__5735__auto___40464__$2,vec__39919_40440,column_40441,column_info_40442,seq__39817_40433__$1,temp__5735__auto___40432__$1,vec__39814_40374,line_40375,columns_40376,seq__39493_40368__$1,temp__5735__auto___40367,inverted))
,cljs.core.sorted_map()));


var G__40484 = cljs.core.next(seq__39923_40465__$1);
var G__40485 = null;
var G__40486 = (0);
var G__40487 = (0);
seq__39923_40446 = G__40484;
chunk__39924_40447 = G__40485;
count__39925_40448 = G__40486;
i__39926_40449 = G__40487;
continue;
}
} else {
}
}
break;
}


var G__40488 = cljs.core.next(seq__39817_40433__$1);
var G__40489 = null;
var G__40490 = (0);
var G__40491 = (0);
seq__39817_40377 = G__40488;
chunk__39818_40378 = G__40489;
count__39819_40379 = G__40490;
i__39820_40380 = G__40491;
continue;
}
} else {
}
}
break;
}


var G__40493 = cljs.core.next(seq__39493_40368__$1);
var G__40494 = null;
var G__40495 = (0);
var G__40496 = (0);
seq__39493_40240 = G__40493;
chunk__39494_40241 = G__40494;
count__39495_40242 = G__40495;
i__39496_40243 = G__40496;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
