goog.provide('pinkgorilla.ui.jsrender');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('cljs_uuid_utils.core');
pinkgorilla.ui.jsrender.info = (function pinkgorilla$ui$jsrender$info(s){
return console.log(s);
});
/**
 * loads a module via js-require
 * spec can be either ["demo"] or ["demo!params"]
 * executes a callback with the loaded module
 */
pinkgorilla.ui.jsrender.require_js_module = (function pinkgorilla$ui$jsrender$require_js_module(spec,callback){
var spec_js = cljs.core.clj__GT_js(spec);
window.require(spec_js,callback);

return null;
});
/**
 * loads a module, and executes a callback containing the loaded module.
 * js-snippet: a string, that defines the module. 
 *            Example: define([],function(){return 'world!'})
 *                     define([],function(){return {render: function (name) {return 'hello, ' + name}}})
 * Implementation:
 * The snippet is passed as a parameter to the 'loadstring' module.
 * The loadstring module then does the real work.
 */
pinkgorilla.ui.jsrender.get_js_module_from_string = (function pinkgorilla$ui$jsrender$get_js_module_from_string(js_snippet,callback){
var spec = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["loadstring!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_snippet)].join('')], null);
return pinkgorilla.ui.jsrender.require_js_module(spec,callback);
});
/**
 * loads a module (with a given name; the module then will be looked up in the
 * require.js module configuration). It then executes the callback, passing it
 * the loaded module.
 */
pinkgorilla.ui.jsrender.get_js_module_with_name = (function pinkgorilla$ui$jsrender$get_js_module_with_name(module_name,callback){
var spec = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [module_name], null);
return pinkgorilla.ui.jsrender.require_js_module(spec,callback);
});
/**
 * renders data to dom, using a loaded js-module
 */
pinkgorilla.ui.jsrender.render_data_from_js_module = (function pinkgorilla$ui$jsrender$render_data_from_js_module(id_or_el,data,js_module){
if((js_module == null)){
return pinkgorilla.ui.jsrender.info(["module nil. cannot render data:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))].join(''));
} else {
var module = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_module,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__26508 = module;
var map__26508__$1 = (((((!((map__26508 == null))))?(((((map__26508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26508.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26508):map__26508);
var render = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26508__$1,new cljs.core.Keyword(null,"render","render",-1408033454));
var version = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26508__$1,new cljs.core.Keyword(null,"version","version",425292698));
var data_js = cljs.core.clj__GT_js(data);
return (render.cljs$core$IFn$_invoke$arity$2 ? render.cljs$core$IFn$_invoke$arity$2(id_or_el,data_js) : render.call(null,id_or_el,data_js));
}
});
pinkgorilla.ui.jsrender.run_script = (function pinkgorilla$ui$jsrender$run_script(id_or_el,data,module_name){
pinkgorilla.ui.jsrender.get_js_module_with_name(module_name,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(pinkgorilla.ui.jsrender.render_data_from_js_module,id_or_el,data));

return null;
});
pinkgorilla.ui.jsrender.jsrender = (function pinkgorilla$ui$jsrender$jsrender(p__26510){
var map__26511 = p__26510;
var map__26511__$1 = (((((!((map__26511 == null))))?(((((map__26511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26511):map__26511);
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26511__$1,new cljs.core.Keyword(null,"module","module",1424618191));
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26511__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var uuid = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"jsrender",new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),uuid], null)], null);
}),new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),(function (this$){
return pinkgorilla.ui.jsrender.run_script(reagent.dom.dom_node(this$),data,module);
}),new cljs.core.Keyword(null,"component-will-update","component-will-update",335247566),(function (this$,p__26513){
var vec__26514 = p__26513;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26514,(0),null);
var map__26517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26514,(1),null);
var map__26517__$1 = (((((!((map__26517 == null))))?(((((map__26517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26517):map__26517);
var module__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26517__$1,new cljs.core.Keyword(null,"module","module",1424618191));
var data__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26517__$1,new cljs.core.Keyword(null,"data","data",-232669377));
pinkgorilla.ui.jsrender.info(["jsrender new params: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data__$1)].join(''));

return pinkgorilla.ui.jsrender.run_script(reagent.dom.dom_node(this$),data__$1,module__$1);
})], null));
});

//# sourceMappingURL=pinkgorilla.ui.jsrender.js.map
