goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__38977){
var vec__38978 = p__38977;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__38981 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__38984 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(4),null);
var vec__38987 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__38990 = segmap;
var map__38990__$1 = (((((!((map__38990 == null))))?(((((map__38990.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38990.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38990):map__38990);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__38993 = arguments.length;
switch (G__38993) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39001 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39940 = cljs.core.next(segs__$1);
var G__39941 = nrelseg;
var G__39942 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39940;
relseg__$1 = G__39941;
result__$1 = G__39942;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39001,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39001,(1),null);
var G__39943 = (gline + (1));
var G__39944 = cljs.core.next(lines__$1);
var G__39945 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39946 = result__$1;
gline = G__39943;
lines__$1 = G__39944;
relseg = G__39945;
result = G__39946;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__39005 = segmap;
var map__39005__$1 = (((((!((map__39005 == null))))?(((((map__39005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39005.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39005):map__39005);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39005__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39005__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39005__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39005__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39005__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__39004_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39004_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__39008 = arguments.length;
switch (G__39008) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39019 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39949 = cljs.core.next(segs__$1);
var G__39950 = nrelseg;
var G__39951 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39949;
relseg__$1 = G__39950;
result__$1 = G__39951;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39019,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39019,(1),null);
var G__39952 = (gline + (1));
var G__39953 = cljs.core.next(lines__$1);
var G__39954 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39955 = result__$1;
gline = G__39952;
lines__$1 = G__39953;
relseg = G__39954;
result = G__39955;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39028){
var vec__39030 = p__39028;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39030,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39030,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39030,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39030,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39030,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__39035){
var vec__39036 = p__39035;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39036,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39036,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39036,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39036,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39036,(4),null);
var seg = vec__39036;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39042){
var vec__39043 = p__39042;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39043,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39043,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39043,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39043,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39043,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__39060 = cljs.core.seq(infos);
var chunk__39061 = null;
var count__39062 = (0);
var i__39063 = (0);
while(true){
if((i__39063 < count__39062)){
var info = chunk__39061.cljs$core$IIndexed$_nth$arity$2(null,i__39063);
var segv_39963 = info__GT_segv(info,source_idx,line,col);
var gline_39964 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39965 = cljs.core.count(cljs.core.deref(lines));
if((gline_39964 > (lc_39965 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39060,chunk__39061,count__39062,i__39063,segv_39963,gline_39964,lc_39965,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39964 - (lc_39965 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39963], null));
});})(seq__39060,chunk__39061,count__39062,i__39063,segv_39963,gline_39964,lc_39965,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39060,chunk__39061,count__39062,i__39063,segv_39963,gline_39964,lc_39965,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39964], null),cljs.core.conj,segv_39963);
});})(seq__39060,chunk__39061,count__39062,i__39063,segv_39963,gline_39964,lc_39965,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39971 = seq__39060;
var G__39972 = chunk__39061;
var G__39973 = count__39062;
var G__39974 = (i__39063 + (1));
seq__39060 = G__39971;
chunk__39061 = G__39972;
count__39062 = G__39973;
i__39063 = G__39974;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39060);
if(temp__5735__auto__){
var seq__39060__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39060__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39060__$1);
var G__39975 = cljs.core.chunk_rest(seq__39060__$1);
var G__39976 = c__4609__auto__;
var G__39977 = cljs.core.count(c__4609__auto__);
var G__39978 = (0);
seq__39060 = G__39975;
chunk__39061 = G__39976;
count__39062 = G__39977;
i__39063 = G__39978;
continue;
} else {
var info = cljs.core.first(seq__39060__$1);
var segv_39979 = info__GT_segv(info,source_idx,line,col);
var gline_39980 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39981 = cljs.core.count(cljs.core.deref(lines));
if((gline_39980 > (lc_39981 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39060,chunk__39061,count__39062,i__39063,segv_39979,gline_39980,lc_39981,info,seq__39060__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39980 - (lc_39981 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39979], null));
});})(seq__39060,chunk__39061,count__39062,i__39063,segv_39979,gline_39980,lc_39981,info,seq__39060__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39060,chunk__39061,count__39062,i__39063,segv_39979,gline_39980,lc_39981,info,seq__39060__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39980], null),cljs.core.conj,segv_39979);
});})(seq__39060,chunk__39061,count__39062,i__39063,segv_39979,gline_39980,lc_39981,info,seq__39060__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39984 = cljs.core.next(seq__39060__$1);
var G__39985 = null;
var G__39986 = (0);
var G__39987 = (0);
seq__39060 = G__39984;
chunk__39061 = G__39985;
count__39062 = G__39986;
i__39063 = G__39987;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__39067_39988 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__39068_39989 = null;
var count__39069_39990 = (0);
var i__39070_39991 = (0);
while(true){
if((i__39070_39991 < count__39069_39990)){
var vec__39279_39994 = chunk__39068_39989.cljs$core$IIndexed$_nth$arity$2(null,i__39070_39991);
var source_idx_39995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39279_39994,(0),null);
var vec__39282_39996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39279_39994,(1),null);
var __39997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39282_39996,(0),null);
var lines_39998__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39282_39996,(1),null);
var seq__39288_39999 = cljs.core.seq(lines_39998__$1);
var chunk__39289_40000 = null;
var count__39290_40001 = (0);
var i__39291_40002 = (0);
while(true){
if((i__39291_40002 < count__39290_40001)){
var vec__39339_40003 = chunk__39289_40000.cljs$core$IIndexed$_nth$arity$2(null,i__39291_40002);
var line_40004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39339_40003,(0),null);
var cols_40005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39339_40003,(1),null);
var seq__39342_40006 = cljs.core.seq(cols_40005);
var chunk__39343_40007 = null;
var count__39344_40008 = (0);
var i__39345_40009 = (0);
while(true){
if((i__39345_40009 < count__39344_40008)){
var vec__39352_40012 = chunk__39343_40007.cljs$core$IIndexed$_nth$arity$2(null,i__39345_40009);
var col_40013 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39352_40012,(0),null);
var infos_40014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39352_40012,(1),null);
encode_cols(infos_40014,source_idx_39995,line_40004,col_40013);


var G__40021 = seq__39342_40006;
var G__40022 = chunk__39343_40007;
var G__40023 = count__39344_40008;
var G__40024 = (i__39345_40009 + (1));
seq__39342_40006 = G__40021;
chunk__39343_40007 = G__40022;
count__39344_40008 = G__40023;
i__39345_40009 = G__40024;
continue;
} else {
var temp__5735__auto___40025 = cljs.core.seq(seq__39342_40006);
if(temp__5735__auto___40025){
var seq__39342_40026__$1 = temp__5735__auto___40025;
if(cljs.core.chunked_seq_QMARK_(seq__39342_40026__$1)){
var c__4609__auto___40027 = cljs.core.chunk_first(seq__39342_40026__$1);
var G__40028 = cljs.core.chunk_rest(seq__39342_40026__$1);
var G__40029 = c__4609__auto___40027;
var G__40030 = cljs.core.count(c__4609__auto___40027);
var G__40031 = (0);
seq__39342_40006 = G__40028;
chunk__39343_40007 = G__40029;
count__39344_40008 = G__40030;
i__39345_40009 = G__40031;
continue;
} else {
var vec__39355_40032 = cljs.core.first(seq__39342_40026__$1);
var col_40033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39355_40032,(0),null);
var infos_40034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39355_40032,(1),null);
encode_cols(infos_40034,source_idx_39995,line_40004,col_40033);


var G__40036 = cljs.core.next(seq__39342_40026__$1);
var G__40037 = null;
var G__40038 = (0);
var G__40039 = (0);
seq__39342_40006 = G__40036;
chunk__39343_40007 = G__40037;
count__39344_40008 = G__40038;
i__39345_40009 = G__40039;
continue;
}
} else {
}
}
break;
}


var G__40041 = seq__39288_39999;
var G__40042 = chunk__39289_40000;
var G__40043 = count__39290_40001;
var G__40044 = (i__39291_40002 + (1));
seq__39288_39999 = G__40041;
chunk__39289_40000 = G__40042;
count__39290_40001 = G__40043;
i__39291_40002 = G__40044;
continue;
} else {
var temp__5735__auto___40045 = cljs.core.seq(seq__39288_39999);
if(temp__5735__auto___40045){
var seq__39288_40046__$1 = temp__5735__auto___40045;
if(cljs.core.chunked_seq_QMARK_(seq__39288_40046__$1)){
var c__4609__auto___40047 = cljs.core.chunk_first(seq__39288_40046__$1);
var G__40048 = cljs.core.chunk_rest(seq__39288_40046__$1);
var G__40049 = c__4609__auto___40047;
var G__40050 = cljs.core.count(c__4609__auto___40047);
var G__40051 = (0);
seq__39288_39999 = G__40048;
chunk__39289_40000 = G__40049;
count__39290_40001 = G__40050;
i__39291_40002 = G__40051;
continue;
} else {
var vec__39358_40052 = cljs.core.first(seq__39288_40046__$1);
var line_40053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39358_40052,(0),null);
var cols_40054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39358_40052,(1),null);
var seq__39361_40055 = cljs.core.seq(cols_40054);
var chunk__39362_40056 = null;
var count__39363_40057 = (0);
var i__39364_40058 = (0);
while(true){
if((i__39364_40058 < count__39363_40057)){
var vec__39373_40059 = chunk__39362_40056.cljs$core$IIndexed$_nth$arity$2(null,i__39364_40058);
var col_40060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39373_40059,(0),null);
var infos_40061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39373_40059,(1),null);
encode_cols(infos_40061,source_idx_39995,line_40053,col_40060);


var G__40065 = seq__39361_40055;
var G__40066 = chunk__39362_40056;
var G__40067 = count__39363_40057;
var G__40068 = (i__39364_40058 + (1));
seq__39361_40055 = G__40065;
chunk__39362_40056 = G__40066;
count__39363_40057 = G__40067;
i__39364_40058 = G__40068;
continue;
} else {
var temp__5735__auto___40069__$1 = cljs.core.seq(seq__39361_40055);
if(temp__5735__auto___40069__$1){
var seq__39361_40070__$1 = temp__5735__auto___40069__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39361_40070__$1)){
var c__4609__auto___40071 = cljs.core.chunk_first(seq__39361_40070__$1);
var G__40072 = cljs.core.chunk_rest(seq__39361_40070__$1);
var G__40073 = c__4609__auto___40071;
var G__40074 = cljs.core.count(c__4609__auto___40071);
var G__40075 = (0);
seq__39361_40055 = G__40072;
chunk__39362_40056 = G__40073;
count__39363_40057 = G__40074;
i__39364_40058 = G__40075;
continue;
} else {
var vec__39377_40076 = cljs.core.first(seq__39361_40070__$1);
var col_40077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39377_40076,(0),null);
var infos_40078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39377_40076,(1),null);
encode_cols(infos_40078,source_idx_39995,line_40053,col_40077);


var G__40079 = cljs.core.next(seq__39361_40070__$1);
var G__40080 = null;
var G__40081 = (0);
var G__40082 = (0);
seq__39361_40055 = G__40079;
chunk__39362_40056 = G__40080;
count__39363_40057 = G__40081;
i__39364_40058 = G__40082;
continue;
}
} else {
}
}
break;
}


var G__40083 = cljs.core.next(seq__39288_40046__$1);
var G__40084 = null;
var G__40085 = (0);
var G__40086 = (0);
seq__39288_39999 = G__40083;
chunk__39289_40000 = G__40084;
count__39290_40001 = G__40085;
i__39291_40002 = G__40086;
continue;
}
} else {
}
}
break;
}


var G__40087 = seq__39067_39988;
var G__40088 = chunk__39068_39989;
var G__40089 = count__39069_39990;
var G__40090 = (i__39070_39991 + (1));
seq__39067_39988 = G__40087;
chunk__39068_39989 = G__40088;
count__39069_39990 = G__40089;
i__39070_39991 = G__40090;
continue;
} else {
var temp__5735__auto___40091 = cljs.core.seq(seq__39067_39988);
if(temp__5735__auto___40091){
var seq__39067_40092__$1 = temp__5735__auto___40091;
if(cljs.core.chunked_seq_QMARK_(seq__39067_40092__$1)){
var c__4609__auto___40093 = cljs.core.chunk_first(seq__39067_40092__$1);
var G__40094 = cljs.core.chunk_rest(seq__39067_40092__$1);
var G__40095 = c__4609__auto___40093;
var G__40096 = cljs.core.count(c__4609__auto___40093);
var G__40097 = (0);
seq__39067_39988 = G__40094;
chunk__39068_39989 = G__40095;
count__39069_39990 = G__40096;
i__39070_39991 = G__40097;
continue;
} else {
var vec__39381_40098 = cljs.core.first(seq__39067_40092__$1);
var source_idx_40099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40098,(0),null);
var vec__39384_40100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40098,(1),null);
var __40101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40100,(0),null);
var lines_40102__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40100,(1),null);
var seq__39387_40104 = cljs.core.seq(lines_40102__$1);
var chunk__39388_40105 = null;
var count__39389_40106 = (0);
var i__39390_40107 = (0);
while(true){
if((i__39390_40107 < count__39389_40106)){
var vec__39429_40108 = chunk__39388_40105.cljs$core$IIndexed$_nth$arity$2(null,i__39390_40107);
var line_40109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40108,(0),null);
var cols_40110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40108,(1),null);
var seq__39432_40111 = cljs.core.seq(cols_40110);
var chunk__39433_40112 = null;
var count__39434_40113 = (0);
var i__39435_40114 = (0);
while(true){
if((i__39435_40114 < count__39434_40113)){
var vec__39442_40115 = chunk__39433_40112.cljs$core$IIndexed$_nth$arity$2(null,i__39435_40114);
var col_40116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39442_40115,(0),null);
var infos_40117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39442_40115,(1),null);
encode_cols(infos_40117,source_idx_40099,line_40109,col_40116);


var G__40118 = seq__39432_40111;
var G__40119 = chunk__39433_40112;
var G__40120 = count__39434_40113;
var G__40121 = (i__39435_40114 + (1));
seq__39432_40111 = G__40118;
chunk__39433_40112 = G__40119;
count__39434_40113 = G__40120;
i__39435_40114 = G__40121;
continue;
} else {
var temp__5735__auto___40123__$1 = cljs.core.seq(seq__39432_40111);
if(temp__5735__auto___40123__$1){
var seq__39432_40124__$1 = temp__5735__auto___40123__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39432_40124__$1)){
var c__4609__auto___40125 = cljs.core.chunk_first(seq__39432_40124__$1);
var G__40126 = cljs.core.chunk_rest(seq__39432_40124__$1);
var G__40127 = c__4609__auto___40125;
var G__40128 = cljs.core.count(c__4609__auto___40125);
var G__40129 = (0);
seq__39432_40111 = G__40126;
chunk__39433_40112 = G__40127;
count__39434_40113 = G__40128;
i__39435_40114 = G__40129;
continue;
} else {
var vec__39445_40130 = cljs.core.first(seq__39432_40124__$1);
var col_40131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39445_40130,(0),null);
var infos_40132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39445_40130,(1),null);
encode_cols(infos_40132,source_idx_40099,line_40109,col_40131);


var G__40134 = cljs.core.next(seq__39432_40124__$1);
var G__40135 = null;
var G__40136 = (0);
var G__40137 = (0);
seq__39432_40111 = G__40134;
chunk__39433_40112 = G__40135;
count__39434_40113 = G__40136;
i__39435_40114 = G__40137;
continue;
}
} else {
}
}
break;
}


var G__40141 = seq__39387_40104;
var G__40142 = chunk__39388_40105;
var G__40143 = count__39389_40106;
var G__40144 = (i__39390_40107 + (1));
seq__39387_40104 = G__40141;
chunk__39388_40105 = G__40142;
count__39389_40106 = G__40143;
i__39390_40107 = G__40144;
continue;
} else {
var temp__5735__auto___40145__$1 = cljs.core.seq(seq__39387_40104);
if(temp__5735__auto___40145__$1){
var seq__39387_40146__$1 = temp__5735__auto___40145__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39387_40146__$1)){
var c__4609__auto___40148 = cljs.core.chunk_first(seq__39387_40146__$1);
var G__40151 = cljs.core.chunk_rest(seq__39387_40146__$1);
var G__40152 = c__4609__auto___40148;
var G__40153 = cljs.core.count(c__4609__auto___40148);
var G__40154 = (0);
seq__39387_40104 = G__40151;
chunk__39388_40105 = G__40152;
count__39389_40106 = G__40153;
i__39390_40107 = G__40154;
continue;
} else {
var vec__39448_40155 = cljs.core.first(seq__39387_40146__$1);
var line_40156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39448_40155,(0),null);
var cols_40157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39448_40155,(1),null);
var seq__39451_40158 = cljs.core.seq(cols_40157);
var chunk__39452_40159 = null;
var count__39453_40160 = (0);
var i__39454_40161 = (0);
while(true){
if((i__39454_40161 < count__39453_40160)){
var vec__39461_40162 = chunk__39452_40159.cljs$core$IIndexed$_nth$arity$2(null,i__39454_40161);
var col_40163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39461_40162,(0),null);
var infos_40164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39461_40162,(1),null);
encode_cols(infos_40164,source_idx_40099,line_40156,col_40163);


var G__40166 = seq__39451_40158;
var G__40167 = chunk__39452_40159;
var G__40168 = count__39453_40160;
var G__40169 = (i__39454_40161 + (1));
seq__39451_40158 = G__40166;
chunk__39452_40159 = G__40167;
count__39453_40160 = G__40168;
i__39454_40161 = G__40169;
continue;
} else {
var temp__5735__auto___40172__$2 = cljs.core.seq(seq__39451_40158);
if(temp__5735__auto___40172__$2){
var seq__39451_40173__$1 = temp__5735__auto___40172__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39451_40173__$1)){
var c__4609__auto___40174 = cljs.core.chunk_first(seq__39451_40173__$1);
var G__40175 = cljs.core.chunk_rest(seq__39451_40173__$1);
var G__40176 = c__4609__auto___40174;
var G__40177 = cljs.core.count(c__4609__auto___40174);
var G__40178 = (0);
seq__39451_40158 = G__40175;
chunk__39452_40159 = G__40176;
count__39453_40160 = G__40177;
i__39454_40161 = G__40178;
continue;
} else {
var vec__39469_40179 = cljs.core.first(seq__39451_40173__$1);
var col_40180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39469_40179,(0),null);
var infos_40181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39469_40179,(1),null);
encode_cols(infos_40181,source_idx_40099,line_40156,col_40180);


var G__40184 = cljs.core.next(seq__39451_40173__$1);
var G__40185 = null;
var G__40186 = (0);
var G__40187 = (0);
seq__39451_40158 = G__40184;
chunk__39452_40159 = G__40185;
count__39453_40160 = G__40186;
i__39454_40161 = G__40187;
continue;
}
} else {
}
}
break;
}


var G__40188 = cljs.core.next(seq__39387_40146__$1);
var G__40189 = null;
var G__40190 = (0);
var G__40191 = (0);
seq__39387_40104 = G__40188;
chunk__39388_40105 = G__40189;
count__39389_40106 = G__40190;
i__39390_40107 = G__40191;
continue;
}
} else {
}
}
break;
}


var G__40192 = cljs.core.next(seq__39067_40092__$1);
var G__40193 = null;
var G__40194 = (0);
var G__40195 = (0);
seq__39067_39988 = G__40192;
chunk__39068_39989 = G__40193;
count__39069_39990 = G__40194;
i__39070_39991 = G__40195;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__39472 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__39051_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39051_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__39053_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__39053_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39054_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__39054_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__39473 = G__39472;
var G__39474_40196 = G__39473;
var G__39475_40197 = "sourcesContent";
var G__39476_40198 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__39474_40196,G__39475_40197,G__39476_40198);

return G__39473;
} else {
return G__39472;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__39478 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39478,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39478,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__39482 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39482,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39482,(1),null);
var G__40209 = cljs.core.next(col_map_seq);
var G__40210 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__39482,col,infos,vec__39478,line,col_map){
return (function (v,p__39485){
var map__39486 = p__39485;
var map__39486__$1 = (((((!((map__39486 == null))))?(((((map__39486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39486):map__39486);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39486__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39486__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__39482,col,infos,vec__39478,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__40209;
new_cols = G__40210;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__40219 = cljs.core.next(line_map_seq);
var G__40220 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__40219;
new_lines = G__40220;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__39491_40224 = cljs.core.seq(reverse_map);
var chunk__39492_40225 = null;
var count__39493_40226 = (0);
var i__39494_40227 = (0);
while(true){
if((i__39494_40227 < count__39493_40226)){
var vec__39664_40228 = chunk__39492_40225.cljs$core$IIndexed$_nth$arity$2(null,i__39494_40227);
var line_40229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39664_40228,(0),null);
var columns_40230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39664_40228,(1),null);
var seq__39667_40231 = cljs.core.seq(columns_40230);
var chunk__39668_40232 = null;
var count__39669_40233 = (0);
var i__39670_40234 = (0);
while(true){
if((i__39670_40234 < count__39669_40233)){
var vec__39727_40235 = chunk__39668_40232.cljs$core$IIndexed$_nth$arity$2(null,i__39670_40234);
var column_40236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39727_40235,(0),null);
var column_info_40237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39727_40235,(1),null);
var seq__39730_40244 = cljs.core.seq(column_info_40237);
var chunk__39731_40245 = null;
var count__39732_40246 = (0);
var i__39733_40248 = (0);
while(true){
if((i__39733_40248 < count__39732_40246)){
var map__39746_40249 = chunk__39731_40245.cljs$core$IIndexed$_nth$arity$2(null,i__39733_40248);
var map__39746_40250__$1 = (((((!((map__39746_40249 == null))))?(((((map__39746_40249.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39746_40249.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39746_40249):map__39746_40249);
var gline_40251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39746_40250__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39746_40250__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39746_40250__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40251], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39730_40244,chunk__39731_40245,count__39732_40246,i__39733_40248,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39746_40249,map__39746_40250__$1,gline_40251,gcol_40252,name_40253,vec__39727_40235,column_40236,column_info_40237,vec__39664_40228,line_40229,columns_40230,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40252], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40229,new cljs.core.Keyword(null,"col","col",-1959363084),column_40236,new cljs.core.Keyword(null,"name","name",1843675177),name_40253], null));
});})(seq__39730_40244,chunk__39731_40245,count__39732_40246,i__39733_40248,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39746_40249,map__39746_40250__$1,gline_40251,gcol_40252,name_40253,vec__39727_40235,column_40236,column_info_40237,vec__39664_40228,line_40229,columns_40230,inverted))
,cljs.core.sorted_map()));


var G__40261 = seq__39730_40244;
var G__40262 = chunk__39731_40245;
var G__40263 = count__39732_40246;
var G__40264 = (i__39733_40248 + (1));
seq__39730_40244 = G__40261;
chunk__39731_40245 = G__40262;
count__39732_40246 = G__40263;
i__39733_40248 = G__40264;
continue;
} else {
var temp__5735__auto___40265 = cljs.core.seq(seq__39730_40244);
if(temp__5735__auto___40265){
var seq__39730_40266__$1 = temp__5735__auto___40265;
if(cljs.core.chunked_seq_QMARK_(seq__39730_40266__$1)){
var c__4609__auto___40269 = cljs.core.chunk_first(seq__39730_40266__$1);
var G__40270 = cljs.core.chunk_rest(seq__39730_40266__$1);
var G__40271 = c__4609__auto___40269;
var G__40272 = cljs.core.count(c__4609__auto___40269);
var G__40273 = (0);
seq__39730_40244 = G__40270;
chunk__39731_40245 = G__40271;
count__39732_40246 = G__40272;
i__39733_40248 = G__40273;
continue;
} else {
var map__39748_40274 = cljs.core.first(seq__39730_40266__$1);
var map__39748_40275__$1 = (((((!((map__39748_40274 == null))))?(((((map__39748_40274.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39748_40274.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39748_40274):map__39748_40274);
var gline_40276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39748_40275__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39748_40275__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40278 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39748_40275__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40276], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39730_40244,chunk__39731_40245,count__39732_40246,i__39733_40248,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39748_40274,map__39748_40275__$1,gline_40276,gcol_40277,name_40278,seq__39730_40266__$1,temp__5735__auto___40265,vec__39727_40235,column_40236,column_info_40237,vec__39664_40228,line_40229,columns_40230,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40277], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40229,new cljs.core.Keyword(null,"col","col",-1959363084),column_40236,new cljs.core.Keyword(null,"name","name",1843675177),name_40278], null));
});})(seq__39730_40244,chunk__39731_40245,count__39732_40246,i__39733_40248,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39748_40274,map__39748_40275__$1,gline_40276,gcol_40277,name_40278,seq__39730_40266__$1,temp__5735__auto___40265,vec__39727_40235,column_40236,column_info_40237,vec__39664_40228,line_40229,columns_40230,inverted))
,cljs.core.sorted_map()));


var G__40287 = cljs.core.next(seq__39730_40266__$1);
var G__40288 = null;
var G__40289 = (0);
var G__40290 = (0);
seq__39730_40244 = G__40287;
chunk__39731_40245 = G__40288;
count__39732_40246 = G__40289;
i__39733_40248 = G__40290;
continue;
}
} else {
}
}
break;
}


var G__40291 = seq__39667_40231;
var G__40292 = chunk__39668_40232;
var G__40293 = count__39669_40233;
var G__40294 = (i__39670_40234 + (1));
seq__39667_40231 = G__40291;
chunk__39668_40232 = G__40292;
count__39669_40233 = G__40293;
i__39670_40234 = G__40294;
continue;
} else {
var temp__5735__auto___40295 = cljs.core.seq(seq__39667_40231);
if(temp__5735__auto___40295){
var seq__39667_40298__$1 = temp__5735__auto___40295;
if(cljs.core.chunked_seq_QMARK_(seq__39667_40298__$1)){
var c__4609__auto___40299 = cljs.core.chunk_first(seq__39667_40298__$1);
var G__40300 = cljs.core.chunk_rest(seq__39667_40298__$1);
var G__40301 = c__4609__auto___40299;
var G__40302 = cljs.core.count(c__4609__auto___40299);
var G__40303 = (0);
seq__39667_40231 = G__40300;
chunk__39668_40232 = G__40301;
count__39669_40233 = G__40302;
i__39670_40234 = G__40303;
continue;
} else {
var vec__39754_40304 = cljs.core.first(seq__39667_40298__$1);
var column_40305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39754_40304,(0),null);
var column_info_40306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39754_40304,(1),null);
var seq__39757_40307 = cljs.core.seq(column_info_40306);
var chunk__39758_40308 = null;
var count__39759_40309 = (0);
var i__39760_40310 = (0);
while(true){
if((i__39760_40310 < count__39759_40309)){
var map__39770_40311 = chunk__39758_40308.cljs$core$IIndexed$_nth$arity$2(null,i__39760_40310);
var map__39770_40312__$1 = (((((!((map__39770_40311 == null))))?(((((map__39770_40311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39770_40311.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39770_40311):map__39770_40311);
var gline_40313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39770_40312__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40314 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39770_40312__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39770_40312__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40313], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39757_40307,chunk__39758_40308,count__39759_40309,i__39760_40310,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39770_40311,map__39770_40312__$1,gline_40313,gcol_40314,name_40315,vec__39754_40304,column_40305,column_info_40306,seq__39667_40298__$1,temp__5735__auto___40295,vec__39664_40228,line_40229,columns_40230,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40314], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40229,new cljs.core.Keyword(null,"col","col",-1959363084),column_40305,new cljs.core.Keyword(null,"name","name",1843675177),name_40315], null));
});})(seq__39757_40307,chunk__39758_40308,count__39759_40309,i__39760_40310,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39770_40311,map__39770_40312__$1,gline_40313,gcol_40314,name_40315,vec__39754_40304,column_40305,column_info_40306,seq__39667_40298__$1,temp__5735__auto___40295,vec__39664_40228,line_40229,columns_40230,inverted))
,cljs.core.sorted_map()));


var G__40322 = seq__39757_40307;
var G__40323 = chunk__39758_40308;
var G__40324 = count__39759_40309;
var G__40325 = (i__39760_40310 + (1));
seq__39757_40307 = G__40322;
chunk__39758_40308 = G__40323;
count__39759_40309 = G__40324;
i__39760_40310 = G__40325;
continue;
} else {
var temp__5735__auto___40328__$1 = cljs.core.seq(seq__39757_40307);
if(temp__5735__auto___40328__$1){
var seq__39757_40329__$1 = temp__5735__auto___40328__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39757_40329__$1)){
var c__4609__auto___40330 = cljs.core.chunk_first(seq__39757_40329__$1);
var G__40331 = cljs.core.chunk_rest(seq__39757_40329__$1);
var G__40332 = c__4609__auto___40330;
var G__40333 = cljs.core.count(c__4609__auto___40330);
var G__40334 = (0);
seq__39757_40307 = G__40331;
chunk__39758_40308 = G__40332;
count__39759_40309 = G__40333;
i__39760_40310 = G__40334;
continue;
} else {
var map__39778_40335 = cljs.core.first(seq__39757_40329__$1);
var map__39778_40336__$1 = (((((!((map__39778_40335 == null))))?(((((map__39778_40335.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39778_40335.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39778_40335):map__39778_40335);
var gline_40337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39778_40336__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39778_40336__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39778_40336__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40337], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39757_40307,chunk__39758_40308,count__39759_40309,i__39760_40310,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39778_40335,map__39778_40336__$1,gline_40337,gcol_40338,name_40339,seq__39757_40329__$1,temp__5735__auto___40328__$1,vec__39754_40304,column_40305,column_info_40306,seq__39667_40298__$1,temp__5735__auto___40295,vec__39664_40228,line_40229,columns_40230,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40338], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40229,new cljs.core.Keyword(null,"col","col",-1959363084),column_40305,new cljs.core.Keyword(null,"name","name",1843675177),name_40339], null));
});})(seq__39757_40307,chunk__39758_40308,count__39759_40309,i__39760_40310,seq__39667_40231,chunk__39668_40232,count__39669_40233,i__39670_40234,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39778_40335,map__39778_40336__$1,gline_40337,gcol_40338,name_40339,seq__39757_40329__$1,temp__5735__auto___40328__$1,vec__39754_40304,column_40305,column_info_40306,seq__39667_40298__$1,temp__5735__auto___40295,vec__39664_40228,line_40229,columns_40230,inverted))
,cljs.core.sorted_map()));


var G__40347 = cljs.core.next(seq__39757_40329__$1);
var G__40348 = null;
var G__40349 = (0);
var G__40350 = (0);
seq__39757_40307 = G__40347;
chunk__39758_40308 = G__40348;
count__39759_40309 = G__40349;
i__39760_40310 = G__40350;
continue;
}
} else {
}
}
break;
}


var G__40351 = cljs.core.next(seq__39667_40298__$1);
var G__40352 = null;
var G__40353 = (0);
var G__40354 = (0);
seq__39667_40231 = G__40351;
chunk__39668_40232 = G__40352;
count__39669_40233 = G__40353;
i__39670_40234 = G__40354;
continue;
}
} else {
}
}
break;
}


var G__40355 = seq__39491_40224;
var G__40356 = chunk__39492_40225;
var G__40357 = count__39493_40226;
var G__40358 = (i__39494_40227 + (1));
seq__39491_40224 = G__40355;
chunk__39492_40225 = G__40356;
count__39493_40226 = G__40357;
i__39494_40227 = G__40358;
continue;
} else {
var temp__5735__auto___40359 = cljs.core.seq(seq__39491_40224);
if(temp__5735__auto___40359){
var seq__39491_40360__$1 = temp__5735__auto___40359;
if(cljs.core.chunked_seq_QMARK_(seq__39491_40360__$1)){
var c__4609__auto___40361 = cljs.core.chunk_first(seq__39491_40360__$1);
var G__40362 = cljs.core.chunk_rest(seq__39491_40360__$1);
var G__40363 = c__4609__auto___40361;
var G__40364 = cljs.core.count(c__4609__auto___40361);
var G__40365 = (0);
seq__39491_40224 = G__40362;
chunk__39492_40225 = G__40363;
count__39493_40226 = G__40364;
i__39494_40227 = G__40365;
continue;
} else {
var vec__39780_40366 = cljs.core.first(seq__39491_40360__$1);
var line_40367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39780_40366,(0),null);
var columns_40368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39780_40366,(1),null);
var seq__39785_40371 = cljs.core.seq(columns_40368);
var chunk__39786_40372 = null;
var count__39787_40373 = (0);
var i__39788_40374 = (0);
while(true){
if((i__39788_40374 < count__39787_40373)){
var vec__39859_40375 = chunk__39786_40372.cljs$core$IIndexed$_nth$arity$2(null,i__39788_40374);
var column_40376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39859_40375,(0),null);
var column_info_40377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39859_40375,(1),null);
var seq__39862_40380 = cljs.core.seq(column_info_40377);
var chunk__39863_40381 = null;
var count__39864_40382 = (0);
var i__39865_40383 = (0);
while(true){
if((i__39865_40383 < count__39864_40382)){
var map__39883_40384 = chunk__39863_40381.cljs$core$IIndexed$_nth$arity$2(null,i__39865_40383);
var map__39883_40385__$1 = (((((!((map__39883_40384 == null))))?(((((map__39883_40384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39883_40384.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39883_40384):map__39883_40384);
var gline_40386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39883_40385__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39883_40385__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39883_40385__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40386], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39862_40380,chunk__39863_40381,count__39864_40382,i__39865_40383,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39883_40384,map__39883_40385__$1,gline_40386,gcol_40387,name_40388,vec__39859_40375,column_40376,column_info_40377,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40387], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40367,new cljs.core.Keyword(null,"col","col",-1959363084),column_40376,new cljs.core.Keyword(null,"name","name",1843675177),name_40388], null));
});})(seq__39862_40380,chunk__39863_40381,count__39864_40382,i__39865_40383,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39883_40384,map__39883_40385__$1,gline_40386,gcol_40387,name_40388,vec__39859_40375,column_40376,column_info_40377,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted))
,cljs.core.sorted_map()));


var G__40393 = seq__39862_40380;
var G__40394 = chunk__39863_40381;
var G__40395 = count__39864_40382;
var G__40396 = (i__39865_40383 + (1));
seq__39862_40380 = G__40393;
chunk__39863_40381 = G__40394;
count__39864_40382 = G__40395;
i__39865_40383 = G__40396;
continue;
} else {
var temp__5735__auto___40397__$1 = cljs.core.seq(seq__39862_40380);
if(temp__5735__auto___40397__$1){
var seq__39862_40399__$1 = temp__5735__auto___40397__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39862_40399__$1)){
var c__4609__auto___40403 = cljs.core.chunk_first(seq__39862_40399__$1);
var G__40404 = cljs.core.chunk_rest(seq__39862_40399__$1);
var G__40405 = c__4609__auto___40403;
var G__40406 = cljs.core.count(c__4609__auto___40403);
var G__40407 = (0);
seq__39862_40380 = G__40404;
chunk__39863_40381 = G__40405;
count__39864_40382 = G__40406;
i__39865_40383 = G__40407;
continue;
} else {
var map__39889_40408 = cljs.core.first(seq__39862_40399__$1);
var map__39889_40409__$1 = (((((!((map__39889_40408 == null))))?(((((map__39889_40408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39889_40408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39889_40408):map__39889_40408);
var gline_40410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39889_40409__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39889_40409__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39889_40409__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40410], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39862_40380,chunk__39863_40381,count__39864_40382,i__39865_40383,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39889_40408,map__39889_40409__$1,gline_40410,gcol_40411,name_40412,seq__39862_40399__$1,temp__5735__auto___40397__$1,vec__39859_40375,column_40376,column_info_40377,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40411], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40367,new cljs.core.Keyword(null,"col","col",-1959363084),column_40376,new cljs.core.Keyword(null,"name","name",1843675177),name_40412], null));
});})(seq__39862_40380,chunk__39863_40381,count__39864_40382,i__39865_40383,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39889_40408,map__39889_40409__$1,gline_40410,gcol_40411,name_40412,seq__39862_40399__$1,temp__5735__auto___40397__$1,vec__39859_40375,column_40376,column_info_40377,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted))
,cljs.core.sorted_map()));


var G__40421 = cljs.core.next(seq__39862_40399__$1);
var G__40422 = null;
var G__40423 = (0);
var G__40424 = (0);
seq__39862_40380 = G__40421;
chunk__39863_40381 = G__40422;
count__39864_40382 = G__40423;
i__39865_40383 = G__40424;
continue;
}
} else {
}
}
break;
}


var G__40425 = seq__39785_40371;
var G__40426 = chunk__39786_40372;
var G__40427 = count__39787_40373;
var G__40428 = (i__39788_40374 + (1));
seq__39785_40371 = G__40425;
chunk__39786_40372 = G__40426;
count__39787_40373 = G__40427;
i__39788_40374 = G__40428;
continue;
} else {
var temp__5735__auto___40431__$1 = cljs.core.seq(seq__39785_40371);
if(temp__5735__auto___40431__$1){
var seq__39785_40432__$1 = temp__5735__auto___40431__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39785_40432__$1)){
var c__4609__auto___40433 = cljs.core.chunk_first(seq__39785_40432__$1);
var G__40434 = cljs.core.chunk_rest(seq__39785_40432__$1);
var G__40435 = c__4609__auto___40433;
var G__40436 = cljs.core.count(c__4609__auto___40433);
var G__40437 = (0);
seq__39785_40371 = G__40434;
chunk__39786_40372 = G__40435;
count__39787_40373 = G__40436;
i__39788_40374 = G__40437;
continue;
} else {
var vec__39896_40438 = cljs.core.first(seq__39785_40432__$1);
var column_40439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39896_40438,(0),null);
var column_info_40440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39896_40438,(1),null);
var seq__39899_40441 = cljs.core.seq(column_info_40440);
var chunk__39900_40442 = null;
var count__39901_40443 = (0);
var i__39902_40444 = (0);
while(true){
if((i__39902_40444 < count__39901_40443)){
var map__39914_40445 = chunk__39900_40442.cljs$core$IIndexed$_nth$arity$2(null,i__39902_40444);
var map__39914_40446__$1 = (((((!((map__39914_40445 == null))))?(((((map__39914_40445.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39914_40445.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39914_40445):map__39914_40445);
var gline_40447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39914_40446__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39914_40446__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39914_40446__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40447], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39899_40441,chunk__39900_40442,count__39901_40443,i__39902_40444,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39914_40445,map__39914_40446__$1,gline_40447,gcol_40448,name_40449,vec__39896_40438,column_40439,column_info_40440,seq__39785_40432__$1,temp__5735__auto___40431__$1,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40448], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40367,new cljs.core.Keyword(null,"col","col",-1959363084),column_40439,new cljs.core.Keyword(null,"name","name",1843675177),name_40449], null));
});})(seq__39899_40441,chunk__39900_40442,count__39901_40443,i__39902_40444,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39914_40445,map__39914_40446__$1,gline_40447,gcol_40448,name_40449,vec__39896_40438,column_40439,column_info_40440,seq__39785_40432__$1,temp__5735__auto___40431__$1,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted))
,cljs.core.sorted_map()));


var G__40455 = seq__39899_40441;
var G__40456 = chunk__39900_40442;
var G__40457 = count__39901_40443;
var G__40458 = (i__39902_40444 + (1));
seq__39899_40441 = G__40455;
chunk__39900_40442 = G__40456;
count__39901_40443 = G__40457;
i__39902_40444 = G__40458;
continue;
} else {
var temp__5735__auto___40459__$2 = cljs.core.seq(seq__39899_40441);
if(temp__5735__auto___40459__$2){
var seq__39899_40460__$1 = temp__5735__auto___40459__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39899_40460__$1)){
var c__4609__auto___40461 = cljs.core.chunk_first(seq__39899_40460__$1);
var G__40462 = cljs.core.chunk_rest(seq__39899_40460__$1);
var G__40463 = c__4609__auto___40461;
var G__40464 = cljs.core.count(c__4609__auto___40461);
var G__40465 = (0);
seq__39899_40441 = G__40462;
chunk__39900_40442 = G__40463;
count__39901_40443 = G__40464;
i__39902_40444 = G__40465;
continue;
} else {
var map__39920_40469 = cljs.core.first(seq__39899_40460__$1);
var map__39920_40470__$1 = (((((!((map__39920_40469 == null))))?(((((map__39920_40469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39920_40469.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39920_40469):map__39920_40469);
var gline_40471 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39920_40470__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40472 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39920_40470__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40473 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39920_40470__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40471], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39899_40441,chunk__39900_40442,count__39901_40443,i__39902_40444,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39920_40469,map__39920_40470__$1,gline_40471,gcol_40472,name_40473,seq__39899_40460__$1,temp__5735__auto___40459__$2,vec__39896_40438,column_40439,column_info_40440,seq__39785_40432__$1,temp__5735__auto___40431__$1,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40472], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40367,new cljs.core.Keyword(null,"col","col",-1959363084),column_40439,new cljs.core.Keyword(null,"name","name",1843675177),name_40473], null));
});})(seq__39899_40441,chunk__39900_40442,count__39901_40443,i__39902_40444,seq__39785_40371,chunk__39786_40372,count__39787_40373,i__39788_40374,seq__39491_40224,chunk__39492_40225,count__39493_40226,i__39494_40227,map__39920_40469,map__39920_40470__$1,gline_40471,gcol_40472,name_40473,seq__39899_40460__$1,temp__5735__auto___40459__$2,vec__39896_40438,column_40439,column_info_40440,seq__39785_40432__$1,temp__5735__auto___40431__$1,vec__39780_40366,line_40367,columns_40368,seq__39491_40360__$1,temp__5735__auto___40359,inverted))
,cljs.core.sorted_map()));


var G__40476 = cljs.core.next(seq__39899_40460__$1);
var G__40477 = null;
var G__40478 = (0);
var G__40479 = (0);
seq__39899_40441 = G__40476;
chunk__39900_40442 = G__40477;
count__39901_40443 = G__40478;
i__39902_40444 = G__40479;
continue;
}
} else {
}
}
break;
}


var G__40480 = cljs.core.next(seq__39785_40432__$1);
var G__40481 = null;
var G__40482 = (0);
var G__40483 = (0);
seq__39785_40371 = G__40480;
chunk__39786_40372 = G__40481;
count__39787_40373 = G__40482;
i__39788_40374 = G__40483;
continue;
}
} else {
}
}
break;
}


var G__40487 = cljs.core.next(seq__39491_40360__$1);
var G__40488 = null;
var G__40489 = (0);
var G__40490 = (0);
seq__39491_40224 = G__40487;
chunk__39492_40225 = G__40488;
count__39493_40226 = G__40489;
i__39494_40227 = G__40490;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
