goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__44632 = (line + (1));
var G__44633 = (1);
var G__44634 = (counter + (1));
line = G__44632;
col = G__44633;
counter = G__44634;
continue;
} else {
var G__44635 = line;
var G__44636 = (col + (1));
var G__44637 = (counter + (1));
line = G__44635;
col = G__44636;
counter = G__44637;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__44638 = cljs.core.next(chars);
var G__44639 = (n__$1 - (1));
chars = G__44638;
n__$1 = G__44639;
continue;
} else {
var G__44640 = cljs.core.next(chars);
var G__44641 = n__$1;
chars = G__44640;
n__$1 = G__44641;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__44621){
var map__44622 = p__44621;
var map__44622__$1 = (((((!((map__44622 == null))))?(((((map__44622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44622.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44622):map__44622);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44622__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44622__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44622__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44622__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__44624_44642 = cljs.core.seq(full_reasons);
var chunk__44625_44643 = null;
var count__44626_44644 = (0);
var i__44627_44645 = (0);
while(true){
if((i__44627_44645 < count__44626_44644)){
var r_44646 = chunk__44625_44643.cljs$core$IIndexed$_nth$arity$2(null,i__44627_44645);
instaparse.failure.print_reason(r_44646);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__44647 = seq__44624_44642;
var G__44648 = chunk__44625_44643;
var G__44649 = count__44626_44644;
var G__44650 = (i__44627_44645 + (1));
seq__44624_44642 = G__44647;
chunk__44625_44643 = G__44648;
count__44626_44644 = G__44649;
i__44627_44645 = G__44650;
continue;
} else {
var temp__5735__auto___44651 = cljs.core.seq(seq__44624_44642);
if(temp__5735__auto___44651){
var seq__44624_44652__$1 = temp__5735__auto___44651;
if(cljs.core.chunked_seq_QMARK_(seq__44624_44652__$1)){
var c__4609__auto___44653 = cljs.core.chunk_first(seq__44624_44652__$1);
var G__44654 = cljs.core.chunk_rest(seq__44624_44652__$1);
var G__44655 = c__4609__auto___44653;
var G__44656 = cljs.core.count(c__4609__auto___44653);
var G__44657 = (0);
seq__44624_44642 = G__44654;
chunk__44625_44643 = G__44655;
count__44626_44644 = G__44656;
i__44627_44645 = G__44657;
continue;
} else {
var r_44658 = cljs.core.first(seq__44624_44652__$1);
instaparse.failure.print_reason(r_44658);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__44659 = cljs.core.next(seq__44624_44652__$1);
var G__44660 = null;
var G__44661 = (0);
var G__44662 = (0);
seq__44624_44642 = G__44659;
chunk__44625_44643 = G__44660;
count__44626_44644 = G__44661;
i__44627_44645 = G__44662;
continue;
}
} else {
}
}
break;
}

var seq__44628 = cljs.core.seq(partial_reasons);
var chunk__44629 = null;
var count__44630 = (0);
var i__44631 = (0);
while(true){
if((i__44631 < count__44630)){
var r = chunk__44629.cljs$core$IIndexed$_nth$arity$2(null,i__44631);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__44663 = seq__44628;
var G__44664 = chunk__44629;
var G__44665 = count__44630;
var G__44666 = (i__44631 + (1));
seq__44628 = G__44663;
chunk__44629 = G__44664;
count__44630 = G__44665;
i__44631 = G__44666;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44628);
if(temp__5735__auto__){
var seq__44628__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44628__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44628__$1);
var G__44667 = cljs.core.chunk_rest(seq__44628__$1);
var G__44668 = c__4609__auto__;
var G__44669 = cljs.core.count(c__4609__auto__);
var G__44670 = (0);
seq__44628 = G__44667;
chunk__44629 = G__44668;
count__44630 = G__44669;
i__44631 = G__44670;
continue;
} else {
var r = cljs.core.first(seq__44628__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__44671 = cljs.core.next(seq__44628__$1);
var G__44672 = null;
var G__44673 = (0);
var G__44674 = (0);
seq__44628 = G__44671;
chunk__44629 = G__44672;
count__44630 = G__44673;
i__44631 = G__44674;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
