goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__36832 = e.target.readyState;
var fexpr__36831 = new cljs.core.PersistentArrayMap(null, 6, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276),new cljs.core.Keyword("cljs.analyzer","analyzed","cljs.analyzer/analyzed",-735094162),true], null);
return (fexpr__36831.cljs$core$IFn$_invoke$arity$1 ? fexpr__36831.cljs$core$IFn$_invoke$arity$1(G__36832) : fexpr__36831.call(null,G__36832));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__36834,handler){
var map__36835 = p__36834;
var map__36835__$1 = (((((!((map__36835 == null))))?(((((map__36835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36835.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36835):map__36835);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__36835__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__36835__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
(this$__$1.withCredentials = with_credentials);

(this$__$1.onreadystatechange = (function (p1__36833_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__36833_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
}));

this$__$1.open(method,uri,true);

(this$__$1.timeout = timeout);

var temp__5735__auto___36853 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___36853)){
var response_type_36854 = temp__5735__auto___36853;
(this$__$1.responseType = cljs.core.name(response_type_36854));
} else {
}

var seq__36837_36855 = cljs.core.seq(headers);
var chunk__36838_36856 = null;
var count__36839_36857 = (0);
var i__36840_36858 = (0);
while(true){
if((i__36840_36858 < count__36839_36857)){
var vec__36847_36859 = chunk__36838_36856.cljs$core$IIndexed$_nth$arity$2(null,i__36840_36858);
var k_36860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36847_36859,(0),null);
var v_36861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36847_36859,(1),null);
this$__$1.setRequestHeader(k_36860,v_36861);


var G__36862 = seq__36837_36855;
var G__36863 = chunk__36838_36856;
var G__36864 = count__36839_36857;
var G__36865 = (i__36840_36858 + (1));
seq__36837_36855 = G__36862;
chunk__36838_36856 = G__36863;
count__36839_36857 = G__36864;
i__36840_36858 = G__36865;
continue;
} else {
var temp__5735__auto___36866 = cljs.core.seq(seq__36837_36855);
if(temp__5735__auto___36866){
var seq__36837_36867__$1 = temp__5735__auto___36866;
if(cljs.core.chunked_seq_QMARK_(seq__36837_36867__$1)){
var c__4609__auto___36868 = cljs.core.chunk_first(seq__36837_36867__$1);
var G__36869 = cljs.core.chunk_rest(seq__36837_36867__$1);
var G__36870 = c__4609__auto___36868;
var G__36871 = cljs.core.count(c__4609__auto___36868);
var G__36872 = (0);
seq__36837_36855 = G__36869;
chunk__36838_36856 = G__36870;
count__36839_36857 = G__36871;
i__36840_36858 = G__36872;
continue;
} else {
var vec__36850_36873 = cljs.core.first(seq__36837_36867__$1);
var k_36874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36850_36873,(0),null);
var v_36875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36850_36873,(1),null);
this$__$1.setRequestHeader(k_36874,v_36875);


var G__36878 = cljs.core.next(seq__36837_36867__$1);
var G__36879 = null;
var G__36880 = (0);
var G__36881 = (0);
seq__36837_36855 = G__36878;
chunk__36838_36856 = G__36879;
count__36839_36857 = G__36880;
i__36840_36858 = G__36881;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4185__auto__ = body;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());

return this$__$1;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
}));

//# sourceMappingURL=ajax.xml_http_request.js.map
