goog.provide('pinkgorilla.notebook.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('pinkgorilla.notebook.uuid');
goog.require('pinkgorilla.encoding.decode');
goog.require('pinkgorilla.encoding.encode');
goog.require('pinkgorilla.storage.storage');
/**
 * creates an empty hydrated notebook
 */
pinkgorilla.notebook.core.empty_notebook = (function pinkgorilla$notebook$core$empty_notebook(){
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"version","version",425292698),(2),new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"segments","segments",1937535949),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ns","ns",441598760),null,new cljs.core.Keyword(null,"segment-order","segment-order",476484406),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"queued-code-segments","queued-code-segments",-1303126826),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054),null], null);
});
pinkgorilla.notebook.core.segments_ordered = (function pinkgorilla$notebook$core$segments_ordered(notebook){
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(notebook);
var segment_ids_ordered = new cljs.core.Keyword(null,"segment-order","segment-order",476484406).cljs$core$IFn$_invoke$arity$1(notebook);
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46408_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(segments,p1__46408_SHARP_);
}),segment_ids_ordered));
});
pinkgorilla.notebook.core.dissoc_in = (function pinkgorilla$notebook$core$dissoc_in(m,p__46409){
var vec__46410 = p__46409;
var seq__46411 = cljs.core.seq(vec__46410);
var first__46412 = cljs.core.first(seq__46411);
var seq__46411__$1 = cljs.core.next(seq__46411);
var k = first__46412;
var ks = seq__46411__$1;
var keys = vec__46410;
if(ks){
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__5733__auto__)){
var nextmap = temp__5733__auto__;
var newmap = (pinkgorilla.notebook.core.dissoc_in.cljs$core$IFn$_invoke$arity$2 ? pinkgorilla.notebook.core.dissoc_in.cljs$core$IFn$_invoke$arity$2(nextmap,ks) : pinkgorilla.notebook.core.dissoc_in.call(null,nextmap,ks));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,newmap);
} else {
return m;
}
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}
});
pinkgorilla.notebook.core.dehydrate_notebook = (function pinkgorilla$notebook$core$dehydrate_notebook(notebook){
var segments = pinkgorilla.notebook.core.segments_ordered(notebook);
var segments_no_id = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46413_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(p1__46413_SHARP_,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"error-text","error-text",2021893718)], 0));
}),segments));
var segments_no_id__$1 = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46414_SHARP_){
return pinkgorilla.notebook.core.dissoc_in(p1__46414_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.Keyword(null,"reagent","reagent",2131627322)], null));
}),segments_no_id));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"version","version",425292698),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(notebook),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(notebook),new cljs.core.Keyword(null,"segments","segments",1937535949),segments_no_id__$1], null);
});
pinkgorilla.notebook.core.to_key = (function pinkgorilla$notebook$core$to_key(segment){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(segment),segment]);
});
pinkgorilla.notebook.core.hydrate_notebook = (function pinkgorilla$notebook$core$hydrate_notebook(notebook){
var version = new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(notebook);
var meta = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(notebook);
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(notebook);
var segments_with_id = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46415_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__46415_SHARP_,new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.notebook.uuid.guuid(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"exception","exception",-335277064),null,new cljs.core.Keyword(null,"error-text","error-text",2021893718),null], 0));
}),segments));
var ids = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092),segments_with_id));
var m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.core.to_key,segments_with_id));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pinkgorilla.notebook.core.empty_notebook(),new cljs.core.Keyword(null,"version","version",425292698),version,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"meta","meta",1499536964),meta,new cljs.core.Keyword(null,"segment-order","segment-order",476484406),ids,new cljs.core.Keyword(null,"segments","segments",1937535949),m], 0));
});
pinkgorilla.notebook.core.load_notebook_hydrated = (function pinkgorilla$notebook$core$load_notebook_hydrated(var_args){
var G__46417 = arguments.length;
switch (G__46417) {
case 1:
return pinkgorilla.notebook.core.load_notebook_hydrated.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return pinkgorilla.notebook.core.load_notebook_hydrated.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.notebook.core.load_notebook_hydrated.cljs$core$IFn$_invoke$arity$1 = (function (str){
return pinkgorilla.notebook.core.load_notebook_hydrated.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"gorilla","gorilla",-211534157),str);
}));

(pinkgorilla.notebook.core.load_notebook_hydrated.cljs$core$IFn$_invoke$arity$2 = (function (format,str){
return pinkgorilla.notebook.core.hydrate_notebook((pinkgorilla.encoding.decode.decode.cljs$core$IFn$_invoke$arity$2 ? pinkgorilla.encoding.decode.decode.cljs$core$IFn$_invoke$arity$2(format,str) : pinkgorilla.encoding.decode.decode.call(null,format,str)));
}));

(pinkgorilla.notebook.core.load_notebook_hydrated.cljs$lang$maxFixedArity = 2);

pinkgorilla.notebook.core.save_notebook_hydrated = (function pinkgorilla$notebook$core$save_notebook_hydrated(notebook){
return pinkgorilla.encoding.encode.encode_notebook(pinkgorilla.notebook.core.dehydrate_notebook(notebook));
});
pinkgorilla.notebook.core.notebook_save = (function pinkgorilla$notebook$core$notebook_save(storage,tokens,notebook){
var content = pinkgorilla.notebook.core.save_notebook_hydrated(notebook);
return pinkgorilla.storage.storage.storage_save(storage,content,tokens);
});
pinkgorilla.notebook.core.notebook_load = (function pinkgorilla$notebook$core$notebook_load(storage,tokens){
var content = pinkgorilla.storage.storage.storage_load(storage,tokens);
return pinkgorilla.notebook.core.load_notebook_hydrated.cljs$core$IFn$_invoke$arity$1(content);
});
/**
 * creates a markdown segment
 */
pinkgorilla.notebook.core.create_free_segment = (function pinkgorilla$notebook$core$create_free_segment(content){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.notebook.uuid.guuid(),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4185__auto__ = content;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown"], null)], null);
});
pinkgorilla.notebook.core.create_code_segment = (function pinkgorilla$notebook$core$create_code_segment(content){
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.notebook.uuid.guuid(),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),new cljs.core.Keyword(null,"clj","clj",-660495428),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4185__auto__ = content;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure"], null),new cljs.core.Keyword(null,"console-response","console-response",81719661),"",new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"html",new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991)], null)], null),new cljs.core.Keyword(null,"error-text","error-text",2021893718),null,new cljs.core.Keyword(null,"exception","exception",-335277064),null], null);
});
pinkgorilla.notebook.core.to_code_segment = (function pinkgorilla$notebook$core$to_code_segment(free_segment){
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(free_segment),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),new cljs.core.Keyword(null,"clj","clj",-660495428),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(free_segment,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null)),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure"], null),new cljs.core.Keyword(null,"console-response","console-response",81719661),null,new cljs.core.Keyword(null,"value-response","value-response",-1249272942),null,new cljs.core.Keyword(null,"error-text","error-text",2021893718),null,new cljs.core.Keyword(null,"exception","exception",-335277064),null], null);
});
pinkgorilla.notebook.core.to_free_segment = (function pinkgorilla$notebook$core$to_free_segment(code_segment){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(code_segment),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(code_segment,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null)),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown"], null)], null);
});
pinkgorilla.notebook.core.insert_segment_at = (function pinkgorilla$notebook$core$insert_segment_at(worksheet,new_index,new_segment){
var segment_order = new cljs.core.Keyword(null,"segment-order","segment-order",476484406).cljs$core$IFn$_invoke$arity$1(worksheet);
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(worksheet);
var new_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(new_segment);
var vec__46418 = cljs.core.split_at(new_index,segment_order);
var head = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46418,(0),null);
var tail = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46418,(1),null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([worksheet,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054),new_id,new cljs.core.Keyword(null,"segments","segments",1937535949),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(segments,new_id,new_segment),new cljs.core.Keyword(null,"segment-order","segment-order",476484406),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(head,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(tail,new_id)))], null)], 0));
});
pinkgorilla.notebook.core.remove_segment = (function pinkgorilla$notebook$core$remove_segment(worksheet,seg_id){
var segment_order = new cljs.core.Keyword(null,"segment-order","segment-order",476484406).cljs$core$IFn$_invoke$arity$1(worksheet);
var active_id = new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054).cljs$core$IFn$_invoke$arity$1(worksheet);
var seg_idx = segment_order.indexOf(seg_id);
var next_active_idx = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_id,seg_id)) && ((seg_idx > (0)))))?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(segment_order,(seg_idx - (1))):null);
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(worksheet);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([worksheet,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054),next_active_idx,new cljs.core.Keyword(null,"segments","segments",1937535949),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(segments,seg_id),new cljs.core.Keyword(null,"segment-order","segment-order",476484406),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__46421_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(seg_id,p1__46421_SHARP_);
}),segment_order))], null)], 0));
});

//# sourceMappingURL=pinkgorilla.notebook.core.js.map
