goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__38977){
var vec__38978 = p__38977;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__38981 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__38984 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(4),null);
var vec__38987 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__38994 = segmap;
var map__38994__$1 = (((((!((map__38994 == null))))?(((((map__38994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38994.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38994):map__38994);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38994__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38994__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38994__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38994__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38994__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__38997 = arguments.length;
switch (G__38997) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39005 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39907 = cljs.core.next(segs__$1);
var G__39908 = nrelseg;
var G__39909 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39907;
relseg__$1 = G__39908;
result__$1 = G__39909;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39005,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39005,(1),null);
var G__39910 = (gline + (1));
var G__39911 = cljs.core.next(lines__$1);
var G__39912 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39913 = result__$1;
gline = G__39910;
lines__$1 = G__39911;
relseg = G__39912;
result = G__39913;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__39012 = segmap;
var map__39012__$1 = (((((!((map__39012 == null))))?(((((map__39012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39012.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39012):map__39012);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__39011_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39011_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__39021 = arguments.length;
switch (G__39021) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39034 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39927 = cljs.core.next(segs__$1);
var G__39928 = nrelseg;
var G__39929 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39927;
relseg__$1 = G__39928;
result__$1 = G__39929;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39034,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39034,(1),null);
var G__39930 = (gline + (1));
var G__39931 = cljs.core.next(lines__$1);
var G__39932 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39933 = result__$1;
gline = G__39930;
lines__$1 = G__39931;
relseg = G__39932;
result = G__39933;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39041){
var vec__39044 = p__39041;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39044,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39044,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39044,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39044,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39044,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__39049){
var vec__39050 = p__39049;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(4),null);
var seg = vec__39050;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39053){
var vec__39054 = p__39053;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__39063 = cljs.core.seq(infos);
var chunk__39064 = null;
var count__39065 = (0);
var i__39066 = (0);
while(true){
if((i__39066 < count__39065)){
var info = chunk__39064.cljs$core$IIndexed$_nth$arity$2(null,i__39066);
var segv_39942 = info__GT_segv(info,source_idx,line,col);
var gline_39943 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39944 = cljs.core.count(cljs.core.deref(lines));
if((gline_39943 > (lc_39944 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39942,gline_39943,lc_39944,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39943 - (lc_39944 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39942], null));
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39942,gline_39943,lc_39944,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39942,gline_39943,lc_39944,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39943], null),cljs.core.conj,segv_39942);
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39942,gline_39943,lc_39944,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39951 = seq__39063;
var G__39952 = chunk__39064;
var G__39953 = count__39065;
var G__39954 = (i__39066 + (1));
seq__39063 = G__39951;
chunk__39064 = G__39952;
count__39065 = G__39953;
i__39066 = G__39954;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39063);
if(temp__5735__auto__){
var seq__39063__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39063__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39063__$1);
var G__39957 = cljs.core.chunk_rest(seq__39063__$1);
var G__39958 = c__4609__auto__;
var G__39959 = cljs.core.count(c__4609__auto__);
var G__39960 = (0);
seq__39063 = G__39957;
chunk__39064 = G__39958;
count__39065 = G__39959;
i__39066 = G__39960;
continue;
} else {
var info = cljs.core.first(seq__39063__$1);
var segv_39961 = info__GT_segv(info,source_idx,line,col);
var gline_39962 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39963 = cljs.core.count(cljs.core.deref(lines));
if((gline_39962 > (lc_39963 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39961,gline_39962,lc_39963,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39962 - (lc_39963 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39961], null));
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39961,gline_39962,lc_39963,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39961,gline_39962,lc_39963,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39962], null),cljs.core.conj,segv_39961);
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39961,gline_39962,lc_39963,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39969 = cljs.core.next(seq__39063__$1);
var G__39970 = null;
var G__39971 = (0);
var G__39972 = (0);
seq__39063 = G__39969;
chunk__39064 = G__39970;
count__39065 = G__39971;
i__39066 = G__39972;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__39075_39973 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__39076_39974 = null;
var count__39077_39975 = (0);
var i__39078_39976 = (0);
while(true){
if((i__39078_39976 < count__39077_39975)){
var vec__39280_39977 = chunk__39076_39974.cljs$core$IIndexed$_nth$arity$2(null,i__39078_39976);
var source_idx_39978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39280_39977,(0),null);
var vec__39283_39979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39280_39977,(1),null);
var __39980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39283_39979,(0),null);
var lines_39981__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39283_39979,(1),null);
var seq__39286_39982 = cljs.core.seq(lines_39981__$1);
var chunk__39287_39983 = null;
var count__39288_39984 = (0);
var i__39289_39985 = (0);
while(true){
if((i__39289_39985 < count__39288_39984)){
var vec__39337_39986 = chunk__39287_39983.cljs$core$IIndexed$_nth$arity$2(null,i__39289_39985);
var line_39987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39337_39986,(0),null);
var cols_39988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39337_39986,(1),null);
var seq__39340_39989 = cljs.core.seq(cols_39988);
var chunk__39341_39990 = null;
var count__39342_39991 = (0);
var i__39343_39992 = (0);
while(true){
if((i__39343_39992 < count__39342_39991)){
var vec__39352_39993 = chunk__39341_39990.cljs$core$IIndexed$_nth$arity$2(null,i__39343_39992);
var col_39994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39352_39993,(0),null);
var infos_39995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39352_39993,(1),null);
encode_cols(infos_39995,source_idx_39978,line_39987,col_39994);


var G__39996 = seq__39340_39989;
var G__39997 = chunk__39341_39990;
var G__39998 = count__39342_39991;
var G__39999 = (i__39343_39992 + (1));
seq__39340_39989 = G__39996;
chunk__39341_39990 = G__39997;
count__39342_39991 = G__39998;
i__39343_39992 = G__39999;
continue;
} else {
var temp__5735__auto___40000 = cljs.core.seq(seq__39340_39989);
if(temp__5735__auto___40000){
var seq__39340_40001__$1 = temp__5735__auto___40000;
if(cljs.core.chunked_seq_QMARK_(seq__39340_40001__$1)){
var c__4609__auto___40002 = cljs.core.chunk_first(seq__39340_40001__$1);
var G__40003 = cljs.core.chunk_rest(seq__39340_40001__$1);
var G__40004 = c__4609__auto___40002;
var G__40005 = cljs.core.count(c__4609__auto___40002);
var G__40006 = (0);
seq__39340_39989 = G__40003;
chunk__39341_39990 = G__40004;
count__39342_39991 = G__40005;
i__39343_39992 = G__40006;
continue;
} else {
var vec__39355_40007 = cljs.core.first(seq__39340_40001__$1);
var col_40008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39355_40007,(0),null);
var infos_40009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39355_40007,(1),null);
encode_cols(infos_40009,source_idx_39978,line_39987,col_40008);


var G__40010 = cljs.core.next(seq__39340_40001__$1);
var G__40011 = null;
var G__40012 = (0);
var G__40013 = (0);
seq__39340_39989 = G__40010;
chunk__39341_39990 = G__40011;
count__39342_39991 = G__40012;
i__39343_39992 = G__40013;
continue;
}
} else {
}
}
break;
}


var G__40014 = seq__39286_39982;
var G__40015 = chunk__39287_39983;
var G__40016 = count__39288_39984;
var G__40017 = (i__39289_39985 + (1));
seq__39286_39982 = G__40014;
chunk__39287_39983 = G__40015;
count__39288_39984 = G__40016;
i__39289_39985 = G__40017;
continue;
} else {
var temp__5735__auto___40018 = cljs.core.seq(seq__39286_39982);
if(temp__5735__auto___40018){
var seq__39286_40019__$1 = temp__5735__auto___40018;
if(cljs.core.chunked_seq_QMARK_(seq__39286_40019__$1)){
var c__4609__auto___40020 = cljs.core.chunk_first(seq__39286_40019__$1);
var G__40021 = cljs.core.chunk_rest(seq__39286_40019__$1);
var G__40022 = c__4609__auto___40020;
var G__40023 = cljs.core.count(c__4609__auto___40020);
var G__40024 = (0);
seq__39286_39982 = G__40021;
chunk__39287_39983 = G__40022;
count__39288_39984 = G__40023;
i__39289_39985 = G__40024;
continue;
} else {
var vec__39358_40025 = cljs.core.first(seq__39286_40019__$1);
var line_40026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39358_40025,(0),null);
var cols_40027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39358_40025,(1),null);
var seq__39361_40029 = cljs.core.seq(cols_40027);
var chunk__39362_40030 = null;
var count__39363_40031 = (0);
var i__39364_40032 = (0);
while(true){
if((i__39364_40032 < count__39363_40031)){
var vec__39373_40033 = chunk__39362_40030.cljs$core$IIndexed$_nth$arity$2(null,i__39364_40032);
var col_40034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39373_40033,(0),null);
var infos_40035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39373_40033,(1),null);
encode_cols(infos_40035,source_idx_39978,line_40026,col_40034);


var G__40036 = seq__39361_40029;
var G__40037 = chunk__39362_40030;
var G__40038 = count__39363_40031;
var G__40039 = (i__39364_40032 + (1));
seq__39361_40029 = G__40036;
chunk__39362_40030 = G__40037;
count__39363_40031 = G__40038;
i__39364_40032 = G__40039;
continue;
} else {
var temp__5735__auto___40040__$1 = cljs.core.seq(seq__39361_40029);
if(temp__5735__auto___40040__$1){
var seq__39361_40041__$1 = temp__5735__auto___40040__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39361_40041__$1)){
var c__4609__auto___40042 = cljs.core.chunk_first(seq__39361_40041__$1);
var G__40043 = cljs.core.chunk_rest(seq__39361_40041__$1);
var G__40044 = c__4609__auto___40042;
var G__40045 = cljs.core.count(c__4609__auto___40042);
var G__40046 = (0);
seq__39361_40029 = G__40043;
chunk__39362_40030 = G__40044;
count__39363_40031 = G__40045;
i__39364_40032 = G__40046;
continue;
} else {
var vec__39376_40047 = cljs.core.first(seq__39361_40041__$1);
var col_40048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39376_40047,(0),null);
var infos_40049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39376_40047,(1),null);
encode_cols(infos_40049,source_idx_39978,line_40026,col_40048);


var G__40050 = cljs.core.next(seq__39361_40041__$1);
var G__40051 = null;
var G__40052 = (0);
var G__40053 = (0);
seq__39361_40029 = G__40050;
chunk__39362_40030 = G__40051;
count__39363_40031 = G__40052;
i__39364_40032 = G__40053;
continue;
}
} else {
}
}
break;
}


var G__40054 = cljs.core.next(seq__39286_40019__$1);
var G__40055 = null;
var G__40056 = (0);
var G__40057 = (0);
seq__39286_39982 = G__40054;
chunk__39287_39983 = G__40055;
count__39288_39984 = G__40056;
i__39289_39985 = G__40057;
continue;
}
} else {
}
}
break;
}


var G__40058 = seq__39075_39973;
var G__40059 = chunk__39076_39974;
var G__40060 = count__39077_39975;
var G__40061 = (i__39078_39976 + (1));
seq__39075_39973 = G__40058;
chunk__39076_39974 = G__40059;
count__39077_39975 = G__40060;
i__39078_39976 = G__40061;
continue;
} else {
var temp__5735__auto___40062 = cljs.core.seq(seq__39075_39973);
if(temp__5735__auto___40062){
var seq__39075_40063__$1 = temp__5735__auto___40062;
if(cljs.core.chunked_seq_QMARK_(seq__39075_40063__$1)){
var c__4609__auto___40064 = cljs.core.chunk_first(seq__39075_40063__$1);
var G__40065 = cljs.core.chunk_rest(seq__39075_40063__$1);
var G__40066 = c__4609__auto___40064;
var G__40067 = cljs.core.count(c__4609__auto___40064);
var G__40068 = (0);
seq__39075_39973 = G__40065;
chunk__39076_39974 = G__40066;
count__39077_39975 = G__40067;
i__39078_39976 = G__40068;
continue;
} else {
var vec__39381_40069 = cljs.core.first(seq__39075_40063__$1);
var source_idx_40070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40069,(0),null);
var vec__39384_40071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40069,(1),null);
var __40072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40071,(0),null);
var lines_40073__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40071,(1),null);
var seq__39387_40074 = cljs.core.seq(lines_40073__$1);
var chunk__39388_40075 = null;
var count__39389_40076 = (0);
var i__39390_40077 = (0);
while(true){
if((i__39390_40077 < count__39389_40076)){
var vec__39429_40078 = chunk__39388_40075.cljs$core$IIndexed$_nth$arity$2(null,i__39390_40077);
var line_40079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40078,(0),null);
var cols_40080 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40078,(1),null);
var seq__39432_40081 = cljs.core.seq(cols_40080);
var chunk__39433_40082 = null;
var count__39434_40083 = (0);
var i__39435_40084 = (0);
while(true){
if((i__39435_40084 < count__39434_40083)){
var vec__39442_40085 = chunk__39433_40082.cljs$core$IIndexed$_nth$arity$2(null,i__39435_40084);
var col_40086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39442_40085,(0),null);
var infos_40087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39442_40085,(1),null);
encode_cols(infos_40087,source_idx_40070,line_40079,col_40086);


var G__40088 = seq__39432_40081;
var G__40089 = chunk__39433_40082;
var G__40090 = count__39434_40083;
var G__40091 = (i__39435_40084 + (1));
seq__39432_40081 = G__40088;
chunk__39433_40082 = G__40089;
count__39434_40083 = G__40090;
i__39435_40084 = G__40091;
continue;
} else {
var temp__5735__auto___40092__$1 = cljs.core.seq(seq__39432_40081);
if(temp__5735__auto___40092__$1){
var seq__39432_40093__$1 = temp__5735__auto___40092__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39432_40093__$1)){
var c__4609__auto___40094 = cljs.core.chunk_first(seq__39432_40093__$1);
var G__40095 = cljs.core.chunk_rest(seq__39432_40093__$1);
var G__40096 = c__4609__auto___40094;
var G__40097 = cljs.core.count(c__4609__auto___40094);
var G__40098 = (0);
seq__39432_40081 = G__40095;
chunk__39433_40082 = G__40096;
count__39434_40083 = G__40097;
i__39435_40084 = G__40098;
continue;
} else {
var vec__39445_40099 = cljs.core.first(seq__39432_40093__$1);
var col_40100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39445_40099,(0),null);
var infos_40101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39445_40099,(1),null);
encode_cols(infos_40101,source_idx_40070,line_40079,col_40100);


var G__40102 = cljs.core.next(seq__39432_40093__$1);
var G__40103 = null;
var G__40104 = (0);
var G__40105 = (0);
seq__39432_40081 = G__40102;
chunk__39433_40082 = G__40103;
count__39434_40083 = G__40104;
i__39435_40084 = G__40105;
continue;
}
} else {
}
}
break;
}


var G__40106 = seq__39387_40074;
var G__40107 = chunk__39388_40075;
var G__40108 = count__39389_40076;
var G__40109 = (i__39390_40077 + (1));
seq__39387_40074 = G__40106;
chunk__39388_40075 = G__40107;
count__39389_40076 = G__40108;
i__39390_40077 = G__40109;
continue;
} else {
var temp__5735__auto___40110__$1 = cljs.core.seq(seq__39387_40074);
if(temp__5735__auto___40110__$1){
var seq__39387_40111__$1 = temp__5735__auto___40110__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39387_40111__$1)){
var c__4609__auto___40112 = cljs.core.chunk_first(seq__39387_40111__$1);
var G__40113 = cljs.core.chunk_rest(seq__39387_40111__$1);
var G__40114 = c__4609__auto___40112;
var G__40115 = cljs.core.count(c__4609__auto___40112);
var G__40116 = (0);
seq__39387_40074 = G__40113;
chunk__39388_40075 = G__40114;
count__39389_40076 = G__40115;
i__39390_40077 = G__40116;
continue;
} else {
var vec__39448_40117 = cljs.core.first(seq__39387_40111__$1);
var line_40118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39448_40117,(0),null);
var cols_40119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39448_40117,(1),null);
var seq__39451_40120 = cljs.core.seq(cols_40119);
var chunk__39452_40121 = null;
var count__39453_40122 = (0);
var i__39454_40123 = (0);
while(true){
if((i__39454_40123 < count__39453_40122)){
var vec__39461_40124 = chunk__39452_40121.cljs$core$IIndexed$_nth$arity$2(null,i__39454_40123);
var col_40125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39461_40124,(0),null);
var infos_40126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39461_40124,(1),null);
encode_cols(infos_40126,source_idx_40070,line_40118,col_40125);


var G__40127 = seq__39451_40120;
var G__40128 = chunk__39452_40121;
var G__40129 = count__39453_40122;
var G__40130 = (i__39454_40123 + (1));
seq__39451_40120 = G__40127;
chunk__39452_40121 = G__40128;
count__39453_40122 = G__40129;
i__39454_40123 = G__40130;
continue;
} else {
var temp__5735__auto___40131__$2 = cljs.core.seq(seq__39451_40120);
if(temp__5735__auto___40131__$2){
var seq__39451_40132__$1 = temp__5735__auto___40131__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39451_40132__$1)){
var c__4609__auto___40133 = cljs.core.chunk_first(seq__39451_40132__$1);
var G__40136 = cljs.core.chunk_rest(seq__39451_40132__$1);
var G__40137 = c__4609__auto___40133;
var G__40138 = cljs.core.count(c__4609__auto___40133);
var G__40139 = (0);
seq__39451_40120 = G__40136;
chunk__39452_40121 = G__40137;
count__39453_40122 = G__40138;
i__39454_40123 = G__40139;
continue;
} else {
var vec__39464_40140 = cljs.core.first(seq__39451_40132__$1);
var col_40141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39464_40140,(0),null);
var infos_40142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39464_40140,(1),null);
encode_cols(infos_40142,source_idx_40070,line_40118,col_40141);


var G__40143 = cljs.core.next(seq__39451_40132__$1);
var G__40144 = null;
var G__40145 = (0);
var G__40146 = (0);
seq__39451_40120 = G__40143;
chunk__39452_40121 = G__40144;
count__39453_40122 = G__40145;
i__39454_40123 = G__40146;
continue;
}
} else {
}
}
break;
}


var G__40149 = cljs.core.next(seq__39387_40111__$1);
var G__40150 = null;
var G__40151 = (0);
var G__40152 = (0);
seq__39387_40074 = G__40149;
chunk__39388_40075 = G__40150;
count__39389_40076 = G__40151;
i__39390_40077 = G__40152;
continue;
}
} else {
}
}
break;
}


var G__40153 = cljs.core.next(seq__39075_40063__$1);
var G__40154 = null;
var G__40155 = (0);
var G__40156 = (0);
seq__39075_39973 = G__40153;
chunk__39076_39974 = G__40154;
count__39077_39975 = G__40155;
i__39078_39976 = G__40156;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__39472 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__39058_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39058_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__39059_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__39059_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39060_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__39060_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__39473 = G__39472;
var G__39474_40160 = G__39473;
var G__39475_40161 = "sourcesContent";
var G__39476_40162 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__39474_40160,G__39475_40161,G__39476_40162);

return G__39473;
} else {
return G__39472;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__39477 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39477,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39477,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__39480 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39480,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39480,(1),null);
var G__40164 = cljs.core.next(col_map_seq);
var G__40165 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__39480,col,infos,vec__39477,line,col_map){
return (function (v,p__39483){
var map__39484 = p__39483;
var map__39484__$1 = (((((!((map__39484 == null))))?(((((map__39484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39484):map__39484);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39484__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39484__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__39480,col,infos,vec__39477,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__40164;
new_cols = G__40165;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__40170 = cljs.core.next(line_map_seq);
var G__40171 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__40170;
new_lines = G__40171;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__39488_40172 = cljs.core.seq(reverse_map);
var chunk__39489_40173 = null;
var count__39490_40174 = (0);
var i__39491_40175 = (0);
while(true){
if((i__39491_40175 < count__39490_40174)){
var vec__39655_40176 = chunk__39489_40173.cljs$core$IIndexed$_nth$arity$2(null,i__39491_40175);
var line_40177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39655_40176,(0),null);
var columns_40178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39655_40176,(1),null);
var seq__39658_40179 = cljs.core.seq(columns_40178);
var chunk__39659_40180 = null;
var count__39660_40181 = (0);
var i__39661_40182 = (0);
while(true){
if((i__39661_40182 < count__39660_40181)){
var vec__39695_40183 = chunk__39659_40180.cljs$core$IIndexed$_nth$arity$2(null,i__39661_40182);
var column_40184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39695_40183,(0),null);
var column_info_40185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39695_40183,(1),null);
var seq__39700_40186 = cljs.core.seq(column_info_40185);
var chunk__39701_40187 = null;
var count__39702_40188 = (0);
var i__39703_40189 = (0);
while(true){
if((i__39703_40189 < count__39702_40188)){
var map__39712_40190 = chunk__39701_40187.cljs$core$IIndexed$_nth$arity$2(null,i__39703_40189);
var map__39712_40191__$1 = (((((!((map__39712_40190 == null))))?(((((map__39712_40190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39712_40190.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39712_40190):map__39712_40190);
var gline_40192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39712_40191__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39712_40191__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39712_40191__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40192], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39700_40186,chunk__39701_40187,count__39702_40188,i__39703_40189,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39712_40190,map__39712_40191__$1,gline_40192,gcol_40193,name_40194,vec__39695_40183,column_40184,column_info_40185,vec__39655_40176,line_40177,columns_40178,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40193], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40177,new cljs.core.Keyword(null,"col","col",-1959363084),column_40184,new cljs.core.Keyword(null,"name","name",1843675177),name_40194], null));
});})(seq__39700_40186,chunk__39701_40187,count__39702_40188,i__39703_40189,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39712_40190,map__39712_40191__$1,gline_40192,gcol_40193,name_40194,vec__39695_40183,column_40184,column_info_40185,vec__39655_40176,line_40177,columns_40178,inverted))
,cljs.core.sorted_map()));


var G__40199 = seq__39700_40186;
var G__40200 = chunk__39701_40187;
var G__40201 = count__39702_40188;
var G__40202 = (i__39703_40189 + (1));
seq__39700_40186 = G__40199;
chunk__39701_40187 = G__40200;
count__39702_40188 = G__40201;
i__39703_40189 = G__40202;
continue;
} else {
var temp__5735__auto___40203 = cljs.core.seq(seq__39700_40186);
if(temp__5735__auto___40203){
var seq__39700_40204__$1 = temp__5735__auto___40203;
if(cljs.core.chunked_seq_QMARK_(seq__39700_40204__$1)){
var c__4609__auto___40205 = cljs.core.chunk_first(seq__39700_40204__$1);
var G__40206 = cljs.core.chunk_rest(seq__39700_40204__$1);
var G__40207 = c__4609__auto___40205;
var G__40208 = cljs.core.count(c__4609__auto___40205);
var G__40209 = (0);
seq__39700_40186 = G__40206;
chunk__39701_40187 = G__40207;
count__39702_40188 = G__40208;
i__39703_40189 = G__40209;
continue;
} else {
var map__39717_40210 = cljs.core.first(seq__39700_40204__$1);
var map__39717_40211__$1 = (((((!((map__39717_40210 == null))))?(((((map__39717_40210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39717_40210.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39717_40210):map__39717_40210);
var gline_40212 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39717_40211__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40213 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39717_40211__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40214 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39717_40211__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40212], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39700_40186,chunk__39701_40187,count__39702_40188,i__39703_40189,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39717_40210,map__39717_40211__$1,gline_40212,gcol_40213,name_40214,seq__39700_40204__$1,temp__5735__auto___40203,vec__39695_40183,column_40184,column_info_40185,vec__39655_40176,line_40177,columns_40178,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40213], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40177,new cljs.core.Keyword(null,"col","col",-1959363084),column_40184,new cljs.core.Keyword(null,"name","name",1843675177),name_40214], null));
});})(seq__39700_40186,chunk__39701_40187,count__39702_40188,i__39703_40189,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39717_40210,map__39717_40211__$1,gline_40212,gcol_40213,name_40214,seq__39700_40204__$1,temp__5735__auto___40203,vec__39695_40183,column_40184,column_info_40185,vec__39655_40176,line_40177,columns_40178,inverted))
,cljs.core.sorted_map()));


var G__40223 = cljs.core.next(seq__39700_40204__$1);
var G__40224 = null;
var G__40225 = (0);
var G__40226 = (0);
seq__39700_40186 = G__40223;
chunk__39701_40187 = G__40224;
count__39702_40188 = G__40225;
i__39703_40189 = G__40226;
continue;
}
} else {
}
}
break;
}


var G__40227 = seq__39658_40179;
var G__40228 = chunk__39659_40180;
var G__40229 = count__39660_40181;
var G__40230 = (i__39661_40182 + (1));
seq__39658_40179 = G__40227;
chunk__39659_40180 = G__40228;
count__39660_40181 = G__40229;
i__39661_40182 = G__40230;
continue;
} else {
var temp__5735__auto___40233 = cljs.core.seq(seq__39658_40179);
if(temp__5735__auto___40233){
var seq__39658_40234__$1 = temp__5735__auto___40233;
if(cljs.core.chunked_seq_QMARK_(seq__39658_40234__$1)){
var c__4609__auto___40235 = cljs.core.chunk_first(seq__39658_40234__$1);
var G__40236 = cljs.core.chunk_rest(seq__39658_40234__$1);
var G__40237 = c__4609__auto___40235;
var G__40238 = cljs.core.count(c__4609__auto___40235);
var G__40239 = (0);
seq__39658_40179 = G__40236;
chunk__39659_40180 = G__40237;
count__39660_40181 = G__40238;
i__39661_40182 = G__40239;
continue;
} else {
var vec__39721_40240 = cljs.core.first(seq__39658_40234__$1);
var column_40241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721_40240,(0),null);
var column_info_40242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721_40240,(1),null);
var seq__39724_40243 = cljs.core.seq(column_info_40242);
var chunk__39725_40244 = null;
var count__39726_40245 = (0);
var i__39727_40246 = (0);
while(true){
if((i__39727_40246 < count__39726_40245)){
var map__39748_40247 = chunk__39725_40244.cljs$core$IIndexed$_nth$arity$2(null,i__39727_40246);
var map__39748_40248__$1 = (((((!((map__39748_40247 == null))))?(((((map__39748_40247.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39748_40247.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39748_40247):map__39748_40247);
var gline_40249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39748_40248__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39748_40248__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39748_40248__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40249], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39724_40243,chunk__39725_40244,count__39726_40245,i__39727_40246,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39748_40247,map__39748_40248__$1,gline_40249,gcol_40250,name_40251,vec__39721_40240,column_40241,column_info_40242,seq__39658_40234__$1,temp__5735__auto___40233,vec__39655_40176,line_40177,columns_40178,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40250], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40177,new cljs.core.Keyword(null,"col","col",-1959363084),column_40241,new cljs.core.Keyword(null,"name","name",1843675177),name_40251], null));
});})(seq__39724_40243,chunk__39725_40244,count__39726_40245,i__39727_40246,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39748_40247,map__39748_40248__$1,gline_40249,gcol_40250,name_40251,vec__39721_40240,column_40241,column_info_40242,seq__39658_40234__$1,temp__5735__auto___40233,vec__39655_40176,line_40177,columns_40178,inverted))
,cljs.core.sorted_map()));


var G__40255 = seq__39724_40243;
var G__40256 = chunk__39725_40244;
var G__40257 = count__39726_40245;
var G__40258 = (i__39727_40246 + (1));
seq__39724_40243 = G__40255;
chunk__39725_40244 = G__40256;
count__39726_40245 = G__40257;
i__39727_40246 = G__40258;
continue;
} else {
var temp__5735__auto___40259__$1 = cljs.core.seq(seq__39724_40243);
if(temp__5735__auto___40259__$1){
var seq__39724_40260__$1 = temp__5735__auto___40259__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39724_40260__$1)){
var c__4609__auto___40261 = cljs.core.chunk_first(seq__39724_40260__$1);
var G__40262 = cljs.core.chunk_rest(seq__39724_40260__$1);
var G__40263 = c__4609__auto___40261;
var G__40264 = cljs.core.count(c__4609__auto___40261);
var G__40265 = (0);
seq__39724_40243 = G__40262;
chunk__39725_40244 = G__40263;
count__39726_40245 = G__40264;
i__39727_40246 = G__40265;
continue;
} else {
var map__39753_40266 = cljs.core.first(seq__39724_40260__$1);
var map__39753_40267__$1 = (((((!((map__39753_40266 == null))))?(((((map__39753_40266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39753_40266.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39753_40266):map__39753_40266);
var gline_40268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753_40267__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40269 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753_40267__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753_40267__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40268], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39724_40243,chunk__39725_40244,count__39726_40245,i__39727_40246,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39753_40266,map__39753_40267__$1,gline_40268,gcol_40269,name_40270,seq__39724_40260__$1,temp__5735__auto___40259__$1,vec__39721_40240,column_40241,column_info_40242,seq__39658_40234__$1,temp__5735__auto___40233,vec__39655_40176,line_40177,columns_40178,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40269], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40177,new cljs.core.Keyword(null,"col","col",-1959363084),column_40241,new cljs.core.Keyword(null,"name","name",1843675177),name_40270], null));
});})(seq__39724_40243,chunk__39725_40244,count__39726_40245,i__39727_40246,seq__39658_40179,chunk__39659_40180,count__39660_40181,i__39661_40182,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39753_40266,map__39753_40267__$1,gline_40268,gcol_40269,name_40270,seq__39724_40260__$1,temp__5735__auto___40259__$1,vec__39721_40240,column_40241,column_info_40242,seq__39658_40234__$1,temp__5735__auto___40233,vec__39655_40176,line_40177,columns_40178,inverted))
,cljs.core.sorted_map()));


var G__40272 = cljs.core.next(seq__39724_40260__$1);
var G__40273 = null;
var G__40274 = (0);
var G__40275 = (0);
seq__39724_40243 = G__40272;
chunk__39725_40244 = G__40273;
count__39726_40245 = G__40274;
i__39727_40246 = G__40275;
continue;
}
} else {
}
}
break;
}


var G__40276 = cljs.core.next(seq__39658_40234__$1);
var G__40277 = null;
var G__40278 = (0);
var G__40279 = (0);
seq__39658_40179 = G__40276;
chunk__39659_40180 = G__40277;
count__39660_40181 = G__40278;
i__39661_40182 = G__40279;
continue;
}
} else {
}
}
break;
}


var G__40280 = seq__39488_40172;
var G__40281 = chunk__39489_40173;
var G__40282 = count__39490_40174;
var G__40283 = (i__39491_40175 + (1));
seq__39488_40172 = G__40280;
chunk__39489_40173 = G__40281;
count__39490_40174 = G__40282;
i__39491_40175 = G__40283;
continue;
} else {
var temp__5735__auto___40284 = cljs.core.seq(seq__39488_40172);
if(temp__5735__auto___40284){
var seq__39488_40285__$1 = temp__5735__auto___40284;
if(cljs.core.chunked_seq_QMARK_(seq__39488_40285__$1)){
var c__4609__auto___40286 = cljs.core.chunk_first(seq__39488_40285__$1);
var G__40287 = cljs.core.chunk_rest(seq__39488_40285__$1);
var G__40288 = c__4609__auto___40286;
var G__40289 = cljs.core.count(c__4609__auto___40286);
var G__40290 = (0);
seq__39488_40172 = G__40287;
chunk__39489_40173 = G__40288;
count__39490_40174 = G__40289;
i__39491_40175 = G__40290;
continue;
} else {
var vec__39757_40292 = cljs.core.first(seq__39488_40285__$1);
var line_40293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39757_40292,(0),null);
var columns_40294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39757_40292,(1),null);
var seq__39760_40295 = cljs.core.seq(columns_40294);
var chunk__39761_40296 = null;
var count__39762_40297 = (0);
var i__39763_40298 = (0);
while(true){
if((i__39763_40298 < count__39762_40297)){
var vec__39817_40299 = chunk__39761_40296.cljs$core$IIndexed$_nth$arity$2(null,i__39763_40298);
var column_40300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39817_40299,(0),null);
var column_info_40301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39817_40299,(1),null);
var seq__39820_40302 = cljs.core.seq(column_info_40301);
var chunk__39821_40303 = null;
var count__39822_40304 = (0);
var i__39823_40305 = (0);
while(true){
if((i__39823_40305 < count__39822_40304)){
var map__39832_40307 = chunk__39821_40303.cljs$core$IIndexed$_nth$arity$2(null,i__39823_40305);
var map__39832_40308__$1 = (((((!((map__39832_40307 == null))))?(((((map__39832_40307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39832_40307.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39832_40307):map__39832_40307);
var gline_40309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39832_40308__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40310 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39832_40308__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39832_40308__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40309], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39820_40302,chunk__39821_40303,count__39822_40304,i__39823_40305,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39832_40307,map__39832_40308__$1,gline_40309,gcol_40310,name_40311,vec__39817_40299,column_40300,column_info_40301,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40310], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40293,new cljs.core.Keyword(null,"col","col",-1959363084),column_40300,new cljs.core.Keyword(null,"name","name",1843675177),name_40311], null));
});})(seq__39820_40302,chunk__39821_40303,count__39822_40304,i__39823_40305,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39832_40307,map__39832_40308__$1,gline_40309,gcol_40310,name_40311,vec__39817_40299,column_40300,column_info_40301,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted))
,cljs.core.sorted_map()));


var G__40319 = seq__39820_40302;
var G__40320 = chunk__39821_40303;
var G__40321 = count__39822_40304;
var G__40322 = (i__39823_40305 + (1));
seq__39820_40302 = G__40319;
chunk__39821_40303 = G__40320;
count__39822_40304 = G__40321;
i__39823_40305 = G__40322;
continue;
} else {
var temp__5735__auto___40325__$1 = cljs.core.seq(seq__39820_40302);
if(temp__5735__auto___40325__$1){
var seq__39820_40326__$1 = temp__5735__auto___40325__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39820_40326__$1)){
var c__4609__auto___40327 = cljs.core.chunk_first(seq__39820_40326__$1);
var G__40328 = cljs.core.chunk_rest(seq__39820_40326__$1);
var G__40329 = c__4609__auto___40327;
var G__40330 = cljs.core.count(c__4609__auto___40327);
var G__40331 = (0);
seq__39820_40302 = G__40328;
chunk__39821_40303 = G__40329;
count__39822_40304 = G__40330;
i__39823_40305 = G__40331;
continue;
} else {
var map__39838_40332 = cljs.core.first(seq__39820_40326__$1);
var map__39838_40333__$1 = (((((!((map__39838_40332 == null))))?(((((map__39838_40332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39838_40332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39838_40332):map__39838_40332);
var gline_40334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39838_40333__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39838_40333__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39838_40333__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40334], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39820_40302,chunk__39821_40303,count__39822_40304,i__39823_40305,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39838_40332,map__39838_40333__$1,gline_40334,gcol_40335,name_40336,seq__39820_40326__$1,temp__5735__auto___40325__$1,vec__39817_40299,column_40300,column_info_40301,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40335], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40293,new cljs.core.Keyword(null,"col","col",-1959363084),column_40300,new cljs.core.Keyword(null,"name","name",1843675177),name_40336], null));
});})(seq__39820_40302,chunk__39821_40303,count__39822_40304,i__39823_40305,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39838_40332,map__39838_40333__$1,gline_40334,gcol_40335,name_40336,seq__39820_40326__$1,temp__5735__auto___40325__$1,vec__39817_40299,column_40300,column_info_40301,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted))
,cljs.core.sorted_map()));


var G__40339 = cljs.core.next(seq__39820_40326__$1);
var G__40340 = null;
var G__40341 = (0);
var G__40342 = (0);
seq__39820_40302 = G__40339;
chunk__39821_40303 = G__40340;
count__39822_40304 = G__40341;
i__39823_40305 = G__40342;
continue;
}
} else {
}
}
break;
}


var G__40343 = seq__39760_40295;
var G__40344 = chunk__39761_40296;
var G__40345 = count__39762_40297;
var G__40346 = (i__39763_40298 + (1));
seq__39760_40295 = G__40343;
chunk__39761_40296 = G__40344;
count__39762_40297 = G__40345;
i__39763_40298 = G__40346;
continue;
} else {
var temp__5735__auto___40347__$1 = cljs.core.seq(seq__39760_40295);
if(temp__5735__auto___40347__$1){
var seq__39760_40348__$1 = temp__5735__auto___40347__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39760_40348__$1)){
var c__4609__auto___40349 = cljs.core.chunk_first(seq__39760_40348__$1);
var G__40350 = cljs.core.chunk_rest(seq__39760_40348__$1);
var G__40351 = c__4609__auto___40349;
var G__40352 = cljs.core.count(c__4609__auto___40349);
var G__40353 = (0);
seq__39760_40295 = G__40350;
chunk__39761_40296 = G__40351;
count__39762_40297 = G__40352;
i__39763_40298 = G__40353;
continue;
} else {
var vec__39844_40354 = cljs.core.first(seq__39760_40348__$1);
var column_40355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39844_40354,(0),null);
var column_info_40356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39844_40354,(1),null);
var seq__39847_40357 = cljs.core.seq(column_info_40356);
var chunk__39848_40358 = null;
var count__39849_40359 = (0);
var i__39850_40360 = (0);
while(true){
if((i__39850_40360 < count__39849_40359)){
var map__39868_40361 = chunk__39848_40358.cljs$core$IIndexed$_nth$arity$2(null,i__39850_40360);
var map__39868_40362__$1 = (((((!((map__39868_40361 == null))))?(((((map__39868_40361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39868_40361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39868_40361):map__39868_40361);
var gline_40363 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39868_40362__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40364 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39868_40362__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40365 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39868_40362__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40363], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39847_40357,chunk__39848_40358,count__39849_40359,i__39850_40360,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39868_40361,map__39868_40362__$1,gline_40363,gcol_40364,name_40365,vec__39844_40354,column_40355,column_info_40356,seq__39760_40348__$1,temp__5735__auto___40347__$1,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40364], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40293,new cljs.core.Keyword(null,"col","col",-1959363084),column_40355,new cljs.core.Keyword(null,"name","name",1843675177),name_40365], null));
});})(seq__39847_40357,chunk__39848_40358,count__39849_40359,i__39850_40360,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39868_40361,map__39868_40362__$1,gline_40363,gcol_40364,name_40365,vec__39844_40354,column_40355,column_info_40356,seq__39760_40348__$1,temp__5735__auto___40347__$1,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted))
,cljs.core.sorted_map()));


var G__40377 = seq__39847_40357;
var G__40378 = chunk__39848_40358;
var G__40379 = count__39849_40359;
var G__40380 = (i__39850_40360 + (1));
seq__39847_40357 = G__40377;
chunk__39848_40358 = G__40378;
count__39849_40359 = G__40379;
i__39850_40360 = G__40380;
continue;
} else {
var temp__5735__auto___40386__$2 = cljs.core.seq(seq__39847_40357);
if(temp__5735__auto___40386__$2){
var seq__39847_40387__$1 = temp__5735__auto___40386__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39847_40387__$1)){
var c__4609__auto___40388 = cljs.core.chunk_first(seq__39847_40387__$1);
var G__40389 = cljs.core.chunk_rest(seq__39847_40387__$1);
var G__40390 = c__4609__auto___40388;
var G__40391 = cljs.core.count(c__4609__auto___40388);
var G__40392 = (0);
seq__39847_40357 = G__40389;
chunk__39848_40358 = G__40390;
count__39849_40359 = G__40391;
i__39850_40360 = G__40392;
continue;
} else {
var map__39875_40393 = cljs.core.first(seq__39847_40387__$1);
var map__39875_40394__$1 = (((((!((map__39875_40393 == null))))?(((((map__39875_40393.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39875_40393.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39875_40393):map__39875_40393);
var gline_40395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39875_40394__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39875_40394__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40397 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39875_40394__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40395], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39847_40357,chunk__39848_40358,count__39849_40359,i__39850_40360,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39875_40393,map__39875_40394__$1,gline_40395,gcol_40396,name_40397,seq__39847_40387__$1,temp__5735__auto___40386__$2,vec__39844_40354,column_40355,column_info_40356,seq__39760_40348__$1,temp__5735__auto___40347__$1,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40396], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40293,new cljs.core.Keyword(null,"col","col",-1959363084),column_40355,new cljs.core.Keyword(null,"name","name",1843675177),name_40397], null));
});})(seq__39847_40357,chunk__39848_40358,count__39849_40359,i__39850_40360,seq__39760_40295,chunk__39761_40296,count__39762_40297,i__39763_40298,seq__39488_40172,chunk__39489_40173,count__39490_40174,i__39491_40175,map__39875_40393,map__39875_40394__$1,gline_40395,gcol_40396,name_40397,seq__39847_40387__$1,temp__5735__auto___40386__$2,vec__39844_40354,column_40355,column_info_40356,seq__39760_40348__$1,temp__5735__auto___40347__$1,vec__39757_40292,line_40293,columns_40294,seq__39488_40285__$1,temp__5735__auto___40284,inverted))
,cljs.core.sorted_map()));


var G__40410 = cljs.core.next(seq__39847_40387__$1);
var G__40411 = null;
var G__40412 = (0);
var G__40413 = (0);
seq__39847_40357 = G__40410;
chunk__39848_40358 = G__40411;
count__39849_40359 = G__40412;
i__39850_40360 = G__40413;
continue;
}
} else {
}
}
break;
}


var G__40414 = cljs.core.next(seq__39760_40348__$1);
var G__40415 = null;
var G__40416 = (0);
var G__40417 = (0);
seq__39760_40295 = G__40414;
chunk__39761_40296 = G__40415;
count__39762_40297 = G__40416;
i__39763_40298 = G__40417;
continue;
}
} else {
}
}
break;
}


var G__40418 = cljs.core.next(seq__39488_40285__$1);
var G__40419 = null;
var G__40420 = (0);
var G__40421 = (0);
seq__39488_40172 = G__40418;
chunk__39489_40173 = G__40419;
count__39490_40174 = G__40420;
i__39491_40175 = G__40421;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
