goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__25999){
var map__26000 = p__25999;
var map__26000__$1 = (((((!((map__26000 == null))))?(((((map__26000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26000):map__26000);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26000__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26000__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26000__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26000__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4185__auto__ = child_of;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__26002_26030 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__26003_26031 = null;
var count__26004_26032 = (0);
var i__26005_26033 = (0);
while(true){
if((i__26005_26033 < count__26004_26032)){
var vec__26016_26034 = chunk__26003_26031.cljs$core$IIndexed$_nth$arity$2(null,i__26005_26033);
var k_26035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26016_26034,(0),null);
var cb_26036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26016_26034,(1),null);
try{var G__26020_26037 = cljs.core.deref(re_frame.trace.traces);
(cb_26036.cljs$core$IFn$_invoke$arity$1 ? cb_26036.cljs$core$IFn$_invoke$arity$1(G__26020_26037) : cb_26036.call(null,G__26020_26037));
}catch (e26019){var e_26039 = e26019;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_26035,"while storing",cljs.core.deref(re_frame.trace.traces),e_26039], 0));
}

var G__26042 = seq__26002_26030;
var G__26043 = chunk__26003_26031;
var G__26044 = count__26004_26032;
var G__26045 = (i__26005_26033 + (1));
seq__26002_26030 = G__26042;
chunk__26003_26031 = G__26043;
count__26004_26032 = G__26044;
i__26005_26033 = G__26045;
continue;
} else {
var temp__5735__auto___26046 = cljs.core.seq(seq__26002_26030);
if(temp__5735__auto___26046){
var seq__26002_26047__$1 = temp__5735__auto___26046;
if(cljs.core.chunked_seq_QMARK_(seq__26002_26047__$1)){
var c__4609__auto___26048 = cljs.core.chunk_first(seq__26002_26047__$1);
var G__26049 = cljs.core.chunk_rest(seq__26002_26047__$1);
var G__26050 = c__4609__auto___26048;
var G__26051 = cljs.core.count(c__4609__auto___26048);
var G__26052 = (0);
seq__26002_26030 = G__26049;
chunk__26003_26031 = G__26050;
count__26004_26032 = G__26051;
i__26005_26033 = G__26052;
continue;
} else {
var vec__26021_26053 = cljs.core.first(seq__26002_26047__$1);
var k_26054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26021_26053,(0),null);
var cb_26055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26021_26053,(1),null);
try{var G__26025_26056 = cljs.core.deref(re_frame.trace.traces);
(cb_26055.cljs$core$IFn$_invoke$arity$1 ? cb_26055.cljs$core$IFn$_invoke$arity$1(G__26025_26056) : cb_26055.call(null,G__26025_26056));
}catch (e26024){var e_26057 = e26024;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_26054,"while storing",cljs.core.deref(re_frame.trace.traces),e_26057], 0));
}

var G__26058 = cljs.core.next(seq__26002_26047__$1);
var G__26059 = null;
var G__26060 = (0);
var G__26061 = (0);
seq__26002_26030 = G__26058;
chunk__26003_26031 = G__26059;
count__26004_26032 = G__26060;
i__26005_26033 = G__26061;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
