goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__38977){
var vec__38978 = p__38977;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__38981 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__38984 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(4),null);
var vec__38987 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__38993 = segmap;
var map__38993__$1 = (((((!((map__38993 == null))))?(((((map__38993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38993.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38993):map__38993);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38993__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38993__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38993__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38993__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38993__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__38997 = arguments.length;
switch (G__38997) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39002 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39941 = cljs.core.next(segs__$1);
var G__39942 = nrelseg;
var G__39943 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39941;
relseg__$1 = G__39942;
result__$1 = G__39943;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39002,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39002,(1),null);
var G__39944 = (gline + (1));
var G__39945 = cljs.core.next(lines__$1);
var G__39946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39947 = result__$1;
gline = G__39944;
lines__$1 = G__39945;
relseg = G__39946;
result = G__39947;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__39012 = segmap;
var map__39012__$1 = (((((!((map__39012 == null))))?(((((map__39012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39012.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39012):map__39012);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39012__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__39008_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39008_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__39021 = arguments.length;
switch (G__39021) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39034 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39957 = cljs.core.next(segs__$1);
var G__39958 = nrelseg;
var G__39959 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39957;
relseg__$1 = G__39958;
result__$1 = G__39959;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39034,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39034,(1),null);
var G__39964 = (gline + (1));
var G__39965 = cljs.core.next(lines__$1);
var G__39966 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39967 = result__$1;
gline = G__39964;
lines__$1 = G__39965;
relseg = G__39966;
result = G__39967;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39041){
var vec__39042 = p__39041;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39042,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__39049){
var vec__39050 = p__39049;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39050,(4),null);
var seg = vec__39050;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39053){
var vec__39054 = p__39053;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39054,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__39063 = cljs.core.seq(infos);
var chunk__39064 = null;
var count__39065 = (0);
var i__39066 = (0);
while(true){
if((i__39066 < count__39065)){
var info = chunk__39064.cljs$core$IIndexed$_nth$arity$2(null,i__39066);
var segv_39980 = info__GT_segv(info,source_idx,line,col);
var gline_39981 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39982 = cljs.core.count(cljs.core.deref(lines));
if((gline_39981 > (lc_39982 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39980,gline_39981,lc_39982,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39981 - (lc_39982 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39980], null));
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39980,gline_39981,lc_39982,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39980,gline_39981,lc_39982,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39981], null),cljs.core.conj,segv_39980);
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39980,gline_39981,lc_39982,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39983 = seq__39063;
var G__39984 = chunk__39064;
var G__39985 = count__39065;
var G__39986 = (i__39066 + (1));
seq__39063 = G__39983;
chunk__39064 = G__39984;
count__39065 = G__39985;
i__39066 = G__39986;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39063);
if(temp__5735__auto__){
var seq__39063__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39063__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39063__$1);
var G__39989 = cljs.core.chunk_rest(seq__39063__$1);
var G__39990 = c__4609__auto__;
var G__39991 = cljs.core.count(c__4609__auto__);
var G__39992 = (0);
seq__39063 = G__39989;
chunk__39064 = G__39990;
count__39065 = G__39991;
i__39066 = G__39992;
continue;
} else {
var info = cljs.core.first(seq__39063__$1);
var segv_39993 = info__GT_segv(info,source_idx,line,col);
var gline_39994 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39995 = cljs.core.count(cljs.core.deref(lines));
if((gline_39994 > (lc_39995 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39993,gline_39994,lc_39995,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39994 - (lc_39995 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39993], null));
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39993,gline_39994,lc_39995,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39063,chunk__39064,count__39065,i__39066,segv_39993,gline_39994,lc_39995,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39994], null),cljs.core.conj,segv_39993);
});})(seq__39063,chunk__39064,count__39065,i__39066,segv_39993,gline_39994,lc_39995,info,seq__39063__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39999 = cljs.core.next(seq__39063__$1);
var G__40000 = null;
var G__40001 = (0);
var G__40002 = (0);
seq__39063 = G__39999;
chunk__39064 = G__40000;
count__39065 = G__40001;
i__39066 = G__40002;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__39077_40003 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__39078_40004 = null;
var count__39079_40005 = (0);
var i__39080_40006 = (0);
while(true){
if((i__39080_40006 < count__39079_40005)){
var vec__39289_40007 = chunk__39078_40004.cljs$core$IIndexed$_nth$arity$2(null,i__39080_40006);
var source_idx_40008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39289_40007,(0),null);
var vec__39292_40009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39289_40007,(1),null);
var __40010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39292_40009,(0),null);
var lines_40011__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39292_40009,(1),null);
var seq__39295_40012 = cljs.core.seq(lines_40011__$1);
var chunk__39296_40013 = null;
var count__39297_40014 = (0);
var i__39298_40015 = (0);
while(true){
if((i__39298_40015 < count__39297_40014)){
var vec__39341_40016 = chunk__39296_40013.cljs$core$IIndexed$_nth$arity$2(null,i__39298_40015);
var line_40017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39341_40016,(0),null);
var cols_40018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39341_40016,(1),null);
var seq__39344_40019 = cljs.core.seq(cols_40018);
var chunk__39345_40020 = null;
var count__39346_40021 = (0);
var i__39347_40022 = (0);
while(true){
if((i__39347_40022 < count__39346_40021)){
var vec__39356_40023 = chunk__39345_40020.cljs$core$IIndexed$_nth$arity$2(null,i__39347_40022);
var col_40024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39356_40023,(0),null);
var infos_40025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39356_40023,(1),null);
encode_cols(infos_40025,source_idx_40008,line_40017,col_40024);


var G__40026 = seq__39344_40019;
var G__40027 = chunk__39345_40020;
var G__40028 = count__39346_40021;
var G__40029 = (i__39347_40022 + (1));
seq__39344_40019 = G__40026;
chunk__39345_40020 = G__40027;
count__39346_40021 = G__40028;
i__39347_40022 = G__40029;
continue;
} else {
var temp__5735__auto___40030 = cljs.core.seq(seq__39344_40019);
if(temp__5735__auto___40030){
var seq__39344_40031__$1 = temp__5735__auto___40030;
if(cljs.core.chunked_seq_QMARK_(seq__39344_40031__$1)){
var c__4609__auto___40032 = cljs.core.chunk_first(seq__39344_40031__$1);
var G__40033 = cljs.core.chunk_rest(seq__39344_40031__$1);
var G__40034 = c__4609__auto___40032;
var G__40035 = cljs.core.count(c__4609__auto___40032);
var G__40036 = (0);
seq__39344_40019 = G__40033;
chunk__39345_40020 = G__40034;
count__39346_40021 = G__40035;
i__39347_40022 = G__40036;
continue;
} else {
var vec__39359_40038 = cljs.core.first(seq__39344_40031__$1);
var col_40039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39359_40038,(0),null);
var infos_40040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39359_40038,(1),null);
encode_cols(infos_40040,source_idx_40008,line_40017,col_40039);


var G__40041 = cljs.core.next(seq__39344_40031__$1);
var G__40042 = null;
var G__40043 = (0);
var G__40044 = (0);
seq__39344_40019 = G__40041;
chunk__39345_40020 = G__40042;
count__39346_40021 = G__40043;
i__39347_40022 = G__40044;
continue;
}
} else {
}
}
break;
}


var G__40045 = seq__39295_40012;
var G__40046 = chunk__39296_40013;
var G__40047 = count__39297_40014;
var G__40048 = (i__39298_40015 + (1));
seq__39295_40012 = G__40045;
chunk__39296_40013 = G__40046;
count__39297_40014 = G__40047;
i__39298_40015 = G__40048;
continue;
} else {
var temp__5735__auto___40049 = cljs.core.seq(seq__39295_40012);
if(temp__5735__auto___40049){
var seq__39295_40050__$1 = temp__5735__auto___40049;
if(cljs.core.chunked_seq_QMARK_(seq__39295_40050__$1)){
var c__4609__auto___40051 = cljs.core.chunk_first(seq__39295_40050__$1);
var G__40052 = cljs.core.chunk_rest(seq__39295_40050__$1);
var G__40053 = c__4609__auto___40051;
var G__40054 = cljs.core.count(c__4609__auto___40051);
var G__40055 = (0);
seq__39295_40012 = G__40052;
chunk__39296_40013 = G__40053;
count__39297_40014 = G__40054;
i__39298_40015 = G__40055;
continue;
} else {
var vec__39362_40056 = cljs.core.first(seq__39295_40050__$1);
var line_40057 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39362_40056,(0),null);
var cols_40058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39362_40056,(1),null);
var seq__39365_40059 = cljs.core.seq(cols_40058);
var chunk__39366_40060 = null;
var count__39367_40061 = (0);
var i__39368_40062 = (0);
while(true){
if((i__39368_40062 < count__39367_40061)){
var vec__39375_40064 = chunk__39366_40060.cljs$core$IIndexed$_nth$arity$2(null,i__39368_40062);
var col_40065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39375_40064,(0),null);
var infos_40066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39375_40064,(1),null);
encode_cols(infos_40066,source_idx_40008,line_40057,col_40065);


var G__40067 = seq__39365_40059;
var G__40068 = chunk__39366_40060;
var G__40069 = count__39367_40061;
var G__40070 = (i__39368_40062 + (1));
seq__39365_40059 = G__40067;
chunk__39366_40060 = G__40068;
count__39367_40061 = G__40069;
i__39368_40062 = G__40070;
continue;
} else {
var temp__5735__auto___40071__$1 = cljs.core.seq(seq__39365_40059);
if(temp__5735__auto___40071__$1){
var seq__39365_40072__$1 = temp__5735__auto___40071__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39365_40072__$1)){
var c__4609__auto___40073 = cljs.core.chunk_first(seq__39365_40072__$1);
var G__40074 = cljs.core.chunk_rest(seq__39365_40072__$1);
var G__40075 = c__4609__auto___40073;
var G__40076 = cljs.core.count(c__4609__auto___40073);
var G__40077 = (0);
seq__39365_40059 = G__40074;
chunk__39366_40060 = G__40075;
count__39367_40061 = G__40076;
i__39368_40062 = G__40077;
continue;
} else {
var vec__39378_40078 = cljs.core.first(seq__39365_40072__$1);
var col_40079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39378_40078,(0),null);
var infos_40080 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39378_40078,(1),null);
encode_cols(infos_40080,source_idx_40008,line_40057,col_40079);


var G__40085 = cljs.core.next(seq__39365_40072__$1);
var G__40086 = null;
var G__40087 = (0);
var G__40088 = (0);
seq__39365_40059 = G__40085;
chunk__39366_40060 = G__40086;
count__39367_40061 = G__40087;
i__39368_40062 = G__40088;
continue;
}
} else {
}
}
break;
}


var G__40089 = cljs.core.next(seq__39295_40050__$1);
var G__40090 = null;
var G__40091 = (0);
var G__40092 = (0);
seq__39295_40012 = G__40089;
chunk__39296_40013 = G__40090;
count__39297_40014 = G__40091;
i__39298_40015 = G__40092;
continue;
}
} else {
}
}
break;
}


var G__40093 = seq__39077_40003;
var G__40094 = chunk__39078_40004;
var G__40095 = count__39079_40005;
var G__40096 = (i__39080_40006 + (1));
seq__39077_40003 = G__40093;
chunk__39078_40004 = G__40094;
count__39079_40005 = G__40095;
i__39080_40006 = G__40096;
continue;
} else {
var temp__5735__auto___40100 = cljs.core.seq(seq__39077_40003);
if(temp__5735__auto___40100){
var seq__39077_40101__$1 = temp__5735__auto___40100;
if(cljs.core.chunked_seq_QMARK_(seq__39077_40101__$1)){
var c__4609__auto___40102 = cljs.core.chunk_first(seq__39077_40101__$1);
var G__40103 = cljs.core.chunk_rest(seq__39077_40101__$1);
var G__40104 = c__4609__auto___40102;
var G__40105 = cljs.core.count(c__4609__auto___40102);
var G__40106 = (0);
seq__39077_40003 = G__40103;
chunk__39078_40004 = G__40104;
count__39079_40005 = G__40105;
i__39080_40006 = G__40106;
continue;
} else {
var vec__39381_40107 = cljs.core.first(seq__39077_40101__$1);
var source_idx_40108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40107,(0),null);
var vec__39384_40109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40107,(1),null);
var __40110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40109,(0),null);
var lines_40111__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40109,(1),null);
var seq__39387_40113 = cljs.core.seq(lines_40111__$1);
var chunk__39388_40114 = null;
var count__39389_40115 = (0);
var i__39390_40116 = (0);
while(true){
if((i__39390_40116 < count__39389_40115)){
var vec__39429_40117 = chunk__39388_40114.cljs$core$IIndexed$_nth$arity$2(null,i__39390_40116);
var line_40118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40117,(0),null);
var cols_40119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39429_40117,(1),null);
var seq__39432_40122 = cljs.core.seq(cols_40119);
var chunk__39433_40123 = null;
var count__39434_40124 = (0);
var i__39435_40125 = (0);
while(true){
if((i__39435_40125 < count__39434_40124)){
var vec__39447_40126 = chunk__39433_40123.cljs$core$IIndexed$_nth$arity$2(null,i__39435_40125);
var col_40127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39447_40126,(0),null);
var infos_40128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39447_40126,(1),null);
encode_cols(infos_40128,source_idx_40108,line_40118,col_40127);


var G__40131 = seq__39432_40122;
var G__40132 = chunk__39433_40123;
var G__40133 = count__39434_40124;
var G__40134 = (i__39435_40125 + (1));
seq__39432_40122 = G__40131;
chunk__39433_40123 = G__40132;
count__39434_40124 = G__40133;
i__39435_40125 = G__40134;
continue;
} else {
var temp__5735__auto___40135__$1 = cljs.core.seq(seq__39432_40122);
if(temp__5735__auto___40135__$1){
var seq__39432_40136__$1 = temp__5735__auto___40135__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39432_40136__$1)){
var c__4609__auto___40137 = cljs.core.chunk_first(seq__39432_40136__$1);
var G__40138 = cljs.core.chunk_rest(seq__39432_40136__$1);
var G__40139 = c__4609__auto___40137;
var G__40140 = cljs.core.count(c__4609__auto___40137);
var G__40141 = (0);
seq__39432_40122 = G__40138;
chunk__39433_40123 = G__40139;
count__39434_40124 = G__40140;
i__39435_40125 = G__40141;
continue;
} else {
var vec__39450_40142 = cljs.core.first(seq__39432_40136__$1);
var col_40143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39450_40142,(0),null);
var infos_40144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39450_40142,(1),null);
encode_cols(infos_40144,source_idx_40108,line_40118,col_40143);


var G__40145 = cljs.core.next(seq__39432_40136__$1);
var G__40146 = null;
var G__40147 = (0);
var G__40148 = (0);
seq__39432_40122 = G__40145;
chunk__39433_40123 = G__40146;
count__39434_40124 = G__40147;
i__39435_40125 = G__40148;
continue;
}
} else {
}
}
break;
}


var G__40149 = seq__39387_40113;
var G__40150 = chunk__39388_40114;
var G__40151 = count__39389_40115;
var G__40152 = (i__39390_40116 + (1));
seq__39387_40113 = G__40149;
chunk__39388_40114 = G__40150;
count__39389_40115 = G__40151;
i__39390_40116 = G__40152;
continue;
} else {
var temp__5735__auto___40153__$1 = cljs.core.seq(seq__39387_40113);
if(temp__5735__auto___40153__$1){
var seq__39387_40154__$1 = temp__5735__auto___40153__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39387_40154__$1)){
var c__4609__auto___40155 = cljs.core.chunk_first(seq__39387_40154__$1);
var G__40156 = cljs.core.chunk_rest(seq__39387_40154__$1);
var G__40157 = c__4609__auto___40155;
var G__40158 = cljs.core.count(c__4609__auto___40155);
var G__40159 = (0);
seq__39387_40113 = G__40156;
chunk__39388_40114 = G__40157;
count__39389_40115 = G__40158;
i__39390_40116 = G__40159;
continue;
} else {
var vec__39453_40160 = cljs.core.first(seq__39387_40154__$1);
var line_40161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39453_40160,(0),null);
var cols_40162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39453_40160,(1),null);
var seq__39456_40163 = cljs.core.seq(cols_40162);
var chunk__39457_40164 = null;
var count__39458_40165 = (0);
var i__39459_40166 = (0);
while(true){
if((i__39459_40166 < count__39458_40165)){
var vec__39468_40167 = chunk__39457_40164.cljs$core$IIndexed$_nth$arity$2(null,i__39459_40166);
var col_40168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39468_40167,(0),null);
var infos_40169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39468_40167,(1),null);
encode_cols(infos_40169,source_idx_40108,line_40161,col_40168);


var G__40170 = seq__39456_40163;
var G__40171 = chunk__39457_40164;
var G__40172 = count__39458_40165;
var G__40173 = (i__39459_40166 + (1));
seq__39456_40163 = G__40170;
chunk__39457_40164 = G__40171;
count__39458_40165 = G__40172;
i__39459_40166 = G__40173;
continue;
} else {
var temp__5735__auto___40174__$2 = cljs.core.seq(seq__39456_40163);
if(temp__5735__auto___40174__$2){
var seq__39456_40175__$1 = temp__5735__auto___40174__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39456_40175__$1)){
var c__4609__auto___40176 = cljs.core.chunk_first(seq__39456_40175__$1);
var G__40177 = cljs.core.chunk_rest(seq__39456_40175__$1);
var G__40178 = c__4609__auto___40176;
var G__40179 = cljs.core.count(c__4609__auto___40176);
var G__40180 = (0);
seq__39456_40163 = G__40177;
chunk__39457_40164 = G__40178;
count__39458_40165 = G__40179;
i__39459_40166 = G__40180;
continue;
} else {
var vec__39471_40181 = cljs.core.first(seq__39456_40175__$1);
var col_40182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39471_40181,(0),null);
var infos_40183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39471_40181,(1),null);
encode_cols(infos_40183,source_idx_40108,line_40161,col_40182);


var G__40188 = cljs.core.next(seq__39456_40175__$1);
var G__40189 = null;
var G__40190 = (0);
var G__40191 = (0);
seq__39456_40163 = G__40188;
chunk__39457_40164 = G__40189;
count__39458_40165 = G__40190;
i__39459_40166 = G__40191;
continue;
}
} else {
}
}
break;
}


var G__40192 = cljs.core.next(seq__39387_40154__$1);
var G__40193 = null;
var G__40194 = (0);
var G__40195 = (0);
seq__39387_40113 = G__40192;
chunk__39388_40114 = G__40193;
count__39389_40115 = G__40194;
i__39390_40116 = G__40195;
continue;
}
} else {
}
}
break;
}


var G__40196 = cljs.core.next(seq__39077_40101__$1);
var G__40197 = null;
var G__40198 = (0);
var G__40199 = (0);
seq__39077_40003 = G__40196;
chunk__39078_40004 = G__40197;
count__39079_40005 = G__40198;
i__39080_40006 = G__40199;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__39474 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__39058_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39058_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__39059_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__39059_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39060_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__39060_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__39478 = G__39474;
var G__39480_40214 = G__39478;
var G__39481_40215 = "sourcesContent";
var G__39482_40216 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__39480_40214,G__39481_40215,G__39482_40216);

return G__39478;
} else {
return G__39474;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__39484 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39484,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39484,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__39487 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39487,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39487,(1),null);
var G__40220 = cljs.core.next(col_map_seq);
var G__40221 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__39487,col,infos,vec__39484,line,col_map){
return (function (v,p__39490){
var map__39491 = p__39490;
var map__39491__$1 = (((((!((map__39491 == null))))?(((((map__39491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39491.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39491):map__39491);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39491__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39491__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__39487,col,infos,vec__39484,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__40220;
new_cols = G__40221;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__40231 = cljs.core.next(line_map_seq);
var G__40232 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__40231;
new_lines = G__40232;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__39495_40235 = cljs.core.seq(reverse_map);
var chunk__39496_40236 = null;
var count__39497_40237 = (0);
var i__39498_40238 = (0);
while(true){
if((i__39498_40238 < count__39497_40237)){
var vec__39690_40239 = chunk__39496_40236.cljs$core$IIndexed$_nth$arity$2(null,i__39498_40238);
var line_40240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39690_40239,(0),null);
var columns_40241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39690_40239,(1),null);
var seq__39693_40243 = cljs.core.seq(columns_40241);
var chunk__39694_40244 = null;
var count__39695_40245 = (0);
var i__39696_40246 = (0);
while(true){
if((i__39696_40246 < count__39695_40245)){
var vec__39746_40247 = chunk__39694_40244.cljs$core$IIndexed$_nth$arity$2(null,i__39696_40246);
var column_40248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39746_40247,(0),null);
var column_info_40249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39746_40247,(1),null);
var seq__39751_40252 = cljs.core.seq(column_info_40249);
var chunk__39752_40253 = null;
var count__39753_40254 = (0);
var i__39754_40255 = (0);
while(true){
if((i__39754_40255 < count__39753_40254)){
var map__39763_40256 = chunk__39752_40253.cljs$core$IIndexed$_nth$arity$2(null,i__39754_40255);
var map__39763_40257__$1 = (((((!((map__39763_40256 == null))))?(((((map__39763_40256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39763_40256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39763_40256):map__39763_40256);
var gline_40258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763_40257__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763_40257__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763_40257__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40258], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39751_40252,chunk__39752_40253,count__39753_40254,i__39754_40255,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39763_40256,map__39763_40257__$1,gline_40258,gcol_40259,name_40260,vec__39746_40247,column_40248,column_info_40249,vec__39690_40239,line_40240,columns_40241,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40259], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40240,new cljs.core.Keyword(null,"col","col",-1959363084),column_40248,new cljs.core.Keyword(null,"name","name",1843675177),name_40260], null));
});})(seq__39751_40252,chunk__39752_40253,count__39753_40254,i__39754_40255,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39763_40256,map__39763_40257__$1,gline_40258,gcol_40259,name_40260,vec__39746_40247,column_40248,column_info_40249,vec__39690_40239,line_40240,columns_40241,inverted))
,cljs.core.sorted_map()));


var G__40267 = seq__39751_40252;
var G__40268 = chunk__39752_40253;
var G__40269 = count__39753_40254;
var G__40270 = (i__39754_40255 + (1));
seq__39751_40252 = G__40267;
chunk__39752_40253 = G__40268;
count__39753_40254 = G__40269;
i__39754_40255 = G__40270;
continue;
} else {
var temp__5735__auto___40273 = cljs.core.seq(seq__39751_40252);
if(temp__5735__auto___40273){
var seq__39751_40274__$1 = temp__5735__auto___40273;
if(cljs.core.chunked_seq_QMARK_(seq__39751_40274__$1)){
var c__4609__auto___40275 = cljs.core.chunk_first(seq__39751_40274__$1);
var G__40276 = cljs.core.chunk_rest(seq__39751_40274__$1);
var G__40277 = c__4609__auto___40275;
var G__40278 = cljs.core.count(c__4609__auto___40275);
var G__40279 = (0);
seq__39751_40252 = G__40276;
chunk__39752_40253 = G__40277;
count__39753_40254 = G__40278;
i__39754_40255 = G__40279;
continue;
} else {
var map__39767_40282 = cljs.core.first(seq__39751_40274__$1);
var map__39767_40283__$1 = (((((!((map__39767_40282 == null))))?(((((map__39767_40282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39767_40282.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39767_40282):map__39767_40282);
var gline_40284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39767_40283__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40285 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39767_40283__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39767_40283__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40284], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39751_40252,chunk__39752_40253,count__39753_40254,i__39754_40255,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39767_40282,map__39767_40283__$1,gline_40284,gcol_40285,name_40286,seq__39751_40274__$1,temp__5735__auto___40273,vec__39746_40247,column_40248,column_info_40249,vec__39690_40239,line_40240,columns_40241,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40285], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40240,new cljs.core.Keyword(null,"col","col",-1959363084),column_40248,new cljs.core.Keyword(null,"name","name",1843675177),name_40286], null));
});})(seq__39751_40252,chunk__39752_40253,count__39753_40254,i__39754_40255,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39767_40282,map__39767_40283__$1,gline_40284,gcol_40285,name_40286,seq__39751_40274__$1,temp__5735__auto___40273,vec__39746_40247,column_40248,column_info_40249,vec__39690_40239,line_40240,columns_40241,inverted))
,cljs.core.sorted_map()));


var G__40289 = cljs.core.next(seq__39751_40274__$1);
var G__40290 = null;
var G__40291 = (0);
var G__40292 = (0);
seq__39751_40252 = G__40289;
chunk__39752_40253 = G__40290;
count__39753_40254 = G__40291;
i__39754_40255 = G__40292;
continue;
}
} else {
}
}
break;
}


var G__40293 = seq__39693_40243;
var G__40294 = chunk__39694_40244;
var G__40295 = count__39695_40245;
var G__40296 = (i__39696_40246 + (1));
seq__39693_40243 = G__40293;
chunk__39694_40244 = G__40294;
count__39695_40245 = G__40295;
i__39696_40246 = G__40296;
continue;
} else {
var temp__5735__auto___40297 = cljs.core.seq(seq__39693_40243);
if(temp__5735__auto___40297){
var seq__39693_40298__$1 = temp__5735__auto___40297;
if(cljs.core.chunked_seq_QMARK_(seq__39693_40298__$1)){
var c__4609__auto___40300 = cljs.core.chunk_first(seq__39693_40298__$1);
var G__40301 = cljs.core.chunk_rest(seq__39693_40298__$1);
var G__40302 = c__4609__auto___40300;
var G__40303 = cljs.core.count(c__4609__auto___40300);
var G__40304 = (0);
seq__39693_40243 = G__40301;
chunk__39694_40244 = G__40302;
count__39695_40245 = G__40303;
i__39696_40246 = G__40304;
continue;
} else {
var vec__39773_40305 = cljs.core.first(seq__39693_40298__$1);
var column_40306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39773_40305,(0),null);
var column_info_40307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39773_40305,(1),null);
var seq__39776_40308 = cljs.core.seq(column_info_40307);
var chunk__39777_40309 = null;
var count__39778_40310 = (0);
var i__39779_40311 = (0);
while(true){
if((i__39779_40311 < count__39778_40310)){
var map__39800_40312 = chunk__39777_40309.cljs$core$IIndexed$_nth$arity$2(null,i__39779_40311);
var map__39800_40313__$1 = (((((!((map__39800_40312 == null))))?(((((map__39800_40312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39800_40312.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39800_40312):map__39800_40312);
var gline_40314 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39800_40313__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39800_40313__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39800_40313__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40314], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39776_40308,chunk__39777_40309,count__39778_40310,i__39779_40311,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39800_40312,map__39800_40313__$1,gline_40314,gcol_40315,name_40316,vec__39773_40305,column_40306,column_info_40307,seq__39693_40298__$1,temp__5735__auto___40297,vec__39690_40239,line_40240,columns_40241,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40315], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40240,new cljs.core.Keyword(null,"col","col",-1959363084),column_40306,new cljs.core.Keyword(null,"name","name",1843675177),name_40316], null));
});})(seq__39776_40308,chunk__39777_40309,count__39778_40310,i__39779_40311,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39800_40312,map__39800_40313__$1,gline_40314,gcol_40315,name_40316,vec__39773_40305,column_40306,column_info_40307,seq__39693_40298__$1,temp__5735__auto___40297,vec__39690_40239,line_40240,columns_40241,inverted))
,cljs.core.sorted_map()));


var G__40324 = seq__39776_40308;
var G__40325 = chunk__39777_40309;
var G__40326 = count__39778_40310;
var G__40327 = (i__39779_40311 + (1));
seq__39776_40308 = G__40324;
chunk__39777_40309 = G__40325;
count__39778_40310 = G__40326;
i__39779_40311 = G__40327;
continue;
} else {
var temp__5735__auto___40328__$1 = cljs.core.seq(seq__39776_40308);
if(temp__5735__auto___40328__$1){
var seq__39776_40329__$1 = temp__5735__auto___40328__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39776_40329__$1)){
var c__4609__auto___40330 = cljs.core.chunk_first(seq__39776_40329__$1);
var G__40331 = cljs.core.chunk_rest(seq__39776_40329__$1);
var G__40332 = c__4609__auto___40330;
var G__40333 = cljs.core.count(c__4609__auto___40330);
var G__40334 = (0);
seq__39776_40308 = G__40331;
chunk__39777_40309 = G__40332;
count__39778_40310 = G__40333;
i__39779_40311 = G__40334;
continue;
} else {
var map__39806_40338 = cljs.core.first(seq__39776_40329__$1);
var map__39806_40339__$1 = (((((!((map__39806_40338 == null))))?(((((map__39806_40338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39806_40338.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39806_40338):map__39806_40338);
var gline_40340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39806_40339__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39806_40339__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39806_40339__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40340], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39776_40308,chunk__39777_40309,count__39778_40310,i__39779_40311,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39806_40338,map__39806_40339__$1,gline_40340,gcol_40341,name_40342,seq__39776_40329__$1,temp__5735__auto___40328__$1,vec__39773_40305,column_40306,column_info_40307,seq__39693_40298__$1,temp__5735__auto___40297,vec__39690_40239,line_40240,columns_40241,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40341], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40240,new cljs.core.Keyword(null,"col","col",-1959363084),column_40306,new cljs.core.Keyword(null,"name","name",1843675177),name_40342], null));
});})(seq__39776_40308,chunk__39777_40309,count__39778_40310,i__39779_40311,seq__39693_40243,chunk__39694_40244,count__39695_40245,i__39696_40246,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39806_40338,map__39806_40339__$1,gline_40340,gcol_40341,name_40342,seq__39776_40329__$1,temp__5735__auto___40328__$1,vec__39773_40305,column_40306,column_info_40307,seq__39693_40298__$1,temp__5735__auto___40297,vec__39690_40239,line_40240,columns_40241,inverted))
,cljs.core.sorted_map()));


var G__40347 = cljs.core.next(seq__39776_40329__$1);
var G__40348 = null;
var G__40349 = (0);
var G__40350 = (0);
seq__39776_40308 = G__40347;
chunk__39777_40309 = G__40348;
count__39778_40310 = G__40349;
i__39779_40311 = G__40350;
continue;
}
} else {
}
}
break;
}


var G__40351 = cljs.core.next(seq__39693_40298__$1);
var G__40352 = null;
var G__40353 = (0);
var G__40354 = (0);
seq__39693_40243 = G__40351;
chunk__39694_40244 = G__40352;
count__39695_40245 = G__40353;
i__39696_40246 = G__40354;
continue;
}
} else {
}
}
break;
}


var G__40355 = seq__39495_40235;
var G__40356 = chunk__39496_40236;
var G__40357 = count__39497_40237;
var G__40358 = (i__39498_40238 + (1));
seq__39495_40235 = G__40355;
chunk__39496_40236 = G__40356;
count__39497_40237 = G__40357;
i__39498_40238 = G__40358;
continue;
} else {
var temp__5735__auto___40361 = cljs.core.seq(seq__39495_40235);
if(temp__5735__auto___40361){
var seq__39495_40362__$1 = temp__5735__auto___40361;
if(cljs.core.chunked_seq_QMARK_(seq__39495_40362__$1)){
var c__4609__auto___40363 = cljs.core.chunk_first(seq__39495_40362__$1);
var G__40364 = cljs.core.chunk_rest(seq__39495_40362__$1);
var G__40365 = c__4609__auto___40363;
var G__40366 = cljs.core.count(c__4609__auto___40363);
var G__40367 = (0);
seq__39495_40235 = G__40364;
chunk__39496_40236 = G__40365;
count__39497_40237 = G__40366;
i__39498_40238 = G__40367;
continue;
} else {
var vec__39810_40368 = cljs.core.first(seq__39495_40362__$1);
var line_40369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39810_40368,(0),null);
var columns_40370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39810_40368,(1),null);
var seq__39813_40373 = cljs.core.seq(columns_40370);
var chunk__39814_40374 = null;
var count__39815_40375 = (0);
var i__39816_40376 = (0);
while(true){
if((i__39816_40376 < count__39815_40375)){
var vec__39888_40377 = chunk__39814_40374.cljs$core$IIndexed$_nth$arity$2(null,i__39816_40376);
var column_40378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39888_40377,(0),null);
var column_info_40379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39888_40377,(1),null);
var seq__39891_40380 = cljs.core.seq(column_info_40379);
var chunk__39892_40381 = null;
var count__39893_40382 = (0);
var i__39894_40383 = (0);
while(true){
if((i__39894_40383 < count__39893_40382)){
var map__39907_40384 = chunk__39892_40381.cljs$core$IIndexed$_nth$arity$2(null,i__39894_40383);
var map__39907_40385__$1 = (((((!((map__39907_40384 == null))))?(((((map__39907_40384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39907_40384.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39907_40384):map__39907_40384);
var gline_40386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39907_40385__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39907_40385__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39907_40385__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40386], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39891_40380,chunk__39892_40381,count__39893_40382,i__39894_40383,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39907_40384,map__39907_40385__$1,gline_40386,gcol_40387,name_40388,vec__39888_40377,column_40378,column_info_40379,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40387], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40369,new cljs.core.Keyword(null,"col","col",-1959363084),column_40378,new cljs.core.Keyword(null,"name","name",1843675177),name_40388], null));
});})(seq__39891_40380,chunk__39892_40381,count__39893_40382,i__39894_40383,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39907_40384,map__39907_40385__$1,gline_40386,gcol_40387,name_40388,vec__39888_40377,column_40378,column_info_40379,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted))
,cljs.core.sorted_map()));


var G__40393 = seq__39891_40380;
var G__40394 = chunk__39892_40381;
var G__40395 = count__39893_40382;
var G__40396 = (i__39894_40383 + (1));
seq__39891_40380 = G__40393;
chunk__39892_40381 = G__40394;
count__39893_40382 = G__40395;
i__39894_40383 = G__40396;
continue;
} else {
var temp__5735__auto___40398__$1 = cljs.core.seq(seq__39891_40380);
if(temp__5735__auto___40398__$1){
var seq__39891_40399__$1 = temp__5735__auto___40398__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39891_40399__$1)){
var c__4609__auto___40403 = cljs.core.chunk_first(seq__39891_40399__$1);
var G__40404 = cljs.core.chunk_rest(seq__39891_40399__$1);
var G__40405 = c__4609__auto___40403;
var G__40406 = cljs.core.count(c__4609__auto___40403);
var G__40407 = (0);
seq__39891_40380 = G__40404;
chunk__39892_40381 = G__40405;
count__39893_40382 = G__40406;
i__39894_40383 = G__40407;
continue;
} else {
var map__39909_40408 = cljs.core.first(seq__39891_40399__$1);
var map__39909_40409__$1 = (((((!((map__39909_40408 == null))))?(((((map__39909_40408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39909_40408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39909_40408):map__39909_40408);
var gline_40410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39909_40409__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39909_40409__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39909_40409__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40410], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39891_40380,chunk__39892_40381,count__39893_40382,i__39894_40383,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39909_40408,map__39909_40409__$1,gline_40410,gcol_40411,name_40412,seq__39891_40399__$1,temp__5735__auto___40398__$1,vec__39888_40377,column_40378,column_info_40379,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40411], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40369,new cljs.core.Keyword(null,"col","col",-1959363084),column_40378,new cljs.core.Keyword(null,"name","name",1843675177),name_40412], null));
});})(seq__39891_40380,chunk__39892_40381,count__39893_40382,i__39894_40383,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39909_40408,map__39909_40409__$1,gline_40410,gcol_40411,name_40412,seq__39891_40399__$1,temp__5735__auto___40398__$1,vec__39888_40377,column_40378,column_info_40379,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted))
,cljs.core.sorted_map()));


var G__40421 = cljs.core.next(seq__39891_40399__$1);
var G__40422 = null;
var G__40423 = (0);
var G__40424 = (0);
seq__39891_40380 = G__40421;
chunk__39892_40381 = G__40422;
count__39893_40382 = G__40423;
i__39894_40383 = G__40424;
continue;
}
} else {
}
}
break;
}


var G__40425 = seq__39813_40373;
var G__40426 = chunk__39814_40374;
var G__40427 = count__39815_40375;
var G__40428 = (i__39816_40376 + (1));
seq__39813_40373 = G__40425;
chunk__39814_40374 = G__40426;
count__39815_40375 = G__40427;
i__39816_40376 = G__40428;
continue;
} else {
var temp__5735__auto___40429__$1 = cljs.core.seq(seq__39813_40373);
if(temp__5735__auto___40429__$1){
var seq__39813_40430__$1 = temp__5735__auto___40429__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39813_40430__$1)){
var c__4609__auto___40431 = cljs.core.chunk_first(seq__39813_40430__$1);
var G__40432 = cljs.core.chunk_rest(seq__39813_40430__$1);
var G__40433 = c__4609__auto___40431;
var G__40434 = cljs.core.count(c__4609__auto___40431);
var G__40435 = (0);
seq__39813_40373 = G__40432;
chunk__39814_40374 = G__40433;
count__39815_40375 = G__40434;
i__39816_40376 = G__40435;
continue;
} else {
var vec__39911_40438 = cljs.core.first(seq__39813_40430__$1);
var column_40439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39911_40438,(0),null);
var column_info_40440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39911_40438,(1),null);
var seq__39914_40441 = cljs.core.seq(column_info_40440);
var chunk__39915_40442 = null;
var count__39916_40443 = (0);
var i__39917_40444 = (0);
while(true){
if((i__39917_40444 < count__39916_40443)){
var map__39934_40445 = chunk__39915_40442.cljs$core$IIndexed$_nth$arity$2(null,i__39917_40444);
var map__39934_40446__$1 = (((((!((map__39934_40445 == null))))?(((((map__39934_40445.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39934_40445.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39934_40445):map__39934_40445);
var gline_40447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39934_40446__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39934_40446__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39934_40446__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40447], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39914_40441,chunk__39915_40442,count__39916_40443,i__39917_40444,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39934_40445,map__39934_40446__$1,gline_40447,gcol_40448,name_40449,vec__39911_40438,column_40439,column_info_40440,seq__39813_40430__$1,temp__5735__auto___40429__$1,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40448], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40369,new cljs.core.Keyword(null,"col","col",-1959363084),column_40439,new cljs.core.Keyword(null,"name","name",1843675177),name_40449], null));
});})(seq__39914_40441,chunk__39915_40442,count__39916_40443,i__39917_40444,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39934_40445,map__39934_40446__$1,gline_40447,gcol_40448,name_40449,vec__39911_40438,column_40439,column_info_40440,seq__39813_40430__$1,temp__5735__auto___40429__$1,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted))
,cljs.core.sorted_map()));


var G__40451 = seq__39914_40441;
var G__40452 = chunk__39915_40442;
var G__40453 = count__39916_40443;
var G__40454 = (i__39917_40444 + (1));
seq__39914_40441 = G__40451;
chunk__39915_40442 = G__40452;
count__39916_40443 = G__40453;
i__39917_40444 = G__40454;
continue;
} else {
var temp__5735__auto___40455__$2 = cljs.core.seq(seq__39914_40441);
if(temp__5735__auto___40455__$2){
var seq__39914_40456__$1 = temp__5735__auto___40455__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39914_40456__$1)){
var c__4609__auto___40457 = cljs.core.chunk_first(seq__39914_40456__$1);
var G__40458 = cljs.core.chunk_rest(seq__39914_40456__$1);
var G__40459 = c__4609__auto___40457;
var G__40460 = cljs.core.count(c__4609__auto___40457);
var G__40461 = (0);
seq__39914_40441 = G__40458;
chunk__39915_40442 = G__40459;
count__39916_40443 = G__40460;
i__39917_40444 = G__40461;
continue;
} else {
var map__39937_40466 = cljs.core.first(seq__39914_40456__$1);
var map__39937_40467__$1 = (((((!((map__39937_40466 == null))))?(((((map__39937_40466.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39937_40466.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39937_40466):map__39937_40466);
var gline_40468 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39937_40467__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39937_40467__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39937_40467__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40468], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39914_40441,chunk__39915_40442,count__39916_40443,i__39917_40444,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39937_40466,map__39937_40467__$1,gline_40468,gcol_40469,name_40470,seq__39914_40456__$1,temp__5735__auto___40455__$2,vec__39911_40438,column_40439,column_info_40440,seq__39813_40430__$1,temp__5735__auto___40429__$1,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40469], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40369,new cljs.core.Keyword(null,"col","col",-1959363084),column_40439,new cljs.core.Keyword(null,"name","name",1843675177),name_40470], null));
});})(seq__39914_40441,chunk__39915_40442,count__39916_40443,i__39917_40444,seq__39813_40373,chunk__39814_40374,count__39815_40375,i__39816_40376,seq__39495_40235,chunk__39496_40236,count__39497_40237,i__39498_40238,map__39937_40466,map__39937_40467__$1,gline_40468,gcol_40469,name_40470,seq__39914_40456__$1,temp__5735__auto___40455__$2,vec__39911_40438,column_40439,column_info_40440,seq__39813_40430__$1,temp__5735__auto___40429__$1,vec__39810_40368,line_40369,columns_40370,seq__39495_40362__$1,temp__5735__auto___40361,inverted))
,cljs.core.sorted_map()));


var G__40476 = cljs.core.next(seq__39914_40456__$1);
var G__40477 = null;
var G__40478 = (0);
var G__40479 = (0);
seq__39914_40441 = G__40476;
chunk__39915_40442 = G__40477;
count__39916_40443 = G__40478;
i__39917_40444 = G__40479;
continue;
}
} else {
}
}
break;
}


var G__40480 = cljs.core.next(seq__39813_40430__$1);
var G__40481 = null;
var G__40482 = (0);
var G__40483 = (0);
seq__39813_40373 = G__40480;
chunk__39814_40374 = G__40481;
count__39815_40375 = G__40482;
i__39816_40376 = G__40483;
continue;
}
} else {
}
}
break;
}


var G__40484 = cljs.core.next(seq__39495_40362__$1);
var G__40485 = null;
var G__40486 = (0);
var G__40487 = (0);
seq__39495_40235 = G__40484;
chunk__39496_40236 = G__40485;
count__39497_40237 = G__40486;
i__39498_40238 = G__40487;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
