goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__41072 = s;
var map__41072__$1 = (((((!((map__41072 == null))))?(((((map__41072.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41072.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41072):map__41072);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41072__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41072__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__41075 = info;
var map__41076 = G__41075;
var map__41076__$1 = (((((!((map__41076 == null))))?(((((map__41076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41076.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41076):map__41076);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41076__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__41075__$1 = G__41075;
while(true){
var d__$2 = d__$1;
var map__41080 = G__41075__$1;
var map__41080__$1 = (((((!((map__41080 == null))))?(((((map__41080.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41080.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41080):map__41080);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41080__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__41800 = (d__$2 + (1));
var G__41801 = shadow__$2;
d__$1 = G__41800;
G__41075__$1 = G__41801;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__41082){
var map__41083 = p__41082;
var map__41083__$1 = (((((!((map__41083 == null))))?(((((map__41083.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41083.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41083):map__41083);
var name_var = map__41083__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41083__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41083__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__41085 = info;
var map__41085__$1 = (((((!((map__41085 == null))))?(((((map__41085.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41085.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41085):map__41085);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__41087 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__41087) : cljs.compiler.munge.call(null,G__41087));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__41089 = arguments.length;
switch (G__41089) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__41090 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__41090.cljs$core$IFn$_invoke$arity$1 ? fexpr__41090.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__41090.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__41091 = cp;
switch (G__41091) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__41092_41813 = cljs.core.seq(s);
var chunk__41093_41814 = null;
var count__41094_41815 = (0);
var i__41095_41816 = (0);
while(true){
if((i__41095_41816 < count__41094_41815)){
var c_41817 = chunk__41093_41814.cljs$core$IIndexed$_nth$arity$2(null,i__41095_41816);
sb.append(cljs.compiler.escape_char(c_41817));


var G__41822 = seq__41092_41813;
var G__41823 = chunk__41093_41814;
var G__41824 = count__41094_41815;
var G__41825 = (i__41095_41816 + (1));
seq__41092_41813 = G__41822;
chunk__41093_41814 = G__41823;
count__41094_41815 = G__41824;
i__41095_41816 = G__41825;
continue;
} else {
var temp__5735__auto___41827 = cljs.core.seq(seq__41092_41813);
if(temp__5735__auto___41827){
var seq__41092_41829__$1 = temp__5735__auto___41827;
if(cljs.core.chunked_seq_QMARK_(seq__41092_41829__$1)){
var c__4609__auto___41831 = cljs.core.chunk_first(seq__41092_41829__$1);
var G__41836 = cljs.core.chunk_rest(seq__41092_41829__$1);
var G__41837 = c__4609__auto___41831;
var G__41838 = cljs.core.count(c__4609__auto___41831);
var G__41839 = (0);
seq__41092_41813 = G__41836;
chunk__41093_41814 = G__41837;
count__41094_41815 = G__41838;
i__41095_41816 = G__41839;
continue;
} else {
var c_41843 = cljs.core.first(seq__41092_41829__$1);
sb.append(cljs.compiler.escape_char(c_41843));


var G__41844 = cljs.core.next(seq__41092_41829__$1);
var G__41845 = null;
var G__41846 = (0);
var G__41847 = (0);
seq__41092_41813 = G__41844;
chunk__41093_41814 = G__41845;
count__41094_41815 = G__41846;
i__41095_41816 = G__41847;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__41096 = cljs.core.get_global_hierarchy;
return (fexpr__41096.cljs$core$IFn$_invoke$arity$0 ? fexpr__41096.cljs$core$IFn$_invoke$arity$0() : fexpr__41096.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__41098_41852 = ast;
var map__41098_41853__$1 = (((((!((map__41098_41852 == null))))?(((((map__41098_41852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41098_41852.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41098_41852):map__41098_41852);
var env_41854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41098_41853__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_41854))){
var map__41100_41855 = env_41854;
var map__41100_41856__$1 = (((((!((map__41100_41855 == null))))?(((((map__41100_41855.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41100_41855.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41100_41855):map__41100_41855);
var line_41857 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41100_41856__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_41858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41100_41856__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__41105 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__41107 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__41106 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__41106.cljs$core$IFn$_invoke$arity$1 ? fexpr__41106.cljs$core$IFn$_invoke$arity$1(G__41107) : fexpr__41106.call(null,G__41107));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41105,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__41105;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_41857 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_41858)?(column_41858 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__41116 = arguments.length;
switch (G__41116) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___41860 = arguments.length;
var i__4790__auto___41861 = (0);
while(true){
if((i__4790__auto___41861 < len__4789__auto___41860)){
args_arr__4810__auto__.push((arguments[i__4790__auto___41861]));

var G__41862 = (i__4790__auto___41861 + (1));
i__4790__auto___41861 = G__41862;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_41863 = (function (){var G__41119 = a;
if((!(typeof a === 'string'))){
return G__41119.toString();
} else {
return G__41119;
}
})();
var temp__5739__auto___41864 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___41864 == null)){
} else {
var sm_data_41865 = temp__5739__auto___41864;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_41865,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__41108_SHARP_){
return (p1__41108_SHARP_ + s_41863.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_41863], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__41120 = cljs.core.seq(xs);
var chunk__41121 = null;
var count__41122 = (0);
var i__41123 = (0);
while(true){
if((i__41123 < count__41122)){
var x = chunk__41121.cljs$core$IIndexed$_nth$arity$2(null,i__41123);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__41868 = seq__41120;
var G__41869 = chunk__41121;
var G__41870 = count__41122;
var G__41871 = (i__41123 + (1));
seq__41120 = G__41868;
chunk__41121 = G__41869;
count__41122 = G__41870;
i__41123 = G__41871;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__41120);
if(temp__5735__auto__){
var seq__41120__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41120__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__41120__$1);
var G__41872 = cljs.core.chunk_rest(seq__41120__$1);
var G__41873 = c__4609__auto__;
var G__41874 = cljs.core.count(c__4609__auto__);
var G__41875 = (0);
seq__41120 = G__41872;
chunk__41121 = G__41873;
count__41122 = G__41874;
i__41123 = G__41875;
continue;
} else {
var x = cljs.core.first(seq__41120__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__41876 = cljs.core.next(seq__41120__$1);
var G__41877 = null;
var G__41878 = (0);
var G__41879 = (0);
seq__41120 = G__41876;
chunk__41121 = G__41877;
count__41122 = G__41878;
i__41123 = G__41879;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq41110){
var G__41111 = cljs.core.first(seq41110);
var seq41110__$1 = cljs.core.next(seq41110);
var G__41112 = cljs.core.first(seq41110__$1);
var seq41110__$2 = cljs.core.next(seq41110__$1);
var G__41113 = cljs.core.first(seq41110__$2);
var seq41110__$3 = cljs.core.next(seq41110__$2);
var G__41114 = cljs.core.first(seq41110__$3);
var seq41110__$4 = cljs.core.next(seq41110__$3);
var G__41115 = cljs.core.first(seq41110__$4);
var seq41110__$5 = cljs.core.next(seq41110__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41111,G__41112,G__41113,G__41114,G__41115,seq41110__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__41125){
var map__41126 = p__41125;
var map__41126__$1 = (((((!((map__41126 == null))))?(((((map__41126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41126.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41126):map__41126);
var m = map__41126__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41126__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__41147 = arguments.length;
switch (G__41147) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___41881 = arguments.length;
var i__4790__auto___41882 = (0);
while(true){
if((i__4790__auto___41882 < len__4789__auto___41881)){
args_arr__4810__auto__.push((arguments[i__4790__auto___41882]));

var G__41883 = (i__4790__auto___41882 + (1));
i__4790__auto___41882 = G__41883;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__41150_41896 = cljs.core.seq(xs);
var chunk__41151_41897 = null;
var count__41152_41898 = (0);
var i__41153_41899 = (0);
while(true){
if((i__41153_41899 < count__41152_41898)){
var x_41900 = chunk__41151_41897.cljs$core$IIndexed$_nth$arity$2(null,i__41153_41899);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_41900);


var G__41901 = seq__41150_41896;
var G__41902 = chunk__41151_41897;
var G__41903 = count__41152_41898;
var G__41904 = (i__41153_41899 + (1));
seq__41150_41896 = G__41901;
chunk__41151_41897 = G__41902;
count__41152_41898 = G__41903;
i__41153_41899 = G__41904;
continue;
} else {
var temp__5735__auto___41905 = cljs.core.seq(seq__41150_41896);
if(temp__5735__auto___41905){
var seq__41150_41906__$1 = temp__5735__auto___41905;
if(cljs.core.chunked_seq_QMARK_(seq__41150_41906__$1)){
var c__4609__auto___41907 = cljs.core.chunk_first(seq__41150_41906__$1);
var G__41908 = cljs.core.chunk_rest(seq__41150_41906__$1);
var G__41909 = c__4609__auto___41907;
var G__41910 = cljs.core.count(c__4609__auto___41907);
var G__41911 = (0);
seq__41150_41896 = G__41908;
chunk__41151_41897 = G__41909;
count__41152_41898 = G__41910;
i__41153_41899 = G__41911;
continue;
} else {
var x_41912 = cljs.core.first(seq__41150_41906__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_41912);


var G__41913 = cljs.core.next(seq__41150_41906__$1);
var G__41914 = null;
var G__41915 = (0);
var G__41916 = (0);
seq__41150_41896 = G__41913;
chunk__41151_41897 = G__41914;
count__41152_41898 = G__41915;
i__41153_41899 = G__41916;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq41141){
var G__41142 = cljs.core.first(seq41141);
var seq41141__$1 = cljs.core.next(seq41141);
var G__41143 = cljs.core.first(seq41141__$1);
var seq41141__$2 = cljs.core.next(seq41141__$1);
var G__41144 = cljs.core.first(seq41141__$2);
var seq41141__$3 = cljs.core.next(seq41141__$2);
var G__41145 = cljs.core.first(seq41141__$3);
var seq41141__$4 = cljs.core.next(seq41141__$3);
var G__41146 = cljs.core.first(seq41141__$4);
var seq41141__$5 = cljs.core.next(seq41141__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41142,G__41143,G__41144,G__41145,G__41146,seq41141__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__41154_41919 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__41155_41920 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__41156_41921 = true;
var _STAR_print_fn_STAR__temp_val__41157_41922 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__41156_41921);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__41157_41922);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__41155_41920);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__41154_41919);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__41159 = cljs.core.get_global_hierarchy;
return (fexpr__41159.cljs$core$IFn$_invoke$arity$0 ? fexpr__41159.cljs$core$IFn$_invoke$arity$0() : fexpr__41159.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__41160 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41160,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41160,(1),null);
var G__41163 = ns;
var G__41164 = name;
var G__41165 = (function (){
var G__41166 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__41166) : cljs.compiler.emit_constant.call(null,G__41166));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__41163,G__41164,G__41165) : cljs.compiler.emit_record_value.call(null,G__41163,G__41164,G__41165));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__41168 = cljs.core.keys(x);
var G__41169 = cljs.core.vals(x);
var G__41170 = cljs.compiler.emit_constants_comma_sep;
var G__41171 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__41168,G__41169,G__41170,G__41171) : cljs.compiler.emit_map.call(null,G__41168,G__41169,G__41170,G__41171));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__41173 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__41174 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__41173,G__41174) : cljs.compiler.emit_with_meta.call(null,G__41173,G__41174));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__41175 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41175,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41175,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41175,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__41182 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__41182) : x.call(null,G__41182));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__41183 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__41183) : x.call(null,G__41183));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__41186 = items;
var G__41187 = (function (p1__41185_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__41185_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__41186,G__41187) : cljs.compiler.emit_js_object.call(null,G__41186,G__41187));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__41193){
var map__41194 = p__41193;
var map__41194__$1 = (((((!((map__41194 == null))))?(((((map__41194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41194.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41194):map__41194);
var ast = map__41194__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41194__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41194__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41194__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__41197 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__41197__$1 = (((((!((map__41197 == null))))?(((((map__41197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41197):map__41197);
var cenv = map__41197__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41197__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__41199 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__41202 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__41202) : cljs.compiler.es5_GT__EQ_.call(null,G__41202));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__41199,cljs.analyzer.es5_allowed);
} else {
return G__41199;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__41203 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__41203,reserved);
} else {
return G__41203;
}
})();
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__41204_41928 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__41204_41929__$1 = (((G__41204_41928 instanceof cljs.core.Keyword))?G__41204_41928.fqn:null);
switch (G__41204_41929__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__41205){
var map__41206 = p__41205;
var map__41206__$1 = (((((!((map__41206 == null))))?(((((map__41206.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41206.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41206):map__41206);
var arg = map__41206__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41206__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41206__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41206__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41206__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__41208 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__41208__$1 = (((((!((map__41208 == null))))?(((((map__41208.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41208.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41208):map__41208);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41208__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__41210){
var map__41211 = p__41210;
var map__41211__$1 = (((((!((map__41211 == null))))?(((((map__41211.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41211.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41211):map__41211);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41211__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41211__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41211__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__41213_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__41213_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__41214 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__41214) : comma_sep.call(null,G__41214));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__41215 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__41215) : comma_sep.call(null,G__41215));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__41217){
var map__41218 = p__41217;
var map__41218__$1 = (((((!((map__41218 == null))))?(((((map__41218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41218.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41218):map__41218);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41218__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41218__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41218__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__41221){
var map__41222 = p__41221;
var map__41222__$1 = (((((!((map__41222 == null))))?(((((map__41222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41222.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41222):map__41222);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41222__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41222__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__41224_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__41224_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__41225 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__41225) : comma_sep.call(null,G__41225));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__41226){
var map__41227 = p__41226;
var map__41227__$1 = (((((!((map__41227 == null))))?(((((map__41227.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41227.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41227):map__41227);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41227__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41227__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___41952 = cljs.core.seq(items);
if(temp__5735__auto___41952){
var items_41953__$1 = temp__5735__auto___41952;
var vec__41232_41954 = items_41953__$1;
var seq__41233_41955 = cljs.core.seq(vec__41232_41954);
var first__41234_41956 = cljs.core.first(seq__41233_41955);
var seq__41233_41957__$1 = cljs.core.next(seq__41233_41955);
var vec__41235_41958 = first__41234_41956;
var k_41959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41235_41958,(0),null);
var v_41960 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41235_41958,(1),null);
var r_41961 = seq__41233_41957__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_41959),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_41960) : emit_js_object_val.call(null,v_41960)));

var seq__41238_41962 = cljs.core.seq(r_41961);
var chunk__41239_41963 = null;
var count__41240_41964 = (0);
var i__41241_41965 = (0);
while(true){
if((i__41241_41965 < count__41240_41964)){
var vec__41248_41966 = chunk__41239_41963.cljs$core$IIndexed$_nth$arity$2(null,i__41241_41965);
var k_41967__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41248_41966,(0),null);
var v_41968__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41248_41966,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_41967__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_41968__$1) : emit_js_object_val.call(null,v_41968__$1)));


var G__41969 = seq__41238_41962;
var G__41970 = chunk__41239_41963;
var G__41971 = count__41240_41964;
var G__41972 = (i__41241_41965 + (1));
seq__41238_41962 = G__41969;
chunk__41239_41963 = G__41970;
count__41240_41964 = G__41971;
i__41241_41965 = G__41972;
continue;
} else {
var temp__5735__auto___41973__$1 = cljs.core.seq(seq__41238_41962);
if(temp__5735__auto___41973__$1){
var seq__41238_41974__$1 = temp__5735__auto___41973__$1;
if(cljs.core.chunked_seq_QMARK_(seq__41238_41974__$1)){
var c__4609__auto___41975 = cljs.core.chunk_first(seq__41238_41974__$1);
var G__41976 = cljs.core.chunk_rest(seq__41238_41974__$1);
var G__41977 = c__4609__auto___41975;
var G__41978 = cljs.core.count(c__4609__auto___41975);
var G__41979 = (0);
seq__41238_41962 = G__41976;
chunk__41239_41963 = G__41977;
count__41240_41964 = G__41978;
i__41241_41965 = G__41979;
continue;
} else {
var vec__41251_41980 = cljs.core.first(seq__41238_41974__$1);
var k_41981__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41251_41980,(0),null);
var v_41982__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41251_41980,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_41981__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_41982__$1) : emit_js_object_val.call(null,v_41982__$1)));


var G__41983 = cljs.core.next(seq__41238_41974__$1);
var G__41984 = null;
var G__41985 = (0);
var G__41986 = (0);
seq__41238_41962 = G__41983;
chunk__41239_41963 = G__41984;
count__41240_41964 = G__41985;
i__41241_41965 = G__41986;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__41257){
var map__41258 = p__41257;
var map__41258__$1 = (((((!((map__41258 == null))))?(((((map__41258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41258.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41258):map__41258);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41258__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41258__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41258__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__41263){
var map__41264 = p__41263;
var map__41264__$1 = (((((!((map__41264 == null))))?(((((map__41264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41264):map__41264);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41264__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41264__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__41266){
var map__41267 = p__41266;
var map__41267__$1 = (((((!((map__41267 == null))))?(((((map__41267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41267):map__41267);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41267__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__41271){
var map__41272 = p__41271;
var map__41272__$1 = (((((!((map__41272 == null))))?(((((map__41272.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41272.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41272):map__41272);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41272__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41272__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__41284 = cljs.analyzer.unwrap_quote(expr);
var map__41284__$1 = (((((!((map__41284 == null))))?(((((map__41284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41284):map__41284);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41284__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41284__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41284__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__41290 = cljs.analyzer.unwrap_quote(expr);
var map__41290__$1 = (((((!((map__41290 == null))))?(((((map__41290.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41290.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41290):map__41290);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41290__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41290__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41290__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__41293 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__41293.cljs$core$IFn$_invoke$arity$1 ? fexpr__41293.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__41293.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__41294){
var map__41295 = p__41294;
var map__41295__$1 = (((((!((map__41295 == null))))?(((((map__41295.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41295.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41295):map__41295);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41295__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41295__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41295__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41295__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41295__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__41297){
var map__41298 = p__41297;
var map__41298__$1 = (((((!((map__41298 == null))))?(((((map__41298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41298.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41298):map__41298);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41298__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41298__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41298__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41298__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__41300_41987 = cljs.core.seq(nodes);
var chunk__41301_41988 = null;
var count__41302_41989 = (0);
var i__41303_41990 = (0);
while(true){
if((i__41303_41990 < count__41302_41989)){
var map__41321_41991 = chunk__41301_41988.cljs$core$IIndexed$_nth$arity$2(null,i__41303_41990);
var map__41321_41992__$1 = (((((!((map__41321_41991 == null))))?(((((map__41321_41991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41321_41991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41321_41991):map__41321_41991);
var ts_41993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41321_41992__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__41322_41994 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41321_41992__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__41322_41995__$1 = (((((!((map__41322_41994 == null))))?(((((map__41322_41994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41322_41994.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41322_41994):map__41322_41994);
var then_41996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41322_41995__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__41326_41997 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_41993));
var chunk__41327_41998 = null;
var count__41328_41999 = (0);
var i__41329_42000 = (0);
while(true){
if((i__41329_42000 < count__41328_41999)){
var test_42001 = chunk__41327_41998.cljs$core$IIndexed$_nth$arity$2(null,i__41329_42000);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_42001,":");


var G__42002 = seq__41326_41997;
var G__42003 = chunk__41327_41998;
var G__42004 = count__41328_41999;
var G__42005 = (i__41329_42000 + (1));
seq__41326_41997 = G__42002;
chunk__41327_41998 = G__42003;
count__41328_41999 = G__42004;
i__41329_42000 = G__42005;
continue;
} else {
var temp__5735__auto___42006 = cljs.core.seq(seq__41326_41997);
if(temp__5735__auto___42006){
var seq__41326_42007__$1 = temp__5735__auto___42006;
if(cljs.core.chunked_seq_QMARK_(seq__41326_42007__$1)){
var c__4609__auto___42008 = cljs.core.chunk_first(seq__41326_42007__$1);
var G__42009 = cljs.core.chunk_rest(seq__41326_42007__$1);
var G__42010 = c__4609__auto___42008;
var G__42011 = cljs.core.count(c__4609__auto___42008);
var G__42012 = (0);
seq__41326_41997 = G__42009;
chunk__41327_41998 = G__42010;
count__41328_41999 = G__42011;
i__41329_42000 = G__42012;
continue;
} else {
var test_42013 = cljs.core.first(seq__41326_42007__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_42013,":");


var G__42014 = cljs.core.next(seq__41326_42007__$1);
var G__42015 = null;
var G__42016 = (0);
var G__42017 = (0);
seq__41326_41997 = G__42014;
chunk__41327_41998 = G__42015;
count__41328_41999 = G__42016;
i__41329_42000 = G__42017;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_41996);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_41996);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__42018 = seq__41300_41987;
var G__42019 = chunk__41301_41988;
var G__42020 = count__41302_41989;
var G__42021 = (i__41303_41990 + (1));
seq__41300_41987 = G__42018;
chunk__41301_41988 = G__42019;
count__41302_41989 = G__42020;
i__41303_41990 = G__42021;
continue;
} else {
var temp__5735__auto___42025 = cljs.core.seq(seq__41300_41987);
if(temp__5735__auto___42025){
var seq__41300_42026__$1 = temp__5735__auto___42025;
if(cljs.core.chunked_seq_QMARK_(seq__41300_42026__$1)){
var c__4609__auto___42027 = cljs.core.chunk_first(seq__41300_42026__$1);
var G__42028 = cljs.core.chunk_rest(seq__41300_42026__$1);
var G__42029 = c__4609__auto___42027;
var G__42030 = cljs.core.count(c__4609__auto___42027);
var G__42031 = (0);
seq__41300_41987 = G__42028;
chunk__41301_41988 = G__42029;
count__41302_41989 = G__42030;
i__41303_41990 = G__42031;
continue;
} else {
var map__41333_42032 = cljs.core.first(seq__41300_42026__$1);
var map__41333_42033__$1 = (((((!((map__41333_42032 == null))))?(((((map__41333_42032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41333_42032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41333_42032):map__41333_42032);
var ts_42034 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41333_42033__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__41334_42035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41333_42033__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__41334_42036__$1 = (((((!((map__41334_42035 == null))))?(((((map__41334_42035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41334_42035.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41334_42035):map__41334_42035);
var then_42037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41334_42036__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__41337_42039 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_42034));
var chunk__41338_42040 = null;
var count__41339_42041 = (0);
var i__41340_42042 = (0);
while(true){
if((i__41340_42042 < count__41339_42041)){
var test_42043 = chunk__41338_42040.cljs$core$IIndexed$_nth$arity$2(null,i__41340_42042);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_42043,":");


var G__42044 = seq__41337_42039;
var G__42045 = chunk__41338_42040;
var G__42046 = count__41339_42041;
var G__42047 = (i__41340_42042 + (1));
seq__41337_42039 = G__42044;
chunk__41338_42040 = G__42045;
count__41339_42041 = G__42046;
i__41340_42042 = G__42047;
continue;
} else {
var temp__5735__auto___42049__$1 = cljs.core.seq(seq__41337_42039);
if(temp__5735__auto___42049__$1){
var seq__41337_42050__$1 = temp__5735__auto___42049__$1;
if(cljs.core.chunked_seq_QMARK_(seq__41337_42050__$1)){
var c__4609__auto___42051 = cljs.core.chunk_first(seq__41337_42050__$1);
var G__42052 = cljs.core.chunk_rest(seq__41337_42050__$1);
var G__42053 = c__4609__auto___42051;
var G__42054 = cljs.core.count(c__4609__auto___42051);
var G__42055 = (0);
seq__41337_42039 = G__42052;
chunk__41338_42040 = G__42053;
count__41339_42041 = G__42054;
i__41340_42042 = G__42055;
continue;
} else {
var test_42056 = cljs.core.first(seq__41337_42050__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_42056,":");


var G__42057 = cljs.core.next(seq__41337_42050__$1);
var G__42058 = null;
var G__42059 = (0);
var G__42060 = (0);
seq__41337_42039 = G__42057;
chunk__41338_42040 = G__42058;
count__41339_42041 = G__42059;
i__41340_42042 = G__42060;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_42037);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_42037);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__42061 = cljs.core.next(seq__41300_42026__$1);
var G__42062 = null;
var G__42063 = (0);
var G__42064 = (0);
seq__41300_41987 = G__42061;
chunk__41301_41988 = G__42062;
count__41302_41989 = G__42063;
i__41303_41990 = G__42064;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__41341){
var map__41342 = p__41341;
var map__41342__$1 = (((((!((map__41342 == null))))?(((((map__41342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41342.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41342):map__41342);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41342__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41342__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__41347 = env;
var G__41348 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__41347,G__41348) : cljs.compiler.resolve_type.call(null,G__41347,G__41348));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__41349 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41349,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41349,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__41344_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__41344_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__41344_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__41352 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__41352,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__41352;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__41355 = env;
var G__41356 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__41355,G__41356) : cljs.compiler.resolve_type.call(null,G__41355,G__41356));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41357_SHARP_){
return cljs.compiler.resolve_type(env,p1__41357_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__41358 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__41359 = cljs.core.seq(vec__41358);
var first__41360 = cljs.core.first(seq__41359);
var seq__41359__$1 = cljs.core.next(seq__41359);
var p = first__41360;
var first__41360__$1 = cljs.core.first(seq__41359__$1);
var seq__41359__$2 = cljs.core.next(seq__41359__$1);
var ts = first__41360__$1;
var first__41360__$2 = cljs.core.first(seq__41359__$2);
var seq__41359__$3 = cljs.core.next(seq__41359__$2);
var n = first__41360__$2;
var xs = seq__41359__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__41361 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__41362 = cljs.core.seq(vec__41361);
var first__41363 = cljs.core.first(seq__41362);
var seq__41362__$1 = cljs.core.next(seq__41362);
var p = first__41363;
var first__41363__$1 = cljs.core.first(seq__41362__$1);
var seq__41362__$2 = cljs.core.next(seq__41362__$1);
var ts = first__41363__$1;
var xs = seq__41362__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__41365 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__41364 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__41364.cljs$core$IFn$_invoke$arity$1 ? fexpr__41364.cljs$core$IFn$_invoke$arity$1(G__41365) : fexpr__41364.call(null,G__41365));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__41368 = arguments.length;
switch (G__41368) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__41376 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41366_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__41366_SHARP_);
} else {
return p1__41366_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__41377 = cljs.core.seq(vec__41376);
var first__41378 = cljs.core.first(seq__41377);
var seq__41377__$1 = cljs.core.next(seq__41377);
var x = first__41378;
var ys = seq__41377__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__41379 = cljs.core.seq(ys);
var chunk__41380 = null;
var count__41381 = (0);
var i__41382 = (0);
while(true){
if((i__41382 < count__41381)){
var next_line = chunk__41380.cljs$core$IIndexed$_nth$arity$2(null,i__41382);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__42066 = seq__41379;
var G__42067 = chunk__41380;
var G__42068 = count__41381;
var G__42069 = (i__41382 + (1));
seq__41379 = G__42066;
chunk__41380 = G__42067;
count__41381 = G__42068;
i__41382 = G__42069;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__41379);
if(temp__5735__auto__){
var seq__41379__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41379__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__41379__$1);
var G__42070 = cljs.core.chunk_rest(seq__41379__$1);
var G__42071 = c__4609__auto__;
var G__42072 = cljs.core.count(c__4609__auto__);
var G__42073 = (0);
seq__41379 = G__42070;
chunk__41380 = G__42071;
count__41381 = G__42072;
i__41382 = G__42073;
continue;
} else {
var next_line = cljs.core.first(seq__41379__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__42074 = cljs.core.next(seq__41379__$1);
var G__42075 = null;
var G__42076 = (0);
var G__42077 = (0);
seq__41379 = G__42074;
chunk__41380 = G__42075;
count__41381 = G__42076;
i__41382 = G__42077;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__41383_42078 = cljs.core.seq(docs__$2);
var chunk__41384_42079 = null;
var count__41385_42080 = (0);
var i__41386_42081 = (0);
while(true){
if((i__41386_42081 < count__41385_42080)){
var e_42082 = chunk__41384_42079.cljs$core$IIndexed$_nth$arity$2(null,i__41386_42081);
if(cljs.core.truth_(e_42082)){
print_comment_lines(e_42082);
} else {
}


var G__42083 = seq__41383_42078;
var G__42084 = chunk__41384_42079;
var G__42085 = count__41385_42080;
var G__42086 = (i__41386_42081 + (1));
seq__41383_42078 = G__42083;
chunk__41384_42079 = G__42084;
count__41385_42080 = G__42085;
i__41386_42081 = G__42086;
continue;
} else {
var temp__5735__auto___42087 = cljs.core.seq(seq__41383_42078);
if(temp__5735__auto___42087){
var seq__41383_42088__$1 = temp__5735__auto___42087;
if(cljs.core.chunked_seq_QMARK_(seq__41383_42088__$1)){
var c__4609__auto___42089 = cljs.core.chunk_first(seq__41383_42088__$1);
var G__42090 = cljs.core.chunk_rest(seq__41383_42088__$1);
var G__42091 = c__4609__auto___42089;
var G__42092 = cljs.core.count(c__4609__auto___42089);
var G__42093 = (0);
seq__41383_42078 = G__42090;
chunk__41384_42079 = G__42091;
count__41385_42080 = G__42092;
i__41386_42081 = G__42093;
continue;
} else {
var e_42094 = cljs.core.first(seq__41383_42088__$1);
if(cljs.core.truth_(e_42094)){
print_comment_lines(e_42094);
} else {
}


var G__42095 = cljs.core.next(seq__41383_42088__$1);
var G__42096 = null;
var G__42097 = (0);
var G__42098 = (0);
seq__41383_42078 = G__42095;
chunk__41384_42079 = G__42096;
count__41385_42080 = G__42097;
i__41386_42081 = G__42098;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__41388_SHARP_){
return goog.string.startsWith(p1__41388_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__41389){
var map__41390 = p__41389;
var map__41390__$1 = (((((!((map__41390 == null))))?(((((map__41390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41390.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41390):map__41390);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41390__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__41392){
var map__41393 = p__41392;
var map__41393__$1 = (((((!((map__41393 == null))))?(((((map__41393.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41393.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41393):map__41393);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41393__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41393__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41393__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__41395_42107 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__41396_42108 = null;
var count__41397_42109 = (0);
var i__41398_42110 = (0);
while(true){
if((i__41398_42110 < count__41397_42109)){
var vec__41405_42111 = chunk__41396_42108.cljs$core$IIndexed$_nth$arity$2(null,i__41398_42110);
var i_42112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41405_42111,(0),null);
var param_42113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41405_42111,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_42113);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__42114 = seq__41395_42107;
var G__42115 = chunk__41396_42108;
var G__42116 = count__41397_42109;
var G__42117 = (i__41398_42110 + (1));
seq__41395_42107 = G__42114;
chunk__41396_42108 = G__42115;
count__41397_42109 = G__42116;
i__41398_42110 = G__42117;
continue;
} else {
var temp__5735__auto___42118 = cljs.core.seq(seq__41395_42107);
if(temp__5735__auto___42118){
var seq__41395_42121__$1 = temp__5735__auto___42118;
if(cljs.core.chunked_seq_QMARK_(seq__41395_42121__$1)){
var c__4609__auto___42122 = cljs.core.chunk_first(seq__41395_42121__$1);
var G__42123 = cljs.core.chunk_rest(seq__41395_42121__$1);
var G__42124 = c__4609__auto___42122;
var G__42125 = cljs.core.count(c__4609__auto___42122);
var G__42126 = (0);
seq__41395_42107 = G__42123;
chunk__41396_42108 = G__42124;
count__41397_42109 = G__42125;
i__41398_42110 = G__42126;
continue;
} else {
var vec__41408_42127 = cljs.core.first(seq__41395_42121__$1);
var i_42128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41408_42127,(0),null);
var param_42129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41408_42127,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_42129);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__42130 = cljs.core.next(seq__41395_42121__$1);
var G__42131 = null;
var G__42132 = (0);
var G__42133 = (0);
seq__41395_42107 = G__42130;
chunk__41396_42108 = G__42131;
count__41397_42109 = G__42132;
i__41398_42110 = G__42133;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__41411_42134 = cljs.core.seq(params);
var chunk__41412_42135 = null;
var count__41413_42136 = (0);
var i__41414_42137 = (0);
while(true){
if((i__41414_42137 < count__41413_42136)){
var param_42138 = chunk__41412_42135.cljs$core$IIndexed$_nth$arity$2(null,i__41414_42137);
cljs.compiler.emit(param_42138);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42138,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42139 = seq__41411_42134;
var G__42140 = chunk__41412_42135;
var G__42141 = count__41413_42136;
var G__42142 = (i__41414_42137 + (1));
seq__41411_42134 = G__42139;
chunk__41412_42135 = G__42140;
count__41413_42136 = G__42141;
i__41414_42137 = G__42142;
continue;
} else {
var temp__5735__auto___42143 = cljs.core.seq(seq__41411_42134);
if(temp__5735__auto___42143){
var seq__41411_42144__$1 = temp__5735__auto___42143;
if(cljs.core.chunked_seq_QMARK_(seq__41411_42144__$1)){
var c__4609__auto___42145 = cljs.core.chunk_first(seq__41411_42144__$1);
var G__42146 = cljs.core.chunk_rest(seq__41411_42144__$1);
var G__42147 = c__4609__auto___42145;
var G__42148 = cljs.core.count(c__4609__auto___42145);
var G__42149 = (0);
seq__41411_42134 = G__42146;
chunk__41412_42135 = G__42147;
count__41413_42136 = G__42148;
i__41414_42137 = G__42149;
continue;
} else {
var param_42150 = cljs.core.first(seq__41411_42144__$1);
cljs.compiler.emit(param_42150);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42150,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42151 = cljs.core.next(seq__41411_42144__$1);
var G__42152 = null;
var G__42153 = (0);
var G__42154 = (0);
seq__41411_42134 = G__42151;
chunk__41412_42135 = G__42152;
count__41413_42136 = G__42153;
i__41414_42137 = G__42154;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__41422_42155 = cljs.core.seq(params);
var chunk__41423_42156 = null;
var count__41424_42157 = (0);
var i__41425_42158 = (0);
while(true){
if((i__41425_42158 < count__41424_42157)){
var param_42159 = chunk__41423_42156.cljs$core$IIndexed$_nth$arity$2(null,i__41425_42158);
cljs.compiler.emit(param_42159);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42159,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42160 = seq__41422_42155;
var G__42161 = chunk__41423_42156;
var G__42162 = count__41424_42157;
var G__42163 = (i__41425_42158 + (1));
seq__41422_42155 = G__42160;
chunk__41423_42156 = G__42161;
count__41424_42157 = G__42162;
i__41425_42158 = G__42163;
continue;
} else {
var temp__5735__auto___42164 = cljs.core.seq(seq__41422_42155);
if(temp__5735__auto___42164){
var seq__41422_42165__$1 = temp__5735__auto___42164;
if(cljs.core.chunked_seq_QMARK_(seq__41422_42165__$1)){
var c__4609__auto___42166 = cljs.core.chunk_first(seq__41422_42165__$1);
var G__42167 = cljs.core.chunk_rest(seq__41422_42165__$1);
var G__42168 = c__4609__auto___42166;
var G__42169 = cljs.core.count(c__4609__auto___42166);
var G__42170 = (0);
seq__41422_42155 = G__42167;
chunk__41423_42156 = G__42168;
count__41424_42157 = G__42169;
i__41425_42158 = G__42170;
continue;
} else {
var param_42171 = cljs.core.first(seq__41422_42165__$1);
cljs.compiler.emit(param_42171);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42171,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42172 = cljs.core.next(seq__41422_42165__$1);
var G__42173 = null;
var G__42174 = (0);
var G__42175 = (0);
seq__41422_42155 = G__42172;
chunk__41423_42156 = G__42173;
count__41424_42157 = G__42174;
i__41425_42158 = G__42175;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__41427 = cljs.core.seq(params);
var chunk__41428 = null;
var count__41429 = (0);
var i__41430 = (0);
while(true){
if((i__41430 < count__41429)){
var param = chunk__41428.cljs$core$IIndexed$_nth$arity$2(null,i__41430);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42177 = seq__41427;
var G__42178 = chunk__41428;
var G__42179 = count__41429;
var G__42180 = (i__41430 + (1));
seq__41427 = G__42177;
chunk__41428 = G__42178;
count__41429 = G__42179;
i__41430 = G__42180;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__41427);
if(temp__5735__auto__){
var seq__41427__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41427__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__41427__$1);
var G__42181 = cljs.core.chunk_rest(seq__41427__$1);
var G__42182 = c__4609__auto__;
var G__42183 = cljs.core.count(c__4609__auto__);
var G__42184 = (0);
seq__41427 = G__42181;
chunk__41428 = G__42182;
count__41429 = G__42183;
i__41430 = G__42184;
continue;
} else {
var param = cljs.core.first(seq__41427__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42185 = cljs.core.next(seq__41427__$1);
var G__42186 = null;
var G__42187 = (0);
var G__42188 = (0);
seq__41427 = G__42185;
chunk__41428 = G__42186;
count__41429 = G__42187;
i__41430 = G__42188;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__41431){
var map__41432 = p__41431;
var map__41432__$1 = (((((!((map__41432 == null))))?(((((map__41432.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41432.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41432):map__41432);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41432__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41432__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41432__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41432__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41432__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41432__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__41434){
var map__41435 = p__41434;
var map__41435__$1 = (((((!((map__41435 == null))))?(((((map__41435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41435):map__41435);
var f = map__41435__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41435__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_42189__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_42190 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_42189__$1);
var delegate_name_42191 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_42190),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_42191," = function (");

var seq__41437_42192 = cljs.core.seq(params);
var chunk__41438_42193 = null;
var count__41439_42194 = (0);
var i__41440_42195 = (0);
while(true){
if((i__41440_42195 < count__41439_42194)){
var param_42196 = chunk__41438_42193.cljs$core$IIndexed$_nth$arity$2(null,i__41440_42195);
cljs.compiler.emit(param_42196);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42196,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42197 = seq__41437_42192;
var G__42198 = chunk__41438_42193;
var G__42199 = count__41439_42194;
var G__42200 = (i__41440_42195 + (1));
seq__41437_42192 = G__42197;
chunk__41438_42193 = G__42198;
count__41439_42194 = G__42199;
i__41440_42195 = G__42200;
continue;
} else {
var temp__5735__auto___42201 = cljs.core.seq(seq__41437_42192);
if(temp__5735__auto___42201){
var seq__41437_42202__$1 = temp__5735__auto___42201;
if(cljs.core.chunked_seq_QMARK_(seq__41437_42202__$1)){
var c__4609__auto___42203 = cljs.core.chunk_first(seq__41437_42202__$1);
var G__42204 = cljs.core.chunk_rest(seq__41437_42202__$1);
var G__42205 = c__4609__auto___42203;
var G__42206 = cljs.core.count(c__4609__auto___42203);
var G__42207 = (0);
seq__41437_42192 = G__42204;
chunk__41438_42193 = G__42205;
count__41439_42194 = G__42206;
i__41440_42195 = G__42207;
continue;
} else {
var param_42208 = cljs.core.first(seq__41437_42202__$1);
cljs.compiler.emit(param_42208);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42208,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42209 = cljs.core.next(seq__41437_42202__$1);
var G__42210 = null;
var G__42211 = (0);
var G__42212 = (0);
seq__41437_42192 = G__42209;
chunk__41438_42193 = G__42210;
count__41439_42194 = G__42211;
i__41440_42195 = G__42212;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_42190," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_42213 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_42213,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_42191,".call(this,");

var seq__41442_42214 = cljs.core.seq(params);
var chunk__41443_42215 = null;
var count__41444_42216 = (0);
var i__41445_42217 = (0);
while(true){
if((i__41445_42217 < count__41444_42216)){
var param_42218 = chunk__41443_42215.cljs$core$IIndexed$_nth$arity$2(null,i__41445_42217);
cljs.compiler.emit(param_42218);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42218,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42219 = seq__41442_42214;
var G__42220 = chunk__41443_42215;
var G__42221 = count__41444_42216;
var G__42222 = (i__41445_42217 + (1));
seq__41442_42214 = G__42219;
chunk__41443_42215 = G__42220;
count__41444_42216 = G__42221;
i__41445_42217 = G__42222;
continue;
} else {
var temp__5735__auto___42223 = cljs.core.seq(seq__41442_42214);
if(temp__5735__auto___42223){
var seq__41442_42224__$1 = temp__5735__auto___42223;
if(cljs.core.chunked_seq_QMARK_(seq__41442_42224__$1)){
var c__4609__auto___42225 = cljs.core.chunk_first(seq__41442_42224__$1);
var G__42226 = cljs.core.chunk_rest(seq__41442_42224__$1);
var G__42227 = c__4609__auto___42225;
var G__42228 = cljs.core.count(c__4609__auto___42225);
var G__42229 = (0);
seq__41442_42214 = G__42226;
chunk__41443_42215 = G__42227;
count__41444_42216 = G__42228;
i__41445_42217 = G__42229;
continue;
} else {
var param_42230 = cljs.core.first(seq__41442_42224__$1);
cljs.compiler.emit(param_42230);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_42230,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__42231 = cljs.core.next(seq__41442_42224__$1);
var G__42232 = null;
var G__42233 = (0);
var G__42234 = (0);
seq__41442_42214 = G__42231;
chunk__41443_42215 = G__42232;
count__41444_42216 = G__42233;
i__41445_42217 = G__42234;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42190,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_42190,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_42189__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42190,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_42191,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_42190,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__41450){
var map__41451 = p__41450;
var map__41451__$1 = (((((!((map__41451 == null))))?(((((map__41451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41451):map__41451);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41451__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41447_SHARP_){
var and__4174__auto__ = p1__41447_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__41447_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_42236__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_42237 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_42236__$1);
var maxparams_42238 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_42239 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_42237),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_42240 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__41448_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__41448_SHARP_)));
}),cljs.core.seq(mmap_42239));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_42237," = null;");

var seq__41457_42241 = cljs.core.seq(ms_42240);
var chunk__41458_42242 = null;
var count__41459_42243 = (0);
var i__41460_42244 = (0);
while(true){
if((i__41460_42244 < count__41459_42243)){
var vec__41467_42245 = chunk__41458_42242.cljs$core$IIndexed$_nth$arity$2(null,i__41460_42244);
var n_42246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41467_42245,(0),null);
var meth_42247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41467_42245,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_42246," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_42247))){
cljs.compiler.emit_variadic_fn_method(meth_42247);
} else {
cljs.compiler.emit_fn_method(meth_42247);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__42248 = seq__41457_42241;
var G__42249 = chunk__41458_42242;
var G__42250 = count__41459_42243;
var G__42251 = (i__41460_42244 + (1));
seq__41457_42241 = G__42248;
chunk__41458_42242 = G__42249;
count__41459_42243 = G__42250;
i__41460_42244 = G__42251;
continue;
} else {
var temp__5735__auto___42252 = cljs.core.seq(seq__41457_42241);
if(temp__5735__auto___42252){
var seq__41457_42253__$1 = temp__5735__auto___42252;
if(cljs.core.chunked_seq_QMARK_(seq__41457_42253__$1)){
var c__4609__auto___42254 = cljs.core.chunk_first(seq__41457_42253__$1);
var G__42255 = cljs.core.chunk_rest(seq__41457_42253__$1);
var G__42256 = c__4609__auto___42254;
var G__42257 = cljs.core.count(c__4609__auto___42254);
var G__42258 = (0);
seq__41457_42241 = G__42255;
chunk__41458_42242 = G__42256;
count__41459_42243 = G__42257;
i__41460_42244 = G__42258;
continue;
} else {
var vec__41470_42259 = cljs.core.first(seq__41457_42253__$1);
var n_42260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41470_42259,(0),null);
var meth_42261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41470_42259,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_42260," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_42261))){
cljs.compiler.emit_variadic_fn_method(meth_42261);
} else {
cljs.compiler.emit_fn_method(meth_42261);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__42262 = cljs.core.next(seq__41457_42253__$1);
var G__42263 = null;
var G__42264 = (0);
var G__42265 = (0);
seq__41457_42241 = G__42262;
chunk__41458_42242 = G__42263;
count__41459_42243 = G__42264;
i__41460_42244 = G__42265;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42237," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_42238),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_42238)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_42238));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__41473_42266 = cljs.core.seq(ms_42240);
var chunk__41474_42267 = null;
var count__41475_42268 = (0);
var i__41476_42269 = (0);
while(true){
if((i__41476_42269 < count__41475_42268)){
var vec__41485_42270 = chunk__41474_42267.cljs$core$IIndexed$_nth$arity$2(null,i__41476_42269);
var n_42271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41485_42270,(0),null);
var meth_42272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41485_42270,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_42272))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_42273 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_42273," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_42274 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_42273," = new cljs.core.IndexedSeq(",a_42274,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_42271,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_42238)),(((cljs.core.count(maxparams_42238) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_42273,");"], 0));
} else {
var pcnt_42275 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_42272));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_42275,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_42271,".call(this",(((pcnt_42275 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_42275,maxparams_42238)),null,(1),null)),(2),null))),");");
}


var G__42276 = seq__41473_42266;
var G__42277 = chunk__41474_42267;
var G__42278 = count__41475_42268;
var G__42279 = (i__41476_42269 + (1));
seq__41473_42266 = G__42276;
chunk__41474_42267 = G__42277;
count__41475_42268 = G__42278;
i__41476_42269 = G__42279;
continue;
} else {
var temp__5735__auto___42280 = cljs.core.seq(seq__41473_42266);
if(temp__5735__auto___42280){
var seq__41473_42281__$1 = temp__5735__auto___42280;
if(cljs.core.chunked_seq_QMARK_(seq__41473_42281__$1)){
var c__4609__auto___42282 = cljs.core.chunk_first(seq__41473_42281__$1);
var G__42283 = cljs.core.chunk_rest(seq__41473_42281__$1);
var G__42284 = c__4609__auto___42282;
var G__42285 = cljs.core.count(c__4609__auto___42282);
var G__42286 = (0);
seq__41473_42266 = G__42283;
chunk__41474_42267 = G__42284;
count__41475_42268 = G__42285;
i__41476_42269 = G__42286;
continue;
} else {
var vec__41488_42287 = cljs.core.first(seq__41473_42281__$1);
var n_42288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41488_42287,(0),null);
var meth_42289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41488_42287,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_42289))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_42290 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_42290," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_42291 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_42290," = new cljs.core.IndexedSeq(",a_42291,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_42288,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_42238)),(((cljs.core.count(maxparams_42238) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_42290,");"], 0));
} else {
var pcnt_42292 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_42289));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_42292,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_42288,".call(this",(((pcnt_42292 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_42292,maxparams_42238)),null,(1),null)),(2),null))),");");
}


var G__42293 = cljs.core.next(seq__41473_42281__$1);
var G__42294 = null;
var G__42295 = (0);
var G__42296 = (0);
seq__41473_42266 = G__42293;
chunk__41474_42267 = G__42294;
count__41475_42268 = G__42295;
i__41476_42269 = G__42296;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_42298 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_42240)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_42298,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42237,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42237,".cljs$lang$applyTo = ",cljs.core.some((function (p1__41449_SHARP_){
var vec__41491 = p1__41449_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41491,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41491,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_42240),".cljs$lang$applyTo;");
} else {
}

var seq__41494_42299 = cljs.core.seq(ms_42240);
var chunk__41495_42300 = null;
var count__41496_42301 = (0);
var i__41497_42302 = (0);
while(true){
if((i__41497_42302 < count__41496_42301)){
var vec__41504_42303 = chunk__41495_42300.cljs$core$IIndexed$_nth$arity$2(null,i__41497_42302);
var n_42304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41504_42303,(0),null);
var meth_42305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41504_42303,(1),null);
var c_42306 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_42305));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_42305))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42237,".cljs$core$IFn$_invoke$arity$variadic = ",n_42304,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_42237,".cljs$core$IFn$_invoke$arity$",c_42306," = ",n_42304,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__42307 = seq__41494_42299;
var G__42308 = chunk__41495_42300;
var G__42309 = count__41496_42301;
var G__42310 = (i__41497_42302 + (1));
seq__41494_42299 = G__42307;
chunk__41495_42300 = G__42308;
count__41496_42301 = G__42309;
i__41497_42302 = G__42310;
continue;
} else {
var temp__5735__auto___42311 = cljs.core.seq(seq__41494_42299);
if(temp__5735__auto___42311){
var seq__41494_42312__$1 = temp__5735__auto___42311;
if(cljs.core.chunked_seq_QMARK_(seq__41494_42312__$1)){
var c__4609__auto___42313 = cljs.core.chunk_first(seq__41494_42312__$1);
var G__42314 = cljs.core.chunk_rest(seq__41494_42312__$1);
var G__42315 = c__4609__auto___42313;
var G__42316 = cljs.core.count(c__4609__auto___42313);
var G__42317 = (0);
seq__41494_42299 = G__42314;
chunk__41495_42300 = G__42315;
count__41496_42301 = G__42316;
i__41497_42302 = G__42317;
continue;
} else {
var vec__41507_42318 = cljs.core.first(seq__41494_42312__$1);
var n_42319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41507_42318,(0),null);
var meth_42320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41507_42318,(1),null);
var c_42321 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_42320));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_42320))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_42237,".cljs$core$IFn$_invoke$arity$variadic = ",n_42319,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_42237,".cljs$core$IFn$_invoke$arity$",c_42321," = ",n_42319,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__42322 = cljs.core.next(seq__41494_42312__$1);
var G__42323 = null;
var G__42324 = (0);
var G__42325 = (0);
seq__41494_42299 = G__42322;
chunk__41495_42300 = G__42323;
count__41496_42301 = G__42324;
i__41497_42302 = G__42325;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_42237,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__41510){
var map__41511 = p__41510;
var map__41511__$1 = (((((!((map__41511 == null))))?(((((map__41511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41511):map__41511);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41511__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41511__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41511__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__41513_42326 = cljs.core.seq(statements);
var chunk__41514_42327 = null;
var count__41515_42328 = (0);
var i__41516_42329 = (0);
while(true){
if((i__41516_42329 < count__41515_42328)){
var s_42330 = chunk__41514_42327.cljs$core$IIndexed$_nth$arity$2(null,i__41516_42329);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_42330);


var G__42331 = seq__41513_42326;
var G__42332 = chunk__41514_42327;
var G__42333 = count__41515_42328;
var G__42334 = (i__41516_42329 + (1));
seq__41513_42326 = G__42331;
chunk__41514_42327 = G__42332;
count__41515_42328 = G__42333;
i__41516_42329 = G__42334;
continue;
} else {
var temp__5735__auto___42335 = cljs.core.seq(seq__41513_42326);
if(temp__5735__auto___42335){
var seq__41513_42336__$1 = temp__5735__auto___42335;
if(cljs.core.chunked_seq_QMARK_(seq__41513_42336__$1)){
var c__4609__auto___42337 = cljs.core.chunk_first(seq__41513_42336__$1);
var G__42338 = cljs.core.chunk_rest(seq__41513_42336__$1);
var G__42339 = c__4609__auto___42337;
var G__42340 = cljs.core.count(c__4609__auto___42337);
var G__42341 = (0);
seq__41513_42326 = G__42338;
chunk__41514_42327 = G__42339;
count__41515_42328 = G__42340;
i__41516_42329 = G__42341;
continue;
} else {
var s_42342 = cljs.core.first(seq__41513_42336__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_42342);


var G__42343 = cljs.core.next(seq__41513_42336__$1);
var G__42344 = null;
var G__42345 = (0);
var G__42346 = (0);
seq__41513_42326 = G__42343;
chunk__41514_42327 = G__42344;
count__41515_42328 = G__42345;
i__41516_42329 = G__42346;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__41517){
var map__41518 = p__41517;
var map__41518__$1 = (((((!((map__41518 == null))))?(((((map__41518.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41518.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41518):map__41518);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41518__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41518__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41518__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41518__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41518__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__41520,is_loop){
var map__41521 = p__41520;
var map__41521__$1 = (((((!((map__41521 == null))))?(((((map__41521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41521):map__41521);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41521__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41521__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41521__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__41523_42347 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__41524_42348 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__41524_42348);

try{var seq__41525_42349 = cljs.core.seq(bindings);
var chunk__41526_42350 = null;
var count__41527_42351 = (0);
var i__41528_42352 = (0);
while(true){
if((i__41528_42352 < count__41527_42351)){
var map__41533_42353 = chunk__41526_42350.cljs$core$IIndexed$_nth$arity$2(null,i__41528_42352);
var map__41533_42354__$1 = (((((!((map__41533_42353 == null))))?(((((map__41533_42353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41533_42353.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41533_42353):map__41533_42353);
var binding_42355 = map__41533_42354__$1;
var init_42356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41533_42354__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_42355);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_42356,";");


var G__42357 = seq__41525_42349;
var G__42358 = chunk__41526_42350;
var G__42359 = count__41527_42351;
var G__42360 = (i__41528_42352 + (1));
seq__41525_42349 = G__42357;
chunk__41526_42350 = G__42358;
count__41527_42351 = G__42359;
i__41528_42352 = G__42360;
continue;
} else {
var temp__5735__auto___42361 = cljs.core.seq(seq__41525_42349);
if(temp__5735__auto___42361){
var seq__41525_42362__$1 = temp__5735__auto___42361;
if(cljs.core.chunked_seq_QMARK_(seq__41525_42362__$1)){
var c__4609__auto___42363 = cljs.core.chunk_first(seq__41525_42362__$1);
var G__42364 = cljs.core.chunk_rest(seq__41525_42362__$1);
var G__42365 = c__4609__auto___42363;
var G__42366 = cljs.core.count(c__4609__auto___42363);
var G__42367 = (0);
seq__41525_42349 = G__42364;
chunk__41526_42350 = G__42365;
count__41527_42351 = G__42366;
i__41528_42352 = G__42367;
continue;
} else {
var map__41535_42368 = cljs.core.first(seq__41525_42362__$1);
var map__41535_42369__$1 = (((((!((map__41535_42368 == null))))?(((((map__41535_42368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41535_42368.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41535_42368):map__41535_42368);
var binding_42370 = map__41535_42369__$1;
var init_42371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41535_42369__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_42370);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_42371,";");


var G__42372 = cljs.core.next(seq__41525_42362__$1);
var G__42373 = null;
var G__42374 = (0);
var G__42375 = (0);
seq__41525_42349 = G__42372;
chunk__41526_42350 = G__42373;
count__41527_42351 = G__42374;
i__41528_42352 = G__42375;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__41523_42347);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__41537){
var map__41538 = p__41537;
var map__41538__$1 = (((((!((map__41538 == null))))?(((((map__41538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41538):map__41538);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41538__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41538__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___42376 = cljs.core.count(exprs);
var i_42377 = (0);
while(true){
if((i_42377 < n__4666__auto___42376)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_42377) : temps.call(null,i_42377))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_42377) : exprs.call(null,i_42377)),";");

var G__42378 = (i_42377 + (1));
i_42377 = G__42378;
continue;
} else {
}
break;
}

var n__4666__auto___42379 = cljs.core.count(exprs);
var i_42380 = (0);
while(true){
if((i_42380 < n__4666__auto___42379)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_42380) : params.call(null,i_42380)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_42380) : temps.call(null,i_42380)),";");

var G__42381 = (i_42380 + (1));
i_42380 = G__42381;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__41540){
var map__41541 = p__41540;
var map__41541__$1 = (((((!((map__41541 == null))))?(((((map__41541.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41541.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41541):map__41541);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41541__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41541__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41541__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__41543_42382 = cljs.core.seq(bindings);
var chunk__41544_42383 = null;
var count__41545_42384 = (0);
var i__41546_42385 = (0);
while(true){
if((i__41546_42385 < count__41545_42384)){
var map__41554_42386 = chunk__41544_42383.cljs$core$IIndexed$_nth$arity$2(null,i__41546_42385);
var map__41554_42387__$1 = (((((!((map__41554_42386 == null))))?(((((map__41554_42386.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41554_42386.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41554_42386):map__41554_42386);
var binding_42388 = map__41554_42387__$1;
var init_42389 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41554_42387__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_42388)," = ",init_42389,";");


var G__42390 = seq__41543_42382;
var G__42391 = chunk__41544_42383;
var G__42392 = count__41545_42384;
var G__42393 = (i__41546_42385 + (1));
seq__41543_42382 = G__42390;
chunk__41544_42383 = G__42391;
count__41545_42384 = G__42392;
i__41546_42385 = G__42393;
continue;
} else {
var temp__5735__auto___42394 = cljs.core.seq(seq__41543_42382);
if(temp__5735__auto___42394){
var seq__41543_42395__$1 = temp__5735__auto___42394;
if(cljs.core.chunked_seq_QMARK_(seq__41543_42395__$1)){
var c__4609__auto___42396 = cljs.core.chunk_first(seq__41543_42395__$1);
var G__42397 = cljs.core.chunk_rest(seq__41543_42395__$1);
var G__42398 = c__4609__auto___42396;
var G__42399 = cljs.core.count(c__4609__auto___42396);
var G__42400 = (0);
seq__41543_42382 = G__42397;
chunk__41544_42383 = G__42398;
count__41545_42384 = G__42399;
i__41546_42385 = G__42400;
continue;
} else {
var map__41556_42401 = cljs.core.first(seq__41543_42395__$1);
var map__41556_42402__$1 = (((((!((map__41556_42401 == null))))?(((((map__41556_42401.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41556_42401.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41556_42401):map__41556_42401);
var binding_42403 = map__41556_42402__$1;
var init_42404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41556_42402__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_42403)," = ",init_42404,";");


var G__42412 = cljs.core.next(seq__41543_42395__$1);
var G__42413 = null;
var G__42414 = (0);
var G__42415 = (0);
seq__41543_42382 = G__42412;
chunk__41544_42383 = G__42413;
count__41545_42384 = G__42414;
i__41546_42385 = G__42415;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__41560){
var map__41561 = p__41560;
var map__41561__$1 = (((((!((map__41561 == null))))?(((((map__41561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41561.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41561):map__41561);
var expr = map__41561__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41561__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41561__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41561__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__41573 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__41573.cljs$core$IFn$_invoke$arity$1 ? fexpr__41573.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__41573.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__41575 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__41575.cljs$core$IFn$_invoke$arity$1 ? fexpr__41575.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__41575.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__41563 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__41558_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__41558_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__41559_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__41559_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41563,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41563,(1),null);
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_42420 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_42420,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_42421 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_42421,args)),(((mfa_42421 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_42421,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__41577 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__41576 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__41576.cljs$core$IFn$_invoke$arity$1 ? fexpr__41576.cljs$core$IFn$_invoke$arity$1(G__41577) : fexpr__41576.call(null,G__41577));
} else {
return and__4174__auto__;
}
})())){
var fprop_42424 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_42424," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_42424,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_42424," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_42424,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__41581){
var map__41582 = p__41581;
var map__41582__$1 = (((((!((map__41582 == null))))?(((((map__41582.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41582.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41582):map__41582);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41582__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41582__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41582__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__41584){
var map__41585 = p__41584;
var map__41585__$1 = (((((!((map__41585 == null))))?(((((map__41585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41585):map__41585);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41585__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41585__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41585__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__41587 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__41587__$1 = (((((!((map__41587 == null))))?(((((map__41587.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41587.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41587):map__41587);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41587__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41587__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__41588 = options;
var map__41588__$1 = (((((!((map__41588 == null))))?(((((map__41588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41588):map__41588);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41588__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41588__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__41589 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__41598 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__41598__$1 = (((((!((map__41598 == null))))?(((((map__41598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41598.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41598):map__41598);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41598__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41598__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41589,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41589,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__41600_42432 = cljs.core.seq(libs_to_load);
var chunk__41601_42433 = null;
var count__41602_42434 = (0);
var i__41603_42435 = (0);
while(true){
if((i__41603_42435 < count__41602_42434)){
var lib_42436 = chunk__41601_42433.cljs$core$IIndexed$_nth$arity$2(null,i__41603_42435);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_42436)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_42436),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_42436),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_42436),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_42436),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_42436,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_42436),"');");
}

}
}
}


var G__42437 = seq__41600_42432;
var G__42438 = chunk__41601_42433;
var G__42439 = count__41602_42434;
var G__42440 = (i__41603_42435 + (1));
seq__41600_42432 = G__42437;
chunk__41601_42433 = G__42438;
count__41602_42434 = G__42439;
i__41603_42435 = G__42440;
continue;
} else {
var temp__5735__auto___42441 = cljs.core.seq(seq__41600_42432);
if(temp__5735__auto___42441){
var seq__41600_42442__$1 = temp__5735__auto___42441;
if(cljs.core.chunked_seq_QMARK_(seq__41600_42442__$1)){
var c__4609__auto___42443 = cljs.core.chunk_first(seq__41600_42442__$1);
var G__42444 = cljs.core.chunk_rest(seq__41600_42442__$1);
var G__42445 = c__4609__auto___42443;
var G__42446 = cljs.core.count(c__4609__auto___42443);
var G__42447 = (0);
seq__41600_42432 = G__42444;
chunk__41601_42433 = G__42445;
count__41602_42434 = G__42446;
i__41603_42435 = G__42447;
continue;
} else {
var lib_42448 = cljs.core.first(seq__41600_42442__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_42448)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_42448),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_42448),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_42448),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_42448),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_42448,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_42448),"');");
}

}
}
}


var G__42449 = cljs.core.next(seq__41600_42442__$1);
var G__42450 = null;
var G__42451 = (0);
var G__42452 = (0);
seq__41600_42432 = G__42449;
chunk__41601_42433 = G__42450;
count__41602_42434 = G__42451;
i__41603_42435 = G__42452;
continue;
}
} else {
}
}
break;
}

var seq__41604_42453 = cljs.core.seq(node_libs);
var chunk__41605_42454 = null;
var count__41606_42455 = (0);
var i__41607_42456 = (0);
while(true){
if((i__41607_42456 < count__41606_42455)){
var lib_42457 = chunk__41605_42454.cljs$core$IIndexed$_nth$arity$2(null,i__41607_42456);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_42457)," = require('",lib_42457,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__42458 = seq__41604_42453;
var G__42459 = chunk__41605_42454;
var G__42460 = count__41606_42455;
var G__42461 = (i__41607_42456 + (1));
seq__41604_42453 = G__42458;
chunk__41605_42454 = G__42459;
count__41606_42455 = G__42460;
i__41607_42456 = G__42461;
continue;
} else {
var temp__5735__auto___42462 = cljs.core.seq(seq__41604_42453);
if(temp__5735__auto___42462){
var seq__41604_42463__$1 = temp__5735__auto___42462;
if(cljs.core.chunked_seq_QMARK_(seq__41604_42463__$1)){
var c__4609__auto___42464 = cljs.core.chunk_first(seq__41604_42463__$1);
var G__42465 = cljs.core.chunk_rest(seq__41604_42463__$1);
var G__42466 = c__4609__auto___42464;
var G__42467 = cljs.core.count(c__4609__auto___42464);
var G__42468 = (0);
seq__41604_42453 = G__42465;
chunk__41605_42454 = G__42466;
count__41606_42455 = G__42467;
i__41607_42456 = G__42468;
continue;
} else {
var lib_42469 = cljs.core.first(seq__41604_42463__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_42469)," = require('",lib_42469,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__42470 = cljs.core.next(seq__41604_42463__$1);
var G__42471 = null;
var G__42472 = (0);
var G__42473 = (0);
seq__41604_42453 = G__42470;
chunk__41605_42454 = G__42471;
count__41606_42455 = G__42472;
i__41607_42456 = G__42473;
continue;
}
} else {
}
}
break;
}

var seq__41608_42474 = cljs.core.seq(global_exports_libs);
var chunk__41609_42475 = null;
var count__41610_42476 = (0);
var i__41611_42477 = (0);
while(true){
if((i__41611_42477 < count__41610_42476)){
var lib_42478 = chunk__41609_42475.cljs$core$IIndexed$_nth$arity$2(null,i__41611_42477);
var map__41616_42479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_42478));
var map__41616_42480__$1 = (((((!((map__41616_42479 == null))))?(((((map__41616_42479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41616_42479.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41616_42479):map__41616_42479);
var global_exports_42481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41616_42480__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_42481,lib_42478);


var G__42482 = seq__41608_42474;
var G__42483 = chunk__41609_42475;
var G__42484 = count__41610_42476;
var G__42485 = (i__41611_42477 + (1));
seq__41608_42474 = G__42482;
chunk__41609_42475 = G__42483;
count__41610_42476 = G__42484;
i__41611_42477 = G__42485;
continue;
} else {
var temp__5735__auto___42486 = cljs.core.seq(seq__41608_42474);
if(temp__5735__auto___42486){
var seq__41608_42487__$1 = temp__5735__auto___42486;
if(cljs.core.chunked_seq_QMARK_(seq__41608_42487__$1)){
var c__4609__auto___42488 = cljs.core.chunk_first(seq__41608_42487__$1);
var G__42489 = cljs.core.chunk_rest(seq__41608_42487__$1);
var G__42490 = c__4609__auto___42488;
var G__42491 = cljs.core.count(c__4609__auto___42488);
var G__42492 = (0);
seq__41608_42474 = G__42489;
chunk__41609_42475 = G__42490;
count__41610_42476 = G__42491;
i__41611_42477 = G__42492;
continue;
} else {
var lib_42493 = cljs.core.first(seq__41608_42487__$1);
var map__41618_42494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_42493));
var map__41618_42495__$1 = (((((!((map__41618_42494 == null))))?(((((map__41618_42494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41618_42494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41618_42494):map__41618_42494);
var global_exports_42496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41618_42495__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_42496,lib_42493);


var G__42497 = cljs.core.next(seq__41608_42487__$1);
var G__42498 = null;
var G__42499 = (0);
var G__42500 = (0);
seq__41608_42474 = G__42497;
chunk__41609_42475 = G__42498;
count__41610_42476 = G__42499;
i__41611_42477 = G__42500;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__41620){
var map__41621 = p__41620;
var map__41621__$1 = (((((!((map__41621 == null))))?(((((map__41621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41621):map__41621);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41621__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__41623){
var map__41624 = p__41623;
var map__41624__$1 = (((((!((map__41624 == null))))?(((((map__41624.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41624.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41624):map__41624);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41624__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__41627){
var map__41628 = p__41627;
var map__41628__$1 = (((((!((map__41628 == null))))?(((((map__41628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41628):map__41628);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41628__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41628__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41628__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41628__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41628__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__41634_42501 = cljs.core.seq(protocols);
var chunk__41635_42502 = null;
var count__41636_42503 = (0);
var i__41637_42504 = (0);
while(true){
if((i__41637_42504 < count__41636_42503)){
var protocol_42505 = chunk__41635_42502.cljs$core$IIndexed$_nth$arity$2(null,i__41637_42504);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_42505)),"}");


var G__42506 = seq__41634_42501;
var G__42507 = chunk__41635_42502;
var G__42508 = count__41636_42503;
var G__42509 = (i__41637_42504 + (1));
seq__41634_42501 = G__42506;
chunk__41635_42502 = G__42507;
count__41636_42503 = G__42508;
i__41637_42504 = G__42509;
continue;
} else {
var temp__5735__auto___42510 = cljs.core.seq(seq__41634_42501);
if(temp__5735__auto___42510){
var seq__41634_42511__$1 = temp__5735__auto___42510;
if(cljs.core.chunked_seq_QMARK_(seq__41634_42511__$1)){
var c__4609__auto___42512 = cljs.core.chunk_first(seq__41634_42511__$1);
var G__42513 = cljs.core.chunk_rest(seq__41634_42511__$1);
var G__42514 = c__4609__auto___42512;
var G__42515 = cljs.core.count(c__4609__auto___42512);
var G__42516 = (0);
seq__41634_42501 = G__42513;
chunk__41635_42502 = G__42514;
count__41636_42503 = G__42515;
i__41637_42504 = G__42516;
continue;
} else {
var protocol_42517 = cljs.core.first(seq__41634_42511__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_42517)),"}");


var G__42518 = cljs.core.next(seq__41634_42511__$1);
var G__42519 = null;
var G__42520 = (0);
var G__42521 = (0);
seq__41634_42501 = G__42518;
chunk__41635_42502 = G__42519;
count__41636_42503 = G__42520;
i__41637_42504 = G__42521;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__41638_42522 = cljs.core.seq(fields__$1);
var chunk__41639_42523 = null;
var count__41640_42524 = (0);
var i__41641_42525 = (0);
while(true){
if((i__41641_42525 < count__41640_42524)){
var fld_42526 = chunk__41639_42523.cljs$core$IIndexed$_nth$arity$2(null,i__41641_42525);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_42526," = ",fld_42526,";");


var G__42527 = seq__41638_42522;
var G__42528 = chunk__41639_42523;
var G__42529 = count__41640_42524;
var G__42530 = (i__41641_42525 + (1));
seq__41638_42522 = G__42527;
chunk__41639_42523 = G__42528;
count__41640_42524 = G__42529;
i__41641_42525 = G__42530;
continue;
} else {
var temp__5735__auto___42531 = cljs.core.seq(seq__41638_42522);
if(temp__5735__auto___42531){
var seq__41638_42532__$1 = temp__5735__auto___42531;
if(cljs.core.chunked_seq_QMARK_(seq__41638_42532__$1)){
var c__4609__auto___42533 = cljs.core.chunk_first(seq__41638_42532__$1);
var G__42534 = cljs.core.chunk_rest(seq__41638_42532__$1);
var G__42535 = c__4609__auto___42533;
var G__42536 = cljs.core.count(c__4609__auto___42533);
var G__42537 = (0);
seq__41638_42522 = G__42534;
chunk__41639_42523 = G__42535;
count__41640_42524 = G__42536;
i__41641_42525 = G__42537;
continue;
} else {
var fld_42538 = cljs.core.first(seq__41638_42532__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_42538," = ",fld_42538,";");


var G__42539 = cljs.core.next(seq__41638_42532__$1);
var G__42540 = null;
var G__42541 = (0);
var G__42542 = (0);
seq__41638_42522 = G__42539;
chunk__41639_42523 = G__42540;
count__41640_42524 = G__42541;
i__41641_42525 = G__42542;
continue;
}
} else {
}
}
break;
}

var seq__41643_42543 = cljs.core.seq(pmasks);
var chunk__41644_42544 = null;
var count__41645_42545 = (0);
var i__41646_42546 = (0);
while(true){
if((i__41646_42546 < count__41645_42545)){
var vec__41653_42547 = chunk__41644_42544.cljs$core$IIndexed$_nth$arity$2(null,i__41646_42546);
var pno_42548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41653_42547,(0),null);
var pmask_42549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41653_42547,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_42548,"$ = ",pmask_42549,";");


var G__42550 = seq__41643_42543;
var G__42551 = chunk__41644_42544;
var G__42552 = count__41645_42545;
var G__42553 = (i__41646_42546 + (1));
seq__41643_42543 = G__42550;
chunk__41644_42544 = G__42551;
count__41645_42545 = G__42552;
i__41646_42546 = G__42553;
continue;
} else {
var temp__5735__auto___42554 = cljs.core.seq(seq__41643_42543);
if(temp__5735__auto___42554){
var seq__41643_42555__$1 = temp__5735__auto___42554;
if(cljs.core.chunked_seq_QMARK_(seq__41643_42555__$1)){
var c__4609__auto___42556 = cljs.core.chunk_first(seq__41643_42555__$1);
var G__42557 = cljs.core.chunk_rest(seq__41643_42555__$1);
var G__42558 = c__4609__auto___42556;
var G__42559 = cljs.core.count(c__4609__auto___42556);
var G__42560 = (0);
seq__41643_42543 = G__42557;
chunk__41644_42544 = G__42558;
count__41645_42545 = G__42559;
i__41646_42546 = G__42560;
continue;
} else {
var vec__41656_42561 = cljs.core.first(seq__41643_42555__$1);
var pno_42562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41656_42561,(0),null);
var pmask_42563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41656_42561,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_42562,"$ = ",pmask_42563,";");


var G__42564 = cljs.core.next(seq__41643_42555__$1);
var G__42565 = null;
var G__42566 = (0);
var G__42567 = (0);
seq__41643_42543 = G__42564;
chunk__41644_42544 = G__42565;
count__41645_42545 = G__42566;
i__41646_42546 = G__42567;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__41660){
var map__41661 = p__41660;
var map__41661__$1 = (((((!((map__41661 == null))))?(((((map__41661.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41661.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41661):map__41661);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41661__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41661__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41661__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41661__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41661__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__41671_42568 = cljs.core.seq(protocols);
var chunk__41672_42569 = null;
var count__41673_42570 = (0);
var i__41674_42571 = (0);
while(true){
if((i__41674_42571 < count__41673_42570)){
var protocol_42572 = chunk__41672_42569.cljs$core$IIndexed$_nth$arity$2(null,i__41674_42571);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_42572)),"}");


var G__42573 = seq__41671_42568;
var G__42574 = chunk__41672_42569;
var G__42575 = count__41673_42570;
var G__42576 = (i__41674_42571 + (1));
seq__41671_42568 = G__42573;
chunk__41672_42569 = G__42574;
count__41673_42570 = G__42575;
i__41674_42571 = G__42576;
continue;
} else {
var temp__5735__auto___42577 = cljs.core.seq(seq__41671_42568);
if(temp__5735__auto___42577){
var seq__41671_42578__$1 = temp__5735__auto___42577;
if(cljs.core.chunked_seq_QMARK_(seq__41671_42578__$1)){
var c__4609__auto___42579 = cljs.core.chunk_first(seq__41671_42578__$1);
var G__42580 = cljs.core.chunk_rest(seq__41671_42578__$1);
var G__42581 = c__4609__auto___42579;
var G__42582 = cljs.core.count(c__4609__auto___42579);
var G__42583 = (0);
seq__41671_42568 = G__42580;
chunk__41672_42569 = G__42581;
count__41673_42570 = G__42582;
i__41674_42571 = G__42583;
continue;
} else {
var protocol_42584 = cljs.core.first(seq__41671_42578__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_42584)),"}");


var G__42585 = cljs.core.next(seq__41671_42578__$1);
var G__42586 = null;
var G__42587 = (0);
var G__42588 = (0);
seq__41671_42568 = G__42585;
chunk__41672_42569 = G__42586;
count__41673_42570 = G__42587;
i__41674_42571 = G__42588;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__41680_42589 = cljs.core.seq(fields__$1);
var chunk__41681_42590 = null;
var count__41682_42591 = (0);
var i__41683_42592 = (0);
while(true){
if((i__41683_42592 < count__41682_42591)){
var fld_42593 = chunk__41681_42590.cljs$core$IIndexed$_nth$arity$2(null,i__41683_42592);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_42593," = ",fld_42593,";");


var G__42594 = seq__41680_42589;
var G__42595 = chunk__41681_42590;
var G__42596 = count__41682_42591;
var G__42597 = (i__41683_42592 + (1));
seq__41680_42589 = G__42594;
chunk__41681_42590 = G__42595;
count__41682_42591 = G__42596;
i__41683_42592 = G__42597;
continue;
} else {
var temp__5735__auto___42598 = cljs.core.seq(seq__41680_42589);
if(temp__5735__auto___42598){
var seq__41680_42599__$1 = temp__5735__auto___42598;
if(cljs.core.chunked_seq_QMARK_(seq__41680_42599__$1)){
var c__4609__auto___42600 = cljs.core.chunk_first(seq__41680_42599__$1);
var G__42601 = cljs.core.chunk_rest(seq__41680_42599__$1);
var G__42602 = c__4609__auto___42600;
var G__42603 = cljs.core.count(c__4609__auto___42600);
var G__42604 = (0);
seq__41680_42589 = G__42601;
chunk__41681_42590 = G__42602;
count__41682_42591 = G__42603;
i__41683_42592 = G__42604;
continue;
} else {
var fld_42605 = cljs.core.first(seq__41680_42599__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_42605," = ",fld_42605,";");


var G__42606 = cljs.core.next(seq__41680_42599__$1);
var G__42607 = null;
var G__42608 = (0);
var G__42609 = (0);
seq__41680_42589 = G__42606;
chunk__41681_42590 = G__42607;
count__41682_42591 = G__42608;
i__41683_42592 = G__42609;
continue;
}
} else {
}
}
break;
}

var seq__41684_42610 = cljs.core.seq(pmasks);
var chunk__41685_42611 = null;
var count__41686_42612 = (0);
var i__41687_42613 = (0);
while(true){
if((i__41687_42613 < count__41686_42612)){
var vec__41694_42614 = chunk__41685_42611.cljs$core$IIndexed$_nth$arity$2(null,i__41687_42613);
var pno_42615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41694_42614,(0),null);
var pmask_42616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41694_42614,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_42615,"$ = ",pmask_42616,";");


var G__42617 = seq__41684_42610;
var G__42618 = chunk__41685_42611;
var G__42619 = count__41686_42612;
var G__42620 = (i__41687_42613 + (1));
seq__41684_42610 = G__42617;
chunk__41685_42611 = G__42618;
count__41686_42612 = G__42619;
i__41687_42613 = G__42620;
continue;
} else {
var temp__5735__auto___42621 = cljs.core.seq(seq__41684_42610);
if(temp__5735__auto___42621){
var seq__41684_42622__$1 = temp__5735__auto___42621;
if(cljs.core.chunked_seq_QMARK_(seq__41684_42622__$1)){
var c__4609__auto___42623 = cljs.core.chunk_first(seq__41684_42622__$1);
var G__42624 = cljs.core.chunk_rest(seq__41684_42622__$1);
var G__42625 = c__4609__auto___42623;
var G__42626 = cljs.core.count(c__4609__auto___42623);
var G__42627 = (0);
seq__41684_42610 = G__42624;
chunk__41685_42611 = G__42625;
count__41686_42612 = G__42626;
i__41687_42613 = G__42627;
continue;
} else {
var vec__41697_42628 = cljs.core.first(seq__41684_42622__$1);
var pno_42629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41697_42628,(0),null);
var pmask_42630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41697_42628,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_42629,"$ = ",pmask_42630,";");


var G__42631 = cljs.core.next(seq__41684_42622__$1);
var G__42632 = null;
var G__42633 = (0);
var G__42634 = (0);
seq__41684_42610 = G__42631;
chunk__41685_42611 = G__42632;
count__41686_42612 = G__42633;
i__41687_42613 = G__42634;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__41700){
var map__41701 = p__41700;
var map__41701__$1 = (((((!((map__41701 == null))))?(((((map__41701.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41701.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41701):map__41701);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41701__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41701__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41701__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41701__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41701__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__41711){
var map__41712 = p__41711;
var map__41712__$1 = (((((!((map__41712 == null))))?(((((map__41712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41712):map__41712);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41712__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41712__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41712__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41712__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41712__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__41719 = clojure.string.trim(code);
var G__41720 = "/*";
return goog.string.startsWith(G__41719,G__41720);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__41045__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__41045__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__41750 = cljs.core.seq(table);
var chunk__41751 = null;
var count__41752 = (0);
var i__41753 = (0);
while(true){
if((i__41753 < count__41752)){
var vec__41760 = chunk__41751.cljs$core$IIndexed$_nth$arity$2(null,i__41753);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41760,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41760,(1),null);
var ns_42635 = cljs.core.namespace(sym);
var name_42636 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__42637 = seq__41750;
var G__42638 = chunk__41751;
var G__42639 = count__41752;
var G__42640 = (i__41753 + (1));
seq__41750 = G__42637;
chunk__41751 = G__42638;
count__41752 = G__42639;
i__41753 = G__42640;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__41750);
if(temp__5735__auto__){
var seq__41750__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41750__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__41750__$1);
var G__42641 = cljs.core.chunk_rest(seq__41750__$1);
var G__42642 = c__4609__auto__;
var G__42643 = cljs.core.count(c__4609__auto__);
var G__42644 = (0);
seq__41750 = G__42641;
chunk__41751 = G__42642;
count__41752 = G__42643;
i__41753 = G__42644;
continue;
} else {
var vec__41763 = cljs.core.first(seq__41750__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41763,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41763,(1),null);
var ns_42645 = cljs.core.namespace(sym);
var name_42646 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__42647 = cljs.core.next(seq__41750__$1);
var G__42648 = null;
var G__42649 = (0);
var G__42650 = (0);
seq__41750 = G__42647;
chunk__41751 = G__42648;
count__41752 = G__42649;
i__41753 = G__42650;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__41767 = arguments.length;
switch (G__41767) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_42652 = cljs.core.first(ks);
var vec__41777_42653 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_42652);
var top_42654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41777_42653,(0),null);
var prefix_SINGLEQUOTE__42655 = vec__41777_42653;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_42652)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__42655) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_42654)) || (cljs.core.contains_QMARK_(known_externs,top_42654)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__42655)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_42654);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__42655)),";");
}
} else {
}

var m_42656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_42652);
if(cljs.core.empty_QMARK_(m_42656)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__42655,m_42656,top_level,known_externs);
}

var G__42657 = cljs.core.next(ks);
ks = G__42657;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
