goog.provide('cljs_await.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
cljs.core.enable_console_print_BANG_();
cljs_await.core.set_timeout = setTimeout;
cljs_await.core.clear_timeout = clearTimeout;
/**
 * works with JS promises
 * 
 *   returns [err res]
 * 
 *   where err - a catched exception (reject)
 *   res - the result of the promise work (resolve)
 * 
 *   (go
 *  (let [[err res] (<! (await my-promise))]
 *    (println res)))
 *   
 */
cljs_await.core.await$ = (function cljs_await$core$await(promise){
var port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
promise.then((function (res){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,res], null));
}),(function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [err,null], null));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [err,null], null));
}));

return port;
});
/**
 * works with functions, the last argument is the function callback
 * 
 *   returns [err res]
 * 
 *   err - an exception (if it happens)
 *   res - the result of the work of the callback function (nil - if there was an exception)
 * 
 *   (go
 *  (let [[err res] (<! (await-cb my-callback))]
 *    (println res)))
 *   
 */
cljs_await.core.await_cb = (function cljs_await$core$await_cb(var_args){
var args__4795__auto__ = [];
var len__4789__auto___43828 = arguments.length;
var i__4790__auto___43829 = (0);
while(true){
if((i__4790__auto___43829 < len__4789__auto___43828)){
args__4795__auto__.push((arguments[i__4790__auto___43829]));

var G__43830 = (i__4790__auto___43829 + (1));
i__4790__auto___43829 = G__43830;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs_await.core.await_cb.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs_await.core.await_cb.cljs$core$IFn$_invoke$arity$variadic = (function (fnc,args){
var port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
try{cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fnc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (a){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,a], null));
})], null)));
}catch (e43824){if((e43824 instanceof Error)){
var e_43832 = e43824;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e_43832,null], null));
} else {
throw e43824;

}
}
return port;
}));

(cljs_await.core.await_cb.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs_await.core.await_cb.cljs$lang$applyTo = (function (seq43821){
var G__43822 = cljs.core.first(seq43821);
var seq43821__$1 = cljs.core.next(seq43821);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43822,seq43821__$1);
}));


//# sourceMappingURL=cljs_await.core.js.map
