goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44569){
var vec__44570 = p__44569;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44570,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44570,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44578 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44587 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44587,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44587,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44587,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44587,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44587,(4),null);
var vec__44590 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44595 = segmap;
var map__44595__$1 = (((((!((map__44595 == null))))?(((((map__44595.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44595.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44595):map__44595);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44595__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44595__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44595__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44595__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44595__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44602 = arguments.length;
switch (G__44602) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44623 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45692 = cljs.core.next(segs__$1);
var G__45693 = nrelseg;
var G__45694 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45692;
relseg__$1 = G__45693;
result__$1 = G__45694;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(1),null);
var G__45695 = (gline + (1));
var G__45696 = cljs.core.next(lines__$1);
var G__45697 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45698 = result__$1;
gline = G__45695;
lines__$1 = G__45696;
relseg = G__45697;
result = G__45698;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44634 = segmap;
var map__44634__$1 = (((((!((map__44634 == null))))?(((((map__44634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44634.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44634):map__44634);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44634__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44634__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44634__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44634__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44634__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44628_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44628_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44644 = arguments.length;
switch (G__44644) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44658 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45720 = cljs.core.next(segs__$1);
var G__45721 = nrelseg;
var G__45722 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45720;
relseg__$1 = G__45721;
result__$1 = G__45722;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44658,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44658,(1),null);
var G__45723 = (gline + (1));
var G__45724 = cljs.core.next(lines__$1);
var G__45725 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45726 = result__$1;
gline = G__45723;
lines__$1 = G__45724;
relseg = G__45725;
result = G__45726;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44663){
var vec__44664 = p__44663;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44668){
var vec__44669 = p__44668;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44669,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44669,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44669,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44669,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44669,(4),null);
var seg = vec__44669;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44677){
var vec__44680 = p__44677;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44695 = cljs.core.seq(infos);
var chunk__44696 = null;
var count__44697 = (0);
var i__44698 = (0);
while(true){
if((i__44698 < count__44697)){
var info = chunk__44696.cljs$core$IIndexed$_nth$arity$2(null,i__44698);
var segv_45739 = info__GT_segv(info,source_idx,line,col);
var gline_45740 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45741 = cljs.core.count(cljs.core.deref(lines));
if((gline_45740 > (lc_45741 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44695,chunk__44696,count__44697,i__44698,segv_45739,gline_45740,lc_45741,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45740 - (lc_45741 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45739], null));
});})(seq__44695,chunk__44696,count__44697,i__44698,segv_45739,gline_45740,lc_45741,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44695,chunk__44696,count__44697,i__44698,segv_45739,gline_45740,lc_45741,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45740], null),cljs.core.conj,segv_45739);
});})(seq__44695,chunk__44696,count__44697,i__44698,segv_45739,gline_45740,lc_45741,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45743 = seq__44695;
var G__45744 = chunk__44696;
var G__45745 = count__44697;
var G__45746 = (i__44698 + (1));
seq__44695 = G__45743;
chunk__44696 = G__45744;
count__44697 = G__45745;
i__44698 = G__45746;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44695);
if(temp__5735__auto__){
var seq__44695__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44695__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44695__$1);
var G__45753 = cljs.core.chunk_rest(seq__44695__$1);
var G__45754 = c__4609__auto__;
var G__45755 = cljs.core.count(c__4609__auto__);
var G__45756 = (0);
seq__44695 = G__45753;
chunk__44696 = G__45754;
count__44697 = G__45755;
i__44698 = G__45756;
continue;
} else {
var info = cljs.core.first(seq__44695__$1);
var segv_45759 = info__GT_segv(info,source_idx,line,col);
var gline_45760 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45761 = cljs.core.count(cljs.core.deref(lines));
if((gline_45760 > (lc_45761 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44695,chunk__44696,count__44697,i__44698,segv_45759,gline_45760,lc_45761,info,seq__44695__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45760 - (lc_45761 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45759], null));
});})(seq__44695,chunk__44696,count__44697,i__44698,segv_45759,gline_45760,lc_45761,info,seq__44695__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44695,chunk__44696,count__44697,i__44698,segv_45759,gline_45760,lc_45761,info,seq__44695__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45760], null),cljs.core.conj,segv_45759);
});})(seq__44695,chunk__44696,count__44697,i__44698,segv_45759,gline_45760,lc_45761,info,seq__44695__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45762 = cljs.core.next(seq__44695__$1);
var G__45763 = null;
var G__45764 = (0);
var G__45765 = (0);
seq__44695 = G__45762;
chunk__44696 = G__45763;
count__44697 = G__45764;
i__44698 = G__45765;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44716_45766 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44717_45767 = null;
var count__44718_45768 = (0);
var i__44719_45769 = (0);
while(true){
if((i__44719_45769 < count__44718_45768)){
var vec__44935_45772 = chunk__44717_45767.cljs$core$IIndexed$_nth$arity$2(null,i__44719_45769);
var source_idx_45773 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44935_45772,(0),null);
var vec__44938_45774 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44935_45772,(1),null);
var __45775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44938_45774,(0),null);
var lines_45776__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44938_45774,(1),null);
var seq__44941_45777 = cljs.core.seq(lines_45776__$1);
var chunk__44942_45778 = null;
var count__44943_45779 = (0);
var i__44944_45780 = (0);
while(true){
if((i__44944_45780 < count__44943_45779)){
var vec__44985_45781 = chunk__44942_45778.cljs$core$IIndexed$_nth$arity$2(null,i__44944_45780);
var line_45782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44985_45781,(0),null);
var cols_45783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44985_45781,(1),null);
var seq__44988_45785 = cljs.core.seq(cols_45783);
var chunk__44989_45786 = null;
var count__44990_45787 = (0);
var i__44991_45788 = (0);
while(true){
if((i__44991_45788 < count__44990_45787)){
var vec__45000_45789 = chunk__44989_45786.cljs$core$IIndexed$_nth$arity$2(null,i__44991_45788);
var col_45790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45000_45789,(0),null);
var infos_45791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45000_45789,(1),null);
encode_cols(infos_45791,source_idx_45773,line_45782,col_45790);


var G__45792 = seq__44988_45785;
var G__45793 = chunk__44989_45786;
var G__45794 = count__44990_45787;
var G__45795 = (i__44991_45788 + (1));
seq__44988_45785 = G__45792;
chunk__44989_45786 = G__45793;
count__44990_45787 = G__45794;
i__44991_45788 = G__45795;
continue;
} else {
var temp__5735__auto___45796 = cljs.core.seq(seq__44988_45785);
if(temp__5735__auto___45796){
var seq__44988_45797__$1 = temp__5735__auto___45796;
if(cljs.core.chunked_seq_QMARK_(seq__44988_45797__$1)){
var c__4609__auto___45798 = cljs.core.chunk_first(seq__44988_45797__$1);
var G__45799 = cljs.core.chunk_rest(seq__44988_45797__$1);
var G__45800 = c__4609__auto___45798;
var G__45801 = cljs.core.count(c__4609__auto___45798);
var G__45802 = (0);
seq__44988_45785 = G__45799;
chunk__44989_45786 = G__45800;
count__44990_45787 = G__45801;
i__44991_45788 = G__45802;
continue;
} else {
var vec__45003_45803 = cljs.core.first(seq__44988_45797__$1);
var col_45804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45003_45803,(0),null);
var infos_45805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45003_45803,(1),null);
encode_cols(infos_45805,source_idx_45773,line_45782,col_45804);


var G__45806 = cljs.core.next(seq__44988_45797__$1);
var G__45807 = null;
var G__45808 = (0);
var G__45809 = (0);
seq__44988_45785 = G__45806;
chunk__44989_45786 = G__45807;
count__44990_45787 = G__45808;
i__44991_45788 = G__45809;
continue;
}
} else {
}
}
break;
}


var G__45810 = seq__44941_45777;
var G__45811 = chunk__44942_45778;
var G__45812 = count__44943_45779;
var G__45813 = (i__44944_45780 + (1));
seq__44941_45777 = G__45810;
chunk__44942_45778 = G__45811;
count__44943_45779 = G__45812;
i__44944_45780 = G__45813;
continue;
} else {
var temp__5735__auto___45814 = cljs.core.seq(seq__44941_45777);
if(temp__5735__auto___45814){
var seq__44941_45815__$1 = temp__5735__auto___45814;
if(cljs.core.chunked_seq_QMARK_(seq__44941_45815__$1)){
var c__4609__auto___45816 = cljs.core.chunk_first(seq__44941_45815__$1);
var G__45817 = cljs.core.chunk_rest(seq__44941_45815__$1);
var G__45818 = c__4609__auto___45816;
var G__45819 = cljs.core.count(c__4609__auto___45816);
var G__45820 = (0);
seq__44941_45777 = G__45817;
chunk__44942_45778 = G__45818;
count__44943_45779 = G__45819;
i__44944_45780 = G__45820;
continue;
} else {
var vec__45011_45821 = cljs.core.first(seq__44941_45815__$1);
var line_45822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45011_45821,(0),null);
var cols_45823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45011_45821,(1),null);
var seq__45014_45824 = cljs.core.seq(cols_45823);
var chunk__45015_45825 = null;
var count__45016_45826 = (0);
var i__45017_45827 = (0);
while(true){
if((i__45017_45827 < count__45016_45826)){
var vec__45026_45828 = chunk__45015_45825.cljs$core$IIndexed$_nth$arity$2(null,i__45017_45827);
var col_45829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45026_45828,(0),null);
var infos_45830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45026_45828,(1),null);
encode_cols(infos_45830,source_idx_45773,line_45822,col_45829);


var G__45831 = seq__45014_45824;
var G__45832 = chunk__45015_45825;
var G__45833 = count__45016_45826;
var G__45834 = (i__45017_45827 + (1));
seq__45014_45824 = G__45831;
chunk__45015_45825 = G__45832;
count__45016_45826 = G__45833;
i__45017_45827 = G__45834;
continue;
} else {
var temp__5735__auto___45835__$1 = cljs.core.seq(seq__45014_45824);
if(temp__5735__auto___45835__$1){
var seq__45014_45836__$1 = temp__5735__auto___45835__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45014_45836__$1)){
var c__4609__auto___45837 = cljs.core.chunk_first(seq__45014_45836__$1);
var G__45839 = cljs.core.chunk_rest(seq__45014_45836__$1);
var G__45840 = c__4609__auto___45837;
var G__45841 = cljs.core.count(c__4609__auto___45837);
var G__45842 = (0);
seq__45014_45824 = G__45839;
chunk__45015_45825 = G__45840;
count__45016_45826 = G__45841;
i__45017_45827 = G__45842;
continue;
} else {
var vec__45030_45846 = cljs.core.first(seq__45014_45836__$1);
var col_45847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45030_45846,(0),null);
var infos_45848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45030_45846,(1),null);
encode_cols(infos_45848,source_idx_45773,line_45822,col_45847);


var G__45850 = cljs.core.next(seq__45014_45836__$1);
var G__45851 = null;
var G__45852 = (0);
var G__45853 = (0);
seq__45014_45824 = G__45850;
chunk__45015_45825 = G__45851;
count__45016_45826 = G__45852;
i__45017_45827 = G__45853;
continue;
}
} else {
}
}
break;
}


var G__45855 = cljs.core.next(seq__44941_45815__$1);
var G__45856 = null;
var G__45857 = (0);
var G__45858 = (0);
seq__44941_45777 = G__45855;
chunk__44942_45778 = G__45856;
count__44943_45779 = G__45857;
i__44944_45780 = G__45858;
continue;
}
} else {
}
}
break;
}


var G__45859 = seq__44716_45766;
var G__45860 = chunk__44717_45767;
var G__45861 = count__44718_45768;
var G__45862 = (i__44719_45769 + (1));
seq__44716_45766 = G__45859;
chunk__44717_45767 = G__45860;
count__44718_45768 = G__45861;
i__44719_45769 = G__45862;
continue;
} else {
var temp__5735__auto___45863 = cljs.core.seq(seq__44716_45766);
if(temp__5735__auto___45863){
var seq__44716_45864__$1 = temp__5735__auto___45863;
if(cljs.core.chunked_seq_QMARK_(seq__44716_45864__$1)){
var c__4609__auto___45865 = cljs.core.chunk_first(seq__44716_45864__$1);
var G__45866 = cljs.core.chunk_rest(seq__44716_45864__$1);
var G__45867 = c__4609__auto___45865;
var G__45868 = cljs.core.count(c__4609__auto___45865);
var G__45869 = (0);
seq__44716_45766 = G__45866;
chunk__44717_45767 = G__45867;
count__44718_45768 = G__45868;
i__44719_45769 = G__45869;
continue;
} else {
var vec__45033_45870 = cljs.core.first(seq__44716_45864__$1);
var source_idx_45871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45033_45870,(0),null);
var vec__45036_45872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45033_45870,(1),null);
var __45873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45036_45872,(0),null);
var lines_45874__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45036_45872,(1),null);
var seq__45041_45875 = cljs.core.seq(lines_45874__$1);
var chunk__45042_45876 = null;
var count__45043_45877 = (0);
var i__45044_45878 = (0);
while(true){
if((i__45044_45878 < count__45043_45877)){
var vec__45091_45879 = chunk__45042_45876.cljs$core$IIndexed$_nth$arity$2(null,i__45044_45878);
var line_45880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45091_45879,(0),null);
var cols_45881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45091_45879,(1),null);
var seq__45096_45882 = cljs.core.seq(cols_45881);
var chunk__45097_45883 = null;
var count__45098_45884 = (0);
var i__45099_45885 = (0);
while(true){
if((i__45099_45885 < count__45098_45884)){
var vec__45106_45886 = chunk__45097_45883.cljs$core$IIndexed$_nth$arity$2(null,i__45099_45885);
var col_45887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45106_45886,(0),null);
var infos_45888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45106_45886,(1),null);
encode_cols(infos_45888,source_idx_45871,line_45880,col_45887);


var G__45891 = seq__45096_45882;
var G__45892 = chunk__45097_45883;
var G__45893 = count__45098_45884;
var G__45894 = (i__45099_45885 + (1));
seq__45096_45882 = G__45891;
chunk__45097_45883 = G__45892;
count__45098_45884 = G__45893;
i__45099_45885 = G__45894;
continue;
} else {
var temp__5735__auto___45895__$1 = cljs.core.seq(seq__45096_45882);
if(temp__5735__auto___45895__$1){
var seq__45096_45896__$1 = temp__5735__auto___45895__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45096_45896__$1)){
var c__4609__auto___45897 = cljs.core.chunk_first(seq__45096_45896__$1);
var G__45898 = cljs.core.chunk_rest(seq__45096_45896__$1);
var G__45899 = c__4609__auto___45897;
var G__45900 = cljs.core.count(c__4609__auto___45897);
var G__45901 = (0);
seq__45096_45882 = G__45898;
chunk__45097_45883 = G__45899;
count__45098_45884 = G__45900;
i__45099_45885 = G__45901;
continue;
} else {
var vec__45111_45906 = cljs.core.first(seq__45096_45896__$1);
var col_45907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45111_45906,(0),null);
var infos_45908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45111_45906,(1),null);
encode_cols(infos_45908,source_idx_45871,line_45880,col_45907);


var G__45909 = cljs.core.next(seq__45096_45896__$1);
var G__45910 = null;
var G__45911 = (0);
var G__45912 = (0);
seq__45096_45882 = G__45909;
chunk__45097_45883 = G__45910;
count__45098_45884 = G__45911;
i__45099_45885 = G__45912;
continue;
}
} else {
}
}
break;
}


var G__45913 = seq__45041_45875;
var G__45914 = chunk__45042_45876;
var G__45915 = count__45043_45877;
var G__45916 = (i__45044_45878 + (1));
seq__45041_45875 = G__45913;
chunk__45042_45876 = G__45914;
count__45043_45877 = G__45915;
i__45044_45878 = G__45916;
continue;
} else {
var temp__5735__auto___45917__$1 = cljs.core.seq(seq__45041_45875);
if(temp__5735__auto___45917__$1){
var seq__45041_45918__$1 = temp__5735__auto___45917__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45041_45918__$1)){
var c__4609__auto___45919 = cljs.core.chunk_first(seq__45041_45918__$1);
var G__45920 = cljs.core.chunk_rest(seq__45041_45918__$1);
var G__45921 = c__4609__auto___45919;
var G__45922 = cljs.core.count(c__4609__auto___45919);
var G__45923 = (0);
seq__45041_45875 = G__45920;
chunk__45042_45876 = G__45921;
count__45043_45877 = G__45922;
i__45044_45878 = G__45923;
continue;
} else {
var vec__45114_45924 = cljs.core.first(seq__45041_45918__$1);
var line_45925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45114_45924,(0),null);
var cols_45926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45114_45924,(1),null);
var seq__45117_45927 = cljs.core.seq(cols_45926);
var chunk__45118_45928 = null;
var count__45119_45929 = (0);
var i__45120_45930 = (0);
while(true){
if((i__45120_45930 < count__45119_45929)){
var vec__45127_45931 = chunk__45118_45928.cljs$core$IIndexed$_nth$arity$2(null,i__45120_45930);
var col_45932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45127_45931,(0),null);
var infos_45933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45127_45931,(1),null);
encode_cols(infos_45933,source_idx_45871,line_45925,col_45932);


var G__45934 = seq__45117_45927;
var G__45935 = chunk__45118_45928;
var G__45936 = count__45119_45929;
var G__45937 = (i__45120_45930 + (1));
seq__45117_45927 = G__45934;
chunk__45118_45928 = G__45935;
count__45119_45929 = G__45936;
i__45120_45930 = G__45937;
continue;
} else {
var temp__5735__auto___45938__$2 = cljs.core.seq(seq__45117_45927);
if(temp__5735__auto___45938__$2){
var seq__45117_45939__$1 = temp__5735__auto___45938__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45117_45939__$1)){
var c__4609__auto___45940 = cljs.core.chunk_first(seq__45117_45939__$1);
var G__45941 = cljs.core.chunk_rest(seq__45117_45939__$1);
var G__45942 = c__4609__auto___45940;
var G__45943 = cljs.core.count(c__4609__auto___45940);
var G__45944 = (0);
seq__45117_45927 = G__45941;
chunk__45118_45928 = G__45942;
count__45119_45929 = G__45943;
i__45120_45930 = G__45944;
continue;
} else {
var vec__45130_45946 = cljs.core.first(seq__45117_45939__$1);
var col_45947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45130_45946,(0),null);
var infos_45948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45130_45946,(1),null);
encode_cols(infos_45948,source_idx_45871,line_45925,col_45947);


var G__45949 = cljs.core.next(seq__45117_45939__$1);
var G__45950 = null;
var G__45951 = (0);
var G__45952 = (0);
seq__45117_45927 = G__45949;
chunk__45118_45928 = G__45950;
count__45119_45929 = G__45951;
i__45120_45930 = G__45952;
continue;
}
} else {
}
}
break;
}


var G__45953 = cljs.core.next(seq__45041_45918__$1);
var G__45954 = null;
var G__45955 = (0);
var G__45956 = (0);
seq__45041_45875 = G__45953;
chunk__45042_45876 = G__45954;
count__45043_45877 = G__45955;
i__45044_45878 = G__45956;
continue;
}
} else {
}
}
break;
}


var G__45957 = cljs.core.next(seq__44716_45864__$1);
var G__45958 = null;
var G__45959 = (0);
var G__45960 = (0);
seq__44716_45766 = G__45957;
chunk__44717_45767 = G__45958;
count__44718_45768 = G__45959;
i__44719_45769 = G__45960;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45133 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44686_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44686_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44687_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44687_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44688_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44688_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45134 = G__45133;
var G__45136_45961 = G__45134;
var G__45137_45962 = "sourcesContent";
var G__45138_45963 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45136_45961,G__45137_45962,G__45138_45963);

return G__45134;
} else {
return G__45133;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45146 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45146,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45146,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45149 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45149,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45149,(1),null);
var G__45964 = cljs.core.next(col_map_seq);
var G__45965 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45149,col,infos,vec__45146,line,col_map){
return (function (v,p__45152){
var map__45153 = p__45152;
var map__45153__$1 = (((((!((map__45153 == null))))?(((((map__45153.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45153.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45153):map__45153);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45153__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45153__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45149,col,infos,vec__45146,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__45964;
new_cols = G__45965;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__45966 = cljs.core.next(line_map_seq);
var G__45967 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__45966;
new_lines = G__45967;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45159_45968 = cljs.core.seq(reverse_map);
var chunk__45160_45969 = null;
var count__45161_45970 = (0);
var i__45162_45971 = (0);
while(true){
if((i__45162_45971 < count__45161_45970)){
var vec__45420_45972 = chunk__45160_45969.cljs$core$IIndexed$_nth$arity$2(null,i__45162_45971);
var line_45973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45420_45972,(0),null);
var columns_45974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45420_45972,(1),null);
var seq__45423_45975 = cljs.core.seq(columns_45974);
var chunk__45424_45976 = null;
var count__45425_45977 = (0);
var i__45426_45978 = (0);
while(true){
if((i__45426_45978 < count__45425_45977)){
var vec__45478_45979 = chunk__45424_45976.cljs$core$IIndexed$_nth$arity$2(null,i__45426_45978);
var column_45980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45478_45979,(0),null);
var column_info_45981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45478_45979,(1),null);
var seq__45481_45982 = cljs.core.seq(column_info_45981);
var chunk__45482_45983 = null;
var count__45483_45984 = (0);
var i__45484_45985 = (0);
while(true){
if((i__45484_45985 < count__45483_45984)){
var map__45498_45986 = chunk__45482_45983.cljs$core$IIndexed$_nth$arity$2(null,i__45484_45985);
var map__45498_45987__$1 = (((((!((map__45498_45986 == null))))?(((((map__45498_45986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45498_45986.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45498_45986):map__45498_45986);
var gline_45988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45498_45987__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_45989 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45498_45987__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_45990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45498_45987__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45988], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45481_45982,chunk__45482_45983,count__45483_45984,i__45484_45985,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45498_45986,map__45498_45987__$1,gline_45988,gcol_45989,name_45990,vec__45478_45979,column_45980,column_info_45981,vec__45420_45972,line_45973,columns_45974,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_45989], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_45973,new cljs.core.Keyword(null,"col","col",-1959363084),column_45980,new cljs.core.Keyword(null,"name","name",1843675177),name_45990], null));
});})(seq__45481_45982,chunk__45482_45983,count__45483_45984,i__45484_45985,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45498_45986,map__45498_45987__$1,gline_45988,gcol_45989,name_45990,vec__45478_45979,column_45980,column_info_45981,vec__45420_45972,line_45973,columns_45974,inverted))
,cljs.core.sorted_map()));


var G__45996 = seq__45481_45982;
var G__45997 = chunk__45482_45983;
var G__45998 = count__45483_45984;
var G__45999 = (i__45484_45985 + (1));
seq__45481_45982 = G__45996;
chunk__45482_45983 = G__45997;
count__45483_45984 = G__45998;
i__45484_45985 = G__45999;
continue;
} else {
var temp__5735__auto___46001 = cljs.core.seq(seq__45481_45982);
if(temp__5735__auto___46001){
var seq__45481_46003__$1 = temp__5735__auto___46001;
if(cljs.core.chunked_seq_QMARK_(seq__45481_46003__$1)){
var c__4609__auto___46004 = cljs.core.chunk_first(seq__45481_46003__$1);
var G__46005 = cljs.core.chunk_rest(seq__45481_46003__$1);
var G__46006 = c__4609__auto___46004;
var G__46007 = cljs.core.count(c__4609__auto___46004);
var G__46008 = (0);
seq__45481_45982 = G__46005;
chunk__45482_45983 = G__46006;
count__45483_45984 = G__46007;
i__45484_45985 = G__46008;
continue;
} else {
var map__45500_46009 = cljs.core.first(seq__45481_46003__$1);
var map__45500_46010__$1 = (((((!((map__45500_46009 == null))))?(((((map__45500_46009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45500_46009.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45500_46009):map__45500_46009);
var gline_46011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45500_46010__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46012 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45500_46010__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46013 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45500_46010__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46011], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45481_45982,chunk__45482_45983,count__45483_45984,i__45484_45985,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45500_46009,map__45500_46010__$1,gline_46011,gcol_46012,name_46013,seq__45481_46003__$1,temp__5735__auto___46001,vec__45478_45979,column_45980,column_info_45981,vec__45420_45972,line_45973,columns_45974,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46012], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_45973,new cljs.core.Keyword(null,"col","col",-1959363084),column_45980,new cljs.core.Keyword(null,"name","name",1843675177),name_46013], null));
});})(seq__45481_45982,chunk__45482_45983,count__45483_45984,i__45484_45985,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45500_46009,map__45500_46010__$1,gline_46011,gcol_46012,name_46013,seq__45481_46003__$1,temp__5735__auto___46001,vec__45478_45979,column_45980,column_info_45981,vec__45420_45972,line_45973,columns_45974,inverted))
,cljs.core.sorted_map()));


var G__46030 = cljs.core.next(seq__45481_46003__$1);
var G__46032 = null;
var G__46033 = (0);
var G__46034 = (0);
seq__45481_45982 = G__46030;
chunk__45482_45983 = G__46032;
count__45483_45984 = G__46033;
i__45484_45985 = G__46034;
continue;
}
} else {
}
}
break;
}


var G__46036 = seq__45423_45975;
var G__46037 = chunk__45424_45976;
var G__46038 = count__45425_45977;
var G__46039 = (i__45426_45978 + (1));
seq__45423_45975 = G__46036;
chunk__45424_45976 = G__46037;
count__45425_45977 = G__46038;
i__45426_45978 = G__46039;
continue;
} else {
var temp__5735__auto___46040 = cljs.core.seq(seq__45423_45975);
if(temp__5735__auto___46040){
var seq__45423_46041__$1 = temp__5735__auto___46040;
if(cljs.core.chunked_seq_QMARK_(seq__45423_46041__$1)){
var c__4609__auto___46042 = cljs.core.chunk_first(seq__45423_46041__$1);
var G__46043 = cljs.core.chunk_rest(seq__45423_46041__$1);
var G__46044 = c__4609__auto___46042;
var G__46045 = cljs.core.count(c__4609__auto___46042);
var G__46046 = (0);
seq__45423_45975 = G__46043;
chunk__45424_45976 = G__46044;
count__45425_45977 = G__46045;
i__45426_45978 = G__46046;
continue;
} else {
var vec__45505_46047 = cljs.core.first(seq__45423_46041__$1);
var column_46048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45505_46047,(0),null);
var column_info_46049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45505_46047,(1),null);
var seq__45511_46050 = cljs.core.seq(column_info_46049);
var chunk__45512_46051 = null;
var count__45513_46052 = (0);
var i__45514_46053 = (0);
while(true){
if((i__45514_46053 < count__45513_46052)){
var map__45520_46054 = chunk__45512_46051.cljs$core$IIndexed$_nth$arity$2(null,i__45514_46053);
var map__45520_46055__$1 = (((((!((map__45520_46054 == null))))?(((((map__45520_46054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45520_46054.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45520_46054):map__45520_46054);
var gline_46056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45520_46055__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46057 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45520_46055__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46058 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45520_46055__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46056], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45511_46050,chunk__45512_46051,count__45513_46052,i__45514_46053,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45520_46054,map__45520_46055__$1,gline_46056,gcol_46057,name_46058,vec__45505_46047,column_46048,column_info_46049,seq__45423_46041__$1,temp__5735__auto___46040,vec__45420_45972,line_45973,columns_45974,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46057], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_45973,new cljs.core.Keyword(null,"col","col",-1959363084),column_46048,new cljs.core.Keyword(null,"name","name",1843675177),name_46058], null));
});})(seq__45511_46050,chunk__45512_46051,count__45513_46052,i__45514_46053,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45520_46054,map__45520_46055__$1,gline_46056,gcol_46057,name_46058,vec__45505_46047,column_46048,column_info_46049,seq__45423_46041__$1,temp__5735__auto___46040,vec__45420_45972,line_45973,columns_45974,inverted))
,cljs.core.sorted_map()));


var G__46062 = seq__45511_46050;
var G__46063 = chunk__45512_46051;
var G__46064 = count__45513_46052;
var G__46065 = (i__45514_46053 + (1));
seq__45511_46050 = G__46062;
chunk__45512_46051 = G__46063;
count__45513_46052 = G__46064;
i__45514_46053 = G__46065;
continue;
} else {
var temp__5735__auto___46066__$1 = cljs.core.seq(seq__45511_46050);
if(temp__5735__auto___46066__$1){
var seq__45511_46069__$1 = temp__5735__auto___46066__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45511_46069__$1)){
var c__4609__auto___46070 = cljs.core.chunk_first(seq__45511_46069__$1);
var G__46071 = cljs.core.chunk_rest(seq__45511_46069__$1);
var G__46072 = c__4609__auto___46070;
var G__46073 = cljs.core.count(c__4609__auto___46070);
var G__46074 = (0);
seq__45511_46050 = G__46071;
chunk__45512_46051 = G__46072;
count__45513_46052 = G__46073;
i__45514_46053 = G__46074;
continue;
} else {
var map__45529_46075 = cljs.core.first(seq__45511_46069__$1);
var map__45529_46076__$1 = (((((!((map__45529_46075 == null))))?(((((map__45529_46075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45529_46075.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45529_46075):map__45529_46075);
var gline_46077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45529_46076__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45529_46076__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45529_46076__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46077], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45511_46050,chunk__45512_46051,count__45513_46052,i__45514_46053,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45529_46075,map__45529_46076__$1,gline_46077,gcol_46078,name_46079,seq__45511_46069__$1,temp__5735__auto___46066__$1,vec__45505_46047,column_46048,column_info_46049,seq__45423_46041__$1,temp__5735__auto___46040,vec__45420_45972,line_45973,columns_45974,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46078], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_45973,new cljs.core.Keyword(null,"col","col",-1959363084),column_46048,new cljs.core.Keyword(null,"name","name",1843675177),name_46079], null));
});})(seq__45511_46050,chunk__45512_46051,count__45513_46052,i__45514_46053,seq__45423_45975,chunk__45424_45976,count__45425_45977,i__45426_45978,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45529_46075,map__45529_46076__$1,gline_46077,gcol_46078,name_46079,seq__45511_46069__$1,temp__5735__auto___46066__$1,vec__45505_46047,column_46048,column_info_46049,seq__45423_46041__$1,temp__5735__auto___46040,vec__45420_45972,line_45973,columns_45974,inverted))
,cljs.core.sorted_map()));


var G__46086 = cljs.core.next(seq__45511_46069__$1);
var G__46087 = null;
var G__46088 = (0);
var G__46089 = (0);
seq__45511_46050 = G__46086;
chunk__45512_46051 = G__46087;
count__45513_46052 = G__46088;
i__45514_46053 = G__46089;
continue;
}
} else {
}
}
break;
}


var G__46090 = cljs.core.next(seq__45423_46041__$1);
var G__46091 = null;
var G__46092 = (0);
var G__46093 = (0);
seq__45423_45975 = G__46090;
chunk__45424_45976 = G__46091;
count__45425_45977 = G__46092;
i__45426_45978 = G__46093;
continue;
}
} else {
}
}
break;
}


var G__46094 = seq__45159_45968;
var G__46095 = chunk__45160_45969;
var G__46096 = count__45161_45970;
var G__46097 = (i__45162_45971 + (1));
seq__45159_45968 = G__46094;
chunk__45160_45969 = G__46095;
count__45161_45970 = G__46096;
i__45162_45971 = G__46097;
continue;
} else {
var temp__5735__auto___46098 = cljs.core.seq(seq__45159_45968);
if(temp__5735__auto___46098){
var seq__45159_46099__$1 = temp__5735__auto___46098;
if(cljs.core.chunked_seq_QMARK_(seq__45159_46099__$1)){
var c__4609__auto___46100 = cljs.core.chunk_first(seq__45159_46099__$1);
var G__46101 = cljs.core.chunk_rest(seq__45159_46099__$1);
var G__46102 = c__4609__auto___46100;
var G__46103 = cljs.core.count(c__4609__auto___46100);
var G__46104 = (0);
seq__45159_45968 = G__46101;
chunk__45160_45969 = G__46102;
count__45161_45970 = G__46103;
i__45162_45971 = G__46104;
continue;
} else {
var vec__45538_46106 = cljs.core.first(seq__45159_46099__$1);
var line_46107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45538_46106,(0),null);
var columns_46108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45538_46106,(1),null);
var seq__45542_46109 = cljs.core.seq(columns_46108);
var chunk__45543_46110 = null;
var count__45544_46111 = (0);
var i__45545_46112 = (0);
while(true){
if((i__45545_46112 < count__45544_46111)){
var vec__45609_46113 = chunk__45543_46110.cljs$core$IIndexed$_nth$arity$2(null,i__45545_46112);
var column_46114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45609_46113,(0),null);
var column_info_46115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45609_46113,(1),null);
var seq__45615_46116 = cljs.core.seq(column_info_46115);
var chunk__45616_46117 = null;
var count__45617_46118 = (0);
var i__45618_46119 = (0);
while(true){
if((i__45618_46119 < count__45617_46118)){
var map__45628_46120 = chunk__45616_46117.cljs$core$IIndexed$_nth$arity$2(null,i__45618_46119);
var map__45628_46121__$1 = (((((!((map__45628_46120 == null))))?(((((map__45628_46120.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45628_46120.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45628_46120):map__45628_46120);
var gline_46122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45628_46121__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45628_46121__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45628_46121__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46122], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45615_46116,chunk__45616_46117,count__45617_46118,i__45618_46119,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45628_46120,map__45628_46121__$1,gline_46122,gcol_46123,name_46124,vec__45609_46113,column_46114,column_info_46115,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46123], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46107,new cljs.core.Keyword(null,"col","col",-1959363084),column_46114,new cljs.core.Keyword(null,"name","name",1843675177),name_46124], null));
});})(seq__45615_46116,chunk__45616_46117,count__45617_46118,i__45618_46119,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45628_46120,map__45628_46121__$1,gline_46122,gcol_46123,name_46124,vec__45609_46113,column_46114,column_info_46115,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted))
,cljs.core.sorted_map()));


var G__46128 = seq__45615_46116;
var G__46129 = chunk__45616_46117;
var G__46130 = count__45617_46118;
var G__46131 = (i__45618_46119 + (1));
seq__45615_46116 = G__46128;
chunk__45616_46117 = G__46129;
count__45617_46118 = G__46130;
i__45618_46119 = G__46131;
continue;
} else {
var temp__5735__auto___46132__$1 = cljs.core.seq(seq__45615_46116);
if(temp__5735__auto___46132__$1){
var seq__45615_46133__$1 = temp__5735__auto___46132__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45615_46133__$1)){
var c__4609__auto___46134 = cljs.core.chunk_first(seq__45615_46133__$1);
var G__46135 = cljs.core.chunk_rest(seq__45615_46133__$1);
var G__46136 = c__4609__auto___46134;
var G__46137 = cljs.core.count(c__4609__auto___46134);
var G__46138 = (0);
seq__45615_46116 = G__46135;
chunk__45616_46117 = G__46136;
count__45617_46118 = G__46137;
i__45618_46119 = G__46138;
continue;
} else {
var map__45632_46139 = cljs.core.first(seq__45615_46133__$1);
var map__45632_46140__$1 = (((((!((map__45632_46139 == null))))?(((((map__45632_46139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45632_46139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45632_46139):map__45632_46139);
var gline_46141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45632_46140__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45632_46140__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46143 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45632_46140__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46141], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45615_46116,chunk__45616_46117,count__45617_46118,i__45618_46119,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45632_46139,map__45632_46140__$1,gline_46141,gcol_46142,name_46143,seq__45615_46133__$1,temp__5735__auto___46132__$1,vec__45609_46113,column_46114,column_info_46115,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46142], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46107,new cljs.core.Keyword(null,"col","col",-1959363084),column_46114,new cljs.core.Keyword(null,"name","name",1843675177),name_46143], null));
});})(seq__45615_46116,chunk__45616_46117,count__45617_46118,i__45618_46119,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45632_46139,map__45632_46140__$1,gline_46141,gcol_46142,name_46143,seq__45615_46133__$1,temp__5735__auto___46132__$1,vec__45609_46113,column_46114,column_info_46115,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted))
,cljs.core.sorted_map()));


var G__46144 = cljs.core.next(seq__45615_46133__$1);
var G__46145 = null;
var G__46146 = (0);
var G__46147 = (0);
seq__45615_46116 = G__46144;
chunk__45616_46117 = G__46145;
count__45617_46118 = G__46146;
i__45618_46119 = G__46147;
continue;
}
} else {
}
}
break;
}


var G__46148 = seq__45542_46109;
var G__46149 = chunk__45543_46110;
var G__46150 = count__45544_46111;
var G__46151 = (i__45545_46112 + (1));
seq__45542_46109 = G__46148;
chunk__45543_46110 = G__46149;
count__45544_46111 = G__46150;
i__45545_46112 = G__46151;
continue;
} else {
var temp__5735__auto___46152__$1 = cljs.core.seq(seq__45542_46109);
if(temp__5735__auto___46152__$1){
var seq__45542_46153__$1 = temp__5735__auto___46152__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45542_46153__$1)){
var c__4609__auto___46154 = cljs.core.chunk_first(seq__45542_46153__$1);
var G__46155 = cljs.core.chunk_rest(seq__45542_46153__$1);
var G__46156 = c__4609__auto___46154;
var G__46157 = cljs.core.count(c__4609__auto___46154);
var G__46158 = (0);
seq__45542_46109 = G__46155;
chunk__45543_46110 = G__46156;
count__45544_46111 = G__46157;
i__45545_46112 = G__46158;
continue;
} else {
var vec__45638_46159 = cljs.core.first(seq__45542_46153__$1);
var column_46160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45638_46159,(0),null);
var column_info_46161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45638_46159,(1),null);
var seq__45641_46162 = cljs.core.seq(column_info_46161);
var chunk__45642_46163 = null;
var count__45643_46164 = (0);
var i__45644_46165 = (0);
while(true){
if((i__45644_46165 < count__45643_46164)){
var map__45660_46166 = chunk__45642_46163.cljs$core$IIndexed$_nth$arity$2(null,i__45644_46165);
var map__45660_46167__$1 = (((((!((map__45660_46166 == null))))?(((((map__45660_46166.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45660_46166.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45660_46166):map__45660_46166);
var gline_46168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45660_46167__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45660_46167__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45660_46167__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46168], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45641_46162,chunk__45642_46163,count__45643_46164,i__45644_46165,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45660_46166,map__45660_46167__$1,gline_46168,gcol_46169,name_46170,vec__45638_46159,column_46160,column_info_46161,seq__45542_46153__$1,temp__5735__auto___46152__$1,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46169], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46107,new cljs.core.Keyword(null,"col","col",-1959363084),column_46160,new cljs.core.Keyword(null,"name","name",1843675177),name_46170], null));
});})(seq__45641_46162,chunk__45642_46163,count__45643_46164,i__45644_46165,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45660_46166,map__45660_46167__$1,gline_46168,gcol_46169,name_46170,vec__45638_46159,column_46160,column_info_46161,seq__45542_46153__$1,temp__5735__auto___46152__$1,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted))
,cljs.core.sorted_map()));


var G__46172 = seq__45641_46162;
var G__46173 = chunk__45642_46163;
var G__46174 = count__45643_46164;
var G__46175 = (i__45644_46165 + (1));
seq__45641_46162 = G__46172;
chunk__45642_46163 = G__46173;
count__45643_46164 = G__46174;
i__45644_46165 = G__46175;
continue;
} else {
var temp__5735__auto___46176__$2 = cljs.core.seq(seq__45641_46162);
if(temp__5735__auto___46176__$2){
var seq__45641_46177__$1 = temp__5735__auto___46176__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45641_46177__$1)){
var c__4609__auto___46178 = cljs.core.chunk_first(seq__45641_46177__$1);
var G__46179 = cljs.core.chunk_rest(seq__45641_46177__$1);
var G__46180 = c__4609__auto___46178;
var G__46181 = cljs.core.count(c__4609__auto___46178);
var G__46182 = (0);
seq__45641_46162 = G__46179;
chunk__45642_46163 = G__46180;
count__45643_46164 = G__46181;
i__45644_46165 = G__46182;
continue;
} else {
var map__45667_46183 = cljs.core.first(seq__45641_46177__$1);
var map__45667_46184__$1 = (((((!((map__45667_46183 == null))))?(((((map__45667_46183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45667_46183.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45667_46183):map__45667_46183);
var gline_46185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45667_46184__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45667_46184__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46187 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45667_46184__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46185], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45641_46162,chunk__45642_46163,count__45643_46164,i__45644_46165,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45667_46183,map__45667_46184__$1,gline_46185,gcol_46186,name_46187,seq__45641_46177__$1,temp__5735__auto___46176__$2,vec__45638_46159,column_46160,column_info_46161,seq__45542_46153__$1,temp__5735__auto___46152__$1,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46186], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46107,new cljs.core.Keyword(null,"col","col",-1959363084),column_46160,new cljs.core.Keyword(null,"name","name",1843675177),name_46187], null));
});})(seq__45641_46162,chunk__45642_46163,count__45643_46164,i__45644_46165,seq__45542_46109,chunk__45543_46110,count__45544_46111,i__45545_46112,seq__45159_45968,chunk__45160_45969,count__45161_45970,i__45162_45971,map__45667_46183,map__45667_46184__$1,gline_46185,gcol_46186,name_46187,seq__45641_46177__$1,temp__5735__auto___46176__$2,vec__45638_46159,column_46160,column_info_46161,seq__45542_46153__$1,temp__5735__auto___46152__$1,vec__45538_46106,line_46107,columns_46108,seq__45159_46099__$1,temp__5735__auto___46098,inverted))
,cljs.core.sorted_map()));


var G__46188 = cljs.core.next(seq__45641_46177__$1);
var G__46189 = null;
var G__46190 = (0);
var G__46191 = (0);
seq__45641_46162 = G__46188;
chunk__45642_46163 = G__46189;
count__45643_46164 = G__46190;
i__45644_46165 = G__46191;
continue;
}
} else {
}
}
break;
}


var G__46192 = cljs.core.next(seq__45542_46153__$1);
var G__46193 = null;
var G__46194 = (0);
var G__46195 = (0);
seq__45542_46109 = G__46192;
chunk__45543_46110 = G__46193;
count__45544_46111 = G__46194;
i__45545_46112 = G__46195;
continue;
}
} else {
}
}
break;
}


var G__46196 = cljs.core.next(seq__45159_46099__$1);
var G__46197 = null;
var G__46198 = (0);
var G__46199 = (0);
seq__45159_45968 = G__46196;
chunk__45160_45969 = G__46197;
count__45161_45970 = G__46198;
i__45162_45971 = G__46199;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
