goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44667){
var vec__44668 = p__44667;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44668,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44668,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44680 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44683 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44683,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44683,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44683,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44683,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44683,(4),null);
var vec__44686 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44686,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44686,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44686,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44686,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44686,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44697 = segmap;
var map__44697__$1 = (((((!((map__44697 == null))))?(((((map__44697.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44697.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44697):map__44697);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44697__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44697__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44697__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44697__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44697__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44709 = arguments.length;
switch (G__44709) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44715 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45781 = cljs.core.next(segs__$1);
var G__45782 = nrelseg;
var G__45783 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45781;
relseg__$1 = G__45782;
result__$1 = G__45783;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(1),null);
var G__45785 = (gline + (1));
var G__45786 = cljs.core.next(lines__$1);
var G__45787 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45788 = result__$1;
gline = G__45785;
lines__$1 = G__45786;
relseg = G__45787;
result = G__45788;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44726 = segmap;
var map__44726__$1 = (((((!((map__44726 == null))))?(((((map__44726.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44726.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44726):map__44726);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44726__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44726__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44726__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44726__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44726__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44722_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44722_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44733 = arguments.length;
switch (G__44733) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44739 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45797 = cljs.core.next(segs__$1);
var G__45798 = nrelseg;
var G__45799 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45797;
relseg__$1 = G__45798;
result__$1 = G__45799;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(1),null);
var G__45800 = (gline + (1));
var G__45801 = cljs.core.next(lines__$1);
var G__45802 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45803 = result__$1;
gline = G__45800;
lines__$1 = G__45801;
relseg = G__45802;
result = G__45803;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44744){
var vec__44745 = p__44744;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44745,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44745,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44745,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44745,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44745,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44753){
var vec__44754 = p__44753;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44754,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44754,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44754,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44754,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44754,(4),null);
var seg = vec__44754;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44758){
var vec__44760 = p__44758;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44760,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44760,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44760,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44760,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44760,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44773 = cljs.core.seq(infos);
var chunk__44774 = null;
var count__44775 = (0);
var i__44776 = (0);
while(true){
if((i__44776 < count__44775)){
var info = chunk__44774.cljs$core$IIndexed$_nth$arity$2(null,i__44776);
var segv_45805 = info__GT_segv(info,source_idx,line,col);
var gline_45806 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45807 = cljs.core.count(cljs.core.deref(lines));
if((gline_45806 > (lc_45807 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44773,chunk__44774,count__44775,i__44776,segv_45805,gline_45806,lc_45807,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45806 - (lc_45807 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45805], null));
});})(seq__44773,chunk__44774,count__44775,i__44776,segv_45805,gline_45806,lc_45807,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44773,chunk__44774,count__44775,i__44776,segv_45805,gline_45806,lc_45807,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45806], null),cljs.core.conj,segv_45805);
});})(seq__44773,chunk__44774,count__44775,i__44776,segv_45805,gline_45806,lc_45807,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45808 = seq__44773;
var G__45809 = chunk__44774;
var G__45810 = count__44775;
var G__45811 = (i__44776 + (1));
seq__44773 = G__45808;
chunk__44774 = G__45809;
count__44775 = G__45810;
i__44776 = G__45811;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44773);
if(temp__5735__auto__){
var seq__44773__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44773__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44773__$1);
var G__45812 = cljs.core.chunk_rest(seq__44773__$1);
var G__45813 = c__4609__auto__;
var G__45814 = cljs.core.count(c__4609__auto__);
var G__45815 = (0);
seq__44773 = G__45812;
chunk__44774 = G__45813;
count__44775 = G__45814;
i__44776 = G__45815;
continue;
} else {
var info = cljs.core.first(seq__44773__$1);
var segv_45816 = info__GT_segv(info,source_idx,line,col);
var gline_45817 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45818 = cljs.core.count(cljs.core.deref(lines));
if((gline_45817 > (lc_45818 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44773,chunk__44774,count__44775,i__44776,segv_45816,gline_45817,lc_45818,info,seq__44773__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45817 - (lc_45818 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45816], null));
});})(seq__44773,chunk__44774,count__44775,i__44776,segv_45816,gline_45817,lc_45818,info,seq__44773__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44773,chunk__44774,count__44775,i__44776,segv_45816,gline_45817,lc_45818,info,seq__44773__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45817], null),cljs.core.conj,segv_45816);
});})(seq__44773,chunk__44774,count__44775,i__44776,segv_45816,gline_45817,lc_45818,info,seq__44773__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45819 = cljs.core.next(seq__44773__$1);
var G__45820 = null;
var G__45821 = (0);
var G__45822 = (0);
seq__44773 = G__45819;
chunk__44774 = G__45820;
count__44775 = G__45821;
i__44776 = G__45822;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44783_45823 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44784_45824 = null;
var count__44785_45825 = (0);
var i__44786_45826 = (0);
while(true){
if((i__44786_45826 < count__44785_45825)){
var vec__45043_45827 = chunk__44784_45824.cljs$core$IIndexed$_nth$arity$2(null,i__44786_45826);
var source_idx_45828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043_45827,(0),null);
var vec__45046_45829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043_45827,(1),null);
var __45830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45046_45829,(0),null);
var lines_45831__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45046_45829,(1),null);
var seq__45049_45832 = cljs.core.seq(lines_45831__$1);
var chunk__45050_45833 = null;
var count__45051_45834 = (0);
var i__45052_45835 = (0);
while(true){
if((i__45052_45835 < count__45051_45834)){
var vec__45104_45836 = chunk__45050_45833.cljs$core$IIndexed$_nth$arity$2(null,i__45052_45835);
var line_45837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45104_45836,(0),null);
var cols_45838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45104_45836,(1),null);
var seq__45107_45839 = cljs.core.seq(cols_45838);
var chunk__45108_45840 = null;
var count__45109_45841 = (0);
var i__45110_45842 = (0);
while(true){
if((i__45110_45842 < count__45109_45841)){
var vec__45117_45843 = chunk__45108_45840.cljs$core$IIndexed$_nth$arity$2(null,i__45110_45842);
var col_45844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45117_45843,(0),null);
var infos_45845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45117_45843,(1),null);
encode_cols(infos_45845,source_idx_45828,line_45837,col_45844);


var G__45846 = seq__45107_45839;
var G__45847 = chunk__45108_45840;
var G__45848 = count__45109_45841;
var G__45849 = (i__45110_45842 + (1));
seq__45107_45839 = G__45846;
chunk__45108_45840 = G__45847;
count__45109_45841 = G__45848;
i__45110_45842 = G__45849;
continue;
} else {
var temp__5735__auto___45850 = cljs.core.seq(seq__45107_45839);
if(temp__5735__auto___45850){
var seq__45107_45851__$1 = temp__5735__auto___45850;
if(cljs.core.chunked_seq_QMARK_(seq__45107_45851__$1)){
var c__4609__auto___45852 = cljs.core.chunk_first(seq__45107_45851__$1);
var G__45853 = cljs.core.chunk_rest(seq__45107_45851__$1);
var G__45854 = c__4609__auto___45852;
var G__45855 = cljs.core.count(c__4609__auto___45852);
var G__45856 = (0);
seq__45107_45839 = G__45853;
chunk__45108_45840 = G__45854;
count__45109_45841 = G__45855;
i__45110_45842 = G__45856;
continue;
} else {
var vec__45120_45858 = cljs.core.first(seq__45107_45851__$1);
var col_45859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45858,(0),null);
var infos_45860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45858,(1),null);
encode_cols(infos_45860,source_idx_45828,line_45837,col_45859);


var G__45863 = cljs.core.next(seq__45107_45851__$1);
var G__45864 = null;
var G__45865 = (0);
var G__45866 = (0);
seq__45107_45839 = G__45863;
chunk__45108_45840 = G__45864;
count__45109_45841 = G__45865;
i__45110_45842 = G__45866;
continue;
}
} else {
}
}
break;
}


var G__45867 = seq__45049_45832;
var G__45868 = chunk__45050_45833;
var G__45869 = count__45051_45834;
var G__45870 = (i__45052_45835 + (1));
seq__45049_45832 = G__45867;
chunk__45050_45833 = G__45868;
count__45051_45834 = G__45869;
i__45052_45835 = G__45870;
continue;
} else {
var temp__5735__auto___45872 = cljs.core.seq(seq__45049_45832);
if(temp__5735__auto___45872){
var seq__45049_45873__$1 = temp__5735__auto___45872;
if(cljs.core.chunked_seq_QMARK_(seq__45049_45873__$1)){
var c__4609__auto___45874 = cljs.core.chunk_first(seq__45049_45873__$1);
var G__45875 = cljs.core.chunk_rest(seq__45049_45873__$1);
var G__45876 = c__4609__auto___45874;
var G__45877 = cljs.core.count(c__4609__auto___45874);
var G__45878 = (0);
seq__45049_45832 = G__45875;
chunk__45050_45833 = G__45876;
count__45051_45834 = G__45877;
i__45052_45835 = G__45878;
continue;
} else {
var vec__45123_45879 = cljs.core.first(seq__45049_45873__$1);
var line_45880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45123_45879,(0),null);
var cols_45881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45123_45879,(1),null);
var seq__45126_45882 = cljs.core.seq(cols_45881);
var chunk__45127_45884 = null;
var count__45128_45885 = (0);
var i__45129_45886 = (0);
while(true){
if((i__45129_45886 < count__45128_45885)){
var vec__45138_45888 = chunk__45127_45884.cljs$core$IIndexed$_nth$arity$2(null,i__45129_45886);
var col_45889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45138_45888,(0),null);
var infos_45890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45138_45888,(1),null);
encode_cols(infos_45890,source_idx_45828,line_45880,col_45889);


var G__45891 = seq__45126_45882;
var G__45892 = chunk__45127_45884;
var G__45893 = count__45128_45885;
var G__45894 = (i__45129_45886 + (1));
seq__45126_45882 = G__45891;
chunk__45127_45884 = G__45892;
count__45128_45885 = G__45893;
i__45129_45886 = G__45894;
continue;
} else {
var temp__5735__auto___45895__$1 = cljs.core.seq(seq__45126_45882);
if(temp__5735__auto___45895__$1){
var seq__45126_45896__$1 = temp__5735__auto___45895__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45126_45896__$1)){
var c__4609__auto___45899 = cljs.core.chunk_first(seq__45126_45896__$1);
var G__45900 = cljs.core.chunk_rest(seq__45126_45896__$1);
var G__45901 = c__4609__auto___45899;
var G__45902 = cljs.core.count(c__4609__auto___45899);
var G__45903 = (0);
seq__45126_45882 = G__45900;
chunk__45127_45884 = G__45901;
count__45128_45885 = G__45902;
i__45129_45886 = G__45903;
continue;
} else {
var vec__45144_45904 = cljs.core.first(seq__45126_45896__$1);
var col_45905 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45144_45904,(0),null);
var infos_45906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45144_45904,(1),null);
encode_cols(infos_45906,source_idx_45828,line_45880,col_45905);


var G__45907 = cljs.core.next(seq__45126_45896__$1);
var G__45908 = null;
var G__45909 = (0);
var G__45910 = (0);
seq__45126_45882 = G__45907;
chunk__45127_45884 = G__45908;
count__45128_45885 = G__45909;
i__45129_45886 = G__45910;
continue;
}
} else {
}
}
break;
}


var G__45911 = cljs.core.next(seq__45049_45873__$1);
var G__45912 = null;
var G__45913 = (0);
var G__45914 = (0);
seq__45049_45832 = G__45911;
chunk__45050_45833 = G__45912;
count__45051_45834 = G__45913;
i__45052_45835 = G__45914;
continue;
}
} else {
}
}
break;
}


var G__45915 = seq__44783_45823;
var G__45916 = chunk__44784_45824;
var G__45917 = count__44785_45825;
var G__45918 = (i__44786_45826 + (1));
seq__44783_45823 = G__45915;
chunk__44784_45824 = G__45916;
count__44785_45825 = G__45917;
i__44786_45826 = G__45918;
continue;
} else {
var temp__5735__auto___45919 = cljs.core.seq(seq__44783_45823);
if(temp__5735__auto___45919){
var seq__44783_45920__$1 = temp__5735__auto___45919;
if(cljs.core.chunked_seq_QMARK_(seq__44783_45920__$1)){
var c__4609__auto___45921 = cljs.core.chunk_first(seq__44783_45920__$1);
var G__45922 = cljs.core.chunk_rest(seq__44783_45920__$1);
var G__45923 = c__4609__auto___45921;
var G__45924 = cljs.core.count(c__4609__auto___45921);
var G__45925 = (0);
seq__44783_45823 = G__45922;
chunk__44784_45824 = G__45923;
count__44785_45825 = G__45924;
i__44786_45826 = G__45925;
continue;
} else {
var vec__45147_45926 = cljs.core.first(seq__44783_45920__$1);
var source_idx_45927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45147_45926,(0),null);
var vec__45150_45928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45147_45926,(1),null);
var __45929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45150_45928,(0),null);
var lines_45930__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45150_45928,(1),null);
var seq__45153_45931 = cljs.core.seq(lines_45930__$1);
var chunk__45154_45932 = null;
var count__45155_45933 = (0);
var i__45156_45934 = (0);
while(true){
if((i__45156_45934 < count__45155_45933)){
var vec__45205_45938 = chunk__45154_45932.cljs$core$IIndexed$_nth$arity$2(null,i__45156_45934);
var line_45939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45205_45938,(0),null);
var cols_45940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45205_45938,(1),null);
var seq__45208_45941 = cljs.core.seq(cols_45940);
var chunk__45209_45942 = null;
var count__45210_45943 = (0);
var i__45211_45944 = (0);
while(true){
if((i__45211_45944 < count__45210_45943)){
var vec__45220_45945 = chunk__45209_45942.cljs$core$IIndexed$_nth$arity$2(null,i__45211_45944);
var col_45946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45220_45945,(0),null);
var infos_45947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45220_45945,(1),null);
encode_cols(infos_45947,source_idx_45927,line_45939,col_45946);


var G__45949 = seq__45208_45941;
var G__45950 = chunk__45209_45942;
var G__45951 = count__45210_45943;
var G__45952 = (i__45211_45944 + (1));
seq__45208_45941 = G__45949;
chunk__45209_45942 = G__45950;
count__45210_45943 = G__45951;
i__45211_45944 = G__45952;
continue;
} else {
var temp__5735__auto___45953__$1 = cljs.core.seq(seq__45208_45941);
if(temp__5735__auto___45953__$1){
var seq__45208_45954__$1 = temp__5735__auto___45953__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45208_45954__$1)){
var c__4609__auto___45955 = cljs.core.chunk_first(seq__45208_45954__$1);
var G__45956 = cljs.core.chunk_rest(seq__45208_45954__$1);
var G__45957 = c__4609__auto___45955;
var G__45958 = cljs.core.count(c__4609__auto___45955);
var G__45959 = (0);
seq__45208_45941 = G__45956;
chunk__45209_45942 = G__45957;
count__45210_45943 = G__45958;
i__45211_45944 = G__45959;
continue;
} else {
var vec__45223_45960 = cljs.core.first(seq__45208_45954__$1);
var col_45961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45223_45960,(0),null);
var infos_45962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45223_45960,(1),null);
encode_cols(infos_45962,source_idx_45927,line_45939,col_45961);


var G__45963 = cljs.core.next(seq__45208_45954__$1);
var G__45964 = null;
var G__45965 = (0);
var G__45966 = (0);
seq__45208_45941 = G__45963;
chunk__45209_45942 = G__45964;
count__45210_45943 = G__45965;
i__45211_45944 = G__45966;
continue;
}
} else {
}
}
break;
}


var G__45967 = seq__45153_45931;
var G__45968 = chunk__45154_45932;
var G__45969 = count__45155_45933;
var G__45970 = (i__45156_45934 + (1));
seq__45153_45931 = G__45967;
chunk__45154_45932 = G__45968;
count__45155_45933 = G__45969;
i__45156_45934 = G__45970;
continue;
} else {
var temp__5735__auto___45971__$1 = cljs.core.seq(seq__45153_45931);
if(temp__5735__auto___45971__$1){
var seq__45153_45972__$1 = temp__5735__auto___45971__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45153_45972__$1)){
var c__4609__auto___45974 = cljs.core.chunk_first(seq__45153_45972__$1);
var G__45975 = cljs.core.chunk_rest(seq__45153_45972__$1);
var G__45976 = c__4609__auto___45974;
var G__45977 = cljs.core.count(c__4609__auto___45974);
var G__45978 = (0);
seq__45153_45931 = G__45975;
chunk__45154_45932 = G__45976;
count__45155_45933 = G__45977;
i__45156_45934 = G__45978;
continue;
} else {
var vec__45226_45979 = cljs.core.first(seq__45153_45972__$1);
var line_45980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45979,(0),null);
var cols_45981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45979,(1),null);
var seq__45229_45982 = cljs.core.seq(cols_45981);
var chunk__45230_45983 = null;
var count__45231_45984 = (0);
var i__45232_45985 = (0);
while(true){
if((i__45232_45985 < count__45231_45984)){
var vec__45244_45986 = chunk__45230_45983.cljs$core$IIndexed$_nth$arity$2(null,i__45232_45985);
var col_45987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45244_45986,(0),null);
var infos_45988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45244_45986,(1),null);
encode_cols(infos_45988,source_idx_45927,line_45980,col_45987);


var G__45989 = seq__45229_45982;
var G__45990 = chunk__45230_45983;
var G__45991 = count__45231_45984;
var G__45992 = (i__45232_45985 + (1));
seq__45229_45982 = G__45989;
chunk__45230_45983 = G__45990;
count__45231_45984 = G__45991;
i__45232_45985 = G__45992;
continue;
} else {
var temp__5735__auto___45993__$2 = cljs.core.seq(seq__45229_45982);
if(temp__5735__auto___45993__$2){
var seq__45229_45994__$1 = temp__5735__auto___45993__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45229_45994__$1)){
var c__4609__auto___45995 = cljs.core.chunk_first(seq__45229_45994__$1);
var G__45997 = cljs.core.chunk_rest(seq__45229_45994__$1);
var G__45998 = c__4609__auto___45995;
var G__45999 = cljs.core.count(c__4609__auto___45995);
var G__46000 = (0);
seq__45229_45982 = G__45997;
chunk__45230_45983 = G__45998;
count__45231_45984 = G__45999;
i__45232_45985 = G__46000;
continue;
} else {
var vec__45247_46001 = cljs.core.first(seq__45229_45994__$1);
var col_46002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45247_46001,(0),null);
var infos_46003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45247_46001,(1),null);
encode_cols(infos_46003,source_idx_45927,line_45980,col_46002);


var G__46004 = cljs.core.next(seq__45229_45994__$1);
var G__46005 = null;
var G__46006 = (0);
var G__46007 = (0);
seq__45229_45982 = G__46004;
chunk__45230_45983 = G__46005;
count__45231_45984 = G__46006;
i__45232_45985 = G__46007;
continue;
}
} else {
}
}
break;
}


var G__46008 = cljs.core.next(seq__45153_45972__$1);
var G__46009 = null;
var G__46010 = (0);
var G__46011 = (0);
seq__45153_45931 = G__46008;
chunk__45154_45932 = G__46009;
count__45155_45933 = G__46010;
i__45156_45934 = G__46011;
continue;
}
} else {
}
}
break;
}


var G__46013 = cljs.core.next(seq__44783_45920__$1);
var G__46014 = null;
var G__46015 = (0);
var G__46016 = (0);
seq__44783_45823 = G__46013;
chunk__44784_45824 = G__46014;
count__44785_45825 = G__46015;
i__44786_45826 = G__46016;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45250 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44764_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44764_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44765_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44765_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44766_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44766_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45258 = G__45250;
var G__45259_46018 = G__45258;
var G__45260_46019 = "sourcesContent";
var G__45261_46020 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45259_46018,G__45260_46019,G__45261_46020);

return G__45258;
} else {
return G__45250;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45268 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45268,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45268,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45271 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45271,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45271,(1),null);
var G__46025 = cljs.core.next(col_map_seq);
var G__46026 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45271,col,infos,vec__45268,line,col_map){
return (function (v,p__45277){
var map__45278 = p__45277;
var map__45278__$1 = (((((!((map__45278 == null))))?(((((map__45278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45278):map__45278);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45278__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45278__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45271,col,infos,vec__45268,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46025;
new_cols = G__46026;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46033 = cljs.core.next(line_map_seq);
var G__46034 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46033;
new_lines = G__46034;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45282_46036 = cljs.core.seq(reverse_map);
var chunk__45283_46037 = null;
var count__45284_46038 = (0);
var i__45285_46039 = (0);
while(true){
if((i__45285_46039 < count__45284_46038)){
var vec__45540_46040 = chunk__45283_46037.cljs$core$IIndexed$_nth$arity$2(null,i__45285_46039);
var line_46041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45540_46040,(0),null);
var columns_46042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45540_46040,(1),null);
var seq__45545_46044 = cljs.core.seq(columns_46042);
var chunk__45546_46045 = null;
var count__45547_46046 = (0);
var i__45548_46047 = (0);
while(true){
if((i__45548_46047 < count__45547_46046)){
var vec__45602_46050 = chunk__45546_46045.cljs$core$IIndexed$_nth$arity$2(null,i__45548_46047);
var column_46051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45602_46050,(0),null);
var column_info_46052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45602_46050,(1),null);
var seq__45606_46053 = cljs.core.seq(column_info_46052);
var chunk__45607_46054 = null;
var count__45608_46055 = (0);
var i__45609_46056 = (0);
while(true){
if((i__45609_46056 < count__45608_46055)){
var map__45625_46058 = chunk__45607_46054.cljs$core$IIndexed$_nth$arity$2(null,i__45609_46056);
var map__45625_46059__$1 = (((((!((map__45625_46058 == null))))?(((((map__45625_46058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45625_46058.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45625_46058):map__45625_46058);
var gline_46060 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45625_46059__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45625_46059__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46062 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45625_46059__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46060], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45606_46053,chunk__45607_46054,count__45608_46055,i__45609_46056,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45625_46058,map__45625_46059__$1,gline_46060,gcol_46061,name_46062,vec__45602_46050,column_46051,column_info_46052,vec__45540_46040,line_46041,columns_46042,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46061], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46041,new cljs.core.Keyword(null,"col","col",-1959363084),column_46051,new cljs.core.Keyword(null,"name","name",1843675177),name_46062], null));
});})(seq__45606_46053,chunk__45607_46054,count__45608_46055,i__45609_46056,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45625_46058,map__45625_46059__$1,gline_46060,gcol_46061,name_46062,vec__45602_46050,column_46051,column_info_46052,vec__45540_46040,line_46041,columns_46042,inverted))
,cljs.core.sorted_map()));


var G__46069 = seq__45606_46053;
var G__46070 = chunk__45607_46054;
var G__46071 = count__45608_46055;
var G__46072 = (i__45609_46056 + (1));
seq__45606_46053 = G__46069;
chunk__45607_46054 = G__46070;
count__45608_46055 = G__46071;
i__45609_46056 = G__46072;
continue;
} else {
var temp__5735__auto___46075 = cljs.core.seq(seq__45606_46053);
if(temp__5735__auto___46075){
var seq__45606_46076__$1 = temp__5735__auto___46075;
if(cljs.core.chunked_seq_QMARK_(seq__45606_46076__$1)){
var c__4609__auto___46077 = cljs.core.chunk_first(seq__45606_46076__$1);
var G__46078 = cljs.core.chunk_rest(seq__45606_46076__$1);
var G__46079 = c__4609__auto___46077;
var G__46080 = cljs.core.count(c__4609__auto___46077);
var G__46081 = (0);
seq__45606_46053 = G__46078;
chunk__45607_46054 = G__46079;
count__45608_46055 = G__46080;
i__45609_46056 = G__46081;
continue;
} else {
var map__45630_46084 = cljs.core.first(seq__45606_46076__$1);
var map__45630_46085__$1 = (((((!((map__45630_46084 == null))))?(((((map__45630_46084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45630_46084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45630_46084):map__45630_46084);
var gline_46086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45630_46085__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46087 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45630_46085__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46088 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45630_46085__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46086], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45606_46053,chunk__45607_46054,count__45608_46055,i__45609_46056,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45630_46084,map__45630_46085__$1,gline_46086,gcol_46087,name_46088,seq__45606_46076__$1,temp__5735__auto___46075,vec__45602_46050,column_46051,column_info_46052,vec__45540_46040,line_46041,columns_46042,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46087], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46041,new cljs.core.Keyword(null,"col","col",-1959363084),column_46051,new cljs.core.Keyword(null,"name","name",1843675177),name_46088], null));
});})(seq__45606_46053,chunk__45607_46054,count__45608_46055,i__45609_46056,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45630_46084,map__45630_46085__$1,gline_46086,gcol_46087,name_46088,seq__45606_46076__$1,temp__5735__auto___46075,vec__45602_46050,column_46051,column_info_46052,vec__45540_46040,line_46041,columns_46042,inverted))
,cljs.core.sorted_map()));


var G__46095 = cljs.core.next(seq__45606_46076__$1);
var G__46096 = null;
var G__46097 = (0);
var G__46098 = (0);
seq__45606_46053 = G__46095;
chunk__45607_46054 = G__46096;
count__45608_46055 = G__46097;
i__45609_46056 = G__46098;
continue;
}
} else {
}
}
break;
}


var G__46101 = seq__45545_46044;
var G__46102 = chunk__45546_46045;
var G__46103 = count__45547_46046;
var G__46104 = (i__45548_46047 + (1));
seq__45545_46044 = G__46101;
chunk__45546_46045 = G__46102;
count__45547_46046 = G__46103;
i__45548_46047 = G__46104;
continue;
} else {
var temp__5735__auto___46105 = cljs.core.seq(seq__45545_46044);
if(temp__5735__auto___46105){
var seq__45545_46106__$1 = temp__5735__auto___46105;
if(cljs.core.chunked_seq_QMARK_(seq__45545_46106__$1)){
var c__4609__auto___46107 = cljs.core.chunk_first(seq__45545_46106__$1);
var G__46108 = cljs.core.chunk_rest(seq__45545_46106__$1);
var G__46109 = c__4609__auto___46107;
var G__46110 = cljs.core.count(c__4609__auto___46107);
var G__46111 = (0);
seq__45545_46044 = G__46108;
chunk__45546_46045 = G__46109;
count__45547_46046 = G__46110;
i__45548_46047 = G__46111;
continue;
} else {
var vec__45632_46112 = cljs.core.first(seq__45545_46106__$1);
var column_46113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45632_46112,(0),null);
var column_info_46114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45632_46112,(1),null);
var seq__45635_46115 = cljs.core.seq(column_info_46114);
var chunk__45636_46116 = null;
var count__45637_46117 = (0);
var i__45638_46118 = (0);
while(true){
if((i__45638_46118 < count__45637_46117)){
var map__45652_46119 = chunk__45636_46116.cljs$core$IIndexed$_nth$arity$2(null,i__45638_46118);
var map__45652_46120__$1 = (((((!((map__45652_46119 == null))))?(((((map__45652_46119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45652_46119.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45652_46119):map__45652_46119);
var gline_46121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45652_46120__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45652_46120__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45652_46120__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46121], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45635_46115,chunk__45636_46116,count__45637_46117,i__45638_46118,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45652_46119,map__45652_46120__$1,gline_46121,gcol_46122,name_46123,vec__45632_46112,column_46113,column_info_46114,seq__45545_46106__$1,temp__5735__auto___46105,vec__45540_46040,line_46041,columns_46042,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46122], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46041,new cljs.core.Keyword(null,"col","col",-1959363084),column_46113,new cljs.core.Keyword(null,"name","name",1843675177),name_46123], null));
});})(seq__45635_46115,chunk__45636_46116,count__45637_46117,i__45638_46118,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45652_46119,map__45652_46120__$1,gline_46121,gcol_46122,name_46123,vec__45632_46112,column_46113,column_info_46114,seq__45545_46106__$1,temp__5735__auto___46105,vec__45540_46040,line_46041,columns_46042,inverted))
,cljs.core.sorted_map()));


var G__46125 = seq__45635_46115;
var G__46126 = chunk__45636_46116;
var G__46127 = count__45637_46117;
var G__46128 = (i__45638_46118 + (1));
seq__45635_46115 = G__46125;
chunk__45636_46116 = G__46126;
count__45637_46117 = G__46127;
i__45638_46118 = G__46128;
continue;
} else {
var temp__5735__auto___46131__$1 = cljs.core.seq(seq__45635_46115);
if(temp__5735__auto___46131__$1){
var seq__45635_46133__$1 = temp__5735__auto___46131__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45635_46133__$1)){
var c__4609__auto___46134 = cljs.core.chunk_first(seq__45635_46133__$1);
var G__46135 = cljs.core.chunk_rest(seq__45635_46133__$1);
var G__46136 = c__4609__auto___46134;
var G__46137 = cljs.core.count(c__4609__auto___46134);
var G__46138 = (0);
seq__45635_46115 = G__46135;
chunk__45636_46116 = G__46136;
count__45637_46117 = G__46137;
i__45638_46118 = G__46138;
continue;
} else {
var map__45654_46139 = cljs.core.first(seq__45635_46133__$1);
var map__45654_46140__$1 = (((((!((map__45654_46139 == null))))?(((((map__45654_46139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45654_46139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45654_46139):map__45654_46139);
var gline_46141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45654_46140__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45654_46140__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46143 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45654_46140__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46141], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45635_46115,chunk__45636_46116,count__45637_46117,i__45638_46118,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45654_46139,map__45654_46140__$1,gline_46141,gcol_46142,name_46143,seq__45635_46133__$1,temp__5735__auto___46131__$1,vec__45632_46112,column_46113,column_info_46114,seq__45545_46106__$1,temp__5735__auto___46105,vec__45540_46040,line_46041,columns_46042,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46142], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46041,new cljs.core.Keyword(null,"col","col",-1959363084),column_46113,new cljs.core.Keyword(null,"name","name",1843675177),name_46143], null));
});})(seq__45635_46115,chunk__45636_46116,count__45637_46117,i__45638_46118,seq__45545_46044,chunk__45546_46045,count__45547_46046,i__45548_46047,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45654_46139,map__45654_46140__$1,gline_46141,gcol_46142,name_46143,seq__45635_46133__$1,temp__5735__auto___46131__$1,vec__45632_46112,column_46113,column_info_46114,seq__45545_46106__$1,temp__5735__auto___46105,vec__45540_46040,line_46041,columns_46042,inverted))
,cljs.core.sorted_map()));


var G__46144 = cljs.core.next(seq__45635_46133__$1);
var G__46145 = null;
var G__46146 = (0);
var G__46147 = (0);
seq__45635_46115 = G__46144;
chunk__45636_46116 = G__46145;
count__45637_46117 = G__46146;
i__45638_46118 = G__46147;
continue;
}
} else {
}
}
break;
}


var G__46148 = cljs.core.next(seq__45545_46106__$1);
var G__46150 = null;
var G__46151 = (0);
var G__46152 = (0);
seq__45545_46044 = G__46148;
chunk__45546_46045 = G__46150;
count__45547_46046 = G__46151;
i__45548_46047 = G__46152;
continue;
}
} else {
}
}
break;
}


var G__46154 = seq__45282_46036;
var G__46155 = chunk__45283_46037;
var G__46156 = count__45284_46038;
var G__46157 = (i__45285_46039 + (1));
seq__45282_46036 = G__46154;
chunk__45283_46037 = G__46155;
count__45284_46038 = G__46156;
i__45285_46039 = G__46157;
continue;
} else {
var temp__5735__auto___46158 = cljs.core.seq(seq__45282_46036);
if(temp__5735__auto___46158){
var seq__45282_46159__$1 = temp__5735__auto___46158;
if(cljs.core.chunked_seq_QMARK_(seq__45282_46159__$1)){
var c__4609__auto___46160 = cljs.core.chunk_first(seq__45282_46159__$1);
var G__46161 = cljs.core.chunk_rest(seq__45282_46159__$1);
var G__46162 = c__4609__auto___46160;
var G__46163 = cljs.core.count(c__4609__auto___46160);
var G__46164 = (0);
seq__45282_46036 = G__46161;
chunk__45283_46037 = G__46162;
count__45284_46038 = G__46163;
i__45285_46039 = G__46164;
continue;
} else {
var vec__45665_46165 = cljs.core.first(seq__45282_46159__$1);
var line_46166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45665_46165,(0),null);
var columns_46167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45665_46165,(1),null);
var seq__45668_46168 = cljs.core.seq(columns_46167);
var chunk__45669_46169 = null;
var count__45670_46170 = (0);
var i__45671_46171 = (0);
while(true){
if((i__45671_46171 < count__45670_46170)){
var vec__45717_46172 = chunk__45669_46169.cljs$core$IIndexed$_nth$arity$2(null,i__45671_46171);
var column_46173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45717_46172,(0),null);
var column_info_46174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45717_46172,(1),null);
var seq__45720_46176 = cljs.core.seq(column_info_46174);
var chunk__45721_46177 = null;
var count__45722_46178 = (0);
var i__45723_46179 = (0);
while(true){
if((i__45723_46179 < count__45722_46178)){
var map__45729_46182 = chunk__45721_46177.cljs$core$IIndexed$_nth$arity$2(null,i__45723_46179);
var map__45729_46183__$1 = (((((!((map__45729_46182 == null))))?(((((map__45729_46182.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45729_46182.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45729_46182):map__45729_46182);
var gline_46184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45729_46183__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45729_46183__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45729_46183__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46184], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45720_46176,chunk__45721_46177,count__45722_46178,i__45723_46179,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45729_46182,map__45729_46183__$1,gline_46184,gcol_46185,name_46186,vec__45717_46172,column_46173,column_info_46174,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46185], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46166,new cljs.core.Keyword(null,"col","col",-1959363084),column_46173,new cljs.core.Keyword(null,"name","name",1843675177),name_46186], null));
});})(seq__45720_46176,chunk__45721_46177,count__45722_46178,i__45723_46179,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45729_46182,map__45729_46183__$1,gline_46184,gcol_46185,name_46186,vec__45717_46172,column_46173,column_info_46174,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted))
,cljs.core.sorted_map()));


var G__46192 = seq__45720_46176;
var G__46193 = chunk__45721_46177;
var G__46194 = count__45722_46178;
var G__46195 = (i__45723_46179 + (1));
seq__45720_46176 = G__46192;
chunk__45721_46177 = G__46193;
count__45722_46178 = G__46194;
i__45723_46179 = G__46195;
continue;
} else {
var temp__5735__auto___46196__$1 = cljs.core.seq(seq__45720_46176);
if(temp__5735__auto___46196__$1){
var seq__45720_46197__$1 = temp__5735__auto___46196__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45720_46197__$1)){
var c__4609__auto___46198 = cljs.core.chunk_first(seq__45720_46197__$1);
var G__46199 = cljs.core.chunk_rest(seq__45720_46197__$1);
var G__46200 = c__4609__auto___46198;
var G__46201 = cljs.core.count(c__4609__auto___46198);
var G__46202 = (0);
seq__45720_46176 = G__46199;
chunk__45721_46177 = G__46200;
count__45722_46178 = G__46201;
i__45723_46179 = G__46202;
continue;
} else {
var map__45731_46203 = cljs.core.first(seq__45720_46197__$1);
var map__45731_46204__$1 = (((((!((map__45731_46203 == null))))?(((((map__45731_46203.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45731_46203.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45731_46203):map__45731_46203);
var gline_46205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46204__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46204__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46204__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46205], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45720_46176,chunk__45721_46177,count__45722_46178,i__45723_46179,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45731_46203,map__45731_46204__$1,gline_46205,gcol_46206,name_46207,seq__45720_46197__$1,temp__5735__auto___46196__$1,vec__45717_46172,column_46173,column_info_46174,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46206], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46166,new cljs.core.Keyword(null,"col","col",-1959363084),column_46173,new cljs.core.Keyword(null,"name","name",1843675177),name_46207], null));
});})(seq__45720_46176,chunk__45721_46177,count__45722_46178,i__45723_46179,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45731_46203,map__45731_46204__$1,gline_46205,gcol_46206,name_46207,seq__45720_46197__$1,temp__5735__auto___46196__$1,vec__45717_46172,column_46173,column_info_46174,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted))
,cljs.core.sorted_map()));


var G__46209 = cljs.core.next(seq__45720_46197__$1);
var G__46210 = null;
var G__46211 = (0);
var G__46212 = (0);
seq__45720_46176 = G__46209;
chunk__45721_46177 = G__46210;
count__45722_46178 = G__46211;
i__45723_46179 = G__46212;
continue;
}
} else {
}
}
break;
}


var G__46213 = seq__45668_46168;
var G__46214 = chunk__45669_46169;
var G__46215 = count__45670_46170;
var G__46216 = (i__45671_46171 + (1));
seq__45668_46168 = G__46213;
chunk__45669_46169 = G__46214;
count__45670_46170 = G__46215;
i__45671_46171 = G__46216;
continue;
} else {
var temp__5735__auto___46217__$1 = cljs.core.seq(seq__45668_46168);
if(temp__5735__auto___46217__$1){
var seq__45668_46218__$1 = temp__5735__auto___46217__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45668_46218__$1)){
var c__4609__auto___46219 = cljs.core.chunk_first(seq__45668_46218__$1);
var G__46220 = cljs.core.chunk_rest(seq__45668_46218__$1);
var G__46221 = c__4609__auto___46219;
var G__46222 = cljs.core.count(c__4609__auto___46219);
var G__46223 = (0);
seq__45668_46168 = G__46220;
chunk__45669_46169 = G__46221;
count__45670_46170 = G__46222;
i__45671_46171 = G__46223;
continue;
} else {
var vec__45733_46224 = cljs.core.first(seq__45668_46218__$1);
var column_46225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45733_46224,(0),null);
var column_info_46226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45733_46224,(1),null);
var seq__45736_46227 = cljs.core.seq(column_info_46226);
var chunk__45737_46228 = null;
var count__45738_46229 = (0);
var i__45739_46230 = (0);
while(true){
if((i__45739_46230 < count__45738_46229)){
var map__45744_46231 = chunk__45737_46228.cljs$core$IIndexed$_nth$arity$2(null,i__45739_46230);
var map__45744_46232__$1 = (((((!((map__45744_46231 == null))))?(((((map__45744_46231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45744_46231.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45744_46231):map__45744_46231);
var gline_46233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45744_46232__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45744_46232__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45744_46232__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46233], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45736_46227,chunk__45737_46228,count__45738_46229,i__45739_46230,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45744_46231,map__45744_46232__$1,gline_46233,gcol_46234,name_46235,vec__45733_46224,column_46225,column_info_46226,seq__45668_46218__$1,temp__5735__auto___46217__$1,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46234], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46166,new cljs.core.Keyword(null,"col","col",-1959363084),column_46225,new cljs.core.Keyword(null,"name","name",1843675177),name_46235], null));
});})(seq__45736_46227,chunk__45737_46228,count__45738_46229,i__45739_46230,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45744_46231,map__45744_46232__$1,gline_46233,gcol_46234,name_46235,vec__45733_46224,column_46225,column_info_46226,seq__45668_46218__$1,temp__5735__auto___46217__$1,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted))
,cljs.core.sorted_map()));


var G__46239 = seq__45736_46227;
var G__46240 = chunk__45737_46228;
var G__46241 = count__45738_46229;
var G__46242 = (i__45739_46230 + (1));
seq__45736_46227 = G__46239;
chunk__45737_46228 = G__46240;
count__45738_46229 = G__46241;
i__45739_46230 = G__46242;
continue;
} else {
var temp__5735__auto___46243__$2 = cljs.core.seq(seq__45736_46227);
if(temp__5735__auto___46243__$2){
var seq__45736_46244__$1 = temp__5735__auto___46243__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45736_46244__$1)){
var c__4609__auto___46247 = cljs.core.chunk_first(seq__45736_46244__$1);
var G__46248 = cljs.core.chunk_rest(seq__45736_46244__$1);
var G__46249 = c__4609__auto___46247;
var G__46250 = cljs.core.count(c__4609__auto___46247);
var G__46251 = (0);
seq__45736_46227 = G__46248;
chunk__45737_46228 = G__46249;
count__45738_46229 = G__46250;
i__45739_46230 = G__46251;
continue;
} else {
var map__45747_46252 = cljs.core.first(seq__45736_46244__$1);
var map__45747_46253__$1 = (((((!((map__45747_46252 == null))))?(((((map__45747_46252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45747_46252.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45747_46252):map__45747_46252);
var gline_46254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45747_46253__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45747_46253__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45747_46253__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46254], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45736_46227,chunk__45737_46228,count__45738_46229,i__45739_46230,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45747_46252,map__45747_46253__$1,gline_46254,gcol_46255,name_46256,seq__45736_46244__$1,temp__5735__auto___46243__$2,vec__45733_46224,column_46225,column_info_46226,seq__45668_46218__$1,temp__5735__auto___46217__$1,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46255], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46166,new cljs.core.Keyword(null,"col","col",-1959363084),column_46225,new cljs.core.Keyword(null,"name","name",1843675177),name_46256], null));
});})(seq__45736_46227,chunk__45737_46228,count__45738_46229,i__45739_46230,seq__45668_46168,chunk__45669_46169,count__45670_46170,i__45671_46171,seq__45282_46036,chunk__45283_46037,count__45284_46038,i__45285_46039,map__45747_46252,map__45747_46253__$1,gline_46254,gcol_46255,name_46256,seq__45736_46244__$1,temp__5735__auto___46243__$2,vec__45733_46224,column_46225,column_info_46226,seq__45668_46218__$1,temp__5735__auto___46217__$1,vec__45665_46165,line_46166,columns_46167,seq__45282_46159__$1,temp__5735__auto___46158,inverted))
,cljs.core.sorted_map()));


var G__46259 = cljs.core.next(seq__45736_46244__$1);
var G__46260 = null;
var G__46261 = (0);
var G__46262 = (0);
seq__45736_46227 = G__46259;
chunk__45737_46228 = G__46260;
count__45738_46229 = G__46261;
i__45739_46230 = G__46262;
continue;
}
} else {
}
}
break;
}


var G__46265 = cljs.core.next(seq__45668_46218__$1);
var G__46266 = null;
var G__46267 = (0);
var G__46268 = (0);
seq__45668_46168 = G__46265;
chunk__45669_46169 = G__46266;
count__45670_46170 = G__46267;
i__45671_46171 = G__46268;
continue;
}
} else {
}
}
break;
}


var G__46269 = cljs.core.next(seq__45282_46159__$1);
var G__46270 = null;
var G__46271 = (0);
var G__46272 = (0);
seq__45282_46036 = G__46269;
chunk__45283_46037 = G__46270;
count__45284_46038 = G__46271;
i__45285_46039 = G__46272;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
