goog.provide('widget.combo');
goog.require('cljs.core');
goog.require('taoensso.timbre');
widget.combo.on_combo_changed_ = (function widget$combo$on_combo_changed_(value_atom,_,action,event){
var value = event.target.value;
cljs.core.reset_BANG_(value_atom,value);

return (action.cljs$core$IFn$_invoke$arity$1 ? action.cljs$core$IFn$_invoke$arity$1(value) : action.call(null,value));
});
/**
 * combobox that is bound to an external atom.
 *    list is supplied
 */
widget.combo.list_selector = (function widget$combo$list_selector(var_args){
var G__55393 = arguments.length;
switch (G__55393) {
case 3:
return widget.combo.list_selector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return widget.combo.list_selector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(widget.combo.list_selector.cljs$core$IFn$_invoke$arity$3 = (function (value_atom,list,action){
var keys = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__55390_SHARP_){
return widget.combo.on_combo_changed_(value_atom,list,action,p1__55390_SHARP_);
})], null);
var keys__$1 = (((cljs.core.deref(value_atom) == null))?keys:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(keys,new cljs.core.Keyword(null,"value","value",305978217),cljs.core.deref(value_atom)));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),keys__$1,new cljs.core.Keyword(null,"value","value",305978217),(cljs.core.truth_(list)?cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,item){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),idx,new cljs.core.Keyword(null,"value","value",305978217),item], null),item], null);
}),list):null)], null);
}));

(widget.combo.list_selector.cljs$core$IFn$_invoke$arity$2 = (function (value_atom,list){
return widget.combo.list_selector.cljs$core$IFn$_invoke$arity$3(value_atom,list,(function (p1__55391_SHARP_){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"widget.combo","/tmp/form-init7190841119320184072.clj",24,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["list selected: ",p1__55391_SHARP_], null);
}),null)),null,-741672482);
}));
}));

(widget.combo.list_selector.cljs$lang$maxFixedArity = 3);

widget.combo.assoc_selected = (function widget$combo$assoc_selected(props,current_val,val){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_val,val)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(props,new cljs.core.Keyword(null,"selected","selected",574897764),true);
} else {
return props;
}
});
widget.combo.go_next = (function widget$combo$go_next(value_atom,list,action){
var new_index = (list.indexOf(cljs.core.deref(value_atom)) + (1));
var new_index__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_index,cljs.core.count(list)))?(0):new_index);
var new_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(list,new_index__$1);
cljs.core.reset_BANG_(value_atom,new_value);

var G__55394 = cljs.core.deref(value_atom);
return (action.cljs$core$IFn$_invoke$arity$1 ? action.cljs$core$IFn$_invoke$arity$1(G__55394) : action.call(null,G__55394));
});
widget.combo.go_prior = (function widget$combo$go_prior(value_atom,list,action){
var new_index = (list.indexOf(cljs.core.deref(value_atom)) - (1));
var new_index__$1 = (((new_index < (0)))?(cljs.core.count(list) - (1)):new_index);
var new_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(list,new_index__$1);
cljs.core.reset_BANG_(value_atom,new_value);

var G__55395 = cljs.core.deref(value_atom);
return (action.cljs$core$IFn$_invoke$arity$1 ? action.cljs$core$IFn$_invoke$arity$1(G__55395) : action.call(null,G__55395));
});

//# sourceMappingURL=widget.combo.js.map
