goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__10084 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__10085 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__10085);

try{try{var seq__10086 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__10087 = null;
var count__10088 = (0);
var i__10089 = (0);
while(true){
if((i__10089 < count__10088)){
var vec__10101 = chunk__10087.cljs$core$IIndexed$_nth$arity$2(null,i__10089);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10101,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10101,(1),null);
var temp__5733__auto___10195 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___10195)){
var effect_fn_10197 = temp__5733__auto___10195;
(effect_fn_10197.cljs$core$IFn$_invoke$arity$1 ? effect_fn_10197.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_10197.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__10199 = seq__10086;
var G__10200 = chunk__10087;
var G__10201 = count__10088;
var G__10202 = (i__10089 + (1));
seq__10086 = G__10199;
chunk__10087 = G__10200;
count__10088 = G__10201;
i__10089 = G__10202;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10086);
if(temp__5735__auto__){
var seq__10086__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10086__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__10086__$1);
var G__10204 = cljs.core.chunk_rest(seq__10086__$1);
var G__10205 = c__4609__auto__;
var G__10206 = cljs.core.count(c__4609__auto__);
var G__10207 = (0);
seq__10086 = G__10204;
chunk__10087 = G__10205;
count__10088 = G__10206;
i__10089 = G__10207;
continue;
} else {
var vec__10108 = cljs.core.first(seq__10086__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10108,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10108,(1),null);
var temp__5733__auto___10208 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___10208)){
var effect_fn_10209 = temp__5733__auto___10208;
(effect_fn_10209.cljs$core$IFn$_invoke$arity$1 ? effect_fn_10209.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_10209.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__10210 = cljs.core.next(seq__10086__$1);
var G__10211 = null;
var G__10212 = (0);
var G__10213 = (0);
seq__10086 = G__10210;
chunk__10087 = G__10211;
count__10088 = G__10212;
i__10089 = G__10213;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__857__auto___10214 = re_frame.interop.now();
var duration__858__auto___10215 = (end__857__auto___10214 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__858__auto___10215,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__857__auto___10214);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__10084);
}} else {
var seq__10111 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__10112 = null;
var count__10113 = (0);
var i__10114 = (0);
while(true){
if((i__10114 < count__10113)){
var vec__10127 = chunk__10112.cljs$core$IIndexed$_nth$arity$2(null,i__10114);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10127,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10127,(1),null);
var temp__5733__auto___10219 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___10219)){
var effect_fn_10220 = temp__5733__auto___10219;
(effect_fn_10220.cljs$core$IFn$_invoke$arity$1 ? effect_fn_10220.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_10220.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__10221 = seq__10111;
var G__10222 = chunk__10112;
var G__10223 = count__10113;
var G__10224 = (i__10114 + (1));
seq__10111 = G__10221;
chunk__10112 = G__10222;
count__10113 = G__10223;
i__10114 = G__10224;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10111);
if(temp__5735__auto__){
var seq__10111__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10111__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__10111__$1);
var G__10227 = cljs.core.chunk_rest(seq__10111__$1);
var G__10228 = c__4609__auto__;
var G__10229 = cljs.core.count(c__4609__auto__);
var G__10230 = (0);
seq__10111 = G__10227;
chunk__10112 = G__10228;
count__10113 = G__10229;
i__10114 = G__10230;
continue;
} else {
var vec__10131 = cljs.core.first(seq__10111__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10131,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10131,(1),null);
var temp__5733__auto___10232 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___10232)){
var effect_fn_10233 = temp__5733__auto___10232;
(effect_fn_10233.cljs$core$IFn$_invoke$arity$1 ? effect_fn_10233.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_10233.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__10234 = cljs.core.next(seq__10111__$1);
var G__10235 = null;
var G__10236 = (0);
var G__10237 = (0);
seq__10111 = G__10234;
chunk__10112 = G__10235;
count__10113 = G__10236;
i__10114 = G__10237;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__10137 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__10138 = null;
var count__10139 = (0);
var i__10140 = (0);
while(true){
if((i__10140 < count__10139)){
var map__10149 = chunk__10138.cljs$core$IIndexed$_nth$arity$2(null,i__10140);
var map__10149__$1 = (((((!((map__10149 == null))))?(((((map__10149.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10149.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10149):map__10149);
var effect = map__10149__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10149__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10149__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__10137,chunk__10138,count__10139,i__10140,map__10149,map__10149__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__10137,chunk__10138,count__10139,i__10140,map__10149,map__10149__$1,effect,ms,dispatch))
,ms);
}


var G__10241 = seq__10137;
var G__10242 = chunk__10138;
var G__10243 = count__10139;
var G__10244 = (i__10140 + (1));
seq__10137 = G__10241;
chunk__10138 = G__10242;
count__10139 = G__10243;
i__10140 = G__10244;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10137);
if(temp__5735__auto__){
var seq__10137__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10137__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__10137__$1);
var G__10246 = cljs.core.chunk_rest(seq__10137__$1);
var G__10247 = c__4609__auto__;
var G__10248 = cljs.core.count(c__4609__auto__);
var G__10249 = (0);
seq__10137 = G__10246;
chunk__10138 = G__10247;
count__10139 = G__10248;
i__10140 = G__10249;
continue;
} else {
var map__10155 = cljs.core.first(seq__10137__$1);
var map__10155__$1 = (((((!((map__10155 == null))))?(((((map__10155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10155.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10155):map__10155);
var effect = map__10155__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__10137,chunk__10138,count__10139,i__10140,map__10155,map__10155__$1,effect,ms,dispatch,seq__10137__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__10137,chunk__10138,count__10139,i__10140,map__10155,map__10155__$1,effect,ms,dispatch,seq__10137__$1,temp__5735__auto__))
,ms);
}


var G__10251 = cljs.core.next(seq__10137__$1);
var G__10252 = null;
var G__10253 = (0);
var G__10254 = (0);
seq__10137 = G__10251;
chunk__10138 = G__10252;
count__10139 = G__10253;
i__10140 = G__10254;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__10163 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__10164 = null;
var count__10165 = (0);
var i__10166 = (0);
while(true){
if((i__10166 < count__10165)){
var event = chunk__10164.cljs$core$IIndexed$_nth$arity$2(null,i__10166);
re_frame.router.dispatch(event);


var G__10255 = seq__10163;
var G__10256 = chunk__10164;
var G__10257 = count__10165;
var G__10258 = (i__10166 + (1));
seq__10163 = G__10255;
chunk__10164 = G__10256;
count__10165 = G__10257;
i__10166 = G__10258;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10163);
if(temp__5735__auto__){
var seq__10163__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10163__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__10163__$1);
var G__10260 = cljs.core.chunk_rest(seq__10163__$1);
var G__10261 = c__4609__auto__;
var G__10262 = cljs.core.count(c__4609__auto__);
var G__10263 = (0);
seq__10163 = G__10260;
chunk__10164 = G__10261;
count__10165 = G__10262;
i__10166 = G__10263;
continue;
} else {
var event = cljs.core.first(seq__10163__$1);
re_frame.router.dispatch(event);


var G__10265 = cljs.core.next(seq__10163__$1);
var G__10266 = null;
var G__10267 = (0);
var G__10268 = (0);
seq__10163 = G__10265;
chunk__10164 = G__10266;
count__10165 = G__10267;
i__10166 = G__10268;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__10170 = cljs.core.seq(value);
var chunk__10171 = null;
var count__10172 = (0);
var i__10173 = (0);
while(true){
if((i__10173 < count__10172)){
var event = chunk__10171.cljs$core$IIndexed$_nth$arity$2(null,i__10173);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__10274 = seq__10170;
var G__10275 = chunk__10171;
var G__10276 = count__10172;
var G__10278 = (i__10173 + (1));
seq__10170 = G__10274;
chunk__10171 = G__10275;
count__10172 = G__10276;
i__10173 = G__10278;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10170);
if(temp__5735__auto__){
var seq__10170__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10170__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__10170__$1);
var G__10284 = cljs.core.chunk_rest(seq__10170__$1);
var G__10285 = c__4609__auto__;
var G__10286 = cljs.core.count(c__4609__auto__);
var G__10287 = (0);
seq__10170 = G__10284;
chunk__10171 = G__10285;
count__10172 = G__10286;
i__10173 = G__10287;
continue;
} else {
var event = cljs.core.first(seq__10170__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__10292 = cljs.core.next(seq__10170__$1);
var G__10293 = null;
var G__10294 = (0);
var G__10295 = (0);
seq__10170 = G__10292;
chunk__10171 = G__10293;
count__10172 = G__10294;
i__10173 = G__10295;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
