goog.provide('pinkgorilla.kernel.guard');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
/**
 * each time the watchdog has a chance to run, this var is set with the current time
 */
pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = (0);
pinkgorilla.kernel.guard.min_max_eval_duration = (3000);
/**
 * The number of msec for the watchdog period.
 *          This value has to be much lower than min-max-eval-duration.
 */
pinkgorilla.kernel.guard.watchdog_period = (pinkgorilla.kernel.guard.min_max_eval_duration / (10));
pinkgorilla.kernel.guard.runonce = (function pinkgorilla$kernel$guard$runonce(f){
var ran = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return (function() { 
var G__23640__delegate = function (args){
if(cljs.core.truth_(cljs.core.deref(ran))){
return null;
} else {
cljs.core.reset_BANG_(ran,true);

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}
};
var G__23640 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23641__i = 0, G__23641__a = new Array(arguments.length -  0);
while (G__23641__i < G__23641__a.length) {G__23641__a[G__23641__i] = arguments[G__23641__i + 0]; ++G__23641__i;}
  args = new cljs.core.IndexedSeq(G__23641__a,0,null);
} 
return G__23640__delegate.call(this,args);};
G__23640.cljs$lang$maxFixedArity = 0;
G__23640.cljs$lang$applyTo = (function (arglist__23642){
var args = cljs.core.seq(arglist__23642);
return G__23640__delegate(args);
});
G__23640.cljs$core$IFn$_invoke$arity$variadic = G__23640__delegate;
return G__23640;
})()
;
});
pinkgorilla.kernel.guard.tick = (function pinkgorilla$kernel$guard$tick(){
return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
});
/**
 * reset the *watchdog-tick* to the current time once in a while
 */
pinkgorilla.kernel.guard.run_watchdog_STAR_ = (function pinkgorilla$kernel$guard$run_watchdog_STAR_(){
pinkgorilla.kernel.guard.tick();

var c__13675__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_23538){
var state_val_23539 = (state_23538[(1)]);
if((state_val_23539 === (1))){
var state_23538__$1 = state_23538;
var statearr_23543_23644 = state_23538__$1;
(statearr_23543_23644[(2)] = null);

(statearr_23543_23644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23539 === (2))){
var inst_23530 = cljs.core.async.timeout(pinkgorilla.kernel.guard.watchdog_period);
var state_23538__$1 = state_23538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23538__$1,(4),inst_23530);
} else {
if((state_val_23539 === (3))){
var inst_23536 = (state_23538[(2)]);
var state_23538__$1 = state_23538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23538__$1,inst_23536);
} else {
if((state_val_23539 === (4))){
var inst_23532 = (state_23538[(2)]);
var inst_23533 = pinkgorilla.kernel.guard.tick();
var state_23538__$1 = (function (){var statearr_23559 = state_23538;
(statearr_23559[(7)] = inst_23533);

(statearr_23559[(8)] = inst_23532);

return statearr_23559;
})();
var statearr_23562_23648 = state_23538__$1;
(statearr_23562_23648[(2)] = null);

(statearr_23562_23648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto__ = null;
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_23572 = [null,null,null,null,null,null,null,null,null];
(statearr_23572[(0)] = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto__);

(statearr_23572[(1)] = (1));

return statearr_23572;
});
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto____1 = (function (state_23538){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_23538);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e23578){if((e23578 instanceof Object)){
var ex__13560__auto__ = e23578;
var statearr_23584_23658 = state_23538;
(statearr_23584_23658[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23538);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23578;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23663 = state_23538;
state_23538 = G__23663;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto__ = function(state_23538){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto____1.call(this,state_23538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto____0;
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto____1;
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_23591 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_23591[(6)] = c__13675__auto__);

return statearr_23591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));

return c__13675__auto__;
});
pinkgorilla.kernel.guard.run_watchdog_once = pinkgorilla.kernel.guard.runonce(pinkgorilla.kernel.guard.run_watchdog_STAR_);
pinkgorilla.kernel.guard.watchdog = (function pinkgorilla$kernel$guard$watchdog(){
pinkgorilla.kernel.guard.tick();

return (pinkgorilla.kernel.guard.run_watchdog_once.cljs$core$IFn$_invoke$arity$0 ? pinkgorilla.kernel.guard.run_watchdog_once.cljs$core$IFn$_invoke$arity$0() : pinkgorilla.kernel.guard.run_watchdog_once.call(null));
});
pinkgorilla.kernel.guard.guard = (function pinkgorilla$kernel$guard$guard(max_eval_duration){
if(((cljs.core.system_time() - pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_) > max_eval_duration)){
if(cljs.core.truth_(confirm(["A KLIPSE snippet has been running for more than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration)," milliseconds. This is often because of a long-running computation or infinite loop. Would you like to interrupt the snippet? \n OK to interrupt the evaluation.\n Cancel to continue."].join('')))){
throw "Infinite Loop";
} else {
}

return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
} else {
return null;
}
});
goog.exportSymbol('pinkgorilla.kernel.guard.guard', pinkgorilla.kernel.guard.guard);
/**
 * same as cljs.compiler/emits with insertion of a `guard()` call before if and recur (emitted as continue) statement.
 * 
 *   Limitations:
 *   1. It doesn't prevent infinite loop in imported code e.g. (reduce + (range)
 *   
 */
pinkgorilla.kernel.guard.my_emits = (function pinkgorilla$kernel$guard$my_emits(var_args){
var args__4795__auto__ = [];
var len__4789__auto___23678 = arguments.length;
var i__4790__auto___23683 = (0);
while(true){
if((i__4790__auto___23683 < len__4789__auto___23678)){
args__4795__auto__.push((arguments[i__4790__auto___23683]));

var G__23684 = (i__4790__auto___23683 + (1));
i__4790__auto___23683 = G__23684;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic = (function (max_eval_duration,xs){
if(cljs.core.truth_(((typeof cljs.core.first(xs) === 'string')?cljs.core.re_matches(/^(if|continue).*/,cljs.core.first(xs)):false))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["klipse_clj.lang.clojure.guard.guard(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration),");"].join('')], 0));
} else {
}

var seq__23613_23697 = cljs.core.seq(xs);
var chunk__23614_23698 = null;
var count__23615_23699 = (0);
var i__23616_23700 = (0);
while(true){
if((i__23616_23700 < count__23615_23699)){
var x_23702 = chunk__23614_23698.cljs$core$IIndexed$_nth$arity$2(null,i__23616_23700);
if((x_23702 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_23702)){
cljs.compiler.emit(x_23702);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_23702)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_23702);
} else {
if(goog.isFunction(x_23702)){
(x_23702.cljs$core$IFn$_invoke$arity$0 ? x_23702.cljs$core$IFn$_invoke$arity$0() : x_23702.call(null));
} else {
var s_23707 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_23702], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__23613_23697,chunk__23614_23698,count__23615_23699,i__23616_23700,s_23707,x_23702){
return (function (p1__23604_SHARP_){
return (p1__23604_SHARP_ + ((s_23707).length));
});})(seq__23613_23697,chunk__23614_23698,count__23615_23699,i__23616_23700,s_23707,x_23702))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_23707], 0));

}
}
}
}


var G__23708 = seq__23613_23697;
var G__23709 = chunk__23614_23698;
var G__23710 = count__23615_23699;
var G__23711 = (i__23616_23700 + (1));
seq__23613_23697 = G__23708;
chunk__23614_23698 = G__23709;
count__23615_23699 = G__23710;
i__23616_23700 = G__23711;
continue;
} else {
var temp__5735__auto___23714 = cljs.core.seq(seq__23613_23697);
if(temp__5735__auto___23714){
var seq__23613_23720__$1 = temp__5735__auto___23714;
if(cljs.core.chunked_seq_QMARK_(seq__23613_23720__$1)){
var c__4609__auto___23721 = cljs.core.chunk_first(seq__23613_23720__$1);
var G__23722 = cljs.core.chunk_rest(seq__23613_23720__$1);
var G__23723 = c__4609__auto___23721;
var G__23724 = cljs.core.count(c__4609__auto___23721);
var G__23725 = (0);
seq__23613_23697 = G__23722;
chunk__23614_23698 = G__23723;
count__23615_23699 = G__23724;
i__23616_23700 = G__23725;
continue;
} else {
var x_23726 = cljs.core.first(seq__23613_23720__$1);
if((x_23726 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_23726)){
cljs.compiler.emit(x_23726);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_23726)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_23726);
} else {
if(goog.isFunction(x_23726)){
(x_23726.cljs$core$IFn$_invoke$arity$0 ? x_23726.cljs$core$IFn$_invoke$arity$0() : x_23726.call(null));
} else {
var s_23727 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_23726], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__23613_23697,chunk__23614_23698,count__23615_23699,i__23616_23700,s_23727,x_23726,seq__23613_23720__$1,temp__5735__auto___23714){
return (function (p1__23604_SHARP_){
return (p1__23604_SHARP_ + ((s_23727).length));
});})(seq__23613_23697,chunk__23614_23698,count__23615_23699,i__23616_23700,s_23727,x_23726,seq__23613_23720__$1,temp__5735__auto___23714))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_23727], 0));

}
}
}
}


var G__23729 = cljs.core.next(seq__23613_23720__$1);
var G__23730 = null;
var G__23731 = (0);
var G__23732 = (0);
seq__23613_23697 = G__23729;
chunk__23614_23698 = G__23730;
count__23615_23699 = G__23731;
i__23616_23700 = G__23732;
continue;
}
} else {
}
}
break;
}

return null;
}));

(pinkgorilla.kernel.guard.my_emits.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.kernel.guard.my_emits.cljs$lang$applyTo = (function (seq23606){
var G__23607 = cljs.core.first(seq23606);
var seq23606__$1 = cljs.core.next(seq23606);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23607,seq23606__$1);
}));


//# sourceMappingURL=pinkgorilla.kernel.guard.js.map
