goog.provide('pinkgorilla.explore.form_helpers');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('reagent.core');
goog.require('clojure.string');
goog.require('cljs_time.format');
goog.require('cljs_time.core');
goog.require('pinkgorilla.explore.utils');
pinkgorilla.explore.form_helpers.form_path = (function pinkgorilla$explore$form_helpers$form_path(partial_path){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350)], null),partial_path);
});
/**
 * Show a progress indicator when a form is submitted
 */
pinkgorilla.explore.form_helpers.progress_indicator = (function pinkgorilla$explore$form_helpers$progress_indicator(form){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(form));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(state,new cljs.core.Keyword(null,"submitting","submitting",472950900)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.submission-progress.visible","span.submission-progress.visible",845331746),"submitting..."], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(state,new cljs.core.Keyword(null,"success","success",1890645906)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.submission-progress.visible","span.submission-progress.visible",845331746),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"fa fa-check-circle"], null)], null)," success"], null):null))], null);
});
pinkgorilla.explore.form_helpers.label_text = (function pinkgorilla$explore$form_helpers$label_text(attr){
return pinkgorilla.explore.utils.hkey_text(attr);
});
pinkgorilla.explore.form_helpers.dispatch_change = (function pinkgorilla$explore$form_helpers$dispatch_change(dk,attr_name,val){
var G__19821 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"edit-field","edit-field",839429103),cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(dk,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([attr_name], 0)),val], null);
return (re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__19821) : re_frame.core.dispatch_sync.call(null,G__19821));
});
pinkgorilla.explore.form_helpers.handle_change_STAR_ = (function pinkgorilla$explore$form_helpers$handle_change_STAR_(v,dk,attr_name){
return pinkgorilla.explore.form_helpers.dispatch_change(dk,attr_name,v);
});
/**
 * Meant for input fields, where your keystrokes should update the
 *   field
 */
pinkgorilla.explore.form_helpers.handle_change = (function pinkgorilla$explore$form_helpers$handle_change(e,dk,attr_name){
return pinkgorilla.explore.form_helpers.handle_change_STAR_(e.target.value,dk,attr_name);
});
pinkgorilla.explore.form_helpers.label_for = (function pinkgorilla$explore$form_helpers$label_for(form_id,attr_name){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_id),cljs.core.name(attr_name)].join('');
});
pinkgorilla.explore.form_helpers.input_opts = (function pinkgorilla$explore$form_helpers$input_opts(p__19847){
var map__19848 = p__19847;
var map__19848__$1 = (((((!((map__19848 == null))))?(((((map__19848.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19848.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19848):map__19848);
var opts = map__19848__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19848__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19848__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19848__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19848__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19848__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),attr_name], null)),new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.explore.form_helpers.label_for(form_id,attr_name),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__19844_SHARP_){
return pinkgorilla.explore.form_helpers.handle_change(p1__19844_SHARP_,dk,attr_name);
}),new cljs.core.Keyword(null,"class","class",-2030961996),["input ",cljs.core.name(attr_name)].join('')], null)], 0));
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.explore !== 'undefined') && (typeof pinkgorilla.explore.form_helpers !== 'undefined') && (typeof pinkgorilla.explore.form_helpers.input !== 'undefined')){
} else {
pinkgorilla.explore.form_helpers.input = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__19860 = cljs.core.get_global_hierarchy;
return (fexpr__19860.cljs$core$IFn$_invoke$arity$0 ? fexpr__19860.cljs$core$IFn$_invoke$arity$0() : fexpr__19860.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("pinkgorilla.explore.form-helpers","input"),(function (type,_){
return type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
pinkgorilla.explore.form_helpers.input.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"textarea","textarea",-650375824),(function (type,opts){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),pinkgorilla.explore.form_helpers.input_opts(opts)], null);
}));
pinkgorilla.explore.form_helpers.input.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"select","select",1147833503),(function (type,p__19875){
var map__19876 = p__19875;
var map__19876__$1 = (((((!((map__19876 == null))))?(((((map__19876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19876):map__19876);
var opts = map__19876__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19876__$1,new cljs.core.Keyword(null,"options","options",99638489));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),pinkgorilla.explore.form_helpers.input_opts(opts),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),x], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null));
}),options)], null);
}));
pinkgorilla.explore.form_helpers.input.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"checkbox","checkbox",1612615655),(function (type,p__19888){
var map__19889 = p__19888;
var map__19889__$1 = (((((!((map__19889 == null))))?(((((map__19889.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19889.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19889):map__19889);
var opts = map__19889__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19889__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19889__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19889__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19889__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19889__$1,new cljs.core.Keyword(null,"options","options",99638489));
var value = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),attr_name], null));
var opts__$1 = pinkgorilla.explore.form_helpers.input_opts(opts);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),value,new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (){
return pinkgorilla.explore.form_helpers.handle_change_STAR_(cljs.core.not(value),dk,attr_name);
})], null)], 0))], null);
}));
pinkgorilla.explore.form_helpers.toggle_set_membership = (function pinkgorilla$explore$form_helpers$toggle_set_membership(s,v){
var fexpr__19896 = (cljs.core.truth_((s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(v) : s.call(null,v)))?cljs.core.disj:cljs.core.conj);
return (fexpr__19896.cljs$core$IFn$_invoke$arity$2 ? fexpr__19896.cljs$core$IFn$_invoke$arity$2(s,v) : fexpr__19896.call(null,s,v));
});
pinkgorilla.explore.form_helpers.input.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"checkbox-set","checkbox-set",-1065172038),(function (type,p__19902){
var map__19907 = p__19902;
var map__19907__$1 = (((((!((map__19907 == null))))?(((((map__19907.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19907.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19907):map__19907);
var opts = map__19907__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19907__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19907__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19907__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19907__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19907__$1,new cljs.core.Keyword(null,"options","options",99638489));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19907__$1,new cljs.core.Keyword(null,"value","value",305978217));
var checkbox_set = (function (){var or__4185__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),attr_name], null));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
var opts__$1 = pinkgorilla.explore.form_helpers.input_opts(opts);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),(checkbox_set.cljs$core$IFn$_invoke$arity$1 ? checkbox_set.cljs$core$IFn$_invoke$arity$1(value) : checkbox_set.call(null,value)),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (){
return pinkgorilla.explore.form_helpers.handle_change_STAR_(pinkgorilla.explore.form_helpers.toggle_set_membership(checkbox_set,value),dk,attr_name);
})], null)], 0))], null);
}));
pinkgorilla.explore.form_helpers.unparse = (function pinkgorilla$explore$form_helpers$unparse(fmt,x){
if(cljs.core.truth_(x)){
return cljs_time.format.unparse(fmt,(new goog.date.DateTime(x)));
} else {
return null;
}
});
pinkgorilla.explore.form_helpers.date_fmt = new cljs.core.Keyword(null,"date","date",-1463434462).cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters);
pinkgorilla.explore.form_helpers.handle_date_change = (function pinkgorilla$explore$form_helpers$handle_date_change(e,dk,attr_name){
var v = e.target.value;
var handler = pinkgorilla.explore.utils.strk.cljs$core$IFn$_invoke$arity$variadic(dk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-edit"], 0));
if(cljs.core.empty_QMARK_(v)){
return pinkgorilla.explore.form_helpers.dispatch_change(dk,attr_name,null);
} else {
var date = cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(pinkgorilla.explore.form_helpers.date_fmt,v);
var date__$1 = (new Date(cljs_time.core.year(date),(cljs_time.core.month(date) - (1)),cljs_time.core.day(date)));
return pinkgorilla.explore.form_helpers.dispatch_change(dk,attr_name,date__$1);
}
});
pinkgorilla.explore.form_helpers.input.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"date","date",-1463434462),(function (type,p__19927){
var map__19928 = p__19927;
var map__19928__$1 = (((((!((map__19928 == null))))?(((((map__19928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19928.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19928):map__19928);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19928__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19928__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19928__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19928__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"date",new cljs.core.Keyword(null,"value","value",305978217),pinkgorilla.explore.form_helpers.unparse(pinkgorilla.explore.form_helpers.date_fmt,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),attr_name], null))),new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.explore.form_helpers.label_for(form_id,attr_name),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__19926_SHARP_){
return pinkgorilla.explore.form_helpers.handle_date_change(p1__19926_SHARP_,dk,attr_name);
})], null)], null);
}));
pinkgorilla.explore.form_helpers.input.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (type,p__19949){
var map__19950 = p__19949;
var map__19950__$1 = (((((!((map__19950 == null))))?(((((map__19950.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19950.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19950):map__19950);
var opts = map__19950__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19950__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19950__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19950__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19950__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19950__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.name(type),new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.explore.form_helpers.label_for(form_id,attr_name),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),attr_name], null)),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__19943_SHARP_){
return pinkgorilla.explore.form_helpers.handle_change(p1__19943_SHARP_,dk,attr_name);
})], null)], 0))], null);
}));
pinkgorilla.explore.form_helpers.field_row = (function pinkgorilla$explore$form_helpers$field_row(type,p__19969){
var map__19970 = p__19969;
var map__19970__$1 = (((((!((map__19970 == null))))?(((((map__19970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19970):map__19970);
var opts = map__19970__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19970__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19970__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19970__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19970__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var errors = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),attr_name], null));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(errors)?"error":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),pinkgorilla.explore.form_helpers.label_for(form_id,attr_name),new cljs.core.Keyword(null,"class","class",-2030961996),"label"], null),pinkgorilla.explore.form_helpers.label_text(attr_name),(cljs.core.truth_(required)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"required"], null),"*"], null):null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.form_helpers.input,type,opts], null),(cljs.core.truth_(errors)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"error-messages"], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null));
}),errors)], null):null)], null)], null);
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.explore !== 'undefined') && (typeof pinkgorilla.explore.form_helpers !== 'undefined') && (typeof pinkgorilla.explore.form_helpers.field !== 'undefined')){
} else {
pinkgorilla.explore.form_helpers.field = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__19993 = cljs.core.get_global_hierarchy;
return (fexpr__19993.cljs$core$IFn$_invoke$arity$0 ? fexpr__19993.cljs$core$IFn$_invoke$arity$0() : fexpr__19993.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("pinkgorilla.explore.form-helpers","field"),(function (type,_){
return type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
pinkgorilla.explore.form_helpers.field.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (type,p__20005){
var map__20006 = p__20005;
var map__20006__$1 = (((((!((map__20006 == null))))?(((((map__20006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20006.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20006):map__20006);
var opts = map__20006__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var tip = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"tip","tip",1221810860));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var no_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20006__$1,new cljs.core.Keyword(null,"no-label","no-label",-928333903));
var errors = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),attr_name], null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.field","div.field",1089355414),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[pinkgorilla.explore.utils.kabob(cljs.core.name(attr_name)),(cljs.core.truth_(errors)?"error":null)].join('')], null),(cljs.core.truth_(no_label)?null:new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),pinkgorilla.explore.form_helpers.label_for(form_id,attr_name),new cljs.core.Keyword(null,"class","class",-2030961996),"label"], null),(function (){var or__4185__auto__ = label;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return pinkgorilla.explore.form_helpers.label_text(attr_name);
}
})(),(cljs.core.truth_(required)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"required"], null),"*"], null):null)], null)),(cljs.core.truth_(tip)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tip","div.tip",118182286),tip], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,dk)))," ",cljs.core.name(attr_name)].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.form_helpers.input,type,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"tip","tip",1221810860))], null),(cljs.core.truth_(errors)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"error-messages"], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null));
}),errors)], null):null)], null)], null);
}));
pinkgorilla.explore.form_helpers.field.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"checkbox","checkbox",1612615655),(function (type,p__20020){
var map__20021 = p__20020;
var map__20021__$1 = (((((!((map__20021 == null))))?(((((map__20021.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20021.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20021):map__20021);
var opts = map__20021__$1;
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var tip = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"tip","tip",1221810860));
var dk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"dk","dk",1345391303));
var attr_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779));
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var no_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20021__$1,new cljs.core.Keyword(null,"no-label","no-label",-928333903));
var errors = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),attr_name], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.field","div.field",1089355414),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[pinkgorilla.explore.utils.kabob(cljs.core.name(attr_name)),(cljs.core.truth_(errors)?"error":null)].join('')], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,dk)))," ",cljs.core.name(attr_name)].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.form_helpers.input,type,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"tip","tip",1221810860))], null),(cljs.core.truth_(no_label)?null:new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),pinkgorilla.explore.form_helpers.label_for(form_id,attr_name),new cljs.core.Keyword(null,"class","class",-2030961996),"label"], null),(function (){var or__4185__auto__ = label;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return pinkgorilla.explore.form_helpers.label_text(attr_name);
}
})(),(cljs.core.truth_(required)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"required"], null),"*"], null):null)], null)),(cljs.core.truth_(tip)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tip","div.tip",118182286),tip], null):null),(cljs.core.truth_(errors)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"error-messages"], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null));
}),errors)], null):null)], null)], null);
}));
/**
 * creates a function that builds inputs
 */
pinkgorilla.explore.form_helpers.builder = (function pinkgorilla$explore$form_helpers$builder(path){
var path__$1 = pinkgorilla.explore.form_helpers.form_path(path);
var data = (function (){var G__20034 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587)], null),path__$1);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__20034) : re_frame.core.subscribe.call(null,G__20034));
})();
return (function() { 
var G__20248__delegate = function (type,attr_name,p__20036){
var map__20037 = p__20036;
var map__20037__$1 = (((((!((map__20037 == null))))?(((((map__20037.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20037.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20037):map__20037);
var opts = map__20037__$1;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.explore.form_helpers.field,type,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"dk","dk",1345391303),path__$1,new cljs.core.Keyword(null,"attr-name","attr-name",-1772640779),attr_name], null),opts], 0))], null);
};
var G__20248 = function (type,attr_name,var_args){
var p__20036 = null;
if (arguments.length > 2) {
var G__20261__i = 0, G__20261__a = new Array(arguments.length -  2);
while (G__20261__i < G__20261__a.length) {G__20261__a[G__20261__i] = arguments[G__20261__i + 2]; ++G__20261__i;}
  p__20036 = new cljs.core.IndexedSeq(G__20261__a,0,null);
} 
return G__20248__delegate.call(this,type,attr_name,p__20036);};
G__20248.cljs$lang$maxFixedArity = 2;
G__20248.cljs$lang$applyTo = (function (arglist__20262){
var type = cljs.core.first(arglist__20262);
arglist__20262 = cljs.core.next(arglist__20262);
var attr_name = cljs.core.first(arglist__20262);
var p__20036 = cljs.core.rest(arglist__20262);
return G__20248__delegate(type,attr_name,p__20036);
});
G__20248.cljs$core$IFn$_invoke$arity$variadic = G__20248__delegate;
return G__20248;
})()
;
});
pinkgorilla.explore.form_helpers.on_submit = (function pinkgorilla$explore$form_helpers$on_submit(form_path){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),pinkgorilla.explore.utils.prevent_default((function (){
var G__20039 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"submit-form","submit-form",-1882310674),form_path], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__20039) : re_frame.core.dispatch.call(null,G__20039));
}))], null);
});

//# sourceMappingURL=pinkgorilla.explore.form_helpers.js.map
