goog.provide('pinkgorilla.editor.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('cljsjs.codemirror');
var module$node_modules$parinfer_codemirror$parinfer_codemirror=shadow.js.require("module$node_modules$parinfer_codemirror$parinfer_codemirror", {});
var module$node_modules$codemirror$addon$edit$closebrackets=shadow.js.require("module$node_modules$codemirror$addon$edit$closebrackets", {});
var module$node_modules$codemirror$addon$edit$matchbrackets=shadow.js.require("module$node_modules$codemirror$addon$edit$matchbrackets", {});
var module$node_modules$codemirror$addon$runmode$runmode=shadow.js.require("module$node_modules$codemirror$addon$runmode$runmode", {});
var module$node_modules$codemirror$addon$runmode$colorize=shadow.js.require("module$node_modules$codemirror$addon$runmode$colorize", {});
var module$node_modules$codemirror$addon$hint$show_hint=shadow.js.require("module$node_modules$codemirror$addon$hint$show_hint", {});
var module$node_modules$codemirror$mode$clojure$clojure=shadow.js.require("module$node_modules$codemirror$mode$clojure$clojure", {});
var module$node_modules$codemirror$mode$markdown$markdown=shadow.js.require("module$node_modules$codemirror$mode$markdown$markdown", {});
goog.require('re_frame.core');
goog.require('pinkgorilla.kernel.core');
goog.require('pinkgorilla.editor.editor_support');
goog.require('taoensso.timbre');
/**
 * Initialize CodeMirror globally
 */
pinkgorilla.editor.core.init_cm_globally_BANG_ = (function pinkgorilla$editor$core$init_cm_globally_BANG_(){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.editor.core","/tmp/form-init5318300759512683746.clj",42,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Initialize Code Mirror globally"], null);
}),null)),null,1071694140);

var cm_commands = CodeMirror.commands;
var cm_keymap = CodeMirror.keyMap;
(cm_commands["doNothing"] = (function (){
return cljs.core.List.EMPTY;
}));

(cm_keymap["gorilla"] = ({"Shift-Enter": "doNothing", "Shift-Ctrl-Enter": "doNothing", "Shift-Alt-Enter": "doNothing", "fallthrough": "default"}));

return (cm_keymap["macDefault"]["fallthrough"] = "basic");
});
/**
 * Called before any change is applied to the editor.
 *   @param {CodeMirror} cm
 */
pinkgorilla.editor.core.parinfer_before_change = (function pinkgorilla$editor$core$parinfer_before_change(cm,change){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("setValue",change.origin)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cm.getValue(),clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",change.text))))){
return change.cancel();
} else {
return null;
}
});
/**
 * Called after any change is applied to the editor.
 *   @param {CodeMirror} cm
 */
pinkgorilla.editor.core.parinfer_on_change = (function pinkgorilla$editor$core$parinfer_on_change(cm,change){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("setValue",change.origin)){
pinkgorilla.editor.editor_support.fix_text_BANG_.cljs$core$IFn$_invoke$arity$variadic(cm,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"change","change",-1163046502),change], 0));

return pinkgorilla.editor.editor_support.set_frame_updated_BANG_(cm,true);
} else {
return null;
}
});
/**
 * Called after the cursor moves in the editor.
 *   @param {CodeMirror} cm
 */
pinkgorilla.editor.core.parinfer_on_cursor_activity = (function pinkgorilla$editor$core$parinfer_on_cursor_activity(cm){
if(cljs.core.truth_(pinkgorilla.editor.editor_support.frame_updated_QMARK_(cm))){
} else {
pinkgorilla.editor.editor_support.fix_text_BANG_(cm);
}

return pinkgorilla.editor.editor_support.set_frame_updated_BANG_(cm,false);
});
/**
 * Indent selection or insert two spaces when tab is pressed.
 *   from: https://github.com/codemirror/CodeMirror/issues/988#issuecomment-14921785
 *   @param {CodeMirror} cm
 */
pinkgorilla.editor.core.parinfer_on_tab = (function pinkgorilla$editor$core$parinfer_on_tab(cm){
if(cljs.core.truth_(cm.somethingSelected())){
return cm.indentSelection();
} else {
var n = cm.getOption("indentUnit");
var spaces = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n," "));
return cm.replaceSelection(spaces);
}
});
pinkgorilla.editor.core.on_mousedown = (function pinkgorilla$editor$core$on_mousedown(segment_id,cm,event){
var G__27765 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"worksheet:segment-clicked","worksheet:segment-clicked",2145563615),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27765) : re_frame.core.dispatch.call(null,G__27765));
});
/**
 * @param {CodeMirror} cm
 */
pinkgorilla.editor.core.on_change = (function pinkgorilla$editor$core$on_change(segment_id,cm,event){
var G__27769 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"segment-value-changed","segment-value-changed",1991885694),segment_id,cm.getDoc().getValue()], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27769) : re_frame.core.dispatch.call(null,G__27769));
});
/**
 * @param {CodeMirror} cm
 */
pinkgorilla.editor.core.on_keydown = (function pinkgorilla$editor$core$on_keydown(cm,event){
var keycode = event.which;
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(38))) && (event.shiftKey === false))){
var cursor = cm.getCursor();
var line = cursor.line;
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),line)) && (cljs.core.not(cm.state.completionActive)))){
var G__27780 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"worksheet:leaveBack","worksheet:leaveBack",-383853131)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27780) : re_frame.core.dispatch.call(null,G__27780));
} else {
return null;
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(37))) && (event.shiftKey === false))){
var cursor = cm.getCursor();
var line = cursor.line;
var ch = cursor.ch;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((0),line,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ch], 0))){
var G__27787 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"worksheet:leaveBack","worksheet:leaveBack",-383853131)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27787) : re_frame.core.dispatch.call(null,G__27787));
} else {
return null;
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(40))) && (event.shiftKey === false))){
var cursor = cm.getCursor();
var line = cursor.line;
var linecount = (cm.lineCount() - (1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(line,linecount)) && (cljs.core.not(cm.state.completionActive)))){
var G__27792 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"worksheet:leaveForward","worksheet:leaveForward",1590484609)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27792) : re_frame.core.dispatch.call(null,G__27792));
} else {
return null;
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(39))) && (event.shiftKey === false))){
var cursor = cm.getCursor();
var line = cursor.line;
var linecount = (cm.lineCount() - (1));
var ch = cursor.ch;
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(line,linecount)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ch,cm.getLine(line).length)))){
var G__27799 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"worksheet:leaveForward","worksheet:leaveForward",1590484609)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27799) : re_frame.core.dispatch.call(null,G__27799));
} else {
return null;
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(8))) && (cljs.core.empty_QMARK_((cm["doc"]).getValue())))){
var G__27801 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"worksheet:deleteBackspace","worksheet:deleteBackspace",-418927494)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27801) : re_frame.core.dispatch.call(null,G__27801));
} else {
return null;
}
}
}
}
}
});
pinkgorilla.editor.core.cm_default_opts_common = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"lineNumbers","lineNumbers",1374890941),false,new cljs.core.Keyword(null,"matchBrackets","matchBrackets",1256448936),true,new cljs.core.Keyword(null,"autoCloseBrackets","autoCloseBrackets",1157493311),"()[]{}\"\"",new cljs.core.Keyword(null,"lineWrapping","lineWrapping",1248501985),true,new cljs.core.Keyword(null,"keyMap","keyMap",945500512),"gorilla"], null);
pinkgorilla.editor.core.cm_default_opts = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("text","x-clojure","text/x-clojure",1162472845),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cm-opts","cm-opts",-794223420),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.editor.core.cm_default_opts_common,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mode","mode",654403691),"clojure"], null)], 0))], null),new cljs.core.Keyword("text","x-markdown","text/x-markdown",-1342571895),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cm-opts","cm-opts",-794223420),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.editor.core.cm_default_opts_common,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mode","mode",654403691),"text/x-markdown"], null)], 0))], null)], null);
pinkgorilla.editor.core.el_editor = (function pinkgorilla$editor$core$el_editor(el){
var cm_el = goog.dom.getElementByClass("CodeMirror",el);
var cm = (cljs.core.truth_(cm_el)?cm_el.CodeMirror:null);
return cm;
});
/**
 * @param {CodeMirror} cm
 */
pinkgorilla.editor.core.do_completions = (function pinkgorilla$editor$core$do_completions(cur,start,end,callback,ns,compl){
var ln = cur.line;
var completions = ({"list": cljs.core.clj__GT_js(compl), "from": CodeMirror.Pos(ln,start), "to": CodeMirror.Pos(ln,end)});
CodeMirror.on(completions,"select",(function (s){
if((!(clojure.string.starts_with_QMARK_(s,"/")))){
return pinkgorilla.kernel.core.get_completion_doc(new cljs.core.Keyword(null,"clj","clj",-660495428),s,ns,(function (docs){
if((!(clojure.string.blank_QMARK_(docs)))){
var G__27825 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"show-doc","show-doc",-454757107),docs], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27825) : re_frame.core.dispatch.call(null,G__27825));
} else {
var G__27826 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hide-doc","hide-doc",1473730389)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27826) : re_frame.core.dispatch.call(null,G__27826));
}
}));
} else {
return null;
}
}));

CodeMirror.on(completions,"close",(function (){
var G__27827 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hide-doc","hide-doc",1473730389)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27827) : re_frame.core.dispatch.call(null,G__27827));
}));

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(completions) : callback.call(null,completions));
});
pinkgorilla.editor.core.completer = (function pinkgorilla$editor$core$completer(ns,cm,callback,options){

var cur = cm.getCursor();
var token = cm.getTokenAt(cur);
var word = token.string;
var start = token.start;
var end = token.end;
var line = cur.line;
var doc = cm.getDoc().copy(false);
doc.replaceRange("__prefix__",({"line": line, "ch": start}),({"line": line, "ch": end}));

return pinkgorilla.kernel.core.get_completions(new cljs.core.Keyword(null,"clj","clj",-660495428),word,ns,doc.getValue(),cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(pinkgorilla.editor.core.do_completions,cur,start,end,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([callback,ns], 0)));
});
pinkgorilla.editor.core.complete = (function pinkgorilla$editor$core$complete(segment_id,ns){
var dom_id = cljs.core.name(segment_id);
var cm = pinkgorilla.editor.core.el_editor(goog.dom.getElement(dom_id));
return CodeMirror.showHint(cm,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.editor.core.completer,ns),({"async": true, "completeSingle": false, "alignWithWord": false}));
});
pinkgorilla.editor.core.get_token_at_cursor = (function pinkgorilla$editor$core$get_token_at_cursor(segment_id){
var dom_id = cljs.core.name(segment_id);
var cm = pinkgorilla.editor.core.el_editor(goog.dom.getElement(dom_id));
return cm.getTokenAt(cm.getCursor()).string;
});
/**
 * Create a non-parinfer editor.
 */
pinkgorilla.editor.core.create_regular_editor_BANG_ = (function pinkgorilla$editor$core$create_regular_editor_BANG_(var_args){
var G__27836 = arguments.length;
switch (G__27836) {
case 1:
return pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (element){
return pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$core$IFn$_invoke$arity$2(element,cljs.core.PersistentArrayMap.EMPTY);
}));

(pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (element,opts){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("none",element.style.display)){
return null;
} else {
var cm = CodeMirror.fromTextArea(element,cljs.core.clj__GT_js(opts));
return cm;
}
}));

(pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$lang$maxFixedArity = 2);

/**
 * Create a CodeMirror editor.
 */
pinkgorilla.editor.core.create_editor_BANG_ = (function pinkgorilla$editor$core$create_editor_BANG_(var_args){
var G__27842 = arguments.length;
switch (G__27842) {
case 1:
return pinkgorilla.editor.core.create_editor_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___27861 = arguments.length;
var i__4790__auto___27862 = (0);
while(true){
if((i__4790__auto___27862 < len__4789__auto___27861)){
args_arr__4810__auto__.push((arguments[i__4790__auto___27862]));

var G__27863 = (i__4790__auto___27862 + (1));
i__4790__auto___27862 = G__27863;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((1)),(0),null));
return pinkgorilla.editor.core.create_editor_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4811__auto__);

}
});
goog.exportSymbol('pinkgorilla.editor.core.create_editor_BANG_', pinkgorilla.editor.core.create_editor_BANG_);

(pinkgorilla.editor.core.create_editor_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (element){
return pinkgorilla.editor.core.create_editor_BANG_.cljs$core$IFn$_invoke$arity$variadic(element,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], 0));
}));

(pinkgorilla.editor.core.create_editor_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (element,p__27848){
var map__27849 = p__27848;
var map__27849__$1 = (((((!((map__27849 == null))))?(((((map__27849.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27849.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27849):map__27849);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27849__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var content_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27849__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634));
var segment_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27849__$1,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590));
var ctkw = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(content_type);
var override_opts = (ctkw.cljs$core$IFn$_invoke$arity$1 ? ctkw.cljs$core$IFn$_invoke$arity$1(opts) : ctkw.call(null,opts));
var merged_cm_opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"cm-opts","cm-opts",-794223420).cljs$core$IFn$_invoke$arity$1((ctkw.cljs$core$IFn$_invoke$arity$1 ? ctkw.cljs$core$IFn$_invoke$arity$1(pinkgorilla.editor.core.cm_default_opts) : ctkw.call(null,pinkgorilla.editor.core.cm_default_opts))),new cljs.core.Keyword(null,"cm-opts","cm-opts",-794223420).cljs$core$IFn$_invoke$arity$1(override_opts)], 0));
var other_opts = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(override_opts);
var cm = pinkgorilla.editor.core.create_regular_editor_BANG_.cljs$core$IFn$_invoke$arity$2(element,merged_cm_opts);
cm.on("keydown",pinkgorilla.editor.core.on_keydown);

cm.on("mousedown",cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.editor.core.on_mousedown,segment_id));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("clojure-parinfer",new cljs.core.Keyword(null,"mode","mode",654403691).cljs$core$IFn$_invoke$arity$1(merged_cm_opts))){
var frame_updated_27864 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var x27858_27865 = cm;
(x27858_27865.pinkgorilla$editor$editor_support$IEditor$ = cljs.core.PROTOCOL_SENTINEL);

(x27858_27865.pinkgorilla$editor$editor_support$IEditor$frame_updated_QMARK_$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.deref(frame_updated_27864);
}));

(x27858_27865.pinkgorilla$editor$editor_support$IEditor$set_frame_updated_BANG_$arity$2 = (function (this$,value){
var this$__$1 = this;
return cljs.core.reset_BANG_(frame_updated_27864,value);
}));


cm.on("change",pinkgorilla.editor.core.parinfer_on_change);

cm.on("beforeChange",pinkgorilla.editor.core.parinfer_before_change);

cm.on("cursorActivity",pinkgorilla.editor.core.parinfer_on_cursor_activity);
} else {
}

cm.on("change",cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.editor.core.on_change,segment_id));

return cm;
}));

/** @this {Function} */
(pinkgorilla.editor.core.create_editor_BANG_.cljs$lang$applyTo = (function (seq27840){
var G__27841 = cljs.core.first(seq27840);
var seq27840__$1 = cljs.core.next(seq27840);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27841,seq27840__$1);
}));

(pinkgorilla.editor.core.create_editor_BANG_.cljs$lang$maxFixedArity = (1));


//# sourceMappingURL=pinkgorilla.editor.core.js.map
