goog.provide('pinkgorilla.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('taoensso.timbre');
goog.require('secretary.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('pinkgorilla.events.google_analytics');
goog.require('pinkgorilla.subs');
goog.require('pinkgorilla.events');
goog.require('pinkgorilla.util');
goog.require('pinkgorilla.prefs');
goog.require('pinkgorilla.views');
goog.require('pinkgorilla.editor.core');
goog.require('pinkgorilla.routes');
goog.require('pinkgorilla.kernel.nrepl');
goog.require('pinkgorilla.kernel.shadowcljs');
goog.require('pinkgorilla.notifications');
pinkgorilla.core.my_before_reload_callback = (function pinkgorilla$core$my_before_reload_callback(){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.core","/tmp/form-init5318300759512683746.clj",30,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["BEFORE reload!!!"], null);
}),null)),null,-1663399703);
});
pinkgorilla.core.my_after_reload_callback = (function pinkgorilla$core$my_after_reload_callback(){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.core","/tmp/form-init5318300759512683746.clj",33,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["AFTER reload!!!"], null);
}),null)),null,-1782491154);
});
pinkgorilla.core.mount_root = (function pinkgorilla$core$mount_root(){
return reagent.core.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.views.gorilla_app], null),document.getElementById("react-app"));
});
pinkgorilla.core.init_BANG_ = (function pinkgorilla$core$init_BANG_(){
pinkgorilla.events.google_analytics.set_enabled_BANG_(true);

pinkgorilla.routes.app_routes();

pinkgorilla.editor.core.init_cm_globally_BANG_();

pinkgorilla.views.init_mathjax_globally_BANG_();

var app_url = pinkgorilla.util.application_url();
var route = app_url.anchor;
var read_write = ((cljs.core.not(route)) || (cljs.core.not(clojure.string.index_of.cljs$core$IFn$_invoke$arity$2(route,"/view"))));
var G__29258_29262 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"initialize-app-db","initialize-app-db",-1585144192),app_url], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__29258_29262) : re_frame.core.dispatch_sync.call(null,G__29258_29262));

pinkgorilla.core.mount_root();

pinkgorilla.notifications.add_notification(pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"warning","warning",-1685650671),"The sky is blue. Gorillas are Pink."));

var G__29259_29263 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"settings-localstorage-load","settings-localstorage-load",-1464956499)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__29259_29263) : re_frame.core.dispatch_sync.call(null,G__29259_29263));

pinkgorilla.kernel.shadowcljs.init_BANG_();

if(read_write){
pinkgorilla.kernel.nrepl.init_BANG_("repl/",app_url);
} else {
}

var G__29260_29264 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"initialize-config","initialize-config",1399025996)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__29260_29264) : re_frame.core.dispatch_sync.call(null,G__29260_29264));

var G__29261_29265 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"explore-load","explore-load",1970977790)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29261_29265) : re_frame.core.dispatch.call(null,G__29261_29265));

if(cljs.core.not(route)){
return pinkgorilla.routes.nav_BANG_("/new");
} else {
return secretary.core.dispatch_BANG_(route);
}
});
goog.exportSymbol('pinkgorilla.core.init_BANG_', pinkgorilla.core.init_BANG_);

//# sourceMappingURL=pinkgorilla.core.js.map
