goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__14037 = (line + (1));
var G__14038 = (1);
var G__14039 = (counter + (1));
line = G__14037;
col = G__14038;
counter = G__14039;
continue;
} else {
var G__14040 = line;
var G__14041 = (col + (1));
var G__14042 = (counter + (1));
line = G__14040;
col = G__14041;
counter = G__14042;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__14045 = cljs.core.next(chars);
var G__14046 = (n__$1 - (1));
chars = G__14045;
n__$1 = G__14046;
continue;
} else {
var G__14048 = cljs.core.next(chars);
var G__14049 = n__$1;
chars = G__14048;
n__$1 = G__14049;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__13929){
var map__13964 = p__13929;
var map__13964__$1 = (((((!((map__13964 == null))))?(((((map__13964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13964.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13964):map__13964);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13964__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13964__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13964__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13964__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__13974_14061 = cljs.core.seq(full_reasons);
var chunk__13975_14062 = null;
var count__13976_14063 = (0);
var i__13977_14064 = (0);
while(true){
if((i__13977_14064 < count__13976_14063)){
var r_14065 = chunk__13975_14062.cljs$core$IIndexed$_nth$arity$2(null,i__13977_14064);
instaparse.failure.print_reason(r_14065);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__14067 = seq__13974_14061;
var G__14068 = chunk__13975_14062;
var G__14069 = count__13976_14063;
var G__14070 = (i__13977_14064 + (1));
seq__13974_14061 = G__14067;
chunk__13975_14062 = G__14068;
count__13976_14063 = G__14069;
i__13977_14064 = G__14070;
continue;
} else {
var temp__5735__auto___14072 = cljs.core.seq(seq__13974_14061);
if(temp__5735__auto___14072){
var seq__13974_14075__$1 = temp__5735__auto___14072;
if(cljs.core.chunked_seq_QMARK_(seq__13974_14075__$1)){
var c__4609__auto___14078 = cljs.core.chunk_first(seq__13974_14075__$1);
var G__14085 = cljs.core.chunk_rest(seq__13974_14075__$1);
var G__14086 = c__4609__auto___14078;
var G__14087 = cljs.core.count(c__4609__auto___14078);
var G__14088 = (0);
seq__13974_14061 = G__14085;
chunk__13975_14062 = G__14086;
count__13976_14063 = G__14087;
i__13977_14064 = G__14088;
continue;
} else {
var r_14092 = cljs.core.first(seq__13974_14075__$1);
instaparse.failure.print_reason(r_14092);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__14095 = cljs.core.next(seq__13974_14075__$1);
var G__14096 = null;
var G__14097 = (0);
var G__14098 = (0);
seq__13974_14061 = G__14095;
chunk__13975_14062 = G__14096;
count__13976_14063 = G__14097;
i__13977_14064 = G__14098;
continue;
}
} else {
}
}
break;
}

var seq__14009 = cljs.core.seq(partial_reasons);
var chunk__14010 = null;
var count__14011 = (0);
var i__14012 = (0);
while(true){
if((i__14012 < count__14011)){
var r = chunk__14010.cljs$core$IIndexed$_nth$arity$2(null,i__14012);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__14121 = seq__14009;
var G__14122 = chunk__14010;
var G__14123 = count__14011;
var G__14124 = (i__14012 + (1));
seq__14009 = G__14121;
chunk__14010 = G__14122;
count__14011 = G__14123;
i__14012 = G__14124;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__14009);
if(temp__5735__auto__){
var seq__14009__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14009__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__14009__$1);
var G__14126 = cljs.core.chunk_rest(seq__14009__$1);
var G__14127 = c__4609__auto__;
var G__14128 = cljs.core.count(c__4609__auto__);
var G__14129 = (0);
seq__14009 = G__14126;
chunk__14010 = G__14127;
count__14011 = G__14128;
i__14012 = G__14129;
continue;
} else {
var r = cljs.core.first(seq__14009__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__14131 = cljs.core.next(seq__14009__$1);
var G__14132 = null;
var G__14133 = (0);
var G__14134 = (0);
seq__14009 = G__14131;
chunk__14010 = G__14132;
count__14011 = G__14133;
i__14012 = G__14134;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
