goog.provide('day8.re_frame_10x.utils.localstorage');
goog.require('cljs.core');
goog.require('goog.storage.Storage');
goog.require('goog.storage.mechanism.HTML5LocalStorage');
goog.require('cljs.reader');
goog.require('clojure.string');
day8.re_frame_10x.utils.localstorage.storage = (new goog.storage.Storage((new goog.storage.mechanism.HTML5LocalStorage())));
day8.re_frame_10x.utils.localstorage.safe_prefix = "day8.re-frame-10x.";
day8.re_frame_10x.utils.localstorage.safe_key = (function day8$re_frame_10x$utils$localstorage$safe_key(key){

return [day8.re_frame_10x.utils.localstorage.safe_prefix,cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
});
/**
 * Gets a re-frame-10x value from local storage.
 */
day8.re_frame_10x.utils.localstorage.get = (function day8$re_frame_10x$utils$localstorage$get(var_args){
var G__7314 = arguments.length;
switch (G__7314) {
case 1:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1 = (function (key){
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2(key,null);
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var value = day8.re_frame_10x.utils.localstorage.storage.get(day8.re_frame_10x.utils.localstorage.safe_key(key));
if((void 0 === value)){
return not_found;
} else {
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
}
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$lang$maxFixedArity = 2);

/**
 * Saves a re-frame-10x value to local storage.
 */
day8.re_frame_10x.utils.localstorage.save_BANG_ = (function day8$re_frame_10x$utils$localstorage$save_BANG_(key,value){
return day8.re_frame_10x.utils.localstorage.storage.set(day8.re_frame_10x.utils.localstorage.safe_key(key),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)));
});
/**
 * Deletes all re-frame-10x config keys
 */
day8.re_frame_10x.utils.localstorage.delete_all_keys_BANG_ = (function day8$re_frame_10x$utils$localstorage$delete_all_keys_BANG_(){
var seq__7318 = cljs.core.seq(Object.keys(localStorage));
var chunk__7319 = null;
var count__7320 = (0);
var i__7321 = (0);
while(true){
if((i__7321 < count__7320)){
var k = chunk__7319.cljs$core$IIndexed$_nth$arity$2(null,i__7321);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__7329 = seq__7318;
var G__7330 = chunk__7319;
var G__7331 = count__7320;
var G__7332 = (i__7321 + (1));
seq__7318 = G__7329;
chunk__7319 = G__7330;
count__7320 = G__7331;
i__7321 = G__7332;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__7318);
if(temp__5735__auto__){
var seq__7318__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7318__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__7318__$1);
var G__7333 = cljs.core.chunk_rest(seq__7318__$1);
var G__7334 = c__4609__auto__;
var G__7335 = cljs.core.count(c__4609__auto__);
var G__7336 = (0);
seq__7318 = G__7333;
chunk__7319 = G__7334;
count__7320 = G__7335;
i__7321 = G__7336;
continue;
} else {
var k = cljs.core.first(seq__7318__$1);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__7337 = cljs.core.next(seq__7318__$1);
var G__7338 = null;
var G__7339 = (0);
var G__7340 = (0);
seq__7318 = G__7337;
chunk__7319 = G__7338;
count__7320 = G__7339;
i__7321 = G__7340;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=day8.re_frame_10x.utils.localstorage.js.map
