goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__20509){
var vec__20510 = p__20509;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20510,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20510,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__20513 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20513,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20513,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20513,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20513,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20513,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__20520 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20520,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20520,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20520,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20520,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20520,(4),null);
var vec__20523 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20523,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20523,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20523,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20523,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20523,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__20528 = segmap;
var map__20528__$1 = (((((!((map__20528 == null))))?(((((map__20528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20528.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20528):map__20528);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20528__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20528__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20528__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20528__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20528__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__20535 = arguments.length;
switch (G__20535) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__20551 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__21512 = cljs.core.next(segs__$1);
var G__21513 = nrelseg;
var G__21514 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__21512;
relseg__$1 = G__21513;
result__$1 = G__21514;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20551,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20551,(1),null);
var G__21519 = (gline + (1));
var G__21520 = cljs.core.next(lines__$1);
var G__21521 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__21522 = result__$1;
gline = G__21519;
lines__$1 = G__21520;
relseg = G__21521;
result = G__21522;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__20565 = segmap;
var map__20565__$1 = (((((!((map__20565 == null))))?(((((map__20565.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20565.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20565):map__20565);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__20564_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20564_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__20581 = arguments.length;
switch (G__20581) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__20594 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__21532 = cljs.core.next(segs__$1);
var G__21533 = nrelseg;
var G__21534 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__21532;
relseg__$1 = G__21533;
result__$1 = G__21534;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20594,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20594,(1),null);
var G__21537 = (gline + (1));
var G__21538 = cljs.core.next(lines__$1);
var G__21539 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__21540 = result__$1;
gline = G__21537;
lines__$1 = G__21538;
relseg = G__21539;
result = G__21540;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__20599){
var vec__20600 = p__20599;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20600,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20600,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20600,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20600,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20600,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__20604){
var vec__20605 = p__20604;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20605,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20605,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20605,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20605,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20605,(4),null);
var seg = vec__20605;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__20610){
var vec__20613 = p__20610;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20613,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20613,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20613,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20613,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20613,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__20634 = cljs.core.seq(infos);
var chunk__20635 = null;
var count__20636 = (0);
var i__20637 = (0);
while(true){
if((i__20637 < count__20636)){
var info = chunk__20635.cljs$core$IIndexed$_nth$arity$2(null,i__20637);
var segv_21561 = info__GT_segv(info,source_idx,line,col);
var gline_21562 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_21563 = cljs.core.count(cljs.core.deref(lines));
if((gline_21562 > (lc_21563 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__20634,chunk__20635,count__20636,i__20637,segv_21561,gline_21562,lc_21563,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_21562 - (lc_21563 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_21561], null));
});})(seq__20634,chunk__20635,count__20636,i__20637,segv_21561,gline_21562,lc_21563,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__20634,chunk__20635,count__20636,i__20637,segv_21561,gline_21562,lc_21563,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21562], null),cljs.core.conj,segv_21561);
});})(seq__20634,chunk__20635,count__20636,i__20637,segv_21561,gline_21562,lc_21563,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__21568 = seq__20634;
var G__21569 = chunk__20635;
var G__21570 = count__20636;
var G__21571 = (i__20637 + (1));
seq__20634 = G__21568;
chunk__20635 = G__21569;
count__20636 = G__21570;
i__20637 = G__21571;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20634);
if(temp__5735__auto__){
var seq__20634__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20634__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__20634__$1);
var G__21574 = cljs.core.chunk_rest(seq__20634__$1);
var G__21575 = c__4609__auto__;
var G__21576 = cljs.core.count(c__4609__auto__);
var G__21577 = (0);
seq__20634 = G__21574;
chunk__20635 = G__21575;
count__20636 = G__21576;
i__20637 = G__21577;
continue;
} else {
var info = cljs.core.first(seq__20634__$1);
var segv_21578 = info__GT_segv(info,source_idx,line,col);
var gline_21579 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_21580 = cljs.core.count(cljs.core.deref(lines));
if((gline_21579 > (lc_21580 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__20634,chunk__20635,count__20636,i__20637,segv_21578,gline_21579,lc_21580,info,seq__20634__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_21579 - (lc_21580 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_21578], null));
});})(seq__20634,chunk__20635,count__20636,i__20637,segv_21578,gline_21579,lc_21580,info,seq__20634__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__20634,chunk__20635,count__20636,i__20637,segv_21578,gline_21579,lc_21580,info,seq__20634__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21579], null),cljs.core.conj,segv_21578);
});})(seq__20634,chunk__20635,count__20636,i__20637,segv_21578,gline_21579,lc_21580,info,seq__20634__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__21581 = cljs.core.next(seq__20634__$1);
var G__21582 = null;
var G__21583 = (0);
var G__21584 = (0);
seq__20634 = G__21581;
chunk__20635 = G__21582;
count__20636 = G__21583;
i__20637 = G__21584;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__20666_21585 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__20667_21586 = null;
var count__20668_21587 = (0);
var i__20669_21588 = (0);
while(true){
if((i__20669_21588 < count__20668_21587)){
var vec__20889_21589 = chunk__20667_21586.cljs$core$IIndexed$_nth$arity$2(null,i__20669_21588);
var source_idx_21590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20889_21589,(0),null);
var vec__20892_21591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20889_21589,(1),null);
var __21592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20892_21591,(0),null);
var lines_21593__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20892_21591,(1),null);
var seq__20895_21594 = cljs.core.seq(lines_21593__$1);
var chunk__20896_21595 = null;
var count__20897_21596 = (0);
var i__20898_21597 = (0);
while(true){
if((i__20898_21597 < count__20897_21596)){
var vec__20947_21598 = chunk__20896_21595.cljs$core$IIndexed$_nth$arity$2(null,i__20898_21597);
var line_21599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20947_21598,(0),null);
var cols_21600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20947_21598,(1),null);
var seq__20950_21601 = cljs.core.seq(cols_21600);
var chunk__20951_21602 = null;
var count__20952_21603 = (0);
var i__20953_21604 = (0);
while(true){
if((i__20953_21604 < count__20952_21603)){
var vec__20962_21605 = chunk__20951_21602.cljs$core$IIndexed$_nth$arity$2(null,i__20953_21604);
var col_21606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20962_21605,(0),null);
var infos_21607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20962_21605,(1),null);
encode_cols(infos_21607,source_idx_21590,line_21599,col_21606);


var G__21610 = seq__20950_21601;
var G__21611 = chunk__20951_21602;
var G__21612 = count__20952_21603;
var G__21613 = (i__20953_21604 + (1));
seq__20950_21601 = G__21610;
chunk__20951_21602 = G__21611;
count__20952_21603 = G__21612;
i__20953_21604 = G__21613;
continue;
} else {
var temp__5735__auto___21614 = cljs.core.seq(seq__20950_21601);
if(temp__5735__auto___21614){
var seq__20950_21617__$1 = temp__5735__auto___21614;
if(cljs.core.chunked_seq_QMARK_(seq__20950_21617__$1)){
var c__4609__auto___21618 = cljs.core.chunk_first(seq__20950_21617__$1);
var G__21619 = cljs.core.chunk_rest(seq__20950_21617__$1);
var G__21620 = c__4609__auto___21618;
var G__21621 = cljs.core.count(c__4609__auto___21618);
var G__21622 = (0);
seq__20950_21601 = G__21619;
chunk__20951_21602 = G__21620;
count__20952_21603 = G__21621;
i__20953_21604 = G__21622;
continue;
} else {
var vec__20965_21623 = cljs.core.first(seq__20950_21617__$1);
var col_21624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20965_21623,(0),null);
var infos_21625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20965_21623,(1),null);
encode_cols(infos_21625,source_idx_21590,line_21599,col_21624);


var G__21626 = cljs.core.next(seq__20950_21617__$1);
var G__21627 = null;
var G__21628 = (0);
var G__21629 = (0);
seq__20950_21601 = G__21626;
chunk__20951_21602 = G__21627;
count__20952_21603 = G__21628;
i__20953_21604 = G__21629;
continue;
}
} else {
}
}
break;
}


var G__21630 = seq__20895_21594;
var G__21631 = chunk__20896_21595;
var G__21632 = count__20897_21596;
var G__21633 = (i__20898_21597 + (1));
seq__20895_21594 = G__21630;
chunk__20896_21595 = G__21631;
count__20897_21596 = G__21632;
i__20898_21597 = G__21633;
continue;
} else {
var temp__5735__auto___21635 = cljs.core.seq(seq__20895_21594);
if(temp__5735__auto___21635){
var seq__20895_21639__$1 = temp__5735__auto___21635;
if(cljs.core.chunked_seq_QMARK_(seq__20895_21639__$1)){
var c__4609__auto___21640 = cljs.core.chunk_first(seq__20895_21639__$1);
var G__21641 = cljs.core.chunk_rest(seq__20895_21639__$1);
var G__21642 = c__4609__auto___21640;
var G__21643 = cljs.core.count(c__4609__auto___21640);
var G__21644 = (0);
seq__20895_21594 = G__21641;
chunk__20896_21595 = G__21642;
count__20897_21596 = G__21643;
i__20898_21597 = G__21644;
continue;
} else {
var vec__20968_21645 = cljs.core.first(seq__20895_21639__$1);
var line_21646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20968_21645,(0),null);
var cols_21647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20968_21645,(1),null);
var seq__20971_21650 = cljs.core.seq(cols_21647);
var chunk__20972_21651 = null;
var count__20973_21652 = (0);
var i__20974_21653 = (0);
while(true){
if((i__20974_21653 < count__20973_21652)){
var vec__20985_21656 = chunk__20972_21651.cljs$core$IIndexed$_nth$arity$2(null,i__20974_21653);
var col_21657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20985_21656,(0),null);
var infos_21658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20985_21656,(1),null);
encode_cols(infos_21658,source_idx_21590,line_21646,col_21657);


var G__21663 = seq__20971_21650;
var G__21664 = chunk__20972_21651;
var G__21665 = count__20973_21652;
var G__21666 = (i__20974_21653 + (1));
seq__20971_21650 = G__21663;
chunk__20972_21651 = G__21664;
count__20973_21652 = G__21665;
i__20974_21653 = G__21666;
continue;
} else {
var temp__5735__auto___21667__$1 = cljs.core.seq(seq__20971_21650);
if(temp__5735__auto___21667__$1){
var seq__20971_21668__$1 = temp__5735__auto___21667__$1;
if(cljs.core.chunked_seq_QMARK_(seq__20971_21668__$1)){
var c__4609__auto___21669 = cljs.core.chunk_first(seq__20971_21668__$1);
var G__21670 = cljs.core.chunk_rest(seq__20971_21668__$1);
var G__21671 = c__4609__auto___21669;
var G__21672 = cljs.core.count(c__4609__auto___21669);
var G__21673 = (0);
seq__20971_21650 = G__21670;
chunk__20972_21651 = G__21671;
count__20973_21652 = G__21672;
i__20974_21653 = G__21673;
continue;
} else {
var vec__20989_21674 = cljs.core.first(seq__20971_21668__$1);
var col_21675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20989_21674,(0),null);
var infos_21676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20989_21674,(1),null);
encode_cols(infos_21676,source_idx_21590,line_21646,col_21675);


var G__21677 = cljs.core.next(seq__20971_21668__$1);
var G__21678 = null;
var G__21679 = (0);
var G__21680 = (0);
seq__20971_21650 = G__21677;
chunk__20972_21651 = G__21678;
count__20973_21652 = G__21679;
i__20974_21653 = G__21680;
continue;
}
} else {
}
}
break;
}


var G__21681 = cljs.core.next(seq__20895_21639__$1);
var G__21682 = null;
var G__21683 = (0);
var G__21684 = (0);
seq__20895_21594 = G__21681;
chunk__20896_21595 = G__21682;
count__20897_21596 = G__21683;
i__20898_21597 = G__21684;
continue;
}
} else {
}
}
break;
}


var G__21686 = seq__20666_21585;
var G__21687 = chunk__20667_21586;
var G__21688 = count__20668_21587;
var G__21689 = (i__20669_21588 + (1));
seq__20666_21585 = G__21686;
chunk__20667_21586 = G__21687;
count__20668_21587 = G__21688;
i__20669_21588 = G__21689;
continue;
} else {
var temp__5735__auto___21693 = cljs.core.seq(seq__20666_21585);
if(temp__5735__auto___21693){
var seq__20666_21694__$1 = temp__5735__auto___21693;
if(cljs.core.chunked_seq_QMARK_(seq__20666_21694__$1)){
var c__4609__auto___21695 = cljs.core.chunk_first(seq__20666_21694__$1);
var G__21696 = cljs.core.chunk_rest(seq__20666_21694__$1);
var G__21697 = c__4609__auto___21695;
var G__21698 = cljs.core.count(c__4609__auto___21695);
var G__21699 = (0);
seq__20666_21585 = G__21696;
chunk__20667_21586 = G__21697;
count__20668_21587 = G__21698;
i__20669_21588 = G__21699;
continue;
} else {
var vec__20999_21701 = cljs.core.first(seq__20666_21694__$1);
var source_idx_21702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20999_21701,(0),null);
var vec__21002_21703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20999_21701,(1),null);
var __21704 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21002_21703,(0),null);
var lines_21705__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21002_21703,(1),null);
var seq__21005_21709 = cljs.core.seq(lines_21705__$1);
var chunk__21006_21710 = null;
var count__21007_21711 = (0);
var i__21008_21712 = (0);
while(true){
if((i__21008_21712 < count__21007_21711)){
var vec__21076_21714 = chunk__21006_21710.cljs$core$IIndexed$_nth$arity$2(null,i__21008_21712);
var line_21715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21076_21714,(0),null);
var cols_21716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21076_21714,(1),null);
var seq__21079_21717 = cljs.core.seq(cols_21716);
var chunk__21080_21718 = null;
var count__21081_21719 = (0);
var i__21082_21720 = (0);
while(true){
if((i__21082_21720 < count__21081_21719)){
var vec__21093_21721 = chunk__21080_21718.cljs$core$IIndexed$_nth$arity$2(null,i__21082_21720);
var col_21722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21093_21721,(0),null);
var infos_21723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21093_21721,(1),null);
encode_cols(infos_21723,source_idx_21702,line_21715,col_21722);


var G__21724 = seq__21079_21717;
var G__21725 = chunk__21080_21718;
var G__21726 = count__21081_21719;
var G__21727 = (i__21082_21720 + (1));
seq__21079_21717 = G__21724;
chunk__21080_21718 = G__21725;
count__21081_21719 = G__21726;
i__21082_21720 = G__21727;
continue;
} else {
var temp__5735__auto___21731__$1 = cljs.core.seq(seq__21079_21717);
if(temp__5735__auto___21731__$1){
var seq__21079_21732__$1 = temp__5735__auto___21731__$1;
if(cljs.core.chunked_seq_QMARK_(seq__21079_21732__$1)){
var c__4609__auto___21734 = cljs.core.chunk_first(seq__21079_21732__$1);
var G__21735 = cljs.core.chunk_rest(seq__21079_21732__$1);
var G__21736 = c__4609__auto___21734;
var G__21737 = cljs.core.count(c__4609__auto___21734);
var G__21738 = (0);
seq__21079_21717 = G__21735;
chunk__21080_21718 = G__21736;
count__21081_21719 = G__21737;
i__21082_21720 = G__21738;
continue;
} else {
var vec__21096_21739 = cljs.core.first(seq__21079_21732__$1);
var col_21740 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21096_21739,(0),null);
var infos_21741 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21096_21739,(1),null);
encode_cols(infos_21741,source_idx_21702,line_21715,col_21740);


var G__21742 = cljs.core.next(seq__21079_21732__$1);
var G__21743 = null;
var G__21744 = (0);
var G__21745 = (0);
seq__21079_21717 = G__21742;
chunk__21080_21718 = G__21743;
count__21081_21719 = G__21744;
i__21082_21720 = G__21745;
continue;
}
} else {
}
}
break;
}


var G__21746 = seq__21005_21709;
var G__21747 = chunk__21006_21710;
var G__21748 = count__21007_21711;
var G__21749 = (i__21008_21712 + (1));
seq__21005_21709 = G__21746;
chunk__21006_21710 = G__21747;
count__21007_21711 = G__21748;
i__21008_21712 = G__21749;
continue;
} else {
var temp__5735__auto___21751__$1 = cljs.core.seq(seq__21005_21709);
if(temp__5735__auto___21751__$1){
var seq__21005_21752__$1 = temp__5735__auto___21751__$1;
if(cljs.core.chunked_seq_QMARK_(seq__21005_21752__$1)){
var c__4609__auto___21753 = cljs.core.chunk_first(seq__21005_21752__$1);
var G__21756 = cljs.core.chunk_rest(seq__21005_21752__$1);
var G__21757 = c__4609__auto___21753;
var G__21758 = cljs.core.count(c__4609__auto___21753);
var G__21759 = (0);
seq__21005_21709 = G__21756;
chunk__21006_21710 = G__21757;
count__21007_21711 = G__21758;
i__21008_21712 = G__21759;
continue;
} else {
var vec__21099_21762 = cljs.core.first(seq__21005_21752__$1);
var line_21763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21099_21762,(0),null);
var cols_21764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21099_21762,(1),null);
var seq__21102_21765 = cljs.core.seq(cols_21764);
var chunk__21103_21766 = null;
var count__21104_21767 = (0);
var i__21105_21768 = (0);
while(true){
if((i__21105_21768 < count__21104_21767)){
var vec__21114_21769 = chunk__21103_21766.cljs$core$IIndexed$_nth$arity$2(null,i__21105_21768);
var col_21770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21114_21769,(0),null);
var infos_21771 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21114_21769,(1),null);
encode_cols(infos_21771,source_idx_21702,line_21763,col_21770);


var G__21775 = seq__21102_21765;
var G__21776 = chunk__21103_21766;
var G__21777 = count__21104_21767;
var G__21778 = (i__21105_21768 + (1));
seq__21102_21765 = G__21775;
chunk__21103_21766 = G__21776;
count__21104_21767 = G__21777;
i__21105_21768 = G__21778;
continue;
} else {
var temp__5735__auto___21779__$2 = cljs.core.seq(seq__21102_21765);
if(temp__5735__auto___21779__$2){
var seq__21102_21780__$1 = temp__5735__auto___21779__$2;
if(cljs.core.chunked_seq_QMARK_(seq__21102_21780__$1)){
var c__4609__auto___21781 = cljs.core.chunk_first(seq__21102_21780__$1);
var G__21782 = cljs.core.chunk_rest(seq__21102_21780__$1);
var G__21783 = c__4609__auto___21781;
var G__21784 = cljs.core.count(c__4609__auto___21781);
var G__21785 = (0);
seq__21102_21765 = G__21782;
chunk__21103_21766 = G__21783;
count__21104_21767 = G__21784;
i__21105_21768 = G__21785;
continue;
} else {
var vec__21119_21786 = cljs.core.first(seq__21102_21780__$1);
var col_21787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21119_21786,(0),null);
var infos_21788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21119_21786,(1),null);
encode_cols(infos_21788,source_idx_21702,line_21763,col_21787);


var G__21789 = cljs.core.next(seq__21102_21780__$1);
var G__21790 = null;
var G__21791 = (0);
var G__21792 = (0);
seq__21102_21765 = G__21789;
chunk__21103_21766 = G__21790;
count__21104_21767 = G__21791;
i__21105_21768 = G__21792;
continue;
}
} else {
}
}
break;
}


var G__21794 = cljs.core.next(seq__21005_21752__$1);
var G__21795 = null;
var G__21796 = (0);
var G__21797 = (0);
seq__21005_21709 = G__21794;
chunk__21006_21710 = G__21795;
count__21007_21711 = G__21796;
i__21008_21712 = G__21797;
continue;
}
} else {
}
}
break;
}


var G__21801 = cljs.core.next(seq__20666_21694__$1);
var G__21802 = null;
var G__21803 = (0);
var G__21804 = (0);
seq__20666_21585 = G__21801;
chunk__20667_21586 = G__21802;
count__20668_21587 = G__21803;
i__20669_21588 = G__21804;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__21122 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__20619_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20619_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__20620_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__20620_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20621_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__20621_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__21125 = G__21122;
var G__21126_21807 = G__21125;
var G__21127_21808 = "sourcesContent";
var G__21128_21809 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__21126_21807,G__21127_21808,G__21128_21809);

return G__21125;
} else {
return G__21122;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__21130 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21130,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21130,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__21133 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21133,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21133,(1),null);
var G__21816 = cljs.core.next(col_map_seq);
var G__21817 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__21133,col,infos,vec__21130,line,col_map){
return (function (v,p__21136){
var map__21137 = p__21136;
var map__21137__$1 = (((((!((map__21137 == null))))?(((((map__21137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21137.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21137):map__21137);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21137__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21137__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__21133,col,infos,vec__21130,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__21816;
new_cols = G__21817;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__21818 = cljs.core.next(line_map_seq);
var G__21819 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__21818;
new_lines = G__21819;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__21140_21820 = cljs.core.seq(reverse_map);
var chunk__21141_21821 = null;
var count__21142_21822 = (0);
var i__21143_21823 = (0);
while(true){
if((i__21143_21823 < count__21142_21822)){
var vec__21316_21824 = chunk__21141_21821.cljs$core$IIndexed$_nth$arity$2(null,i__21143_21823);
var line_21825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21316_21824,(0),null);
var columns_21826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21316_21824,(1),null);
var seq__21319_21827 = cljs.core.seq(columns_21826);
var chunk__21320_21828 = null;
var count__21321_21829 = (0);
var i__21322_21830 = (0);
while(true){
if((i__21322_21830 < count__21321_21829)){
var vec__21356_21831 = chunk__21320_21828.cljs$core$IIndexed$_nth$arity$2(null,i__21322_21830);
var column_21832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21356_21831,(0),null);
var column_info_21833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21356_21831,(1),null);
var seq__21359_21834 = cljs.core.seq(column_info_21833);
var chunk__21360_21835 = null;
var count__21361_21836 = (0);
var i__21362_21837 = (0);
while(true){
if((i__21362_21837 < count__21361_21836)){
var map__21370_21838 = chunk__21360_21835.cljs$core$IIndexed$_nth$arity$2(null,i__21362_21837);
var map__21370_21839__$1 = (((((!((map__21370_21838 == null))))?(((((map__21370_21838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21370_21838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21370_21838):map__21370_21838);
var gline_21840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21370_21839__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_21841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21370_21839__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_21842 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21370_21839__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21840], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21359_21834,chunk__21360_21835,count__21361_21836,i__21362_21837,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21370_21838,map__21370_21839__$1,gline_21840,gcol_21841,name_21842,vec__21356_21831,column_21832,column_info_21833,vec__21316_21824,line_21825,columns_21826,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_21841], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21825,new cljs.core.Keyword(null,"col","col",-1959363084),column_21832,new cljs.core.Keyword(null,"name","name",1843675177),name_21842], null));
});})(seq__21359_21834,chunk__21360_21835,count__21361_21836,i__21362_21837,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21370_21838,map__21370_21839__$1,gline_21840,gcol_21841,name_21842,vec__21356_21831,column_21832,column_info_21833,vec__21316_21824,line_21825,columns_21826,inverted))
,cljs.core.sorted_map()));


var G__21854 = seq__21359_21834;
var G__21855 = chunk__21360_21835;
var G__21856 = count__21361_21836;
var G__21857 = (i__21362_21837 + (1));
seq__21359_21834 = G__21854;
chunk__21360_21835 = G__21855;
count__21361_21836 = G__21856;
i__21362_21837 = G__21857;
continue;
} else {
var temp__5735__auto___21859 = cljs.core.seq(seq__21359_21834);
if(temp__5735__auto___21859){
var seq__21359_21860__$1 = temp__5735__auto___21859;
if(cljs.core.chunked_seq_QMARK_(seq__21359_21860__$1)){
var c__4609__auto___21861 = cljs.core.chunk_first(seq__21359_21860__$1);
var G__21863 = cljs.core.chunk_rest(seq__21359_21860__$1);
var G__21864 = c__4609__auto___21861;
var G__21865 = cljs.core.count(c__4609__auto___21861);
var G__21866 = (0);
seq__21359_21834 = G__21863;
chunk__21360_21835 = G__21864;
count__21361_21836 = G__21865;
i__21362_21837 = G__21866;
continue;
} else {
var map__21375_21867 = cljs.core.first(seq__21359_21860__$1);
var map__21375_21868__$1 = (((((!((map__21375_21867 == null))))?(((((map__21375_21867.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21375_21867.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21375_21867):map__21375_21867);
var gline_21869 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21375_21868__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_21870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21375_21868__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_21871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21375_21868__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21869], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21359_21834,chunk__21360_21835,count__21361_21836,i__21362_21837,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21375_21867,map__21375_21868__$1,gline_21869,gcol_21870,name_21871,seq__21359_21860__$1,temp__5735__auto___21859,vec__21356_21831,column_21832,column_info_21833,vec__21316_21824,line_21825,columns_21826,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_21870], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21825,new cljs.core.Keyword(null,"col","col",-1959363084),column_21832,new cljs.core.Keyword(null,"name","name",1843675177),name_21871], null));
});})(seq__21359_21834,chunk__21360_21835,count__21361_21836,i__21362_21837,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21375_21867,map__21375_21868__$1,gline_21869,gcol_21870,name_21871,seq__21359_21860__$1,temp__5735__auto___21859,vec__21356_21831,column_21832,column_info_21833,vec__21316_21824,line_21825,columns_21826,inverted))
,cljs.core.sorted_map()));


var G__21872 = cljs.core.next(seq__21359_21860__$1);
var G__21873 = null;
var G__21874 = (0);
var G__21875 = (0);
seq__21359_21834 = G__21872;
chunk__21360_21835 = G__21873;
count__21361_21836 = G__21874;
i__21362_21837 = G__21875;
continue;
}
} else {
}
}
break;
}


var G__21876 = seq__21319_21827;
var G__21877 = chunk__21320_21828;
var G__21878 = count__21321_21829;
var G__21879 = (i__21322_21830 + (1));
seq__21319_21827 = G__21876;
chunk__21320_21828 = G__21877;
count__21321_21829 = G__21878;
i__21322_21830 = G__21879;
continue;
} else {
var temp__5735__auto___21880 = cljs.core.seq(seq__21319_21827);
if(temp__5735__auto___21880){
var seq__21319_21881__$1 = temp__5735__auto___21880;
if(cljs.core.chunked_seq_QMARK_(seq__21319_21881__$1)){
var c__4609__auto___21882 = cljs.core.chunk_first(seq__21319_21881__$1);
var G__21883 = cljs.core.chunk_rest(seq__21319_21881__$1);
var G__21884 = c__4609__auto___21882;
var G__21885 = cljs.core.count(c__4609__auto___21882);
var G__21886 = (0);
seq__21319_21827 = G__21883;
chunk__21320_21828 = G__21884;
count__21321_21829 = G__21885;
i__21322_21830 = G__21886;
continue;
} else {
var vec__21377_21887 = cljs.core.first(seq__21319_21881__$1);
var column_21888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21377_21887,(0),null);
var column_info_21889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21377_21887,(1),null);
var seq__21380_21890 = cljs.core.seq(column_info_21889);
var chunk__21381_21891 = null;
var count__21382_21892 = (0);
var i__21383_21893 = (0);
while(true){
if((i__21383_21893 < count__21382_21892)){
var map__21392_21894 = chunk__21381_21891.cljs$core$IIndexed$_nth$arity$2(null,i__21383_21893);
var map__21392_21895__$1 = (((((!((map__21392_21894 == null))))?(((((map__21392_21894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21392_21894.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21392_21894):map__21392_21894);
var gline_21896 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21392_21895__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_21897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21392_21895__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_21898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21392_21895__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21896], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21380_21890,chunk__21381_21891,count__21382_21892,i__21383_21893,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21392_21894,map__21392_21895__$1,gline_21896,gcol_21897,name_21898,vec__21377_21887,column_21888,column_info_21889,seq__21319_21881__$1,temp__5735__auto___21880,vec__21316_21824,line_21825,columns_21826,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_21897], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21825,new cljs.core.Keyword(null,"col","col",-1959363084),column_21888,new cljs.core.Keyword(null,"name","name",1843675177),name_21898], null));
});})(seq__21380_21890,chunk__21381_21891,count__21382_21892,i__21383_21893,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21392_21894,map__21392_21895__$1,gline_21896,gcol_21897,name_21898,vec__21377_21887,column_21888,column_info_21889,seq__21319_21881__$1,temp__5735__auto___21880,vec__21316_21824,line_21825,columns_21826,inverted))
,cljs.core.sorted_map()));


var G__21900 = seq__21380_21890;
var G__21901 = chunk__21381_21891;
var G__21902 = count__21382_21892;
var G__21903 = (i__21383_21893 + (1));
seq__21380_21890 = G__21900;
chunk__21381_21891 = G__21901;
count__21382_21892 = G__21902;
i__21383_21893 = G__21903;
continue;
} else {
var temp__5735__auto___21904__$1 = cljs.core.seq(seq__21380_21890);
if(temp__5735__auto___21904__$1){
var seq__21380_21905__$1 = temp__5735__auto___21904__$1;
if(cljs.core.chunked_seq_QMARK_(seq__21380_21905__$1)){
var c__4609__auto___21906 = cljs.core.chunk_first(seq__21380_21905__$1);
var G__21907 = cljs.core.chunk_rest(seq__21380_21905__$1);
var G__21908 = c__4609__auto___21906;
var G__21909 = cljs.core.count(c__4609__auto___21906);
var G__21910 = (0);
seq__21380_21890 = G__21907;
chunk__21381_21891 = G__21908;
count__21382_21892 = G__21909;
i__21383_21893 = G__21910;
continue;
} else {
var map__21394_21911 = cljs.core.first(seq__21380_21905__$1);
var map__21394_21912__$1 = (((((!((map__21394_21911 == null))))?(((((map__21394_21911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21394_21911.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21394_21911):map__21394_21911);
var gline_21913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21394_21912__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_21914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21394_21912__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_21915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21394_21912__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21913], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21380_21890,chunk__21381_21891,count__21382_21892,i__21383_21893,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21394_21911,map__21394_21912__$1,gline_21913,gcol_21914,name_21915,seq__21380_21905__$1,temp__5735__auto___21904__$1,vec__21377_21887,column_21888,column_info_21889,seq__21319_21881__$1,temp__5735__auto___21880,vec__21316_21824,line_21825,columns_21826,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_21914], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21825,new cljs.core.Keyword(null,"col","col",-1959363084),column_21888,new cljs.core.Keyword(null,"name","name",1843675177),name_21915], null));
});})(seq__21380_21890,chunk__21381_21891,count__21382_21892,i__21383_21893,seq__21319_21827,chunk__21320_21828,count__21321_21829,i__21322_21830,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21394_21911,map__21394_21912__$1,gline_21913,gcol_21914,name_21915,seq__21380_21905__$1,temp__5735__auto___21904__$1,vec__21377_21887,column_21888,column_info_21889,seq__21319_21881__$1,temp__5735__auto___21880,vec__21316_21824,line_21825,columns_21826,inverted))
,cljs.core.sorted_map()));


var G__21916 = cljs.core.next(seq__21380_21905__$1);
var G__21917 = null;
var G__21918 = (0);
var G__21919 = (0);
seq__21380_21890 = G__21916;
chunk__21381_21891 = G__21917;
count__21382_21892 = G__21918;
i__21383_21893 = G__21919;
continue;
}
} else {
}
}
break;
}


var G__21920 = cljs.core.next(seq__21319_21881__$1);
var G__21921 = null;
var G__21922 = (0);
var G__21923 = (0);
seq__21319_21827 = G__21920;
chunk__21320_21828 = G__21921;
count__21321_21829 = G__21922;
i__21322_21830 = G__21923;
continue;
}
} else {
}
}
break;
}


var G__21924 = seq__21140_21820;
var G__21925 = chunk__21141_21821;
var G__21926 = count__21142_21822;
var G__21927 = (i__21143_21823 + (1));
seq__21140_21820 = G__21924;
chunk__21141_21821 = G__21925;
count__21142_21822 = G__21926;
i__21143_21823 = G__21927;
continue;
} else {
var temp__5735__auto___21928 = cljs.core.seq(seq__21140_21820);
if(temp__5735__auto___21928){
var seq__21140_21929__$1 = temp__5735__auto___21928;
if(cljs.core.chunked_seq_QMARK_(seq__21140_21929__$1)){
var c__4609__auto___21930 = cljs.core.chunk_first(seq__21140_21929__$1);
var G__21931 = cljs.core.chunk_rest(seq__21140_21929__$1);
var G__21932 = c__4609__auto___21930;
var G__21933 = cljs.core.count(c__4609__auto___21930);
var G__21934 = (0);
seq__21140_21820 = G__21931;
chunk__21141_21821 = G__21932;
count__21142_21822 = G__21933;
i__21143_21823 = G__21934;
continue;
} else {
var vec__21396_21935 = cljs.core.first(seq__21140_21929__$1);
var line_21936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21396_21935,(0),null);
var columns_21937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21396_21935,(1),null);
var seq__21399_21938 = cljs.core.seq(columns_21937);
var chunk__21400_21939 = null;
var count__21401_21940 = (0);
var i__21402_21941 = (0);
while(true){
if((i__21402_21941 < count__21401_21940)){
var vec__21442_21942 = chunk__21400_21939.cljs$core$IIndexed$_nth$arity$2(null,i__21402_21941);
var column_21943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21442_21942,(0),null);
var column_info_21944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21442_21942,(1),null);
var seq__21445_21945 = cljs.core.seq(column_info_21944);
var chunk__21446_21946 = null;
var count__21447_21947 = (0);
var i__21448_21948 = (0);
while(true){
if((i__21448_21948 < count__21447_21947)){
var map__21458_21949 = chunk__21446_21946.cljs$core$IIndexed$_nth$arity$2(null,i__21448_21948);
var map__21458_21950__$1 = (((((!((map__21458_21949 == null))))?(((((map__21458_21949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21458_21949.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21458_21949):map__21458_21949);
var gline_21951 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21458_21950__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_21952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21458_21950__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_21953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21458_21950__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21951], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21445_21945,chunk__21446_21946,count__21447_21947,i__21448_21948,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21458_21949,map__21458_21950__$1,gline_21951,gcol_21952,name_21953,vec__21442_21942,column_21943,column_info_21944,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_21952], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21936,new cljs.core.Keyword(null,"col","col",-1959363084),column_21943,new cljs.core.Keyword(null,"name","name",1843675177),name_21953], null));
});})(seq__21445_21945,chunk__21446_21946,count__21447_21947,i__21448_21948,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21458_21949,map__21458_21950__$1,gline_21951,gcol_21952,name_21953,vec__21442_21942,column_21943,column_info_21944,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted))
,cljs.core.sorted_map()));


var G__21954 = seq__21445_21945;
var G__21955 = chunk__21446_21946;
var G__21956 = count__21447_21947;
var G__21957 = (i__21448_21948 + (1));
seq__21445_21945 = G__21954;
chunk__21446_21946 = G__21955;
count__21447_21947 = G__21956;
i__21448_21948 = G__21957;
continue;
} else {
var temp__5735__auto___21958__$1 = cljs.core.seq(seq__21445_21945);
if(temp__5735__auto___21958__$1){
var seq__21445_21959__$1 = temp__5735__auto___21958__$1;
if(cljs.core.chunked_seq_QMARK_(seq__21445_21959__$1)){
var c__4609__auto___21960 = cljs.core.chunk_first(seq__21445_21959__$1);
var G__21961 = cljs.core.chunk_rest(seq__21445_21959__$1);
var G__21962 = c__4609__auto___21960;
var G__21963 = cljs.core.count(c__4609__auto___21960);
var G__21964 = (0);
seq__21445_21945 = G__21961;
chunk__21446_21946 = G__21962;
count__21447_21947 = G__21963;
i__21448_21948 = G__21964;
continue;
} else {
var map__21460_21965 = cljs.core.first(seq__21445_21959__$1);
var map__21460_21966__$1 = (((((!((map__21460_21965 == null))))?(((((map__21460_21965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21460_21965.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21460_21965):map__21460_21965);
var gline_21967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21460_21966__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_21968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21460_21966__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_21969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21460_21966__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_21967], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21445_21945,chunk__21446_21946,count__21447_21947,i__21448_21948,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21460_21965,map__21460_21966__$1,gline_21967,gcol_21968,name_21969,seq__21445_21959__$1,temp__5735__auto___21958__$1,vec__21442_21942,column_21943,column_info_21944,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_21968], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21936,new cljs.core.Keyword(null,"col","col",-1959363084),column_21943,new cljs.core.Keyword(null,"name","name",1843675177),name_21969], null));
});})(seq__21445_21945,chunk__21446_21946,count__21447_21947,i__21448_21948,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21460_21965,map__21460_21966__$1,gline_21967,gcol_21968,name_21969,seq__21445_21959__$1,temp__5735__auto___21958__$1,vec__21442_21942,column_21943,column_info_21944,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted))
,cljs.core.sorted_map()));


var G__21977 = cljs.core.next(seq__21445_21959__$1);
var G__21978 = null;
var G__21979 = (0);
var G__21980 = (0);
seq__21445_21945 = G__21977;
chunk__21446_21946 = G__21978;
count__21447_21947 = G__21979;
i__21448_21948 = G__21980;
continue;
}
} else {
}
}
break;
}


var G__21981 = seq__21399_21938;
var G__21982 = chunk__21400_21939;
var G__21983 = count__21401_21940;
var G__21984 = (i__21402_21941 + (1));
seq__21399_21938 = G__21981;
chunk__21400_21939 = G__21982;
count__21401_21940 = G__21983;
i__21402_21941 = G__21984;
continue;
} else {
var temp__5735__auto___21985__$1 = cljs.core.seq(seq__21399_21938);
if(temp__5735__auto___21985__$1){
var seq__21399_21986__$1 = temp__5735__auto___21985__$1;
if(cljs.core.chunked_seq_QMARK_(seq__21399_21986__$1)){
var c__4609__auto___21987 = cljs.core.chunk_first(seq__21399_21986__$1);
var G__21988 = cljs.core.chunk_rest(seq__21399_21986__$1);
var G__21989 = c__4609__auto___21987;
var G__21990 = cljs.core.count(c__4609__auto___21987);
var G__21991 = (0);
seq__21399_21938 = G__21988;
chunk__21400_21939 = G__21989;
count__21401_21940 = G__21990;
i__21402_21941 = G__21991;
continue;
} else {
var vec__21473_21992 = cljs.core.first(seq__21399_21986__$1);
var column_21993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21473_21992,(0),null);
var column_info_21994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21473_21992,(1),null);
var seq__21477_21995 = cljs.core.seq(column_info_21994);
var chunk__21478_21996 = null;
var count__21479_21997 = (0);
var i__21480_21998 = (0);
while(true){
if((i__21480_21998 < count__21479_21997)){
var map__21494_21999 = chunk__21478_21996.cljs$core$IIndexed$_nth$arity$2(null,i__21480_21998);
var map__21494_22000__$1 = (((((!((map__21494_21999 == null))))?(((((map__21494_21999.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21494_21999.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21494_21999):map__21494_21999);
var gline_22001 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21494_22000__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_22002 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21494_22000__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_22003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21494_22000__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_22001], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21477_21995,chunk__21478_21996,count__21479_21997,i__21480_21998,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21494_21999,map__21494_22000__$1,gline_22001,gcol_22002,name_22003,vec__21473_21992,column_21993,column_info_21994,seq__21399_21986__$1,temp__5735__auto___21985__$1,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_22002], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21936,new cljs.core.Keyword(null,"col","col",-1959363084),column_21993,new cljs.core.Keyword(null,"name","name",1843675177),name_22003], null));
});})(seq__21477_21995,chunk__21478_21996,count__21479_21997,i__21480_21998,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21494_21999,map__21494_22000__$1,gline_22001,gcol_22002,name_22003,vec__21473_21992,column_21993,column_info_21994,seq__21399_21986__$1,temp__5735__auto___21985__$1,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted))
,cljs.core.sorted_map()));


var G__22009 = seq__21477_21995;
var G__22010 = chunk__21478_21996;
var G__22011 = count__21479_21997;
var G__22012 = (i__21480_21998 + (1));
seq__21477_21995 = G__22009;
chunk__21478_21996 = G__22010;
count__21479_21997 = G__22011;
i__21480_21998 = G__22012;
continue;
} else {
var temp__5735__auto___22013__$2 = cljs.core.seq(seq__21477_21995);
if(temp__5735__auto___22013__$2){
var seq__21477_22014__$1 = temp__5735__auto___22013__$2;
if(cljs.core.chunked_seq_QMARK_(seq__21477_22014__$1)){
var c__4609__auto___22015 = cljs.core.chunk_first(seq__21477_22014__$1);
var G__22016 = cljs.core.chunk_rest(seq__21477_22014__$1);
var G__22017 = c__4609__auto___22015;
var G__22018 = cljs.core.count(c__4609__auto___22015);
var G__22019 = (0);
seq__21477_21995 = G__22016;
chunk__21478_21996 = G__22017;
count__21479_21997 = G__22018;
i__21480_21998 = G__22019;
continue;
} else {
var map__21496_22020 = cljs.core.first(seq__21477_22014__$1);
var map__21496_22021__$1 = (((((!((map__21496_22020 == null))))?(((((map__21496_22020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21496_22020.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21496_22020):map__21496_22020);
var gline_22022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21496_22021__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_22023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21496_22021__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_22024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21496_22021__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_22022], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__21477_21995,chunk__21478_21996,count__21479_21997,i__21480_21998,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21496_22020,map__21496_22021__$1,gline_22022,gcol_22023,name_22024,seq__21477_22014__$1,temp__5735__auto___22013__$2,vec__21473_21992,column_21993,column_info_21994,seq__21399_21986__$1,temp__5735__auto___21985__$1,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_22023], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_21936,new cljs.core.Keyword(null,"col","col",-1959363084),column_21993,new cljs.core.Keyword(null,"name","name",1843675177),name_22024], null));
});})(seq__21477_21995,chunk__21478_21996,count__21479_21997,i__21480_21998,seq__21399_21938,chunk__21400_21939,count__21401_21940,i__21402_21941,seq__21140_21820,chunk__21141_21821,count__21142_21822,i__21143_21823,map__21496_22020,map__21496_22021__$1,gline_22022,gcol_22023,name_22024,seq__21477_22014__$1,temp__5735__auto___22013__$2,vec__21473_21992,column_21993,column_info_21994,seq__21399_21986__$1,temp__5735__auto___21985__$1,vec__21396_21935,line_21936,columns_21937,seq__21140_21929__$1,temp__5735__auto___21928,inverted))
,cljs.core.sorted_map()));


var G__22027 = cljs.core.next(seq__21477_22014__$1);
var G__22028 = null;
var G__22029 = (0);
var G__22030 = (0);
seq__21477_21995 = G__22027;
chunk__21478_21996 = G__22028;
count__21479_21997 = G__22029;
i__21480_21998 = G__22030;
continue;
}
} else {
}
}
break;
}


var G__22031 = cljs.core.next(seq__21399_21986__$1);
var G__22032 = null;
var G__22033 = (0);
var G__22034 = (0);
seq__21399_21938 = G__22031;
chunk__21400_21939 = G__22032;
count__21401_21940 = G__22033;
i__21402_21941 = G__22034;
continue;
}
} else {
}
}
break;
}


var G__22037 = cljs.core.next(seq__21140_21929__$1);
var G__22038 = null;
var G__22039 = (0);
var G__22040 = (0);
seq__21140_21820 = G__22037;
chunk__21141_21821 = G__22038;
count__21142_21822 = G__22039;
i__21143_21823 = G__22040;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
