(ns goldly.sci.sci-types
  (:require
   [taoensso.timbre :as timbre :refer-macros [debugf info error]]

   [sci.impl.vars]
   [sci.impl.vars :refer [SciNamespace]]
   [picasso.protocols :refer [Renderable render]]
   [picasso.render.span :refer [span-render]]))

(extend-type sci.impl.vars/SciVar
  Renderable
  (render [self]
    (span-render self "clj-symbol")))

(extend-type sci.impl.vars.SciNamespace
  Renderable
  (render [self]
    ;(error "sci ns: " (pr-str self))
    (span-render (.toString self) "clj-namespace")))

