(ns goldly.app
  (:require
   [taoensso.timbre :as timbre :refer-macros [tracef debugf infof warnf errorf info]]
   [webly.web.app]
   [webly.config :refer [webly-config]]
   [goldly.web.ws :refer [start-router!]]
   [goldly.web.views] ; side-effects
   [goldly.puppet.loader] ; side-effects
   [goldly.events] ; side-effects
   [goldly.puppet.subs] ; side-effects
   [goldly.puppet.db] ; side-effects
   [goldly.web.routes :refer [goldly-routes-backend]]

   ; dependencies 
   [pinkie.default-setup] ; side-effecs pinkie
   ;[picasso.default-config] ; side-efects picasso
   [pinkgorilla.ui.default-renderer] ; side-effects gorilla-ui 
   ))

(defn ^:export start []
  (swap! webly-config assoc :timbre-loglevel :info)
  (info "goldly starting ..")
  (webly.web.app/start goldly-routes-backend)
  (webly.web.app/mount-app)
  (start-router!))

;(start)